/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          file_reader.cpp  -  description
                             -------------------
    begin                : Tue Jan 23 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "file_reader.h"

File_Reader::File_Reader(){

	reader_in_use=false;
	perform_endian_swap=false;
}

File_Reader::~File_Reader(){
}


void File_Reader::check_for_errors() {

	if ( !feof(f) ) {

		error_ocurred=true;
		error_type=ferror(f);
	}
}

int File_Reader::open(const char *p_filename) {


	if ( reader_in_use ) return FUNCTION_FAILED;

	f=fopen(p_filename,"rb");


	if (f==NULL) return FUNCTION_FAILED;
	else {
                error_ocurred=false;
         	reader_in_use=true;
		return FUNCTION_SUCCESS;

	}
}


void File_Reader::close() {

	if ( !reader_in_use ) return;

        reader_in_use=false;

	fclose(f);
}

void File_Reader::seek(Uint32 p_position) {

	if ( fseek(f,p_position,SEEK_SET) ) check_for_errors();
}

bool File_Reader::eof_reached() {

	return feof(f);

}

bool File_Reader::error_loading() {

	return error_ocurred;

}

Uint8 File_Reader::get_byte() {

	Uint8 p_dest;

	if ( fread(&p_dest,1,1,f)==0 ) check_for_errors();

	return p_dest;
}

void File_Reader::get_byte_array(Uint8 *p_dest,int p_elements) {

	if ( fread(p_dest,p_elements,1,f) ==0/*< p_elements*/ ) check_for_errors();
}


void File_Reader::get_word_array(Uint16 *p_dest,int p_elements) {

	for (int i=0;i<p_elements;i++)
		*p_dest++ = get_word();
}


Uint16 File_Reader::get_word() {

	Uint16 p_dest;

	Uint8 aux_byte1,aux_byte2;

	aux_byte1=get_byte();
	aux_byte2=get_byte();

	endian_swap(aux_byte1,aux_byte2);

	p_dest=aux_byte2;
	p_dest<<=8;
	p_dest|=aux_byte1;

	return p_dest;

}

Uint32 File_Reader::get_dword() {

	Uint16 aux_word1,aux_word2;
	Uint32 p_dest;

	aux_word1=get_word();
	aux_word2=get_word();

	endian_swap(aux_word1,aux_word2);

	p_dest=aux_word2;
	p_dest<<=16;
	p_dest|=aux_word1;

	return p_dest;
}
