#!/bin/sh
# CVE-2011-0046
set -e

echo "> $0 $*"

cd "$1" && patch -p1 < "$0"

exit 0

Description: CVE-2011-0046 Voting lacks CSRF protection
Origin: http://bzr.mozilla.org/bugzilla/3.6/revision/7225
Bug: https://bugzilla.mozilla.org/show_bug.cgi?id=621105
Bug-Debian: http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=611176

--- a/template/en/default/bug/votes/delete-all.html.tmpl	2007-08-20 23:24:38 +0000
+++ b/template/en/default/bug/votes/delete-all.html.tmpl	2011-01-24 19:22:37 +0000
@@ -35,6 +35,7 @@
 
 <form action="votes.cgi" method="post">
     <input type="hidden" name="action" value="vote">
+  <input type="hidden" name="token" value="[% issue_hash_token(['vote']) FILTER html %]"> 
   <p>
     <input type="radio" name="delete_all_votes" value="1">
     Yes, delete all my votes

--- a/template/en/default/bug/votes/list-for-user.html.tmpl	2009-08-06 15:02:47 +0000
+++ b/template/en/default/bug/votes/list-for-user.html.tmpl	2011-01-24 19:22:37 +0000
@@ -74,6 +74,7 @@
 [% IF products.size %]
   <form name="voting_form" method="post" action="votes.cgi">
     <input type="hidden" name="action" value="vote">
+    <input type="hidden" name="token" value="[% issue_hash_token(['vote']) FILTER html %]">
     <table cellspacing="4">
       <tr>
         <td></td>

--- a/votes.cgi	2010-04-07 03:28:35 +0000
+++ b/votes.cgi	2011-01-24 19:22:37 +0000
@@ -35,6 +35,7 @@
 use Bugzilla::BugMail;
 use Bugzilla::User;
 use Bugzilla::Product;
+use Bugzilla::Token;
 
 use List::Util qw(min);
 
@@ -264,6 +265,9 @@
         || ThrowUserError("votes_must_be_nonnegative");
     }
 
+    my $token = $cgi->param('token');
+    check_hash_token($token, ['vote']);
+
     ############################################################################
     # End Data/Security Validation
     ############################################################################

