#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
# 
# Test template expansion.
#
# $Id: lookup.py,v 1.12 2003/01/24 11:34:31 andrewm Exp $

import unittest
import albatross
import albatross_test

class TemplateTestCase(albatross_test.AlbatrossTestCase):
    template_dir = "lookup"
    lookup_cases = (
        (0,	"Zero\n"),
        (1,	"One\n"),
        (2,	"Two\n"),
        (3,	"Many\n"),
        (4,	"Many\n"),
        (-1,	"Many\n"),
        (20,	"Many\n")
    )

    def html_test(self, template, value, expect):
        self.ctx.locals.i = value
        albatross_test.AlbatrossTestCase.html_test(self, template, expect)


class FileTemplateCase(TemplateTestCase):
    def check_enum(self):
        for (x, result) in self.lookup_cases:
            self.html_test("lookup.html", x, result)

    def check_no_default(self):
        no_default_cases = (
            (0,	"Zero\n"),
            (1,	"One\n"),
            (2,	"\n"),
            (20, "\n"),
        )
        for (x, result) in no_default_cases:
            self.html_test("no-default.html", x, result)

    def check_no_close(self):
        self.assertRaises(albatross.ApplicationError, self.html_test, "no-close.html", 0, "(none)")

# This differs from the previous class because it generates the html output by
# feeding in a string to the templating code.

class StringTemplateCase(TemplateTestCase):
    template_string = '''
<al-lookup name="xlat">
 <al-item expr="0">Zero</al-item>
 <al-item expr="1">One</al-item>
 <al-item expr="2">Two</al-item>
 Many</al-lookup>
<al-value expr="i" lookup="xlat" whitespace>
'''
    # this overrides the albatross_test.Albatross.gen_html method.
    def gen_html(self, ctx, template_string):
        ctx.push_content_trap()
        tmpl = albatross.template.Template(ctx, '<ether>', template_string)
        tmpl.to_html(ctx)
        return ctx.pop_content_trap()

    def check_enum(self):
        for (x, result) in self.lookup_cases:
            self.html_test(self.template_string, x, result)


class TemplateSuite(unittest.TestSuite):
    test_list = (
        "check_enum",
        "check_no_default",
        "check_no_close",
    )
    def __init__(self):
        unittest.TestSuite.__init__(self, map(FileTemplateCase, self.test_list))
        self.addTest(StringTemplateCase("check_enum"))

def suite():
    return TemplateSuite()

if __name__ == '__main__':
    unittest.main(defaultTest='suite')


