<?php
/*  
 * Analysis Console for Intrusion Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2001 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose: routines to manipulate shared state (session
 *          information)   
 *
 */

include_once("acid_state_common.inc");

class CriteriaState
{
  var $valid_criteria_list = array("layer4",
                                  "ag",
                                  "sig",
                                  "sig_class",
                                  "sensor",
                                  "time",
                                  "ip_addr",
                                  "ip_field",
                                  "tcp_port",
                                  "tcp_flags",
                                  "tcp_field",
                                  "udp_port",
                                  "udp_field",
                                  "icmp_field",
                                  "data");

  var $clear_criteria_name;
  var $clear_criteria_element;
  var $clear_url;
  var $clear_url_params;

  function CriteriaState($url, $params = "")
  {
    $this->clear_url = $url;
    $this->clear_url_params = $params;
  }

  function InitState()
  {
    RegisterGlobalState();
    InitGlobalState();
  }

  function ReadState()
  {
    GLOBAL $time, $time_cnt, $sig, $sig_type, 
         $sensor, $ag, $sig_class,
         $ip_addr, $ip_addr_cnt, $ip_field, $ip_field_cnt,
         $tcp_port, $tcp_port_cnt, $tcp_flags, $tcp_field, $tcp_field_cnt,
         $udp_port, $udp_port_cnt, $udp_field, $udp_field_cnt,
         $icmp_field, $icmp_field_cnt,
         $have_meta, $have_ip, $have_tcp, $have_udp, $have_icmp, $have_data,
         $layer4, $data, $data_cnt, $data_encode, $QUERY_STRING, $PHP_SELF, $debug_mode,
         $back_list, $back_list_cnt;

    RegisterGlobalState();
    ImportGlobalState();
    
    $this->clear_criteria_name = ImportHTTPVar("clear_criteria");
    $this->clear_criteria_element = ImportHTTPVar("clear_criteria_element");

    if ( $this->clear_criteria_name != "" )
       $this->ClearCriteriaStateElement($this->clear_criteria_name,
                                        $this->clear_criteria_element);
    if ( $GLOBALS['maintain_history'] == 1 )
       PreserveHistory();
  }

  function GetBackLink()
  {
    return PrintBackButton();
  }

  function GetClearCriteriaString($name, $element = "")
  {
    return '&nbsp;&nbsp;<A HREF="'.$this->clear_url.'?clear_criteria='.$name.
           '&clear_criteria_element='.$element.$this->clear_url_params.'">...clear...</A>';
  }

  function ClearCriteriaStateElement($name, $element)
  {
    GLOBAL $time, $time_cnt, $sig, $sig_type, 
         $sensor, $ag, $sig_class,
         $ip_addr, $ip_addr_cnt, $ip_field, $ip_field_cnt,
         $tcp_port, $tcp_port_cnt, $tcp_flags, $tcp_field, $tcp_field_cnt,
         $udp_port, $udp_port_cnt, $udp_field, $udp_field_cnt,
         $icmp_field, $icmp_field_cnt,
         $have_meta, $have_ip, $have_tcp, $have_udp, $have_icmp, $have_data,
         $layer4, $data, $data_cnt, $data_encode; 

    if ( in_array($name, $this->valid_criteria_list) )
    {
       ErrorMessage("Removing '$name' from criteria");
       
       switch($name)
       {
          case "sensor":
            $sensor = "";
            break;
          case "ag":
            $ag = "";
            break;
          case "sig":
            $sig = "";
            break;
          case "sig_class":
            $sig_class = "";
            break;
          case "time":
            unset($time);
            $time_cnt = 0;
            break;
          case "ip_addr":
            unset($ip_addr);
            $ip_addr_cnt = 0;
            break;
          case "ip_field":
            unset($ip_field);
            $ip_field_cnt = 0;
            break;
          case "tcp_port":
            unset($tcp_port);
            $tcp_port_cnt = 0;
            break;
          case "tcp_flags":
            unset($tcp_flags);
            $tcp_flags_cnt = 0;
            break;
          case "tcp_field":
            unset($tcp_field);
            $tcp_field_cnt = 0;
            break;
          case "udp_port":
            unset($udp_port);
            $udp_port_cnt = 0;
            break;
          case "udp_field":
            unset($udp_field);
            $udp_field_cnt = 0;
            break;
          case "icmp_field":
            unset($icmp_field);
            $icmp_field_cnt = 0;
            break;
          case "data":
            unset($data);
            $data_cnt = 0;
            break;
       }
    }
    else
      ErrorMessage("Invalid criteria element");
  }
}

function PreserveHistory()
{
  GLOBAL $back_list_cnt, $back_list, $PHP_SELF, $QUERY_STRING, $debug_mode;
 
  /* If the BACK button was clicked, extract the old criteria */
  if ( ImportHTTPVar("back") == 1 )
  {
      --$back_list_cnt;
      if ( $back_list_cnt >= 0 )
      {
        if ( $debug_mode > 0 )
        {
          $tmp_num = $back_list_cnt + 1;
          ErrorMessage("Back (from ".$back_list[$tmp_num]["PHP_SELF"].")");
          ErrorMessage("Import (historical) state from #".$back_list_cnt);
        }

        session_decode($back_list[$back_list_cnt]["session"]);
        $back_list = & $GLOBALS['back_list'];
      }
  }

  /* Save criteria of current page into history
   * Note: the $back_list need not be saved 
   */
  session_unregister('back_list');
  $full_session = session_encode();
  session_register('back_list');
  $back_list_cnt = & $GLOBALS['back_list_cnt'];

  ++$back_list_cnt;
  $back_list[$back_list_cnt] = array ("PHP_SELF" => $PHP_SELF,
                                      "QUERY_STRING" => $QUERY_STRING,
                                      "session" => $full_session );

  if ( $debug_mode > 0 ) 
  {
     echo "History depth = $back_list_cnt<BR>";
     /*
     ErrorMessage("Saved criteria for ".$back_list[$back_list_cnt]["PHP_SELF"]);
     for ( $i = 1; $i <= $back_list_cnt; $i++ )
         echo $back_list[$i]["PHP_SELF"]." &nbsp;&nbsp > &nbsp;&nbsp; ";
     echo "<BR>";
     */
  }      
 
  if ( $debug_mode > 1 ) 
  {
    echo "Back List (Cnt = $back_list_cnt) <PRE>";
    print_r($back_list);
    echo "</PRE>";
  }
}

function PrintBackButton()
{
   GLOBAL $back_list, $back_list_cnt;

   if ( $GLOBALS['maintain_history'] == 0 )
      return "<FONT>Back</FONT>";

   $back_list = & $GLOBALS['back_list'];
   $back_list_cnt = & $GLOBALS['back_list_cnt'];

   $criteria_num = $back_list_cnt - 1;
   
   if ( isset($back_list[$criteria_num]["PHP_SELF"]) )

     return "<FONT><A HREF=\"".$back_list[$criteria_num]["PHP_SELF"].
            "?back=1&".
            $back_list[$criteria_num]["QUERY_STRING"]."\">Back</A></FONT>";
   else
     return "<FONT>Back</FONT>";
}
?>
