<?php
/*  
 * Analysis Console for Incident Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose:   
 *
 */

include_once("acid_constants.inc");

function SensorCnt($db, $join = "", $where = "")
{
   if ( $join == "" && $where == "" )
      $result = $db->acidExecute("SELECT count(*) FROM sensor");
   else
      $result = $db->acidExecute("SELECT COUNT(DISTINCT acid_event.sid) FROM acid_event $join $where");
   $myrow = $result->acidFetchRow();
   $num = $myrow[0];
   $result->acidFreeRows();

   return $num;
}

function EventCnt($db, $join = "", $where = "")
{
   if ( $join == "" && $where == "" )
      $result = $db->acidExecute("SELECT count(*) FROM acid_event");
   else
      $result = $db->acidExecute("SELECT COUNT(acid_event.sid) FROM acid_event $join $where");  

   $myrow = $result->acidFetchRow();
   $num = $myrow[0];
   $result->acidFreeRows();

   return $num;
}

/*
 * Takes: Numeric sensor ID from the Sensor table (SID), and 
 *	  database connection.
 * 
 * Returns: The number of unique alert descriptions for the 
 * 	    given sensor ID. 
 *
 */
function UniqueCntBySensor($sensorID, $db)
{

  /* Calculate the Unique Alerts */
  $query = "SELECT COUNT(DISTINCT signature) FROM acid_event WHERE sid = " . $sensorID . ";";
  $result = $db->acidExecute($query);

  if ( $result ) 
  {
     $row = $result->acidFetchRow();
     $num = $row[0];
     $result->acidFreeRows();
  }
  else
     $num = 0;

  return $num;
}

/*
 * Takes: Numeric sensor ID from the Sensor table (SID), and 
 *        database connection.
 * 
 * Returns: The total number of alerts for the given sensor ID
 */ 
function EventCntBySensor($sensorID, $db)
{
   $query = "SELECT count(*) FROM acid_event where sid = " .$sensorID. ";";

   $result = $db->acidExecute($query);
   $myrow = $result->acidFetchRow();
   $num = $myrow[0];
   $result->acidFreeRows();

   return $num;
}

function MinDateBySensor($sensorID, $db)
{
   $query = "SELECT min(timestamp) FROM acid_event WHERE sid=" . $sensorID . ";";

   $result = $db->acidExecute($query);
   $myrow = $result->acidFetchRow();
   $num = $myrow[0];
   $result->acidFreeRows();

   return $num;
}


function MaxDateBySensor($sensorID, $db)
{
   $query = "SELECT max(timestamp) FROM acid_event WHERE sid=" . $sensorID . ";";

   $result = $db->acidExecute($query);
   $myrow = $result->acidFetchRow();
   $num = $myrow[0];
   $result->acidFreeRows();

   return $num;
}

function UniqueDestAddrCntBySensor( $sensorID, $db )
{
   $query = "SELECT COUNT(DISTINCT ip_dst) from acid_event WHERE sid=" . $sensorID . ";";

   $result = $db->acidExecute($query);
   $row = $result->acidFetchRow();
   $num = $row[0];
   $result->acidFreeRows();

   return $num;
}

function UniqueSrcAddrCntBySensor( $sensorID, $db )
{
   $query = "SELECT COUNT(DISTINCT ip_src) from acid_event WHERE sid=" . $sensorID . ";";

   $result = $db->acidExecute($query);
   $row = $result->acidFetchRow();
   $num = $row[0];
   $result->acidFreeRows();

   return $num;
}

function TCPPktCnt($db)
{
   $result = $db->acidExecute("SELECT count(*) FROM tcphdr;");
   $myrow = $result->acidFetchRow();
   $num = $myrow[0];
   $result->acidFreeRows();

   return $num;
}

function UDPPktCnt($db)
{
   $result = $db->acidExecute("SELECT count(*) FROM udphdr;");
   $myrow = $result->acidFetchRow();
   $num = $myrow[0];
   $result->acidFreeRows();

   return $num;
}

function ICMPPktCnt($db)
{
   $result = $db->acidExecute("SELECT count(*) FROM icmphdr;");
   $myrow = $result->acidFetchRow();
   $num = $myrow[0];
   $result->acidFreeRows();

   return $num;
}

function PortscanPktCnt($db)
{
  GLOBAL $DBtype;

  if ( $db->acidGetDBVersion() >= 100 )
      $result = $db->acidExecute("SELECT count(event.sid) FROM event ".
                                 "LEFT JOIN signature ON event.signature=signature.sig_id ".
                                 "WHERE sig_name LIKE 'spp_portscan%'");
  else
      $result = $db->acidExecute("SELECT count(event.sid) FROM event ".
                                 "WHERE signature LIKE 'spp_portscan%'");
  //$result = $db->acidExecute("SELECT count(sid) FROM acid_event ".
  //                           "WHERE sig_name LIKE 'spp_portscan%'");  

   $myrow = $result->acidFetchRow();
   $num = $myrow[0];
   $result->acidFreeRows();

   return $num;
}

function UniqueSrcIPCnt($db, $join = "", $where = "")
{
   if ( $join == "" && $where == "" )
     $result = $db->acidExecute("SELECT COUNT(DISTINCT acid_event.ip_src) FROM acid_event");
   else
     $result = $db->acidExecute("SELECT COUNT(DISTINCT acid_event.ip_src) FROM acid_event $join ".
                                "WHERE acid_event.sid > 0 $where");

   $row = $result->acidFetchRow();
   $num = $row[0];
   $result->acidFreeRows();

   return $num;
}

function UniqueDstIPCnt($db, $join = "", $where = "")
{
   if ( $join == "" && $where == "" )
     $result = $db->acidExecute("SELECT COUNT(DISTINCT acid_event.ip_dst) FROM acid_event");
   else
     $result = $db->acidExecute("SELECT COUNT(DISTINCT acid_event.ip_dst) FROM acid_event $join ".
                                "WHERE acid_event.sid > 0 $where");

   $row = $result->acidFetchRow();
   $num = $row[0];
   $result->acidFreeRows();

   return $num;
}

function UniqueIPCnt($db, $join = "", $where = "")
{
   $result = $db->acidExecute("SELECT COUNT(DISTINCT acid_event.ip_src), ".
                              "COUNT(DISTINCT acid_event.ip_dst) FROM acid_event $join $where");

   $row = $result->acidFetchRow();
   $num1 = $row[0];
   $num2 = $row[1];
   $result->acidFreeRows();

   return array ( $num1, $num2 );
}

function StartStopTime(&$start_time, &$stop_time, $db)
{
   $result = $db->acidExecute("SELECT min(timestamp), max(timestamp) FROM acid_event");
   $myrow = $result->acidFetchRow();
   $start_time = $myrow[0];
   $stop_time = $myrow[1];
   $result->acidFreeRows();
}

function UniqueAlertCnt($db, $join = "", $where = "")
{
   //if ( $db->acidGetDBVersion() >= 100  )
   //   $result = $db->acidExecute("SELECT COUNT(*) FROM signature");
   //else
   $result = $db->acidExecute("SELECT COUNT(DISTINCT acid_event.signature) FROM acid_event $join ".
                                 "$where");    

   $row = $result->acidFetchRow();
   $num = $row[0];
   $result->acidFreeRows();

   return $num;
}

function UniquePortCnt($db, $join = "", $where = "")
{
   if ( $join == "" && $where == "")
     $result = $db->acidExecute("SELECT COUNT(DISTINCT layer4_sport),  ".
                                "COUNT(DISTINCT layer4_dport) FROM acid_event");
   else
     $result = $db->acidExecute("SELECT COUNT(DISTINCT acid_event.layer4_sport),  ".
                                "COUNT(DISTINCT acid_event.layer4_dport) FROM acid_event $join ".
                                "$where");

   $row = $result->acidFetchRow();
   $result->acidFreeRows();

   return array( $row[0], $row[1]);
}

function UniqueTCPPortCnt($db, $join = "", $where = "")
{
   if ( $join == "" && $where == "")
     $result = $db->acidExecute("SELECT COUNT(DISTINCT acid_event.layer4_sport),  ".
                              "COUNT(DISTINCT acid_event.layer4_dport) FROM acid_event ".
                              "WHERE ip_proto=".TCP);
   else
     $result = $db->acidExecute("SELECT COUNT(DISTINCT acid_event.layer4_sport),  ".
                              "COUNT(DISTINCT acid_event.layer4_dport) FROM acid_event $join".
                              " $where AND ip_proto=".TCP);

   $row = $result->acidFetchRow();
   $result->acidFreeRows();

   return array( $row[0], $row[1]);
}

function UniqueUDPPortCnt($db, $join = "", $where = "")
{
   if ( $join == "" && $where == "")
     $result = $db->acidExecute("SELECT COUNT(DISTINCT acid_event.layer4_sport),  ".
                              "COUNT(DISTINCT acid_event.layer4_dport) FROM acid_event ".
                              "WHERE ip_proto=".UDP);
   else
     $result = $db->acidExecute("SELECT COUNT(DISTINCT acid_event.layer4_sport),  ".
                              "COUNT(DISTINCT acid_event.layer4_dport) FROM acid_event $join".
                              " $where AND ip_proto=".UDP);

   $row = $result->acidFetchRow();
   $result->acidFreeRows();

   return array( $row[0], $row[1]);
}

function UniqueLinkCnt($db, $join = "", $where = "")
{
   if ( $db->DB_type == "mysql" )
   {
     if ( $join == "" && $where == "")
       $result = $db->acidExecute("SELECT COUNT(DISTINCT acid_event.ip_src, acid_event.ip_dst, acid_event.ip_proto) FROM acid_event");
     else
       $result = $db->acidExecute("SELECT COUNT(DISTINCT acid_event.ip_src, acid_event.ip_dst, acid_event.ip_proto) FROM acid_event $join $where");

     $row = $result->acidFetchRow();
     $result->acidFreeRows();
   }
   else
   {
     if ( $join == "" && $where == "")
       $result = $db->acidExecute("SELECT DISTINCT acid_event.ip_src, acid_event.ip_dst, acid_event.ip_proto FROM acid_event");
     else
       $result = $db->acidExecute("SELECT DISTINCT acid_event.ip_src, acid_event.ip_dst, acid_event.ip_proto FROM acid_event $join $where");
   
     $row[0] = $result->acidRecordCount();
     $result->acidFreeRows();     
   }

   return $row[0];  
}

function PrintGeneralStats($db, $compact, $show_stats, $join = "", $where = "", $show_total_events = false)
{
   if ( $show_stats == 1 )
   {
     $sensor_cnt = SensorCnt($db, $join, $where);
     $unique_alert_cnt = UniqueAlertCnt($db, $join, $where);
     $event_cnt = EventCnt($db, $join, $where);
     $unique_ip_cnt = UniqueIPCnt($db, $join, $where);
     $unique_links_cnt = UniqueLinkCnt($db, $join, $where);
     $unique_port_cnt = UniquePortCnt($db, $join, $where);
     $unique_tcp_port_cnt = UniqueTCPPortCnt($db, $join, $where);
     $unique_udp_port_cnt = UniqueUDPPortCnt($db, $join, $where);
   }

   if ( $db->acidGetDBversion() >= 103 )
   {
      $result = $db->acidExecute("SELECT count(DISTINCT(sig_class_id)) FROM acid_event");
      $myrow = $result->acidFetchRow();
      $class_cnt = $myrow[0];
      $result->acidFreeRows();

      $class_cnt_info[0] = " &nbsp;&nbsp; ( &nbsp;&nbsp;";
      $class_cnt_info[1] = "<A HREF=\"acid_stat_class.php?sort_order=class_a\">";
      $class_cnt_info[2] = "</A> <B>categories</B> &nbsp;&nbsp;)";
   }

   $sensor_cnt_info[0] = "<B>Sensors:</B>\n";
   $sensor_cnt_info[1] = "<A HREF=\"acid_stat_sensor.php\">";
   $sensor_cnt_info[2] = "</A>";

   $unique_alert_cnt_info[0] = "<B>Unique Alerts:</B>\n";
   $unique_alert_cnt_info[1] = "<A HREF=\"acid_stat_alerts.php\">"; 
   $unique_alert_cnt_info[2] = "</A>";

   $event_cnt_info[0] = "<B>Total Number of Alerts:</B>\n";
   $event_cnt_info[1] = '<A HREF="acid_qry_main.php?&num_result_rows=-1'.
                        '&submit=Query+DB&current_view=-1">';
   $event_cnt_info[2] = "</A>";

   $unique_src_ip_cnt_info[0] = "Source IP addresses:";
   $unique_src_ip_cnt_info[1] = " ".BuildUniqueAddressLink(1);
   $unique_src_ip_cnt_info[2] = "</A>";
   $unique_dst_ip_cnt_info[0] = "Dest. IP addresses:";
   $unique_dst_ip_cnt_info[1] = " ".BuildUniqueAddressLink(2);
   $unique_dst_ip_cnt_info[2] = "</A>";

   $unique_links_info[0] = "Unique IP links";
   $unique_links_info[1] = " <A HREF=\"acid_stat_iplink.php\">";
   $unique_links_info[2] = "</A>";

   $unique_src_port_cnt_info[0] = "Source Ports: "; 
   $unique_src_port_cnt_info[1] = " <A HREF=\"acid_stat_ports.php?port_type=1&proto=-1\">";
   $unique_src_port_cnt_info[2] = "</A>";
   $unique_dst_port_cnt_info[0] = "Dest. Ports: "; 
   $unique_dst_port_cnt_info[1] = " <A HREF=\"acid_stat_ports.php?port_type=2&proto=-1\">";
   $unique_dst_port_cnt_info[2] = "</A>";

   $unique_tcp_src_port_cnt_info[0] = "TCP (";
   $unique_tcp_src_port_cnt_info[1] = " <A HREF=\"acid_stat_ports.php?port_type=1&proto=".TCP."\">";
   $unique_tcp_src_port_cnt_info[2] = "</A>)";
   $unique_tcp_dst_port_cnt_info[0] = "TCP (";
   $unique_tcp_dst_port_cnt_info[1] = " <A HREF=\"acid_stat_ports.php?port_type=2&proto=".TCP."\">";
   $unique_tcp_dst_port_cnt_info[2] = "</A>)";

   $unique_udp_src_port_cnt_info[0] = "UDP (";
   $unique_udp_src_port_cnt_info[1] = " <A HREF=\"acid_stat_ports.php?port_type=1&proto=".UDP."\">";
   $unique_udp_src_port_cnt_info[2] = "</A>)";
   $unique_udp_dst_port_cnt_info[0] = "UDP (";
   $unique_udp_dst_port_cnt_info[1] = " <A HREF=\"acid_stat_ports.php?port_type=2&proto=".UDP."\">";
   $unique_udp_dst_port_cnt_info[2] = "</A>)";


   if ( $show_stats == 1 )
   {
   echo $sensor_cnt_info[0].
        $sensor_cnt_info[1].
        $sensor_cnt.
        $sensor_cnt_info[2]."\n<BR>";

   echo $unique_alert_cnt_info[0].
        $unique_alert_cnt_info[1].
        $unique_alert_cnt.
        $unique_alert_cnt_info[2];

   if ( $db->acidGetDBversion() >= 103 )
      echo $class_cnt_info[0].
           $class_cnt_info[1].
           $class_cnt.
           $class_cnt_info[2];

   echo "<BR>";

   echo $event_cnt_info[0].
        $event_cnt_info[1].
        $event_cnt.
        $event_cnt_info[2];

   echo "<UL>";

   echo "<LI>".
        $unique_src_ip_cnt_info[0].
        $unique_src_ip_cnt_info[1]. 
        $unique_ip_cnt[0].
        $unique_src_ip_cnt_info[2];

   echo "<LI>".
        $unique_dst_ip_cnt_info[0].
        $unique_dst_ip_cnt_info[1]. 
        $unique_ip_cnt[1].
        $unique_dst_ip_cnt_info[2];

   echo "<LI>".
        $unique_links_info[0].
        $unique_links_info[1].
        $unique_links_cnt.
        $unique_links_info[2];

   if ( $compact == 0 )
      echo "<P>";

   echo "<LI>".
        $unique_src_port_cnt_info[0].
        $unique_src_port_cnt_info[1]. 
        $unique_port_cnt[0].
        $unique_src_port_cnt_info[2];

   if ( $compact == 0 )
     echo "<UL><LI>";
   else
     echo "&nbsp;&nbsp;--&nbsp;&nbsp;";

   echo $unique_tcp_src_port_cnt_info[0].
        $unique_tcp_src_port_cnt_info[1]. 
        $unique_tcp_port_cnt[0].
        $unique_tcp_src_port_cnt_info[2].
        "&nbsp;&nbsp;".
        $unique_udp_src_port_cnt_info[0].
        $unique_udp_src_port_cnt_info[1]. 
        $unique_udp_port_cnt[0].
        $unique_udp_src_port_cnt_info[2];
   
   if ( $compact == 0 )
     echo "</UL>";

   echo "<LI>".
        $unique_dst_port_cnt_info[0].
        $unique_dst_port_cnt_info[1]. 
        $unique_port_cnt[1].
        $unique_dst_port_cnt_info[2];

   if ( $compact == 0 )
     echo "<UL><LI>";
   else
     echo "&nbsp;&nbsp;--&nbsp;&nbsp;";

   echo $unique_tcp_dst_port_cnt_info[0].
        $unique_tcp_dst_port_cnt_info[1]. 
        $unique_tcp_port_cnt[1].
        $unique_tcp_dst_port_cnt_info[2].
        "&nbsp;&nbsp;".
        $unique_udp_dst_port_cnt_info[0].
        $unique_udp_dst_port_cnt_info[1]. 
        $unique_udp_port_cnt[1].
        $unique_udp_dst_port_cnt_info[2];

   if ( $compact == 0 )
     echo "</UL>";

   echo "</UL>";
   }
   else
   {
      if ( $show_total_events )
      {
         $event_cnt = EventCnt($db, $join, $where);
         echo "<LI>".
               $event_cnt_info[0].
               $event_cnt_info[1].
               $event_cnt.
               $event_cnt_info[2]."<P>";
      }

      echo
           "<LI>".
             $sensor_cnt_info[1]."Sensors".$sensor_cnt_info[2].
           "  <LI>".
             $unique_alert_cnt_info[1]."Unique Alerts".$unique_alert_cnt_info[2];
   
     if ( $db->acidGetDBversion() >= 103 )
        echo "&nbsp;&nbsp;&nbsp;( ".$class_cnt_info[1]."classifications</A> )";
       echo 
           "  <LI>Unique addresses: ".
             $unique_src_ip_cnt_info[1].'source | '.$unique_src_ip_cnt_info[2].
             $unique_dst_ip_cnt_info[1].'destination'.$unique_dst_ip_cnt_info[2].
           "  <LI>".
             $unique_links_info[1].$unique_links_info[0].$unique_links_info[2].
           "  <LI>".
             $unique_src_port_cnt_info[1]."Source ".$unique_src_port_cnt_info[2]."Port: ".
             $unique_tcp_src_port_cnt_info[1]." TCP</A> | ".
             $unique_udp_src_port_cnt_info[1]." UDP</A>".
           "  <LI>".
             $unique_dst_port_cnt_info[1]."Destination ".$unique_dst_port_cnt_info[2]."Port: ".
             $unique_tcp_dst_port_cnt_info[1]." TCP</A> | ".
             $unique_udp_dst_port_cnt_info[1]." UDP</A>";
   }
}

?>
