/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.IOException;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.NodeBase;
import org.apache.crimson.tree.TextNode;
import org.apache.crimson.tree.TreeWalker;
import org.apache.crimson.tree.XmlDocument;
import org.apache.crimson.tree.XmlWriteContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class ParentNode
extends NodeBase {
    private NodeBase[] children;
    private int length;

    ParentNode() {
    }

    public void trimToSize() {
        if (this.length == 0) {
            this.children = null;
        } else if (this.children.length != this.length) {
            NodeBase[] temp = new NodeBase[this.length];
            System.arraycopy(this.children, 0, temp, 0, this.length);
            this.children = temp;
        }
    }

    void reduceWaste() {
        if (this.children == null) {
            return;
        }
        if (this.children.length - this.length > 6) {
            this.trimToSize();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeChildrenXml(XmlWriteContext context) throws IOException {
        if (this.children == null) {
            return;
        }
        int oldIndent = 0;
        boolean preserve = true;
        boolean pureText = true;
        if (this.getNodeType() == 1) {
            preserve = "preserve".equals(this.getInheritedAttribute("xml:space"));
            oldIndent = context.getIndentLevel();
        }
        try {
            if (!preserve) {
                context.setIndentLevel(oldIndent + 2);
            }
            int i = 0;
            while (i < this.length) {
                if (!preserve && this.children[i].getNodeType() != 3) {
                    context.printIndent();
                    pureText = false;
                }
                this.children[i].writeXml(context);
                ++i;
            }
            Object var7_6 = null;
            if (preserve) return;
            context.setIndentLevel(oldIndent);
            if (pureText) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (preserve) throw throwable;
            context.setIndentLevel(oldIndent);
            if (pureText) throw throwable;
            context.printIndent();
            throw throwable;
        }
        context.printIndent();
    }

    abstract void checkChildType(int var1) throws DOMException;

    public final boolean hasChildNodes() {
        return this.length > 0;
    }

    public final Node getFirstChild() {
        if (this.length == 0) {
            return null;
        }
        return this.children[0];
    }

    public final Node getLastChild() {
        if (this.length == 0) {
            return null;
        }
        return this.children[this.length - 1];
    }

    public final int getLength() {
        return this.length;
    }

    public final Node item(int i) {
        if (this.length == 0 || i >= this.length) {
            return null;
        }
        try {
            return this.children[i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    private NodeBase checkDocument(Node newChild) throws DOMException {
        if (newChild == null) {
            throw new DomEx(3);
        }
        if (!(newChild instanceof NodeBase)) {
            throw new DomEx(4);
        }
        Document owner = newChild.getOwnerDocument();
        XmlDocument myOwner = this.ownerDocument;
        NodeBase child = (NodeBase)newChild;
        if (myOwner == null && this instanceof XmlDocument) {
            myOwner = (XmlDocument)this;
        }
        if (owner != null && owner != myOwner) {
            throw new DomEx(4);
        }
        if (owner == null) {
            child.setOwnerDocument(myOwner);
        }
        if (child.hasChildNodes()) {
            Node node;
            int i = 0;
            while ((node = child.item(i)) != null) {
                if (node.getOwnerDocument() == null) {
                    ((NodeBase)node).setOwnerDocument(myOwner);
                } else if (node.getOwnerDocument() != myOwner) {
                    throw new DomEx(4);
                }
                ++i;
            }
        }
        return child;
    }

    private void checkNotAncestor(Node newChild) throws DOMException {
        if (!newChild.hasChildNodes()) {
            return;
        }
        Node ancestor = this;
        while (ancestor != null) {
            if (newChild == ancestor) {
                throw new DomEx(3);
            }
            ancestor = ancestor.getParentNode();
        }
    }

    private void mutated() {
        XmlDocument doc = this.ownerDocument;
        if (doc == null && this instanceof XmlDocument) {
            doc = (XmlDocument)this;
        }
        if (doc != null) {
            ++doc.mutationCount;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void consumeFragment(Node fragment, Node before) throws DOMException {
        Node temp;
        ParentNode frag = (ParentNode)fragment;
        int i = 0;
        while ((temp = frag.item(i)) != null) {
            void var4_5;
            this.checkNotAncestor((Node)var4_5);
            this.checkChildType(var4_5.getNodeType());
            ++i;
        }
        while ((temp = frag.item(0)) != null) {
            this.insertBefore(temp, before);
        }
    }

    public Node appendChild(Node newChild) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        NodeBase child = this.checkDocument(newChild);
        if (newChild.getNodeType() == 11) {
            this.consumeFragment(newChild, null);
            return newChild;
        }
        this.checkNotAncestor(newChild);
        this.checkChildType(child.getNodeType());
        if (this.children == null) {
            this.children = new NodeBase[3];
        } else if (this.children.length == this.length) {
            NodeBase[] temp = new NodeBase[this.length * 2];
            System.arraycopy(this.children, 0, temp, 0, this.length);
            this.children = temp;
        }
        child.setParentNode(this, this.length);
        this.children[this.length++] = child;
        this.mutated();
        return child;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (refChild == null) {
            return this.appendChild(newChild);
        }
        if (this.length == 0) {
            throw new DomEx(8);
        }
        NodeBase child = this.checkDocument(newChild);
        if (newChild.getNodeType() == 11) {
            this.consumeFragment(newChild, refChild);
            return newChild;
        }
        this.checkNotAncestor(newChild);
        this.checkChildType(newChild.getNodeType());
        int i = 0;
        while (i < this.length) {
            if (this.children[i] == newChild) {
                this.removeChild(newChild);
                break;
            }
            ++i;
        }
        if (this.children.length == this.length) {
            NodeBase[] temp = new NodeBase[this.length * 2];
            System.arraycopy(this.children, 0, temp, 0, this.length);
            this.children = temp;
        }
        int i2 = 0;
        while (i2 < this.length) {
            if (this.children[i2] == refChild) {
                child.setParentNode(this, i2);
                System.arraycopy(this.children, i2, this.children, i2 + 1, this.length - i2);
                this.children[i2] = child;
                ++this.length;
                this.mutated();
                return newChild;
            }
            ++i2;
        }
        throw new DomEx(8);
    }

    public Node replaceChild(Node newChild, Node refChild) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (newChild == null || refChild == null) {
            throw new DomEx(3);
        }
        if (this.children == null) {
            throw new DomEx(8);
        }
        NodeBase child = this.checkDocument(newChild);
        if (newChild.getNodeType() == 11) {
            this.consumeFragment(newChild, refChild);
            return this.removeChild(refChild);
        }
        this.checkNotAncestor(newChild);
        this.checkChildType(newChild.getNodeType());
        int i = 0;
        while (i < this.length) {
            if (this.children[i] == newChild) {
                this.removeChild(newChild);
                break;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.length) {
            if (this.children[i2] == refChild) {
                child.setParentNode(this, i2);
                this.children[i2] = child;
                ((NodeBase)refChild).setParentNode(null, -1);
                this.mutated();
                return refChild;
            }
            ++i2;
        }
        throw new DomEx(8);
    }

    public Node removeChild(Node oldChild) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(oldChild instanceof NodeBase)) {
            throw new DomEx(8);
        }
        NodeBase child = (NodeBase)oldChild;
        int i = 0;
        while (i < this.length) {
            if (this.children[i] == child) {
                if (i + 1 != this.length) {
                    System.arraycopy(this.children, i + 1, this.children, i, this.length - 1 - i);
                }
                --this.length;
                this.children[this.length] = null;
                child.setParentNode(null, -1);
                this.mutated();
                return oldChild;
            }
            ++i;
        }
        throw new DomEx(8);
    }

    public NodeList getElementsByTagName(String tagname) {
        if ("*".equals(tagname)) {
            tagname = null;
        }
        return new TagList(tagname);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        if ("*".equals(namespaceURI)) {
            namespaceURI = null;
        }
        if ("*".equals(localName)) {
            localName = null;
        }
        return new TagListNS(namespaceURI, localName);
    }

    public final int getIndexOf(Node maybeChild) {
        int i = 0;
        while (i < this.length) {
            if (this.children[i] == maybeChild) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void normalize() {
        Node node;
        boolean preserve = false;
        boolean knowPreserve = false;
        if (this.readonly) {
            throw new DomEx(7);
        }
        int i = 0;
        while ((node = this.item(i)) != null) {
            switch (node.getNodeType()) {
                case 1: {
                    ((Element)node).normalize();
                    break;
                }
                case 3: {
                    Node node2 = this.item(i + 1);
                    if (node2 == null || node2.getNodeType() != 3) break;
                    ((TextNode)node).joinNextText();
                    --i;
                    break;
                }
            }
            ++i;
        }
    }

    public int removeWhiteSpaces(char[] buf) {
        int current = 0;
        int j = 0;
        block0: while (j < buf.length) {
            int c;
            boolean sawSpace = false;
            if ((c = buf[j++]) == 32 || c == 9 || c == 10 || c == 13) {
                c = 32;
                sawSpace = true;
            }
            buf[current++] = c;
            if (!sawSpace) continue;
            while (j < buf.length) {
                c = buf[j];
                if (c != 32 && c != 9 && c != 10 && c != 13) continue block0;
                ++j;
            }
        }
        return current;
    }

    class TagListNS
    extends TagList {
        private String namespaceURI;

        TagListNS(String namespaceURI, String localName) {
            super(localName);
            this.namespaceURI = namespaceURI;
        }

        public Node item(int i) {
            if (i < 0) {
                return null;
            }
            int temp = this.getLastMutationCount();
            if (this.lastWalker != null && (i < this.lastIndex || temp != this.lastMutationCount)) {
                this.lastWalker = null;
            }
            if (this.lastWalker == null) {
                this.lastWalker = new TreeWalker(ParentNode.this);
                this.lastIndex = -1;
                this.lastMutationCount = temp;
            }
            if (i == this.lastIndex) {
                return this.lastWalker.getCurrent();
            }
            Element node = null;
            while (i > this.lastIndex && (node = this.lastWalker.getNextElement(this.namespaceURI, this.tag)) != null) {
                ++this.lastIndex;
            }
            if (node == null) {
                this.lastWalker = null;
            }
            return node;
        }

        public int getLength() {
            TreeWalker walker = new TreeWalker(ParentNode.this);
            int count = 0;
            while (walker.getNextElement(this.namespaceURI, this.tag) != null) {
                ++count;
            }
            return count;
        }
    }

    class TagList
    implements NodeList {
        protected String tag;
        protected int lastMutationCount;
        protected int lastIndex;
        protected TreeWalker lastWalker;

        protected int getLastMutationCount() {
            XmlDocument doc = (XmlDocument)ParentNode.this.getOwnerDocument();
            return doc == null ? 0 : doc.mutationCount;
        }

        TagList(String tag) {
            this.tag = tag;
        }

        public Node item(int i) {
            if (i < 0) {
                return null;
            }
            int temp = this.getLastMutationCount();
            if (this.lastWalker != null && (i < this.lastIndex || temp != this.lastMutationCount)) {
                this.lastWalker = null;
            }
            if (this.lastWalker == null) {
                this.lastWalker = new TreeWalker(ParentNode.this);
                this.lastIndex = -1;
                this.lastMutationCount = temp;
            }
            if (i == this.lastIndex) {
                return this.lastWalker.getCurrent();
            }
            Element node = null;
            while (i > this.lastIndex && (node = this.lastWalker.getNextElement(this.tag)) != null) {
                ++this.lastIndex;
            }
            if (node == null) {
                this.lastWalker = null;
            }
            return node;
        }

        public int getLength() {
            TreeWalker walker = new TreeWalker(ParentNode.this);
            Element node = null;
            int retval = 0;
            while ((node = walker.getNextElement(this.tag)) != null) {
                ++retval;
            }
            return retval;
        }
    }
}

