#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>
#include "configdata.h"
#include "clibrary.h"
#include "libinn.h"
#include "macros.h"


#define OFFSET_ARTNUM      0
#define OFFSET_HASH        4

/* 
** Pack the OVERINDEX structure into something more suitable for storing
** on disk.  Result is architecture independent.
*/
void PackOverIndex(OVERINDEX *index, char *result) {
    U_INT32_T i;
    
    i = htonl(index->artnum & 0xffffffff);
    memcpy(&result[OFFSET_ARTNUM], &i, sizeof(i));
    memcpy(&result[OFFSET_HASH], &index->hash, sizeof(HASH));
}


void UnpackOverIndex(char *packedindex, OVERINDEX *index) {
    U_INT32_T		i;
    char                buff[sizeof(i)];

    memset(buff, '\0', sizeof(buff));
    memcpy(&i, &packedindex[OFFSET_ARTNUM], sizeof(i));
    index->artnum = ntohl(i);

    memcpy(&index->hash, &packedindex[OFFSET_HASH], sizeof(HASH));
}

