#include "fm.h"

#ifdef USE_HISTORY
Buffer *
historyBuffer(Hist * hist)
{
    Str src = Strnew();
    char *q;
    int i, j;

    Strcat_charp(src, "<html>\n<head><title>History Page</title></head>\n");
    Strcat_charp(src, "<body>\n<h1>History Page</h1>\n<hr>\n");
    Strcat_charp(src, "<ol>\n");
    for (i = 0; i < hist->length; i++) {
	j = (hist->offset - i + hist->size) % hist->size;
	q = htmlquote_str(hist->line[j]);
	Strcat_charp(src, "<li><a href=\"");
	Strcat_charp(src, q);
	Strcat_charp(src, "\">");
	Strcat_charp(src, q);
	Strcat_charp(src, "</a>\n");
    }
    Strcat_charp(src, "</ol>\n</body>\n</html>");
    return loadHTMLString(src->ptr);
}

void
loadHistory(Hist * hist)
{
    FILE *f;
    Str line;

    if ((f = fopen(rcFile(HISTORY_FILE), "r")) == NULL)
	return;

    while (!feof(f)) {
	line = Strfgets(f);
	Strchop(line);
	Strremovefirstspaces(line);
	Strremovetrailingspaces(line);
	if (line->length == 0)
	    continue;
	addUniqHist(hist, line->ptr);
    }
    fclose(f);
}

void
saveHistory(Hist * hist)
{
    FILE *f;
    int i, j;

    if ((f = fopen(rcFile(HISTORY_FILE), "w")) == NULL) {
	disp_message("Can't open history", FALSE);
	return;
    }

    for (i = 0; i < hist->length; i++) {
	j = (hist->offset + i + 1 - hist->length + hist->size) % hist->size;
	fprintf(f, "%s\n", hist->line[j]);
    }
    fclose(f);
}
#endif				/* USE_HISTORY */

Hist *
initHist(int size)
{
    Hist *hist;
    int i;

    hist = New(Hist);
    hist->offset = size - 1;
    hist->position = 0;
    hist->length = 0;
    hist->size = size;
    hist->line = New_N(char *, size);
    for (i = 0; i < size; i++)
	hist->line[i] = New(char);

    return (hist);
}

void
resizeHist(Hist * hist, int size)
{
    char **newline;
    int i, j;

    if (hist->size == size)
	return;
    newline = New_N(char *, size);
    for (i = 0; i < size; i++)
	newline[i] = New(char);

    if (hist->length >= size)
	hist->length = size - 1;
    for (i = 0; i < hist->length; i++) {
	j = (hist->offset + i + 1 - hist->length + hist->size) % hist->size;
	newline[i] = hist->line[j];
    }
    hist->offset = (hist->length - 1 + size) % size;
    hist->position = hist->length;
    hist->size = size;
    hist->line = newline;
}

int
insertHist(Hist * hist, char *line)
{
    int p;

    if (hist == NULL || line == NULL)
	return (-1);
    if (hist->size <= 0 || line[0] == '\0')
	return (-1);
    if (hist->length >= hist->size - 1)
	return (-1);

    p = (hist->offset - hist->length + hist->size) % hist->size;
    hist->line[p] = New_Reuse(char, hist->line[p],
			      (strlen(line) + 1));
    strcpy(hist->line[p], line);
    hist->length++;
    return (p);
}

int
addHist(Hist * hist, char *line)
{
    if (hist == NULL || line == NULL)
	return (-1);
    if (hist->size <= 0 || line[0] == '\0')
	return (-1);

    hist->offset = (hist->offset + 1) % hist->size;
    hist->line[hist->offset] = New_Reuse(char, hist->line[hist->offset],
					 (strlen(line) + 1));
    strcpy(hist->line[hist->offset], line);
    hist->position = (hist->offset + 1) % hist->size;
    hist->line[hist->position] = New_Reuse(char, hist->line[hist->position], 1);
    *hist->line[hist->position] = '\0';
    if (hist->length < hist->size - 1)
	hist->length++;
    return (hist->offset);
}

int
addUniqHist(Hist * hist, char *line)
{
    int i, j;
    char *p;

    if (hist == NULL || line == NULL)
	return (-1);
    if (hist->size <= 0 || line[0] == '\0')
	return (-1);

    for (i = 0; i < hist->length; i++) {
	j = (hist->offset - i + hist->size) % hist->size;
	if (!strcmp(hist->line[j], line)) {
	    p = hist->line[j];
	    for (; i > 0; i--) {
		j = (hist->offset - i + hist->size) % hist->size;
		hist->line[j] = hist->line[(j + 1) % hist->size];
	    }
	    hist->line[hist->offset] = p;
	    hist->position = (hist->offset + 1) % hist->size;
	    return (hist->offset);
	}
    }
    return addHist(hist, line);
}
