#
# rules.mk:  1998 09 26
#
# Copyright (C) 1998 by Avery Pennarun <apenwarr@worldvisions.ca>.
#   Use, distribute, modify, and redistribute freely.  (But if you're nice,
#   you'll send all your changes back to me.)
#
# This is a complicated-looking set of Makefile rules that should make your
# own Makefiles simpler, by providing for several useful features (like
# autodependencies and a 'clean' target) without any extra effort.
#
# It will only work with GNU make.
#

STRIP=strip --remove-section=.note --remove-section=.comment
#STRIP=echo

#
# Define DEBUG flag if not already set.
#
ifeq ($(DEBUG),)
DEBUG=1
endif

#
# Point to the electric fence library, assuming DEBUG=1.
#
ifeq ($(DEBUG),1)
EFENCE=-lefence
else
EFENCE=
endif

#
# C compilation flags (depends on DEBUG setting)
#
CPPFLAGS = $(CPPOPTS)
CFLAGS = $(COPTS) -Wall -D_BSD_SOURCE -D_GNU_SOURCE
CXXFLAGS = $(CXXOPTS)
LDFLAGS = $(LDOPTS)

ifeq ($(DEBUG),1)
CFLAGS += -g -Wall -DDEBUG=1
CXXFLAGS +=
LDFLAGS += -g
else
CFLAGS += -O6 -DDEBUG=0 -DNDEBUG
#CFLAGS += -fomit-frame-pointer  # somewhat evil
#CXXFLAGS += -fno-implement-inlines  # causes trouble with egcs 1.0
#CXXFLAGS += -fno-implement-inlines -fno-rtti -fno-exceptions
LDFLAGS += -s
endif


# we need a default rule, since the 'include' below causes trouble
default: all

# any rule that depends on FORCE will always run
.PHONY: FORCE
FORCE:

%.gz: FORCE %
	@rm -f $@
	gzip -f $*
	@ls -l $@

ALLDIRS = $(XPATH)
#VPATH = $(shell echo $(ALLDIRS) | sed 's/[ 	][ 	]*/:/g')
INCFLAGS = $(addprefix -I,$(ALLDIRS))

#
# Typical compilation rules.
#
override _R_CFLAGS=$(CPPFLAGS) $(CFLAGS) $(INCFLAGS)
override _R_CXXFLAGS=$(CPPFLAGS) $(CFLAGS) $(CXXFLAGS) $(INCFLAGS)
export _R_CFLAGS
export _R_CXXFLAGS
%.o: %.c
	$(CC) $$_R_CFLAGS -c $<

%.o: %.cc
	$(CXX) $$_R_CXXFLAGS -c $<
	
../%.a:
	@echo "Library $@ does not exist!"; exit 1
	
%.a:
	rm -f $@
	ar q $@ $^
	ranlib $@

%: %.o
	$(CC) $(LDFLAGS) -o $@ $^ $(LIBS) $($*-LIBS)

#
# Automatically generate header dependencies for .c and .cc files.  The
# dependencies are stored in the file ".depend"
#

rules_mk_sf = $(wildcard *.c) $(wildcard *.cc)

.depend: $(rules_mk_sf)
	@echo "(autodepend)"
	@set +e; \
	  ALLFILES=$$(echo $$(grep -h '^[ 	]*#include' $(rules_mk_sf) \
		  	| $(CC) $$_R_CFLAGS -MM -E -) "" \
		  	| sed -e 's/-://g' -e 's/\\//g'); \
	  ( echo $(rules_mk_sf); echo $$ALLFILES; \
	    grep '^[ 	]*#include' $(rules_mk_sf) $$ALLFILES \
	    | sed 's/:#include[ 	][ 	]*[<"]\(.*\)[">].*$$/ \1/' ) \
	  | awk ' \
	  	NR<=2 { \
	  		for (a=1; a <= NF; a++) { \
	  			n = split($$a, elem, "/"); \
	  			if (NR==1) important[elem[n]]=1; \
	  			paths[elem[n]]=$$a; \
	  		} \
	  	} \
	  	\
	  	NR>2 { \
	  		if ($$2 in paths) \
		  		deps[$$1] = deps[$$1] " " $$2; \
	  	} \
	  	\
	  	function depcheck(file,    n, ntot, depsx) { \
	  		if (file in alldeps) return; \
	  		alldeps[file]=file; \
	  		ntot = split(deps[paths[file]], depsx); \
	  		for (n = 1; n <= ntot; n++) \
	  			depcheck(depsx[n]); \
	  	} \
	  	\
	  	END { \
	  		for (d in important) { \
	  			x=d; \
	  			sub(".c$$|.cc$$",".o",x); \
	  			printf("%s:", x); \
	  			delete alldeps; \
	  			depcheck(d); \
	  			for (dd in alldeps) \
	  				printf(" %s", paths[alldeps[dd]]); \
	  			printf("\n"); \
	  		} \
	  		\
	  		printf(".depend:"); \
	  		for (d in deps) { \
	  			sub(":$$", "", d); \
	  			printf(" %s", d); \
	  		} \
	  		printf("\n"); \
	  	} ' >.depend || rm -f .depend
	

ifneq ($(strip $(rules_mk_sf)),)
-include .depend
endif


#
# A macro for compiling subdirectories listed in the SUBDIRS variable.
# Tries to make the target ($@) in each subdir, unless the target is called
# "subdirs" in which case it makes "all" in each subdir.
#
define subdirs
	@OLDDIR="$$PWD"; set -e; \
	for d in __fx__ ${SUBDIRS}; do \
		if [ "$$d" = "__fx__" ]; then continue; fi; \
		cd "$$d"; \
		echo ; \
		echo "--> Making $(subst subdirs,all,$@) in $$PWD..."; \
		${MAKE} --no-print-directory $(subst subdirs,all,$@); \
		cd "$$OLDDIR"; \
	done
	@echo
	@echo "--> Back in $$PWD..."
endef

subdirs:
	$(subdirs)


#
# Auto-clean rule.  Feel free to append to this in your own directory, by
# defining your own "clean" rule.
#
clean: FORCE cleanrule

cleanrule: FORCE
	rm -f *~ *.o *.a .*.d .depend

#
# Make 'tags' file using the ctags program - useful for editing
#
#tags: $(shell find -name '*.cc' -o -name '*.[ch]')
#	@echo '(creating "tags")'
#	@if [ -x /usr/bin/ctags ]; then /usr/bin/ctags $^; fi
