// -*-c++-*-
/* $Id: getfh3.h,v 1.3 2001/04/07 06:13:02 dm Exp $ */

/*
 *
 * Copyright (C) 2001 David Mazieres (dm@uun.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#ifndef _SFSMISC_GETFH3_H_
#define _SFSMISC_GETFH3_H_ 1

#include "arpc.h"
#include "nfs3_prot.h"
#include "mount_prot.h"

const strbuf &strbuf_cat (const strbuf &, mountstat3);
void getfh3 (str host, str path,
	     callback<void, const nfs_fh3 *, str>::ref);
void getfh3 (ref<aclnt> c, str path,
	     callback<void, const nfs_fh3 *, str>::ref);
void lookupfh3 (ref<aclnt> c, const nfs_fh3 &start, str path,
		callback<void, const nfs_fh3 *,
		const fattr3exp *, str>::ref cb,
		const authunix_parms *aup = NULL);

#endif /* !_SFSMISC_GETFH3_H_ */
