/***************************************************************************
                          verkauf_rechnung.cpp  -  description
                             -------------------
    begin                : Wed Aug 9 2000
    version              : $Id: verkauf_rechnung.cpp,v 1.29 2001/03/14 13:59:04 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : info@bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qmessagebox.h>

#include "verkauf_rechnung.h"

Verkauf_Rechnung::Verkauf_Rechnung(QWidget *parent, const char *name,
															SQLQuerier *sql_ptr )
	: QWidget(parent,name)
{
	strPtr = new QString("");
	QBoxLayout *topLayout = new QVBoxLayout( this, 5 );

	dialog = new QDBMenuDialog( this, 0, sql_ptr, false,
									"SELECT * FROM verkaufskopf WHERE art='Deb.-Rechnung' ORDER BY art,belegnr",
									"art,belegnr", "verkaufskopf",
									"Rechnung.kdevdlg" );

	tableKopf = dialog->dialog->table;

	dialog->dialog->Page1->Feldvorgabe[tableKopf->fNumber("art")]->setStr( "Deb.-Rechnung" );

	accounting = new QPopupMenu( this );
	accounting->insertItem( "&Buchen", this, SLOT(sBuchen()) );
	dialog->menuBar->insertItem( "&Buchfhrung", accounting );

	topLayout->addWidget( dialog, 5 );

	statusBar = new QStatusBar( this );
	topLayout->addWidget( statusBar );

	setMinimumSize( dialog->dialog->Page1->sizeHint() );
	setMinimumSize( width()+50, dialog->dialog->Page1->height()+100 );

	// If customer number was changed, update the display.
	connect( dialog->dialog->Page1->Feld[tableKopf->fNumber("kundennr")],
		SIGNAL(returnPressed()), SLOT(setDefaults()) );
	// If a tuple was modified, update the display.
	connect( dialog->dialog->Page1,
		SIGNAL(tupleChanged()), SLOT(sCalcPositions()) );
	// If the position was changed, update the display.
	connect( dialog->dialog->Page1,
		SIGNAL(posChanged()), SLOT(sCalcPositions()) );
	// If the position was changed in the table, update the display.
	connect( dialog->dialog->TableP2,
		SIGNAL(selectionChanged()), SLOT(sCalcPositions()) );

	// if new was pressed, get a invoice number
	connect( dialog->dialog->Page1, SIGNAL(sigNew()), SLOT(getNewInvoiceNo()) );
	// if the new tuple was updated activate the positions site
	connect( dialog->dialog->Page1, SIGNAL(tupleChanged()), SLOT(enableZeilen()) );
	connect( dialog->dialog->Page1, SIGNAL(sigUndo()), SLOT(enableZeilen()) );

	initPositions();

	buchen = new Buchen( &sql, tableKopf, tableZeilen );

	setGeometry( x(), y(), 1000, height() );
}

Verkauf_Rechnung::~Verkauf_Rechnung(){
}

void Verkauf_Rechnung::getNewInvoiceNo()
{
	QString NoBO;
	QString nothing;

	sql.getLfdNr( "buchhaltungsdaten", &NoBO, "letz_auftragsnr", 1);
	NoBO.setNum( NoBO.toLong()+1 );
	dialog->dialog->Page1->Feld[tableKopf->fNumber("belegnr")]->setText( NoBO );
	dialog->dialog->Page1->setValue( "nettobetrag", &nothing );
	dialog->dialog->Page1->setValue( "bruttobetrag", &nothing );
	dialog->dialog->Page1->Feld[tableKopf->fNumber("kundennr")]->setFocus();

	dialog->dialog->setTabEnabled( zeilen, false );
	statusBar->message( "EINFGEMODUS" );
}

void Verkauf_Rechnung::enableZeilen()
{
	dialog->dialog->setTabEnabled( zeilen, true );
	statusBar->clear();
}

void Verkauf_Rechnung::setDefaults()
{
	QDBDate date; // for current date

	// get tuple with the customer number
	QString query = "SELECT * FROM debitor where nummer = '";

	query.append(dialog->dialog->Page1->Feld[tableKopf->fNumber("kundennr")]->text());
	query.append( "'" );

	SQLTable *t = new SQLTable( query.ascii(), "nummer" );

	// only for test
	//QMessageBox::information( 0, "QtTudo Test", query.ascii() );

  if (t->execute() != SUCCESS_NO_RESULTS) {
		// fill in the customer data (this fields must be visible)
		setDebitorValue( t, "briefanrede" );
		setDebitorValue( t, "name" );
		setDebitorValue( t, "name_2" );
		setDebitorValue( t, "adresse" );
		setDebitorValue( t, "adresse_2" );
		setDebitorValue( t, "plz" );
		setDebitorValue( t, "ort" );
		setDebitorValue( t, "waehrungscode" );
		setDebitorValue( t, "zahlungsbed_code" );
		setDebitorValue( t, "mwst_pflichtig" );
		setDebitorValue( t, "preisgruppennr" );
		setDebitorValue( t, "ust_idnr" );
		setDebitorValue( t, "lieferungscode" );
		setDebitorValue( t, "laendercode" );
		setDebitorValue( t, "lokationscode" );
		setDebitorValue( t, "buchungsgruppe", "buch_gr" );
		setDebitorValue( t, "verkaeufercode" );
	}

	dialog->dialog->Page1->Feld[tableKopf->fNumber(
		"buchungsdatum")]->setText( date.getDate() );
	dialog->dialog->Page1->Feld[tableKopf->fNumber(
		"faelligkeitsdatum")]->setText( date.getDate() );
	dialog->dialog->Page1->Feld[tableKopf->fNumber(
		"lieferdatum")]->setText( date.getDate() );
}

void Verkauf_Rechnung::setDebitorValue( SQLTable *t,
		const char *fieldDebitor, const char *fieldKopf )
{
	if (fieldKopf == 0)
		dialog->dialog->Page1->Feld[tableKopf->fNumber(
			fieldDebitor)]->setText( t->getValue( 0, fieldDebitor) );
	else
		dialog->dialog->Page1->Feld[tableKopf->fNumber(
			fieldKopf)]->setText( t->getValue( 0, fieldDebitor) );
}

// Calculate invoice positions
void Verkauf_Rechnung::setFields( const char *fieldname )
{
	QString sNetto, sBrutto;
	double netto, brutto, VAT_percent;

	QCString *DBneu = new QCString();
	QCString *DBartikel = new QCString();
	QCString *DBmwst = new QCString();
	QCString *DBres = new QCString();
	QCString *DBsachk = new QCString();
	
	SQLTable *tableNeu = new SQLTable();
	SQLTable *tableArtikel = new SQLTable();
	SQLTable *tableMwSt = new SQLTable();
	SQLTable *tableRes = new SQLTable();
	SQLTable *tableSachk = new SQLTable();

	// set VAT percent
	if (strstr(fieldname, "mwst_code") != NULL) {
		// get VAT percent
		DBmwst->setStr( "SELECT * FROM mwst WHERE code = '" );
		DBmwst->append( positions->currentItem()->text(
			positions->tupleIndex[tableZeilen->fNumber("mwst_code")] ) );
		DBmwst->append( "'" );
		// Only for test
		//QMessageBox::information( this, "QtTudo Test: MwSt", DBmwst->copy() );
		tableMwSt->sQuery = DBmwst->copy();
		if (tableMwSt->execute() != SUCCESS_RESULTS)
			QMessageBox::warning( this, "QtTudo", tableMwSt->ErrorText );

		// setting fields
		DBneu->setStr( "UPDATE verkaufszeile SET mwst_prozent = '" );
		DBneu->append( tableMwSt->getValue(0,"mwst_proz") );
		DBneu->append( "' WHERE " );
		tableZeilen->GetPrimaryKey( DBneu );

		// Only for test
		//QMessageBox::information( this, "Test: MwSt.-Code", DBneu->copy() );

		tableNeu->sQuery = DBneu->copy();
		if (tableNeu->execute() != SUCCESS_NO_RESULTS)
			QMessageBox::warning( this, "QtTudo", tableNeu->ErrorText );

		positions->update();
	}

	// fill fields with 'nummer'-typical data
	if (strstr(fieldname, "nummer") != NULL) {
		getPosValue( "art" );
		// if artikel
		if ( strPtr->compare("Artikel") == 0 ) {
			// searching artikel
			DBartikel->setStr( "SELECT * FROM artikel WHERE nummer = '" );
			DBartikel->append( getPosValue( "nummer" )->copy() );
			DBartikel->append( "'" );

 			// Only for test
			//QMessageBox::information( this, "QtTudo Test: Artikel", DBneu->copy() );

			tableArtikel->sQuery = DBartikel->copy();
 			if (tableArtikel->execute() != SUCCESS_RESULTS)
 				QMessageBox::warning( this, "QtTudo", tableArtikel->ErrorText );
			else {
				// get VAT percent
				DBmwst->setStr( "SELECT * FROM mwst WHERE code = '" );
				DBmwst->append( tableArtikel->getValue(0,"umsatzsteuercode") );
				DBmwst->append( "'" );
				// Only for test
				//QMessageBox::information( this, "QtTudo Test: MwSt", DBmwst->copy() );
				tableMwSt->sQuery = DBmwst->copy();
				if (tableMwSt->execute() != SUCCESS_RESULTS)
 					QMessageBox::warning( this, "QtTudo", tableMwSt->ErrorText );

				// setting fields
				DBneu->setStr( "UPDATE verkaufszeile SET text = '" );
				DBneu->append( tableArtikel->getValue(0,"bezeichnung") );
				DBneu->append( "',text_2 = '" );
				DBneu->append( tableArtikel->getValue(0,"bezeichnung_2") );
				DBneu->append( "',lokationscode = '" );
				DBneu->append( tableKopf->getValue(0,"lokationscode") );
				DBneu->append( "',buch_gr = '" );
				DBneu->append( tableArtikel->getValue(0,"buch_gr") );
				DBneu->append( "',einheit = '" );
				DBneu->append( tableArtikel->getValue(0,"einheit") );
				DBneu->append( "',stueckpreis = '" );
				DBneu->append( tableArtikel->getValue(0,"vk_preis") );
				DBneu->append( "',einstandspreis_mw = '" );
				DBneu->append( tableArtikel->getValue(0,"einstandspreis") );
				//DBneu->append( "',einstandspreis = '" );
				//DBneu->append( einstandspreis aus verkaufszeile umgerechnet );
				DBneu->append( "',mwst_code = '" );
				DBneu->append( tableArtikel->getValue(0,"umsatzsteuercode") );
				DBneu->append( "',mwst_prozent = '" );
				DBneu->append( tableMwSt->getValue(0,"mwst_proz") );
				DBneu->append( "',menge='0',nettobetrag='0',bruttobetrag='0'" );
				DBneu->append( " WHERE " );
				tableZeilen->GetPrimaryKey( DBneu );

				// Only for test
				QMessageBox::information( this, "Test: Calc. Pos.", DBneu->copy() );

				tableNeu->sQuery = DBneu->copy();
				if (tableNeu->execute() != SUCCESS_NO_RESULTS)
					QMessageBox::warning( this, "QtTudo", tableNeu->ErrorText );

				positions->update();
			}
		} else
		// if sachkonto
		if ( strPtr->compare("Sachkonto") == 0 ) {
			// searching ressource
			DBsachk->setStr( "SELECT * FROM sachkonto WHERE nummer = '" );
			DBsachk->append( getPosValue( "nummer" )->copy() );
			DBsachk->append( "'" );

 			// Only for test
			//QMessageBox::information( this, "QtTudo Test: Sachkonto", DBsachk->copy() );

			tableSachk->sQuery = DBsachk->copy();
 			if (tableSachk->execute() != SUCCESS_RESULTS)
 				QMessageBox::warning( this, "QtTudo", tableSachk->ErrorText );
			else {
				// get VAT percent
				DBmwst->setStr( "SELECT * FROM mwst WHERE code = '" );
				DBmwst->append( tableSachk->getValue(0,"mwst_code") );
				DBmwst->append( "'" );
				// Only for test
				//QMessageBox::information( this, "QtTudo Test: MwSt", DBmwst->copy() );
				tableMwSt->sQuery = DBmwst->copy();
				if (tableMwSt->execute() != SUCCESS_RESULTS)
 					QMessageBox::warning( this, "QtTudo", tableMwSt->ErrorText );

				// setting fields
				DBneu->setStr( "UPDATE verkaufszeile SET text = '" );
				DBneu->append( tableSachk->getValue(0,"name") );
				//DBneu->append( "',text_2 = '" );
				//DBneu->append( tableRes->getValue(0,"name_2") );
				//DBneu->append( "',lokationscode = '" );
				//DBneu->append( tableKopf->getValue(0,"lokationscode") );
				//DBneu->append( "',buch_gr = '" );
				//DBneu->append( tableRes->getValue(0,"buch_gr") );
				//DBneu->append( "',einheit = '" );
				//DBneu->append( tableArtikel->getValue(0,"einheit") );
				//DBneu->append( "',stueckpreis = '" );
				//DBneu->append( tableRes->getValue(0,"vk_preis") );
				//DBneu->append( "',einstandspreis_mw = '" );
				//DBneu->append( tableRes->getValue(0,"einstandspreis") );
				//DBneu->append( "',einstandspreis = '" );
				//DBneu->append( einstandspreis aus verkaufszeile umgerechnet );
				DBneu->append( "',mwst_code = '" );
				DBneu->append( tableSachk->getValue(0,"mwst_code") );
				DBneu->append( "',mwst_prozent = '" );
				DBneu->append( tableMwSt->getValue(0,"mwst_proz") );
				DBneu->append( "',menge='0',nettobetrag='0',bruttobetrag='0'" );
				DBneu->append( " WHERE " );
				tableZeilen->GetPrimaryKey( DBneu );

				// Only for test
				//QMessageBox::information( this, "QtTudo Test: Ressource", DBneu->copy() );

				tableNeu->sQuery = DBneu->copy();
				if (tableNeu->execute() != SUCCESS_NO_RESULTS)
					QMessageBox::warning( this, "QtTudo", tableNeu->ErrorText );

				positions->update();
			}
		} else
		// if ressource
		if ( strPtr->compare("Ressource") == 0 ) {
			// searching ressource
			DBres->setStr( "SELECT * FROM ressource WHERE nummer = '" );
			DBres->append( getPosValue( "nummer" )->copy() );
			DBres->append( "'" );

 			// Only for test
			//QMessageBox::information( this, "QtTudo Test: Ressource", DBres->copy() );

			tableRes->sQuery = DBres->copy();
 			if (tableRes->execute() != SUCCESS_RESULTS)
 				QMessageBox::warning( this, "QtTudo", tableRes->ErrorText );
			else {
				// get VAT percent
				DBmwst->setStr( "SELECT * FROM mwst WHERE code = 'M0'" );
				// Only for test
				//QMessageBox::information( this, "QtTudo Test: MwSt", DBmwst->copy() );
				tableMwSt->sQuery = DBmwst->copy();
				if (tableMwSt->execute() != SUCCESS_RESULTS)
					QMessageBox::warning( this, "QtTudo", tableMwSt->ErrorText );

				// setting fields
				DBneu->setStr( "UPDATE verkaufszeile SET text = '" );
				DBneu->append( tableRes->getValue(0,"name") );
				DBneu->append( "',text_2 = '" );
				DBneu->append( tableRes->getValue(0,"name_2") );
				//DBneu->append( "',lokationscode = '" );
				//DBneu->append( tableKopf->getValue(0,"lokationscode") );
				DBneu->append( "',buch_gr = '" );
				DBneu->append( tableRes->getValue(0,"buch_gr") );
				//DBneu->append( "',einheit = '" );
				//DBneu->append( tableArtikel->getValue(0,"einheit") );
				DBneu->append( "',stueckpreis = '" );
				DBneu->append( tableRes->getValue(0,"vk_preis") );
				DBneu->append( "',einstandspreis_mw = '" );
				DBneu->append( tableRes->getValue(0,"einstandspreis") );
				//DBneu->append( "',einstandspreis = '" );
				//DBneu->append( einstandspreis aus verkaufszeile umgerechnet );
				DBneu->append( "',mwst_code = 'M0" );
				DBneu->append( "',mwst_prozent = '" );
				DBneu->append( tableMwSt->getValue(0,"mwst_proz") );
				DBneu->append( "',menge='0',nettobetrag='0',bruttobetrag='0'" );
				DBneu->append( " WHERE " );
				tableZeilen->GetPrimaryKey( DBneu );

				// Only for test
				//QMessageBox::information( this, "QtTudo Test: Ressource", DBneu->copy() );

				tableNeu->sQuery = DBneu->copy();
				if (tableNeu->execute() != SUCCESS_NO_RESULTS)
					QMessageBox::warning( this, "QtTudo", tableNeu->ErrorText );

				positions->update();
			}
		}
	} else // end of fieldname == nummer
	// calculate and fill fields
	if ((strstr(fieldname, "menge") != NULL) ||
			(strstr(fieldname, "stueckpreis") != NULL) ||
			(strstr(fieldname, "mwst_prozent") != NULL)) {
		netto = getPosValue( "menge" )->copy().toDouble();
		netto *= getPosValue( "stueckpreis" )->copy().toDouble();
		sNetto.setNum( netto );
		VAT_percent = getPosValue( "mwst_prozent" )->copy().toDouble();
		if ( VAT_percent > 0 ) // if with VAT
			brutto = netto + (netto * VAT_percent / 100);
		else
			brutto = netto;
		sBrutto.setNum ( brutto );
		DBneu->setStr( "UPDATE verkaufszeile SET nettobetrag = '" );
 		DBneu->append( sNetto.copy() );
 		DBneu->append( "'" );
		DBneu->append( ",bruttobetrag = '" );
 		DBneu->append( sBrutto.copy() );
 		DBneu->append( "'" );
 		DBneu->append( " WHERE " );
 		tableZeilen->GetPrimaryKey( DBneu );

 		// Only for test
		//QMessageBox::information( this, "Test: Calc. Pos.", DBneu->copy() );

		tableNeu->sQuery = DBneu->copy();
 		if (tableNeu->execute() != SUCCESS_NO_RESULTS)
 			QMessageBox::warning( this, "QtTudo", tableNeu->ErrorText );

		positions->update();
	}
}

QString *Verkauf_Rechnung::getPosValue( const char *fieldname )
{
	strPtr->truncate(0);

	if (positions->currentItem()->text(
			positions->tupleIndex[tableZeilen->fNumber( fieldname )]) != 0 )
		strPtr->append( positions->currentItem()->text(
			positions->tupleIndex[tableZeilen->fNumber( fieldname )] ).copy());
	return strPtr;
}

void Verkauf_Rechnung::initPositions()
{
	QString query = "SELECT * FROM verkaufszeile WHERE belegnr = '";
	QString nr;
	QString test;

	zeilen = new QWidget( this );
  topLayoutZeilen = new QVBoxLayout( zeilen, 10 );

	nr.append( tableKopf->getValue( tableKopf->pos, "belegnr") );
	query.append( nr );
	query.append( "' ORDER BY belegart,belegnr,lfd_nr" );

	// Only for test
	//QMessageBox::information( 0, "QtTudo Test", query.copy() );

	tableZeilen =	new SQLTable( query.ascii(), "belegart,belegnr,lfd_nr" );
	if (tableZeilen->execute() != SUCCESS_RESULTS)
		QMessageBox::warning( this, "QtTudo Zeilen generieren", tableZeilen->ErrorText );

	positions = new QDBTableEdit(
		zeilen, 0, &sql, tableZeilen, statusBar, "verkaufszeile", false, true );

	// defaults
	positions->Feldvorgabe[tableZeilen->fNumber("belegart")]->append("Deb.-Rechnung");
	positions->Feldvorgabe[tableZeilen->fNumber("art")]->append("Ressource");

	// Special column headers (labels)
	positions->colName[tableZeilen->fNumber("art")]->append( "Art" );
	positions->colSize[tableZeilen->fNumber("art")] = 70;
	positions->colName[tableZeilen->fNumber("text")]->append( "Text" );
	positions->colSize[tableZeilen->fNumber("text")] = 400;
	//positions->colName[tableZeilen->fNumber("lokationscode")]->append( "Lok." );
	//positions->colSize[tableZeilen->fNumber("lokationscode")] = 86;
	positions->colName[tableZeilen->fNumber("buch_gr")]->append( "Buch.Gr." );
	positions->colName[tableZeilen->fNumber("mwst_code")]->append( "MwSt." );
	positions->colSize[tableZeilen->fNumber("mwst_code")] = 40;
	positions->colName[tableZeilen->fNumber("nummer")]->append( "Nummer" );
	positions->colSize[tableZeilen->fNumber("nummer")] = 70;
	positions->colName[tableZeilen->fNumber("menge")]->append( "Menge" );
	positions->colSize[tableZeilen->fNumber("menge")] = 45;
	positions->colName[tableZeilen->fNumber("stueckpreis")]->append( "Stckpreis" );
	positions->colSize[tableZeilen->fNumber("stueckpreis")] = 70;
	positions->colName[tableZeilen->fNumber("nettobetrag")]->append( "Nettobetr." );
	positions->colSize[tableZeilen->fNumber("nettobetrag")] = 70;
	positions->colName[tableZeilen->fNumber("bruttobetrag")]->append( "Bruttobetr." );
	positions->colSize[tableZeilen->fNumber("bruttobetrag")] = 70;
	//positions->colName[tableZeilen->fNumber("einstandspreis_mw")]->append( "Einst.Pr.MW" );
	//positions->colSize[tableZeilen->fNumber("einstandspreis_mw")] = 70;
	//positions->colName[tableZeilen->fNumber("einstandspreis")]->append( "Einst.Pr." );
	//positions->colSize[tableZeilen->fNumber("einstandspreis")] = 70;
	positions->colName[tableZeilen->fNumber("mwst_prozent")]->append( "MwSt.%" );
	positions->colSize[tableZeilen->fNumber("mwst_prozent")] = 50;

	// Don't show the first 3 fields and activate colName's,
	// because not important for the user.
	for (int i = 3; i < tableZeilen->getnFields(); i++ ) {
		test = tableZeilen->fName( i );
		// Don't show this fields
		if ((test.find("text_2") == -1) &&
				(test.find("lokationscode") == -1) &&
				(test.find("einstandspreis") == -1) &&
				(test.find("einstandspreis_mw") == -1) &&
				(test.find("lieferdatum") == -1) &&
				(test.find("einheit") == -1) &&
				(test.find("restmenge") == -1) &&
				(test.find("zu_fakturieren") == -1) &&
				(test.find("zu_liefern") == -1) &&
				(test.find("seriennr") == -1) &&
				(test.find("geliefert") == -1) &&
				(test.find("fakturiert") == -1) &&
				(test.find("lieferungsnr") == -1) &&
				(test.find("gewinn_prozent") == -1) &&
				(test.find("art_des_geschaeftes") == -1) &&
				(test.find("verkehrszweig") == -1) &&
				(test.find("einladehafen") == -1) &&
				(test.find("verfahren") == -1) &&
				(test.find("ursprungsregion") == -1)
			 )
		{
			positions->makeVisible( i );
			positions->addCol( i );
		}
	}

	// to get a unique number (lfd_nr) for the tuple
	connect( positions, SIGNAL(newTuple() ), SLOT(getLfdNr()) );

	connect( positions, SIGNAL(tupleModified()),	SLOT(sCalcPositions()) );

	// calculate the invoice positions
	connect( positions, SIGNAL(tupleUpdated( const char * )),
		SLOT(setFields( const char * )) );

	topLayoutZeilen->addWidget( positions, 10 );

	dialog->dialog->addTab( zeilen, "&Zeilen" );

	sCalcPositions();
}

void Verkauf_Rechnung::getLfdNr()
{
	// Go to the last tuple, get the number of lfd_nr,
	// increment it and put the number in the new tuple.

	QString value;
	QString query = "SELECT * FROM verkaufszeile where belegnr = '";
	QString nr;

	nr.append( tableKopf->getValue( tableKopf->pos, tableKopf->fNumber("belegnr")) );
	query.append( nr );
	query.append( "' ORDER BY belegart,belegnr,lfd_nr" );

	if (positions->currentItem() != 0) {
		SQLTable *t = new SQLTable( query.ascii(), "belegart,belegnr,lfd_nr" );
		value.setNum(0);
		if (t->execute() != SUCCESS_RESULTS)
			QMessageBox::warning( this, "QtTudo Zeilen generieren", t->ErrorText );
		else
			// if we found tuples
			if (t->getnTuples() > 0)
				// get the last number and increment
				value = t->getValue( t->getnTuples()-1, "lfd_nr");

		value.setNum( value.toLong()+1 );

		// set the next lfd_nr
		if (positions->visible[tableZeilen->fNumber("lfd_nr")])
			positions->currentItem()->setText(
				positions->tupleIndex[tableZeilen->fNumber("lfd_nr")], value.copy());

		// Important, if the 'lfd_nr' is not a visible field.
		positions->Feldvorgabe[tableZeilen->fNumber("lfd_nr")]->truncate(0);
		positions->Feldvorgabe[tableZeilen->fNumber("lfd_nr")]->append( value.copy());

		positions->insTuple(); // immediatly save new tuple
	}
}

void Verkauf_Rechnung::sBuchen()
{
	if (buchen->makeAccountVerkauf()) {
		dialog->dialog->Page1->fRead();
	}
}

void Verkauf_Rechnung::sCalcPositions()
{
	int i;
	double f;
	QString s;
	QString query = "SELECT * FROM verkaufszeile WHERE belegnr = '";
	QString nr;

	nr.append( tableKopf->getValue( tableKopf->pos, "belegnr") );
	query.append( nr );
	query.append( "' ORDER BY belegart,belegnr,lfd_nr" );

	tableZeilen->sQuery = query.copy();

	// Only for test
	//QMessageBox::information( 0, "QtTudo Test", tableZeilen->sQuery.copy() );

	if ( tableZeilen->execute() == SUCCESS_RESULTS )
	{
		// defaults
		positions->Feldvorgabe[tableZeilen->fNumber("belegnr")]->truncate(0);
		positions->Feldvorgabe[tableZeilen->fNumber("belegnr")]->append( nr );

		dialog->dialog->Page1->setValue( "bruttobetrag", &s );

		f = 0;
		for ( i = 0; i < tableZeilen->getnTuples(); i++ ) {
			s = tableZeilen->getValue( i, tableZeilen->fNumber("nettobetrag"));
			f += s.toDouble();
		}
		s.setNum(f);
		dialog->dialog->Page1->setValue( "nettobetrag", &s );
		f = 0;
		for ( i = 0; i < tableZeilen->getnTuples(); i++ ) {
			s = tableZeilen->getValue( i, tableZeilen->fNumber("bruttobetrag"));
			f += s.toDouble();
		}
		s.setNum(f);
		dialog->dialog->Page1->setValue( "bruttobetrag", &s );

		positions->update(false);
	}
}
