/***************************************************************************
                          qttudo.cpp  -  description                              
                             -------------------                                         
    begin                : Don Sep  2 09:24:15 CEST 1999
    version              : $Id: qttudo.cpp,v 1.24 2001/03/26 06:45:17 joerg_bemme Exp $
    copyright            : (C) 1999 by Jrg Bemm
    email                : info@bemme.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "qttudo.h"
#include "qdbdialog.h"
#include "qdbtableedit.h"
#include "printsystem.h"

#include "pixmaps/debitor.xpm"
#include "pixmaps/kreditor.xpm"

QtTudoApp::QtTudoApp()
{
	ProgName = new QCString( "QtTudo " );
	//ProgName->append( VERSION ); Mit oder ohne Versions-Nr.
  setCaption(ProgName->copy() + VERSION );
  
  // call inits to invoke all other construction parts
  initMenuBar();
  initToolBar();
  initStatusBar();

  initDoc();
  initView();

	print = new PrintSystem(0,0,&sql);

	debitor						= 0;
	kreditor					= 0;
	artikel						= 0;
	VKrechnung				= 0;
	VKgutschrift			= 0;
	gebVKrechnung			= 0;
	gebVKgutschrift		= 0;
  zeiterfassung			= 0;
	allg_erfassung		= 0;
	warenerfassung		= 0;
	debitorgruppe			= 0;
	kreditorgruppe		= 0;
	sachkonto					= 0;
	buchhaltungsdaten	= 0;
	firmendaten				= 0;
	mwst							= 0;
	waehrung					= 0;
	land							= 0;
	buchungsart				= 0;
	einheit						= 0;
	kontoart					= 0;
	sachkontoart			= 0;
	kontenplan				= 0;
	guv_bilanz				= 0;
	soll_haben				= 0;
	uva_typ						= 0;
	rech_rund_methode = 0;
	warenpostenart		= 0;
	belegart_vk				= 0;
	belegart_ek				= 0;
	zeilenart					= 0;
	ressourceart			= 0;
	res_posten_art		= 0;
	projektpostenart	= 0;
	intra_art					= 0;
	sprache						= 0;
	zahlungsbedingung = 0;
	projektstatus			= 0;
	bundesland				= 0;
	art_des_geschaeftes = 0;
	verkehrszweig			= 0;
	warenverzeichnis	= 0;
	hafen							= 0;
	verfahren					= 0;
	sitz_des_versenders = 0;
	sitz_des_empfaengers = 0;
	deb_buch_gruppe		= 0;
	kred_buch_gruppe	= 0;
	warenbuch_gruppe	= 0;
	resbuch_gruppe		= 0;
	lieferung					= 0;
	lokation					= 0;
	vertreter					= 0;
	preisgruppe				= 0;
	ressource					= 0;
	printElements			= 0;
	printLogictype		= 0;
	printSyntax				= 0;
	printPrinter			= 0;
}

QtTudoApp::~QtTudoApp(){
}

bool QtTudoApp::close( bool forceKill ) {
  // exits the Application
	if (queryExit())
		qApp->quit();
	return forceKill;
}

void QtTudoApp::initMenuBar()
{
  // MENUBAR
  QPopupMenu *Bericht_Debitor = new QPopupMenu;
  QPopupMenu *Bericht_Kreditor = new QPopupMenu;
  QPopupMenu *Bericht_Lager = new QPopupMenu;
  QPopupMenu *Bericht_Warengruppe = new QPopupMenu;
  QPopupMenu *Bericht_Verkauf = new QPopupMenu;
  QPopupMenu *Bericht_Einkauf = new QPopupMenu;
  QPopupMenu *Bericht_Projekt = new QPopupMenu;
  QPopupMenu *Bericht_Intrastat = new QPopupMenu;
  QPopupMenu *Bericht_Sachkonto = new QPopupMenu;
  Bericht_Sachkonto->insertItem( "Sachkonto-Liste", this, SLOT(slotBericht_Sachkonto_Liste()) );
  Bericht_Sachkonto->insertItem( "G.u.V./Bilanz", this, SLOT(slotBericht_Sachkonto_GuV()) );
  Bericht_Sachkonto->insertItem( "G.u.V./Bilanz zum Stichtag", this, SLOT(slotBericht_Sachkonto_GuV_Stichtag()) );

  QPopupMenu *Administration = new QPopupMenu;
  QPopupMenu *Intrastat = new QPopupMenu;
  QPopupMenu *Buchungsgruppen = new QPopupMenu;
  QPopupMenu *GebuchtVK = new QPopupMenu;
  QPopupMenu *GebuchtEK = new QPopupMenu;
  QPopupMenu *reportGen = new QPopupMenu;

	QPopupMenu *printTools = new QPopupMenu;
  printTools->insertItem( "&Elemente", this, SLOT(slotPrint_Elements()) );
  printTools->insertItem( "&Logik Typen", this, SLOT(slotPrint_Logictype()) );
  printTools->insertItem( "&Syntax", this, SLOT(slotPrint_Syntax()) );
	printTools->insertItem( "&Drucker", this, SLOT(slotPrint_Printer()) );

  // menuBar entry Karteien_menu
  Karteien_menu = new QPopupMenu();
  Karteien_menu->insertItem( "&Debitor",  this, SLOT(slotKartei_Debitor()) );
  Karteien_menu->insertItem( "&Kreditor", this, SLOT(slotKartei_Kreditor()) );
  Karteien_menu->insertItem( "&Artikel", this, SLOT(slotKartei_Artikel()) );
  Karteien_menu->insertItem( "&Preisgruppe", this, SLOT(slotKartei_Preisgruppe()) );
  Karteien_menu->insertItem( "&Sachkonto", this, SLOT(slotKartei_Sachkonto()) );
  Karteien_menu->insertItem( "K&ontenplan", this, SLOT(slotKartei_Kontenplan()) );
  Karteien_menu->insertItem( "&Warengruppe", this, SLOT(slotKartei_Warengruppe()) );
  Karteien_menu->insertItem( "&Ressource", this, SLOT(slotKartei_Ressource()) );
  Karteien_menu->insertItem( "Proj&ekt", this, SLOT(slotKartei_Projekt()) );
  Karteien_menu->insertSeparator();
  Karteien_menu->insertItem("&Beenden",this,SLOT(slotFileQuit()),CTRL+Key_Q, ID_FILE_QUIT );

  // menuBar entry Erfassung_menu
  Erfassung_menu = new QPopupMenu();
  Erfassung_menu->insertItem( "&Allg. Erfassung", this, SLOT(slotErfassung_Allg_Erfassung()) );
  Erfassung_menu->insertItem( "&Warenerfassung", this, SLOT(slotErfassung_Warenerfassung()) );
  Erfassung_menu->insertItem( "&Zeiterfassung", this, SLOT(slotErfassung_Zeiterfassung()) );

  QPopupMenu *Verkauf_menu = new QPopupMenu();
  Verkauf_menu->insertItem( "A&ngebot", this, SLOT(slotVerkauf_Angebot()) );
  Verkauf_menu->insertItem( "&Auftrag", this, SLOT(slotVerkauf_Auftrag()) );
  Verkauf_menu->insertItem( "&Rechnung", this, SLOT(slotVerkauf_Rechnung()) );
  Verkauf_menu->insertItem( "&Gutschrift", this, SLOT(slotVerkauf_Gutschrift()) );
	Verkauf_menu->insertSeparator();
  Verkauf_menu->insertItem( "Ge&bucht", GebuchtVK );

  QPopupMenu *Einkauf_menu = new QPopupMenu();
  Einkauf_menu->insertItem( "A&nfrage", this, SLOT(slotEinkauf_Anfrage()) );
  Einkauf_menu->insertItem( "&Bestellung", this, SLOT(slotEinkauf_Bestellung()) );
  Einkauf_menu->insertItem( "&Rechnung", this, SLOT(slotEinkauf_Rechnung()) );
  Einkauf_menu->insertSeparator();
  Einkauf_menu->insertItem( "&Gebucht", GebuchtEK );

  QPopupMenu *Berichte_menu = new QPopupMenu();
	Berichte_menu->insertItem( "Berichte bearbeiten", reportGen );
  Berichte_menu->insertItem( "Debitor",  Bericht_Debitor );
  Berichte_menu->insertItem( "Kreditor",  Bericht_Kreditor);
  Berichte_menu->insertItem( "Lager",  Bericht_Lager);
  Berichte_menu->insertItem( "Sachkonto", Bericht_Sachkonto );
  Berichte_menu->insertItem( "Warengruppe",  Bericht_Warengruppe);
  Berichte_menu->insertItem( "Verkauf", Bericht_Verkauf);
  Berichte_menu->insertItem( "Einkauf", Bericht_Einkauf);
  Berichte_menu->insertItem( "Projekt", Bericht_Projekt);
  Berichte_menu->insertItem( "Intrastat", Bericht_Intrastat);

  QPopupMenu *Allgemein_menu = new QPopupMenu();
  Allgemein_menu->insertItem( "Anmeldung", this, SLOT(slotAllgemein_Anmeldung()) );
  Allgemein_menu->insertItem( "Buchhaltungsdaten", this, SLOT(slotAllgemein_Buchhaltungsdaten()) );
  Allgemein_menu->insertItem( "Firmendaten", this, SLOT(slotAllgemein_Firmendaten()) );
  Allgemein_menu->insertItem( "Debitorgruppe", this, SLOT(slotAllgemein_Debitorgruppe()) );
  Allgemein_menu->insertItem( "Kreditorgruppe", this, SLOT(slotAllgemein_Kreditorgruppe()) );
  Allgemein_menu->insertItem( "MwSt.-Code", this, SLOT(slotAllgemein_MwStCode()) );
  Allgemein_menu->insertItem( "Whrungscode", this, SLOT(slotAllgemein_Wahrungscode()) );
  Allgemein_menu->insertItem( "Lndercode", this, SLOT(slotAllgemein_Landercode()) );
	Allgemein_menu->insertItem( "Sprache", this, SLOT(slotAllgemein_Sprache()) );
	Allgemein_menu->insertItem( "Zahlungsbedingung", this, SLOT(slotAllgemein_Zahlungsbedingung()) );
	Allgemein_menu->insertItem( "Projektstatus", this, SLOT(slotAllgemein_Projektstatus()) );
	Allgemein_menu->insertItem( "Lieferung", this, SLOT(slotAllgemein_Lieferung()) );
	Allgemein_menu->insertItem( "Lokation", this, SLOT(slotAllgemein_Lokation()) );
	Allgemein_menu->insertItem( "Verkufer", this, SLOT(slotAllgemein_Vertreter()) );
	Allgemein_menu->insertItem( "Preisgruppe", this, SLOT(slotAllgemein_Preisgruppe()) );
  Allgemein_menu->insertItem( "Buchungsgruppen", Buchungsgruppen );
  Allgemein_menu->insertItem( "Intrastat", Intrastat );
  Allgemein_menu->insertItem( "Administration", Administration );

	Buchungsgruppen->insertItem( "Debitor Buchungsgruppe", this, SLOT(slotAllg_BuchGr_Deb_Buch_Gruppe()) );
	Buchungsgruppen->insertItem( "Kreditor Buchungsgruppe", this, SLOT(slotAllg_BuchGr_Kred_Buch_Gruppe()) );
	Buchungsgruppen->insertItem( "Warenbuchungsgruppe", this, SLOT(slotAllg_BuchGr_Warenbuch_Gruppe()) );
	Buchungsgruppen->insertItem( "Res.-Buchungsgruppe", this, SLOT(slotAllg_BuchGr_ResBuch_Gruppe()) );

	Intrastat->insertItem( "Bundesland", this, SLOT(slotAllg_Intra_Bundesland()) );
	Intrastat->insertItem( "Art des Geschftes", this, SLOT(slotAllg_Intra_Art_des_Geschaeftes()) );
	Intrastat->insertItem( "Verkehrszweig", this, SLOT(slotAllg_Intra_Verkehrszweig()) );
	Intrastat->insertItem( "Warenverzeichnis", this, SLOT(slotAllg_Intra_Warenverzeichnis()) );
	Intrastat->insertItem( "Hafen", this, SLOT(slotAllg_Intra_Hafen()) );
	Intrastat->insertItem( "Verfahren", this, SLOT(slotAllg_Intra_Verfahren()) );
	Intrastat->insertItem( "Sitz des Versenders", this, SLOT(slotAllg_Intra_Sitz_des_Versenders()) );
	Intrastat->insertItem( "Sitz des Empfngers", this, SLOT(slotAllg_Intra_Sitz_des_Empfaengers()) );

  Administration->insertItem( "Buchungsart", this, SLOT(slotAllgemein_Buchungsart()) );
  Administration->insertItem( "Einheit", this, SLOT(slotAllgemein_Einheit()) );
  Administration->insertItem( "Kontoart", this, SLOT(slotAllgemein_Kontoart()) );
  Administration->insertItem( "Sachkontoart", this, SLOT(slotAllgemein_Sachkontoart()) );
	Administration->insertItem( "G.u.V./Bilanz", this, SLOT(slotAllg_Admin_GuV_Bilanz()) );
	Administration->insertItem( "Soll/Haben", this, SLOT(slotAllg_Admin_Soll_Haben()) );
	Administration->insertItem( "UVA-Typ", this, SLOT(slotAllg_Admin_UVA_Typ()) );
	Administration->insertItem( "Rech.-Rund.-Methode", this, SLOT(slotAllg_Admin_Rech_Rund_Methode()) );
	Administration->insertItem( "Warenpostenart", this, SLOT(slotAllg_Admin_Warenpostenart()) );
	Administration->insertItem( "Belegart Einkauf", this, SLOT(slotAllg_Admin_Belegart_EK()) );
	Administration->insertItem( "Belegart Verkauf", this, SLOT(slotAllg_Admin_Belegart_VK()) );
	Administration->insertItem( "Zeilenart", this, SLOT(slotAllg_Admin_Zeileart()) );
	Administration->insertItem( "Ressourcenart", this, SLOT(slotAllg_Admin_Ressourceart()) );
	Administration->insertItem( "Res.-Posten-Art", this, SLOT(slotAllg_Admin_Res_Posten_Art()) );
	Administration->insertItem( "Projektpostenart", this, SLOT(slotAllg_Admin_Projektpostenart()) );
	Administration->insertItem( "IntraStat-Art", this, SLOT(slotAllg_Admin_Intra_Art()) );
  Administration->insertItem( "Drucksystem", printTools );

	GebuchtVK->insertItem( "&Lieferschein", this, SLOT(slotGebuchtVK_Lieferschein()) );
	GebuchtVK->insertItem( "&Rechnung", this, SLOT(slotGebuchtVK_Rechnung()) );
	GebuchtVK->insertItem( "&Gutschrift", this, SLOT(slotGebuchtVK_Gutschrift()) );
	GebuchtVK->insertItem( "&Mahnung", this, SLOT(slotGebuchtVK_Mahnung()) );

	GebuchtEK->insertItem( "&Lieferschein", this, SLOT(slotGebuchtEK_Lieferschein()) );
	GebuchtEK->insertItem( "&Rechnung", this, SLOT(slotGebuchtEK_Rechnung()) );
	GebuchtEK->insertItem( "&Gutschrift", this, SLOT(slotGebuchtEK_Gutschrift()) );

	reportGen->insertItem( "Datei-&Import", this, SLOT(slotBericht_Rep_ImportTex()) );
	reportGen->insertItem( "Bericht &bearbeiten", this, SLOT(slotBericht_Rep_EditReport()) );
	reportGen->insertItem( "Bericht &drucken", this, SLOT(slotBericht_Rep_PrintRep()) );

  // menuBar entry view_menu
  view_menu = new QPopupMenu();
  view_menu->setCheckable(true);
  view_menu->insertItem("Tool&bar",this,SLOT(slotViewToolBar()),0, ID_VIEW_TOOLBAR);
  view_menu->insertItem("&Statusbar",this,SLOT(slotViewStatusBar()),0, ID_VIEW_STATUSBAR );

  view_menu->setItemChecked(ID_VIEW_TOOLBAR, true);
  view_menu->setItemChecked(ID_VIEW_STATUSBAR,true);

  // menuBar entry help_menu
  help_menu = new QPopupMenu();
  help_menu->insertItem("ber...",this,SLOT(slotHelpAbout()),0,ID_HELP_ABOUT);

  // MENUBAR CONFIGURATION
  // set menuBar() the current menuBar 
  menuBar()->insertItem("&Karteien", Karteien_menu);
  menuBar()->insertItem("&Erfassung", Erfassung_menu);
  menuBar()->insertItem("&Verkauf", Verkauf_menu);
  menuBar()->insertItem("Ei&nkauf", Einkauf_menu);
  menuBar()->insertItem("&Berichte", Berichte_menu);
  menuBar()->insertItem("&Allgemein", Allgemein_menu);
  menuBar()->insertItem("An&sicht", view_menu);
  menuBar()->insertSeparator();
  menuBar()->insertItem("&Hilfe", help_menu);
  
  // CONNECT THE SUBMENU SLOTS WITH SIGNALS
  connect(Karteien_menu,SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
  connect(Erfassung_menu,SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
  connect(Verkauf_menu,SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
  connect(Einkauf_menu,SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
  connect(Berichte_menu,SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
  connect(Allgemein_menu,SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
  connect(view_menu,SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
  connect(help_menu,SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
}

void QtTudoApp::initToolBar()
{
	QPixmap DebitorIcon;
	QPixmap KreditorIcon;

  // TOOLBAR
  toolbar = new QToolBar( this );
 
  toolbar->addSeparator();

	DebitorIcon = QPixmap( debitor_xpm );
	QToolButton *Debitor = new QToolButton( DebitorIcon, "Debitor",
												QString::null, this, SLOT(slotKartei_Debitor()), toolbar, "Debitor" );
	QWhatsThis::add( Debitor, "Debitor" );
	KreditorIcon = QPixmap( kreditor_xpm );
	QToolButton *Kreditor = new QToolButton( KreditorIcon, "Kreditor",
												QString::null, this, SLOT(slotKartei_Kreditor()), toolbar, "Kreditor" );
	QWhatsThis::add( Kreditor, "Kreditor" );

  (void)QWhatsThis::whatsThisButton( toolbar );

}

void QtTudoApp::initStatusBar()
{
  statusBar()->message( "Fertig", 2000 );
}

void QtTudoApp::initDoc(){
}

void QtTudoApp::initView()
{ 
}

bool QtTudoApp::queryExit()
{
	// Do we really need this ???
	//int exit=QMessageBox::information(this,"Beenden...","Wirklich beenden?",QMessageBox::Ok,QMessageBox::Cancel);

	//if(exit==1){
		// Remove the user-id from table 'benutzer'.
		SQLTable *t = new SQLTable( "DELETE FROM benutzer WHERE taskname ='" );
		t->sQuery.append( Taskname.copy() );
		t->sQuery.append( "'" );
		//QMessageBox::information( 0, "QtTudo Test", t->sQuery );
		t->execute();
		return true;
	//}
	//else{
	//	return false;
	//}
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void QtTudoApp::slotFileQuit()
{ 
  // exits the Application
	if (queryExit())
		qApp->quit();
}

void QtTudoApp::slotViewToolBar()
{
  // turn Toolbar on or off
  if ( toolbar->isVisible() ) {
    toolbar->hide();
    view_menu->setItemChecked( ID_VIEW_TOOLBAR, false);
  } 
  else {
    toolbar->show();
    view_menu->setItemChecked( ID_VIEW_TOOLBAR, true );
  }  
  statusBar()->message(IDS_DEFAULT);

}

void QtTudoApp::slotViewStatusBar()
{
  //turn Statusbar on or off
  if ( statusBar()->isVisible() ) {
    statusBar()->hide();
    view_menu->setItemChecked( ID_VIEW_STATUSBAR, false );
  }
  else {
    statusBar()->show();
    view_menu->setItemChecked( ID_VIEW_STATUSBAR, true );
  }
  
  statusBar()->message(IDS_DEFAULT);
}

void QtTudoApp::slotHelpAbout(){
  QMessageBox::about(this,"ber...", IDS_APP_ABOUT
		"\nWarenwirtschaft und Finanzbuchhaltung"
		"\n(c) 2000/2001 by Jrg Bemm");
}

void QtTudoApp::slotBericht_Sachkonto_Liste() {
	QString s;
	QStringList list;

	if (print != 0) {
		s = "SELECT * FROM sachkonto ORDER BY nummer";
		list << s; // add to list

		print->reportGenerator( "Sachkonto-Liste", &list );
	}
}

void QtTudoApp::slotBericht_Sachkonto_GuV() {
	QString s;
	QStringList list;

	if (print != 0) {
		s = "SELECT * FROM sachkonto ORDER BY nummer";
		list << s; // add to list
		s = "SELECT * FROM sachposten ORDER BY lfd_nr";
		list << s; // add to list

		print->reportGenerator( "GuV", &list );
	}
}

void QtTudoApp::slotBericht_Sachkonto_GuV_Stichtag() {

}

void QtTudoApp::slotKartei_Debitor() {
	if (sql.conn == 0) {
		delete debitor;
		debitor = 0;
	}
  if (!debitor) {
		debitor = new Kartei_Debitor( 0, 0, &sql );
	  debitor->setCaption( ProgName->copy() + "Debitor" );
  }
	debitor->show();
}

void QtTudoApp::slotKartei_Kreditor() {
  if (!kreditor) {
		kreditor = new Kartei_Kreditor( 0, 0, &sql );
	  kreditor->setCaption( ProgName->copy() + "Kreditor" );
  }
	kreditor->show();
}

void QtTudoApp::slotKartei_Artikel() {
  if (!artikel) {
		artikel = new Kartei_Artikel( 0, 0, &sql );
	  artikel->setCaption( ProgName->copy() + "Artikel" );
  }
	artikel->show();
}

void QtTudoApp::slotKartei_Preisgruppe() {

}

void QtTudoApp::slotKartei_Sachkonto() {
  if (!sachkonto) {
		sachkonto = new Kartei_Sachkonto( 0, 0, &sql );
	  sachkonto->setCaption( ProgName->copy() + "Sachkonto" );
  }
	sachkonto->show();
}

// Der Kontenplan ist ein vernderbare Tabelle der Sachkonten
void QtTudoApp::slotKartei_Kontenplan() {
	if (kontenplan == 0) {
		SQLTable *table =
			new SQLTable( "select nummer,name,kontoart,guv_bilanz,einrueckung,"
			"mwst_code,soll_haben from sachkonto order by nummer",
			"nummer" );
		kontenplan = new Kartei_Kontenplan( 0, 0, &sql, table, "sachkonto" );
	  kontenplan->setCaption( ProgName->copy() + "Kontenplan" );
  }
	if (kontenplan != 0)
		kontenplan->show();
}

void QtTudoApp::slotKartei_Warengruppe() {

}

void QtTudoApp::slotKartei_Ressource() {
  if (!ressource) {
		ressource = new QDBDialog( 0, 0, &sql, true, "select * from ressource",
															"nummer", "ressource" );
	  ressource->setCaption( ProgName->copy() + "Ressource" );
  }
	ressource->show();
}

void QtTudoApp::slotKartei_Projekt() {

}

void QtTudoApp::slotErfassung_Allg_Erfassung() {
	if (allg_erfassung == 0) {
		SQLTable *table =
			new SQLTable( "SELECT kladdenname,lfd_nr,kontoart,kontonr,datum,art,belegnr,text,mwst_code,"
				"gegenkonto,waehrungscode,betrag,mw,buch_gr,belegdatum,spur"
				" FROM kassenkladdenzeile WHERE kladdenname>='Standard'"
				" ORDER BY kladdenname,lfd_nr", "kladdenname,lfd_nr" );
		allg_erfassung = new Erfassung_Allg_Erfassung( 0, 0, &sql, table, "kassenkladdenzeile" );
	  allg_erfassung->setCaption( ProgName->copy() + "Allg. Erfassung" );
  }
	if (allg_erfassung != 0)
		allg_erfassung->show();
}

void QtTudoApp::slotErfassung_Warenerfassung() {
	if (warenerfassung == 0) {
		SQLTable *table =
			new SQLTable( "select * from warenkladdenzeile where kladdenname='Standard'"
				" order by kladdenname,lfd_nr", "kladdenname,lfd_nr" );
		warenerfassung = new Erfassung_Warenerfassung( 0, 0, &sql, table, "warenkladdenzeile" );
	  warenerfassung->setCaption( ProgName->copy() + "Warenerfassung" );
  }
	if (warenerfassung != 0)
		warenerfassung->show();
}

void QtTudoApp::slotErfassung_Zeiterfassung() {
// 'killme' hat noch keine Funktion. Das kommt spter ...
// (Ist gedacht fr mehrfaches Dialog ffnen.)
//===============================================================

	if (zeiterfassung == 0) {
		SQLTable *table =
			new SQLTable( "select * from zeiterfassung", "kladdenname,lfd_nr" );
		zeiterfassung = new Erfassung_Zeiterfassung( 0, 0, &sql, table, "zeiterfassung" );
	  zeiterfassung->setCaption( ProgName->copy() + "Zeiterfassung" );
/*		if (!zeiterfassung->killMe)
  		zeiterfassung->setCaption( "Linux-Tudo Zeiterfassung" );
		else {
			delete zeiterfassung;
			zeiterfassung = 0;
			return;
		}*/
  }
	if (zeiterfassung != 0)
		zeiterfassung->show();
}

void QtTudoApp::slotVerkauf_Angebot() {

}

void QtTudoApp::slotVerkauf_Auftrag() {

}

void QtTudoApp::slotVerkauf_Rechnung() {
  if (!VKrechnung) {
		VKrechnung = new Verkauf_Rechnung( 0, 0, &sql );
	  VKrechnung->setCaption( ProgName->copy() + "Rechnung" );
  }
	VKrechnung->show();
}

void QtTudoApp::slotVerkauf_Gutschrift() {
  if (!VKgutschrift) {
		VKgutschrift = new Verkauf_Gutschrift( 0, 0, &sql );
	  VKgutschrift->setCaption( ProgName->copy() + "Gutschrift" );
  }
	VKgutschrift->show();
}

void QtTudoApp::slotGebuchtVK_Lieferschein() {

}

void QtTudoApp::slotGebuchtVK_Rechnung() {
  if (!gebVKrechnung) {
		gebVKrechnung = new Verkauf_GebRechnung( 0, 0, &sql, print );
	  gebVKrechnung->setCaption( ProgName->copy() + "Geb. Verkaufsrechnung" );
  }
	gebVKrechnung->show();
}

void QtTudoApp::slotGebuchtVK_Gutschrift() {
  if (!gebVKgutschrift) {
		gebVKgutschrift = new Verkauf_GebGutschrift( 0, 0, &sql, print );
	  gebVKgutschrift->setCaption( ProgName->copy() + "Geb. Verkaufsgutschrift" );
  }
	gebVKgutschrift->show();
}

void QtTudoApp::slotGebuchtVK_Mahnung() {

}

void QtTudoApp::slotEinkauf_Anfrage() {

}

void QtTudoApp::slotEinkauf_Bestellung() {

}

void QtTudoApp::slotEinkauf_Rechnung() {

}

void QtTudoApp::slotGebuchtEK_Lieferschein() {

}

void QtTudoApp::slotGebuchtEK_Rechnung() {

}

void QtTudoApp::slotGebuchtEK_Gutschrift() {

}

void QtTudoApp::slotAllgemein_Anmeldung() {
 	Allgemein_Anmeldung *anmeldung =
		new Allgemein_Anmeldung( 0, 0, &Benutzer, false, ProgName );
  anmeldung->show();
}

void QtTudoApp::slotAllgemein_Buchhaltungsdaten() {
  if (!buchhaltungsdaten) {
		buchhaltungsdaten = new QDBDialog( 0, 0, &sql, true, "select * from buchhaltungsdaten",
																			"", "buchhaltungsdaten" );
	  buchhaltungsdaten->setCaption( ProgName->copy() + "Buchhaltungsdaten" );
  }
	buchhaltungsdaten->show();
}

void QtTudoApp::slotAllgemein_Buchungsart() {
  if (!buchungsart) {
		buchungsart = new QDBDialog( 0, 0, &sql, true,
																	"select * from buchungsart",
																	"buchungsart", "buchungsart" );
	  buchungsart->setCaption( ProgName->copy() + "Buchungsart" );
  }
	buchungsart->show();
}

void QtTudoApp::slotAllgemein_Einheit() {
  if (!einheit) {
		einheit = new QDBDialog( 0, 0, &sql, true,
																	"select * from einheit", "einheit", "einheit" );
	  einheit->setCaption( ProgName->copy() + "Einheit" );
  }
	einheit->show();
}

void QtTudoApp::slotAllgemein_Firmendaten() {
  if (!firmendaten) {
		// if the parameter for the PrimaryKey is empty, it is not
		// possible to delete a record. We don't want to delete
		// the office data (firmendaten).
		firmendaten = new QDBDialog( 0, 0, &sql, true,
																	"select * from firmendaten", "", "firmendaten" );
	  firmendaten->setCaption( ProgName->copy() + "Firmendaten" );
  }
	firmendaten->show();
}

void QtTudoApp::slotAllgemein_Kontoart() {
  if (!kontoart) {
		kontoart = new QDBDialog( 0, 0, &sql, true,
																	"select * from kontoart", "kontoart", "kontoart" );
	  kontoart->setCaption( ProgName->copy() + "Kontoart" );
  }
	kontoart->show();
}

void QtTudoApp::slotAllgemein_Sachkontoart() {
  if (!sachkontoart) {
		sachkontoart = new QDBDialog( 0, 0, &sql, true,
																	"select * from sachkontoart",
																	"sachkontoart", "sachkontoart" );
	  sachkontoart->setCaption( ProgName->copy() + "Sachkontoart" );
  }
	sachkontoart->show();
}

void QtTudoApp::slotAllgemein_Debitorgruppe() {
  if (!debitorgruppe) {
		debitorgruppe = new QDBDialog( 0, 0, &sql, true,
																	"select * from kundengruppe", "kundengruppe", "kundengruppe" );
	  debitorgruppe->setCaption( ProgName->copy() + "Kundengruppe" );
  }
	debitorgruppe->show();
}

void QtTudoApp::slotAllgemein_Kreditorgruppe() {
  if (!kreditorgruppe) {
		kreditorgruppe = new QDBDialog( 0, 0, &sql, true,
																	"select * from lieferantengruppe",
																	"lieferantengruppe", "lieferantengruppe" );
	  kreditorgruppe->setCaption( ProgName->copy() + "Lieferantengruppe" );
  }
	kreditorgruppe->show();
}

void QtTudoApp::slotAllgemein_MwStCode() {
  if (!mwst) {
		mwst = new QDBDialog( 0, 0, &sql, true,
																	"select * from mwst", "code", "mwst" );
	  mwst->setCaption( ProgName->copy() + "MwSt.-Code" );
  }
	mwst->show();
}

void QtTudoApp::slotAllgemein_Wahrungscode() {
  if (!waehrung) {
		waehrung = new QDBDialog( 0, 0, &sql, true,
																	"select * from waehrung", "code", "waehrung" );
	  waehrung->setCaption( ProgName->copy() + "Whrungscode" );
  }
	waehrung->show();
}

void QtTudoApp::slotAllgemein_Landercode() {
  if (!land) {
		land = new QDBDialog( 0, 0, &sql, true,
																	"select * from land", "code", "land" );
	  land->setCaption( ProgName->copy() + "Lndercode" );
  }
	land->show();
}

void QtTudoApp::slotAllg_Admin_GuV_Bilanz() {
	if (!guv_bilanz) {
		SQLTable *table =
			new SQLTable( "select * from guv_bilanz", "guv_bilanz" );
		guv_bilanz = new QDBTableEdit( 0, 0, &sql, table,
																	statusBar(), "guv_bilanz" );
	  guv_bilanz->setCaption( ProgName->copy() + "G.u.V./Bilanz" );
	}
	guv_bilanz->show();
}

void QtTudoApp::slotAllg_Admin_Soll_Haben() {
	if (!soll_haben) {
		SQLTable *table =
			new SQLTable( "select * from soll_haben", "soll_haben" );
		soll_haben = new QDBTableEdit( 0, 0, &sql, table,
																	statusBar(), "soll_haben" );
	  soll_haben->setCaption( ProgName->copy() + "Soll/Haben" );
	}
	soll_haben->show();
}

void QtTudoApp::slotAllg_Admin_UVA_Typ() {
	if (!uva_typ) {
		SQLTable *table =
			new SQLTable( "select * from uva_typ", "uva_typ" );
		uva_typ = new QDBTableEdit( 0, 0, &sql, table,
																	statusBar(), "uva_typ" );
	  uva_typ->setCaption( ProgName->copy() + "UVA-Typ" );
	}
	uva_typ->show();
}

void QtTudoApp::slotAllg_Admin_Rech_Rund_Methode() {
	if (!rech_rund_methode) {
		SQLTable *table =
			new SQLTable( "select * from rech_rund_methode", "rech_rund_methode" );
		rech_rund_methode = new QDBTableEdit( 0, 0, &sql, table,
																	statusBar(), "rech_rund_methode" );
	  rech_rund_methode->setCaption( ProgName->copy() + "Rech.-Rund.-Methode" );
	}
	rech_rund_methode->show();
}

void QtTudoApp::slotAllg_Admin_Warenpostenart() {
	if (!warenpostenart) {
		SQLTable *table =
			new SQLTable( "select * from warenpostenart", "art" );
		warenpostenart = new QDBTableEdit( 0, 0, &sql, table,
																	statusBar(), "warenpostenart" );
	  warenpostenart->setCaption( ProgName->copy() + "Warenpostenart" );
	}
	warenpostenart->show();
}

void QtTudoApp::slotAllg_Admin_Belegart_EK() {
	if (!belegart_ek) {
		SQLTable *table =
			new SQLTable( "select * from belegart_ek", "belegart" );
		belegart_ek = new QDBTableEdit( 0, 0, &sql, table,
																	statusBar(), "belegart_ek" );
	  belegart_ek->setCaption( ProgName->copy() + "Belegart Einkauf" );
	}
	belegart_ek->show();
}

void QtTudoApp::slotAllg_Admin_Belegart_VK() {
	if (!belegart_vk) {
		SQLTable *table =
			new SQLTable( "select * from belegart_vk", "belegart" );
		belegart_vk = new QDBTableEdit( 0, 0, &sql, table,
																	statusBar(), "belegart_vk" );
	  belegart_vk->setCaption( ProgName->copy() + "Belegart Verkauf" );
	}
	belegart_vk->show();
}

void QtTudoApp::slotAllg_Admin_Zeileart() {
	if (!zeilenart) {
		SQLTable *table =
			new SQLTable( "select * from zeilenart", "art" );
		zeilenart = new QDBTableEdit( 0, 0, &sql, table,
																	statusBar(), "zeilenart", false );
	  zeilenart->setCaption( ProgName->copy() + "Zeilenart" );

		zeilenart->colName[table->fNumber("art")]->append( "Art" );
		zeilenart->colSize[table->fNumber("art")] = 100;

		zeilenart->makeVisible( table->fNumber("art") );
		zeilenart->addCol( table->fNumber("art") );
		zeilenart->update();
	}
	zeilenart->show();
}

void QtTudoApp::slotAllg_Admin_Ressourceart() {
	if (!ressourceart) {
		SQLTable *table =
			new SQLTable( "select * from ressourceart", "art" );
		ressourceart = new QDBTableEdit( 0, 0, &sql, table,
																	statusBar(), "ressourceart" );
	  ressourceart->setCaption( ProgName->copy() + "Ressource-Art" );
	}
	ressourceart->show();
}

void QtTudoApp::slotAllg_Admin_Res_Posten_Art() {
	if (!res_posten_art) {
		SQLTable *table =
			new SQLTable( "select * from res_posten_art", "art" );
		res_posten_art = new QDBTableEdit( 0, 0, &sql, table,
																	statusBar(), "res_posten_art" );
	  res_posten_art->setCaption( ProgName->copy() + "Res.-Posten-Art" );
	}
	res_posten_art->show();
}

void QtTudoApp::slotAllg_Admin_Projektpostenart() {
	if (!projektpostenart) {
		SQLTable *table =
			new SQLTable( "select * from projektpostenart", "art" );
		projektpostenart = new QDBTableEdit( 0, 0, &sql, table,
																	statusBar(), "projektpostenart" );
	  projektpostenart->setCaption( ProgName->copy() + "projektpostenart" );
	}
	projektpostenart->show();
}

void QtTudoApp::slotAllg_Admin_Intra_Art() {
	if (!intra_art) {
		SQLTable *table =
			new SQLTable( "select * from intra_art", "art" );
		intra_art = new QDBTableEdit( 0, 0, &sql, table,
																	statusBar(), "intra_art" );
	  intra_art->setCaption( ProgName->copy() + "Intrastat-Art" );
	}
	intra_art->show();
}

void QtTudoApp::slotAllgemein_Sprache() {
	if (!sprache) {
		SQLTable *table =
			new SQLTable( "select * from sprache", "code" );
		sprache = new QDBErfassung( 0, 0, &sql, table, "sprache" );
	  sprache->setCaption( ProgName->copy() + "Sprache" );
	}
	sprache->show();
}

void QtTudoApp::slotAllgemein_Lokation() {
	if (!lokation) {
		SQLTable *table =
			new SQLTable( "select * from lokation", "code" );
		lokation = new QDBErfassung( 0, 0, &sql, table, "lokation" );
	  lokation->setCaption( ProgName->copy() + "Lokation" );
	}
	lokation->show();
}

void QtTudoApp::slotAllgemein_Zahlungsbedingung() {
	if (!zahlungsbedingung) {
		SQLTable *table =
			new SQLTable( "select * from zahlungsbedingung", "code" );
		zahlungsbedingung = new QDBErfassung( 0, 0, &sql, table, "zahlungsbedingung" );
	  zahlungsbedingung->setCaption( ProgName->copy() + "Zahlungsbedingung" );
	}
	zahlungsbedingung->show();
}

void QtTudoApp::slotAllgemein_Projektstatus() {
	if (!projektstatus) {
		SQLTable *table =
			new SQLTable( "select * from projektstatus", "status" );
		projektstatus = new QDBErfassung( 0, 0, &sql, table, "projektstatus" );
	  projektstatus->setCaption( ProgName->copy() + "Projektstatus" );
	}
	projektstatus->show();
}

void QtTudoApp::slotAllg_Intra_Bundesland() {
	if (!bundesland) {
		SQLTable *table =
			new SQLTable( "select * from bundesland", "code" );
		bundesland = new QDBErfassung( 0, 0, &sql, table, "bundesland" );
	  bundesland->setCaption( ProgName->copy() + "Bundesland" );
	}
	bundesland->show();
}

void QtTudoApp::slotAllg_Intra_Art_des_Geschaeftes() {
	if (!art_des_geschaeftes) {
		SQLTable *table =
			new SQLTable( "select * from art_des_geschaeftes", "code" );
		art_des_geschaeftes = new QDBErfassung( 0, 0, &sql, table, "art_des_geschaeftes" );
	  art_des_geschaeftes->setCaption( ProgName->copy() + "Art des Geschftes" );
	}
	art_des_geschaeftes->show();
}

void QtTudoApp::slotAllg_Intra_Verkehrszweig() {
	if (!verkehrszweig) {
		SQLTable *table =
			new SQLTable( "select * from verkehrszweig", "code" );
		verkehrszweig = new QDBErfassung( 0, 0, &sql, table, "verkehrszweig" );
	  verkehrszweig->setCaption( ProgName->copy() + "Verkehrszweig" );
	}
	verkehrszweig->show();
}

void QtTudoApp::slotAllg_Intra_Warenverzeichnis() {
	if (!warenverzeichnis) {
		SQLTable *table =
			new SQLTable( "select * from warenverzeichnis", "nummer" );
		warenverzeichnis = new QDBErfassung( 0, 0, &sql, table, "warenverzeichnis" );
	  warenverzeichnis->setCaption( ProgName->copy() + "Warenverzeichnis" );
	}
	warenverzeichnis->show();
}

void QtTudoApp::slotAllg_Intra_Hafen() {
	if (!hafen) {
		SQLTable *table =
			new SQLTable( "select * from hafen", "code" );
		hafen = new QDBErfassung( 0, 0, &sql, table, "hafen" );
	  hafen->setCaption( ProgName->copy() + "Hafen" );
	}
	hafen->show();
}

void QtTudoApp::slotAllg_Intra_Verfahren() {
	if (!verfahren) {
		SQLTable *table =
			new SQLTable( "select * from verfahren", "code" );
		verfahren = new QDBErfassung( 0, 0, &sql, table, "verfahren" );
	  verfahren->setCaption( ProgName->copy() + "verfahren" );
	}
	verfahren->show();
}

void QtTudoApp::slotAllg_Intra_Sitz_des_Versenders() {
	if (!sitz_des_versenders) {
		SQLTable *table =
			new SQLTable( "select * from sitz_des_versenders", "code" );
		sitz_des_versenders = new QDBErfassung( 0, 0, &sql, table, "sitz_des_versenders" );
	  sitz_des_versenders->setCaption( ProgName->copy() + "Sitz des Versenders" );
	}
	sitz_des_versenders->show();
}

void QtTudoApp::slotAllg_Intra_Sitz_des_Empfaengers() {
	if (!sitz_des_empfaengers) {
		SQLTable *table =
			new SQLTable( "select * from sitz_des_empfaengers", "code" );
		sitz_des_empfaengers = new QDBErfassung( 0, 0, &sql, table, "sitz_des_empfaengers" );
	  sitz_des_empfaengers->setCaption( ProgName->copy() + "Sitz des Empfngers" );
	}
	sitz_des_empfaengers->show();
}

void QtTudoApp::slotAllgemein_Lieferung() {
	if (!lieferung) {
		SQLTable *table =
			new SQLTable( "select * from lieferung", "code" );
		lieferung = new QDBErfassung( 0, 0, &sql, table, "lieferung" );
	  lieferung->setCaption( ProgName->copy() + "Lieferung" );
	}
	lieferung->show();
}

void QtTudoApp::slotAllgemein_Vertreter() {
	if (!vertreter) {
		SQLTable *table =
			new SQLTable( "select * from verkaeufer", "code" );
		vertreter = new QDBErfassung( 0, 0, &sql, table, "verkaeufer" );
	  vertreter->setCaption( ProgName->copy() + "Verkufer" );
	}
	vertreter->show();
}

void QtTudoApp::slotAllgemein_Preisgruppe() {
	if (!preisgruppe) {
		SQLTable *table =
			new SQLTable( "select * from preisgruppe", "nummer" );
		preisgruppe = new QDBErfassung( 0, 0, &sql, table, "preisgruppe" );
	  preisgruppe->setCaption( ProgName->copy() + "Preisgruppe" );
	}
	preisgruppe->show();
}

void QtTudoApp::slotAllg_BuchGr_Deb_Buch_Gruppe() {
	if (!deb_buch_gruppe) {
		SQLTable *table =
			new SQLTable( "select * from deb_buch_gruppe", "code" );
		deb_buch_gruppe = new QDBErfassung( 0, 0, &sql, table, "deb_buch_gruppe" );
	  deb_buch_gruppe->setCaption( ProgName->copy() + "Deb.-Buch.-Gruppe" );
	}
	deb_buch_gruppe->show();
}

void QtTudoApp::slotAllg_BuchGr_Kred_Buch_Gruppe() {
	if (!kred_buch_gruppe) {
		SQLTable *table =
			new SQLTable( "select * from kred_buch_gruppe", "code" );
		kred_buch_gruppe = new QDBErfassung( 0, 0, &sql, table, "kred_buch_gruppe" );
	  kred_buch_gruppe->setCaption( ProgName->copy() + "Kred.-Buch.-Gruppe" );
	}
	kred_buch_gruppe->show();
}

void QtTudoApp::slotAllg_BuchGr_Warenbuch_Gruppe() {
	if (!warenbuch_gruppe) {
		SQLTable *table =
			new SQLTable( "select * from warenbuch_gruppe", "code" );
		warenbuch_gruppe = new QDBErfassung( 0, 0, &sql, table, "warenbuch_gruppe" );
	  warenbuch_gruppe->setCaption( ProgName->copy() + "Warenbuchungsgruppe" );
	}
	warenbuch_gruppe->show();
}

void QtTudoApp::slotAllg_BuchGr_ResBuch_Gruppe() {
	if (!resbuch_gruppe) {
		SQLTable *table =
			new SQLTable( "select * from res_buch_gruppe", "code" );
		resbuch_gruppe = new QDBErfassung( 0, 0, &sql, table, "res_buch_gruppe" );
	  resbuch_gruppe->setCaption( ProgName->copy() + "Ressourcebuchungsgruppe" );
	}
	resbuch_gruppe->show();
}

void QtTudoApp::slotBericht_Rep_ImportTex()
{
	print->importTexFile();
}

void QtTudoApp::slotBericht_Rep_PrintRep()
{
	print->printReport();
}

void QtTudoApp::slotBericht_Rep_EditReport()
{
	print->editReport();
}

void QtTudoApp::slotPrint_Elements()
{
	if (!printElements) {
		SQLTable *table =
			new SQLTable( "select * from print_elements", "art" );
		printElements = new QDBErfassung( 0, 0, &sql, table, "print_elements" );
	  printElements->setCaption( ProgName->copy() + "Druckelemente" );
	}
	printElements->show();
}

void QtTudoApp::slotPrint_Logictype()
{
	if (!printLogictype) {
		SQLTable *table =
			new SQLTable( "select * from print_logictype", "type" );
		printLogictype = new QDBErfassung( 0, 0, &sql, table, "print_logictype" );
	  printLogictype->setCaption( ProgName->copy() + "Drucklogiktypen" );
	}
	printLogictype->show();
}

void QtTudoApp::slotPrint_Printer()
{
	if (!printPrinter) {
		SQLTable *table =
			new SQLTable( "select * from printer", "name" );
		printPrinter = new QDBErfassung( 0, 0, &sql, table, "printer" );
	  printPrinter->setCaption( ProgName->copy() + "Drucker" );
	}
	printPrinter->show();
}

void QtTudoApp::slotPrint_Syntax()
{
	if (!printSyntax) {
		SQLTable *table =
			new SQLTable( "select * from print_syntax", "language" );
		printSyntax = new QDBErfassung( 0, 0, &sql, table, "print_syntax" );
	  printSyntax->setCaption( ProgName->copy() + "Drucksyntax" );
	}
	printSyntax->show();
}

//====================================================================================

void QtTudoApp::slotStatusHelpMsg(const char *text)
{
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}

void QtTudoApp::statusCallback(int id_){
  switch (id_) {
    
  case ID_FILE_QUIT       :  slotStatusHelpMsg("Beendet das Programm");break;
  case ID_VIEW_TOOLBAR    :  slotStatusHelpMsg("Aktuelle Toolbar ein-/ausschalten");break;
  case ID_VIEW_STATUSBAR  :  slotStatusHelpMsg("Statusbar ein-/ausschalten");break;
  case ID_HELP_ABOUT      :  slotStatusHelpMsg("Informationen zum Programm");break;
  }
}
