/***************************************************************************
                          buchen.cpp  -  description
                             -------------------
    begin                : Wed Jul 26 2000
    version              : $Id: buchen.cpp,v 1.26 2001/03/14 13:59:04 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : info@bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <time.h>

#include <qmessagebox.h>

#include "buchen.h"

Buchen::Buchen( SQLQuerier *sql_ptr, SQLTable *tableKopf, SQLTable *tableZeile )
{
	sql = sql_ptr;
	table = tableKopf; // kassenkladdenzeile, verkaufskopf, einkaufskopf
	tablePositions = tableZeile;
	tableTA = new SQLTable();
	NoSP = "";
	NoDP = "";
	NoKP = "";
}

Buchen::~Buchen(){
}

// Accounting from erfassung_allg_erfassung
bool Buchen::makeAccountErfassung()
{
	int nTuples, noTuples;
	QString s;
	QString tableName = "kassenkladdenzeile";
	QString valBetrag, valMw;
	bool ok = true;

	if ((sql==0)||(table==0))
		return false;

	NoSP = "";
	NoDP = "";
	NoKP = "";
	noTuples = table->getnTuples();

	// Reserve allways 3 numbers for tuples of sachposten.
	// Important: Don't do this inside the transaction,
	// because another user can get the same numbers.
	// The numbers must be unique.
	sql->getLfdNr( "interne_daten", &NoSP, "sachposten_nr", 3 * noTuples);

	for ( nTuples = 0; nTuples < table->getnTuples(); nTuples++ )
	{
		// The sign of the values can not be different and not 0.
		valBetrag = table->getValue( nTuples, "betrag" );
		valMw = table->getValue( nTuples, "mw" );
		if ((valBetrag.toDouble() == 0) || ( valMw.toDouble() == 0) ||
				((valBetrag.toDouble() > 0) && (valMw.toDouble() < 0)) ||
				((valBetrag.toDouble() < 0) && (valMw.toDouble() > 0)))
		{
			QMessageBox::warning( 0, "QtTudo Vorzeichenfehler",
				"Der Betrag ist entweder Null oder hat ein\n"
				"unterschiedliches Vorzeichen zur Mandantenwhrung (MW).\n"
				"Das ist nicht erlaubt." );
			return false;
		}

		s = table->getValue( nTuples, "kontoart" ); // get the 'kontoart'

		if (s.find("Debitor") != -1)
			sql->getLfdNr( "interne_daten", &NoDP, "debitorposten_nr", 1);

		if (s.find("Kreditor") != -1)
			sql->getLfdNr( "interne_daten", &NoKP, "kreditorposten_nr", 1);
	}

	// begin transaction
	tableTA->sQuery = "BEGIN TRANSACTION";
	if ( tableTA->execute() != SUCCESS_NO_RESULTS ) {
		QMessageBox::warning( 0, "QtTudo Transaktion Start", tableTA->ErrorText );
		return false;
	}

	// Now, we are booking the created tuples in buchen_intern.
	// loop through all selected tuples from buchen_intern
	for ( nTuples = 0; nTuples < table->getnTuples(); nTuples++ )
	{
		s = table->getValue( nTuples, "kontoart" ); // get the 'kontoart'

		// Which kind of 'kontoart' (Sachkonto, Debitor or Kreditor) is it?
		if (s.find("Sachkonto") != -1)
			if (!KontoartSachkonto( nTuples,
					table->getValue( nTuples, "kontonr" ) ))
				ok = false;
		if (s.find("Debitor") != -1)
			if (!KontoartDebitor( nTuples ))
				ok = false;
		if (s.find("Kreditor") != -1)
			if (!KontoartKreditor( nTuples ))
				ok = false;

		if (!ok)
			return rollback();
		else
			// delete tuple
			deleteTuple( nTuples, &tableName );
	} // loop through all selected tuples

	// end transaction
	tableTA->sQuery = "COMMIT";
	if ( tableTA->execute() != SUCCESS_NO_RESULTS )
		return rollback();

	return true;
}

// Account from debitor invoide, credit note, order (rechnung, gutschrift, auftrag)
//==================================================================================
// Parameter:
//-----------
// tablePositions =	positions of an invoice, credit note, order
//									-> table verkaufszeile
// Return:
//-----------
// true		-> transaction successfully
// false	-> transaction failed
//----------------------------------------------------------------------------------
// This function creates sachposten, debitorenposten
// and perhaps warenposten.
// The header of the invoice is in table (->verkaufskopf)
//
// If we comes from an invoice, we can't create
// the tuples in buchen_intern, because the VAT percent value per
// each invoice position can be different. So we have to check each
// line of an invoice.
//----------------------------------------------------------------------------------
bool Buchen::makeAccountVerkauf()
{
	typedef struct {
		QString mwCode;
		QString account;
		QString netto;
	} posten;
	posten *newSP; // a arry of net values (for each contrary account one value)

	int i, ii;
	int noTuples = 0; // Number of tuples we need to create in sachposten
	int noPos; // Number of tuples for contrary account
	int buchGrPos; // position of accounting group
	double *mwstPosten; // a array of VAT values (for each VAT code one value)
	QString sumSP; // sum for contrary account in sachposten
	bool ok; // for managing program flow
	QString mwstQS; // String for converting mwstPosten
	QString netQS; // String for converting netPosten
	SQLTable *mwstSQL; // result set of table mwst
	SQLTable *pos; // result set of table warenbuch_gruppe or res_buch_gruppe
	SQLTable *debBuchGrSQL; // result set of table deb_buch_gruppe
	QString debBuchGrQS; // String for the query of deb_buch_gruppe
	QString brutto, netto; // Strings for calculating VAT values
	QString buch_gr;
	QString ktoQS;
	QString lValues;
	QString lFields;
	QString voucherType; // for example 'Deb.-Rechnung' or 'Deb.-Gutschrift'

	// this parameters are necessary
	if ((sql==0)||(table==0)||(tablePositions==0))
		return false;

	switch( QMessageBox::warning( 0, "QtTudo Buchen",
		"Mchten Sie diesen Beleg wirklich buchen?",
		"&Ja", "&Nein", "",
		1,2 ))     // No == button 0 -> default
	{
		case 0: // 'Ja' (yes) clicked, Alt-J or Enter pressed.
			// delete
			break;
		case 1: // 'Nein' (no) clicked or Alt-N pressed
			// don't account
			return false;
	} // switch

	//=====================================================================
	// 1. Preparation
	//=====================================================================

	// result set for accounting group
	pos = new SQLTable();

	// Get the contrary account of the debitor accounting group
	debBuchGrQS = "SELECT * FROM deb_buch_gruppe WHERE code = '";
	debBuchGrQS.append( table->getValue(0,"buch_gr") );
	debBuchGrQS.append("'");
	debBuchGrSQL = new SQLTable( debBuchGrQS.copy().ascii() );

	if ( debBuchGrSQL->execute() != SUCCESS_RESULTS )
		QMessageBox::warning( 0, "QtTudo Deb.-Buch.-Gruppe", debBuchGrSQL->ErrorText );

	// Get the number of VAT-codes (MwSt.-Codes)
	mwstSQL = new SQLTable( "SELECT * FROM mwst" );
	if ( mwstSQL->execute() != SUCCESS_RESULTS )
		QMessageBox::warning( 0, "QtTudo MwSt.-Codes", mwstSQL->ErrorText );

	mwstPosten = new double[mwstSQL->getnTuples()];
	if (mwstPosten == NULL) {
		QMessageBox::warning( 0, "QtTudo Buchen: mwstPosten",
			"Kein Speicher mehr verfgbar." );
		return false;
	}

	// set defaults to null
	for (i=0; i<mwstSQL->getnTuples(); i++)
		mwstPosten[i] = 0L;

	// Loop through each position of (invoice, credit note, order)
	// to get the VAT values (building sums for each used
	// VAT code).
	for (i=0; i<tablePositions->getnTuples(); i++) {
		brutto.truncate(0);
		brutto.append( tablePositions->getValue(i,"bruttobetrag") );
		netto.truncate(0);
		netto.append( tablePositions->getValue(i,"nettobetrag") );
		// if credit note (Gutschrift)
		if ( strcmp(table->getValue(table->pos,"art"),"Deb.-Gutschrift") == 0 ) {
			brutto.setNum( -brutto.toDouble() );
			netto.setNum( -netto.toDouble() );
		}
		mwstPosten[getVATtuple(mwstSQL, tablePositions, i)] -=
			( brutto.toDouble() - netto.toDouble() );
	}

	// Get the count of VAT codes (equal to the count of VAT tuples we need)
	for (i=0; i<mwstSQL->getnTuples(); i++) {
		if (mwstPosten[i] != 0) {
			sumSP.setNum( sumSP.toDouble() - mwstPosten[i] );
			//printf("sum: %f\n", sumSP.toDouble() );
			noTuples++;
		}
	}

	// a structur of net values
	// it can be the maximum of positions in the invoice, credit note, etc.
	newSP = new posten[tablePositions->getnTuples()];
	if (newSP == NULL) {
		QMessageBox::warning( 0, "QtTudo Buchen: netPosten",
			"Kein Speicher mehr verfgbar." );
		return false;
	}

	noPos = 0;
	// Loop through each position of (invoice, credit note, order)
	// to get the net values (building sums for each used
	// VAT code and contrary account).
	for (i=0; i<tablePositions->getnTuples(); i++) {
		netto.truncate(0); // delete old value
		netto.append( tablePositions->getValue(i,"nettobetrag") );
		brutto.truncate(0);
		brutto.append( tablePositions->getValue(i,"bruttobetrag") );
		// if credit note (Gutschrift)
		if ( strcmp(table->getValue(table->pos,"art"),"Deb.-Gutschrift") == 0 ) {
			brutto.setNum( -brutto.toDouble() );
			netto.setNum( -netto.toDouble() );
		}

		ok = false;
		if (strstr(tablePositions->getValue(i,"art"),"Artikel") != 0) {
			pos->sQuery = "SELECT code,warenverk_konto,warenverk_kto_o_st "
				"FROM warenbuch_gruppe WHERE code = '";
			pos->sQuery.append( tablePositions->getValue(i,"buch_gr") );
			pos->sQuery.append("'");
			buch_gr.truncate(0);
			// if with VAT
			if (netto.toDouble() != brutto.toDouble())
				buch_gr.append( "warenverk_konto" );
			// if without VAT (net == gross)
			else
				buch_gr.append( "warenverk_kto_o_st" );
			ok = true;
		} else
		if (strstr(tablePositions->getValue(i,"art"),"Ressource") != 0) {
			pos->sQuery = "SELECT code,res_verkaufskonto,res_verk_kto_o_st "
				"FROM res_buch_gruppe WHERE code = '";
			pos->sQuery.append( tablePositions->getValue(i,"buch_gr") );
			pos->sQuery.append("'");
			buch_gr.truncate(0);
			buch_gr.append( "res_verkaufskonto" );
			ok = true;
		} else
		if (strstr(tablePositions->getValue(i,"art"),"Sachkonto") != 0) {
			pos->sQuery = "SELECT nummer FROM sachkonto WHERE nummer = '";
			pos->sQuery.append( tablePositions->getValue(i,"nummer") );
			pos->sQuery.append("'");
			buch_gr.truncate(0);
			buch_gr.append( "nummer" );
			ok = true;
		}

		if (ok) { // only if it's a valid table position, otherwise skip
			if ( pos->execute() != SUCCESS_RESULTS )
				QMessageBox::warning( 0, "QtTudo Buch.-Gruppe", pos->ErrorText );

			for (ii=0; ii < noPos; ii++) {
				buchGrPos = getBuchGr(pos,i);
				if (buchGrPos < 0)
					return false;
				ktoQS = pos->getValue(buchGrPos,buch_gr);
				// only for test
				//printf( "ktoQS: %s\n", ktoQS.copy().ascii() );
				//printf( "newSP: %s\n", newSP[ii].account.copy().ascii() );
				//printf( "mwCode: %s\n", newSP[ii].mwCode.copy().ascii() );
				//printf( "tabPos: %s\n", tablePositions->getValue(i,"mwst_code") );
				if ((strstr(newSP[ii].mwCode, tablePositions->getValue(i,"mwst_code")) != 0) &&
						(strstr(newSP[ii].account, ktoQS) != 0))
				{
					newSP[ii].netto.setNum( newSP[ii].netto.toDouble() - netto.toDouble() );
					sumSP.setNum( sumSP.toDouble() + netto.toDouble() );
					//printf("sum: %f\n", sumSP.toDouble() );
					break;
				}
			}
			if (ii >= noPos ) {
				newSP[noPos].mwCode = tablePositions->getValue(i,"mwst_code");
				newSP[noPos].account = pos->getValue(0,buch_gr);
				newSP[noPos].netto.setNum( -netto.toDouble() );
				sumSP.setNum( sumSP.toDouble() + netto.toDouble() );
				//printf("sum: %f\n", sumSP.toDouble() );
				noPos++;
				noTuples++;
			}
		}
	}

	// Reserve numbers for tuples of sachposten and debitorenposten
	// Important: Don't do this inside the transaction,
	// because another user can get the same numbers.
	// The numbers must be unique.
	// noTuples = number of VAT tuples + 2 impersonal accounts (konto, gegenkonto)
	sql->getLfdNr( "interne_daten", &NoSP, "sachposten_nr", noTuples + 2);
	sql->getLfdNr( "interne_daten", &NoDP, "debitorposten_nr", 1);

	NoBO.truncate(0);
	// get the next voucher number
	voucherType = table->getValue(table->pos,"art");
	if (voucherType.find("Deb.-Rechnung") != -1) {
		sql->getLfdNr( "buchhaltungsdaten", &NoBO, "letz_deb_rech_nr", 1);
		NoBO.setNum( NoBO.toLong()+1 );
	} else
	if (voucherType.find("Deb.-Gutschrift") != -1) {
		sql->getLfdNr( "buchhaltungsdaten", &NoBO, "letz_deb_guts_nr", 1);
		NoBO.setNum( NoBO.toLong()+1 );
	} else	
		// otherwise get from verkaufskopf
		NoBO.append( table->getValue(table->pos,"belegnr") );

	//=====================================================================
	// 2. Transaction Begin
	//=====================================================================

	tableTA->sQuery = "BEGIN TRANSACTION";
	if ( tableTA->execute() != SUCCESS_NO_RESULTS ) {
		QMessageBox::warning( 0, "QtTudo Transaktion Start", tableTA->ErrorText );
		return false;
	}

	//=====================================================================
	// 3. Create VAT sachposten (different quantity, depends on order)
	//=====================================================================

	// create for each VAT value a sachposten
	// i = tuple position in mwstSQL
	for (i=0; i<mwstSQL->getnTuples(); i++) {
		if (mwstPosten[i] != 0) {
			lFields = ",lfd_nr,mwst_code,kontonr,nettobetrag";
			lValues = NoSP;
			NoSP.setNum( NoSP.toLong()+1 );
			lValues.append("','");
			lValues.append( mwstSQL->getValue(i,"code") );
			lValues.append("','");
			// 'gegenkonto' = 'mwst_konto' from table 'mwst'
			lValues.append(mwstSQL->getValue(i,"mwst_konto"));
			lValues.append("','");
			mwstQS.setNum( mwstPosten[i] ); // convert double to string
			lValues.append( mwstQS.copy() );

			if ( !createPosten( &lValues, &lFields, i, VERKAUF ) )
				return rollback();
		}
	}

	//=====================================================================
	// 4. Create x sachposten for account net (netto),
	//    depends on:
	//
	// ATTENTION! We are still not checking EG (european union) and
	//            other specialities in warenbuch_gruppe
	//
	//=====================================================================

	// i = tuple position in mwstSQL
	for (i=0; i<noPos; i++) {
		lFields = ",lfd_nr,mwst_code,kontonr,nettobetrag";
		lValues = NoSP;
		NoSP.setNum( NoSP.toLong()+1 );
		lValues.append("','");
		lValues.append( newSP[i].mwCode.copy() );
		lValues.append("','");
		lValues.append( newSP[i].account.copy() );
		lValues.append("','");
		lValues.append( newSP[i].netto.copy() );

		if ( !createPosten( &lValues, &lFields, i, VERKAUF ) )
			return rollback();
	}

	//=====================================================================
	// 5. Create 1 sachposten for contrary account gross (brutto)
	//=====================================================================

		lFields = ",lfd_nr,kontonr,nettobetrag";
		lValues = NoSP;
		NoSP.setNum( NoSP.toLong()+1 );
		lValues.append("','");
		// get contrary account from accounting group
		lValues.append( debBuchGrSQL->getValue(0, "sammelkonto") );
		lValues.append("','");
		lValues.append( sumSP.copy() );

		if ( !createPosten( &lValues, &lFields, i, VERKAUF ) )
			return rollback();

	//=====================================================================
	// 6. Create 1 debitorenposten
	//=====================================================================

		// setting the fieldvalues for the debitorenposten tuple
		lFields = ",lfd_nr,debitornr,waehrungscode,betrag,mw,buch_gr";
		lValues = NoDP;
		NoDP.setNum( NoDP.toLong()+1 );
		lValues.append("','");
		addValue( table, &lValues, table->pos, "kundennr", true );
		addValue( table, &lValues, table->pos, "waehrungscode", true );
		lValues.append( sumSP.copy() ); // field 'betrag'
		lValues.append("','");
		lValues.append( sumSP.copy() ); // field 'mw'
		lValues.append("','");
		addValue( table, &lValues, table->pos, "buch_gr", false );

		if ( !createPosten( &lValues, &lFields, 0, VERKAUF, "debitorenposten" ) )
			return rollback();

	//=====================================================================
	// 7. Create warenposten
	//=====================================================================


	//=====================================================================
	// 8. Copy order to tables for booked invoices
	//    (deb_rech_kopf, deb_rech_zeile)
	//=====================================================================

	// if credit note (Gutschrift)
	if ( strcmp(table->getValue(table->pos,"art"),"Deb.-Gutschrift") == 0 ) {
		if (!copyOrder("deb_gutschr_kopf","deb_gutschr_zeile"))
			return rollback();
	} else {
		if (!copyOrder("deb_rech_kopf","deb_rech_zeile"))
			return rollback();
	}

	//=====================================================================
	// 9. Delete order
	//=====================================================================

	if (!deleteOrder())
		return rollback();

	//=====================================================================
	// 10. Transaction End
	//=====================================================================

	tableTA->sQuery = "COMMIT";
	if ( tableTA->execute() != SUCCESS_NO_RESULTS )
		return rollback();

	return true;
}

// Accounting from einkauf_rechnung, gutschrift, bestellung
bool Buchen::makeAccountEinkauf()
{
	if ((sql==0)||(table==0)||(tablePositions==0))
		return false;

	QMessageBox::information( 0, "QtTudo Einkauf buchen", "coming soon ..." );

	return true;
}

// Copy order to deb_rech_kopf/deb_rech_zeile
bool Buchen::copyOrder( const char *head, const char *positions )
{
	int i;
	QString s;
	QString datum;
	SQLTable *t = new SQLTable();

	s = "INSERT INTO ";
	s.append( head ); // deb_rech_kopf or deb_gutschr_kopf
	s.append( " (" );
	s.append( "nummer,debitornr,name,name_2,adresse,adresse_2,ort,plz"
			",ihre_unsere_ref,buchungsdatum,buchungstext,zahlungsbed_code"
			",buch_gr,waehrungscode,waehrungsfaktor,mwst_pflichtig"
			",verkaeufercode,briefanrede,evtl_auftragsnr,belegdatum" );
	s.append( ") VALUES ('");

	// get the next invoice number
	s.append( NoBO.copy() );

	s.append("','");
	// fields in verkaufskopf
	addValue( table, &s, table->pos, "kundennr", true );
	addValue( table, &s, table->pos, "name", true );
	addValue( table, &s, table->pos, "name_2", true );
	addValue( table, &s, table->pos, "adresse", true );
	addValue( table, &s, table->pos, "adresse_2", true );
	addValue( table, &s, table->pos, "ort", true );
	addValue( table, &s, table->pos, "plz", true );
	addValue( table, &s, table->pos, "ihre_unsere_ref", true );
	addValue( table, &s, table->pos, "buchungsdatum", true );
	addValue( table, &s, table->pos, "buchungstext", true );
	addValue( table, &s, table->pos, "zahlungsbed_code", true );
	addValue( table, &s, table->pos, "buch_gr", true );
	addValue( table, &s, table->pos, "waehrungscode", true );
	addValue( table, &s, table->pos, "waehrungsfaktor", true );
	addValue( table, &s, table->pos, "mwst_pflichtig", true );
	addValue( table, &s, table->pos, "verkaeufercode", true );
	addValue( table, &s, table->pos, "briefanrede", true );
	addValue( table, &s, table->pos, "belegnr", true );
	s.append( setDate( &datum )->copy() ); // current date

	s.append( "')" );

	// Only for test
	//QMessageBox::information( 0, "QtTudo Test", s );

	// Now we have to create the tuple.
	t->sQuery = s.ascii();
  if ( t->execute() != SUCCESS_NO_RESULTS ) {
		QMessageBox::warning( 0, "QtTudo Verkauf buchen", t->ErrorText );
		return false;
	}

	for (i=0;i<tablePositions->getnTuples();i++) {
		s = "INSERT INTO ";
		s.append( positions ); // deb_rech_zeile or deb_gutschr_zeile
		s.append( " (" );

		s.append( "belegnr,lfd_nr,art,nummer"
				",buch_gr,text,text_2,menge,stueckpreis,mwst_code,mwst_prozent"
				",nettobetrag" );
		if ( strlen(tablePositions->getValue(i,"lokationscode")) > 0 )
			s.append( ",lokationscode" );
		s.append( ",bruttobetrag" );
		s.append( ") VALUES ('");

		// get the invoice number of the header
		s.append( NoBO.copy() );

		s.append("','");
		// fields in verkaufszeile
		addValue( tablePositions, &s, i, "lfd_nr", true );
		addValue( tablePositions, &s, i, "art", true );
		addValue( tablePositions, &s, i, "nummer", true );
		addValue( tablePositions, &s, i, "buch_gr", true );
		addValue( tablePositions, &s, i, "text", true );
		addValue( tablePositions, &s, i, "text_2", true );
		addValue( tablePositions, &s, i, "menge", true );
		addValue( tablePositions, &s, i, "stueckpreis", true );
		addValue( tablePositions, &s, i, "mwst_code", true );
		addValue( tablePositions, &s, i, "mwst_prozent", true );
		addValue( tablePositions, &s, i, "nettobetrag", true );
		if ( strlen(tablePositions->getValue(i,"lokationscode")) > 0 )
			addValue( tablePositions, &s, i, "lokationscode", true );
		addValue( tablePositions, &s, i, "bruttobetrag", false );

		s.append( "')" );

		// Only for test
		//QMessageBox::information( 0, "QtTudo Test", s );

		// Now we have to create the tuple.
		t->sQuery = s.ascii();
	  if ( t->execute() != SUCCESS_NO_RESULTS ) {
			QMessageBox::warning( 0, "QtTudo Verkauf buchen", t->ErrorText );
			return false;
		}
	}

	return true;
}

// Delete the current order in verkaufskopf/verkaufszeile
bool Buchen::deleteOrder()
{
	QString s;
	QString belegnr = table->getValue(table->pos,"belegnr");
	SQLTable *t = new SQLTable();

	s = "DELETE FROM verkaufszeile WHERE belegnr = ";

	// get the invoice number of the header
	s.append( belegnr.copy() );

	// Only for test
	//QMessageBox::information( 0, "QtTudo Test", s );

	// Now we have to delete the order positions.
	t->sQuery = s.ascii();
  if ( t->execute() != SUCCESS_NO_RESULTS ) {
		QMessageBox::warning( 0, "QtTudo Verkaufszeile lschen", t->ErrorText );
		return false;
	}

	s = "DELETE FROM verkaufskopf WHERE belegnr = ";

	// get the next invoice number
	s.append( belegnr.copy() );

	// Only for test
	//QMessageBox::information( 0, "QtTudo Test", s );

	// Now we have to delete the order header.
	t->sQuery = s.ascii();
  if ( t->execute() != SUCCESS_NO_RESULTS ) {
		QMessageBox::warning( 0, "QtTudo Verkaufskopf lschen", t->ErrorText );
		return false;
	}

	return true;
}

QString *Buchen::setDate( QString *date )
{
	char datum[12];
	time_t t;
	tm *d;

	time(&t);
	d = localtime( &t );

	sprintf( datum, "%i.%i.%i", d->tm_mday, d->tm_mon + 1, d->tm_year + 1900 );
	date->truncate(0);
	date->append( datum );

	return date;
}

// Rollback transaction
bool Buchen::rollback()
{
	if (tableTA == 0)
		QMessageBox::warning( 0, "QtTudo Transaktionsabbruch", "Parameter tableTA fehlt." );
	else {
		tableTA->sQuery = "ROLLBACK";
		tableTA->execute();
	}
	return false;
}

// Give back the tuple number of VAT code
int Buchen::getVATtuple( SQLTable *mwst, SQLTable *tablePositions, int tuple )
{
	// i is the tuple position
	for (int i=0; i < mwst->getnTuples(); i++) {
		if ( strstr(mwst->getValue(i,"code"),
								tablePositions->getValue(tuple,"mwst_code")) != 0 )
			return i;
	}
	return 0;
}

// Give back the tuple number of table pos
// (pos is warenbuch_gruppe, res_buch_gruppe or sachkonto)
int Buchen::getBuchGr( SQLTable *pos, int tuple )
{
	SQLTable *quelle;

	if (strstr(tablePositions->getValue(tuple,"art"),"Artikel") != 0) {
		quelle = new SQLTable( "SELECT nummer,buch_gr FROM artikel WHERE nummer = '" );
	} else
	if (strstr(tablePositions->getValue(tuple,"art"),"Ressource") != 0) {
		quelle = new SQLTable( "SELECT nummer,buch_gr FROM ressource WHERE nummer = '" );
	} else
	if (strstr(tablePositions->getValue(tuple,"art"),"Sachkonto") != 0) {
		quelle = new SQLTable( "SELECT nummer FROM sachkonto WHERE nummer = '" );
	} else
		return -1; // otherwise skip this tuple

	quelle->sQuery.append( tablePositions->getValue(tuple,"nummer") );
	quelle->sQuery.append("'");
	if ( quelle->execute() != SUCCESS_RESULTS ) {
		QMessageBox::warning( 0, "QtTudo Buchen", quelle->ErrorText );
		return -1;
	}

	// if no tuples were found ...
	if (quelle->getnTuples() < 1) {
		QMessageBox::warning( 0, "QtTudo Buchen",
			"Keine Nummer in der Verkaufszeile gefunden." );
		return -1;
	}

	// i is the tuple position
	for (int i=0; i < pos->getnTuples(); i++) {
		if (strstr(tablePositions->getValue(tuple,"art"),"Sachkonto") != 0) {
			if ( strstr(pos->getValue(i,"nummer"),quelle->getValue(0,"nummer")) != 0 )
				return i;
		} else {
			if ( strstr(pos->getValue(i,"code"),quelle->getValue(0,"buch_gr")) != 0 )
				return i;
		}
	}
	return -1;
}

bool Buchen::KontoartSachkonto( int tuple, const char *kontonr )
{
	QString f;
	QString sVAT, sVAT_Kto;
	QString s;
	QString lValues;
	QString lFields;
	QString mwst;

	mwst.append( table->getValue(tuple, "mwst_code") );

	// setting the fieldvalues for the first tuple
	//======================================================================
	if (mwst.isEmpty())
		lFields = ",lfd_nr,kontonr,gegenkonto,mwst_betrag,nettobetrag";
	else
		lFields = ",lfd_nr,kontonr,mwst_code,gegenkonto,mwst_betrag,nettobetrag";
	lValues = NoSP;
	NoSP.setNum( NoSP.toLong()+1 );
	lValues.append("','");
	addValue( table, &lValues, tuple, "gegenkonto", true );
	if (!mwst.isEmpty())
		addValue( table, &lValues, tuple, "mwst_code", true );
	lValues.append( kontonr );
	lValues.append("','");
	lValues.append( getVAT(&f,tuple,&sVAT,&sVAT_Kto)->copy() );
	lValues.append("','");
	f = table->getValue(tuple,"mw");
	f.setNum(-((f.toDouble() * 100) / (100+sVAT.toDouble())));
	lValues.append( f.copy() );

	if ( !createPosten( &lValues, &lFields, tuple, ERFASSUNG ) )
		return false;

	// setting the fieldvalues for the second tuple
	//======================================================================
	lFields = ",lfd_nr,kontonr,gegenkonto,nettobetrag";
	lValues = NoSP;
	NoSP.setNum( NoSP.toLong()+1 );
	lValues.append("','");
	lValues.append( kontonr );
	lValues.append("','");
	addValue( table, &lValues, tuple, "gegenkonto", true );
	f = table->getValue(tuple,"mw");
	f.setNum(f.toDouble());
	lValues.append( f.copy() );

	if ( !createPosten( &lValues, &lFields, tuple, ERFASSUNG ) )
		return false;

	// if we have a VAT value, then create the third tuple in sachposten
	if ( sVAT.toDouble() > 0 ) {
		// setting the fieldvalues for the third tuple (VAT)
		//======================================================================
		lFields = ",lfd_nr,kontonr,mwst_code,gegenkonto,nettobetrag";
		lValues = NoSP;
		lValues.append("','");
		lValues.append( sVAT_Kto );
		lValues.append("','");
		addValue( table, &lValues, tuple, "mwst_code", true );
		lValues.append( kontonr );
		lValues.append("','");
		f = table->getValue(tuple,"mw");
		f.setNum(-(f.toDouble()-((f.toDouble() * 100) / (100+sVAT.toDouble()))));
		lValues.append( f.copy() );

		if ( !createPosten( &lValues, &lFields, tuple, ERFASSUNG ) )
			return false;
	} // sVAT.toDouble() > 0

	return true;
}

// Creating sach- and debitorenposten
bool Buchen::KontoartDebitor( int tuple )
{
	QString f;
	QString s;
	bool ok = false;

	// get the 'art'
	s = table->getValue( tuple, "art" );

	// Which kind of 'art' (Buchungsart) is it?
	if (s.find("Sonstiges") != -1)
		ok = false; // not allowed
	if (s.find("Umbuchung") != -1)
		ok = false; // not allowed

	// That's the same like a credit note (Gutschrift)
	if (s.find("Storno") != -1)
		ok = false; // not allowed

	// Create 1 negativ debitorenposten and
	// 2 positiv sachposten
	// kontonr negativ (1400)
	// gegenkonto positiv (1200)
	if (s.find("Zahlung") != -1) {
		f = table->getValue(tuple,"mw");
		if (f.toDouble() >= 0) {
			QMessageBox::warning( 0, "QtTudo Debitor Zahlung buchen",
				"Betrag mu negativ sein!");
			return false; // return with error
		}

		// payment can only be without VAT (Umsatzsteuer)
		if ( getVAT(tuple) != 0 ) {
			QMessageBox::warning( 0, "QtTudo Debitor Zahlung buchen",
				"Die Zahlung darf kein MwSt.-Code enthalten!");
			return false; // return with error
		}


		// More examinations

		ok = createDebitorposten( tuple );
	}

	// Create 1 positiv debitorenposten and
	// until to 3 sachposten
	// kontonr and VAT-kto positiv (1400/1776)
	// gegenkonto negativ (8042)
	if (s.find("Rechnung") != -1) {
		f = table->getValue(tuple,"mw");
		if (f.toDouble() <= 0) {
			QMessageBox::warning( 0, "QtTudo Debitor Rechnung buchen",
				"Betrag mu positiv sein!");
			return false; // return with error
		}

		// More examinations

		ok = createDebitorposten( tuple );
	}

	// Create 1 negativ debitorenposten and
	// until to 3 sachposten
	// kontonr and VAT-kto negativ (1400/1776)
	// gegenkonto positiv (8042)
	if (s.find("Gutschrift") != -1) {
		f = table->getValue(tuple,"mw");
		if (f.toDouble() >= 0) {
			QMessageBox::warning( 0, "QtTudo Debitor Gutschrift buchen",
				"Betrag mu negativ sein!");
			return false; // return with error
		}

		// More examinations

		ok = createDebitorposten( tuple );
	}

	return ok;
}

bool Buchen::KontoartKreditor( int tuple )
{
	QString f;
	QString s;
	bool ok = false;

	// get the 'art'
	s = table->getValue( tuple, "art" );

	// Which kind of 'art' (Buchungsart) is it?
	if (s.find("Sonstiges") != -1)
		ok = false; // not allowed
	if (s.find("Umbuchung") != -1)
		ok = false; // not allowed

	// That's the same like a credit note (Gutschrift)
	if (s.find("Storno") != -1)
		ok = false; // not allowed

	// Create 1 positiv kreditorenposten and
	// 2 negativ sachposten
	// kontonr positiv (1600)
	// gegenkonto negativ (1362)
	if (s.find("Zahlung") != -1) {
		f = table->getValue(tuple,"mw");
		if (f.toDouble() <= 0) {
			QMessageBox::warning( 0, "QtTudo Kreditor Zahlung buchen",
				"Betrag mu positiv sein!");
			return false; // return with error
		}

		// payment can only be without VAT (Umsatzsteuer)
		if ( getVAT(tuple) != 0 ) {
			QMessageBox::warning( 0, "QtTudo Kreditor Zahlung buchen",
				"Die Zahlung darf kein MwSt.-Code enthalten!");
			return false; // return with error
		}


		// More examinations

		ok = createKreditorposten( tuple );
	}

	// Create 1 negativ kreditorenposten and
	// until to 3 sachposten
	// kontonr and VAT-kto positiv (4761/1576)
	// gegenkonto negativ (1600)
	if (s.find("Rechnung") != -1) {
		f = table->getValue(tuple,"mw");
		if (f.toDouble() >= 0) {
			QMessageBox::warning( 0, "QtTudo Kreditor Rechnung buchen",
				"Betrag mu negativ sein!");
			return false; // return with error
		}

		// More examinations

		ok = createKreditorposten( tuple );
	}

	// Create 1 positiv kreditorenposten and
	// until to 3 sachposten
	// kontonr and VAT-kto negativ (4761/1576)
	// gegenkonto positiv (1600)
	if (s.find("Gutschrift") != -1) {
		f = table->getValue(tuple,"mw");
		if (f.toDouble() >= 0) {
			QMessageBox::warning( 0, "QtTudo Kreditor Gutschrift buchen",
				"Betrag mu positiv sein!");
			return false; // return with error
		}

		// More examinations

		ok = createKreditorposten( tuple );
	}

	return ok;
}

bool Buchen::createDebitorposten( int tuple )
{
	bool ok;
	QString lValues;
	QString lFields;
	QString sachkonto;

	// setting the fieldvalues for the debitorenposten tuple
	lFields = ",lfd_nr,debitornr,waehrungscode,betrag,mw,buch_gr";
	lValues = NoDP;
	NoDP.setNum( NoDP.toLong()+1 );
	lValues.append("','");
	addValue( table, &lValues, tuple, "kontonr", true );
	addValue( table, &lValues, tuple, "waehrungscode", true );
	addValue( table, &lValues, tuple, "betrag", true );
	addValue( table, &lValues, tuple, "mw", true );
	addValue( table, &lValues, tuple, "buch_gr", false );

	if ( !createPosten( &lValues, &lFields, tuple, ERFASSUNG, "debitorenposten" ) )
		return false;
	else {
		getSachkonto( DEBITOR, &sachkonto, tuple );
		ok = KontoartSachkonto( tuple, sachkonto.ascii() );
		return ok;
	}
}

bool Buchen::createKreditorposten( int tuple )
{
	QString lValues;
	QString lFields;
	QString sachkonto;

	// setting the fieldvalues for the debitorenposten tuple
	lFields = ",lfd_nr,kreditornr,waehrungscode,betrag,mw,buch_gr";
	lValues = NoKP;
	NoDP.setNum( NoKP.toLong()+1 );
	lValues.append("','");
	addValue( table, &lValues, tuple, "kontonr", true );
	addValue( table, &lValues, tuple, "waehrungscode", true );
	addValue( table, &lValues, tuple, "betrag", true );
	addValue( table, &lValues, tuple, "mw", true );
	addValue( table, &lValues, tuple, "buch_gr", false );

	if ( !createPosten( &lValues, &lFields, tuple, ERFASSUNG, "kreditorenposten" ) )
		return false;
	else {
		getSachkonto( KREDITOR, &sachkonto, tuple );
		return KontoartSachkonto( tuple, sachkonto );
	}
}

// Get the VAT (Umsatzsteuer)
QString *Buchen::getVAT( QString *VAT, int tuple,
					QString *sVAT, QString *sVAT_Kto )
{
	QString lVAT = "SELECT * FROM mwst WHERE code ='";
	lVAT.append( table->getValue(tuple,"mwst_code"));
	lVAT.append( "'" );
	SQLTable *tableVAT = new SQLTable( lVAT.ascii() );
	tableVAT->execute();

	VAT->truncate(0); // delete old strings
	sVAT->truncate(0);
	sVAT_Kto->truncate(0);

	sVAT->append( tableVAT->getValue(0,"mwst_proz") );
	sVAT_Kto->append( tableVAT->getValue(0,"mwst_konto") );
	VAT->append( table->getValue(tuple,"mw") );
	VAT->setNum(-(VAT->toDouble() -
		( (VAT->toDouble() * 100) / (100 + sVAT->toDouble()) )));
	return VAT;
}

// Get the VAT (Umsatzsteuer) in percent as double
double Buchen::getVAT( int tuple )
{
	QString s;
	QString lVAT = "SELECT * FROM mwst WHERE code ='";
	lVAT.append( table->getValue(tuple,"mwst_code"));
	lVAT.append( "'" );
	SQLTable *tableVAT = new SQLTable( lVAT.ascii() );

  if ( tableVAT->execute() != SUCCESS_RESULTS ) {
		QMessageBox::warning( 0, "QtTudo MwSt.-Code", tableVAT->ErrorText );
	}

	s = tableVAT->getValue(0,"mwst_proz");
	return s.toDouble();
}

QString *Buchen::getSachkonto( int Type, QString *Sachkonto, int tuple )
{
	QString sDeb, sBuchGr;
	QString tableBuchGr;
	SQLTable *tDeb, *tBuchGr;

	switch (Type) {
		case DEBITOR:
			sDeb = "SELECT * FROM debitor WHERE nummer = '";
			tableBuchGr = "deb_buch_gruppe";
			break;
		case KREDITOR:
			sDeb = "SELECT * FROM kreditor WHERE nummer = '";
			tableBuchGr = "kred_buch_gruppe";
			break;
		default:
			QMessageBox::warning( 0, "QtTudo Fehler",
				"Buchen::getSachkonto\n"
				"Falsche Typ-bergabe");
			return Sachkonto;
	}
	sDeb.append( table->getValue(tuple,"kontonr") );
	sDeb.append( "'" );
	tDeb = new SQLTable( sDeb.ascii() );
	tDeb->execute();
	// if found, then ...
	if (tDeb->getnTuples() > 0) {
		sBuchGr = "SELECT * FROM ";
		sBuchGr.append( tableBuchGr.copy() );
		sBuchGr.append( " WHERE code = '" );
		sBuchGr.append( tDeb->getValue(0,"buchungsgruppe") );
		sBuchGr.append( "'" );
		tBuchGr = new SQLTable( sBuchGr.ascii() );
		tBuchGr->execute();
		if (tBuchGr->getnTuples() > 0) {
			Sachkonto->truncate(0);
			Sachkonto->append( tBuchGr->getValue(0,"sammelkonto"));
		}
	}
	return Sachkonto;
}

bool Buchen::createPosten(QString *values, QString *fields,
		int tuple, int type, const char *posten )
{
	QString lValues;
	QString s;

	s = "INSERT INTO ";
	s.append( posten );
	s.append( " (" );
	s.append( "datum,belegnr,text,benutzerid,spur,belegdatum,art" );
	if ( fields != 0 )
		s.append( fields->copy() );
	s.append( ") VALUES (");

	getValuesToQuery( type, &lValues, tuple, table );
	s.append( lValues );

	if ( values != 0 ) {
		s.append( ",'" );
		s.append( values->copy() );
		s.append( "'" );
	}

	s.append( ")" );

	// Only for test
	//QMessageBox::information( 0, "QtTudo Test", s );

	// Now we have to create the tuple.
	tableSP = new SQLTable( s.ascii(), "lfd_nr" );
  if ( tableSP->execute() != SUCCESS_NO_RESULTS ) {
		QMessageBox::warning( 0, "QtTudo Posten", tableSP->ErrorText );
		return false;
	}
	return true;
}

// The Parameters 'tuple' and 'table' have different meanings, depends
// on which kind of accounting (allg_erfassung, verkauf, einkauf)
// we are making.
void Buchen::getValuesToQuery( int type, QString *query, int tuple,
		SQLTable *table )
{
	QString belegart;
	QString betrag;
	QString betrag2;

	query->truncate(0); // delete old string
	query->append("'");
	switch (type) {
		case ERFASSUNG:
			// tuple = position in kassenkladdenzeile
			// table = kassenkladdenzeile
			addValue( table, query, tuple, "datum", true );
			addValue( table, query, tuple, "belegnr", true );
			addValue( table, query, tuple, "text", true );
			query->append( Benutzer ); // user id
			query->append( "','" );
			addValue( table, query, tuple, "spur", true );
			addValue( table, query, tuple, "belegdatum", true );
			addValue( table, query, tuple, "art", false );
			betrag = table->getValue(tuple,"mw");
			break;
		case VERKAUF:
			// tuple = position in mwstSQL to get the VAT value
			// table = verkaufskopf
			addValue( table, query, table->pos, "buchungsdatum", true );
			query->append( NoBO.copy() ); // the new voucher number
			query->append( "','" );
			addValue( table, query, table->pos, "buchungstext", true );
			query->append( Benutzer ); // user id
			query->append( "','VK','" ); // spur
			addValue( table, query, table->pos, "buchungsdatum", true );

			belegart = table->getValue(table->pos,"art");
			if ( belegart.find("Deb.-Rechnung") != -1 )
				query->append( "Rechnung" ); // art
			else
				query->append( "Gutschrift" ); // art

			break;
		case EINKAUF: break;
		default: break;
	}
	query->append( "'" );
}

void Buchen::addValue( SQLTable *table, QString *value, int tuple,
		const char *name, bool sep )
{
	QString s = table->getValue(tuple,name);

	if ((table != 0)&&(value != 0)) {
		if ( table->fType(table->fNumber(name)) == 16 ) { // == bool
			if ( s.isEmpty() || (s.find("f")!=-1) )
				value->append( "f" );
			else
				value->append( "t" );
		} else
			value->append( s );
		if (sep)
			value->append("','");
	}
}

void Buchen::deleteTuple( int tuple, QString *tableName )
{
	QString s = "DELETE FROM ";
	s.append( tableName->copy() );
	s.append( " WHERE (kladdenname = '");
	s.append( table->getValue( tuple, "kladdenname") );
	s.append( "') AND (lfd_nr = '");
	s.append( table->getValue( tuple, "lfd_nr" ) );
	s.append( "')");
	SQLTable *table = new SQLTable( s.ascii() );

  if ( table->execute() != SUCCESS_NO_RESULTS ) {
		QMessageBox::warning( 0, "QtTudo Kladdenzeile lschen", table->ErrorText );
	}
}

QCString *Buchen::setStr( QCString *str )
{
	QCString LfdNr;

	// Momentary set the string for debitor invoice,
	// later for other types.
	str->truncate(0);
	str->append( "INSERT INTO buchen_intern ("
			"kladdenname,spur,lfd_nr,"
			"kontoart,"
			"kontonr,"
			"belegnr,"
			"art,"
			/*"datum,"
			"text,"
			"mwst_code,"
			"mwst_prozent,"
			"gegenkonto,"
			"waehrungscode,"
			"waehrungsfaktor,"
			"betrag,"
			"mw,"
			"deckungsbetrag,"
			"buch_gr,"
			"verkaeufercode,"
			"ausgleichsart,"
			"ausgleichsnr,"
			"faelligkeitsdatum,"
			"mwst_betrag,"
			"mwst_buchung,"
			"zahlungsbed_code,"
			"ausgleichsid,"
			"urspr_waehrung,"
			"urspr_betrag,"
			"urspr_mwst_betrag"
			"belegdatum"*/ );
	str->append( ") VALUES ('Standard','VK','" );
	str->append( getLfdNrBuchenIntern( &LfdNr )->copy() );
	str->append( "','Debitor" );
	str->append( "','" );
	str->append( table->getValue(0,"kundennr") );
	str->append( "','" );
	str->append( table->getValue(0,"belegnr") ); // Auftrags-Nr. (order-no.)
	str->append( "','" );
	str->append( table->getValue(0,"Rechnung") ); // Art
	str->append( "'" );
	str->append( ")" );

	// Only for testing
	//QMessageBox::information( 0, "QtTudo Test", str->copy() );

	return str;
}

QCString *Buchen::getLfdNrBuchenIntern( QCString *nr )
{
	QString s, value;

	SQLTable *t = new SQLTable( "SELECT * FROM interne_daten" );
	t->execute();

	// read the next Lfd_nr
	nr->truncate(0);
	nr->append(	t->getValue( 0, "buchen_intern_nr"));

	// Only for testing
	//QMessageBox::information( 0, "QtTudo Test",
		//Page1->Feldvorgabe[table->fNumber("lfd_nr")]->copy() );

	// Setting the number for the next accounting.
	s = "UPDATE interne_daten SET buchen_intern_nr = ";
	value = t->getValue( 0, "buchen_intern_nr");
	value.setNum( value.toLong() + 1 );
	s.append( value );
	t = new SQLTable( s.ascii() );
  if ( t->execute() != SUCCESS_NO_RESULTS ) {
		QMessageBox::warning( 0, "QtTudo Interne Daten", t->ErrorText );
	}
	return nr;
}
