/***************************************************************************
                          allgemein_anmeldung.cpp  -  description                              
                             -------------------                                         
    begin                : Fri Sep 10 1999                                           
    version              : $Id: allgemein_anmeldung.cpp,v 1.6 2001/03/26 06:45:17 joerg_bemme Exp $
    copyright            : (C) 1999 by Jrg Bemm
    email                : info@bemme.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <pwd.h>
#include <unistd.h>

#include "allgemein_anmeldung.h"

Allgemein_Anmeldung::Allgemein_Anmeldung(QWidget *parent,
											const char *name, QCString *mainBenutzer,
											bool firstTime, QCString *ProgName)
: QDialog(parent,name,true)
{
	Benutzer		= mainBenutzer;
	ok					= false;
	bFirstTime	= firstTime;

  QPushButton *anmelden = new QPushButton( "&Verbinden", this, "anmelden" );
  QPushButton *abbruch = new QPushButton( "&Abbruch", this, "abbruch" );
	QLabel			*lpassword = new QLabel( this );
	QLabel			*lname = new QLabel( this );

	enum EchoMode { Normal, NoEcho, Password };

  db_name     = new QLineEdit( this, "Name" );
	db_password = new QLineEdit( this, "Password" );

  lname->move( 40, 35 );
  lname->setText( "&Benutzername:" );
  lname->setBuddy( db_name );
	lpassword->move( 40, 75 );
  lpassword->setText( "&Passwort:" );
	lpassword->setBuddy( db_password );
  db_name->move( 140, 40 );
  db_name->resize( 200, 20 );
	db_password->move( 140, 80 );
  db_password->resize( 200, 20 );
	db_password->setEchoMode( (QLineEdit::EchoMode) NoEcho );

  anmelden->move( 80, 160 );
  anmelden->resize( 100, 30 );
  anmelden->setFont( QFont( "Times", 14, QFont::Bold ) );
  abbruch->move( 220, 160 );
  abbruch->resize( 100, 30 );
  abbruch->setFont( QFont( "Times", 14, QFont::Bold ) );

	if (ProgName != 0)
		setCaption( ProgName->copy() + "Datenbank-Anmeldung" );
	else
		setCaption( "Datenbank-Anmeldung" );

	db_name->setFocus();

  connect( abbruch, SIGNAL(clicked()), this, SLOT(Abbruch()) );
  connect( anmelden, SIGNAL(clicked()), this, SLOT(Verbinden()) );
	connect( db_password, SIGNAL(returnPressed()), SLOT(Verbinden()) );

	// get the current user name as default
	db_name->setText( getpwuid(getuid())->pw_name );
	db_password->setFocus();
}

void Allgemein_Anmeldung::closeEvent( QCloseEvent *e )
{
	if (!ok) {
		Benutzer->setStr( "Nicht angemeldet" );
	}
	QDialog::closeEvent( e );
}

void Allgemein_Anmeldung::Abbruch()
{
  close();
}

void Allgemein_Anmeldung::Verbinden()
{
	QString sVal = "1";
	QString s = "SELECT * from benutzer WHERE taskname = '";
	const char ueberschrift[21] = "QtTudo Anmeldung";

	if (!bFirstTime) {
		// Remove the old user-id from table 'benutzer'.
		SQLTable *t2 = new SQLTable( "DELETE FROM benutzer WHERE taskname ='" );
		t2->sQuery.append( Taskname.copy() );
		t2->sQuery.append( "'" );
		//QMessageBox::information( 0, "QtTudo Test", t->sQuery );
		t2->execute();
	}

  // Create connection to database (in SQLQuerier)
  if (sql.Connect( db_name->text(), db_password->text() ) == SUCCESS_NO_RESULTS) {
		ok = true;
		// Look in the user table!
		s.append( db_name->text() );
		s.append( "'" );
		SQLTable *t = new SQLTable( s.ascii() );
		//QMessageBox::information( 0, "QtTudo Test1", s );
		t->execute();

		// If user already exist, append a available number
		if ( t->getnTuples() > 0 ) {
			// coming soon ...
			do {
				s = "SELECT * from benutzer WHERE taskname = '";
				s.append( db_name->text() );
				sVal.setNum( sVal.toInt()+1 );
				s.append( sVal );
				s.append( "'" );
				t->sQuery = s.ascii();
				//QMessageBox::information( 0, "QtTudo Test2", s );
				t->execute();
			} while ( t->getnTuples() > 0 );
			Benutzer->setStr( db_name->text() );
			Taskname.setStr( db_name->text() );
			Taskname.append( sVal );
		} else {
			Benutzer->setStr( db_name->text() );
			Taskname.setStr( db_name->text() );
		}
		// Add user to user table 'benutzer'
		t->sQuery = "INSERT INTO benutzer (name,taskname) VALUES ('";
		t->sQuery.append( Benutzer->copy() );
		t->sQuery.append( "','" );
		t->sQuery.append( Taskname.copy() );
		t->sQuery.append( "')" );
		//QMessageBox::information( 0, "QtTudo Test3", t->sQuery );
		t->execute();
	} else {
  	ok = false;
		QMessageBox::information( this, ueberschrift, sql.ErrorText );
	}

 	db_password->setText( "" ); // After trying connection delete the password.
	close();
}
