/***************************************************************************/
/* 		This code is part of WWW grabber called pavuk		   */
/*		Copyright (c) 1997 - 2001 Stefan Ondrejicka		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#ifdef HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif
#include <netdb.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/wait.h>
#include <signal.h>

#include "config.h"
#include "tools.h"
#include "bufio.h"

typedef struct {
	char	*h_name;
	int	h_length;
	char	*h_addres;
} dns_entry;

typedef struct {
	int num;
	dns_entry *e;
} htab_entry;

#define DNS_HASH_NUM 50
static htab_entry dns_htab[DNS_HASH_NUM];

#if defined(I_FACE) && !defined(HAVE_MT)

typedef struct {
	int	serial;
	int	status;
	int	syserr;
	int	herr;
	int	length;
	char	addr[64];
} dns_response_rec_t;

typedef struct {
	int	serial;
	char 	hostname[256];
} dns_request_rec_t;

static pid_t dns_pid = 0;
static bufio *dns_w = NULL;
static bufio *dns_r = NULL;

static void dns_serv_loop(in , out)
bufio *in;
bufio *out;
{
	struct hostent * host;
	int len;

	cfg.xi_face = FALSE;
	cfg.ctimeout = .0;

	for (;;)
	{	
		dns_request_rec_t req;
		dns_response_rec_t resp;

		if ((len = bufio_read(in, (char *)&req , sizeof(req))) != sizeof(req))
		{
			if (len) perror("dns server - protocol error");
			else printf("dns server - client exited\n");
			exit(1);
		}

		resp.serial = req.serial;

		if ((host = gethostbyname(req.hostname)))
		{
			resp.status = 0;
			resp.syserr = 0;
			resp.herr = 0;
			resp.length = host->h_length;
			memcpy(resp.addr, host->h_addr, host->h_length);
		}
		else
		{
			resp.status = -1;
			resp.syserr = errno;
			resp.herr = h_errno;
		}
		if (bufio_write(out , (char *)&resp , sizeof(resp)) != sizeof(resp))
		{
			perror("dns server - protocol error");
			exit(1);
		}
	}
}

int dns_serv_start()
{
	int cfd[2];
	int sfd[2];
	int i;

	for (i = 0 ; i < DNS_HASH_NUM ; i++)
	{
		dns_htab[i].num = 0;
		dns_htab[i].e = NULL;
	}

	if (pipe(cfd))
	{
		xperror("pipe");
		return -1;
	}

	if (pipe(sfd))
	{
		xperror("pipe");
		close(cfd[0]);
		close(cfd[1]);
		return -1;
	}

	if (!(dns_pid = fork()))
	{
		/* child */
		close(sfd[0]);
		close(cfd[1]);
		dns_serv_loop(bufio_fdopen(cfd[0]) , bufio_fdopen(sfd[1]));
		exit(0);
	}

	if (dns_pid < 0)
	{
		xperror("fork");
		close(cfd[0]);
		close(cfd[1]);
		close(sfd[0]);
		close(sfd[1]);
		return -1;
	}

	setpgid(0 , dns_pid);

	close(sfd[1]);
	close(cfd[0]);

	dns_w = bufio_fdopen(cfd[1]);
	dns_r = bufio_fdopen(sfd[0]);
	dns_pid = dns_pid;

	return 0;
}

void dns_server_kill()
{
	if (dns_pid)
	{
		kill(dns_pid , 15);
		waitpid(dns_pid , NULL , 0);
		bufio_close(dns_w);
		bufio_close(dns_r);
		dns_pid = 0;
		dns_w = NULL;
		dns_r = NULL;
	}
}

static int dns_cli_gethostbyname(host , len , addr)
char *host;
int *len;
char *addr;
{
	static int serno = 0;
	dns_request_rec_t req;
	dns_response_rec_t resp;

	serno++;

	req.serial = serno;
	memcpy(req.hostname, host, MIN(strlen(host)+1, sizeof(req.hostname) - 1));
	req.hostname[sizeof(req.hostname) - 1] = '\0';

	if (bufio_write(dns_w, (char *)&req, sizeof(req)) != sizeof(req))
	{
		xperror("dns client protocol error");
		return -1;
	}

	do
	{
		if (cfg.rbreak)
		{
			errno = EINTR;
			return -1;	
		}

		if (bufio_read(dns_r, (char *)&resp, sizeof(resp)) != sizeof(resp))
		{
			xperror("dns client protocol error");
			return -1;
		}
	} while (serno > resp.serial);

	if (resp.status)
	{
		h_errno = resp.herr;
		errno = resp.syserr;
		return -1;
	}
	else
	{
		h_errno = 0;
		memcpy(addr, resp.addr, resp.length);
		*len = resp.length;
		return 0;
	}
}
#endif /* I_FACE && !HAVE_MT */

int dns_gethostbyname(name , alen , addr)
char *name;
int *alen;
char *addr;
{
#ifdef HAVE_GETHOSTBYNAME_R
	struct hostent shost;
#endif
	struct hostent *host;
	int ret;
	int i;
	unsigned int hpos;

	LOCK_DNS
	hpos = hash_func(name , DNS_HASH_NUM);

	for (i = 0 ; i < dns_htab[hpos].num ; i++)
	{
		if (!strcasecmp(dns_htab[hpos].e[i].h_name , name))
		{
			*alen = dns_htab[hpos].e[i].h_length;
			memcpy(addr , dns_htab[hpos].e[i].h_addres , 
				dns_htab[hpos].e[i].h_length);
			UNLOCK_DNS
			return 0;
		}
	}
	UNLOCK_DNS

#if defined(I_FACE) && !defined(HAVE_MT)
	if (dns_pid)
	{
		ret = dns_cli_gethostbyname(name , alen , addr);
	}
	else
#endif
	{
#if defined(HAVE_GETHOSTBYNAME_R) && !(defined(__OSF__) || defined (__osf__))
{
		char sbuf[2048];
		int sherrno;
#if defined(__GLIBC__) && __GLIBC__ >= 2
		if (!gethostbyname_r(name, &shost, sbuf, sizeof(sbuf), &host, &sherrno))
#else
#if  defined (__OSF__) || defined (__osf__)
		struct hostent_data hdt;
		host = &shost;
		if (!gethostbyname_r(name, &shost, &hdt))
#else
		if ((host = gethostbyname_r(name, &shost, sbuf, sizeof(sbuf), &sherrno)))
#endif
#endif
		{
			_h_errno_ = 0;
			*alen = host->h_length;
			memcpy(addr , host->h_addr , host->h_length);
			ret = 0;
		}
		else
		{
			_h_errno_ = sherrno;
			ret = -1;
		}
}
#else
		LOCK_GHBN
		if ((host = gethostbyname(name)))
		{
			_h_errno_ = 0;
			*alen = host->h_length;
			memcpy(addr , host->h_addr , host->h_length);
			ret = 0;
		}
		else
		{
			_h_errno_ = h_errno;
			ret = -1;
		}
		UNLOCK_GHBN
#endif
	}

	LOCK_DNS
	if (!ret)
	{
		dns_htab[hpos].num++;
		dns_htab[hpos].e = _realloc(dns_htab[hpos].e , 
			dns_htab[hpos].num * sizeof(dns_entry));
		dns_htab[hpos].e[dns_htab[hpos].num - 1].h_name = new_string(name);
		dns_htab[hpos].e[dns_htab[hpos].num - 1].h_length = *alen;
		dns_htab[hpos].e[dns_htab[hpos].num - 1].h_addres = _malloc(*alen);
		memcpy(dns_htab[hpos].e[dns_htab[hpos].num - 1].h_addres , 
			addr , *alen);
	}
	UNLOCK_DNS

	return ret;
}

void dns_free_tab()
{
	int i,j;

	LOCK_DNS
	for (i = 0; i < DNS_HASH_NUM ; i++)
	{
		for(j = 0; j < dns_htab[i].num ; j++)
		{
			_free(dns_htab[i].e[j].h_name);
			_free(dns_htab[i].e[j].h_addres);
		} 
		_free(dns_htab[i].e);
	}
	UNLOCK_DNS
}

