// Copyright (c) 2000-2001 Brad Hughes <bhughes@trolltech.com>
//
// Use, modification and distribution is allowed without limitation,
// warranty, or liability of any kind.
//

#ifndef __configuration_h
#define __configuration_h

class Configuration;

#include <qobject.h>
#include <qiconset.h>
#include <qstring.h>

#include "organizer.h"
#include "mainvisual.h"
#include "configdialog.h"

class QWidget;
class QSettings;

class Prefs {
public:
    Prefs()
    {
    }

    virtual ~Prefs()
    {
    }

    virtual void init( QSettings &settings ) = 0;
    virtual void write( QSettings &settings ) = 0;
};

class RealConfigDialog : public ConfigDialog
{
    Q_OBJECT
public:
    RealConfigDialog(QWidget *);

    void init();
    void write();

public slots:
    void addPath();
    void removePath();
    void changeVisualPrefs( const QString &visualname );

private:
    Prefs *visualPrefs;
};

class Configuration : public QObject
{
    Q_OBJECT
public:
    Configuration(QObject *, const char * = 0);
    ~Configuration();

    void init();

public slots:
    void show();

signals:
    void configChanged();
};



#endif // __configuration_h
