#ifndef __htmlstreamh__
  #include "../htmlstream.h"
#endif

#ifndef __htmlh__
  #include "../html.h"
#endif

#ifndef __stringproch__
  #include "../stringproc.h"
#endif

#ifndef __pluginh__
  #include "../plugin.h"
#endif

#include <string>
#include <vector>

class dsoEcommerceMod :public Plugin{
public:
  dsoEcommerceMod();
  virtual void Init();
private:
  static void VALIDCARDNUM(const HTML& Cur,string& data,const vector<string>& params);
};

static dsoEcommerceMod initmodule;

dsoEcommerceMod::dsoEcommerceMod() {
  RegisterPlugin("ecommerce",1);
}

void dsoEcommerceMod::Init(){
  Plugin::RegisterFunction("VALIDCARDNUM",&dsoEcommerceMod::VALIDCARDNUM);
}

void dsoEcommerceMod::VALIDCARDNUM(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"VALIDCARDNUM",e_ParamNone);
  string::reverse_iterator pos;
  int mult=1,sum=0,prod,digits=0;
  for(pos=data.rbegin();pos!=data.rend();++pos){
    if(isdigit(*pos)){
      ++digits;
      prod=(*pos-'0')*mult;
      sum+=(prod%10)+(prod/10);
      mult=3-mult;
    }
  }
  if((digits>12)&&((sum%10)==0)) data="1"; else data="0";
}
