/* CConfigGroup.cpp */

#include "CConfigGroup.h"
#include <stdlib.h>
#include <stdio.h>

CConfigGroup::CConfigGroup(const QString& groupname)
{
  setName(groupname);
}

CConfigGroup::CConfigGroup()
{
}

void CConfigGroup::setName(const QString& gname)
{
  // assign group name
  groupname = gname;
}

void CConfigGroup::writeEntry(const QString& key, const QString& value)
{
  // replace or insert new key
  if( map.find( key)!= map.end() )
    map.replace(key, value);
  else
    map.insert(key, value);

}

const QString& CConfigGroup::readEntry(const QString& key, const QString& vdefault)
{
  // return value, if exists or default value
  const QString& tmp = map[key];
//qDebug("key is %s, default is %s", tmp.latin1(), vdefault.latin1());
if(tmp.find(key+" =",0,TRUE) !=-1)
return vdefault;
else
 // return vdefault;
  return (tmp.isEmpty() ? vdefault : tmp);
}

//  QFont readFontEntry( const QString& key,  const QFont* pDefault );
QFont CConfigGroup::readFontEntry( const QString& key, const QFont* pDefault )
{
  QFont aRetFont;
// QFont::QFont ( const QString & family, int pointSize, int weight, bool italic, CharSet charSet )

  QString aValue = readEntry( key );
  if( !aValue.isNull() )
    {
      // find first part (font family)    const QString & family
      int nIndex = aValue.find( ',' );
      if( nIndex == -1 )
      {
        if( pDefault )
          aRetFont = *pDefault;
        return aRetFont;
      }
      aRetFont.setFamily( aValue.left( nIndex ) );

      // find second part (point size)       int pointSize
      int nOldIndex = nIndex;
      nIndex = aValue.find( ',', nOldIndex+1 );
      if( nIndex == -1 )
      {
        if( pDefault )
          aRetFont = *pDefault;
        return aRetFont;
      }

      aRetFont.setPointSize( aValue.mid( nOldIndex+1,
                     nIndex-nOldIndex-1 ).toInt() );

      // find third part (style hint)          int weight
      nOldIndex = nIndex;
      nIndex = aValue.find( ',', nOldIndex+1 );

      if( nIndex == -1 )
      {
        if( pDefault )
          aRetFont = *pDefault;
        return aRetFont;
      }

      aRetFont.setStyleHint( (QFont::StyleHint)aValue.mid( nOldIndex+1,
                                                    nIndex-nOldIndex-1 ).toUInt() );

      // find fourth part (weight)             bool italic
      nOldIndex = nIndex;
      nIndex = aValue.find( ',', nOldIndex+1 );

      if( nIndex == -1 ){
        if( pDefault )
          aRetFont = *pDefault;
        return aRetFont;
      }

      aRetFont.setWeight( aValue.mid( nOldIndex+1,
                          nIndex-nOldIndex-1 ).toUInt() );

      // find fith part (font bits)
      uint nFontBits = aValue.right( aValue.length()-nIndex-1 ).toUInt();
      if( nFontBits & 0x01 )
        aRetFont.setItalic( true );
      else
        aRetFont.setItalic( false );

      if( nFontBits & 0x02 )
        aRetFont.setUnderline( true );
      else
        aRetFont.setUnderline( false );

      if( nFontBits & 0x04 )
        aRetFont.setStrikeOut( true );
      else
        aRetFont.setStrikeOut( false );

      if( nFontBits & 0x08 )
        aRetFont.setFixedPitch( true );
      else
        aRetFont.setFixedPitch( false );

      if( nFontBits & 0x20 )
        aRetFont.setRawMode( true );
      else
        aRetFont.setRawMode( false );


      // find sixth part (char set)     CharSet charSet
      nOldIndex = nIndex;
      nIndex = aValue.find( ',', nOldIndex+1 );

      if( nIndex == -1 )
      {
        if( pDefault )
          aRetFont = *pDefault;
        return aRetFont;
      }

     QString chStr=aValue.mid( nOldIndex+1,
                   nIndex-nOldIndex-1 );
     bool chOldEntry;
     QFont::CharSet chId=(QFont::CharSet)aValue.mid( nOldIndex+1,
                   nIndex-nOldIndex-1 ).toUInt(&chOldEntry);
     if (chOldEntry)
       aRetFont.setCharSet( chId );
     else if ( qApp)
     {
   //        if (chStr=="default")
//       charSetForLocale()
//              if( kapp->localeConstructed() )
//          chStr=klocale->charset();
//        else
chStr="iso-8859-1";
//     qApp->getCharsets()->setQFont(aRetFont,chStr);
     }

    }
  else {
    if( pDefault )
    aRetFont = *pDefault;
  }

  return aRetFont;
}

void CConfigGroup::writeFontEntry( const QString& key,  const QFont& rFont)
{
  QString aValue;
  QString aCharset;
  UINT8 nFontBits = 0;
  // this mimics get_font_bits() from qfont.cpp
  if( rFont.italic() )
    nFontBits = nFontBits | 0x01;
  if( rFont.underline() )
    nFontBits = nFontBits | 0x02;
  if( rFont.strikeOut() )
    nFontBits = nFontBits | 0x04;
  if( rFont.fixedPitch() )
    nFontBits = nFontBits | 0x08;
  if( rFont.rawMode() )
    nFontBits = nFontBits | 0x20;

  if ( qApp){

    aCharset =  rFont.encodingName ( QFont::charSetForLocale()  );
  }
  else aCharset="default";
 QString info = rFont.family();

//  aValue.sprintf( "%d,%d,%s,%d,%d", rFont.pointSize(),
//                rFont.styleHint(), (const char *)aCharset,
//                rFont.weight(), nFontBits );

  aValue.sprintf( "%d,%d,%d,%d,%s", rFont.pointSize(),
                  rFont.styleHint(),rFont.weight(), nFontBits, (const char *)aCharset );

// for some odd reason sprintf mangles rFont.family()
                  info = rFont.family()+","+aValue;

      map.replace(key, info);
}





