# PGB.pm - Initialization library for Gutenbook
# http://www.gutenbook.org/
# Copyright (C) 2000  Lee "Lefty" Burgess
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package PGB;

use FileHandle;
use File::Basename;
use Data::Dumper;
use Storable;
use Date::Calc qw(Delta_Days Compress Uncompress Today);
use HTML::Parser;

use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

require Exporter;
require AutoLoader;

@ISA = qw(Exporter AutoLoader);
@EXPORT = qw(gb_init BUG_ME $zip $unzip $prefs_file $marks_file 
	     $notes_file $index_file $plist_hash $config_dir $local_index 
	     Dumper fileparse Delta_Days Compress Uncompress Today
	     parse store retrieve);
$VERSION = '0.02';

$DEBUG = 0;

# $http_url = "http://www.viemeister.com/pub/gutenberg/";
# $http_url = "http://metalab.unc.edu/pub/docs/books/gutenberg/";
# $http_url = "http://www.prairienet.org/gutenberg/";
$zip = "/usr/bin/zip";
$unzip = "/usr/bin/unzip";

$index_file = "index";
$prefs_file = "preferences";
$marks_file = "bookmarks";
$notes_file = "annotations";

$config_dir = $ENV{'HOME'} . "/.gutenbook/";
$local_index = $config_dir . $index_file;

$plist_hash = { 'library_dir' => $ENV{'HOME'} . "/Gutenberg_Library", 
		'http_index' => 'http://www.gutenberg.net/pgwhole.zip',
		'http_url' => 'http://metalab.unc.edu/pub/docs/books/gutenberg/',
		'http_proxy' => '',
		'cache_local_index' => '',
		'update_index_always' => '',
		'update_index_never' => 1,
		'update_index_interval' => '',
		'update_index_days' => '',
		'update_index_date' => '',
		'always_download_etexts' => 1,
		'always_read_etexts' => 1,
		'main_window_small' => 1,
		'main_window_medium' => '',
		'main_window_large' => '' };

sub gb_init();
sub BUG_ME( $$ );

sub gb_init() {
  foreach ($config_dir, $plist_hash->{"library_dir"}) { 
    if (! -d $_) {
      umask(0022) || BUG_ME(0, "Cannot set umask: $!");
      mkdir($_, 0755) || BUG_ME(0, "Cannot make directory $_: $!");
    }
  }
}

sub BUG_ME( $$ ) {
  my ($die, $spam) = @_;
  warn("DEBUG: $spam\n") if $DEBUG;
  die("Killed by popular demand!\n") if $die;
  return;
}

1;
