/* $Id$
 * hipe_mkliterals.c
 */
#include <stdio.h>
#include <stddef.h>
#include <string.h>
#include <errno.h>
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "sys.h"
#include "erl_vm.h"
#include "global.h"
#include "erl_process.h"
#include "error.h"
#include "erl_bits.h"

static const struct literal {
    const char *name;
    unsigned long value;
} literals[] = {
    /* Field offsets in a process struct */
    { "P_HP", offsetof(struct process, htop) },
#ifdef UNIFIED_HEAP
    { "P_HP_LIMIT", offsetof(struct process, hend) },
#else
    { "P_HP_LIMIT", offsetof(struct process, stop) },
#endif
    { "P_ID", offsetof(struct process, id) },
    { "P_FLAGS", offsetof(struct process, flags) },
    { "P_FVALUE", offsetof(struct process, fvalue) },
    { "P_FREASON", offsetof(struct process, freason) },
    { "P_FCALLS", offsetof(struct process, fcalls) },
    { "P_OFF_HEAP_FUNS", offsetof(struct process, off_heap.funs) },
    { "P_BEAM_IP", offsetof(struct process, i) },
    { "P_ARITY", offsetof(struct process, arity) },
    { "P_ARG0", offsetof(struct process, def_arg_reg[0]) },
    { "P_ARG1", offsetof(struct process, def_arg_reg[1]) },
    { "P_ARG2", offsetof(struct process, def_arg_reg[2]) },
    { "P_ARG3", offsetof(struct process, def_arg_reg[3]) },
    { "P_ARG4", offsetof(struct process, def_arg_reg[4]) },
    { "P_NSP", offsetof(struct process, hipe.nsp) },
    { "P_NCALLEE", offsetof(struct process, hipe.ncallee) },
    { "P_CLOSURE", offsetof(struct process, hipe.closure) },
#if defined(__sparc__)
    { "P_NSP_LIMIT", offsetof(struct process, hipe.nstend) },
    { "P_NRA", offsetof(struct process, hipe.nra) },
    { "P_CRA", offsetof(struct process, hipe.ncra) },
#elif defined(__i386__)
    { "P_NSP_LIMIT", offsetof(struct process, hipe.nstack) },
    { "P_CSP", offsetof(struct process, hipe.ncsp) },
    { "P_NARITY", offsetof(struct process, hipe.narity) },
#endif

    /* process flags bits */
    {  "F_TIMO", F_TIMO },

    /* freason codes */
    { "FREASON_THROWN", THROWN },
    { "FREASON_USER_EXIT", USER_EXIT },
    { "FREASON_USER_ERROR", USER_ERROR },
    { "FREASON_USER_ERROR2", USER_ERROR2 },
    { "FREASON_TRAP", TRAP },
    { "FREASON_RESCHEDULE", RESCHEDULE },

    /* special Erlang constants */
    { "ERL_NIL", NIL },
    { "THE_NON_VALUE", THE_NON_VALUE },

    /* special HiPE constants */
    { "HIPE_SPARC_LEAF_WORDS", HIPE_SPARC_LEAF_WORDS },

    /* funs */
    { "EFE_BUCKET", offsetof(struct erl_fun_entry, bucket) },
    { "EFE_OLD_UNIQ", offsetof(struct erl_fun_entry, old_uniq) },
    { "EFE_OLD_INDEX", offsetof(struct erl_fun_entry, old_index) },
    { "EFE_ADDRESS", offsetof(struct erl_fun_entry, address) },
    { "EFE_NATIVE_ADDRESS", offsetof(struct erl_fun_entry, native_address) },
    { "EFE_MODULE", offsetof(struct erl_fun_entry, module) },
    { "EFE_REFC", offsetof(struct erl_fun_entry, refc) },
    { "EFT_THING", offsetof(struct erl_fun_thing, thing_word) },
    { "EFT_NEXT", offsetof(struct erl_fun_thing, next) },
    { "EFT_CREATOR", offsetof(struct erl_fun_thing, creator) },
    { "EFT_FE", offsetof(struct erl_fun_thing, fe) },
    { "EFT_NATIVE_ADDRESS", offsetof(struct erl_fun_thing, native_address) },
    { "EFT_ARITY", offsetof(struct erl_fun_thing, arity) },
    { "EFT_NUM_FREE", offsetof(struct erl_fun_thing, num_free) },
    { "EFT_ENV", offsetof(struct erl_fun_thing, env[0]) },
    { "ERL_FUN_SIZE", ERL_FUN_SIZE },

    /* bit synatax */
    { "BSF_ALIGNED", BSF_ALIGNED},
    { "BSF_LITTLE", BSF_LITTLE},
    { "BSF_SIGNED", BSF_SIGNED},
    { "BSF_EXACT", BSF_EXACT},
};
#define NLITERALS ((sizeof literals)/sizeof(literals[0]))

static void c_print1(FILE *fp, const struct literal *literal)
{
    fprintf(fp, "#define %s %lu\n", literal->name, literal->value);
}

static void e_print1(FILE *fp, const struct literal *literal)
{
    fprintf(fp, "-define(%s,%lu).\n", literal->name, literal->value);
}

static void printall(FILE *fp, void (*print1)(FILE*,const struct literal*))
{
    int i;

    for(i = 0; i < NLITERALS; ++i)
	(*print1)(fp, &literals[i]);
}

static int do_c(FILE *fp)
{
    fprintf(fp, "/* File: hipe_literals.h, generated by hipe_mkliterals */\n");
    fprintf(fp, "#ifndef __HIPE_LITERALS_H__\n");
    fprintf(fp, "#define __HIPE_LITERALS_H__\n\n");
    printall(fp, c_print1);
    fprintf(fp, "\n#endif\n");
    return 0;
}

static int do_e(FILE *fp)
{
    fprintf(fp, "%% File: hipe_literals.hrl, generated by hipe_mkliterals\n\n");
    printall(fp, e_print1);
    return 0;
}

int main(int argc, const char **argv)
{
    if( argv[1] ) {
	if( strcmp(argv[1], "-c") == 0 )
	    return do_c(stdout);
	if( strcmp(argv[1], "-e") == 0 )
	    return do_e(stdout);
    }
    fprintf(stderr, "usage: %s [-c | -e] > output-file\n", argv[0]);
    return 1;
}
