/* hey emacs! -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * ddtd.h
 *   header file for client daemon.
 *
 * $Id: ddtd.h,v 1.23 2001/11/24 21:11:50 benoit Exp $
 *
 * Copyright (c) 2000 Remi Lefebvre <remi@dhis.net>
 *                and Luca Filipozzi <lfilipoz@dhis.net>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "global.h"

#define PID_FILE  PID_DIR  "/ddt/ddtd.pid"
#define LOG_FILE  LOG_DIR  "/ddtd.log"
#define CONF_FILE CONF_DIR "/ddtd.conf"

#define TIMEOUT (5 * 60)

#include <pwd.h>
#include <grp.h>
#include <fcntl.h>
#include <pthread.h>
#include <signal.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <errno.h>
#include <opt.h>

#include "Exception.h"
#include "Logger.h"

#include "DdtManager.h"
#include "DbPsql.h"
#include "DnsBind.h"

#include "Options.h"
#include "Thread.h"
#include "UDP.h"
#include "packets.h"
#include "DdtMD.h"
#include "DdtCipher.h"
#include "Packet.h"

#ifndef DDTD_H
#define DDTD_H

class Server; // forward delcaration

class SendThread : public Thread
{
  public:
    SendThread(Server*);

    void *run (void *);
    void cleanUp();

  private:
};

class Server
{
  public:
    Server();
    ~Server();

    int alreadyRunning ();
    int parseArgs(int *argc, char ***argv);
    int becomeDaemon();
    int run();

    /**
     * handles receiving and processing of
     * UPDATE_QUERY and ALIVE_REPLY packets
     */
    int receiver();

    /**
     * handles sending ALIVE_QUERY packets
     * and prunes the "stale" entries
     */
    void validateActiveAccounts();
        
  private:
    static void processActiveAccount (int accountId,
                                      unsigned long addr,
                                      time_t lastAccessTime);

    int processReceivedPacket (DdtpPacket* pkt,
                               int accountId,
                               char* db_password);
    int processDDTPv1UpdateQuery (DDTPv1UpdateQuery* updateQuery,
                                  DDTPv1UpdateReply* updateReply,
                                  int accountId,
                                  char* db_password);

    int processDDTPv1AliveReply (DDTPv1AliveReply* aliveReply,
                                 int accountId);

    static void atexit_handler ();
    static void signal_handler (int signum);

    static Logger *log;
    static Options *opts;
    static UDP *udp;

    static DdtManager *manager;
    static Db *db;
    static Dns *dns;
    
    static Mutex *mutex;

    SendThread *sendThread;
};

#endif // DDTD_H
