#include <string>
#include <iostream>
#include <vector>
#include <ace/Synch.h>

#define ST_ROUND_ROBIN = 0;
#define ST_LEAST_USED = 1;
#define ST_LEAST_RECENTLY_USED = 2;

class DBPool;
class DBBalancerConfig;
class DBPooledConnection;

class DBPoolContainer {

public:

  DBPoolContainer(DBBalancerConfig* db, unsigned int mode);
  ~DBPoolContainer();
  void processConnection(int socket);
  DBPooledConnection *getConnectionForTest();
  DBPooledConnection *getPooledConnection(int strategy);
  void adjustConnections(int threadGain);
  unsigned int getPoolNumber() { return _pools.size(); };
    
private:

  // Methods

  DBPool* getPool(int strategy);

  // Do different init work, depending on the task that the
  // daemon will do.
  void initAsReader();
  void initAsWriter();

  // Grow and Shrink implementation, both modes
  void growReaderMode(int conns);
  void shrinkReaderMode(int conns);
  void growWriterMode(int conns);
  void shrinkWriterMode(int conns);

  // Attributes

  // The pools and the number of them;
  vector<DBPool*> _pools;

  // Strategy por balancing.
  unsigned int _current_strategy;

  // Mutexes and indexes for the currently used and tested pools.
  ACE_Thread_Mutex _used_pool_mutex;
  ACE_Thread_Mutex _tested_pool_mutex;
  unsigned int _used_pool_index;
  unsigned int _tested_pool_index;

  // The config source
  DBBalancerConfig* _config;

  // The working mode: DBBalancer::READER_PROCESS or DBBalancer::WRITER_PROCESS
  unsigned int _mode;

  // We need this info to create connections in DBBalancer::READER_PROCESS mode.

  // We need this info to create connections in DBBalancer::WRITER_PROCESS mode.
  vector<string> _users;
  vector<string> _passwords;
  vector<string> _dbs;
  vector<string> _hosts;
  vector<int> _ports;

};

