#include <fstream>
#include <stdio.h>
#include "conn_pool/DBPoolContainer.hh"
#include "thread_pool/DBThreadPool.hh"
#include "DBBalancer.hh"
#include "config/DBBalancerConfig.hh"
#include "method_objects/DBDoConnectionMO.hh"
#include "method_objects/DBManagementMO.hh"


DBBalancer::DBBalancer(DBBalancerConfig *config, unsigned int mode) {

  // We should substitute all these instantiations by three Singletons so they could
  // be easily reached. The same will occur with DBBalancerConfig class.

  _config = config;
  _dbpc = new DBPoolContainer(_config, mode);
  _threadPool = new DBThreadPool(config->getDaemonInitThreads(),config->getDaemonMinThreads(),config->getDaemonMaxThreads());

  // Starting the connection Growing/Reaping/Testing thread.
  unsigned int delay = _config->getDaemonReaperDelay();

  if (delay>0)
    _threadPool->submit(new DBManagementMO(this,delay));
  
}

DBBalancer::~DBBalancer() {

  delete _dbpc;
  delete _threadPool;

  ACE_DEBUG((LM_DEBUG,"Destroying DBBalancer.\n"));

}

// This is the main request processing method, called by the Daemon.

void DBBalancer::processConnection(int socket) {

  _threadPool->submit(new DBDoConnectionMO(_dbpc,socket));

}



/*
void DBBalancer::checkmem(string message) {

  char file[127];
  string tmp;
  int ncampo = 23;

  sprintf(file,"/proc/%d/stat",getpid());
  ifstream f(file);
  for (int i=0;i<ncampo;i++) f >> tmp;
  f.close();

  ACE_DEBUG((LM_DEBUG,"DBBalancerMEM: (%s) (pid= %d, mem=#%s#) ",message.c_str(),getpid(),tmp.c_str()));

}
*/
