/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <errno.h>
#include <stdlib.h>

#include 	"ListP.h"
#include	"Init.h"
#include	"cvt.h"
#include	"LabelMEP.h"
#include	"misc.h"

#ifdef HAVE_SCROLLLIST
#include	"ScrollListP.h"
#endif

static XtResource listConstraintsResources [] = {
        {
         XtNtop_space ,
         XtCTop_space ,
         XtRInt ,
         sizeof(int) ,
         XtOffsetOf(ListConstraintsRec , col.top_space) ,
         XtRImmediate ,
         (XtPointer) 0
        },
        {
         XtNbottom_space ,
         XtCBottom_space ,
         XtRInt ,
         sizeof(int) ,
         XtOffsetOf(ListConstraintsRec , col.bottom_space) ,
         XtRImmediate ,
         (XtPointer) 0
        },
};

#define offset(field) XtOffsetOf(ListRec , list.field)

static XtResource resources[] = { 
	{
	 XtNfont ,
	 XtCFont ,
	 XtRFontStruct ,
	 sizeof(XFontStruct *) ,
	 offset(font) ,
	 XtRString ,
	 (XtPointer) XtDefaultFont
	},
	{
	 XtNnum_entry ,
	 XtCNum_entry ,
	 XtRInt ,
	 sizeof(int) ,
	 offset(num_entry) ,
	 XtRImmediate ,
	 (XtPointer) 0
	},
	{
	 XtNnum_selected ,
	 XtCNum_selected ,
	 XtRInt ,
	 sizeof(int) ,
	 offset(num_selected) ,
	 XtRImmediate ,
	 (XtPointer) 0
	},
	{
	 XtNselect_cb ,
	 XtCSelect_cb ,
	 XtRCallback ,
	 sizeof(XtCallbackList) ,
	 offset(select_cb) ,
	 XtRImmediate ,
	 (XtPointer) NULL
	},
	{
	 XtNselect_changed_cb ,
	 XtCSelect_changed_cb ,
	 XtRCallback ,
	 sizeof(XtCallbackList) ,
	 offset(select_changed_cb) ,
	 XtRImmediate ,
	 (XtPointer) NULL
	},
	{
	 XtNselected_fg ,
	 XtCSelected_fg ,
	 XtRPixel ,
	 sizeof(Pixel) ,
	 offset(selected_fg) ,
	 XtRString ,
	 (XtPointer) XtDefaultBackground
	},
	{
	 XtNselected_bg ,
	 XtCSelected_bg ,
	 XtRPixel ,
	 sizeof(Pixel) ,
	 offset(selected_bg) ,
	 XtRString ,
	 (XtPointer) XtDefaultForeground
	},
	{
	 XtNlist ,
	 XtCList ,
	 XtRListStruct ,
	 sizeof(ListStruct *) ,
	 offset(list) ,
	 XtRImmediate ,
	 (XtPointer) NULL
	},
	{
	 XtNtraverse ,
	 XtCTraverse ,
	 XtRBoolean ,
	 sizeof(Boolean) ,
	 XtOffsetOf(ListRec , baseConst.traverse) ,
	 XtRImmediate ,
	 (XtPointer) False ,
	},
};

static void ClassInitialize();
static void ResolveInheritance();
static void Initialize();
static void Redisplay();
static void ChangeManaged();

static void _StartSelecting ();
static void StartSelecting ();
static void Selecting ();
static void ActivateDouble ();
static void Activate ();
static void Select();

static void GetPositionEntry ();

static XtActionsRec action [] = {
	{"start_selecting" , StartSelecting},
	{"selecting" , Selecting },
	{"activate" , Activate},
	{"select" , Select},
	};


static char trans_tab [] =
	"<Btn1Down>: start_selecting() focusCurrent() \n\
	 <Btn1Motion>: selecting() \n\
	 <Key>Return: activate() \n\
	 <Key>Up: select(previous) \n\
	 <Key>Down: select(next) \n\
	 <Key>Home: select(first) \n\
	 <Key>End: select(last) \n\
	 <Key>Prior: select(previous_page) \n\
	 <Key>Next: select(next_page) \n\
	 ~Shift<Key>Tab: traverseForward()\n\
	 Shift<Key>Tab: traverseBackward()\n\
	 <FocusIn>: focusIn()\n\
	 <FocusOut>: focusOut()\n\
	 <BtnDown>: focusCurrent()\n\
	 ";

ListClassRec listClassRec = {
/* core */
   {
    /* superclass            */ (WidgetClass) &colClassRec,
    /* class_name            */ "List",
    /* widget_size           */ sizeof(ListRec),
    /* class_initialize      */ ClassInitialize,
    /* class_part_initialize */ ResolveInheritance,
    /* class_inited          */ FALSE,
    /* initialize            */ Initialize,
    /* initialize_hook       */ NULL,
    /* realize               */ XtInheritRealize,
    /* actions               */ action,
    /* num_actions           */ XtNumber(action),
    /* resources             */ resources,
    /* num_resources         */ XtNumber(resources),
    /* xrm_class             */ NULLQUARK,
    /* compress_motion       */ False,
    /* compress_exposure     */ False,
    /* compress_enterleave   */ False,
    /* visible_interest      */ FALSE,
    /* destroy               */ NULL,
    /* resize                */ XtInheritResize,
    /* expose                */ Redisplay,
    /* set_values            */ NULL,
    /* set_values_hook       */ NULL,
    /* set_values_almost     */ XtInheritSetValuesAlmost,
    /* get_values_hook       */ NULL,
    /* accept_focus          */ XtInheritAcceptFocus,
    /* version               */ XtVersion,
    /* callback_private      */ NULL,
    /* tm_table              */ trans_tab,
    /* query_geometry        */ XtInheritQueryGeometry,
    /* display_accelerator   */ XtInheritDisplayAccelerator,
    /* extension             */ NULL
   },
/* composite */
   {
    /* geometry_manager	     */ XtInheritGeometryManager,
    /* change_managed	     */ ChangeManaged,
    /* insert_child	     */ XtInheritInsertChild,
    /* delete_child	     */ XtInheritDeleteChild,
    /* extension	     */ NULL
   },
   {
/* constraint */
    /* subresourses       */   listConstraintsResources,
    /* subresource_count  */   XtNumber(listConstraintsResources),
    /* constraint_size    */   sizeof(ListConstraintsRec),
    /* initialize         */   NULL,
    /* destroy            */   NULL,
    /* set_values         */   NULL,
    /* extension          */   NULL
   },
/* baseConst */
   {
    /* get_internal_dimension  */ XtInheritGetInternalDimension,
    /* set_internal_dimension  */ XtInheritSetInternalDimension,
    /* traverse                */ XtInheritTraverse,
    /* traverseTo              */ XtInheritTraverseTo,
    /* traverseOut	       */ XtInheritTraverseOut,
    /* traverseInside          */ XtInheritTraverseInside,
    /* highlightBorder         */ XtInheritHighlightBorder,
    /* unhighlightBorder       */ XtInheritUnhighlightBorder,
   },
/* col */
   {
    /* empty		       */ 0
   },
/* list */
   {
    /* empty		       */ 0
   },
};


WidgetClass listWidgetClass = (WidgetClass) & listClassRec;

#define ForAllChildren(cw, childP) \
	for ( (childP) = (BaseMEObject *) (cw)->composite.children ; \
		(childP) < (BaseMEObject *) ((cw)->composite.children + \
		(cw)->composite.num_children ) ; \
		(childP)++ )

static void ClassInitialize()
{
	_InitializeWidgetSet();

	XtSetTypeConverter(XtRString, XtRListStruct, cvtStringToListStruct,
		NULL, 0, XtCacheNone, NULL);
}

static void ResolveInheritance(class)
WidgetClass class;
{
        ListWidgetClass c = (ListWidgetClass) class;

        static CompositeClassExtensionRec extension_rec = {
                NULL, NULLQUARK, XtCompositeExtensionVersion,
                sizeof(CompositeClassExtensionRec), True };
        CompositeClassExtensionRec *ext;

        ext = (XtPointer)XtMalloc(sizeof(*ext));
        *ext = extension_rec;
        ext->next_extension = c->composite_class.extension;
        c->composite_class.extension = ext;
}

static void Initialize(req_widget,new_widget,args,num_args)
Widget req_widget;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	ListWidget nw = (ListWidget) new_widget;

	nw->list.w_list = NULL;
	nw->list.last_selected = NULL;
	nw->list.double_click_timer = (XtIntervalId) 0;

	if (nw->list.list)
	{
		ListChange(new_widget , nw->list.list , nw->list.num_entry , False);
	}

}

static void Redisplay(w,event,region)
Widget w;
XEvent * event;
Region  region;
{
	ListWidget cw = (ListWidget) w;
        BaseMEObject * entry;   
        BaseMEObjectClass class;

	if (!XtIsManaged(w)) colClassRec.core_class.expose(w,event,region);

        ForAllChildren(cw, entry)
        {
                if (!XtIsManaged ( (Widget) *entry)) continue;

                if (region != NULL) 
                        switch(XRectInRegion(region , (*entry)->rectangle.x,
                                (*entry)->rectangle.y , (*entry)->rectangle.width ,
                                (*entry)->rectangle.height)) 
                        {

                                case RectangleIn:
                                case RectanglePart:
                                        break;
                                default:
                                        continue;
                        }
                class = (BaseMEObjectClass) (*entry)->object.widget_class;

                if (class->rect_class.expose != NULL)
                        (class->rect_class.expose)( (Widget) *entry, NULL, NULL);
        }

}

static void ChangeManaged(w)
Widget w;
{
	XtWidgetGeometry intended , preferred;

	intended.request_mode = CWWidth | CWHeight;
	intended.width = 0;
	intended.height = 0;

	((ListWidgetClass)XtClass(w))->core_class.query_geometry(w,&intended,&preferred);

	preferred.request_mode = CWWidth | CWHeight;

	XtMakeGeometryRequest(w , &preferred , &intended);

	colClassRec.composite_class.change_managed(w);
}


void ListChange(w , list , num_items , free_old)
Widget w;
ListStruct *list;
int num_items;
Boolean free_old;
{
	ListWidget cw = (ListWidget) w;
	int i;

	XtUnmanageChild(w);

	XtUnmanageChildren(cw->list.w_list,cw->list.num_entry);
	if (free_old)
	{
		for (i = 0 ; i < cw->list.num_entry ; i++)
		{
			XtFree((void *)cw->list.list[i].label);
			XtDestroyWidget(cw->list.w_list[i]);
		}
		if (cw->list.list)
		{
			XtFree((void *)cw->list.list);
			XtFree((void *)cw->list.w_list);
		}


	}

	cw->list.num_entry = num_items;
	cw->list.list = list ? (ListStruct *)XtCalloc(num_items , sizeof(ListStruct)) : NULL;
	cw->list.w_list = list ? (WidgetList)XtCalloc(num_items , sizeof(Widget)) : NULL;

	for (i = 0 ; i < num_items ; i++)
	{
		cw->list.list[i].index = i;
		cw->list.list[i].right_icon = list[i].right_icon;
		cw->list.list[i].left_icon = list[i].left_icon;
		cw->list.list[i].label = XtNewString(list[i].label);

		cw->list.w_list[i] = XtVaCreateWidget(cw->list.list[i].label ,
			labelMEObjectClass , w ,
			XtNlabel , cw->list.list[i].label ,
			XtNbackground , cw->core.background_pixel ,
			XtNforeground , cw->baseConst.foreground ,
			XtNfont , cw->list.font ,
			XtNactiv_fg , cw->list.selected_fg ,
			XtNactiv_bg , cw->list.selected_bg ,
			XtNleft_icon , cw->list.list[i].left_icon ,
			XtNright_icon , cw->list.list[i].right_icon ,
			XtNspacing , 2 ,
			XtNlabel_justify , XtCleft ,
			NULL);
	}
	cw->list.last_selected = NULL;
	XtManageChildren(cw->list.w_list,cw->list.num_entry);
	XtManageChild(w);
}

int ListAppendItems(w , list , num_items)
Widget w;
ListStruct *list;
int num_items;
{
	ListWidget cw = (ListWidget) w;
	int i;

	if (num_items < 1 || !list)
	{
		XtWarning("ListAppendItems function called with wrong parameter");
		return -1;
	}

	XtUnmanageChild(w);

	XtUnmanageChildren(cw->list.w_list,cw->list.num_entry);

	cw->list.list = (ListStruct *) XtRealloc((void *) cw->list.list , 
		sizeof(ListStruct) * (cw->list.num_entry + num_items));

	cw->list.w_list = (WidgetList) XtRealloc((void *) cw->list.w_list ,
		sizeof(Widget) * (cw->list.num_entry + num_items ));


	for (i = cw->list.num_entry ; i < (cw->list.num_entry + num_items) ; i++)
	{
		cw->list.list[i].index = i;
		cw->list.list[i].left_icon = list[i - cw->list.num_entry].left_icon;
		cw->list.list[i].right_icon = list[i - cw->list.num_entry].right_icon;
		cw->list.list[i].label = XtNewString(list[i - cw->list.num_entry].label);
		cw->list.list[i].sensitive = list[i - cw->list.num_entry].sensitive;
		cw->list.list[i].related_info = list[i - cw->list.num_entry].related_info;

		cw->list.w_list[i] = XtVaCreateWidget(cw->list.list[i].label ,
			labelMEObjectClass , w ,
			XtNlabel , cw->list.list[i].label ,
			XtNbackground , cw->core.background_pixel ,
			XtNforeground , cw->baseConst.foreground ,
			XtNfont , cw->list.font ,
			XtNactiv_fg , cw->list.selected_fg ,
			XtNactiv_bg , cw->list.selected_bg ,
			XtNleft_icon , cw->list.list[i].left_icon ,
			XtNright_icon , cw->list.list[i].right_icon ,
			XtNspacing , 2 ,
			XtNlabel_justify , XtCleft ,
			NULL);
		
	}
	cw->list.num_entry += num_items;

	XtManageChildren(cw->list.w_list,cw->list.num_entry);
	XtManageChild(w);
	return cw->list.num_entry;
}

static void StartSelecting (w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	ListWidget cw = (ListWidget) w;
	BaseMEObject * entry = NULL;
	BaseMEObjectClass class;


	GetPositionEntry(w , event->xbutton.x , event->xbutton.y ,
		event , &entry);

	if (entry)
	{
		if (cw->list.last_selected && ((Widget) *entry) != cw->list.last_selected)
		{
			class = (BaseMEObjectClass) 
				((BaseMEObject)cw->list.last_selected)
				->object.widget_class;

			((BaseMEObject)cw->list.last_selected)->baseME.entered = False;

			if (class->rect_class.expose)
				class->rect_class.expose(cw->list.last_selected,
					NULL , NULL);

		}

		cw->list.last_selected = (Widget)*entry;

		class = (BaseMEObjectClass) (*entry)->object.widget_class;

		(* entry)->baseME.entered = True;
		if (class->rect_class.expose)
			class->rect_class.expose((Widget) *entry , NULL , NULL);

		if (cw->list.double_click_timer)
		{
			XtRemoveTimeOut(cw->list.double_click_timer);
			cw->list.double_click_timer = (XtIntervalId) 0;
			ActivateDouble(w);
		}
		else
		{
			cw->list.double_click_timer = XtAppAddTimeOut(
				XtWidgetToApplicationContext(w), 
				(unsigned long) _DCtimeout ,
				_StartSelecting , (XtPointer) w);
		}
	}

}

static void _StartSelecting (client_data , timer)
XtPointer  client_data;
XtIntervalId * timer;
{

	ListWidget cw = (ListWidget) client_data;


	cw->list.double_click_timer = (XtIntervalId) 0;

	XtCallCallbackList((Widget) cw , cw->list.select_changed_cb ,
		(XtPointer) &cw->list.list[cw->list.selected_idx]);

}


static void Selecting (w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	ListWidget cw = (ListWidget) w;
	BaseMEObject * entry = NULL;
	BaseMEObjectClass class;

	GetPositionEntry(w , 5 , event->xmotion.y , event , &entry);

	if (entry && (Widget) *entry != cw->list.last_selected)
	{
		if (cw->list.last_selected)
		{
			class = (BaseMEObjectClass) 
				((BaseMEObject)cw->list.last_selected)
				->object.widget_class;

			((BaseMEObject)cw->list.last_selected)->baseME.entered = False;

			if (class->rect_class.expose)
				class->rect_class.expose(cw->list.last_selected ,
					NULL , NULL);
		}
		class = (BaseMEObjectClass) (*entry)->object.widget_class;

		(* entry)->baseME.entered = True;

		if (class->rect_class.expose)
			class->rect_class.expose((Widget) *entry , NULL , NULL);

		cw->list.last_selected = (Widget)*entry;

		XtCallCallbackList(w , cw->list.select_changed_cb ,
				(XtPointer) &cw->list.list[cw->list.selected_idx]);

	}
	if (entry) cw->list.last_selected = (Widget)*entry;

}

static void ActivateDouble(w)
Widget w;
{
	ListWidget cw = (ListWidget) w;

	cw->list.double_click_timer = (XtIntervalId) 0;

	if (cw->list.last_selected)
	{

		XtCallCallbackList((Widget) cw , cw->list.select_changed_cb ,
			(XtPointer) &cw->list.list[cw->list.selected_idx]);

		XtCallCallbackList((Widget) cw , cw->list.select_cb ,
			(XtPointer) &cw->list.list[cw->list.selected_idx]);
	}
}

static void Activate (w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	ListWidget cw = (ListWidget) w;

	if (cw->list.last_selected)
	{
		XtCallCallbackList(w , cw->list.select_cb ,
				(XtPointer) &cw->list.list[cw->list.selected_idx]);
	}
}


static void Select (w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	ListWidget cw = (ListWidget) w;
	BaseMEObjectClass class;
	int idx;

	if (*num_params != 1)
	{
		XtWarning("Action 'select' called with wrong parameters count");
		return;
	}
	if (!cw->list.num_entry) return;

	if (!cw->list.last_selected)
	{
		idx = 0;
	}
	else
	{
		idx = cw->list.selected_idx;

#ifdef HAVE_SCROLLLIST
		if ((! strcmp(params[0] , "next_page")) ||
		    (! strcmp(params[0] , "previous_page")))
		{
			if ((XtClass(XtParent(w))) == scrollListWidgetClass)
			XtCallActionProc(XtParent(w) , "select" , event , params , 1);	
			return;
		}
		else
#endif
		if (! strcmp(params[0] , "next"))
		{
			idx += (idx < (cw->list.num_entry - 1));
		}
		else if (! strcmp(params[0] , "previous"))
		{
			idx -= (idx != 0);
		}
		else if (! strcmp(params[0] , "first"))
		{
			idx = 0;
		}
		else if (! strcmp(params[0] , "last"))
		{
			idx = cw->list.num_entry - 1;
		}
		else 
		{
			idx += atoi(params[0]);
			if (errno == ERANGE)
			{
				XtWarning("Action 'select' called with wrong parameter");
				return;
			}
			if (idx < 0) idx = 0;
			if (idx > (cw->list.num_entry - 1)) idx = cw->list.num_entry - 1;
		}
	}
	if (cw->list.w_list[idx] != cw->list.last_selected)
	{
		if (cw->list.last_selected)
		{
			class = (BaseMEObjectClass) 
				((BaseMEObject)cw->list.last_selected)
				->object.widget_class;

			((BaseMEObject)cw->list.last_selected)->baseME.entered = False;

			if (class->rect_class.expose)
				class->rect_class.expose(cw->list.last_selected ,
					NULL , NULL);
		}

		class = (BaseMEObjectClass) 
			((BaseMEObject)cw->list.w_list[idx])->object.widget_class;

		((BaseMEObject)cw->list.w_list[idx])->baseME.entered = True;

		if (class->rect_class.expose)
			class->rect_class.expose(cw->list.w_list[idx] , NULL , NULL);

		cw->list.last_selected = cw->list.w_list[idx];

		XtCallCallbackList(w , cw->list.select_changed_cb ,
				(XtPointer) &cw->list.list[idx]);

	}
	cw->list.last_selected = cw->list.w_list[idx];
	cw->list.selected_idx = idx;
}

static void GetPositionEntry(w , x , y , event , entry )
Widget w;
int x;
int y;
XEvent *event;
BaseMEObject **entry;
{
	ListWidget cw = (ListWidget) w;
	BaseMEObject * pentry;
	Position pomx , pomy;
	Dimension width , height;
	int i=-1;

	if (XtWindow(w) != event->xany.window) return;

	listClassRec.baseConst_class.get_internal_dimension(w , &pomx , &pomy , 
		&width , &height);

	if ((x < pomx) || (x > pomx + width) || (y < pomy) || (y > pomy + height)) return;
	
	ForAllChildren(cw , pentry)
	{
		i++;
		if (!XtIsManaged ((Widget) *pentry)) continue;

		if ( ( (*pentry)->rectangle.y <= y) && (( (*pentry)->rectangle.y +
			(int) (*pentry)->rectangle.height) >= y) &&
			(*pentry)->rectangle.sensitive)
		{
			*entry = pentry;
			cw->list.selected_idx = i;
			return;
		}
	}
}

void FreeList(list,num)
ListStruct *list;
int num;
{
	int i;
	for (i = 0; i < num ; i++)
	{
		XtFree(list[i].label);
	}
	XtFree((char *)list);
}

ListStruct *SetSelected(w , which)
Widget w;
int which;
{
	ListWidget cw = (ListWidget) w;
	int idx = which;
	BaseMEObjectClass class;

	if ((!cw->list.num_entry) || (which < 0) || ((which + 1) > cw->list.num_entry)) 
		return NULL;

	if (cw->list.selected_idx == idx && 
		cw->list.last_selected == cw->list.w_list[idx]) return NULL;

	if (cw->list.last_selected)
	{
		class = (BaseMEObjectClass) 
			((BaseMEObject)cw->list.w_list[cw->list.selected_idx])
			->object.widget_class;

		((BaseMEObject)cw->list.w_list[cw->list.selected_idx])
			->baseME.entered = False;

		if (class->rect_class.expose)
			class->rect_class.expose(cw->list.w_list[cw->list.selected_idx] ,
				NULL , NULL);
	}

	class = (BaseMEObjectClass) 
		((BaseMEObject)cw->list.w_list[idx])->object.widget_class;

	((BaseMEObject)cw->list.w_list[idx])->baseME.entered = True;

	if (class->rect_class.expose)
		class->rect_class.expose(cw->list.w_list[idx] , NULL , NULL);

	cw->list.selected_idx = idx;
	cw->list.last_selected = cw->list.w_list[idx];

	XtCallCallbackList(w , cw->list.select_changed_cb ,
				(XtPointer) &cw->list.list[idx]);

	return &cw->list.list[idx];
}

void DeleteListItem(w , which)
Widget w;
int which;
{
	ListWidget cw = (ListWidget) w;
	int i;
	Widget del;

	if ((!cw->list.num_entry) || (which < 0) || ((which + 1) > cw->list.num_entry)) 
		return;

	if (which == cw->list.selected_idx && cw->list.last_selected)
		cw->list.last_selected = NULL;

	del = cw->list.w_list[which];
	XtFree(cw->list.list[which].label);

	memmove(cw->list.list + which , cw->list.list + which + 1, 
		sizeof(ListStruct) * (cw->list.num_entry - which));

	memmove(cw->list.w_list + which , cw->list.w_list + which + 1 , 
		sizeof(Widget) * (cw->list.num_entry - which - 1));

	cw->list.num_entry --;

	for (i = which ;  i < cw->list.num_entry ; i++)
	{
		cw->list.list[i].index = i;
	}

	XtDestroyWidget(del);

	if (cw->list.num_entry == 0) cw->list.last_selected = NULL;
	else 
		SetSelected(w , which - (which == cw->list.num_entry ));
}

ListStruct * ListGetSelected(w)
Widget w;
{
	ListWidget cw = (ListWidget) w;

	if (cw->list.last_selected && cw->list.list)
		return &cw->list.list[cw->list.selected_idx];
	else
		return NULL;
}
