#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 name["english"] = "wrap";
 name["francais"] = "wrap";
 name["deutsch"] = "wrap";
 script_name(english:name["english"], francais:name["francais"], deutsch:name["deutsch"]);
 
 desc["english"] = "The 'wrap' cgi is installed. This CGI allows
anyone to get a listing for any directory with mode +755.

Solution : remove it from /cgi-bin.

Risk factor : Low/Medium";


 desc["francais"] = "Le cgi 'wrap' est install. Celui-ci permet
 n'importe qui d'obtenir un listing pour n'importe quel dossier
de mode +755.

Solution : retirez-le de /cgi-bin.

Facteur de risque : Faible/Moyen";

 desc["deutsch"] = "Das CGI 'wrap' ist installiert. Dieses CGI ermglicht
jedem ein beliebiges Verzeichnis mit dem Modus +755 einzusehen.

Lsung: Lschen aus dem Verzeichnis /cgi-bin

Risikofaktor: Niedrig / Mittel";

 script_description(english:desc["english"], francais:desc["francais"], deutsch:desc["deutsch"]);
 
 summary["english"] = "Checks for the presence of /cgi-bin/wrap";
 summary["francais"] = "Vrifie la prsence de /cgi-bin/wrap";
 summary["deutsch"] = "berprft auf Existenz von /cgi-bin/wrap"; 

 script_summary(english:summary["english"], francais:summary["francais"], deutsch:summary["deutsch"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison",
                deutsch:"Dieses Skript ist urheberrechtlich geschtzt (C) 1999 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 family["deutsch"] = "CGI Mibrauch";
 script_family(english:family["english"], francais:family["francais"], deutsch:family["deutsch"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

if(is_cgi_installed("wrap"))
{
 port = get_kb_item("Services/www");
 if(!port)port = 80;
 security_hole(port);
}
