/*
 * Copyright (C) 2012-2014 Robert Chéramy (robert@cheramy.net)
 *
 * This file is part of YASW (Yet Another Scan Wizard).
 *
 * YASW is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * YASW is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with YASW.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "rotationwidget.h"
#include "ui_rotationwidget.h"
#include <QDebug>

RotationWidget::RotationWidget(QWidget *parent) :
    AbstractFilterWidget(parent),
    ui(new Ui::RotationWidget)
{
    ui->setupUi(this);
    rotationAngle = 0;
}

RotationWidget::~RotationWidget()
{
    delete ui;
}

void RotationWidget::setPixmap(QPixmap pixmap)
{
    inputPixmap = pixmap;
    if (!preview()) {
        ui->view->setPixmap(pixmap);
    }
}

void RotationWidget::setPreview(QPixmap pixmap)
{
    previewPixmap = pixmap;
    if (preview())
        ui->view->setPixmap(pixmap);
}


void RotationWidget::on_rotateLeft_clicked()
{
    rotationAngle = (rotationAngle - 90) % 360;
    emit parameterChanged();
}

void RotationWidget::on_rotateRight_clicked()
{
    rotationAngle = (rotationAngle + 90) % 360;;
    emit parameterChanged();
}


void RotationWidget::on_preview_toggled(bool checked)
{
    if (checked) {
        // This does recalculate the output image if necessary and sets the preview Image.
        emit previewChecked();
    } else {
        ui->view->setPixmap(inputPixmap);
    }
}

bool RotationWidget::preview()
{
    return ui->preview->isChecked();
}

int RotationWidget::rotation()
{
    return rotationAngle;
}

/** \brief Sets the rotation angle in degrees

    This function is called when changing the Settings of the Rotation Filter
  */
void RotationWidget::setRotation(int degrees)
{
    /* If the rotation angle is not 0, 90, 180 or 270, someone tempered with the project file
       and knows what (s)he is dooing, so we don't check */
    rotationAngle = degrees;
}

void RotationWidget::enableFilter(bool enable)
{
    ui->enable->setChecked(enable);
}

void RotationWidget::setBackgroundColor(QColor color)
{
    ui->view->setBackgroundBrush(QBrush(color));
}

void RotationWidget::on_enable_toggled(bool checked)
{
    emit enableFilterToggled(checked);
}
