/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */

#include "vdk/timer.h"
#include "vdk/forms.h"
/*
 */
VDKTimer::VDKTimer(VDKForm* owner,unsigned int tick, bool start):
  VDKObject(owner),tick(tick),
  TimeTick("TimeTick",this,tick,&VDKTimer::SetTimeTick)
{
  timerId = gtk_timeout_add(tick,VDKTimer::HandleTimerTick,this);
  started = start;
  owner->Objects().add(this);
  Parent(owner);
}

/*
 */
void
VDKTimer::SetTimeTick(unsigned int t)
{
if((t > 0) && (timerId) )
  {
    gtk_timeout_remove(timerId);
    timerId = gtk_timeout_add(t,VDKTimer::HandleTimerTick,this);
    TimeTick(t);
  }
}
/*
 */
VDKTimer::~VDKTimer()
{
if(timerId)
  {
    gtk_timeout_remove(timerId);
    timerId = 0;
  }
}
/*
 */
void VDKTimer::Stop()
{
if(! started)
  return;
else {
    started = false;
#ifdef USE_SIGCPLUSPLUS
    OnTimerRunning(this,false);
#endif
 }
}
/*
 */
void VDKTimer::Start()
{
if(started)
     return;
 else{
   started = true;
#ifdef USE_SIGCPLUSPLUS
   OnTimerRunning(this,true);
#endif /* USE_SIGCPLUSPLUS */
 }
}
/*
 */
int VDKTimer::HandleTimerTick(gpointer gp)
{
  VDKTimer* timer = reinterpret_cast<VDKTimer*>(gp);
  if(timer->started)
    {
      timer->SignalEmit(timer_tick_signal);
      timer->SignalEmit("timer_tick_signal");
#ifdef USE_SIGCPLUSPLUS
      timer->OnTimerTick(timer);
#endif /* USE_SIGCPLUSPLUS */
    }
  return TRUE;
}
