/*   
 *   This is part of Remote System Call (RSC) Library.
 *
 *   rsc_to_nr.h: __RSC_* to __NR_* constants conversion header 
 *   
 *   Copyright (C) 2007 Andrea Forni
 *   
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License, version 2, as
 *   published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA.
 *
 */

#ifndef __RSC_TO_NR_HEADER__
#define __RSC_TO_NR_HEADER__
#include <stdlib.h>
#include <linux/net.h>
#include "rsc_consts.h"

struct nr_and_sys rsc_to_x86[] = {
	/* 0. __RSC__exit */ {NO_VALUE, NO_VALUE},
	/* 1. __RSC__llseek */ {140, NO_VALUE},
	/* 2. __RSC__newselect */ {142, NO_VALUE},
	/* 3. __RSC__sysctl */ {149, NO_VALUE},
	/* 4. __RSC_accept */ {102, SYS_ACCEPT},
	/* 5. __RSC_access */ {33, NO_VALUE},
	/* 6. __RSC_acct */ {51, NO_VALUE},
	/* 7. __RSC_add_key */ {286, NO_VALUE},
	/* 8. __RSC_adjtimex */ {124, NO_VALUE},
	/* 9. __RSC_afs_syscall */ {137, NO_VALUE},
	/* 10. __RSC_alarm */ {27, NO_VALUE},
	/* 11. __RSC_arch_prctl */ {NO_VALUE, NO_VALUE},
	/* 12. __RSC_bdflush */ {134, NO_VALUE},
	/* 13. __RSC_bind */ {102, SYS_BIND},
	/* 14. __RSC_break */ {17, NO_VALUE},
	/* 15. __RSC_brk */ {45, NO_VALUE},
	/* 16. __RSC_capget */ {184, NO_VALUE},
	/* 17. __RSC_capset */ {185, NO_VALUE},
	/* 18. __RSC_chdir */ {12, NO_VALUE},
	/* 19. __RSC_chmod */ {15, NO_VALUE},
	/* 20. __RSC_chown */ {182, NO_VALUE},
	/* 21. __RSC_chown32 */ {212, NO_VALUE},
	/* 22. __RSC_chroot */ {61, NO_VALUE},
	/* 23. __RSC_clock_getres */ {266, NO_VALUE},
	/* 24. __RSC_clock_gettime */ {265, NO_VALUE},
	/* 25. __RSC_clock_nanosleep */ {267, NO_VALUE},
	/* 26. __RSC_clock_settime */ {264, NO_VALUE},
	/* 27. __RSC_clone */ {120, NO_VALUE},
	/* 28. __RSC_close */ {6, NO_VALUE},
	/* 29. __RSC_connect */ {102, SYS_CONNECT},
	/* 30. __RSC_creat */ {8, NO_VALUE},
	/* 31. __RSC_create_module */ {127, NO_VALUE},
	/* 32. __RSC_delete_module */ {129, NO_VALUE},
	/* 33. __RSC_dup */ {41, NO_VALUE},
	/* 34. __RSC_dup2 */ {63, NO_VALUE},
	/* 35. __RSC_epoll_create */ {254, NO_VALUE},
	/* 36. __RSC_epoll_ctl */ {255, NO_VALUE},
	/* 37. __RSC_epoll_ctl_old */ {NO_VALUE, NO_VALUE},
	/* 38. __RSC_epoll_wait */ {256, NO_VALUE},
	/* 39. __RSC_epoll_wait_old */ {NO_VALUE, NO_VALUE},
	/* 40. __RSC_execve */ {11, NO_VALUE},
	/* 41. __RSC_exit */ {1, NO_VALUE},
	/* 42. __RSC_exit_group */ {252, NO_VALUE},
	/* 43. __RSC_fadvise64 */ {250, NO_VALUE},
	/* 44. __RSC_fadvise64_64 */ {272, NO_VALUE},
	/* 45. __RSC_fchdir */ {133, NO_VALUE},
	/* 46. __RSC_fchmod */ {94, NO_VALUE},
	/* 47. __RSC_fchown */ {95, NO_VALUE},
	/* 48. __RSC_fchown32 */ {207, NO_VALUE},
	/* 49. __RSC_fcntl */ {55, NO_VALUE},
	/* 50. __RSC_fcntl64 */ {221, NO_VALUE},
	/* 51. __RSC_fdatasync */ {148, NO_VALUE},
	/* 52. __RSC_fgetxattr */ {231, NO_VALUE},
	/* 53. __RSC_flistxattr */ {234, NO_VALUE},
	/* 54. __RSC_flock */ {143, NO_VALUE},
	/* 55. __RSC_fork */ {2, NO_VALUE},
	/* 56. __RSC_fremovexattr */ {237, NO_VALUE},
	/* 57. __RSC_fsetxattr */ {228, NO_VALUE},
	/* 58. __RSC_fstat */ {108, NO_VALUE},
	/* 59. __RSC_fstat64 */ {197, NO_VALUE},
	/* 60. __RSC_fstatfs */ {100, NO_VALUE},
	/* 61. __RSC_fstatfs64 */ {269, NO_VALUE},
	/* 62. __RSC_fsync */ {118, NO_VALUE},
	/* 63. __RSC_ftime */ {35, NO_VALUE},
	/* 64. __RSC_ftruncate */ {93, NO_VALUE},
	/* 65. __RSC_ftruncate64 */ {194, NO_VALUE},
	/* 66. __RSC_futex */ {240, NO_VALUE},
	/* 67. __RSC_get_kernel_syms */ {130, NO_VALUE},
	/* 68. __RSC_get_mempolicy */ {275, NO_VALUE},
	/* 69. __RSC_get_thread_area */ {244, NO_VALUE},
	/* 70. __RSC_getcwd */ {183, NO_VALUE},
	/* 71. __RSC_getdents */ {141, NO_VALUE},
	/* 72. __RSC_getdents64 */ {220, NO_VALUE},
	/* 73. __RSC_getegid */ {50, NO_VALUE},
	/* 74. __RSC_getegid32 */ {202, NO_VALUE},
	/* 75. __RSC_geteuid */ {49, NO_VALUE},
	/* 76. __RSC_geteuid32 */ {201, NO_VALUE},
	/* 77. __RSC_getgid */ {47, NO_VALUE},
	/* 78. __RSC_getgid32 */ {200, NO_VALUE},
	/* 79. __RSC_getgroups */ {80, NO_VALUE},
	/* 80. __RSC_getgroups32 */ {205, NO_VALUE},
	/* 81. __RSC_getitimer */ {105, NO_VALUE},
	/* 82. __RSC_getpeername */ {102, SYS_GETPEERNAME},
	/* 83. __RSC_getpgid */ {132, NO_VALUE},
	/* 84. __RSC_getpgrp */ {65, NO_VALUE},
	/* 85. __RSC_getpid */ {20, NO_VALUE},
	/* 86. __RSC_getpmsg */ {188, NO_VALUE},
	/* 87. __RSC_getppid */ {64, NO_VALUE},
	/* 88. __RSC_getpriority */ {96, NO_VALUE},
	/* 89. __RSC_getresgid */ {171, NO_VALUE},
	/* 90. __RSC_getresgid32 */ {211, NO_VALUE},
	/* 91. __RSC_getresuid */ {165, NO_VALUE},
	/* 92. __RSC_getresuid32 */ {209, NO_VALUE},
	/* 93. __RSC_getrlimit */ {76, NO_VALUE},
	/* 94. __RSC_getrusage */ {77, NO_VALUE},
	/* 95. __RSC_getsid */ {147, NO_VALUE},
	/* 96. __RSC_getsockname */ {102, SYS_GETSOCKNAME},
	/* 97. __RSC_getsockopt */ {102, SYS_GETSOCKOPT},
	/* 98. __RSC_gettid */ {224, NO_VALUE},
	/* 99. __RSC_gettimeofday */ {78, NO_VALUE},
	/* 100. __RSC_getuid */ {24, NO_VALUE},
	/* 101. __RSC_getuid32 */ {199, NO_VALUE},
	/* 102. __RSC_getxattr */ {229, NO_VALUE},
	/* 103. __RSC_gtty */ {32, NO_VALUE},
	/* 104. __RSC_idle */ {112, NO_VALUE},
	/* 105. __RSC_init_module */ {128, NO_VALUE},
	/* 106. __RSC_io_cancel */ {249, NO_VALUE},
	/* 107. __RSC_io_destroy */ {246, NO_VALUE},
	/* 108. __RSC_io_getevents */ {247, NO_VALUE},
	/* 109. __RSC_io_setup */ {245, NO_VALUE},
	/* 110. __RSC_io_submit */ {248, NO_VALUE},
	/* 111. __RSC_ioctl */ {54, NO_VALUE},
	/* 112. __RSC_ioperm */ {101, NO_VALUE},
	/* 113. __RSC_iopl */ {110, NO_VALUE},
	/* 114. __RSC_ipc */ {117, NO_VALUE},
	/* 115. __RSC_kexec_load */ {NO_VALUE, NO_VALUE},
	/* 116. __RSC_keyctl */ {288, NO_VALUE},
	/* 117. __RSC_kill */ {37, NO_VALUE},
	/* 118. __RSC_lchown */ {16, NO_VALUE},
	/* 119. __RSC_lchown32 */ {198, NO_VALUE},
	/* 120. __RSC_lgetxattr */ {230, NO_VALUE},
	/* 121. __RSC_link */ {9, NO_VALUE},
	/* 122. __RSC_listen */ {102, SYS_LISTEN},
	/* 123. __RSC_listxattr */ {232, NO_VALUE},
	/* 124. __RSC_llistxattr */ {233, NO_VALUE},
	/* 125. __RSC_lock */ {53, NO_VALUE},
	/* 126. __RSC_lookup_dcookie */ {253, NO_VALUE},
	/* 127. __RSC_lremovexattr */ {236, NO_VALUE},
	/* 128. __RSC_lseek */ {19, NO_VALUE},
	/* 129. __RSC_lsetxattr */ {227, NO_VALUE},
	/* 130. __RSC_lstat */ {107, NO_VALUE},
	/* 131. __RSC_lstat64 */ {196, NO_VALUE},
	/* 132. __RSC_madvise */ {219, NO_VALUE},
	/* 133. __RSC_madvise1 */ {219, NO_VALUE},
	/* 134. __RSC_mbind */ {274, NO_VALUE},
	/* 135. __RSC_mincore */ {218, NO_VALUE},
	/* 136. __RSC_mkdir */ {39, NO_VALUE},
	/* 137. __RSC_mknod */ {14, NO_VALUE},
	/* 138. __RSC_mlock */ {150, NO_VALUE},
	/* 139. __RSC_mlockall */ {152, NO_VALUE},
	/* 140. __RSC_mmap */ {90, NO_VALUE},
	/* 141. __RSC_mmap2 */ {192, NO_VALUE},
	/* 142. __RSC_modify_ldt */ {123, NO_VALUE},
	/* 143. __RSC_mount */ {21, NO_VALUE},
	/* 144. __RSC_mprotect */ {125, NO_VALUE},
	/* 145. __RSC_mpx */ {56, NO_VALUE},
	/* 146. __RSC_mq_getsetattr */ {282, NO_VALUE},
	/* 147. __RSC_mq_notify */ {281, NO_VALUE},
	/* 148. __RSC_mq_open */ {277, NO_VALUE},
	/* 149. __RSC_mq_timedreceive */ {280, NO_VALUE},
	/* 150. __RSC_mq_timedsend */ {279, NO_VALUE},
	/* 151. __RSC_mq_unlink */ {278, NO_VALUE},
	/* 152. __RSC_mremap */ {163, NO_VALUE},
	/* 153. __RSC_msgctl */ {NO_VALUE, NO_VALUE},
	/* 154. __RSC_msgget */ {NO_VALUE, NO_VALUE},
	/* 155. __RSC_msgrcv */ {NO_VALUE, NO_VALUE},
	/* 156. __RSC_msgsnd */ {NO_VALUE, NO_VALUE},
	/* 157. __RSC_msync */ {144, NO_VALUE},
	/* 158. __RSC_multiplexer */ {NO_VALUE, NO_VALUE},
	/* 159. __RSC_munlock */ {151, NO_VALUE},
	/* 160. __RSC_munlockall */ {153, NO_VALUE},
	/* 161. __RSC_munmap */ {91, NO_VALUE},
	/* 162. __RSC_nanosleep */ {162, NO_VALUE},
	/* 163. __RSC_nfsservctl */ {169, NO_VALUE},
	/* 164. __RSC_nice */ {34, NO_VALUE},
	/* 165. __RSC_oldfstat */ {28, NO_VALUE},
	/* 166. __RSC_oldlstat */ {84, NO_VALUE},
	/* 167. __RSC_oldolduname */ {59, NO_VALUE},
	/* 168. __RSC_oldstat */ {18, NO_VALUE},
	/* 169. __RSC_olduname */ {109, NO_VALUE},
	/* 170. __RSC_open */ {5, NO_VALUE},
	/* 171. __RSC_pause */ {29, NO_VALUE},
	/* 172. __RSC_pciconfig_iobase */ {NO_VALUE, NO_VALUE},
	/* 173. __RSC_pciconfig_read */ {NO_VALUE, NO_VALUE},
	/* 174. __RSC_pciconfig_write */ {NO_VALUE, NO_VALUE},
	/* 175. __RSC_personality */ {136, NO_VALUE},
	/* 176. __RSC_pipe */ {42, NO_VALUE},
	/* 177. __RSC_pivot_root */ {217, NO_VALUE},
	/* 178. __RSC_poll */ {168, NO_VALUE},
	/* 179. __RSC_prctl */ {172, NO_VALUE},
	/* 180. __RSC_pread64 */ {180, NO_VALUE},
	/* 181. __RSC_prof */ {44, NO_VALUE},
	/* 182. __RSC_profil */ {98, NO_VALUE},
	/* 183. __RSC_ptrace */ {26, NO_VALUE},
	/* 184. __RSC_putpmsg */ {189, NO_VALUE},
	/* 185. __RSC_pwrite64 */ {181, NO_VALUE},
	/* 186. __RSC_query_module */ {167, NO_VALUE},
	/* 187. __RSC_quotactl */ {131, NO_VALUE},
	/* 188. __RSC_read */ {3, NO_VALUE},
	/* 189. __RSC_readahead */ {225, NO_VALUE},
	/* 190. __RSC_readdir */ {89, NO_VALUE},
	/* 191. __RSC_readlink */ {85, NO_VALUE},
	/* 192. __RSC_readv */ {145, NO_VALUE},
	/* 193. __RSC_reboot */ {88, NO_VALUE},
	/* 194. __RSC_recv */ {102, SYS_RECV},
	/* 195. __RSC_recvfrom */ {102, SYS_RECVFROM},
	/* 196. __RSC_recvmsg */ {102, SYS_RECVMSG},
	/* 197. __RSC_remap_file_pages */ {257, NO_VALUE},
	/* 198. __RSC_removexattr */ {235, NO_VALUE},
	/* 199. __RSC_rename */ {38, NO_VALUE},
	/* 200. __RSC_request_key */ {287, NO_VALUE},
	/* 201. __RSC_restart_syscall */ {0, NO_VALUE},
	/* 202. __RSC_rmdir */ {40, NO_VALUE},
	/* 203. __RSC_rt_sigaction */ {174, NO_VALUE},
	/* 204. __RSC_rt_sigpending */ {176, NO_VALUE},
	/* 205. __RSC_rt_sigprocmask */ {175, NO_VALUE},
	/* 206. __RSC_rt_sigqueueinfo */ {178, NO_VALUE},
	/* 207. __RSC_rt_sigreturn */ {173, NO_VALUE},
	/* 208. __RSC_rt_sigsuspend */ {179, NO_VALUE},
	/* 209. __RSC_rt_sigtimedwait */ {177, NO_VALUE},
	/* 210. __RSC_sched_get_priority_max */ {159, NO_VALUE},
	/* 211. __RSC_sched_get_priority_min */ {160, NO_VALUE},
	/* 212. __RSC_sched_getaffinity */ {242, NO_VALUE},
	/* 213. __RSC_sched_getparam */ {155, NO_VALUE},
	/* 214. __RSC_sched_getscheduler */ {157, NO_VALUE},
	/* 215. __RSC_sched_rr_get_interval */ {161, NO_VALUE},
	/* 216. __RSC_sched_setaffinity */ {241, NO_VALUE},
	/* 217. __RSC_sched_setparam */ {154, NO_VALUE},
	/* 218. __RSC_sched_setscheduler */ {156, NO_VALUE},
	/* 219. __RSC_sched_yield */ {158, NO_VALUE},
	/* 220. __RSC_security */ {NO_VALUE, NO_VALUE},
	/* 221. __RSC_select */ {82, NO_VALUE},
	/* 222. __RSC_semctl */ {NO_VALUE, NO_VALUE},
	/* 223. __RSC_semget */ {NO_VALUE, NO_VALUE},
	/* 224. __RSC_semop */ {NO_VALUE, NO_VALUE},
	/* 225. __RSC_semtimedop */ {NO_VALUE, NO_VALUE},
	/* 226. __RSC_send */ {102, SYS_SEND},
	/* 227. __RSC_sendfile */ {187, NO_VALUE},
	/* 228. __RSC_sendfile64 */ {239, NO_VALUE},
	/* 229. __RSC_sendmsg */ {102, SYS_SENDMSG},
	/* 230. __RSC_sendto */ {102, SYS_SENDTO},
	/* 231. __RSC_set_mempolicy */ {276, NO_VALUE},
	/* 232. __RSC_set_thread_area */ {243, NO_VALUE},
	/* 233. __RSC_set_tid_address */ {258, NO_VALUE},
	/* 234. __RSC_setdomainname */ {121, NO_VALUE},
	/* 235. __RSC_setfsgid */ {139, NO_VALUE},
	/* 236. __RSC_setfsgid32 */ {216, NO_VALUE},
	/* 237. __RSC_setfsuid */ {138, NO_VALUE},
	/* 238. __RSC_setfsuid32 */ {215, NO_VALUE},
	/* 239. __RSC_setgid */ {46, NO_VALUE},
	/* 240. __RSC_setgid32 */ {214, NO_VALUE},
	/* 241. __RSC_setgroups */ {81, NO_VALUE},
	/* 242. __RSC_setgroups32 */ {206, NO_VALUE},
	/* 243. __RSC_sethostname */ {74, NO_VALUE},
	/* 244. __RSC_setitimer */ {104, NO_VALUE},
	/* 245. __RSC_setpgid */ {57, NO_VALUE},
	/* 246. __RSC_setpriority */ {97, NO_VALUE},
	/* 247. __RSC_setregid */ {71, NO_VALUE},
	/* 248. __RSC_setregid32 */ {204, NO_VALUE},
	/* 249. __RSC_setresgid */ {170, NO_VALUE},
	/* 250. __RSC_setresgid32 */ {210, NO_VALUE},
	/* 251. __RSC_setresuid */ {164, NO_VALUE},
	/* 252. __RSC_setresuid32 */ {208, NO_VALUE},
	/* 253. __RSC_setreuid */ {70, NO_VALUE},
	/* 254. __RSC_setreuid32 */ {203, NO_VALUE},
	/* 255. __RSC_setrlimit */ {75, NO_VALUE},
	/* 256. __RSC_setsid */ {66, NO_VALUE},
	/* 257. __RSC_setsockopt */ {102, SYS_SETSOCKOPT},
	/* 258. __RSC_settimeofday */ {79, NO_VALUE},
	/* 259. __RSC_setuid */ {23, NO_VALUE},
	/* 260. __RSC_setuid32 */ {213, NO_VALUE},
	/* 261. __RSC_setxattr */ {226, NO_VALUE},
	/* 262. __RSC_sgetmask */ {68, NO_VALUE},
	/* 263. __RSC_shmat */ {NO_VALUE, NO_VALUE},
	/* 264. __RSC_shmctl */ {NO_VALUE, NO_VALUE},
	/* 265. __RSC_shmdt */ {NO_VALUE, NO_VALUE},
	/* 266. __RSC_shmget */ {NO_VALUE, NO_VALUE},
	/* 267. __RSC_shutdown */ {102, SYS_SHUTDOWN},
	/* 268. __RSC_sigaction */ {67, NO_VALUE},
	/* 269. __RSC_sigaltstack */ {186, NO_VALUE},
	/* 270. __RSC_signal */ {48, NO_VALUE},
	/* 271. __RSC_sigpending */ {73, NO_VALUE},
	/* 272. __RSC_sigprocmask */ {126, NO_VALUE},
	/* 273. __RSC_sigreturn */ {119, NO_VALUE},
	/* 274. __RSC_sigsuspend */ {72, NO_VALUE},
	/* 275. __RSC_socket */ {102, SYS_SOCKET},
	/* 276. __RSC_socketcall */ {102, NO_VALUE},
	/* 277. __RSC_socketpair */ {102, SYS_SOCKETPAIR},
	/* 278. __RSC_ssetmask */ {69, NO_VALUE},
	/* 279. __RSC_stat */ {106, NO_VALUE},
	/* 280. __RSC_stat64 */ {195, NO_VALUE},
	/* 281. __RSC_statfs */ {99, NO_VALUE},
	/* 282. __RSC_statfs64 */ {268, NO_VALUE},
	/* 283. __RSC_stime */ {25, NO_VALUE},
	/* 284. __RSC_stty */ {31, NO_VALUE},
	/* 285. __RSC_swapcontext */ {NO_VALUE, NO_VALUE},
	/* 286. __RSC_swapoff */ {115, NO_VALUE},
	/* 287. __RSC_swapon */ {87, NO_VALUE},
	/* 288. __RSC_symlink */ {83, NO_VALUE},
	/* 289. __RSC_sync */ {36, NO_VALUE},
	/* 290. __RSC_sys_kexec_load */ {283, NO_VALUE},
	/* 291. __RSC_sysfs */ {135, NO_VALUE},
	/* 292. __RSC_sysinfo */ {116, NO_VALUE},
	/* 293. __RSC_syslog */ {103, NO_VALUE},
	/* 294. __RSC_tgkill */ {270, NO_VALUE},
	/* 295. __RSC_time */ {13, NO_VALUE},
	/* 296. __RSC_timer_create */ {259, NO_VALUE},
	/* 297. __RSC_timer_delete */ {263, NO_VALUE},
	/* 298. __RSC_timer_getoverrun */ {262, NO_VALUE},
	/* 299. __RSC_timer_gettime */ {261, NO_VALUE},
	/* 300. __RSC_timer_settime */ {260, NO_VALUE},
	/* 301. __RSC_times */ {43, NO_VALUE},
	/* 302. __RSC_tkill */ {238, NO_VALUE},
	/* 303. __RSC_truncate */ {92, NO_VALUE},
	/* 304. __RSC_truncate64 */ {193, NO_VALUE},
	/* 305. __RSC_tuxcall */ {NO_VALUE, NO_VALUE},
	/* 306. __RSC_ugetrlimit */ {191, NO_VALUE},
	/* 307. __RSC_ulimit */ {58, NO_VALUE},
	/* 308. __RSC_umask */ {60, NO_VALUE},
	/* 309. __RSC_umount */ {22, NO_VALUE},
	/* 310. __RSC_umount2 */ {52, NO_VALUE},
	/* 311. __RSC_uname */ {122, NO_VALUE},
	/* 312. __RSC_unlink */ {10, NO_VALUE},
	/* 313. __RSC_uselib */ {86, NO_VALUE},
	/* 314. __RSC_ustat */ {62, NO_VALUE},
	/* 315. __RSC_utime */ {30, NO_VALUE},
	/* 316. __RSC_utimes */ {271, NO_VALUE},
	/* 317. __RSC_vfork */ {190, NO_VALUE},
	/* 318. __RSC_vhangup */ {111, NO_VALUE},
	/* 319. __RSC_vm86 */ {166, NO_VALUE},
	/* 320. __RSC_vm86old */ {113, NO_VALUE},
	/* 321. __RSC_vserver */ {273, NO_VALUE},
	/* 322. __RSC_wait4 */ {114, NO_VALUE},
	/* 323. __RSC_waitid */ {284, NO_VALUE},
	/* 324. __RSC_waitpid */ {7, NO_VALUE},
	/* 325. __RSC_write */ {4, NO_VALUE},
	/* 326. __RSC_writev */ {146, NO_VALUE}
};

struct nr_and_sys rsc_to_x86_64[] = {
	/* 0. __RSC__exit */ {NO_VALUE, NO_VALUE},
	/* 1. __RSC__llseek */ {NO_VALUE, NO_VALUE},
	/* 2. __RSC__newselect */ {NO_VALUE, NO_VALUE},
	/* 3. __RSC__sysctl */ {156, NO_VALUE},
	/* 4. __RSC_accept */ {43, NO_VALUE},
	/* 5. __RSC_access */ {21, NO_VALUE},
	/* 6. __RSC_acct */ {163, NO_VALUE},
	/* 7. __RSC_add_key */ {248, NO_VALUE},
	/* 8. __RSC_adjtimex */ {159, NO_VALUE},
	/* 9. __RSC_afs_syscall */ {183, NO_VALUE},
	/* 10. __RSC_alarm */ {37, NO_VALUE},
	/* 11. __RSC_arch_prctl */ {158, NO_VALUE},
	/* 12. __RSC_bdflush */ {NO_VALUE, NO_VALUE},
	/* 13. __RSC_bind */ {49, NO_VALUE},
	/* 14. __RSC_break */ {NO_VALUE, NO_VALUE},
	/* 15. __RSC_brk */ {12, NO_VALUE},
	/* 16. __RSC_capget */ {125, NO_VALUE},
	/* 17. __RSC_capset */ {126, NO_VALUE},
	/* 18. __RSC_chdir */ {80, NO_VALUE},
	/* 19. __RSC_chmod */ {90, NO_VALUE},
	/* 20. __RSC_chown */ {92, NO_VALUE},
	/* 21. __RSC_chown32 */ {NO_VALUE, NO_VALUE},
	/* 22. __RSC_chroot */ {161, NO_VALUE},
	/* 23. __RSC_clock_getres */ {229, NO_VALUE},
	/* 24. __RSC_clock_gettime */ {228, NO_VALUE},
	/* 25. __RSC_clock_nanosleep */ {230, NO_VALUE},
	/* 26. __RSC_clock_settime */ {227, NO_VALUE},
	/* 27. __RSC_clone */ {56, NO_VALUE},
	/* 28. __RSC_close */ {3, NO_VALUE},
	/* 29. __RSC_connect */ {42, NO_VALUE},
	/* 30. __RSC_creat */ {85, NO_VALUE},
	/* 31. __RSC_create_module */ {174, NO_VALUE},
	/* 32. __RSC_delete_module */ {176, NO_VALUE},
	/* 33. __RSC_dup */ {32, NO_VALUE},
	/* 34. __RSC_dup2 */ {33, NO_VALUE},
	/* 35. __RSC_epoll_create */ {213, NO_VALUE},
	/* 36. __RSC_epoll_ctl */ {233, NO_VALUE},
	/* 37. __RSC_epoll_ctl_old */ {214, NO_VALUE},
	/* 38. __RSC_epoll_wait */ {232, NO_VALUE},
	/* 39. __RSC_epoll_wait_old */ {215, NO_VALUE},
	/* 40. __RSC_execve */ {59, NO_VALUE},
	/* 41. __RSC_exit */ {60, NO_VALUE},
	/* 42. __RSC_exit_group */ {231, NO_VALUE},
	/* 43. __RSC_fadvise64 */ {221, NO_VALUE},
	/* 44. __RSC_fadvise64_64 */ {NO_VALUE, NO_VALUE},
	/* 45. __RSC_fchdir */ {81, NO_VALUE},
	/* 46. __RSC_fchmod */ {91, NO_VALUE},
	/* 47. __RSC_fchown */ {93, NO_VALUE},
	/* 48. __RSC_fchown32 */ {NO_VALUE, NO_VALUE},
	/* 49. __RSC_fcntl */ {72, NO_VALUE},
	/* 50. __RSC_fcntl64 */ {NO_VALUE, NO_VALUE},
	/* 51. __RSC_fdatasync */ {75, NO_VALUE},
	/* 52. __RSC_fgetxattr */ {193, NO_VALUE},
	/* 53. __RSC_flistxattr */ {196, NO_VALUE},
	/* 54. __RSC_flock */ {73, NO_VALUE},
	/* 55. __RSC_fork */ {57, NO_VALUE},
	/* 56. __RSC_fremovexattr */ {199, NO_VALUE},
	/* 57. __RSC_fsetxattr */ {190, NO_VALUE},
	/* 58. __RSC_fstat */ {5, NO_VALUE},
	/* 59. __RSC_fstat64 */ {5, NO_VALUE},
	/* 60. __RSC_fstatfs */ {138, NO_VALUE},
	/* 61. __RSC_fstatfs64 */ {138, NO_VALUE},
	/* 62. __RSC_fsync */ {74, NO_VALUE},
	/* 63. __RSC_ftime */ {NO_VALUE, NO_VALUE},
	/* 64. __RSC_ftruncate */ {77, NO_VALUE},
	/* 65. __RSC_ftruncate64 */ {77, NO_VALUE},
	/* 66. __RSC_futex */ {202, NO_VALUE},
	/* 67. __RSC_get_kernel_syms */ {177, NO_VALUE},
	/* 68. __RSC_get_mempolicy */ {239, NO_VALUE},
	/* 69. __RSC_get_thread_area */ {211, NO_VALUE},
	/* 70. __RSC_getcwd */ {79, NO_VALUE},
	/* 71. __RSC_getdents */ {78, NO_VALUE},
	/* 72. __RSC_getdents64 */ {217, NO_VALUE},
	/* 73. __RSC_getegid */ {108, NO_VALUE},
	/* 74. __RSC_getegid32 */ {NO_VALUE, NO_VALUE},
	/* 75. __RSC_geteuid */ {107, NO_VALUE},
	/* 76. __RSC_geteuid32 */ {NO_VALUE, NO_VALUE},
	/* 77. __RSC_getgid */ {104, NO_VALUE},
	/* 78. __RSC_getgid32 */ {NO_VALUE, NO_VALUE},
	/* 79. __RSC_getgroups */ {115, NO_VALUE},
	/* 80. __RSC_getgroups32 */ {NO_VALUE, NO_VALUE},
	/* 81. __RSC_getitimer */ {36, NO_VALUE},
	/* 82. __RSC_getpeername */ {52, NO_VALUE},
	/* 83. __RSC_getpgid */ {121, NO_VALUE},
	/* 84. __RSC_getpgrp */ {111, NO_VALUE},
	/* 85. __RSC_getpid */ {39, NO_VALUE},
	/* 86. __RSC_getpmsg */ {181, NO_VALUE},
	/* 87. __RSC_getppid */ {110, NO_VALUE},
	/* 88. __RSC_getpriority */ {140, NO_VALUE},
	/* 89. __RSC_getresgid */ {120, NO_VALUE},
	/* 90. __RSC_getresgid32 */ {NO_VALUE, NO_VALUE},
	/* 91. __RSC_getresuid */ {118, NO_VALUE},
	/* 92. __RSC_getresuid32 */ {NO_VALUE, NO_VALUE},
	/* 93. __RSC_getrlimit */ {97, NO_VALUE},
	/* 94. __RSC_getrusage */ {98, NO_VALUE},
	/* 95. __RSC_getsid */ {124, NO_VALUE},
	/* 96. __RSC_getsockname */ {51, NO_VALUE},
	/* 97. __RSC_getsockopt */ {55, NO_VALUE},
	/* 98. __RSC_gettid */ {186, NO_VALUE},
	/* 99. __RSC_gettimeofday */ {96, NO_VALUE},
	/* 100. __RSC_getuid */ {102, NO_VALUE},
	/* 101. __RSC_getuid32 */ {NO_VALUE, NO_VALUE},
	/* 102. __RSC_getxattr */ {191, NO_VALUE},
	/* 103. __RSC_gtty */ {NO_VALUE, NO_VALUE},
	/* 104. __RSC_idle */ {NO_VALUE, NO_VALUE},
	/* 105. __RSC_init_module */ {175, NO_VALUE},
	/* 106. __RSC_io_cancel */ {210, NO_VALUE},
	/* 107. __RSC_io_destroy */ {207, NO_VALUE},
	/* 108. __RSC_io_getevents */ {208, NO_VALUE},
	/* 109. __RSC_io_setup */ {206, NO_VALUE},
	/* 110. __RSC_io_submit */ {209, NO_VALUE},
	/* 111. __RSC_ioctl */ {16, NO_VALUE},
	/* 112. __RSC_ioperm */ {173, NO_VALUE},
	/* 113. __RSC_iopl */ {172, NO_VALUE},
	/* 114. __RSC_ipc */ {NO_VALUE, NO_VALUE},
	/* 115. __RSC_kexec_load */ {246, NO_VALUE},
	/* 116. __RSC_keyctl */ {250, NO_VALUE},
	/* 117. __RSC_kill */ {62, NO_VALUE},
	/* 118. __RSC_lchown */ {94, NO_VALUE},
	/* 119. __RSC_lchown32 */ {NO_VALUE, NO_VALUE},
	/* 120. __RSC_lgetxattr */ {192, NO_VALUE},
	/* 121. __RSC_link */ {86, NO_VALUE},
	/* 122. __RSC_listen */ {50, NO_VALUE},
	/* 123. __RSC_listxattr */ {194, NO_VALUE},
	/* 124. __RSC_llistxattr */ {195, NO_VALUE},
	/* 125. __RSC_lock */ {NO_VALUE, NO_VALUE},
	/* 126. __RSC_lookup_dcookie */ {212, NO_VALUE},
	/* 127. __RSC_lremovexattr */ {198, NO_VALUE},
	/* 128. __RSC_lseek */ {8, NO_VALUE},
	/* 129. __RSC_lsetxattr */ {189, NO_VALUE},
	/* 130. __RSC_lstat */ {6, NO_VALUE},
	/* 131. __RSC_lstat64 */ {6, NO_VALUE},
	/* 132. __RSC_madvise */ {28, NO_VALUE},
	/* 133. __RSC_madvise1 */ {NO_VALUE, NO_VALUE},
	/* 134. __RSC_mbind */ {237, NO_VALUE},
	/* 135. __RSC_mincore */ {27, NO_VALUE},
	/* 136. __RSC_mkdir */ {83, NO_VALUE},
	/* 137. __RSC_mknod */ {133, NO_VALUE},
	/* 138. __RSC_mlock */ {149, NO_VALUE},
	/* 139. __RSC_mlockall */ {151, NO_VALUE},
	/* 140. __RSC_mmap */ {9, NO_VALUE},
	/* 141. __RSC_mmap2 */ {NO_VALUE, NO_VALUE},
	/* 142. __RSC_modify_ldt */ {154, NO_VALUE},
	/* 143. __RSC_mount */ {165, NO_VALUE},
	/* 144. __RSC_mprotect */ {10, NO_VALUE},
	/* 145. __RSC_mpx */ {NO_VALUE, NO_VALUE},
	/* 146. __RSC_mq_getsetattr */ {245, NO_VALUE},
	/* 147. __RSC_mq_notify */ {244, NO_VALUE},
	/* 148. __RSC_mq_open */ {240, NO_VALUE},
	/* 149. __RSC_mq_timedreceive */ {243, NO_VALUE},
	/* 150. __RSC_mq_timedsend */ {242, NO_VALUE},
	/* 151. __RSC_mq_unlink */ {241, NO_VALUE},
	/* 152. __RSC_mremap */ {25, NO_VALUE},
	/* 153. __RSC_msgctl */ {71, NO_VALUE},
	/* 154. __RSC_msgget */ {68, NO_VALUE},
	/* 155. __RSC_msgrcv */ {70, NO_VALUE},
	/* 156. __RSC_msgsnd */ {69, NO_VALUE},
	/* 157. __RSC_msync */ {26, NO_VALUE},
	/* 158. __RSC_multiplexer */ {NO_VALUE, NO_VALUE},
	/* 159. __RSC_munlock */ {150, NO_VALUE},
	/* 160. __RSC_munlockall */ {152, NO_VALUE},
	/* 161. __RSC_munmap */ {11, NO_VALUE},
	/* 162. __RSC_nanosleep */ {35, NO_VALUE},
	/* 163. __RSC_nfsservctl */ {180, NO_VALUE},
	/* 164. __RSC_nice */ {NO_VALUE, NO_VALUE},
	/* 165. __RSC_oldfstat */ {NO_VALUE, NO_VALUE},
	/* 166. __RSC_oldlstat */ {NO_VALUE, NO_VALUE},
	/* 167. __RSC_oldolduname */ {NO_VALUE, NO_VALUE},
	/* 168. __RSC_oldstat */ {NO_VALUE, NO_VALUE},
	/* 169. __RSC_olduname */ {NO_VALUE, NO_VALUE},
	/* 170. __RSC_open */ {2, NO_VALUE},
	/* 171. __RSC_pause */ {34, NO_VALUE},
	/* 172. __RSC_pciconfig_iobase */ {NO_VALUE, NO_VALUE},
	/* 173. __RSC_pciconfig_read */ {NO_VALUE, NO_VALUE},
	/* 174. __RSC_pciconfig_write */ {NO_VALUE, NO_VALUE},
	/* 175. __RSC_personality */ {135, NO_VALUE},
	/* 176. __RSC_pipe */ {22, NO_VALUE},
	/* 177. __RSC_pivot_root */ {155, NO_VALUE},
	/* 178. __RSC_poll */ {7, NO_VALUE},
	/* 179. __RSC_prctl */ {157, NO_VALUE},
	/* 180. __RSC_pread64 */ {17, NO_VALUE},
	/* 181. __RSC_prof */ {NO_VALUE, NO_VALUE},
	/* 182. __RSC_profil */ {NO_VALUE, NO_VALUE},
	/* 183. __RSC_ptrace */ {101, NO_VALUE},
	/* 184. __RSC_putpmsg */ {182, NO_VALUE},
	/* 185. __RSC_pwrite64 */ {18, NO_VALUE},
	/* 186. __RSC_query_module */ {178, NO_VALUE},
	/* 187. __RSC_quotactl */ {179, NO_VALUE},
	/* 188. __RSC_read */ {0, NO_VALUE},
	/* 189. __RSC_readahead */ {187, NO_VALUE},
	/* 190. __RSC_readdir */ {NO_VALUE, NO_VALUE},
	/* 191. __RSC_readlink */ {89, NO_VALUE},
	/* 192. __RSC_readv */ {19, NO_VALUE},
	/* 193. __RSC_reboot */ {169, NO_VALUE},
	/* 194. __RSC_recv */ {NO_VALUE, NO_VALUE},
	/* 195. __RSC_recvfrom */ {45, NO_VALUE},
	/* 196. __RSC_recvmsg */ {47, NO_VALUE},
	/* 197. __RSC_remap_file_pages */ {216, NO_VALUE},
	/* 198. __RSC_removexattr */ {197, NO_VALUE},
	/* 199. __RSC_rename */ {82, NO_VALUE},
	/* 200. __RSC_request_key */ {249, NO_VALUE},
	/* 201. __RSC_restart_syscall */ {219, NO_VALUE},
	/* 202. __RSC_rmdir */ {84, NO_VALUE},
	/* 203. __RSC_rt_sigaction */ {13, NO_VALUE},
	/* 204. __RSC_rt_sigpending */ {127, NO_VALUE},
	/* 205. __RSC_rt_sigprocmask */ {14, NO_VALUE},
	/* 206. __RSC_rt_sigqueueinfo */ {129, NO_VALUE},
	/* 207. __RSC_rt_sigreturn */ {15, NO_VALUE},
	/* 208. __RSC_rt_sigsuspend */ {130, NO_VALUE},
	/* 209. __RSC_rt_sigtimedwait */ {128, NO_VALUE},
	/* 210. __RSC_sched_get_priority_max */ {146, NO_VALUE},
	/* 211. __RSC_sched_get_priority_min */ {147, NO_VALUE},
	/* 212. __RSC_sched_getaffinity */ {204, NO_VALUE},
	/* 213. __RSC_sched_getparam */ {143, NO_VALUE},
	/* 214. __RSC_sched_getscheduler */ {145, NO_VALUE},
	/* 215. __RSC_sched_rr_get_interval */ {148, NO_VALUE},
	/* 216. __RSC_sched_setaffinity */ {203, NO_VALUE},
	/* 217. __RSC_sched_setparam */ {142, NO_VALUE},
	/* 218. __RSC_sched_setscheduler */ {144, NO_VALUE},
	/* 219. __RSC_sched_yield */ {24, NO_VALUE},
	/* 220. __RSC_security */ {185, NO_VALUE},
	/* 221. __RSC_select */ {23, NO_VALUE},
	/* 222. __RSC_semctl */ {66, NO_VALUE},
	/* 223. __RSC_semget */ {64, NO_VALUE},
	/* 224. __RSC_semop */ {65, NO_VALUE},
	/* 225. __RSC_semtimedop */ {220, NO_VALUE},
	/* 226. __RSC_send */ {NO_VALUE, NO_VALUE},
	/* 227. __RSC_sendfile */ {40, NO_VALUE},
	/* 228. __RSC_sendfile64 */ {NO_VALUE, NO_VALUE},
	/* 229. __RSC_sendmsg */ {46, NO_VALUE},
	/* 230. __RSC_sendto */ {44, NO_VALUE},
	/* 231. __RSC_set_mempolicy */ {238, NO_VALUE},
	/* 232. __RSC_set_thread_area */ {205, NO_VALUE},
	/* 233. __RSC_set_tid_address */ {218, NO_VALUE},
	/* 234. __RSC_setdomainname */ {171, NO_VALUE},
	/* 235. __RSC_setfsgid */ {123, NO_VALUE},
	/* 236. __RSC_setfsgid32 */ {NO_VALUE, NO_VALUE},
	/* 237. __RSC_setfsuid */ {122, NO_VALUE},
	/* 238. __RSC_setfsuid32 */ {NO_VALUE, NO_VALUE},
	/* 239. __RSC_setgid */ {106, NO_VALUE},
	/* 240. __RSC_setgid32 */ {NO_VALUE, NO_VALUE},
	/* 241. __RSC_setgroups */ {116, NO_VALUE},
	/* 242. __RSC_setgroups32 */ {NO_VALUE, NO_VALUE},
	/* 243. __RSC_sethostname */ {170, NO_VALUE},
	/* 244. __RSC_setitimer */ {38, NO_VALUE},
	/* 245. __RSC_setpgid */ {109, NO_VALUE},
	/* 246. __RSC_setpriority */ {141, NO_VALUE},
	/* 247. __RSC_setregid */ {114, NO_VALUE},
	/* 248. __RSC_setregid32 */ {NO_VALUE, NO_VALUE},
	/* 249. __RSC_setresgid */ {119, NO_VALUE},
	/* 250. __RSC_setresgid32 */ {NO_VALUE, NO_VALUE},
	/* 251. __RSC_setresuid */ {117, NO_VALUE},
	/* 252. __RSC_setresuid32 */ {NO_VALUE, NO_VALUE},
	/* 253. __RSC_setreuid */ {113, NO_VALUE},
	/* 254. __RSC_setreuid32 */ {NO_VALUE, NO_VALUE},
	/* 255. __RSC_setrlimit */ {160, NO_VALUE},
	/* 256. __RSC_setsid */ {112, NO_VALUE},
	/* 257. __RSC_setsockopt */ {54, NO_VALUE},
	/* 258. __RSC_settimeofday */ {164, NO_VALUE},
	/* 259. __RSC_setuid */ {105, NO_VALUE},
	/* 260. __RSC_setuid32 */ {NO_VALUE, NO_VALUE},
	/* 261. __RSC_setxattr */ {188, NO_VALUE},
	/* 262. __RSC_sgetmask */ {NO_VALUE, NO_VALUE},
	/* 263. __RSC_shmat */ {30, NO_VALUE},
	/* 264. __RSC_shmctl */ {31, NO_VALUE},
	/* 265. __RSC_shmdt */ {67, NO_VALUE},
	/* 266. __RSC_shmget */ {29, NO_VALUE},
	/* 267. __RSC_shutdown */ {48, NO_VALUE},
	/* 268. __RSC_sigaction */ {NO_VALUE, NO_VALUE},
	/* 269. __RSC_sigaltstack */ {131, NO_VALUE},
	/* 270. __RSC_signal */ {NO_VALUE, NO_VALUE},
	/* 271. __RSC_sigpending */ {NO_VALUE, NO_VALUE},
	/* 272. __RSC_sigprocmask */ {NO_VALUE, NO_VALUE},
	/* 273. __RSC_sigreturn */ {NO_VALUE, NO_VALUE},
	/* 274. __RSC_sigsuspend */ {NO_VALUE, NO_VALUE},
	/* 275. __RSC_socket */ {41, NO_VALUE},
	/* 276. __RSC_socketcall */ {NO_VALUE, NO_VALUE},
	/* 277. __RSC_socketpair */ {53, NO_VALUE},
	/* 278. __RSC_ssetmask */ {NO_VALUE, NO_VALUE},
	/* 279. __RSC_stat */ {4, NO_VALUE},
	/* 280. __RSC_stat64 */ {4, NO_VALUE},
	/* 281. __RSC_statfs */ {137, NO_VALUE},
	/* 282. __RSC_statfs64 */ {137, NO_VALUE},
	/* 283. __RSC_stime */ {NO_VALUE, NO_VALUE},
	/* 284. __RSC_stty */ {NO_VALUE, NO_VALUE},
	/* 285. __RSC_swapcontext */ {NO_VALUE, NO_VALUE},
	/* 286. __RSC_swapoff */ {168, NO_VALUE},
	/* 287. __RSC_swapon */ {167, NO_VALUE},
	/* 288. __RSC_symlink */ {88, NO_VALUE},
	/* 289. __RSC_sync */ {162, NO_VALUE},
	/* 290. __RSC_sys_kexec_load */ {NO_VALUE, NO_VALUE},
	/* 291. __RSC_sysfs */ {139, NO_VALUE},
	/* 292. __RSC_sysinfo */ {99, NO_VALUE},
	/* 293. __RSC_syslog */ {103, NO_VALUE},
	/* 294. __RSC_tgkill */ {234, NO_VALUE},
	/* 295. __RSC_time */ {201, NO_VALUE},
	/* 296. __RSC_timer_create */ {222, NO_VALUE},
	/* 297. __RSC_timer_delete */ {226, NO_VALUE},
	/* 298. __RSC_timer_getoverrun */ {225, NO_VALUE},
	/* 299. __RSC_timer_gettime */ {224, NO_VALUE},
	/* 300. __RSC_timer_settime */ {223, NO_VALUE},
	/* 301. __RSC_times */ {100, NO_VALUE},
	/* 302. __RSC_tkill */ {200, NO_VALUE},
	/* 303. __RSC_truncate */ {76, NO_VALUE},
	/* 304. __RSC_truncate64 */ {76, NO_VALUE},
	/* 305. __RSC_tuxcall */ {184, NO_VALUE},
	/* 306. __RSC_ugetrlimit */ {NO_VALUE, NO_VALUE},
	/* 307. __RSC_ulimit */ {NO_VALUE, NO_VALUE},
	/* 308. __RSC_umask */ {95, NO_VALUE},
	/* 309. __RSC_umount */ {NO_VALUE, NO_VALUE},
	/* 310. __RSC_umount2 */ {166, NO_VALUE},
	/* 311. __RSC_uname */ {63, NO_VALUE},
	/* 312. __RSC_unlink */ {87, NO_VALUE},
	/* 313. __RSC_uselib */ {134, NO_VALUE},
	/* 314. __RSC_ustat */ {136, NO_VALUE},
	/* 315. __RSC_utime */ {132, NO_VALUE},
	/* 316. __RSC_utimes */ {235, NO_VALUE},
	/* 317. __RSC_vfork */ {58, NO_VALUE},
	/* 318. __RSC_vhangup */ {153, NO_VALUE},
	/* 319. __RSC_vm86 */ {NO_VALUE, NO_VALUE},
	/* 320. __RSC_vm86old */ {NO_VALUE, NO_VALUE},
	/* 321. __RSC_vserver */ {236, NO_VALUE},
	/* 322. __RSC_wait4 */ {61, NO_VALUE},
	/* 323. __RSC_waitid */ {247, NO_VALUE},
	/* 324. __RSC_waitpid */ {NO_VALUE, NO_VALUE},
	/* 325. __RSC_write */ {1, NO_VALUE},
	/* 326. __RSC_writev */ {20, NO_VALUE}
};

struct nr_and_sys rsc_to_ppc[] = {
	/* 0. __RSC__exit */ {1, NO_VALUE},
	/* 1. __RSC__llseek */ {140, NO_VALUE},
	/* 2. __RSC__newselect */ {142, NO_VALUE},
	/* 3. __RSC__sysctl */ {149, NO_VALUE},
	/* 4. __RSC_accept */ {102, SYS_ACCEPT},
	/* 5. __RSC_access */ {33, NO_VALUE},
	/* 6. __RSC_acct */ {51, NO_VALUE},
	/* 7. __RSC_add_key */ {NO_VALUE, NO_VALUE},
	/* 8. __RSC_adjtimex */ {124, NO_VALUE},
	/* 9. __RSC_afs_syscall */ {137, NO_VALUE},
	/* 10. __RSC_alarm */ {27, NO_VALUE},
	/* 11. __RSC_arch_prctl */ {NO_VALUE, NO_VALUE},
	/* 12. __RSC_bdflush */ {134, NO_VALUE},
	/* 13. __RSC_bind */ {102, SYS_BIND},
	/* 14. __RSC_break */ {17, NO_VALUE},
	/* 15. __RSC_brk */ {45, NO_VALUE},
	/* 16. __RSC_capget */ {183, NO_VALUE},
	/* 17. __RSC_capset */ {184, NO_VALUE},
	/* 18. __RSC_chdir */ {12, NO_VALUE},
	/* 19. __RSC_chmod */ {15, NO_VALUE},
	/* 20. __RSC_chown */ {181, NO_VALUE},
	/* 21. __RSC_chown32 */ {NO_VALUE, NO_VALUE},
	/* 22. __RSC_chroot */ {61, NO_VALUE},
	/* 23. __RSC_clock_getres */ {247, NO_VALUE},
	/* 24. __RSC_clock_gettime */ {246, NO_VALUE},
	/* 25. __RSC_clock_nanosleep */ {248, NO_VALUE},
	/* 26. __RSC_clock_settime */ {245, NO_VALUE},
	/* 27. __RSC_clone */ {120, NO_VALUE},
	/* 28. __RSC_close */ {6, NO_VALUE},
	/* 29. __RSC_connect */ {102, SYS_CONNECT},
	/* 30. __RSC_creat */ {8, NO_VALUE},
	/* 31. __RSC_create_module */ {127, NO_VALUE},
	/* 32. __RSC_delete_module */ {129, NO_VALUE},
	/* 33. __RSC_dup */ {41, NO_VALUE},
	/* 34. __RSC_dup2 */ {63, NO_VALUE},
	/* 35. __RSC_epoll_create */ {236, NO_VALUE},
	/* 36. __RSC_epoll_ctl */ {237, NO_VALUE},
	/* 37. __RSC_epoll_ctl_old */ {NO_VALUE, NO_VALUE},
	/* 38. __RSC_epoll_wait */ {238, NO_VALUE},
	/* 39. __RSC_epoll_wait_old */ {NO_VALUE, NO_VALUE},
	/* 40. __RSC_execve */ {11, NO_VALUE},
	/* 41. __RSC_exit */ {1, NO_VALUE},
	/* 42. __RSC_exit_group */ {234, NO_VALUE},
	/* 43. __RSC_fadvise64 */ {233, NO_VALUE},
	/* 44. __RSC_fadvise64_64 */ {254, NO_VALUE},
	/* 45. __RSC_fchdir */ {133, NO_VALUE},
	/* 46. __RSC_fchmod */ {94, NO_VALUE},
	/* 47. __RSC_fchown */ {95, NO_VALUE},
	/* 48. __RSC_fchown32 */ {NO_VALUE, NO_VALUE},
	/* 49. __RSC_fcntl */ {55, NO_VALUE},
	/* 50. __RSC_fcntl64 */ {204, NO_VALUE},
	/* 51. __RSC_fdatasync */ {148, NO_VALUE},
	/* 52. __RSC_fgetxattr */ {214, NO_VALUE},
	/* 53. __RSC_flistxattr */ {217, NO_VALUE},
	/* 54. __RSC_flock */ {143, NO_VALUE},
	/* 55. __RSC_fork */ {2, NO_VALUE},
	/* 56. __RSC_fremovexattr */ {220, NO_VALUE},
	/* 57. __RSC_fsetxattr */ {211, NO_VALUE},
	/* 58. __RSC_fstat */ {108, NO_VALUE},
	/* 59. __RSC_fstat64 */ {197, NO_VALUE},
	/* 60. __RSC_fstatfs */ {100, NO_VALUE},
	/* 61. __RSC_fstatfs64 */ {253, NO_VALUE},
	/* 62. __RSC_fsync */ {118, NO_VALUE},
	/* 63. __RSC_ftime */ {35, NO_VALUE},
	/* 64. __RSC_ftruncate */ {93, NO_VALUE},
	/* 65. __RSC_ftruncate64 */ {194, NO_VALUE},
	/* 66. __RSC_futex */ {221, NO_VALUE},
	/* 67. __RSC_get_kernel_syms */ {130, NO_VALUE},
	/* 68. __RSC_get_mempolicy */ {NO_VALUE, NO_VALUE},
	/* 69. __RSC_get_thread_area */ {NO_VALUE, NO_VALUE},
	/* 70. __RSC_getcwd */ {182, NO_VALUE},
	/* 71. __RSC_getdents */ {141, NO_VALUE},
	/* 72. __RSC_getdents64 */ {202, NO_VALUE},
	/* 73. __RSC_getegid */ {50, NO_VALUE},
	/* 74. __RSC_getegid32 */ {NO_VALUE, NO_VALUE},
	/* 75. __RSC_geteuid */ {49, NO_VALUE},
	/* 76. __RSC_geteuid32 */ {NO_VALUE, NO_VALUE},
	/* 77. __RSC_getgid */ {47, NO_VALUE},
	/* 78. __RSC_getgid32 */ {NO_VALUE, NO_VALUE},
	/* 79. __RSC_getgroups */ {80, NO_VALUE},
	/* 80. __RSC_getgroups32 */ {NO_VALUE, NO_VALUE},
	/* 81. __RSC_getitimer */ {105, NO_VALUE},
	/* 82. __RSC_getpeername */ {102, SYS_GETPEERNAME},
	/* 83. __RSC_getpgid */ {132, NO_VALUE},
	/* 84. __RSC_getpgrp */ {65, NO_VALUE},
	/* 85. __RSC_getpid */ {20, NO_VALUE},
	/* 86. __RSC_getpmsg */ {187, NO_VALUE},
	/* 87. __RSC_getppid */ {64, NO_VALUE},
	/* 88. __RSC_getpriority */ {96, NO_VALUE},
	/* 89. __RSC_getresgid */ {170, NO_VALUE},
	/* 90. __RSC_getresgid32 */ {NO_VALUE, NO_VALUE},
	/* 91. __RSC_getresuid */ {165, NO_VALUE},
	/* 92. __RSC_getresuid32 */ {NO_VALUE, NO_VALUE},
	/* 93. __RSC_getrlimit */ {76, NO_VALUE},
	/* 94. __RSC_getrusage */ {77, NO_VALUE},
	/* 95. __RSC_getsid */ {147, NO_VALUE},
	/* 96. __RSC_getsockname */ {102, SYS_GETSOCKNAME},
	/* 97. __RSC_getsockopt */ {102, SYS_GETSOCKOPT},
	/* 98. __RSC_gettid */ {207, NO_VALUE},
	/* 99. __RSC_gettimeofday */ {78, NO_VALUE},
	/* 100. __RSC_getuid */ {24, NO_VALUE},
	/* 101. __RSC_getuid32 */ {NO_VALUE, NO_VALUE},
	/* 102. __RSC_getxattr */ {212, NO_VALUE},
	/* 103. __RSC_gtty */ {32, NO_VALUE},
	/* 104. __RSC_idle */ {112, NO_VALUE},
	/* 105. __RSC_init_module */ {128, NO_VALUE},
	/* 106. __RSC_io_cancel */ {231, NO_VALUE},
	/* 107. __RSC_io_destroy */ {228, NO_VALUE},
	/* 108. __RSC_io_getevents */ {229, NO_VALUE},
	/* 109. __RSC_io_setup */ {227, NO_VALUE},
	/* 110. __RSC_io_submit */ {230, NO_VALUE},
	/* 111. __RSC_ioctl */ {54, NO_VALUE},
	/* 112. __RSC_ioperm */ {101, NO_VALUE},
	/* 113. __RSC_iopl */ {110, NO_VALUE},
	/* 114. __RSC_ipc */ {117, NO_VALUE},
	/* 115. __RSC_kexec_load */ {NO_VALUE, NO_VALUE},
	/* 116. __RSC_keyctl */ {NO_VALUE, NO_VALUE},
	/* 117. __RSC_kill */ {37, NO_VALUE},
	/* 118. __RSC_lchown */ {16, NO_VALUE},
	/* 119. __RSC_lchown32 */ {NO_VALUE, NO_VALUE},
	/* 120. __RSC_lgetxattr */ {213, NO_VALUE},
	/* 121. __RSC_link */ {9, NO_VALUE},
	/* 122. __RSC_listen */ {102, SYS_LISTEN},
	/* 123. __RSC_listxattr */ {215, NO_VALUE},
	/* 124. __RSC_llistxattr */ {216, NO_VALUE},
	/* 125. __RSC_lock */ {53, NO_VALUE},
	/* 126. __RSC_lookup_dcookie */ {235, NO_VALUE},
	/* 127. __RSC_lremovexattr */ {219, NO_VALUE},
	/* 128. __RSC_lseek */ {19, NO_VALUE},
	/* 129. __RSC_lsetxattr */ {210, NO_VALUE},
	/* 130. __RSC_lstat */ {107, NO_VALUE},
	/* 131. __RSC_lstat64 */ {196, NO_VALUE},
	/* 132. __RSC_madvise */ {205, NO_VALUE},
	/* 133. __RSC_madvise1 */ {NO_VALUE, NO_VALUE},
	/* 134. __RSC_mbind */ {NO_VALUE, NO_VALUE},
	/* 135. __RSC_mincore */ {206, NO_VALUE},
	/* 136. __RSC_mkdir */ {39, NO_VALUE},
	/* 137. __RSC_mknod */ {14, NO_VALUE},
	/* 138. __RSC_mlock */ {150, NO_VALUE},
	/* 139. __RSC_mlockall */ {152, NO_VALUE},
	/* 140. __RSC_mmap */ {90, NO_VALUE},
	/* 141. __RSC_mmap2 */ {192, NO_VALUE},
	/* 142. __RSC_modify_ldt */ {123, NO_VALUE},
	/* 143. __RSC_mount */ {21, NO_VALUE},
	/* 144. __RSC_mprotect */ {125, NO_VALUE},
	/* 145. __RSC_mpx */ {56, NO_VALUE},
	/* 146. __RSC_mq_getsetattr */ {NO_VALUE, NO_VALUE},
	/* 147. __RSC_mq_notify */ {NO_VALUE, NO_VALUE},
	/* 148. __RSC_mq_open */ {NO_VALUE, NO_VALUE},
	/* 149. __RSC_mq_timedreceive */ {NO_VALUE, NO_VALUE},
	/* 150. __RSC_mq_timedsend */ {NO_VALUE, NO_VALUE},
	/* 151. __RSC_mq_unlink */ {NO_VALUE, NO_VALUE},
	/* 152. __RSC_mremap */ {163, NO_VALUE},
	/* 153. __RSC_msgctl */ {NO_VALUE, NO_VALUE},
	/* 154. __RSC_msgget */ {NO_VALUE, NO_VALUE},
	/* 155. __RSC_msgrcv */ {NO_VALUE, NO_VALUE},
	/* 156. __RSC_msgsnd */ {NO_VALUE, NO_VALUE},
	/* 157. __RSC_msync */ {144, NO_VALUE},
	/* 158. __RSC_multiplexer */ {201, NO_VALUE},
	/* 159. __RSC_munlock */ {151, NO_VALUE},
	/* 160. __RSC_munlockall */ {153, NO_VALUE},
	/* 161. __RSC_munmap */ {91, NO_VALUE},
	/* 162. __RSC_nanosleep */ {162, NO_VALUE},
	/* 163. __RSC_nfsservctl */ {168, NO_VALUE},
	/* 164. __RSC_nice */ {34, NO_VALUE},
	/* 165. __RSC_oldfstat */ {28, NO_VALUE},
	/* 166. __RSC_oldlstat */ {84, NO_VALUE},
	/* 167. __RSC_oldolduname */ {59, NO_VALUE},
	/* 168. __RSC_oldstat */ {18, NO_VALUE},
	/* 169. __RSC_olduname */ {109, NO_VALUE},
	/* 170. __RSC_open */ {5, NO_VALUE},
	/* 171. __RSC_pause */ {29, NO_VALUE},
	/* 172. __RSC_pciconfig_iobase */ {200, NO_VALUE},
	/* 173. __RSC_pciconfig_read */ {198, NO_VALUE},
	/* 174. __RSC_pciconfig_write */ {199, NO_VALUE},
	/* 175. __RSC_personality */ {136, NO_VALUE},
	/* 176. __RSC_pipe */ {42, NO_VALUE},
	/* 177. __RSC_pivot_root */ {203, NO_VALUE},
	/* 178. __RSC_poll */ {167, NO_VALUE},
	/* 179. __RSC_prctl */ {171, NO_VALUE},
	/* 180. __RSC_pread64 */ {179, NO_VALUE},
	/* 181. __RSC_prof */ {44, NO_VALUE},
	/* 182. __RSC_profil */ {98, NO_VALUE},
	/* 183. __RSC_ptrace */ {26, NO_VALUE},
	/* 184. __RSC_putpmsg */ {188, NO_VALUE},
	/* 185. __RSC_pwrite64 */ {180, NO_VALUE},
	/* 186. __RSC_query_module */ {166, NO_VALUE},
	/* 187. __RSC_quotactl */ {131, NO_VALUE},
	/* 188. __RSC_read */ {3, NO_VALUE},
	/* 189. __RSC_readahead */ {191, NO_VALUE},
	/* 190. __RSC_readdir */ {89, NO_VALUE},
	/* 191. __RSC_readlink */ {85, NO_VALUE},
	/* 192. __RSC_readv */ {145, NO_VALUE},
	/* 193. __RSC_reboot */ {88, NO_VALUE},
	/* 194. __RSC_recv */ {102, SYS_RECV},
	/* 195. __RSC_recvfrom */ {102, SYS_RECVFROM},
	/* 196. __RSC_recvmsg */ {102, SYS_RECVMSG},
	/* 197. __RSC_remap_file_pages */ {239, NO_VALUE},
	/* 198. __RSC_removexattr */ {218, NO_VALUE},
	/* 199. __RSC_rename */ {38, NO_VALUE},
	/* 200. __RSC_request_key */ {NO_VALUE, NO_VALUE},
	/* 201. __RSC_restart_syscall */ {0, NO_VALUE},
	/* 202. __RSC_rmdir */ {40, NO_VALUE},
	/* 203. __RSC_rt_sigaction */ {173, NO_VALUE},
	/* 204. __RSC_rt_sigpending */ {175, NO_VALUE},
	/* 205. __RSC_rt_sigprocmask */ {174, NO_VALUE},
	/* 206. __RSC_rt_sigqueueinfo */ {177, NO_VALUE},
	/* 207. __RSC_rt_sigreturn */ {172, NO_VALUE},
	/* 208. __RSC_rt_sigsuspend */ {178, NO_VALUE},
	/* 209. __RSC_rt_sigtimedwait */ {176, NO_VALUE},
	/* 210. __RSC_sched_get_priority_max */ {159, NO_VALUE},
	/* 211. __RSC_sched_get_priority_min */ {160, NO_VALUE},
	/* 212. __RSC_sched_getaffinity */ {223, NO_VALUE},
	/* 213. __RSC_sched_getparam */ {155, NO_VALUE},
	/* 214. __RSC_sched_getscheduler */ {157, NO_VALUE},
	/* 215. __RSC_sched_rr_get_interval */ {161, NO_VALUE},
	/* 216. __RSC_sched_setaffinity */ {222, NO_VALUE},
	/* 217. __RSC_sched_setparam */ {154, NO_VALUE},
	/* 218. __RSC_sched_setscheduler */ {156, NO_VALUE},
	/* 219. __RSC_sched_yield */ {158, NO_VALUE},
	/* 220. __RSC_security */ {NO_VALUE, NO_VALUE},
	/* 221. __RSC_select */ {82, NO_VALUE},
	/* 222. __RSC_semctl */ {NO_VALUE, NO_VALUE},
	/* 223. __RSC_semget */ {NO_VALUE, NO_VALUE},
	/* 224. __RSC_semop */ {NO_VALUE, NO_VALUE},
	/* 225. __RSC_semtimedop */ {NO_VALUE, NO_VALUE},
	/* 226. __RSC_send */ {102, SYS_SEND},
	/* 227. __RSC_sendfile */ {186, NO_VALUE},
	/* 228. __RSC_sendfile64 */ {226, NO_VALUE},
	/* 229. __RSC_sendmsg */ {102, SYS_SENDMSG},
	/* 230. __RSC_sendto */ {102, SYS_SENDTO},
	/* 231. __RSC_set_mempolicy */ {NO_VALUE, NO_VALUE},
	/* 232. __RSC_set_thread_area */ {NO_VALUE, NO_VALUE},
	/* 233. __RSC_set_tid_address */ {232, NO_VALUE},
	/* 234. __RSC_setdomainname */ {121, NO_VALUE},
	/* 235. __RSC_setfsgid */ {139, NO_VALUE},
	/* 236. __RSC_setfsgid32 */ {NO_VALUE, NO_VALUE},
	/* 237. __RSC_setfsuid */ {138, NO_VALUE},
	/* 238. __RSC_setfsuid32 */ {NO_VALUE, NO_VALUE},
	/* 239. __RSC_setgid */ {46, NO_VALUE},
	/* 240. __RSC_setgid32 */ {NO_VALUE, NO_VALUE},
	/* 241. __RSC_setgroups */ {81, NO_VALUE},
	/* 242. __RSC_setgroups32 */ {NO_VALUE, NO_VALUE},
	/* 243. __RSC_sethostname */ {74, NO_VALUE},
	/* 244. __RSC_setitimer */ {104, NO_VALUE},
	/* 245. __RSC_setpgid */ {57, NO_VALUE},
	/* 246. __RSC_setpriority */ {97, NO_VALUE},
	/* 247. __RSC_setregid */ {71, NO_VALUE},
	/* 248. __RSC_setregid32 */ {NO_VALUE, NO_VALUE},
	/* 249. __RSC_setresgid */ {169, NO_VALUE},
	/* 250. __RSC_setresgid32 */ {NO_VALUE, NO_VALUE},
	/* 251. __RSC_setresuid */ {164, NO_VALUE},
	/* 252. __RSC_setresuid32 */ {NO_VALUE, NO_VALUE},
	/* 253. __RSC_setreuid */ {70, NO_VALUE},
	/* 254. __RSC_setreuid32 */ {NO_VALUE, NO_VALUE},
	/* 255. __RSC_setrlimit */ {75, NO_VALUE},
	/* 256. __RSC_setsid */ {66, NO_VALUE},
	/* 257. __RSC_setsockopt */ {102, SYS_SETSOCKOPT},
	/* 258. __RSC_settimeofday */ {79, NO_VALUE},
	/* 259. __RSC_setuid */ {23, NO_VALUE},
	/* 260. __RSC_setuid32 */ {NO_VALUE, NO_VALUE},
	/* 261. __RSC_setxattr */ {209, NO_VALUE},
	/* 262. __RSC_sgetmask */ {68, NO_VALUE},
	/* 263. __RSC_shmat */ {NO_VALUE, NO_VALUE},
	/* 264. __RSC_shmctl */ {NO_VALUE, NO_VALUE},
	/* 265. __RSC_shmdt */ {NO_VALUE, NO_VALUE},
	/* 266. __RSC_shmget */ {NO_VALUE, NO_VALUE},
	/* 267. __RSC_shutdown */ {102, SYS_SHUTDOWN},
	/* 268. __RSC_sigaction */ {67, NO_VALUE},
	/* 269. __RSC_sigaltstack */ {185, NO_VALUE},
	/* 270. __RSC_signal */ {48, NO_VALUE},
	/* 271. __RSC_sigpending */ {73, NO_VALUE},
	/* 272. __RSC_sigprocmask */ {126, NO_VALUE},
	/* 273. __RSC_sigreturn */ {119, NO_VALUE},
	/* 274. __RSC_sigsuspend */ {72, NO_VALUE},
	/* 275. __RSC_socket */ {102, SYS_SOCKET},
	/* 276. __RSC_socketcall */ {102, NO_VALUE},
	/* 277. __RSC_socketpair */ {102, SYS_SOCKETPAIR},
	/* 278. __RSC_ssetmask */ {69, NO_VALUE},
	/* 279. __RSC_stat */ {106, NO_VALUE},
	/* 280. __RSC_stat64 */ {195, NO_VALUE},
	/* 281. __RSC_statfs */ {99, NO_VALUE},
	/* 282. __RSC_statfs64 */ {252, NO_VALUE},
	/* 283. __RSC_stime */ {25, NO_VALUE},
	/* 284. __RSC_stty */ {31, NO_VALUE},
	/* 285. __RSC_swapcontext */ {249, NO_VALUE},
	/* 286. __RSC_swapoff */ {115, NO_VALUE},
	/* 287. __RSC_swapon */ {87, NO_VALUE},
	/* 288. __RSC_symlink */ {83, NO_VALUE},
	/* 289. __RSC_sync */ {36, NO_VALUE},
	/* 290. __RSC_sys_kexec_load */ {NO_VALUE, NO_VALUE},
	/* 291. __RSC_sysfs */ {135, NO_VALUE},
	/* 292. __RSC_sysinfo */ {116, NO_VALUE},
	/* 293. __RSC_syslog */ {103, NO_VALUE},
	/* 294. __RSC_tgkill */ {250, NO_VALUE},
	/* 295. __RSC_time */ {13, NO_VALUE},
	/* 296. __RSC_timer_create */ {240, NO_VALUE},
	/* 297. __RSC_timer_delete */ {244, NO_VALUE},
	/* 298. __RSC_timer_getoverrun */ {243, NO_VALUE},
	/* 299. __RSC_timer_gettime */ {242, NO_VALUE},
	/* 300. __RSC_timer_settime */ {241, NO_VALUE},
	/* 301. __RSC_times */ {43, NO_VALUE},
	/* 302. __RSC_tkill */ {208, NO_VALUE},
	/* 303. __RSC_truncate */ {92, NO_VALUE},
	/* 304. __RSC_truncate64 */ {193, NO_VALUE},
	/* 305. __RSC_tuxcall */ {225, NO_VALUE},
	/* 306. __RSC_ugetrlimit */ {190, NO_VALUE},
	/* 307. __RSC_ulimit */ {58, NO_VALUE},
	/* 308. __RSC_umask */ {60, NO_VALUE},
	/* 309. __RSC_umount */ {22, NO_VALUE},
	/* 310. __RSC_umount2 */ {52, NO_VALUE},
	/* 311. __RSC_uname */ {122, NO_VALUE},
	/* 312. __RSC_unlink */ {10, NO_VALUE},
	/* 313. __RSC_uselib */ {86, NO_VALUE},
	/* 314. __RSC_ustat */ {62, NO_VALUE},
	/* 315. __RSC_utime */ {30, NO_VALUE},
	/* 316. __RSC_utimes */ {251, NO_VALUE},
	/* 317. __RSC_vfork */ {189, NO_VALUE},
	/* 318. __RSC_vhangup */ {111, NO_VALUE},
	/* 319. __RSC_vm86 */ {113, NO_VALUE},
	/* 320. __RSC_vm86old */ {NO_VALUE, NO_VALUE},
	/* 321. __RSC_vserver */ {NO_VALUE, NO_VALUE},
	/* 322. __RSC_wait4 */ {114, NO_VALUE},
	/* 323. __RSC_waitid */ {NO_VALUE, NO_VALUE},
	/* 324. __RSC_waitpid */ {7, NO_VALUE},
	/* 325. __RSC_write */ {4, NO_VALUE},
	/* 326. __RSC_writev */ {146, NO_VALUE}
};

#endif /* __RSC_TO_NR_HEADER__ */
