// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2019 - Samuel GOUGEON
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- CLI SHELL MODE -->
// <-- NO CHECK REF -->

// Unitary tests for coth()

s = sprand(5, 4, 0.3);
assert_checkequal(coth(s), coth(full(s)));

x = [0:0.01:0.1 0.1:0.1:1 1:20]';
r = [
   %inf
   100.003333311111305
   50.0066664888956609
   33.3433327333847558
   25.0133319113277963
   20.0166638895500988
   16.6866618683117913
   14.3090400003806923
   12.5266552958194826
   11.1410949235981391
   10.0333111322539885
   10.0333111322539885
   5.06648956343947265
   3.43273843032174097
   2.63193244183218855
   2.16395341373865291
   1.8620255213866661 
   1.65462163580262911
   1.50594070204370678
   1.39606725303001178
   1.31303528549933146
   1.31303528549933146
   1.03731472072754816
   1.004969823313689
   1.00067115040168253
   1.00009080398201955
   1.00001228850020984
   1.0000016630588211
   1.00000022507037478
   1.00000003045995989
   1.00000000412230716
   1.00000000055789373
   1.00000000007550272
   1.00000000001021827
   1.00000000000138289
   1.00000000000018718
   1.00000000000002554
   1.00000000000000355
   1.00000000000000044
   1.00000000000000022
   1.
   ];
assert_checkequal(coth(x), r);
assert_checkequal(coth(-x), -r);
