///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// vector = Array of floats 
//	    + linear algebra methods
//
// author: Pierre.Saramito@imag.fr
//
// date: 14 january 1997
//
# include "rheolef/vec.h"
# include "rheolef/blas-algorithm.h"

# include "rheolef/iorheo.h"
# include "rheolef/inhb.h"
# include "rheolef/outhb.h"
# include "rheolef/outml.h"
using namespace rheolef;
using namespace std;

namespace rheolef {
template <class T>
vec<T> 
vec<T>::operator = (T lambda)
{
    fill (Array<T>::begin(), Array<T>::end(), lambda);
    return *this ;
}
template <class T>
istream& operator >> (istream& s, vec<T>& u)
{	
    typedef typename vec<T>::size_type size_type;

    iorheo::flag_type fmt = iorheo::flags(s) & iorheo::format_field;
    	
    if (fmt [iorheo::dump]) {
           
        if (!u.size()) return s;
        typename vec<T>::iterator i = u.begin();
        typename vec<T>::const_iterator z = u.end();
        while (s && i < z) s >> (*i++);
        return s;
    }
    if (fmt [iorheo::hb]) {

        size_type ivec = iorheo::getivec(s);
        size_type nrhs = iorheo::getnrhs(s);
        size_type nidx    = iorheo::getnidx(s);
        size_type nptr    = iorheo::getnptr(s);
        string rhstype = iorheo::getrhstype(s);
        string rhsfmt = iorheo::getrhsfmt(s);
        size_type line_no = iorheo::getline_no(s);

        if (rhstype [0] != 'F') {
    	    error_macro ("harwell-boeing sparse vector storage not yet supported");
#ifdef _RHEOLEF_HAVE_IOS_SETSTATE
    	    s.setstate(ios::failbit);
#endif // _RHEOLEF_HAVE_IOS_SETSTATE
    	    return s;
  	}
        size_type size;
        if (ivec < nrhs) {
    	// read a rhs
    	size = nidx; 
        } else {
    	// read a guess of exact sol
    	size = nptr;
        }
        // TODO: use a.resize(nidx);
        vec<T> v (size);
        bool status = read_harwell_boeing (
    	                 s, (ivec % nrhs), size, rhsfmt.c_str(), nrhs,
    	                 0,  line_no,
    	                 v.begin());

        iorheo::setivec(s, ivec+1);
        iorheo::setline_no(s, line_no);

        if (status) u = v;
        return s;
    }
    fatal_macro ("format not implemented");
    return s;
}
template <class T>
ostream&  operator << (ostream& s, const vec<T>& a)
{
    typedef typename vec<T>::size_type size_type;

    iorheo::flag_type fmt = iorheo::flags(s) & iorheo::format_field;
    if (fmt [iorheo::dump]) {

        ml_pref.reset();
        ml_pref.bank_format       = true;
        ml_pref.pr_as_read_syntax = false;
        print_matlab (s, a);
        return s;
    }
    if (fmt [iorheo::ml]) {

        print_matlab (s, a);
        return s;
    }
    if (fmt [iorheo::hb]) {

        size_type ivec = iorheo::getivec(s);
        size_type nrhs = iorheo::getnrhs(s);
        print_harwell_boeing (s, a.begin(), a.size(), ivec % max(size_type(1),nrhs), nrhs);
        iorheo::setivec(s, ivec+1);
        return s;
    }
    fatal_macro ("format not implemented (fmt=" << fmt.to_ulong() << ")");
    return s;
}
// instanciation in library:
template class vec<Float>;

template istream& operator >> (istream&, vec<Float>&);
template ostream& operator << (ostream&, const vec<Float>&);

# ifdef TODO
template class vec<float>;
template istream& operator >> (istream& s, vec<float>& u);
template ostream& operator << (ostream& s, const vec<float>& x);

#ifdef _RHEOLEF_HAVE_LONG_DOUBLE
template class vec<long Float>;
template istream& operator >> (istream& s, vec<long Float>& u);
template ostream& operator << (ostream& s, const vec<long Float>& x);
#endif
#endif // TODO

} // namespace rheolef
