#!/usr/bin/env python
# coding=UTF-8

# RetroArch - A frontend for libretro.
# Copyright (C) 2011-2016 - Daniel De Matteis
#
# RetroArch is free software: you can redistribute it and/or modify it under the terms
# of the GNU General Public License as published by the Free Software Found-
# ation, either version 3 of the License, or (at your option) any later version.
#
# RetroArch is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
# without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with RetroArch.
# If not, see <http://www.gnu.org/licenses/>.

# You probably don't need this script. It's only needed to update menu_hash_uspseudo.c,
# and that's not necessary either, because outdated translations fall back to English.

# Usage: ./pseudolocalize.py < menu_hash_us.c > menu_hash_uspseudo.c

replacements = {
  # These characters all exist in ISO-8859-1.
  #" ": "´¨¯¸",
  "!": "¡",
  "?": "¿",
  "a": "áàâåäã",
  "A": "ÁÀÂÅÄÃ",
  "c": "ç",
  "C": "Ç",
  "D": "Ð",
  "e": "éèêë",
  "E": "ÉÈÊË",
  "i": "íìîï",
  "I": "ÍÌÎÏ",
  "n": "ñ",
  "N": "Ñ",
  "o": "óòôöõø",
  "O": "ÓÒÔÖÕØ",
  "u": "úùûü",
  "U": "ÚÙÛÜ",
  "y": "ýÿ",
  "Y": "Ý",
}

import sys,random

if sys.version_info >= (3, 0):
    import io
    sys.stdin = io.TextIOWrapper(sys.stdin.buffer, encoding='ISO-8859-1')
    sys.stdout = io.TextIOWrapper(sys.stdout.buffer, encoding='ISO-8859-1')
else:
    import codecs
    sys.stdin = codecs.getreader('ISO-8859-1')(sys.stdin)
    sys.stdout = codecs.getwriter('UTF-8')(sys.stdout)
    
    nreplacements = {}
    for k in replacements:
        nreplacements[k] = replacements[k].decode("UTF-8")
    replacements = nreplacements

def pseudolocalize(string):
    ret = ""
    it = iter(string)
    for ch in it:
        if ch == '\\' or ch == '%':
            ret += ch
            ret += next(it)
            continue
        try:
            if random.randint(0,2) == 0:
                cand = replacements[ch]
                ret += random.choice(cand)
            else:
                ret += ch
        except KeyError:
            ret += ch
    return ret

def pseudolocalize_code(string):
    if '"' not in string: return string
    if '"null"' in string: return string
    if '"Main Menu"' in string: return string # RetroArch bug, this string can't be translated.
    
    parts = string.split('"')
    parts[1] = pseudolocalize(parts[1])
    return '"'.join(parts);

print("/* Autogenerated, do not edit. Your changes will be undone. */")

localize = False
for line in sys.stdin:
    line = line.strip("\n")
    if 'force_iso_8859_1' in line: # nuke this because we're UTF-8 now
        continue
    elif 'menu_hash_to_str_' in line or 'menu_hash_get_help_' in line:
        #line = line.replace("_us", "_pseudo")
        if '_label' not in line: localize = True
    if localize:
        line = pseudolocalize_code(line)
    print(line)

# look for const char *menu_hash_to_str_us(uint32_t hash) and add a 'pseudo'
for line in sys.stdin:
    line = line.strip("\n")
    if 'menu_hash_to_str' in line:
        print(line.replace("(", "pseudo("))
        break
    print(line)

# screw with all strings in the rest of the file
# and add 'pseudo' to int menu_hash_get_help_us(uint32_t hash, char *s, size_t len)
for line in sys.stdin:
    line = line.strip("\n")
    if 'force_iso_8859_1' in line: pass
    elif 'menu_hash_get_help' in line:
        print(line.replace("(", "pseudo("))
    else:
        print(pseudolocalize_code(line))
