/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdf5.hdf5objects;

import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import visad.data.hdf5.hdf5objects.HDF5Object;

public class HDF5Datatype
extends HDF5Object {
    public HDF5Datatype() {
        this.type = 3;
    }

    public HDF5Datatype(int datatype_class, int size) {
        this.type = 3;
        try {
            this.id = H5.H5Tcreate(datatype_class, size);
        }
        catch (HDF5Exception e) {
            System.err.println("HDF5Datatype: " + e);
            this.id = -1;
        }
        try {
            this.init();
        }
        catch (HDF5Exception e) {
            System.err.println("HDF5Datatype.init(): " + e);
        }
    }

    public HDF5Datatype(int loc_id, String type_name) {
        super(type_name);
        this.type = 3;
        try {
            this.id = H5.H5Topen(loc_id, this.name);
        }
        catch (HDF5Exception e) {
            System.err.println("HDF5Datatype: " + e);
            this.id = -1;
        }
    }

    public int H5Tcommit(int loc_id, String type_name) throws HDF5LibraryException, NullPointerException {
        this.name = type_name;
        return H5.H5Tcommit(loc_id, type_name, this.id);
    }

    public int get_class() throws HDF5LibraryException {
        return H5.H5Tget_class(this.id);
    }

    public int get_size() throws HDF5LibraryException {
        return H5.H5Tget_size(this.id);
    }

    public Object defineData(long[] count) throws HDF5Exception {
        Object[] data = null;
        int size = 0;
        long lsize = 1L;
        if (count == null) {
            return null;
        }
        for (int i = 0; i < count.length; ++i) {
            if ((lsize *= count[i]) <= Integer.MAX_VALUE) continue;
            throw new OutOfMemoryError("the size of data array > 2147483647");
        }
        size = (int)lsize;
        int class_t = H5.H5Tget_class(this.id);
        int class_s = H5.H5Tget_size(this.id);
        switch (class_t) {
            case 0: {
                if (class_s == 1) {
                    data = new byte[size];
                    break;
                }
                if (class_s == 2) {
                    data = new short[size];
                    break;
                }
                if (class_s == 4) {
                    data = new int[size];
                    break;
                }
                if (class_s != 8) break;
                data = new long[size];
                break;
            }
            case 1: {
                if (class_s == 4) {
                    data = new float[size];
                    break;
                }
                if (class_s != 8) break;
                data = new double[size];
                break;
            }
            case 3: {
                data = new String[size];
                break;
            }
        }
        return data;
    }

    public static String getDatatype(int data_type) {
        if (data_type == H5.J2C(1)) {
            return "HDF5CDataTypes.JH5T_ALPHA_B16";
        }
        if (data_type == H5.J2C(2)) {
            return "HDF5CDataTypes.JH5T_ALPHA_B32";
        }
        if (data_type == H5.J2C(3)) {
            return "HDF5CDataTypes.JH5T_ALPHA_B64";
        }
        if (data_type == H5.J2C(4)) {
            return "HDF5CDataTypes.JH5T_ALPHA_B8";
        }
        if (data_type == H5.J2C(5)) {
            return "HDF5CDataTypes.JH5T_ALPHA_F32";
        }
        if (data_type == H5.J2C(6)) {
            return "HDF5CDataTypes.JH5T_ALPHA_F64";
        }
        if (data_type == H5.J2C(7)) {
            return "HDF5CDataTypes.JH5T_ALPHA_I16";
        }
        if (data_type == H5.J2C(8)) {
            return "HDF5CDataTypes.JH5T_ALPHA_I32";
        }
        if (data_type == H5.J2C(9)) {
            return "HDF5CDataTypes.JH5T_ALPHA_I64";
        }
        if (data_type == H5.J2C(10)) {
            return "HDF5CDataTypes.JH5T_ALPHA_I8";
        }
        if (data_type == H5.J2C(11)) {
            return "HDF5CDataTypes.JH5T_ALPHA_U16";
        }
        if (data_type == H5.J2C(12)) {
            return "HDF5CDataTypes.JH5T_ALPHA_U32";
        }
        if (data_type == H5.J2C(13)) {
            return "HDF5CDataTypes.JH5T_ALPHA_U64";
        }
        if (data_type == H5.J2C(14)) {
            return "HDF5CDataTypes.JH5T_ALPHA_U8";
        }
        if (data_type == H5.J2C(15)) {
            return "HDF5CDataTypes.JH5T_C_S1";
        }
        if (data_type == H5.J2C(16)) {
            return "HDF5CDataTypes.JH5T_FORTRAN_S1";
        }
        if (data_type == H5.J2C(17)) {
            return "HDF5CDataTypes.JH5T_IEEE_F32BE";
        }
        if (data_type == H5.J2C(18)) {
            return "HDF5CDataTypes.JH5T_IEEE_F32LE";
        }
        if (data_type == H5.J2C(19)) {
            return "HDF5CDataTypes.JH5T_IEEE_F64BE";
        }
        if (data_type == H5.J2C(20)) {
            return "HDF5CDataTypes.JH5T_IEEE_F64LE";
        }
        if (data_type == H5.J2C(21)) {
            return "HDF5CDataTypes.JH5T_INTEL_B16";
        }
        if (data_type == H5.J2C(22)) {
            return "HDF5CDataTypes.JH5T_INTEL_B32";
        }
        if (data_type == H5.J2C(23)) {
            return "HDF5CDataTypes.JH5T_INTEL_B64";
        }
        if (data_type == H5.J2C(24)) {
            return "HDF5CDataTypes.JH5T_INTEL_B8";
        }
        if (data_type == H5.J2C(25)) {
            return "HDF5CDataTypes.JH5T_INTEL_F32";
        }
        if (data_type == H5.J2C(26)) {
            return "HDF5CDataTypes.JH5T_INTEL_F64";
        }
        if (data_type == H5.J2C(27)) {
            return "HDF5CDataTypes.JH5T_INTEL_I16";
        }
        if (data_type == H5.J2C(28)) {
            return "HDF5CDataTypes.JH5T_INTEL_I32";
        }
        if (data_type == H5.J2C(29)) {
            return "HDF5CDataTypes.JH5T_INTEL_I64";
        }
        if (data_type == H5.J2C(30)) {
            return "HDF5CDataTypes.JH5T_INTEL_I8";
        }
        if (data_type == H5.J2C(31)) {
            return "HDF5CDataTypes.JH5T_INTEL_U16";
        }
        if (data_type == H5.J2C(32)) {
            return "HDF5CDataTypes.JH5T_INTEL_U32";
        }
        if (data_type == H5.J2C(33)) {
            return "HDF5CDataTypes.JH5T_INTEL_U64";
        }
        if (data_type == H5.J2C(34)) {
            return "HDF5CDataTypes.JH5T_INTEL_U8";
        }
        if (data_type == H5.J2C(35)) {
            return "HDF5CDataTypes.JH5T_MIPS_B16";
        }
        if (data_type == H5.J2C(36)) {
            return "HDF5CDataTypes.JH5T_MIPS_B32";
        }
        if (data_type == H5.J2C(37)) {
            return "HDF5CDataTypes.JH5T_MIPS_B64";
        }
        if (data_type == H5.J2C(38)) {
            return "HDF5CDataTypes.JH5T_MIPS_B8";
        }
        if (data_type == H5.J2C(39)) {
            return "HDF5CDataTypes.JH5T_MIPS_F32";
        }
        if (data_type == H5.J2C(40)) {
            return "HDF5CDataTypes.JH5T_MIPS_F64";
        }
        if (data_type == H5.J2C(41)) {
            return "HDF5CDataTypes.JH5T_MIPS_I16";
        }
        if (data_type == H5.J2C(42)) {
            return "HDF5CDataTypes.JH5T_MIPS_I32";
        }
        if (data_type == H5.J2C(43)) {
            return "HDF5CDataTypes.JH5T_MIPS_I64";
        }
        if (data_type == H5.J2C(44)) {
            return "HDF5CDataTypes.JH5T_MIPS_I8";
        }
        if (data_type == H5.J2C(45)) {
            return "HDF5CDataTypes.JH5T_MIPS_U16";
        }
        if (data_type == H5.J2C(46)) {
            return "HDF5CDataTypes.JH5T_MIPS_U32";
        }
        if (data_type == H5.J2C(47)) {
            return "HDF5CDataTypes.JH5T_MIPS_U64 ";
        }
        if (data_type == H5.J2C(48)) {
            return "HDF5CDataTypes.JH5T_MIPS_U8";
        }
        if (data_type == H5.J2C(49)) {
            return "HDF5CDataTypes.JH5T_NATIVE_B16";
        }
        if (data_type == H5.J2C(50)) {
            return "HDF5CDataTypes.JH5T_NATIVE_B32";
        }
        if (data_type == H5.J2C(51)) {
            return "HDF5CDataTypes.JH5T_NATIVE_B64";
        }
        if (data_type == H5.J2C(52)) {
            return "HDF5CDataTypes.JH5T_NATIVE_B8";
        }
        if (data_type == H5.J2C(53)) {
            return "HDF5CDataTypes.JH5T_NATIVE_CHAR";
        }
        if (data_type == H5.J2C(54)) {
            return "HDF5CDataTypes.JH5T_NATIVE_DOUBLE";
        }
        if (data_type == H5.J2C(55)) {
            return "HDF5CDataTypes.JH5T_NATIVE_FLOAT";
        }
        if (data_type == H5.J2C(56)) {
            return "HDF5CDataTypes.JH5T_NATIVE_HBOOL";
        }
        if (data_type == H5.J2C(57)) {
            return "HDF5CDataTypes.JH5T_NATIVE_HERR";
        }
        if (data_type == H5.J2C(58)) {
            return "HDF5CDataTypes.JH5T_NATIVE_HSIZE";
        }
        if (data_type == H5.J2C(59)) {
            return "HDF5CDataTypes.JH5T_NATIVE_HSSIZE";
        }
        if (data_type == H5.J2C(60)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT";
        }
        if (data_type == H5.J2C(61)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT_FAST16";
        }
        if (data_type == H5.J2C(62)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT_FAST32";
        }
        if (data_type == H5.J2C(63)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT_FAST64";
        }
        if (data_type == H5.J2C(64)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT_FAST8";
        }
        if (data_type == H5.J2C(65)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT_LEAST16";
        }
        if (data_type == H5.J2C(66)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT_LEAST32";
        }
        if (data_type == H5.J2C(67)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT_LEAST64";
        }
        if (data_type == H5.J2C(68)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT_LEAST8";
        }
        if (data_type == H5.J2C(69)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT16";
        }
        if (data_type == H5.J2C(70)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT32";
        }
        if (data_type == H5.J2C(71)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT64";
        }
        if (data_type == H5.J2C(72)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT8";
        }
        if (data_type == H5.J2C(73)) {
            return "HDF5CDataTypes.JH5T_NATIVE_LDOUBLE";
        }
        if (data_type == H5.J2C(74)) {
            return "HDF5CDataTypes.JH5T_NATIVE_LLONG";
        }
        if (data_type == H5.J2C(75)) {
            return "HDF5CDataTypes.JH5T_NATIVE_LONG";
        }
        if (data_type == H5.J2C(76)) {
            return "HDF5CDataTypes.JH5T_NATIVE_OPAQUE";
        }
        if (data_type == H5.J2C(77)) {
            return "HDF5CDataTypes.JH5T_NATIVE_SCHAR";
        }
        if (data_type == H5.J2C(78)) {
            return "HDF5CDataTypes.JH5T_NATIVE_SHORT";
        }
        if (data_type == H5.J2C(79)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UCHAR";
        }
        if (data_type == H5.J2C(80)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT";
        }
        if (data_type == H5.J2C(81)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT_FAST16";
        }
        if (data_type == H5.J2C(82)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT_FAST32";
        }
        if (data_type == H5.J2C(83)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT_FAST64";
        }
        if (data_type == H5.J2C(84)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT_FAST8";
        }
        if (data_type == H5.J2C(85)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT_LEAST16";
        }
        if (data_type == H5.J2C(86)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT_LEAST32";
        }
        if (data_type == H5.J2C(87)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT_LEAST64";
        }
        if (data_type == H5.J2C(88)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT_LEAST8";
        }
        if (data_type == H5.J2C(89)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT16";
        }
        if (data_type == H5.J2C(90)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT32";
        }
        if (data_type == H5.J2C(91)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT64 ";
        }
        if (data_type == H5.J2C(92)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT8";
        }
        if (data_type == H5.J2C(93)) {
            return "HDF5CDataTypes.JH5T_NATIVE_ULLONG";
        }
        if (data_type == H5.J2C(94)) {
            return "HDF5CDataTypes.JH5T_NATIVE_ULONG";
        }
        if (data_type == H5.J2C(95)) {
            return "HDF5CDataTypes.JH5T_NATIVE_USHORT";
        }
        if (data_type == H5.J2C(96)) {
            return "HDF5CDataTypes.JH5T_NCSET";
        }
        if (data_type == H5.J2C(97)) {
            return "HDF5CDataTypes.JH5T_NSTR";
        }
        if (data_type == H5.J2C(98)) {
            return "HDF5CDataTypes.JH5T_STD_B16BE";
        }
        if (data_type == H5.J2C(99)) {
            return "HDF5CDataTypes.JH5T_STD_B16LE";
        }
        if (data_type == H5.J2C(100)) {
            return "HDF5CDataTypes.JH5T_STD_B32BE";
        }
        if (data_type == H5.J2C(101)) {
            return "HDF5CDataTypes.JH5T_STD_B32LE";
        }
        if (data_type == H5.J2C(102)) {
            return "HDF5CDataTypes.JH5T_STD_B64BE";
        }
        if (data_type == H5.J2C(103)) {
            return "HDF5CDataTypes.JH5T_STD_B64LE";
        }
        if (data_type == H5.J2C(104)) {
            return "HDF5CDataTypes.JH5T_STD_B8BE";
        }
        if (data_type == H5.J2C(105)) {
            return "HDF5CDataTypes.JH5T_STD_B8LE";
        }
        if (data_type == H5.J2C(106)) {
            return "HDF5CDataTypes.JH5T_STD_I16BE";
        }
        if (data_type == H5.J2C(107)) {
            return "HDF5CDataTypes.JH5T_STD_I16LE";
        }
        if (data_type == H5.J2C(108)) {
            return "HDF5CDataTypes.JH5T_STD_I32BE";
        }
        if (data_type == H5.J2C(109)) {
            return "HDF5CDataTypes.JH5T_STD_I32LE";
        }
        if (data_type == H5.J2C(110)) {
            return "HDF5CDataTypes.JH5T_STD_I64BE";
        }
        if (data_type == H5.J2C(111)) {
            return "HDF5CDataTypes.JH5T_STD_I64LE";
        }
        if (data_type == H5.J2C(112)) {
            return "HDF5CDataTypes.JH5T_STD_I8BE";
        }
        if (data_type == H5.J2C(113)) {
            return "HDF5CDataTypes.JH5T_STD_I8LE";
        }
        if (data_type == H5.J2C(114)) {
            return "HDF5CDataTypes.JH5T_STD_REF_DSETREG";
        }
        if (data_type == H5.J2C(115)) {
            return "HDF5CDataTypes.JH5T_STD_REF_OBJ";
        }
        if (data_type == H5.J2C(116)) {
            return "HDF5CDataTypes.JH5T_STD_U16BE";
        }
        if (data_type == H5.J2C(117)) {
            return "HDF5CDataTypes.JH5T_STD_U16LE";
        }
        if (data_type == H5.J2C(118)) {
            return "HDF5CDataTypes.JH5T_STD_U32BE";
        }
        if (data_type == H5.J2C(119)) {
            return "HDF5CDataTypes.JH5T_STD_U32LE";
        }
        if (data_type == H5.J2C(120)) {
            return "HDF5CDataTypes.JH5T_STD_U64BE";
        }
        if (data_type == H5.J2C(121)) {
            return "HDF5CDataTypes.JH5T_STD_U64LE";
        }
        if (data_type == H5.J2C(122)) {
            return "HDF5CDataTypes.JH5T_STD_U8BE";
        }
        if (data_type == H5.J2C(123)) {
            return "HDF5CDataTypes.JH5T_STD_U8LE";
        }
        if (data_type == H5.J2C(124)) {
            return "HDF5CDataTypes.JH5T_UNIX_D32BE";
        }
        if (data_type == H5.J2C(125)) {
            return "HDF5CDataTypes.JH5T_UNIX_D32LE";
        }
        if (data_type == H5.J2C(126)) {
            return "HDF5CDataTypes.JH5T_UNIX_D64BE";
        }
        if (data_type == H5.J2C(127)) {
            return "HDF5CDataTypes.JH5T_UNIX_D64LE";
        }
        if (data_type == H5.J2C(76)) {
            return "H5T_NATIVE_OPAQUE";
        }
        return "Unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            H5.H5Tclose(this.id);
        }
    }
}

