------------------------------------------------------------------------------
--                             M O D E L I N G                              --
--                                                                          --
--                     Copyright (C) 2010-2015, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Text_IO;       use Ada.Text_IO;
with GNATCOLL.Traces;   use GNATCOLL.Traces;
with TestPools_Support; use TestPools_Support;

procedure TestPools is
   Val2, Val3  : Int_Pools.Resource;
begin
   GNATCOLL.Traces.Parse_Config_File;

   Int_Pools.Set_Factory (1, Max_Elements => 2);

   declare
      Val1 : Int_Pools.Resource;
   begin
      Int_Pools.Get (Val1);
      Put_Line ("Retrieved element from pool: " & Val1.Element.all'Img);

      Int_Pools.Get (Val2);
      Put_Line ("Retrieved element from pool: " & Val2.Element.all'Img);

      --  Now Val1 goes out of scope and we release the resource
   end;

   Int_Pools.Get (Val3);
   Put_Line ("Retrieved element from pool: " & Val3.Element.all'Img);

   --  The following would Deadlock
   --  Pool.Get (Val2);
   --  Put_Line ("Retrieved element from pool: " & Val2.Element'Img);

   Int_Pools.Free;
   GNATCOLL.Traces.Finalize;
end TestPools;
