// Generated by gmmproc 2.50.1 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gstreamermm/context.h>
#include <gstreamermm/private/context_p.h>


/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2014-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/structure.h>


namespace
{
} // anonymous namespace


/* Why reinterpret_cast<Context*>(gobject) is needed:
 *
 * A Context instance is in fact always a GstContext instance.
 * Unfortunately, GstContext cannot be a member of Context,
 * because it is an opaque struct.  Also, the C interface does not provide
 * any hooks to install a destroy notification handler, thus we cannot
 * wrap it dynamically either.
 *
 * The cast works because Context does not have any member data, and
 * it is impossible to derive from it.  This is ensured by using final on the
 * class and by using = delete on the default constructor.
 */

namespace Glib
{

Glib::RefPtr<Gst::Context> wrap(GstContext* object, bool take_copy)
{
  if(take_copy && object)
    gst_context_ref(object);

  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::RefPtr<Gst::Context>(reinterpret_cast<Gst::Context*>(object));
}

} // namespace Glib


namespace Gst
{


void Context::reference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gst_context_ref(reinterpret_cast<GstContext*>(const_cast<Context*>(this)));
}

void Context::unreference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gst_context_unref(reinterpret_cast<GstContext*>(const_cast<Context*>(this)));
}

GstContext* Context::gobj()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<GstContext*>(this);
}

const GstContext* Context::gobj() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<const GstContext*>(this);
}

GstContext* Context::gobj_copy() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  const auto gobject = reinterpret_cast<GstContext*>(const_cast<Context*>(this));
  gst_context_ref(gobject);
  return gobject;
}


Glib::RefPtr<Gst::Context> Context::create(const Glib::ustring& context_type, bool persistent)
{
  return Glib::wrap(gst_context_new(context_type.c_str(), static_cast<int>(persistent)));
}

Glib::RefPtr<Gst::Context> Context::copy() const
{
  return Glib::wrap(gst_context_copy(const_cast<GstContext*>(gobj())));
}

Glib::ustring Context::get_context_type() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gst_context_get_context_type(const_cast<GstContext*>(gobj())));
}

bool Context::has_context_type(const Glib::ustring& context_type) const
{
  return gst_context_has_context_type(const_cast<GstContext*>(gobj()), context_type.c_str());
}

bool Context::is_persistent() const
{
  return gst_context_is_persistent(const_cast<GstContext*>(gobj()));
}

Gst::Structure Context::writable_structure() const
{
  return Glib::wrap(gst_context_writable_structure(const_cast<GstContext*>(gobj())));
}


} // namespace Gst


