/*
 * This file is part of the GROMACS molecular simulation package.
 *
 * Copyright (c) 2016,2017,2018, by the GROMACS development team, led by
 * Mark Abraham, David van der Spoel, Berk Hess, and Erik Lindahl,
 * and including many others, as listed in the AUTHORS file in the
 * top-level source directory and at http://www.gromacs.org.
 *
 * GROMACS is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * GROMACS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GROMACS; if not, see
 * http://www.gnu.org/licenses, or write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * If you want to redistribute modifications to GROMACS, please
 * consider that scientific software is very special. Version
 * control is crucial - bugs must be traceable. We will be happy to
 * consider code for inclusion in the official distribution, but
 * derived work must not be called official GROMACS. Details are found
 * in the README & COPYING files - if they are missing, get the
 * official version at http://www.gromacs.org.
 *
 * To help us fund GROMACS development, we humbly ask that you cite
 * the research papers on the package. Check out http://www.gromacs.org.
 */
/*! \libinternal \file
 * \brief
 * Declares a generic serialization interface that supports both directions.
 *
 * \author Teemu Murtola <teemu.murtola@gmail.com>
 * \inlibraryapi
 * \ingroup module_utility
 */
#ifndef GMX_UTILITY_ISERIALIZER_H
#define GMX_UTILITY_ISERIALIZER_H

#include <string>

#include "gromacs/utility/basedefinitions.h"

namespace gmx
{

/*! \libinternal
 * \brief Interface for types that convert standard data types into a
 * form suitable for storage or transfer.
 *
 * Different implementations could suit MPI, file I/O, or in-memory
 * conversion. */
class ISerializer
{
    public:
        virtual ~ISerializer() {}
        /*! \brief Returns whether the serializer is reading or
         * writing, because details like memory management vary
         * accordingly. */
        virtual bool reading() const = 0;
        //! \brief Serialize values of different types.
        ///@{
        virtual void doBool(bool *value)           = 0;
        virtual void doUChar(unsigned char *value) = 0;
        virtual void doInt(int *value)             = 0;
        virtual void doInt64(int64_t *value)       = 0;
        virtual void doFloat(float *value)         = 0;
        virtual void doDouble(double *value)       = 0;
        virtual void doString(std::string *value)  = 0;
        ///@}
};

} // namespace gmx

#endif
