/*
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __GLUE_GUI_GTK_FI_H_INCLUDED
#define __GLUE_GUI_GTK_FI_H_INCLUDED

typedef struct {
	GtkVBox parent;

	GtkWidget *table;

	const char *type;
	const char *activator;
	struct {
		const char *name;
		unsigned long long start;
		unsigned long long end;
		const char **desc;

		GtkWidget *entry;
	} loc0[4];
	unsigned int nloc0s;
	struct {
		const char *name;
		unsigned long long start;
		unsigned long long end;
		const char **desc;

		GtkWidget *entry;
	} loc1[4];
	unsigned int nloc1s;

	struct fi_fault_actual {
		unsigned int state;
		const char *loc0[4];
		const char *loc1[4];

		GtkWidget *weak;
		GtkWidget *active;
		GtkWidget *range;
		GtkWidget *trigger;
	} fault_actual[100];
	unsigned int nfault_actuals;

	GtkWidget *dialog;
} GuiGtkFI;

#define GUI_GTK_TYPE_FI	(gui_gtk_fi_get_type())
#define GUI_GTK_FI(obj)	(G_TYPE_CHECK_INSTANCE_CAST((obj), GUI_GTK_TYPE_FI, GuiGtkFI))

extern GType
gui_gtk_fi_get_type(void);


extern GtkWidget *
gui_gtk_fi_new(const char *type, const char *activator);

extern GtkWidget *
gui_gtk_fi_pattern_new(const char *type, ...);

extern void
gui_gtk_fi_set(
	GuiGtkFI *fi,
	const char *type,
	unsigned int activator,
	unsigned long long loc0,
	unsigned long long loc1
);

#endif /* __GLUE_GUI_GTK_FI_H_INCLUDED */
