package gui

import (
	"encoding/hex"
	"io/ioutil"
	"log"
	"os"
	"path/filepath"
	"strings"

	"github.com/twstrike/coyim/Godeps/_workspace/src/github.com/twstrike/gotk3adapter/gdki"
)

type icon struct {
	encoded string
	size    string
	decoded []byte
	cached  gdki.Pixbuf
	path    string
	name    string
}

var coyimIcon = &icon{
	name: "coyimIcon_256x256.png",
	path: "build/mac-bundle/coy.iconset/icon_256x256.png",
	size: "256x256",
	encoded: "" +
		"89504e470d0a1a0a0000000d49484452000001000000010008060000005c72a86600000004734249" +
		"54080808087c08648800000009704859730000037600000376017dd582cc0000001974455874536f" +
		"667477617265007777772e696e6b73636170652e6f72679bee3c1a00001eef49444154789ceddd79" +
		"7c1bd5d537f073ee48b6b57877363b49d90ba4408114020f504ca0a169694b791b5e689bb7852614" +
		"4869a1ecb4104ad95b0a059ab2539e9216872510309004429eb2843e4943164220a109c4fb2e5996" +
		"644b73cffb8793348b1d6ba49146b27fdfcfe77e3e1079ee1c4933e7de19dd7b8708000000000000" +
		"00000000000000000000000000000000000000000000000000000000000000000000000000000000" +
		"00000000000000000000000000000000000000000000000000000000000000000000000000000000" +
		"0000000000000000000000000000000000000000000000000000000000000000000000000000c036" +
		"ec74003072441ebefe028e45cbe2a5e316fbc64ddec0d5d571a7631ae99000202364f5ea92c87b4f" +
		"37924841ff3f489c0cf7ff88c7ffbc316ae292fce9333733b37638cc1107090032a2f7c95b6e337b" +
		"baae1bec75260a903bef55f117bfe03960e2729e727e7326e31ba9900020ede4c377cb226f3dd744" +
		"42ee84b7615eaf3cfe054645e5abeeca633ee0c99363e98c71a4420280b48b3ef9db3b75a8f3eaa4" +
		"2bd87eb9a03cbee7a862c292fc6ffee8535c2ed8030900d22a99d67f28ac7580dcee5af1972df48c" +
		"9bb89c4fc7e542b2900020adc24ffee66e0a05ae4cdb0e444848ad573eff02a37c6cadbb6af21a5c" +
		"2e240e0900888848b6bdebe95bb5767f33d07c04d5fdbbf2fd13f7bfbfba7a6e4a3fd3c987ef9645" +
		"96d9dbfa0f494b9c0c63b9f2f99ea5b2f14bf3bf75e1bf71b930382480114836ad288a6df9f400b3" +
		"abe1580a064f9258f454d27abffe1785ccad1b8888def41f37e5eb3c636e5fb2fb093f3ef71eeae9" +
		"bedc9ea893c35a07286fc7e5c2216ff0e9df6d77329e6c8304308c8908d3dac5a3a29bb74ee2dec0" +
		"97241a3956477ba6b1986307dda6ab8d747b43ff7f1bc63f0aaba79fc1d32febb5bcef0fdf2d8bbc" +
		"f97c3391b852780bf6124d42bc5e79bc35464565ad7bc2716b47fae50212c0302122066d786b54f4" +
		"df9f4e52c1d6c9f170cf29aaafef1421d36fa112323fdb4814ffcf39c1ccab7c53ce3c99675c11b1" +
		"124ff4b1b97fd03dddbfb0b24dc669899332962bbfff392aaf5a32122f17900072906cda94dfdbba" +
		"610237371c6506dba750b8fb1432cd6388536b6da5ab8d745bc3de2f306ff44f39f12b3c636e2891" +
		"7abadf797db4b16a71031119a9c493692c664094bbd6f417bfe01f77c81b7ce68c0ea7634a372480" +
		"2c271bdf2e8c7dbae94033d8762c47c347eb68f438d27d93496cfeee0668fd777b997873e1e4138f" +
		"e51fcc0d0e5555f491b9f7e948f765b6c697697a97cb85e2b1afb80f9ab26e385e2e2001640911e1" +
		"e086f74a3d0d9f7d81da9b8e35c3c19324129a4aa2c76764ff5deda4dbeaf7fd47aceafc934e388a" +
		"7f3277d09651562c1d13f9e7abf59463adff90b65f2e4841c1b3c6a8f14bf2bf337bcb70b85c4002" +
		"70808828daf0d6e81dd7eb3a143e99639193b448b14301edb3f5df153337fa8e3cf628bee0f6d681" +
		"5e8f3e76f3033a14bcd4f618b30c9bf180b8f36a4d4ff10bfef1b97bb980049066b269537e6fcbfa" +
		"f15cfff991ba2774948e45bea2faa2d522e2713ab61d24d04eba7588d67f174cd4cefb4d3ac277f9" +
		"bd8dbbd5b362e998c8fbc3b0f51fca8e5f170a3ccf18c5635e711f7ce2fa5cb95c4002b0916c7cbb" +
		"b0afb1e50bd4d172a8d9dd3985c2c153d272bd6e272d647ebe912866f1786509b9c68e3fc273dd93" +
		"5b77fc53e491b97fd23ddd17db1c61eed1f11819aed7bc479e7a01579fd5e67438fb92bd07668e09" +
		"3f7dd7e5d4d17c8fd37158258176d22d89b7febb6109b9c6ef77a4e7aa47b7c83f978d8dbcf74a9d" +
		"888cacd67f5f983678bff5cd6379ffeaa8d3a10c0609c006b2766d6974f953f5d9d4ad4f8808999f" +
		"7d4c144b7ab01f11518cca271ea32a275e46e1e02cbb421b36945ae4fdd95ddfc9d61b86d9334a2b" +
		"8745de7fe116d23976f21391043a523df98988dc1c6cfd1715971a684e06a0f55991076ef81d115d" +
		"e1742803514e0790ebe45f6f7c8122c14b9c8ec33211d29d03dec8b74c958f761389222142d9bb48" +
		"bcf7f2f0e3b79f97d2879c26480029ea79ef8dfb49133b7d90593e2877b4fe29d6c37905243e677e" +
		"bdcc25126879baafe68fc7391dc79e900052105ef497e354acf72ca7e3b04ec8ec6cb5259750e958" +
		"226d4345c3be2836ebb6be115ef65c460676252a2d0920fae80d6785ff7cd579f2ca83634564585e" +
		"198a88a2cf363ee8741cc9d0814e9b5a7f0fb1afc88177909b34b19f56bffb3fb2e6759fd3b1ec60" +
		"fbc9d9bea2b6c8bbea8d2621f21011b16906c4edae255ff10b9e03272ee7ff9ad962f73e9dd0bbe0" +
		"816f9bf55b163a1d4732e25b3612c553bef9476adc7ec45e2400ab9878b9e7e86f9c9e0dcf45b03d" +
		"01f43c7ad3cddc1bba71c017b59010ad571edf3346d1b857dd07e4e67c6cf9f0c3bcf092273733e9" +
		"094ec76295eeea20dd5297723daac0433cfe601b221a9994e17abce0b23b7ec2cce2641cb6260059" +
		"bdac24f2cecb4dc4949fd006a68e93e15aae7c45cf51f9f8a5b9b2da6bf4aff75ca2dbea73affb2f" +
		"f6b5fec6b80388bc892f350003f0fa2ef15dfc9b794e86606b02883e3ef74e1dee4e7af967d63a20" +
		"2ef7ab5458f642b6aef62a9b5614455f7eae4e48173a1d8b5576b5fe5c50406ac221dbef0242f284" +
		"a474dc19fe0bae5aea5404b6250059b6a822b2eead46629b0617096d7f3844d102a37cd46bee095f" +
		"599d0d970bbd8fdf7a8719e8b8c6e9382c13a2f8d68d760cfc21a3727f226fcee5bfacc4a27bd5c1" +
		"93be54f0ed9f6c7664ff7655147ee8570f505f247dd34035c5d9652c677fd1f35475d0d2fca9e766" +
		"fc5972b2f1edca48edc2cf89726fbcbb0e74906eb6a1f5f778498d3fc886886027ad9bbcd5d30fe5" +
		"c9670432bd6b5b1280ac78714ce4fde5f5a4386327060b05c4e57e8dcaca177a2a0f58cea79cd338" +
		"f456a909fff9c6f914eec9ca115d43896fb1a9f5af3a80c8836b7ffbc92aefa9e79f90e95eae2d09" +
		"a067def54f70acf74776d4952c61f5a1f2172d304aab5e731f7cfc6a9e3429f5a37d17bdafce3fd2" +
		"fc68d51a3bebcc14bb5a7fe5f111571d6843443010267adef3cbdf7d2f933ddb941340f8dd9a2a5a" +
		"f9fe36caaa39ef1c6777de3f8ca2b217a472bf37f3aacfd9c8cc66b2b58908471eb8e12deaeb3dc5" +
		"ce2833c2c66b7f35fe0062b4fe69a5dceeb99e9fdf7173a6f697f2491b79f0babf4bacef5c3b8249" +
		"1be676e5f53f27f9c5cf78665efea6d5cda3357f3e436fdbb4381da1a59b7dd7fe3e5268fd3340c8" +
		"28ae38ab60f6f52f67626f290d058ebcfed4fe597ff213118994eb9eeed9f10defbcd17dc379e758" +
		"db540ca9dff2a0f363c993289a48b7b7d85217970dfa2c11b01593ee6a5d189affa72333b1b79412" +
		"807cbc3e6756c091be5e92508028d05e13baf5e2843fdce85fff3053cc784e0e79d3ddb6ccf727f6" +
		"f8883d59337c7dd81356066fdbf496d4d68c4af7be924e0052fbd7c3c934bf636730e9a4db1a8934" +
		"91685166fde6f7420f5e356493260d2bbdbab9e1778eb7e44916dd664febafcad1fa679c52a5e175" +
		"2b96cb96650569dd4db21b4637afeb6ffdb3e0401faa482442d21dfc4f7756c8ab37ac7d4f163de4" +
		"dde77bac5d7c258b9425fb193949076d6afdbd7ea2029fe3dfe1882ccc87859f59f4523ad7594c2a" +
		"01f4fdfda163241e9f667730e9a2db061822a0f57ea1d7172e929a9a013f5c59f3ce68e9eab83edd" +
		"b1a58510895dad7fd998ccc70fffa1f88cc83dd7fe2e6dd55bdd4044b8af71f3bdfdff93fd457a42" +
		"243da1815f8bc74f0bbdf3d4bd03ad59107d7bf1ed2492d8a4a62ca3831d2468fd874d9178fc17bd" +
		"f7ffe607097c6596594e0091bf3d3845893e391dc1a4836eddf70041e9ed9dd37de5f72edcf5dfa2" +
		"8b9f3d587a421738fdc5277dc0d876ed3f7aa88f173224ded3f154df13bf9f6277bd96128088b034" +
		"6dfda3d30778a24507ba48a291a1ff3614782478c38f4fdcf13ecd8f3ef8a395cf259be8809dad3f" +
		"06fd640d3638de54b7345cfb575b9714b3341028f2b73f9c2a0d75cbec0c206d84c8dcbad1c2c9c0" +
		"317dd0215ff41d7862556cf3aa7fa435b674112273cb46923e1bc6fc4f3c88c8b3cf7ba4e00433de" +
		"10fdf2b4c3caa74f1ff229cd8948b8072022acebeb1e70ba554fb8f5ef6aef3f1112de46dc6ad3a6" +
		"f7fbb6ac7d28e14f2fcbe840872d273ffb0a890abc8e7f87280314e5aa2c58fdfaebb272a57b9f5f" +
		"6282129ebbdffbd49d67b2d0243b769a76a249b735f77f6016a8b2f2511c8fa57df045ba48873dcb" +
		"2daa72dcf9cf6a866b4af8cd671e16910b525d522ca11e808828b3a52567ae8b75672b513c6e31b3" +
		"2ae2a2dcbde9a5bb3a497a6d58e9d75b48948fd63feb8ba97fd47bdf8d3fa314259400228fdff16d" +
		"26ce8d5520b426dd61fd893746e9186257ceadf3d14fc8b6d69f2b30ea2f5798e1d07dd1876f393d" +
		"953a864c00b26c994b5a9b73e7ce7f5b33515c5bdbce95475c54e178ec49bfe74027496f6fcaf5b0" +
		"af90383fe71e713872b122ddd6fe72b4e6d1a41be721134074e33be7b232b2ea69268391588c7447" +
		"9be5035f958f255259b49c81154224ed765dfba3f5cf35c246bef9f1baf765e9f3e5c96cbfcf0420" +
		"2b57ba75b0236dc310eda6db9b89442c6da33c5e5285258eb7e24eb7fee42b24caf738fe7e509228" +
		"86abace7bdb7de92da5acb2357f79900a2ff5bfb43261eebf81b4ca0486f2f495787d5f74f5436b6" +
		"bf8e5c2484d61f8888880df79742ff5af23711b134b86fd0bb5e9b6a6bf3fd5b3f5ccc8a73e2a250" +
		"37d611f5f55ada86fd85a44a73f7272f0976924e26e9ed810b8b4895e5ecaf9fb01d331f167bef0d" +
		"ba6de93b6f25bacda0d962ece67fce62a54a9d6ed9136afdc3e1dda6fb26548888cb2b13fd9cb292" +
		"6eb3a9f5c78cbfe12316bb2978dfcd6727fae7032600d9b2acc0e80edc665f54e9a55b9b2c6fa38a" +
		"cb89f37272b21f1111894dd7feca5f48ecc9894e1e24422932825d0b7a1fb937a155af064c009197" +
		"debc8c942a74ba654fa8f50f0d3edd77d0c28a289747bb897dad3f978f75fc3b44b1b92865988d5b" +
		"df09bdf2c4903776f64a002dcb6afcd41dba498428178ad9da68791b2e1b45ac5cce7f51491609da" +
		"d4fa17161317a0f51f8ec430fcbc72f5dbb272d13e6774ed3517a070f59a2bb45239310d4c829d24" +
		"e188b58ddc6e324a4793a427a4f41322dd6a57eb3f9a72f783802119ee0343af2c794944a60df65c" +
		"8cdd7a00b26449b119eef95566a24b9110e956eb0f0f362ac692103bde8aa7d4fa5bfcb56320aab0" +
		"18a3fe460065b8a7466efde53d03ad7a45b4470fa0f783e5d7311bee5c681574677bffe4170b5441" +
		"017151699a22ca8c9d2bfda60833fe460e11baace777bffe80889ed8f3b59d3d0059fa7cb9190d5d" +
		"e9740b9750d1dba7fb5ac4a372fb67bf9d77fe53a48a4a880ad2bada34641366a248e8b1f003b79d" +
		"b0e74b3b1340e47f57cc253672623a9c6e6f258a599beecb3e3fb12f8797b8129bd6f927222e1fe3" +
		"7c1247c968613658da9ade8cfc6dde7eb40b4544242fce1f23b1d8a5940b4cdd9f00ac602285d69f" +
		"8888546109717eee8e7f801418ee02fdd147ef486d6dd18e7f7211114537acb98d546e4c87d36dcd" +
		"44a6b5a727737119717ec1ce1630e7884dd7fe8c3bff239ecb5d195ef1da6259b9f2649e3c39a6c2" +
		"0bff3641f7c5726309ec64a6fb3293312ab76f78d977ed5fda9f08616473b98fef79f9af8f8a08bb" +
		"f4fa7fddcdcc39d12ae8e66622d35aa0aab094c870e7c4fb1b905dad3f11710526fc403f56c6ccc8" +
		"9dd7af71a96834aec33d4ec79310e96825b178fd2fa649e2cde127db8a90b4b5f43fdf20d5aaca2b" +
		"fae7fc0310118f1e431caef94b95b97c719dd3c12424d647f10d6b88b4857b004a91ebf0a388dc79" +
		"e98b2bcda4b38dccad9fa65c0f975590f185036d8808721d7bbc8ff9ee7e7896f2cef87ff52e8f6f" +
		"9ed30125c49d47aac2e24f58a626dd901bf96d305c5a6ecb987de96cb7a5270139ceed7ec7f77f2f" +
		"ba9899fb570f2938f1a4b924248edfe44ba0a8315544cab0b48d6e6fa35cb9cc1918931a5399fae7" +
		"a78574637de6c387acc14ad5f9bf36633a4f9e1c23da3e0e80bf3bb385fdbe7b9c0d2d4186416acc" +
		"386bdb8890d46d4b4f3c19625b2fa0ab8324825ec048c44c1163caf127f12e8f15db3912d077dae9" +
		"b79190e9740b9f502f60f43822579ea56d24182009041c8f3de962772fc0e9f78392e9226ac261a7" +
		"7abe3fe733dac5ce04c067cee8504525b76641a0431752499d0cb2ed73226b6388b28a9df7022812" +
		"b62122c815aed1e3667aaff9d53ff7fcf7dda6037bbffa8ddf9350ea4f97cc0055319a38afc05202" +
		"d0e1304947abf3092ce9c467532f4088cc06f402464a619feff70537ddfd340d60b704c0d3a707b9" +
		"b4e4c681fe30eb3093aab4febc92787d1db1361dff5292fe324bcbfbe7f1a7588f747690a01730ec" +
		"89dbfd9aefae87ae19ec21a27b2d09169ef6d50799b9c7e9033de193c1e3b3b64d6f1f998dd61711" +
		"cd1e4c6aac3d139b04bd80e15dd8f8a470e639e70cb61a10d100096074f58c9059547283d36bfd25" +
		"bcbe5fe504ebeb08363612f5c506fb4cb29e5dbd008d5ec0b0c54a05f9a4934fe1c967edf30b1e70" +
		"55e0a233cf798888038e67b0040a17161317165bdbce34c9accfe1c141cca4c65afc297410d290db" +
		"3f8fc2804cf7e1934ef49f3f6bc85573064c005c5d1da5f2f2abec8f2b3d54d504cbdbe8b656929e" +
		"88e3092ce9c4575a61532fa08ba427970749c19e64dcf8b3f3e75cfb61227f3be893819a4f9ef614" +
		"296eb72facf461af8fb8a4ccdac1af85742e0f0eb2b11780d181c3872a29fd55d14d772e4af8ef07" +
		"7be1e0e9d37bdd15637eee744b9768312ac713595ced577776921908387e1f23d942a5fdb3fb52ad" +
		"47777692847a1cff0e51522b3acf53e3bdfdfedbc9827d3e49b4e0ecf36a58a97aa7df584225df43" +
		"aaacc2fa769fa3174044b97d4f04880cd70745677e7726335b1aeab6cf04c09327c768f4b85fa416" +
		"59e6a8caf1fd13852cd03d3d24ed1dce27b0240b97d9732f40025dfd8f591342c9b142c2adfe6f7d" +
		"632a4f9f6e79d9a8219f25ee9ffaf585426aabd3077a42c59d476ad468cbdbe9cf3fa7dc1d236c63" +
		"2fa001f702720d3347dd534e9cc267ce48ea39f1432600aeae8ebbaa2ae72453b913d458ebd38525" +
		"da4bbac1fa7306b2856dbd80aefe5e80e3891c25f13271e2f4820b2ef9372569c8044044e4bdf98e" +
		"57d9303e4a762719e532926a11757d3d713c9e868032c0ce5f04727cf19491c4185d7e71e10db72d" +
		"4ba58e841200336bd7f8f13f733cdb2558d49871fd4b8059d92e6e52bcaec1f1d8932d5c56617972" +
		"d44045ba0224dddd7b1f0490550c8fff61ef6fef7b28d57a124a0044440537defaa618ae0f9c3ed0" +
		"132aacc8185765793bddd4dc28ca58ed78fcc9941df7026ca84be35e407673b9ffe19d396bce6013" +
		"7cac48380130b3b8271e38c7f1033dc1c215a3fef33090c44ea0beb8c48ef67cf1b00b13fd4cb20d" +
		"978fb265dd7f096cef0564c1f788b27b11a5b6c5ce9af1cd1d4b7aa52ae1044044e4f9f5afdfa53c" +
		"f7bb76ec38fd98549585e9c2ca9c3c66fd96e6bc5f5eb79af30b9e77fa8b4eaad8d90ba8432f20db" +
		"3073c875dca953ca7759d22b55961200338b71d0613fb76be7e9c665e5c4dea1a70b0bd18cb275ff" +
		"5eb7633be3e8a372e63dee6967cf2745120c9004737809b5e157441d7444b5efc20b1b86faeeacb0" +
		"94008888bc575fbd8add794bb3e00349a8a8aa09fb7e5de8f6f20d9b17ecf61e675d56a7bcfefbac" +
		"7e36d9c1c65e407d63e6c38701b9c6569ee7bbe69a9576d76b390130b3e41d7ec4154e9fd889162e" +
		"dac7746192578a376ebe61a0f7e99b7ae65c268e5afd7cb281bdbd80a0e3dfe1482faab0f02eefad" +
		"773f93c0576699e5044044947fc515eb382fff25bb8349173561efe9c24cb4a9d45772f6604f45e4" +
		"b3cfeee292e2eb9cfef2932ab817306c485e5eadef0ff3ae4f57fd4925002222ffd1c75ce5f8819e" +
		"6061af8fb874b7e9c221f2c48fe355abf67927d577fa37e6b1626b0f23cc12fdbd80fc94eb91ee60" +
		"7f2f00328e0dd7baa27367ee7349af54259d0078ce9c4f243fffef7606934e46d5cee9c25a913aaa" +
		"f483ad5d436dc3d3a7f7d2e8ca4b9c4e60c9f702ec594158d7617460c631b7fbaba79dc6d5d569bd" +
		"0c4d3a011011b98f39f66ac70ff4444b8187b8a49414ab69259f7c92f0d869ff6d773ecf2e23a1d5" +
		"55b28d7dbd806ed2b81790c962f2515f3e85cf3fbf2dd1ef2859292500efa5976e238fe72f760593" +
		"36cc2daab0f00ff9c71f7f7cc9279f2cb5b6296b63fc01b3b3e0a0b05e88498db3a71720dbd00bc8" +
		"145535e19b85975db92113fbe2542b083df2c81873d95b8d6c435db6618ea93cf7125d52f26cdec4" +
		"8397e7ffe2e2ad56174ad895887068f68f5f95bed8343bc3cc0c2173ed1a925ecb53c5f7a20e3d94" +
		"5451b10d31c1605449c9f5fe7b1fb4b4aa4f2a6c3969033f99fd27eee9b9d88eba92252e63351716" +
		"cd5713c72ff19d7efa06bb864aee1079e4fefd636faf487adaa593a4a585ccad5b52ae870b0bc938" +
		"fc701b2282814841fedf8be63df6fd541a2bab6c4900327f7e4570d12b4d4c646d399e5428eea482" +
		"fc178dd28a85de2327bdc73367b6a47b97a18b663daa23e1dc9b2b20f6f5028cc30e252e462fc06e" +
		"ec72bde7ffe9cfbe6a77c335e47eedaa2834eba2bb752874a55df5ed6547b7bed49e6e7d3264fefc" +
		"8ad0ebb50d22e2cee47eed605b2fc0ef2763d2241b22821d58a97afff7ce3b9c6d1ce39ff0beedaa" +
		"28505353c62fbcd444369e1ce23256b3af68beda3f3dddfa64f45c36e706b3b3f3b74ec761197a01" +
		"598999a3aeff3afe70cfac9fa59e9d93d9bf9d9575ff74ce5ce9ecbc29e90a14779227ff45a32c73" +
		"dd7aab64d1226ff782671a4824e7ce00db7a013e2f19471c614344c0130f38b5f0965b963bb67f3b" +
		"2b93dadaa2eebfcc6f2691c406a22b8e29f7f66efdfece74eb9311b9f2ca1fc49a1affdbe938ac13" +
		"32d7d8d80b28c9b91c98558cf25117faeeb9f7712763b0fda7bbd045975ea33bbbee18ecf59d77eb" +
		"abc62ff14dcf8e6ebd55b26c992bf4e4131f89691ee4742c56d9d50b507e1fa92f7dc986884626c3" +
		"eb9be79df7d0a576acea930adb13404b4d8dbfe0d9979a88c44744fdddfafcfc178d51d9dbad4f46" +
		"f7b5d79e2675dbde703a0ecbc4c65ec0a15f242e2db121a89185f3f296f8bf3f733a57573bbe0a6d" +
		"5a06ef842e98fd3531a5900f99f4b6effa9fb7389de5d24144b8fb821f2fa758ec64a763b14a9aed" +
		"fa45c047067a0196b0cbd8e4ffeef7becc67edfbb1dd99923da3f77250ef1d774cea5db76ebdd371" +
		"58a635996bd7dad30bf8e221c465a5360435fcb1524175fad70ef5fdf08759b3d24a4a730146bafc" +
		"6baffd903c9ea79c8ec332a588c78db365ba81de56e7fc9c87dc28927fe8e1a766d3c94f840490b2" +
		"c2e34fbb5a84240b0e304b852b4611e7e5a75c8fee09937474daf5710e5bae0955ff27efbaeb563b" +
		"1dc79e900052c4b3ce6fe6a2c23b9d8ec32a568ad4389b9e29b8adae8f72f7e18ae9e72fbcc37bfb" +
		"5dcf3b1dc64090006c5078eeb9b712718fd3adbae55ec0281b7a01c47d2ad87ba8f217e6e822aae9" +
		"c5059e670be7cd1b70ddc96c80046003aeae0ed1a8f2cb9d8ec32a6695eada8141d38c7da1e4b38f" +
		"b7e8134eb895844ca7935a361556c61afff7bfffc36c1edc865f016cd4b06891b76cf3b6b1f1a6ba" +
		"8339109c62f684a64a3c765256ad95b007d19ae21fac21eaebb3b41d33b7455d7c58e5279fec5cb5" +
		"267cd14577c7d339212c77f47141c1223d6ddaece219c93db63b53b2f6c01c2e64e54a7764f5ea31" +
		"7af39649ba2b780445a3c7535ff4eb24db074a6501ddd44ce6d6ad896fc0d4128e450f9b5057b7db" +
		"c12d353565c1852fb664745a789610c358cdc545f3d5f8ec99b896082400078808d38205a5c10d9f" +
		"1ce26a6b3ac6ec8e56532c3a95b438f283bac55ec0369d6f4c1af5f1c7033e423838fba77752a8fb" +
		"6a7b23cc42fc9ff528e2c71dfb8f6c6fe9078304902544843b5e7db5d0bf6143655f7dd39775a0fb" +
		"648a84a7b3d6fb6562ffbab999cc2d5b87f82bde5216f51cc1cd6b7b06fb8b404d4d192d7cb18565" +
		"98f50294bdcbcc650b24802cd7b06891b7fce38f27f6d5377d597a424753387a82c4ecbfaf30542f" +
		"8085d697aaf85778ebd62197a90ecefee9edd4dd7dad9df13921ddcbcc650324801cb4eb7d05ee0c" +
		"4e31c3a1a9148f4f219dda622cbaa989ccad9fedf5ef4cf441691e4de1cd9b131a3bdcf5f4d3a5fc" +
		"726d6bcedd0b50c3a35b6f0512c03021228a162c28d9edbe426fefd748eba2c4ebd0145fbd572fe0" +
		"ddb251c5a70ef514a53d75fff492df4a2090b5bf7f1351562c33e7342480616cd79b8ddcd67e9884" +
		"c393251c3e4b69bdf7c312b7d38dbbf50216976ddb3c9d892c3f9a4a6a6b8bbaff7b7e9b9d4bc4d9" +
		"211b9799731212c008b4eb7d051de83e99239133c8340f26da7e2f60d56aa258ec9537ea3efdf68c" +
		"244efe1d02175d7c0b0782bfb22ff224ece8d6978d9c6ebd15480040444452539317f8e7da2a6e6a" +
		"3c5cd67f38eede0f563c3e37c5f1fd525b5b147ceae95626cab329cca131c754be7b892ecaad65e6" +
		"9c8204006995f242b1091023f79799730a1200a4d5ce5e80d8d80bc881d5a373051200a45df7ac4b" +
		"6f9440d7cd495790a3ab47e702240048bb9dbd009d782f6038ac1e9d0b900020237a66cfb9c1ecda" +
		"c7139586e9ead1d90e09003242962df377ffe9d11662f21051ffdd7af7f6b1f507a25bef142400c8" +
		"98c885179f1f8f472b6842d512ffd4a99bb2615d7c00000000000000000000000000000000000000" +
		"00000000000000000000000000000000000000000000000000000000000000000000000000000000" +
		"00000000000000000000000000000000000000000000000000000000000000000000000000000000" +
		"0000000000000000000000000000000000000000000000000000b0cdff0756b6a34c90fa03410000" +
		"000049454e44ae426082",
}

var statusIcons = map[string]*icon{
	"unknown2": &icon{
		size: "16x16",
		encoded: "" +
			"89504E470D0A1A0A0000000D49484452000000100000001008060000001F" +
			"F3FF61000000097048597300000B1300000B1301009A9C1800000A4F6943" +
			"435050686F746F73686F70204943432070726F66696C65000078DA9D5367" +
			"5453E9163DF7DEF4424B8880944B6F5215082052428B801491262A210910" +
			"4A8821A1D91551C1114545041BC8A088038E8E808C15512C0C8A0AD807E4" +
			"21A28E83A3888ACAFBE17BA36BD6BCF7E6CDFEB5D73EE7ACF39DB3CF07C0" +
			"080C9648335135800CA9421E11E083C7C4C6E1E42E40810A2470001008B3" +
			"642173FD230100F87E3C3C2B22C007BE000178D30B0800C04D9BC0301C87" +
			"FF0FEA42995C01808401C07491384B08801400407A8E42A600404601809D" +
			"98265300A0040060CB6362E300502D0060277FE6D300809DF8997B01005B" +
			"94211501A09100201365884400683B00ACCF568A450058300014664BC439" +
			"00D82D00304957664800B0B700C0CE100BB200080C00305188852900047B" +
			"0060C8232378008499001446F2573CF12BAE10E72A00007899B23CB92439" +
			"45815B082D710757572E1E28CE49172B14366102619A402EC27999193281" +
			"340FE0F3CC0000A0911511E083F3FD78CE0EAECECE368EB60E5F2DEABF06" +
			"FF226262E3FEE5CFAB70400000E1747ED1FE2C2FB31A803B06806DFEA225" +
			"EE04685E0BA075F78B66B20F40B500A0E9DA57F370F87E3C3C45A190B9D9" +
			"D9E5E4E4D84AC4425B61CA577DFE67C25FC057FD6CF97E3CFCF7F5E0BEE2" +
			"2481325D814704F8E0C2CCF44CA51CCF92098462DCE68F47FCB70BFFFC1D" +
			"D322C44962B9582A14E35112718E449A8CF332A52289429229C525D2FF64" +
			"E2DF2CFB033EDF3500B06A3E017B912DA85D6303F64B27105874C0E2F700" +
			"00F2BB6FC1D4280803806883E1CF77FFEF3FFD47A0250080664992710000" +
			"5E44242E54CAB33FC708000044A0812AB0411BF4C1182CC0061CC105DCC1" +
			"0BFC6036844224C4C24210420A64801C726029AC82422886CDB01D2A602F" +
			"D4401D34C051688693700E2EC255B80E3D700FFA61089EC128BC81090441" +
			"C808136121DA8801628A58238E08179985F821C14804128B2420C9881451" +
			"224B91354831528A542055481DF23D720239875C46BA913BC8003282FC86" +
			"BC47319481B2513DD40CB543B9A8371A8446A20BD06474319A8F16A09BD0" +
			"72B41A3D8C36A1E7D0AB680FDA8F3E43C730C0E8180733C46C302EC6C342" +
			"B1382C099363CBB122AC0CABC61AB056AC03BB89F563CFB17704128145C0" +
			"093604774220611E4148584C584ED848A8201C243411DA093709038451C2" +
			"272293A84BB426BA11F9C4186232318758482C23D6128F132F107B8843C4" +
			"37241289433227B9900249B1A454D212D246D26E5223E92CA99B34481A23" +
			"93C9DA646BB20739942C202BC885E49DE4C3E433E41BE421F25B0A9D6240" +
			"71A4F853E22852CA6A4A19E510E534E5066598324155A39A52DDA8A15411" +
			"358F5A42ADA1B652AF5187A81334759A39CD8316494BA5ADA295D31A6817" +
			"68F769AFE874BA11DD951E4E97D057D2CBE947E897E803F4770C0D861583" +
			"C7886728199B18071867197718AF984CA619D38B19C754303731EB98E799" +
			"0F996F55582AB62A7C1591CA0A954A9526951B2A2F54A9AAA6AADEAA0B55" +
			"F355CB548FA95E537DAE46553353E3A909D496AB55AA9D50EB531B5367A9" +
			"3BA887AA67A86F543FA47E59FD890659C34CC34F43A451A0B15FE3BCC620" +
			"0B6319B3782C216B0DAB86758135C426B1CDD97C762ABB98FD1DBB8B3DAA" +
			"A9A13943334A3357B352F394663F07E39871F89C744E09E728A797F37E8A" +
			"DE14EF29E2291BA6344CB931655C6BAA96979658AB48AB51AB47EBBD36AE" +
			"EDA79DA6BD45BB59FB810E41C74A275C2747678FCE059DE753D953DDA70A" +
			"A7164D3D3AF5AE2EAA6BA51BA1BB4477BF6EA7EE989EBE5E809E4C6FA7DE" +
			"79BDE7FA1C7D2FFD54FD6DFAA7F5470C5806B30C2406DB0CCE183CC53571" +
			"6F3C1D2FC7DBF151435DC34043A561956197E18491B9D13CA3D5468D460F" +
			"8C69C65CE324E36DC66DC6A326062621264B4DEA4DEE9A524DB9A629A63B" +
			"4C3B4CC7CDCCCDA2CDD699359B3D31D732E79BE79BD79BDFB7605A785A2C" +
			"B6A8B6B86549B2E45AA659EEB6BC6E855A3959A558555A5DB346AD9DAD25" +
			"D6BBADBBA711A7B94E934EAB9ED667C3B0F1B6C9B6A9B719B0E5D806DBAE" +
			"B66DB67D6167621767B7C5AEC3EE93BD937DBA7D8DFD3D070D87D90EAB1D" +
			"5A1D7E73B472143A563ADE9ACE9CEE3F7DC5F496E92F6758CF10CFD833E3" +
			"B613CB29C4699D539BD347671767B97383F3888B894B82CB2E973E2E9B1B" +
			"C6DDC8BDE44A74F5715DE17AD2F59D9BB39BC2EDA8DBAFEE36EE69EE87DC" +
			"9FCC349F299E593373D0C3C843E051E5D13F0B9F95306BDFAC7E4F434F81" +
			"67B5E7232F632F9157ADD7B0B7A577AAF761EF173EF63E729FE33EE33C37" +
			"DE32DE595FCC37C0B7C8B7CB4FC36F9E5F85DF437F23FF64FF7AFFD100A7" +
			"8025016703898141815B02FBF87A7C21BF8E3F3ADB65F6B2D9ED418CA0B9" +
			"4115418F82AD82E5C1AD2168C8EC90AD21F7E798CE91CE690E85507EE8D6" +
			"D00761E6618BC37E0C2785878557863F8E7088581AD131973577D1DC4373" +
			"DF44FA449644DE9B67314F39AF2D4A352A3EAA2E6A3CDA37BA34BA3FC62E" +
			"6659CCD5589D58496C4B1C392E2AAE366E6CBEDFFCEDF387E29DE20BE37B" +
			"17982FC85D7079A1CEC2F485A716A92E122C3A96404C884E3894F041102A" +
			"A8168C25F21377258E0A79C21DC267222FD136D188D8435C2A1E4EF2482A" +
			"4D7A92EC91BC357924C533A52CE5B98427A990BC4C0D4CDD9B3A9E169A76" +
			"206D323D3ABD31839291907142AA214D93B667EA67E66676CBAC6585B2FE" +
			"C56E8BB72F1E9507C96BB390AC05592D0AB642A6E8545A28D72A07B26765" +
			"5766BFCD89CA3996AB9E2BCDEDCCB3CADB90379CEF9FFFED12C212E192B6" +
			"A5864B572D1D58E6BDAC6A39B23C7179DB0AE315052B865606AC3CB88AB6" +
			"2A6DD54FABED5797AE7EBD267A4D6B815EC1CA82C1B5016BEB0B550AE585" +
			"7DEBDCD7ED5D4F582F59DFB561FA869D1B3E15898AAE14DB1797157FD828" +
			"DC78E51B876FCABF99DC94B4A9ABC4B964CF66D266E9E6DE2D9E5B0E96AA" +
			"97E6970E6E0DD9DAB40DDF56B4EDF5F645DB2F97CD28DBBB83B643B9A3BF" +
			"3CB8BC65A7C9CECD3B3F54A454F454FA5436EED2DDB561D7F86ED1EE1B7B" +
			"BCF634ECD5DB5BBCF7FD3EC9BEDB5501554DD566D565FB49FBB3F73FAE89" +
			"AAE9F896FB6D5DAD4E6D71EDC703D203FD07230EB6D7B9D4D51DD23D5452" +
			"8FD62BEB470EC71FBEFE9DEF772D0D360D558D9CC6E223704479E4E9F709" +
			"DFF71E0D3ADA768C7BACE107D31F761D671D2F6A429AF29A469B539AFB5B" +
			"625BBA4FCC3ED1D6EADE7AFC47DB1F0F9C343C59794AF354C969DAE982D3" +
			"9367F2CF8C9D959D7D7E2EF9DC60DBA2B67BE763CEDF6A0F6FEFBA1074E1" +
			"D245FF8BE73BBC3BCE5CF2B874F2B2DBE51357B8579AAF3A5F6DEA74EA3C" +
			"FE93D34FC7BB9CBB9AAEB95C6BB9EE7ABDB57B66F7E91B9E37CEDDF4BD79" +
			"F116FFD6D59E393DDDBDF37A6FF7C5F7F5DF16DD7E7227FDCECBBBD97727" +
			"EEADBC4FBC5FF440ED41D943DD87D53F5BFEDCD8EFDC7F6AC077A0F3D1DC" +
			"47F7068583CFFE91F58F0F43058F998FCB860D86EB9E383E3939E23F72FD" +
			"E9FCA743CF64CF269E17FEA2FECBAE17162F7EF8D5EBD7CED198D1A197F2" +
			"9793BF6D7CA5FDEAC0EB19AFDBC6C2C61EBEC97833315EF456FBEDC177DC" +
			"771DEFA3DF0F4FE47C207F28FF68F9B1F553D0A7FB93199393FF040398F3" +
			"FC63332DDB000000206348524D00007A25000080830000F9FF000080E900" +
			"0075300000EA6000003A980000176F925FC546000001D84944415478DAA4" +
			"92CD6B135114C57FEFCDBC37136B4C6C26584941146369374511A48B2282" +
			"F827086A518A0B17BA70E142BBEC52DCB9A852AB280A22B870E547417465" +
			"A11BD1285204B10914A5D54E12133393CCB8C8871D4C37E6C083B3B9E7DE" +
			"F3CE116118D20B243DA26701B34D84101D4A72728C504D21180521098377" +
			"D0B8867BFB251002B4AD8B0E690A4892672FF7A593D3A74F1C328E8C6591" +
			"52F07AE1330F1E2FF2E3EBEA55DCB92B40D04D40B06DE2183AF16CF6E619" +
			"46B20308042040041456D6397EEA0678E593B8F71E86AD4119B123AC4B6C" +
			"4F503334284D6869B014280BCF50E0F403FA22A0BA7DA2429807C8ECE4C2" +
			"8B3CCF0BBF282B4D456B5E7DAB32F1E40B643280B17FA38019B920080503" +
			"0E0CA6992E0790AF3457B80D1874C0ADC2A288CC4562944933872D21BD15" +
			"6236E8A6152C0DA92D1093C884CA758D11A8EF8817671DAF345EF37D96D6" +
			"0228F920002F20DB00BBE6F2B3BF7AB7B04CBD9B80BFF2E1FEFCAE3DBBAF" +
			"EFFD689EDF373C22CB290790C48A6BD8F902DFD797E7DEBFBDF508F03BA5" +
			"89C408312075F0E8E4E1E1D1F1737DF1C49090D2A8948A9F96720B77DE3C" +
			"9D990756814A3BC67F8B0436106F3DABB5C8034A4011F8BD5991FE56B969" +
			"4D6DB0586F9D5DDFB4CAFF8B3F0300641EAD5DDBD40B2F0000000049454E" +
			"44AE426082",
	},
	"busy": &icon{
		size: "16x16",
		encoded: "" +
			"" +
			"89504e470d0a1a0a0000000d49484452000000100000001008060000001ff3ff6100000009704859" +
			"7300000b1300000b1301009a9c1800000a4f6943435050686f746f73686f70204943432070726f66" +
			"696c65000078da9d53675453e9163df7def4424b8880944b6f5215082052428b801491262a210910" +
			"4a8821a1d91551c1114545041bc8a088038e8e808c15512c0c8a0ad807e421a28e83a3888acafbe1" +
			"7ba36bd6bcf7e6cdfeb5d73ee7acf39db3cf07c0080c9648335135800ca9421e11e083c7c4c6e1e4" +
			"2e40810a2470001008b3642173fd230100f87e3c3c2b22c007be000178d30b0800c04d9bc0301c87" +
			"ff0fea42995c01808401c07491384b08801400407a8e42a600404601809d98265300a0040060cb63" +
			"62e300502d0060277fe6d300809df8997b01005b94211501a09100201365884400683b00accf568a" +
			"450058300014664bc43900d82d00304957664800b0b700c0ce100bb200080c00305188852900047b" +
			"0060c8232378008499001446f2573cf12bae10e72a00007899b23cb9243945815b082d710757572e" +
			"1e28ce49172b14366102619a402ec27999193281340fe0f3cc0000a0911511e083f3fd78ce0eaece" +
			"ce368eb60e5f2deabf06ff226262e3fee5cfab70400000e1747ed1fe2c2fb31a803b06806dfea225" +
			"ee04685e0ba075f78b66b20f40b500a0e9da57f370f87e3c3c45a190b9d9d9e5e4e4d84ac4425b61" +
			"ca577dfe67c25fc057fd6cf97e3cfcf7f5e0bee22481325d814704f8e0c2ccf44ca51ccf92098462" +
			"dce68f47fcb70bfffc1dd322c44962b9582a14e35112718e449a8cf332a52289429229c525d2ff64" +
			"e2df2cfb033edf3500b06a3e017b912da85d6303f64b27105874c0e2f70000f2bb6fc1d428080380" +
			"6883e1cf77ffef3ffd47a02500806649927100005e44242e54cab33fc708000044a0812ab0411bf4" +
			"c1182cc0061cc105dcc10bfc6036844224c4c24210420a64801c726029ac82422886cdb01d2a602f" +
			"d4401d34c051688693700e2ec255b80e3d700ffa61089ec128bc81090441c808136121da8801628a" +
			"58238e08179985f821c14804128b2420c9881451224b91354831528a542055481df23d720239875c" +
			"46ba913bc8003282fc86bc47319481b2513dd40cb543b9a8371a8446a20bd06474319a8f16a09bd0" +
			"72b41a3d8c36a1e7d0ab680fda8f3e43c730c0e8180733c46c302ec6c342b1382c099363cbb122ac" +
			"0cabc61ab056ac03bb89f563cfb17704128145c0093604774220611e4148584c584ed848a8201c24" +
			"3411da093709038451c2272293a84bb426ba11f9c4186232318758482c23d6128f132f107b8843c4" +
			"37241289433227b9900249b1a454d212d246d26e5223e92ca99b34481a2393c9da646bb20739942c" +
			"202bc885e49de4c3e433e41be421f25b0a9d624071a4f853e22852ca6a4a19e510e534e506659832" +
			"4155a39a52dda8a15411358f5a42ada1b652af5187a81334759a39cd8316494ba5ada295d31a6817" +
			"68f769afe874ba11dd951e4e97d057d2cbe947e897e803f4770c0d861583c7886728199b18071867" +
			"197718af984ca619d38b19c754303731eb98e7990f996f55582ab62a7c1591ca0a954a9526951b2a" +
			"2f54a9aaa6aadeaa0b55f355cb548fa95e537dae46553353e3a909d496ab55aa9d50eb531b5367a9" +
			"3ba887aa67a86f543fa47e59fd890659c34cc34f43a451a0b15fe3bcc6200b6319b3782c216b0dab" +
			"86758135c426b1cdd97c762abb98fd1dbb8b3daaa9a13943334a3357b352f394663f07e39871f89c" +
			"744e09e728a797f37e8ade14ef29e2291ba6344cb931655c6baa96979658ab48ab51ab47ebbd36ae" +
			"eda79da6bd45bb59fb810e41c74a275c2747678fce059de753d953dda70aa7164d3d3af5ae2eaa6b" +
			"a51ba1bb4477bf6ea7ee989ebe5e809e4c6fa7de79bde7fa1c7d2ffd54fd6dfaa7f5470c5806b30c" +
			"2406db0cce183cc535716f3c1d2fc7dbf151435dc34043a561956197e18491b9d13ca3d5468d460f" +
			"8c69c65ce324e36dc66dc6a326062621264b4dea4dee9a524db9a629a63b4c3b4cc7cdcccda2cdd6" +
			"99359b3d31d732e79be79bd79bdfb7605a785a2cb6a8b6b86549b2e45aa659eeb6bc6e855a3959a5" +
			"58555a5db346ad9dad25d6bbadbba711a7b94e934eab9ed667c3b0f1b6c9b6a9b719b0e5d806dbae" +
			"b66db67d6167621767b7c5aec3ee93bd937dba7d8dfd3d070d87d90eab1d5a1d7e73b472143a563a" +
			"de9ace9cee3f7dc5f496e92f6758cf10cfd833e3b613cb29c4699d539bd347671767b97383f3888b" +
			"894b82cb2e973e2e9b1bc6ddc8bde44a74f5715de17ad2f59d9bb39bc2eda8dbafee36ee69ee87dc" +
			"9fcc349f299e593373d0c3c843e051e5d13f0b9f95306bdfac7e4f434f8167b5e7232f632f9157ad" +
			"d7b0b7a577aaf761ef173ef63e729fe33ee33c37de32de595fcc37c0b7c8b7cb4fc36f9e5f85df43" +
			"7f23ff64ff7affd100a78025016703898141815b02fbf87a7c21bf8e3f3adb65f6b2d9ed418ca0b9" +
			"4115418f82ad82e5c1ad2168c8ec90ad21f7e798ce91ce690e85507ee8d6d00761e6618bc37e0c27" +
			"85878557863f8e7088581ad131973577d1dc4373df44fa449644de9b67314f39af2d4a352a3eaa2e" +
			"6a3cda37ba34ba3fc62e6659ccd5589d58496c4b1c392e2aae366e6cbedffcedf387e29de20be37b" +
			"17982fc85d7079a1cec2f485a716a92e122c3a96404c884e3894f041102aa8168c25f21377258e0a" +
			"79c21dc267222fd136d188d8435c2a1e4ef2482a4d7a92ec91bc357924c533a52ce5b98427a990bc" +
			"4c0d4cdd9b3a9e169a76206d323d3abd31839291907142aa214d93b667ea67e66676cbac6585b2fe" +
			"c56e8bb72f1e9507c96bb390ac05592d0ab642a6e8545a28d72a07b267655766bfcd89ca3996ab9e" +
			"2bcdedccb3cadb90379cef9fffed12c212e192b6a5864b572d1d58e6bdac6a39b23c7179db0ae315" +
			"052b865606ac3cb88ab62a6dd54fabed5797ae7ebd267a4d6b815ec1ca82c1b5016beb0b550ae585" +
			"7debdcd7ed5d4f582f59dfb561fa869d1b3e15898aae14db1797157fd828dc78e51b876fcabf99dc" +
			"94b4a9abc4b964cf66d266e9e6de2d9e5b0e96aa97e6970e6e0dd9dab40ddf56b4edf5f645db2f97" +
			"cd28dbbb83b643b9a3bf3cb8bc65a7c9cecd3b3f54a454f454fa5436eed2ddb561d7f86ed1ee1b7b" +
			"bcf634ecd5db5bbcf7fd3ec9bedb5501554dd566d565fb49fbb3f73fae89aae9f896fb6d5dad4e6d" +
			"71edc703d203fd07230eb6d7b9d4d51dd23d54528fd62beb470ec71fbefe9def772d0d360d558d9c" +
			"c6e223704479e4e9f709dff71e0d3ada768c7bace107d31f761d671d2f6a429af29a469b539afb5b" +
			"625bba4fcc3ed1d6eade7afc47db1f0f9c343c59794af354c969dae982d39367f2cf8c9d959d7d7e" +
			"2ef9dc60dba2b67be763cedf6a0f6fefba1074e1d245ff8be73bbc3bce5cf2b874f2b2dbe51357b8" +
			"579aaf3a5f6dea74ea3cfe93d34fc7bb9cbb9aaeb95c6bb9ee7abdb57b66f7e91b9e37ceddf4bd79" +
			"f116ffd6d59e393dddbdf37a6ff7c5f7f5df16dd7e7227fdcecbbbd97727eeadbc4fbc5ff440ed41" +
			"d943dd87d53f5bfedcd8efdc7f6ac077a0f3d1dc47f7068583cffe91f58f0f43058f998fcb860d86" +
			"eb9e383e3939e23f72fde9fca743cf64cf269e17fea2fecbae17162f7ef8d5ebd7ced198d1a197f2" +
			"9793bf6d7ca5fdeac0eb19afdbc6c2c61ebec97833315ef456fbedc177dc771defa3df0f4fe47c20" +
			"7f28ff68f9b1f553d0a7fb93199393ff040398f3fc63332ddb000000206348524d00007a25000080" +
			"830000f9ff000080e9000075300000ea6000003a980000176f925fc546000001bf4944415478daa4" +
			"923fafd25018c67fe7b4879616ca50c2cce668206570727323ecf70b38b898e0a08eb2193747638c" +
			"9b31b894c5e4121366081073073e420706a2b4b1bd2d75b885102f2cf2266ff224e79cf7bccf1f91" +
			"e7399794e4c2ba7880be07428803f43cef9194f2b510e22120f33cffb9dbeddecd66b31f400eb0a7" +
			"2e0ee06e80ec743a2f5dd77dd3ebf5b476bb8da6692c160b7cdf270882b7d3e9f415b03b3540b45a" +
			"ad27a6697e1f0c06388e431445e4798e6559645946bfdf278ee3abf97cfe252f1eeac774745d7f61" +
			"9a269bcd86388e49920480300c012897cb6459f61cf80624ff8aa8a494ed6ab5ca6834220802a494" +
			"28a558afd7f8be4fad564308d102d43d110b2c6cdba652a9b05aad50eaee5e9aa6944a256cdbde6b" +
			"a59fb45129756359164a29745d47d3b443ebba4e7176732e07a9a6691f0cc3a05eafa39422cb32b2" +
			"2c430841a3d1c0300c0cc3f80ca4a728dc4e2693eb66b3f93e499267aeeb4ad3340188e398ed764b" +
			"14451fc7e3f157e0f6109a631b8132e076bbddc79ee73d751ce701a08561b85a2e979f86c3e135b0" +
			"06a2bd8df782049840b568a3f828017e03bf803fe78274d8aaa0a68e28a6c5dae9d928ff6ffd1d00" +
			"3fcbb3e848bbf45d0000000049454e44ae426082",
	},

	"chat": &icon{
		size: "16x16",
		encoded: "" +
			"" +
			"89504e470d0a1a0a0000000d49484452000000100000001008060000001ff3ff6100000009704859" +
			"7300000b1300000b1301009a9c1800000a4f6943435050686f746f73686f70204943432070726f66" +
			"696c65000078da9d53675453e9163df7def4424b8880944b6f5215082052428b801491262a210910" +
			"4a8821a1d91551c1114545041bc8a088038e8e808c15512c0c8a0ad807e421a28e83a3888acafbe1" +
			"7ba36bd6bcf7e6cdfeb5d73ee7acf39db3cf07c0080c9648335135800ca9421e11e083c7c4c6e1e4" +
			"2e40810a2470001008b3642173fd230100f87e3c3c2b22c007be000178d30b0800c04d9bc0301c87" +
			"ff0fea42995c01808401c07491384b08801400407a8e42a600404601809d98265300a0040060cb63" +
			"62e300502d0060277fe6d300809df8997b01005b94211501a09100201365884400683b00accf568a" +
			"450058300014664bc43900d82d00304957664800b0b700c0ce100bb200080c00305188852900047b" +
			"0060c8232378008499001446f2573cf12bae10e72a00007899b23cb9243945815b082d710757572e" +
			"1e28ce49172b14366102619a402ec27999193281340fe0f3cc0000a0911511e083f3fd78ce0eaece" +
			"ce368eb60e5f2deabf06ff226262e3fee5cfab70400000e1747ed1fe2c2fb31a803b06806dfea225" +
			"ee04685e0ba075f78b66b20f40b500a0e9da57f370f87e3c3c45a190b9d9d9e5e4e4d84ac4425b61" +
			"ca577dfe67c25fc057fd6cf97e3cfcf7f5e0bee22481325d814704f8e0c2ccf44ca51ccf92098462" +
			"dce68f47fcb70bfffc1dd322c44962b9582a14e35112718e449a8cf332a52289429229c525d2ff64" +
			"e2df2cfb033edf3500b06a3e017b912da85d6303f64b27105874c0e2f70000f2bb6fc1d428080380" +
			"6883e1cf77ffef3ffd47a02500806649927100005e44242e54cab33fc708000044a0812ab0411bf4" +
			"c1182cc0061cc105dcc10bfc6036844224c4c24210420a64801c726029ac82422886cdb01d2a602f" +
			"d4401d34c051688693700e2ec255b80e3d700ffa61089ec128bc81090441c808136121da8801628a" +
			"58238e08179985f821c14804128b2420c9881451224b91354831528a542055481df23d720239875c" +
			"46ba913bc8003282fc86bc47319481b2513dd40cb543b9a8371a8446a20bd06474319a8f16a09bd0" +
			"72b41a3d8c36a1e7d0ab680fda8f3e43c730c0e8180733c46c302ec6c342b1382c099363cbb122ac" +
			"0cabc61ab056ac03bb89f563cfb17704128145c0093604774220611e4148584c584ed848a8201c24" +
			"3411da093709038451c2272293a84bb426ba11f9c4186232318758482c23d6128f132f107b8843c4" +
			"37241289433227b9900249b1a454d212d246d26e5223e92ca99b34481a2393c9da646bb20739942c" +
			"202bc885e49de4c3e433e41be421f25b0a9d624071a4f853e22852ca6a4a19e510e534e506659832" +
			"4155a39a52dda8a15411358f5a42ada1b652af5187a81334759a39cd8316494ba5ada295d31a6817" +
			"68f769afe874ba11dd951e4e97d057d2cbe947e897e803f4770c0d861583c7886728199b18071867" +
			"197718af984ca619d38b19c754303731eb98e7990f996f55582ab62a7c1591ca0a954a9526951b2a" +
			"2f54a9aaa6aadeaa0b55f355cb548fa95e537dae46553353e3a909d496ab55aa9d50eb531b5367a9" +
			"3ba887aa67a86f543fa47e59fd890659c34cc34f43a451a0b15fe3bcc6200b6319b3782c216b0dab" +
			"86758135c426b1cdd97c762abb98fd1dbb8b3daaa9a13943334a3357b352f394663f07e39871f89c" +
			"744e09e728a797f37e8ade14ef29e2291ba6344cb931655c6baa96979658ab48ab51ab47ebbd36ae" +
			"eda79da6bd45bb59fb810e41c74a275c2747678fce059de753d953dda70aa7164d3d3af5ae2eaa6b" +
			"a51ba1bb4477bf6ea7ee989ebe5e809e4c6fa7de79bde7fa1c7d2ffd54fd6dfaa7f5470c5806b30c" +
			"2406db0cce183cc535716f3c1d2fc7dbf151435dc34043a561956197e18491b9d13ca3d5468d460f" +
			"8c69c65ce324e36dc66dc6a326062621264b4dea4dee9a524db9a629a63b4c3b4cc7cdcccda2cdd6" +
			"99359b3d31d732e79be79bd79bdfb7605a785a2cb6a8b6b86549b2e45aa659eeb6bc6e855a3959a5" +
			"58555a5db346ad9dad25d6bbadbba711a7b94e934eab9ed667c3b0f1b6c9b6a9b719b0e5d806dbae" +
			"b66db67d6167621767b7c5aec3ee93bd937dba7d8dfd3d070d87d90eab1d5a1d7e73b472143a563a" +
			"de9ace9cee3f7dc5f496e92f6758cf10cfd833e3b613cb29c4699d539bd347671767b97383f3888b" +
			"894b82cb2e973e2e9b1bc6ddc8bde44a74f5715de17ad2f59d9bb39bc2eda8dbafee36ee69ee87dc" +
			"9fcc349f299e593373d0c3c843e051e5d13f0b9f95306bdfac7e4f434f8167b5e7232f632f9157ad" +
			"d7b0b7a577aaf761ef173ef63e729fe33ee33c37de32de595fcc37c0b7c8b7cb4fc36f9e5f85df43" +
			"7f23ff64ff7affd100a78025016703898141815b02fbf87a7c21bf8e3f3adb65f6b2d9ed418ca0b9" +
			"4115418f82ad82e5c1ad2168c8ec90ad21f7e798ce91ce690e85507ee8d6d00761e6618bc37e0c27" +
			"85878557863f8e7088581ad131973577d1dc4373df44fa449644de9b67314f39af2d4a352a3eaa2e" +
			"6a3cda37ba34ba3fc62e6659ccd5589d58496c4b1c392e2aae366e6cbedffcedf387e29de20be37b" +
			"17982fc85d7079a1cec2f485a716a92e122c3a96404c884e3894f041102aa8168c25f21377258e0a" +
			"79c21dc267222fd136d188d8435c2a1e4ef2482a4d7a92ec91bc357924c533a52ce5b98427a990bc" +
			"4c0d4cdd9b3a9e169a76206d323d3abd31839291907142aa214d93b667ea67e66676cbac6585b2fe" +
			"c56e8bb72f1e9507c96bb390ac05592d0ab642a6e8545a28d72a07b267655766bfcd89ca3996ab9e" +
			"2bcdedccb3cadb90379cef9fffed12c212e192b6a5864b572d1d58e6bdac6a39b23c7179db0ae315" +
			"052b865606ac3cb88ab62a6dd54fabed5797ae7ebd267a4d6b815ec1ca82c1b5016beb0b550ae585" +
			"7debdcd7ed5d4f582f59dfb561fa869d1b3e15898aae14db1797157fd828dc78e51b876fcabf99dc" +
			"94b4a9abc4b964cf66d266e9e6de2d9e5b0e96aa97e6970e6e0dd9dab40ddf56b4edf5f645db2f97" +
			"cd28dbbb83b643b9a3bf3cb8bc65a7c9cecd3b3f54a454f454fa5436eed2ddb561d7f86ed1ee1b7b" +
			"bcf634ecd5db5bbcf7fd3ec9bedb5501554dd566d565fb49fbb3f73fae89aae9f896fb6d5dad4e6d" +
			"71edc703d203fd07230eb6d7b9d4d51dd23d54528fd62beb470ec71fbefe9def772d0d360d558d9c" +
			"c6e223704479e4e9f709dff71e0d3ada768c7bace107d31f761d671d2f6a429af29a469b539afb5b" +
			"625bba4fcc3ed1d6eade7afc47db1f0f9c343c59794af354c969dae982d39367f2cf8c9d959d7d7e" +
			"2ef9dc60dba2b67be763cedf6a0f6fefba1074e1d245ff8be73bbc3bce5cf2b874f2b2dbe51357b8" +
			"579aaf3a5f6dea74ea3cfe93d34fc7bb9cbb9aaeb95c6bb9ee7abdb57b66f7e91b9e37ceddf4bd79" +
			"f116ffd6d59e393dddbdf37a6ff7c5f7f5df16dd7e7227fdcecbbbd97727eeadbc4fbc5ff440ed41" +
			"d943dd87d53f5bfedcd8efdc7f6ac077a0f3d1dc47f7068583cffe91f58f0f43058f998fcb860d86" +
			"eb9e383e3939e23f72fde9fca743cf64cf269e17fea2fecbae17162f7ef8d5ebd7ced198d1a197f2" +
			"9793bf6d7ca5fdeac0eb19afdbc6c2c61ebec97833315ef456fbedc177dc771defa3df0f4fe47c20" +
			"7f28ff68f9b1f553d0a7fb93199393ff040398f3fc63332ddb000000206348524d00007a25000080" +
			"830000f9ff000080e9000075300000ea6000003a980000176f925fc546000001d94944415478daa4" +
			"92cb6b135114c67fe7ce2b33b676d052525f1175f0b1b14a2d288ab811ff0041900a1604175270d1" +
			"85ba2caec49d0b05a3225510ff00514604dd88f8404b11a92e6a1aa96829a68963db8c735d380909" +
			"a61b73e0c2b739df3ddf43b4d6b4338a36a76d02b30644a40e87e8df6bc10541ed04ad347a3c465f" +
			"bec9eb278006a849973af84ba04eb1e79cdf911d1d3871c4080ef5214af8f4ec1dafee3c6676ae70" +
			"29cfcbf340d28a4006e93bbc12efe1c9fc45b2db732801ad410bfc98feceb5632394a91c1fe3ed3d" +
			"9d2e367a6066b0467cb2d8bf32d83858dac5160f5b3b98558755acc1c13c0b58ad4cb40c64772f5b" +
			"981e2e5279b488517191c8217a1a333558602d01266a572381d96ca8966e7278ac677254f39b8804" +
			"3088f1e8a587cd0861d35e538c86e14f2871113a317030b1b1713071887151acc090ae8996310271" +
			"b987ebf3dd5f0e6c585cc29b4c30a9920009096620ccb80516e6acdb14895b1154c766c270636ed3" +
			"152b08cfec08f6a9ae681da28552e62b45f73d9fbf4dddc88f3fb80f54eba5698c117081d543fd47" +
			"0feedf3670daeff0b72a5146e967e9c38b8f6f6e5d7d7e37046681a816e33f4502324067fa9cf4a3" +
			"25a00ccc030bcb15a97e552acd6a9018a767c7cb56f97fe7cf006831acf012eb8d28000000004945" +
			"4e44ae426082",
	},

	"extended-away": &icon{
		size: "16x16",
		encoded: "" +
			"" +
			"89504e470d0a1a0a0000000d49484452000000100000001008060000001ff3ff6100000009704859" +
			"7300000b1300000b1301009a9c1800000a4f6943435050686f746f73686f70204943432070726f66" +
			"696c65000078da9d53675453e9163df7def4424b8880944b6f5215082052428b801491262a210910" +
			"4a8821a1d91551c1114545041bc8a088038e8e808c15512c0c8a0ad807e421a28e83a3888acafbe1" +
			"7ba36bd6bcf7e6cdfeb5d73ee7acf39db3cf07c0080c9648335135800ca9421e11e083c7c4c6e1e4" +
			"2e40810a2470001008b3642173fd230100f87e3c3c2b22c007be000178d30b0800c04d9bc0301c87" +
			"ff0fea42995c01808401c07491384b08801400407a8e42a600404601809d98265300a0040060cb63" +
			"62e300502d0060277fe6d300809df8997b01005b94211501a09100201365884400683b00accf568a" +
			"450058300014664bc43900d82d00304957664800b0b700c0ce100bb200080c00305188852900047b" +
			"0060c8232378008499001446f2573cf12bae10e72a00007899b23cb9243945815b082d710757572e" +
			"1e28ce49172b14366102619a402ec27999193281340fe0f3cc0000a0911511e083f3fd78ce0eaece" +
			"ce368eb60e5f2deabf06ff226262e3fee5cfab70400000e1747ed1fe2c2fb31a803b06806dfea225" +
			"ee04685e0ba075f78b66b20f40b500a0e9da57f370f87e3c3c45a190b9d9d9e5e4e4d84ac4425b61" +
			"ca577dfe67c25fc057fd6cf97e3cfcf7f5e0bee22481325d814704f8e0c2ccf44ca51ccf92098462" +
			"dce68f47fcb70bfffc1dd322c44962b9582a14e35112718e449a8cf332a52289429229c525d2ff64" +
			"e2df2cfb033edf3500b06a3e017b912da85d6303f64b27105874c0e2f70000f2bb6fc1d428080380" +
			"6883e1cf77ffef3ffd47a02500806649927100005e44242e54cab33fc708000044a0812ab0411bf4" +
			"c1182cc0061cc105dcc10bfc6036844224c4c24210420a64801c726029ac82422886cdb01d2a602f" +
			"d4401d34c051688693700e2ec255b80e3d700ffa61089ec128bc81090441c808136121da8801628a" +
			"58238e08179985f821c14804128b2420c9881451224b91354831528a542055481df23d720239875c" +
			"46ba913bc8003282fc86bc47319481b2513dd40cb543b9a8371a8446a20bd06474319a8f16a09bd0" +
			"72b41a3d8c36a1e7d0ab680fda8f3e43c730c0e8180733c46c302ec6c342b1382c099363cbb122ac" +
			"0cabc61ab056ac03bb89f563cfb17704128145c0093604774220611e4148584c584ed848a8201c24" +
			"3411da093709038451c2272293a84bb426ba11f9c4186232318758482c23d6128f132f107b8843c4" +
			"37241289433227b9900249b1a454d212d246d26e5223e92ca99b34481a2393c9da646bb20739942c" +
			"202bc885e49de4c3e433e41be421f25b0a9d624071a4f853e22852ca6a4a19e510e534e506659832" +
			"4155a39a52dda8a15411358f5a42ada1b652af5187a81334759a39cd8316494ba5ada295d31a6817" +
			"68f769afe874ba11dd951e4e97d057d2cbe947e897e803f4770c0d861583c7886728199b18071867" +
			"197718af984ca619d38b19c754303731eb98e7990f996f55582ab62a7c1591ca0a954a9526951b2a" +
			"2f54a9aaa6aadeaa0b55f355cb548fa95e537dae46553353e3a909d496ab55aa9d50eb531b5367a9" +
			"3ba887aa67a86f543fa47e59fd890659c34cc34f43a451a0b15fe3bcc6200b6319b3782c216b0dab" +
			"86758135c426b1cdd97c762abb98fd1dbb8b3daaa9a13943334a3357b352f394663f07e39871f89c" +
			"744e09e728a797f37e8ade14ef29e2291ba6344cb931655c6baa96979658ab48ab51ab47ebbd36ae" +
			"eda79da6bd45bb59fb810e41c74a275c2747678fce059de753d953dda70aa7164d3d3af5ae2eaa6b" +
			"a51ba1bb4477bf6ea7ee989ebe5e809e4c6fa7de79bde7fa1c7d2ffd54fd6dfaa7f5470c5806b30c" +
			"2406db0cce183cc535716f3c1d2fc7dbf151435dc34043a561956197e18491b9d13ca3d5468d460f" +
			"8c69c65ce324e36dc66dc6a326062621264b4dea4dee9a524db9a629a63b4c3b4cc7cdcccda2cdd6" +
			"99359b3d31d732e79be79bd79bdfb7605a785a2cb6a8b6b86549b2e45aa659eeb6bc6e855a3959a5" +
			"58555a5db346ad9dad25d6bbadbba711a7b94e934eab9ed667c3b0f1b6c9b6a9b719b0e5d806dbae" +
			"b66db67d6167621767b7c5aec3ee93bd937dba7d8dfd3d070d87d90eab1d5a1d7e73b472143a563a" +
			"de9ace9cee3f7dc5f496e92f6758cf10cfd833e3b613cb29c4699d539bd347671767b97383f3888b" +
			"894b82cb2e973e2e9b1bc6ddc8bde44a74f5715de17ad2f59d9bb39bc2eda8dbafee36ee69ee87dc" +
			"9fcc349f299e593373d0c3c843e051e5d13f0b9f95306bdfac7e4f434f8167b5e7232f632f9157ad" +
			"d7b0b7a577aaf761ef173ef63e729fe33ee33c37de32de595fcc37c0b7c8b7cb4fc36f9e5f85df43" +
			"7f23ff64ff7affd100a78025016703898141815b02fbf87a7c21bf8e3f3adb65f6b2d9ed418ca0b9" +
			"4115418f82ad82e5c1ad2168c8ec90ad21f7e798ce91ce690e85507ee8d6d00761e6618bc37e0c27" +
			"85878557863f8e7088581ad131973577d1dc4373df44fa449644de9b67314f39af2d4a352a3eaa2e" +
			"6a3cda37ba34ba3fc62e6659ccd5589d58496c4b1c392e2aae366e6cbedffcedf387e29de20be37b" +
			"17982fc85d7079a1cec2f485a716a92e122c3a96404c884e3894f041102aa8168c25f21377258e0a" +
			"79c21dc267222fd136d188d8435c2a1e4ef2482a4d7a92ec91bc357924c533a52ce5b98427a990bc" +
			"4c0d4cdd9b3a9e169a76206d323d3abd31839291907142aa214d93b667ea67e66676cbac6585b2fe" +
			"c56e8bb72f1e9507c96bb390ac05592d0ab642a6e8545a28d72a07b267655766bfcd89ca3996ab9e" +
			"2bcdedccb3cadb90379cef9fffed12c212e192b6a5864b572d1d58e6bdac6a39b23c7179db0ae315" +
			"052b865606ac3cb88ab62a6dd54fabed5797ae7ebd267a4d6b815ec1ca82c1b5016beb0b550ae585" +
			"7debdcd7ed5d4f582f59dfb561fa869d1b3e15898aae14db1797157fd828dc78e51b876fcabf99dc" +
			"94b4a9abc4b964cf66d266e9e6de2d9e5b0e96aa97e6970e6e0dd9dab40ddf56b4edf5f645db2f97" +
			"cd28dbbb83b643b9a3bf3cb8bc65a7c9cecd3b3f54a454f454fa5436eed2ddb561d7f86ed1ee1b7b" +
			"bcf634ecd5db5bbcf7fd3ec9bedb5501554dd566d565fb49fbb3f73fae89aae9f896fb6d5dad4e6d" +
			"71edc703d203fd07230eb6d7b9d4d51dd23d54528fd62beb470ec71fbefe9def772d0d360d558d9c" +
			"c6e223704479e4e9f709dff71e0d3ada768c7bace107d31f761d671d2f6a429af29a469b539afb5b" +
			"625bba4fcc3ed1d6eade7afc47db1f0f9c343c59794af354c969dae982d39367f2cf8c9d959d7d7e" +
			"2ef9dc60dba2b67be763cedf6a0f6fefba1074e1d245ff8be73bbc3bce5cf2b874f2b2dbe51357b8" +
			"579aaf3a5f6dea74ea3cfe93d34fc7bb9cbb9aaeb95c6bb9ee7abdb57b66f7e91b9e37ceddf4bd79" +
			"f116ffd6d59e393dddbdf37a6ff7c5f7f5df16dd7e7227fdcecbbbd97727eeadbc4fbc5ff440ed41" +
			"d943dd87d53f5bfedcd8efdc7f6ac077a0f3d1dc47f7068583cffe91f58f0f43058f998fcb860d86" +
			"eb9e383e3939e23f72fde9fca743cf64cf269e17fea2fecbae17162f7ef8d5ebd7ced198d1a197f2" +
			"9793bf6d7ca5fdeac0eb19afdbc6c2c61ebec97833315ef456fbedc177dc771defa3df0f4fe47c20" +
			"7f28ff68f9b1f553d0a7fb93199393ff040398f3fc63332ddb000000206348524d00007a25000080" +
			"830000f9ff000080e9000075300000ea6000003a980000176f925fc546000001cc4944415478daa4" +
			"923f68535114c67fe7be77ef6b5323114553c456445b6c155151b008c5a520b8174405412c28a883" +
			"4375ec24e2d6a14869b59b8893a0042a2282e824b6445275951643a17f525fe3cb33d7c19b9060b2" +
			"980f0e9ce57ce77ce7fbc45a4b2b50b4889609fc4a2322d5f6ea594e699fbb4a3882a0ca96f938e6" +
			"c1c397bc062c4045ba549bbf04eada394653db1263174e5ff2f61c3e838862e9f35b5ebd9b613ebf" +
			"7e7fe2057780722302b93cc4505f82ccc8cd49125dfd6e9960ad255afecef4bd613e15393f95e189" +
			"7583b53ff0db0cb74f2421f037110d62408c4519303ae2640a028f5b806ef444ed298e1d48c3efdc" +
			"0d58cda0cc06ca6c228537c47317d9df099ec7d15a02bfeea18204bbc0a441fd1a831540408ae0ef" +
			"04b3012a573f5767a3a7259bd7e06d01dadc1e0304e077405e836fc836cb415c88d2930b3ffb094b" +
			"fb20040ac01a104254decb97f0106179f70c103792509a7ebe34dbdddd355eccf55c1fe839a83a77" +
			"ac22023f56927c5d6c676e313f35f12cfb14285543536b23d00e6cbf327c7c7070a06f24b5b5a357" +
			"c05b2b840b1f3e7e7b34fef8fd2cb00c84151bff0992539f7415b8459113b40e149b05a97a9593a6" +
			"6b24c6eeecb86994ff177f0600b533a79d8fd40a510000000049454e44ae426082",
	},

	"invisible": &icon{
		size: "16x16",
		encoded: "" +
			"" +
			"89504e470d0a1a0a0000000d49484452000000100000001008060000001ff3ff6100000009704859" +
			"7300000b1300000b1301009a9c1800000a4f6943435050686f746f73686f70204943432070726f66" +
			"696c65000078da9d53675453e9163df7def4424b8880944b6f5215082052428b801491262a210910" +
			"4a8821a1d91551c1114545041bc8a088038e8e808c15512c0c8a0ad807e421a28e83a3888acafbe1" +
			"7ba36bd6bcf7e6cdfeb5d73ee7acf39db3cf07c0080c9648335135800ca9421e11e083c7c4c6e1e4" +
			"2e40810a2470001008b3642173fd230100f87e3c3c2b22c007be000178d30b0800c04d9bc0301c87" +
			"ff0fea42995c01808401c07491384b08801400407a8e42a600404601809d98265300a0040060cb63" +
			"62e300502d0060277fe6d300809df8997b01005b94211501a09100201365884400683b00accf568a" +
			"450058300014664bc43900d82d00304957664800b0b700c0ce100bb200080c00305188852900047b" +
			"0060c8232378008499001446f2573cf12bae10e72a00007899b23cb9243945815b082d710757572e" +
			"1e28ce49172b14366102619a402ec27999193281340fe0f3cc0000a0911511e083f3fd78ce0eaece" +
			"ce368eb60e5f2deabf06ff226262e3fee5cfab70400000e1747ed1fe2c2fb31a803b06806dfea225" +
			"ee04685e0ba075f78b66b20f40b500a0e9da57f370f87e3c3c45a190b9d9d9e5e4e4d84ac4425b61" +
			"ca577dfe67c25fc057fd6cf97e3cfcf7f5e0bee22481325d814704f8e0c2ccf44ca51ccf92098462" +
			"dce68f47fcb70bfffc1dd322c44962b9582a14e35112718e449a8cf332a52289429229c525d2ff64" +
			"e2df2cfb033edf3500b06a3e017b912da85d6303f64b27105874c0e2f70000f2bb6fc1d428080380" +
			"6883e1cf77ffef3ffd47a02500806649927100005e44242e54cab33fc708000044a0812ab0411bf4" +
			"c1182cc0061cc105dcc10bfc6036844224c4c24210420a64801c726029ac82422886cdb01d2a602f" +
			"d4401d34c051688693700e2ec255b80e3d700ffa61089ec128bc81090441c808136121da8801628a" +
			"58238e08179985f821c14804128b2420c9881451224b91354831528a542055481df23d720239875c" +
			"46ba913bc8003282fc86bc47319481b2513dd40cb543b9a8371a8446a20bd06474319a8f16a09bd0" +
			"72b41a3d8c36a1e7d0ab680fda8f3e43c730c0e8180733c46c302ec6c342b1382c099363cbb122ac" +
			"0cabc61ab056ac03bb89f563cfb17704128145c0093604774220611e4148584c584ed848a8201c24" +
			"3411da093709038451c2272293a84bb426ba11f9c4186232318758482c23d6128f132f107b8843c4" +
			"37241289433227b9900249b1a454d212d246d26e5223e92ca99b34481a2393c9da646bb20739942c" +
			"202bc885e49de4c3e433e41be421f25b0a9d624071a4f853e22852ca6a4a19e510e534e506659832" +
			"4155a39a52dda8a15411358f5a42ada1b652af5187a81334759a39cd8316494ba5ada295d31a6817" +
			"68f769afe874ba11dd951e4e97d057d2cbe947e897e803f4770c0d861583c7886728199b18071867" +
			"197718af984ca619d38b19c754303731eb98e7990f996f55582ab62a7c1591ca0a954a9526951b2a" +
			"2f54a9aaa6aadeaa0b55f355cb548fa95e537dae46553353e3a909d496ab55aa9d50eb531b5367a9" +
			"3ba887aa67a86f543fa47e59fd890659c34cc34f43a451a0b15fe3bcc6200b6319b3782c216b0dab" +
			"86758135c426b1cdd97c762abb98fd1dbb8b3daaa9a13943334a3357b352f394663f07e39871f89c" +
			"744e09e728a797f37e8ade14ef29e2291ba6344cb931655c6baa96979658ab48ab51ab47ebbd36ae" +
			"eda79da6bd45bb59fb810e41c74a275c2747678fce059de753d953dda70aa7164d3d3af5ae2eaa6b" +
			"a51ba1bb4477bf6ea7ee989ebe5e809e4c6fa7de79bde7fa1c7d2ffd54fd6dfaa7f5470c5806b30c" +
			"2406db0cce183cc535716f3c1d2fc7dbf151435dc34043a561956197e18491b9d13ca3d5468d460f" +
			"8c69c65ce324e36dc66dc6a326062621264b4dea4dee9a524db9a629a63b4c3b4cc7cdcccda2cdd6" +
			"99359b3d31d732e79be79bd79bdfb7605a785a2cb6a8b6b86549b2e45aa659eeb6bc6e855a3959a5" +
			"58555a5db346ad9dad25d6bbadbba711a7b94e934eab9ed667c3b0f1b6c9b6a9b719b0e5d806dbae" +
			"b66db67d6167621767b7c5aec3ee93bd937dba7d8dfd3d070d87d90eab1d5a1d7e73b472143a563a" +
			"de9ace9cee3f7dc5f496e92f6758cf10cfd833e3b613cb29c4699d539bd347671767b97383f3888b" +
			"894b82cb2e973e2e9b1bc6ddc8bde44a74f5715de17ad2f59d9bb39bc2eda8dbafee36ee69ee87dc" +
			"9fcc349f299e593373d0c3c843e051e5d13f0b9f95306bdfac7e4f434f8167b5e7232f632f9157ad" +
			"d7b0b7a577aaf761ef173ef63e729fe33ee33c37de32de595fcc37c0b7c8b7cb4fc36f9e5f85df43" +
			"7f23ff64ff7affd100a78025016703898141815b02fbf87a7c21bf8e3f3adb65f6b2d9ed418ca0b9" +
			"4115418f82ad82e5c1ad2168c8ec90ad21f7e798ce91ce690e85507ee8d6d00761e6618bc37e0c27" +
			"85878557863f8e7088581ad131973577d1dc4373df44fa449644de9b67314f39af2d4a352a3eaa2e" +
			"6a3cda37ba34ba3fc62e6659ccd5589d58496c4b1c392e2aae366e6cbedffcedf387e29de20be37b" +
			"17982fc85d7079a1cec2f485a716a92e122c3a96404c884e3894f041102aa8168c25f21377258e0a" +
			"79c21dc267222fd136d188d8435c2a1e4ef2482a4d7a92ec91bc357924c533a52ce5b98427a990bc" +
			"4c0d4cdd9b3a9e169a76206d323d3abd31839291907142aa214d93b667ea67e66676cbac6585b2fe" +
			"c56e8bb72f1e9507c96bb390ac05592d0ab642a6e8545a28d72a07b267655766bfcd89ca3996ab9e" +
			"2bcdedccb3cadb90379cef9fffed12c212e192b6a5864b572d1d58e6bdac6a39b23c7179db0ae315" +
			"052b865606ac3cb88ab62a6dd54fabed5797ae7ebd267a4d6b815ec1ca82c1b5016beb0b550ae585" +
			"7debdcd7ed5d4f582f59dfb561fa869d1b3e15898aae14db1797157fd828dc78e51b876fcabf99dc" +
			"94b4a9abc4b964cf66d266e9e6de2d9e5b0e96aa97e6970e6e0dd9dab40ddf56b4edf5f645db2f97" +
			"cd28dbbb83b643b9a3bf3cb8bc65a7c9cecd3b3f54a454f454fa5436eed2ddb561d7f86ed1ee1b7b" +
			"bcf634ecd5db5bbcf7fd3ec9bedb5501554dd566d565fb49fbb3f73fae89aae9f896fb6d5dad4e6d" +
			"71edc703d203fd07230eb6d7b9d4d51dd23d54528fd62beb470ec71fbefe9def772d0d360d558d9c" +
			"c6e223704479e4e9f709dff71e0d3ada768c7bace107d31f761d671d2f6a429af29a469b539afb5b" +
			"625bba4fcc3ed1d6eade7afc47db1f0f9c343c59794af354c969dae982d39367f2cf8c9d959d7d7e" +
			"2ef9dc60dba2b67be763cedf6a0f6fefba1074e1d245ff8be73bbc3bce5cf2b874f2b2dbe51357b8" +
			"579aaf3a5f6dea74ea3cfe93d34fc7bb9cbb9aaeb95c6bb9ee7abdb57b66f7e91b9e37ceddf4bd79" +
			"f116ffd6d59e393dddbdf37a6ff7c5f7f5df16dd7e7227fdcecbbbd97727eeadbc4fbc5ff440ed41" +
			"d943dd87d53f5bfedcd8efdc7f6ac077a0f3d1dc47f7068583cffe91f58f0f43058f998fcb860d86" +
			"eb9e383e3939e23f72fde9fca743cf64cf269e17fea2fecbae17162f7ef8d5ebd7ced198d1a197f2" +
			"9793bf6d7ca5fdeac0eb19afdbc6c2c61ebec97833315ef456fbedc177dc771defa3df0f4fe47c20" +
			"7f28ff68f9b1f553d0a7fb93199393ff040398f3fc63332ddb000000206348524d00007a25000080" +
			"830000f9ff000080e9000075300000ea6000003a980000176f925fc546000001bf4944415478daa4" +
			"92b1cb526118c57feffd7cef2d34e1125750179d1a1ca2b6706813c5bfc0fe81d690866a6c11a2ad" +
			"3142da22274144f8205cdc9cf2035b4444c4e58260a0f7ead5a721bd08e9920fbc7096e7bce739e7" +
			"2811e19a31b872ae26881c81522a84a552e999d6fa1df058296588c8cf20083eb6dbed1f80001c4f" +
			"5721f84b6094cbe537b66dbf2f168b37b95c0ea514c3e1906eb7cb6c36fbd06ab5de02fb7304aa50" +
			"28146cdbee54ab5552a954a84a44582c16d46a35168bc58b4ea7f34d0e8ba71e444cd37c9d4c26b1" +
			"2c0bad35a669629a6688d3e9345aeb57803e67a2360ce3692693613a9db25eaf4302cff3188d4664" +
			"b3590cc378724a103955a094528ee390482410113ccf434410111cc761b55a1dcf8a9c8d516b7db7" +
			"dfef8946a35896152ab02c8b582c8688609ae6dda51e04dbedf6b3ebba6c361b8220c0f7fd10ef76" +
			"3b5cd74544be02c139826db3d9bc9d4c269f7abdde7e369be1791ebeef339fcf190c068cc7e32f8d" +
			"46e33bb00d4b731a23701f7858a9549ee7f3f997f178fc9152ea66b95cfeeaf7fbf57abd7e0bb8c0" +
			"ea18e33f4502ee010f0ecf3a7cb4017e034bc0bb54a450d5c1657de27670901d5cacf2ffce9f0100" +
			"b95fd29880cb2c140000000049454e44ae426082",
	},

	"offline": &icon{
		size: "16x16",
		encoded: "" +
			"" +
			"89504e470d0a1a0a0000000d49484452000000100000001008060000001ff3ff6100000009704859" +
			"7300000b1300000b1301009a9c1800000a4f6943435050686f746f73686f70204943432070726f66" +
			"696c65000078da9d53675453e9163df7def4424b8880944b6f5215082052428b801491262a210910" +
			"4a8821a1d91551c1114545041bc8a088038e8e808c15512c0c8a0ad807e421a28e83a3888acafbe1" +
			"7ba36bd6bcf7e6cdfeb5d73ee7acf39db3cf07c0080c9648335135800ca9421e11e083c7c4c6e1e4" +
			"2e40810a2470001008b3642173fd230100f87e3c3c2b22c007be000178d30b0800c04d9bc0301c87" +
			"ff0fea42995c01808401c07491384b08801400407a8e42a600404601809d98265300a0040060cb63" +
			"62e300502d0060277fe6d300809df8997b01005b94211501a09100201365884400683b00accf568a" +
			"450058300014664bc43900d82d00304957664800b0b700c0ce100bb200080c00305188852900047b" +
			"0060c8232378008499001446f2573cf12bae10e72a00007899b23cb9243945815b082d710757572e" +
			"1e28ce49172b14366102619a402ec27999193281340fe0f3cc0000a0911511e083f3fd78ce0eaece" +
			"ce368eb60e5f2deabf06ff226262e3fee5cfab70400000e1747ed1fe2c2fb31a803b06806dfea225" +
			"ee04685e0ba075f78b66b20f40b500a0e9da57f370f87e3c3c45a190b9d9d9e5e4e4d84ac4425b61" +
			"ca577dfe67c25fc057fd6cf97e3cfcf7f5e0bee22481325d814704f8e0c2ccf44ca51ccf92098462" +
			"dce68f47fcb70bfffc1dd322c44962b9582a14e35112718e449a8cf332a52289429229c525d2ff64" +
			"e2df2cfb033edf3500b06a3e017b912da85d6303f64b27105874c0e2f70000f2bb6fc1d428080380" +
			"6883e1cf77ffef3ffd47a02500806649927100005e44242e54cab33fc708000044a0812ab0411bf4" +
			"c1182cc0061cc105dcc10bfc6036844224c4c24210420a64801c726029ac82422886cdb01d2a602f" +
			"d4401d34c051688693700e2ec255b80e3d700ffa61089ec128bc81090441c808136121da8801628a" +
			"58238e08179985f821c14804128b2420c9881451224b91354831528a542055481df23d720239875c" +
			"46ba913bc8003282fc86bc47319481b2513dd40cb543b9a8371a8446a20bd06474319a8f16a09bd0" +
			"72b41a3d8c36a1e7d0ab680fda8f3e43c730c0e8180733c46c302ec6c342b1382c099363cbb122ac" +
			"0cabc61ab056ac03bb89f563cfb17704128145c0093604774220611e4148584c584ed848a8201c24" +
			"3411da093709038451c2272293a84bb426ba11f9c4186232318758482c23d6128f132f107b8843c4" +
			"37241289433227b9900249b1a454d212d246d26e5223e92ca99b34481a2393c9da646bb20739942c" +
			"202bc885e49de4c3e433e41be421f25b0a9d624071a4f853e22852ca6a4a19e510e534e506659832" +
			"4155a39a52dda8a15411358f5a42ada1b652af5187a81334759a39cd8316494ba5ada295d31a6817" +
			"68f769afe874ba11dd951e4e97d057d2cbe947e897e803f4770c0d861583c7886728199b18071867" +
			"197718af984ca619d38b19c754303731eb98e7990f996f55582ab62a7c1591ca0a954a9526951b2a" +
			"2f54a9aaa6aadeaa0b55f355cb548fa95e537dae46553353e3a909d496ab55aa9d50eb531b5367a9" +
			"3ba887aa67a86f543fa47e59fd890659c34cc34f43a451a0b15fe3bcc6200b6319b3782c216b0dab" +
			"86758135c426b1cdd97c762abb98fd1dbb8b3daaa9a13943334a3357b352f394663f07e39871f89c" +
			"744e09e728a797f37e8ade14ef29e2291ba6344cb931655c6baa96979658ab48ab51ab47ebbd36ae" +
			"eda79da6bd45bb59fb810e41c74a275c2747678fce059de753d953dda70aa7164d3d3af5ae2eaa6b" +
			"a51ba1bb4477bf6ea7ee989ebe5e809e4c6fa7de79bde7fa1c7d2ffd54fd6dfaa7f5470c5806b30c" +
			"2406db0cce183cc535716f3c1d2fc7dbf151435dc34043a561956197e18491b9d13ca3d5468d460f" +
			"8c69c65ce324e36dc66dc6a326062621264b4dea4dee9a524db9a629a63b4c3b4cc7cdcccda2cdd6" +
			"99359b3d31d732e79be79bd79bdfb7605a785a2cb6a8b6b86549b2e45aa659eeb6bc6e855a3959a5" +
			"58555a5db346ad9dad25d6bbadbba711a7b94e934eab9ed667c3b0f1b6c9b6a9b719b0e5d806dbae" +
			"b66db67d6167621767b7c5aec3ee93bd937dba7d8dfd3d070d87d90eab1d5a1d7e73b472143a563a" +
			"de9ace9cee3f7dc5f496e92f6758cf10cfd833e3b613cb29c4699d539bd347671767b97383f3888b" +
			"894b82cb2e973e2e9b1bc6ddc8bde44a74f5715de17ad2f59d9bb39bc2eda8dbafee36ee69ee87dc" +
			"9fcc349f299e593373d0c3c843e051e5d13f0b9f95306bdfac7e4f434f8167b5e7232f632f9157ad" +
			"d7b0b7a577aaf761ef173ef63e729fe33ee33c37de32de595fcc37c0b7c8b7cb4fc36f9e5f85df43" +
			"7f23ff64ff7affd100a78025016703898141815b02fbf87a7c21bf8e3f3adb65f6b2d9ed418ca0b9" +
			"4115418f82ad82e5c1ad2168c8ec90ad21f7e798ce91ce690e85507ee8d6d00761e6618bc37e0c27" +
			"85878557863f8e7088581ad131973577d1dc4373df44fa449644de9b67314f39af2d4a352a3eaa2e" +
			"6a3cda37ba34ba3fc62e6659ccd5589d58496c4b1c392e2aae366e6cbedffcedf387e29de20be37b" +
			"17982fc85d7079a1cec2f485a716a92e122c3a96404c884e3894f041102aa8168c25f21377258e0a" +
			"79c21dc267222fd136d188d8435c2a1e4ef2482a4d7a92ec91bc357924c533a52ce5b98427a990bc" +
			"4c0d4cdd9b3a9e169a76206d323d3abd31839291907142aa214d93b667ea67e66676cbac6585b2fe" +
			"c56e8bb72f1e9507c96bb390ac05592d0ab642a6e8545a28d72a07b267655766bfcd89ca3996ab9e" +
			"2bcdedccb3cadb90379cef9fffed12c212e192b6a5864b572d1d58e6bdac6a39b23c7179db0ae315" +
			"052b865606ac3cb88ab62a6dd54fabed5797ae7ebd267a4d6b815ec1ca82c1b5016beb0b550ae585" +
			"7debdcd7ed5d4f582f59dfb561fa869d1b3e15898aae14db1797157fd828dc78e51b876fcabf99dc" +
			"94b4a9abc4b964cf66d266e9e6de2d9e5b0e96aa97e6970e6e0dd9dab40ddf56b4edf5f645db2f97" +
			"cd28dbbb83b643b9a3bf3cb8bc65a7c9cecd3b3f54a454f454fa5436eed2ddb561d7f86ed1ee1b7b" +
			"bcf634ecd5db5bbcf7fd3ec9bedb5501554dd566d565fb49fbb3f73fae89aae9f896fb6d5dad4e6d" +
			"71edc703d203fd07230eb6d7b9d4d51dd23d54528fd62beb470ec71fbefe9def772d0d360d558d9c" +
			"c6e223704479e4e9f709dff71e0d3ada768c7bace107d31f761d671d2f6a429af29a469b539afb5b" +
			"625bba4fcc3ed1d6eade7afc47db1f0f9c343c59794af354c969dae982d39367f2cf8c9d959d7d7e" +
			"2ef9dc60dba2b67be763cedf6a0f6fefba1074e1d245ff8be73bbc3bce5cf2b874f2b2dbe51357b8" +
			"579aaf3a5f6dea74ea3cfe93d34fc7bb9cbb9aaeb95c6bb9ee7abdb57b66f7e91b9e37ceddf4bd79" +
			"f116ffd6d59e393dddbdf37a6ff7c5f7f5df16dd7e7227fdcecbbbd97727eeadbc4fbc5ff440ed41" +
			"d943dd87d53f5bfedcd8efdc7f6ac077a0f3d1dc47f7068583cffe91f58f0f43058f998fcb860d86" +
			"eb9e383e3939e23f72fde9fca743cf64cf269e17fea2fecbae17162f7ef8d5ebd7ced198d1a197f2" +
			"9793bf6d7ca5fdeac0eb19afdbc6c2c61ebec97833315ef456fbedc177dc771defa3df0f4fe47c20" +
			"7f28ff68f9b1f553d0a7fb93199393ff040398f3fc63332ddb000000206348524d00007a25000080" +
			"830000f9ff000080e9000075300000ea6000003a980000176f925fc546000001bf4944415478daa4" +
			"92b1cb526118c57feffd7cef2d34e1125750179d1a1ca2b6706813c5bfc0fe81d690866a6c11a2ad" +
			"3142da22274144f8205cdc9cf2035b4444c4e58260a0f7ead5a721bd08e9920fbc7096e7bce739e7" +
			"2811e19a31b872ae26881c81522a84a552e999d6fa1df058296588c8cf20083eb6dbed1f80001c4f" +
			"5721f84b6094cbe537b66dbf2f168b37b95c0ea514c3e1906eb7cb6c36fbd06ab5de02fb7304aa50" +
			"28146cdbee54ab5552a954a84a44582c16d46a35168bc58b4ea7f34d0e8ba71e444cd37c9d4c26b1" +
			"2c0bad35a669629a6688d3e9345aeb57803e67a2360ce3692693613a9db25eaf4302cff3188d4664" +
			"b3590cc378724a103955a094528ee390482410113ccf434410111cc761b55a1dcf8a9c8d516b7db7" +
			"dfef8946a35896152ab02c8b582c8688609ae6dda51e04dbedf6b3ebba6c361b8220c0f7fd10ef76" +
			"3b5cd74544be02c139826db3d9bc9d4c269f7abdde7e369be1791ebeef339fcf190c068cc7e32f8d" +
			"46e33bb00d4b731a23701f7858a9549ee7f3f997f178fc9152ea66b95cfeeaf7fbf57abd7e0bb8c0" +
			"ea18e33f4502ee010f0ecf3a7cb4017e034bc0bb54a450d5c1657de27670901d5cacf2ffce9f0100" +
			"b95fd29880cb2c140000000049454e44ae426082",
	},

	"unknown": &icon{
		size: "16x16",
		encoded: "" +
			"89504e470d0a1a0a0000000d49484452000000100000000b080600000076e20d3900000004734249" +
			"54080808087c0864880000000970485973000001060000010601cdd333bc0000001974455874536f" +
			"667477617265007777772e696e6b73636170652e6f72679bee3c1a000000984944415428cf63f8ff" +
			"ff3f032e0c0462208c570d0e8df1407c0188ff4131881d4f9401409002d5f418881b81b80088af43" +
			"c552f01a0004925085df8058098805815804880580f803544e129f013140fc1f8a57425d31172ab7" +
			"172a1e83cf807e240340782110b300b11f10ff828af513eb0210ae05e26ca8d3ff13e3024934c5ee" +
			"500ce3e30f03b45800711aa018a63985f6e980d494080058a0508e080901ed0000000049454e44ae" +
			"426082",
	},

	"available": &icon{
		size: "16x16",
		encoded: "" +
			"" +
			"89504e470d0a1a0a0000000d49484452000000100000001008060000001ff3ff6100000009704859" +
			"7300000b1300000b1301009a9c1800000a4f6943435050686f746f73686f70204943432070726f66" +
			"696c65000078da9d53675453e9163df7def4424b8880944b6f5215082052428b801491262a210910" +
			"4a8821a1d91551c1114545041bc8a088038e8e808c15512c0c8a0ad807e421a28e83a3888acafbe1" +
			"7ba36bd6bcf7e6cdfeb5d73ee7acf39db3cf07c0080c9648335135800ca9421e11e083c7c4c6e1e4" +
			"2e40810a2470001008b3642173fd230100f87e3c3c2b22c007be000178d30b0800c04d9bc0301c87" +
			"ff0fea42995c01808401c07491384b08801400407a8e42a600404601809d98265300a0040060cb63" +
			"62e300502d0060277fe6d300809df8997b01005b94211501a09100201365884400683b00accf568a" +
			"450058300014664bc43900d82d00304957664800b0b700c0ce100bb200080c00305188852900047b" +
			"0060c8232378008499001446f2573cf12bae10e72a00007899b23cb9243945815b082d710757572e" +
			"1e28ce49172b14366102619a402ec27999193281340fe0f3cc0000a0911511e083f3fd78ce0eaece" +
			"ce368eb60e5f2deabf06ff226262e3fee5cfab70400000e1747ed1fe2c2fb31a803b06806dfea225" +
			"ee04685e0ba075f78b66b20f40b500a0e9da57f370f87e3c3c45a190b9d9d9e5e4e4d84ac4425b61" +
			"ca577dfe67c25fc057fd6cf97e3cfcf7f5e0bee22481325d814704f8e0c2ccf44ca51ccf92098462" +
			"dce68f47fcb70bfffc1dd322c44962b9582a14e35112718e449a8cf332a52289429229c525d2ff64" +
			"e2df2cfb033edf3500b06a3e017b912da85d6303f64b27105874c0e2f70000f2bb6fc1d428080380" +
			"6883e1cf77ffef3ffd47a02500806649927100005e44242e54cab33fc708000044a0812ab0411bf4" +
			"c1182cc0061cc105dcc10bfc6036844224c4c24210420a64801c726029ac82422886cdb01d2a602f" +
			"d4401d34c051688693700e2ec255b80e3d700ffa61089ec128bc81090441c808136121da8801628a" +
			"58238e08179985f821c14804128b2420c9881451224b91354831528a542055481df23d720239875c" +
			"46ba913bc8003282fc86bc47319481b2513dd40cb543b9a8371a8446a20bd06474319a8f16a09bd0" +
			"72b41a3d8c36a1e7d0ab680fda8f3e43c730c0e8180733c46c302ec6c342b1382c099363cbb122ac" +
			"0cabc61ab056ac03bb89f563cfb17704128145c0093604774220611e4148584c584ed848a8201c24" +
			"3411da093709038451c2272293a84bb426ba11f9c4186232318758482c23d6128f132f107b8843c4" +
			"37241289433227b9900249b1a454d212d246d26e5223e92ca99b34481a2393c9da646bb20739942c" +
			"202bc885e49de4c3e433e41be421f25b0a9d624071a4f853e22852ca6a4a19e510e534e506659832" +
			"4155a39a52dda8a15411358f5a42ada1b652af5187a81334759a39cd8316494ba5ada295d31a6817" +
			"68f769afe874ba11dd951e4e97d057d2cbe947e897e803f4770c0d861583c7886728199b18071867" +
			"197718af984ca619d38b19c754303731eb98e7990f996f55582ab62a7c1591ca0a954a9526951b2a" +
			"2f54a9aaa6aadeaa0b55f355cb548fa95e537dae46553353e3a909d496ab55aa9d50eb531b5367a9" +
			"3ba887aa67a86f543fa47e59fd890659c34cc34f43a451a0b15fe3bcc6200b6319b3782c216b0dab" +
			"86758135c426b1cdd97c762abb98fd1dbb8b3daaa9a13943334a3357b352f394663f07e39871f89c" +
			"744e09e728a797f37e8ade14ef29e2291ba6344cb931655c6baa96979658ab48ab51ab47ebbd36ae" +
			"eda79da6bd45bb59fb810e41c74a275c2747678fce059de753d953dda70aa7164d3d3af5ae2eaa6b" +
			"a51ba1bb4477bf6ea7ee989ebe5e809e4c6fa7de79bde7fa1c7d2ffd54fd6dfaa7f5470c5806b30c" +
			"2406db0cce183cc535716f3c1d2fc7dbf151435dc34043a561956197e18491b9d13ca3d5468d460f" +
			"8c69c65ce324e36dc66dc6a326062621264b4dea4dee9a524db9a629a63b4c3b4cc7cdcccda2cdd6" +
			"99359b3d31d732e79be79bd79bdfb7605a785a2cb6a8b6b86549b2e45aa659eeb6bc6e855a3959a5" +
			"58555a5db346ad9dad25d6bbadbba711a7b94e934eab9ed667c3b0f1b6c9b6a9b719b0e5d806dbae" +
			"b66db67d6167621767b7c5aec3ee93bd937dba7d8dfd3d070d87d90eab1d5a1d7e73b472143a563a" +
			"de9ace9cee3f7dc5f496e92f6758cf10cfd833e3b613cb29c4699d539bd347671767b97383f3888b" +
			"894b82cb2e973e2e9b1bc6ddc8bde44a74f5715de17ad2f59d9bb39bc2eda8dbafee36ee69ee87dc" +
			"9fcc349f299e593373d0c3c843e051e5d13f0b9f95306bdfac7e4f434f8167b5e7232f632f9157ad" +
			"d7b0b7a577aaf761ef173ef63e729fe33ee33c37de32de595fcc37c0b7c8b7cb4fc36f9e5f85df43" +
			"7f23ff64ff7affd100a78025016703898141815b02fbf87a7c21bf8e3f3adb65f6b2d9ed418ca0b9" +
			"4115418f82ad82e5c1ad2168c8ec90ad21f7e798ce91ce690e85507ee8d6d00761e6618bc37e0c27" +
			"85878557863f8e7088581ad131973577d1dc4373df44fa449644de9b67314f39af2d4a352a3eaa2e" +
			"6a3cda37ba34ba3fc62e6659ccd5589d58496c4b1c392e2aae366e6cbedffcedf387e29de20be37b" +
			"17982fc85d7079a1cec2f485a716a92e122c3a96404c884e3894f041102aa8168c25f21377258e0a" +
			"79c21dc267222fd136d188d8435c2a1e4ef2482a4d7a92ec91bc357924c533a52ce5b98427a990bc" +
			"4c0d4cdd9b3a9e169a76206d323d3abd31839291907142aa214d93b667ea67e66676cbac6585b2fe" +
			"c56e8bb72f1e9507c96bb390ac05592d0ab642a6e8545a28d72a07b267655766bfcd89ca3996ab9e" +
			"2bcdedccb3cadb90379cef9fffed12c212e192b6a5864b572d1d58e6bdac6a39b23c7179db0ae315" +
			"052b865606ac3cb88ab62a6dd54fabed5797ae7ebd267a4d6b815ec1ca82c1b5016beb0b550ae585" +
			"7debdcd7ed5d4f582f59dfb561fa869d1b3e15898aae14db1797157fd828dc78e51b876fcabf99dc" +
			"94b4a9abc4b964cf66d266e9e6de2d9e5b0e96aa97e6970e6e0dd9dab40ddf56b4edf5f645db2f97" +
			"cd28dbbb83b643b9a3bf3cb8bc65a7c9cecd3b3f54a454f454fa5436eed2ddb561d7f86ed1ee1b7b" +
			"bcf634ecd5db5bbcf7fd3ec9bedb5501554dd566d565fb49fbb3f73fae89aae9f896fb6d5dad4e6d" +
			"71edc703d203fd07230eb6d7b9d4d51dd23d54528fd62beb470ec71fbefe9def772d0d360d558d9c" +
			"c6e223704479e4e9f709dff71e0d3ada768c7bace107d31f761d671d2f6a429af29a469b539afb5b" +
			"625bba4fcc3ed1d6eade7afc47db1f0f9c343c59794af354c969dae982d39367f2cf8c9d959d7d7e" +
			"2ef9dc60dba2b67be763cedf6a0f6fefba1074e1d245ff8be73bbc3bce5cf2b874f2b2dbe51357b8" +
			"579aaf3a5f6dea74ea3cfe93d34fc7bb9cbb9aaeb95c6bb9ee7abdb57b66f7e91b9e37ceddf4bd79" +
			"f116ffd6d59e393dddbdf37a6ff7c5f7f5df16dd7e7227fdcecbbbd97727eeadbc4fbc5ff440ed41" +
			"d943dd87d53f5bfedcd8efdc7f6ac077a0f3d1dc47f7068583cffe91f58f0f43058f998fcb860d86" +
			"eb9e383e3939e23f72fde9fca743cf64cf269e17fea2fecbae17162f7ef8d5ebd7ced198d1a197f2" +
			"9793bf6d7ca5fdeac0eb19afdbc6c2c61ebec97833315ef456fbedc177dc771defa3df0f4fe47c20" +
			"7f28ff68f9b1f553d0a7fb93199393ff040398f3fc63332ddb000000206348524d00007a25000080" +
			"830000f9ff000080e9000075300000ea6000003a980000176f925fc546000001d84944415478daa4" +
			"92bf6b137118c63feff77ee55ac395f68e5a3016a455ac83540475283af53fd041a554101c747070" +
			"50b73a8a9b20058de28f415c5c1c2a85222e12c425761015b452add0a46a925e8fcb35e7904bb862" +
			"ba9807bef02eeff37d9ef779248e63ba81a24b744da0b70611698fee34c730b82ec24104153728b2" +
			"c9add27d168018a0655dda43934079e7b93ad8b7e3c6c92353dad1d113281485cfaf79fef609df4a" +
			"6b3757f35c031a9d08a4ff0c93a6c3dcecf43d46768e350dc620c0caaf65a6664f11d6385d7ac4d3" +
			"38594cdf405719ae0cf4816e05981658464cc602dd00dd08f1fa018bcb80d1e98886681cca0dc1c2" +
			"d2257ed45e629a354cc3a71cbc62eecb5972bb4034c6d3047a5a412cc89007c31ed41b33947d5002" +
			"c126e45cf8bd0105d9bab7254647a9c58c085e167a6c304d300cb04c706de8d1c0d1d562c71881a8" +
			"b7367877a3ea4e0461c06af4898ad63c62bd01a18cb2fec7c6f1cb0fe17bd489a05e7cbc32bf6778" +
			"f7eda23e72f1c0d85ee5b9eb8882b5b2cdd2b24df9ebcffcbb7cf119506f97261d2360030393e70e" +
			"1f1f9fd87f21ebf4ee534ab46ac5fff0bef0f1c18b3b6fe68112e0b762fca7484006c826cf4a3e0a" +
			"812a500182ed8ad4569558335216a34476b46d95ff177f07007a58aa94d2c031070000000049454e" +
			"44ae426082",
	},

	"away": &icon{
		size: "16x16",
		encoded: "" +
			"" +
			"89504e470d0a1a0a0000000d49484452000000100000001008060000001ff3ff6100000009704859" +
			"7300000b1300000b1301009a9c1800000a4f6943435050686f746f73686f70204943432070726f66" +
			"696c65000078da9d53675453e9163df7def4424b8880944b6f5215082052428b801491262a210910" +
			"4a8821a1d91551c1114545041bc8a088038e8e808c15512c0c8a0ad807e421a28e83a3888acafbe1" +
			"7ba36bd6bcf7e6cdfeb5d73ee7acf39db3cf07c0080c9648335135800ca9421e11e083c7c4c6e1e4" +
			"2e40810a2470001008b3642173fd230100f87e3c3c2b22c007be000178d30b0800c04d9bc0301c87" +
			"ff0fea42995c01808401c07491384b08801400407a8e42a600404601809d98265300a0040060cb63" +
			"62e300502d0060277fe6d300809df8997b01005b94211501a09100201365884400683b00accf568a" +
			"450058300014664bc43900d82d00304957664800b0b700c0ce100bb200080c00305188852900047b" +
			"0060c8232378008499001446f2573cf12bae10e72a00007899b23cb9243945815b082d710757572e" +
			"1e28ce49172b14366102619a402ec27999193281340fe0f3cc0000a0911511e083f3fd78ce0eaece" +
			"ce368eb60e5f2deabf06ff226262e3fee5cfab70400000e1747ed1fe2c2fb31a803b06806dfea225" +
			"ee04685e0ba075f78b66b20f40b500a0e9da57f370f87e3c3c45a190b9d9d9e5e4e4d84ac4425b61" +
			"ca577dfe67c25fc057fd6cf97e3cfcf7f5e0bee22481325d814704f8e0c2ccf44ca51ccf92098462" +
			"dce68f47fcb70bfffc1dd322c44962b9582a14e35112718e449a8cf332a52289429229c525d2ff64" +
			"e2df2cfb033edf3500b06a3e017b912da85d6303f64b27105874c0e2f70000f2bb6fc1d428080380" +
			"6883e1cf77ffef3ffd47a02500806649927100005e44242e54cab33fc708000044a0812ab0411bf4" +
			"c1182cc0061cc105dcc10bfc6036844224c4c24210420a64801c726029ac82422886cdb01d2a602f" +
			"d4401d34c051688693700e2ec255b80e3d700ffa61089ec128bc81090441c808136121da8801628a" +
			"58238e08179985f821c14804128b2420c9881451224b91354831528a542055481df23d720239875c" +
			"46ba913bc8003282fc86bc47319481b2513dd40cb543b9a8371a8446a20bd06474319a8f16a09bd0" +
			"72b41a3d8c36a1e7d0ab680fda8f3e43c730c0e8180733c46c302ec6c342b1382c099363cbb122ac" +
			"0cabc61ab056ac03bb89f563cfb17704128145c0093604774220611e4148584c584ed848a8201c24" +
			"3411da093709038451c2272293a84bb426ba11f9c4186232318758482c23d6128f132f107b8843c4" +
			"37241289433227b9900249b1a454d212d246d26e5223e92ca99b34481a2393c9da646bb20739942c" +
			"202bc885e49de4c3e433e41be421f25b0a9d624071a4f853e22852ca6a4a19e510e534e506659832" +
			"4155a39a52dda8a15411358f5a42ada1b652af5187a81334759a39cd8316494ba5ada295d31a6817" +
			"68f769afe874ba11dd951e4e97d057d2cbe947e897e803f4770c0d861583c7886728199b18071867" +
			"197718af984ca619d38b19c754303731eb98e7990f996f55582ab62a7c1591ca0a954a9526951b2a" +
			"2f54a9aaa6aadeaa0b55f355cb548fa95e537dae46553353e3a909d496ab55aa9d50eb531b5367a9" +
			"3ba887aa67a86f543fa47e59fd890659c34cc34f43a451a0b15fe3bcc6200b6319b3782c216b0dab" +
			"86758135c426b1cdd97c762abb98fd1dbb8b3daaa9a13943334a3357b352f394663f07e39871f89c" +
			"744e09e728a797f37e8ade14ef29e2291ba6344cb931655c6baa96979658ab48ab51ab47ebbd36ae" +
			"eda79da6bd45bb59fb810e41c74a275c2747678fce059de753d953dda70aa7164d3d3af5ae2eaa6b" +
			"a51ba1bb4477bf6ea7ee989ebe5e809e4c6fa7de79bde7fa1c7d2ffd54fd6dfaa7f5470c5806b30c" +
			"2406db0cce183cc535716f3c1d2fc7dbf151435dc34043a561956197e18491b9d13ca3d5468d460f" +
			"8c69c65ce324e36dc66dc6a326062621264b4dea4dee9a524db9a629a63b4c3b4cc7cdcccda2cdd6" +
			"99359b3d31d732e79be79bd79bdfb7605a785a2cb6a8b6b86549b2e45aa659eeb6bc6e855a3959a5" +
			"58555a5db346ad9dad25d6bbadbba711a7b94e934eab9ed667c3b0f1b6c9b6a9b719b0e5d806dbae" +
			"b66db67d6167621767b7c5aec3ee93bd937dba7d8dfd3d070d87d90eab1d5a1d7e73b472143a563a" +
			"de9ace9cee3f7dc5f496e92f6758cf10cfd833e3b613cb29c4699d539bd347671767b97383f3888b" +
			"894b82cb2e973e2e9b1bc6ddc8bde44a74f5715de17ad2f59d9bb39bc2eda8dbafee36ee69ee87dc" +
			"9fcc349f299e593373d0c3c843e051e5d13f0b9f95306bdfac7e4f434f8167b5e7232f632f9157ad" +
			"d7b0b7a577aaf761ef173ef63e729fe33ee33c37de32de595fcc37c0b7c8b7cb4fc36f9e5f85df43" +
			"7f23ff64ff7affd100a78025016703898141815b02fbf87a7c21bf8e3f3adb65f6b2d9ed418ca0b9" +
			"4115418f82ad82e5c1ad2168c8ec90ad21f7e798ce91ce690e85507ee8d6d00761e6618bc37e0c27" +
			"85878557863f8e7088581ad131973577d1dc4373df44fa449644de9b67314f39af2d4a352a3eaa2e" +
			"6a3cda37ba34ba3fc62e6659ccd5589d58496c4b1c392e2aae366e6cbedffcedf387e29de20be37b" +
			"17982fc85d7079a1cec2f485a716a92e122c3a96404c884e3894f041102aa8168c25f21377258e0a" +
			"79c21dc267222fd136d188d8435c2a1e4ef2482a4d7a92ec91bc357924c533a52ce5b98427a990bc" +
			"4c0d4cdd9b3a9e169a76206d323d3abd31839291907142aa214d93b667ea67e66676cbac6585b2fe" +
			"c56e8bb72f1e9507c96bb390ac05592d0ab642a6e8545a28d72a07b267655766bfcd89ca3996ab9e" +
			"2bcdedccb3cadb90379cef9fffed12c212e192b6a5864b572d1d58e6bdac6a39b23c7179db0ae315" +
			"052b865606ac3cb88ab62a6dd54fabed5797ae7ebd267a4d6b815ec1ca82c1b5016beb0b550ae585" +
			"7debdcd7ed5d4f582f59dfb561fa869d1b3e15898aae14db1797157fd828dc78e51b876fcabf99dc" +
			"94b4a9abc4b964cf66d266e9e6de2d9e5b0e96aa97e6970e6e0dd9dab40ddf56b4edf5f645db2f97" +
			"cd28dbbb83b643b9a3bf3cb8bc65a7c9cecd3b3f54a454f454fa5436eed2ddb561d7f86ed1ee1b7b" +
			"bcf634ecd5db5bbcf7fd3ec9bedb5501554dd566d565fb49fbb3f73fae89aae9f896fb6d5dad4e6d" +
			"71edc703d203fd07230eb6d7b9d4d51dd23d54528fd62beb470ec71fbefe9def772d0d360d558d9c" +
			"c6e223704479e4e9f709dff71e0d3ada768c7bace107d31f761d671d2f6a429af29a469b539afb5b" +
			"625bba4fcc3ed1d6eade7afc47db1f0f9c343c59794af354c969dae982d39367f2cf8c9d959d7d7e" +
			"2ef9dc60dba2b67be763cedf6a0f6fefba1074e1d245ff8be73bbc3bce5cf2b874f2b2dbe51357b8" +
			"579aaf3a5f6dea74ea3cfe93d34fc7bb9cbb9aaeb95c6bb9ee7abdb57b66f7e91b9e37ceddf4bd79" +
			"f116ffd6d59e393dddbdf37a6ff7c5f7f5df16dd7e7227fdcecbbbd97727eeadbc4fbc5ff440ed41" +
			"d943dd87d53f5bfedcd8efdc7f6ac077a0f3d1dc47f7068583cffe91f58f0f43058f998fcb860d86" +
			"eb9e383e3939e23f72fde9fca743cf64cf269e17fea2fecbae17162f7ef8d5ebd7ced198d1a197f2" +
			"9793bf6d7ca5fdeac0eb19afdbc6c2c61ebec97833315ef456fbedc177dc771defa3df0f4fe47c20" +
			"7f28ff68f9b1f553d0a7fb93199393ff040398f3fc63332ddb000000206348524d00007a25000080" +
			"830000f9ff000080e9000075300000ea6000003a980000176f925fc546000001df4944415478daa4" +
			"924b6813611485bf3bf34f663a698d9936110245e246858228b850aca20bb72edcb91154a8d08d0b" +
			"1756772e8b2ea4f800ad2f1444702f1444142aba1125825868313e106b629a574d6632bf8b2621b5" +
			"e9c65cf8e16ceef9cfb9e788d69a5ec6a0c7e99940b58088b4e169933d9670de1076a031b4f0ded7" +
			"5cba1ef00cd0002debd2062b04c6b8e29c971cbcb8eff82973cbc14388080b2f5f307bff363fbf7e" +
			"9fbc1a300184dd08e4a4e2704c787ae2ee03a29e875f2880d6446231fc46831b478fb01472ec5683" +
			"47bab9a83aed3870362e107ec9d2c8e7a05c46b4c6775d7c53e109d48433c013a0feef112d1376a5" +
			"4cc84d5d4065de10d7253c63197bee1d8b97271856600a3b016bcd11012582246d485a1af7f543dc" +
			"0fa005c23224056a36487df59e5a9569bf9d3192eee8c0d06f9c3eb0fa5734861170a3204e1c4baa" +
			"19f235ba1104c50d4337971289d17a6a984016f0750980306181de46c150546ab97be4b34137027f" +
			"faf3b799747af394a952e323f1b4b129b28c61c0622d42b6e230af7e4c5f9b7ffb18f0dba5e98c11" +
			"e80306c7f6ee3eb07f64fbd8c66874ab8059ac543fbefa3477e7caf3d919e017506dc5b8a6488003" +
			"0c349fddfca80e948022f067bd22b55535ad591d1683a6ec60dd2affeffc1d005f1eb80123361f35" +
			"0000000049454e44ae426082",
	},
	"connecting": &icon{ //animation
		size: "16x16",
		encoded: "" +
			"89504e470d0a1a0a0000000d49484452000000100000001008060000001ff3ff6100000009704859" +
			"7300000b1300000b1301009a9c1800000a4f6943435050686f746f73686f70204943432070726f66" +
			"696c65000078da9d53675453e9163df7def4424b8880944b6f5215082052428b801491262a210910" +
			"4a8821a1d91551c1114545041bc8a088038e8e808c15512c0c8a0ad807e421a28e83a3888acafbe1" +
			"7ba36bd6bcf7e6cdfeb5d73ee7acf39db3cf07c0080c9648335135800ca9421e11e083c7c4c6e1e4" +
			"2e40810a2470001008b3642173fd230100f87e3c3c2b22c007be000178d30b0800c04d9bc0301c87" +
			"ff0fea42995c01808401c07491384b08801400407a8e42a600404601809d98265300a0040060cb63" +
			"62e300502d0060277fe6d300809df8997b01005b94211501a09100201365884400683b00accf568a" +
			"450058300014664bc43900d82d00304957664800b0b700c0ce100bb200080c00305188852900047b" +
			"0060c8232378008499001446f2573cf12bae10e72a00007899b23cb9243945815b082d710757572e" +
			"1e28ce49172b14366102619a402ec27999193281340fe0f3cc0000a0911511e083f3fd78ce0eaece" +
			"ce368eb60e5f2deabf06ff226262e3fee5cfab70400000e1747ed1fe2c2fb31a803b06806dfea225" +
			"ee04685e0ba075f78b66b20f40b500a0e9da57f370f87e3c3c45a190b9d9d9e5e4e4d84ac4425b61" +
			"ca577dfe67c25fc057fd6cf97e3cfcf7f5e0bee22481325d814704f8e0c2ccf44ca51ccf92098462" +
			"dce68f47fcb70bfffc1dd322c44962b9582a14e35112718e449a8cf332a52289429229c525d2ff64" +
			"e2df2cfb033edf3500b06a3e017b912da85d6303f64b27105874c0e2f70000f2bb6fc1d428080380" +
			"6883e1cf77ffef3ffd47a02500806649927100005e44242e54cab33fc708000044a0812ab0411bf4" +
			"c1182cc0061cc105dcc10bfc6036844224c4c24210420a64801c726029ac82422886cdb01d2a602f" +
			"d4401d34c051688693700e2ec255b80e3d700ffa61089ec128bc81090441c808136121da8801628a" +
			"58238e08179985f821c14804128b2420c9881451224b91354831528a542055481df23d720239875c" +
			"46ba913bc8003282fc86bc47319481b2513dd40cb543b9a8371a8446a20bd06474319a8f16a09bd0" +
			"72b41a3d8c36a1e7d0ab680fda8f3e43c730c0e8180733c46c302ec6c342b1382c099363cbb122ac" +
			"0cabc61ab056ac03bb89f563cfb17704128145c0093604774220611e4148584c584ed848a8201c24" +
			"3411da093709038451c2272293a84bb426ba11f9c4186232318758482c23d6128f132f107b8843c4" +
			"37241289433227b9900249b1a454d212d246d26e5223e92ca99b34481a2393c9da646bb20739942c" +
			"202bc885e49de4c3e433e41be421f25b0a9d624071a4f853e22852ca6a4a19e510e534e506659832" +
			"4155a39a52dda8a15411358f5a42ada1b652af5187a81334759a39cd8316494ba5ada295d31a6817" +
			"68f769afe874ba11dd951e4e97d057d2cbe947e897e803f4770c0d861583c7886728199b18071867" +
			"197718af984ca619d38b19c754303731eb98e7990f996f55582ab62a7c1591ca0a954a9526951b2a" +
			"2f54a9aaa6aadeaa0b55f355cb548fa95e537dae46553353e3a909d496ab55aa9d50eb531b5367a9" +
			"3ba887aa67a86f543fa47e59fd890659c34cc34f43a451a0b15fe3bcc6200b6319b3782c216b0dab" +
			"86758135c426b1cdd97c762abb98fd1dbb8b3daaa9a13943334a3357b352f394663f07e39871f89c" +
			"744e09e728a797f37e8ade14ef29e2291ba6344cb931655c6baa96979658ab48ab51ab47ebbd36ae" +
			"eda79da6bd45bb59fb810e41c74a275c2747678fce059de753d953dda70aa7164d3d3af5ae2eaa6b" +
			"a51ba1bb4477bf6ea7ee989ebe5e809e4c6fa7de79bde7fa1c7d2ffd54fd6dfaa7f5470c5806b30c" +
			"2406db0cce183cc535716f3c1d2fc7dbf151435dc34043a561956197e18491b9d13ca3d5468d460f" +
			"8c69c65ce324e36dc66dc6a326062621264b4dea4dee9a524db9a629a63b4c3b4cc7cdcccda2cdd6" +
			"99359b3d31d732e79be79bd79bdfb7605a785a2cb6a8b6b86549b2e45aa659eeb6bc6e855a3959a5" +
			"58555a5db346ad9dad25d6bbadbba711a7b94e934eab9ed667c3b0f1b6c9b6a9b719b0e5d806dbae" +
			"b66db67d6167621767b7c5aec3ee93bd937dba7d8dfd3d070d87d90eab1d5a1d7e73b472143a563a" +
			"de9ace9cee3f7dc5f496e92f6758cf10cfd833e3b613cb29c4699d539bd347671767b97383f3888b" +
			"894b82cb2e973e2e9b1bc6ddc8bde44a74f5715de17ad2f59d9bb39bc2eda8dbafee36ee69ee87dc" +
			"9fcc349f299e593373d0c3c843e051e5d13f0b9f95306bdfac7e4f434f8167b5e7232f632f9157ad" +
			"d7b0b7a577aaf761ef173ef63e729fe33ee33c37de32de595fcc37c0b7c8b7cb4fc36f9e5f85df43" +
			"7f23ff64ff7affd100a78025016703898141815b02fbf87a7c21bf8e3f3adb65f6b2d9ed418ca0b9" +
			"4115418f82ad82e5c1ad2168c8ec90ad21f7e798ce91ce690e85507ee8d6d00761e6618bc37e0c27" +
			"85878557863f8e7088581ad131973577d1dc4373df44fa449644de9b67314f39af2d4a352a3eaa2e" +
			"6a3cda37ba34ba3fc62e6659ccd5589d58496c4b1c392e2aae366e6cbedffcedf387e29de20be37b" +
			"17982fc85d7079a1cec2f485a716a92e122c3a96404c884e3894f041102aa8168c25f21377258e0a" +
			"79c21dc267222fd136d188d8435c2a1e4ef2482a4d7a92ec91bc357924c533a52ce5b98427a990bc" +
			"4c0d4cdd9b3a9e169a76206d323d3abd31839291907142aa214d93b667ea67e66676cbac6585b2fe" +
			"c56e8bb72f1e9507c96bb390ac05592d0ab642a6e8545a28d72a07b267655766bfcd89ca3996ab9e" +
			"2bcdedccb3cadb90379cef9fffed12c212e192b6a5864b572d1d58e6bdac6a39b23c7179db0ae315" +
			"052b865606ac3cb88ab62a6dd54fabed5797ae7ebd267a4d6b815ec1ca82c1b5016beb0b550ae585" +
			"7debdcd7ed5d4f582f59dfb561fa869d1b3e15898aae14db1797157fd828dc78e51b876fcabf99dc" +
			"94b4a9abc4b964cf66d266e9e6de2d9e5b0e96aa97e6970e6e0dd9dab40ddf56b4edf5f645db2f97" +
			"cd28dbbb83b643b9a3bf3cb8bc65a7c9cecd3b3f54a454f454fa5436eed2ddb561d7f86ed1ee1b7b" +
			"bcf634ecd5db5bbcf7fd3ec9bedb5501554dd566d565fb49fbb3f73fae89aae9f896fb6d5dad4e6d" +
			"71edc703d203fd07230eb6d7b9d4d51dd23d54528fd62beb470ec71fbefe9def772d0d360d558d9c" +
			"c6e223704479e4e9f709dff71e0d3ada768c7bace107d31f761d671d2f6a429af29a469b539afb5b" +
			"625bba4fcc3ed1d6eade7afc47db1f0f9c343c59794af354c969dae982d39367f2cf8c9d959d7d7e" +
			"2ef9dc60dba2b67be763cedf6a0f6fefba1074e1d245ff8be73bbc3bce5cf2b874f2b2dbe51357b8" +
			"579aaf3a5f6dea74ea3cfe93d34fc7bb9cbb9aaeb95c6bb9ee7abdb57b66f7e91b9e37ceddf4bd79" +
			"f116ffd6d59e393dddbdf37a6ff7c5f7f5df16dd7e7227fdcecbbbd97727eeadbc4fbc5ff440ed41" +
			"d943dd87d53f5bfedcd8efdc7f6ac077a0f3d1dc47f7068583cffe91f58f0f43058f998fcb860d86" +
			"eb9e383e3939e23f72fde9fca743cf64cf269e17fea2fecbae17162f7ef8d5ebd7ced198d1a197f2" +
			"9793bf6d7ca5fdeac0eb19afdbc6c2c61ebec97833315ef456fbedc177dc771defa3df0f4fe47c20" +
			"7f28ff68f9b1f553d0a7fb93199393ff040398f3fc63332ddb000000206348524d00007a25000080" +
			"830000f9ff000080e9000075300000ea6000003a980000176f925fc546000001bf4944415478daa4" +
			"92b1cb526118c57feffd7cef2d34e1125750179d1a1ca2b6706813c5bfc0fe81d690866a6c11a2ad" +
			"3142da22274144f8205cdc9cf2035b4444c4e58260a0f7ead5a721bd08e9920fbc7096e7bce739e7" +
			"2811e19a31b872ae26881c81522a84a552e999d6fa1df058296588c8cf20083eb6dbed1f80001c4f" +
			"5721f84b6094cbe537b66dbf2f168b37b95c0ea514c3e1906eb7cb6c36fbd06ab5de02fb7304aa50" +
			"28146cdbee54ab5552a954a84a44582c16d46a35168bc58b4ea7f34d0e8ba71e444cd37c9d4c26b1" +
			"2c0bad35a669629a6688d3e9345aeb57803e67a2360ce3692693613a9db25eaf4302cff3188d4664" +
			"b3590cc378724a103955a094528ee390482410113ccf434410111cc761b55a1dcf8a9c8d516b7db7" +
			"dfef8946a35896152ab02c8b582c8688609ae6dda51e04dbedf6b3ebba6c361b8220c0f7fd10ef76" +
			"3b5cd74544be02c139826db3d9bc9d4c269f7abdde7e369be1791ebeef339fcf190c068cc7e32f8d" +
			"46e33bb00d4b731a23701f7858a9549ee7f3f997f178fc9152ea66b95cfeeaf7fbf57abd7e0bb8c0" +
			"ea18e33f4502ee010f0ecf3a7cb4017e034bc0bb54a450d5c1657de27670901d5cacf2ffce9f0100" +
			"b95fd29880cb2c140000000049454e44ae426082",
	},
}

func (i *icon) get() []byte {
	if i.decoded == nil {
		i.decoded, _ = hex.DecodeString(i.encoded)
	}
	return i.decoded
}

func getActualRootFolder() string {
	wd, _ := os.Getwd()
	if strings.HasSuffix(wd, "/gui") {
		return filepath.Join(wd, "../")
	}
	return wd
}

func (i *icon) getPath() string {
	iconPath := filepath.Join(getActualRootFolder(), i.path)
	if fileNotFound(iconPath) {
		tmpIconPath := filepath.Join(filepath.Join(os.TempDir(), "coyim"), i.name)
		if fileNotFound(tmpIconPath) {
			os.MkdirAll(filepath.Join(os.TempDir(), "coyim"), 0755)
			ioutil.WriteFile(tmpIconPath, i.get(), 0644)
			log.Printf("gui/icons: wrote %s to %s\n", i.name, tmpIconPath)
		}
		return tmpIconPath
	}
	return iconPath
}

func (i *icon) getPixbuf() gdki.Pixbuf {
	if i.cached == nil {
		pl, _ := g.gdk.PixbufLoaderNew()
		pl.Write(i.get())
		pl.Close()
		pixbuf, _ := pl.GetPixbuf()
		i.cached = pixbuf
	}
	return i.cached
}
