// Copyright 1986 - 1993, 1998, 2004   Thomas Williams, Colin Kelley
//
// Permission to use, copy, and distribute this software and its
// documentation for any purpose with or without fee is hereby granted,
// provided that the above copyright notice appear in all copies and
// that both that copyright notice and this permission notice appear
// in supporting documentation.
//
// Permission to modify the software is granted, but not the right to
// distribute the complete modified source code.  Modifications are to
// be distributed as patches to the released version.  Permission to
// distribute binaries produced by compiling modified sources is granted,
// provided you
//    1. distribute the corresponding source modifications from the
//       released version in the form of a patch file along with the binaries,
//    2. add special version identification to distinguish your version
//       in addition to the base release version number,
//    3. provide your name and address as the primary contact for the
//       support of your modified version, and
//    4. retain our contact information in regard to use of the base
//       software.
// Permission to distribute the released version of the source code along
// with corresponding source modifications in the form of a patch file is
// granted with same provisions 2 through 4 for binary distributions.
//
// This software is provided "as is" without express or implied warranty
// to the extent permitted by applicable law.

// This Javascript port of gnuplot 4.6.3 [1] has been generated using
// Emscripten [2].  This port has been made possible by Christian Huettig [3],
// whose changes to gnuplot's source files can be found below [4] in
// accordance to gnuplot's copyright.
//
// [1] http://www.gnuplot.info/
// [2] https://github.com/kripken/emscripten/
// [3] https://github.com/chhu/gnuplot-JS
// [4] Patch to gnuplot 4.6.3
// --- gnuplot-4.6.3/src/axis.c 2012-11-08 18:13:08.000000000 +0100
// +++ gnuplot-4.6.3_mod/src/axis.c     2013-05-11 11:08:08.791587160 +0200
// @@ -467,8 +467,9 @@ copy_or_invent_formatstring(AXIS_INDEX a
//             int precision = (ceil(-log10(fabs(axmax-axmin))));
//             if ((axmin*axmax > 0) && precision > 4)
//                 sprintf(ticfmt[axis],"%%.%df", (precision>14) ? 14 : precision);
// +           else
// +               strcpy(ticfmt[axis], "%g");
//         }
// -
//         return ticfmt[axis];
//     }

var Module = {
    'noInitialRun': true,
    print: function(text) {
        self.postMessage({'transaction': -1, 'content': text});
    },
    printErr: function(text) {
        self.postMessage({'transaction': -2, 'content': text});
    },
};
function gnuplot_create() {
// Note: For maximum-speed code, see "Optimizing Code" on the Emscripten wiki, https://github.com/kripken/emscripten/wiki/Optimizing-Code
// Note: Some Emscripten settings may limit the speed of the generated code.
try {
  this['Module'] = Module;
  Module.test;
} catch(e) {
  this['Module'] = Module = {};
}
// The environment setup code below is customized to use Module.
// *** Environment setup code ***
var ENVIRONMENT_IS_NODE = typeof process === 'object' && typeof require === 'function';
var ENVIRONMENT_IS_WEB = typeof window === 'object';
var ENVIRONMENT_IS_WORKER = typeof importScripts === 'function';
var ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER;
if (typeof module === "object") {
  module.exports = Module;
}
if (ENVIRONMENT_IS_NODE) {
  // Expose functionality in the same simple way that the shells work
  // Note that we pollute the global namespace here, otherwise we break in node
  Module['print'] = function(x) {
    process['stdout'].write(x + '\n');
  };
  Module['printErr'] = function(x) {
    process['stderr'].write(x + '\n');
  };
  var nodeFS = require('fs');
  var nodePath = require('path');
  Module['read'] = function(filename, binary) {
    filename = nodePath['normalize'](filename);
    var ret = nodeFS['readFileSync'](filename);
    // The path is absolute if the normalized version is the same as the resolved.
    if (!ret && filename != nodePath['resolve'](filename)) {
      filename = path.join(__dirname, '..', 'src', filename);
      ret = nodeFS['readFileSync'](filename);
    }
    if (ret && !binary) ret = ret.toString();
    return ret;
  };
  Module['readBinary'] = function(filename) { return Module['read'](filename, true) };
  Module['load'] = function(f) {
    globalEval(read(f));
  };
  if (!Module['arguments']) {
    Module['arguments'] = process['argv'].slice(2);
  }
}
if (ENVIRONMENT_IS_SHELL) {
  Module['print'] = print;
  if (typeof printErr != 'undefined') Module['printErr'] = printErr; // not present in v8 or older sm
  Module['read'] = read;
  Module['readBinary'] = function(f) {
    return read(f, 'binary');
  };
  if (!Module['arguments']) {
    if (typeof scriptArgs != 'undefined') {
      Module['arguments'] = scriptArgs;
    } else if (typeof arguments != 'undefined') {
      Module['arguments'] = arguments;
    }
  }
}
if (ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_WORKER) {
  if (!Module['print']) {
    Module['print'] = function(x) {
      console.log(x);
    };
  }
  if (!Module['printErr']) {
    Module['printErr'] = function(x) {
      console.log(x);
    };
  }
}
if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
  Module['read'] = function(url) {
    var xhr = new XMLHttpRequest();
    xhr.open('GET', url, false);
    xhr.send(null);
    return xhr.responseText;
  };
  if (!Module['arguments']) {
    if (typeof arguments != 'undefined') {
      Module['arguments'] = arguments;
    }
  }
}
if (ENVIRONMENT_IS_WORKER) {
  // We can do very little here...
  var TRY_USE_DUMP = false;
  if (!Module['print']) {
    Module['print'] = (TRY_USE_DUMP && (typeof(dump) !== "undefined") ? (function(x) {
      dump(x);
    }) : (function(x) {
      // self.postMessage(x); // enable this if you want stdout to be sent as messages
    }));
  }
  Module['load'] = importScripts;
}
if (!ENVIRONMENT_IS_WORKER && !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_SHELL) {
  // Unreachable because SHELL is dependent on the others
  throw 'Unknown runtime environment. Where are we?';
}
function globalEval(x) {
  eval.call(null, x);
}
if (!Module['load'] == 'undefined' && Module['read']) {
  Module['load'] = function(f) {
    globalEval(Module['read'](f));
  };
}
if (!Module['print']) {
  Module['print'] = function(){};
}
if (!Module['printErr']) {
  Module['printErr'] = Module['print'];
}
if (!Module['arguments']) {
  Module['arguments'] = [];
}
// *** Environment setup code ***
// Closure helpers
Module.print = Module['print'];
Module.printErr = Module['printErr'];
// Callbacks
if (!Module['preRun']) Module['preRun'] = [];
if (!Module['postRun']) Module['postRun'] = [];
// === Auto-generated preamble library stuff ===
//========================================
// Runtime code shared with compiler
//========================================
var Runtime = {
  stackSave: function () {
    return STACKTOP;
  },
  stackRestore: function (stackTop) {
    STACKTOP = stackTop;
  },
  forceAlign: function (target, quantum) {
    quantum = quantum || 4;
    if (quantum == 1) return target;
    if (isNumber(target) && isNumber(quantum)) {
      return Math.ceil(target/quantum)*quantum;
    } else if (isNumber(quantum) && isPowerOfTwo(quantum)) {
      var logg = log2(quantum);
      return '((((' +target + ')+' + (quantum-1) + ')>>' + logg + ')<<' + logg + ')';
    }
    return 'Math.ceil((' + target + ')/' + quantum + ')*' + quantum;
  },
  isNumberType: function (type) {
    return type in Runtime.INT_TYPES || type in Runtime.FLOAT_TYPES;
  },
  isPointerType: function isPointerType(type) {
  return type[type.length-1] == '*';
},
  isStructType: function isStructType(type) {
  if (isPointerType(type)) return false;
  if (isArrayType(type)) return true;
  if (/<?{ ?[^}]* ?}>?/.test(type)) return true; // { i32, i8 } etc. - anonymous struct types
  // See comment in isStructPointerType()
  return type[0] == '%';
},
  INT_TYPES: {"i1":0,"i8":0,"i16":0,"i32":0,"i64":0},
  FLOAT_TYPES: {"float":0,"double":0},
  or64: function (x, y) {
    var l = (x | 0) | (y | 0);
    var h = (Math.round(x / 4294967296) | Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  and64: function (x, y) {
    var l = (x | 0) & (y | 0);
    var h = (Math.round(x / 4294967296) & Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  xor64: function (x, y) {
    var l = (x | 0) ^ (y | 0);
    var h = (Math.round(x / 4294967296) ^ Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  getNativeTypeSize: function (type, quantumSize) {
    if (Runtime.QUANTUM_SIZE == 1) return 1;
    var size = {
      '%i1': 1,
      '%i8': 1,
      '%i16': 2,
      '%i32': 4,
      '%i64': 8,
      "%float": 4,
      "%double": 8
    }['%'+type]; // add '%' since float and double confuse Closure compiler as keys, and also spidermonkey as a compiler will remove 's from '_i8' etc
    if (!size) {
      if (type.charAt(type.length-1) == '*') {
        size = Runtime.QUANTUM_SIZE; // A pointer
      } else if (type[0] == 'i') {
        var bits = parseInt(type.substr(1));
        assert(bits % 8 == 0);
        size = bits/8;
      }
    }
    return size;
  },
  getNativeFieldSize: function (type) {
    return Math.max(Runtime.getNativeTypeSize(type), Runtime.QUANTUM_SIZE);
  },
  dedup: function dedup(items, ident) {
  var seen = {};
  if (ident) {
    return items.filter(function(item) {
      if (seen[item[ident]]) return false;
      seen[item[ident]] = true;
      return true;
    });
  } else {
    return items.filter(function(item) {
      if (seen[item]) return false;
      seen[item] = true;
      return true;
    });
  }
},
  set: function set() {
  var args = typeof arguments[0] === 'object' ? arguments[0] : arguments;
  var ret = {};
  for (var i = 0; i < args.length; i++) {
    ret[args[i]] = 0;
  }
  return ret;
},
  STACK_ALIGN: 8,
  getAlignSize: function (type, size, vararg) {
    // we align i64s and doubles on 64-bit boundaries, unlike x86
    if (type == 'i64' || type == 'double' || vararg) return 8;
    if (!type) return Math.min(size, 8); // align structures internally to 64 bits
    return Math.min(size || (type ? Runtime.getNativeFieldSize(type) : 0), Runtime.QUANTUM_SIZE);
  },
  calculateStructAlignment: function calculateStructAlignment(type) {
    type.flatSize = 0;
    type.alignSize = 0;
    var diffs = [];
    var prev = -1;
    type.flatIndexes = type.fields.map(function(field) {
      var size, alignSize;
      if (Runtime.isNumberType(field) || Runtime.isPointerType(field)) {
        size = Runtime.getNativeTypeSize(field); // pack char; char; in structs, also char[X]s.
        alignSize = Runtime.getAlignSize(field, size);
      } else if (Runtime.isStructType(field)) {
        size = Types.types[field].flatSize;
        alignSize = Runtime.getAlignSize(null, Types.types[field].alignSize);
      } else if (field[0] == 'b') {
        // bN, large number field, like a [N x i8]
        size = field.substr(1)|0;
        alignSize = 1;
      } else {
        throw 'Unclear type in struct: ' + field + ', in ' + type.name_ + ' :: ' + dump(Types.types[type.name_]);
      }
      if (type.packed) alignSize = 1;
      type.alignSize = Math.max(type.alignSize, alignSize);
      var curr = Runtime.alignMemory(type.flatSize, alignSize); // if necessary, place this on aligned memory
      type.flatSize = curr + size;
      if (prev >= 0) {
        diffs.push(curr-prev);
      }
      prev = curr;
      return curr;
    });
    type.flatSize = Runtime.alignMemory(type.flatSize, type.alignSize);
    if (diffs.length == 0) {
      type.flatFactor = type.flatSize;
    } else if (Runtime.dedup(diffs).length == 1) {
      type.flatFactor = diffs[0];
    }
    type.needsFlattening = (type.flatFactor != 1);
    return type.flatIndexes;
  },
  generateStructInfo: function (struct, typeName, offset) {
    var type, alignment;
    if (typeName) {
      offset = offset || 0;
      type = (typeof Types === 'undefined' ? Runtime.typeInfo : Types.types)[typeName];
      if (!type) return null;
      if (type.fields.length != struct.length) {
        printErr('Number of named fields must match the type for ' + typeName + ': possibly duplicate struct names. Cannot return structInfo');
        return null;
      }
      alignment = type.flatIndexes;
    } else {
      var type = { fields: struct.map(function(item) { return item[0] }) };
      alignment = Runtime.calculateStructAlignment(type);
    }
    var ret = {
      __size__: type.flatSize
    };
    if (typeName) {
      struct.forEach(function(item, i) {
        if (typeof item === 'string') {
          ret[item] = alignment[i] + offset;
        } else {
          // embedded struct
          var key;
          for (var k in item) key = k;
          ret[key] = Runtime.generateStructInfo(item[key], type.fields[i], alignment[i]);
        }
      });
    } else {
      struct.forEach(function(item, i) {
        ret[item[1]] = alignment[i];
      });
    }
    return ret;
  },
  dynCall: function (sig, ptr, args) {
    if (args && args.length) {
      if (!args.splice) args = Array.prototype.slice.call(args);
      args.splice(0, 0, ptr);
      return Module['dynCall_' + sig].apply(null, args);
    } else {
      return Module['dynCall_' + sig].call(null, ptr);
    }
  },
  functionPointers: [],
  addFunction: function (func) {
    for (var i = 0; i < Runtime.functionPointers.length; i++) {
      if (!Runtime.functionPointers[i]) {
        Runtime.functionPointers[i] = func;
        return 2 + 2*i;
      }
    }
    throw 'Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS.';
  },
  removeFunction: function (index) {
    Runtime.functionPointers[(index-2)/2] = null;
  },
  warnOnce: function (text) {
    if (!Runtime.warnOnce.shown) Runtime.warnOnce.shown = {};
    if (!Runtime.warnOnce.shown[text]) {
      Runtime.warnOnce.shown[text] = 1;
      Module.printErr(text);
    }
  },
  funcWrappers: {},
  getFuncWrapper: function (func, sig) {
    assert(sig);
    if (!Runtime.funcWrappers[func]) {
      Runtime.funcWrappers[func] = function() {
        return Runtime.dynCall(sig, func, arguments);
      };
    }
    return Runtime.funcWrappers[func];
  },
  UTF8Processor: function () {
    var buffer = [];
    var needed = 0;
    this.processCChar = function (code) {
      code = code & 0xff;
      if (needed) {
        buffer.push(code);
        needed--;
      }
      if (buffer.length == 0) {
        if (code < 128) return String.fromCharCode(code);
        buffer.push(code);
        if (code > 191 && code < 224) {
          needed = 1;
        } else {
          needed = 2;
        }
        return '';
      }
      if (needed > 0) return '';
      var c1 = buffer[0];
      var c2 = buffer[1];
      var c3 = buffer[2];
      var ret;
      if (c1 > 191 && c1 < 224) {
        ret = String.fromCharCode(((c1 & 31) << 6) | (c2 & 63));
      } else {
        ret = String.fromCharCode(((c1 & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
      }
      buffer.length = 0;
      return ret;
    }
    this.processJSString = function(string) {
      string = unescape(encodeURIComponent(string));
      var ret = [];
      for (var i = 0; i < string.length; i++) {
        ret.push(string.charCodeAt(i));
      }
      return ret;
    }
  },
  stackAlloc: function (size) { var ret = STACKTOP;STACKTOP = (STACKTOP + size)|0;STACKTOP = ((((STACKTOP)+7)>>3)<<3); return ret; },
  staticAlloc: function (size) { var ret = STATICTOP;STATICTOP = (STATICTOP + size)|0;STATICTOP = ((((STATICTOP)+7)>>3)<<3); return ret; },
  dynamicAlloc: function (size) { var ret = DYNAMICTOP;DYNAMICTOP = (DYNAMICTOP + size)|0;DYNAMICTOP = ((((DYNAMICTOP)+7)>>3)<<3); if (DYNAMICTOP >= TOTAL_MEMORY) enlargeMemory();; return ret; },
  alignMemory: function (size,quantum) { var ret = size = Math.ceil((size)/(quantum ? quantum : 8))*(quantum ? quantum : 8); return ret; },
  makeBigInt: function (low,high,unsigned) { var ret = (unsigned ? ((+(((low)>>>(0))))+((+(((high)>>>(0))))*(+(4294967296)))) : ((+(((low)>>>(0))))+((+(((high)|(0))))*(+(4294967296))))); return ret; },
  GLOBAL_BASE: 8,
  QUANTUM_SIZE: 4,
  __dummy__: 0
}
//========================================
// Runtime essentials
//========================================
var __THREW__ = 0; // Used in checking for thrown exceptions.
var ABORT = false; // whether we are quitting the application. no code should run after this. set in exit() and abort()
var undef = 0;
// tempInt is used for 32-bit signed values or smaller. tempBigInt is used
// for 32-bit unsigned values or more than 32 bits. TODO: audit all uses of tempInt
var tempValue, tempInt, tempBigInt, tempInt2, tempBigInt2, tempPair, tempBigIntI, tempBigIntR, tempBigIntS, tempBigIntP, tempBigIntD;
var tempI64, tempI64b;
var tempRet0, tempRet1, tempRet2, tempRet3, tempRet4, tempRet5, tempRet6, tempRet7, tempRet8, tempRet9;
function abort(text) {
  Module.print(text + ':\n' + (new Error).stack);
  ABORT = true;
  throw "Assertion: " + text;
}
function assert(condition, text) {
  if (!condition) {
    abort('Assertion failed: ' + text);
  }
}
var globalScope = this;
// C calling interface. A convenient way to call C functions (in C files, or
// defined with extern "C").
//
// Note: LLVM optimizations can inline and remove functions, after which you will not be
//       able to call them. Closure can also do so. To avoid that, add your function to
//       the exports using something like
//
//         -s EXPORTED_FUNCTIONS='["_main", "_myfunc"]'
//
// @param ident      The name of the C function (note that C++ functions will be name-mangled - use extern "C")
// @param returnType The return type of the function, one of the JS types 'number', 'string' or 'array' (use 'number' for any C pointer, and
//                   'array' for JavaScript arrays and typed arrays).
// @param argTypes   An array of the types of arguments for the function (if there are no arguments, this can be omitted). Types are as in returnType,
//                   except that 'array' is not possible (there is no way for us to know the length of the array)
// @param args       An array of the arguments to the function, as native JS values (as in returnType)
//                   Note that string arguments will be stored on the stack (the JS string will become a C string on the stack).
// @return           The return value, as a native JS value (as in returnType)
function ccall(ident, returnType, argTypes, args) {
  return ccallFunc(getCFunc(ident), returnType, argTypes, args);
}
Module["ccall"] = ccall;
// Returns the C function with a specified identifier (for C++, you need to do manual name mangling)
function getCFunc(ident) {
  try {
    var func = globalScope['Module']['_' + ident]; // closure exported function
    if (!func) func = eval('_' + ident); // explicit lookup
  } catch(e) {
  }
  assert(func, 'Cannot call unknown function ' + ident + ' (perhaps LLVM optimizations or closure removed it?)');
  return func;
}
// Internal function that does a C call using a function, not an identifier
function ccallFunc(func, returnType, argTypes, args) {
  var stack = 0;
  function toC(value, type) {
    if (type == 'string') {
      if (value === null || value === undefined || value === 0) return 0; // null string
      if (!stack) stack = Runtime.stackSave();
      var ret = Runtime.stackAlloc(value.length+1);
      writeStringToMemory(value, ret);
      return ret;
    } else if (type == 'array') {
      if (!stack) stack = Runtime.stackSave();
      var ret = Runtime.stackAlloc(value.length);
      writeArrayToMemory(value, ret);
      return ret;
    }
    return value;
  }
  function fromC(value, type) {
    if (type == 'string') {
      return Pointer_stringify(value);
    }
    assert(type != 'array');
    return value;
  }
  var i = 0;
  var cArgs = args ? args.map(function(arg) {
    return toC(arg, argTypes[i++]);
  }) : [];
  var ret = fromC(func.apply(null, cArgs), returnType);
  if (stack) Runtime.stackRestore(stack);
  return ret;
}
// Returns a native JS wrapper for a C function. This is similar to ccall, but
// returns a function you can call repeatedly in a normal way. For example:
//
//   var my_function = cwrap('my_c_function', 'number', ['number', 'number']);
//   alert(my_function(5, 22));
//   alert(my_function(99, 12));
//
function cwrap(ident, returnType, argTypes) {
  var func = getCFunc(ident);
  return function() {
    return ccallFunc(func, returnType, argTypes, Array.prototype.slice.call(arguments));
  }
}
Module["cwrap"] = cwrap;
// Sets a value in memory in a dynamic way at run-time. Uses the
// type data. This is the same as makeSetValue, except that
// makeSetValue is done at compile-time and generates the needed
// code then, whereas this function picks the right code at
// run-time.
// Note that setValue and getValue only do *aligned* writes and reads!
// Note that ccall uses JS types as for defining types, while setValue and
// getValue need LLVM types ('i8', 'i32') - this is a lower-level operation
function setValue(ptr, value, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': HEAP8[(ptr)]=value; break;
      case 'i8': HEAP8[(ptr)]=value; break;
      case 'i16': HEAP16[((ptr)>>1)]=value; break;
      case 'i32': HEAP32[((ptr)>>2)]=value; break;
      case 'i64': (tempI64 = [value>>>0,Math.min(Math.floor((value)/(+(4294967296))), (+(4294967295)))>>>0],HEAP32[((ptr)>>2)]=tempI64[0],HEAP32[(((ptr)+(4))>>2)]=tempI64[1]); break;
      case 'float': HEAPF32[((ptr)>>2)]=value; break;
      case 'double': HEAPF64[((ptr)>>3)]=value; break;
      default: abort('invalid type for setValue: ' + type);
    }
}
Module['setValue'] = setValue;
// Parallel to setValue.
function getValue(ptr, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': return HEAP8[(ptr)];
      case 'i8': return HEAP8[(ptr)];
      case 'i16': return HEAP16[((ptr)>>1)];
      case 'i32': return HEAP32[((ptr)>>2)];
      case 'i64': return HEAP32[((ptr)>>2)];
      case 'float': return HEAPF32[((ptr)>>2)];
      case 'double': return HEAPF64[((ptr)>>3)];
      default: abort('invalid type for setValue: ' + type);
    }
  return null;
}
Module['getValue'] = getValue;
var ALLOC_NORMAL = 0; // Tries to use _malloc()
var ALLOC_STACK = 1; // Lives for the duration of the current function call
var ALLOC_STATIC = 2; // Cannot be freed
var ALLOC_DYNAMIC = 3; // Cannot be freed except through sbrk
var ALLOC_NONE = 4; // Do not allocate
Module['ALLOC_NORMAL'] = ALLOC_NORMAL;
Module['ALLOC_STACK'] = ALLOC_STACK;
Module['ALLOC_STATIC'] = ALLOC_STATIC;
Module['ALLOC_DYNAMIC'] = ALLOC_DYNAMIC;
Module['ALLOC_NONE'] = ALLOC_NONE;
// allocate(): This is for internal use. You can use it yourself as well, but the interface
//             is a little tricky (see docs right below). The reason is that it is optimized
//             for multiple syntaxes to save space in generated code. So you should
//             normally not use allocate(), and instead allocate memory using _malloc(),
//             initialize it with setValue(), and so forth.
// @slab: An array of data, or a number. If a number, then the size of the block to allocate,
//        in *bytes* (note that this is sometimes confusing: the next parameter does not
//        affect this!)
// @types: Either an array of types, one for each byte (or 0 if no type at that position),
//         or a single type which is used for the entire block. This only matters if there
//         is initial data - if @slab is a number, then this does not matter at all and is
//         ignored.
// @allocator: How to allocate memory, see ALLOC_*
function allocate(slab, types, allocator, ptr) {
  var zeroinit, size;
  if (typeof slab === 'number') {
    zeroinit = true;
    size = slab;
  } else {
    zeroinit = false;
    size = slab.length;
  }
  var singleType = typeof types === 'string' ? types : null;
  var ret;
  if (allocator == ALLOC_NONE) {
    ret = ptr;
  } else {
    ret = [_malloc, Runtime.stackAlloc, Runtime.staticAlloc, Runtime.dynamicAlloc][allocator === undefined ? ALLOC_STATIC : allocator](Math.max(size, singleType ? 1 : types.length));
  }
  if (zeroinit) {
    var ptr = ret, stop;
    assert((ret & 3) == 0);
    stop = ret + (size & ~3);
    for (; ptr < stop; ptr += 4) {
      HEAP32[((ptr)>>2)]=0;
    }
    stop = ret + size;
    while (ptr < stop) {
      HEAP8[((ptr++)|0)]=0;
    }
    return ret;
  }
  if (singleType === 'i8') {
    if (slab.subarray || slab.slice) {
      HEAPU8.set(slab, ret);
    } else {
      HEAPU8.set(new Uint8Array(slab), ret);
    }
    return ret;
  }
  var i = 0, type, typeSize, previousType;
  while (i < size) {
    var curr = slab[i];
    if (typeof curr === 'function') {
      curr = Runtime.getFunctionIndex(curr);
    }
    type = singleType || types[i];
    if (type === 0) {
      i++;
      continue;
    }
    if (type == 'i64') type = 'i32'; // special case: we have one i32 here, and one i32 later
    setValue(ret+i, curr, type);
    // no need to look up size unless type changes, so cache it
    if (previousType !== type) {
      typeSize = Runtime.getNativeTypeSize(type);
      previousType = type;
    }
    i += typeSize;
  }
  return ret;
}
Module['allocate'] = allocate;
function Pointer_stringify(ptr, /* optional */ length) {
  // Find the length, and check for UTF while doing so
  var hasUtf = false;
  var t;
  var i = 0;
  while (1) {
    t = HEAPU8[(((ptr)+(i))|0)];
    if (t >= 128) hasUtf = true;
    else if (t == 0 && !length) break;
    i++;
    if (length && i == length) break;
  }
  if (!length) length = i;
  var ret = '';
  if (!hasUtf) {
    var MAX_CHUNK = 1024; // split up into chunks, because .apply on a huge string can overflow the stack
    var curr;
    while (length > 0) {
      curr = String.fromCharCode.apply(String, HEAPU8.subarray(ptr, ptr + Math.min(length, MAX_CHUNK)));
      ret = ret ? ret + curr : curr;
      ptr += MAX_CHUNK;
      length -= MAX_CHUNK;
    }
    return ret;
  }
  var utf8 = new Runtime.UTF8Processor();
  for (i = 0; i < length; i++) {
    t = HEAPU8[(((ptr)+(i))|0)];
    ret += utf8.processCChar(t);
  }
  return ret;
}
Module['Pointer_stringify'] = Pointer_stringify;
// Memory management
var PAGE_SIZE = 4096;
function alignMemoryPage(x) {
  return ((x+4095)>>12)<<12;
}
var HEAP;
var HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64;
var STATIC_BASE = 0, STATICTOP = 0, staticSealed = false; // static area
var STACK_BASE = 0, STACKTOP = 0, STACK_MAX = 0; // stack area
var DYNAMIC_BASE = 0, DYNAMICTOP = 0; // dynamic area handled by sbrk
function enlargeMemory() {
  abort('Cannot enlarge memory arrays in asm.js. Either (1) compile with -s TOTAL_MEMORY=X with X higher than the current value, or (2) set Module.TOTAL_MEMORY before the program runs.');
}
var TOTAL_STACK = Module['TOTAL_STACK'] || 5242880;
var TOTAL_MEMORY = Module['TOTAL_MEMORY'] || 16777216;
var FAST_MEMORY = Module['FAST_MEMORY'] || 2097152;
// Initialize the runtime's memory
// check for full engine support (use string 'subarray' to avoid closure compiler confusion)
assert(!!Int32Array && !!Float64Array && !!(new Int32Array(1)['subarray']) && !!(new Int32Array(1)['set']),
       'Cannot fallback to non-typed array case: Code is too specialized');
var buffer = new ArrayBuffer(TOTAL_MEMORY);
HEAP8 = new Int8Array(buffer);
HEAP16 = new Int16Array(buffer);
HEAP32 = new Int32Array(buffer);
HEAPU8 = new Uint8Array(buffer);
HEAPU16 = new Uint16Array(buffer);
HEAPU32 = new Uint32Array(buffer);
HEAPF32 = new Float32Array(buffer);
HEAPF64 = new Float64Array(buffer);
// Endianness check (note: assumes compiler arch was little-endian)
HEAP32[0] = 255;
assert(HEAPU8[0] === 255 && HEAPU8[3] === 0, 'Typed arrays 2 must be run on a little-endian system');
Module['HEAP'] = HEAP;
Module['HEAP8'] = HEAP8;
Module['HEAP16'] = HEAP16;
Module['HEAP32'] = HEAP32;
Module['HEAPU8'] = HEAPU8;
Module['HEAPU16'] = HEAPU16;
Module['HEAPU32'] = HEAPU32;
Module['HEAPF32'] = HEAPF32;
Module['HEAPF64'] = HEAPF64;
function callRuntimeCallbacks(callbacks) {
  while(callbacks.length > 0) {
    var callback = callbacks.shift();
    if (typeof callback == 'function') {
      callback();
      continue;
    }
    var func = callback.func;
    if (typeof func === 'number') {
      if (callback.arg === undefined) {
        Runtime.dynCall('v', func);
      } else {
        Runtime.dynCall('vi', func, [callback.arg]);
      }
    } else {
      func(callback.arg === undefined ? null : callback.arg);
    }
  }
}
var __ATINIT__ = []; // functions called during startup
var __ATMAIN__ = []; // functions called when main() is to be run
var __ATEXIT__ = []; // functions called during shutdown
var runtimeInitialized = false;
function ensureInitRuntime() {
  if (runtimeInitialized) return;
  runtimeInitialized = true;
  callRuntimeCallbacks(__ATINIT__);
}
function preMain() {
  callRuntimeCallbacks(__ATMAIN__);
}
function exitRuntime() {
  callRuntimeCallbacks(__ATEXIT__);
}
// Tools
// This processes a JS string into a C-line array of numbers, 0-terminated.
// For LLVM-originating strings, see parser.js:parseLLVMString function
function intArrayFromString(stringy, dontAddNull, length /* optional */) {
  var ret = (new Runtime.UTF8Processor()).processJSString(stringy);
  if (length) {
    ret.length = length;
  }
  if (!dontAddNull) {
    ret.push(0);
  }
  return ret;
}
Module['intArrayFromString'] = intArrayFromString;
function intArrayToString(array) {
  var ret = [];
  for (var i = 0; i < array.length; i++) {
    var chr = array[i];
    if (chr > 0xFF) {
      chr &= 0xFF;
    }
    ret.push(String.fromCharCode(chr));
  }
  return ret.join('');
}
Module['intArrayToString'] = intArrayToString;
// Write a Javascript array to somewhere in the heap
function writeStringToMemory(string, buffer, dontAddNull) {
  var array = intArrayFromString(string, dontAddNull);
  var i = 0;
  while (i < array.length) {
    var chr = array[i];
    HEAP8[(((buffer)+(i))|0)]=chr
    i = i + 1;
  }
}
Module['writeStringToMemory'] = writeStringToMemory;
function writeArrayToMemory(array, buffer) {
  for (var i = 0; i < array.length; i++) {
    HEAP8[(((buffer)+(i))|0)]=array[i];
  }
}
Module['writeArrayToMemory'] = writeArrayToMemory;
function unSign(value, bits, ignore, sig) {
  if (value >= 0) {
    return value;
  }
  return bits <= 32 ? 2*Math.abs(1 << (bits-1)) + value // Need some trickery, since if bits == 32, we are right at the limit of the bits JS uses in bitshifts
                    : Math.pow(2, bits)         + value;
}
function reSign(value, bits, ignore, sig) {
  if (value <= 0) {
    return value;
  }
  var half = bits <= 32 ? Math.abs(1 << (bits-1)) // abs is needed if bits == 32
                        : Math.pow(2, bits-1);
  if (value >= half && (bits <= 32 || value > half)) { // for huge values, we can hit the precision limit and always get true here. so don't do that
                                                       // but, in general there is no perfect solution here. With 64-bit ints, we get rounding and errors
                                                       // TODO: In i64 mode 1, resign the two parts separately and safely
    value = -2*half + value; // Cannot bitshift half, as it may be at the limit of the bits JS uses in bitshifts
  }
  return value;
}
if (!Math['imul']) Math['imul'] = function(a, b) {
  var ah  = a >>> 16;
  var al = a & 0xffff;
  var bh  = b >>> 16;
  var bl = b & 0xffff;
  return (al*bl + ((ah*bl + al*bh) << 16))|0;
};
// A counter of dependencies for calling run(). If we need to
// do asynchronous work before running, increment this and
// decrement it. Incrementing must happen in a place like
// PRE_RUN_ADDITIONS (used by emcc to add file preloading).
// Note that you can add dependencies in preRun, even though
// it happens right before run - run will be postponed until
// the dependencies are met.
var runDependencies = 0;
var runDependencyTracking = {};
var calledInit = false, calledRun = false;
var runDependencyWatcher = null;
function addRunDependency(id) {
  runDependencies++;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (id) {
    assert(!runDependencyTracking[id]);
    runDependencyTracking[id] = 1;
  } else {
    Module.printErr('warning: run dependency added without ID');
  }
}
Module['addRunDependency'] = addRunDependency;
function removeRunDependency(id) {
  runDependencies--;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (id) {
    assert(runDependencyTracking[id]);
    delete runDependencyTracking[id];
  } else {
    Module.printErr('warning: run dependency removed without ID');
  }
  if (runDependencies == 0) {
    if (runDependencyWatcher !== null) {
      clearInterval(runDependencyWatcher);
      runDependencyWatcher = null;
    }
    // If run has never been called, and we should call run (INVOKE_RUN is true, and Module.noInitialRun is not false)
    if (!calledRun && shouldRunNow) run();
  }
}
Module['removeRunDependency'] = removeRunDependency;
Module["preloadedImages"] = {}; // maps url to image data
Module["preloadedAudios"] = {}; // maps url to audio data
function addPreRun(func) {
  if (!Module['preRun']) Module['preRun'] = [];
  else if (typeof Module['preRun'] == 'function') Module['preRun'] = [Module['preRun']];
  Module['preRun'].push(func);
}
var awaitingMemoryInitializer = false;
function loadMemoryInitializer(filename) {
  function applyData(data) {
    HEAPU8.set(data, STATIC_BASE);
    runPostSets();
  }
  // always do this asynchronously, to keep shell and web as similar as possible
  addPreRun(function() {
    if (ENVIRONMENT_IS_NODE || ENVIRONMENT_IS_SHELL) {
      applyData(Module['readBinary'](filename));
    } else {
      Browser.asyncLoad(filename, function(data) {
        applyData(data);
      }, function(data) {
        throw 'could not load memory initializer ' + filename;
      });
    }
  });
  awaitingMemoryInitializer = false;
}
// === Body ===
STATIC_BASE = 8;
STATICTOP = STATIC_BASE + 243440;
var _stdout;
var _stdin;
var _stderr;
var _stdout = _stdout=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
var _stdin = _stdin=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
var _stderr = _stderr=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
/* memory initializer */ allocate([0,0,128,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,90,71,110,117,112,108,111,116,80,0,0,0,0,0,0,0,90,71,110,117,112,108,111,116,68,0,0,0,0,0,0,0,90,71,110,117,112,108,111,116,0,0,0,0,0,0,0,0,58,140,48,226,142,121,69,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,139,1,0,240,84,3,0,80,126,1,0,0,0,0,0,80,131,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,134,1,0,248,132,1,0,232,123,1,0,0,0,0,0,224,128,1,0,0,0,0,0,0,85,1,0,8,0,0,0,208,80,1,0,9,0,0,0,192,76,1,0,10,0,0,0,64,73,1,0,13,0,0,0,240,70,1,0,27,0,0,0,40,67,1,0,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,244,1,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,1,0,0,0,1,0,0,0,100,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,252,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,252,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,3,0,0,0,1,0,0,0,100,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,252,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,252,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,154,153,153,153,153,153,169,63,184,30,133,235,81,184,158,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,2,0,0,0,1,0,0,0,100,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,252,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,252,255,255,255,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,20,174,71,225,122,148,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,118,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,193,1,0,16,189,1,0,16,220,1,0,192,222,1,0,0,0,0,0,96,133,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,253,1,0,0,0,0,0,160,149,1,0,32,148,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,3,0,0,0,5,0,0,0,1,0,0,0,20,0,0,0,26,0,0,0,21,0,0,0,27,0,0,0,14,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,26,1,0,0,0,0,0,0,2,0,0,0,94,1,0,0,1,0,0,0,2,0,0,0,88,0,0,0,0,0,0,0,2,0,0,0,26,0,0,0,1,0,0,0,2,0,0,0,58,0,0,0,0,0,0,0,2,0,0,0,48,1,0,0,1,0,0,0,1,0,0,0,96,0,0,0,1,0,0,0,2,0,0,0,96,0,0,0,1,0,0,0,3,0,0,0,96,0,0,0,3,0,0,0,1,0,0,0,96,0,0,0,3,0,0,0,2,0,0,0,96,0,0,0,3,0,0,0,3,0,0,0,96,0,0,0,3,0,0,0,2,0,0,0,26,1,0,0,3,0,0,0,2,0,0,0,88,0,0,0,3,0,0,0,2,0,0,0,58,0,0,0,1,0,0,0,2,0,0,0,134,1,0,0,3,0,0,0,2,0,0,0,134,1,0,0,1,0,0,0,2,0,0,0,140,1,0,0,1,0,0,0,2,0,0,0,8,0,0,0,1,0,0,0,2,0,0,0,38,1,0,0,1,0,0,0,2,0,0,0,54,1,0,0,1,0,0,0,2,0,0,0,94,0,0,0,1,0,0,0,2,0,0,0,182,0,0,0,3,0,0,0,2,0,0,0,140,1,0,0,1,0,0,0,2,0,0,0,14,0,0,0,1,0,0,0,2,0,0,0,16,0,0,0,1,0,0,0,2,0,0,0,24,1,0,0,1,0,0,0,2,0,0,0,132,0,0,0,1,0,0,0,2,0,0,0,118,1,0,0,1,0,0,0,2,0,0,0,108,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,2,0,0,0,1,0,0,0,4,0,0,0,3,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,2,0,0,0,2,0,0,0,4,0,0,0,3,0,0,0,2,0,0,0,4,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,3,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,4,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,153,153,153,153,153,185,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,93,1,0,8,93,1,0,248,92,1,0,240,92,1,0,208,92,1,0,200,92,1,0,184,92,1,0,160,92,1,0,0,0,0,0,0,0,0,0,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,42,2,0,1,0,0,0,176,34,3,0,2,0,0,0,32,42,2,0,3,0,0,0,0,0,0,0,0,0,0,0,117,110,115,32,112,109,51,100,59,115,101,32,108,109,97,114,103,32,115,99,114,101,32,48,46,48,53,59,115,101,32,114,109,97,114,103,32,115,99,114,101,32,48,46,57,55,53,59,32,115,101,32,98,109,97,114,103,32,115,99,114,101,32,48,46,50,50,59,32,115,101,32,116,109,97,114,103,32,115,99,114,101,32,48,46,56,54,59,115,101,32,103,114,105,100,59,115,101,32,116,105,99,115,32,115,99,97,108,101,32,48,59,32,115,101,32,120,116,105,99,115,32,48,44,48,46,49,59,115,101,32,121,116,105,99,115,32,48,44,48,46,49,59,115,101,32,107,101,121,32,116,111,112,32,114,105,103,104,116,32,97,116,32,115,99,114,101,32,48,46,57,55,53,44,48,46,57,55,53,32,104,111,114,105,122,111,110,116,97,108,32,116,105,116,108,101,32,39,82,44,71,44,66,32,112,114,111,102,105,108,101,115,32,111,102,32,116,104,101,32,99,117,114,114,101,110,116,32,99,111,108,111,114,32,112,97,108,101,116,116,101,39,59,0,0,0,0,0,115,112,108,111,116,32,49,47,48,59,10,10,10,0,0,0,114,101,115,101,116,59,115,101,116,32,109,117,108,116,105,59,117,110,115,32,98,111,114,100,101,114,59,117,110,115,32,107,101,121,59,115,101,116,32,116,105,99,32,105,110,59,117,110,115,32,120,116,105,99,115,59,117,110,115,32,121,116,105,99,115,59,115,101,32,99,98,116,105,99,32,48,44,48,46,49,44,49,32,109,105,114,114,32,102,111,114,109,97,116,32,39,39,59,115,101,32,120,114,91,48,58,49,93,59,115,101,32,121,114,91,48,58,49,93,59,115,101,32,122,114,91,48,58,49,93,59,115,101,32,99,98,114,91,48,58,49,93,59,115,101,32,112,109,51,100,32,109,97,112,59,115,101,116,32,99,111,108,111,114,98,111,120,32,104,111,114,32,117,115,101,114,32,111,114,105,103,32,48,46,48,53,44,48,46,48,50,32,115,105,122,101,32,48,46,57,50,53,44,48,46,49,50,59,0,0,0,0,0,0,0,0,10,10,10,117,110,115,32,109,117,108,116,105,59,10,0,0,248,110,3,0,56,16,3,0,100,0,0,0,100,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,48,1,0,0,190,0,0,0,190,0,0,0,190,0,0,0,2,0,0,0,190,0,0,0,126,0,0,0,126,0,0,0,90,0,0,0,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,13,3,0,128,10,3,0,220,5,0,0,132,3,0,0,45,0,0,0,22,0,0,0,20,0,0,0,20,0,0,0,20,0,0,0,142,1,0,0,158,1,0,0,18,1,0,0,2,0,0,0,120,0,0,0,82,0,0,0,34,0,0,0,174,0,0,0,40,0,0,0,62,0,0,0,158,0,0,0,54,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,9,3,0,176,7,3,0,32,3,0,0,184,1,0,0,20,0,0,0,9,0,0,0,8,0,0,0,6,0,0,0,102,0,0,0,48,0,0,0,218,0,0,0,98,0,0,0,2,0,0,0,12,1,0,0,50,0,0,0,96,0,0,0,158,0,0,0,42,0,0,0,164,0,0,0,124,0,0,0,54,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,6,3,0,176,4,3,0,255,15,0,0,59,12,0,0,71,0,0,0,51,0,0,0,36,0,0,0,36,0,0,0,48,1,0,0,8,0,0,0,104,1,0,0,100,0,0,0,2,0,0,0,52,0,0,0,102,0,0,0,86,0,0,0,38,0,0,0,80,0,0,0,160,0,0,0,124,0,0,0,72,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,2,3,0,96,0,3,0,0,4,0,0,12,3,0,0,25,0,0,0,14,0,0,0,11,0,0,0,11,0,0,0,48,1,0,0,20,1,0,0,40,1,0,0,170,0,0,0,2,0,0,0,172,0,0,0,128,0,0,0,60,0,0,0,106,1,0,0,78,0,0,0,12,0,0,0,124,0,0,0,54,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,253,2,0,160,251,2,0,0,4,0,0,12,3,0,0,25,0,0,0,14,0,0,0,11,0,0,0,11,0,0,0,48,1,0,0,234,0,0,0,50,0,0,0,170,0,0,0,2,0,0,0,172,0,0,0,136,0,0,0,42,0,0,0,40,0,0,0,62,0,0,0,12,0,0,0,124,0,0,0,54,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,245,2,0,64,243,2,0,0,4,0,0,12,3,0,0,25,0,0,0,14,0,0,0,11,0,0,0,11,0,0,0,48,1,0,0,20,1,0,0,40,1,0,0,66,0,0,0,2,0,0,0,6,0,0,0,136,0,0,0,42,0,0,0,40,0,0,0,62,0,0,0,12,0,0,0,124,0,0,0,54,0,0,0,48,0,0,0,152,0,0,0,0,0,0,0,65,0,0,0,66,0,0,0,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,234,2,0,192,220,2,0,112,23,0,0,160,15,0,0,100,0,0,0,80,0,0,0,100,0,0,0,100,0,0,0,206,0,0,0,148,0,0,0,222,0,0,0,116,1,0,0,2,0,0,0,180,1,0,0,100,0,0,0,130,0,0,0,140,0,0,0,118,0,0,0,34,0,0,0,20,0,0,0,70,0,0,0,48,0,0,0,60,0,0,0,30,0,0,0,1,11,0,0,0,0,0,0,0,0,0,0,52,0,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,0,0,0,0,0,0,0,56,0,0,0,98,0,0,0,0,0,0,0,4,0,0,0,120,1,0,0,102,0,0,0,24,0,0,0,130,0,0,0,0,0,0,0,0,0,0,0,128,218,2,0,160,216,2,0,73,127,0,0,182,91,0,0,12,3,0,0,177,1,0,0,153,1,0,0,153,1,0,0,106,0,0,0,150,0,0,0,168,0,0,0,2,0,0,0,2,0,0,0,176,1,0,0,40,0,0,0,106,0,0,0,230,0,0,0,28,0,0,0,96,0,0,0,50,0,0,0,58,0,0,0,48,0,0,0,106,0,0,0,40,0,0,0,4,9,0,0,0,0,0,0,0,0,0,0,50,0,0,0,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,42,1,0,0,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,214,2,0,120,212,2,0,72,23,0,0,32,28,0,0,220,0,0,0,132,0,0,0,90,0,0,0,90,0,0,0,24,0,0,0,28,1,0,0,62,0,0,0,56,1,0,0,2,0,0,0,46,1,0,0,144,0,0,0,54,0,0,0,28,0,0,0,38,0,0,0,138,0,0,0,146,0,0,0,60,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,210,2,0,248,208,2,0,79,0,0,0,24,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,196,0,0,0,40,0,0,0,242,0,0,0,34,1,0,0,2,0,0,0,86,0,0,0,108,0,0,0,18,0,0,0,146,0,0,0,104,0,0,0,12,0,0,0,124,0,0,0,110,0,0,0,42,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,28,0,0,0,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,207,2,0,0,206,2,0,32,28,0,0,192,18,0,0,124,0,0,0,100,0,0,0,120,0,0,0,120,0,0,0,48,1,0,0,126,1,0,0,254,0,0,0,182,0,0,0,2,0,0,0,90,0,0,0,104,0,0,0,124,0,0,0,70,1,0,0,64,0,0,0,8,0,0,0,194,0,0,0,60,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,204,2,0,144,202,2,0,122,105,0,0,28,79,0,0,38,2,0,0,254,0,0,0,168,0,0,0,168,0,0,0,50,1,0,0,246,0,0,0,148,1,0,0,32,0,0,0,2,0,0,0,74,1,0,0,28,0,0,0,48,0,0,0,220,0,0,0,102,0,0,0,36,0,0,0,184,0,0,0,50,0,0,0,48,0,0,0,180,0,0,0,20,0,0,0,4,25,0,0,0,0,0,0,0,0,0,0,32,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,0,0,0,136,0,0,0,54,0,0,0,64,0,0,0,0,0,0,0,8,0,0,0,238,0,0,0,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,199,2,0,232,194,2,0,112,23,0,0,16,14,0,0,125,0,0,0,75,0,0,0,75,0,0,0,75,0,0,0,78,0,0,0,6,1,0,0,178,1,0,0,66,1,0,0,2,0,0,0,56,0,0,0,122,0,0,0,10,0,0,0,128,1,0,0,94,0,0,0,82,0,0,0,94,0,0,0,112,0,0,0,46,0,0,0,0,0,0,0,24,0,0,0,4,1,0,0,0,0,0,0,0,0,0,0,38,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,0,0,0,0,0,0,0,108,1,0,0,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,193,2,0,232,191,2,0,0,2,0,0,134,1,0,0,10,0,0,0,7,0,0,0,5,0,0,0,5,0,0,0,48,1,0,0,192,0,0,0,72,0,0,0,86,1,0,0,2,0,0,0,220,0,0,0,22,0,0,0,16,0,0,0,132,1,0,0,98,0,0,0,118,0,0,0,124,0,0,0,44,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,190,2,0,224,188,2,0,208,2,0,0,104,1,0,0,12,0,0,0,7,0,0,0,8,0,0,0,8,0,0,0,48,1,0,0,250,0,0,0,216,0,0,0,88,1,0,0,2,0,0,0,134,0,0,0,38,0,0,0,46,0,0,0,156,0,0,0,52,0,0,0,28,0,0,0,124,0,0,0,54,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,187,2,0,16,185,2,0,16,39,0,0,76,29,0,0,60,0,0,0,30,0,0,0,107,0,0,0,107,0,0,0,104,0,0,0,8,1,0,0,4,1,0,0,16,1,0,0,2,0,0,0,178,0,0,0,26,0,0,0,4,0,0,0,84,1,0,0,108,0,0,0,22,0,0,0,124,0,0,0,60,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,183,2,0,120,182,2,0,21,177,0,0,148,132,0,0,169,0,0,0,112,0,0,0,106,0,0,0,106,0,0,0,204,0,0,0,110,1,0,0,58,0,0,0,30,1,0,0,2,0,0,0,154,1,0,0,152,0,0,0,92,0,0,0,120,0,0,0,18,0,0,0,2,0,0,0,84,0,0,0,32,0,0,0,48,0,0,0,142,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,181,2,0,88,179,2,0,228,12,0,0,36,9,0,0,60,0,0,0,30,0,0,0,20,0,0,0,20,0,0,0,68,0,0,0,80,1,0,0,88,0,0,0,12,0,0,0,2,0,0,0,70,0,0,0,52,0,0,0,68,0,0,0,168,0,0,0,22,0,0,0,76,0,0,0,168,0,0,0,54,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,178,2,0,168,175,2,0,152,58,0,0,16,39,0,0,66,1,0,0,157,0,0,0,66,0,0,0,66,0,0,0,24,1,0,0,210,0,0,0,64,1,0,0,0,1,0,0,2,0,0,0,198,0,0,0,12,0,0,0,84,0,0,0,18,1,0,0,4,0,0,0,16,0,0,0,80,0,0,0,120,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,174,2,0,152,172,2,0,32,28,0,0,176,19,0,0,140,0,0,0,84,0,0,0,63,0,0,0,63,0,0,0,122,1,0,0,42,0,0,0,42,1,0,0,146,0,0,0,2,0,0,0,162,0,0,0,20,0,0,0,118,0,0,0,242,0,0,0,116,0,0,0,26,0,0,0,154,0,0,0,114,0,0,0,54,0,0,0,90,0,0,0,6,0,0,0,148,29,0,0,0,0,0,0,0,0,0,0,6,0,0,0,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,16,0,0,0,30,1,0,0,8,0,0,0,34,0,0,0,10,0,0,0,132,0,0,0,136,1,0,0,0,1,0,0,86,0,0,0,0,0,0,0,0,0,36,64,248,170,2,0,192,169,2,0,40,35,0,0,112,23,0,0,120,0,0,0,70,0,0,0,70,0,0,0,70,0,0,0,48,1,0,0,228,0,0,0,118,1,0,0,70,1,0,0,2,0,0,0,62,1,0,0,30,0,0,0,56,0,0,0,18,0,0,0,24,0,0,0,12,0,0,0,124,0,0,0,54,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0].concat([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,3,0,64,168,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,172,1,0,0,34,0,0,0,4,0,0,0,156,0,0,0,2,0,0,0,212,0,0,0,74,0,0,0,62,0,0,0,20,0,0,0,68,0,0,0,132,0,0,0,110,0,0,0,122,0,0,0,48,0,0,0,144,0,0,0,10,0,0,0,5,11,0,0,0,0,0,0,0,0,0,0,28,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,0,0,0,180,0,0,0,4,1,0,0,14,0,0,0,0,0,0,0,6,0,0,0,82,0,0,0,194,0,0,0,228,0,0,0,102,1,0,0,0,0,0,0,0,0,36,64,208,165,2,0,48,164,2,0,182,3,0,0,122,2,0,0,18,0,0,0,10,0,0,0,7,0,0,0,7,0,0,0,200,0,0,0,248,0,0,0,18,0,0,0,140,1,0,0,2,0,0,0,152,0,0,0,94,0,0,0,142,0,0,0,180,0,0,0,30,0,0,0,176,0,0,0,148,0,0,0,26,0,0,0,10,0,0,0,204,0,0,0,2,0,0,0,1,9,0,0,0,0,0,0,0,0,0,0,24,0,0,0,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,0,0,0,82,1,0,0,138,0,0,0,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,162,2,0,72,161,2,0,232,3,0,0,232,3,0,0,25,0,0,0,16,0,0,0,18,0,0,0,18,0,0,0,230,0,0,0,100,1,0,0,244,0,0,0,76,0,0,0,2,0,0,0,130,0,0,0,32,0,0,0,154,0,0,0,236,0,0,0,96,0,0,0,12,0,0,0,6,0,0,0,60,0,0,0,48,0,0,0,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,160,2,0,208,158,2,0,220,5,0,0,132,3,0,0,45,0,0,0,22,0,0,0,20,0,0,0,20,0,0,0,188,0,0,0,106,1,0,0,182,1,0,0,174,1,0,0,2,0,0,0,26,1,0,0,134,0,0,0,132,0,0,0,160,0,0,0,90,0,0,0,114,0,0,0,30,0,0,0,56,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,0,32,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,157,2,0,72,156,2,0,220,5,0,0,132,3,0,0,45,0,0,0,22,0,0,0,20,0,0,0,20,0,0,0,188,0,0,0,14,1,0,0,158,0,0,0,146,1,0,0,2,0,0,0,26,1,0,0,134,0,0,0,132,0,0,0,160,0,0,0,90,0,0,0,114,0,0,0,30,0,0,0,56,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,154,2,0,248,152,2,0,32,28,0,0,176,19,0,0,110,0,0,0,66,0,0,0,63,0,0,0,63,0,0,0,122,1,0,0,42,0,0,0,186,0,0,0,146,0,0,0,2,0,0,0,162,0,0,0,20,0,0,0,118,0,0,0,34,1,0,0,16,0,0,0,26,0,0,0,154,0,0,0,114,0,0,0,48,0,0,0,90,0,0,0,6,0,0,0,148,32,0,0,0,0,0,0,0,0,0,0,6,0,0,0,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,16,0,0,0,32,0,0,0,8,0,0,0,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,0,0,0,86,0,0,0,0,0,0,0,0,0,0,0,0,152,2,0,216,149,2,0,32,28,0,0,176,19,0,0,100,0,0,0,60,0,0,0,63,0,0,0,63,0,0,0,122,1,0,0,42,0,0,0,186,0,0,0,14,0,0,0,2,0,0,0,162,0,0,0,20,0,0,0,118,0,0,0,242,0,0,0,12,0,0,0,26,0,0,0,154,0,0,0,114,0,0,0,54,0,0,0,0,0,0,0,6,0,0,0,128,32,0,0,0,0,0,0,0,0,0,0,6,0,0,0,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,16,0,0,0,30,1,0,0,8,0,0,0,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,0,0,0,0,0,0,0,0,0,0,0,232,147,2,0,88,146,2,0,32,28,0,0,176,19,0,0,100,0,0,0,60,0,0,0,63,0,0,0,63,0,0,0,122,1,0,0,42,0,0,0,186,0,0,0,14,0,0,0,2,0,0,0,162,0,0,0,20,0,0,0,118,0,0,0,242,0,0,0,12,0,0,0,26,0,0,0,154,0,0,0,114,0,0,0,54,0,0,0,0,0,0,0,6,0,0,0,128,32,0,0,0,0,0,0,0,0,0,0,6,0,0,0,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,16,0,0,0,30,1,0,0,8,0,0,0,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,0,0,0,0,0,0,0,0,0,0,0,240,144,2,0,176,142,2,0,184,11,0,0,8,7,0,0,83,0,0,0,41,0,0,0,41,0,0,0,41,0,0,0,46,0,0,0,84,0,0,0,164,0,0,0,52,1,0,0,2,0,0,0,124,1,0,0,116,0,0,0,44,0,0,0,62,0,0,0,20,0,0,0,64,0,0,0,128,0,0,0,36,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,141,2,0,152,139,2,0,136,19,0,0,184,11,0,0,152,0,0,0,73,0,0,0,69,0,0,0,69,0,0,0,10,1,0,0,152,1,0,0,160,0,0,0,224,0,0,0,2,0,0,0,154,0,0,0,6,0,0,0,72,0,0,0,48,0,0,0,100,0,0,0,88,0,0,0,190,0,0,0,82,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,138,2,0,168,136,2,0,16,39,0,0,16,39,0,0,164,1,0,0,160,0,0,0,200,0,0,0,150,0,0,0,138,1,0,0,92,1,0,0,68,1,0,0,102,1,0,0,2,0,0,0,44,1,0,0,90,0,0,0,66,0,0,0,34,0,0,0,66,0,0,0,116,0,0,0,186,0,0,0,14,0,0,0,40,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,0,0,0,0,0,0,0,148,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,134,2,0,8,133,2,0,220,5,0,0,132,3,0,0,45,0,0,0,22,0,0,0,20,0,0,0,20,0,0,0,48,1,0,0,226,0,0,0,54,1,0,0,122,0,0,0,2,0,0,0,176,0,0,0,146,0,0,0,110,0,0,0,142,0,0,0,126,0,0,0,130,0,0,0,170,0,0,0,84,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,131,2,0,0,130,2,0,220,5,0,0,132,3,0,0,45,0,0,0,22,0,0,0,20,0,0,0,20,0,0,0,48,1,0,0,114,0,0,0,130,1,0,0,90,1,0,0,2,0,0,0,94,0,0,0,138,0,0,0,140,0,0,0,120,1,0,0,106,0,0,0,70,0,0,0,198,0,0,0,54,0,0,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,128,2,0,136,125,2,0,224,46,0,0,32,28,0,0,110,1,0,0,176,0,0,0,166,0,0,0,166,0,0,0,136,1,0,0,60,1,0,0,126,0,0,0,134,1,0,0,2,0,0,0,252,0,0,0,112,0,0,0,58,0,0,0,204,0,0,0,10,0,0,0,72,0,0,0,200,0,0,0,34,0,0,0,22,0,0,0,68,0,0,0,12,0,0,0,132,1,0,0,0,0,0,0,0,0,0,0,26,0,0,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,0,0,0,156,1,0,0,212,0,0,0,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,123,2,0,208,120,2,0,156,49,0,0,196,29,0,0,165,1,0,0,206,0,0,0,123,0,0,0,123,0,0,0,116,0,0,0,74,0,0,0,58,1,0,0,110,0,0,0,2,0,0,0,54,0,0,0,70,0,0,0,2,0,0,0,46,0,0,0,48,0,0,0,188,0,0,0,112,0,0,0,92,0,0,0,30,0,0,0,38,0,0,0,28,0,0,0,0,59,0,0,0,0,0,0,0,0,0,0,2,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,0,0,0,0,0,0,0,178,0,0,0,114,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,0,0,128,63,0,0,0,0,0,0,240,65,0,0,0,0,0,0,112,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,93,0,0,0,0,0,0,9,46,46,46,105,116,32,105,115,78,101,119,76,101,118,101,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,0,0,0,0,0,0,0,97,65,101,69,102,70,103,71,0,0,0,0,0,0,0,0,99,100,105,111,117,120,88,0,104,108,76,113,106,122,90,116,67,83,112,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,21,3,0,160,0,3,0,176,212,2,0,32,192,2,0,224,175,2,0,120,160,2,0,32,145,2,0,136,128,2,0,8,184,2,0,64,79,2,0,120,129,2,0,96,64,2,0,40,56,2,0,168,48,2,0,208,42,2,0,48,36,2,0,152,28,2,0,80,22,2,0,184,14,2,0,232,8,2,0,120,3,2,0,80,254,1,0,56,250,1,0,64,245,1,0,8,240,1,0,200,235,1,0])
.concat([240,230,1,0,40,226,1,0,224,220,1,0,48,214,1,0,40,209,1,0,160,197,1,0,56,194,1,0,128,190,1,0,192,177,1,0,216,165,1,0,16,162,1,0,184,158,1,0,48,154,1,0,224,151,1,0,240,149,1,0,128,148,1,0,224,139,1,0,240,137,1,0,8,135,1,0,88,133,1,0,144,131,1,0,152,129,1,0,8,127,1,0,96,124,1,0,32,122,1,0,72,120,1,0,200,118,1,0,192,116,1,0,8,115,1,0,56,112,1,0,216,109,1,0,160,107,1,0,184,103,1,0,8,101,1,0,136,98,1,0,232,96,1,0,88,94,1,0,104,92,1,0,80,89,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,199,1,0,1,0,0,0,88,199,1,0,2,0,0,0,224,198,1,0,3,0,0,0,40,43,1,0,4,0,0,0,136,198,1,0,4,0,0,0,176,111,1,0,5,0,0,0,88,198,1,0,9,0,0,0,232,197,1,0,10,0,0,0,152,197,1,0,6,0,0,0,8,197,1,0,7,0,0,0,112,196,1,0,8,0,0,0,248,195,1,0,11,0,0,0,0,0,0,0,0,0,0,0,248,60,1,0,56,55,1,0,88,52,1,0,48,50,1,0,200,48,1,0,0,0,0,0,16,241,1,0,152,240,1,0,88,52,1,0,48,50,1,0,200,48,1,0,0,0,0,0,16,241,1,0,152,240,1,0,88,52,1,0,48,50,1,0,104,249,1,0,0,0,0,0,0,0,0,0,0,0,0,0,37,115,115,99,97,108,101,32,109,117,115,116,32,98,101,32,62,32,48,59,32,118,105,101,119,32,117,110,99,104,97,110,103,101,100,0,0,0,0,0,114,111,116,95,37,99,32,109,117,115,116,32,98,101,32,105,110,32,91,48,58,37,100,93,32,100,101,103,114,101,101,115,32,114,97,110,103,101,59,32,118,105,101,119,32,117,110,99,104,97,110,103,101,100,0,0,232,119,1,0,2,0,0,0,16,118,1,0,1,0,0,0,48,116,1,0,1,0,0,0,96,114,1,0,3,0,0,0,176,111,1,0,4,0,0,0,56,109,1,0,5,0,0,0,248,105,1,0,6,0,0,0,8,199,1,0,7,0,0,0,40,100,1,0,8,0,0,0,232,97,1,0,9,0,0,0,248,95,1,0,10,0,0,0,32,93,1,0,11,0,0,0,56,91,1,0,12,0,0,0,0,89,1,0,13,0,0,0,0,84,1,0,14,0,0,0,224,79,1,0,15,0,0,0,16,75,1,0,17,0,0,0,232,72,1,0,18,0,0,0,160,69,1,0,19,0,0,0,16,66,1,0,20,0,0,0,80,60,1,0,21,0,0,0,248,54,1,0,22,0,0,0,24,52,1,0,23,0,0,0,248,49,1,0,16,0,0,0,96,48,1,0,16,0,0,0,0,46,1,0,24,0,0,0,184,43,1,0,25,0,0,0,96,41,1,0,26,0,0,0,24,39,1,0,27,0,0,0,104,37,1,0,28,0,0,0,104,35,1,0,29,0,0,0,200,33,1,0,30,0,0,0,96,32,1,0,31,0,0,0,208,30,1,0,32,0,0,0,112,28,1,0,31,0,0,0,32,111,3,0,32,0,0,0,80,109,3,0,33,0,0,0,80,105,3,0,34,0,0,0,240,102,3,0,35,0,0,0,64,101,3,0,36,0,0,0,32,98,3,0,37,0,0,0,56,96,3,0,37,0,0,0,136,93,3,0,38,0,0,0,0,87,3,0,39,0,0,0,48,85,3,0,40,0,0,0,192,82,3,0,41,0,0,0,128,80,3,0,42,0,0,0,240,77,3,0,44,0,0,0,32,76,3,0,45,0,0,0,56,74,3,0,48,0,0,0,56,72,3,0,49,0,0,0,32,70,3,0,46,0,0,0,128,67,3,0,47,0,0,0,120,65,3,0,52,0,0,0,80,63,3,0,53,0,0,0,208,60,3,0,50,0,0,0,168,58,3,0,51,0,0,0,48,57,3,0,54,0,0,0,56,55,3,0,55,0,0,0,104,52,3,0,68,0,0,0,176,49,3,0,69,0,0,0,88,48,3,0,56,0,0,0,16,46,3,0,57,0,0,0,200,43,3,0,58,0,0,0,136,40,3,0,59,0,0,0,0,38,3,0,61,0,0,0,176,34,3,0,60,0,0,0,64,32,3,0,62,0,0,0,32,31,3,0,63,0,0,0,56,30,3,0,63,0,0,0,16,189,2,0,76,0,0,0,16,29,3,0,77,0,0,0,24,28,3,0,78,0,0,0,56,27,3,0,79,0,0,0,248,172,2,0,80,0,0,0,72,26,3,0,81,0,0,0,24,25,3,0,75,0,0,0,0,24,3,0,82,0,0,0,120,97,1,0,83,0,0,0,152,19,3,0,85,0,0,0,184,16,3,0,84,0,0,0,128,13,3,0,86,0,0,0,176,123,1,0,87,0,0,0,200,10,3,0,88,0,0,0,112,9,3,0,89,0,0,0,216,7,3,0,90,0,0,0,168,6,3,0,91,0,0,0,248,4,3,0,92,0,0,0,224,2,3,0,93,0,0,0,152,0,3,0,94,0,0,0,128,121,1,0,97,0,0,0,24,254,2,0,98,0,0,0,0,252,2,0,99,0,0,0,88,245,2,0,119,0,0,0,120,243,2,0,110,0,0,0,144,235,2,0,101,0,0,0,32,221,2,0,129,0,0,0,216,218,2,0,120,0,0,0,224,216,2,0,138,0,0,0,112,214,2,0,70,0,0,0,168,212,2,0,113,0,0,0,184,210,2,0,104,0,0,0,48,209,2,0,132,0,0,0,232,207,2,0,123,0,0,0,64,206,2,0,141,0,0,0,208,204,2,0,64,0,0,0,232,202,2,0,117,0,0,0,96,200,2,0,118,0,0,0,40,195,2,0,108,0,0,0,200,193,2,0,109,0,0,0,24,192,2,0,136,0,0,0,120,190,2,0,137,0,0,0,8,189,2,0,127,0,0,0,192,187,2,0,128,0,0,0,96,185,2,0,145,0,0,0,160,183,2,0,146,0,0,0,200,182,2,0,147,0,0,0,96,181,2,0,148,0,0,0,120,179,2,0,66,0,0,0,48,178,2,0,67,0,0,0,216,175,2,0,111,0,0,0,80,174,2,0,112,0,0,0,232,172,2,0,102,0,0,0,16,171,2,0,103,0,0,0,0,170,2,0,130,0,0,0,160,168,2,0,131,0,0,0,24,166,2,0,121,0,0,0,112,164,2,0,122,0,0,0,8,163,2,0,139,0,0,0,136,161,2,0,140,0,0,0,104,160,2,0,71,0,0,0,0,159,2,0,72,0,0,0,200,157,2,0,114,0,0,0,120,156,2,0,115,0,0,0,200,154,2,0,105,0,0,0,56,153,2,0,106,0,0,0,16,152,2,0,133,0,0,0,40,150,2,0,134,0,0,0,248,147,2,0,124,0,0,0,152,146,2,0,125,0,0,0,24,145,2,0,142,0,0,0,232,142,2,0,143,0,0,0,64,141,2,0,73,0,0,0,232,139,2,0,74,0,0,0,120,138,2,0,116,0,0,0,232,136,2,0,107,0,0,0,16,135,2,0,135,0,0,0,88,133,2,0,126,0,0,0,224,131,2,0,144,0,0,0,56,130,2,0,65,0,0,0,80,128,2,0,149,0,0,0,192,125,2,0,95,0,0,0,224,123,2,0,96,0,0,0,88,121,2,0,100,0,0,0,192,111,2,0,153,0,0,0,24,109,2,0,154,0,0,0,80,107,2,0,155,0,0,0,240,104,2,0,156,0,0,0,168,96,2,0,157,0,0,0,80,93,2,0,152,0,0,0,248,91,2,0,150,0,0,0,216,90,2,0,151,0,0,0,0,0,0,0,0,0,0,0,48,116,1,0,1,0,0,0,24,20,2,0,2,0,0,0,128,19,2,0,3,0,0,0,136,18,2,0,4,0,0,0,240,17,2,0,5,0,0,0,120,17,2,0,6,0,0,0,160,16,2,0,7,0,0,0,32,16,2,0,8,0,0,0,144,15,2,0,9,0,0,0,168,14,2,0,10,0,0,0,24,14,2,0,11,0,0,0,152,13,2,0,12,0,0,0,40,13,2,0,13,0,0,0,136,12,2,0,14,0,0,0,232,247,1,0,15,0,0,0,48,11,2,0,16,0,0,0,168,10,2,0,17,0,0,0,16,10,2,0,18,0,0,0,144,9,2,0,19,0,0,0,216,8,2,0,20,0,0,0,168,7,2,0,21,0,0,0,240,6,2,0,22,0,0,0,96,6,2,0,23,0,0,0,0,0,0,0,0,0,0,0,240,34,2,0,1,0,0,0,40,34,2,0,2,0,0,0,8,93,1,0,3,0,0,0,128,32,2,0,3,0,0,0,208,250,1,0,4,0,0,0,248,30,2,0,5,0,0,0,88,30,2,0,9,0,0,0,104,29,2,0,10,0,0,0,136,28,2,0,11,0,0,0,112,27,2,0,12,0,0,0,192,26,2,0,6,0,0,0,56,26,2,0,7,0,0,0,168,25,2,0,8,0,0,0,64,25,2,0,13,0,0,0,128,24,2,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,153,153,153,153,153,169,63,154,153,153,153,153,153,169,63,154,153,153,153,153,153,201,63,154,153,153,153,153,153,185,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,208,63,102,102,102,102,102,102,230,63,51,51,51,51,51,51,235,63,205,204,204,204,204,204,236,63,154,153,153,153,153,153,217,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,102,102,102,102,102,102,230,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,205,204,204,204,204,204,236,63,51,51,51,51,51,51,227,63,51,51,51,51,51,51,227,63,51,51,51,51,51,51,227,63,0,0,0,0,0,0,240,63,102,102,102,102,102,102,238,63,102,102,102,102,102,102,238,63,102,102,102,102,102,102,238,63,232,211,1,0,0,0,0,0,128,82,2,0,1,0,0,0,112,82,2,0,2,0,0,0,96,82,2,0,4,0,0,0,80,82,2,0,5,0,0,0,8,82,2,0,3,0,0,0,0,82,2,0,6,0,0,0,128,234,1,0,7,0,0,0,0,0,0,0,8,0,0,0,136,208,2,0,39,0,0,0,104,75,2,0,40,0,0,0,192,74,2,0,41,0,0,0,32,74,2,0,1,0,0,0,88,73,2,0,2,0,0,0,192,72,2,0,3,0,0,0,64,72,2,0,4,0,0,0,56,71,2,0,5,0,0,0,8,70,2,0,6,0,0,0,104,69,2,0,7,0,0,0,216,68,2,0,8,0,0,0,232,67,2,0,13,0,0,0,168,67,2,0,9,0,0,0,192,66,2,0,14,0,0,0,48,116,1,0,10,0,0,0,32,66,2,0,11,0,0,0,88,65,2,0,12,0,0,0,80,64,2,0,15,0,0,0,72,63,2,0,16,0,0,0,64,62,2,0,17,0,0,0,48,61,2,0,18,0,0,0,136,60,2,0,19,0,0,0,200,59,2,0,20,0,0,0,32,59,2,0,21,0,0,0,120,58,2,0,22,0,0,0,232,57,2,0,23,0,0,0,200,56,2,0,24,0,0,0,0,224,1,0,25,0,0,0,192,218,1,0,26,0,0,0,240,53,2,0,27,0,0,0,16,53,2,0,28,0,0,0,40,52,2,0,29,0,0,0,72,51,2,0,30,0,0,0,184,50,2,0,31,0,0,0,64,50,2,0,32,0,0,0,248,49,2,0,37,0,0,0,96,49,2,0,38,0,0,0,128,234,1,0,33,0,0,0,0,48,2,0,34,0,0,0,192,229,1,0,35,0,0,0,192,46,2,0,36,0,0,0,8,46,2,0,36,0,0,0,72,45,2,0,42,0,0,0,200,44,2,0,42,0,0,0,40,44,2,0,43,0,0,0,176,43,2,0,44,0,0,0,88,43,2,0,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,89,2,0,1,0,0,0,0,82,2,0,2,0,0,0,40,86,2,0,3,0,0,0,112,84,2,0,4,0,0,0,0,83,2,0,5,0,0,0,192,81,2,0,6,0,0,0,200,80,2,0,7,0,0,0,32,80,2,0,8,0,0,0,48,79,2,0,9,0,0,0,8,78,2,0,10,0,0,0,72,77,2,0,11,0,0,0,176,76,2,0,12,0,0,0,0,0,0,0,0,0,0,0,136,208,2,0,0,0,0,0,88,188,2,0,15,0,0,0,24,172,2,0,1,0,0,0,176,73,2,0,2,0,0,0,152,4,2,0,3,0,0,0,160,209,1,0,4,0,0,0,88,157,2,0,5,0,0,0,144,122,1,0,6,0,0,0,184,98,1,0,7,0,0,0,184,67,1,0,8,0,0,0,24,38,1,0,9,0,0,0,40,102,3,0,10,0,0,0,56,75,3,0,11,0,0,0,152,140,2,0,12,0,0,0,112,122,2,0,13,0,0,0,152,88,2,0,14,0,0,0,0,0,0,0,16,0,0,0,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,176,0,0,0,0,0,0,160,41,2,0,1,0,0,0,216,40,2,0,2,0,0,0,136,208,2,0,3,0,0,0,32,40,2,0,4,0,0,0,48,116,1,0,4,0,0,0,80,39,2,0,5,0,0,0,184,38,2,0,6,0,0,0,56,38,2,0,7,0,0,0,184,37,2,0,8,0,0,0,56,86,3,0,9,0,0,0,40,36,2,0,10,0,0,0,120,35,2,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,128,1,0,1,0,0,0,16,126,1,0,3,0,0,0,176,123,1,0,2,0,0,0,128,121,1,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,141,2,0,40,140,2,0,160,138,2,0,56,137,2,0,96,135,2,0,0,0,0,0,100,0,0,0,0,0,0,0,100,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,72,101,108,118,101,116,105,99,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,101,108,118,101,116,105,99,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,205,204,204,204,204,204,236,63,205,204,204,204,204,204,236,63,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,16,64,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,253,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,37,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,128,63,0,0,128,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,0,1,0,0,208,7,0,0,250,126,106,188,116,147,104,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,128,63,0,0,128,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,0,1,0,0,208,7,0,0,250,126,106,188,116,147,104,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,128,63,0,0,128,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,0,1,0,0,208,7,0,0,250,126,106,188,116,147,104,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,128,63,0,0,128,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,0,1,0,0,208,7,0,0,250,126,106,188,116,147,104,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,243,1,0,24,150,1,0,104,136,1,0,8,116,1,0,128,90,1,0,48,153,2,0,80,32,1,0,112,22,3,0,64,67,3,0,192,45,3,0,248,26,3,0,168,7,3,0,120,220,2,0,112,202,2,0,96,182,2,0,152,165,2,0,232,151,2,0,216,134,2,0,0,107,2,0,144,82,2,0,144,74,2,0,120,67,2,0,224,58,2,0,128,50,2,0,152,44,2,0,152,38,2,0,112,31,2,0,96,24,2,0,16,17,2,0,8,11,2,0,16,5,2,0,72,0,2,0,240,251,1,0,136,246,1,0,248,241,1,0,8,237,1,0,24,232,1,0,248,227,1,0,136,222,1,0,144,216,1,0,16,210,1,0,152,198,1,0,32,195,1,0,200,191,1,0,184,186,1,0,72,167,1,0,104,163,1,0,0,160,1,0,40,155,1,0,104,152,1,0,80,150,1,0,208,148,1,0,184,140,1,0,152,138,1,0,176,135,1,0,184,133,1,0,56,132,1,0,168,130,1,0,176,127,1,0,32,125,1,0,232,122,1,0,168,120,1,0,48,119,1,0,40,117,1,0,80,115,1,0,152,112,1,0,64,110,1,0,72,108,1,0,168,104,1,0,144,101,1,0,208,98,1,0,72,97,1,0,48,95,1,0,192,92,1,0,152,190,2,0,152,190,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,93,1,0,72,93,1,0,248,92,1,0,208,92,1,0,240,92,1,0,184,92,1,0,160,92,1,0,48,55,1,0,232,54,1,0,200,54,1,0,72,93,1,0,192,54,1,0,0,0,0,0,0,0,255,0,0,0,255,0,0,0,255,255,0,255,0,255,255,255,255,0,143,188,143,255,105,180,0,0,0,255,127,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,64,0,0,0,0,0,0,89,64,0,0,0,0,0,136,195,64,0,0,0,0,132,215,151,65,0,128,224,55,121,195,65,67,23,110,5,181,181,184,147,70,245,249,63,233,3,79,56,77,50,29,48,249,72,119,130,90,60,191,115,127,221,79,21,117,3,0,0,0,50,0,0,0,50,0,0,0,2,0,0,0,0,0,0,0,0,0,128,63,0,0,128,63,0,0,0,0,0,0,0,0,72,101,108,118,101,116,105,99,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,65,0,0,128,63,0,0,0,0,208,7,0,0,250,126,106,188,116,147,104,63,0,1,0,0,0,0,0,0,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,3,0,0,0,50,0,0,0,50,0,0,0,2,0,0,0,0,0,0,0,0,0,128,63,0,0,128,63,0,0,0,0,0,0,0,0,72,101,108,118,101,116,105,99,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,65,0,0,128,63,0,0,0,0,208,7,0,0,250,126,106,188,116,147,104,63,0,1,0,0,0,0,0,0,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,255,255,255,255,0,0,0,0,48,0,0,0,0,0,0,0,128,194,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,0,0,0,0,0,0,98,0,97,52,0,0,0,0,0,0,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,224,198,1,0,1,0,0,0,184,195,1,0,33,0,0,0,232,52,2,0,18,0,0,0,48,195,1,0,51,0,0,0,240,194,1,0,51,0,0,0,192,194,1,0,64,0,0,0,104,194,1,0,39,1,0,0])
.concat([40,194,1,0,39,1,0,0,88,193,1,0,23,1,0,0,240,192,1,0,55,1,0,0,168,192,1,0,102,0,0,0,104,192,1,0,102,0,0,0,16,192,1,0,86,0,0,0,224,191,1,0,118,0,0,0,168,191,1,0,153,0,0,0,112,191,1,0,136,1,0,0,32,191,1,0,89,1,0,0,112,190,1,0,169,0,0,0,88,189,1,0,137,0,0,0,192,188,1,0,177,0,0,0,96,188,1,0,184,0,0,0,40,188,1,0,193,0,0,0,120,187,1,0,209,0,0,0,216,186,1,0,225,0,0,0,104,186,1,0,1,1,0,0,88,185,1,0,252,0,0,0,248,195,1,0,218,1,0,0,0,38,3,0,96,1,0,0,80,184,1,0,112,1,0,0,184,177,1,0,144,1,0,0,248,175,1,0,160,1,0,0,128,172,1,0,176,1,0,0,216,170,1,0,201,1,0,0,176,168,1,0,233,1,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,128,196,1,0,1,0,0,0,0,193,1,0,2,0,0,0,200,188,1,0,3,0,0,0,144,172,1,0,4,0,0,0,216,164,1,0,5,0,0,0,8,161,1,0,6,0,0,0,48,157,1,0,7,0,0,0,16,153,1,0,8,0,0,0,200,150,1,0,9,0,0,0,0,0,0,0,0,0,0,0,67,97,110,32,115,112,101,99,105,102,121,32,96,111,114,105,103,105,110,96,32,111,114,32,96,99,101,110,116,101,114,96,44,32,98,117,116,32,110,111,116,32,98,111,116,104,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,224,1,0,0,0,0,0,216,219,1,0,1,0,0,0,64,212,1,0,2,0,0,0,232,199,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,100,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,252,255,255,255,0,0,0,0,0,0,0,0,154,153,153,153,153,153,201,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,252,255,255,255,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,20,174,71,225,122,148,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,118,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,4,0,0,0,1,0,0,0,100,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,0,0,0,0,0,0,0,10,215,163,59,56,0,0,0,71,0,0,0,111,18,3,59,49,8,172,61,40,0,0,0,59,0,0,0,111,18,3,59,49,8,172,61,40,0,0,0,110,0,0,0,111,18,3,59,49,8,172,61,40,0,0,0,53,0,0,0,111,18,3,59,49,8,172,61,40,0,0,0,115,0,0,0,111,18,3,59,182,243,125,61,40,0,0,0,75,0,0,0,10,215,163,59,154,153,153,61,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,255,255,255,255,0,0,0,0,1,0,0,0,44,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,32,35,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,0,0,0,28,0,0,0,31,0,0,0,30,0,0,0,31,0,0,0,30,0,0,0,31,0,0,0,31,0,0,0,30,0,0,0,31,0,0,0,30,0,0,0,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,8,0,0,0,12,0,0,0,13,0,0,0,5,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,0,0,0,0,231,251,31,65,160,134,0,0,160,134,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,12,0,0,0,3,0,0,0,0,0,0,0,9,0,0,0,8,0,0,0,14,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,43,3,0,136,43,3,0,0,43,3,0,168,42,3,0,120,42,3,0,64,42,3,0,216,41,3,0,128,41,3,0,64,41,3,0,240,40,3,0,152,40,3,0,120,40,3,0,32,40,3,0,0,40,3,0,192,39,3,0,128,39,3,0,64,39,3,0,0,39,3,0,176,38,3,0,160,38,3,0,8,38,3,0,184,37,3,0,48,37,3,0,248,36,3,0,176,36,3,0,80,36,3,0,40,36,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,200,1,0,240,196,1,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,150,1,0,48,153,2,0,240,152,2,0,224,156,0,0,232,152,2,0,224,152,2,0,112,169,2,0,0,0,0,0,128,152,2,0,120,152,2,0,96,152,2,0,24,152,2,0,8,152,2,0,248,151,2,0,224,151,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,127,0,0,0,0,255,255,255,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,64,0,0,0,0,0,0,36,64,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,205,204,204,204,204,204,236,63,205,204,204,204,204,204,236,63,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,16,64,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,253,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,117,1,0,32,235,1,0,80,230,1,0,192,224,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,175,203,174,131,28,212,63,5,131,82,81,72,84,238,63,69,54,70,161,27,144,249,63,152,255,235,55,110,60,2,64,78,179,64,187,67,42,8,64,182,126,159,22,40,30,15,64,4,60,105,225,178,74,246,63,1,185,171,244,102,150,205,63,22,140,132,149,142,226,195,191,74,181,106,247,109,120,121,63,254,41,194,141,220,23,24,63,203,225,243,45,104,14,165,190,132,27,223,205,9,48,240,63,248,153,229,120,38,16,232,191,53,126,55,150,221,183,137,63,17,80,205,36,107,134,132,63,156,200,73,125,117,186,47,191,218,83,12,136,64,206,160,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,15,0,0,14,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,56,15,0,14,53,15,0,14,59,15,0,14,58,15,0,14,60,15,0,15,124,15,0,14,61,15,0,14,43,15,0,0,0,0,0,14,121,15,0,14,123,15,0,0,0,0,0,0,0,0,0,0,0,0,0,14,48,15,0,14,122,15,0,14,126,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,122,15,0,14,125,15,0,14,119,15,0,14,120,15,0,0,0,0,0,14,57,15,0,14,33,15,0,14,96,15,0,14,34,15,0,14,97,15,0,14,88,15,0,14,80,15,0,14,83,15,0,14,52,15,0,14,35,15,0,14,92,15,0,14,36,15,0,14,37,15,0,14,102,15,0,14,101,15,0,14,38,15,0,14,39,15,0,14,99,15,0,14,54,15,0,14,104,15,0,14,103,15,0,14,95,15,0,14,105,15,0,14,90,15,0,0,0,0,0,14,82,15,0,14,45,15,0,14,109,15,0,14,46,15,0,14,91,15,0,0,0,0,0,14,112,15,0,14,94,15,0,14,72,15,0,14,68,15,0,14,64,15,0,14,98,15,0,14,76,15,0,14,84,15,0,14,87,15,0,14,53,15,0,14,73,15,0,14,69,15,0,14,65,15,0,14,77,15,0,14,89,15,0,14,85,15,0,14,81,15,0,14,93,15,0,14,100,15,0,14,55,15,0,14,74,15,0,14,70,15,0,14,66,15,0,14,106,15,0,14,78,15,0,0,0,0,0,14,86,15,0,14,75,15,0,14,71,15,0,14,67,15,0,14,79,15,0,0,0,0,0,14,113,15,0,14,111,15,0,14,52,15,0,14,79,15,0,14,69,15,0,14,64,15,0,14,76,15,0,14,72,15,0,14,84,15,0,14,53,15,0,14,65,15,0,14,77,15,0,14,73,15,0,14,93,15,0,14,81,15,0,14,89,15,0,14,88,15,0,14,80,15,0,14,92,15,0,14,87,15,0,14,83,15,0,14,66,15,0,14,78,15,0,14,74,15,0,14,67,15,0,14,75,15,0,14,111,15,0,14,90,15,0,14,91,15,0,14,86,15,0,14,59,15,0,14,82,15,0,0,0,0,0,14,62,15,0,14,68,15,0,14,85,15,0,14,70,15,0,14,71,15,0,14,55,15,0,14,54,15,0,14,121,15,0,14,122,15,0,14,57,15,0,0,0,0,0,0,0,0,0,14,120,15,0,14,119,15,0,14,56,15,0,14,123,15,0,14,125,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,96,15,0,14,34,15,0,14,33,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,63,15,0,14,60,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,98,15,0,14,97,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,58,15,0,14,100,15,0,14,99,15,0,14,36,15,0,14,37,15,0,14,35,15,0,0,0,0,0,14,101,15,0,14,38,15,0,14,39,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,102,15,0,0,0,0,0,14,103,15,0,14,94,15,0,14,95,15,0,14,104,15,0,14,106,15,0,14,105,15,0,0,0,0,0,14,113,15,0,14,112,15,0,14,109,15,0,14,46,15,0,14,45,15,0,0,0,0,0,0,0,0,0,14,48,15,0,14,40,15,0,14,118,15,0,14,126,15,0,0,0,0,0,0,0,0,0,0,0,0,0,14,61,15,0,0,0,0,0,0,0,0,0,14,122,15,0,14,43,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,251,255,255,255,251,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,46,54,0,0,0,0,0,51,0,0,0,0,0,0,0,50,48,49,51,45,48,52,45,49,50,32,0,0,0,0,0,67,111,112,121,114,105,103,104,116,32,40,67,41,32,49,57,56,54,45,49,57,57,51,44,32,49,57,57,56,44,32,50,48,48,52,44,32,50,48,48,55,45,50,48,49,51,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,97,110,117,97,114,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,101,98,114,117,97,114,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,97,114,99,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,112,114,105,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,97,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,117,110,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,117,108,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,117,103,117,115,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,101,112,116,101,109,98,101,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,99,116,111,98,101,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,111,118,101,109,98,101,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,101,99,101,109,98,101,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,117,110,100,97,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
.concat([77,111,110,100,97,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,117,101,115,100,97,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,101,100,110,101,115,100,97,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,104,117,114,115,100,97,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,114,105,100,97,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,97,116,117,114,100,97,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,78,3,0,116,1,0,0,72,75,2,0,32,1,0,0,112,5,2,0,64,1,0,0,64,210,1,0,62,1,0,0,96,150,1,0,36,1,0,0,152,76,3,0,10,1,0,0,248,109,3,0,188,0,0,0,72,68,1,0,128,0,0,0,216,150,1,0,100,0,0,0,104,102,3,0,170,0,0,0,136,75,3,0,210,0,0,0,88,54,3,0,80,1,0,0,224,30,3,0,72,1,0,0,120,15,3,0,222,0,0,0,136,250,2,0,78,1,0,0,176,208,2,0,28,1,0,0,120,188,2,0,232,0,0,0,168,42,2,0,56,1,0,0,24,36,2,0,252,0,0,0,184,140,2,0,172,0,0,0,32,111,3,0,68,0,0,0,168,88,2,0,74,0,0,0,40,77,2,0,124,0,0,0,184,69,2,0,206,0,0,0,0,62,2,0,192,0,0,0,136,53,2,0,166,0,0,0,224,46,2,0,72,0,0,0,80,41,2,0,246,0,0,0,88,34,2,0,96,1,0,0,152,26,2,0,216,0,0,0,192,19,2,0,214,0,0,0,112,13,2,0,74,1,0,0,160,6,2,0,2,0,0,0,208,1,2,0,84,0,0,0,64,253,1,0,208,0,0,0,16,248,1,0,114,1,0,0,184,243,1,0,82,1,0,0,184,238,1,0,104,0,0,0,112,234,1,0,234,0,0,0,176,229,1,0,6,1,0,0,208,223,1,0,30,0,0,0,152,190,2,0,0,0,0,0,72,158,1,0,240,0,0,0,144,199,1,0,104,1,0,0,0,196,1,0,104,1,0,0,144,42,2,0,116,0,0,0,112,188,1,0,176,0,0,0,240,170,1,0,2,1,0,0,120,164,1,0,98,1,0,0,184,160,1,0,12,0,0,0,248,156,1,0,152,0,0,0,216,152,1,0,112,1,0,0,168,150,1,0,110,0,0,0,72,149,1,0,250,0,0,0,120,145,1,0,184,0,0,0,0,139,1,0,130,1,0,0,96,136,1,0,126,0,0,0,80,134,1,0,134,0,0,0,144,132,1,0,20,1,0,0,240,130,1,0,60,0,0,0,64,128,1,0,66,0,0,0,208,125,1,0,70,0,0,0,112,123,1,0,90,1,0,0,88,121,1,0,76,1,0,0,184,119,1,0,76,0,0,0,216,117,1,0,110,1,0,0,0,116,1,0,68,1,0,0,224,113,1,0,36,0,0,0,96,182,2,0,196,0,0,0,0,137,1,0,122,0,0,0,208,105,1,0,106,0,0,0,136,102,1,0,6,0,0,0,224,99,1,0,224,0,0,0,192,97,1,0,226,0,0,0,208,95,1,0,46,1,0,0,0,93,1,0,44,1,0,0,120,90,1,0,82,0,0,0,160,87,1,0,202,0,0,0,168,83,1,0,154,0,0,0,168,79,1,0,164,0,0,0,144,74,1,0,186,0,0,0,184,72,1,0,218,0,0,0,104,69,1,0,44,0,0,0,136,65,1,0,12,1,0,0,184,59,1,0,112,0,0,0,208,54,1,0,8,1,0,0,248,51,1,0,58,1,0,0,208,49,1,0,122,1,0,0,0,48,1,0,78,0,0,0,216,45,1,0,66,1,0,0,120,43,1,0,118,0,0,0,48,41,1,0,52,1,0,0,208,38,1,0,126,1,0,0,48,37,1,0,244,0,0,0,72,35,1,0,64,0,0,0,152,33,1,0,14,1,0,0,72,32,1,0,88,1,0,0,144,30,1,0,254,0,0,0,72,28,1,0,124,1,0,0,240,110,3,0,190,0,0,0,192,108,3,0,50,1,0,0,56,105,3,0,50,0,0,0,208,102,3,0,86,1,0,0,192,165,1,0,60,1,0,0,200,97,3,0,42,0,0,0,32,96,3,0,40,1,0,0,48,93,3,0,198,0,0,0,144,86,3,0,114,1,0,0,240,84,3,0,238,0,0,0,240,161,1,0,238,0,0,0,24,80,3,0,248,0,0,0,192,77,3,0,22,1,0,0,32,42,2,0,10,0,0,0,8,74,3,0,92,1,0,0,0,72,3,0,162,0,0,0,208,69,3,0,162,0,0,0,56,67,3,0,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,25,2,0,232,18,2,0,200,12,2,0,48,6,2,0,128,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,121,1,0,0,0,0,0,8,120,1,0,0,0,0,0,192,172,1,0,240,164,1,0,102,105,116,46,108,111,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,1,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,0,0,0,0,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,167,1,0,0,0,0,0,96,167,1,0,1,0,0,0,8,167,1,0,2,0,0,0,176,166,1,0,3,0,0,0,88,166,1,0,4,0,0,0,160,76,2,0,9,0,0,0,96,244,2,0,10,0,0,0,208,164,1,0,11,0,0,0,112,164,1,0,12,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,80,3,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,50,0,0,0,50,0,0,0,0,0,0,0,0,0,1,0,0,0,128,63,0,0,128,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,65,0,0,128,63,1,0,0,0,208,7,0,0,250,126,106,188,116,147,104,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,2,0,0,0,50,0,0,0,50,0,0,0,0,0,0,0,0,0,1,0,0,0,128,63,0,0,128,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,65,0,0,128,63,1,0,0,0,208,7,0,0,250,126,106,188,116,147,104,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,0,0,0,0,0,0,0,0,241,104,227,136,181,248,228,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,236,1,0,96,25,3,0,176,73,2,0,152,4,2,0,160,209,1,0,32,150,1,0,144,122,1,0,184,98,1,0,184,67,1,0,24,38,1,0,40,102,3,0,56,75,3,0,0,54,3,0,176,30,3,0,240,14,3,0,48,246,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,251,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,65,0,0,0,0,0,0,0,0,0,0,240,63,65,114,105,97,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,65,0,0,0,0,65,114,105,97,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,64,0,0,0,0,0,0,160,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,7,0,0,0,8,0,0,0,0,0,0,0,12,0,0,0,10,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,121,1,0,24,121,1,0,216,120,1,0,152,120,1,0,128,120,1,0,104,120,1,0,88,120,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,57,2,0,1,0,0,0,0,0,1,0,184,49,2,0,0,0,0,0,1,0,1,0,56,49,2,0,3,0,0,0,0,0,2,0,48,43,2,0,2,0,0,0,1,0,2,0,168,36,2,0,5,0,0,0,0,0,4,0,232,28,2,0,4,0,0,0,1,0,4,0,192,22,2,0,7,0,0,0,0,0,8,0,248,14,2,0,6,0,0,0,1,0,8,0,16,9,2,0,8,0,0,0,2,0,4,0,152,3,2,0,9,0,0,0,2,0,8,0,160,254,1,0,8,0,0,0,2,0,4,0,160,250,1,0,9,0,0,0,2,0,8,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,32,73,2,0,0,0,0,0,0,66,2,0,3,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,0,0,0,0,0,0,0,101,120,101,99,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,10,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,104,149,1,0,1,0,0,0,72,147,1,0,2,0,0,0,88,139,1,0,3,0,0,0,0,137,1,0,4,0,0,0,120,134,1,0,5,0,0,0,192,132,1,0,6,0,0,0,24,131,1,0,7,0,0,0,0,0,0,0,8,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,129,2,0,88,59,3,0,16,92,2,0,8,161,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,1,0,1,2,2,1,0,1,3,2,1,0,152,187,0,0,10,0,0,0,248,186,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,219,0,0,2,0,0,0,0,0,0,0,1,0,0,0,248,7,0,0,2,0,0,0,1,0,0,0,1,0,0,0,72,3,0,0,2,0,0,0,2,0,0,0,2,0,0,0,168,3,0,0,2,0,0,0,3,0,0,0,2,0,0,0,88,3,0,0,1,0,0,0,6,0,0,0,4,0,0,0,184,3,0,0,1,0,0,0,7,0,0,0,4,0,0,0,80,3,0,0,1,0,0,0,10,0,0,0,8,0,0,0,176,3,0,0,1,0,0,0,11,0,0,0,8,0,0,0,0,165,0,0,1,0,0,0,8,0,0,0,4,0,0,0,8,165,0,0,1,0,0,0,9,0,0,0,8,0,0,0,168,211,0,0,3,0,0,0,0,0,0,0,1,0,0,0,240,7,0,0,1,0,0,0,1,0,0,0,1,0,0,0,88,85,0,0,1,0,0,0,2,0,0,0,2,0,0,0,112,4,0,0,1,0,0,0,3,0,0,0,2,0,0,0,64,146,0,0,4,0,0,0,4,0,0,0,4,0,0,0,184,7,0,0,2,0,0,0,5,0,0,0,4,0,0,0,64,137,0,0,2,0,0,0,6,0,0,0,4,0,0,0,176,7,0,0,2,0,0,0,7,0,0,0,4,0,0,0,16,165,0,0,2,0,0,0,8,0,0,0,4,0,0,0,96,201,0,0,2,0,0,0,9,0,0,0,8,0,0,0,72,55,1,0,253,255,255,255,252,255,255,255,251,255,255,255,200,125,2,0,252,255,255,255,251,255,255,255,253,255,255,255,224,90,2,0,251,255,255,255,253,255,255,255,252,255,255,255,0,78,2,0,252,255,255,255,253,255,255,255,251,255,255,255,48,71,2,0,253,255,255,255,251,255,255,255,252,255,255,255,64,63,2,0,251,255,255,255,252,255,255,255,253,255,255,255,32,55,2,0,253,255,255,255,252,255,255,255,251,255,255,255,248,47,2,0,252,255,255,255,251,255,255,255,253,255,255,255,24,42,2,0,251,255,255,255,253,255,255,255,252,255,255,255,112,35,2,0,252,255,255,255,253,255,255,255,251,255,255,255,88,27,2,0,253,255,255,255,251,255,255,255,252,255,255,255,224,20,2,0,251,255,255,255,252,255,255,255,253,255,255,255,160,76,2,0,253,255,255,255,252,255,255,255,251,255,255,255,64,69,2,0,252,255,255,255,253,255,255,255,251,255,255,255,96,174,2,0,253,255,255,255,252,255,255,255,251,255,255,255,16,159,2,0,252,255,255,255,253,255,255,255,251,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,253,255,255,255,252,255,255,255,251,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,220,1,0,202,0,0,0,240,153,1,0,174,0,0,0,224,126,1,0,164,1,0,0,80,103,1,0,164,1,0,0,80,87,3,0,142,0,0,0,24,42,1,0,124,0,0,0,232,105,3,0,2,1,0,0,80,78,3,0,2,1,0,0,128,57,3,0,144,0,0,0,160,32,3,0,174,0,0,0,224,109,1,0,174,0,0,0,40,17,3,0,64,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,176,0,0,0,0,0,0,1,0,0,0,1,0,1,0,18,0,0,0,1,0,1,0,33,0,0,0,1,0,1,0,51,0,0,0,1,0,1,0,64,0,0,0,1,0,1,0,86,0,0,0,2,0,1,0,102,0,0,0,2,0,1,0,118,0,0,0,3,0,1,0,137,0,0,0,3,0,1,0,153,0,0,0,1,0,1,0,169,0,0,0,3,0,1,0,177,0,0,0,1,0,1,0,193,0,0,0,1,0,1,0,184,0,0,0,1,0,1,0,209,0,0,0,1,0,1,0,225,0,0,0,2,0,2,0,252,0,0,0,4,0,1,0,1,1,0,0,4,0,1,0,218,1,0,0,2,0,1,0,23,1,0,0,2,0,1,0,39,1,0,0,2,0,1,0,55,1,0,0,3,0,1,0,89,1,0,0,1,0,1,0,96,1,0,0,1,0,2,0,112,1,0,0,2,0,1,0,136,1,0,0,1,0,0,0,144,1,0,0,1,0,2,0,160,1,0,0,3,0,2,0,176,1,0,0,4,0,2,0,201,1,0,0,2,0,1,0,233,1,0,0,2,0,3,0,0,0,0,0,255,255,255,255,0,0,0,0,1,0,0,0,1,0,0,0,100,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,252,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,252,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,3,0,0,0,1,0,0,0,100,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,252,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,252,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,154,153,153,153,153,153,169,63,184,30,133,235,81,184,158,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,73,1,0,255,255,255,0,72,93,1,0,0,0,0,0,48,5,2,0,160,160,160,0,248,92,1,0,0,0,255,0,32,4,2,0,0,192,0,0,208,3,2,0,255,128,0,0,104,3,2,0,255,0,192,0,136,2,2,0,238,238,0,0,8,2,2,0,0,64,192,0,184,1,2,0,0,200,200,0,96,1,2,0,225,105,65,0,184,0,2,0,32,192,255,0,120,0,2,0,64,128,0,0,0,0,2,0,255,128,192,0,104,255,1,0,128,96,48,0,208,254,1,0,0,0,139,0,64,254,1,0,0,128,64,0,200,253,1,0,255,128,255,0,104,253,1,0,212,255,127,0,200,92,1,0,42,42,165,0,48,55,1,0,0,255,255,0,160,252,1,0,208,224,64,0,16,252,1,0,0,0,0,0,208,251,1,0,26,26,26,0,88,251,1,0,51,51,51,0,216,250,1,0,77,77,77,0,48,250,1,0,102,102,102,0,128,249,1,0,127,127,127,0,88,248,1,0,153,153,153,0,240,247,1,0,179,179,179,0,128,32,2,0,192,192,192,0,144,247,1,0,204,204,204,0,24,247,1,0,229,229,229,0,168,246,1,0,255,255,255,0,64,246,1,0,50,50,240,0,232,245,1,0,144,238,144,0,160,245,1,0,230,216,173,0,48,245,1,0,240,85,240,0,112,244,1,0,255,255,224,0,232,243,1,0,130,221,238,0,144,243,1,0,193,182,255,0,8,243,1,0,238,238,175,0,120,242,1,0,0,215,255,0,208,92,1,0,0,255,0,0,200,241,1,0,0,100,0,0,0,241,1,0,127,255,0,0,136,240,1,0,34,139,34,0,248,239,1,0,87,139,46,0,240,92,1,0,255,0,0,0,248,238,1,0,139,0,0,0,104,238,1,0,112,25,25,0,232,237,1,0,128,0,0,0,104,237,1,0,205,0,0,0,48,237,1,0,235,206,135,0,160,92,1,0,255,255,0,0,184,92,1,0,255,0,255,0,32,236,1,0,209,206,0,0,184,235,1,0,147,20,255,0,192,54,1,0,80,127,255,0,160,234,1,0,128,128,240,0,72,234,1,0,0,69,255,0,216,233,1,0,114,128,250,0,128,233,1,0,122,150,233,0,168,232,1,0,140,230,240,0,240,231,1,0,107,183,189,0,144,231,1,0,11,134,184,0,64,231,1,0,220,245,245,0,232,230,1,0,32,128,160,0,128,230,1,0,0,165,255,0,232,229,1,0,238,130,238,0,136,229,1,0,211,0,148,0,32,229,1,0,221,160,221,0,160,228,1,0,64,80,144,0,56,228,1,0,47,107,85,0,176,227,1,0,0,20,128,0,104,227,1,0,20,20,128,0,176,226,1,0,20,64,128,0,32,226,1,0,128,64,128,0,224,224,1,0,192,96,128,0,56,224,1,0,255,96,128,0,184,223,1,0,0,128,128,0,120,223,1,0,64,128,255,0,40,223,1,0,64,160,255,0,176,222,1,0,96,160,255,0,64,222,1,0,112,160,255,0,216,221,1,0,192,192,255,0,72,221,1,0,128,255,255,0,208,220,1,0,192,255,255,0,56,220,1,0,158,183,205,0,200,219,1,0,240,255,240,0,168,218,1,0,205,182,160,0,96,218,1,0,193,255,193,0,24,218,1,0,176,192,205,0,80,217,1,0,64,255,124,0,112,216,1,0,32,255,160,0,8,93,1,0,190,190,190,0,24,216,1,0,211,211,211,0,120,215,1,0,211,211,211,0,32,214,1,0,160,160,160,0,152,213,1,0,205,182,160,0,56,212,1,0,0,0,0,0,192,211,1,0,26,26,26,0,56,211,1,0,51,51,51,0,248,210,1,0,77,77,77,0,56,210,1,0,102,102,102,0,232,209,1,0,127,127,127,0,152,209,1,0,153,153,153,0,112,209,1,0,179,179,179,0,32,209,1,0,204,204,204,0,152,200,1,0,229,229,229,0,224,199,1,0,255,255,255,0,0,0,0,0,255,255,255,255,100,118,1,0,254,255,255,255,1,0,0,0,0,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,205,204,204,204,204,204,236,63,154,153,153,153,153,153,201,63,0,0,0,0,0,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,154,153,153,153,153,153,169,63,51,51,51,51,51,51,227,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,2,0,0,0,1,0,0,0,100,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,252,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,252,255,255,255,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,20,174,71,225,122,148,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,118,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,253,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
.concat([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,161,1,0,120,157,1,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,28,0,0,0,0,0,0,72,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,65,0,0,0,0,0,0,0,0,0,0,0,0,22,0,0,0,0,0,0,0,83,119,105,116,122,101,114,108,97,110,100,76,105,103,104,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,85,3,0,88,83,3,0,72,89,1,0,40,81,3,0,96,78,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,56,46,51,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,9,2,0,10,0,0,0,152,31,3,0,160,1,0,0,168,77,2,0,96,0,0,0,80,7,2,0,72,1,0,0,96,212,1,0,30,0,0,0,224,150,1,0,76,1,0,0,208,123,1,0,60,0,0,0,64,100,1,0,214,0,0,0,184,69,1,0,166,1,0,0,64,39,1,0,140,0,0,0,224,194,2,0,98,1,0,0,104,76,3,0,98,1,0,0,96,55,3,0,236,0,0,0,48,31,3,0,166,0,0,0,200,16,3,0,132,1,0,0,8,252,2,0,94,1,0,0,80,209,2,0,36,0,0,0,16,189,2,0,240,0,0,0,248,172,2,0,150,1,0,0,208,157,2,0,112,0,0,0,80,141,2,0,166,1,0,0,232,123,2,0,170,1,0,0,88,89,2,0,208,0,0,0,80,77,2,0,22,1,0,0,24,70,2,0,138,0,0,0,80,62,2,0,128,0,0,0,248,53,2,0,114,1,0,0,144,47,2,0,38,1,0,0,176,41,2,0,184,0,0,0,0,35,2,0,38,0,0,0,208,26,2,0,22,0,0,0,40,20,2,0,108,1,0,0,160,13,2,0,26,0,0,0,0,7,2,0,32,1,0,0,24,2,2,0,232,0,0,0,120,253,1,0,194,0,0,0,96,248,1,0,84,1,0,0,248,243,1,0,144,1,0,0,8,239,1,0,96,1,0,0,176,234,1,0,36,1,0,0,240,148,1,0,118,0,0,0,0,0,0,0,112,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,157,255,255,255,0,0,0,0,24,24,2,0,114,0,0,0,216,23,2,0,104,0,0,0,88,23,2,0,99,0,0,0,72,22,2,0,121,0,0,0,240,20,2,0,120,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,8,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,13,2,0,144,7,2,0,72,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,191,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,254,255,255,255,0,0,0,0,254,255,255,255,254,255,255,255,254,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,112,213,0,0,0,0,0,0,72,101,108,118,101,116,105,99,97,32,66,111,108,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,191,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,97,1,0,0,0,0,0,57,180,200,118,190,159,240,63,224,95,1,0,0,0,0,0,47,221,36,6,129,149,241,63,16,93,1,0,0,0,0,0,135,22,217,206,247,83,241,63,32,91,1,0,0,0,0,0,147,24,4,86,14,45,240,63,104,134,1,0,0,0,0,0,49,8,172,28,90,100,239,63,8,131,1,0,0,0,0,0,133,235,81,184,30,133,239,63,176,132,1,0,0,0,0,0,227,165,155,196,32,176,238,63,88,128,1,0,0,0,0,0,0,0,0,0,0,0,240,63,48,109,1,0,0,0,0,0,8,172,28,90,100,59,245,63,176,102,1,0,0,0,0,0,8,172,28,90,100,59,245,63,232,105,1,0,0,0,0,0,176,114,104,145,237,124,243,63,16,100,1,0,0,0,0,0,219,249,126,106,188,116,245,63,224,45,1,0,0,0,0,0,78,98,16,88,57,180,236,63,168,141,2,0,0,0,0,0,155,85,159,171,173,216,243,63,88,141,2,0,0,0,0,0,210,111,95,7,206,25,237,63,40,141,2,0,0,0,0,0,39,194,134,167,87,202,243,63,8,141,2,0,0,0,0,0,188,150,144,15,122,54,237,63,240,140,2,0,0,0,0,0,84,82,39,160,137,176,246,63,216,140,2,0,0,0,0,0,215,163,112,61,10,215,241,63,192,140,2,0,0,0,0,0,233,72,46,255,33,253,236,63,160,140,2,0,0,0,0,0,28,124,97,50,85,48,246,63,120,140,2,0,0,0,0,0,224,190,14,156,51,162,246,63,88,140,2,0,0,0,0,0,238,235,192,57,35,74,243,63,48,140,2,0,0,0,0,0,208,213,86,236,47,187,242,63,248,139,2,0,0,0,0,0,201,118,190,159,26,47,245,63,208,139,2,0,0,0,0,0,178,157,239,167,198,75,245,63,128,139,2,0,0,0,0,0,238,235,192,57,35,74,243,63,104,139,2,0,0,0,0,0,121,88,168,53,205,59,243,63,64,139,2,0,0,0,0,0,121,88,168,53,205,59,243,63,16,139,2,0,0,0,0,0,233,72,46,255,33,253,236,63,248,138,2,0,0,0,0,0,233,72,46,255,33,253,236,63,216,138,2,0,0,0,0,0,233,72,46,255,33,253,236,63,200,138,2,0,0,0,0,0,135,22,217,206,247,83,249,63,168,138,2,0,0,0,0,0,211,77,98,16,88,57,242,63,128,138,2,0,0,0,0,0,211,77,98,16,88,57,242,63,96,138,2,0,0,0,0,0,47,221,36,6,129,149,241,63,56,138,2,0,0,0,0,0,147,24,4,86,14,45,240,63,40,138,2,0,0,0,0,0,176,114,104,145,237,124,243,63,16,138,2,0,0,0,0,0,219,249,126,106,188,116,245,63,0,138,2,0,0,0,0,0,227,165,155,196,32,176,238,63,232,137,2,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,160,15,0,0,0,0,0,0,255,255,255,255,0,0,0,0,112,23,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,251,255,255,255,0,0,0,0,152,190,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,36,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,153,1,0,40,151,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,240,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,63,1,0,0,0,6,0,0,0,252,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,1,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,2,0,0,0,0,0,0,0,0,0,0,0,0,56,143,192,0,0,0,0,0,56,143,192,0,0,0,0,0,56,143,192,0,0,0,0,0,56,143,192,0,0,0,0,0,56,143,192,0,0,0,0,0,56,143,192,0,0,0,0,0,56,143,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,37,45,49,55,115,32,32,37,115,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,1,0,0,0,0,0,0,0,0,0,0,0,252,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,252,255,255,255,0,0,0,0,0,0,0,0,1,0,0,0,252,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,46,1,0,0,0,0,0,224,61,3,0,1,0,0,0,112,22,3,0,2,0,0,0,96,89,1,0,3,0,0,0,96,231,1,0,4,0,0,0,88,166,1,0,5,0,0,0,176,166,1,0,6,0,0,0,96,244,2,0,7,0,0,0,208,174,2,0,8,0,0,0,192,222,1,0,9,0,0,0,8,112,3,0,10,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,122,0,0,0,1,0,0,0,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,121,0,0,0,5,0,0,0,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,120,0,0,0,5,0,0,0,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,99,98,0,0,5,0,0,0,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,122,50,0,0,0,0,0,0,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,121,50,0,0,0,0,0,0,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,120,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,64,114,0,0,0,2,0,0,0,0,0,0,0,0,0,20,192,0,0,0,0,0,0,20,64,116,0,0,0,0,0,0,0,0,0,0,0,0,0,20,192,0,0,0,0,0,0,20,64,117,0,0,0,0,0,0,0,0,0,0,0,0,0,20,192,0,0,0,0,0,0,20,64,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
.concat([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,37,32,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,100,47,37,109,47,37,121,44,37,72,58,37,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,36,64,0,0,0,0,0,0,240,63,0,0,0,0,0,0,224,63,1,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,37,32,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,100,47,37,109,47,37,121,44,37,72,58,37,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,36,64,0,0,0,0,0,0,240,63,0,0,0,0,0,0,224,63,1,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,37,32,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,100,47,37,109,47,37,121,44,37,72,58,37,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,36,64,0,0,0,0,0,0,240,63,0,0,0,0,0,0,224,63,1,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,37,32,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,100,47,37,109,47,37,121,44,37,72,58,37,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,36,64,0,0,0,0,0,0,240,63,0,0,0,0,0,0,224,63,1,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,37,32,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,100,47,37,109,47,37,121,44,37,72,58,37,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,36,64,0,0,0,0,0,0,240,63,0,0,0,0,0,0,224,63,1,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,37,32,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,100,47,37,109,47,37,121,44,37,72,58,37,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,36,64,0,0,0,0,0,0,240,63,0,0,0,0,0,0,224,63,1,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,37,32,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,100,47,37,109,47,37,121,44,37,72,58,37,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,36,64,0,0,0,0,0,0,240,63,0,0,0,0,0,0,224,63,1,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,37,32,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,100,47,37,109,47,37,121,44,37,72,58,37,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,36,64,0,0,0,0,0,0,240,63,0,0,0,0,0,0,224,63,1,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,37,32,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,100,47,37,109,47,37,121,44,37,72,58,37,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,36,64,0,0,0,0,0,0,240,63,0,0,0,0,0,0,224,63,1,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,37,32,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,100,47,37,109,47,37,121,44,37,72,58,37,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,36,64,0,0,0,0,0,0,240,63,0,0,0,0,0,0,224,63,1,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,36,192,0,0,0,0,0,0,36,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
.concat([0,0,0,0,1,37,32,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,100,47,37,109,47,37,121,44,37,72,58,37,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,36,64,0,0,0,0,0,0,240,63,0,0,0,0,0,0,224,63,1,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,77,2,0,176,69,2,0,240,61,2,0,128,53,2,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,97,110,0,0,0,0,0,70,101,98,0,0,0,0,0,77,97,114,0,0,0,0,0,65,112,114,0,0,0,0,0,77,97,121,0,0,0,0,0,74,117,110,0,0,0,0,0,74,117,108,0,0,0,0,0,65,117,103,0,0,0,0,0,83,101,112,0,0,0,0,0,79,99,116,0,0,0,0,0,78,111,118,0,0,0,0,0,68,101,99,0,0,0,0,0,83,117,110,0,0,0,0,0,77,111,110,0,0,0,0,0,84,117,101,0,0,0,0,0,87,101,100,0,0,0,0,0,84,104,117,0,0,0,0,0,70,114,105,0,0,0,0,0,83,97,116,0,0,0,0,0,0,0,0,0,0,0,0,0,112,108,111,116,95,97,120,105,115,95,120,109,97,120,0,0,71,80,86,65,76,95,88,95,77,65,88,0,0,0,0,0,103,110,117,112,108,111,116,95,115,118,103,46,37,115,32,61,32,37,103,59,10,0,0,0,87,105,108,108,32,110,111,116,32,99,104,101,99,107,32,102,111,114,32,117,110,100,101,102,105,110,101,100,32,100,97,116,97,112,111,105,110,116,115,32,40,109,97,121,32,99,97,117,115,101,32,99,114,97,115,104,101,115,41,46,10,0,0,0,117,110,100,101,102,105,110,101,100,32,118,97,114,105,97,98,108,101,58,32,37,115,0,0,101,120,101,99,117,116,105,110,103,58,32,37,115,0,0,0,112,108,111,116,95,97,120,105,115,95,120,109,105,110,0,0,65,109,98,105,103,117,111,117,115,32,114,101,113,117,101,115,116,32,39,37,46,42,115,39,59,32,112,111,115,115,105,98,108,101,32,109,97,116,99,104,101,115,58,10,0,0,0,0,103,110,117,112,108,111,116,95,115,118,103,46,37,115,32,61,32,37,100,59,10,0,0,0,116,109,95,109,100,97,121,0,97,108,108,95,116,101,114,109,95,110,97,109,101,115,50,0,71,80,86,65,76,95,88,95,77,73,78,0,0,0,0,0,108,115,0,0,0,0,0,0,105,110,100,101,120,95,109,105,110,0,0,0,0,0,0,0,110,111,32,99,111,108,117,109,110,32,119,105,116,104,32,104,101,97,100,101,114,32,34,37,115,34,0,0,0,0,0,0,103,110,117,112,108,111,116,95,115,118,103,46,112,108,111,116,95,104,101,105,103,104,116,32,61,32,37,46,49,102,59,10,0,0,0,0,0,0,0,0,10,9,85,115,101,114,32,97,110,100,32,100,101,102,97,117,108,116,32,118,97,114,105,97,98,108,101,115,58,10,0,0,114,101,108,36,97,116,105,118,101,0,0,0,0,0,0,0,103,110,117,112,108,111,116,95,115,118,103,46,112,108,111,116,95,119,105,100,116,104,32,61,32,37,46,49,102,59,10,0,99,104,97,110,103,101,32,118,105,101,119,32,40,115,99,97,108,105,110,103,41,46,32,85,115,101,32,60,99,116,114,108,62,32,116,111,32,115,99,97,108,101,32,116,104,101,32,97,120,101,115,32,111,110,108,121,46,0,0,0,0,0,0,0,103,110,117,112,108,111,116,95,115,118,103,46,112,108,111,116,95,121,116,111,112,32,61,32,37,46,49,102,59,10,0,0,103,110,117,112,108,111,116,95,115,118,103,46,112,108,111,116,95,121,98,111,116,32,61,32,37,46,49,102,59,10,0,0,103,110,117,112,108,111,116,95,115,118,103,46,112,108,111,116,95,120,109,97,120,32,61,32,37,46,49,102,59,10,0,0,101,108,108,105,112,115,101,0,103,110,117,112,108,111,116,95,115,118,103,46,112,108,111,116,95,120,109,105,110,32,61,32,37,46,49,102,59,10,0,0,103,110,117,112,108,111,116,95,115,118,103,46,112,108,111,116,95,116,101,114,109,95,121,109,97,120,32,61,32,37,100,59,10,0,0,0,0,0,0,0,67,111,110,116,105,110,117,101,46,0,0,0,0,0,0,0,103,110,117,112,108,111,116,95,115,118,103,46,112,108,111,116,95,116,101,114,109,95,120,109,97,120,32,61,32,37,100,59,10,0,0,0,0,0,0,0,122,116,105,99,115,0,0,0,47,47,32,112,108,111,116,32,98,111,117,110,100,97,114,105,101,115,32,97,110,100,32,97,120,105,115,32,115,99,97,108,105,110,103,32,105,110,102,111,114,109,97,116,105,111,110,32,102,111,114,32,109,111,117,115,105,110,103,32,10,0,0,0,116,109,95,104,111,117,114,0,37,115,32,0,0,0,0,0,10,60,115,99,114,105,112,116,32,116,121,112,101,61,34,116,101,120,116,47,106,97,118,97,115,99,114,105,112,116,34,62,60,33,91,67,68,65,84,65,91,10,0,0,0,0,0,0,108,105,110,101,116,121,112,101,36,115,0,0,0,0,0,0,115,117,109,115,113,0,0,0,115,116,114,105,110,103,99,111,108,117,109,110,40,41,32,99,97,108,108,101,100,32,102,114,111,109,32,105,110,118,97,108,105,100,32,99,111,110,116,101,120,116,0,0,0,0,0,0,32,57,44,52,44,49,44,52,44,49,44,52,0,0,0,0,10,9,86,97,114,105,97,98,108,101,115,32,98,101,103,105,110,110,105,110,103,32,119,105,116,104,32,37,115,58,10,0,32,56,44,52,44,50,44,52,0,0,0,0,0,0,0,0,116,105,109,101,32,102,111,114,109,97,116,32,115,116,114,105,110,103,32,101,120,112,101,99,116,101,100,0,0,0,0,0,10,37,115,111,98,106,101,99,116,32,37,50,100,32,0,0,68,105,109,95,49,0,0,0,60,66,50,45,77,111,116,105,111,110,62,0,0,0,0,0,104,101,97,100,32,115,105,122,101,32,101,120,112,101,99,116,101,100,0,0,0,0,0,0,32,50,44,52,0,0,0,0,32,53,44,56,0,0,0,0,83,117,98,116,111,112,105,99,32,111,102,32,0,0,0,0,32,100,61,39,0,0,0,0,99,108,97,115,115,61,34,103,114,105,100,108,105,110,101,34,32,0,0,0,0,0,0,0,115,116,114,111,107,101,45,100,97,115,104,97,114,114,97,121,61,39,37,115,39,32,0,0,83,116,111,112,46,0,0,0,115,116,114,111,107,101,61,39,37,115,39,32,0,0,0,0,115,116,114,111,107,101,61,39,114,103,98,40,37,51,100,44,32,37,51,100,44,32,37,51,100,41,39,32,0,0,0,0,116,109,95,109,105,110,0,0,32,0,0,0,0,0,0,0,9,60,112,97,116,104,32,0,108,105,110,101,115,36,116,121,108,101,0,0,0,0,0,0,77,37,46,49,102,44,37,46,49,102,32,0,0,0,0,0,10,9,65,108,108,32,97,118,97,105,108,97,98,108,101,32,118,97,114,105,97,98,108,101,115,58,10,0,0,0,0,0,10,9,9,9,32,32,32,32,116,111,32,0,0,0,0,0,10,9,9,0,0,0,0,0,76,37,46,49,102,44,37,46,49,102,32,0,0,0,0,0,99,104,97,110,103,101,32,118,105,101,119,32,40,114,111,116,97,116,105,111,110,41,46,32,85,115,101,32,60,99,116,114,108,62,32,116,111,32,114,111,116,97,116,101,32,116,104,101,32,97,120,101,115,32,111,110,108,121,46,0,0,0,0,0,60,47,116,101,120,116,62,10,9,60,47,103,62,10,0,0,38,97,109,112,59,0,0,0,38,108,116,59,0,0,0,0,9,9,60,116,101,120,116,62,0,0,0,0,0,0,0,0,10,10,40,83,41,116,111,112,32,102,105,116,44,32,40,67,41,111,110,116,105,110,117,101,44,32,40,69,41,120,101,99,117,116,101,32,70,73,84,95,83,67,82,73,80,84,58,32,32,0,0,0,0,0,0,0,9,9,60,116,101,120,116,32,120,109,108,58,115,112,97,99,101,61,34,112,114,101,115,101,114,118,101,34,62,0,0,0,32,32,0,0,0,0,0,0,116,109,95,115,101,99,0,0,97,108,108,95,116,101,114,109,95,110,97,109,101,115,0,0,32,116,101,120,116,45,97,110,99,104,111,114,58,37,115,34,62,10,0,0,0,0,0,0,108,97,36,98,101,108,0,0,99,114,101,97,116,101,95,97,110,100,95,115,101,116,95,118,97,114,0,0,0,0,0,0,99,111,108,117,109,110,40,41,32,99,97,108,108,101,100,32,102,114,111,109,32,105,110,118,97,108,105,100,32,99,111,110,116,101,120,116,0,0,0,0,32,102,111,110,116,45,115,116,121,108,101,58,37,115,59,0,97,108,108,0,0,0,0,0,32,102,111,110,116,45,119,101,105,103,104,116,58,37,115,59,0,0,0,0,0,0,0,0,37,97,32,37,98,32,37,100,32,37,72,58,37,77,58,37,83,32,37,89,0,0,0,0,37,115,111,98,106,101,99,116,32,37,50,100,32,112,111,108,121,103,111,110,32,0,0,0,60,66,49,45,77,111,116,105,111,110,62,0,0,0,0,0,110,111,102,105,108,108,36,101,100,0,0,0,0,0,0,0,59,32,102,111,110,116,45,102,97,109,105,108,121,58,37,115,59,32,102,111,110,116,45,115,105,122,101,58,37,46,50,102,112,116,59,0,0,0,0,0,114,103,98,40,37,100,44,37,100,44,37,100,41,0,0,0,104,101,108,112,32,112,114,111,109,112,116,0,0,0,0,0,34,32,115,116,121,108,101,61,34,115,116,114,111,107,101,58,110,111,110,101,59,32,102,105,108,108,58,0,0,0,0,0,32,114,111,116,97,116,101,40,37,105,41,0,0,0,0,0,9,60,103,32,116,114,97,110,115,102,111,114,109,61,34,116,114,97,110,115,108,97,116,101,40,37,46,49,102,44,37,46,49,102,41,0,0,0,0,0,37,115,95,101,114,114,0,0,101,110,100,0,0,0,0,0,109,105,100,100,108,101,0,0,101,120,112,105,110,116,0,0,32,32,37,49,53,115,32,32,37,115,10,0,0,0,0,0,115,116,97,114,116,0,0,0,107,101,121,116,36,105,116,108,101,0,0,0,0,0,0,0,112,111,115,95,109,97,120,95,121,0,0,0,0,0,0,0,68,97,116,97,32,102,105,108,101,32,105,115,32,101,109,112,116,121,0,0,0,0,0,0,9,60,117,115,101,32,120,108,105,110,107,58,104,114,101,102,61,39,35,103,112,80,116,37,117,39,32,116,114,97,110,115,102,111,114,109,61,39,116,114,97,110,115,108,97,116,101,40,37,46,49,102,44,37,46,49,102,41,32,115,99,97,108,101,40,37,46,50,102,41,39,37,115,47,62,10,0,0,0,0,108,105,110,101,115,116,121,108,101,32,110,111,116,32,102,111,117,110,100,0,0,0,0,0,9,60,117,115,101,32,120,108,105,110,107,58,104,114,101,102,61,39,35,103,112,68,111,116,39,32,120,61,39,37,46,49,102,39,32,121,61,39,37,46,49,102,39,37,115,47,62,10,0,0,0,0,0,0,0,0,109,97,114,107,32,122,111,111,109,32,114,101,103,105,111,110,32,40,111,110,108,121,32,102,111,114,32,50,100,45,112,108,111,116,115,32,97,110,100,32,109,97,112,115,41,46,0,0,32,99,111,108,111,114,61,39,37,115,39,0,0,0,0,0,32,99,111,108,111,114,61,39,114,103,98,40,37,51,100,44,32,37,51,100,44,32,37,51,100,41,39,0,0,0,0,0,104,101,108,112,32,98,117,102,102,101,114,0,0,0,0,0,98,111,108,100,0,0,0,0,105,116,97,108,105,99,0,0,47,117,115,114,47,108,111,99,97,108,47,115,104,97,114,101,47,103,110,117,112,108,111,116,47,52,46,54,0,0,0,0,32,73,116,97,108,105,99,0,37,46,48,102,0,0,0,0,32,105,116,97,108,105,99,0,101,120,112,101,99,116,101,100,32,111,112,116,105,111,110,97,108,32,97,120,105,115,32,110,97,109,101,0,0,0,0,0,37,109,47,37,100,47,37,121,0,0,0,0,0,0,0,0,32,66,111,108,100,0,0,0,97,105,114,121,0,0,0,0,10,65,118,97,105,108,97,98,108,101,32,116,101,114,109,105,110,97,108,32,116,121,112,101,115,58,10,0,0,0,0,0,32,98,111,108,100,0,0,0,34,62,10,0,0,0,0,0,107,36,101,121,0,0,0,0,112,111,115,95,109,105,110,95,121,0,0,0,0,0,0,0,68,97,116,97,32,102,105,108,101,32,114,101,97,100,32,101,114,114,111,114,0,0,0,0,80,65,71,69,82,0,0,0,9,108,105,110,101,115,116,121,108,101,32,37,100,44,32,0,109,105,116,101,114,0,0,0,60,66,51,62,0,0,0,0,102,105,108,108,36,101,100,0,59,32,115,116,114,111,107,101,45,119,105,100,116,104,58,37,46,50,102,59,32,115,116,114,111,107,101,45,108,105,110,101,99,97,112,58,37,115,59,32,115,116,114,111,107,101,45,108,105,110,101,106,111,105,110,58,37,115,0,0,0,0,0,0,99,117,114,114,101,110,116,67,111,108,111,114,0,0,0,0,99,112,49,50,53,48,0,0,32,111,112,101,110,32,121,108,111,119,32,121,104,105,103,104,32,121,99,108,111,115,101,32,119,105,100,116,104,0,0,0,114,103,98,40,37,51,100,44,32,37,51,100,44,32,37,51,100,41,0,0,0,0,0,0,60,103,32,115,116,121,108,101,61,34,102,105,108,108,58,110,111,110,101,59,32,99,111,108,111,114,58,37,115,59,32,115,116,114,111,107,101,58,0,0,37,54,46,51,102,32,0,0,9,9,60,47,112,97,116,116,101,114,110,62,10,9,60,47,100,101,102,115,62,10,0,0,9,9,9,60,112,97,116,104,32,115,116,121,108,101,32,61,32,39,37,115,32,37,115,58,99,117,114,114,101,110,116,67,111,108,111,114,39,32,100,61,39,37,115,39,47,62,10,0,108,97,109,98,101,114,116,119,0,0,0,0,0,0,0,0,108,105,115,116,95,116,101,114,109,115,0,0,0,0,0,0,9,9,9,60,112,97,116,104,32,115,116,121,108,101,32,61,32,39,37,115,32,37,115,58,37,115,39,32,100,61,32,39,37,115,39,47,62,10,0,0,105,115,36,111,115,97,109,112,108,101,115,0,0,0,0,0,32,32,68,97,116,97,32,66,108,111,99,107,115,58,32,32,37,42,108,100,10,0,0,0,102,36,105,116,0,0,0,0,9,9,9,60,112,97,116,104,32,115,116,121,108,101,61,39,37,115,32,37,115,58,114,103,98,40,37,100,44,37,100,44,37,100,41,39,32,100,61,39,37,115,39,47,62,10,0,0,108,105,110,101,116,121,112,101,32,110,111,116,32,102,111,117,110,100,0,0,0,0,0,0,83,116,97,116,115,32,99,111,109,109,97,110,100,32,110,111,116,32,97,118,97,105,108,97,98,108,101,32,105,110,32,112,111,108,97,114,32,109,111,100,101,0,0,0,0,0,0,0,115,116,114,111,107,101,58,110,111,110,101,59,0,0,0,0,114,101,109,111,118,101,32,108,97,98,101,108,32,99,108,111,115,101,32,116,111,32,112,111,105,110,116,101,114,32,105,102,32,96,115,101,116,32,109,111,117,115,101,32,108,97,98,101,108,115,96,32,105,115,32,111,110,0,0,0,0,0,0,0,102,105,108,108,58,110,111,110,101,59,0,0,0,0,0,0,10,37,115,32,0,0,0,0,77,45,50,44,48,32,76,52,44,49,50,32,77,48,44,45,52,32,76,56,44,49,50,32,77,52,44,45,52,32,76,49,48,44,56,0,0,0,0,0,77,45,50,44,56,32,76,52,44,45,52,32,77,48,44,49,50,32,76,56,44,45,52,32,77,52,44,49,50,32,76,49,48,44,48,0,0,0,0,0,77,45,52,44,56,32,76,56,44,45,52,32,77,48,44,49,50,32,76,49,50,44,48,0,77,45,52,44,48,32,76,56,44,49,50,32,77,48,44,45,52,32,76,49,50,44,56,0,37,45,49,53,46,49,53,115,0,0,0,0,0,0,0,0,85,110,114,101,99,111,103,110,105,122,101,100,32,111,112,116,105,111,110,46,32,83,101,101,32,39,104,101,108,112,32,115,104,111,119,39,46,0,0,0,77,48,44,48,32,76,48,44,56,32,76,56,44,56,32,76,56,44,48,32,76,48,44,48,0,0,0,0,0,0,0,0,77,48,44,48,32,76,56,44,56,32,77,48,44,56,32,76,56,44,48,32,77,48,44,52,32,76,52,44,56,32,76,56,44,52,32,76,52,44,48,32,76,48,44,52,0,0,0,0,97,116,97,110,104,0,0,0,90,97,112,102,32,68,105,110,103,98,97,116,115,0,0,0,77,48,44,48,32,76,56,44,56,32,77,48,44,56,32,76,56,44,48,0,0,0,0,0,104,105,115,36,116,111,114,121,115,105,122,101,0,0,0,0,32,32,66,108,97,110,107,58,32,32,32,32,32,32,32,32,37,42,108,100,10,0,0,0,46,46,46,0,0,0,0,0,9,60,100,101,102,115,62,10,9,9,60,112,97,116,116,101,114,110,32,105,100,61,39,103,112,80,97,116,37,100,39,32,112,97,116,116,101,114,110,85,110,105,116,115,61,39,117,115,101,114,83,112,97,99,101,79,110,85,115,101,39,32,120,61,39,48,39,32,121,61,39,48,39,32,119,105,100,116,104,61,39,56,39,32,104,101,105,103,104,116,61,39,56,39,62,10,0,0,0,0,0,0,0,0,9,108,105,110,101,116,121,112,101,32,37,100,44,32,0,0,110,111,102,111,114,116,36,114,97,110,0,0,0,0,0,0,103,112,98,105,110,0,0,0,32,117,110,105,116,115,32,0,115,116,114,111,107,101,0,0,60,67,116,114,108,45,66,50,62,0,0,0,0,0,0,0,9,60,103,32,115,116,121,108,101,32,61,32,39,115,116,114,111,107,101,58,110,111,110,101,59,32,115,104,97,112,101,45,114,101,110,100,101,114,105,110,103,58,99,114,105,115,112,69,100,103,101,115,39,62,10,0,103,101,110,95,111,110,101,95,99,111,110,116,111,117,114,58,32,110,111,32,99,111,110,116,111,117,114,32,102,111,117,110,100,10,0,0,0,0,0,0,37,115,32,61,32,39,99,117,114,114,101,110,116,67,111,108,111,114,39,0,0,0,0,0,32,60,32,0,0,0,0,0,37,115,32,61,32,39,37,115,39,0,0,0,0,0,0,0,99,97,110,110,111,116,32,98,101,32,104,101,114,101,0,0,78,101,101,100,32,102,117,108,108,32,117,115,105,110,103,32,115,112,101,99,32,102,111,114,32,121,32,116,105,109,101,32,100,97,116,97,0,0,0,0,37,115,32,61,32,39,114,103,98,40,37,51,100,44,32,37,51,100,44,32,37,51,100,41,39,0,0,0,0,0,0,0,102,105,108,108,0,0,0,0,45,45,100,101,102,97,117,108,116,45,115,101,116,116,105,110,103,115,0,0,0,0,0,0,37,45,54,46,54,115,32,0,39,47,62,10,0,0,0,0,117,115,101,114,32,102,117,110,99,0,0,0,0,0,0,0,37,46,49,102,44,37,46,49,102,37,115,0,0,0,0,0,97,99,111,115,104,0,0,0,90,97,112,102,32,67,104,97,110,99,101,114,121,32,77,101,100,105,117,109,32,73,116,97,108,105,99,0,0,0,0,0,32,112,111,105,110,116,115,32,61,32,39,0,0,0,0,0,109,111,114,101,62,32,0,0,104,105,100,36,100,101,110,51,100,0,0,0,0,0,0,0,32,32,73,110,118,97,108,105,100,58,32,32,32,32,32,32,37,42,108,100,10,0,0,0,96,98,117,105,108,116,105,110,45,116,111,103,103,108,101,45,114,117,108,101,114,96,0,0,37,46,55,55,115,37,115,10,37,115,58,37,100,58,0,0,32,102,105,108,108,32,61,32,39,117,114,108,40,35,103,112,80,97,116,37,100,41,39,0,9,76,105,110,101,116,121,112,101,115,32,114,101,112,101,97,116,32,101,118,101,114,121,32,37,100,32,117,110,108,101,115,115,32,101,120,112,108,105,99,105,116,108,121,32,100,101,102,105,110,101,100,10,0,0,0,32,32,97,110,103,108,101,32,37,103,0,0,0,0,0,0,32,102,105,108,108,45,111,112,97,99,105,116,121,32,61,32,39,37,102,39,0,0,0,0,47,121,115,116,101,112,32,49,32,105,109,97,120,32,100,105,118,32,100,101,102,32,47,121,48,32,48,32,100,101,102,32,47,105,105,32,48,32,100,101,102,10,0,0,0,0,0,0,67,97,110,110,111,116,32,111,112,101,110,32,37,115,32,102,105,108,101,32,39,37,115,39,0,0,0,0,0,0,0,0,99,117,114,118,101,0,0,0,120,32,112,111,115,0,0,0,111,114,32,100,114,97,119,32,108,97,98,101,108,115,32,105,102,32,96,115,101,116,32,109,111,117,115,101,32,108,97,98,101,108,115,32,105,115,32,111,110,96,0,0,0,0,0,0,32,102,105,108,108,32,61,32,39,37,115,39,0,0,0,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,32,58,32,116,121,112,101,32,110,101,105,116,104,101,114,32,73,78,84,32,111,114,32,67,77,80,76,88,0,0,0,0,0,0,9,9,60,112,111,108,121,103,111,110,32,0,0,0,0,0,99,97,110,110,111,116,32,115,101,116,32,114,97,110,103,101,32,119,105,116,104,32,114,101,112,108,111,116,0,0,0,0,32,120,109,108,58,115,112,97,99,101,61,34,112,114,101,115,101,114,118,101,34,0,0,0,32,102,105,108,108,61,34,110,111,110,101,34,0,0,0,0,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,0,32,100,121,61,34,37,46,50,102,112,116,34,0,0,0,0,32,100,120,61,34,37,46,50,102,101,109,34,0,0,0,0,97,115,105,110,104,0,0,0,83,121,109,98,111,108,0,0,32,102,111,110,116,45,115,116,121,108,101,61,34,37,115,34,32,0,0,0,0,0,0,0,103,36,114,105,100,0,0,0,32,32,79,117,116,32,111,102,32,114,97,110,103,101,58,32,37,42,108,100,10,0,0,0,82,101,119,105,110,100,105,110,103,32,102,100,32,37,100,10,0,0,0,0,0,0,0,0,32,102,111,110,116,45,119,101,105,103,104,116,61,34,37,115,34,32,0,0,0,0,0,0,40,37,115,37,103,44,32,37,115,37,103,44,32,37,115,37,103,41,0,0,0,0,0,0,122,0,0,0,0,0,0,0,44,32,37,115,37,103,0,0,110,111,114,109,97,108,0,0,73,110,32,108,111,103,32,109,111,100,101,32,114,114,97,110,103,101,32,109,117,115,116,32,110,111,116,32,105,110,99,108,117,100,101,32,48,0,0,0,97,110,110,111,116,97,116,101,32,116,104,101,32,103,114,97,112,104,32,117,115,105,110,103,32,96,109,111,117,115,101,102,111,114,109,97,116,96,32,40,115,101,101,32,107,101,121,115,32,39,49,39,44,32,39,50,39,41,0,0,0,0,0,0,32,102,111,110,116,45,115,105,122,101,61,34,37,46,49,102,112,116,34,0,0,0,0,0,32,115,116,121,108,101,61,34,102,111,110,116,45,102,97,109,105,108,121,58,37,115,34,32,0,0,0,0,0,0,0,0,60,116,115,112,97,110,0,0,60,116,115,112,97,110,32,100,120,61,34,45,37,46,49,102,101,109,34,32,100,121,61,34,37,46,49,102,112,116,34,62,0,0,0,0,0,0,0,0,79,110,108,121,32,117,110,100,101,102,105,110,101,100,32,100,97,116,97,112,111,105,110,116,115,32,97,114,101,32,111,109,105,116,116,101,100,32,102,114,111,109,32,116,104,101,32,115,117,114,102,97,99,101,46,10,0,0,0,0,0,0,0,0,37,115,60,47,116,115,112,97,110,62,0,0,0,0,0,0,10,10,99,111,114,114,101,108,97,116,105,111,110,32,109,97,116,114,105,120,32,111,102,32,116,104,101,32,102,105,116,32,112,97,114,97,109,101,116,101,114,115,58,10,10,0,0,0,60,47,103,62,10,0,0,0,10,72,101,108,112,32,116,111,112,105,99,115,32,97,118,97,105,108,97,98,108,101,58,10,0,0,0,0,0,0,0,0,62,10,0,0,0,0,0,0,105,110,118,110,111,114,109,0,80,97,108,97,116,105,110,111,32,66,111,108,100,32,73,116,97,108,105,99,0,0,0,0,111,110,99,108,105,99,107,61,34,103,110,117,112,108,111,116,95,115,118,103,46,116,111,103,103,108,101,86,105,115,105,98,105,108,105,116,121,40,101,118,116,44,39,37,115,95,112,108,111,116,95,37,100,37,115,39,41,34,0,0,0,0,0,0,102,117,36,110,99,116,105,111,110,115,0,0,0,0,0,0,32,32,82,101,99,111,114,100,115,58,32,32,32,32,32,32,37,42,108,100,10,0,0,0,83,107,105,112,112,105,110,103,32,117,110,114,101,97,100,97,98,108,101,32,102,105,108,101,32,34,37,115,34,0,0,0,9,60,103,32,118,105,115,105,98,105,108,105,116,121,61,34,118,105,115,105,98,108,101,34,32,0,0,0,0,0,0,0,40,99,104,97,114,97,99,116,101,114,32,117,110,105,116,115,41,32,0,0,0,0,0,0,37,115,111,98,106,101,99,116,32,37,50,100,32,101,108,108,105,112,115,101,32,0,0,0,62,60,116,105,116,108,101,62,37,115,95,112,108,111,116,95,37,100,37,115,60,47,116,105,116,108,101,62,10,0,0,0,84,104,105,115,32,112,108,111,116,32,115,116,121,108,101,32,100,111,101,115,32,110,111,116,32,119,111,114,107,32,119,105,116,104,32,54,32,99,111,108,115,46,32,83,101,116,116,105,110,103,32,116,111,32,120,121,101,114,114,111,114,98,97,114,115,0,0,0,0,0,0,0,60,66,50,62,0,0,0,0,9,60,103,32,105,100,61,34,37,115,95,112,108,111,116,95,37,100,37,115,34,32,0,0,103,110,117,112,108,111,116,0,105,110,118,97,108,105,100,32,99,111,109,109,97,110,100,0,9,60,47,103,62,10,0,0,32,104,48,46,48,49,39,47,62,0,0,0,0,0,0,0,90,32,0,0,0,0,0,0,43,47,45,0,0,0,0,0,100,36,97,115,104,101,100,0,91,0,0,0,0,0,0,0,105,110,118,101,114,102,0,0,80,97,108,97,116,105,110,111,32,66,111,108,100,0,0,0,108,36,97,110,100,115,99,97,112,101,0,0,0,0,0,0,102,117,36,110,99,116,105,111,110,0,0,0,0,0,0,0,42,32,70,73,76,69,58,32,10,0,0,0,0,0,0,0,114,98,0,0,0,0,0,0,112,36,111,114,116,114,97,105,116,0,0,0,0,0,0,0,40,115,99,114,101,101,110,32,117,110,105,116,115,41,32,0,32,97,114,99,32,91,37,103,58,37,103,93,32,0,0,0,32,37,115,32,102,111,110,116,32,34,37,115,44,37,117,34,0,0,0,0,0,0,0,0,85,110,114,101,99,111,103,110,105,122,101,100,32,53,32,99,111,108,117,109,110,32,112,108,111,116,32,115,116,121,108,101,59,32,114,101,115,101,116,116,105,110,103,32,116,111,32,98,111,120,101,114,114,111,114,98,97,114,115,0,0,0,0,0,32,108,105,110,101,119,105,100,116,104,32,37,102,0,0,0,112,114,105,110,116,32,99,111,111,114,100,105,110,97,116,101,115,32,116,111,32,99,108,105,112,98,111,97,114,100,32,117,115,105,110,103,32,96,99,108,105,112,98,111,97,114,100,102,111,114,109,97,116,96,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,40,115,101,101,32,107,101,121,115,32,39,51,39,44,32,39,52,39,41,0,0,97,114,114,111,119,115,36,116,121,108,101,0,0,0,0,0,69,68,70,95,66,105,110,97,114,121,70,105,108,101,80,111,115,105,116,105,111,110,0,0,32,109,111,110,111,99,104,114,111,109,101,0,0,0,0,0,78,101,119,32,112,97,114,97,109,101,116,101,114,32,102,105,108,101,110,97,109,101,32,101,120,112,101,99,116,101,100,0,108,97,110,100,115,99,97,112,101,0,0,0,0,0,0,0,112,111,114,116,114,97,105,116,0,0,0,0,0,0,0,0,37,115,32,91,37,117,44,37,117,93,0,0,0,0,0,0,37,45,49,53,46,49,53,115,32,61,32,37,45,49,53,103,32,32,37,45,51,46,51,115,32,37,45,49,50,46,52,103,32,40,37,46,52,103,37,37,41,10,0,0,0,0,0,0,69,120,112,101,99,116,105,110,103,32,102,111,110,116,32,110,97,109,101,32,0,0,0,0,101,120,112,101,99,116,105,110,103,32,39,93,39,0,0,0,110,111,114,109,0,0,0,0,80,97,108,97,116,105,110,111,32,73,116,97,108,105,99,0,93,0,0,0,0,0,0,0,102,111,36,114,109,97,116,0,111,117,116,111,102,114,97,110,103,101,0,0,0,0,0,0,34,37,115,34,32,105,115,32,97,32,100,105,114,101,99,116,111,114,121,0,0,0,0,0,39,44,39,32,101,120,112,101,99,116,101,100,0,0,0,0,40,103,114,97,112,104,32,117,110,105,116,115,41,32,0,0,110,111,101,113,117,97,108,36,95,97,120,101,115,0,0,0,37,115,37,103,0,0,0,0,110,111,46,32,119,105,110,100,111,119,115,58,32,91,104,111,114,105,122,111,110,116,97,108,44,118,101,114,116,105,99,97,108,93,32,101,120,112,101,99,116,101,100,0,0,0,0,0,84,104,105,115,32,112,108,111,116,32,115,116,121,108,101,32,100,111,101,115,32,110,111,116,32,119,111,114,107,32,119,105,116,104,32,52,32,99,111,108,115,46,32,83,101,116,116,105,110,103,32,116,111,32,121,101,114,114,111,114,98,97,114,115,0,0,0,0,0,0,0,0,108,105,110,101,119,105,100,116,104,58,32,111,117,116,32,111,102,32,114,97,110,103,101,0,50,120,60,66,49,62,0,0,97,114,114,111,119,115,116,121,108,101,32,37,100,32,110,111,116,32,102,111,117,110,100,0,108,105,110,101,119,105,100,116,104,58,32,119,105,100,116,104,32,105,115,32,110,111,116,32,115,112,101,99,105,102,105,101,100,46,0,0,0,0,0,0,80,97,114,97,109,101,116,101,114,32,102,105,108,101,110,97,109,101,32,101,120,112,101,99,116,101,100,0,0,0,0,0,37,37,84,71,73,70,32,50,46,49,53,45,112,55,10,115,116,97,116,101,40,37,100,44,51,48,44,37,117,44,48,44,48,44,37,117,44,49,54,44,49,44,57,44,49,44,49,44,48,44,48,44,48,44,48,44,49,44,48,44,39,37,115,39,44,48,44,37,117,44,48,44,48,44,49,44,49,48,44,48,44,48,44,49,44,49,44,48,44,49,54,44,48,44,48,44,49,44,49,44,49,41,46,10,37,37,10,37,37,32,64,40,35,41,67,114,101,97,116,111,114,58,32,103,110,117,112,108,111,116,32,37,115,32,112,97,116,99,104,108,101,118,101,108,32,37,115,10,37,37,32,37,37,87,37,37,10,37,37,10,112,97,103,101,40,49,44,34,34,41,46,10,0,0,0,0,119,97,114,110,105,110,103,58,32,117,115,105,110,103,32,115,116,97,110,100,97,114,100,32,109,117,108,116,105,112,108,111,116,10,0,0,0,0,0,0,101,114,114,111,114,58,32,110,117,109,98,101,114,32,111,102,32,112,108,111,116,115,32,62,32,112,108,111,116,115,32,112,101,114,32,112,97,103,101,10,0,0,0,0,0,0,0,0,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,32,32,32,32,32,32,32,32,32,32,32,32,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,10,10,0,99,111,114,97,108,0,0,0,72,111,116,80,105,110,107,0,99,101,105,108,0,0,0,0,80,97,108,97,116,105,110,111,32,82,111,109,97,110,0,0,68,97,114,107,83,101,97,71,114,101,101,110,0,0,0,0,102,111,110,116,36,112,97,116,104,0,0,0,0,0,0,0,98,108,111,99,107,115,0,0,99,97,110,110,111,116,32,99,114,101,97,116,101,32,112,105,112,101,32,102,111,114,32,100,97,116,97,0,0,0,0,0,121,101,108,108,111,119,0,0,40,115,101,99,111,110,100,32,97,120,101,115,41,32,0,0,120,121,122,0,0,0,0,0,37,115,111,98,106,101,99,116,32,37,50,100,32,99,105,114,99,108,101,32,0,0,0,0,116,101,120,116,40,39,37,115,39,44,37,117,44,37,117,44,39,37,115,39,44,48,44,37,117,44,49,44,37,117,44,37,117,44,49,44,53,53,44,49,49,57,44,37,117,44,48,44,49,53,44,52,44,48,44,48,44,48,44,48,44,91,10,9,34,37,115,34,93,41,46,10,0,0,0,0,0,0,0,0,84,104,105,115,32,112,108,111,116,32,115,116,121,108,101,32,100,111,101,115,32,110,111,116,32,119,111,114,107,32,119,105,116,104,32,51,32,99,111,108,115,46,32,83,101,116,116,105,110,103,32,116,111,32,121,101,114,114,111,114,98,97,114,115,0,0,0,0,0,0,0,0,117,110,114,101,99,111,103,110,105,122,101,100,32,99,111,108,111,114,32,110,97,109,101,32,97,110,100,32,110,111,116,32,97,32,115,116,114,105,110,103,32,34,35,65,65,82,82,71,71,66,66,34,0,0,0,0,112,111,108,121,103,111,110,40,39,37,115,39,44,55,44,91,10,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,93,44,49,44,49,44,49,44,48,44,37,117,44,48,44,48,44,48,44,48,44,48,44,91,10,93,41,46,10,0,0,0,0,0,97,114,99,40,39,37,115,39,44,49,44,49,44,49,44,48,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,48,44,37,46,49,102,44,37,46,49,102,44,53,55,54,48,44,49,55,50,56,48,44,37,117,44,48,44,48,44,56,44,51,44,48,44,91,10,93,41,46,10,0,0,0,0,0,111,110,108,121,32,107,101,121,119,111,114,100,115,32,97,114,101,32,39,116,101,114,109,105,110,97,108,39,32,97,110,100,32,39,112,97,108,101,116,116,101,39,0,0,0,0,0,0,97,114,99,40,39,37,115,39,44,49,44,49,44,49,44,48,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,48,44,37,46,49,102,44,37,46,49,102,44,49,49,53,50,48,44,49,55,50,56,48,44,37,117,44,48,44,48,44,56,44,51,44,48,44,91,10,93,41,46,10,0,0,0,0,97,114,99,40,39,37,115,39,44,49,44,49,44,49,44,48,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,48,44,37,46,49,102,44,37,46,49,102,44,49,49,53,50,48,44,49,49,53,50,48,44,37,117,44,48,44,48,44,56,44,51,44,48,44,91,10,93,41,46,10,0,0,0,0,115,121,110,116,97,120,32,101,114,114,111,114,32,105,110,32,112,97,114,97,109,101,116,101,114,32,102,105,108,101,32,37,115,0,0,0,0,0,0,0,97,114,99,40,39,37,115,39,44,49,44,49,44,49,44,48,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,48,44,37,46,49,102,44,37,46,49,102,44,49,55,50,56,48,44,49,55,50,56,48,44,37,117,44,48,44,48,44,56,44,51,44,48,44,91,10,93,41,46,10,0,0,0,0,70,105,110,97,108,32,115,101,116,32,111,102,32,112,97,114,97,109,101,116,101,114,115,32,32,32,32,32,32,32,32,32,32,32,32,65,115,121,109,112,116,111,116,105,99,32,83,116,97,110,100,97,114,100,32,69,114,114,111,114,10,0,0,0,97,114,99,40,39,37,115,39,44,49,44,49,44,49,44,48,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,48,44,37,46,49,102,44,37,46,49,102,44,49,55,50,56,48,44,49,49,53,50,48,44,37,117,44,48,44,48,44,56,44,51,44,48,44,91,10,93,41,46,10,0,0,0,0,97,114,99,40,39,37,115,39,44,49,44,49,44,49,44,48,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,48,44,37,46,49,102,44,37,46,49,102,44,49,55,50,56,48,44,53,55,54,48,44,37,117,44,48,44,48,44,56,44,51,44,48,44,91,10,93,41,46,10,0,0,0,0,0,102,108,111,111,114,0,0,0,78,101,119,32,67,101,110,116,117,114,121,32,83,99,104,111,111,108,98,111,111,107,32,66,111,108,100,32,73,116,97,108,105,99,0,0,0,0,0,0,97,114,99,40,39,37,115,39,44,49,44,49,44,49,44,48,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,48,44,37,46,49,102,44,37,46,49,102,44,48,44,49,55,50,56,48,44,37,117,44,48,44,48,44,56,44,51,44,48,44,91,10,93,41,46,10,0,0,0,0,0,0,0,0,102,105,116,0,0,0,0,0,98,108,97,110,107,115,0,0,99,97,110,110,111,116,32,111,112,101,110,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,32,102,111,114,32,114,101,97,100,105,110,103,32,100,97,116,97,0,0,0,0,97,114,99,40,39,37,115,39,44,49,44,49,44,49,44,48,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,48,44,37,46,49,102,44,37,46,49,102,44,53,55,54,48,44,49,49,53,50,48,44,37,117,44,48,44,48,44,56,44,51,44,48,44,91,10,93,41,46,10,0,0,0,0,0,40,102,105,114,115,116,32,97,120,101,115,41,32,0,0,0,97,114,99,40,39,37,115,39,44,49,44,49,44,49,44,48,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,48,44,37,46,49,102,44,37,46,49,102,44,49,49,53,50,48,44,53,55,54,48,44,37,117,44,48,44,48,44,56,44,51,44,48,44,91,10,93,41,46,10,0,0,0,0,0,84,104,105,115,32,112,108,111,116,32,115,116,121,108,101,32,100,111,101,115,32,110,111,116,32,119,111,114,107,32,119,105,116,104,32,49,32,111,114,32,50,32,99,111,108,115,46,32,83,101,116,116,105,110,103,32,116,111,32,112,111,105,110,116,115,0,0,0,0,0,0,0,98,105,110,100,95,97,112,112,101,110,100,45,62,110,101,119,0,0,0,0,0,0,0,0,35,37,108,120,0,0,0,0,97,114,99,40,39,37,115,39,44,49,44,49,44,49,44,48,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,48,44,37,46,49,102,44,37,46,49,102,44,48,44,49,49,53,50,48,44,37,117,44,48,44,48,44,56,44,51,44,48,44,91,10,93,41,46,10,0,0,0,0,0,0,0,0,97,114,99,40,39,37,115,39,44,49,44,49,44,49,44,48,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,48,44,37,46,49,102,44,37,46,49,102,44,53,55,54,48,44,53,55,54,48,44,37,117,44,48,44,48,44,56,44,51,44,48,44,91,10,93,41,46,10,0,0,0,0,0,0,115,99,114,101,101,110,100,117,109,112,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,10,0,0,0,0,0,97,114,99,40,39,37,115,39,44,49,44,49,44,49,44,48,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,48,44,37,46,49,102,44,37,46,49,102,44,48,44,53,55,54,48,44,37,117,44,48,44,48,44,56,44,51,44,48,44,91,10,93,41,46,10,0,97,114,99,40,39,37,115,39,44,49,44,49,44,49,44,48,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,48,44,37,46,49,102,44,37,46,49,102,44,52,52,56,48,44,50,53,54,48,44,37,117,44,48,44,48,44,56,44,51,44,48,44,91,10,93,41,46,10,0,0,0,0,0,0,9,103,110,117,112,108,111,116,114,99,32,105,115,32,114,101,97,100,32,102,114,111,109,32,37,115,10,0,0,0,0,0,112,111,108,121,103,111,110,40,39,37,115,39,44,54,44,91,10,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,93,44,49,44,49,44,49,44,48,44,37,117])
.concat([44,48,44,48,44,48,44,48,44,48,44,91,10,93,41,46,10,0,0,0,0,0,0,0,67,97,108,99,117,108,97,116,105,111,110,32,101,114,114,111,114,58,32,110,111,110,45,112,111,115,105,116,105,118,101,32,100,105,97,103,111,110,97,108,32,101,108,101,109,101,110,116,32,105,110,32,99,111,118,97,114,46,32,109,97,116,114,105,120,0,0,0,0,0,0,0,70,111,114,109,97,116,32,99,104,97,114,97,99,116,101,114,32,109,105,115,109,97,116,99,104,58,32,37,37,76,32,105,115,32,111,110,108,121,32,118,97,108,105,100,32,119,105,116,104,32,37,37,108,0,0,0,112,111,108,121,103,111,110,40,39,37,115,39,44,54,44,91,10,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,93,44,48,44,49,44,49,44,48,44,37,117,44,48,44,48,44,48,44,48,44,48,44,91,10,93,41,46,10,0,0,0,0,0,0,0,37,100,47,37,109,47,37,121,44,37,72,58,37,77,0,0,37,42,100,0,0,0,0,0,112,111,108,121,103,111,110,40,39,37,115,39,44,53,44,91,10,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,93,44,49,44,49,44,49,44,48,44,37,117,44,48,44,48,44,48,44,48,44,48,44,91,10,93,41,46,10,0,114,97,110,100,0,0,0,0,112,111,108,121,103,111,110,40,39,37,115,39,44,53,44,91,10,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,93,44,48,44,49,44,49,44,48,44,37,117,44,48,44,48,44,48,44,48,44,48,44,91,10,93,41,46,10,0,78,101,119,32,67,101,110,116,117,114,121,32,83,99,104,111,111,108,98,111,111,107,32,66,111,108,100,0,0,0,0,0,100,101,99,36,105,109,97,108,115,105,103,110,0,0,0,0,105,110,118,97,108,105,100,0,112,111,108,121,103,111,110,40,39,37,115,39,44,52,44,91,10,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,93,44,49,44,49,44,49,44,48,44,37,117,44,48,44,48,44,48,44,48,44,48,44,91,10,93,41,46,10,0,0,0,9,32,32,102,111,110,116,32,34,37,115,34,10,0,0,0,101,113,117,97,108,36,95,97,120,101,115,0,0,0,0,0,102,114,111,109,32,0,0,0,112,111,108,121,103,111,110,40,39,37,115,39,44,52,44,91,10,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,93,44,48,44,49,44,49,44,48,44,37,117,44,48,44,48,44,48,44,48,44,48,44,91,10,93,41,46,10,0,0,0,84,111,111,32,109,97,110,121,32,99,111,108,117,109,110,115,32,105,110,32,117,115,105,110,103,32,115,112,101,99,105,102,105,99,97,116,105,111,110,0,68,101,108,101,116,101,0,0,111,118,97,108,40,39,37,115,39,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,49,44,49,44,49,44,37,117,44,48,44,48,44,48,44,91,10,93,41,46,10,0,0,0,0,0,111,118,97,108,40,39,37,115,39,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,50,44,49,44,49,44,37,117,44,48,44,48,44,48,44,91,10,93,41,46,10,0,0,0,0,0,67,97,110,110,111,116,32,111,112,101,110,32,115,97,118,101,32,102,105,108,101,0,0,0,99,112,57,53,48,0,0,0,98,111,120,40,39,37,115,39,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,49,44,49,44,49,44,37,117,44,48,44,48,44,48,44,91,10,93,41,46,10,0,0,0,0,0,0,32,111,112,101,110,32,121,108,111,119,32,121,104,105,103,104,32,121,99,108,111,115,101,0,98,111,120,40,39,37,115,39,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,50,44,49,44,49,44,37,117,44,48,44,48,44,48,44,91,10,93,41,46,10,0,0,0,0,0,0,99,97,108,108,110,0,0,0,112,111,108,121,40,39,37,115,39,44,50,44,91,10,9,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,93,44,48,44,50,44,49,44,37,117,44,48,44,48,44,48,44,48,44,56,44,51,44,48,44,91,10,93,41,46,10,0,0,0,0,0,0,0,70,73,84,95,87,83,83,82,0,0,0,0,0,0,0,0,112,111,108,121,40,39,37,115,39,44,50,44,91,10,9,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,93,44,48,44,50,44,49,44,37,117,44,48,44,48,44,48,44,48,44,56,44,51,44,48,44,91,10,93,41,10,0,0,0,0,0,0,0,0,112,111,108,121,40,39,37,115,39,44,50,44,91,10,9,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,93,44,48,44,50,44,49,44,37,117,44,48,44,48,44,48,44,48,44,56,44,51,44,48,44,91,10,93,41,44,10,0,0,0,0,0,0,0,67,97,110,110,111,116,32,115,112,108,111,116,32,105,110,32,112,111,108,97,114,32,99,111,111,114,100,105,110,97,116,101,32,115,121,115,116,101,109,46,0,0,0,0,0,0,0,0,105,103,97,109,109,97,0,0,103,114,111,117,112,40,91,10,0,0,0,0,0,0,0,0,78,101,119,32,67,101,110,116,117,114,121,32,83,99,104,111,111,108,98,111,111,107,32,73,116,97,108,105,99,0,0,0,101,110,99,36,111,100,105,110,103,0,0,0,0,0,0,0,114,101,99,111,114,100,115,0,101,120,36,105,116,0,0,0,99,97,110,110,111,116,32,112,108,111,116,32,102,114,111,109,32,115,116,100,105,110,47,115,116,100,111,117,116,47,115,116,100,101,114,114,0,0,0,0,103,114,111,117,112,40,91,10,112,111,108,121,40,39,37,115,39,44,50,44,91,10,9,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,93,44,48,44,50,44,49,44,37,117,44,48,44,48,44,48,44,48,44,56,44,51,44,48,44,91,10,93,41,46,10,112,111,108,121,40,39,37,115,39,44,50,44,91,10,9,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,93,44,48,44,50,44,49,44,37,117,44,48,44,48,44,48,44,48,44,56,44,51,44,48,44,91,10,93,41,46,10,0,0,0,0,0,0,83,116,97,116,115,32,99,111,109,109,97,110,100,32,110,111,116,32,97,118,97,105,108,97,98,108,101,32,105,110,32,116,105,109,101,100,97,116,97,32,109,111,100,101,0,0,0,0,32,115,105,122,101,32,0,0,93,44,10,37,117,44,48,44,91,10,93,41,46,10,0,0,78,111,116,32,101,110,111,117,103,104,32,99,111,108,117,109,110,115,32,105,110,32,117,115,105,110,103,32,115,112,101,99,105,102,105,99,97,116,105,111,110,0,0,0,0,0,0,0,69,115,99,97,112,101,0,0,99,111,108,111,114,115,112,101,99,32,111,112,116,105,111,110,32,110,111,116,32,114,101,99,111,103,110,105,122,101,100,0,103,114,111,117,112,40,91,10,112,111,108,121,40,39,37,115,39,44,50,44,91,10,9,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,93,44,48,44,50,44,49,44,37,117,44,48,44,48,44,48,44,48,44,56,44,51,44,48,44,91,10,93,41,44,10,112,111,108,121,40,39,37,115,39,44,50,44,91,10,9,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,93,44,48,44,50,44,49,44,37,117,44,48,44,48,44,48,44,48,44,56,44,51,44,48,44,91,10,93,41,10,0,0,0,0,0,0,0,112,111,108,121,40,39,37,115,39,44,50,44,91,10,9,37,46,49,102,44,37,46,49,102,44,37,46,49,102,44,37,46,49,102,93,44,48,44,49,44,49,44,37,117,44,48,44,48,44,48,44,48,44,56,44,51,44,48,44,91,10,93,41,46,10,0,0,0,0,0,0,0,112,111,108,121,40,39,37,115,39,44,37,100,44,91,10,9,37,117,44,37,117,44,37,117,44,37,117,93,44,49,44,37,117,44,49,44,37,117,44,48,44,48,44,37,117,44,48,44,56,44,51,44,48,44,91,10,93,41,46,10,0,0,0,0,37,117,44,37,117,93,44,48,44,37,117,44,49,44,37,117,44,48,44,48,44,37,117,44,48,44,56,44,51,44,48,44,91,10,93,41,46,10,0,0,112,111,108,121,40,39,37,115,39,44,37,100,44,91,10,9,0,0,0,0,0,0,0,0,91,110,111,110,101,93,0,0,70,73,84,95,83,84,68,70,73,84,0,0,0,0,0,0,35,37,46,50,120,37,46,50,120,37,46,50,120,0,0,0,93,44,37,100,44,49,44,48,44,48,44,37,117,44,48,44,48,44,48,44,48,44,91,10,93,41,46,10,0,0,0,0,118,111,105,103,116,0,0,0,37,117,44,37,117,0,0,0,78,101,119,32,67,101,110,116,117,114,121,32,83,99,104,111,111,108,98,111,111,107,32,82,111,109,97,110,0,0,0,0,100,117,36,109,109,121,0,0,37,115,9,37,108,100,10,0,105,110,118,97,108,105,100,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,32,105,110,116,101,103,101,114,0,10,9,0,0,0,0,0,0,9,32,0,0,0,0,0,0,116,36,105,109,101,0,0,0,99,101,110,116,101,114,32,0,37,117,44,37,117,44,0,0,82,101,116,117,114,110,0,0,112,97,108,101,116,116,101,32,102,114,97,99,116,105,111,110,32,111,117,116,32,111,102,32,114,97,110,103,101,0,0,0,112,111,108,121,103,111,110,40,39,37,115,39,44,37,100,44,91,10,9,0,0,0,0,0,99,111,110,116,111,117,114,32,116,114,105,100,105,97,103,32,109,0,0,0,0,0,0,0,119,104,105,116,101,0,0,0,110,111,32,112,114,101,118,105,111,117,115,32,112,108,111,116,0,0,0,0,0,0,0,0,105,36,110,116,101,114,97,99,116,105,118,101,0,0,0,0,98,108,45,105,110,116,101,114,112,32,98,101,116,119,101,101,110,32,115,99,97,110,0,0,78,101,101,100,32,102,117,108,108,32,117,115,105,110,103,32,115,112,101,99,32,102,111,114,32,120,32,116,105,109,101,32,100,97,116,97,0,0,0,0,85,110,100,101,102,105,110,101,100,32,118,97,108,117,101,32,116,104,105,114,100,32,99,111,108,111,114,32,100,117,114,105,110,103,32,102,117,110,99,116,105,111,110,32,101,118,97,108,117,97,116,105,111,110,0,0,112,36,101,114,108,116,107,0,108,97,98,101,108,112,111,105,110,116,32,108,97,98,101,108,0,0,0,0,0,0,0,0,105,110,116,101,114,97,99,116,105,118,101,0,0,0,0,0,45,100,0,0,0,0,0,0,70,73,84,95,78,68,70,0,112,101,114,108,116,107,0,0,37,115,32,37,115,0,0,0,105,98,101,116,97,0,0,0,105,102,32,123,91,115,116,114,105,110,103,32,108,101,110,103,116,104,32,36,121,50,109,93,62,48,125,32,123,112,117,116,115,32,34,32,36,121,50,109,34,125,32,101,108,115,101,32,123,112,117,116,115,32,34,32,91,101,120,112,114,32,48,46,53,42,40,36,121,50,115,43,36,121,50,101,41,93,34,125,10,0,0,0,0,0,0,0,72,101,108,118,101,116,105,99,97,32,78,97,114,114,111,119,32,66,111,108,100,32,79,98,108,105,113,117,101,0,0,0,100,103,36,114,105,100,51,100,0,0,0,0,0,0,0,0,32,32,77,101,100,105,97,110,58,32,32,32,37,115,32,10,0,0,0,0,0,0,0,0,116,117,114,110,105,110,103,32,114,117,108,101,114,32,111,102,102,46,10,0,0,0,0,0,100,97,116,97,102,105,108,101,32,108,105,110,101,32,98,117,102,102,101,114,0,0,0,0,105,102,32,123,91,115,116,114,105,110,103,32,108,101,110,103,116,104,32,36,120,50,109,93,62,48,125,32,123,112,117,116,115,32,45,110,111,110,101,119,108,105,110,101,32,34,32,36,120,50,109,34,125,32,101,108,115,101,32,123,112,117,116,115,32,45,110,111,110,101,119,108,105,110,101,32,34,32,91,101,120,112,114,32,48,46,53,42,40,36,120,50,115,43,36,120,50,101,41,93,34,125,10,0,41,10,0,0,0,0,0,0,110,111,119,114,105,36,116,101,98,97,99,107,0,0,0,0,105,102,32,123,91,115,116,114,105,110,103,32,108,101,110,103,116,104,32,36,121,49,109,93,62,48,125,32,123,112,117,116,115,32,45,110,111,110,101,119,108,105,110,101,32,34,32,36,121,49,109,34,125,32,101,108,115,101,32,123,112,117,116,115,32,45,110,111,110,101,119,108,105,110,101,32,34,32,91,101,120,112,114,32,48,46,53,42,40,36,121,49,115,43,36,121,49,101,41,93,34,125,10,0,115,101,116,32,0,0,0,0,73,110,118,97,108,105,100,32,115,117,98,115,116,105,116,117,116,105,111,110,32,36,37,99,0,0,0,0,0,0,0,0,37,105,32,37,105,32,116,114,97,110,115,108,97,116,101,32,37,105,32,37,105,32,115,99,97,108,101,32,48,32,115,101,116,108,105,110,101,119,105,100,116,104,10,0,0,0,0,0,115,112,108,105,110,101,32,104,101,108,112,32,118,101,99,116,111,114,0,0,0,0,0,0,75,80,95,69,110,116,101,114,0,0,0,0,0,0,0,0,101,120,112,101,99,116,101,100,32,112,97,108,101,116,116,101,32,102,114,97,99,116,105,111,110,0,0,0,0,0,0,0,105,102,32,123,91,115,116,114,105,110,103,32,108,101,110,103,116,104,32,36,120,49,109,93,62,48,125,32,123,112,117,116,115,32,45,110,111,110,101,119,108,105,110,101,32,34,32,36,120,49,109,34,125,32,101,108,115,101,32,123,112,117,116,115,32,45,110,111,110,101,119,108,105,110,101,32,34,32,91,101,120,112,114,32,48,46,53,42,40,36,120,49,115,43,36,120,49,101,41,93,34,125,10,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,58,32,102,95,115,117,109,32,99,111,117,108,100,32,110,111,116,32,97,99,99,101,115,115,32,115,117,109,109,97,116,105,111,110,32,99,111,101,102,102,105,99,105,101,110,116,32,102,117,110,99,116,105,111,110,0,0,0,117,115,101,114,95,103,110,117,112,108,111,116,95,99,111,111,114,100,105,110,97,116,101,115,32,36,119,105,110,32,36,105,100,32,36,120,49,115,32,36,121,49,115,32,36,120,50,115,32,36,121,50,115,32,36,120,49,101,32,36,121,49,101,32,36,120,50,101,32,36,121,50,101,32,36,120,49,109,32,36,121,49,109,32,36,120,50,109,32,36,121,50,109,10,0,0,73,110,116,101,114,110,97,108,32,101,114,114,111,114,32,45,32,114,101,102,114,101,115,104,32,111,102,32,117,110,107,110,111,119,110,32,112,108,111,116,32,116,121,112,101,0,0,0,115,101,116,32,105,100,32,91,36,119,105,110,32,102,105,110,100,32,119,105,116,104,116,97,103,32,99,117,114,114,101,110,116,93,10,0,0,0,0,0,85,110,100,101,102,105,110,101,100,32,118,97,108,117,101,32,115,101,99,111,110,100,32,99,111,108,111,114,32,100,117,114,105,110,103,32,102,117,110,99,116,105,111,110,32,101,118,97,108,117,97,116,105,111,110,0,105,102,32,123,40,91,108,108,101,110,103,116,104,32,91,105,110,102,111,32,99,111,109,109,97,110,100,115,32,117,115,101,114,95,103,110,117,112,108,111,116,95,99,111,111,114,100,105,110,97,116,101,115,93,93,41,125,32,123,10,0,0,0,0,112,114,111,99,32,103,110,117,112,108,111,116,95,120,121,32,123,119,105,110,32,120,49,115,32,121,49,115,32,120,50,115,32,121,50,115,32,120,49,101,32,121,49,101,32,120,50,101,32,121,50,101,32,120,49,109,32,121,49,109,32,120,50,109,32,121,50,109,125,32,123,10,0,0,0,0,0,0,0,0,118,97,114,105,97,110,99,101,32,111,102,32,114,101,115,105,100,117,97,108,115,32,40,114,101,100,117,99,101,100,32,99,104,105,115,113,117,97,114,101,41,32,61,32,87,83,83,82,47,110,100,102,32,32,32,58,32,37,103,10,10,0,0,0,114,101,116,117,114,110,32,123,37,102,32,37,102,32,37,102,32,37,102,32,37,102,32,37,102,32,37,102,32,37,102,125,10,0,0,0,0,0,0,0,112,114,111,99,32,103,110,117,112,108,111,116,95,97,120,105,115,114,97,110,103,101,115,32,123,125,32,123,10,0,0,0,108,103,97,109,109,97,0,0,114,101,116,117,114,110,32,123,37,100,32,37,100,32,37,100,32,37,100,125,10,0,0,0,72,101,108,118,101,116,105,99,97,32,78,97,114,114,111,119,32,66,111,108,100,0,0,0,100,97,116,97,36,102,105,108,101,0,0,0,0,0,0,0,32,32,81,117,97,114,116,105,108,101,58,32,37,115,32,10,0,0,0,0,0,0,0,0,112,114,111,99,32,103,110,117,112,108,111,116,95,112,108,111,116,97,114,101,97,32,123,125,32,123,10,0,0,0,0,0,100,117,112,108,105,99,97,116,101,100,32,111,114,32,99,111,110,116,114,97,100,105,99,116,105,110,103,32,97,114,103,117,109,101,110,116,115,32,105,110,32,100,97,116,97,102,105,108,101,32,111,112,116,105,111,110,115,0,0,0,0,0,0,0,44,32,0,0,0,0,0,0,119,114,36,105,116,101,98,97,99,107,0,0,0,0,0,0,125,10,0,0,0,0,0,0,9,0,0,0,0,0,0,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,32,58,32,100,102,95,114,101,97,100,108,105,110,101,32,114,101,116,117,114,110,101,100,32,37,100,32,58,32,100,97,116,97,102,105,108,101,32,108,105,110,101,32,37,100,0,0,0,0,0,84,97,98,0,0,0,0,0,112,114,105,110,116,32,34,92,110,34,10,0,0,0,0,0,105,102,32,40,108,101,110,103,116,104,40,36,121,50,109,41,62,48,41,32,123,112,114,105,110,116,32,34,32,36,121,50,109,34,59,125,32,101,108,115,101,32,123,112,114,105,110,116,32,34,32,34,44,32,48,46,53,42,40,36,121,50,115,43,36,121,50,101,41,59,125,10,0,0,0,0,0,0,0,0,99,97,110,110,111,116,32,114,101,102,114,101,115,104,32,102,114,111,109,32,116,104,105,115,32,115,116,97,116,101,46,32,116,114,121,105,110,103,32,102,117,108,108,32,114,101,112,108,111,116,0,0,0,0,0,0,105,102,32,40,108,101,110,103,116,104,40,36,120,50,109,41,62,48,41,32,123,112,114,105,110,116,32,34,32,36,120,50,109,34,59,125,32,101,108,115,101,32,123,112,114,105,110,116,32,34,32,34,44,32,48,46,53,42,40,36,120,50,115,43,36,120,50,101,41,59,125,10,0,0,0,0,0,0,0,0,85,110,100,101,102,105,110,101,100,32,118,97,108,117,101,32,102,105,114,115,116,32,99,111,108,111,114,32,100,117,114,105,110,103,32,102,117,110,99,116,105,111,110,32,101,118,97,108,117,97,116,105,111,110,0,0,105,102,32,40,108,101,110,103,116,104,40,36,121,49,109,41,62,48,41,32,123,112,114,105,110,116,32,34,32,36,121,49,109,34,59,125,32,101,108,115,101,32,123,112,114,105,110,116,32,34,32,34,44,32,48,46,53,42,40,36,121,49,115,43,36,121,49,101,41,59,125,10,0,0,0,0,0,0,0,0,105,102,32,40,108,101,110,103,116,104,40,36,120,49,109,41,62,48,41,32,123,112,114,105,110,116,32,34,32,36,120,49,109,34,59,125,32,101,108,115,101,32,123,112,114,105,110,116,32,34,32,34,44,32,48,46,53,42,40,36,120,49,115,43,36,120,49,101,41,59,125,10,0,0,0,0,0,0,0,0,79,117,116,114,97,110,103,101,100,32,97,110,100,32,117,110,100,101,102,105,110,101,100,32,100,97,116,97,112,111,105,110,116,115,32,97,114,101,32,111,109,105,116,116,101,100,32,102,114,111,109,32,116,104,101,32,115,117,114,102,97,99,101,46,10,0,0,0,0,0,0,0,114,109,115,32,111,102,32,114,101,115,105,100,117,97,108,115,32,32,32,32,32,32,40,70,73,84,95,83,84,68,70,73,84,41,32,61,32,115,113,114,116,40,87,83,83,82,47,110,100,102,41,32,32,32,32,58,32,37,103,10,0,0,0,0,125,32,101,108,115,101,32,123,10,0,0,0,0,0,0,0,58,10,0,0,0,0,0,0,117,115,101,114,95,103,110,117,112,108,111,116,95,99,111,111,114,100,105,110,97,116,101,115,32,36,119,105,110,44,32,36,105,100,44,32,36,120,49,115,44,32,36,121,49,115,44,32,36,120,50,115,44,32,36,121,50,115,44,32,36,120,49,101,44,32,36,121,49,101,44,32,36,120,50,101,44,32,36,121,50,101,44,32,36,120,49,109,44,32,36,121,49,109,44,32,36,120,50,109,44,32,36,121,50,109,10,0,0,0,0,0,103,97,109,109,97,0,0,0,109,121,32,36,105,100,32,61,32,36,119,105,110,45,62,102,105,110,100,40,39,119,105,116,104,116,97,103,39,44,32,39,99,117,114,114,101,110,116,39,41,59,10,0,0,0,0,0,72,101,108,118,101,116,105,99,97,32,78,97,114,114,111,119,32,79,98,108,105,113,117,101,0,0,0,0,0,0,0,0,100,97,36,116,97,0,0,0,32,32,77,97,120,105,109,117,109,58,32,32,37,115,32,91,37,42,108,100,93,10,0,0,105,102,32,40,100,101,102,105,110,101,100,32,38,117,115,101,114,95,103,110,117,112,108,111,116,95,99,111,111,114,100,105,110,97,116,101,115,41,32,123,10,0,0,0,0,0,0,0,110,111,97,117,116,111,36,115,99,97,108,101,0,0,0,0,109,121,32,40,36,119,105,110,44,32,36,120,49,115,44,32,36,121,49,115,44,32,36,120,50,115,44,32,36,121,50,115,44,32,36,120,49,101,44,32,36,121,49,101,44,32,36,120,50,101,44,32,36,121,50,101,44,32,36,120,49,109,44,32,36,121,49,109,44,32,36,120,50,109,44,32,36,121,50,109,41,32,61,32,64,95,59,10,0,0,0,0,0,0,0,0,37,115,111,98,106,101,99,116,32,37,50,100,32,114,101,99,116,32,0,0,0,0,0,0,78,111,116,32,101,110,111,117,103,104,32,99,111,108,117,109,110,115,32,102,111,114,32,118,97,114,105,97,98,108,101,32,99,111,108,111,114,0,0,0,66,97,99,107,83,112,97,99,101,0,0,0,0,0,0,0,101,120,112,101,99,116,101,100,32,99,98,32,118,97,108,117,101,0,0,0,0,0,0,0,115,117,98,32,103,110,117,112,108,111,116,95,120,121,32,123,10,0,0,0,0,0,0,0,114,101,116,117,114,110,32,40,37,102,44,32,37,102,44,32,37,102,44,32,37,102,44,32,37,102,44,32,37,102,44,32,37,102,44,32,37,102,41,59,10,0,0,0,0,0,0,0,110,111,32,97,99,116,105,118,101,32,112,108,111,116,59,32,99,97,110,110,111,116,32,114,101,102,114,101,115,104,0,0,115,117,98,32,103,110,117,112,108,111,116,95,97,120,105,115,114,97,110,103,101,115,32,123,10,0,0,0,0,0,0,0,105,110,32,108,97,98,101,108,95,119,105,100,116,104,0,0,37,115,58,37,100,32,111,111,111,112,115,58,32,85,110,107,110,111,119,110,32,99,111,108,111,114,77,111,100,101,32,39,37,99,39,46,10,0,0,0,114,101,116,117,114,110,32,40,37,100,44,32,37,100,44,32,37,100,44,32,37,100,41,59,10,0,0,0,0,0,0,0,115,117,98,32,103,110,117,112,108,111,116,95,112,108,111,116,97,114,101,97,32,123,10,0,100,101,103,114,101,101,115,32,111,102,32,102,114,101,101,100,111,109,32,32,32,32,40,70,73,84,95,78,68,70,41,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,58,32,37,100,10,0,0,0,0,125,59,10,0,0,0,0,0,112,114,111,99,32,103,110,117,112,108,111,116,32,99,97,110,32,123,10,36,99,97,110,32,100,101,108,101,116,101,32,97,108,108,10,115,101,116,32,99,109,120,32,91,101,120,112,114,32,91,119,105,110,102,111,32,119,105,100,116,104,32,36,99,97,110,93,45,50,42,91,36,99,97,110,32,99,103,101,116,32,45,98,111,114,100,101,114,93,45,50,42,91,36,99,97,110,32,99,103,101,116,32,45,104,105,103,104,108,105,103,104,116,116,104,105,99,107,110,101,115,115,93,93,10,105,102,32,123,36,99,109,120,32,60,61,32,49,125,32,123,115,101,116,32,99,109,120,32,91,36,99,97,110,32,99,103,101,116,32,45,119,105,100,116,104,93,125,10,115,101,116,32,99,109,121,32,91,101,120,112,114,32,91,119,105,110,102,111,32,104,101,105,103,104,116,32,36,99,97,110,93,45,50,42,91,36,99,97,110,32,99,103,101,116,32,45,98,111,114,100,101,114,93,45,50,42,91,36,99,97,110,32,99,103,101,116,32,45,104,105,103,104,108,105,103,104,116,116,104,105,99,107,110,101,115,115,93,93,10,105,102,32,123,36,99,109,121,32,60,61,32,49,125,32,123,115,101,116,32,99,109,121,32,91,36,99,97,110,32,99,103,101,116,32,45,104,101,105,103,104,116,93,125,10,0,0,0,0,0,0,0,101,114,102,99,0,0,0,0,115,117,98,32,123,10,109,121,40,36,99,97,110,41,32,61,32,64,95,59,10,36,99,97,110,45,62,100,101,108,101,116,101,40,39,97,108,108,39,41,59,10,109,121,32,36,99,109,120,32,61,32,36,99,97,110,45,62,119,105,100,116,104,32,45,32,50,32,42,32,36,99,97,110,45,62,99,103,101,116,40,45,98,111,114,100,101,114,41,32,45,32,50,32,42,32,36,99,97,110,45,62,99,103,101,116,40,45,104,105,103,104,108,105,103,104,116,116,104,105,99,107,110,101,115,115,41,59,10,105,102,32,40,36,99,109,120,32,60,61,32,49,41,32,123,10,36,99,109,120,32,61,32,40,36,99,97,110,45,62,99,103,101,116,40,45,119,105,100,116,104,41,41,59,10,125,10,109,121,32,36,99,109,121,32,61,32,36,99,97,110,45,62,104,101,105,103,104,116,32,45,32,50,32,42,32,36,99,97,110,45,62,99,103,101,116,40,45,98,111,114,100,101,114,41,32,45,32,50,32,42,32,36,99,97,110,45,62,99,103,101,116,40,45,104,105,103,104,108,105,103,104,116,116,104,105,99,107,110,101,115,115,41,59,10,105,102,32,40,36,99,109,121,32,60,61,32,49,41,32,123,10,36,99,109,121,32,61,32,40,36,99,97,110,45,62,99,103,101,116,40,45,104,101,105,103,104,116,41,41,59,10,125,10,0,0,0,0,0,0,72,101,108,118,101,116,105,99,97,32,78,97,114,114,111,119,0,0,0,0,0,0,0,0,99,111,36,110,116,111,117,114,115,0,0,0,0,0,0,0,32,32,77,105,110,105,109,117,109,58,32,32,37,115,32,91,37,42,108,100,93,10,0,0,34,10,0,0,0,0,0,0,118,111,108,97,116,105,108,101,0,0,0,0,0,0,0,0,32,123,125,0,0,0,0,0,103,114,97,112,104,32,0,0,71,80,95,76,65,83,84,95,75,69,89,0,0,0,0,0,99,98,0,0,0,0,0,0,93,32,60,66,117,116,116,111,110,62,32,34,103,110,117,112,108,111,116,95,120,121,32,37,37,87,32,37,102,32,37,102,32,37,102,32,37,102,32,37,102,32,37,102,32,37,102,32,37,102,0,0,0,0,0,0,93,41,59,10,0,0,0,0,100,97,116,97,102,105,108,101,32,110,97,109,101,0,0,0,112,114,105,110,116,32,99,117,114,114,101,110,116,32,100,105,114,0,0,0,0,0,0,0,32,34,34,0,0,0,0,0,32,37,102,0,0,0,0,0,32,34,34,44,0,0,0,0,10,72,109,109,109,109,46,46,46,46,32,83,117,109,32,111,102,32,115,113,117,97,114,101,100,32,114,101,115,105,100,117,97,108,115,32,105,115,32,122,101,114,111,46,32,67,97,110,39,116,32,99,111,109,112,117,116,101,32,101,114,114,111,114,115,46,10,10,0,0,0,0,32,37,102,44,0,0,0,0,44,32,39,60,66,117,116,116,111,110,62,39,32,61,62,32,91,92,38,103,110,117,112,108,111,116,95,120,121,44,32,37,102,44,32,37,102,44,32,37,102,44,32,37,102,44,32,37,102,44,32,37,102,44,32,37,102,44,32,37,102,44,0,0,101,114,102,0,0,0,0,0,112,111,112,32,49,0,0,0,36,99,97,110,32,99,114,101,97,116,101,32,108,105,110,101,32,91,101,120,112,114,32,36,99,109,120,32,42,32,37,100,32,47,49,48,48,48,93,32,91,101,120,112,114,32,36,99,109,121,32,42,32,37,100,32,47,49,48,48,48,93,32,91,101,120,112,114,32,36,99,109,120,32,42,32,37,100,32,47,49,48,48,48,93,32,91,101,120,112,114,32,36,99,109,121,32,42,32,37,100,32,47,49,48,48,48,93,32,45,102,105,108,108,32,37,115,32,45,119,105,100,116,104,32,37,102,32,45,99,97,112,115,116,121,108,101,32,114,111,117,110,100,10,0,0,0,0,0,0,0,0,72,101,108,118,101,116,105,99,97,32,66,111,108,100,32,79,98,108,105,113,117,101,0,0,99,110,36,116,114,112,97,114,97,109,0,0,0,0,0,0,32,32,67,79,71,58,32,32,32,32,32,32,37,115,32,37,115,10,0,0,0,0,0,0,36,99,97,110,45,62,99,114,101,97,116,101,76,105,110,101,40,36,99,109,120,32,42,32,37,100,32,47,32,49,48,48,48,44,32,36,99,109,121,32,42,32,37,100,32,47,32,49,48,48,48,44,32,36,99,109,120,32,42,32,37,100,32,47,32,49,48,48,48,44,32,36,99,109,121,32,42,32,37,100,32,47,32,49,48,48,48,44,32,45,102,105,108,108,32,61,62,32,113,123,37,115,125,44,32,45,119,105,100,116,104,32,61,62,32,37,102,44,32,45,99,97,112,115,116,121,108,101,32,61,62,32,113,123,114,111,117,110,100,125,41,0,0,0,117,36,115,105,110,103,0,0,9,32,32,101,120,112,108,105,99,105,116,32,108,105,115,116,32,40,0,0,0,0,0,0,36,99,97,110,32,98,105,110,100,32,91,10,0,0,0,0,37,115,32,37,115,37,103,44,32,37,115,37,103,44,32,37,115,37,103,44,32,37,115,37,103,10,0,0,0,0,0,0,78,111,116,32,101,110,111,117,103,104,32,99,111,108,117,109,110,115,32,102,111,114,32,116,104,105,115,32,115,116,121,108,101,0,0,0,0,0,0,0,66,117,116,116,111,110,49,0,112,97,108,101,116,116,101,32,122,32,110,111,116,32,112,111,115,115,105,98,108,101,32,104,101,114,101,0,0,0,0,0,36,99,97,110,45,62,98,105,110,100,40,0,0,0,0,0,99,121,97,110,0,0,0,0,60,115,116,100,101,114,114,62,0,0,0,0,0,0,0,0,109,97,103,101,110,116,97,0,50,42,120,32,45,32,49,0,98,114,111,119,110,0,0,0,103,114,101,101,110,0,0,0,37,45,49,53,46,49,53,115,32,61,32,37,45,49,53,103,10,0,0,0,0,0,0,0,98,108,117,101,0,0,0,0,114,101,100,0,0,0,0,0,98,101,115,121,49,0,0,0,103,114,97,121,0,0,0,0,72,101,108,118,101,116,105,99,97,32,66,111,108,100,0,0,99,36,108,105,112,0,0,0,32,32,77,97,120,105,109,117,109,58,32,32,37,115,32,91,37,42,108,100,32,37,108,100,32,93,10,0,0,0,0,0,98,108,97,99,107,0,0,0,116,104,114,117,36,0,0,0,117,110,107,110,111,119,110,32,116,105,99,100,101,102,32,116,121,112,101,32,105,110,32,115,104,111,119,95,116,105,99,100,101,102,40,41,0,0,0,0,101,118,97,108,32,36,99,97,110,32,99,114,101,97,116,101,32,116,101,120,116,32,91,101,120,112,114,32,36,99,109,120,32,42,32,37,100,32,47,49,48,48,48,93,32,91,101,120,112,114,32,36,99,109,121,32,42,32,37,100,32,47,49,48,48,48,93,32,45,116,101,120,116,32,92,123,37,115,92,125,32,45,102,105,108,108,32,37,115,32,45,97,110,99,104,111,114,32,37,115,32,91,101,120,112,114,32,91,105,110,102,111,32,101,120,105,115,116,115,32,102,111,110,116,93,63,34,45,102,111,110,116,32,92,36,102,111,110,116,34,58,123,125,93,10,0,0,0,0,0,0,0,32,112,111,105,110,116,105,110,116,101,114,118,97,108,32,37,100,0,0,0,0,0,0,0,84,111,111,32,109,97,110,121,32,117,115,105,110,103,32,115,112,101,99,115,32,102,111,114,32,116,104,105,115,32,115,116,121,108,101,0,0,0,0,0,67,108,111,115,101,0,0,0,84,75,95,112,117,116,95,116,101,120,116,58,32,113,117,111,116,101,100,32,115,116,114,105,110,103,0,0,0,0,0,0,36,99,97,110,45,62,99,114,101,97,116,101,84,101,120,116,40,36,99,109,120,32,42,32,37,100,32,47,32,49,48,48,48,44,32,36,99,109,121,32,42,32,37,100,32,47,32,49,48,48,48,44,32,45,116,101,120,116,32,61,62,32,113,123,37,115,125,44,32,45,102,105,108,108,32,61,62,32,113,123,37,115,125,44,32,45,97,110,99,104,111,114,32,61,62,32,39,37,115,39,44,32,40,100,101,102,105,110,101,100,32,36,102,111,110,116,32,63,32,40,45,102,111,110,116,32,61,62,32,36,102,111,110,116,41,32,58,32,40,41,41,41,59,10,0,0,0,0,0,0,0,0,60,115,116,100,111,117,116,62,0,0,0,0,0,0,0,0,99,101,110,116,101,114,0,0,50,32,109,117,108,32,49,32,115,117,98,0,0,0,0,0,110,101,119,32,112,97,114,97,109,101,116,101,114,32,102,105,108,101,32,37,115,32,99,111,117,108,100,32,110,111,116,32,98,101,32,99,114,101,97,116,101,100,0,0,0,0,0,0,93,10,0,0,0,0,0,0,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,32,10,10,0,0,0,0,0,0,32,45,115,105,122,101,32,37,100,0,0,0,0,0,0,0,115,101,116,32,102,111,110,116,32,91,102,111,110,116,32,99,114,101,97,116,101,32,45,102,97,109,105,108,121,32,37,115,0,0,0,0,0,0,0,0,98,101,115,121,48,0,0,0,41,59,10,125,10,0,0,0,72,101,108,118,101,116,105,99,97,32,79,98,108,105,113,117,101,0,0,0,0,0,0,0,99,108,36,97,98,101,108,0,32,32,77,105,110,105,109,117,109,58,32,32,37,115,32,91,37,42,108,100,32,37,108,100,32,93,10,0,0,0,0,0,44,32,45,115,105,122,101,32,61,62,32,37,100,0,0,0,101,118,36,101,114,121,0,0,32,32,110,111,32,97,117,116,111,45,103,101,110,101,114,97,116,101,100,32,116,105,99,115,10,0,0,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,39,91,39,32,111,114,32,39,114,101,115,116,111,114,101,39,0,0,0,0,0,0,105,102,32,40,36,99,97,110,45,62,99,97,110,40,39,102,111,110,116,67,114,101,97,116,101,39,41,41,32,123,10,36,102,111,110,116,32,61,32,36,99,97,110,45,62,102,111,110,116,67,114,101,97,116,101,40,45,102,97,109,105,108,121,32,61,62,32,113,123,37,115,125,0,0,0,0,0,0,0,0,32,112,111,105,110,116,115,105,122,101,32,37,46,51,102,0,118,97,114,99,111,108,111,114,32,97,114,114,97,121,0,0,70,49,50,0,0,0,0,0,111,110,108,121,32,116,99,32,108,116,32,60,110,62,32,112,111,115,115,105,98,108,101,32,104,101,114,101,0,0,0,0,99,97,116,99,104,32,123,117,110,115,101,116,32,36,102,111,110,116,125,10,0,0,0,0,117,110,100,101,102,32,36,102,111,110,116,59,10,0,0,0,110,111,36,114,111,116,97,116,101,0,0,0,0,0,0,0,50,42,120,32,45,32,48,46,53,0,0,0,0,0,0,0,114,111,116,36,97,116,101,0,9,108,111,97,100,112,97,116,104,32,105,115,32,101,109,112,116,121,10,0,0,0,0,0,115,105,36,122,101,0,0,0,70,105,110,97,108,32,115,101,116,32,111,102,32,112,97,114,97,109,101,116,101,114,115,32,10,0,0,0,0,0,0,0,114,36,111,109,97,110,0,0,37,48,42,100,0,0,0,0,99,36,111,117,114,105,101,114,0,0,0,0,0,0,0,0,98,101,115,106,49,0,0,0,32,110,111,114,111,116,97,116,101,0,0,0,0,0,0,0,72,101,108,118,101,116,105,99,97,0,0,0,0,0,0,0,98,111,120,36,119,105,100,116,104,0,0,0,0,0,0,0,32,32,83,117,109,32,83,113,46,58,32,32,37,115,10,0,115,105,122,101,32,37,46,50,102,105,110,44,32,37,46,50,102,105,110,32,0,0,0,0,105,36,110,100,101,120,0,0,32,117,110,116,105,108,32,0,115,105,122,101,32,37,46,50,102,99,109,44,32,37,46,50,102,99,109,32,0,0,0,0,32,112,111,105,110,116,115,105,122,101,32,100,101,102,97,117,108,116,0,0,0,0,0,0,65,108,108,32,112,111,105,110,116,115,32,105,110,32,104,105,115,116,111,103,114,97,109,32,85,78,68,69,70,73,78,69,68,0,0,0,0,0,0,0,70,49,49,0,0,0,0,0,105,108,108,101,103,97,108,32,108,105,110,101,116,121,112,101,0,0,0,0,0,0,0,0,114,111,109,97,110,0,0,0,99,111,117,114,105,101,114,0,99,112,56,53,50,0,0,0,37,115,32,37,100,0,0,0,49,32,121,50,0,0,0,0,50,32,109,117,108,32,48,46,53,32,115,117,98,0,0,0,40,100,111,99,117,109,101,110,116,32,115,112,101,99,105,102,105,99,32,102,111,110,116,41,0,0,0,0,0,0,0,0,73,110,32,116,104,105,115,32,100,101,103,101,110,101,114,97,116,101,32,99,97,115,101,44,32,97,108,108,32,101,114,114,111,114,115,32,97,114,101,32,122,101,114,111,32,98,121,32,100,101,102,105,110,105,116,105,111,110,46,10,10,0,0,0,99,109,116,116,0,0,0,0,37,37,32,71,78,85,80,76,79,84,58,32,76,97,84,101,88,32,112,105,99,116,117,114,101,10,92,115,101,116,108,101,110,103,116,104,123,92,117,110,105,116,108,101,110,103,116,104,125,123,37,102,112,116,125,10,92,105,102,120,92,112,108,111,116,112,111,105,110,116,92,117,110,100,101,102,105,110,101,100,92,110,101,119,115,97,118,101,98,111,120,123,92,112,108,111,116,112,111,105,110,116,125,92,102,105,10,0,0,0,0,0,37,115,58,37,100,32,111,111,111,112,115,58,32,85,110,107,110,111,119,110,32,99,111,108,111,114,32,109,111,100,101,108,32,39,37,99,39,10,0,0,98,101,115,106,48,0,0,0,92,102,111,110,116,92,103,110,117,112,108,111,116,61,37,115,49,48,32,97,116,32,37,100,112,116,10,92,103,110,117,112,108,111,116,10,0,0,0,0,67,111,117,114,105,101,114,32,66,111,108,100,32,79,98,108,105,113,117,101,0,0,0,0,98,111,114,36,100,101,114,0,32,32,83,117,109,58,32,32,32,32,32,32,37,115,10,0,101,118,97,108,36,117,97,116,101,0,0,0,0,0,0,0,100,111,99,0,0,0,0,0,110,111,110,117,110,105,36,102,111,114,109,0,0,0,0,0,32,115,101,99,115,0,0,0,114,101,36,115,116,111,114,101,0,0,0,0,0,0,0,0,83,116,97,116,115,32,99,111,109,109,97,110,100,32,110,111,116,32,97,118,97,105,108,97,98,108,101,32,119,105,116,104,32,108,111,103,115,99,97,108,101,32,97,99,116,105,118,101,0,0,0,0,0,0,0,0,92,98,101,103,105,110,123,112,105,99,116,117,114,101,125,40,37,100,44,37,100,41,40,48,44,48,41,10,0,0,0,0,32,112,111,105,110,116,115,105,122,101,32,118,97,114,105,97,98,108,101,0,0,0,0,0,115,116,97,99,107,104,101,105,103,104,116,32,97,114,114,97,121,0,0,0,0,0,0,0,70,49,48,0,0,0,0,0,101,120,112,101,99,116,101,100,32,108,105,110,101,116,121,112,101,0,0,0,0,0,0,0,92,109,117,108,116,105,112,117,116,40,37,117,44,37,117,41,40,37,46,51,102,44,37,46,51,102,41,123,37,117,125,123,37,115,125,10,0,0,0,0,92,112,117,116,40,37,46,50,102,44,37,46,50,102,41,123,37,115,125,10,0,0,0,0,92,115,112,101,99,105,97,108,123,101,109,58,108,105,110,101,119,105,100,116,104,32,37,46,49,102,112,116,125,37,37,10,0,0,0,0,0,0,0,0,50,42,120,0,0,0,0,0,92,115,98,111,120,123,92,112,108,111,116,112,111,105,110,116,125,123,92,114,117,108,101,91,37,46,51,102,112,116,93,123,37,46,51,102,112,116,125,123,37,46,51,102,112,116,125,125,37,37,10,0,0,0,0,0,123,92,114,111,116,97,116,101,98,111,120,123,37,100,125,0,84,101,114,109,105,110,97,108,32,111,112,116,105,111,110,115,32,97,114,101,32,39,37,115,39,10,0,0,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,115,112,97,100,101,115,117,105,116,36,125,0,0,0,0,0,10,69,120,97,99,116,108,121,32,97,115,32,109,97,110,121,32,100,97,116,97,32,112,111,105,110,116,115,32,97,115,32,116,104,101,114,101,32,97,114,101,32,112,97,114,97,109,101,116,101,114,115,46,10,0,0,103,101,116,95,111,102,102,115,101,116,115,0,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,104,101,97,114,116,115,117,105,116,36,125,0,0,0,0,0,108,111,103,0,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,98,108,97,99,107,108,111,122,101,110,103,101,36,125,0,0,67,111,117,114,105,101,114,32,66,111,108,100,0,0,0,0,32,32,83,116,100,32,68,101,118,58,32,32,37,115,10,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,108,111,122,101,110,103,101,36,125,0,0,0,0,0,0,0,32,98,121,32,37,103,37,115,0,0,0,0,0,0,0,0,105,110,116,101,103,101,114,32,111,118,101,114,102,108,111,119,59,32,99,104,97,110,103,105,110,103,32,116,111,32,102,108,111,97,116,105,110,103,32,112,111,105,110,116,0,0,0,0,101,120,112,101,99,116,105,110,103,32,114,105,103,104,116,32,112,97,114,101,110,116,104,101,115,105,115,32,41,0,0,0,101,104,102,0,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,98,108,97,99,107,116,114,105,97,110,103,108,101,100,111,119,110,36,125,0,0,0,0,0,32,112,111,105,110,116,116,121,112,101,32,37,100,0,0,0,98,111,120,112,108,111,116,32,104,97,115,32,117,110,100,101,102,105,110,101,100,32,120,32,99,111,111,114,100,105,110,97,116,101,0,0,0,0,0,0,70,57,0,0,0,0,0,0,101,120,112,101,99,116,101,100,32,99,111,108,111,114,115,112,101,99,0,0,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,116,114,105,97,110,103,108,101,100,111,119,110,36,125,0,0,99,111,110,116,111,117,114,32,100,50,121,0,0,0,0,0])
.concat([92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,98,108,97,99,107,116,114,105,97,110,103,108,101,36,125,0,115,101,116,32,37,115,114,97,110,103,101,32,91,32,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,98,117,108,108,101,116,36,125,0,0,0,0,0,0,0,0,98,108,45,105,110,116,101,114,112,32,97,108,111,110,103,32,115,99,97,110,0,0,0,0,112,114,101,118,105,111,117,115,32,112,97,114,97,109,101,116,114,105,99,32,102,117,110,99,116,105,111,110,32,110,111,116,32,102,117,108,108,121,32,115,112,101,99,105,102,105,101,100,0,0,0,0,0,0,0,0,50,32,109,117,108,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,99,105,114,99,36,125,0,0,116,101,120,116,95,108,97,98,101,108,32,108,105,115,116,32,119,97,115,32,110,111,116,32,105,110,105,116,105,97,108,105,122,101,100,0,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,98,108,97,99,107,115,113,117,97,114,101,36,125,0,0,0,45,45,112,101,114,115,105,115,116,0,0,0,0,0,0,0,97,98,115,46,32,99,104,97,110,103,101,32,100,117,114,105,110,103,32,108,97,115,116,32,105,116,101,114,97,116,105,111,110,32,58,32,37,103,10,10,0,0,0,0,0,0,0,0,92,114,97,105,115,101,98,111,120,123,45,46,56,112,116,125,123,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,66,111,120,36,125,125,0,87,97,114,110,105,110,103,32,58,32,117,100,102,32,115,104,97,100,111,119,101,100,32,98,121,32,98,117,105,108,116,45,105,110,32,102,117,110,99,116,105,111,110,32,111,102,32,116,104,101,32,115,97,109,101,32,110,97,109,101,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,97,115,116,36,125,0,0,0,108,111,103,49,48,0,0,0,92,114,117,108,101,123,49,112,116,125,123,49,112,116,125,0,67,111,117,114,105,101,114,32,79,98,108,105,113,117,101,0,98,36,97,114,115,0,0,0,32,32,77,101,97,110,58,32,32,32,32,32,37,115,10,0,77,79,85,83,69,95,82,85,76,69,82,95,89,0,0,0,92,112,117,116,40,37,100,44,37,100,41,123,92,114,117,108,101,123,37,103,112,116,125,123,37,103,112,116,125,125,10,0,37,35,103,0,0,0,0,0,105,110,99,114,101,109,101,110,116,32,109,117,115,116,32,98,101,32,110,101,103,97,116,105,118,101,0,0,0,0,0,0,37,37,32,71,78,85,80,76,79,84,58,32,76,97,84,101,88,32,112,105,99,116,117,114,101,32,119,105,116,104,32,101,109,116,101,120,32,115,112,101,99,105,97,108,115,10,92,115,101,116,108,101,110,103,116,104,123,92,117,110,105,116,108,101,110,103,116,104,125,123,37,102,112,116,125,10,92,105,102,120,92,112,108,111,116,112,111,105,110,116,92,117,110,100,101,102,105,110,101,100,92,110,101,119,115,97,118,101,98,111,120,123,92,112,108,111,116,112,111,105,110,116,125,92,102,105,10,0,32,108,105,110,101,119,105,100,116,104,32,37,46,51,102,0,98,111,120,112,108,111,116,32,112,101,114,109,117,116,97,116,105,111,110,115,32,97,114,114,97,121,0,0,0,0,0,0,115,116,114,111,107,101,32,103,115,97,118,101,9,37,37,32,100,114,97,119,32,103,114,97,121,32,115,99,97,108,101,32,115,109,111,111,116,104,32,98,111,120,10,109,97,120,99,111,108,111,114,115,32,48,32,103,116,32,123,47,105,109,97,120,32,109,97,120,99,111,108,111,114,115,32,100,101,102,125,32,123,47,105,109,97,120,32,49,48,50,52,32,100,101,102,125,32,105,102,101,108,115,101,10,0,0,0,0,0,0,0,0,115,112,108,105,110,101,32,115,111,108,117,116,105,111,110,32,118,101,99,116,111,114,0,0,70,56,0,0,0,0,0,0,92,101,110,100,71,78,85,80,76,79,84,112,105,99,116,117,114,101,10,92,101,110,100,103,114,111,117,112,10,92,101,110,100,105,110,112,117,116,10,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,58,32,102,95,115,117,109,32,99,111,117,108,100,32,110,111,116,32,97,99,99,101,115,115,32,105,116,101,114,97,116,105,111,110,32,118,97,114,105,97,98,108,101,46,0,0,0,0,0,0,92,101,110,100,123,112,105,99,116,117,114,101,125,37,10,92,101,110,100,103,114,111,117,112,10,92,101,110,100,105,110,112,117,116,10,0,0,0,0,0,92,101,110,100,123,100,111,99,117,109,101,110,116,125,10,0,124,50,42,120,32,45,32,48,46,53,124,0,0,0,0,0,32,32,32,32,92,103,112,108,98,97,99,107,116,101,120,116,10,32,32,32,32,92,112,117,116,40,48,44,48,41,123,92,105,110,99,108,117,100,101,103,114,97,112,104,105,99,115,123,37,115,125,125,37,37,10,32,32,32,32,92,103,112,108,102,114,111,110,116,116,101,120,116,10,32,32,92,101,110,100,123,112,105,99,116,117,114,101,125,37,37,10,92,101,110,100,103,114,111,117,112,10,0,0,0,114,101,108,46,32,99,104,97,110,103,101,32,100,117,114,105,110,103,32,108,97,115,116,32,105,116,101,114,97,116,105,111,110,32,58,32,37,103,10,10,0,0,0,0,0,0,0,0,92,114,111,116,97,116,101,98,111,120,123,37,100,125,123,0,32,32,32,32,32,32,92,112,117,116,40,37,100,44,37,100,41,123,0,0,0,0,0,0,32,32,32,32,32,32,92,99,111,108,111,114,103,114,97,121,123,37,115,125,37,37,10,0,67,111,117,114,105,101,114,0,97,117,36,116,111,115,99,97,108,101,0,0,0,0,0,0,42,32,67,79,76,85,77,78,58,32,10,0,0,0,0,0,32,32,32,32,32,32,92,99,111,108,111,114,123,119,104,105,116,101,125,37,37,10,0,0,32,102,114,111,109,32,0,0,105,110,99,114,101,109,101,110,116,32,109,117,115,116,32,98,101,32,112,111,115,105,116,105,118,101,0,0,0,0,0,0,32,32,32,32,32,32,92,99,111,108,111,114,123,98,108,97,99,107,125,37,37,10,0,0,32,118,97,114,105,97,98,108,101,0,0,0,0,0,0,0,98,111,120,112,108,111,116,32,108,97,98,101,108,115,32,97,114,114,97,121,0,0,0,0,70,55,0,0,0,0,0,0,114,103,98,0,0,0,0,0,119,98,97,48,49,50,51,52,53,54,55,56,0,0,0,0,32,32,32,32,32,32,92,99,115,110,97,109,101,32,76,84,37,99,92,101,110,100,99,115,110,97,109,101,37,37,10,0,32,32,32,32,32,32,92,99,111,108,111,114,114,103,98,123,37,51,46,50,102,44,37,51,46,50,102,44,37,51,46,50,102,125,37,37,10,0,0,0,50,32,109,117,108,32,48,46,53,32,115,117,98,32,97,98,115,0,0,0,0,0,0,0,37,37,112,109,51,100,95,109,97,112,95,101,110,100,10,0,37,37,112,109,51,100,95,109,97,112,95,98,101,103,105,110,10,0,0,0,0,0,0,0,9,32,32,66,97,99,107,32,115,105,100,101,32,111,102,32,115,117,114,102,97,99,101,115,32,104,97,115,32,108,105,110,101,115,116,121,108,101,32,111,102,102,115,101,116,32,111,102,32,37,100,10,9,32,32,66,105,116,45,77,97,115,107,32,111,102,32,76,105,110,101,115,32,116,111,32,100,114,97,119,32,105,110,32,101,97,99,104,32,116,114,105,97,110,103,108,101,32,105,115,32,37,108,100,10,9,32,32,37,100,58,32,0,0,0,0,0,0,0,0,102,105,110,97,108,32,115,117,109,32,111,102,32,115,113,117,97,114,101,115,32,111,102,32,114,101,115,105,100,117,97,108,115,32,58,32,37,103,10,0,32,32,32,32,92,103,112,108,103,97,100,100,116,111,109,97,99,114,111,92,103,112,108,102,114,111,110,116,116,101,120,116,123,37,10,0,0,0,0,0,32,32,32,32,92,103,112,108,103,97,100,100,116,111,109,97,99,114,111,92,103,112,108,98,97,99,107,116,101,120,116,123,37,10,0,0,0,0,0,0,10,83,117,98,116,111,112,105,99,115,32,97,118,97,105,108,97,98,108,101,32,102,111,114,32,0,0,0,0,0,0,0,32,32,32,32,125,37,10,0,66,111,111,107,109,97,110,32,68,101,109,105,32,73,116,97,108,105,99,0,0,0,0,0,97,114,36,114,111,119,0,0,42,32,77,65,84,82,73,88,58,32,91,37,100,32,88,32,37,100,93,32,10,0,0,0,125,37,10,0,0,0,0,0,78,111,32,112,114,101,118,105,111,117,115,32,102,105,108,101,110,97,109,101,0,0,0,0,32,32,115,101,114,105,101,115,0,0,0,0,0,0,0,0,37,10,32,32,92,115,112,101,99,105,97,108,123,112,115,58,32,99,117,114,114,101,110,116,112,111,105,110,116,32,103,114,101,115,116,111,114,101,32,109,111,118,101,116,111,125,37,10,32,32,0,0,0,0,0,0,70,54,0,0,0,0,0,0,92,114,106,117,115,116,123,92,115,116,114,117,116,123,125,37,115,125,0,0,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,91,114,93,123,92,115,116,114,117,116,123,125,37,115,125,0,0,0,0,92,99,106,117,115,116,123,92,115,116,114,117,116,123,125,37,115,125,0,0,0,0,0,0,121,116,105,99,115,0,0,0,52,120,59,49,59,45,50,120,43,49,46,56,52,59,120,47,48,46,48,56,45,49,49,46,53,0,0,0,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,92,115,116,114,117,116,123,125,37,115,125,0,0,0,0,0,0,0,92,108,106,117,115,116,123,92,115,116,114,117,116,123,125,37,115,125,0,0,0,0,0,0,10,65,102,116,101,114,32,37,100,32,105,116,101,114,97,116,105,111,110,115,32,116,104,101,32,102,105,116,32,99,111,110,118,101,114,103,101,100,46,10,0,0,0,0,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,91,108,93,123,92,115,116,114,117,116,123,125,37,115,125,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,37,115,0,32,32,87,97,114,110,105,110,103,58,32,83,105,110,103,108,101,32,105,115,111,108,105,110,101,32,40,115,99,97,110,41,32,105,115,32,110,111,116,32,101,110,111,117,103,104,32,102,111,114,32,97,32,112,109,51,100,32,112,108,111,116,46,10,9,32,32,32,72,105,110,116,58,32,77,105,115,115,105,110,103,32,98,108,97,110,107,32,108,105,110,101,115,32,105,110,32,116,104,101,32,100,97,116,97,32,102,105,108,101,63,32,83,101,101,32,39,104,101,108,112,32,112,109,51,100,39,32,97,110,100,32,70,65,81,46,10,0,0,0,0,0,0,0,115,103,110,0,0,0,0,0,37,37,10,32,32,92,115,112,101,99,105,97,108,123,112,115,58,32,103,115,97,118,101,32,99,117,114,114,101,110,116,112,111,105,110,116,32,99,117,114,114,101,110,116,112,111,105,110,116,32,116,114,97,110,115,108,97,116,101,10,37,100,32,114,111,116,97,116,101,32,110,101,103,32,101,120,99,104,32,110,101,103,32,101,120,99,104,32,116,114,97,110,115,108,97,116,101,125,37,37,10,32,32,0,66,111,111,107,109,97,110,32,68,101,109,105,0,0,0,0,97,110,36,103,108,101,115,0,109,97,120,95,105,110,100,101,120,0,0,0,0,0,0,0,32,32,92,112,117,116,40,37,100,44,37,100,41,123,0,0,32,32,68,97,121,115,32,99,111,109,112,117,116,101,100,32,97,117,116,111,109,97,116,105,99,97,108,108,121,10,0,0,92,102,111,110,116,115,105,122,101,123,37,103,125,123,92,98,97,115,101,108,105,110,101,115,107,105,112,125,92,115,101,108,101,99,116,102,111,110,116,10,0,0,0,0,0,0,0,0,32,108,105,110,101,99,111,108,111,114,0,0,0,0,0,0,120,112,45,62,112,95,99,111,117,110,116,32,61,61,32,121,112,45,62,112,95,99,111,117,110,116,0,0,0,0,0,0,70,53,0,0,0,0,0,0,32,32,125,125,37,10,0,0,32,115,105,122,101,32,37,46,50,102,105,110,44,32,37,46,50,102,105,110,32,0,0,0,32,115,105,122,101,32,37,46,50,102,99,109,44,32,37,46,50,102,99,109,32,0,0,0,32,59,10,0,0,0,0,0,100,117,112,32,48,46,52,50,32,108,101,32,123,52,32,109,117,108,125,32,123,100,117,112,32,48,46,57,50,32,108,101,32,123,45,50,32,109,117,108,32,49,46,56,52,32,97,100,100,125,32,123,48,46,48,56,32,100,105,118,32,49,49,46,53,32,115,117,98,125,32,105,102,101,108,115,101,125,32,105,102,101,108,115,101,0,0,0,32,37,100,0,0,0,0,0,32,116,105,110,121,0,0,0,10,84,104,101,32,102,105,116,32,119,97,115,32,115,116,111,112,112,101,100,32,98,121,32,116,104,101,32,117,115,101,114,32,97,102,116,101,114,32,37,100,32,105,116,101,114,97,116,105,111,110,115,46,10,0,0,32,115,109,97,108,108,0,0,32,114,111,116,97,116,101,0,97,98,115,0,0,0,0,0,48,46,53,0,0,0,0,0,32,100,97,115,104,101,100,0,66,111,111,107,109,97,110,32,76,105,103,104,116,32,73,116,97,108,105,99,0,0,0,0,97,116,0,0,0,0,0,0,109,105,110,95,105,110,100,101,120,0,0,0,0,0,0,0,32,99,111,108,111,114,0,0,109,97,120,95,117,115,105,110,103,32,60,61,32,77,65,88,68,65,84,65,67,79,76,83,0,0,0,0,0,0,0,0,32,32,77,111,110,116,104,115,32,99,111,109,112,117,116,101,100,32,97,117,116,111,109,97,116,105,99,97,108,108,121,10,0,0,0,0,0,0,0,0,100,36,116,105,99,115,0,0,37,115,37,115,37,115,37,115,0,0,0,0,0,0,0,0,32,108,105,110,101,116,121,112,101,32,37,100,0,0,0,0,70,52,0,0,0,0,0,0,112,36,97,116,116,101,114,110,0,0,0,0,0,0,0,0,117,110,114,101,99,111,103,110,105,122,101,100,32,111,112,116,105,111,110,0,0,0,0,0,102,111,110,116,32,115,105,122,101,32,111,117,116,32,111,102,32,98,111,117,110,100,115,32,91,49,46,46,49,48,48,93,0,0,0,0,0,0,0,0,116,36,105,110,121,0,0,0,115,36,109,97,108,108,0,0,50,42,120,45,48,46,56,52,0,0,0,0,0,0,0,0,114,36,111,116,97,116,101,0,10,77,97,120,105,109,117,109,32,105,116,101,114,97,116,105,111,110,32,99,111,117,110,116,32,40,37,100,41,32,114,101,97,99,104,101,100,46,32,70,105,116,32,115,116,111,112,112,101,100,46,10,0,0,0,0,37,37,32,71,78,85,80,76,79,84,58,32,76,97,84,101,88,32,112,105,99,116,117,114,101,32,117,115,105,110,103,32,69,69,80,73,67,32,109,97,99,114,111,115,10,92,115,101,116,108,101,110,103,116,104,123,92,117,110,105,116,108,101,110,103,116,104,125,123,37,102,112,116,125,10,0,0,0,0,0,92,102,111,111,116,110,111,116,101,115,105,122,101,10,0,0,105,110,116,0,0,0,0,0,92,102,111,110,116,115,105,122,101,123,37,100,125,123,37,103,125,92,115,101,108,101,99,116,102,111,110,116,10,0,0,0,66,111,111,107,109,97,110,32,76,105,103,104,116,0,0,0,97,99,36,116,105,111,110,95,116,97,98,108,101,0,0,0,99,111,103,95,121,0,0,0,92,98,101,103,105,110,123,112,105,99,116,117,114,101,125,40,37,100,44,37,100,41,40,37,100,44,37,100,41,10,0,0,32,32,105,110,116,101,114,118,97,108,115,32,99,111,109,112,117,116,101,100,32,97,117,116,111,109,97,116,105,99,97,108,108,121,10,0,0,0,0,0,109,36,116,105,99,115,0,0,92,116,104,105,110,108,105,110,101,115,32,92,100,111,116,116,101,100,108,105,110,101,123,50,48,125,0,0,0,0,0,0,45,45,45,101,114,114,111,114,33,45,45,45,10,0,0,0,117,115,101,115,95,97,120,105,115,91,83,69,67,79,78,68,95,89,95,65,88,73,83,93,0,0,0,0,0,0,0,0,70,51,0,0,0,0,0,0,92,116,104,105,110,108,105,110,101,115,32,92,100,97,115,104,108,105,110,101,91,54,48,93,123,50,48,125,0,0,0,0,92,116,104,105,110,108,105,110,101,115,32,92,100,111,116,116,101,100,108,105,110,101,123,49,48,125,0,0,0,0,0,0,92,116,104,105,110,108,105,110,101,115,32,92,100,97,115,104,108,105,110,101,91,57,48,93,123,49,48,125,0,0,0,0,50,32,109,117,108,32,48,46,56,52,32,115,117,98,0,0,92,84,104,105,99,107,108,105,110,101,115,32,92,112,97,116,104,0,0,0,0,0,0,0,92,116,104,105,110,108,105,110,101,115,32,92,112,97,116,104,0,0,0,0,0,0,0,0,70,73,84,95,67,79,78,86,69,82,71,69,68,0,0,0,92,116,104,105,110,108,105,110,101,115,32,92,100,114,97,119,108,105,110,101,91,45,53,48,93,0,0,0,0,0,0,0,92,116,104,105,99,107,108,105,110,101,115,32,92,112,97,116,104,0,0,0,0,0,0,0,69,108,108,105,112,116,105,99,80,105,0,0,0,0,0,0,40,37,117,44,37,117,41,0,65,118,97,110,116,71,97,114,100,101,32,68,101,109,105,32,79,98,108,105,113,117,101,0,97,36,108,108,0,0,0,0,99,111,103,95,120,0,0,0,10,37,115,40,37,117,44,37,117,41,0,0,0,0,0,0,102,108,111,97,116,54,52,0,37,115,40,37,117,44,37,117,41,0,0,0,0,0,0,0,101,108,108,105,112,115,101,115,10,0,0,0,0,0,0,0,117,115,101,115,95,97,120,105,115,91,70,73,82,83,84,95,89,95,65,88,73,83,93,0,70,50,0,0,0,0,0,0,101,36,109,112,116,121,0,0,92,99,111,108,111,114,123,121,101,108,108,111,119,125,10,0,92,99,111,108,111,114,123,99,121,97,110,125,10,0,0,0,112,97,117,115,101,100,0,0,92,99,111,108,111,114,123,109,97,103,101,110,116,97,125,10,0,0,0,0,0,0,0,0,92,99,111,108,111,114,123,103,114,101,101,110,125,10,0,0,120,47,48,46,51,50,45,48,46,55,56,49,50,53,0,0,9,108,111,97,100,112,97,116,104,32,102,114,111,109,32,71,78,85,80,76,79,84,95,76,73,66,32,105,115,32,0,0,92,99,111,108,111,114,123,98,108,117,101,125,10,0,0,0,103,112,95,115,116,114,97,100,100,0,0,0,0,0,0,0,70,73,84,58,32,101,114,114,111,114,32,111,99,99,117,114,114,101,100,32,100,117,114,105,110,103,32,102,105,116,0,0,92,99,111,108,111,114,123,114,101,100,125,10,0,0,0,0,37,56,46,51,103,0,0,0,116,105,109,101,32,118,97,108,117,101,32,111,117,116,32,111,102,32,114,97,110,103,101,0,92,99,111,108,111,114,123,98,108,97,99,107,125,10,0,0,69,108,108,105,112,116,105,99,69,0,0,0,0,0,0,0,125,125,125,10,0,0,0,0,65,118,97,110,116,71,97,114,100,101,32,68,101,109,105,0,118,36,97,114,105,97,98,108,101,115,0,0,0,0,0,0,105,110,100,101,120,95,109,97,120,95,121,0,0,0,0,0,37,99,92,92,0,0,0,0,102,108,111,97,116,51,50,0,32,32,32,32,111,102,102,115,101,116,32,0,0,0,0,0,97,117,36,116,111,102,114,101,113,0,0,0,0,0,0,0,123,92,109,97,107,101,98,111,120,40,48,44,48,41,91,108,116,93,123,92,115,104,111,114,116,115,116,97,99,107,123,0,99,105,114,99,108,101,115,10,0,0,0,0,0,0,0,0,97,108,108,32,112,111,105,110,116,115,32,121,50,32,118,97,108,117,101,32,117,110,100,101,102,105,110,101,100,33,0,0,70,49,0,0,0,0,0,0,116,114,97,110,115,36,112,97,114,101,110,116,0,0,0,0,123,92,109,97,107,101,98,111,120,40,48,44,48,41,91,108,93,123,92,115,104,111,114,116,115,116,97,99,107,123,0,0,123,92,109,97,107,101,98,111,120,40,48,44,48,41,91,108,98,93,123,92,115,104,111,114,116,115,116,97,99,107,123,0,77,111,117,115,105,110,103,32,110,111,116,32,97,99,116,105,118,101,0,0,0,0,0,0,99,112,56,53,48,0,0,0,37,115,125,125,125,10,0,0,32,120,108,111,119,32,120,104,105,103,104,32,121,108,111,119,32,121,104,105,103,104,0,0,123,92,109,97,107,101,98,111,120,40,48,44,48,41,91,108,116,93,123,92,114,111,116,97,116,101,98,111,120,91,111,114,105,103,105,110,61,99,93,123,57,48,125,123,0,0,0,0,48,46,51,50,32,100,105,118,32,48,46,55,56,49,50,53,32,115,117,98,0,0,0,0,123,92,109,97,107,101,98,111,120,40,48,44,48,41,91,108,93,123,92,114,111,116,97,116,101,98,111,120,91,111,114,105,103,105,110,61,99,93,123,57,48,125,123,0,0,0,0,0,108,111,103,102,105,108,101,0,123,92,109,97,107,101,98,111,120,40,48,44,48,41,91,108,98,93,123,92,114,111,116,97,116,101,98,111,120,91,111,114,105,103,105,110,61,99,93,123,57,48,125,123,0,0,0,0,37,115,125,125,10,0,0,0,69,108,108,105,112,116,105,99,75,0,0,0,0,0,0,0,123,92,109,97,107,101,98,111,120,40,48,44,48,41,91,114,93,123,0,0,0,0,0,0,65,118,97,110,116,71,97,114,100,101,32,66,111,111,107,32,79,98,108,105,113,117,101,0,116,36,101,114,109,105,110,97,108,0,0,0,0,0,0,0,105,110,100,101,120,95,109,97,120,95,120,0,0,0,0,0,100,111,0,0,0,0,0,0,123,92,109,97,107,101,98,111,120,40,48,44,48,41,123,0,117,105,110,116,54,52,0,0,32,97,110,100,32,97,114,101,32,110,111,116,32,114,111,116,97,116,101,100,44,10,9,0,101,120,112,101,99,116,101,100,32,102,111,114,109,97,116,0,123,92,109,97,107,101,98,111,120,40,48,44,48,41,91,108,93,123,0,0,0,0,0,0,114,103,98,105,109,97,103,101,10,0,0,0,0,0,0,0,97,108,108,32,112,111,105,110,116,115,32,121,32,118,97,108,117,101,32,117,110,100,101,102,105,110,101,100,33,0,0,0,75,80,95,57,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,115,99,114,105,112,116,115,99,114,105,112,116,115,116,121,108,101,92,115,116,97,114,36,125,0,0,0,0,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,115,99,114,105,112,116,115,99,114,105,112,116,115,116,121,108,101,92,116,114,105,97,110,103,108,101,36,125,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,115,99,114,105,112,116,115,99,114,105,112,116,115,116,121,108,101,92,116,105,109,101,115,36,125,0,0,0,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,115,99,114,105,112,116,115,99,114,105,112,116,115,116,121,108,101,92,66,111,120,36,125,0,124,40,51,120,45,50,41,47,50,124,0,0,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,115,99,114,105,112,116,115,99,114,105,112,116,115,116,121,108,101,32,43,36,125,0,0,0,78,111,32,102,105,116,116,97,98,108,101,32,112,97,114,97,109,101,116,101,114,115,33,10,0,0,0,0,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,115,99,114,105,112,116,115,99,114,105,112,116,115,116,121,108,101,92,68,105,97,109,111,110,100,36,125,0,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,115,99,114,105,112,116,115,116,121,108,101,92,115,116,97,114,36,125,0,0,0,0,0,0,116,97,110,104,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,115,99,114,105,112,116,115,116,121,108,101,92,116,114,105,97,110,103,108,101,36,125,0,0,65,118,97,110,116,71,97,114,100,101,32,66,111,111,107,0,115,36,101,116,0,0,0,0,105,110,100,101,120,95,109,105,110,95,121,0,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,115,99,114,105,112,116,115,116,121,108,101,92,116,105,109,101,115,36,125,0,0,0,0,0,105,110,116,54,52,0,0,0,32,105,110,32,50,68,32,109,111,100,101,44,32,116,101,114,109,105,110,97,108,32,112,101,114,109,105,116,116,105,110,103,44,10,9,0,0,0,0,0,99,111,109,36,109,101,110,116,115,99,104,97,114,115,0,0,101,120,112,101,99,116,105,110,103,32,101,120,112,111,110,101,110,116,0,0,0,0,0,0,102,111,114,109,97,116,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,115,99,114,105,112,116,115,116,121,108,101,92,66,111,120,36,125,0,0,0,0,0,0,0,105,109,97,103,101,10,0,0,101,100,102,0,0,0,0,0,117,115,101,115,95,97,120,105,115,91,83,69,67,79,78,68,95,88,95,65,88,73,83,93,0,0,0,0,0,0,0,0,75,80,95,56,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,115,99,114,105,112,116,115,116,121,108,101,32,43,36,125,0,99,111,110,116,111,117,114,32,100,50,120,0,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,115,99,114,105,112,116,115,116,121,108,101,92,68,105,97,109,111,110,100,36,125,0,0,0,35,32,115,101,116,32,111,117,116,112,117,116,10,0,0,0,92,99,105,114,99,108,101,42,123,50,52,125,0,0,0,0,112,109,51,100,95,112,108,111,116,45,62,113,117,97,100,114,97,110,103,108,101,115,0,0,92,99,105,114,99,108,101,42,123,49,56,125,0,0,0,0,49,46,53,32,109,117,108,32,49,32,115,117,98,32,97,98,115,0,0,0,0,0,0,0,92,99,105,114,99,108,101,42,123,49,50,125,0,0,0,0,45,112,101,114,115,105,115,116,0,0,0,0,0,0,0,0,78,117,109,98,101,114,32,111,102,32,100,97,116,97,32,112,111,105,110,116,115,32,115,109,97,108,108,101,114,32,116,104,97,110,32,110,117,109,98,101,114,32,111,102,32,112,97,114,97,109,101,116,101,114,115,0,92,99,105,114,99,108,101,123,50,52,125,0,0,0,0,0,92,99,105,114,99,108,101,123,49,56,125,0,0,0,0,0,99,111,115,104,0,0,0,0,92,99,105,114,99,108,101,123,49,50,125,0,0,0,0,0,84,105,109,101,115,32,66,111,108,100,32,73,116,97,108,105,99,0,0,0,0,0,0,0,102,36,117,110,99,116,105,111,110,115,0,0,0,0,0,0,105,110,100,101,120,95,109,105,110,95,120,0,0,0,0,0,84,111,111,32,109,97,110,121,32,108,101,118,101,108,115,32,111,102,32,110,101,115,116,101,100,32,109,97,99,114,111,115,0,0,0,0,0,0,0,0,77,79,85,83,69,95,82,85,76,69,82,95,88,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,115,116,97,114,36,125,0,0,117,105,110,116,51,50,0,0,32,98,121,32,37,100,0,0,101,120,112,101,99,116,101,100,32,102,111,110,116,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,116,114,105,97,110,103,108,101,36,125,0,0,0,0,0,0,108,97,98,101,108,115,10,0,99,108,111,115,101,0,0,0,37,105,0,0,0,0,0,0,117,115,101,115,95,97,120,105,115,91,70,73,82,83,84,95,88,95,65,88,73,83,93,0,83,105,110,103,117,108,97,114,32,109,97,116,114,105,120,32,105,110,32,76,85,45,68,69,67,79,77,80,0,0,0,0,115,109,111,111,116,104,95,98,111,120,0,0,0,0,0,0,115,112,108,105,110,101,32,114,105,103,104,116,32,115,105,100,101,0,0,0,0,0,0,0,75,80,95,55,0,0,0,0,100,117,112,108,105,99,97,116,101,100,32,97,114,103,117,109,101,110,116,115,32,105,110,32,115,116,121,108,101,32,115,112,101,99,105,102,105,99,97,116,105,111,110,0,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,116,105,109,101,115,36,125,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,58,32,102,95,115,117,109,32,101,120,112,101,99,116,115,32,97,114,103,117,109,101,110,116,32,40,118,97,114,110,97,109,101,41,32,111,102,32,116,121,112,101,32,115,116,114,105,110,103,46,0,0,0,0,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,66,111,120,36,125,0,0,0,37,115,32,97,120,105,115,32,114,97,110,103,101,32,117,110,100,101,102,105,110,101,100,32,111,114,32,111,118,101,114,102,108,111,119,0,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,43,36,125,0,0,0,0,0,0,92,109,97,107,101,98,111,120,40,48,44,48,41,123,36,92,68,105,97,109,111,110,100,36,125,0,0,0,0,0,0,0,124,40,51,120,45,49,41,47,50,124,0,0,0,0,0,0,92,112,117,116,40,37,100,44,37,100,41,123,37,115,125,10,0,0,0,0,0,0,0,0,37,100,32,37,100,32,37,102,0,0,0,0,0,0,0,0,92,101,110,100,123,112,105,99,116,117,114,101,125,10,0,0,115,105,110,104,0,0,0,0,92,102,111,111,116,110,111,116,101,115,105,122,101,37,10,0,84,105,109,101,115,32,66,111,108,100,0,0,0,0,0,0,104,97,110,110,0,0,0,0,37,115,37,115,9,37,108,100,10,0,0,0,0,0,0,0,116,114,105,109,32,116,111,112,32,38,32,98,111,116,116,111,109,32,109,97,114,103,105,110,115,0,0,0,0,0,0,0,105,110,116,51,50,0,0,0,32,114,111,116,97,116,101,100,0,0,0,0,0,0,0,0,116,114,105,109,32,98,111,116,116,111,109,32,109,97,114,103,105,110,0,0,0,0,0,0,112,109,51,100,10,0,0,0,98,117,116,116,111,110,51,0,75,80,95,54,0,0,0,0,78,111,32,112,111,105,110,116,105,110,116,101,114,118,97,108,32,115,112,101,99,105,102,105,101,114,32,97,108,108,111,119,101,100,44,32,104,101,114,101,0,0,0,0,0,0,0,0,116,114,105,109,32,116,111,112,32,109,97,114,103,105,110,0,116,114,105,109,32,108,101,102,116,32,38,32,114,105,103,104,116,32,109,97,114,103,105,110,115,0,0,0,0,0,0,0,99,104,97,114,36,97,99,116,101,114,0,0,0,0,0,0,116,114,105,109,32,114,105,103,104,116,32,109,97,114,103,105,110,0,0,0,0,0,0,0,116,114,105,109,32,108,101,102,116,32,109,97,114,103,105,110,0,0,0,0,0,0,0,0,49,46,53,32,109,117,108,32,46,53,32,115,117,98,32,97,98,115,0,0,0,0,0,0,37,37,32,0,0,0,0,0,110,111,32,112,97,114,97,109,101,116,101,114,32,115,112,101,99,105,102,105,101,100,0,0,37,10,0,0,0,0,0,0,92,115,112,101,99,105,97,108,123,100,116,32,37,102,125,37,37,10,0,0,0,0,0,0,97,116,97,110,50,0,0,0,92,115,112,101,99,105,97,108,123,100,97,32,37,102,125,37,37,10,0,0,0,0,0,0,84,105,109,101,115,32,73,116,97,108,105,99,0,0,0,0,98,111,120,0,0,0,0,0,109,97,120,0,0,0,0,0,123,92,109,97,107,101,98,111,120,40,48,44,48,41,37,115,123,92,115,104,111,114,116,115,116,97,99,107,123,37,115,125,125,125,10,0,0,0,0,0,117,119,111,114,100,0,0,0,102,111,114,109,97,116,32,34,37,115,34,0,0,0,0,0,110,111,114,97,110,103,101,36,108,105,109,105,116,101,100,0,91,108,116,93,0,0,0,0,98,111,120,112,108,111,116,10,0,0,0,0,0,0,0,0,98,117,116,116,111,110,50,0,97,108,108,32,112,111,105,110,116,115,32,117,110,100,101,102,105,110,101,100,33,0,0,0,75,80,95,53,0,0,0,0,112,105,0,0,0,0,0,0,91,108,98,93,0,0,0,0,123,92,109,97,107,101,98,111,120,40,48,44,48,41,37,115,123,37,115,125,125,10,0,0,123,92,109,97,107,101,98,111,120,40,48,44,48,41,37,115,125,10,0,0,0,0,0,0,120,116,105,99,115,0,0,0,92,112,117,116,40,37,100,44,37,100,41,0,0,0,0,0,40,51,120,45,50,41,47,50,0,0,0,0,0,0,0,0,92,115,112,101,99,105,97,108,123,112,97,32,37,100,32,37,100,125,0,0,0,0,0,0,102,105,116,116,101,100,32,112,97,114,97,109,101,116,101,114,115,32,105,110,105,116,105,97,108,105,122,101,100,32,119,105,116,104,32,99,117,114,114,101,110,116,32,118,97,114,105,97,98,108,101,32,118,97,108,117,101,115,10,10,0,0,0,0,92,115,112,101,99,105,97,108,123,102,112,125,37,10,0,0,92,115,112,101,99,105,97,108,123,97,114,32,48,32,48,32,37,100,32,37,100,32,48,32,55,125,0,0,0,0,0,0,97,116,97,110,0,0,0,0,92,115,112,101,99,105,97,108,123,112,110,32,37,100,125,0,84,105,109,101,115,32,82,111,109,97,110,0,0,0,0,0,99,97,117,99,104,121,0,0,117,112,95,113,117,97,114,116,105,108,101,0,0,0,0,0,92,115,112,101,99,105,97,108,123,115,104,32,37,102,125,0,117,105,110,116,49,54,0,0,106,117,115,116,105,102,105,101,100,32,97,117,116,111,109,97,116,105,99,97,108,108,121,44,32,0,0,0,0,0,0,0,114,97,110,103,101,36,108,105,109,105,116,101,100,0,0,0,125,37,37,10,0,0,0,0,99,97,110,100,108,101,115,116,105,99,107,115,10,0,0,0,98,117,116,116,111,110,49,0,78,111,32,100,97,116,97,32,105,110,32,112,108,111,116,0,75,80,95,52,0,0,0,0,112,111,105,110,116,105,36,110,116,101,114,118,97,108,0,0,92,114,117,108,101,123,46,49,112,116,125,123,46,49,112,116,125,0,0,0,0,0,0,0,92,112,117,116,40,37,100,44,37,100,41,123,0,0,0,0,92,112,117,116,40,37,100,44,37,100,41,123,92,115,112,101,99,105,97,108,123,101,109,58,108,105,110,101,116,111,125,125,10,0,0,0,0,0,0,0,92,112,117,116,40,37,100,44,37,100,41,123,92,115,112,101,99,105,97,108,123,101,109,58,109,111,118,101,116,111,125,125,10,0,0,0,0,0,0,0,69,68,70,95,66,105,110,97,114,121,70,105,108,101,78,97,109,101,0,0,0,0,0,0,49,46,53,32,109,117,108,32,49,32,115,117,98,0,0,0,92,112,117,116,40,37,46,49,102,44,37,46,49,102,41,123,92,114,117,108,101,91,37,46,51,102,112,116,93,123,37,46,51,102,112,116,125,123,37,46,51,102,112,116,125,125,10,0,79,117,116,32,111,102,32,109,101,109,111,114,121,32,105,110,32,102,105,116,58,32,116,111,111,32,109,97,110,121,32,112,97,114,97,109,101,116,101,114,115,63,0,0,0,0,0,0,92,112,117,116,40,37,46,49,102,44,37,46,49,102,41,123,37,115,125,10,0,0,0,0,92,112,117,116,40,37,46,50,102,44,37,117,41,123,92,114,117,108,101,123,37,46,51,102,112,116,125,123,37,46,51,102,112,116,125,125,10,0,0,0,97,99,111,115,0,0,0,0,112,111,112,32,48,46,53,0,92,109,117,108,116,105,112,117,116,40,37,46,50,102,44,37,46,50,102,41,40,37,46,51,102,44,37,46,51,102,41,123,50,125,123,92,114,117,108,101,123,37,46,51,102,112,116,125,123,37,46,51,102,112,116,125,125,10,0,0,0,0,0,0,77,117,115,116,32,115,101,116,32,111,117,116,112,117,116,32,116,111,32,97,32,102,105,108,101,32,111,114,32,112,117,116,32,97,108,108,32,109,117,108,116,105,112,108,111,116,32,99,111,109,109,97,110,100,115,32,111,110,32,111,110,101,32,105,110,112,117,116,32,108,105,110,101,0,0,0,0,0,0,0,101,120,112,0,0,0,0,0,109,101,100,105,97,110,0,0,92,109,117,108,116,105,112,117,116,40,37,46,50,102,44,37,46,50,102,41,40,37,46,51,102,44,37,46,51,102,41,123,37,117,125,123,92,114,117,108,101,123,37,46,51,102,112,116,125,123,37,46,51,102,112,116,125,125,10,0,0,0,0,0,99,101,110,116,101,114,32,106,117,115,116,105,102,105,101,100,44,32,0,0,0,0,0,0,97,117,116,111,106,36,117,115,116,105,102,121,0,0,0,0,92,112,117,116,40,37,117,44,37,46,50,102,41,123,92,114,117,108,101,123,37,46,51,102,112,116,125,123,37,46,51,102,112,116,125,125,10,0,0,0,102,105,110,97,110,99,101,98,97,114,115,10,0,0,0,0,97,110,121,0,0,0,0,0,69,120,112,101,99,116,105,110,103,32,39,115,117,109,32,91,60,118,97,114,62,32,61,32,60,115,116,97,114,116,62,58,60,101,110,100,62,93,32,60,101,120,112,114,101,115,115,105,111,110,62,39,10,0,0,0,75,80,95,51,0,0,0,0,78,111,32,112,111,105,110,116,115,105,122,101,32,115,112,101,99,105,102,105,101,114,32,97,108,108,111,119,101,100,44,32,104,101,114,101,0,0,0,0,92,117,115,101,98,111,120,123,92,112,108,111,116,112,111,105,110,116,125,0,0,0,0,0,92,112,117,116,40,37,117,44,37,117,41,123,37,115,125,10,0,0,0,0,0,0,0,0,115,101,99,36,111,110,100,0,92,112,117,116,40,37,100,44,37,100,41,123,92,118,101,99,116,111,114,40,37,100,44,37,100,41,123,48,125,125,10,0,92,112,117,116,40,37,100,44,37,100,41,123,92,37,115,40,37,100,44,37,100,41,123,37,100,125,125,10,0,0,0,0,40,51,120,45,49,41,47,50,0,0,0,0,0,0,0,0,92,112,117,116,40,37,100,44,37,100,41,123,92,37,115,40,37,100,44,48,41,123,37,100,125,125,10,0,0,0,0,0,102,105,116,32,112,97,114,97,109,32,114,101,115,105,122,101,0,0,0,0,0,0,0,0,108,105,110,101,0,0,0,0,118,101,99,116,111,114,0,0,32,32,32,32,32,32,32,32,32,0,0,0,0,0,0,0,97,115,105,110,0,0,0,0,92,112,117,116,40,37,100,44,37,100,41,123,92,37,115,40,48,44,37,100,41,123,37,100,125,125,10,0,0,0,0,0,84,104,105,115,32,116,101,114,109,105,110,97,108,32,100,111,101,115,32,110,111,116,32,115,117,112,112,111,114,116,32,109,117,108,116,105,112,108,111,116,0,0,0,0,0,0,0,0,103,97,117,115,115,0,0,0,108,111,95,113,117,97,114,116,105,108,101,0,0,0,0,0,117,36,110,105,116,0,0,0,114,105,103,104,116,32,106,117,115,116,105,102,105,101,100,44,32,0,0,0,0,0,0,0,105,110,116,49,54,0,0,0,114,105,36,103,104,116,0,0,110,111,36,104,97,99,107,116,101,120,116,0,0,0,0,0,118,101,99,116,111,114,10,0,115,117,114,102,97,99,101,0,107,101,121,36,112,114,101,115,115,0,0,0,0,0,0,0,39,93,39,32,101,120,112,101,99,116,101,100,0,0,0,0,75,80,95,50,0,0,0,0,37,32,71,78,85,80,76,79,84,58,32,76,97,84,101,88,32,112,105,99,116,117,114,101,32,117,115,105,110,103,32,80,83,84,82,73,67,75,83,32,109,97,99,114,111,115,10,0,92,99,97,116,99,111,100,101,96,64,61,49,50,10,92,102,105,10,92,101,110,100,112,115,112,105,99,116,117,114,101,10,0,0,0,0,0,0,0,0,102,105,114,36,115,116,0,0,92,112,115,112,105,99,116,117,114,101,40,37,102,44,37,102,41,40,37,102,44,37,102,41,10,92,105,102,120,92,110,111,102,105,103,115,92,117,110,100,101,102,105,110,101,100,10,92,99,97,116,99,111,100,101,96,64,61,49,49,10,10,0,0,92,112,115,115,101,116,123,117,110,105,116,61,53,46,48,105,110,44,120,117,110,105,116,61,53,46,48,105,110,44,121,117,110,105,116,61,51,46,48,105,110,125,10,0,0,0,0,0,49,46,53,32,109,117,108,32,46,53,32,115,117,98,0,0,112,97,114,97,109,101,116,101,114,32,102,105,108,101,32,37,115,32,99,111,117,108,100,32,110,111,116,32,98,101,32,114,101,97,100,0,0,0,0,0,92,110,101,119,112,115,111,98,106,101,99,116,123,80,83,84,64,65,114,114,111,119,125,123,112,115,108,105,110,101,125,123,108,105,110,101,119,105,100,116,104,61,46,48,48,49,44,108,105,110,101,115,116,121,108,101,61,115,111,108,105,100,125,10,92,99,97,116,99,111,100,101,96,64,61,49,50,10,10,92,102,105,10,0,0,0,0,0,115,121,110,116,97,120,32,101,114,114,111,114,32,105,110,32,112,97,114,97,109,101,116,101,114,32,102,105,108,101,0,0,92,110,101,119,112,115,111,98,106,101,99,116,123,80,83,84,64,80,108,117,115,125,123,112,115,100,111,116,115,125,123,108,105,110,101,119,105,100,116,104,61,46,48,48,49,44,108,105,110,101,115,116,121,108,101,61,115,111,108,105,100,44,100,111,116,115,116,121,108,101,61,43,125,10,92,110,101,119,112,115,111,98,106,101,99,116,123,80,83,84,64,83,113,117,97,114,101,125,123,112,115,100,111,116,115,125,123,108,105,110,101,119,105,100,116,104,61,46,48,48,49,44,108,105,110,101,115,116,121,108,101,61,115,111,108,105,100,44,100,111,116,115,116,121,108,101,61,115,113,117,97,114,101,125,10,92,110,101,119,112,115,111,98,106,101,99,116,123,80,83,84,64,67,105,114,99,108,101,125,123,112,115,100,111,116,115,125,123,108,105,110,101,119,105,100,116,104,61,46,48,48,49,44,108,105,110,101,115,116,121,108,101,61,115,111,108,105,100,44,100,111,116,115,116,121,108,101,61,111,125,10,92,110,101,119,112,115,111,98,106,101,99,116,123,80,83,84,64,84,114,105,97,110,103,108,101,125,123,112,115,100,111,116,115,125,123,108,105,110,101,119,105,100,116,104,61,46,48,48,49,44,108,105,110,101,115,116,121,108,101,61,115,111,108,105,100,44,100,111,116,115,116,121,108,101,61,116,114,105,97,110,103,108,101,125,10,92,110,101,119,112,115,111,98,106,101,99,116,123,80,83,84,64,80,101,110,116,97,103,111,110,125,123,112,115,100,111,116,115,125,123,108,105,110,101,119,105,100,116,104,61,46,48,48,49,44,108,105,110,101,115,116,121,108,101,61,115,111,108,105,100,44,100,111,116,115,116,121,108,101,61,112,101,110,116,97,103,111,110,125,10,92,110,101,119,112,115,111,98,106,101,99,116,123,80,83,84,64,70,105,108,108,115,113,117,97,114,101,125,123,112,115,100,111,116,115,125,123,108,105,110,101,119,105,100,116,104,61,46,48,48,49,44,108,105,110,101,115,116,121,108,101,61,115,111,108,105,100,44,100,111,116,115,116,121,108,101,61,115,113,117,97,114,101,42,125,10,92,110,101,119,112,115,111,98,106,101,99,116,123,80,83,84,64,70,105,108,108,99,105,114,99,108,101,125,123,112,115,100,111,116,115,125,123,108,105,110,101,119,105,100,116,104,61,46,48,48,49,44,108,105,110,101,115,116,121,108,101,61,115,111,108,105,100,44,100,111,116,115,116,121,108,101,61,42,125,10,92,110,101,119,112,115,111,98,106,101,99,116,123,80,83,84,64,70,105,108,108,116,114,105,97,110,103,108,101,125,123,112,115,100,111,116,115,125,123,108,105,110,101,119,105,100,116,104,61,46,48,48,49,44,108,105,110,101,115,116,121,108,101,61,115,111,108,105,100,44,100,111,116,115,116,121,108,101,61,116,114,105,97,110,103,108,101,42,125,10,92,110,101,119,112,115,111,98,106,101,99,116,123,80,83])
.concat([84,64,70,105,108,108,112,101,110,116,97,103,111,110,125,123,112,115,100,111,116,115,125,123,108,105,110,101,119,105,100,116,104,61,46,48,48,49,44,108,105,110,101,115,116,121,108,101,61,115,111,108,105,100,44,100,111,116,115,116,121,108,101,61,112,101,110,116,97,103,111,110,42,125,10,0,0,0,0,0,92,110,101,119,112,115,111,98,106,101,99,116,123,80,83,84,64,68,105,97,109,111,110,100,125,123,112,115,100,111,116,115,125,123,108,105,110,101,119,105,100,116,104,61,46,48,48,49,44,108,105,110,101,115,116,121,108,101,61,115,111,108,105,100,44,100,111,116,115,116,121,108,101,61,115,113,117,97,114,101,44,100,111,116,97,110,103,108,101,61,52,53,125,10,92,110,101,119,112,115,111,98,106,101,99,116,123,80,83,84,64,70,105,108,108,100,105,97,109,111,110,100,125,123,112,115,100,111,116,115,125,123,108,105,110,101,119,105,100,116,104,61,46,48,48,49,44,108,105,110,101,115,116,121,108,101,61,115,111,108,105,100,44,100,111,116,115,116,121,108,101,61,115,113,117,97,114,101,42,44,100,111,116,97,110,103,108,101,61,52,53,125,10,92,110,101,119,112,115,111,98,106,101,99,116,123,80,83,84,64,67,114,111,115,115,125,123,112,115,100,111,116,115,125,123,108,105,110,101,119,105,100,116,104,61,46,48,48,49,44,108,105,110,101,115,116,121,108,101,61,115,111,108,105,100,44,100,111,116,115,116,121,108,101,61,43,44,100,111,116,97,110,103,108,101,61,52,53,125,10,0,0,0,0,0,0,0,0,116,97,110,0,0,0,0,0,92,110,101,119,112,115,111,98,106,101,99,116,123,80,83,84,64,66,111,114,100,101,114,125,123,112,115,108,105,110,101,125,123,108,105,110,101,119,105,100,116,104,61,46,48,48,49,53,44,108,105,110,101,115,116,121,108,101,61,115,111,108,105,100,125,10,92,110,101,119,112,115,111,98,106,101,99,116,123,80,83,84,64,65,120,101,115,125,123,112,115,108,105,110,101,125,123,108,105,110,101,119,105,100,116,104,61,46,48,48,49,53,44,108,105,110,101,115,116,121,108,101,61,100,111,116,116,101,100,44,100,111,116,115,101,112,61,46,48,48,52,125,10,92,110,101,119,112,115,111,98,106,101,99,116,123,80,83,84,64,83,111,108,105,100,125,123,112,115,108,105,110,101,125,123,108,105,110,101,119,105,100,116,104,61,46,48,48,49,53,44,108,105,110,101,115,116,121,108,101,61,115,111,108,105,100,125,10,92,110,101,119,112,115,111,98,106,101,99,116,123,80,83,84,64,68,97,115,104,101,100,125,123,112,115,108,105,110,101,125,123,108,105,110,101,119,105,100,116,104,61,46,48,48,49,53,44,108,105,110,101,115,116,121,108,101,61,100,97,115,104,101,100,44,100,97,115,104,61,46,48,49,32,46,48,49,125,10,92,110,101,119,112,115,111,98,106,101,99,116,123,80,83,84,64,68,111,116,116,101,100,125,123,112,115,108,105,110,101,125,123,108,105,110,101,119,105,100,116,104,61,46,48,48,50,53,44,108,105,110,101,115,116,121,108,101,61,100,111,116,116,101,100,44,100,111,116,115,101,112,61,46,48,48,56,125,10,92,110,101,119,112,115,111,98,106,101,99,116,123,80,83,84,64,76,111,110,103,68,97,115,104,125,123,112,115,108,105,110,101,125,123,108,105,110,101,119,105,100,116,104,61,46,48,48,49,53,44,108,105,110,101,115,116,121,108,101,61,100,97,115,104,101,100,44,100,97,115,104,61,46,48,50,32,46,48,49,125,10,0,0,0,0,0,0,0,115,112,108,105,110,101,36,115,0,0,0,0,0,0,0,0,109,105,110,0,0,0,0,0,37,32,68,101,102,105,110,101,32,110,101,119,32,80,83,84,32,111,98,106,101,99,116,115,44,32,105,102,32,110,111,116,32,97,108,114,101,97,100,121,32,100,101,102,105,110,101,100,10,92,105,102,120,92,80,83,84,108,111,97,100,101,100,92,117,110,100,101,102,105,110,101,100,10,92,100,101,102,92,80,83,84,108,111,97,100,101,100,123,116,125,10,92,112,115,115,101,116,123,97,114,114,111,119,115,105,122,101,61,46,48,49,32,51,46,50,32,49,46,52,32,46,51,125,10,92,112,115,115,101,116,123,100,111,116,115,105,122,101,61,46,48,49,125,10,92,99,97,116,99,111,100,101,96,64,61,49,49,10,10,0,0,0,0,0,0,0,0,108,101,102,116,32,106,117,115,116,105,102,105,101,100,44,32,0,0,0,0,0,0,0,0,117,98,121,116,101,0,0,0,92,80,83,84,64,76,111,110,103,68,97,115,104,0,0,0,104,105,115,116,101,112,115,10,0,0,0,0,0,0,0,0,105,110,100,101,120,101,115,32,108,117,0,0,0,0,0,0,120,50,32,114,97,110,103,101,32,105,115,32,105,110,118,97,108,105,100,0,0,0,0,0,39,58,39,32,101,120,112,101,99,116,101,100,0,0,0,0,75,80,95,49,0,0,0,0,112,115,0,0,0,0,0,0,92,80,83,84,64,68,111,116,116,101,100,0,0,0,0,0,92,80,83,84,64,68,97,115,104,101,100,0,0,0,0,0,92,80,83,84,64,83,111,108,105,100,0,0,0,0,0,0,92,80,83,84,64,65,120,101,115,0,0,0,0,0,0,0,124,51,120,45,50,124,0,0,34,37,115,34,32,0,0,0,92,80,83,84,64,66,111,114,100,101,114,0,0,0,0,0,59,0,0,0,0,0,0,0,70,73,88,69,68,58,32,32,37,115,10,0,0,0,0,0,40,37,46,52,102,44,37,46,52,102,41,10,0,0,0,0,105,108,108,101,103,97,108,32,100,97,121,32,111,102,32,109,111,110,116,104,0,0,0,0,36,37,102,32,92,116,105,109,101,115,32,49,48,94,123,37,100,125,36,0,0,0,0,0,99,111,115,0,0,0,0,0,36,37,102,36,0,0,0,0,109,112,32,116,105,116,108,101,0,0,0,0,0,0,0,0,113,110,111,114,109,0,0,0,115,117,109,95,115,113,0,0,36,37,100,32,92,116,105,109,101,115,32,49,48,94,123,37,100,125,36,0,0,0,0,0,10,9,32,32,108,97,98,101,108,115,32,97,114,101,32,0,117,105,110,116,56,0,0,0,36,37,100,36,0,0,0,0,102,115,116,101,112,115,10,0,109,97,116,114,105,120,32,58,32,116,104,105,110,32,112,108,97,116,101,32,115,112,108,105,110,101,115,32,50,100,0,0,117,110,101,120,112,101,99,116,101,100,32,125,0,0,0,0,42,42,0,0,0,0,0,0,75,80,95,48,0,0,0,0,112,111,105,110,116,115,36,105,122,101,0,0,0,0,0,0,36,49,48,94,123,37,100,125,36,0,0,0,0,0,0,0,48,0,0,0,0,0,0,0,99,112,52,51,55,0,0,0,123,37,115,125,10,0,0,0,32,121,108,111,119,32,121,104,105,103,104,0,0,0,0,0,40,37,46,52,102,44,37,46,52,102,41,0,0,0,0,0,51,32,109,117,108,32,50,32,115,117,98,32,97,98,115,0,112,117,115,104,100,0,0,0,123,76,125,0,0,0,0,0,99,111,117,108,100,32,110,111,116,32,114,101,97,100,32,112,97,114,97,109,101,116,101,114,45,102,105,108,101,32,34,37,115,34,0,0,0,0,0,0,91,114,93,0,0,0,0,0,91,108,93,0,0,0,0,0,115,105,110,0,0,0,0,0,92,114,112,117,116,0,0,0,71,80,86,65,76,95,77,85,76,84,73,80,76,79,84,0,99,110,36,111,114,109,97,108,0,0,0,0,0,0,0,0,115,117,109,0,0,0,0,0,99,108,36,101,97,114,0,0,92,80,83,84,64,70,105,108,108,112,101,110,116,97,103,111,110,0,0,0,0,0,0,0,10,9,32,32,116,105,99,115,32,97,114,101,32,108,105,109,105,116,101,100,32,116,111,32,100,97,116,97,32,114,97,110,103,101,0,0,0,0,0,0,98,121,116,101,0,0,0,0,110,111,114,111,36,116,97,116,101,0,0,0,0,0,0,0,78,101,101,100,32,48,32,116,111,32,50,32,117,115,105,110,103,32,115,112,101,99,115,32,102,111,114,32,115,116,97,116,115,32,99,111,109,109,97,110,100,0,0,0,0,0,0,0,92,80,83,84,64,70,105,108,108,99,105,114,99,108,101,0,115,116,101,112,115,10,0,0,116,104,105,110,32,112,108,97,116,101,32,115,112,108,105,110,101,115,32,105,110,32,100,103,114,105,100,51,100,0,0,0,101,120,112,101,99,116,105,110,103,32,123,119,104,105,108,101,45,99,108,97,117,115,101,125,0,0,0,0,0,0,0,0,105,110,118,97,108,105,100,32,101,120,112,114,101,115,115,105,111,110,32,0,0,0,0,0,75,80,95,68,105,118,105,100,101,0,0,0,0,0,0,0,78,111,32,112,111,105,110,116,116,121,112,101,32,115,112,101,99,105,102,105,101,114,32,97,108,108,111,119,101,100,44,32,104,101,114,101,0,0,0,0,92,80,83,84,64,70,105,108,108,116,114,105,97,110,103,108,101,0,0,0,0,0,0,0,92,80,83,84,64,70,105,108,108,115,113,117,97,114,101,0,92,80,83,84,64,70,105,108,108,100,105,97,109,111,110,100,0,0,0,0,0,0,0,0,92,80,83,84,64,80,101,110,116,97,103,111,110,0,0,0,124,51,120,45,49,124,0,0,92,80,83,84,64,84,114,105,97,110,103,108,101,0,0,0,102,105,116,116,101,100,32,112,97,114,97,109,101,116,101,114,115,32,97,110,100,32,105,110,105,116,105,97,108,32,118,97,108,117,101,115,32,102,114,111,109,32,102,105,108,101,58,32,37,115,10,10,0,0,0,0,92,80,83,84,64,67,105,114,99,108,101,0,0,0,0,0,92,80,83,84,64,67,114,111,115,115,0,0,0,0,0,0,99,111,110,106,103,0,0,0,92,80,83,84,64,83,113,117,97,114,101,0,0,0,0,0,105,110,118,97,108,105,100,32,111,114,32,100,117,112,108,105,99,97,116,101,32,111,112,116,105,111,110,0,0,0,0,0,107,36,100,101,110,115,105,116,121,0,0,0,0,0,0,0,115,116,100,100,101,118,0,0,92,80,83,84,64,80,108,117,115,0,0,0,0,0,0,0,32,97,110,100,32,109,105,114,114,111,114,101,100,32,111,110,32,111,112,112,111,115,105,116,101,32,98,111,114,100,101,114,0,0,0,0,0,0,0,0,105,110,116,56,0,0,0,0,92,80,83,84,64,68,105,97,109,111,110,100,0,0,0,0,105,110,112,117,116,32,108,105,110,101,32,99,111,112,121,0,114,111,36,116,97,116,101,0,32,37,100,10,0,0,0,0,98,111,120,120,121,101,114,114,111,114,98,97,114,115,10,0,71,114,105,100,100,105,110,103,32,111,102,32,116,104,101,32,99,111,108,111,114,32,99,111,108,117,109,110,32,105,115,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,101,120,112,101,99,116,105,110,103,32,123,100,111,45,99,108,97,117,115,101,125,0,0,0,98,105,110,0,0,0,0,0,83,107,105,112,112,105,110,103,32,100,97,116,97,32,102,105,108,101,32,119,105,116,104,32,110,111,32,118,97,108,105,100,32,112,111,105,110,116,115,0,37,115,40,37,46,52,102,44,37,46,52,102,41,10,0,0,75,80,95,68,101,99,105,109,97,108,0,0,0,0,0,0,32,43,37,100,10,0,0,0,92,113,100,105,115,107,40,37,46,52,102,44,37,46,52,102,41,123,37,46,52,102,125,10,0,0,0,0,0,0,0,0,99,111,110,116,111,117,114,32,100,101,108,116,97,95,116,0,32,40,117,110,100,101,102,105,110,101,100,41,10,0,0,0,97,100,100,95,116,105,99,95,117,115,101,114,58,32,108,105,115,116,32,115,111,114,116,32,101,114,114,111,114,0,0,0,123,45,62,125,0,0,0,0,35,32,115,101,116,32,111,117,116,112,117,116,32,39,37,115,39,10,0,0,0,0,0,0,32,37,99,32,100,117,109,109,121,10,0,0,0,0,0,0,92,80,83,84,64,65,114,114,111,119,37,115,40,37,46,52,102,44,37,46,52,102,41,40,37,46,52,102,44,37,46,52,102,41,10,0,0,0,0,0,102,117,110,99,116,105,111,110,32,116,111,32,112,108,111,116,32,101,120,112,101,99,116,101,100,0,0,0,0,0,0,0,32,37,115,10,0,0,0,0,51,32,109,117,108,32,49,32,115,117,98,32,97,98,115,0,92,100,101,102,92,112,111,108,121,112,109,73,73,73,100,35,49,123,92,112,115,112,111,108,121,103,111,110,91,108,105,110,101,115,116,121,108,101,61,110,111,110,101,44,102,105,108,108,115,116,121,108,101,61,115,111,108,105,100,44,102,105,108,108,99,111,108,111,114,61,80,83,84,64,67,79,76,79,82,35,49,93,125,10,10,0,0,0,10,9,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,0,0,0,0,0,0,0,85,115,97,103,101,58,32,103,110,117,112,108,111,116,32,91,79,80,84,73,79,78,93,46,46,46,32,91,70,73,76,69,93,10,32,32,45,86,44,32,45,45,118,101,114,115,105,111,110,10,32,32,45,104,44,32,45,45,104,101,108,112,10,32,32,45,112,32,32,45,45,112,101,114,115,105,115,116,10,32,32,45,100,32,32,45,45,100,101,102,97,117,108,116,45,115,101,116,116,105,110,103,115,10,32,32,45,101,32,32,34,99,111,109,109,97,110,100,49,59,32,99,111,109,109,97,110,100,50,59,32,46,46,46,34,10,103,110,117,112,108,111,116,32,37,115,32,112,97,116,99,104,108,101,118,101,108,32,37,115,10,0,0,0,0,0,0,0,92,110,101,119,114,103,98,99,111,108,111,114,123,80,83,84,64,67,79,76,79,82,37,100,125,123,37,103,32,37,103,32,37,103,125,10,0,0,0,0,102,105,116,32,112,97,114,97,109,0,0,0,0,0,0,0,32,40,102,105,120,109,97,120,41,0,0,0,0,0,0,0,112,101,114,109,95,97,116,0,92,110,101,119,103,114,97,121,123,80,83,84,64,67,79,76,79,82,37,100,125,123,37,103,125,10,0,0,0,0,0,0,32,40,102,105,120,109,105,110,41,0,0,0,0,0,0,0,112,115,116,114,105,99,107,115,58,32,80,97,108,101,116,116,101,32,117,115,101,100,32,98,101,102,111,114,101,32,115,101,116,33,10,0,0,0,0,0,97,114,103,0,0,0,0,0,32,40,109,97,120,41,0,0,101,120,112,101,99,116,105,110,103,32,60,121,111,102,102,115,101,116,62,0,0,0,0,0,40,37,46,52,103,44,37,46,52,103,41,0,0,0,0,0,99,117,109,36,117,108,97,116,105,118,101,0,0,0,0,0,109,101,97,110,0,0,0,0,109,111,117,115,101,46,99,0,103,110,117,112,108,111,116,62,32,0,0,0,0,0,0,0,32,40,109,105,110,41,0,0,111,110,32,98,111,114,100,101,114,0,0,0,0,0,0,0,108,102,0,0,0,0,0,0,92,112,111,108,121,112,109,73,73,73,100,123,37,100,125,0,9,37,115,58,32,37,115,37,115,37,115,37,115,37,115,44,32,0,0,0,0,0,0,0,98,111,120,101,114,114,111,114,98,97,114,115,10,0,0,0,78,111,32,117,115,97,98,108,101,32,100,97,116,97,32,105,110,32,116,104,105,115,32,112,108,111,116,32,116,111,32,97,117,116,111,45,115,99,97,108,101,32,97,120,105,115,32,114,97,110,103,101,0,0,0,0,99,97,108,108,95,97,114,103,99,32,62,61,32,48,32,38,38,32,99,97,108,108,95,97,114,103,99,32,60,61,32,57,0,0,0,0,0,0,0,0,101,108,115,101,32,119,105,116,104,111,117,116,32,105,102,0,78,101,101,100,32,117,115,105,110,103,32,115,112,101,99,32,102,111,114,32,121,32,116,105,109,101,32,100,97,116,97,0,99,111,108,117,109,110,0,0,83,105,110,103,117,108,97,114,32,109,97,116,114,105,120,32,105,110,32,73,110,118,101,114,116,95,82,116,82,0,0,0,99,98,111,120,0,0,0,0,115,112,108,105,110,101,32,104,101,108,112,32,109,97,116,114,105,120,0,0,0,0,0,0,37,37,32,71,78,85,80,76,79,84,58,32,76,97,84,101,88,32,117,115,105,110,103,32,84,69,88,68,82,65,87,32,109,97,99,114,111,115,10,0,75,80,95,83,117,98,116,114,97,99,116,0,0,0,0,0,115,112,114,105,110,116,102,95,115,112,101,99,105,102,105,101,114,58,32,110,111,32,102,111,114,109,97,116,32,115,112,101,99,105,102,105,101,114,10,0,9,97,117,116,111,115,99,97,108,105,110,103,32,105,115,32,0,0,0,0,0,0,0,0,92,101,110,100,123,116,101,120,100,114,97,119,125,10,0,0,114,97,110,103,101,32,115,112,101,99,105,102,105,101,114,115,32,111,102,32,115,117,109,32,109,117,115,116,32,104,97,118,101,32,105,110,116,101,103,101,114,32,118,97,108,117,101,115,0,0,0,0,0,0,0,0,9,101,114,114,111,114,115,32,97,114,101,32,112,108,111,116,116,101,100,32,119,105,116,104,111,117,116,32,98,97,114,115,10,0,0,0,0,0,0,0,40,37,100,32,37,100,41,0,9,101,114,114,111,114,98,97,114,115,32,97,114,101,32,112,108,111,116,116,101,100,32,105,110,32,37,115,32,119,105,116,104,32,98,97,114,115,32,111,102,32,115,105,122,101,32,37,102,10,0,0,0,0,0,0,10,92,99,112,97,116,104,32,0,0,0,0,0,0,0,0,9,98,111,114,100,101,114,32,37,100,32,105,115,32,100,114,97,119,110,32,105,110,32,37,115,32,111,102,32,116,104,101,32,112,108,111,116,32,101,108,101,109,101,110,116,115,32,119,105,116,104,10,9,32,0,0,51,120,45,50,0,0,0,0,92,112,97,116,104,32,40,37,100,32,37,100,41,0,0,0,9,98,111,114,100,101,114,32,105,115,32,110,111,116,32,100,114,97,119,110,10,0,0,0,92,108,105,110,101,119,100,32,37,100,10,0,0,0,0,0,78,101,101,100,32,118,105,97,32,97,110,100,32,101,105,116,104,101,114,32,112,97,114,97,109,101,116,101,114,32,108,105,115,116,32,111,114,32,102,105,108,101,0,0,0,0,0,0,114,101,108,97,116,105,118,101,0,0,0,0,0,0,0,0,92,37,99,116,101,120,116,123,37,115,125,10,0,0,0,0,97,98,115,111,108,117,116,101,0,0,0,0,0,0,0,0,92,116,101,120,116,114,101,102,32,104,58,82,32,118,58,67,32,0,0,0,0,0,0,0,105,109,97,103,0,0,0,0,9,98,111,120,119,105,100,116,104,32,105,115,32,37,103,32,37,115,10,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,60,121,115,99,97,108,101,62,0,0,0,0,0,0,92,116,101,120,116,114,101,102,32,104,58,76,32,118,58,67,32,0,0,0,0,0,0,0,102,36,114,101,113,117,101,110,99,121,0,0,0,0,0,0,37,115,37,115,9,37,102,10,0,0,0,0,0,0,0,0,9,98,111,120,119,105,100,116,104,32,105,115,32,97,117,116,111,10,0,0,0,0,0,0,32,97,110,100,32,109,105,114,114,111,114,101,100,32,37,115,0,0,0,0,0,0,0,0,100,111,117,98,108,101,0,0,92,109,111,118,101,32,40,37,100,32,37,100,41,0,0,0,115,99,36,97,108,101,0,0,9,110,111,116,32,100,114,97,119,105,110,103,32,108,105,110,101,115,32,98,101,116,119,101,101,110,32,116,119,111,32,111,117,116,114,97,110,103,101,32,112,111,105,110,116,115,10,0,87,114,111,110,103,32,110,117,109,98,101,114,32,111,102,32,99,111,108,117,109,110,115,32,105,110,32,105,110,112,117,116,32,100,97,116,97,32,45,32,108,105,110,101,32,37,100,0,73,110,118,97,108,105,100,32,123,101,108,115,101,45,99,108,97,117,115,101,125,0,0,0,119,111,114,100,115,0,0,0,92,102,99,105,114,32,102,58,48,46,57,32,114,58,49,54,0,0,0,0,0,0,0,0,75,80,95,83,101,112,97,114,97,116,111,114,0,0,0,0,115,112,114,105,110,116,102,95,115,112,101,99,105,102,105,101,114,58,32,117,115,101,100,32,119,105,116,104,32,105,110,118,97,108,105,100,32,102,111,114,109,97,116,32,115,112,101,99,105,102,105,101,114,10,0,0,9,100,114,97,119,105,110,103,32,97,110,100,32,99,108,105,112,112,105,110,103,32,108,105,110,101,115,32,98,101,116,119,101,101,110,32,116,119,111,32,111,117,116,114,97,110,103,101,32,112,111,105,110,116,115,10,0,0,0,0,0,0,0,0,92,102,99,105,114,32,102,58,48,46,57,32,114,58,49,50,0,0,0,0,0,0,0,0,9,110,111,116,32,100,114,97,119,105,110,103,32,108,105,110,101,115,32,98,101,116,119,101,101,110,32,105,110,114,97,110,103,101,32,97,110,100,32,111,117,116,114,97,110,103,101,32,112,111,105,110,116,115,10,0,92,102,99,105,114,32,102,58,48,46,57,32,114,58,57,0,9,100,114,97,119,105,110,103,32,97,110,100,32,99,108,105,112,112,105,110,103,32,108,105,110,101,115,32,98,101,116,119,101,101,110,32,105,110,114,97,110,103,101,32,97,110,100,32,111,117,116,114,97,110,103,101,32,112,111,105,110,116,115,10,0,0,0,0,0,0,0,0,92,108,99,105,114,32,114,58,49,54,0,0,0,0,0,0,9,112,111,105,110,116,32,99,108,105,112,32,105,115,32,37,115,10,0,0,0,0,0,0,51,32,109,117,108,32,50,32,115,117,98,0,0,0,0,0,92,108,99,105,114,32,114,58,49,50,0,0,0,0,0,0,9,99,111,110,116,111,117,114,32,108,105,110,101,32,116,121,112,101,115,32,97,114,101,32,97,108,108,32,116,104,101,32,115,97,109,101,10,0,0,0,92,108,99,105,114,32,114,58,57,0,0,0,0,0,0,0,118,105,97,0,0,0,0,0,9,99,111,110,116,111,117,114,32,108,105,110,101,32,116,121,112,101,115,32,97,114,101,32,118,97,114,105,101,100,32,38,32,108,97,98,101,108,101,100,32,119,105,116,104,32,102,111,114,109,97,116,32,39,37,115,39,10,0,0,0,0,0,0,92,104,116,101,120,116,123,36,92,115,116,97,114,36,125,0,9,9,37,100,32,105,110,99,114,101,109,101,110,116,97,108,32,108,101,118,101,108,115,32,115,116,97,114,116,105,110,103,32,97,116,32,37,103,44,32,115,116,101,112,32,37,103,44,32,101,110,100,32,37,103,10,0,0,0,0,0,0,0,0,92,104,116,101,120,116,123,36,92,116,114,105,97,110,103,108,101,36,125,0,0,0,0,0,98,101,108,111,119,0,0,0,114,101,97,108,0,0,0,0,44,37,103,32,0,0,0,0,111,110,108,121,32,118,97,108,105,100,32,97,115,32,112,97,114,116,32,111,102,32,97,110,32,97,117,116,111,45,108,97,121,111,117,116,32,99,111,109,109,97,110,100,0,0,0,0,92,104,116,101,120,116,123,36,92,116,105,109,101,115,36,125,0,0,0,0,0,0,0,0,97,98,111,118,101,0,0,0,117,36,110,105,113,117,101,0,37,49,49,46,53,101,0,0,111,110,32,97,120,105,115,0,102,0,0,0,0,0,0,0,92,114,109,111,118,101,40,48,32,52,41,92,104,116,101,120,116,123,36,92,66,111,120,36,125,0,0,0,0,0,0,0,111,117,116,36,119,97,114,100,115,0,0,0,0,0,0,0,9,9,37,100,32,100,105,115,99,114,101,116,101,32,108,101,118,101,108,115,32,97,116,32,0,0,0,0,0,0,0,0,100,97,116,97,0,0,0,0,73,110,116,101,114,110,97,108,32,101,114,114,111,114,58,32,85,110,107,110,111,119,110,32,109,97,112,112,105,110,103,32,116,121,112,101,0,0,0,0,79,108,100,45,115,116,121,108,101,32,105,102,47,101,108,115,101,32,115,116,97,116,101,109,101,110,116,32,101,110,99,111,117,110,116,101,114,101,100,32,105,110,115,105,100,101,32,98,114,97,99,107,101,116,115,0,78,101,119,32,104,105,115,116,111,103,114,97,109,0,0,0,115,112,114,105,110,116,102,0,92,104,116,101,120,116,123,36,43,36,125,0,0,0,0,0,75,80,95,65,100,100,0,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,58,32,115,112,114,105,110,116,102,95,115,112,101,99,105,102,105,101,114,32,99,97,108,108,101,100,32,119,105,116,104,111,117,116,32,39,37,39,10,0,0,0,9,9,97,112,112,114,111,120,46,32,37,100,32,97,117,116,111,109,97,116,105,99,32,108,101,118,101,108,115,10,0,0,92,114,109,111,118,101,40,48,32,52,41,92,104,116,101,120,116,123,36,92,68,105,97,109,111,110,100,36,125,0,0,0,121,50,0,0,0,0,0,0,9,9,97,115,32,98,115,112,108,105,110,101,32,97,112,112,114,111,120,105,109,97,116,105,111,110,32,115,101,103,109,101,110,116,115,32,111,102,32,111,114,100,101,114,32,37,100,32,119,105,116,104,32,37,100,32,112,116,115,10,0,0,0,0,92,104,116,101,120,116,123,36,92,99,100,111,116,36,125,0,120,50,0,0,0,0,0,0,9,9,97,115,32,99,117,98,105,99,32,115,112,108,105,110,101,32,105,110,116,101,114,112,111,108,97,116,105,111,110,32,115,101,103,109,101,110,116,115,32,119,105,116,104,32,37,100,32,112,116,115,10,0,0,0,92,116,101,120,116,114,101,102,32,104,58,67,32,118,58,67,32,0,0,0,0,0,0,0,121,49,0,0,0,0,0,0,9,9,97,115,32,108,105,110,101,97,114,32,115,101,103,109,101,110,116,115,10,0,0,0,67,97,110,39,116,32,117,115,101,32,112,109,51,100,32,102,111,114,32,50,100,32,112,108,111,116,115,0,0,0,0,0,51,120,45,49,0,0,0,0,92,109,111,118,101,32,40,37,100,32,37,100,41,10,0,0,120,49,0,0,0,0,0,0,103,114,105,100,32,98,97,115,101,32,97,110,100,32,115,117,114,102,97,99,101,10,0,0,92,109,111,118,101,32,40,37,100,32,37,100,41,92,37,99,118,101,99,32,40,37,100,32,37,100,41,0,0,0,0,0,99,36,108,111,115,101,100,0,102,117,110,99,116,105,111,110,32,117,115,101,100,32,102,111,114,32,102,105,116,116,105,110,103,58,32,37,115,10,0,0,115,117,114,102,97,99,101,10,0,0,0,0,0,0,0,0,10,10,102,111,110,116,95,105,100,101,110,116,105,102,105,101,114,58,61,34,71,78,85,80,76,79,84,34,59,10,102,111,110,116,95,115,105,122,101,32,55,50,112,116,35,59,10,116,104,35,61,48,46,52,112,116,35,59,32,100,101,102,105,110,101,95,119,104,111,108,101,95,112,105,120,101,108,115,40,116,104,41,59,10,10,112,97,116,104,32,97,114,114,111,119,104,101,97,100,59,10,97,114,114,111,119,104,101,97,100,32,61,32,40,45,55,112,116,44,45,50,112,116,41,123,100,105,114,51,48,125,46,46,40,45,54,112,116,44,48,112,116,41,46,46,123,100,105,114,49,53,48,125,40,45,55,112,116,44,50,112,116,41,32,38,10,32,32,40,45,55,112,116,44,50,112,116,41,45,45,40,48,112,116,44,48,112,116,41,45,45,40,45,55,112,116,44,45,50,112,116,41,32,38,32,99,121,99,108,101,59,10,0,0,0,0,101,108,108,36,105,112,115,101,115,0,0,0,0,0,0,0,103,114,105,100,32,98,97,115,101,10,0,0,0,0,0,0,10,100,101,102,32,101,110,100,99,104,97,114,32,61,10,32,32,37,32,78,101,120,116,32,108,105,110,101,32,115,104,111,117,108,100,32,112,114,111,98,97,98,108,121,32,98,101,32,114,101,109,111,118,101,100,32,105,102,32,67,77,32,98,97,115,101,32,105,115,32,117,115,101,100,10,32,32,108,58,61,48,59,32,114,58,61,119,59,10,32,32,37,73,110,99,108,117,100,101,32,116,104,101,32,110,101,120,116,32,116,119,111,32,108,105,110,101,115,32,105,102,32,121,111,117,32,119,97,110,116,32,116,111,10,32,32,37,114,111,116,97,116,101,32,116,104,101,32,112,105,99,116,117,114,101,32,57,48,32,100,101,103,46,40,80,111,114,116,114,97,105,116,32,116,111,32,76,97,110,100,115,99,97,112,101,41,10,32,32,37,99,117,114,114,101,110,116,112,105,99,116,117,114,101,58,61,99,117,114,114,101,110,116,112,105,99,116,117,114,101,32,114,111,116,97,116,101,100,32,57,48,32,115,104,105,102,116,101,100,32,40,104,44,48,41,59,10,32,32,37,116,109,112,58,61,99,104,97,114,104,116,59,32,99,104,97,114,104,116,58,61,99,104,97,114,119,100,59,32,99,104,97,114,119,100,58,61,116,109,112,59,10,32,32,115,99,97,110,116,111,107,101,110,115,32,101,120,116,114,97,95,101,110,100,99,104,97,114,59,10,32,32,105,102,32,112,114,111,111,102,105,110,103,62,48,58,32,109,97,107,101,98,111,120,40,112,114,111,111,102,114,117,108,101,41,59,32,102,105,10,32,32,99,104,97,114,100,120,58,61,119,59,10,32,32,115,104,105,112,105,116,59,10,32,32,105,102,32,100,105,115,112,108,97,121,105,110,103,62,48,58,32,109,97,107,101,98,111,120,40,115,99,114,101,101,110,114,117,108,101,41,59,32,115,104,111,119,105,116,59,32,102,105,10,32,32,101,110,100,103,114,111,117,112,32,10,101,110,100,100,101,102,59,10,108,101,116,32,101,110,100,99,104,97,114,95,32,61,32,101,110,100,99,104,97,114,59,10,108,101,116,32,103,101,110,101,114,97,116,101,32,61,32,105,110,112,117,116,59,10,108,101,116,32,114,111,109,97,110,32,61,32,114,111,109,97,110,59,10,0,99,105,114,36,99,108,101,115,0,0,0,0,0,0,0,0,51,100,112,108,111,116,0,0,116,105,109,101,99,111,108,117,109,110,0,0,0,0,0,0,32,105,110,32,37,100,32,108,101,118,101,108,115,32,111,110,32,0,0,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,60,110,117,109,95,99,111,108,115,62,0,0,0,0,10,99,109,99,104,97,114,32,34,80,101,114,105,111,100,34,59,10,32,32,110,117,109,101,114,105,99,32,100,111,116,95,100,105,97,109,35,59,32,100,111,116,95,100,105,97,109,35,58,61,105,102,32,109,111,110,111,115,112,97,99,101,58,32,53,47,52,32,102,105,92,32,100,111,116,95,115,105,122,101,35,59,10,32,32,100,101,102,105,110,101,95,119,104,111,108,101,95,98,108,97,99,107,101,114,95,112,105,120,101,108,115,40,100,111,116,95,100,105,97,109,41,59,10,32,32,98,101,103,105,110,99,104,97,114,40,34,46,34,44,53,117,35,44,100,111,116,95,100,105,97,109,35,44,48,41,59,10,32,32,97,100,106,117,115,116,95,102,105,116,40,48,44,48,41,59,32,112,105,99,107,117,112,32,102,105,110,101,46,110,105,98,59,10,32,32,112,111,115,49,40,100,111,116,95,100,105,97,109,44,48,41,59,32,112,111,115,50,40,100,111,116,95,100,105,97,109,44,57,48,41,59,10,32,32,108,102,116,32,120,49,108,61,104,114,111,117,110,100,40,46,53,119,45,46,53,100,111,116,95,100,105,97,109,41,59,32,98,111,116,32,121,50,108,61,48,59,32,122,49,61,122,50,59,32,100,111,116,40,49,44,50,41,59,9,37,32,100,111,116,10,32,32,112,101,110,108,97,98,101,108,115,40,49,44,50,41,59,10,101,110,100,99,104,97,114,59,10,0,0,0,0,0,0,0,0,114,103,98,97,36,108,112,104,97,0,0,0,0,0,0,0,115,36,98,101,122,105,101,114,0,0,0,0,0,0,0,0,37,49,49,46,52,102,0,0,110,111,116,32,100,114,97,119,110,10,0,0,0,0,0,0,79,70,70,10,0,0,0,0,102,108,111,97,116,0,0,0,105,110,112,117,116,32,99,109,114,49,48,46,109,102,10,105,102,32,108,105,103,115,62,49,58,32,102,111,110,116,95,99,111,100,105,110,103,95,115,99,104,101,109,101,58,61,34,84,101,88,32,116,101,120,116,34,59,10,32,32,115,112,97,110,105,115,104,95,115,104,114,105,101,107,61,111,99,116,34,48,55,52,34,59,32,115,112,97,110,105,115,104,95,113,117,101,114,121,61,111,99,116,34,48,55,54,34,59,10,101,108,115,101,58,32,102,111,110,116,95,99,111,100,105,110,103,95,115,99,104,101,109,101,58,61,10,32,32,105,102,32,108,105,103,115,61,48,58,32,34,84,101,88,32,116,121,112,101,119,114,105,116,101,114,32,116,101,120,116,34,10,32,32,101,108,115,101,58,32,34,84,101,88,32,116,101,120,116,32,119,105,116,104,111,117,116,32,102,45,108,105,103,97,116,117,114,101,115,34,32,102,105,59,10,32,32,115,112,97,110,105,115,104,95,115,104,114,105,101,107,61,111,99,116,34,48,49,54,34,59,32,115,112,97,110,105,115,104,95,113,117,101,114,121,61,111,99,116,34,48,49,55,34,59,32,102,105,10,102,111,110,116,95,115,101,116,117,112,59,10,105,110,112,117,116,32,114,111,109,97,110,117,46,109,102,32,37,82,111,109,97,110,32,117,112,112,101,114,99,97,115,101,46,10,105,110,112,117,116,32,114,111,109,97,110,108,46,109,102,32,37,82,111,109,97,110,32,108,111,119,101,114,99,97,115,101,46,10,105,110,112,117,116,32,103,114,101,101,107,117,46,109,102,32,37,71,114,101,101,107,32,117,112,112,101,114,99,97,115,101,46,10,105,110,112,117,116,32,114,111,109,97,110,100,46,109,102,32,37,78,117,109,101,114,97,108,115,46,10,105,110,112,117,116,32,114,111,109,97,110,112,46,109,102,32,37,65,109,112,101,114,115,97,110,100,44,32,113,117,101,115,116,105,111,110,32,109,97,114,107,115,44,32,99,117,114,114,101,110,99,121,32,115,105,103,110,46,10,105,110,112,117,116,32,114,111,109,115,112,108,46,109,102,32,37,76,111,119,101,114,99,97,115,101,32,115,112,101,99,105,97,108,115,32,40,100,111,116,108,101,115,115,32,92,105,44,32,108,105,103,97,116,117,114,101,32,92,97,101,44,32,101,116,99,46,41,10,105,110,112,117,116,32,114,111,109,115,112,117,46,109,102,32,37,85,112,112,101,114,99,97,115,101,32,115,112,101,99,105,97,108,115,32,40,92,65,69,44,32,92,79,69,44,32,92,79,41,10,105,110,112,117,116,32,112,117,110,99,116,46,109,102,32,37,80,117,110,99,116,117,97,116,105,111,110,32,115,121,109,98,111,108,115,46,10,10,109,105,110,117,115,61,65,83,67,73,73,34,45,34,59,32,99,109,99,104,97,114,32,34,77,105,110,117,115,32,115,105,103,110,34,59,10,32,98,101,103,105,110,97,114,105,116,104,99,104,97,114,40,109,105,110,117,115,41,59,32,10,32,32,112,105,99,107,117,112,32,114,117,108,101,46,110,105,98,59,10,32,32,108,102,116,32,120,49,61,104,114,111,117,110,100,32,49,46,53,117,45,101,112,115,59,10,32,32,120,50,61,119,45,120,49,59,32,121,49,61,121,50,61,109,97,116,104,95,97,120,105,115,59,10,32,32,100,114,97,119,32,122,49,45,45,122,50,59,9,32,37,32,98,97,114,10,32,32,108,97,98,101,108,115,40,49,44,50,41,59,32,10,101,110,100,99,104,97,114,59,10,0,0,0,0,0,0,0,0,114,103,98,105,109,97,36,103,101,0,0,0,0,0,0,0,105,110,36,119,97,114,100,115,0,0,0,0,0,0,0,0,9,99,111,110,116,111,117,114,32,102,111,114,32,115,117,114,102,97,99,101,115,32,97,114,101,32,37,115,0,0,0,0,102,105,108,108,101,100,99,117,114,118,101,115,32,0,0,0,78,101,101,100,32,50,32,111,114,32,51,32,99,111,108,117,109,110,115,0,0,0,0,0,99,108,97,117,115,101,0,0,76,111,103,32,115,99,97,108,101,32,111,110,32,89,32,105,115,32,105,110,99,111,109,112,97,116,105,98,108,101,32,119,105,116,104,32,115,116,97,99,107,101,100,32,104,105,115,116,111,103,114,97,109,32,112,108,111,116,10,0,0,0,0,0,80,111,115,105,116,105,118,101,32,105,110,116,101,103,101,114,32,101,120,112,101,99,116,101,100,0,0,0,0,0,0,0,10,100,101,102,32,101,110,100,99,104,97,114,32,61,10,32,32,114,91,99,104,97,114,99,111,100,101,93,58,61,99,117,114,114,101,110,116,112,105,99,116,117,114,101,59,10,32,32,119,100,91,99,104,97,114,99,111,100,101,93,58,61,119,59,104,116,91,99,104,97,114,99,111,100,101,93,58,61,104,59,100,112,91,99,104,97,114,99,111,100,101,93,58,61,100,59,10,32,32,109,101,115,115,97,103,101,32,34,80,105,99,116,117,114,101,32,111,102,32,99,104,97,114,99,111,100,101,32,110,111,46,34,32,38,32,100,101,99,105,109,97,108,32,99,104,97,114,99,111,100,101,59,10,32,32,101,110,100,103,114,111,117,112,59,10,101,110,100,100,101,102,59,10,108,101,116,32,101,110,100,99,104,97,114,95,32,61,32,101,110,100,99,104,97,114,59,10,108,101,116,32,103,101,110,101,114,97,116,101,32,61,32,114,101,108,97,120,59,10,108,101,116,32,114,111,109,97,110,32,61,32,114,101,108,97,120,59,10,0,0,105,109,97,36,103,101,0,0,75,80,95,77,117,108,116,105,112,108,121,0,0,0,0,0,118,97,114,36,105,97,98,108,101,0,0,0,0,0,0,0,97,116,116,101,109,112,116,32,116,111,32,97,115,115,105,103,110,32,116,111,32,115,111,109,101,116,104,105,110,103,32,111,116,104,101,114,32,116,104,97,110,32,97,32,110,97,109,101,100,32,118,97,114,105,97,98,108,101,0,0,0,0,0,0,9,100,97,116,97,32,103,114,105,100,51,100,32,105,115,32,100,105,115,97,98,108,101,100,10,0,0,0,0,0,0,0,10,100,101,102,32,112,117,116,95,116,101,120,116,40,101,120,112,114,32,116,115,44,120,115,116,97,114,116,44,121,115,116,97,114,116,44,114,111,116,44,106,117,115,116,105,102,105,99,97,116,105,111,110,41,32,61,10,32,32,98,101,103,105,110,103,114,111,117,112,10,32,32,32,32,116,101,120,116,95,119,105,100,116,104,58,61,48,59,116,101,120,116,95,104,101,105,103,104,116,58,61,48,59,116,101,120,116,95,100,101,112,116,104,58,61,48,59,10,32,32,32,32,102,111,114,32,105,110,100,58,61,48,32,115,116,101,112,32,49,32,117,110,116,105,108,32,108,101,110,103,116,104,40,116,115,41,45,49,58,10,32,32,32,32,32,32,100,101,99,95,110,117,109,58,61,65,83,67,73,73,32,115,117,98,115,116,114,105,110,103,32,40,105,110,100,44,105,110,100,43,49,41,32,111,102,32,116,115,59,10,32,32,32,32,32,32,105,102,32,117,110,107,110,111,119,110,32,114,91,100,101,99,95,110,117,109,93,58,32,100,101,99,95,110,117,109,58,61,51,50,59,32,102,105,10,32,32,32,32,32,32,105,102,32,100,101,99,95,110,117,109,61,51,50,58,32,10,32,32,32,32,32,32,32,32,116,101,120,116,95,119,105,100,116,104,58,61,116,101,120,116,95,119,105,100,116,104,43,119,100,91,54,53,93,59,10,32,32,32,32,32,32,32,32,116,101,120,116,95,104,101,105,103,104,116,58,61,109,97,120,40,116,101,120,116,95,104,101,105,103,104,116,44,104,116,91,54,53,93,41,59,10,32,32,32,32,32,32,32,32,116,101,120,116,95,100,101,112,116,104,58,61,109,97,120,40,116,101,120,116,95,100,101,112,116,104,44,100,112,91,54,53,93,41,59,10,32,32,32,32,32,32,101,108,115,101,105,102,32,100,101,99,95,110,117,109,62,61,48,58,32,10,32,32,32,32,32,32,32,32,116,101,120,116,95,119,105,100,116,104,58,61,116,101,120,116,95,119,105,100,116,104,43,119,100,91,100,101,99,95,110,117,109,93,59,10,32,32,32,32,32,32,32,32,116,101,120,116,95,104,101,105,103,104,116,58,61,109,97,120,40,116,101,120,116,95,104,101,105,103,104,116,44,104,116,91,100,101,99,95,110,117,109,93,41,59,10,32,32,32,32,32,32,32,32,116,101,120,116,95,100,101,112,116,104,58,61,109,97,120,40,116,101,120,116,95,100,101,112,116,104,44,100,112,91,100,101,99,95,110,117,109,93,41,59,10,32,32,32,32,32,32,102,105,10,32,32,32,32,101,110,100,102,111,114,10,32,32,32,32,105,102,32,114,111,116,61,57,48,58,10,32,32,32,32,32,32,105,102,32,106,117,115,116,105,102,105,99,97,116,105,111,110,61,49,58,32,121,110,101,120,116,58,61,121,115,116,97,114,116,59,10,32,32,32,32,32,32,101,108,115,101,105,102,32,106,117,115,116,105,102,105,99,97,116,105,111,110,61,50,58,32,121,110,101,120,116,58,61,114,111,117,110,100,40,121,115,116,97,114,116,45,116,101,120,116,95,119,105,100,116,104,47,50,41,59,10,32,32,32,32,32,32,101,108,115,101,58,32,121,110,101,120,116,58,61,114,111,117,110,100,40,121,115,116,97,114,116,45,116,101,120,116,95,119,105,100,116,104,41,59,10,32,32,32,32,32,32,102,105,10,32,32,32,32,32,32,120,110,101,120,116,58,61,120,115,116,97,114,116,43,40,116,101,120,116,95,104,101,105,103,104,116,45,116,101,120,116,95,100,101,112,116,104,41,47,50,59,10,32,32,32,32,101,108,115,101,58,10,32,32,32,32,32,32,105,102,32,106,117,115,116,105,102,105,99,97,116,105,111,110,61,49,58,32,120,110,101,120,116,58,61,120,115,116,97,114,116,59,10,32,32,32,32,32,32,101,108,115,101,105,102,32,106,117,115,116,105,102,105,99,97,116,105,111,110,61,50,58,32,120,110,101,120,116,58,61,114,111,117,110,100,40,120,115,116,97,114,116,45,116,101,120,116,95,119,105,100,116,104,47,50,41,59,10,32,32,32,32,32,32,101,108,115,101,58,32,120,110,101,120,116,58,61,114,111,117,110,100,40,120,115,116,97,114,116,45,116,101,120,116,95,119,105,100,116,104,41,59,10,32,32,32,32,32,32,102,105,10,32,32,32,32,32,32,121,110,101,120,116,58,61,121,115,116,97,114,116,45,40,116,101,120,116,95,104,101,105,103,104,116,45,116,101,120,116,95,100,101,112,116,104,41,47,50,59,10,32,32,32,32,102,105,10,32,32,32,32,102,111,114,32,105,110,100,58,61,48,32,115,116,101,112,32,49,32,117,110,116,105,108,32,108,101,110,103,116,104,40,116,115,41,45,49,58,10,32,32,32,32,32,32,100,101,99,95,110,117,109,58,61,65,83,67,73,73,32,115,117,98,115,116,114,105,110,103,32,40,105,110,100,44,105,110,100,43,49,41,32,111,102,32,116,115,59,10,32,32,32,32,32,32,105,102,32,117,110,107,110,111,119,110,32,114,91,100,101,99,95,110,117,109,93,58,32,100,101,99,95,110,117,109,58,61,51,50,59,32,102,105,10,32,32,32,32,32,32,105,102,32,100,101,99,95,110,117,109,61,51,50,58,32,10,32,32,32,32,32,32,32,32,120,110,101,120,116,58,61,120,110,101,120,116,43,119,100,91,54,53,93,42,99,111,115,100,32,114,111,116,59,10,32,32,32,32,32,32,32,32,121,110,101,120,116,58,61,121,110,101,120,116,43,119,100,91,54,53,93,42,115,105,110,100,32,114,111,116,59,10,32,32,32,32,32,32,101,108,115,101,105,102,32,100,101,99,95,110,117,109,62,61,48,58,32,10,32,32,32,32,32,32,32,32,99,117,114,114,101,110,116,112,105,99,116,117,114,101,58,61,99,117,114,114,101,110,116,112,105,99,116,117,114,101,43,114,91,100,101,99,95,110,117,109,93,32,115,104,105,102,116,101,100,40,120,110,101,120,116,44,121,110,101,120,116,41,10,32,32,32,32,32,32,32,32,32,32,114,111,116,97,116,101,100,97,114,111,117,110,100,32,40,40,120,110,101,120,116,44,121,110,101,120,116,41,44,114,111,116,41,59,32,10,32,32,32,32,32,32,32,32,120,110,101,120,116,58,61,120,110,101,120,116,43,119,100,91,100,101,99,95,110,117,109,93,42,99,111,115,100,32,114,111,116,59,10,32,32,32,32,32,32,32,32,121,110,101,120,116,58,61])
.concat([121,110,101,120,116,43,119,100,91,100,101,99,95,110,117,109,93,42,115,105,110,100,32,114,111,116,59,10,32,32,32,32,32,32,102,105,10,32,32,32,32,101,110,100,102,111,114,10,32,32,101,110,100,103,114,111,117,112,32,10,101,110,100,100,101,102,59,10,0,0,0,0,108,97,98,101,108,115,0,0,44,32,107,100,101,110,115,105,116,121,50,100,32,109,111,100,101,0,0,0,0,0,0,0,99,111,108,111,114,32,97,120,105,115,0,0,0,0,0,0,10,37,73,110,99,108,117,100,101,32,110,101,120,116,32,101,105,103,104,116,32,108,105,110,101,115,32,105,102,32,121,111,117,32,104,97,118,101,32,112,114,111,98,108,101,109,115,32,119,105,116,104,32,116,104,101,32,109,111,100,101,32,111,110,32,121,111,117,114,32,115,121,115,116,101,109,46,46,10,37,112,114,111,111,102,105,110,103,58,61,48,59,10,37,102,111,110,116,109,97,107,105,110,103,58,61,49,59,10,37,116,114,97,99,105,110,103,116,105,116,108,101,115,58,61,48,59,10,37,112,105,120,101,108,115,95,112,101,114,95,105,110,99,104,58,61,51,48,48,59,10,37,98,108,97,99,107,101,114,58,61,48,59,10,37,102,105,108,108,105,110,58,61,46,50,59,10,37,111,95,99,111,114,114,101,99,116,105,111,110,58,61,46,54,59,10,37,102,105,120,95,117,110,105,116,115,59,10,0,0,0,0,0,0,0,0,99,97,110,36,100,108,101,115,116,105,99,107,115,0,0,0,9,100,97,116,97,32,103,114,105,100,51,100,32,105,115,32,101,110,97,98,108,101,100,32,102,111,114,32,109,101,115,104,32,111,102,32,115,105,122,101,32,37,100,120,37,100,44,32,107,101,114,110,101,108,61,37,115,44,10,9,115,99,97,108,101,32,102,97,99,116,111,114,115,32,120,61,37,102,44,32,121,61,37,102,37,115,10,0,105,102,32,117,110,107,110,111,119,110,32,99,109,98,97,115,101,58,32,105,110,112,117,116,32,99,109,98,97,115,101,32,102,105,10,10,116,114,97,99,105,110,103,115,116,97,116,115,58,61,49,59,10,112,105,99,116,117,114,101,32,114,91,93,59,10,10,100,101,102,32,111,112,101,110,105,116,32,61,32,111,112,101,110,119,105,110,100,111,119,32,99,117,114,114,101,110,116,119,105,110,100,111,119,10,32,32,102,114,111,109,32,40,48,44,48,41,32,116,111,32,40,52,48,48,44,56,48,48,41,32,97,116,32,40,45,53,48,44,53,48,48,41,32,101,110,100,100,101,102,59,10,10,109,111,100,101,95,115,101,116,117,112,59,10,0,0,0,102,105,110,36,97,110,99,101,98,97,114,115,0,0,0,0,9,100,97,116,97,32,103,114,105,100,51,100,32,105,115,32,101,110,97,98,108,101,100,32,102,111,114,32,109,101,115,104,32,111,102,32,115,105,122,101,32,37,100,120,37,100,44,32,115,112,108,105,110,101,115,10,0,0,0,0,0,0,0,0,51,32,109,117,108,32,49,32,115,117,98,0,0,0,0,0,101,110,100,99,104,97,114,59,10,0,0,0,0,0,0,0,118,101,99,36,116,111,114,115,0,0,0,0,0,0,0,0,9,100,97,116,97,32,103,114,105,100,51,100,32,105,115,32,101,110,97,98,108,101,100,32,102,111,114,32,109,101,115,104,32,111,102,32,115,105,122,101,32,37,100,120,37,100,44,32,110,111,114,109,61,37,100,10,0,0,0,0,0,0,0,0,68,97,109,97,103,101,100,32,69,68,70,32,104,101,97,100,101,114,32,111,102,32,37,115,58,32,110,111,116,32,109,117,108,116,105,112,108,101,32,111,102,32,53,49,50,32,66,46,10,0,0,0,0,0,0,0,97,58,61,119,47,37,100,59,98,58,61,104,47,37,100,59,10,0,0,0,0,0,0,0,104,105,115,36,116,101,112,115,0,0,0,0,0,0,0,0,32,32,32,32,32,32,32,32,114,101,115,105,100,117,97,108,115,32,97,114,101,32,119,101,105,103,104,116,101,100,32,101,113,117,97,108,108,121,32,40,117,110,105,116,32,119,101,105,103,104,116,41,10,10,0,0,9,99,111,109,109,97,110,100,32,108,105,110,101,32,109,97,99,114,111,115,32,119,105,108,108,32,37,115,98,101,32,101,120,112,97,110,100,101,100,10,0,0,0,0,0,0,0,0,65,115,115,101,114,116,105,111,110,32,102,97,105,108,101,100,58,32,37,115,0,0,0,0,10,10,98,101,103,105,110,99,104,97,114,40,37,100,44,37,103,105,110,35,44,37,103,105,110,35,44,48,41,59,10,0,102,115,36,116,101,112,115,0,99,121,108,105,110,100,114,105,99,97,108,10,0,0,0,0,100,114,97,119,32,40,37,100,97,44,37,100,98,41,45,45,40,37,100,97,44,37,100,98,41,59,10,0,0,0,0,0,102,105,108,108,115,116,36,101,112,115,0,0,0,0,0,0,118,97,108,105,100,0,0,0,115,112,104,101,114,105,99,97,108,10,0,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,39,44,32,60,110,117,109,95,99,111,108,115,62,39,0,0,0,0,0,0,0,0,100,114,97,119,100,111,116,32,40,37,100,97,44,37,100,98,41,59,10,0,0,0,0,0,115,116,36,101,112,115,0,0,99,36,115,112,108,105,110,101,115,0,0,0,0,0,0,0,32,32,83,117,109,32,120,121,58,32,32,32,32,32,32,32,37,46,52,103,10,0,0,0,99,97,114,116,101,115,105,97,110,10,0,0,0,0,0,0,9,37,115,45,97,120,105,115,32,116,105,99,115,58,9,0,108,117,0,0,0,0,0,0,101,114,114,111,114,32,105,110,32,101,100,103,101,51,100,95,105,110,116,101,114,115,101,99,116,0,0,0,0,0,0,0,112,105,99,107,117,112,32,112,101,110,99,105,114,99,108,101,32,115,99,97,108,101,100,32,37,103,116,104,59,10,0,0,98,111,120,120,36,121,101,114,114,111,114,98,97,114,115,0,110,111,109,105,36,114,114,111,114,0,0,0,0,0,0,0,9,109,97,112,112,105,110,103,32,102,111,114,32,51,45,100,32,100,97,116,97,32,105,115,32,0,0,0,0,0,0,0,104,105,115,116,111,103,114,97,109,115,10,0,0,0,0,0,50,32,99,111,108,117,109,110,115,32,111,110,108,121,32,112,111,115,115,105,98,108,101,32,119,105,116,104,32,101,120,112,108,105,99,105,116,32,112,109,51,100,32,115,116,121,108,101,32,40,108,105,110,101,32,37,100,41,0,0,0,0,0,0,76,111,103,32,115,99,97,108,101,32,111,110,32,88,32,105,115,32,105,110,99,111,109,112,97,116,105,98,108,101,32,119,105,116,104,32,104,105,115,116,111,103,114,97,109,32,112,108,111,116,115,10,0,0,0,0,101,120,112,101,99,116,101,100,32,123,101,108,115,101,45,99,108,97,117,115,101,125,0,0,67,111,108,117,109,110,32,110,117,109,98,101,114,32,101,120,112,101,99,116,101,100,0,0,112,117,116,95,116,101,120,116,40,34,37,115,34,44,37,100,97,44,37,100,98,44,37,100,44,37,100,41,59,10,0,0,98,111,120,101,114,36,114,111,114,98,97,114,115,0,0,0,75,80,95,69,113,117,97,108,0,0,0,0,0,0,0,0,65,116,116,101,109,112,116,32,116,111,32,97,115,115,105,103,110,32,116,111,32,97,32,114,101,97,100,45,111,110,108,121,32,118,97,114,105,97,98,108,101,0,0,0,0,0,0,0,9,100,117,109,109,121,32,118,97,114,105,97,98,108,101,115,32,97,114,101,32,34,37,115,34,32,97,110,100,32,34,37,115,34,10,0,0,0,0,0,102,105,108,108,32,97,114,114,111,119,104,101,97,100,32,114,111,116,97,116,101,100,32,97,110,103,108,101,40,37,100,44,37,100,41,32,115,104,105,102,116,101,100,32,40,37,100,97,44,37,100,98,41,59,10,0,102,105,108,108,101,100,99,36,117,114,118,101,115,0,0,0,9,32,32,37,115,45,97,120,105,115,58,32,34,37,115,34,10,0,0,0,0,0,0,0,39,58,39,32,111,114,32,107,101,121,119,111,114,100,32,39,116,111,39,32,101,120,112,101,99,116,101,100,0,0,0,0,102,111,36,110,116,0,0,0,104,105,115,116,36,111,103,114,97,109,115,0,0,0,0,0,9,116,105,99,32,102,111,114,109,97,116,32,105,115,58,10,0,0,0,0,0,0,0,0,109,97,36,103,110,105,102,105,99,97,116,105,111,110,0,0,98,111,120,101,115,0,0,0,9,37,115,32,97,114,101,32,112,108,111,116,116,101,100,32,119,105,116,104,32,0,0,0,51,120,0,0,0,0,0,0,110,111,112,114,111,36,108,111,103,117,101,115,0,0,0,0,120,121,101,36,114,114,111,114,98,97,114,115,0,0,0,0,32,119,105,116,104,32,98,111,114,100,101,114,32,0,0,0,112,114,111,36,108,111,103,117,101,115,0,0,0,0,0,0,120,101,36,114,114,111,114,98,97,114,115,0,0,0,0,0,32,119,105,116,104,32,110,111,32,98,111,114,100,101,114,10,0,0,0,0,0,0,0,0,32,32,32,32,32,32,32,32,35,100,97,116,97,112,111,105,110,116,115,32,61,32,37,100,10,0,0,0,0,0,0,0,110,111,112,115,36,110,102,115,115,0,0,0,0,0,0,0,101,36,114,114,111,114,98,97,114,115,0,0,0,0,0,0,9,70,105,108,108,32,115,116,121,108,101,32,105,115,32,101,109,112,116,121,0,0,0,0,112,115,110,102,115,115,45,118,36,101,114,115,105,111,110,55,0,0,0,0,0,0,0,0,121,101,36,114,114,111,114,98,97,114,115,0,0,0,0,0,9,70,105,108,108,32,115,116,121,108,101,32,117,115,101,115,32,37,115,32,112,97,116,116,101,114,110,115,32,115,116,97,114,116,105,110,103,32,97,116,32,37,100,0,0,0,0,0,112,115,36,110,102,115,115,0,120,121,101,114,114,111,114,108,36,105,110,101,115,0,0,0,98,36,101,122,105,101,114,0,32,32,67,111,114,114,101,108,97,116,105,111,110,58,32,32,114,32,61,32,37,46,52,103,10,0,0,0,0,0,0,0,116,114,97,110,115,112,97,114,101,110,116,0,0,0,0,0,61,0,0,0,0,0,0,0,79,85,84,0,0,0,0,0,117,108,111,110,103,0,0,0,97,109,36,115,116,101,120,0,120,101,114,114,111,114,108,36,105,110,101,115,0,0,0,0,109,105,36,114,114,111,114,0,9,70,105,108,108,32,115,116,121,108,101,32,117,115,101,115,32,37,115,32,115,111,108,105,100,32,99,111,108,111,117,114,32,119,105,116,104,32,100,101,110,115,105,116,121,32,37,46,51,102,0,0,0,0,0,0,98,111,120,101,115,10,0,0,103,101,116,95,100,97,116,97,58,32,107,101,121,32,116,105,116,108,101,32,110,111,116,32,102,111,117,110,100,32,105,110,32,114,101,113,117,101,115,116,101,100,32,99,111,108,117,109,110,10,0,0,0,0,0,0,84,104,105,115,32,112,108,111,116,32,115,116,121,108,101,32,105,115,32,110,111,116,32,97,118,97,105,108,97,98,108,101,32,105,110,32,112,111,108,97,114,32,109,111,100,101,0,0,97,52,36,112,97,112,101,114,0,0,0,0,0,0,0,0,101,114,114,111,114,108,36,105,110,101,115,0,0,0,0,0,75,80,95,68,101,108,101,116,101,0,0,0,0,0,0,0,100,101,102,97,117,108,116,32,108,105,110,101,116,121,112,101,115,10,0,0,0,0,0,0,108,97,36,116,101,120,0,0,121,101,114,114,111,114,108,36,105,110,101,115,0,0,0,0,117,115,101,114,45,100,101,102,105,110,101,100,32,108,105,110,101,32,115,116,121,108,101,115,32,114,97,116,104,101,114,32,116,104,97,110,32,100,101,102,97,117,108,116,32,108,105,110,101,32,116,121,112,101,115,10,0,0,0,0,0,0,0,0,116,36,101,120,0,0,0,0,100,36,111,116,115,0,0,0,9,80,108,111,116,32,108,105,110,101,115,32,105,110,99,114,101,109,101,110,116,32,111,118,101,114,32,0,0,0,0,0,110,36,111,116,101,120,0,0,108,112,0,0,0,0,0,0,102,111,114,116,36,114,97,110,0,0,0,0,0,0,0,0,32,116,101,120,116,99,111,108,111,114,32,108,116,32,37,100,0,0,0,0,0,0,0,0,51,32,109,117,108,0,0,0,115,36,111,108,105,100,0,0,108,105,110,101,115,112,36,111,105,110,116,115,0,0,0,0,32,116,105,116,108,101,32,111,102,102,115,101,116,32,0,0,99,36,111,108,111,117,114,0,78,111,32,100,97,116,97,32,116,111,32,102,105,116,32,0,9,72,105,115,116,111,103,114,97,109,32,115,116,121,108,101,32,105,115,32,99,111,108,117,109,110,115,116,97,99,107,101,100,32,0,0,0,0,0,0,99,36,111,108,111,114,0,0,66,97,100,32,97,98,98,114,101,118,105,97,116,101,100,32,109,111,110,116,104,32,110,97,109,101,0,0,0,0,0,0,105,36,109,112,117,108,115,101,115,0,0,0,0,0,0,0,9,72,105,115,116,111,103,114,97,109,32,115,116,121,108,101,32,105,115,32,114,111,119,115,116,97,99,107,101,100,32,0,109,111,36,110,111,99,104,114,111,109,101,0,0,0,0,0,98,111,120,112,108,111,116,0,115,116,114,99,111,108,0,0,9,72,105,115,116,111,103,114,97,109,32,115,116,121,108,101,32,105,115,32,101,114,114,111,114,98,97,114,115,32,119,105,116,104,32,103,97,112,32,37,100,32,108,119,32,37,103,32,0,0,0,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,39,60,110,117,109,95,99,111,108,115,62,44,60,110,117,109,95,114,111,119,115,62,39,0,0,0,0,0,0,0,112,115,110,115,102,115,115,0,114,101,99,116,36,97,110,103,108,101,0,0,0,0,0,0,97,36,99,115,112,108,105,110,101,115,0,0,0,0,0,0,32,32,76,105,110,101,97,114,32,77,111,100,101,108,58,32,121,32,61,32,37,46,52,103,32,120,32,43,32,37,46,52,103,10,0,0,0,0,0,0,9,72,105,115,116,111,103,114,97,109,32,115,116,121,108,101,32,105,115,32,99,108,117,115,116,101,114,101,100,32,119,105,116,104,32,103,97,112,32,37,100,32,0,0,0,0,0,0,73,78,0,0,0,0,0,0,108,100,0,0,0,0,0,0,112,115,110,115,102,115,115,40,118,55,41,0,0,0,0,0,101,108,108,36,105,112,115,101,0,0,0,0,0,0,0,0,97,114,114,111,119,115,116,121,108,101,32,110,111,116,32,102,111,117,110,100,0,0,0,0,120,121,101,114,114,111,114,98,97,114,115,10,0,0,0,0,101,120,112,101,99,116,105,110,103,32,40,101,120,112,114,101,115,115,105,111,110,41,0,0,39,41,39,32,101,120,112,101,99,116,101,100,0,0,0,0,37,115,32,37,115,32,37,115,116,101,120,37,115,37,115,32,109,97,103,32,37,46,51,102,32,37,115,32,37,115,112,114,111,108,111,103,117,101,115,40,37,100,41,0,0,0,0,0,99,105,114,99,36,108,101,0,75,80,95,80,97,103,101,85,112,0,0,0,0,0,0,0,108,105,110,101,99,36,111,108,111,114,0,0,0,0,0,0,32,40,100,101,102,97,117,108,116,32,108,101,110,103,116,104,32,97,110,100,32,97,110,103,108,101,115,41,10,0,0,0,32,97,109,115,116,101,120,0,104,105,115,116,36,111,103,114,97,109,0,0,0,0,0,0,32,108,101,110,103,116,104,32,37,115,37,103,44,32,97,110,103,108,101,32,37,103,32,100,101,103,0,0,0,0,0,0,115,116,97,114,116,105,110,103,32,114,97,110,103,101,32,118,97,108,117,101,32,111,114,32,39,58,39,32,111,114,32,39,116,111,39,32,101,120,112,101,99,116,101,100,0,0,0,0,32,97,52,112,97,112,101,114,0,0,0,0,0,0,0,0,105,110,99,114,36,101,109,101,110,116,0,0,0,0,0,0,9,32,32,97,114,114,111,119,32,104,101,97,100,115,58,32,37,115,44,32,0,0,0,0,108,97,0,0,0,0,0,0,102,115,0,0,0,0,0,0,32,110,111,104,101,97,100,0,124,99,111,115,40,55,50,48,120,41,124,0,0,0,0,0,9,108,111,97,100,112,97,116,104,32,105,115,32,0,0,0,109,111,110,111,99,104,114,111,109,101,0,0,0,0,0,0,32,111,110,101,32,104,101,97,100,32,0,0,0,0,0,0,99,111,108,111,114,0,0,0,108,36,105,110,101,115,0,0,115,116,114,105,110,103,0,0,37,103,93,10,0,0,0,0,32,98,111,116,104,32,104,101,97,100,115,32,0,0,0,0,98,105,110,100,0,0,0,0,105,108,108,101,103,97,108,32,109,111,110,116,104,0,0,0,37,115,32,37,115,32,37,115,116,101,120,37,115,37,115,32,109,97,103,32,37,46,51,102,32,102,111,110,116,32,34,37,115,44,37,46,50,102,34,32,37,115,112,114,111,108,111,103,117,101,115,40,37,100,41,0,102,36,117,110,99,116,105,111,110,0,0,0,0,0,0,0,9,32,37,115,32,37,115,0,101,120,112,101,99,116,105,110,103,32,102,111,110,116,32,110,97,109,101,0,0,0,0,0,100,36,97,116,97,0,0,0,115,116,114,105,110,103,99,111,108,117,109,110,0,0,0,0,9,97,114,114,111,119,115,116,121,108,101,32,37,100,44,32,0,0,0,0,0,0,0,0,116,111,111,32,109,97,110,121,32,108,97,121,111,117,116,32,99,111,109,109,97,110,100,115,0,0,0,0,0,0,0,0,112,99,114,114,56,114,0,0,103,114,97,121,49,48,48,0,120,50,121,49,0,0,0,0,32,32,76,105,110,101,97,114,32,77,111,100,101,108,58,32,121,32,61,32,37,46,52,103,32,120,32,45,32,37,46,52,103,10,0,0,0,0,0,0,97,112,112,101,97,114,32,105,110,32,116,104,101,32,111,114,100,101,114,32,116,104,101,121,32,119,101,114,101,32,102,111,117,110,100,0,0,0,0,0,9,37,115,45,97,120,105,115,32,116,105,99,115,32,97,114,101,32,37,115,44,32,9,109,97,106,111,114,32,116,105,99,115,99,97,108,101,32,105,115,32,37,103,32,97,110,100,32,109,105,110,111,114,32,116,105,99,115,99,97,108,101,32,105,115,32,37,103,10,0,0,0,108,111,110,103,0,0,0,0,99,109,114,49,48,0,0,0,103,114,97,121,57,48,0,0,97,120,36,105,115,0,0,0,98,101,32,115,111,114,116,101,100,32,97,108,112,104,97,98,101,116,105,99,97,108,108,121,0,0,0,0,0,0,0,0,120,101,114,114,111,114,98,97,114,115,10,0,0,0,0,0,66,97,100,32,100,97,116,97,32,111,110,32,108,105,110,101,32,37,100,32,111,102,32,102,105,108,101,32,37,115,0,0,89,111,117,32,104,97,118,101,32,116,111,32,99,111,109,112,105,108,101,32,103,110,117,112,108,111,116,32,119,105,116,104,32,98,117,105,108,116,105,110,32,114,101,97,100,108,105,110,101,32,111,114,32,71,78,85,32,114,101,97,100,108,105,110,101,32,111,114,32,66,83,68,32,101,100,105,116,108,105,110,101,32,116,111,32,101,110,97,98,108,101,32,104,105,115,116,111,114,121,32,115,117,112,112,111,114,116,46,0,0,0,0,10,100,101,102,32,95,119,99,32,61,32,119,105,116,104,112,101,110,32,99,117,114,114,101,110,116,112,101,110,32,119,105,116,104,99,111,108,111,114,32,99,117,114,114,101,110,116,99,111,108,111,114,32,101,110,100,100,101,102,59,10,100,101,102,32,95,97,99,32,61,32,97,100,100,116,111,32,99,117,114,114,101,110,116,112,105,99,116,117,114,101,32,101,110,100,100,101,102,59,10,100,101,102,32,95,115,109,115,32,61,32,115,99,97,108,101,100,32,109,112,116,32,115,104,105,102,116,101,100,32,101,110,100,100,101,102,59,10,37,32,100,114,97,119,105,110,103,32,112,111,105,110,116,45,116,121,112,101,115,10,100,101,102,32,103,112,100,114,97,119,32,40,101,120,112,114,32,110,44,32,120,44,32,121,41,32,61,10,32,32,105,102,32,110,60,48,58,32,95,97,99,32,99,111,110,116,111,117,114,32,102,117,108,108,99,105,114,99,108,101,32,95,115,109,115,32,40,120,44,121,41,10,32,32,101,108,115,101,105,102,32,40,110,61,49,41,32,111,114,32,40,110,61,51,41,58,10,32,32,32,32,95,97,99,32,100,111,117,98,108,101,112,97,116,104,32,112,116,112,97,116,104,91,110,93,32,95,115,109,115,32,40,120,44,121,41,32,95,119,99,59,10,32,32,32,32,95,97,99,32,100,111,117,98,108,101,112,97,116,104,32,112,116,112,97,116,104,91,110,93,32,114,111,116,97,116,101,100,32,57,48,32,95,115,109,115,32,40,120,44,121,41,32,95,119,99,10,32,32,101,108,115,101,105,102,32,110,60,54,58,32,95,97,99,32,100,111,117,98,108,101,112,97,116,104,32,112,116,112,97,116,104,91,110,93,32,95,115,109,115,32,40,120,44,121,41,32,95,119,99,10,32,32,101,108,115,101,58,32,95,97,99,32,99,111,110,116,111,117,114,32,112,116,112,97,116,104,91,110,93,32,95,115,109,115,32,40,120,44,121,41,32,95,119,99,10,32,32,102,105,10,101,110,100,100,101,102,59,10,10,37,32,116,104,101,32,112,111,105,110,116,32,115,104,97,112,101,115,10,112,97,116,104,32,112,116,112,97,116,104,91,93,59,10,37,100,105,97,109,111,110,100,10,112,116,112,97,116,104,48,32,61,32,112,116,112,97,116,104,54,32,61,32,40,45,49,47,50,44,48,41,45,45,40,48,44,45,49,47,50,41,45,45,40,49,47,50,44,48,41,45,45,40,48,44,49,47,50,41,45,45,99,121,99,108,101,59,10,37,32,112,108,117,115,32,115,105,103,110,10,112,116,112,97,116,104,49,32,61,32,40,45,49,47,50,44,48,41,45,45,40,49,47,50,44,48,41,59,10,37,32,115,113,117,97,114,101,10,112,116,112,97,116,104,50,32,61,32,112,116,112,97,116,104,55,32,61,32,40,45,49,47,50,44,45,49,47,50,41,45,45,40,49,47,50,44,45,49,47,50,41,45,45,40,49,47,50,44,49,47,50,41,45,45,40,45,49,47,50,44,49,47,50,41,45,45,99,121,99,108,101,59,10,37,32,99,114,111,115,115,10,112,116,112,97,116,104,51,32,58,61,32,40,45,49,47,50,44,45,49,47,50,41,45,45,40,49,47,50,44,49,47,50,41,59,10,37,32,99,105,114,99,108,101,58,10,112,116,112,97,116,104,52,32,61,32,112,116,112,97,116,104,56,58,61,32,102,117,108,108,99,105,114,99,108,101,59,10,37,32,116,114,105,97,110,103,108,101,10,112,116,112,97,116,104,53,32,61,32,112,116,112,97,116,104,57,32,58,61,32,40,48,44,49,47,50,41,45,45,40,45,49,47,50,44,45,49,47,50,41,45,45,40,49,47,50,44,45,49,47,50,41,45,45,99,121,99,108,101,59,10,10,100,101,102,32,108,105,110,101,116,121,112,101,32,101,120,112,114,32,110,32,61,10,32,32,99,117,114,114,101,110,116,99,111,108,111,114,58,61,32,105,102,32,99,111,108,111,114,108,105,110,101,115,32,58,32,99,111,108,91,110,93,32,101,108,115,101,58,32,98,108,97,99,107,32,102,105,59,10,32,32,105,102,32,110,32,61,32,45,49,32,58,10,32,32,32,32,32,32,100,114,97,119,111,112,116,105,111,110,115,40,119,105,116,104,99,111,108,111,114,32,99,117,114,114,101,110,116,99,111,108,111,114,32,119,105,116,104,112,101,110,32,40,99,117,114,114,101,110,116,112,101,110,32,115,99,97,108,101,100,32,46,53,41,41,59,10,32,32,101,108,115,101,105,102,32,110,32,60,32,49,32,58,10,32,32,32,32,100,114,97,119,111,112,116,105,111,110,115,40,95,119,99,41,59,10,32,32,101,108,115,101,32,58,10,32,32,32,32,100,114,97,119,111,112,116,105,111,110,115,40,32,105,102,32,100,97,115,104,101,100,108,105,110,101,115,58,32,100,97,115,104,101,100,32,108,116,91,110,93,32,102,105,32,95,119,99,41,59,10,32,32,102,105,10,101,110,100,100,101,102,59,10,10,37,32,100,97,115,104,32,112,97,116,116,101,114,110,115,10,112,105,99,116,117,114,101,32,108,116,91,93,59,10,108,116,49,61,100,97,115,104,112,97,116,116,101,114,110,40,111,110,32,50,32,111,102,102,32,50,41,59,32,37,32,100,97,115,104,101,115,10,108,116,50,61,100,97,115,104,112,97,116,116,101,114,110,40,111,110,32,50,32,111,102,102,32,50,32,111,110,32,48,46,50,32,111,102,102,32,50,41,59,32,37,100,97,115,104,45,100,111,116,10,108,116,51,61,108,116,49,32,115,99,97,108,101,100,32,49,46,52,49,52,59,10,108,116,52,61,108,116,50,32,115,99,97,108,101,100,32,49,46,52,49,52,59,10,108,116,53,61,108,116,49,32,115,99,97,108,101,100,32,50,59,10,108,116,54,58,61,108,116,50,32,115,99,97,108,101,100,32,50,59,10,108,116,55,61,100,97,115,104,112,97,116,116,101,114,110,40,111,110,32,48,46,50,32,111,102,102,32,50,41,59,32,37,100,111,116,115,10,10,99,111,108,111,114,32,99,111,108,91,93,44,99,121,97,110,44,32,109,97,103,101,110,116,97,44,32,121,101,108,108,111,119,59,10,99,121,97,110,61,98,108,117,101,43,103,114,101,101,110,59,32,109,97,103,101,110,116,97,61,114,101,100,43,98,108,117,101,59,121,101,108,108,111,119,61,103,114,101,101,110,43,114,101,100,59,10,99,111,108,91,45,50,93,58,61,99,111,108,91,45,49,93,58,61,99,111,108,48,58,61,98,108,97,99,107,59,10,99,111,108,49,58,61,114,101,100,59,10,99,111,108,50,58,61,40,46,50,44,46,50,44,49,41,59,32,37,98,108,117,101,10,99,111,108,51,58,61,40,49,44,46,54,54,44,48,41,59,32,37,111,114,97,110,103,101,10,99,111,108,52,58,61,46,56,53,42,103,114,101,101,110,59,10,99,111,108,53,58,61,46,57,42,109,97,103,101,110,116,97,59,10,99,111,108,54,58,61,48,46,56,53,42,99,121,97,110,59,10,99,111,108,55,58,61,46,56,53,42,121,101,108,108,111,119,59,10,10,37,112,108,97,99,105,110,103,32,116,101,120,116,10,112,105,99,116,117,114,101,32,71,80,116,101,120,116,59,10,100,101,102,32,112,117,116,95,116,101,120,116,40,101,120,112,114,32,112,105,99,44,32,120,44,32,121,44,32,114,44,32,106,41,32,61,10,32,32,71,80,116,101,120,116,58,61,109,97,107,101,112,105,99,40,112,105,99,41,59,10,32,32,71,80,116,101,120,116,58,61,71,80,116,101,120,116,32,115,104,105,102,116,101,100,10,32,32,32,32,105,102,32,106,32,61,32,49,58,32,40,45,40,117,108,99,111,114,110,101,114,32,71,80,116,101,120,116,32,43,32,108,108,99,111,114,110,101,114,32,71,80,116,101,120,116,41,47,50,41,10,32,32,32,32,101,108,115,101,105,102,32,106,32,61,32,50,58,32,40,45,99,101,110,116,101,114,32,71,80,116,101,120,116,41,10,32,32,32,32,101,108,115,101,58,32,40,45,40,117,114,99,111,114,110,101,114,32,71,80,116,101,120,116,32,43,32,108,114,99,111,114,110,101,114,32,71,80,116,101,120,116,41,47,50,41,10,32,32,32,32,102,105,10,32,32,32,32,114,111,116,97,116,101,100,32,114,59,10,32,32,97,100,100,116,111,32,99,117,114,114,101,110,116,112,105,99,116,117,114,101,32,97,108,115,111,32,71,80,116,101,120,116,32,115,104,105,102,116,101,100,32,40,120,44,121,41,10,101,110,100,100,101,102,59,10,0,0,0,0,0,0,0,0,103,114,97,121,56,48,0,0,75,80,95,85,112,0,0,0,108,99,0,0,0,0,0,0,69,82,82,78,79,0,0,0,9,102,97,99,116,111,114,32,108,97,98,101,108,115,32,119,105,108,108,32,37,115,10,0,100,97,115,104,101,100,108,105,110,101,115,58,61,116,114,117,101,59,10,0,0,0,0,0,103,114,97,121,55,48,0,0,97,114,101,32,111,102,102,0,100,97,115,104,101,100,108,105,110,101,115,58,61,102,97,108,115,101,59,10,0,0,0,0,103,114,97,121,54,48,0,0,105,115,111,95,56,56,53,57,95,49,53,0,0,0,0,0,97,114,101,32,97,117,116,111,109,97,116,105,99,0,0,0,32,120,108,111,119,32,120,104,105,103,104,0,0,0,0,0,99,111,108,111,114,108,105,110,101,115,58,61,102,97,108,115,101,59,10,0,0,0,0,0,103,114,97,121,53,48,0,0,119,105,108,108,32,98,101,32,112,117,116,32,111,110,32,116,104,101,32,120,50,32,97,120,105,115,0,0,0,0,0,0,55,50,48,32,109,117,108,32,99,111,115,32,97,98,115,0,99,111,108,111,114,108,105,110,101,115,58,61,116,114,117,101,59,10,0,0,0,0,0,0,103,114,97,121,52,48,0,0,112,117,115,104,100,50,0,0,119,105,108,108,32,98,101,32,112,117,116,32,111,110,32,116,104,101,32,120,32,97,120,105,115,0,0,0,0,0,0,0,100,114,111,112,108,97,115,116,95,100,121,110,97,114,114,97,121,58,32,100,121,110,97,114,114,97,121,32,119,97,115,110,39,116,32,105,110,105,116,105,97,108,105,122,101,100,33,0,10,99,111,108,111,114,32,99,117,114,114,101,110,116,99,111,108,111,114,59,32,99,117,114,114,101,110,116,99,111,108,111,114,58,61,98,108,97,99,107,59,10,99,111,108,111,114,32,102,105,108,108,99,111,108,111,114,59,10,98,111,111,108,101,97,110,32,99,111,108,111,114,108,105,110,101,115,44,100,97,115,104,101,100,108,105,110,101,115,59,10,0,0,0,0,0,103,114,97,121,51,48,0,0,9,102,97,99,116,111,114,32,108,97,98,101,108,115,32,37,115,10,0,0,0,0,0,0,92,115,101,116,102,111,110,116,123,37,115,125,123,37,53,46,50,102,125,10,101,116,101,120,10,0,0,0,0,0,0,0,103,114,97,121,50,48,0,0,9,115,101,112,97,114,97,116,105,111,110,32,98,101,116,119,101,101,110,32,98,111,120,112,108,111,116,115,32,105,115,32,37,103,10,0,0,0,0,0,10,37,102,111,110,116,32,99,104,97,110,103,101,115,10,118,101,114,98,97,116,105,109,116,101,120,10,92,100,101,102,92,115,101,116,102,111,110,116,35,49,35,50,123,37,46,10,32,32,92,102,111,110,116,92,103,112,102,111,110,116,61,35,49,32,97,116,32,35,50,112,116,10,92,103,112,102,111,110,116,125,10,0,0,0,0,0,0,103,114,97,121,49,48,0,0,9,111,117,116,108,105,101,114,115,32,119,105,108,108,32,110,111,116,32,98,101,32,100,114,97,119,110,10,0,0,0,0,108,97,121,36,111,117,116,0,10,100,101,102,97,117,108,116,102,111,110,116,58,61,32,34,37,115,34,59,10,100,101,102,97,117,108,116,115,99,97,108,101,32,58,61,32,37,54,46,51,102,47,102,111,110,116,115,105,122,101,32,100,101,102,97,117,108,116,102,111,110,116,59,10,0,0,0,0,0,0,0,103,114,97,121,48,0,0,0,120,49,121,50,0,0,0,0,32,32,77,101,100,105,97,110,58,32,32,32,37,115,32,37,115,32,37,115,10,0,0,0,99,100,0,0,0,0,0,0,9,111,117,116,108,105,101,114,115,32,119,105,108,108,32,98,101,32,100,114,97,119,110,32,117,115,105,110,103,32,112,111,105,110,116,32,116,121,112,101,32,37,100,10,0,0,0,0,46,48,0,0,0,0,0,0,118,97,114,100,101,102,32,109,97,107,101,112,105,99,40,101,120,112,114,32,115,116,114,41,32,61,10,32,32,105,102,32,112,105,99,116,117,114,101,32,115,116,114,32,58,32,115,116,114,32,115,99,97,108,101,100,32,116,101,120,116,109,97,103,10,32,32,37,32,111,116,104,101,114,119,105,115,101,32,97,32,115,116,114,105,110,103,10,32,32,101,108,115,101,58,32,115,116,114,32,105,110,102,111,110,116,32,100,101,102,97,117,108,116,102,111,110,116,32,115,99,97,108,101,100,32,40,100,101,102,97,117,108,116,115,99,97,108,101,42,116,101,120,116,109,97,103,41,10,32,32,102,105,10,101,110,100,100,101,102,59,10,10,100,101,102,32,105,110,102,111,110,116,115,105,122,101,40,101,120,112,114,32,115,116,114,44,32,115,105,122,101,41,32,61,10,32,32,105,110,102,111,110,116,32,115,116,114,32,115,99,97,108,101,100,32,40,115,105,122,101,32,47,32,102,111,110,116,115,105,122,101,32,115,116,114,41,10,101,110,100,100,101,102,59,10,0,0,115,108,97,116,101,103,114,97,121,0,0,0,0,0,0,0,116,36,105,99,115,0,0,0,67,97,110,39,116,32,114,101,97,100,32,100,97,116,97,32,102,105,108,101,0,0,0,0,32,32,98,111,120,32,98,121,32,37,53,46,50,102,32,111,102,32,116,104,101,32,105,110,116,101,114,113,117,97,114,116,105,108,101,32,100,105,115,116,97,110,99,101,10,0,0,0,121,101,114,114,111,114,98,97,114,115,10,0,0,0,0,0,10,116,101,120,116,109,97,103,58,61,37,54,46,51,102,59,10,0,0,0,0,0,0,0,100,97,114,107,45,103,114,97,121,0,0,0,0,0,0,0,75,80,95,72,111,109,101,0,98,103,110,100,0,0,0,0,110,111,110,45,115,116,114,105,110,103,32,97,114,103,117,109,101,110,116,32,116,111,32,115,121,115,116,101,109,40,41,0,32,32,109,101,100,105,97,110,32,116,111,32,105,110,99,108,117,100,101,32,37,53,46,50,102,32,111,102,32,116,104,101,32,112,111,105,110,116,115,10,0,0,0,0,0,0,0,0,10,119,97,114,110,105,110,103,99,104,101,99,107,58,61,48,59,10,100,101,102,97,117,108,116,109,112,116,58,61,109,112,116,58,61,52,59,10,116,104,58,61,46,54,59,10,37,37,32,72,97,118,101,32,110,105,99,101,32,115,104,97,114,112,32,106,111,105,110,115,32,111,110,32,111,117,114,32,108,105,110,101,115,10,108,105,110,101,99,97,112,58,61,98,117,116,116,59,10,108,105,110,101,106,111,105,110,58,61,109,105,116,101,114,101,100,59,10,10,100,101,102,32,115,99,97,108,101,112,101,110,32,101,120,112,114,32,110,32,61,32,112,105,99,107,117,112,32,112,101,110,99,105,114,99,108,101,32,115,99,97,108,101,100,32,40,110,42,116,104,41,32,101,110,100,100,101,102,59,10,100,101,102,32,112,116,115,105,122,101,32,101,120,112,114,32,110,32,61,32,109,112,116,58,61,110,42,100,101,102,97,117,108,116,109,112,116,32,101,110,100,100,101,102,59,10,10,0,0,0,0,0,108,105,103,104,116,45,103,114,101,121,0,0,0,0,0,0,9,98,111,120,112,108,111,116,32,114,97,110,103,101,32,101,120,116,101,110,100,115,32,102,114,111,109,32,116,104,101,32,0,0,0,0,0,0,0,0,85,112,112,101,114,32,98,111,117,110,100,32,111,102,32,99,111,110,115,116,114,97,105,110,116,32,60,32,108,111,119,101,114,32,98,111,117,110,100,58,32,32,84,117,114,110,105,110,103,32,111,102,32,99,111,110,115,116,114,97,105,110,116,115,46,0,0,0,0,0,0,0,92,98,101,103,105,110,123,100,111,99,117,109,101,110,116,125,10,101,116,101,120,10,37,32,69,78,68,80,82,69,10,0,108,105,103,104,116,45,103,114,97,121,0,0,0,0,0,0,98,111,120,32,97,110,100,32,119,104,105,115,107,101,114,0,92,117,115,101,112,97,99,107,97,103,101,91,105,110,116,108,105,109,105,116,115,93,123,97,109,115,109,97,116,104,125,10,92,117,115,101,112,97,99,107,97,103,101,123,97,109,115,102,111,110,116,115,125,10,0,0,103,114,101,101,110,121,101,108,108,111,119,0,0,0,0,0,102,105,110,97,110,99,101,32,98,97,114,0,0,0,0,0,124,115,105,110,40,55,50,48,120,41,124,0,0,0,0,0,92,117,115,101,112,97,99,107,97,103,101,91,108,97,116,105,110,49,93,123,105,110,112,117,116,101,110,99,125,10,92,117,115,101,112,97,99,107,97,103,101,91,84,49,93,123,102,111,110,116,101,110,99,125,10,92,117,115,101,112,97,99,107,97,103,101,123,116,101,120,116,99,111,109,112,125,10,92,117,115,101,112,97,99,107,97,103,101,123,109,97,116,104,112,116,109,120,125,10,92,117,115,101,112,97,99,107,97,103,101,91,115,99,97,108,101,100,61,46,57,50,93,123,104,101,108,118,101,116,125,10,92,117,115,101,112,97,99,107,97,103,101,123,99,111,117,114,105,101,114,125,10,92,117,115,101,112,97,99,107,97,103,101,123,108,97,116,101,120,115,121,109,125,10,0,0,99,104,97,114,116,114,101,117,115,101,0,0,0,0,0,0,9,98,111,120,112,108,111,116,32,114,101,112,114,101,115,101,110,116,97,116,105,111,110,32,105,115,32,37,115,10,0,0,109,117,108,116,105,112,108,111,116,32,109,111,100,101,32,105,115,32,37,115,10,0,0,0,92,117,115,101,112,97,99,107,97,103,101,91,108,97,116,105,110,49,93,123,105,110,112,117,116,101,110,99,125,10,92,117,115,101,112,97,99,107,97,103,101,91,84,49,93,123,102,111,110,116,101,110,99,125,10,92,117,115,101,112,97,99,107,97,103,101,123,116,105,109,101,115,44,109,97,116,104,112,116,109,120,125,10,92,117,115,101,112,97,99,107,97,103,101,123,104,101,108,118,101,116,125,10,92,117,115,101,112,97,99,107,97,103,101,123,99,111,117,114,105,101,114,125,10,0,0,0,0,97,110,116,105,113,117,101,119,104,105,116,101,0,0,0,0,37,103,58,0,0,0,0,0,44,32,102,105,108,108,115,116,121,108,101,0,0,0,0,0,92,100,111,99,117,109,101,110,116,99,108,97,115,115,123,97,114,116,105,99,108,101,125,10,0,0,0,0,0,0,0,0,115,101,97,103,114,101,101,110,0,0,0,0,0,0,0,0,44,32,108,119,32,37,46,49,102,32,0,0,0,0,0,0,92,100,111,99,117,109,101,110,116,99,108,97,115,115,91,97,52,112,97,112,101,114,93,123,97,114,116,105,99,108,101,125,10,0,0,0,0,0,0,0,115,108,97,116,101,103,114,101,121,0,0,0,0,0,0,0,108,116,32,37,100,0,0,0,110,111,101,110,104,36,97,110,99,101,100,0,0,0,0,0,10,37,37,32,65,100,100,32,92,100,111,99,117,109,101,110,116,99,108,97,115,115,32,97,110,100,32,92,98,101,103,105,110,123,100,99,111,117,109,101,110,116,125,32,102,111,114,32,108,97,116,101,120,10,37,37,32,78,66,32,121,111,117,32,115,104,111,117,108,100,32,115,101,116,32,116,104,101,32,101,110,118,105,114,111,110,109,101,110,116,32,118,97,114,105,97,98,108,101,32,84,69,88,32,116,111,32,116,104,101,32,110,97,109,101,32,111,102,32,121,111,117,114,10,37,37,32,108,97,116,101,120,32,101,120,101,99,117,116,97,98,108,101,32,40,110,111,114,109,97,108,108,121,32,108,97,116,101,120,41,32,105,110,111,114,100,101,114,32,102,111,114,32,109,101,116,97,112,111,115,116,32,116,111,32,119,111,114,107,10,37,37,32,111,114,32,114,117,110,10,37,37,32,109,112,111,115,116,32,45,45,116,101,120,61,108,97,116,101,120,32,46,46,46,10,10,37,32,66,69,71,80,82,69,10,118,101,114,98,97,116,105,109,116,101,120,10,0,104,111,110,101,121,100,101,119,0,0,0,0,0,0,0,0,120,50,121,50,0,0,0,0,32,32,81,117,97,114,116,105,108,101,58,32,37,115,32,37,115,32,37,115,10,0,0,0,98,97,99,107,103,114,111,117,110,100,0,0,0,0,0,0,37,46,49,53,103,0,0,0,117,105,110,116,0,0,0,0,112,114,111,108,111,103,117,101,115,58,61,37,100,59,10,0,99,111,109,109,97,110,100,32,115,116,114,105,110,103,0,0,98,105,115,113,117,101,0,0,98,101,104,105,110,100,0,0,120,121,101,114,114,111,114,108,105,110,101,115,10,0,0,0,78,101,101,100,32,50,32,111,114,32,51,32,99,111,108,117,109,110,115,32,102,111,114,32,112,111,108,97,114,32,100,97,116,97,0,0,0,0,0,0,102,105,108,108,36,115,116,121,108,101,0,0,0,0,0,0,69,120,112,101,99,116,101,100,32,99,111,109,109,97,110,100,32,115,116,114,105,110,103,0,97,118,115,0,0,0,0,0,37,37,71,78,85,80,76,79,84,32,77,101,116,97,112,111,115,116,32,111,117,116,112,117,116,58,32,37,115,10,0,0,108,101,109,111,110,99,104,105,102,102,111,110,0,0,0,0,75,80,95,82,105,103,104,116,0,0,0,0,0,0,0,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,58,32,105,110,118,97,108,105,100,32,97,114,103,117,109,101,110,116,32,116,121,112,101,0,0,0,9,82,101,99,116,97,110,103,108,101,32,115,116,121,108,101,32,105,115,32,37,115,44,32,102,105,108,108,32,99,111,108,111,114,32,0,0,0,0,0,101,110,100,46,10,0,0,0,107,104,97,107,105,49,0,0,9,67,105,114,99,108,101,32,115,116,121,108,101,32,104,97,115,32,100,101,102,97,117,108,116,32,114,97,100,105,117,115,32,0,0,0,0,0,0,0,110,111,32,117,112,112,101,114,32,98,111,117,110,100,32,99,111,110,115,116,114,97,105,110,116,32,97,108,108,111,119,101,100,32,105,102,32,110,111,116,32,97,117,116,111,115,99,97,108,105,110,103,0,0,0,0,99,111,110,116,111,117,114,32,98,95,115,112,108,105,110,101,0,0,0,0,0,0,0,0,37,32,69,78,68,80,79,83,84,10,0,0,0,0,0,0,112,105,110,107,0,0,0,0,115,101,116,32,116,101,114,109,105,110,97,108,32,117,110,107,110,111,119,110,10,0,0,0,44,32,98,111,116,104,32,100,105,97,109,101,116,101,114,115,32,97,114,101,32,105,110,32,116,104,101,32,115,97,109,101,32,117,110,105,116,115,32,97,115,32,116,104,101,32,121,32,97,120,105,115,10,0,0,0,60,110,111,62,0,0,0,0,101,116,101,120,10,0,0,0,108,105,103,104,116,45,115,97,108,109,111,110,0,0,0,0,44,32,98,111,116,104,32,100,105,97,109,101,116,101,114,115,32,97,114,101,32,105,110,32,116,104,101,32,115,97,109,101,32,117,110,105,116,115,32,97,115,32,116,104,101,32,120,32,97,120,105,115,10,0,0,0,55,50,48,32,109,117,108,32,115,105,110,32,97,98,115,0,32,92,101,110,100,123,100,111,99,117,109,101,110,116,125,10,0,0,0,0,0,0,0,0,115,97,110,100,121,98,114,111,119,110,0,0,0,0,0,0,117,0,0,0,0,0,0,0,44,32,100,105,97,109,101,116,101,114,115,32,97,114,101,32,105,110,32,100,105,102,102,101,114,101,110,116,32,117,110,105,116,115,32,40,109,97,106,111,114,58,32,120,32,97,120,105,115,44,32,109,105,110,111,114,58,32,121,32,97,120,105,115,41,10,0,0,0,0,0,0,45,45,104,101,108,112,0,0,118,101,114,98,97,116,105,109,116,101,120,10,0,0,0,0,116,97,110,49,0,0,0,0,42,58,0,0,0,0,0,0,44,32,100,101,102,97,117,108,116,32,97,110,103,108,101,32,105,115,32,37,46,49,102,32,100,101,103,114,101,101,115,0,97,99,116,105,111,110,32,116,97,98,108,101,0,0,0,0,37,32,66,69,71,80,79,83,84,10,0,0,0,0,0,0,115,105,101,110,110,97,49,0,9,69,108,108,105,112,115,101,32,115,116,121,108,101,32,104,97,115,32,100,101,102,97,117,108,116,32,115,105,122,101,32,0,0,0,0,0,0,0,0,101,110,100,102,105,103,59,10,0,0,0,0,0,0,0,0,121,101,108,108,111,119,52,0,70,117,110,99,116,105,111,110,115,0,0,0,0,0,0,0,106,116,101,114,110,0,0,0,101,120,112,101,99,116,105,110,103,32,39,114,97,100,105,97,110,115,39,32,111,114,32,39,100,101,103,114,101,101,115,39,0,0,0,0,0,0,0,0,101,110,104,36,97,110,99,101])
.concat([100,0,0,0,0,0,0,0,115,99,97,108,101,112,101,110,32,49,59,32,112,116,115,105,122,101,32,37,46,51,102,59,108,105,110,101,116,121,112,101,32,45,50,59,10,0,0,0,115,108,97,116,101,98,108,117,101,49,0,0,0,0,0,0,120,49,121,49,0,0,0,0,68,97,116,97,0,0,0,0,32,32,77,97,120,105,109,117,109,58,32,32,37,115,32,91,37,42,108,100,93,32,32,32,37,115,32,91,37,42,108,100,93,10,0,0,0,0,0,0,37,115,58,37,100,32,112,114,111,116,111,99,111,108,32,101,114,114,111,114,10,0,0,0,100,36,101,103,114,101,101,115,0,0,0,0,0,0,0,0,109,117,108,116,105,112,108,111,116,62,32,0,0,0,0,0,37,48,51,111,0,0,0,0,100,0,0,0,0,0,0,0,97,58,61,119,47,37,46,49,102,59,98,58,61,104,47,37,46,49,102,59,10,0,0,0,109,101,100,105,117,109,112,117,114,112,108,101,51,0,0,0,9,37,115,32,105,115,32,117,110,100,101,102,105,110,101,100,10,0,0,0,0,0,0,0,115,116,121,108,101,32,108,105,110,101,0,0,0,0,0,0,114,36,97,100,105,97,110,115,0,0,0,0,0,0,0,0,120,101,114,114,111,114,108,105,110,101,115,10,0,0,0,0,78,101,101,100,32,49,32,111,114,32,51,32,99,111,108,117,109,110,115,32,102,111,114,32,99,97,114,116,101,115,105,97,110,32,100,97,116,97,0,0,67,97,110,39,116,32,99,104,97,110,103,101,32,116,111,32,116,104,105,115,32,100,105,114,101,99,116,111,114,121,0,0,126,0,0,0,0,0,0,0,83,105,110,103,117,108,97,114,32,109,97,116,114,105,120,32,105,110,32,71,105,118,101,110,115,40,41,0,0,0,0,0,67,97,110,39,116,32,99,97,108,99,117,108,97,116,101,32,97,112,112,114,111,120,105,109,97,116,105,111,110,32,115,112,108,105,110,101,115,44,32,97,108,108,32,119,101,105,103,104,116,115,32,104,97,118,101,32,116,111,32,98,101,32,62,32,48,0,0,0,0,0,0,0,10,98,101,103,105,110,102,105,103,40,37,100,41,59,10,119,58,61,37,46,51,102,105,110,59,104,58,61,37,46,51,102,105,110,59,10,0,0,0,0,99,98,116,105,99,115,0,0,111,114,99,104,105,100,52,0,75,80,95,66,101,103,105,110,0,0,0,0,0,0,0,0,9,37,115,10,0,0,0,0,114,103,98,36,99,111,108,111,114,0,0,0,0,0,0,0,73,110,116,101,114,110,97,108,32,101,114,114,111,114,58,32,115,116,114,105,110,103,32,110,111,116,32,97,108,108,111,99,97,116,101,100,0,0,0,0,100,117,112,108,105,99,97,116,101,32,111,114,32,99,111,110,116,114,97,100,105,99,116,111,114,121,32,97,114,103,117,109,101,110,116,115,0,0,0,0,45,45,40,37,46,49,102,97,44,37,46,49,102,98,41,0,115,105,101,110,110,97,52,0,10,9,85,115,101,114,45,68,101,102,105,110,101,100,32,70,117,110,99,116,105,111,110,115,58,10,0,0,0,0,0,0,102,117,110,99,116,105,111,110,32,37,115,32,114,101,113,117,105,114,101,115,32,37,100,32,118,97,114,105,97,98,108,101,37,99,0,0,0,0,0,0,119,114,111,110,103,32,97,114,103,117,109,101,110,116,32,105,110,32,115,101,116,32,97,114,114,111,119,0,0,0,0,0,109,97,108,102,111,114,109,101,100,32,114,97,110,103,101,32,119,105,116,104,32,99,111,110,115,116,114,97,105,110,116,32,40,117,115,101,32,39,60,39,32,111,110,108,121,41,0,0,100,114,97,119,32,40,37,46,49,102,97,44,37,46,49,102,98,41,0,0,0,0,0,0,98,114,111,119,110,52,0,0,100,101,102,97,117,108,116,32,108,97,121,101,114,0,0,0,101,110,100,32,99,111,111,114,100,105,110,97,116,101,115,32,101,120,112,101,99,116,101,100,0,0,0,0,0,0,0,0,108,105,110,101,116,121,112,101,32,37,100,59,10,0,0,0,111,114,97,110,103,101,114,101,100,52,0,0,0,0,0,0,9,71,114,105,100,32,100,114,97,119,110,32,97,116,32,37,115,10,0,0,0,0,0,0,115,116,97,114,116,32,99,111,111,114,100,105,110,97,116,101,115,32,101,120,112,101,99,116,101,100,0,0,0,0,0,0,124,99,111,115,40,51,54,48,120,41,124,0,0,0,0,0,112,117,116,95,116,101,120,116,40,32,98,116,101,120,32,37,115,32,101,116,101,120,44,32,37,46,49,102,97,44,32,37,46,49,102,98,44,32,37,100,44,32,37,100,41,59,10,0,100,97,114,107,45,111,108,105,118,101,103,114,101,101,110,0,100,101,103,114,101,101,115,0,97,114,114,111,119,0,0,0,112,117,116,95,116,101,120,116,40,32,98,116,101,120,32,92,115,101,116,102,111,110,116,123,37,115,125,123,37,53,46,50,102,125,32,37,115,32,101,116,101,120,44,32,37,46,49,102,97,44,32,37,46,49,102,98,44,32,37,100,44,32,37,100,41,59,10,0,0,0,0,0,100,97,114,107,45,112,108,117,109,0,0,0,0,0,0,0,114,97,100,105,97,110,115,0,32,32,32,32,32,32,32,32,32,83,107,105,112,112,101,100,32,37,100,32,112,111,105,110,116,115,32,111,117,116,115,105,100,101,32,114,97,110,103,101,32,91,37,115,61,0,0,0,116,97,103,32,109,117,115,116,32,98,101,32,62,32,48,0,112,117,116,95,116,101,120,116,40,34,37,115,34,44,32,37,46,49,102,97,44,32,37,46,49,102,98,44,32,37,100,44,32,37,100,41,59,10,0,0,112,108,117,109,0,0,0,0,9,71,114,105,100,32,114,97,100,105,105,32,100,114,97,119,110,32,101,118,101,114,121,32,37,102,32,37,115,10,0,0,112,117,116,95,116,101,120,116,40,34,37,115,34,32,105,110,102,111,110,116,115,105,122,101,40,34,37,115,34,44,37,53,46,50,102,41,44,32,37,46,49,102,97,44,32,37,46,49,102,98,44,32,37,100,44,32,37,100,41,59,10,0,0,0,100,97,114,107,45,118,105,111,108,101,116,0,0,0,0,0,10,9,77,105,110,111,114,32,103,114,105,100,32,100,114,97,119,110,32,119,105,116,104,0,106,117,109,112,110,122,0,0,104,101,97,100,36,115,0,0,102,111,110,116,0,0,0,0,103,112,100,114,97,119,40,37,100,44,37,46,49,102,97,44,37,46,49,102,98,41,59,10,0,0,0,0,0,0,0,0,118,105,111,108,101,116,0,0,9,77,97,106,111,114,32,103,114,105,100,32,100,114,97,119,110,32,119,105,116,104,0,0,32,32,77,105,110,105,109,117,109,58,32,32,37,115,32,91,37,42,108,100,93,32,32,32,37,115,32,91,37,42,108,100,93,10,0,0,0,0,0,0,97,115,0,0,0,0,0,0,99,111,110,118,95,116,101,120,116,32,98,117,102,102,101,114,0,0,0,0,0,0,0,0,105,0,0,0,0,0,0,0,100,114,97,119,32,40,37,46,49,102,97,44,37,46,49,102,98,41,45,45,40,37,46,49,102,97,44,37,46,49,102,98,41,59,10,0,0,0,0,0,111,114,97,110,103,101,0,0,32,116,105,99,115,10,0,0,108,105,110,101,116,121,112,101,0,0,0,0,0,0,0,0,121,101,114,114,111,114,108,105,110,101,115,10,0,0,0,0,101,120,112,101,99,116,105,110,103,32,100,105,114,101,99,116,111,114,121,32,110,97,109,101,0,0,0,0,0,0,0,0,33,0,0,0,0,0,0,0,100,114,97,119,100,98,108,97,114,114,111,119,0,0,0,0,111,108,105,118,101,0,0,0,75,80,95,76,101,102,116,0,32,109,37,115,0,0,0,0,66,111,116,104,32,112,97,114,97,109,101,116,101,114,115,32,116,111,32,115,116,114,112,116,105,109,101,32,109,117,115,116,32,98,101,32,115,116,114,105,110,103,115,0,0,0,0,0,100,114,97,119,97,114,114,111,119,0,0,0,0,0,0,0,98,101,105,103,101,0,0,0,32,37,115,0,0,0,0,0,98,97,99,107,36,104,101,97,100,0,0,0,0,0,0,0,122,50,0,0,0,0,0,0,37,115,32,40,37,46,49,102,97,44,37,46,49,102,98,41,45,45,40,37,46,49,102,97,44,37,46,49,102,98,41,59,10,0,0,0,0,0,0,0,100,97,114,107,45,103,111,108,100,101,110,114,111,100,0,0,82,101,99,116,97,110,103,117,108,97,114,0,0,0,0,0,121,95,109,105,110,32,115,104,111,117,108,100,32,110,111,116,32,101,113,117,97,108,32,121,95,109,97,120,33,0,0,0,73,110,118,97,108,105,100,32,114,97,110,103,101,0,0,0,112,116,115,105,122,101,32,37,46,51,102,59,10,0,0,0,100,97,114,107,45,107,104,97,107,105,0,0,0,0,0,0,80,111,108,97,114,0,0,0,37,115,102,105,120,109,97,36,120,0,0,0,0,0,0,0,51,54,48,32,109,117,108,32,99,111,115,32,97,98,115,0,102,105,108,108,32,40,37,46,49,102,97,44,37,46,49,102,98,41,45,45,40,37,46,49,102,97,44,37,46,49,102,98,41,45,45,40,37,46,49,102,97,44,37,46,49,102,98,41,45,45,40,37,46,49,102,97,44,37,46,49,102,98,41,45,45,99,121,99,108,101,32,119,105,116,104,112,101,110,32,40,112,101,110,99,105,114,99,108,101,32,115,99,97,108,101,100,32,48,112,116,41,32,119,105,116,104,99,111,108,111,114,32,102,105,108,108,99,111,108,111,114,59,10,0,0,0,0,0,107,104,97,107,105,0,0,0,9,37,115,32,103,114,105,100,32,100,114,97,119,110,32,97,116,0,0,0,0,0,0,0,37,115,102,105,120,109,105,36,110,0,0,0,0,0,0,0,9,32,32,72,105,100,100,101,110,51,100,32,101,108,101,109,101,110,116,115,32,119,105,108,108,32,98,101,32,100,114,97,119,110,32,105,110,32,37,115,32,111,102,32,110,111,110,45,104,105,100,100,101,110,51,100,32,101,108,101,109,101,110,116,115,10,0,0,0,0,0,0,102,105,108,108,32,40,37,46,49,102,97,44,37,46,49,102,98,41,45,45,40,37,46,49,102,97,44,37,46,49,102,98,41,45,45,40,37,46,49,102,97,44,37,46,49,102,98,41,45,45,40,37,46,49,102,97,44,37,46,49,102,98,41,45,45,99,121,99,108,101,32,119,105,116,104,99,111,108,111,114,32,98,97,99,107,103,114,111,117,110,100,59,10,0,0,0,100,97,114,107,45,115,97,108,109,111,110,0,0,0,0,0,9,103,114,105,100,32,105,115,32,79,70,70,10,0,0,0,32,32,32,32,32,32,32,32,32,82,101,97,100,32,37,100,32,112,111,105,110,116,115,10,0,0,0,0,0,0,0,0,37,115,102,105,120,0,0,0,115,99,97,108,101,112,101,110,32,37,46,51,102,59,10,0,115,97,108,109,111,110,0,0,114,97,120,105,115,32,105,115,32,37,115,100,114,97,119,110,10,0,0,0,0,0,0,0,37,115,109,97,36,120,0,0,80,114,101,115,115,32,114,101,116,117,114,110,32,102,111,114,32,109,111,114,101,58,32,0,99,117,114,114,101,110,116,99,111,108,111,114,58,61,37,46,52,103,42,114,101,100,43,37,46,52,103,42,103,114,101,101,110,43,37,46,52,103,42,98,108,117,101,59,10,0,0,0,111,114,97,110,103,101,45,114,101,100,0,0,0,0,0,0,9,37,115,122,101,114,111,97,120,105,115,32,105,115,32,79,70,70,10,0,0,0,0,0,106,117,109,112,122,0,0,0,37,115,109,105,36,110,0,0,116,105,36,116,108,101,0,0,99,117,114,114,101,110,116,99,111,108,111,114,58,61,99,111,108,37,100,59,10,0,0,0,108,105,103,104,116,45,99,111,114,97,108,0,0,0,0,0,125,0,0,0,0,0,0,0,9,37,115,122,101,114,111,97,120,105,115,32,105,115,32,100,114,97,119,110,32,119,105,116,104,0,0,0,0,0,0,0,32,32,83,117,109,32,83,113,46,58,32,32,37,115,32,37,115,32,37,115,10,0,0,0,107,101,36,101,112,102,105,120,0,0,0,0,0,0,0,0,117,110,107,110,111,119,110,32,116,121,112,101,32,105,110,32,100,105,115,112,95,118,97,108,117,101,40,41,0,0,0,0,115,105,110,116,0,0,0,0,99,117,114,114,101,110,116,99,111,108,111,114,58,61,98,108,97,99,107,59,10,0,0,0,108,97,98,101,108,32,110,111,116,32,102,111,117,110,100,0,69,120,116,114,97,110,101,111,117,115,32,97,114,103,117,109,101,110,116,115,32,116,111,32,115,101,116,32,37,115,0,0,102,105,120,0,0,0,0,0,100,111,116,115,10,0,0,0,120,112,45,62,110,101,120,116,95,115,112,32,61,61,32,121,112,0,0,0,0,0,0,0,99,117,114,114,101,110,116,99,111,108,111,114,58,61,37,46,51,103,119,104,105,116,101,59,10,0,0,0,0,0,0,0,100,97,114,107,45,112,105,110,107,0,0,0,0,0,0,0,75,80,95,80,97,103,101,68,111,119,110,0,0,0,0,0,32,112,111,105,110,116,32,119,105,116,104,32,99,111,108,111,114,32,111,102,0,0,0,0,98,117,102,102,101,114,91,108,101,110,103,116,104,45,49,93,32,61,61,32,39,32,39,0,102,117,108,108,36,119,105,100,116,104,0,0,0,0,0,0,59,10,0,0,0,0,0,0,100,97,114,107,45,116,117,114,113,117,111,105,115,101,0,0,32,110,111,112,111,105,110,116,0,0,0,0,0,0,0,0,108,36,97,114,103,101,0,0,100,101,102,97,117,108,116,0,37,115,32,61,32,0,0,0,109,97,108,102,111,114,109,101,100,32,114,97,110,103,101,32,119,105,116,104,32,99,111,110,115,116,97,114,105,110,116,0,99,121,99,108,101,32,119,105,116,104,99,111,108,111,114,32,102,105,108,108,99,111,108,111,114,59,10,0,0,0,0,0,32,102,111,110,116,32,34,37,115,34,0,0,0,0,0,0,120,95,109,105,110,32,115,104,111,117,108,100,32,110,111,116,32,101,113,117,97,108,32,120,95,109,97,120,33,0,0,0,45,45,0,0,0,0,0,0,32,37,115,32,0,0,0,0,101,120,112,101,99,116,105,110,103,32,39,97,98,115,111,108,117,116,101,39,32,111,114,32,39,114,101,108,97,116,105,118,101,39,32,0,0,0,0,0,77,79,85,83,69,95,0,0,124,115,105,110,40,51,54,48,120,41,124,0,0,0,0,0,10,45,45,0,0,0,0,0,116,105,109,101,108,97,98,101,108,46,116,101,120,116,0,0,115,107,121,98,108,117,101,0,32,110,111,116,32,114,111,116,97,116,101,100,0,0,0,0,114,36,101,108,97,116,105,118,101,0,0,0,0,0,0,0,40,37,46,49,102,97,44,37,46,49,102,98,41,37,115,0,109,101,100,105,117,109,45,98,108,117,101,0,0,0,0,0,32,114,111,116,97,116,101,100,32,98,121,32,37,100,32,100,101,103,114,101,101,115,32,40,105,102,32,112,111,115,115,105,98,108,101,41,0,0,0,0,97,36,98,115,111,108,117,116,101,0,0,0,0,0,0,0,98,97,100,32,100,97,116,97,32,111,110,32,108,105,110,101,32,37,100,32,111,102,32,100,97,116,97,102,105,108,101,0,115,101,116,32,37,115,122,101,114,111,97,120,105,115,0,0,102,105,108,108,32,0,0,0,110,97,118,121,0,0,0,0,32,99,101,110,116,114,101,0,112,114,105,110,116,95,116,97,98,108,101,58,32,111,117,116,112,117,116,32,98,117,102,102,101,114,0,0,0,0,0,0,73,110,116,101,114,110,97,108,32,101,114,114,111,114,32,105,110,32,115,99,105,101,110,116,105,102,105,99,32,110,117,109,98,101,114,32,102,111,114,109,97,116,116,105,110,103,0,0,102,105,108,108,99,111,108,111,114,58,61,99,117,114,114,101,110,116,99,111,108,111,114,59,10,0,0,0,0,0,0,0,109,105,100,110,105,103,104,116,45,98,108,117,101,0,0,0,9,108,97,98,101,108,32,37,100,32,34,37,115,34,32,97,116,32,0,0,0,0,0,0,122,95,109,105,110,51,100,32,115,104,111,117,108,100,32,110,111,116,32,101,113,117,97,108,32,122,95,109,97,120,51,100,33,0,0,0,0,0,0,0,106,117,109,112,0,0,0,0,32,40,0,0,0,0,0,0,102,105,108,108,99,111,108,111,114,58,61,99,117,114,114,101,110,116,99,111,108,111,114,42,37,46,50,102,43,98,97,99,107,103,114,111,117,110,100,42,37,46,50,102,59,10,0,0,100,97,114,107,45,98,108,117,101,0,0,0,0,0,0,0,123,0,0,0,0,0,0,0,32,32,83,117,109,58,32,32,32,32,32,32,37,115,32,37,115,32,37,115,10,0,0,0,34,37,115,34,0,0,0,0,102,105,108,108,99,111,108,111,114,58,61,98,97,99,107,103,114,111,117,110,100,59,10,0,44,32,98,97,99,107,97,110,103,108,101,32,37,103,32,100,101,103,0,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,39,108,105,110,101,97,114,39,44,32,39,99,117,98,105,99,115,112,108,105,110,101,39,44,32,39,98,115,112,108,105,110,101,39,44,32,39,112,111,105,110,116,115,39,44,32,39,108,101,118,101,108,115,39,32,111,114,32,39,111,114,100,101,114,39,0,0,0,0,0,115,101,116,32,37,115,116,105,99,115,32,37,115,32,0,0,108,105,110,101,115,112,111,105,110,116,115,10,0,0,0,0,71,80,86,65,76,95,76,65,83,84,95,80,76,79,84,0,47,0,0,0,0,0,0,0,100,101,102,97,117,108,116,102,111,110,116,0,0,0,0,0,115,101,97,45,103,114,101,101,110,0,0,0,0,0,0,0,75,80,95,68,111,119,110,0,10,9,32,32,97,114,114,111,119,32,104,101,97,100,58,32,108,101,110,103,116,104,32,37,115,37,103,44,32,97,110,103,108,101,32,37,103,32,100,101,103,0,0,0,0,0,0,0,98,115,112,108,105,110,101,32,111,114,100,101,114,32,109,117,115,116,32,98,101,32,105,110,32,91,50,46,46,49,48,93,32,114,97,110,103,101,46,0,32,110,111,114,97,110,103,101,108,105,109,105,116,0,0,0,101,120,116,101,114,110,97,108,36,105,109,97,103,101,115,0,102,111,114,101,115,116,45,103,114,101,101,110,0,0,0,0,40,115,101,99,111,110,100,32,120,32,97,120,105,115,41,32,0,0,0,0,0,0,0,0,111,36,114,100,101,114,0,0,32,114,97,110,103,101,108,105,109,105,116,0,0,0,0,0,117,110,102,105,110,105,115,104,101,100,32,114,97,110,103,101,32,119,105,116,104,32,99,111,110,115,116,114,97,105,110,116,0,0,0,0,0,0,0,0,105,110,108,105,110,101,36,105,109,97,103,101,115,0,0,0,115,112,114,105,110,103,45,103,114,101,101,110,0,0,0,0,40,102,105,114,115,116,32,120,32,97,120,105,115,41,32,0,76,101,118,101,108,115,32,116,121,112,101,32,105,115,32,100,105,115,99,114,101,116,101,44,32,105,103,110,111,114,105,110,103,32,110,101,119,32,110,117,109,98,101,114,32,111,102,32,99,111,110,116,111,117,114,32,108,101,118,101,108,115,0,0,84,101,114,109,105,110,97,108,32,99,97,110,118,97,115,32,97,114,101,97,32,116,111,111,32,115,109,97,108,108,32,116,111,32,104,111,108,100,32,112,108,111,116,46,10,9,32,32,32,32,67,104,101,99,107,32,112,108,111,116,32,98,111,117,110,100,97,114,121,32,97,110,100,32,102,111,110,116,32,115,105,122,101,115,46,0,0,0,112,111,105,110,116,115,119,105,116,104,116,101,120,0,0,0,100,97,114,107,45,103,114,101,101,110,0,0,0,0,0,0,32,116,111,32,0,0,0,0,97,117,36,116,111,0,0,0,10,115,101,116,32,37,115,100,116,105,99,115,0,0,0,0,51,54,48,32,109,117,108,32,115,105,110,32,97,98,115,0,112,111,105,110,116,115,119,105,116,104,109,101,116,97,112,111,115,116,0,0,0,0,0,0,32,114,116,111,32,0,0,0,101,120,112,101,99,116,105,110,103,32,99,111,109,109,97,32,116,111,32,115,101,112,97,114,97,116,101,32,105,110,99,114,44,115,116,111,112,32,108,101,118,101,108,115,0,0,0,0,10,115,101,116,32,37,115,109,116,105,99,115,0,0,0,0,112,111,105,110,116,115,119,105,116,104,109,112,0,0,0,0,103,111,108,100,0,0,0,0,10,9,32,32,102,114,111,109,32,0,0,0,0,0,0,0,105,110,99,114,101,109,101,110,116,32,99,97,110,110,111,116,32,98,101,32,48,0,0,0,97,117,116,111,102,114,101,113,32,0,0,0,0,0,0,0,77,97,120,46,32,110,117,109,98,101,114,32,111,102,32,100,97,116,97,32,112,111,105,110,116,115,32,115,99,97,108,101,100,32,117,112,32,116,111,58,32,37,100,10,0,0,0,0,69,68,70,32,104,101,97,100,101,114,0,0,0,0,0,0,116,101,120,36,112,111,105,110,116,115,0,0,0,0,0,0,108,105,103,104,116,45,116,117,114,113,117,111,105,115,101,0,110,111,102,105,108,108,101,100,0,0,0,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,99,111,109,109,97,32,116,111,32,115,101,112,97,114,97,116,101,32,115,116,97,114,116,44,105,110,99,114,32,108,101,118,101,108,115,0,0,0,10,115,101,116,32,37,115,116,105,99,115,32,0,0,0,0,108,111,103,49,48,95,98,97,115,101,32,61,61,32,49,46,48,0,0,0,0,0,0,0,109,112,36,112,111,105,110,116,115,0,0,0,0,0,0,0,108,105,103,104,116,45,112,105,110,107,0,0,0,0,0,0,101,109,112,116,121,0,0,0,105,110,36,99,114,101,109,101,110,116,97,108,0,0,0,0,97,115,115,105,103,110,0,0,32,97,117,116,111,106,117,115,116,105,102,121,0,0,0,0,112,111,112,32,48,0,0,0,116,101,120,116,115,99,97,108,101,0,0,0,0,0,0,0,108,105,103,104,116,45,103,111,108,100,101,110,114,111,100,0,119,104,105,108,101,0,0,0,102,105,108,108,101,100,0,0,101,120,112,101,99,116,105,110,103,32,99,111,109,109,97,32,116,111,32,115,101,112,97,114,97,116,101,32,100,105,115,99,114,101,116,101,32,108,101,118,101,108,115,0,0,0,0,0,32,32,83,116,100,32,68,101,118,58,32,32,37,115,32,37,115,32,37,115,10,0,0,0,98,121,32,37,100,32,0,0,117,115,104,111,114,116,0,0,102,111,110,116,115,99,97,108,101,0,0,0,0,0,0,0,108,105,103,104,116,45,99,121,97,110,0,0,0,0,0,0,9,97,114,114,111,119,32,37,100,44,32,37,115,32,37,115,32,37,115,0,0,0,0,0,108,105,110,101,115,116,121,108,101,0,0,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,100,105,115,99,114,101,116,101,32,108,101,118,101,108,0,0,0,0,0,0,0,0,105,109,112,117,108,115,101,115,10,0,0,0,0,0,0,0,67,97,110,110,111,116,32,99,111,110,116,111,117,114,32,110,111,110,32,103,114,105,100,32,100,97,116,97,46,32,80,108,101,97,115,101,32,117,115,101,32,34,115,101,116,32,100,103,114,105,100,51,100,34,46,0,98,105,110,100,95,99,111,109,109,97,110,100,45,62,114,104,115,0,0,0,0,0,0,0,108,119,0,0,0,0,0,0,108,105,103,104,116,45,109,97,103,101,110,116,97,0,0,0,75,80,95,69,110,100,0,0,9,107,101,121,32,116,105,116,108,101,32,105,115,32,34,37,115,34,10,0,0,0,0,0,100,105,36,115,99,114,101,116,101,0,0,0,0,0,0,0,82,101,115,117,108,116,105,110,103,32,115,116,114,105,110,103,32,105,115,32,116,111,111,32,108,111,110,103,0,0,0,0,108,105,110,101,119,36,105,100,116,104,0,0,0,0,0,0,108,105,103,104,116,45,98,108,117,101,0,0,0,0,0,0,37,100,32,102,111,114,32,118,101,114,116,105,99,97,108,32,97,108,105,103,110,109,101,110,116,10,0,0,0,0,0,0,108,101,36,118,101,108,115,0,111,117,116,0,0,0,0,0,100,108,0,0,0,0,0,0,108,105,103,104,116,45,103,114,101,101,110,0,0,0,0,0,9,109,97,120,105,109,117,109,32,110,117,109,98,101,114,32,111,102,32,114,111,119,115,32,105,115,32,0,0,0,0,0,98,36,115,112,108,105,110,101,0,0,0,0,0,0,0,0,107,101,121,0,0,0,0,0,100,97,115,104,108,36,101,110,103,116,104,0,0,0,0,0,108,105,103,104,116,45,114,101,100,0,0,0,0,0,0,0,99,97,108,99,117,108,97,116,101,100,32,97,117,116,111,109,97,116,105,99,97,108,108,121,10,0,0,0,0,0,0,0,99,36,117,98,105,99,115,112,108,105,110,101,0,0,0,0,97,120,105,115,0,0,0,0,99,111,115,40,51,54,48,120,41,0,0,0,0,0,0,0,115,113,117,97,114,101,36,100,0,0,0,0,0,0,0,0,103,114,101,121,49,48,48,0,37,100,32,102,111,114,32,104,111,114,105,122,111,110,116,97,108,32,97,108,105,103,110,109,101,110,116,10,0,0,0,0,108,105,36,110,101,97,114,0,115,101,116,32,37,115,116,105,99,115,32,37,115,32,37,115,32,115,99,97,108,101,32,37,103,44,37,103,32,37,115,109,105,114,114,111,114,32,37,115,32,0,0,0,0,0,0,0,98,101,118,101,108,36,101,100,0,0,0,0,0,0,0,0,103,114,101,121,57,48,0,0,9,109,97,120,105,109,117,109,32,110,117,109,98,101,114,32,111,102,32,99,111,108,117,109,110,115,32,105,115,32,0,0,115,101,116,32,110,111,37,115,116,105,99,115,10,0,0,0,79,117,116,32,111,102,32,109,101,109,111,114,121,32,105,110,32,102,105,116,58,32,116,111,111,32,109,97,110,121,32,100,97,116,97,112,111,105,110,116,115,32,40,37,100,41,63,0,109,105,116,101,114,36,101,100,0,0,0,0,0,0,0,0,103,114,101,121,56,48,0,0,119,105,116,104,32,99,111,108,117,109,110,32,104,101,97,100,101,114,0,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,39,98,97,115,101,39,44,32,39,115,117,114,102,97,99,101,39,44,32,111,114,32,39,98,111,116,104,39,0,0,32,108,111,103,102,105,108,101,32,39,37,115,39,0,0,0,115,111,36,108,105,100,0,0,103,114,101,121,55,48,0,0,119,105,116,104,32,102,105,108,101,110,97,109,101,0,0,0,98,111,36,116,104,0,0,0,91,93,0,0,0,0,0,0,115,101,116,32,102,105,116,32,37,115,101,114,114,111,114,118,97,114,105,97,98,108,101,115,0,0,0,0,0,0,0,0,116,101,109,112,32,102,105,108,101,32,115,116,114,105,110,103,0,0,0,0,0,0,0,0,100,97,36,115,104,101,100,0,103,114,101,121,54,48,0,0,117,112,36,100,97,116,101,0,9,115,97,109,112,108,101,32,108,101,110,103,116,104,32,105,115,32,37,103,32,99,104,97,114,97,99,116,101,114,115,10,9,118,101,114,116,105,99,97,108,32,115,112,97,99,105,110,103,32,105,115,32,37,103,32,99,104,97,114,97,99,116,101,114,115,10,9,119,105,100,116,104,32,97,100,106,117,115,116,109,101,110,116,32,105,115,32,37,103,32,99,104,97,114,97,99,116,101,114,115,10,9,104,101,105,103,104,116,32,97,100,106,117,115,116,109,101,110,116,32,105,115,32,37,103,32,99,104,97,114,97,99,116,101,114,115,10,9,99,117,114,118,101,115,32,97,114,101,37,115,32,97,117,116,111,109,97,116,105,99,97,108,108,121,32,116,105,116,108,101,100,32,37,115,10,0,0,0,0,0,0,0,0,115,36,117,114,102,97,99,101,0,0,0,0,0,0,0,0,32,32,77,101,97,110,58,32,32,32,32,32,37,115,32,37,115,32,37,115,10,0,0,0,115,101,116,32,112,115,100,105,114,10,0,0,0,0,0,0,123,37,115,44,32,37,115,125,0,0,0,0,0,0,0,0,115,104,111,114,116,0,0,0,109,111,110,111,36,99,104,114,111,109,101,0,0,0,0,0,103,114,101,121,53,48,0,0,9,107,101,121,32,98,111,120,32,105,115,32,111,112,97,113,117,101,32,97,110,100,32,100,114,97,119,110,32,105,110,32,102,114,111,110,116,32,111,102,32,116,104,101,32,103,114,97,112,104,10,0,0,0,0,0,98,97,36,115,101,0,0,0,115,101,116,32,112,115,100,105,114,32,34,37,115,34,10,0,112,111,105,110,116,115,10,0,65,108,108,32,112,111,105,110,116,115,32,111,102,32,99,111,108,111,114,98,111,120,32,118,97,108,117,101,32,117,110,100,101,102,105,110,101,100,0,0,98,105,110,100,95,99,111,109,109,97,110,100,45,62,108,104,115,0,0,0,0,0,0,0,43,0,0,0,0,0,0,0,99,111,108,36,111,117,114,0,103,114,101,121,52,48,0,0,75,80,95,73,110,115,101,114,116,0,0,0,0,0,0,0,110,111,116,32,98,111,120,101,100,10,0,0,0,0,0,0,83,99,97,108,101,32,102,97,99,116,111,114,115,32,109,117,115,116,32,98,101,32,103,114,101,97,116,101,114,32,116,104,97,110,32,122,101,114,111,32,45,32,110,111,116,32,99,104,97,110,103,101,100,33,0,0,115,101,116,32,102,111,110,116,112,97,116,104,32,0,0,0,68,111,117,98,108,101,0,0,102,95,115,116,114,102,116,105,109,101,58,32,98,117,102,102,101,114,0,0,0,0,0,0,105,110,105,116,32,100,121,110,97,114,114,97,121,0,0,0,99,111,108,36,111,114,0,0,103,114,101,121,51,48,0,0,98,111,120,101,100,10,9,119,105,116,104,32,0,0,0,0,78,117,109,98,101,114,32,111,102,32,103,114,105,100,32,112,111,105,110,116,115,32,109,117,115,116,32,98,101,32,105,110,32,91,50,58,49,48,48,48,93,32,45,32,110,111,116,32,99,104,97,110,103,101,100,33,0,0,0,0,0,0,0,0,117,110,102,105,110,105,115,104,101,100,32,114,97,110,103,101,0,0,0,0,0,0,0,0,110,111,104,101,97,100,101,114,0,0,0,0,0,0,0,0,103,114,101,121,50,48,0,0,114,105,103,104,116,0,0,0,85,110,114,101,99,111,103,110,105,122,101,32,107,101,121,119,111,114,100,32,111,114,32,117,110,101,120,112,101,99,116,101,100,32,118,97,108,117,101,0,100,105,102,102,105,99,117,108,116,121,32,109,97,107,105,110,103,32,114,111,111,109,32,102,111,114,32,120,116,105,99,32,108,97,98,101,108,115,0,0,115,101,116,32,108,111,97,100,112,97,116,104,32,0,0,0,104,101,97,100,101,114,0,0,103,114,101,121,49,48,0,0,108,101,102,116,0,0,0,0,107,100,101,110,115,36,105,116,121,50,100,0,0,0,0,0,51,54,48,32,109,117,108,32,99,111,115,0,0,0,0,0,110,111,116,105,109,101,36,115,116,97,109,112,0,0,0,0,103,114,101,121,48,0,0,0,9,107,101,121,32,105,115,32,37,115,32,106,117,115,116,105,102,105,101,100,44,32,37,115,114,101,118,101,114,115,101,100,44,32,37,115,105,110,118,101,114,116,101,100,44,32,37,115,101,110,104,97,110,99,101,100,32,97,110,100,32,0,0,0,100,101,99,105,109,97,108,95,115,105,103,110,32,105,110,32,108,111,99,97,108,101,32,105,115,32,37,115,10,0,0,0,101,114,114,111,114,32,100,117,114,105,110,103,32,102,105,116,0,0,0,0,0,0,0,0,116,105,109,101,36,115,116,97,109,112,0,0,0,0,0,0,116,117,114,113,117,111,105,115,101,0,0,0,0,0,0,0,9,107,101,121,32,105,115,32,97,116,32,0,0,0,0,0,67,111,117,108,100,32,110,111,116,32,102,105,110,100,32,114,101,113,117,101,115,116,101,100,32,108,111,99,97,108,101,0,115,116,97,110,100,36,97,108,111,110,101,0,0,0,0,0,32,114,109,97,114,103,105,110,0,0,0,0,0,0,0,0,76,65,78,71,0,0,0,0,85,83,69,82,78,65,77,69,0,0,0,0,0,0,0,0,105,110,112,36,117,116,0,0,32,108,109,97,114,103,105,110,0,0,0,0,0,0,0,0,76,67,95,78,85,77,69,82,73,67,0,0,0,0,0,0,110,101,115,0,0,0,0,0,67,108,111,115,105,110,103,32,37,115,10,0,0,0,0,0,100,101,102,97,117,108,116,115,105,122,101,0,0,0,0,0,97,113,117,97,109,97,114,105,110,101,0,0,0,0,0,0,117,110,115,36,101,116,0,0,32,98,109,97,114,103,105,110,0,0,0,0,0,0,0,0,76,67,95,65,76,76,0,0,42,32,67,79,76,85,77,78,83,58,10,0,0,0,0,0,102,114,97,99,116,105,111,110,0,0,0,0,0,0,0,0,117,99,104,97,114,0,0,0,115,105,122,101,0,0,0,0,111,114,99,104,105,100,0,0,32,116,109,97,114,103,105,110,0,0,0,0,0,0,0,0,99,97,110,100,108,101,115,0,108,105,110,101,115,10,0,0,65,108,108,32,112,111,105,110,116,115,32,122,32,118,97,108,117,101,32,117,110,100,101,102,105,110,101,100,0,0,0,0,119,104,105,115,107,101,114,36,98,97,114,115,0,0,0,0,99,111,109,109,97,110,100,46,99,0,0,0,0,0,0,0,100,36,101,102,97,117,108,116,0,0,0,0,0,0,0,0,100,97,114,107,45,99,104,97,114,116,114,101,117,115,101,0,75,80,95,70,52,0,0,0,32,111,117,116,115,105,100,101,0,0,0,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,115,101,99,111,110,100,32,100,117,109,109,121,32,118,97,114,105,97,98,108,101,32,110,97,109,101,0,0,0,0,120,121,61,37,103,44,37,103,0,0,0,0,0,0,0,0,70,108,111,97,116,0,0,0,102,105,110,97,110,99,101,98,97,114,115,0,0,0,0,0,115,105,122,101,58,32,111,117,116,32,111,102,32,114,97,110,103,101,0,0,0,0,0,0,100,97,114,107,45,114,101,100,0,0,0,0,0,0,0,0,32,105,110,115,105,100,101,0,101,120,112,101,99,116,105,110,103,32,100,117,109,109,121,32,118,97,114,105,97,98,108,101,32,110,97,109,101,0,0,0,115,101,116,32,115,116,121,108,101,32,98,111,120,112,108,111,116,32,37,115,32,37,115,32,37,53,46,50,102,32,37,115,111,117,116,108,105,101,114,115,32,112,116,32,37,100,32,115,101,112,97,114,97,116,105,111,110,32,37,103,32,108,97,98,101,108,115,32,37,115,32,37,115,115,111,114,116,101,100,10,0,0,0,0,0,0,0,0,105,110,36,99,104,101,115,0,115,116,101,101,108,98,108,117,101,0,0,0,0,0,0,0,32,104,111,114,105,122,111,110,116,97,108,0,0,0,0,0,105,99,111,110,118,32,102,97,105,108,101,100,32,116,111,32,99,111,110,118,101,114,116,32,100,101,103,114,101,101,32,115,105,103,110,0,0,0,0,0,120,116,105,99,0,0,0,0,10,117,110,115,101,116,32,99,111,108,111,114,98,111,120,10,0,0,0,0,0,0,0,0,115,105,122,101,32,114,101,113,117,105,114,101,115,32,116,119,111,32,110,117,109,98,101,114,115,58,32,32,120,115,105,122,101,44,32,121,115,105,122,101,0,0,0,0,0,0,0,0,112,117,114,112,108,101,0,0,32,118,101,114,116,105,99,97,108,0,0,0,0,0,0,0,105,99,111,110,118,95,111,112,101,110,32,102,97,105,108,101,100,32,102,111,114,32,37,115,0,0,0,0,0,0,0,0,98,111,114,100,101,114,32,37,100,0,0,0,0,0,0,0,115,105,110,40,51,54,48,120,41,0,0,0,0,0,0,0,101,120,112,97,110,100,32,108,111,97,100,112,97,116,104,0,102,111,110,116,32,34,37,115,44,37,103,34,0,0,0,0,100,97,114,107,45,115,112,114,105,110,103,45,103,114,101,101,110,0,0,0,0,0,0,0,32,99,101,110,116,101,114,0,98,100,101,102,97,117,108,116,0,0,0,0,0,0,0,0,109,112,112,111,105,110,116,115,32,0,0,0,0,0,0,0,103,111,108,100,101,110,114,111,100,0,0,0,0,0,0,0,41,0,0,0,0,0,0,0,32,114,105,103,104,116,0,0,117,110,114,101,99,111,103,110,105,122,101,100,32,101,110,99,111,100,105,110,103,32,115,112,101,99,105,102,105,99,97,116,105,111,110,59,32,115,101,101,32,39,104,101,108,112,32,101,110,99,111,100,105,110,103,39,46,0,0,0,0,0,0,0,110,111,98,111,114,100,101,114,0,0,0,0,0,0,0,0,101,114,114,36,111,114,115,116,97,116,101,0,0,0,0,0,73,108,108,101,103,97,108,32,100,97,121,32,111,102,32,121,101,97,114,0,0,0,0,0,116,101,120,112,111,105,110,116,115,32,0,0,0,0,0,0,114,111,121,97,108,98,108,117,101,0,0,0,0,0,0,0,32,108,101,102,116,0,0,0,57,51,50,0,0,0,0,0,47,117,115,114,47,108,111,99,97,108,47,115,104,97,114,101,47,103,104,111,115,116,115,99,114,105,112,116,47,102,111,110,116,115,0,0,0,0,0,0,85,83,69,82,0,0,0,0,115,111,108,105,100,0,0,0,100,97,114,107,45,121,101,108,108,111,119,0,0,0,0,0,83,74,73,83,0,0,0,0,101,113,115,0,0,0,0,0,104,111,114,105,122,111,110,116,0,0,0,0,0,0,0,0,78,111,32,116,101,114,109,105,110,97,108,32,100,101,102,105,110,101,100,0,0,0,0,0,100,97,115,104,101,100,0,0,100,97,114,107,45,111,114,97,110,103,101,0,0,0,0,0,117,110,100,36,101,102,105,110,101,0,0,0,0,0,0,0,9,107,101,121,32,105,115,32,79,78,44,32,112,111,115,105,116,105,111,110,58,32,0,0,118,101,114,116,105,99,0,0,99,0,0,0,0,0,0,0,32,37,115,32,100,97,115,104,108,101,110,103,116,104,32,37,103,32,108,105,110,101,119,105,100,116,104,32,37,103,32,102,111,110,116,115,99,97,108,101,32,37,103,32,92,10,32,32,32,0,0,0,0,0,0,0,100,97,114,107,45,99,121,97,110,0,0,0,0,0,0,0,9,107,101,121,32,105,115,32,79,70,70,10,0,0,0,0,85,84,70,0,0,0,0,0,115,101,116,32,99,111,108,111,114,98,111,120,32,37,115,97,108,32,111,114,105,103,105,110,32,0,0,0,0,0,0,0,32,114,103,98,32,34,35,37,54,46,54,120,34,32,0,0,65,108,108,32,112,111,105,110,116,115,32,121,32,118,97,108,117,101,32,117,110,100,101,102,105,110,101,100,0,0,0,0,84,104,105,115,32,112,108,111,116,32,115,116,121,108,101,32,105,115,32,111,110,108,121,32,102,111,114,32,100,97,116,97,102,105,108,101,115,44,32,114,101,118,101,114,116,105,110,103,32,116,111,32,34,112,111,105,110,116,115,34,0,0,0,0,40,98,105,110,100,95,99,111,109,109,97,110,100,41,32,37,115,58,37,100,10,0,0,0,60,61,0,0,0,0,0,0,114,111,117,110,100,0,0,0,100,97,114,107,45,109,97,103,101,110,116,97,0,0,0,0,75,80,95,70,51,0,0,0,32,111,110,108,121,10,0,0,117,116,102,0,0,0,0,0,37,115,61,37,103,0,0,0,68,111,117,98,108,101,86,97,108,117,101,0,0,0,0,0,102,95,115,116,114,102,116,105,109,101,58,32,102,109,116,0,117,115,101,114,0,0,0,0,98,101,118,101,108,101,100,32,0,0,0,0,0,0,0,0,119,101,98,45,98,108,117,101,0,0,0,0,0,0,0,0,9,110,111,32,108,111,103,115,99,97,108,105,110,103,10,0,108,111,99,97,108,101,0,0,115,101,116,32,99,111,108,111,114,98,111,120,32,37,115,10,0,0,0,0,0,0,0,0,114,111,117,110,100,101,100,32,0,0,0,0,0,0,0,0,119,101,98,45,103,114,101,101,110,0,0,0,0,0,0,0,32,97,110,100,0,0,0,0,117,110,107,110,111,119,110,32,45,45,45,32,101,120,112,101,99,116,101,100,32,39,108,111,103,102,105,108,101,39,32,111,114,32,91,110,111,93,101,114,114,111,114,118,97,114,105,97,98,108,101,115,0,0,0,0,65,108,108,32,112,111,105,110,116,115,32,111,102,32,99,111,108,111,114,32,97,120,105,115,32,117,110,100,101,102,105,110,101,100,46,0,0,0,0,0,105,115,111,95,56,56,53,57,95,57,0,0,0,0,0,0,10,35,32,120,32,121,0,0,109,105,116,101,114,101,100,32,0,0,0,0,0,0,0,0,9,108,111,103,115,99,97,108,105,110,103,0,0,0,0,0,110,111,113,117,105,101,116,0,99,117,98,101,104,101,108,105,120,32,115,116,97,114,116,32,37,46,50,103,32,99,121,99,108,101,115,32,37,46,50,103,32,115,97,116,117,114,97,116,105,111,110,32,37,46,50,103,10,0,0,0,0,0,0,0,51,54,48,32,109,117,108,32,115,105,110,0,0,0,0,0,109,111,110,111,99,104,114,111,109,101,32,0,0,0,0,0,100,97,114,107,45,103,114,101,121,0,0,0,0,0,0,0,37,115,32,37,115,32,40,98,97,115,101,32,37,103,41,0,113,117,105,101,116,0,0,0,102,117,110,99,116,105,111,110,115,32,37,115,44,32,37,115,44,32,37,115,10,0,0,0,112,117,115,104,100,49,0,0,99,111,108,111,114,32,0,0,110,101,120,116,102,114,111,109,95,100,121,110,97,114,114,97,121,58,32,100,121,110,97,114,114,97,121,32,119,97,110,39,116,32,105,110,105,116,105,97,108,105,122,101,100,33,0,0,9,111,102,102,115,101,116,115,32,97,114,101,0,0,0,0,110,111,101,114,114,36,111,114,118,97,114,105,97,98,108,101,115,0,0,0,0,0,0,0,32,41,10,0,0,0,0,0,122,58,115,10,0,0,0,0,34,32,92,10,32,32,32,0,9,116,109,97,114,103,105,110,32,105,115,32,99,111,109,112,117,116,101,100,32,97,117,116,111,109,97,116,105,99,97,108,108,121,10,0,0,0,0,0,101,114,114,36,111,114,118,97,114,105,97,98,108,101,115,0,92,10,32,32,32,32,0,0,47,117,115,114,47,115,104,97,114,101,47,103,104,111,115,116,115,99,114,105,112,116,47,102,111,110,116,115,0,0,0,0,37,51,111,37,110,0,0,0,34,0,0,0,0,0,0,0,99,111,114,110,101,114,115,50,99,36,111,108,111,114,0,0,9,116,109,97,114,103,105,110,32,105,115,32,115,101,116,32,116,111,32,37,103,10,0,0,101,120,112,101,99,116,105,110,103,32,115,116,114,105,110,103,0,0,0,0,0,0,0,0,99,111,110,99,97,116,101,110,97,116,101,0,0,0,0,0,99,97,110,110,111,116,32,111,112,101,110,32,102,105,108,101,59,32,111,117,116,112,117,116,32,110,111,116,32,99,104,97,110,103,101,100,0,0,0,0,37,115,0,0,0,0,0,0,92,10,32,32,32,104,101,97,100,101,114,32,0,0,0,0,101,36,120,112,108,105,99,105,116,0,0,0,0,0,0,0,116,101,115,116,0,0,0,0,9,116,109,97,114,103,105,110,32,105,115,32,115,101,116,32,116,111,32,115,99,114,101,101,110,32,37,103,10,0,0,0,108,111,103,36,102,105,108,101,0,0,0,0,0,0,0,0,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,0,0,0,0,0,0,0,99,97,36,108,108,0,0,0,32,37,46,52,103,32,37,46,52,103,32,37,46,52,103,32,37,46,52,103,0,0,0,0,72,69,76,80,70,73,76,69,32,32,32,32,32,32,32,32,32,32,32,61,32,34,37,115,34,10,0,0,0,0,0,0,115,99,104,97,114,0,0,0,110,111,104,101,97,100,101,114,32,92,10,32,32,32,0,0,110,111,105,36,109,112,108,105,99,105,116,0,0,0,0,0,9,114,109,97,114,103,105,110,32,105,115,32,99,111,109,112,117,116,101,100,32,97,117,116,111,109,97,116,105,99,97,108,108,121,10,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,102,111,114,109,97,116,32,115,116,114,105,110,103,0,100,101,102,105,110,101,100,32,40,0,0,0,0,0,0,0])
.concat([79,117,116,32,111,102,32,109,101,109,111,114,121,32,105,110,32,115,116,97,116,115,58,32,116,111,111,32,109,97,110,121,32,100,97,116,97,112,111,105,110,116,115,32,40,37,100,41,63,0,0,0,0,0,0,0,32,114,103,98,32,34,37,115,34,32,0,0,0,0,0,0,65,108,108,32,112,111,105,110,116,115,32,120,32,118,97,108,117,101,32,117,110,100,101,102,105,110,101,100,0,0,0,0,34,119,105,116,104,34,32,97,108,108,111,119,101,100,32,111,110,108,121,32,97,102,116,101,114,32,112,97,114,97,109,101,116,114,105,99,32,102,117,110,99,116,105,111,110,32,102,117,108,108,121,32,115,112,101,99,105,102,105,101,100,0,0,0,97,108,108,36,119,105,110,100,111,119,115,0,0,0,0,0,62,61,0,0,0,0,0,0,110,111,116,105,109,101,115,116,97,109,112,0,0,0,0,0,110,111,101,36,120,112,108,105,99,105,116,0,0,0,0,0,75,80,95,70,50,0,0,0,9,114,109,97,114,103,105,110,32,105,115,32,115,101,116,32,116,111,32,37,103,10,0,0,99,108,111,115,101,100,0,0,70,108,111,97,116,86,97,108,117,101,0,0,0,0,0,0,70,105,114,115,116,32,112,97,114,97,109,101,116,101,114,32,116,111,32,115,116,114,102,116,105,109,101,32,109,117,115,116,32,98,101,32,97,32,102,111,114,109,97,116,32,115,116,114,105,110,103,0,0,0,0,0,114,103,98,102,111,114,109,117,108,97,101,32,37,100,44,32,37,100,44,32,37,100,10,0,114,97,36,105,115,101,0,0,100,111,109,97,105,110,0,0,116,105,109,101,115,116,97,109,112,0,0,0,0,0,0,0,105,36,109,112,108,105,99,105,116,0,0,0,0,0,0,0,9,114,109,97,114,103,105,110,32,105,115,32,115,101,116,32,116,111,32,115,99,114,101,101,110,32,37,103,10,0,0,0,78,97,78,0,0,0,0,0,10,115,101,116,32,112,97,108,101,116,116,101,32,0,0,0,119,104,105,99,104,61,61,65,85,84,79,83,67,65,76,69,95,77,73,78,32,124,124,32,119,104,105,99,104,61,61,65,85,84,79,83,67,65,76,69,95,77,65,88,0,0,0,0,105,110,112,117,116,0,0,0,116,114,36,97,110,115,112,97,114,101,110,116,0,0,0,0,9,98,109,97,114,103,105,110,32,105,115,32,99,111,109,112,117,116,101,100,32,97,117,116,111,109,97,116,105,99,97,108,108,121,10,0,0,0,0,0,108,97,121,101,114,100,36,101,102,97,117,108,116,0,0,0,87,97,114,110,105,110,103,32,45,32,100,105,102,102,105,99,117,108,116,121,32,102,105,116,116,105,110,103,32,112,108,111,116,32,116,105,116,108,101,115,32,105,110,116,111,32,107,101,121,0,0,0,0,0,0,0,115,97,118,101,46,99,0,0,115,116,97,110,100,97,108,111,110,101,0,0,0,0,0,0,110,111,115,111,36,108,105,100,0,0,0,0,0,0,0,0,9,98,109,97,114,103,105,110,32,105,115,32,115,101,116,32,116,111,32,37,103,10,0,0,110,111,112,111,36,108,97,114,0,0,0,0,0,0,0,0,37,115,58,37,100,32,111,111,111,112,115,58,32,85,110,107,110,111,119,110,32,99,111,108,111,114,32,109,111,100,101,108,32,39,37,99,39,46,10,0,124,99,111,115,40,49,56,48,120,41,124,0,0,0,0,0,115,105,122,101,32,37,103,37,115,44,37,103,37,115,32,37,115,32,37,115,32,37,115,0,110,111,116,114,36,97,110,115,112,97,114,101,110,116,0,0,9,98,109,97,114,103,105,110,32,105,115,32,115,101,116,32,116,111,32,115,99,114,101,101,110,32,37,103,10,0,0,0,112,111,36,108,97,114,0,0,88,89,90,32,0,0,0,0,107,101,121,119,111,114,100,32,39,100,97,116,97,39,32,100,101,112,114,101,99,97,116,101,100,44,32,117,115,101,32,39,115,104,111,119,32,115,116,121,108,101,32,100,97,116,97,39,0,0,0,0,0,0,0,0,101,120,116,114,97,110,101,111,117,115,32,97,114,103,117,109,101,110,116,32,105,110,32,115,101,116,32,116,101,114,109,105,110,97,108,32,37,115,0,0,9,108,109,97,114,103,105,110,32,105,115,32,99,111,109,112,117,116,101,100,32,97,117,116,111,109,97,116,105,99,97,108,108,121,10,0,0,0,0,0,110,111,114,36,116,105,99,115,0,0,0,0,0,0,0,0,89,73,81,32,0,0,0,0,122,10,0,0,0,0,0,0,71,110,117,112,108,111,116,32,119,97,115,32,98,117,105,108,116,32,119,105,116,104,111,117,116,32,115,117,112,112,111,114,116,32,102,111,114,32,80,78,71,32,105,109,97,103,101,115,46,32,89,111,117,32,99,97,110,110,111,116,32,117,115,101,32,116,104,105,115,32,111,112,116,105,111,110,32,117,110,108,101,115,115,32,121,111,117,32,114,101,98,117,105,108,100,32,103,110,117,112,108,111,116,46,0,0,0,0,0,0,0,0,110,111,104,105,36,100,100,101,110,51,100,0,0,0,0,0,9,108,109,97,114,103,105,110,32,105,115,32,115,101,116,32,116,111,32,37,103,10,0,0,110,111,109,99,98,36,116,105,99,115,0,0,0,0,0,0,67,77,89,32,0,0,0,0,47,117,115,114,47,108,105,98,47,88,49,49,47,102,111,110,116,115,33,0,0,0,0,0,37,52,111,37,110,0,0,0,97,114,114,111,119,32,110,111,116,32,102,111,117,110,100,0,83,116,114,105,110,103,32,99,111,110,116,97,105,110,105,110,103,32,104,101,97,100,101,114,32,105,110,102,111,114,109,97,116,105,111,110,32,101,120,112,101,99,116,101,100,0,0,0,104,105,36,100,100,101,110,51,100,0,0,0,0,0,0,0,9,108,109,97,114,103,105,110,32,105,115,32,115,101,116,32,116,111,32,115,99,114,101,101,110,32,37,103,10,0,0,0,110,111,99,98,36,116,105,99,115,0,0,0,0,0,0,0,72,83,86,32,0,0,0,0,100,111,108,108,97,114,115,0,119,98,0,0,0,0,0,0,101,110,108,0,0,0,0,0,10,92,115,116,97,114,116,116,101,120,116,10,10,0,0,0,109,97,112,0,0,0,0,0,115,121,36,115,116,101,109,0,9,111,117,116,112,117,116,32,105,115,32,115,101,110,116,32,116,111,32,83,84,68,79,85,84,10,0,0,0,0,0,0,110,111,109,121,50,36,116,105,99,115,0,0,0,0,0,0,115,117,109,120,121,0,0,0,82,71,66,32,0,0,0,0,99,104,97,114,0,0,0,0,101,120,116,101,114,110,97,108,0,0,0,0,0,0,0,0,105,110,118,97,108,105,100,32,99,104,97,114,97,99,116,101,114,32,37,99,0,0,0,0,99,108,105,112,52,36,105,110,0,0,0,0,0,0,0,0,9,111,117,116,112,117,116,32,105,115,32,115,101,110,116,32,116,111,32,39,37,115,39,10,0,0,0,0,0,0,0,0,110,111,109,120,50,36,116,105,99,115,0,0,0,0,0,0,99,111,108,111,114,32,109,111,100,101,108,32,0,0,0,0,32,114,103,98,32,118,97,114,105,97,98,108,101,32,0,0,110,111,32,102,117,110,99,116,105,111,110,115,32,111,114,32,100,97,116,97,32,116,111,32,112,108,111,116,0,0,0,0,42,0,0,0,0,0,0,0,105,110,108,105,110,101,0,0,99,108,105,112,49,36,105,110,0,0,0,0,0,0,0,0,75,80,95,70,49,0,0,0,9,112,114,105,110,116,32,111,117,116,112,117,116,32,105,115,32,115,101,110,116,32,116,111,32,39,37,115,39,10,0,0,110,111,109,122,36,116,105,99,115,0,0,0,0,0,0,0,98,101,108,111,119,32,0,0,83,105,103,110,101,100,76,111,110,103,0,0,0,0,0,0,102,95,103,112,114,105,110,116,102,0,0,0,0,0,0,0,103,114,97,121,10,0,0,0,32,32,32,32,105,109,97,103,101,115,61,37,115,93,32,37,37,32,42,105,110,108,105,110,101,42,32,124,32,101,120,116,101,114,110,97,108,32,40,105,110,108,105,110,101,32,111,110,108,121,32,119,111,114,107,115,32,105,110,32,77,75,73,86,44,32,101,120,116,101,114,110,97,108,32,114,101,113,117,105,114,101,115,32,112,110,103,32,115,117,112,112,111,114,116,32,105,110,32,103,110,117,112,108,111,116,41,10,0,0,0,0,110,111,102,116,114,36,105,97,110,103,108,101,115,0,0,0,9,100,101,102,97,117,108,116,32,115,121,115,116,101,109,32,100,105,114,101,99,116,111,114,121,32,34,37,115,34,10,0,110,111,109,121,36,116,105,99,115,0,0,0,0,0,0,0,103,97,109,109,97,32,37,103,32,0,0,0,0,0,0,0,99,111,110,116,111,117,114,32,99,111,111,114,100,115,0,0,73,110,116,101,114,110,97,108,32,101,114,114,111,114,58,32,111,117,116,32,111,102,32,109,101,109,111,114,121,32,105,110,32,115,116,97,116,115,0,0,116,101,120,0,0,0,0,0,102,116,114,36,105,97,110,103,108,101,115,0,0,0,0,0,110,111,109,120,36,116,105,99,115,0,0,0,0,0,0,0,115,101,116,32,116,101,114,109,105,110,97,108,32,37,115,32,37,115,10,0,0,0,0,0,98,111,117,110,100,97,114,121,0,0,0,0,0,0,0,0,35,32,67,111,110,116,111,117,114,58,32,112,111,105,110,116,115,32,37,105,44,32,122,32,37,103,44,32,108,97,98,101,108,58,32,37,115,10,0,0,109,101,116,97,112,111,115,116,0,0,0,0,0,0,0,0,102,108,36,117,115,104,0,0,9,101,110,118,105,114,111,110,109,101,110,116,32,118,97,114,105,97,98,108,101,32,71,78,85,80,76,79,84,95,80,83,95,68,73,82,58,32,0,0,110,111,121,50,36,116,105,99,115,0,0,0,0,0,0,0,117,115,101,32,39,115,101,116,32,116,101,114,109,39,32,116,111,32,115,101,116,32,116,101,114,109,105,110,97,108,32,116,121,112,101,32,102,105,114,115,116,0,0,0,0,0,0,0,49,56,48,32,109,117,108,32,99,111,115,32,97,98,115,0,32,32,32,32,112,111,105,110,116,115,61,37,115,44,32,37,37,32,42,109,101,116,97,112,111,115,116,42,32,124,32,116,101,120,32,40,83,104,111,117,108,100,32,112,111,105,110,116,115,32,98,101,32,100,114,97,119,110,32,119,105,116,104,32,77,101,116,97,80,111,115,116,32,111,114,32,84,101,88,63,41,10,0,0,0,0,0,0,100,101,112,36,116,104,111,114,100,101,114,0,0,0,0,0,110,111,110,101,0,0,0,0,110,111,120,50,36,116,105,99,115,0,0,0,0,0,0,0,110,101,103,97,116,105,118,101,0,0,0,0,0,0,0,0,45,104,0,0,0,0,0,0,32,32,32,32,37,37,102,111,110,116,115,99,97,108,101,61,37,103,44,32,37,37,32,115,99,97,108,105,110,103,32,102,97,99,116,111,114,32,102,111,114,32,116,101,120,116,32,108,97,98,101,108,115,10,0,0,115,99,97,110,115,97,117,116,111,36,109,97,116,105,99,0,110,111,122,36,116,105,99,115,0,0,0,0,0,0,0,0,112,111,115,105,116,105,118,101,0,0,0,0,0,0,0,0,37,115,58,0,0,0,0,0,101,120,112,114,101,115,115,105,111,110,32,101,120,112,101,99,116,101,100,0,0,0,0,0,32,32,32,32,108,105,110,101,119,105,100,116,104,61,37,103,44,32,37,37,32,115,99,97,108,105,110,103,32,102,97,99,116,111,114,32,102,111,114,32,108,105,110,101,32,119,105,100,116,104,115,32,40,49,46,48,32,109,101,97,110,115,32,48,46,53,98,112,41,10,0,0,115,99,97,110,115,98,97,99,107,36,119,97,114,100,0,0,9,100,105,114,101,99,116,111,114,121,32,102,114,111,109,32,39,115,101,116,32,112,115,100,105,114,39,58,32,0,0,0,110,111,121,36,116,105,99,115,0,0,0,0,0,0,0,0,115,101,116,32,112,97,108,101,116,116,101,32,37,115,32,37,115,32,109,97,120,99,111,108,111,114,115,32,37,100,32,0,47,117,115,114,47,88,49,49,82,54,47,108,105,98,47,88,49,49,47,102,111,110,116,115,47,116,114,117,101,116,121,112,101,0,0,0,0,0,0,0,119,97,114,110,105,110,103,58,32,0,0,0,0,0,0,0,101,120,116,114,97,110,101,111,117,115,32,97,114,103,117,109,101,110,116,115,32,116,111,32,117,110,115,101,116,32,97,114,114,111,119,0,0,0,0,0,32,32,32,32,100,97,115,104,108,101,110,103,116,104,61,37,103,44,32,37,37,32,115,99,97,108,105,110,103,32,102,97,99,116,111,114,32,102,111,114,32,100,97,115,104,32,108,101,110,103,116,104,115,10,0,0,115,99,97,110,115,102,111,114,36,119,97,114,100,0,0,0,9,112,97,114,97,109,101,116,114,105,99,32,105,115,32,37,115,10,0,0,0,0,0,0,110,111,120,36,116,105,99,115,0,0,0,0,0,0,0,0,99,37,105,0,0,0,0,0,98,111,111,108,0,0,0,0,99,97,110,110,111,116,32,99,114,101,97,116,101,32,112,105,112,101,59,32,111,117,116,112,117,116,32,110,111,116,32,99,104,97,110,103,101,100,0,0,10,35,32,67,111,110,116,111,117,114,32,37,100,44,32,108,97,98,101,108,58,32,37,115,10,0,0,0,0,0,0,0,110,111,0,0,0,0,0,0,105,110,116,101,114,112,36,111,108,97,116,101,0,0,0,0,115,116,36,97,116,115,0,0,35,37,48,50,120,37,48,50,120,37,48,50,120,32,61,32,37,51,105,32,37,51,105,32,37,51,105,0,0,0,0,0,105,103,110,111,114,105,110,103,32,108,101,102,116,47,99,101,110,116,101,114,47,114,105,103,104,116,59,32,105,110,99,111,109,112,97,116,105,98,108,101,32,119,105,116,104,32,108,109,97,114,103,105,110,47,116,109,97,114,103,105,110,46,0,0,99,111,114,114,101,108,97,116,105,111,110,0,0,0,0,0,114,101,112,108,111,116,0,0,101,120,116,101,110,100,32,116,111,107,101,110,32,116,97,98,108,101,0,0,0,0,0,0,71,78,85,80,76,79,84,95,80,83,95,68,73,82,32,32,32,32,32,61,32,34,37,115,34,10,0,0,0,0,0,0,122,114,116,0,0,0,0,0,121,101,115,0,0,0,0,0,88,89,90,0,0,0,0,0,10,32,32,37,45,49,56,115,32,0,0,0,0,0,0,0,111,102,36,102,115,101,116,0,105,103,110,111,114,105,110,103,32,116,111,112,47,99,101,110,116,101,114,47,98,111,116,116,111,109,59,32,105,110,99,111,109,112,97,116,105,98,108,101,32,119,105,116,104,32,116,109,97,114,103,105,110,47,98,109,97,114,103,105,110,46,0,0,32,112,97,108,101,116,116,101,32,102,114,97,99,116,105,111,110,32,37,52,46,50,102,0,105,103,110,111,114,105,110,103,32,116,114,97,105,108,105,110,103,32,99,111,109,109,97,32,105,110,32,112,108,111,116,32,99,111,109,109,97,110,100,0,46,103,110,117,112,108,111,116,0,0,0,0,0,0,0,0,60,0,0,0,0,0,0,0,117,115,97,103,101,58,32,114,97,105,115,101,32,123,112,108,111,116,95,105,100,125,0,0,119,32,61,32,48,32,105,110,32,71,105,118,101,110,115,40,41,59,32,32,67,106,106,32,61,32,37,103,44,32,32,67,105,106,32,61,32,37,103,0,67,97,110,39,116,32,99,97,108,99,117,108,97,116,101,32,97,112,112,114,111,120,105,109,97,116,105,111,110,32,115,112,108,105,110,101,115,44,32,110,101,101,100,32,97,116,32,108,101,97,115,116,32,52,32,112,111,105,110,116,115,0,0,0,32,32,32,32,100,97,115,104,101,100,61,37,115,44,32,37,37,32,42,121,101,115,42,32,124,32,110,111,10,0,0,0,89,73,81,0,0,0,0,0,75,80,95,84,97,98,0,0,102,105,108,108,101,100,95,112,111,108,121,103,111,110,95,122,102,105,120,32,99,111,114,110,101,114,115,0,0,0,0,0,9,84,104,101,114,101,32,97,114,101,32,37,100,32,112,114,101,100,101,102,105,110,101,100,32,99,111,108,111,114,32,110,97,109,101,115,58,0,0,0,117,110,107,110,111,119,110,32,107,101,121,32,111,112,116,105,111,110,0,0,0,0,0,0,97,98,111,118,101,32,0,0,85,110,115,105,103,110,101,100,76,111,110,103,0,0,0,0,70,105,114,115,116,32,112,97,114,97,109,101,116,101,114,32,116,111,32,103,112,114,105,110,116,102,32,109,117,115,116,32,98,101,32,97,32,102,111,114,109,97,116,32,115,116,114,105,110,103,0,0,0,0,0,0,99,97,110,32,111,110,108,121,32,100,111,32,101,108,108,105,112,116,105,99,32,105,110,116,101,103,114,97,108,115,32,111,102,32,114,101,97,108,115,0,44,32,37,37,32,42,98,117,116,116,42,32,124,32,114,111,117,110,100,101,100,32,124,32,115,113,117,97,114,101,100,10,0,0,0,0,0,0,0,0,67,77,89,0,0,0,0,0,37,105,9,37,105,9,37,105,10,0,0,0,0,0,0,0,97,36,117,116,111,109,97,116,105,99,0,0,0,0,0,0,114,101,99,117,114,115,105,111,110,32,100,101,112,116,104,32,108,105,109,105,116,32,101,120,99,101,101,100,101,100,0,0,116,105,99,107,32,105,110,116,101,114,118,97,108,32,116,111,111,32,115,109,97,108,108,32,102,111,114,32,109,97,99,104,105,110,101,32,112,114,101,99,105,115,105,111,110,0,0,0,115,113,117,97,114,101,100,0,72,83,86,0,0,0,0,0,37,48,46,52,102,9,37,48,46,52,102,9,37,48,46,52,102,10,0,0,0,0,0,0,99,111,108,36,117,109,110,104,101,97,100,101,114,0,0,0,95,94,0,0,0,0,0,0,98,117,116,116,0,0,0,0,82,71,66,0,0,0,0,0,46,10,0,0,0,0,0,0,77,117,108,116,105,112,108,101,32,115,116,97,99,107,32,100,105,114,101,99,116,105,111,110,32,115,101,116,116,105,110,103,115,0,0,0,0,0,0,0,32,99,111,114,110,101,114,115,50,99,111,108,111,114,32,0,115,105,110,40,49,56,48,120,41,0,0,0,0,0,0,0,32,32,32,32,108,105,110,101,99,97,112,61,0,0,0,0,99,117,98,101,104,101,108,105,120,0,0,0,0,0,0,0,32,115,97,118,101,100,32,116,111,32,34,37,115,34,46,0,77,117,108,116,105,112,108,101,32,108,111,99,97,116,105,111,110,32,114,101,103,105,111,110,32,115,101,116,116,105,110,103,115,0,0,0,0,0,0,0,32,110,111,104,105,100,100,101,110,51,100,0,0,0,0,0,105,110,118,101,114,115,101,95,101,114,114,111,114,95,102,117,110,99,58,32,84,104,101,32,118,97,108,117,101,32,111,117,116,32,111,102,32,116,104,101,32,114,97,110,103,101,32,111,102,32,116,104,101,32,102,117,110,99,116,105,111,110,0,0,44,32,37,37,32,42,109,105,116,101,114,101,100,42,32,124,32,114,111,117,110,100,101,100,32,124,32,98,101,118,101,108,101,100,10,0,0,0,0,0,103,97,109,36,109,97,0,0,67,111,108,111,114,0,0,0,77,117,108,116,105,112,108,101,32,104,111,114,105,122,111,110,116,97,108,32,112,111,115,105,116,105,111,110,32,115,101,116,116,105,110,103,115,0,0,0,32,104,105,100,100,101,110,51,100,0,0,0,0,0,0,0,32,32,32,32,32,32,32,32,102,111,114,109,97,116,32,61,32,0,0,0,0,0,0,0,98,101,118,101,108,101,100,0,109,97,120,99,36,111,108,111,114,115,0,0,0,0,0,0,71,114,97,121,0,0,0,0,77,117,108,116,105,112,108,101,32,118,101,114,116,105,99,97,108,32,112,111,115,105,116,105,111,110,32,115,101,116,116,105,110,103,115,0,0,0,0,0,32,104,105,100,100,101,110,51,100,32,37,100,0,0,0,0,47,117,115,114,47,88,49,49,82,54,47,108,105,98,47,88,49,49,47,102,111,110,116,115,47,84,121,112,101,49,0,0,71,80,86,65,76,95,69,82,82,77,83,71,0,0,0,0,116,121,120,0,0,0,0,0,114,111,117,110,100,101,100,0,112,115,95,97,108,108,99,70,0,0,0,0,0,0,0,0,37,115,32,112,97,108,101,116,116,101,32,119,105,116,104,32,37,105,32,100,105,115,99,114,101,116,101,32,99,111,108,111,114,115,0,0,0,0,0,0,102,105,108,108,95,110,117,109,98,101,114,115,32,99,108,111,115,105,110,103,0,0,0,0,102,116,114,105,97,110,103,108,101,115,0,0,0,0,0,0,102,97,99,116,111,114,105,97,108,0,0,0,0,0,0,0,119,0,0,0,0,0,0,0,37,99,10,0,0,0,0,0,109,105,116,101,114,101,100,0,110,111,112,115,95,97,108,108,99,70,0,0,0,0,0,0,115,112,36,108,111,116,0,0,101,120,112,101,99,116,105,110,103,32,110,111,32,111,112,116,105,111,110,32,111,114,32,105,110,116,32,111,114,32,102,108,111,97,116,0,0,0,0,0,115,116,114,105,110,103,32,101,120,112,101,99,116,101,100,0,105,110,116,101,114,99,101,112,116,0,0,0,0,0,0,0,32,110,111,0,0,0,0,0,47,117,115,114,47,108,111,99,97,108,47,115,104,97,114,101,47,103,110,117,112,108,111,116,47,52,46,54,47,103,110,117,112,108,111,116,46,103,105,104,0,0,0,0,0,0,0,0,116,122,114,0,0,0,0,0,108,105,110,101,106,111,105,110,61,0,0,0,0,0,0,0,109,111,36,100,101,108,0,0,105,36,110,116,0,0,0,0,110,111,112,111,36,105,110,116,0,0,0,0,0,0,0,0,102,105,108,108,95,110,117,109,98,101,114,115,32,114,101,115,105,122,101,32,112,97,116,116,101,114,110,0,0,0,0,0,67,111,110,102,108,105,99,116,32,98,101,116,119,101,101,110,32,115,111,109,101,32,109,97,116,114,105,120,32,98,105,110,97,114,121,32,97,110,100,32,103,101,110,101,114,97,108,32,98,105,110,97,114,121,32,107,101,121,119,111,114,100,115,0,32,112,97,108,101,116,116,101,32,99,98,32,37,103,0,0,115,97,109,112,108,101,115,32,111,114,32,105,115,111,95,115,97,109,112,108,101,115,32,60,32,50,46,32,77,117,115,116,32,98,101,32,97,116,32,108,101,97,115,116,32,50,46,0,103,110,117,112,108,111,116,114,99,0,0,0,0,0,0,0,62,0,0,0,0,0,0,0,117,115,97,103,101,58,32,108,111,119,101,114,32,123,112,108,111,116,95,105,100,125,0,0,92,115,101,116,117,112,71,78,85,80,76,79,84,116,101,114,109,105,110,97,108,10,32,32,32,91,99,111,110,116,101,120,116,93,10,32,32,32,91,0,102,117,110,99,36,116,105,111,110,115,0,0,0,0,0,0,75,80,95,83,112,97,99,101,0,0,0,0,0,0,0,0,102,36,108,111,97,116,0,0,102,105,108,108,95,110,117,109,98,101,114,115,32,110,101,120,116,32,110,117,109,98,101,114,0,0,0,0,0,0,0,0,115,121,110,116,97,120,32,105,115,32,120,121,61,60,120,62,44,60,121,62,0,0,0,0,83,105,103,110,101,100,73,110,116,101,103,101,114,0,0,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,58,32,105,110,118,97,108,105,100,32,115,112,101,99,95,116,121,112,101,0,0,0,0,0,0,0,76,97,115,116,32,108,105,110,101,32,109,117,115,116,32,110,111,116,32,98,101,32,98,101,102,111,114,101,32,102,105,114,115,116,32,108,105,110,101,0,92,115,101,116,117,112,98,111,100,121,102,111,110,116,10,32,32,32,91,37,115,37,115,37,103,112,116,93,10,0,0,0,102,105,108,101,0,0,0,0,112,97,108,101,116,116,101,32,115,105,122,101,32,114,101,113,117,105,114,101,100,0,0,0,99,111,110,115,116,97,110,116,32,101,120,112,114,101,115,115,105,111,110,32,101,120,112,101,99,116,101,100,0,0,0,0,98,101,103,105,110,0,0,0,76,97,115,116,32,112,111,105,110,116,32,109,117,115,116,32,110,111,116,32,98,101,32,98,101,102,111,114,101,32,102,105,114,115,116,32,112,111,105,110,116,0,0,0,0,0,0,0,84,111,111,32,109,97,110,121,32,97,120,105,115,32,116,105,99,107,115,32,114,101,113,117,101,115,116,101,100,32,40,62,37,46,48,103,41,0,0,0,102,117,110,99,116,105,111,110,32,37,115,32,114,101,113,117,105,114,101,115,32,37,100,32,118,97,114,105,97,98,108,101,115,0,0,0,0,0,0,0,92,100,101,102,105,110,101,98,111,100,121,102,111,110,116,101,110,118,105,114,111,110,109,101,110,116,10,32,32,32,91,37,103,112,116,93,10,0,0,0,100,101,102,36,105,110,101,100,0,0,0,0,0,0,0,0,37,51,105,46,32,103,114,97,121,61,37,48,46,52,102,44,32,40,114,44,103,44,98,41,61,40,37,48,46,52,102,44,37,48,46,52,102,44,37,48,46,52,102,41,44,32,35,37,48,50,120,37,48,50,120,37,48,50,120,32,61,32,37,51,105,32,37,51,105,32,37,51,105,10,0,0,0,0,0,0,102,105,108,108,95,110,117,109,98,101,114,115,32,111,117,116,112,117,116,32,98,117,102,102,101,114,0,0,0,0,0,0,69,120,112,101,99,116,101,100,32,110,111,110,45,110,101,103,97,116,105,118,101,32,105,110,116,101,103,101,114,0,0,0,114,103,98,36,102,111,114,109,117,108,97,101,0,0,0,0,9,99,111,108,111,114,32,109,97,112,112,105,110,103,32,42,110,111,116,42,32,100,111,110,101,32,98,121,32,100,101,102,105,110,101,100,32,103,114,97,100,105,101,110,116,46,10,0,112,111,105,110,116,116,36,121,112,101,0,0,0,0,0,0,32,102,108,117,115,104,32,0,69,120,112,101,99,116,101,100,32,112,111,115,105,116,105,118,101,32,105,110,116,101,103,101,114,0,0,0,0,0,0,0,49,56,48,32,109,117,108,32,115,105,110,0,0,0,0,0,92,115,101,116,117,112,99,111,108,111,114,115,10,32,32,32,91,115,116,97,116,101,61,115,116,97,114,116,93,10,0,0,9,32,32,42,32,116,104,117,115,32,116,104,101,32,114,97,110,103,101,115,32,105,110,32,96,115,101,116,32,112,109,51,100,32,114,103,98,102,111,114,109,117,108,97,101,39,32,97,114,101,32,45,37,105,46,46,37,105,10,0,0,0,0,0,108,105,110,101,116,36,121,112,101,0,0,0,0,0,0,0,115,101,116,32,112,109,51,100,32,105,110,116,101,114,112,111,108,97,116,101,32,37,100,44,37,100,0,0,0,0,0,0,73,110,100,101,120,32,115,116,101,112,32,109,117,115,116,32,98,101,32,112,111,115,105,116,105,118,101,0,0,0,0,0,92,117,115,101,109,111,100,117,108,101,10,32,32,32,91,103,110,117,112,108,111,116,93,10,0,0,0,0,0,0,0,0,78,111,32,115,117,99,104,32,111,112,116,105,111,110,32,116,111,32,104,105,100,100,101,110,51,100,32,40,111,114,32,119,114,111,110,103,32,111,114,100,101,114,41,0,0,0,0,0,103,114,101,121,0,0,0,0,9,32,32,42,32,110,101,103,97,116,105,118,101,32,110,117,109,98,101,114,115,32,109,101,97,110,32,105,110,118,101,114,116,101,100,61,110,101,103,97,116,105,118,101,32,99,111,108,111,117,114,32,99,111,109,112,111,110,101,110,116,10,0,0,100,101,112,116,104,111,114,100,101,114,10,0,0,0,0,0,85,112,112,101,114,32,105,110,100,101,120,32,115,104,111,117,108,100,32,98,101,32,98,105,103,103,101,114,32,116,104,97,110,32,108,111,119,101,114,32,105,110,100,101,120,0,0,0,70,73,84,58,32,32,32,32,100,97,116,97,32,114,101,97,100,32,102,114,111,109,32,37,115,10,0,0,0,0,0,0,92,101,110,97,98,108,101,114,101,103,105,109,101,10,32,32,32,91,117,116,102,45,56,93,10,0,0,0,0,0,0,0,37,50,105,58,32,37,45,49,53,115,0,0,0,0,0,0,115,99,97,110,115,98,97,99,107,119,97,114,100,10,0,0,66,105,110,97,114,121,32,109,97,116,114,105,120,32,102,105,108,101,32,102,111,114,109,97,116,32,100,111,101,115,32,110,111,116,32,97,108,108,111,119,32,109,111,114,101,32,116,104,97,110,32,111,110,101,32,115,117,114,102,97,99,101,32,112,101,114,32,102,105,108,101,0,67,0,0,0,0,0,0,0,10,10,0,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,39,112,111,105,110,116,115,39,44,32,39,111,110,101,39,44,32,111,114,32,39,116,119,111,39,0,0,0,0,0,76,73,78,69,83,0,0,0,37,37,32,83,101,101,32,97,108,115,111,32,104,116,116,112,58,47,47,119,105,107,105,46,99,111,110,116,101,120,116,103,97,114,100,101,110,46,110,101,116,47,71,110,117,112,108,111,116,10,37,37,10,0,0,0,110,101,103,36,97,116,105,118,101,0,0,0,0,0,0,0,10,9,32,32,32,32,0,0,99,101,110,116,114,101,0,0,115,99,97,110,115,102,111,114,119,97,114,100,10,0,0,0,112,111,119,101,114,0,0,0,73,110,32,109,117,108,116,105,112,108,111,116,32,109,111,100,101,32,121,111,117,32,99,97,110,39,116,32,99,104,97,110,103,101,32,116,104,101,32,111,117,116,112,117,116,10,0,0,32,100,101,108,116,97,95,120,32,100,101,108,116,97,95,121,32,100,101,108,116,97,95,122,0,0,0,0,0,0,0,0,37,37,32,71,78,85,80,76,79,84,32,118,101,114,115,105,111,110,58,32,37,115,46,37,115,44,32,116,101,114,109,105,110,97,108,32,118,101,114,115,105,111,110,58,32,37,115,46,37,115,32,40,37,115,41,10,0,0,0,0,0,0,0,0,112,111,115,36,105,116,105,118,101,0,0,0,0,0,0,0,115,104,36,111,119,0,0,0,9,32,32,42,32,116,104,101,114,101,32,97,114,101,32,37,105,32,97,118,97,105,108,97,98,108,101,32,114,103,98,32,99,111,108,111,114,32,109,97,112,112,105,110,103,32,102,111,114,109,117,108,97,101,58,0,115,108,111,112,101,0,0,0,115,99,97,110,115,97,117,116,111,109,97,116,105,99,10,0,102,70,101,69,103,71,0,0,71,78,85,72,69,76,80,0,10,0,0,0,0,0,0,0,114,116,122,0,0,0,0,0,98,97,36,99,107,0,0,0,9,84,104,101,32,98,101,115,116,32,109,97,116,99,104,32,111,102,32,116,104,101,32,99,117,114,114,101,110,116,32,112,97,108,101,116,116,101,32,99,111,114,114,101,115,112,111,110,100,115,32,116,111,10,9,32,32,32,32,115,101,116,32,112,97,108,101,116,116,101,32,114,103,98,102,111,114,109,117,108,97,101,32,37,105,44,37,105,44,37,105,10,0,0,0,0,112,111,36,105,110,116,0,0,32,97,116,32,37,115,10,0,43,45,35,48,49,50,51,52,53,54,55,56,57,46,0,0,32,112,97,108,101,116,116,101,32,122,0,0,0,0,0,0,121,32,114,97,110,103,101,0,110,101,0,0,0,0,0,0,32,111,110,58,32,37,115,0,102,114,36,111,110,116,0,0,66,101,103,105,110,0,0,0,102,111,114,109,117,108,97,101,32,112,116,115,0,0,0,0,116,109,112,32,108,111,97,100,112,97,116,104,0,0,0,0,101,120,112,108,105,99,105,116,0,0,0,0,0,0,0,0,102,95,115,112,114,105,110,116,102,58,32,97,116,116,101,109,112,116,32,116,111,32,112,114,105,110,116,32,115,116,114,105,110,103,32,118,97,108,117,101,32,119,105,116,104,32,110,117,109,101,114,105,99,32,102,111,114,109,97,116,0,0,0,0,85,110,115,105,103,110,101,100,73,110,116,101,103,101,114,0,116,105,99,108,97,98,101,108,115,32,109,117,115,116,32,99,111,109,101,32,102,114,111,109,32,97,32,114,101,97,108,32,99,111,108,117,109,110,0,0,37,89,45,37,109,45,37,100,32,37,72,58,37,77,32,37,90,0,0,0,0,0,0,0,102,111,114,109,117,108,97,101,0,0,0,0,0,0,0,0,116,109,112,32,102,111,110,116,112,97,116,104,0,0,0,0,105,109,112,108,105,99,105,116,0,0,0,0,0,0,0,0,102,111,114,109,97,116,32,109,117,115,116,32,104,97,118,101,32,49,45,55,32,99,111,110,118,101,114,115,105,111,110,115,32,111,102,32,116,121,112,101,32,100,111,117,98,108,101,32,40,37,37,108,102,41,0,0,73,110,116,101,114,110,97,108,32,101,114,114,111,114,32,58,32,117,110,107,110,111,119,110,32,116,105,99,32,116,121,112,101,0,0,0,0,0,0,0,37,37,32,87,114,105,116,116,101,110,32,98,121,32,67,111,110,84,101,88,116,32,116,101,114,109,105,110,97,108,32,102,111,114,32,71,78,85,80,76,79,84,0,0,0,0,0,0,111,36,114,105,103,105,110,0,102,111,114,109,117,108,97,101,83,101,113,0,0,0,0,0,101,120,112,101,99,116,101,100,32,115,116,114,105,110,103,0,115,101,116,32,112,109,51,100,32,0,0,0,0,0,0,0,99,111,114,110,101,114,115,32,102,111,114,32,102,105,108,108,101,100,99,117,114,118,101,115,0,0,0,0,0,0,0,0,67,111,108,117,109,110,32,109,117,115,116,32,98,101,32,62,61,32,45,50,0,0,0,0,92,101,110,100,105,110,112,117,116,10,0,0,0,0,0,0,110,111,98,111,36,114,100,101,114,0,0,0,0,0,0,0,82,71,66,32,112,116,115,0,108,111,103,32,98,97,115,101,32,109,117,115,116,32,98,101,32,62,32,49,46,48,59,32,108,111,103,115,99,97,108,101,32,117,110,99,104,97,110,103,101,100,0,0,0,0,0,0,115,101,116,32,108,111,99,97,108,101,32,34,37,115,34,10,0,0,0,0,0,0,0,0,40,50,120,45,49,41,94,50,0,0,0,0,0,0,0,0,92,115,116,111,112,116,101,120,116,10,0,0,0,0,0,0,98,100,36,101,102,97,117,108,116,0,0,0,0,0,0,0,100,111,112,108,111,116,0,0,9,67,117,114,114,101,110,116,32,112,97,108,101,116,116,101,32,105,115,10,9,32,32,32,32,115,101,116,32,112,97,108,101,116,116,101,32,114,103,98,102,111,114,109,117,108,97,101,32,37,105,44,37,105,44,37,105,10,0,0,0,0,0,0,115,101,116,32,116,109,97,114,103,105,110,32,37,115,32,37,103,10,0,0,0,0,0,0,99,98,116,105,99,36,108,97,98,101,108,115,0,0,0,0,92,115,116,111,112,71,78,85,80,76,79,84,103,114,97,112,104,105,99,10,0,0,0,0,98,111,36,114,100,101,114,0,69,120,112,101,99,116,105,110,103,32,39,103,114,97,100,105,101,110,116,39,32,111,114,32,39,112,97,108,101,116,116,101,32,60,110,62,39,32,111,114,32,39,114,103,98,102,111,114,109,117,108,97,101,39,32,111,114,32,39,99,111,108,111,114,110,97,109,101,115,39,0,0,101,120,112,101,99,116,105,110,103,32,39,99,97,114,116,101,115,105,97,110,39,44,32,39,115,112,104,101,114,105,99,97,108,39,44,32,111,114,32,39,99,121,108,105,110,100,114,105,99,97,108,39,0,0,0,0,115,101,116,32,114,109,97,114,103,105,110,32,37,115,32,37,103,10,0,0,0,0,0,0,122,116,105,99,36,108,97,98,101,108,115,0,0,0,0,0,37,115,10,10,0,0,0,0,92,115,116,111,112,71,78,85,80,76,79,84,112,97,103,101,10,0,0,0,0,0,0,0,117,36,115,101,114,0,0,0,102,105,116,50,114,103,98,36,102,111,114,109,117,108,97,101,0,0,0,0,0,0,0,0,99,121,36,108,105,110,100,114,105,99,97,108,0,0,0,0,115,101,116,32,98,109,97,114,103,105,110,32,37,115,32,37,103,10,0,0,0,0,0,0,121,50,116,105,99,36,108,97,98,101,108,115,0,0,0,0,9,103,110,117,112,108,111,116,32,76,67,95,78,85,77,69,82,73,67,32,37,115,10,0,37,46,49,50,48,115,0,0,116,36,119,111,0,0,0,0,115,101,116,98,111,117,110,100,115,32,99,117,114,114,101,110,116,112,105,99,116,117,114,101,32,116,111,32,117,110,105,116,115,113,117,97,114,101,32,120,121,115,99,97,108,101,100,32,40,119,44,104,41,59,10,0,104,36,111,114,105,122,111,110,116,97,108,0,0,0,0,0,99,111,108,111,114,36,110,97,109,101,115,0,0,0,0,0,115,36,112,104,101,114,105,99,97,108,0,0,0,0,0,0,97,116,32,115,99,114,101,101,110,0,0,0,0,0,0,0,121,95,109,105,110,51,100,32,115,104,111,117,108,100,32,110,111,116,32,101,113,117,97,108,32,121,95,109,97,120,51,100,33,0,0,0,0,0,0,0,121,116,105,99,36,108,97,98,101,108,115,0,0,0,0,0,109,111,100,0,0,0,0,0,100,101,115,116,32,61,61,32,78,85,76,76,32,124,124,32,100,101,115,116,32,33,61,32,111,117,116,115,116,114,0,0,10,35,32,73,115,111,67,117,114,118,101,32,37,100,44,32,37,100,32,112,111,105,110,116,115,10,35,32,120,32,121,32,122,0,0,0,0,0,0,0,118,36,101,114,116,105,99,97,108,0,0,0,0,0,0,0,115,104,101,36,108,108,0,0,99,97,36,114,116,101,115,105,97,110,0,0,0,0,0,0,37,115,9,37,102,10,0,0,115,101,116,32,108,109,97,114,103,105,110,32,37,115,32,37,103,10,0,0,0,0,0,0,120,50,116,105,99,36,108,97,98,101,108,115,0,0,0,0,67,111,109,112,105,108,101,32,111,112,116,105,111,110,115,58,10,37,115,10,0,0,0,0,37,46,52,103,0,0,0,0,114,122,116,0,0,0,0,0,116,105,109,101,0,0,0,0,114,103,98,102,111,114,36,109,117,108,97,101,0,0,0,0,101,120,112,101,99,116,105,110,103,32,39,115,99,114,101,101,110,32,60,102,114,97,99,116,105,111,110,62,39,0,0,0,115,101,116,32,122,101,114,111,32,37,103,10,0,0,0,0,120,116,105,99,36,108,97,98,101,108,115,0,0,0,0,0,32,108,105,110,101,115,116,121,108,101,32,37,100,0,0,0,120,32,114,97,110,103,101,0,99,111,108,117,109,110,104,101,97,100,0,0,0,0,0,0,114,99,102,105,108,101,0,0,101,113,0,0,0,0,0,0,41,59,112,111,115,105,116,105,111,110,115,40,0,0,0,0,116,101,114,109,36,105,110,97,108,0,0,0,0,0,0,0,69,110,100,0,0,0,0,0,103,114,97,36,100,105,101,110,116,0,0,0,0,0,0,0,115,99,36,114,101,101,110,0,102,95,115,112,114,105,110,116,102,58,32,97,116,116,101,109,112,116,32,116,111,32,112,114,105,110,116,32,110,117,109,101,114,105,99,32,118,97,108,117,101,32,119,105,116,104,32,115,116,114,105,110,103,32,102,111,114,109,97,116,0,0,0,0,83,105,103,110,101,100,83,104,111,114,116,0,0,0,0,0,40,37,46,51,103,44,37,46,51,103,44,37,46,51,103,41,0,0,0,0,0,0,0,0,110,111,111,112,97,113,117,101,0,0,0,0,0,0,0,0,101,120,116,114,97,32,99,104,97,114,115,32,97,102,116,101,114,32,60,115,101,112,97,114,97,116,105,111,110,95,99,104,97,114,62,0,0,0,0,0,107,101,121,32,101,110,116,114,121,0,0,0,0,0,0,0,10,37,72,58,37,77,0,0,99,111,108,111,114,115,40,0,111,112,97,113,117,101,0,0,9,103,97,109,109,97,32,105,115,32,37,46,52,103,10,0,39,92,116,39,0,0,0,0,104,105,115,116,101,112,115,32,118,97,108,105,100,32,112,111,105,110,116,32,109,97,112,112,105,110,103,0,0,0,0,0,116,101,109,112,32,115,116,114,105,110,103,32,102,111,114,32,108,97,98,101,108,32,104,97,99,107,0,0,0,0,0,0,99,111,108,111,114,95,109,111,100,101,40,103,114,97,100,105,101,110,116,41,59,0,0,0,109,97,120,114,111,119,36,115,0,0,0,0,0,0,0,0,37,115,58,37,100,32,111,111,111,112,115,58,32,85,110,107,110,111,119,110,32,99,111,108,111,114,32,109,111,100,101,32,39,37,99,39,46,10,0,0,34,92,116,34,0,0,0,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,58,32,99,111,108,117,109,110,32,60,61,32,48,32,105,110,32,100,97,116,97,102,105,108,101,46,99,0,0,0,0,0,0,0,50,32,109,117,108,32,49,32,115,117,98,32,100,117,112,32,109,117,108,0,0,0,0,0,99,111,108,111,114,95,109,111,100,101,40,102,117,110,99,116,105,111,110,115,41,0,0,0,109,97,120,99,111,108,117,36,109,110,115,0,0,0,0,0,88,89,90,10,0,0,0,0,101,120,112,101,99,116,101,100,32,34,60,115,101,112,97,114,97,116,111,114,95,99,104,97,114,62,34,0,0,0,0,0,115,101,116,32,116,105,109,101,115,116,97,109,112,32,37,115,32,10,0,0,0,0,0,0,37,49,54,46,51,102,0,0,99,111,108,111,114,95,109,111,100,101,40,114,103,98,41,59,102,111,114,109,117,108,97,101,40,37,100,44,37,100,44,37,100,41,0,0,0,0,0,0,109,97,120,99,111,108,36,115,0,0,0,0,0,0,0,0,89,73,81,10,0,0,0,0,119,104,105,116,101,36,115,112,97,99,101,0,0,0,0,0,32,114,111,116,97,116,101,32,112,97,114,97,108,108,101,108,0,0,0,0,0,0,0,0,116,105,109,101,115,116,114,105,110,103,0,0,0,0,0,0,10,10,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,10,0,0,0,0,0,0,99,111,108,111,114,95,109,111,100,101,40,103,114,97,121,41,0,0,0,0,0,0,0,0,116,101,120,116,36,99,111,108,111,114,0,0,0,0,0,0,84,105,99,32,108,97,98,101,108,32,100,111,101,115,32,110,111,116,32,101,118,97,108,117,97,116,101,32,97,115,32,115,116,114,105,110,103,33,10,0,67,77,89,10,0,0,0,0,101,120,112,101,99,116,101,100,32,115,116,114,105,110,103,32,119,105,116,104,32,99,111,109,109,101,110,116,115,32,99,104,97,114,115,0,0,0,0,0,10,115,101,116,32,37,115,37,115,32,0,0,0,0,0,0,9,103,110,117,112,108,111,116,32,76,67,95,84,73,77,69,32,32,32,32,37,115,10,0,117,116,105,108,46,99,0,0,111,36,110,101,0,0,0,0,103,112,95,109,97,107,101,95,112,97,108,101,116,116,101,40,0,0,0,0,0,0,0,0,116,99,0,0,0,0,0,0,72,83,86,10,0,0,0,0,109,97,120,95,108,105,110,101,95,108,101,110,0,0,0,0,100,105,118,0,0,0,0,0,84,97,98,117,108,97,114,32,111,117,116,112,117,116,32,111,102,32,116,104,105,115,32,51,68,32,112,108,111,116,32,115,116,121,108,101,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,10,0,0,0,70,97,116,97,108,58,32,117,110,100,101,102,105,110,101,100,32,99,111,108,111,114,32,102,111,114,109,117,108,97,32,40,99,97,110,32,98,101,32,48,45,45,37,105,41,10,0,0,37,37,32,102,111,114,32,97,100,100,105,116,105,111,110,97,108,32,117,115,101,114,45,100,101,102,105,110,101,100,32,115,101,116,116,105,110,103,115,10,103,112,95,115,101,116,117,112,95,97,102,116,101,114,59,10,0,0,0,0,0,0,0,0,115,101,36,116,0,0,0,0,82,71,66,10,0,0,0,0,101,120,112,101,99,116,101,100,32,109,105,115,115,105,110,103,45,118,97,108,117,101,32,115,116,114,105,110,103,0,0,0,95,121,0,0,0,0,0,0,115,101,116,32,37,115,37,115,32,34,37,115,34,32,0,0,108,36,111,110,103,0,0,0,103,112,95,115,101,116,95,108,105,110,101,119,105,100,116,104,40,37,103,41,59,10,0,0,122,116,114,0,0,0,0,0,110,111,116,105,36,116,108,101])
.concat([0,0,0,0,0,0,0,0,9,67,111,108,111,114,45,77,111,100,101,108,58,32,0,0,119,114,111,110,103,32,111,112,116,105,111,110,0,0,0,0,115,101,116,32,109,37,115,116,105,99,115,32,37,102,10,0,37,103,32,37,103,0,0,0,32,108,116,32,37,100,0,0,121,32,114,97,110,103,101,32,105,115,32,105,110,118,97,108,105,100,0,0,0,0,0,0,33,61,0,0,0,0,0,0,37,37,32,108,105,110,101,119,105,100,116,104,32,115,99,97,108,105,110,103,32,102,97,99,116,111,114,32,102,111,114,32,105,110,100,105,118,105,100,117,97,108,32,108,105,110,101,115,10,0,0,0,0,0,0,0,80,97,103,101,68,111,119,110,0,0,0,0,0,0,0,0,32,99,111,108,111,114,32,112,111,115,105,116,105,111,110,115,32,102,111,114,32,100,105,115,99,114,101,116,101,32,112,97,108,101,116,116,101,32,116,101,114,109,105,110,97,108,115,10,0,0,0,0,0,0,0,0,114,117,108,101,114,32,97,116,0,0,0,0,0,0,0,0,115,101,116,32,109,37,115,116,105,99,115,32,100,101,102,97,117,108,116,10,0,0,0,0,117,110,114,101,99,111,103,110,105,122,101,100,32,112,108,111,116,32,116,121,112,101,0,0,37,37,0,0,0,0,0,0,85,110,115,105,103,110,101,100,83,104,111,114,116,0,0,0,103,112,95,115,101,116,95,112,111,105,110,116,115,105,122,101,40,37,103,41,59,10,0,0,110,111,97,36,117,116,111,116,105,116,108,101,115,0,0,0,65,76,76,32,114,101,109,97,105,110,105,110,103,0,0,0,101,120,112,101,99,116,105,110,103,32,114,117,108,101,114,32,99,111,111,114,100,105,110,97,116,101,115,0,0,0,0,0,115,101,116,32,109,37,115,116,105,99,115,10,0,0,0,0,37,100,47,37,109,0,0,0,83,105,103,110,101,100,66,121,116,101,0,0,0,0,0,0,112,118,101,114,116,32,62,61,32,48,0,0,0,0,0,0,37,37,32,112,111,105,110,116,115,105,122,101,32,115,99,97,108,105,110,103,32,102,97,99,116,111,114,10,0,0,0,0,97,36,117,116,111,116,105,116,108,101,115,0,0,0,0,0,77,65,88,32,37,105,0,0,114,117,36,108,101,114,0,0,115,101,116,32,110,111,109,37,115,116,105,99,115,10,0,0,103,112,95,115,99,97,108,101,95,116,101,120,116,32,58,61,32,37,103,59,10,0,0,0,104,36,101,105,103,104,116,0,9,97,108,108,111,99,97,116,105,110,103,32,0,0,0,0,110,111,114,117,36,108,101,114,0,0,0,0,0,0,0,0,115,101,116,32,116,105,99,115,108,101,118,101,108,32,37,103,10,0,0,0,0,0,0,0,124,120,45,48,46,53,124,0,37,37,32,116,101,120,116,32,115,99,97,108,105,110,103,32,102,97,99,116,111,114,32,102,111,114,32,116,104,101,32,119,104,111,108,101,32,102,105,103,117,114,101,10,0,0,0,0,119,36,105,100,116,104,0,0,32,78,79,84,0,0,0,0,115,104,111,117,108,100,32,98,101,58,32,37,100,32,60,61,32,109,111,117,115,101,102,111,114,109,97,116,32,60,61,32,37,100,10,0,0,0,0,0,115,101,116,32,120,121,112,108,97,110,101,32,97,116,32,37,103,10,0,0,0,0,0,0,37,37,32,102,111,114,32,97,100,100,105,116,105,111,110,97,108,32,117,115,101,114,45,100,101,102,105,110,101,100,32,115,101,116,116,105,110,103,115,10,103,112,95,115,101,116,117,112,95,98,101,102,111,114,101,59,10,0,0,0,0,0,0,0,115,112,36,97,99,105,110,103,0,0,0,0,0,0,0,0,9,97,108,108,32,99,111,108,111,114,32,102,111,114,109,117,108,97,101,32,65,82,69,37,115,32,119,114,105,116,116,101,110,32,105,110,116,111,32,111,117,116,112,117,116,32,112,111,115,116,115,99,114,105,112,116,32,102,105,108,101,10,0,0,112,108,101,97,115,101,32,39,115,101,116,32,109,111,117,115,101,32,109,111,117,115,101,102,111,114,109,97,116,32,60,102,109,116,62,39,32,102,105,114,115,116,46,10,0,0,0,0,102,117,110,99,116,105,111,110,0,0,0,0,0,0,0,0,44,32,116,97,110,103,101,110,116,61,37,115,41,0,0,0,99,111,117,108,100,32,110,111,116,32,111,112,101,110,32,108,111,103,45,102,105,108,101,32,37,115,0,0,0,0,0,0,37,37,32,68,105,102,102,101,114,101,110,116,32,105,110,105,116,105,97,108,105,115,97,116,105,111,110,115,10,0,0,0,115,97,36,109,112,108,101,110,0,0,0,0,0,0,0,0,78,69,71,65,84,73,86,69,0,0,0,0,0,0,0,0,109,111,36,117,115,101,102,111,114,109,97,116,0,0,0,0,115,101,116,32,115,116,121,108,101,32,102,117,110,99,116,105,111,110,32,0,0,0,0,0,44,32,37,32,35,46,52,103,100,101,103,41,0,0,0,0,80,115,101,117,100,111,100,97,116,97,32,110,111,116,32,121,101,116,32,105,109,112,108,101,109,101,110,116,101,100,32,102,111,114,32,112,111,108,97,114,32,111,114,32,112,97,114,97,109,101,116,114,105,99,32,103,114,97,112,104,115,0,0,0,9,103,110,117,112,108,111,116,32,101,110,99,111,100,105,110,103,32,32,32,37,115,10,0,108,105,110,101,32,37,100,58,32,0,0,0,0,0,0,0,112,36,111,105,110,116,115,0,37,37,32,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,10,0,0,0,110,111,98,36,111,120,0,0,105,110,112,117,116,32,100,97,116,97,32,40,39,101,39,32,101,110,100,115,41,32,62,32,0,0,0,0,0,0,0,0,80,79,83,73,84,73,86,69,0,0,0,0,0,0,0,0,115,104,111,117,108,100,32,98,101,58,32,37,100,32,60,61,32,99,108,105,112,98,111,97,114,100,102,111,114,109,97,116,32,60,61,32,37,100,10,0,115,101,116,32,115,116,121,108,101,32,100,97,116,97,32,0,104,101,97,100,115,0,0,0,109,117,108,116,0,0,0,0,10,35,32,83,117,114,102,97,99,101,32,37,100,32,111,102,32,37,100,32,115,117,114,102,97,99,101,115,10,0,0,0,37,37,32,116,101,109,112,111,114,97,114,121,32,118,97,114,105,97,98,108,101,32,102,111,114,32,115,116,111,114,105,110,103,32,116,104,101,32,112,97,116,104,10,115,97,118,101,32,112,59,32,112,97,116,104,32,112,59,10,0,0,0,0,0,98,36,111,120,0,0,0,0,115,99,114,36,101,101,110,100,117,109,112,0,0,0,0,0,9,102,105,103,117,114,101,32,105,115,32,37,115,10,0,0,95,120,0,0,0,0,0,0,115,101,116,32,99,110,116,114,112,97,114,97,109,32,112,111,105,110,116,115,32,37,100,10,115,101,116,32,115,105,122,101,32,114,97,116,105,111,32,37,103,32,37,103,44,37,103,10,115,101,116,32,111,114,105,103,105,110,32,37,103,44,37,103,10,0,0,0,0,0,0,0,93,32,32,100,105,115,116,97,110,99,101,58,32,0,0,0,109,97,116,114,105,120,32,99,111,110,116,97,105,110,115,32,109,105,115,115,105,110,103,32,111,114,32,117,110,100,101,102,105,110,101,100,32,118,97,108,117,101,115,0,0,0,0,0,71,32,78,32,85,32,80,32,76,32,79,32,84,0,0,0,37,37,32,116,101,109,112,111,114,97,114,121,32,118,97,114,105,97,98,108,101,32,102,111,114,32,115,116,111,114,105,110,103,32,116,104,101,32,112,97,116,104,32,97,110,100,32,105,109,97,103,101,115,10,115,97,118,101,32,112,44,32,105,109,103,44,32,105,109,97,59,32,112,97,116,104,32,112,59,32,115,116,114,105,110,103,32,105,109,103,44,32,105,109,97,59,10,0,0,0,0,0,0,0,116,114,122,0,0,0,0,0,115,104,111,119,46,99,0,0,39,102,111,110,116,110,97,109,101,44,102,111,110,116,115,105,122,101,39,32,101,120,112,101,99,116,101,100,0,0,0,0,99,108,36,105,112,98,111,97,114,100,102,111,114,109,97,116,0,0,0,0,0,0,0,0,100,121,50,61,0,0,0,0,100,102,95,109,97,116,114,105,120,0,0,0,0,0,0,0,32,116,101,120,116,99,111,108,111,114,0,0,0,0,0,0,120,32,114,97,110,103,101,32,105,115,32,105,110,118,97,108,105,100,0,0,0,0,0,0,80,105,112,101,115,32,97,110,100,32,115,104,101,108,108,32,99,111,109,109,97,110,100,115,32,110,111,116,32,112,101,114,109,105,116,116,101,100,32,100,117,114,105,110,103,32,105,110,105,116,105,97,108,105,122,97,116,105,111,110,0,0,0,0,61,61,0,0,0,0,0,0,67,97,110,110,111,116,32,115,101,116,32,105,110,116,101,114,110,97,108,32,118,97,114,105,97,98,108,101,115,32,71,80,86,65,76,95,32,97,110,100,32,77,79,85,83,69,95,0,99,109,0,0,0,0,0,0,80,97,103,101,85,112,0,0,37,115,58,37,100,32,111,111,112,115,58,32,85,110,107,110,111,119,110,32,99,111,108,111,114,32,109,111,100,101,32,39,37,99,39,46,10,0,0,0,100,105,115,99,114,101,116,101,32,37,103,0,0,0,0,0,78,111,32,116,101,114,109,105,110,97,108,32,104,97,115,32,98,101,101,110,32,112,117,115,104,101,100,32,121,101,116,10,0,0,0,0,0,0,0,0,100,120,50,61,0,0,0,0,77,97,116,114,105,120,32,100,111,101,115,32,110,111,116,32,114,101,112,114,101,115,101,110,116,32,97,32,103,114,105,100,0,0,0,0,0,0,0,0,105,110,0,0,0,0,0,0,110,111,105,110,118,36,101,114,116,0,0,0,0,0,0,0,9,67,117,98,101,104,101,108,105,120,32,99,111,108,111,114,32,112,97,108,101,116,116,101,58,32,115,116,97,114,116,32,37,103,32,99,121,99,108,101,115,32,37,103,32,115,97,116,117,114,97,116,105,111,110,32,37,103,10,0,0,0,0,0,110,111,122,111,111,109,106,117,36,109,112,0,0,0,0,0,105,110,99,114,101,109,101,110,116,97,108,32,37,103,44,37,103,44,37,103,10,0,0,0,70,105,108,101,32,100,111,101,115,110,39,116,32,102,97,99,116,111,114,105,122,101,32,105,110,116,111,32,102,117,108,108,32,109,97,116,114,105,120,0,37,109,47,37,100,0,0,0,85,110,115,105,103,110,101,100,66,121,116,101,0,0,0,0,37,37,32,115,99,97,108,105,110,103,32,102,97,99,116,111,114,44,32,119,105,100,116,104,32,97,110,100,32,104,101,105,103,104,116,32,111,102,32,116,104,101,32,102,105,103,117,114,101,10,97,32,58,61,32,49,99,109,59,32,119,32,58,61,32,37,46,51,102,97,59,32,104,32,58,61,32,37,46,51,102,97,59,32,37,37,32,40,37,103,37,115,44,32,37,103,37,115,41,10,0,0,0,0,105,110,118,36,101,114,116,0,9,32,32,67,45,102,111,114,109,117,108,97,58,32,37,115,10,0,0,0,0,0,0,0,122,111,111,109,106,117,36,109,112,0,0,0,0,0,0,0,97,117,116,111,32,37,100,10,0,0,0,0,0,0,0,0,82,101,97,100,32,103,114,105,100,32,119,105,100,116,104,32,116,111,111,32,108,97,114,103,101,0,0,0,0,0,0,0,115,116,114,105,110,103,32,116,101,114,109,118,101,114,115,105,111,110,59,32,32,32,32,116,101,114,109,118,101,114,115,105,111,110,32,32,32,32,58,61,32,34,37,115,34,59,10,0,110,111,114,101,118,36,101,114,115,101,0,0,0,0,0,0,9,32,32,66,45,102,111,114,109,117,108,97,58,32,37,115,10,0,0,0,0,0,0,0,110,111,118,101,36,114,98,111,115,101,0,0,0,0,0,0,115,101,116,32,99,110,116,114,112,97,114,97,109,32,108,101,118,101,108,115,32,0,0,0,82,101,97,100,32,103,114,105,100,32,111,102,32,122,101,114,111,32,119,105,100,116,104,0,48,46,53,32,115,117,98,32,97,98,115,0,0,0,0,0,115,116,114,105,110,103,32,103,110,117,112,108,111,116,118,101,114,115,105,111,110,59,32,103,110,117,112,108,111,116,118,101,114,115,105,111,110,32,58,61,32,34,37,115,34,59,10,0,114,101,118,36,101,114,115,101,0,0,0,0,0,0,0,0,9,32,32,65,45,102,111,114,109,117,108,97,58,32,37,115,10,0,0,0,0,0,0,0,118,101,36,114,98,111,115,101,0,0,0,0,0,0,0,0,98,115,112,108,105,110,101,10,0,0,0,0,0,0,0,0,67,97,110,39,116,32,114,101,97,100,32,115,101,99,111,110,100,32,100,105,109,101,110,115,105,111,110,32,105,110,32,100,97,116,97,32,102,105,108,101,32,34,37,115,34,0,0,0,66,82,69,65,75,58,32,37,115,0,0,0,0,0,0,0,92,115,116,97,114,116,71,78,85,80,76,79,84,103,114,97,112,104,105,99,91,37,100,93,10,0,0,0,0,0,0,0,82,36,105,103,104,116,0,0,9,99,111,108,111,114,32,109,97,112,112,105,110,103,32,105,115,32,100,111,110,101,32,98,121,32,117,115,101,114,32,100,101,102,105,110,101,100,32,102,117,110,99,116,105,111,110,115,10,0,0,0,0,0,0,0,110,111,108,97,36,98,101,108,115,0,0,0,0,0,0,0,99,117,98,105,99,115,112,108,105,110,101,10,0,0,0,0,121,61,0,0,0,0,0,0,67,97,110,39,116,32,114,101,97,100,32,102,105,114,115,116,32,100,105,109,101,110,115,105,111,110,32,105,110,32,100,97,116,97,32,102,105,108,101,32,34,37,115,34,0,0,0,0,92,115,116,97,114,116,71,78,85,80,76,79,84,112,97,103,101,32,37,37,32,71,114,97,112,104,105,99,32,78,114,46,32,37,100,10,0,0,0,0,76,36,101,102,116,0,0,0,9,99,111,108,111,114,32,109,97,112,112,105,110,103,32,98,121,32,100,101,102,105,110,101,100,32,103,114,97,100,105,101,110,116,10,0,0,0,0,0,108,97,98,101,108,36,115,0,108,105,110,101,97,114,10,0,120,61,0,0,0,0,0,0,67,97,110,39,116,32,111,112,101,110,32,100,97,116,97,32,102,105,108,101,32,34,37,115,34,0,0,0,0,0,0,0,9,103,110,117,112,108,111,116,32,76,67,95,67,84,89,80,69,32,32,32,37,115,10,0,34,37,115,34,44,32,108,105,110,101,32,37,100,58,32,0,112,32,58,61,32,40,37,46,51,102,97,44,37,46,51,102,97,41,0,0,0,0,0,0,114,109,36,97,114,103,105,110,0,0,0,0,0,0,0,0,9,114,103,98,32,99,111,108,111,114,32,109,97,112,112,105,110,103,32,98,121,32,114,103,98,102,111,114,109,117,108,97,101,32,97,114,101,32,37,105,44,37,105,44,37,105,10,0,110,111,112,111,36,108,97,114,100,105,115,116,97,110,99,101,0,0,0,0,0,0,0,0,115,101,116,32,99,110,116,114,112,97,114,97,109,32,0,0,32,32,32,115,99,97,108,101,58,32,0,0,0,0,0,0,84,111,111,32,109,97,110,121,32,99,111,108,117,109,110,115,32,105,110,32,117,115,105,110,103,32,115,112,101,99,105,102,105,99,97,116,105,111,110,32,97,110,100,32,105,109,112,108,105,101,100,32,115,97,109,112,108,105,110,103,32,97,114,114,97,121,0,0,0,0,0,0,98,97,99,107,104,101,97,100,0,0,0,0,0,0,0,0,109,105,110,117,115,0,0,0,112,114,105,110,116,95,51,100,116,97,98,108,101,32,111,117,116,112,117,116,32,98,117,102,102,101,114,0,0,0,0,0,103,112,95,115,101,116,95,108,105,110,101,116,121,112,101,40,37,100,41,59,10,0,0,0,108,109,36,97,114,103,105,110,0,0,0,0,0,0,0,0,115,97,36,118,101,0,0,0,67,79,76,79,82,0,0,0,112,111,108,97,114,100,105,115,116,97,110,99,101,116,36,97,110,0,0,0,0,0,0,0,115,101,116,32,99,110,116,114,112,97,114,97,109,32,111,114,100,101,114,32,37,100,10,0,118,105,101,119,58,32,0,0,80,108,111,116,32,115,116,121,108,101,32,114,101,113,117,105,114,101,115,32,104,105,103,104,101,114,32,116,104,97,110,32,111,110,101,45,100,105,109,101,110,115,105,111,110,97,108,32,115,97,109,112,108,105,110,103,32,97,114,114,97,121,0,0,37,115,9,102,97,113,44,32,98,117,103,115,44,32,101,116,99,58,32,32,32,116,121,112,101,32,34,104,101,108,112,32,70,65,81,34,10,37,115,9,105,109,109,101,100,105,97,116,101,32,104,101,108,112,58,32,32,32,116,121,112,101,32,34,104,101,108,112,34,32,32,40,112,108,111,116,32,119,105,110,100,111,119,58,32,104,105,116,32,39,104,39,41,10,0,0,123,37,115,125,41,59,10,0,122,121,120,0,0,0,0,0,98,109,36,97,114,103,105,110,0,0,0,0,0,0,0,0,71,82,65,89,0,0,0,0,112,111,36,108,97,114,100,105,115,116,97,110,99,101,100,101,103,0,0,0,0,0,0,0,115,101,116,32,100,97,116,97,102,105,108,101,32,110,111,102,112,101,95,116,114,97,112,10,0,0,0,0,0,0,0,0,122,111,111,109,105,110,103,32,99,97,110,99,101,108,108,101,100,46,10,0,0,0,0,0,80,108,111,116,32,115,116,121,108,101,32,114,101,113,117,105,114,101,115,32,104,105,103,104,101,114,32,116,104,97,110,32,116,119,111,45,100,105,109,101,110,115,105,111,110,97,108,32,115,97,109,112,108,105,110,103,32,97,114,114,97,121,0,0,112,97,114,97,109,101,116,114,105,99,32,102,117,110,99,116,105,111,110,32,110,111,116,32,102,117,108,108,121,32,115,112,101,99,105,102,105,101,100,0,72,79,77,69,32,110,111,116,32,115,101,116,32,45,32,99,97,110,110,111,116,32,101,120,112,97,110,100,32,116,105,108,100,101,0,0,0,0,0,0,38,0,0,0,0,0,0,0,91,37,115,93,0,0,0,0,116,109,36,97,114,103,105,110,0,0,0,0,0,0,0,0,68,111,119,110,0,0,0,0,9,112,97,108,101,116,116,101,32,105,115,32,37,115,10,0,110,111,122,111,111,109,99,111,36,111,114,100,105,110,97,116,101,115,0,0,0,0,0,0,115,101,116,32,100,97,116,97,102,105,108,101,32,102,111,114,116,114,97,110,10,0,0,0,32,32,32,114,101,115,116,111,114,101,100,32,116,101,114,109,105,110,97,108,32,105,115,32,37,115,32,37,115,10,0,0,96,98,117,105,108,116,105,110,45,99,97,110,99,101,108,45,122,111,111,109,96,32,99,97,110,99,101,108,32,122,111,111,109,32,114,101,103,105,111,110,0,0,0,0,0,0,0,0,80,108,111,116,32,115,116,121,108,101,32,100,111,101,115,32,110,111,116,32,99,111,110,102,111,114,109,32,116,111,32,116,104,114,101,101,32,99,111,108,117,109,110,32,100,97,116,97,32,105,110,32,116,104,105,115,32,103,114,97,112,104,32,109,111,100,101,0,0,0,0,0,97,108,105,103,110,40,37,115,41,44,32,92,115,111,109,101,116,120,116,91,103,112,93,0,111,36,117,116,115,105,100,101,0,0,0,0,0,0,0,0,72,79,82,73,90,79,78,84,65,76,0,0,0,0,0,0,122,111,111,109,99,111,36,111,114,100,105,110,97,116,101,115,0,0,0,0,0,0,0,0,115,101,116,32,100,97,116,97,102,105,108,101,32,99,111,109,109,101,110,116,115,99,104,97,114,115,32,39,37,115,39,10,0,0,0,0,0,0,0,0,77,79,85,83,69,95,75,69,89,95,87,73,78,68,79,87,0,0,0,0,0,0,0,0,110,111,95,99,111,108,115,32,60,61,32,77,65,88,68,65,84,65,67,79,76,83,0,0,104,105,100,100,101,110,32,116,104,101,115,101,95,101,100,103,101,115,0,0,0,0,0,0,72,105,103,104,66,121,116,101,70,105,114,115,116,0,0,0,97,110,103,108,101,40,37,100,41,44,32,0,0,0,0,0,105,110,115,36,105,100,101,0,86,69,82,84,73,67,65,76,0,0,0,0,0,0,0,0,110,111,100,111,36,117,98,108,101,99,108,105,99,107,0,0,71,80,86,65,76,95,86,73,69,87,95,90,83,67,65,76,69,0,0,0,0,0,0,0,101,108,108,105,112,115,101,32,112,108,111,116,0,0,0,0,67,97,110,110,111,116,32,103,101,110,101,114,97,116,101,32,99,111,111,114,100,115,32,102,111,114,32,116,104,97,116,32,112,108,111,116,32,115,116,121,108,101,0,0,0,0,0,0,103,112,95,112,117,116,95,116,101,120,116,40,40,37,46,51,102,97,44,32,37,46,51,102,97,41,44,32,0,0,0,0,98,101,36,108,111,119,0,0,9,99,111,108,111,114,32,103,114,97,100,105,101,110,116,32,105,115,32,37,115,32,105,110,32,116,104,101,32,99,111,108,111,114,32,98,111,120,10,0,100,111,36,117,98,108,101,99,108,105,99,107,0,0,0,0,115,101,116,32,100,97,116,97,102,105,108,101,32,115,101,112,97,114,97,116,111,114,32,119,104,105,116,101,115,112,97,99,101,10,0,0,0,0,0,0,71,80,86,65,76,95,86,73,69,87,95,83,67,65,76,69,0,0,0,0,0,0,0,0,77,97,116,114,105,120,32,100,97,116,97,32,99,111,110,116,97,105,110,115,32,111,110,108,121,32,116,104,114,101,101,32,99,111,108,117,109,110,115,0,71,78,85,80,76,79,84,95,76,73,66,0,0,0,0,0,99,111,115,40,57,48,120,41,0,0,0,0,0,0,0,0,103,112,95,112,111,105,110,116,40,37,46,51,102,97,44,37,46,51,102,97,44,37,100,41,59,10,0,0,0,0,0,0,117,36,110,100,101,114,0,0,65,114,103,104,33,0,0,0,103,114,36,97,112,104,0,0,115,101,116,32,100,97,116,97,102,105,108,101,32,115,101,112,97,114,97,116,111,114,32,34,37,99,34,10,0,0,0,0,37,108,102,0,0,0,0,0,97,98,36,111,118,101,0,0,44,0,0,0,0,0,0,0,10,9,32,32,32,32,32,32,32,32,32,32,115,105,122,101,58,32,0,0,0,0,0,0,115,101,116,32,100,97,116,97,102,105,108,101,32,109,105,115,115,105,110,103,32,39,37,115,39,10,0,0,0,0,0,0,78,111,32,100,101,102,97,117,108,116,32,99,111,108,117,109,110,115,32,107,110,111,119,110,32,102,111,114,32,116,104,97,116,32,112,108,111,116,32,115,116,121,108,101,0,0,0,0,76,97,109,98,100,97,32,115,99,97,108,105,110,103,32,102,97,99,116,111,114,115,32,114,101,115,101,116,58,32,32,37,103,10,0,0,0,0,0,0,85,110,114,101,99,111,103,110,105,122,101,100,32,111,112,116,105,111,110,46,32,32,83,101,101,32,39,104,101,108,112,32,117,110,115,101,116,39,46,0,66,97,100,32,116,105,109,101,32,102,111,114,109,97,116,32,105,110,32,115,116,114,105,110,103,0,0,0,0,0,0,0,44,37,103,112,116,0,0,0,111,118,36,101,114,0,0,0,97,116,32,85,83,69,82,32,111,114,105,103,105,110,58,32,0,0,0,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,107,101,121,119,111,114,100,32,39,97,112,112,101,110,100,39,0,0,0,0,0,0,116,117,112,108,101,32,115,121,110,116,97,120,32,101,114,114,111,114,0,0,0,0,0,0,37,98,0,0,0,0,0,0,94,10,0,0,0,0,0,0,121,120,0,0,0,0,0,0,103,112,95,115,101,116,95,112,111,105,110,116,115,105,122,101,40,37,46,51,102,41,59,10,0,0,0,0,0,0,0,0,104,111,114,36,105,122,111,110,116,97,108,0,0,0,0,0,97,116,32,68,69,70,65,85,76,84,32,112,111,115,105,116,105,111,110,10,0,0,0,0,97,112,112,101,110,100,0,0,69,120,112,101,99,116,105,110,103,32,39,44,39,32,111,114,32,39,41,39,0,0,0,0,104,101,97,100,0,0,0,0,112,108,117,115,0,0,0,0,32,37,99,10,0,0,0,0,112,32,58,61,32,117,110,105,116,115,113,117,97,114,101,32,120,121,115,99,97,108,101,100,32,40,37,46,51,102,97,44,37,46,51,102,97,41,32,115,104,105,102,116,101,100,32,40,37,46,51,102,97,44,37,46,51,102,97,41,59,10,0,0,118,101,114,36,116,105,99,97,108,0,0,0,0,0,0,0,114,101,115,36,101,116,0,0,78,79,84,32,100,114,97,119,110,10,0,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,102,105,108,101,110,97,109,101,0,0,0,0,0,0,112,114,101,102,105,120,0,0,37,115,10,37,115,9,37,115,10,37,115,9,86,101,114,115,105,111,110,32,37,115,32,112,97,116,99,104,108,101,118,101,108,32,37,115,32,32,32,32,108,97,115,116,32,109,111,100,105,102,105,101,100,32,37,115,10,37,115,9,66,117,105,108,100,32,83,121,115,116,101,109,58,32,37,115,32,37,115,10,37,115,10,37,115,9,37,115,10,37,115,9,84,104,111,109,97,115,32,87,105,108,108,105,97,109,115,44,32,67,111,108,105,110,32,75,101,108,108,101,121,32,97,110,100,32,109,97,110,121,32,111,116,104,101,114,115,10,37,115,10,37,115,9,103,110,117,112,108,111,116,32,104,111,109,101,58,32,32,32,32,32,104,116,116,112,58,47,47,119,119,119,46,103,110,117,112,108,111,116,46,105,110,102,111,10,0,0,0,0,0,0,103,112,95,115,101,116,95,108,105,110,101,119,105,100,116,104,40,37,46,51,102,41,59,10,0,0,0,0,0,0,0,0,120,122,121,0,0,0,0,0,99,36,101,110,116,101,114,0,100,114,97,119,110,32,98,97,99,107,10,9,0,0,0,0,110,111,114,111,116,36,97,116,101,0,0,0,0,0,0,0,10,9,100,117,109,109,121,32,118,97,114,105,97,98,108,101,32,105,115,32,116,32,102,111,114,32,99,117,114,118,101,115,44,32,117,47,118,32,102,111,114,32,115,117,114,102,97,99,101,115,10,0,0,0,0,0,115,101,116,32,109,97,112,112,105,110,103,32,0,0,0,0,98,111,114,100,101,114,0,0,116,104,105,115,95,112,108,111,116,32,33,61,32,78,85,76,76,0,0,0,0,0,0,0,97,120,101,115,32,109,117,115,116,32,98,101,32,120,49,121,49,44,32,120,49,121,50,44,32,120,50,121,49,32,111,114,32,120,50,121,50,0,0,0,116,105,108,100,101,32,101,120,112,97,110,115,105,111,110,0,94,0,0,0,0,0,0,0,99,111,110,116,101,120,116,46,116,114,109,32,115,101,116,95,99,111,108,111,114,32,117,110,107,110,111,119,110,32,99,111,108,111,114,115,112,101,99,45,62,116,121,112,101,32,37,105,0,0,0,0,0,0,0,0,114,36,105,103,104,116,0,0,100,114,97,119,110,32,102,114,111,110,116,10,9,0,0,0,115,101,116,32,109,97,99,114,111,115,10,0,0,0,0,0,115,101,116,32,116,101,114,109,32,37,115,32,37,115,0,0,102,95,115,112,114,105,110,116,102,0,0,0,0,0,0,0,77,111,114,101,32,116,104,97,110,32,37,100,32,101,108,101,109,101,110,116,115,0,0,0,37,37,103,112,95,115,101,116,95,99,111,108,111,114,40,102,114,97,99,40,37,46,52,102,41,41,59,10,0,0,0,0,108,36,101,102,116,0,0,0,9,99,111,108,111,114,32,98,111,120,32,119,105,116,104,111,117,116,32,98,111,114,100,101,114,32,105,115,32,0,0,0,69,120,112,101,99,116,101,100,32,99,111,109,109,97,46,0,117,110,115,101,116,32,99,108,97,98,101,108,10,0,0,0,104,105,100,100,101,110,32,110,111,114,116,104,95,101,100,103,101,115,0,0,0,0,0,0,76,111,119,66,121,116,101,70,105,114,115,116,0,0,0,0,103,112,95,115,101,116,95,99,111,108,111,114,40,114,103,98,40,37,51,46,50,102,44,37,51,46,50,102,44,37,51,46,50,102,41,41,59,10,0,0,98,36,111,116,116,111,109,0,68,69,70,65,85,76,84,32,108,105,110,101,32,116,121,112,101,32,105,115,32,0,0,0,86,97,108,117,101,32,111,117,116,32,111,102,32,114,97,110,103,101,32,91,48,44,49,93,46,0,0,0,0,0,0,0,115,101,116,32,99,108,97,98,101,108,32,39,37,115,39,10,0,0,0,0,0,0,0,0,105,115,111,95,56,56,53,57,95,50,0,0,0,0,0,0,104,105,115,116,111,103,114,97,109,0,0,0,0,0,0,0,73,110,118,97,108,105,100,32,110,117,109,101,114,105,99,32,111,114,32,116,117,112,108,101,32,102,111,114,109,0,0,0,10,35,32,67,117,114,118,101,32,116,105,116,108,101,58,32,34,37,115,34,0,0,0,0,103,112,95,115,101,116,95,99,111,108,111,114,40,108,116,40,37,100,41,41,59,10,0,0,116,36,111,112,0,0,0,0,108,105,110,101,32,116,121,112,101,32,37,100,32,105,115,32,0,0,0,0,0,0,0,0,85,110,107,110,111,119,110,32,99,111,108,111,114,32,110,97,109,101,46,0,0,0,0,0,32,98,111,116,104,10,0,0,73,110,116,101,114,110,97,108,32,101,114,114,111,114,58,32,73,110,118,97,108,105,100,32,99,111,109,109,97,32,115,101,112,97,114,97,116,101,100,32,116,121,112,101,0,0,0,0,57,48,32,109,117,108,32,99,111,115,0,0,0,0,0,0,45,45,40,37,46,51,102,97,44,37,46,51,102,97,41,59,10,103,112,95,100,114,97,119,40,112,41,59,10,0,0,0,111,102,102,0,0,0,0,0,9,99,111,108,111,114,32,98,111,120,32,119,105,116,104,32,98,111,114,100,101,114,44,32,0,0,0,0,0,0,0,0,85,110,107,110,111,119,110,32,99,111,108,111,114,32,115,112,101,99,105,102,105,101,114,46,32,85,115,101,32,39,35,114,114,103,103,98,98,39,46,0,32,115,117,114,102,97,99,101,10,0,0,0,0,0,0,0,80,101,114,112,101,110,100,105,99,117,108,97,114,32,118,101,99,116,111,114,32,99,97,110,110,111,116,32,98,101,32,122,101,114,111,0,0,0,0,0,112,117,115,104,99,0,0,0,45,45,99,121,99,108,101,59,10,103,112,95,100,114,97,119,40,112,41,59,10,0,0,0,111,110,0,0,0,0,0,0,101,120,116,101,110,100,32,100,121,110,97,114,114,97,121,0,99,111,114,110,101,114,32,37,105,10,0,0,0,0,0,0,35,37,50,120,37,50,120,37,50,120,0,0,0,0,0,0,32,98,97,115,101,10,0,0,84,104,114,101,101,45,100,105,109,101,110,115,105,111,110,97,108,32,116,117,112,108,101,32,114,101,113,117,105,114,101,100,0,0,0,0,0,0,0,0,76,97,109,98,100,97,32,83,116,97,114,116,32,118,97,108,117,101,32,115,101,116,58,32,37,103,10,0,0,0,0,0,103,112,95,100,111,116,40,37,46,51,102,97,44,37,46,51,102,97,41,59,10,0,0,0,109,97,120,105,109,117,109,32,111,102,32,52,32,99,111,114,110,101,114,115,10,0,0,0,69,120,112,101,99,116,101,100,32,40,32,116,111,32,115,116,97,114,116,32,103,114,97,100,105,101,110,116,32,100,101,102,105,110,105,116,105,111,110,46,0,0,0,0,0,0,0,0,10,115,101,116,32,115,97,109,112,108,101,115,32,37,100,44,32,37,100,10,115,101,116,32,105,115,111,115,97,109,112,108,101,115,32,37,100,44,32,37,100,10,37,115,115,101,116,32,115,117,114,102,97,99,101,10,37,115,115,101,116,32,99,111,110,116,111,117,114,0,0,0,37,66,0,0,0,0,0,0,120,121,0,0,0,0,0,0,41,59,10,0,0,0,0,0,98,97,99,107,0,0,0,0,109,105,110,105,109,117,109,32,111,102,32,52,32,99,111,114,110,101,114,115,10,0,0,0,71,114,97,121,32,115,99,97,108,101,32,110,111,116,32,115,111,114,116,101,100,32,105,110,32,103,114,97,100,105,101,110,116,46,0,0,0,0,0,0,101,113,117,97,108,32,120,121,122,0,0,0,0,0,0,0,37,100,46,32,37,100,46,32,37,48,52,100,32,37,100,58,37,48,50,100,0,0,0,0,110,111,104,101,97,100,0,0,108,101,0,0,0,0,0,0,48,120,37,48,54,120,0,0,44,100,101,110,115,105,116,121,40,48,41,0,0,0,0,0,102,114,111,110,116,0,0,0,114,101,36,114,101,97,100,0,109,101,100,105,97,110,32,111,102,32,52,32,99,111,114,110,101,114,115,10,0,0,0,0,78,111,32,118,97,108,105,100,32,112,97,108,101,116,116,101,32,102,111,117,110,100,0,0,83,84,65,84,83,95,0,0,101,113,117,97,108,32,120,121,0,0,0,0,0,0,0,0,37,100,58,37,48,50,100,0,98,105,36,110,100,0,0,0,73,110,116,101,114,110,97,108,32,101,114,114,111,114,32,40,100,97,116,97,102,105,108,101,46,99,41,58,32,85,110,107,110,111,119,110,32,112,108,111,116,32,109,111,100,101,0,0,47,117,115,114,47,108,111,99,97,108,47,98,105,110,0,0,44,112,97,116,116,101,114,110,40,37,100,41,0,0,0,0,121,120,122,0,0,0,0,0,110,111,98,101,110,116,36,111,118,101,114,0,0,0,0,0,103,101,111,109,101,116,114,105,99,97,108,32,109,101,97,110,32,111,102,32,52,32,99,111,114,110,101,114,115,10,0,0,105,110,118,97,108,105,100,32,111,112,116,105,111,110,0,0,66,97,100,32,100,97,116,97,32,111,110,32,108,105,110,101,32,37,100,0,0,0,0,0,10,115,101,116,32,118,105,101,119,32,32,37,115,0,0,0,37,100,46,32,37,100,46,32,37,48,52,100,0,0,0,0,84,104,114,101,101,45,100,105,109,101,110,115,105,111,110,97,108,32,116,117,112,108,101,32,114,101,113,117,105,114,101,100,32,102,111,114,32,115,101,116,116,105,110,103,32,98,105,110,97,114,121,32,112,97,114,97,109,101,116,101,114,115,0,0,109,97,116,36,114,105,120,0,110,111,98,111,114,100,101,114,10,0,0,0,0,0,0,0,116,104,105,115,95,112,108,111,116,32,61,61,32,42,116,112,95,51,100,95,112,116,114,0,67,97,110,110,111,116,32,101,120,112,97,110,100,32,101,109,112,116,121,32,112,97,116,104,0,0,0,0,0,0,0,0,124,0,0,0,0,0,0,0,71,80,70,85,78,95,0,0,44,100,101,110,115,105,116,121,40,37,46,50,102,41,0,0,98,101,110,116,36,111,118,101,114,0,0,0,0,0,0,0,85,112,0,0,0,0,0,0,97,118,101,114,97,103,101,100,32,52,32,99,111,114,110,101,114,115,10,0,0,0,0,0,112,109,51,100,32,103,114,97,100,105,101,110,116,0,0,0,37,103,44,32,37,103,44,32,37,103,44,32,37,103,0,0,99,97,110,32,111,110,108,121,32,100,111,32,98,101,115,115,101,108,32,102,117,110,99,116,105,111,110,115,32,111,102,32,114,101,97,108,115,0,0,0,70,105,114,115,116,32,112,97,114,97,109,101,116,101,114,32,116,111,32,115,112,114,105,110,116,102,32,109,117,115,116,32,98,101,32,97,32,102,111,114,109,97,116,32,115,116,114,105,110,103,0,0,0,0,0,0,84,104,114,101,101,45,100,105,109,101,110,115,105,111,110,97,108,32,116,117,112,108,101,32,114,101,113,117,105,114,101,100,32,102,111,114,32,51,68,32,112,108,111,116,0,0,0,0,44,116,114,97,110,115,112,97,114,101,110,116,0,0,0,0,110,111,97,108,116,36,100,105,97,103,111,110,97,108,0,0,9,113,117,97,100,114,97,110,103,108,101,32,99,111,108,111,114,32,97,99,99,111,114,100,105,110,103,32,116,111,32,0,103,114,97,100,105,101,110,116,0,0,0,0,0,0,0,0,84,119,111,45,100,105,109,101,110,115,105,111,110,97,108,32,116,117,112,108,101,32,114,101,113,117,105,114,101,100,32,102,111,114,32,50,68,32,112,108,111,116,0,0,0,0,0,0,104,105,100,100,101,110,32,116,104,101,115,101,95,112,111,108,121,115,0,0,0,0,0,0,88,114,105,103,104,116,89,117,112,0,0,0,0,0,0,0,103,112,95,102,105,108,108,40,112,0,0,0,0,0,0,0,97,108,116,36,100,105,97,103,111,110,97,108,0,0,0,0,9,115,116,101,112,115,32,102,111,114,32,98,105,108,105,110,101,97,114,32,105,110,116,101,114,112,111,108,97,116,105,111,110,58,32,37,100,44,37,100,10,0,0,0,0,0,0,0,76,101,115,115,32,116,104,97,110,32,51,32,117,115,105,110,103,32,115,112,101,99,115,32,102,111,114,32,112,97,108,101,116,116,101,0,0,0,0,0,115,101,116,32,118,105,101,119,32,0,0,0,0,0,0,0,44,32,40,117,110,100,101,102,105,110,101,100,41,47,0,0,99,117,116,101,32,108,105,116,116,108,101,32,101,108,108,105,112,115,101,32,102,111,114,32,116,104,101,32,107,101,121,32,115,97,109,112,108,101,0,0,78,117,109,98,101,114,32,111,102,32,98,121,116,101,115,32,116,111,32,115,107,105,112,32,109,117,115,116,32,98,101,32,112,111,115,105,116,105,118,101,32,105,110,116,101,103,101,114,0,0,0,0,0,0,0,0,45,45,99,121,99,108,101,59,10,0,0,0,0,0,0,0,110,111,117,110,100,36,101,102,105,110,101,100,0,0,0,0,9,112,109,51,100,45,104,105,100,100,101,110,51,100,32,105,115,32,37,115,10,0,0,0,117,110,115,101,116,32,100,101,99,105,109,97,108,115,105,103,110,10,0,0,0,0,0,0,111,102,102,36,115,101,116,0,115,99,97,36,108,101,0,0,73,109,112,114,111,112,101,114,32,115,99,97,110,110,105,110,103,32,115,116,114,105,110,103,46,32,84,114,121,32,50,32,99,104,97,114,97,99,116,101,114,32,115,116,114,105,110,103,32,102,111,114,32,50,68,32,100,97,116,97,0,0,0,0,117,112,36,119,97,114,100,115,0,0,0,0,0,0,0,0,100,111,119,110,36,119,97,114,100,115,0,0,0,0,0,0,114,111,119,36,115,102,105,114,115,116,0,0,0,0,0,0,99,111,108,36,117,109,110,115,102,105,114,115,116,0,0,0,115,105,110,40,57,48,120,41,0,0,0,0,0,0,0,0,79,114,105,103,105,110,32,105,115,32,97,116,32,40,37,102,44,37,102,41,0,0,0,0,45,45,40,37,46,51,102,97,44,37,46,51,102,97,41,0,46,92,34,71,78,85,80,76,79,84,58,32,71,82,79,70,70,32,112,105,99,116,117,114,101,32,117,115,105,110,103,32,116,104,101,32,103,112,105,99,32,112,114,101,112,114,111,99,101,115,115,111,114,10,0,0,117,110,100,101,102,36,105,110,101,100,0,0,0,0,0,0,46,80,69,10,0,0,0,0,9,112,109,51,100,45,104,105,100,100,101,110,51,100,32,105,115,32,111,110,32,97,110,100,32,119,105,108,108,32,117,115,101,32,108,105,110,101,115,116,121,108,101,32,37,100,10,0,69,120,112,101,99,116,101,100,32,99,111,109,109,97,0,0,115,101,116,32,100,101,99,105,109,97,108,115,105,103,110,32,39,37,115,39,10,0,0,0,120,61,37,102,59,32,121,61,37,102,10,0,0,0,0,0,47,40,117,110,100,101,102,105,110,101,100,41,0,0,0,0,46,80,83,32,37,102,32,37,102,10,0,0,0,0,0,0,109,111,118,101,32,116,111,32,40,120,43,37,102,44,121,43,37,102,41,10,0,0,0,0,73,109,112,114,111,112,101,114,32,115,99,97,110,110,105,110,103,32,115,116,114,105,110,103,46,32,84,114,121,32,51,32,99,104,97,114,97,99,116,101,114,32,115,116,114,105,110,103,32,102,111,114,32,51,68,32,100,97,116,97,0,0,0,0,100,97,115,104,101,100,32,48,46,48,55,53,0,0,0,0,100,97,115,104,101,100,32,48,46,48,53,0,0,0,0,0,100,111,116,116,101,100,0,0,116,104,105,99,107,110,101,115,115,32,49,46,48,0,0,0,32,92,10,32,32,32,116,104,101,110,32,116,111,32,40,120,43,37,102,44,121,43,37,102,41,0,0,0,0,0,0,0,10,32,32,0,0,0,0,0,108,105,110,101,32,37,115,32,116,111,32,40,120,43,37,102,44,121,43,37,102,41,0,0,116,114,105,36,97,110,103,108,101,112,97,116,116,101,114,110,0,0,0,0,0,0,0,0,97,116,32,120,43,37,102,44,121,43,37,102,10,0,0,0,97,108,108,32,52,32,112,111,105,110,116,115,32,111,102,32,116,104,101,32,113,117,97,100,114,97,110,103,108,101,32,105,110,32,120,44,121,32,114,97,110,103,101,115,10,0,0,0,110,111,116,32,101,110,111,117,103,104,32,109,101,109,111,114,121,32,102,111,114,32,102,117,110,99,116,105,111,110,0,0,115,101,116,32,100,101,99,105,109,97,108,115,105,103,110,32,108,111,99,97,108,101,32,34,37,115,34,10,0,0,0,0,114,106,117,115,116,32,0,0,108,106,117,115,116,32,0,0,67,97,110,110,111,116,32,97,108,116,101,114,32,115,99,97,110,110,105,110,103,32,109,101,116,104,111,100,32,102,111,114,32,111,110,101,45,100,105,109,101,110,115,105,111,110,97,108,32,100,97,116,97,0,0,0,59,32,114,101,115,101,116,32,108,105,110,101,119,105,100,10,0,0,0,0,0,0,0,0,84,111,111,32,109,97,110,121,32,114,97,110,103,101,45,115,112,101,99,115,32,102,111,114,32,97,32,37,100,45,118,97,114,105,97,98,108,101,32,102,105,116,0,0,0,0,0,0,108,105,110,101,32,102,114,111,109,32,120,43,37,102,44,121,43,37,102,32,116,111,32,120,43,37,102,44,121,43,37,102,10,0,0,0,0,0,0,0,97,114,114,111,119,104,101,97,100,61,55,59,32,97,114,114,111,119,32,102,114,111,109,32,120,43,37,102,44,121,43,37,102,32,116,111,32,120,43,37,102,44,121,43,37,102,10,0,49,54,0,0,0,0,0,0,27,91,114,27,91,50,52,59,49,72,0,0,0,0,0,0,40,37,46,51,102,97,44,37,46,51,102,97,41,0,0,0,27,91,50,74,27,91,50,52,59,49,72,0,0,0,0,0,110,111,111,102,102,36,115,101,116,0,0,0,0,0,0,0,27,92,27,91,50,52,59,49,72,0,0,0,0,0,0,0,97,116,32,108,101,97,115,116,32,49,32,112,111,105,110,116,32,111,102,32,116,104,101,32,113,117,97,100,114,97,110,103,108,101,32,105,110,32,120,44,121,32,114,97,110,103,101,115,10,0,0,0,0,0,0,0,115,101,116,32,112,111,105,110,116,115,105,122,101,32,37,103,10,115,101,116,32,112,111,105,110,116,105,110,116,101,114,118,97,108,98,111,120,32,37,103,10,115,101,116,32,101,110,99,111,100,105,110,103,32,37,115,10,37,115,115,101,116,32,112,111,108,97,114,10,37,115,115,101,116,32,112,97,114,97,109,101,116,114,105,99,10,0,0,27,91,50,74,27,80,49,112,83,40,67,48,41,83,40,69,41,84,40,65,48,41,10,0,80,91,37,100,44,37,100,93,10,0,0,0,0,0,0,0,118,91,93,118,91,37,100,44,37,100,93,10,0,0,0,0,122,90,0,0,0,0,0,0,87,40,80,37,100,41,10,0,87,40,73,37,100,41,10,0,37,97,0,0,0,0,0,0,84,40,68,48,44,83,49,41,10,0,0,0,0,0,0,0,10,37,115,37,115,10,0,0,84,40,68,57,48,44,83,49,41,10,0,0,0,0,0,0,67,111,109,109,97,110,100,32,39,117,110,115,101,116,32,104,105,115,116,111,114,121,115,105,122,101,39,32,114,101,113,117,105,114,101,115,32,104,105,115,116,111,114,121,32,115,117,112,112,111,114,116,46,0,0,0,100,101,112,114,101,99,97,116,101,100,32,115,121,110,116,97,120,44,32,117,115,101,32,34,117,110,115,101,116,34,0,0,27,77,71,49,27,82,75,33,27,83,75,33,27,76,90,27,37,37,33,49,0,0,0,0,112,32,58,61,32,0,0,0,27,37,37,33,48,27,77,78,48,27,77,67,66,55,67,59,27,77,81,49,27,77,84,49,0,0,0,0,0,0,0,0,27,37,37,33,48,27,76,90,27,37,37,33,49,0,0,0,9,99,108,105,112,112,105,110])
.concat([103,58,32,0,0,0,0,0,78,97,109,101,100,32,99,111,108,111,114,115,32,119,105,108,108,32,112,114,111,100,117,99,101,32,115,116,114,97,110,103,101,32,114,101,115,117,108,116,115,32,105,102,32,110,111,116,32,105,110,32,99,111,108,111,114,32,109,111,100,101,32,82,71,66,46,0,0,0,0,0,115,101,116,32,111,102,102,115,101,116,115,0,0,0,0,0,27,76,86,49,27,37,37,33,49,0,0,0,0,0,0,0,27,37,37,33,48,27,12,27,76,86,48,0,0,0,0,0,27,76,70,0,0,0,0,0,121,89,0,0,0,0,0,0,115,106,36,105,115,0,0,0,27,76,71,0,0,0,0,0,103,101,0,0,0,0,0,0,37,52,100,32,0,0,0,0,27,77,86,0,0,0,0,0,27,77,76,0,0,0,0,0,27,77,76,63,0,0,0,0,37,108,102,32,44,32,37,108,102,32,37,99,0,0,0,0,27,77,76,53,0,0,0,0,32,32,99,108,105,112,32,99,117,114,114,101,110,116,112,105,99,116,117,114,101,32,116,111,32,117,110,105,116,115,113,117,97,114,101,32,120,121,115,99,97,108,101,100,32,40,37,46,51,102,97,44,37,46,51,102,97,41,32,115,104,105,102,116,101,100,32,40,37,46,51,102,97,44,37,46,51,102,97,41,59,41,59,10,0,0,0,0,27,76,84,0,0,0,0,0,100,101,102,36,97,117,108,116,115,0,0,0,0,0,0,0,114,101,112,36,108,111,116,0,27,77,82,69,58,48,0,0,9,102,108,117,115,104,105,110,103,32,116,114,105,97,110,103,108,101,115,32,97,114,101,32,37,115,100,114,97,119,110,10,0,0,0,0,0,0,0,0,105,110,118,97,108,105,100,32,112,97,108,101,116,116,101,32,111,112,116,105,111,110,0,0,69,120,112,101,99,116,105,110,103,32,91,110,111,93,111,117,116,112,117,116,32,111,114,32,112,114,101,102,105,120,0,0,115,101,116,32,108,111,103,115,99,97,108,101,32,37,115,32,37,103,10,0,0,0,0,0,27,77,82,48,48,0,0,0,27,76,72,0,0,0,0,0,27,77,77,0,0,0,0,0,120,88,0,0,0,0,0,0,31,37,115,10,0,0,0,0,27,91,63,51,56,108,0,0,35,33,37,115,47,103,110,117,112,108,111,116,10,35,10,0,96,97,96,97,98,99,100,104,105,106,107,108,0,0,0,0,31,27,3,0,0,0,0,0,67,111,109,109,97,110,100,32,39,115,101,116,32,104,105,115,116,111,114,121,115,105,122,101,39,32,114,101,113,117,105,114,101,115,32,104,105,115,116,111,114,121,32,115,117,112,112,111,114,116,46,0,0,0,0,0,100,114,97,119,32,98,105,116,109,97,112,105,109,97,103,101,32,40,37,117,44,37,117,44,105,109,103,41,32,120,121,115,99,97,108,101,100,32,40,37,46,51,102,97,44,37,46,51,102,97,41,32,115,104,105,102,116,101,100,32,40,37,46,51,102,97,44,37,46,51,102,97,41,59,10,0,0,0,0,0,27,12,0,0,0,0,0,0,110,111,32,109,97,116,99,104,105,110,103,32,39,125,39,0,122,36,101,114,111,0,0,0,121,122,120,0,0,0,0,0,56,57,58,59,0,0,0,0,69,78,68,0,0,0,0,0,112,97,114,97,36,108,108,101,108,0,0,0,0,0,0,0,110,111,110,45,110,101,103,97,116,105,118,101,32,110,117,109,98,101,114,32,114,101,113,117,105,114,101,100,0,0,0,0,117,110,115,101,116,32,108,111,103,115,99,97,108,101,10,0,27,37,99,0,0,0,0,0,27,91,63,51,56,104,0,0,116,105,116,108,101,0,0,0,67,97,110,32,111,110,108,121,32,102,108,105,112,32,120,44,32,121,44,32,97,110,100,47,111,114,32,122,0,0,0,0,32,101,109,112,116,121,32,0,106,115,36,100,105,114,0,0,102,115,105,122,101,0,0,0,97,120,36,101,115,0,0,0,32,106,115,100,105,114,32,34,37,115,34,0,0,0,0,0,47,98,105,110,47,115,104,0,38,38,0,0,0,0,0,0,32,116,105,116,108,101,32,34,37,115,34,0,0,0,0,0,118,97,114,110,97,109,101,0,32,109,111,117,115,105,110,103,0,0,0,0,0,0,0,0,100,114,97,119,32,105,109,97,103,101,40,10,32,32,0,0,32,115,116,97,110,100,97,108,111,110,101,0,0,0,0,0,114,97,120,36,105,115,0,0,32,110,97,109,101,32,34,37,115,34,0,0,0,0,0,0,115,119,97,112,112,101,100,32,112,100,112,32,40,100,105,109,109,108,101,41,0,0,0,0,66,69,71,73,78,0,0,0,85,110,107,110,111,119,110,32,99,111,108,111,114,32,109,111,100,101,108,46,0,0,0,0,37,115,10,0,0,0,0,0,116,105,116,108,101,32,0,0,32,102,111,110,116,115,99,97,108,101,32,37,103,0,0,0,9,99,117,114,114,101,110,116,32,116,101,114,109,105,110,97,108,32,116,121,112,101,32,105,115,32,117,110,107,110,111,119,110,10,0,0,0,0,0,0,77,79,85,83,69,95,67,84,82,76,0,0,0,0,0,0,32,101,110,104,97,110,99,101,100,0,0,0,0,0,0,0,115,112,114,105,110,116,102,32,97,114,103,115,0,0,0,0,37,115,32,102,115,105,122,101,32,37,103,32,108,119,32,37,103,0,0,0,0,0,0,0,120,88,121,89,122,90,0,0,32,115,105,122,101,32,37,100,44,37,100,0,0,0,0,0,32,98,117,116,116,0,0,0,32,114,111,117,110,100,101,100,0,0,0,0,0,0,0,0,32,100,97,115,104,108,101,110,103,116,104,32,37,51,46,49,102,0,0,0,0,0,0,0,32,115,111,108,105,100,0,0,105,109,97,32,58,61,32,34,37,37,10,0,0,0,0,0,102,111,110,116,58,32,101,120,112,101,99,116,105,110,103,32,115,116,114,105,110,103,0,0,122,101,114,111,97,36,120,105,115,0,0,0,0,0,0,0,105,108,108,101,103,97,108,32,106,97,118,97,115,99,114,105,112,116,32,102,117,110,99,116,105,111,110,32,110,97,109,101,0,0,0,0,0,0,0,0,102,108,117,115,104,101,100,32,102,114,111,109,32,37,115,10,0,0,0,0,0,0,0,0,69,120,112,101,99,116,101,100,32,99,111,108,111,114,32,109,111,100,101,108,46,0,0,0,99,111,108,117,109,110,115,116,97,99,107,101,100,32,0,0,101,120,112,101,99,116,105,110,103,32,97,32,106,97,118,97,115,99,114,105,112,116,32,102,117,110,99,116,105,111,110,32,110,97,109,101,0,0,0,0,77,79,85,83,69,95,65,76,84,0,0,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,97,110,32,72,84,77,76,32,116,105,116,108,101,32,115,116,114,105,110,103,0,0,60,47,100,105,118,62,10,10,60,47,98,111,100,121,62,10,60,47,104,116,109,108,62,10,0,0,0,0,0,0,0,0,70,108,105,112,112,105,110,103,32,100,105,109,101,110,115,105,111,110,32,100,105,114,101,99,116,105,111,110,32,109,117,115,116,32,98,101,32,49,32,111,114,32,48,0,0,0,0,0,60,47,116,100,62,60,47,116,114,62,60,47,116,97,98,108,101,62,10,0,0,0,0,0,104,105,100,100,101,110,32,110,111,114,116,104,95,112,111,108,121,115,0,0,0,0,0,0,60,116,97,98,108,101,32,99,108,97,115,115,61,34,112,108,111,116,34,62,10,60,116,114,62,60,116,100,62,10,32,32,32,32,60,99,97,110,118,97,115,32,105,100,61,34,103,110,117,112,108,111,116,95,99,97,110,118,97,115,34,32,119,105,100,116,104,61,34,37,100,34,32,104,101,105,103,104,116,61,34,37,100,34,32,116,97,98,105,110,100,101,120,61,34,48,34,62,10,9,83,111,114,114,121,44,32,121,111,117,114,32,98,114,111,119,115,101,114,32,115,101,101,109,115,32,110,111,116,32,116,111,32,115,117,112,112,111,114,116,32,116,104,101,32,72,84,77,76,32,53,32,99,97,110,118,97,115,32,101,108,101,109,101,110,116,10,32,32,32,32,60,47,99,97,110,118,97,115,62,10,60,47,116,100,62,60,47,116,114,62,10,60,47,116,97,98,108,101,62,10,0,0,0,0,0,0,0,60,47,116,100,62,60,116,100,62,10,0,0,0,0,0,0,103,110,117,112,108,111,116,95,99,111,110,116,111,117,114,0,60,47,116,97,98,108,101,62,60,47,116,100,62,60,47,116,114,62,10,60,47,116,97,98,108,101,62,10,0,0,0,0,60,116,114,62,32,60,116,100,32,99,108,97,115,115,61,34,109,98,48,34,62,121,50,38,110,98,115,112,59,60,47,116,100,62,32,60,116,100,32,99,108,97,115,115,61,34,109,98,49,34,62,60,115,112,97,110,32,105,100,61,34,103,110,117,112,108,111,116,95,99,97,110,118,97,115,95,121,50,34,62,38,110,98,115,112,59,60,47,115,112,97,110,62,60,47,116,100,62,32,60,47,116,114,62,10,0,0,0,0,0,0,0,60,116,114,62,32,60,116,100,32,99,108,97,115,115,61,34,109,98,48,34,62,120,50,38,110,98,115,112,59,60,47,116,100,62,32,60,116,100,32,99,108,97,115,115,61,34,109,98,49,34,62,60,115,112,97,110,32,105,100,61,34,103,110,117,112,108,111,116,95,99,97,110,118,97,115,95,120,50,34,62,38,110,98,115,112,59,60,47,115,112,97,110,62,60,47,116,100,62,32,60,47,116,114,62,10,0,0,0,0,0,0,0,37,48,50,120,0,0,0,0,88,114,105,103,104,116,89,100,111,119,110,0,0,0,0,0,122,122,101,114,111,97,36,120,105,115,0,0,0,0,0,0,60,116,97,98,108,101,32,99,108,97,115,115,61,34,109,111,117,115,101,98,111,120,34,32,105,100,61,34,103,110,117,112,108,111,116,95,109,111,117,115,101,98,111,120,34,32,98,111,114,100,101,114,61,49,62,10,60,116,114,62,32,60,116,100,32,99,108,97,115,115,61,34,109,98,48,34,62,120,38,110,98,115,112,59,60,47,116,100,62,32,60,116,100,32,99,108,97,115,115,61,34,109,98,49,34,62,60,115,112,97,110,32,105,100,61,34,103,110,117,112,108,111,116,95,99,97,110,118,97,115,95,120,34,62,38,110,98,115,112,59,60,47,115,112,97,110,62,60,47,116,100,62,32,60,47,116,114,62,10,60,116,114,62,32,60,116,100,32,99,108,97,115,115,61,34,109,98,48,34,62,121,38,110,98,115,112,59,60,47,116,100,62,32,60,116,100,32,99,108,97,115,115,61,34,109,98,49,34,62,60,115,112,97,110,32,105,100,61,34,103,110,117,112,108,111,116,95,99,97,110,118,97,115,95,121,34,62,38,110,98,115,112,59,60,47,115,112,97,110,62,60,47,116,100,62,32,60,47,116,114,62,10,0,0,67,69,78,84,69,82,69,68,10,0,0,0,0,0,0,0,115,97,116,36,117,114,97,116,105,111,110,0,0,0,0,0,114,111,119,115,116,97,99,107,101,100,32,0,0,0,0,0,35,35,32,0,0,0,0,0,32,32,32,32,32,32,60,47,116,97,98,108,101,62,10,32,32,60,47,116,100,62,60,47,116,114,62,10,60,47,116,97,98,108,101,62,60,47,116,100,62,60,47,116,114,62,60,116,114,62,60,116,100,32,99,108,97,115,115,61,34,109,111,117,115,101,98,111,120,34,62,10,0,0,0,0,0,0,0,0,77,79,85,83,69,95,83,72,73,70,84,0,0,0,0,0,9,60,47,116,114,62,10,0,9,32,32,60,116,100,32,99,108,97,115,115,61,34,105,99,111,110,34,32,62,32,60,47,116,100,62,10,0,0,0,0,83,97,109,112,108,101,32,112,101,114,105,111,100,32,109,117,115,116,32,98,101,32,112,111,115,105,116,105,118,101,46,32,84,114,121,32,96,102,108,105,112,96,32,102,111,114,32,99,104,97,110,103,105,110,103,32,100,105,114,101,99,116,105,111,110,0,0,0,0,0,0,0,84,104,105,115,32,116,101,114,109,105,110,97,108,32,100,111,101,115,32,110,111,116,32,115,117,112,112,111,114,116,32,102,105,108,108,101,100,32,112,111,108,121,103,111,110,115,0,0,9,32,32,60,116,100,32,99,108,97,115,115,61,34,105,99,111,110,34,32,111,110,99,108,105,99,107,61,103,110,117,112,108,111,116,46,116,111,103,103,108,101,95,112,108,111,116,40,34,103,112,95,112,108,111,116,95,37,100,34,41,62,37,100,60,47,116,100,62,10,0,0,112,97,114,97,109,101,116,101,114,32,116,111,32,96,112,109,51,100,32,97,116,96,32,114,101,113,117,105,114,101,115,32,99,111,109,98,105,110,97,116,105,111,110,32,111,102,32,117,112,32,116,111,32,54,32,99,104,97,114,97,99,116,101,114,115,32,98,44,115,44,116,10,9,40,100,114,97,119,105,110,103,32,97,116,32,98,111,116,116,111,109,44,32,115,117,114,102,97,99,101,44,32,116,111,112,41,0,0,0,0,0,0,9,60,116,114,62,10,0,0,60,116,97,98,108,101,32,99,108,97,115,115,61,34,109,98,108,101,102,116,34,62,60,116,114,62,60,116,100,32,99,108,97,115,115,61,34,109,111,117,115,101,98,111,120,34,62,10,60,116,97,98,108,101,32,99,108,97,115,115,61,34,109,111,117,115,101,98,111,120,34,32,98,111,114,100,101,114,61,48,62,10,32,32,60,116,114,62,60,116,100,32,99,108,97,115,115,61,34,109,111,117,115,101,98,111,120,34,62,10,32,32,32,32,60,116,97,98,108,101,32,99,108,97,115,115,61,34,109,111,117,115,101,98,111,120,34,32,105,100,61,34,103,110,117,112,108,111,116,95,109,111,117,115,101,98,111,120,34,32,98,111,114,100,101,114,61,48,62,10,32,32,32,32,60,116,114,62,60,116,100,32,99,108,97,115,115,61,34,109,98,104,34,62,60,47,116,100,62,60,47,116,114,62,10,32,32,32,32,60,116,114,62,60,116,100,32,99,108,97,115,115,61,34,109,98,104,34,62,10,32,32,32,32,32,32,60,116,97,98,108,101,32,99,108,97,115,115,61,34,109,111,117,115,101,98,111,120,34,62,10,9,60,116,114,62,10,9,32,32,60,116,100,32,99,108,97,115,115,61,34,105,99,111,110,34,62,60,47,116,100,62,10,9,32,32,60,116,100,32,99,108,97,115,115,61,34,105,99,111,110,34,32,111,110,99,108,105,99,107,61,103,110,117,112,108,111,116,46,116,111,103,103,108,101,95,103,114,105,100,62,60,105,109,103,32,115,114,99,61,34,37,115,103,114,105,100,46,112,110,103,34,32,105,100,61,34,103,110,117,112,108,111,116,95,103,114,105,100,95,105,99,111,110,34,32,99,108,97,115,115,61,34,105,99,111,110,45,105,109,97,103,101,34,32,97,108,116,61,34,35,34,32,116,105,116,108,101,61,34,116,111,103,103,108,101,32,103,114,105,100,34,62,60,47,116,100,62,10,9,32,32,60,116,100,32,99,108,97,115,115,61,34,105,99,111,110,34,32,111,110,99,108,105,99,107,61,103,110,117,112,108,111,116,46,117,110,122,111,111,109,62,60,105,109,103,32,115,114,99,61,34,37,115,112,114,101,118,105,111,117,115,122,111,111,109,46,112,110,103,34,32,105,100,61,34,103,110,117,112,108,111,116,95,117,110,122,111,111,109,95,105,99,111,110,34,32,99,108,97,115,115,61,34,105,99,111,110,45,105,109,97,103,101,34,32,97,108,116,61,34,117,110,122,111,111,109,34,32,116,105,116,108,101,61,34,117,110,122,111,111,109,34,62,60,47,116,100,62,10,9,32,32,60,116,100,32,99,108,97,115,115,61,34,105,99,111,110,34,32,111,110,99,108,105,99,107,61,103,110,117,112,108,111,116,46,114,101,122,111,111,109,62,60,105,109,103,32,115,114,99,61,34,37,115,110,101,120,116,122,111,111,109,46,112,110,103,34,32,105,100,61,34,103,110,117,112,108,111,116,95,114,101,122,111,111,109,95,105,99,111,110,34,32,99,108,97,115,115,61,34,105,99,111,110,45,105,109,97,103,101,34,32,97,108,116,61,34,114,101,122,111,111,109,34,32,116,105,116,108,101,61,34,114,101,122,111,111,109,34,62,60,47,116,100,62,10,9,32,32,60,116,100,32,99,108,97,115,115,61,34,105,99,111,110,34,32,111,110,99,108,105,99,107,61,103,110,117,112,108,111,116,46,116,111,103,103,108,101,95,122,111,111,109,95,116,101,120,116,62,60,105,109,103,32,115,114,99,61,34,37,115,116,101,120,116,122,111,111,109,46,112,110,103,34,32,105,100,61,34,103,110,117,112,108,111,116,95,116,101,120,116,122,111,111,109,95,105,99,111,110,34,32,99,108,97,115,115,61,34,105,99,111,110,45,105,109,97,103,101,34,32,97,108,116,61,34,122,111,111,109,32,116,101,120,116,34,32,116,105,116,108,101,61,34,122,111,111,109,32,116,101,120,116,32,119,105,116,104,32,112,108,111,116,34,62,60,47,116,100,62,10,9,32,32,60,116,100,32,99,108,97,115,115,61,34,105,99,111,110,34,32,111,110,99,108,105,99,107,61,103,110,117,112,108,111,116,46,112,111,112,117,112,95,104,101,108,112,40,41,62,60,105,109,103,32,115,114,99,61,34,37,115,104,101,108,112,46,112,110,103,34,32,105,100,61,34,103,110,117,112,108,111,116,95,104,101,108,112,95,105,99,111,110,34,32,99,108,97,115,115,61,34,105,99,111,110,45,105,109,97,103,101,34,32,97,108,116,61,34,63,34,32,116,105,116,108,101,61,34,104,101,108,112,34,62,60,47,116,100,62,10,9,60,47,116,114,62,10,0,0,0,0,0,60,47,115,99,114,105,112,116,62,10,60,108,105,110,107,32,116,121,112,101,61,34,116,101,120,116,47,99,115,115,34,32,104,114,101,102,61,34,37,115,103,110,117,112,108,111,116,95,109,111,117,115,101,46,99,115,115,34,32,114,101,108,61,34,115,116,121,108,101,115,104,101,101,116,34,62,10,60,47,104,101,97,100,62,10,60,98,111,100,121,32,111,110,108,111,97,100,61,34,103,110,117,112,108,111,116,95,99,97,110,118,97,115,40,41,59,32,103,110,117,112,108,111,116,46,105,110,105,116,40,41,59,34,32,111,110,99,111,110,116,101,120,116,109,101,110,117,61,34,114,101,116,117,114,110,32,102,97,108,115,101,59,34,62,10,10,60,100,105,118,32,99,108,97,115,115,61,34,103,110,117,112,108,111,116,34,62,10,0,0,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,116,105,109,101,97,120,105,115,95,120,32,61,32,34,34,59,10,0,0,34,59,10,0,0,0,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,116,105,109,101,97,120,105,115,95,120,32,61,32,34,37,115,34,59,10,0,0,0,0,0,0,0,0,121,50,122,101,114,111,97,36,120,105,115,0,0,0,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,97,120,105,115,95,120,109,97,120,32,61,32,37,46,51,102,59,10,0,9,115,117,98,115,101,113,117,101,110,116,32,115,99,97,110,115,32,119,105,116,104,32,100,105,102,102,101,114,101,110,116,32,110,98,32,111,102,32,112,116,115,32,97,114,101,32,0,99,121,99,36,108,101,115,0,101,114,114,111,114,98,97,114,115,32,103,97,112,32,37,100,32,108,119,32,37,103,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,97,120,105,115,95,120,109,105,110,32,61,32,37,46,51,102,59,10,0,77,79,85,83,69,95,89,50,0,0,0,0,0,0,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,97,120,105,115,95,104,101,105,103,104,116,32,61,32,103,110,117,112,108,111,116,46,112,108,111,116,95,97,120,105,115,95,121,109,97,120,32,45,32,103,110,117,112,108,111,116,46,112,108,111,116,95,97,120,105,115,95,121,109,105,110,59,10,0,0,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,97,120,105,115,95,119,105,100,116,104,32,61,32,103,110,117,112,108,111,116,46,112,108,111,116,95,97,120,105,115,95,120,109,97,120,32,45,32,103,110,117,112,108,111,116,46,112,108,111,116,95,97,120,105,115,95,120,109,105,110,59,10,0,0,0,0,0,77,111,114,101,32,112,97,114,97,109,101,116,101,114,115,32,115,112,101,99,105,102,105,101,100,32,116,104,97,110,32,100,97,116,97,32,114,101,99,111,114,100,115,32,115,112,101,99,105,102,105,101,100,0,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,108,111,103,97,120,105,115,95,114,32,61,32,37,100,59,10,0,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,108,111,103,97,120,105,115,95,121,32,61,32,37,100,59,10,0,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,108,111,103,97,120,105,115,95,120,32,61,32,37,100,59,10,0,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,97,120,105,115,95,121,50,109,105,110,32,61,32,34,110,111,110,101,34,10,0,0,0,0,0,0,0,57,48,32,109,117,108,32,115,105,110,0,0,0,0,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,97,120,105,115,95,121,50,109,97,120,0,37,48,50,120,37,48,50,120,37,48,50,120,0,0,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,97,120,105,115,95,121,50,109,105,110,0,121,122,101,114,111,97,36,120,105,115,0,0,0,0,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,97,120,105,115,95,120,50,109,105,110,32,61,32,34,110,111,110,101,34,10,0,0,0,0,0,0,0,9,116,97,107,105,110,103,32,115,99,97,110,115,32,100,105,114,101,99,116,105,111,110,32,97,117,116,111,109,97,116,105,99,97,108,108,121,10,0,0,99,108,117,115,116,101,114,101,100,32,103,97,112,32,37,100,32,0,0,0,0,0,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,97,120,105,115,95,120,50,109,97,120,0,101,120,112,97,110,100,105,110,103,32,99,117,114,118,101,32,118,97,114,105,97,98,108,101,32,99,111,108,111,114,115,0,77,79,85,83,69,95,88,50,0,0,0,0,0,0,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,97,120,105,115,95,120,50,109,105,110,0,103,110,117,112,108,111,116,46,112,108,111,116,95,97,120,105,115,95,114,109,105,110,32,61,32,37,103,59,10,0,0,0,67,97,110,110,111,116,32,102,108,105,112,32,97,32,110,111,110,45,101,120,105,115,116,101,110,116,32,100,105,109,101,110,115,105,111,110,0,0,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,97,120,105,115,95,121,109,97,120,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,97,120,105,115,95,121,109,105,110,0,0,103,110,117,112,108,111,116,32,37,115,32,112,97,116,99,104,108,101,118,101,108,32,37,115,10,0,0,0,0,0,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,97,120,105,115,95,120,109,97,120,0,0,37,115,32,61,32,37,103,59,10,0,0,0,0,0,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,97,120,105,115,95,120,109,105,110,0,0,37,37,10,0,0,0,0,0,37,115,32,61,32,37,100,59,10,0,0,0,0,0,0,0,120,50,122,101,114,111,97,36,120,105,115,0,0,0,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,104,101,105,103,104,116,32,61,32,37,46,49,102,59,10,0,0,0,0,66,65,67,75,87,65,82,68,0,0,0,0,0,0,0,0,99,111,108,111,114,32,102,111,114,109,117,108,97,32,111,117,116,32,111,102,32,114,97,110,103,101,32,40,117,115,101,32,96,115,104,111,119,32,112,97,108,101,116,116,101,32,114,103,98,102,111,114,109,117,108,97,101,39,32,116,111,32,100,105,115,112,108,97,121,32,116,104,101,32,114,97,110,103,101,41,0,0,0,0,0,0,0,0,115,101,116,32,115,116,121,108,101,32,104,105,115,116,111,103,114,97,109,32,0,0,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,119,105,100,116,104,32,61,32,37,46,49,102,59,10,0,0,0,0,0,77,79,85,83,69,95,89,0,103,110,117,112,108,111,116,46,112,108,111,116,95,121,116,111,112,32,61,32,37,46,49,102,59,10,0,0,0,0,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,121,98,111,116,32,61,32,37,46,49,102,59,10,0,0,0,0,0,0,70,111,114,109,97,116,32,115,112,101,99,105,102,105,101,114,32,109,117,115,116,32,98,101,103,105,110,32,119,105,116,104,32,39,37,39,0,0,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,120,109,97,120,32,61,32,37,46,49,102,59,10,0,0,0,0,0,0,67,97,110,39,116,32,114,101,45,110,97,109,101,32,39,121,39,32,105,110,32,97,32,111,110,101,45,118,97,114,105,97,98,108,101,32,102,105,116,0,117,110,100,101,102,105,110,101,100,32,118,97,108,117,101,0,103,110,117,112,108,111,116,46,112,108,111,116,95,120,109,105,110,32,61,32,37,46,49,102,59,10,0,0,0,0,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,116,101,114,109,95,121,109,97,120,32,61,32,37,100,59,10,0,0,0,103,110,117,112,108,111,116,46,112,108,111,116,95,116,101,114,109,95,120,109,97,120,32,61,32,37,100,59,10,0,0,0,10,47,47,32,112,108,111,116,32,98,111,117,110,100,97,114,105,101,115,32,97,110,100,32,97,120,105,115,32,115,99,97,108,105,110,103,32,105,110,102,111,114,109,97,116,105,111,110,32,102,111,114,32,109,111,117,115,105,110,103,32,10,0,0,105,109,103,32,58,61,32,34,37,37,10,0,0,0,0,0,67,97,110,118,97,115,84,101,120,116,70,117,110,99,116,105,111,110,115,46,101,110,97,98,108,101,40,99,116,120,41,59,10,99,116,120,46,115,116,114,111,107,101,83,116,121,108,101,32,61,32,34,114,103,98,40,50,49,53,44,50,49,53,44,50,49,53,41,34,59,10,99,116,120,46,108,105,110,101,87,105,100,116,104,32,61,32,37,46,49,103,59,10,10,0,0,120,122,101,114,111,97,36,120,105,115,0,0,0,0,0,0,99,116,120,46,102,105,108,108,83,116,121,108,101,32,61,32,34,37,115,34,59,10,99,116,120,46,102,105,108,108,82,101,99,116,40,48,44,48,44,37,100,44,37,100,41,59,10,0,70,79,82,87,65,82,68,0,99,111,110,102,108,105,99,116,105,110,103,32,111,112,116,105,111,110,115,0,0,0,0,0,99,116,120,46,108,105,110,101,67,97,112,32,61,32,34,37,115,34,59,32,99,116,120,46,108,105,110,101,74,111,105,110,32,61,32,34,37,115,34,59,10,0,0,0,0,0,0,0,77,79,85,83,69,95,88,0,103,110,117,112,108,111,116,46,100,97,115,104,108,101,110,103,116,104,32,61,32,37,100,59,10,0,0,0,0,0,0,0,47,47,32,115,104,111,114,116,32,102,111,114,109,115,32,111,102,32,99,111,109,109,97,110,100,115,32,112,114,111,118,105,100,101,100,32,98,121,32,103,110,117,112,108,111,116,95,99,111,109,109,111,110,46,106,115,10,102,117,110,99,116,105,111,110,32,68,84,32,32,40,100,116,41,32,32,123,103,110,117,112,108,111,116,46,100,97,115,104,116,121,112,101,40,100,116,41,59,125,59,10,102,117,110,99,116,105,111,110,32,68,83,32,32,40,120,44,121,41,32,123,103,110,117,112,108,111,116,46,100,97,115,104,115,116,97,114,116,40,120,44,121,41,59,125,59,10,102,117,110,99,116,105,111,110,32,68,76,32,32,40,120,44,121,41,32,123,103,110,117,112,108,111,116,46,100,97,115,104,115,116,101,112,40,120,44,121,41,59,125,59,10,102,117,110,99,116,105,111,110,32,77,32,32,32,40,120,44,121,41,32,123,105,102,32,40,103,110,117,112,108,111,116,46,112,97,116,116,101,114,110,46,108,101,110,103,116,104,32,62,32,48,41,32,68,83,40,120,44,121,41,59,32,101,108,115,101,32,103,110,117,112,108,111,116,46,77,40,120,44,121,41,59,125,59,10,102,117,110,99,116,105,111,110,32,76,32,32,32,40,120,44,121,41,32,123,105,102,32,40,103,110,117,112,108,111,116,46,112,97,116,116,101,114,110,46,108,101,110,103,116,104,32,62,32,48,41,32,68,76,40,120,44,121,41,59,32,101,108,115,101,32,103,110,117,112,108,111,116,46,76,40,120,44,121,41,59,125,59,10,102,117,110,99,116,105,111,110,32,68,111,116,32,40,120,44,121,41,32,123,103,110,117,112,108,111,116,46,68,111,116,40,120,47,49,48,46,44,121,47,49,48,46,41,59,125,59,10,102,117,110,99,116,105,111,110,32,80,116,32,32,40,78,44,120,44,121,44,119,41,32,123,103,110,117,112,108,111,116,46,80,116,40,78,44,120,47,49,48,46,44,121,47,49,48,46,44,119,47,49,48,46,41,59,125,59,10,102,117,110,99,116,105,111,110,32,82,32,32,32,40,120,44,121,44,119,44,104,41,32,123,103,110,117,112,108,111,116,46,82,40,120,44,121,44,119,44,104,41,59,125,59,10,102,117,110,99,116,105,111,110,32,84,32,32,32,40,120,44,121,44,102,111,110,116,115,105,122,101,44,106,117,115,116,105,102,121,44,115,116,114,105,110,103,41,32,123,103,110,117,112,108,111,116,46,84,40,120,44,121,44,102,111,110,116,115,105,122,101,44,106,117,115,116,105,102,121,44,115,116,114,105,110,103,41,59,125,59,10,102,117,110,99,116,105,111,110,32,84,82,32,32,40,120,44,121,44,97,110,103,108,101,44,102,111,110,116,115,105,122,101,44,106,117,115,116,105,102,121,44,115,116,114,105,110,103,41,32,123,103,110,117,112,108,111,116,46,84,82,40,120,44,121,44,97,110,103,108,101,44,102,111,110,116,115,105,122,101,44,106,117,115,116,105,102,121,44,115,116,114,105,110,103,41,59,125,59,10,102,117,110,99,116,105,111,110,32,98,112,32,32,40,120,44,121,41,32,123,103,110,117,112,108,111,116,46,98,112,40,120,44,121,41,59,125,59,10,102,117,110,99,116,105,111,110,32,99,102,112,32,40,41,32,123,103,110,117,112,108,111,116,46,99,102,112,40,41,59,125,59,10,102,117,110,99,116,105,111,110,32,99,102,115,112,40,41,32,123,103,110,117,112,108,111,116,46,99,102,115,112,40,41,59,125,59,10,10,0,85,110,114,101,99,111,103,110,105,122,101,100,32,98,105,110,97,114,121,32,102,111,114,109,97,116,32,115,112,101,99,105,102,105,99,97,116,105,111,110,0,0,0,0,0,0,0,0,47,47,32,71,110,117,112,108,111,116,32,118,101,114,115,105,111,110,32,37,115,46,37,115,10,0,0,0,0,0,0,0,47,47,32,82,101,105,110,105,116,105,97,108,105,122,101,32,109,111,117,115,101,32,116,114,97,99,107,105,110,103,32,97,110,100,32,122,111,111,109,32,102,111,114,32,116,104,105,115,32,112,97,114,116,105,99,117,108,97,114,32,112,108,111,116,10,105,102,32,40,40,116,121,112,101,111,102,40,103,110,117,112,108,111,116,46,97,99,116,105,118,101,95,112,108,111,116,41,32,61,61,32,34,117,110,100,101,102,105,110,101,100,34,32,124,124,32,103,110,117,112,108,111,116,46,97,99,116,105,118,101,95,112,108,111,116,32,33,61,32,37,115,41,32,32,38,38,32,32,116,121,112,101,111,102,40,103,110,117,112,108,111,116,46,109,111,117,115,101,95,117,112,100,97,116,101,41,32,33,61,32,34,117,110,100,101,102,105,110,101,100,34,41,32,123,10,32,32,103,110,117,112,108,111,116,46,97,99,116,105,118,101,95,112,108,111,116,95,110,97,109,101,32,61,32,34,37,115,34,59,10,32,32,103,110,117,112,108,111,116,46,97,99,116,105,118,101,95,112,108,111,116,32,61,32,37,115,59,10,32,32,99,97,110,118,97,115,46,111,110,109,111,117,115,101,109,111,118,101,32,61,32,103,110,117,112,108,111,116,46,109,111,117,115,101,95,117,112,100,97,116,101,59,10,32,32,99,97,110,118,97,115,46,111,110,109,111,117,115,101,117,112,32,61,32,103,110,117,112,108,111,116,46,122,111,111,109,95,105,110,59,10,32,32,99,97,110,118,97,115,46,111,110,109,111,117,115,101,100,111,119,110,32,61,32,103,110,117,112,108,111,116,46,115,97,118,101,99,108,105,99,107,59,10,32,32,99,97,110,118,97,115,46,111,110,107,101,121,112,114,101,115,115,32,61,32,103,110,117,112,108,111,116,46,100,111,95,104,111,116,107,101,121,59,10,32,32,105,102,32,40,99,97,110,118,97,115,46,97,116,116,97,99,104,69,118,101,110,116,41,32,123,99,97,110,118,97,115,46,97,116,116,97,99,104,69,118,101,110,116,40,39,109,111,117,115,101,111,118,101,114,39,44,32,37,115,41,59,125,10,32,32,101,108,115,101,32,105,102,32,40,99,97,110,118,97,115,46,97,100,100,69,118,101,110,116,76,105,115,116,101,110,101,114,41,32,123,99,97,110,118,97,115,46,97,100,100,69,118,101,110,116,76,105,115,116,101,110,101,114,40,39,109,111,117,115,101,111,118,101,114,39,44,32,37,115,44,32,102,97,108,115,101,41,59,125,32,10,32,32,103,110,117,112,108,111,116,46,122,111,111,109,101,100,32,61,32,102,97,108,115,101,59,10,32,32,103,110,117,112,108,111,116,46,122,111,111,109,95,97,120,105,115,95,119,105,100,116,104,32,61,32,48,59,10,32,32,103,110,117,112,108,111,116,46,122,111,111,109,95,105,110,95,112,114,111,103,114,101,115,115,32,61,32,102,97,108,115,101,59,10,32,32,103,110,117,112,108,111,116,46,112,111,108,97,114,95,109,111,100,101,32,61,32,37,115,59,10,32,32,99,116,120,46,99,108,101,97,114,82,101,99,116,40,48,44,48,44,37,100,44,37,100,41,59,10,125,10,0,37,65,0,0,0,0,0,0,102,117,110,99,116,105,111,110,32,37,115,40,41,32,123,10,99,97,110,118,97,115,32,61,32,100,111,99,117,109,101,110,116,46,103,101,116,69,108,101,109,101,110,116,66,121,73,100,40,34,37,115,34,41,59,10,99,116,120,32,61,32,99,97,110,118,97,115,46,103,101,116,67,111,110,116,101,120,116,40,34,50,100,34,41,59,10,0,102,111,114,109,97,116,32,116,111,111,32,108,111,110,103,32,100,117,101,32,116,111,32,108,111,110,103,32,100,101,99,105,109,97,108,115,105,103,110,32,115,116,114,105,110,103,0,0,101,120,116,114,97,110,101,111,117,115,32,97,114,103,117,109,101,110,116,115,32,116,111,32,117,110,115,101,116,32,108,97,98,101,108,0,0,0,0,0,60,115,99,114,105,112,116,32,116,121,112,101,61,34,116,101,120,116,47,106,97,118,97,115,99,114,105,112,116,34,62,10,118,97,114,32,99,97,110,118,97,115,44,32,99,116,120,59,10,103,110,117,112,108,111,116,46,103,114,105,100,95,108,105,110,101,115,32,61,32,116,114,117,101,59,10,103,110,117,112,108,111,116,46,122,111,111,109,101,100,32,61,32,102,97,108,115,101,59,10,103,110,117,112,108,111,116,46,97,99,116,105,118,101,95,112,108,111,116,95,110,97,109,101,32,61,32,34,103,110,117,112,108,111,116,95,99,97,110,118,97,115,34,59,10,10,102,117,110,99,116,105,111,110,32,103,110,117,112,108,111,116,95,99,97,110,118,97,115,40,41,32,123,10,99,97,110,118,97,115,32,61,32,100,111,99,117,109,101,110,116,46,103,101,116,69,108,101,109,101,110,116,66,121,73,100,40,34,103,110,117,112,108,111,116,95,99,97,110,118,97,115,34,41,59,10,99,116,120,32,61,32,99,97,110,118,97,115,46,103,101,116,67,111,110,116,101,120,116,40,34,50,100,34,41,59,10,0,0,0,0,0,0,0,60,115,99,114,105,112,116,32,116,121,112,101,61,34,116,101,120,116,47,106,97,118,97,115,99,114,105,112,116,34,62,103,110,117,112,108,111,116,46,105,110,105,116,32,61,32,102,117,110,99,116,105,111,110,40,41,32,123,125,59,60,47,115,99,114,105,112,116,62,10,0,0,67,111,110,84,101,88,116,32,119,105,116,104,32,77,101,116,97,70,117,110,32,40,102,111,114,32,80,68,70,32,100,111,99,117,109,101,110,116,115,41,0,0,0,0,0,0,0,0,60,115,99,114,105,112,116,32,116,121,112,101,61,34,116,101,120,116,47,106,97,118,97,115,99,114,105,112,116,34,62,32,103,110,117,112,108,111,116,46,104,101,108,112,95,85,82,76,32,61,32,34,37,115,47,99,97,110,118,97,115,95,104,101,108,112,46,104,116,109,108,34,59,32,60,47,115,99,114,105,112,116,62,10,0,0,0,0,118,114,36,97,110,103,101,0,60,115,99,114,105,112,116,32,115,114,99,61,34,37,115,103,110,117,112,108,111,116,95,109,111,117,115,101,46,106,115,34,62,60,47,115,99,114,105,112,116,62,10,0,0,0,0,0,9,116,97,107,105,110,103,32,115,99,97,110,115,32,105,110,32,37,115,32,100,105,114,101,99,116,105,111,110,10,0,0,105,110,118,97,108,105,100,32,99,111,108,111,114,98,111,120,32,111,112,116,105,111,110,0,115,101,116,32,115,116,121,108,101,32,97,114,114,111,119,32,37,100,0,0,0,0,0,0,60,115,99,114,105,112,116,32,115,114,99,61,34,37,115,103,110,117,112,108,111,116,95,100,97,115,104,101,100,108,105,110,101,115,46,106,115,34,62,60,47,115,99,114,105,112,116,62,10,0,0,0,0,0,0,0,107,101,121,95,99,104,97,114,0,0,0,0,0,0,0,0,99,97,110,118,97,115,116,101,120,116,0,0,0,0,0,0,99,97,110,118,97,115,109,97,116,104,0,0,0,0,0,0,70,97,105,108,117,114,101,32,105,110,32,98,105,110,97,114,121,32,116,97,98,108,101,32,105,110,105,116,105,97,108,105,122,97,116,105,111,110,0,0,107,111,105,56,36,117,0,0,60,33,45,45,91,105,102,32,73,69,93,62,60,115,99,114,105,112,116,32,116,121,112,101,61,34,116,101,120,116,47,106,97,118,97,115,99,114,105,112,116,34,32,115,114,99,61,34,101,120,99,97,110,118,97,115,46,106,115,34,62,60,47,115,99,114,105,112,116,62,60,33,91,101,110,100,105,102,93,45,45,62,10,60,115,99,114,105,112,116,32,115,114,99,61,34,37,115,37,115,46,106,115,34,62,60,47,115,99,114,105,112,116,62,10,60,115,99,114,105,112,116,32,115,114,99,61,34,37,115,103,110,117,112,108,111,116,95,99,111,109,109,111,110,46,106,115,34,62,60,47,115,99,114,105,112,116,62,10,0,60,109,101,116,97,32,104,116,116,112,45,101,113,117,105,118,61,34,99,111,110,116,101,110,116,45,116,121,112,101,34,32,99,111,110,116,101,110,116,61,34,116,101,120,116,47,104,116,109,108,59,32,99,104,97,114,115,101,116,61,85,84,70,45,56,34,62,10,0,0,0,0,71,110,117,112,108,111,116,32,67,97,110,118,97,115,32,71,114,97,112,104,0,0,0,0,60,33,68,79,67,84,89,80,69,32,72,84,77,76,62,10,60,104,116,109,108,62,10,60,104,101,97,100,62,10,60,116,105,116,108,101,62,37,115,60,47,116,105,116,108,101,62,10,0,0,0,0,0,0,0,0,99,116,120,46,98,101,103,105,110,80,97,116,104,40,41,59,10,0,0,0,0,0,0,0,99,111,110,116,101,120,116,0,77,40,37,117,44,37,117,41,59,10,0,0,0,0,0,0,117,114,36,97,110,103,101,0,114,101,102,36,114,101,115,104,0,0,0,0,0,0,0,0,76,40,37,117,44,37,117,41,59,10,0,0,0,0,0,0,9,116,114,117,101,32,100,101,112,116,104,32,111,114,100,101,114,105,110,103,10,0,0,0,101,120,112,101,99,116,105,110,103,32,115,99,114,101,101,110,32,118,97,108,117,101,32,91,48,32,45,32,49,93,0,0,105,108,108,101,103,97,108,32,112,114,101,102,105,120,0,0,117,110,115,101,116,32,115,116,121,108,101,32,97,114,114,111,119,10,0,0,0,0,0,0,68,84,40,103,110,117,112,108,111,116,46,100,97,115,104,112,97,116,116,101,114,110,51,41,59,10,0,0,0,0,0,0,77,79,85,83,69,95,67,72,65,82,0,0,0,0,0,0,68,84,40,103,110,117,112,108,111,116,46,100,97,115,104,112,97,116,116,101,114,110,37,49,100,41,59,10,0,0,0,0,119,120,116,0,0,0,0,0,114,103,98,40,49,55,49,44,50,49,52,44,48,48,48,41,0,0,0,0,0,0,0,0,37,39,34,32,0,0,0,0,114,103,98,40,50,49,52,44,48,48,48,44,49,50,48,41,0,0,0,0,0,0,0,0,114,103,98,40,50,53,53,44,50,48,52,44,48,48,48,41,0,0,0,0,0,0,0,0,114,103,98,40,49,54,51,44,49,52,53,44,50,53,53,41,0,0,0,0,0,0,0,0,116,111,107,101,110,32,116,97,98,108,101,0,0,0,0,0,37,115,37,115,10,37,115,37,115,10,37,115,37,115,10,37,115,37,115,37,115,37,115,10,37,115,10,0,0,0,0,0,114,103,98,40,50,49,52,44,50,49,52,44,48,54,57,41,0,0,0,0,0,0,0,0,114,103,98,40,48,48,48,44,49,53,51,44,49,54,49,41,0,0,0,0,0,0,0,0,77,101,116,97,80,111,115,116,32,112,108,111,116,116,105,110,103,32,115,116,97,110,100,97,114,100,0,0,0,0,0,0,114,103,98,40,50,53,53,44,49,53,51,44,48,48,48,41,0,0,0,0,0,0,0,0,116,114,36,97,110,103,101,0,122,120,121,0,0,0,0,0,114,103,98,40,48,48,48,44,48,48,48,44,49,52,56,41,0,0,0,0,0,0,0,0,84,79,80,0,0,0,0,0,98,121,0,0,0,0,0,0,116,97,103,32,109,117,115,116,32,98,101,32,115,116,114,105,99,116,108,121,32,112,111,115,105,116,105,118,101,32,40,115,101,101,32,96,104,101,108,112,32,115,101,116,32,115,116,121,108,101,32,108,105,110,101,39,41,0,0,0,0,0,0,0,115,101,116,32,115,116,121,108,101,32,108,105,110,101,32,37,100,32,0,0,0,0,0,0,114,103,98,40,48,50,49,44,49,49,55,44,48,54,57,41,0,0,0,0,0,0,0,0,77,79,85,83,69,95,75,69,89,0,0,0,0,0,0,0,114,103,98,40,48,48,48,44,50,53,53,44,50,53,53,41,0,0,0,0,0,0,0,0,114,103,98,40,49,57,48,44,48,48,48,44,49,57,48,41,0,0,0,0,0,0,0,0,117,115,105,110,103,32,100,101,102,97,117,108,116,32,98,105,110,97,114,121,32,102,111,114,109,97,116,0,0,0,0,0,32,100,101,102,97,117,108,116,10,0,0,0,0,0,0,0,114,103,98,40,48,48,48,44,48,48,48,44,50,50,53,41,0,0,0,0,0,0,0,0,100,117,112,108,105,99,97,116,101,100,32,111,114,32,99,111,110,116,114,97,100,105,99,116,105,110,103,32,97,114,103,117,109,101,110,116,115,32,105,110,32,112,108,111,116,32,111,112,116,105,111,110,115,0,0,0,114,103,98,40,48,48,48,44,49,55,49,44,48,48,48,41,0,0,0,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,39,117,110,105,113,117,101,39,44,32,39,102,114,101,113,117,101,110,99,121,39,44,32,39,99,117,109,117,108,97,116,105,118,101,39,44,32,39,99,110,111,114,109,97,108,39,44,32,39,107,100,101,110,115,105,116,121,39,44,32,39,97,99,115,112,108,105,110,101,115,39,44,32,39,99,115,112,108,105,110,101,115,39,44,32,39,98,101,122,105,101,114,39,32,111,114,32,39,115,98,101,122,105,101,114,39,0,0,0,0,114,103,98,40,50,53,53,44,48,48,48,44,48,48,48,41,0,0,0,0,0,0,0,0,83,72,69,76,76,0,0,0,124,124,0,0,0,0,0,0,114,103,98,40,49,54,48,44,49,54,48,44,49,54,48,41,0,0,0,0,0,0,0,0,109,97,116,114,105,120,32,101,108,101,109,101,110,116,115,0])
.concat([114,103,98,40,48,48,48,44,48,48,48,44,48,48,48,41,0,0,0,0,0,0,0,0,115,112,108,105,110,101,32,109,97,116,114,105,120,0,0,0,109,112,0,0,0,0,0,0,114,103,98,40,50,53,53,44,50,53,53,44,50,53,53,41,0,0,0,0,0,0,0,0,114,114,36,97,110,103,101,0,117,115,105,110,103,32,100,101,102,97,117,108,116,32,98,105,110,97,114,121,32,114,101,99,111,114,100,47,97,114,114,97,121,32,115,116,114,117,99,116,117,114,101,0,0,0,0,0,72,111,109,101,0,0,0,0,34,41,59,10,0,0,0,0,83,85,82,70,65,67,69,0,105,110,118,97,108,105,100,32,112,109,51,100,32,111,112,116,105,111,110,0,0,0,0,0,84,40,37,100,44,37,100,44,37,46,49,102,44,34,37,115,34,44,34,0,0,0,0,0,117,110,115,101,116,32,115,116,121,108,101,32,108,105,110,101,10,0,0,0,0,0,0,0,102,105,108,108,101,100,95,112,111,108,121,103,111,110,51,100,32,99,111,114,110,101,114,115,0,0,0,0,0,0,0,0,32,32,32,112,117,115,104,101,100,32,116,101,114,109,105,110,97,108,32,37,115,32,37,115,10,0,0,0,0,0,0,0,77,79,85,83,69,95,66,85,84,84,79,78,0,0,0,0,84,82,40,37,100,44,37,100,44,37,100,44,37,46,49,102,44,34,37,115,34,44,34,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,32,58,32,110,111,110,45,83,84,82,73,78,71,32,97,114,103,117,109,101,110,116,0,0,0,0,82,105,103,104,116,0,0,0,108,105,116,116,108,101,0,0,80,116,40,37,100,44,37,100,44,37,100,44,37,46,49,102,41,59,10,0,0,0,0,0,68,111,116,40,37,100,44,37,100,41,59,10,0,0,0,0,82,40,37,100,44,37,100,44,37,100,44,37,100,41,59,10,0,0,0,0,0,0,0,0,99,116,120,46,108,105,110,101,87,105,100,116,104,32,61,32,37,103,59,10,0,0,0,0,99,116,120,46,115,116,114,111,107,101,83,116,121,108,101,32,61,32,34,37,115,34,59,10,0,0,0,0,0,0,0,0,77,101,116,97,102,111,110,116,32,112,108,111,116,116,105,110,103,32,115,116,97,110,100,97,114,100,0,0,0,0,0,0,114,103,98,40,37,48,51,100,44,37,48,51,100,44,37,48,51,100,41,0,0,0,0,0,99,98,114,36,97,110,103,101,0,0,0,0,0,0,0,0,37,115,37,99,0,0,0,0,66,79,84,84,79,77,0,0,101,120,112,101,99,116,105,110,103,32,39,109,101,97,110,39,44,32,39,103,101,111,109,101,97,110,39,44,32,39,109,101,100,105,97,110,39,44,32,39,109,105,110,39,44,32,39,109,97,120,39,44,32,39,99,49,39,44,32,39,99,50,39,44,32,39,99,51,39,32,111,114,32,39,99,52,39,0,0,0,117,115,101,114,115,116,121,108,101,115,0,0,0,0,0,0,114,103,98,40,37,51,100,44,37,51,100,44,37,51,100,41,37,99,0,0,0,0,0,0,114,103,98,97,40,50,53,53,44,50,53,53,44,50,53,53,44,48,46,48,48,41,0,0,114,103,98,97,40,37,49,49,46,49,49,115,44,37,52,46,50,102,41,37,99,0,0,0,68,117,112,108,105,99,97,116,101,100,32,111,114,32,99,111,110,116,114,97,100,105,99,116,105,110,103,32,97,114,103,117,109,101,110,116,115,32,105,110,32,100,97,116,97,102,105,108,101,32,111,112,116,105,111,110,115,0,0,0,0,0,0,0,37,77,0,0,0,0,0,0,99,102,115,112,40,41,59,10,0,0,0,0,0,0,0,0,80,108,111,116,32,116,121,112,101,32,105,115,32,110,101,105,116,104,101,114,32,102,117,110,99,116,105,111,110,32,110,111,114,32,100,97,116,97,0,0,99,102,112,40,41,59,10,0,76,40,37,100,44,32,37,100,41,59,10,0,0,0,0,0,98,112,40,37,100,44,32,37,100,41,59,10,0,0,0,0,99,116,120,46,102,105,108,108,83,116,121,108,101,32,61,32,34,37,115,34,59,10,0,0,109,102,0,0,0,0,0,0,68,84,40,103,110,117,112,108,111,116,46,115,111,108,105,100,41,59,10,0,0,0,0,0,122,114,36,97,110,103,101,0,109,0,0,0,0,0,0,0,84,104,105,115,32,99,111,112,121,32,111,102,32,103,110,117,112,108,111,116,32,99,97,110,110,111,116,32,114,101,97,100,32,112,110,103,47,103,105,102,47,106,112,101,103,32,105,109,97,103,101,115,0,0,0,0,44,32,116,104,101,110,32,0,99,52,0,0,0,0,0,0,115,101,116,32,115,116,121,108,101,32,105,110,99,114,101,109,101,110,116,32,37,115,10,0,77,126,60,62,37,87,61,38,64,0,0,0,0,0,0,0,97,120,105,115,32,114,97,110,103,101,115,32,109,117,115,116,32,98,101,32,97,98,111,118,101,32,48,32,102,111,114,32,108,111,103,32,115,99,97,108,101,33,0,0,0,0,0,0,65,99,101,70,86,63,97,98,100,69,103,104,110,111,112,113,117,0,0,0,0,0,0,0,32,74,84,118,94,95,34,42,121,107,76,115,120,122,0,0,109,105,115,115,105,110,103,32,102,111,114,109,97,116,32,115,116,114,105,110,103,0,0,0,40,41,91,93,123,125,92,0,102,116,114,0,0,0,0,0,106,96,39,44,59,58,33,46,0,0,0,0,0,0,0,0,105,73,108,124,0,0,0,0,99,116,120,46,115,116,114,111,107,101,40,41,59,10,0,0,76,97,84,101,88,32,116,101,120,100,114,97,119,32,101,110,118,105,114,111,110,109,101,110,116,0,0,0,0,0,0,0,99,116,120,46,108,105,110,101,87,105,100,116,104,32,61,32,115,97,118,101,87,105,100,116,104,59,10,125,32,47,47,32,103,114,105,100,95,108,105,110,101,115,10,0,0,0,0,0,121,50,114,36,97,110,103,101,0,0,0,0,0,0,0,0,105,102,32,40,103,110,117,112,108,111,116,46,103,114,105,100,95,108,105,110,101,115,41,32,123,10,118,97,114,32,115,97,118,101,87,105,100,116,104,32,61,32,99,116,120,46,108,105,110,101,87,105,100,116,104,59,10,99,116,120,46,108,105,110,101,87,105,100,116,104,32,61,32,99,116,120,46,108,105,110,101,87,105,100,116,104,32,42,32,48,46,53,59,10,0,0,9,112,109,51,100,32,112,108,111,116,116,101,100,32,97,116,32,0,0,0,0,0,0,0,99,51,0,0,0,0,0,0,32,115,105,122,101,32,37,115,32,37,46,51,102,44,37,46,51,102,44,37,46,51,102,0,125,32,47,47,32,69,110,100,32,37,115,95,112,108,111,116,95,37,100,32,10,0,0,0,115,101,116,32,97,117,116,111,115,99,97,108,101,32,107,101,101,112,102,105,120,0,0,0,105,102,32,40,116,121,112,101,111,102,40,103,110,117,112,108,111,116,46,104,105,100,101,95,37,115,95,112,108,111,116,95,37,100,41,32,61,61,32,34,117,110,100,101,102,105,110,101,100,34,124,124,32,33,103,110,117,112,108,111,116,46,104,105,100,101,95,37,115,95,112,108,111,116,95,37,100,41,32,123,10,0,0,0,0,0,0,0,103,112,0,0,0,0,0,0,102,111,114,109,36,97,116,0,99,116,120,46,99,108,111,115,101,80,97,116,104,40,41,59,10,0,0,0,0,0,0,0,119,105,100,36,116,104,0,0,108,105,36,110,101,119,105,100,116,104,0,0,0,0,0,0,110,111,114,36,111,116,97,116,101,0,0,0,0,0,0,0,115,113,114,116,40,115,113,114,116,40,120,41,41,0,0,0,119,105,110,36,119,111,114,100,54,0,0,0,0,0,0,0,116,101,120,100,114,97,119,0,110,111,102,36,111,110,116,108,105,115,116,0,0,0,0,0,121,114,36,97,110,103,101,0,108,97,36,110,100,115,99,97,112,101,0,0,0,0,0,0,101,120,112,108,105,99,105,116,32,40,100,114,97,119,32,112,109,51,100,32,115,117,114,102,97,99,101,32,97,99,99,111,114,100,105,110,103,32,116,111,32,115,116,121,108,101,41,0,99,50,0,0,0,0,0,0,99,104,97,114,97,99,116,101,114,0,0,0,0,0,0,0,32,120,37,48,50,120,37,48,50,120,37,48,50,120,0,0,96,98,117,105,108,116,105,110,45,97,117,116,111,115,99,97,108,101,96,32,40,115,101,116,32,97,117,116,111,115,99,97,108,101,32,107,101,101,112,102,105,120,59,32,114,101,112,108,111,116,41,0,0,0,0,0,110,111,102,111,110,116,108,105,115,116,0,0,0,0,0,0,37,115,32,37,115,32,37,115,32,37,115,32,37,115,32,119,105,100,116,104,32,37,100,32,108,105,110,101,119,105,100,116,104,32,37,100,32,34,37,115,34,32,37,100,0,0,0,0,79,112,116,105,111,110,115,32,97,114,101,32,100,101,102,97,117,108,116,44,32,115,119,97,112,32,40,115,119,97,98,41,44,32,108,105,116,116,108,101,44,32,98,105,103,44,32,109,105,100,100,108,101,32,40,112,100,112,41,0,0,0,0,0,37,115,44,37,100,0,0,0,105,110,118,97,108,105,100,32,99,111,108,111,114,32,115,112,101,99,44,32,109,117,115,116,32,98,101,32,120,82,82,71,71,66,66,0,0,0,0,0,120,37,50,104,120,37,50,104,120,37,50,104,120,0,0,0,119,105,100,116,104,32,111,117,116,32,111,102,32,114,97,110,103,101,0,0,0,0,0,0,108,105,110,101,119,105,100,116,104,32,111,117,116,32,111,102,32,114,97,110,103,101,0,0,76,97,84,101,88,32,112,105,99,116,117,114,101,32,101,110,118,105,114,111,110,109,101,110,116,32,119,105,116,104,32,80,83,84,114,105,99,107,115,32,109,97,99,114,111,115,0,0,99,103,109,32,112,111,108,121,108,105,110,101,115,0,0,0,120,50,114,36,97,110,103,101,0,0,0,0,0,0,0,0,37,46,51,49,115,44,37,100,0,0,0,0,0,0,0,0,105,109,112,108,105,99,105,116,32,40,112,109,51,100,32,100,114,97,119,32,102,111,114,32,97,108,108,32,115,117,114,102,97,99,101,115,41,0,0,0,99,49,0,0,0,0,0,0,115,99,114,101,101,110,0,0,80,73,67,84,85,82,69,49,0,0,0,0,0,0,0,0,96,98,117,105,108,116,105,110,45,116,111,103,103,108,101,45,98,111,114,100,101,114,96,0,67,71,77,32,102,111,110,116,32,108,105,115,116,0,0,0,71,110,117,112,108,111,116,32,118,101,114,115,105,111,110,32,37,115,32,112,97,116,99,104,108,101,118,101,108,32,37,115,44,32,67,111,109,112,117,116,101,114,32,71,114,97,112,104,105,99,115,32,77,101,116,97,102,105,108,101,32,118,101,114,115,105,111,110,32,49,32,112,101,114,32,77,73,76,45,68,45,50,56,48,48,51,65,47,66,65,83,73,67,45,49,46,37,100,0,0,0,0,0,0,112,100,112,0,0,0,0,0,84,105,109,101,115,32,66,111,108,100,32,79,98,108,105,113,117,101,0,0,0,0,0,0,84,105,109,101,115,32,79,98,108,105,113,117,101,0,0,0,67,111,117,114,105,101,114,32,66,111,108,100,32,73,116,97,108,105,99,0,0,0,0,0,67,111,117,114,105,101,114,32,73,116,97,108,105,99,0,0,72,101,108,118,101,116,105,99,97,32,66,111,108,100,32,73,116,97,108,105,99,0,0,0,112,115,116,114,105,99,107,115,0,0,0,0,0,0,0,0,72,101,108,118,101,116,105,99,97,32,73,116,97,108,105,99,0,0,0,0,0,0,0,0,120,114,36,97,110,103,101,0,49,53,0,0,0,0,0,0,9,112,109,51,100,32,115,116,121,108,101,32,105,115,32,37,115,10,0,0,0,0,0,0,103,114,97,112,104,0,0,0,83,99,114,105,112,116,0,0,96,98,117,105,108,116,105,110,45,114,101,112,108,111,116,96,0,0,0,0,0,0,0,0,90,97,112,102,68,105,110,103,98,97,116,115,0,0,0,0,72,101,114,115,104,101,121,47,83,121,109,98,111,108,95,77,97,116,104,0,0,0,0,0,109,105,100,36,100,108,101,0,72,101,114,115,104,101,121,47,83,121,109,98,111,108,95,83,101,116,95,50,0,0,0,0,72,101,114,115,104,101,121,47,83,121,109,98,111,108,95,83,101,116,95,49,0,0,0,0,76,111,99,97,108,101,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,0,0,0,72,101,114,115,104,101,121,47,71,111,116,104,105,99,95,73,116,97,108,105,97,110,0,0,111,101,69,102,70,103,71,0,99,121,99,108,101,0,0,0,72,101,114,115,104,101,121,47,71,111,116,104,105,99,95,69,110,103,108,105,115,104,0,0,72,101,114,115,104,101,121,47,71,111,116,104,105,99,95,71,101,114,109,97,110,0,0,0,84,80,73,67,32,45,45,32,76,97,84,101,88,32,112,105,99,116,117,114,101,32,101,110,118,105,114,111,110,109,101,110,116,32,119,105,116,104,32,116,112,105,99,32,92,115,112,101,99,105,97,108,115,0,0,0,72,101,114,115,104,101,121,47,84,114,105,112,108,101,120,95,73,116,97,108,105,99,0,0,110,111,99,98,109,116,105,36,99,115,0,0,0,0,0,0,72,101,114,115,104,101,121,47,84,114,105,112,108,101,120,95,82,111,109,97,110,0,0,0,9,112,111,105,110,116,115,105,122,101,32,105,115,32,37,103,10,0,0,0,0,0,0,0,115,101,99,111,110,100,0,0,72,101,114,115,104,101,121,47,68,117,112,108,101,120,95,82,111,109,97,110,0,0,0,0,117,110,115,101,116,32,103,114,105,100,0,0,0,0,0,0,72,101,114,115,104,101,121,47,67,111,109,112,108,101,120,95,67,121,114,105,108,108,105,99,0,0,0,0,0,0,0,0,72,101,114,115,104,101,121,47,67,111,109,112,108,101,120,95,73,116,97,108,105,99,0,0,108,105,116,36,116,108,101,0,107,111,105,56,36,114,0,0,72,101,114,115,104,101,121,47,67,111,109,112,108,101,120,95,83,99,114,105,112,116,0,0,103,116,0,0,0,0,0,0,72,101,114,115,104,101,121,47,67,111,109,112,108,101,120,95,71,114,101,101,107,0,0,0,72,101,114,115,104,101,121,47,67,111,109,112,108,101,120,95,82,111,109,97,110,0,0,0,72,101,114,115,104,101,121,47,83,105,109,112,108,101,120,95,83,99,114,105,112,116,0,0,72,101,114,115,104,101,121,47,83,105,109,112,108,101,120,95,71,114,101,101,107,0,0,0,116,112,105,99,0,0,0,0,72,101,114,115,104,101,121,47,83,105,109,112,108,101,120,95,82,111,109,97,110,0,0,0,99,98,109,116,105,36,99,115,0,0,0,0,0,0,0,0,113,36,117,105,116,0,0,0,72,101,114,115,104,101,121,47,67,97,114,116,111,103,114,97,112,104,105,99,95,71,114,101,101,107,0,0,0,0,0,0,9,112,111,105,110,116,105,110,116,101,114,118,97,108,98,111,120,32,105,115,32,37,103,10,0,0,0,0,0,0,0,0,71,80,86,65,76,95,0,0,102,105,114,115,116,0,0,0,72,101,114,115,104,101,121,47,67,97,114,116,111,103,114,97,112,104,105,99,95,82,111,109,97,110,0,0,0,0,0,0,67,71,77,32,99,111,108,111,114,32,116,97,98,108,101,0,48,32,60,61,32,108,101,110,103,116,104,0,0,0,0,0,115,119,97,98,0,0,0,0,40,48,32,60,61,32,99,103,109,95,105,100,41,32,38,38,32,40,99,103,109,95,105,100,32,60,32,49,50,56,41,0,40,48,32,60,61,32,99,108,97,115,115,41,32,38,38,40,99,108,97,115,115,32,60,49,54,41,0,0,0,0,0,0,118,97,108,117,101,32,60,61,32,51,50,55,54,55,0,0,43,68,65,84,65,83,84,82,73,78,71,83,32,32,43,72,73,83,84,79,71,82,65,77,83,32,32,43,79,66,74,69,67,84,83,32,32,43,83,84,82,73,78,71,86,65,82,83,32,32,43,77,65,67,82,79,83,32,32,43,73,77,65,71,69,32,32,43,85,83,69,82,95,76,73,78,69,84,89,80,69,83,32,43,83,84,65,84,83,32,0,0,0,0,0,0,45,51,50,55,54,56,32,60,61,32,118,97,108,117,101,0,69,69,80,73,67,32,45,45,32,101,120,116,101,110,100,101,100,32,76,97,84,101,88,32,112,105,99,116,117,114,101,32,101,110,118,105,114,111,110,109,101,110,116,0,0,0,0,0,99,111,108,111,117,114,36,0,110,111,122,109,116,105,36,99,115,0,0,0,0,0,0,0,99,111,108,111,114,36,0,0,9,104,111,119,101,118,101,114,32,76,67,95,67,84,89,80,69,32,105,110,32,99,117,114,114,101,110,116,32,108,111,99,97,108,101,32,105,115,32,37,115,10,0,0,0,0,0,0,103,101,111,109,101,97,110,0,37,115,32,34,37,115,34,32,37,100,44,37,48,46,49,102,44,37,48,46,49,102,44,37,48,46,49,102,0,0,0,0,96,98,117,105,108,116,105,110,45,116,111,103,103,108,101,45,103,114,105,100,96,0,0,0,83,119,105,116,122,101,114,108,97,110,100,76,105,103,104,116,0,0,0,0,0,0,0,0,37,37,33,80,83,45,65,100,111,98,101,45,50,46,48,32,69,80,83,70,45,49,46,50,10,37,37,37,37,66,111,117,110,100,105,110,103,66,111,120,58,32,37,100,32,37,100,32,37,100,32,37,100,10,37,37,37,37,84,101,109,112,108,97,116,101,66,111,120,58,32,37,100,32,37,100,32,37,100,32,37,100,10,37,37,37,37,69,110,100,67,111,109,109,101,110,116,115,10,37,37,37,37,69,110,100,80,114,111,108,111,103,10,37,37,37,37,66,101,103,105,110,83,101,116,117,112,10,37,37,37,37,69,110,100,83,101,116,117,112,10,0,0,0,115,119,97,112,0,0,0,0,32,37,115,32,112,97,116,116,101,114,110,32,37,100,32,0,37,48,46,50,102,32,37,48,46,50,102,32,109,10,0,0,110,111,115,117,114,36,102,97,99,101,0,0,0,0,0,0,83,10,37,46,50,102,32,37,46,50,102,32,109,10,0,0,115,36,109,111,111,116,104,0,37,46,50,102,32,37,46,50,102,32,108,10,0,0,0,0,110,111,32,72,79,77,69,32,102,111,117,110,100,0,0,0,101,120,116,101,110,100,95,97,116,0,0,0,0,0,0,0,91,50,32,50,32,50,32,50,32,50,32,50,32,50,32,52,93,32,48,32,100,10,50,32,106,10,48,32,71,10,0,0,48,46,53,32,48,46,53,32,48,46,53,32,48,32,75,10,0,0,0,0,0,0,0,0,102,117,110,99,116,105,111,110,32,100,101,102,105,110,105,116,105,111,110,32,101,120,112,101,99,116,101,100,0,0,0,0,101,101,112,105,99,0,0,0,91,50,32,50,32,50,32,50,32,50,32,52,93,32,48,32,100,10,50,32,106,10,48,32,71,10,0,0,0,0,0,0,122,109,116,105,36,99,115,0,73,110,115,101,114,116,0,0,48,32,48,46,55,32,49,32,48,32,75,10,0,0,0,0,9,110,111,109,105,110,97,108,32,99,104,97,114,97,99,116,101,114,32,101,110,99,111,100,105,110,103,32,105,115,32,37,115,10,0,0,0,0,0,0,91,50,32,50,32,50,32,52,93,32,48,32,100,10,50,32,106,10,48,32,71,10,0,0,102,111,110,116,112,97,116,104,95,102,117,108,108,110,97,109,101,58,32,78,111,32,80,105,112,101,32,97,108,108,111,119,101,100,0,0,0,0,0,0,96,98,117,105,108,116,105,110,45,104,101,108,112,96,0,0,91,52,32,51,32,49,32,51,93,32,48,32,100,10,50,32,106,10,48,32,71,10,0,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,32,58,32,110,111,110,45,73,78,84,71,82,32,97,114,103,117,109,101,110,116,0,0,0,0,0,48,32,48,32,49,32,48,32,75,10,0,0,0,0,0,0,91,53,32,50,32,49,32,50,93,32,48,32,100,10,50,32,106,10,48,32,71,10,0,0,49,32,48,32,48,32,48,32,75,10,0,0,0,0,0,0,37,102,32,119,10,0,0,0,91,49,32,49,46,53,93,32,48,32,100,10,50,32,106,10,48,32,71,10,0,0,0,0,48,32,49,32,48,32,48,32,75,10,0,0,0,0,0,0,112,108,97,105,110,32,84,101,88,32,119,105,116,104,32,80,111,115,116,83,99,114,105,112,116,32,92,115,112,101,99,105,97,108,115,0,0,0,0,0,91,50,32,51,93,32,48,32,100,10,50,32,106,10,48,32,71,10,0,0,0,0,0,0,110,111,121,50,109,116,105,36,99,115,0,0,0,0,0,0,48,32,49,32,49,32,48,32,75,10,0,0,0,0,0,0,9,100,101,103,114,101,101,32,115,105,103,110,32,102,111,114,32,111,117,116,112,117,116,32,105,115,32,37,115,32,10,0,68,101,112,114,101,99,97,116,101,100,32,115,121,110,116,97,120,32,45,45,45,32,105,103,110,111,114,101,100,0,0,0,91,52,32,50,93,32,48,32,100,10,50,32,106,10,48,32,71,10,0,0,0,0,0,0,67,97,110,110,111,116,32,116,111,103,103,108,101,32,108,111,103,32,115,99,97,108,101,32,102,111,114,32,118,111,108,97,116,105,108,101,32,100,97,116,97,0,0,0,0,0,0,0,49,32,49,32,48,32,48,32,75,10,0,0,0,0,0,0,91,93,32,48,32,100,10,50,32,106,10,48,32,71,10,0,101,110,100,36,105,97,110,0,49,32,48,32,49,32,48,32,75,10,0,0,0,0,0,0,91,49,32,50,93,32,48,32,100,10,48,32,106,10,48,32,71,10,0,0,0,0,0,0,104,105,100,100,101,110,32,115,111,114,116,32,101,100,103,101,115,0,0,0,0,0,0,0,117,110,100,101,102,105,110,101,100,32,102,117,110,99,116,105,111,110,58,32,37,115,0,0,91,93,32,48,32,100,10,48,32,106,10,48,32,71,10,0,48,32,48,32,48,32,49,32,75,10,0,0,0,0,0,0,37,46,50,102,32,119,10,0,112,115,116,101,120,0,0,0,41,116,10,84,10,0,0,0,121,50,109,116,105,36,99,115,0,0,0,0,0,0,0,0,91,48,32,49,32,45,49,32,48,32,37,46,50,102,32,37,46,50,102,93,101,10,48,32,103,10,0,0,0,0,0,0,9,100,101,99,105,109,97,108,115,105,103,110,32,102,111,114,32,111,117,116,112,117,116,32,104,97,115,32,100,101,102,97,117,108,116,32,118,97,108,117,101,32,40,110,111,114,109,97,108,108,121,32,39,46,39,41,10,0,0,0,0,0,0,0,91,49,32,48,32,48,32,49,32,37,46,50,102,32,37,46,50,102,93,101,10,48,32,103,10,0,0,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,102,108,117,115,104,32,39,98,101,103,105,110,39,44,32,39,99,101,110,116,101,114,39,32,111,114,32,39,101,110,100,39,0,0,0,0,0,0,32,37,115,32,37,115,32,37,115,0,0,0,0,0,0,0,82,97,115,116,101,114,65,120,101,115,0,0,0,0,0,0,96,98,117,105,108,116,105,110,45,116,111,103,103,108,101,45,108,111,103,96,32,121,32,108,111,103,115,99,97,108,101,32,102,111,114,32,112,108,111,116,115,44,32,122,32,97,110,100,32,99,98,32,102,111,114,32,115,112,108,111,116,115,0,0,47,95,37,115,32,37,100,32,37,100,32,48,32,50,32,122,10,0,0,0,0,0,0,0,47,95,37,115,32,37,100,32,37,100,32,48,32,49,32,122,10,0,0,0,0,0,0,0,115,107,105,112,0,0,0,0,86,105,115,105,98,108,101,32,112,105,120,101,108,32,103,114,105,100,32,104,97,115,32,97,32,115,99,97,110,32,108,105,110,101,32,115,104,111,114,116,101,114,32,116,104,97,110,32,112,114,101,118,105,111,117,115,32,115,99,97,110,32,108,105,110,101,115,46,0,0,0,0,47,95,37,115,32,37,100,32,37,100,32,48,32,48,32,122,10,0,0,0,0,0,0,0,83,10,0,0,0,0,0,0,110,111,101,36,110,104,97,110,99,101,100,0,0,0,0,0,110,111,102,36,101,101,100,0,102,36,101,101,100,0,0,0,76,97,84,101,88,32,112,105,99,116,117,114,101,32,101,110,118,105,114,111,110,109,101,110,116,32,119,105,116,104,32,80,111,115,116,83,99,114,105,112,116,32,92,115,112,101,99,105,97,108,115,0,0,0,0,0,37,115,102,101,101,100,32,37,115,32,115,105,122,101,32,37,100,44,32,37,100,0,0,0,110,111,121,109,116,105,36,99,115,0,0,0,0,0,0,0,100,117,109,98,32,116,101,114,109,105,110,97,108,0,0,0,9,100,101,99,105,109,97,108,115,105,103,110,32,102,111,114,32,111,117,116,112,117,116,32,105,115,32,37,115,32,10,0,101,36,110,100,0,0,0,0,32,32,48,10,69,78,68,83,69,67,10,32,32,48,10,69,79,70,10,0,0,0,0,0,115,101,116,32,108,111,103,32,121,50,0,0,0,0,0,0,55,0,0,0,0,0,0,0,32,32,48,10,69,78,68,84,65,66,10,48,10,69,78,68,83,69,67,10,32,32,48,10,83,69,67,84,73,79,78,10,32,32,50,10,66,76,79,67,75,83,10,32,32,48,10,69,78,68,83,69,67,10,32,32,48,10,83,69,67,84,73,79,78,10,32,32,50,10,69,78,84,73,84,73,69,83,10,0,75,101,121,32,119,111,114,100,32,96,112,101,114,112,101,110,100,105,99,117,108,97,114,96,32,105,115,32,110,111,116,32,97,108,108,111,119,101,100,32,119,105,116,104,32,96,112,108,111,116,96,32,99,111,109,109,97,110,100,0,0,0,0,0,32,32,48,10,76,65,89,69,82,10,32,32,50,10,37,115,10,32,55,48,10,32,32,32,54,52,10,54,50,10,32,32,32,37,115,10,32,32,54,10,37,115,10,0,0,0,0,0,32,32,48,10,84,65,66,76,69,10,32,32,50,10,76,65,89,69,82,10,32,55,48,10,32,32,32,37,45,100,10,0,32,32,48,10,80,79,76,89,76,73,78,69,10,32,32,56,10,37,115,10,32,54,54,10,32,32,32,49,10,32,32,54,10,37,115,10,32,32,48,10,86,69,82,84,69,88,10,32,32,56,10,37,115,10,32,32,54,10,37,115,10,32,49,48,10,37,45,54,46,51,102,10,32,50,48,10,37,45,54,46,51,102,10,32,51,48,10,48,46,48,48,48,10,0,0,0,68,65,83,72,68,79,84,0,115,113,114,116,32,115,113,114,116,0,0,0,0,0,0,0,68,79,84,0,0,0,0,0,112,115,108,97,116,101,120,0,80,72,65,78,84,79,77,0,121,109,116,105,36,99,115,0,67,69,78,84,69,82,0,0,9,100,101,99,105,109,97,108,115,105,103,110,32,102,111,114,32,105,110,112,117,116,32,105,115,32,32,37,115,32,10,0,98,36,101,103,105,110,0,0,115,101,116,32,97,114,114,111,119,32,37,100,32,102,114,111,109,32,0,0,0,0,0,0,72,73,68,68,69,78,0,0,117,110,115,101,116,32,108,111,103,32,121,50,0,0,0,0,68,65,83,72,69,68,0,0,67,79,78,84,73,78,85,79,85,83,0,0,0,0,0,0,112,101,114,112,36,101,110,100,105,99,117,108,97,114,0,0,32,32,48,10,86,69,82,84,69,88,10,32,32,56,10,37,115,10,32,32,54,10,37,115,10,32,32,49,48,10,37,45,54,46,51,102,10,32,32,50,48,10,37,45,54,46,51,102,10,32,32,51,48,10,48,46,48,48,48,10,0,0,0,0,53,0,0,0,0,0,0,0,52,0,0,0,0,0,0,0,50,0,0,0,0,0,0,0,76,97,84,101,88,32,112,105,99,116,117,114,101,32,101,110,118,105,114,111,110,109,101,110,116,32,117,115,105,110,103,32,103,114,97,112,104,105,99,120,32,112,97,99,107,97,103,101,0,0,0,0,0,0,0,0,49,0,0,0,0,0,0,0,110,111,120,50,109,116,105,36,99,115,0,0,0,0,0,0,83,84,65,78,68,65,82,68,0,0,0,0,0,0,0,0,78,111,32,102,117,114,116,104,101,114,32,111,112,116,105,111,110,115,32,97,108,108,111,119,101,100,32,97,102,116,101,114,32,39,100,101,102,97,117,108,116,115,39,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,115,116,101,112,32,118,97,108,117,101,115,32,105,44,106,0,0,0,0,0,0,0,117,110,115,101,116,32,97,114,114,111,119,10,0,0,0,0,32,55,50,10,37,100,10,32,49,49,10,37,45,54,46,51,102,10,32,50,49,10,37,45,54,46,51,102,10,32,51,49,10,48,46,48,48,48,10,0,115,101,116,32,108,111,103,32,120,50,0,0,0,0,0,0,32,49,48,10,37,45,54,46,51,102,10,32,50,48,10,37,45,54,46,51,102,10,32,51,48,10,48,46,48,48,48,10,32,52,48,10,37,45,54,46,51,102,10,32,32,49,10,37,115,10,32,53,48,10,37,45,54,46,51,102,10,32,32,55,10,37,115,10,0,0,0,0,32,32,48,10,84,69,88,84,10,32,32,56,10,37,115,10,0,0,0,0,0,0,0,0,32,32,48,10,83,69,81,69,78,68,10,0,0,0,0,0,38,35,120,37,50,46,50,120,59,0,0,0,0,0,0,0,123,125,94,95,64,38,126,0,32,98,97,99,107,103,114,111,117,110,100,32,34,35,37,48,54,120,34,0,0,0,0,0,32,100,97,115,104,108,101,110,103,116,104,32,37,46,49,102,0,0,0,0,0,0,0,0,101,112,115,108,97,116,101,120,0,0,0,0,0,0,0,0,32,108,119,32,37,46,49,102,0,0,0,0,0,0,0,0,120,50,109,116,105,36,99,115,0,0,0,0,0,0,0,0,114,111,116,36,97,116,105,111,110,0,0,0,0,0,0,0,32,115,105,122,101,32,37,100,44,37,100,32,0,0,0,0,9,108,111,103,45,102,105,108,101,32,102,111,114,32,102,105,116,115,32,105,115,32,117,110,99,104,97,110,103,101,100,32,102,114,111,109,32,116,104,101,32,101,110,118,105,114,111,110,109,101,110,116,32,100,101,102,97,117,108,116,32,111,102,10,9,39,37,115,39,10,0,0,32,112,111,105,110,116,0,0,32,102,111,110,116,115,99,97,108,101,32,37,46,49,102,0,117,110,115,101,116,32,108,111,103,32,120,50,0,0,0,0,32,101,110,104,97,110,99,101,100,32,0,0,0,0,0,0,37,115,32,37,115,32,37,115,32,102,111,110,116,32,34,37,115,44,37,103,34,0,0,0,99,111,110,116,111,117,114,32,112,111,108,121,103,111,110,0,37,103,0,0,0,0,0,0,110,111,112,114,111,36,112,111,114,116,105,111,110,97,108,0,98,97,99,107,36,103,114,111,117,110,100,0,0,0,0,0,66,97,100,32,102,111,114,109,97,116,32,99,104,97,114,97,99,116,101,114,0,0,0,0,100,101,36,102,97,117,108,116,0,0,0,0,0,0,0,0,101,120,116,114,97,110,101,111,117,115,32,97,114,103,117,109,101,110,116,115,32,116,111,32,117,110,115,101,116,32,114,101,99,116,97,110,103,108,101,0,116,101,114,109,111,112,116,36,105,111,110,0,0,0,0,0,101,109,102,95,109,111,118,101,58,32,40,37,100,44,37,100,41,32,111,117,116,32,111,102,32,114,97,110,103,101,0,0,76,97,84,101,88,32,112,105,99,116,117,114,101,32,101,110,118,105,114,111,110,109,101,110,116,32,119,105,116,104,32,101,109,84,101,88,32,115,112,101,99,105,97,108,115,0,0,0,110,111,120,109,116,105,36,99,115,0,0,0,0,0,0,0,101,109,102,95,115,111,108,105,100,95,118,101,99,116,111,114,58,32,40,37,100,44,37,100,41,32,111,117,116,32,111,102,32,114,97,110,103,101,0,0,9,108,111,103,45,102,105,108,101,32,102,111,114,32,102,105,116,115,32,105,115,32,119,97,115,32,115,101,116,32,98,121,32,116,104,101,32,117,115,101,114,32,116,111,32,98,101,32,10,9,39,37,115,39,10,0,10,9,100,117,109,109,121,32,118,97,114,105,97,98,108,101,32,105,115,32,116,32,102,111,114,32,99,117,114,118,101,115,10,0,0,0,0,0,0,0,105,99,111,110,118,32,102,97,105,108,101,100,0,0,0,0,115,101,116,32,108,111,103,32,121,0,0,0,0,0,0,0,105,99,111,110,118,95,111,112,101,110,32,102,97,105,108,101,100,0,0,0,0,0,0,0,85,84,70,45,49,54,76,69,0,0,0,0,0,0,0,0,99,112,52,36,51,55,0,0,83,104,105,102,116,95,74,73,83,0,0,0,0,0,0,0,32,34,37,115,34,10,0,0,85,84,70,45,56,0,0,0,105,99,111,110,118,32,115,116,114,105,110,103,0,0,0,0,32,83,116,114,105,107,101,79,117,116,0,0,0,0,0,0,32,83,116,114,105,107,101,111,117,116,0,0,0,0,0,0,101,109,116,101,120,0,0,0,32,115,116,114,105,107,101,111,117,116,0,0,0,0,0,0,120,109,116,105,36,99,115,0,112,119,100,0,0,0,0,0,32,85,110,100,101,114,108,105,110,101,0,0,0,0,0,0,32,110,111,116,0,0,0,0,117,110,114,101,99,111,103,110,105,122,101,100,32,111,98,106,101,99,116,32,116,121,112,101,0,0,0,0,0,0,0,0,32,117,110,100,101,114,108,105,110,101,0,0,0,0,0,0,117,110,115,101,116,32,108,111,103,32,121,0,0,0,0,0,101,109,102,95,100,97,115,104,101,100,95,118,101,99,116,111,114,58,32,40,37,100,44,37,100,41,32,111,117,116,32,111,102,32,114,97,110,103,101,0,32,105,46,44,59,58,124,33,39,0,0,0,0,0,0,0,111,114,105,103,36,105,110,0,109,119,60,62,0,0,0,0,32,105,106,108,46,44,59,58,124,33,40,41,91,93,73,45,39,0,0,0,0,0,0,0,118,36,101,114,115,105,111,110,0,0,0,0,0,0,0,0,43,85,83,69,95,77,79,85,83,69,32,32,0,0,0,0,116,101,120,116,115,36,112,101,99,105,97,108,0,0,0,0,116,101,120,116,114,36,105,103,105,100,0,0,0,0,0,0,76,97,84,101,88,32,112,105,99,116,117,114,101,32,101,110,118,105,114,111,110,109,101,110,116,0,0,0,0,0,0,0,116,101,120,116,110,36,111,114,109,97,108,0,0,0,0,0,110,111,99,98,100,116,105,36,99,115,0,0,0,0,0,0,114,116,0,0,0,0,0,0,116,101,120,116,104,36,105,100,100,101,110,0,0,0,0,0,9,102,105,116,32,119,105,108,108,37,115,32,112,108,97,99,101,32,112,97,114,97,109,101,116,101,114,32,101,114,114,111,114,115,32,105,110,32,118,97,114,105,97,98,108,101,115,10,0,0,0,0,0,0,0,0,117,110,107,110,111,119,110,32,111,98,106,101,99,116,0,0,116,36,104,105,99,107,110,101,115,115,0,0,0,0,0,0,115,101,116,32,108,111,103,32,120,0,0,0,0,0,0,0,115,109,36,97,108,108,0,0,112,111,114,36,116,114,97,105,116,0,0,0,0,0,0,0,116,114,97,110,115,36,112,111,115,101,0,0,0,0,0,0,112,111,105,36,110,116,115,109,97,120,0,0,0,0,0,0,109,101,36,116,114,105,99,0,110,111,99,111,110,36,116,111,117,114,115,0,0,0,0,0,35,32,32,32,32,69,79,70,10,0,0,0,0,0,0,0,102,36,111,110,116,115,105,122,101,0,0,0,0,0,0,0,72,79,77,69,0,0,0,0,101,120,112,101,99,116,105,110,103,32,39,58,39,0,0,0,100,101,36,112,116,104,0,0,98,36,105,103,0,0,0,0,102,117,110,99,116,105,111,110,32,99,111,110,116,97,105,110,115,32,116,111,111,32,109,97,110,121,32,112,97,114,97,109,101,116,101,114,115,0,0,0,108,97,116,101,120,0,0,0,32,115,105,122,101,32,37,102,32,37,102,0,0,0,0,0,99,98,100,116,105,36,99,115,0,0,0,0,0,0,0,0,83,121,115,95,82,101,113,0,32,115,105,122,101,32,37,100,32,37,100,0,0,0,0,0,79,70,70,0,0,0,0,0,112,111,108,121,36,103,111,110,0,0,0,0,0,0,0,0,118,101,114,115,105,111,110,0,108,111,97,100,112,97,116,104,95,102,111,112,101,110,0,0,117,110,115,101,116,32,108,111,103,32,120,0,0,0,0,0,100,101,112,116,104,0,0,0,109,101,116,114,105,99,0,0,115,99,97,110,0,0,0,0,105,110,99,104,101,115,0,0,112,111,105,110,116,115,109,97,120,0,0,0,0,0,0,0,115,109,97,108,108,0,0,0,98,105,103,0,0,0,0,0,37,115,32,37,115,32,37,115,32,37,100,32,37,115,32,37,115,32,37,115,37,115,32,37,115,32,34,37,115,44,37,100,34,32,37,115,32,37,100,32,37,115,32,37,100,32,37,115,32,37,115,0,0,0,0,0,84,107,47,84,99,108,32,99,97,110,118,97,115,32,119,105,100,103,101,116,32,91,112,101,114,108,116,107,93,32,91,105,110,116,101,114,97,99,116,105,118,101,93,0,0,0,0,0,32,116,101,120,116,114,105,103,105,100,0,0,0,0,0,0,110,111,122,100,116,105,36,99,115,0,0,0,0,0,0,0,32,116,101,120,116,104,105,100,100,101,110,0,0,0,0,0,79,78,0,0,0,0,0,0,32,114,111,116,97,116,101,32,98,121,32,37,100,0,0,0,32,116,101,120,116,115,112,101,99,105,97,108,0,0,0,0,115,101,116,32,108,111,103,32,122,0,0,0,0,0,0,0,37,115,37,115,37,115,0,0,32,116,101,120,116,110,111,114,109,97,108,0,0,0,0,0,110,111,102,108,105,112,0,0,37,72,0,0,0,0,0,0,119,114,111,110,103,32,118,101,114,115,105,111,110,32,110,117,109,98,101,114,44,32,109,117,115,116,32,98,101,32,51,46,49,32,111,114,32,51,46,50,0,0,0,0,0,0,0,0,104,105,100,100,101,110,32,115,111,114,116,97,114,114,97,121,0,0,0,0,0,0,0,0,118,101,114,115,105,111,110,58,32,51,46,49,32,111,114,32,51,46,50,32,101,120,112,101,99,116,101,100,0,0,0,0,112,111,105,110,116,115,109,97,120,58,32,110,117,109,98,101,114,32,111,117,116,32,111,102,32,114,97,110,103,101,32,40,50,44,37,108,100,41,0,0,109,97,120,46,32,112,111,105,110,116,115,32,112,101,114,32,112,111,108,121,108,105,110,101,58,32,110,117,109,98,101,114,32,101,120,112,101,99,116,101,100,0,0,0,0,0,0,0,100,101,112,116,104,32,111,117,116,32,111,102,32,114,97,110,103,101,0,0,0,0,0,0,116,107,99,97,110,118,97,115,0,0,0,0,0,0,0,0,100,101,112,116,104,58,32,110,117,109,98,101,114,32,101,120,112,101,99,116,101,100,0,0,122,100,116,105,36,99,115,0,116,104,105,99,107,110,101,115,115,32,111,117,116,32,111,102,32,114,97,110,103,101,0,0,9,112,111,108,97,114,32,105,115,32,37,115,10,0,0,0,116,104,105,99,107,110,101,115,115,58,32,110,117,109,98,101,114,32,101,120,112,101,99,116,101,100,0,0,0,0,0,0,117,110,115,101,116,32,108,111,103,32,122,0,0,0,0,0,115,105,122,101,58,32,50,32,110,117,109,98,101,114,115,32,101,120,112,101,99,116,101,100,0,0,0,0,0,0,0,0,80,83,105,122,101,95,50,0,83,105,110,103,108,101,0,0,102,108,105,112,0,0,0,0,86,105,115,105,98,108,101,32,112,105,120,101,108,32,103,114,105,100,32,104,97,115,32,97,32,115,99,97,110,32,108,105,110,101,32,108,111,110,103,101,114,32,116,104,97,110,32,112,114,101,118,105,111,117,115,32,115,99,97,110,32,108,105,110,101,115,46,0,0,0,0,0,65,52,0,0,0,0,0,0,76,101,116,116,101,114,0,0,35,70,73,71,32,51,46,50,10,37,115,10,37,115,10,37,115,10,37,115,10,37,54,46,50,102,10,37,115,10,37,100,10,37,100,32,37,100,10,0,51,46,50,0,0,0,0,0,77,101,116,114,105,99,0,0,84,71,73,70,32,88,49,49,32,91,109,111,100,101,93,32,91,120,44,121,93,32,91,100,97,115,104,101,100,93,32,91,34,102,111,110,116,34,32,91,102,111,110,116,115,105,122,101,93,93,0,0,0,0,0,0,73,110,99,104,101,115,0,0,110,111,121,50,100,116,105,36,99,115,0,0,0,0,0,0,67,101,110,116,101,114,0,0,100,101,103,114,101,101,115,10,0,0,0,0,0,0,0,0,115,101,116,32,108,97,98,101,108,32,37,100,32,34,37,115,34,32,97,116,32,0,0,0,35,70,73,71,32,51,46,49,10,37,115,10,37,115,10,37,115,10,37,100,32,37,100,10,0,0,0,0,0,0,0,0,115,101,116,32,108,111,103,32,99,98,0,0,0,0,0,0,51,46,49,0,0,0,0,0,70,73,71,95,112,111,105,110,116,115,0,0,0,0,0,0,102,108,105,112,122,0,0,0,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,54,46,51,102,32,37,54,46,51,102,32,37,100,32,37,54,46,51,102,32,37,54,46,51,102,32,37,100,32,37,100,32,37,115,92,48,48,49,10,0,0,0,0,0,0,70,73,71,32,116,101,120,116,0,0,0,0,0,0,0,0,52,10,9,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,10,0,0,0,0,0,53,10,9,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,10,0,0,0,0,0,0,0,115,113,114,116,40,120,41,0,50,32,51,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,54,46,51,102,32,48,32,48,32,48,32,48,32,48,32,0,0,0,0,0,0,0,116,103,105,102,0,0,0,0,49,32,51,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,54,46,51,102,32,49,32,48,46,48,48,48,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,10,0,121,50,100,116,105,36,99,115,0,0,0,0,0,0,0,0,37,100,32,37,100,32,37,100,32,37,100,10,0,0,0,0,114,97,100,105,97,110,115,10,0,0,0,0,0,0,0,0,37,100,32,37,100,32,37,46,51,102,32,37,46,51,102,32,37,46,51,102,10,0,0,0,115,97,109,112,108,105,110,103,32,114,97,116,101,32,109,117,115,116,32,98,101,32,62,32,49,59,32,115,97,109,112,108,105,110,103,32,117,110,99,104,97,110,103,101,100,0,0,0,117,110,115,101,116,32,108,97,98,101,108,10,0,0,0,0,114,101,99,116,0,0,0,0,117,110,115,101,116,32,108,111,103,32,99,98,0,0,0,0,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,57,46,51,102,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,10,0,0,0,0,0,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,54,46,51,102,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,10,32,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,10,0,0,0,0,0,77,117,115,116,32,115,112,101,99,105,102,121,32,97,32,115,97,109,112,108,105,110,103,32,97,114,114,97,121,32,115,105,122,101,32,98,101,102,111,114,101,32,105,110,100,105,99,97,116,105,110,103,32,102,108,105,112,32,105,110,32,115,101,99,111,110,100,32,100,105,109,101,110,115,105,111,110,0,0,0,102,105,103,58,32,65,116,116,101,109,112,116,32,116,111,32,115,101,116,32,112,97,108,101,116,116,101,32,116,119,105,99,101,10,0,0,0,0,0,0,37,100,32,37,100,32,35,37,50,46,50,120,37,50,46,50,120,37,50,46,50,120,10,0,77,111,110,111,99,104,114,111,109,101,32,102,105,103,32,102,105,108,101,58,32,117,115,105,110,103,32,103,114,97,121,32,112,97,108,101,116,116,101,32,105,110,115,116,101,97,100,32])
.concat([111,102,32,99,111,108,111,114,10,0,0,0,0,0,0,0,102,105,103,58,32,80,97,108,101,116,116,101,32,117,115,101,100,32,98,101,102,111,114,101,32,115,101,116,10,0,0,0,32,37,100,32,37,100,0,0,87,51,67,32,83,99,97,108,97,98,108,101,32,86,101,99,116,111,114,32,71,114,97,112,104,105,99,115,32,100,114,105,118,101,114,0,0,0,0,0,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,57,46,51,102,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,108,100,10,9,0,0,0,110,111,121,100,116,105,36,99,115,0,0,0,0,0,0,0,45,54,10,0,0,0,0,0,9,65,110,103,108,101,115,32,97,114,101,32,105,110,32,0,73,108,108,101,103,97,108,32,118,97,108,117,101,32,102,111,114,32,115,105,122,101,0,0,117,110,115,101,116,32,107,101,121,10,0,0,0,0,0,0,35,32,69,110,100,32,112,108,111,116,32,35,37,100,10,0,96,98,117,105,108,116,105,110,45,110,101,97,114,101,115,116,45,108,111,103,96,32,116,111,103,103,108,101,32,108,111,103,115,99,97,108,101,32,111,102,32,97,120,105,115,32,110,101,97,114,101,115,116,32,99,117,114,115,111,114,0,0,0,0,35,32,66,101,103,105,110,32,112,108,111,116,32,35,37,100,10,0,0,0,0,0,0,0,32,37,100,32,37,100,32,37,100,32,37,100,10,0,0,0,102,108,105,112,121,0,0,0,54,0,0,0,0,0,0,0,78,101,101,100,32,50,32,116,111,32,55,32,117,115,105,110,103,32,115,112,101,99,115,0,27,42,109,112,49,109,50,97,50,81,0,0,0,0,0,0,27,42,100,101,84,0,0,0,27,42,100,97,102,108,115,67,0,0,0,0,0,0,0,0,27,42,112,0,0,0,0,0,81,77,83,47,81,85,73,67,32,76,97,115,101,114,32,112,114,105,110,116,101,114,32,40,97,108,115,111,32,84,97,108,97,114,105,115,32,49,50,48,48,32,97,110,100,32,111,116,104,101,114,115,41,0,0,0,27,42,109,37,100,66,0,0,121,100,116,105,36,99,115,0,27,42,100,84,0,0,0,0,9,115,97,109,112,108,105,110,103,32,114,97,116,101,32,105,115,32,37,100,44,32,37,100,10,0,0,0,0,0,0,0,110,111,115,113,36,117,97,114,101,0,0,0,0,0,0,0,115,101,116,32,107,101,121,32,37,115,111,112,97,113,117,101,10,0,0,0,0,0,0,0,72,80,50,54,0,0,0,0,116,117,114,110,105,110,103,32,109,111,117,115,101,32,111,102,102,46,10,0,0,0,0,0,37,100,44,37,100,79,0,0,37,100,44,37,100,80,0,0,102,108,105,112,120,0,0,0,27,42,100,0,0,0,0,0,27,42,109,37,100,78,0,0,9,102,111,110,116,112,97,116,104,32,105,115,32,101,109,112,116,121,10,0,0,0,0,0,27,42,109,49,109,49,110,49,51,54,44,49,99,90,0,0,120,50,94,123,37,100,125,0,27,42,100,97,99,90,0,0,105,110,118,97,108,105,100,32,97,120,105,115,0,0,0,0,27,42,112,97,102,37,100,44,37,100,90,0,0,0,0,0,113,109,115,0,0,0,0,0,27,42,112,98,102,37,100,44,37,100,90,0,0,0,0,0,110,111,120,50,100,116,105,36,99,115,0,0,0,0,0,0,27,42,109,37,100,98,90,0,9,105,115,111,32,115,97,109,112,108,105,110,103,32,114,97,116,101,32,105,115,32,37,100,44,32,37,100,10,0,0,0,110,111,114,97,36,116,105,111,0,0,0,0,0,0,0,0,10,115,101,116,32,107,101,121,32,109,97,120,99,111,108,117,109,110,115,32,37,100,32,109,97,120,114,111,119,115,32,37,100,0,0,0,0,0,0,0,27,42,108,37,115,10,0,0,116,117,114,110,105,110,103,32,109,111,117,115,101,32,111,110,46,10,0,0,0,0,0,0,27,42,109,37,100,110,90,10,0,0,0,0,0,0,0,0,110,111,101,106,101,99,116,0,120,95,109,105,110,51,100,32,115,104,111,117,108,100,32,110,111,116,32,101,113,117,97,108,32,120,95,109,97,120,51,100,33,0,0,0,0,0,0,0,67,117,114,114,101,110,116,108,121,32,110,111,116,32,115,117,112,112,111,114,116,105,110,103,32,116,104,114,101,101,45,100,105,109,101,110,115,105,111,110,97,108,32,115,97,109,112,108,105,110,103,0,0,0,0,0,105,115,111,36,95,56,56,53,57,95,49,0,0,0,0,0,101,106,101,99,116,0,0,0,32,116,121,112,101,10,0,0,37,100,32,112,101,110,115,32,37,115,0,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,34,101,106,101,99,116,34,32,111,114,32,110,117,109,98,101,114,32,111,102,32,112,101,110,115,0,0,0,0,0,78,117,109,98,101,114,32,111,102,32,112,101,110,115,32,109,117,115,116,32,98,101,32,112,111,115,105,116,105,118,101,0,101,106,101,36,99,116,0,0,80,111,115,116,83,99,114,105,112,116,32,103,114,97,112,104,105,99,115,44,32,105,110,99,108,117,100,105,110,103,32,69,80,83,70,32,101,109,98,101,100,100,101,100,32,102,105,108,101,115,32,40,42,46,101,112,115,41,0,0,0,0,0,0,80,85,83,80,48,59,80,71,59,27,46,90,10,0,0,0,120,50,100,116,105,36,99,115,0,0,0,0,0,0,0,0,112,114,36,105,110,116,0,0,80,85,83,80,48,59,27,46,90,10,0,0,0,0,0,0,105,110,100,101,112,101,110,100,101,110,116,108,121,32,115,99,97,108,101,100,0,0,0,0,114,97,36,116,105,111,0,0,112,114,101,36,102,105,120,0,10,115,101,116,32,107,101,121,32,37,115,105,110,118,101,114,116,32,115,97,109,112,108,101,110,32,37,103,32,115,112,97,99,105,110,103,32,37,103,32,119,105,100,116,104,32,37,103,32,104,101,105,103,104,116,32,37,103,32,0,0,0,0,0,67,65,55,59,0,0,0,0,96,98,117,105,108,116,105,110,45,116,111,103,103,108,101,45,109,111,117,115,101,96,0,0,73,78,59,37,115,10,83,67,48,44,37,100,44,48,44,37,100,59,10,83,82,37,102,44,37,102,59,10,0,0,0,0,27,46,89,10,27,46,73,56,49,59,59,49,55,58,27,46,78,59,49,57,58,27,46,77,53,48,48,58,10,0,0,0,100,122,0,0,0,0,0,0,80,85,59,80,65,37,100,44,37,100,59,10,0,0,0,0,80,65,37,100,44,37,100,59,10,0,0,0,0,0,0,0,80,68,59,80,65,37,100,44,37,100,59,10,0,0,0,0,45,85,83,69,95,67,87,68,82,67,32,32,0,0,0,0,80,85,59,10,83,80,37,100,59,10,0,0,0,0,0,0,3,10,0,0,0,0,0,0,112,111,115,116,115,99,114,105,112,116,0,0,0,0,0,0,76,66,0,0,0,0,0,0,110,111,120,100,116,105,36,99,115,0,0,0,0,0,0,0,116,114,0,0,0,0,0,0,68,73,48,44,49,59,10,0,111,110,32,116,104,101,32,115,97,109,101,32,115,99,97,108,101,0,0,0,0,0,0,0,115,113,36,117,97,114,101,0,110,111,98,111,120,0,0,0,68,73,48,44,45,49,59,10,0,0,0,0,0,0,0,0,96,98,117,105,108,116,105,110,45,112,114,101,118,105,111,117,115,45,109,111,117,115,101,45,102,111,114,109,97,116,96,0,68,73,49,44,48,59,10,0,116,0,0,0,0,0,0,0,112,36,115,112,111,105,110,116,115,0,0,0,0,0,0,0,77,117,115,116,32,115,112,101,99,105,102,121,32,97,32,115,97,109,112,108,105,110,103,32,97,114,114,97,121,32,115,105,122,101,32,98,101,102,111,114,101,32,105,110,100,105,99,97,116,105,110,103,32,115,112,97,99,105,110,103,32,105,110,32,115,101,99,111,110,100,32,100,105,109,101,110,115,105,111,110,0,0,0,0,0,0,0,0,32,37,115,32,115,111,108,105,100,32,37,46,50,102,32,0,110,36,111,112,115,112,111,105,110,116,115,0,0,0,0,0,110,111,104,105,100,100,101,110,36,51,100,0,0,0,0,0,102,36,111,110,116,0,0,0,115,121,110,116,97,120,32,101,114,114,111,114,0,0,0,0,100,97,115,36,104,101,100,0,115,111,108,36,105,100,0,0,110,111,112,115,112,111,105,110,116,115,0,0,0,0,0,0,70,114,97,109,101,32,109,97,107,101,114,32,77,73,70,32,51,46,48,48,32,102,111,114,109,97,116,0,0,0,0,0,112,115,112,111,105,110,116,115,0,0,0,0,0,0,0,0,120,100,116,105,36,99,115,0,83,99,114,111,108,108,95,76,111,99,107,0,0,0,0,0,112,105,116,99,104,0,0,0,120,47,121,47,122,0,0,0,101,120,116,114,97,110,101,111,117,115,32,111,114,32,111,117,116,45,111,102,45,111,114,100,101,114,32,97,114,103,117,109,101,110,116,115,32,105,110,32,115,101,116,32,97,114,114,111,119,115,116,121,108,101,0,0,104,101,105,103,104,116,0,0,115,119,105,116,99,104,101,100,32,109,111,117,115,101,32,102,111,114,109,97,116,32,102,114,111,109,32,37,108,100,32,116,111,32,37,108,100,10,0,0,32,37,115,32,37,100,32,37,115,32,92,10,32,32,32,37,115,32,37,115,32,37,102,32,37,115,0,0,0,0,0,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,58,32,115,117,98,115,116,114,105,110,103,32,114,97,110,103,101,32,111,112,101,114,97,116,111,114,32,97,112,112,108,105,101,100,32,116,111,32,110,111,110,45,83,84,82,73,78,71,32,116,121,112,101,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,112,111,105,110,116,32,115,105,122,101,58,32,114,101,97,108,32,110,117,109,98,101,114,0,0,0,0,0,0,0,100,114,0,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,102,111,110,116,58,32,115,116,105,99,107,44,32,99,103,95,116,105,109,101,115,44,32,117,110,105,118,101,114,115,44,32,122,97,112,102,95,100,105,110,103,98,97,116,115,44,32,97,110,116,105,113,117,101,95,111,108,105,118,101,44,10,97,114,105,97,108,44,32,99,111,117,114,105,101,114,44,32,103,97,114,97,109,111,110,100,95,97,110,116,105,103,117,97,44,32,108,101,116,116,101,114,95,103,111,116,104,105,99,44,32,99,103,95,111,109,101,103,97,44,32,97,108,98,101,114,116,117,115,44,10,116,105,109,101,115,95,110,101,119,95,114,111,109,97,110,44,32,99,108,97,114,101,110,100,111,110,44,32,99,111,114,111,110,101,116,44,32,109,97,114,105,103,111,108,100,44,32,116,114,117,101,116,121,112,101,95,115,121,109,98,111,108,115,44,32,111,114,32,119,105,110,103,100,105,110,103,115,0,0,0,0,0,0,78,117,109,98,101,114,32,111,102,32,112,101,110,115,32,109,117,115,116,32,98,101,32,97,32,112,111,115,105,116,105,118,101,0,0,0,0,0,0,0,108,101,116,116,101,114,0,0,108,101,116,36,116,101,114,0,108,101,103,97,108,0,0,0,109,105,102,0,0,0,0,0,108,101,103,36,97,108,0,0,110,111,99,98,116,105,36,99,115,0,0,0,0,0,0,0,110,111,101,120,116,101,110,100,101,100,0,0,0,0,0,0,120,47,121,0,0,0,0,0,97,114,114,111,119,115,116,121,108,101,0,0,0,0,0,0,110,111,97,117,116,111,116,105,116,108,101,115,0,0,0,0,110,111,101,120,116,36,101,110,100,101,100,0,0,0,0,0,96,98,117,105,108,116,105,110,45,110,101,120,116,45,109,111,117,115,101,45,102,111,114,109,97,116,96,0,0,0,0,0,101,120,116,101,110,100,101,100,0,0,0,0,0,0,0,0,101,120,116,36,101,110,100,101,100,0,0,0,0,0,0,0,100,121,0,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,109,111,100,101,58,32,112,111,114,116,114,97,105,116,32,111,114,32,108,97,110,100,115,99,97,112,101,0,0,0,109,36,111,100,101,0,0,0,42,65,108,108,42,32,101,100,103,101,115,32,117,110,100,101,102,105,110,101,100,32,111,114,32,111,117,116,32,111,102,32,114,97,110,103,101,44,32,116,104,117,115,32,110,111,32,112,108,111,116,46,0,0,0,0,27,38,108,48,79,0,0,0,27,38,108,49,79,0,0,0,27,69,27,38,108,49,88,37,115,10,0,0,0,0,0,0,73,109,97,103,101,110,32,108,97,115,101,114,32,112,114,105,110,116,101,114,0,0,0,0,27,37,48,65,27,69,10,0,99,98,116,105,36,99,115,0,27,37,49,65,27,38,108,48,72,10,0,0,0,0,0,0,9,9,37,115,32,97,120,101,115,32,97,114,101,32,37,115,10,0,0,0,0,0,0,0,111,98,106,101,99,116,32,105,110,105,116,105,97,108,105,122,97,116,105,111,110,32,102,97,105,108,117,114,101,0,0,0,97,117,116,111,116,105,116,108,101,115,0,0,0,0,0,0,85,76,49,44,49,48,48,59,10,85,76,50,44,56,44,56,44,57,44,56,44,56,44,57,44,56,44,56,44,57,44,56,44,56,44,57,59,10,85,76,51,44,54,44,54,44,54,44,55,44,54,44,54,44,54,44,55,44,54,44,54,44,54,44,55,44,54,44,54,44,54,44,55,59,10,85,76,52,44,53,44,53,44,53,44,49,48,44,53,44,53,44,53,44,49,48,44,53,44,53,44,53,44,49,48,59,10,85,76,53,44,53,44,53,44,53,44,53,44,53,44,56,44,53,44,53,44,53,44,53,44,53,44,56,44,53,44,53,44,53,44,53,44,53,44,57,59,10,85,76,54,44,56,44,56,44,48,44,57,44,56,44,56,44,48,44,57,44,56,44,56,44,48,44,57,59,10,85,76,55,44,52,44,52,44,52,44,52,44,48,44,52,44,52,44,52,44,52,44,52,44,48,44,52,44,52,44,52,44,52,44,52,44,48,44,52,59,10,85,76,56,44,54,44,54,44,54,44,54,44,54,44,54,44,48,44,54,44,54,44,54,44,54,44,54,44,54,44,54,44,48,44,54,59,10,0,96,98,117,105,108,116,105,110,45,100,101,99,114,101,109,101,110,116,45,99,108,105,112,98,111,97,114,100,109,111,100,101,96,0,0,0,0,0,0,0,73,78,83,80,49,83,68,49,44,37,100,44,50,44,37,100,44,0,0,0,0,0,0,0,27,37,48,66,0,0,0,0,80,83,105,122,101,95,49,0,100,116,0,0,0,0,0,0,105,109,97,103,101,0,0,0,80,69,60,0,0,0,0,0,80,69,0,0,0,0,0,0,46,48,56,0,0,0,0,0,105,109,97,103,101,110,0,0,46,49,54,0,0,0,0,0,110,111,114,116,105,36,99,115,0,0,0,0,0,0,0,0,46,50,52,0,0,0,0,0,37,103,32,114,111,116,95,120,44,32,37,103,32,114,111,116,95,122,44,32,37,103,32,115,99,97,108,101,44,32,37,103,32,115,99,97,108,101,95,122,10,0,0,0,0,0,0,0,111,98,106,101,99,116,0,0,97,117,116,111,116,105,116,108,101,115,32,99,111,108,117,109,110,104,101,97,100,0,0,0,44,50,0,0,0,0,0,0,115,119,105,116,99,104,101,100,32,99,108,105,112,98,111,97,114,100,32,102,111,114,109,97,116,32,102,114,111,109,32,37,108,100,32,116,111,32,37,108,100,10,0,0,0,0,0,0,80,87,46,49,76,84,49,44,46,50,53,0,0,0,0,0,80,87,46,50,76,84,0,0,100,120,0,0,0,0,0,0,80,87,37,115,76,84,0,0,80,87,37,115,76,84,37,100,37,115,0,0,0,0,0,0,80,85,59,10,83,80,49,59,10,80,87,46,50,76,84,49,44,46,50,53,0,0,0,0,80,85,59,10,83,80,49,59,10,80,87,46,50,76,84,0,115,113,114,116,0,0,0,0,80,85,59,10,83,80,37,100,59,10,76,84,59,0,0,0,72,80,32,68,101,115,105,103,110,106,101,116,32,55,53,48,67,44,32,72,80,32,76,97,115,101,114,106,101,116,32,73,73,73,47,73,86,44,32,101,116,99,46,32,40,109,97,110,121,32,111,112,116,105,111,110,115,41,0,0,0,0,0,0,80,85,59,10,83,80,37,100,59,10,76,84,37,100,59,0,114,116,105,36,99,115,0,0,76,66,37,115,3,10,0,0,109,97,112,10,0,0,0,0,73,110,99,111,110,115,105,115,116,101,110,116,32,111,112,116,105,111,110,115,0,0,0,0,68,73,49,44,48,0,0,0,96,98,117,105,108,116,105,110,45,105,110,99,114,101,109,101,110,116,45,99,108,105,112,98,111,97,114,100,109,111,100,101,96,0,0,0,0,0,0,0,68,73,48,44,45,49,0,0,68,73,48,44,49,0,0,0,97,114,114,36,97,121,0,0,76,79,55,0,0,0,0,0,76,79,52,0,0,0,0,0,76,79,49,0,0,0,0,0,87,71,37,46,50,102,44,49,56,48,44,49,56,48,59,69,80,59,10,0,0,0,0,0,69,87,37,46,50,102,44,48,44,49,56,48,59,10,0,0,112,99,108,53,0,0,0,0,80,77,50,59,70,84,49,48,44,51,48,59,70,80,59,69,80,59,70,84,59,10,0,0,110,111,122,116,105,36,99,115,0,0,0,0,0,0,0,0,70,84,49,48,44,51,48,59,87,71,37,46,50,102,44,48,44,51,54,48,59,69,80,59,70,84,59,10,0,0,0,0,9,118,105,101,119,32,105,115,32,0,0,0,0,0,0,0,85,110,114,101,99,111,103,110,105,122,101,100,32,111,114,32,100,117,112,108,105,99,97,116,101,32,111,112,116,105,111,110,0,0,0,0,0,0,0,0,76,101,102,116,0,0,0,0,70,84,49,48,44,51,48,59,82,65,37,100,44,37,100,59,69,80,59,70,84,59,10,0,110,111,116,0,0,0,0,0,82,65,37,100,44,37,100,59,69,80,59,10,0,0,0,0,87,71,37,100,44,48,44,51,54,48,59,69,80,59,10,0,114,101,99,36,111,114,100,0,87,71,37,100,44,57,48,44,50,55,48,59,69,80,59,69,87,37,100,44,48,44,57,48,59,10,0,0,0,0,0,0,87,71,37,100,44,49,56,48,44,50,55,48,59,69,80,59,69,87,37,100,44,57,48,44,57,48,59,10,0,0,0,0,87,71,37,100,44,49,56,48,44,49,56,48,59,69,80,59,69,87,37,100,44,48,44,49,56,48,59,10,0,0,0,0,87,71,37,100,44,50,55,48,44,50,55,48,59,69,80,59,69,87,37,100,44,49,56,48,44,57,48,59,10,0,0,0,87,71,37,100,44,57,48,44,57,48,59,69,80,59,69,87,37,100,44,49,56,48,44,57,48,59,87,71,37,100,44,50,55,48,44,57,48,59,69,80,59,69,87,37,100,44,48,44,57,48,59,10,0,0,0,0,72,80,55,52,55,53,32,97,110,100,32,114,101,108,97,116,105,118,101,115,32,91,110,117,109,98,101,114,32,111,102,32,112,101,110,115,93,32,91,101,106,101,99,116,93,0,0,0,87,71,37,100,44,50,55,48,44,49,56,48,59,69,80,59,69,87,37,100,44,57,48,44,49,56,48,59,10,0,0,0,122,116,105,36,99,115,0,0,87,71,37,100,44,50,55,48,44,57,48,59,69,80,59,69,87,37,100,44,48,44,50,55,48,59,10,0,0,0,0,0,9,115,117,114,102,97,99,101,32,105,115,32,37,115,100,114,97,119,110,10,0,0,0,0,102,105,108,108,99,36,111,108,111,114,0,0,0,0,0,0,104,111,114,105,122,111,110,116,97,108,0,0,0,0,0,0,87,71,37,100,44,48,44,50,55,48,59,69,80,59,69,87,37,100,44,50,55,48,44,57,48,59,10,0,0,0,0,0,100,105,115,116,97,110,99,101,32,116,111,32,114,117,108,101,114,32,119,105,108,108,32,37,115,32,98,101,32,115,104,111,119,110,32,105,110,32,112,111,108,97,114,32,99,111,111,114,100,105,110,97,116,101,115,46,10,0,0,0,0,0,0,0,87,71,37,100,44,57,48,44,49,56,48,59,69,80,59,69,87,37,100,44,50,55,48,44,49,56,48,59,10,0,0,0,87,71,37,100,44,48,44,57,48,59,69,80,59,69,87,37,100,44,57,48,44,57,48,59,87,71,37,100,44,49,56,48,44,57,48,59,69,80,59,69,87,37,100,44,50,55,48,44,57,48,59,10,0,0,0,0,85,110,114,101,99,111,103,110,105,122,101,100,32,102,105,108,101,116,121,112,101,59,32,116,114,121,32,34,115,104,111,119,32,100,97,116,97,102,105,108,101,32,98,105,110,97,114,121,32,102,105,108,101,116,121,112,101,115,34,0,0,0,0,0,87,71,37,100,44,49,56,48,44,57,48,59,69,80,59,69,87,37,100,44,50,55,48,44,50,55,48,59,10,0,0,0,87,71,37,100,44,48,44,49,56,48,59,69,80,59,69,87,37,100,44,49,56,48,44,49,56,48,59,10,0,0,0,0,9,115,121,115,116,101,109,32,102,111,110,116,112,97,116,104,32,105,115,32,0,0,0,0,87,71,37,100,44,57,48,44,57,48,59,69,80,59,69,87,37,100,44,49,56,48,44,50,55,48,59,10,0,0,0,0,120,50,94,123,37,100,125,89,105,0,0,0,0,0,0,0,87,71,37,100,44,48,44,57,48,59,69,80,59,69,87,37,100,44,57,48,44,50,55,48,59,10,0,0,0,0,0,0,121,111,117,32,99,97,110,39,116,32,99,104,97,110,103,101,32,116,104,101,32,111,117,116,112,117,116,32,105,110,32,109,117,108,116,105,112,108,111,116,32,109,111,100,101,0,0,0,37,72,58,37,77,58,37,83,0,0,0,0,0,0,0,0,67,73,37,100,59,10,0,0,104,112,103,108,0,0,0,0,80,77,50,59,70,80,59,69,80,59,10,0,0,0,0,0,110,111,121,50,116,105,36,99,115,0,0,0,0,0,0,0,80,77,48,59,10,0,0,0,100,114,97,119,110,0,0,0,102,99,0,0,0,0,0,0,118,101,114,116,105,99,97,108,0,0,0,0,0,0,0,0,87,71,37,46,50,102,44,48,44,51,54,48,59,69,80,59,10,0,0,0,0,0,0,0,96,98,117,105,108,116,105,110,45,116,111,103,103,108,101,45,112,111,108,97,114,100,105,115,116,97,110,99,101,96,0,0,67,73,37,46,50,102,59,10,0,0,0,0,0,0,0,0,82,65,37,46,50,102,44,37,46,50,102,59,69,80,59,10,0,0,0,0,0,0,0,0,117,116,102,36,56,0,0,0,119,105,110,103,100,105,110,103,115,0,0,0,0,0,0,0,32,32,99,111,108,111,114,0,98,97,110,100,0,0,0,0,119,36,105,110,103,100,105,110,103,115,0,0,0,0,0,0,116,114,117,101,116,121,112,101,95,115,121,109,98,111,108,115,0,0,0,0,0,0,0,0,116,114,36,117,101,116,121,112,101,95,115,121,109,98,111,108,115,0,0,0,0,0,0,0,103,101,116,99,111,108,111,114,46,99,0,0,0,0,0,0,109,97,114,105,103,111,108,100,0,0,0,0,0,0,0,0,72,80,50,54,52,56,32,97,110,100,32,72,80,50,54,52,55,0,0,0,0,0,0,0,109,36,97,114,105,103,111,108,100,0,0,0,0,0,0,0,121,50,116,105,36,99,115,0,112,36,108,111,116,0,0,0,99,111,114,111,110,101,116,0,114,101,109,111,118,101,100,0,73,110,118,97,108,105,100,32,99,111,109,109,97,110,100,32,45,32,100,105,100,32,121,111,117,32,109,101,97,110,32,39,117,110,115,101,116,32,115,116,121,108,101,32,114,101,99,116,97,110,103,108,101,39,63,0,110,111,111,117,116,36,112,117,116,0,0,0,0,0,0,0,32,37,115,32,37,115,32,37,115,114,101,118,101,114,115,101,32,37,115,101,110,104,97,110,99,101,100,32,37,115,32,0,99,111,114,36,111,110,101,116,0,0,0,0,0,0,0,0,99,111,109,109,117,110,105,99,97,116,105,111,110,32,99,111,109,109,97,110,100,115,32,119,105,108,108,32,98,101,32,101,99,104,111,101,100,46,10,0,99,108,97,114,101,110,100,111,110,0,0,0,0,0,0,0,99,108,36,97,114,101,110,100,111,110,0,0,0,0,0,0,102,105,108,101,36,116,121,112,101,0,0,0,0,0,0,0,116,105,109,101,115,95,110,101,119,95,114,111,109,97,110,0,116,105,36,109,101,115,95,110,101,119,95,114,111,109,97,110,0,0,0,0,0,0,0,0,97,108,98,101,114,116,117,115,0,0,0,0,0,0,0,0,43,66,73,78,65,82,89,95,68,65,84,65,32,32,0,0,97,108,36,98,101,114,116,117,115,0,0,0,0,0,0,0,99,103,95,111,109,101,103,97,0,0,0,0,0,0,0,0,104,112,50,54,52,56,0,0,99,103,95,111,36,109,101,103,97,0,0,0,0,0,0,0,110,111,121,116,105,36,99,115,0,0,0,0,0,0,0,0,108,101,116,116,101,114,95,103,111,116,104,105,99,0,0,0,0,0,0,0,0,0,0,0,9,104,105,100,100,101,110,32,115,117,114,102,97,99,101,32,105,115,32,37,115,10,0,0,99,36,101,110,116,114,101,0,32,98,111,116,116,111,109,0,108,36,101,116,116,101,114,95,103,111,116,104,105,99,0,0,101,99,104,111,105,110,103,32,111,102,32,99,111,109,109,117,110,105,99,97,116,105,111,110,32,99,111,109,109,97,110,100,115,32,105,115,32,116,117,114,110,101,100,32,111,102,102,46,10,0,0,0,0,0,0,0,103,97,114,97,109,111,110,100,95,97,110,116,105,103,117,97,0,0,0,0,0,0,0,0,103,36,97,114,97,109,111,110,100,95,97,110,116,105,103,117,97,0,0,0,0,0,0,0,100,97,116,97,102,105,108,101,32,99,111,108,117,109,110,0,115,101,116,32,97,117,116,111,115,99,97,108,101,32,37,115,102,105,120,109,97,120,10,0,99,111,117,36,114,105,101,114,0,0,0,0,0,0,0,0,97,114,105,97,108,0,0,0,97,114,36,105,97,108,0,0,99,117,114,118,101,32,112,111,105,110,116,115,0,0,0,0,117,110,114,101,99,111,103,110,105,122,101,100,32,111,112,116,105,111,110,32,37,115,10,0,105,116,101,114,97,116,105,111,110,32,108,105,110,107,101,100,32,108,105,115,116,0,0,0,97,110,116,105,113,117,101,95,111,108,105,118,101,0,0,0,97,110,36,116,105,113,117,101,95,111,108,105,118,101,0,0,72,80,50,54,50,51,65,32,97,110,100,32,109,97,121,98,101,32,111,116,104,101,114,115,0,0,0,0,0,0,0,0,122,97,112,102,95,100,105,110,103,98,97,116,115,0,0,0,121,116,105,36,99,115,0,0,80,97,117,115,101,0,0,0,122,36,97,112,102,95,100,105,110,103,98,97,116,115,0,0,9,84,114,121,32,116,111,32,115,101,116,32,76,79,67,75,69,68,32,97,115,112,101,99,116,32,114,97,116,105,111,32,116,111,32,37,103,58,49,46,48,10,0,0,0,0,0,0,85,110,114,101,99,111,103,105,110,105,122,101,100,32,111,98,106,101,99,116,32,116,121,112,101,0,0,0,0,0,0,0,32,116,111,112,0,0,0,0,99,103,95,116,105,109,101,115,0,0,0,0,0,0,0,0,108,102,32,116,111,107,101,110,115,0,0,0,0,0,0,0,96,98,117,105,108,116,105,110,45,116,111,103,103,108,101,45,118,101,114,98,111,115,101,96,0,0,0,0,0,0,0,0,99,103,95,116,36,105,109,101,115,0,0,0,0,0,0,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,58,32,115,117,98,115,116,114,105,110,103,32,114,97,110,103,101,32,115,112,101,99,105,102,105,101,114,115,32,109,117,115,116,32,104,97,118,101,32,105,110,116,101,103,101,114,32,118,97,108,117,101,115,0,0,0,0,0,115,116,105,99,107,0,0,0,100,102,95,110,111,95,117,115,101,95,115,112,101,99,115,32,61,61,32,48,32,124,124,32,111,117,116,112,117,116,32,61,61,32,100,102,95,110,111,95,117,115,101,95,115,112,101,99,115,32,124,124,32,111,117,116,112,117,116,32,61,61,32,109,97,120,0,0,0,0,0,0,115,36,116,105,99,107,0,0,117,110,105,118,101,114,115,0,117,36,110,105,118,101,114,115,0,0,0,0,0,0,0,0,53,44,37,100,44,54,44,37,100,44,55,44,37,100,59,83,83,59,10,0,0,0,0,0,51,44,37,102,44,0,0,0,104,112,50,54,50,51,65,0,52,44,37,102,44,0,0,0,110,111,120,50,116,105,36,99,115,0,0,0,0,0,0,0,83,68,49,44,37,100,44,50,44,37,100,44,0,0,0,0,9,78,111,32,97,116,116,101,109,112,116,32,116,111,32,99,111,110,116,114,111,108,32,97,115,112,101,99,116,32,114,97,116,105,111,10,0,0,0,0,85,110,114,101,99,111,103,110,105,122,101,100,32,112,111,108,121,103,111,110,32,115,121,110,116,97,120,0,0,0,0,0,36,0,0,0,0,0,0,0,115,101,116,32,115,105,122,101,32,115,113,117,97,114,101,0,37,100,32,37,115,32,91,37,49,100,44,37,49,100,93,0,99,111,117,114,0,0,0,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,58,32,117,110,107,110,111,119,110,32,99,111,108,117,109,110,32,116,121,112,101,0,0,0,0,0,37,37,46,37,100,102,0,0,37,115,37,48,50,100,0,0,64,100,111,99,117,109,101,110,116,40,108,97,110,103,117,97,103,101,32,105,109,112,114,101,115,115,44,32,112,97,112,101,114,32,97,52,41,0,0,0,99,111,110,118,101,114,116,101,100,32,108,97,98,101,108,32,115,116,114,105,110,103,0,0,63,36,0,0,0,0,0,0,104,36,101,108,112,0,0,0,70,73,71,32,103,114,97,112,104,105,99,115,32,108,97,110,103,117,97,103,101,32,102,111,114,32,88,70,73,71,32,103,114,97,112,104,105,99,115,32,101,100,105,116,111,114,0,0,112,36,111,108,121,108,105,110,101,0,0,0,0,0,0,0,120,50,116,105,36,99,115,0,118,36,101,99,116,111,114,115,0,0,0,0,0,0,0,0,9,84,114,121,32,116,111,32,115,101,116,32,97,115,112,101,99,116,32,114,97,116,105,111,32,116,111,32,37,103,58,49,46,48,10,0,0,0,0,0,80,111,108,121,103,111,110,32,105,115,32,110,111,116,32,99,108,111,115,101,100,32,45,32,97,100,100,105,110,103,32,101,120,116,114,97,32,118,101,114,116,101,120,10,0,0,0,0,118,101,99,116,111,114,115,0,115,101,116,32,115,105,122,101,32,110,111,115,113,117,97,114,101,0,0,0,0,0,0,0,112,111,108,121,108,105,110,101,0,0,0,0,0,0,0,0,99,111,108,111,117,114,0,0,113,117,111,116,101,0,0,0,85,115,97,103,101,58,32,115,101,116,32,116,101,114,109,105,110,97,108,32,109,105,102,32,91,111,112,116,105,111,110,115,93,10,9,111,112,116,105,111,110,115,58,10,9,9,99,111,108,111,117,114,32,47,32,32,32,32,32,32,32,32,68,114,97,119,32,112,114,105,109,105,116,105,118,101,115,32,119,105,116,104,32,108,105,110,101,32,116,121,112,101,115,32,62,61,32,48,32,105,110,32,99,111,108,111,117,114,32,40,115,101,112,46,32,50,45,55,41,10,9,9,109,111,110,111,99,104,114,111,109,101,32,32,32,32,32,32,68,114,97,119,32,112,114,105,109,105,116,105,118,101,115,32,105,110,32,98,108,97,99,107,32,40,115,101,112,46,32,48,41,10,10,9,9,112,111,108,121,108,105,110,101,32,47,32,32,32,32,32,32,68,114,97,119,32,108,105,110,101,115,32,97,115,32,99,111,110,116,105,110,117,111,117,115,32,99,117,114,118,101,115,10,9,9,118,101,99,116,111,114,115,32,32,32,32,32,32,32,32,32,68,114,97,119,32,108,105,110,101,115,32,97,115,32,99,111,108,108,101,99,116,105,111,110,115,32,111,102,32,118,101,99,116,111,114,115,10,10,9,9,104,101,108,112,32,47,32,63,32,32,32,32,32,32,32,32,80,114,105,110,116,32,115,104,111,114,116,32,117,115,97,103,101,32,100,101,115,99,114,105,112,116,105,111,110,32,111,110,32,115,116,100,101,114,114,10,0,0,0,0,0,0,0,78,117,109,98,101,114,32,111,102,32,112,105,120,101,108,115,32,99,97,110,110,111,116,32,98,101,32,102,97,99,116,111,114,101,100,32,105,110,116,111,32,105,110,116,101,103,101,114,115,32,109,97,116,99,104,105,110,103,32,103,114,105,100,46,32,78,32,61,32,37,100,32,32,75,32,61,32,37,100,0,67,101,110,116,101,114,95,50,0,0,0,0,0,0,0,0,60,77,73,70,70,105,108,101,32,51,46,48,48,62,32,35,32,71,101,110,101,114,97,116,101,100,32,98,121,32,103,110,117,112,108,111,116,32,118,101,114,115,105,111,110,32,37,115,32,112,97,116,99,104,108,101,118,101,108,32,37,115,59,32,105,100,101,110,116,105,102,105,101,115,32,116,104,105,115,32,97,115,32,97,32,77,73,70,32,102,105,108,101,10,35,10,35,32,115,104,111,119,32,98,111,114,100,101,114,115,10,60,68,111,99,117,109,101,110,116,10,60,68,66,111,114,100,101,114,115,79,110,32,89,101,115,62,10,62,10,35,32,83,101,116,32,97,32,100,101,102,97,117,108,116,32,112,101,110,32,112,97,116,116,101,114,110,44,32,112,101,110,32,119,105,100,116,104,44,32,117,110,105,116,32,97,110,100,32,102,111,110,116,32,102,111,114,32,115,117,98,115,101,113,117,101,110,116,32,111,98,106,101,99,116,115,10,60,80,101,110,32,48,62,10,60,70,105,108,108,32,49,53,62,10,60,80,101,110,87,105,100,116,104,32,48,46,53,32,112,116,62,10,60,83,101,112,97,114,97,116,105,111,110,32,48,62,10,60,85,110,105,116,115,32,85,99,109,62,10,60,70,111,110,116,67,97,116,97,108,111,103,10,9,60,70,111,110,116,32,60,70,84,97,103,32,96,37,115,39,62,60,70,70,97,109,105,108,121,32,96,84,105,109,101,115,39,62,60,70,83,105,122,101,32,37,100,62,60,70,80,108,97,105,110,32,89,101,115,62,62,10,9,60,70,111,110,116,32,60,70,84,97,103,32,96,37,115,39,62,60,70,70,97,109,105,108,121,32,96,90,97,112,102,68,105,110,103,98,97,116,115,39,62,60,70,83,105,122,101,32,55,46,48,32,112,116,62,60,70,80,108,97,105,110,32,89,101,115,62,62,10,9,60,70,111,110,116,32,60,70,84,97,103,32,96,37,115,39,62,60,70,70,97,109,105,108,121,32,96,83,121,109,98,111,108,39,62,60,70,83,105,122,101,32,53,46,48,32,112,116,62,60,70,80,108,97,105,110,32,89,101,115,62,62,10,62,10,35,10,0,0,0,0,0,0,35,10,35,32,69,110,100,32,111,102,32,77,73,70,70,105,108,101,10,0,0,0,0,0,62,10,35,32,69,110,100,32,111,102,32,70,114,97,109,101,32,110,117,109,98,101,114,32,37,100,10,35,10,0,0,0,37,115,95,37,115,95,37,115,0,0,0,0,0,0,0,0,9,60,71,114,111,117,112,10,9,9,60,73,68,32,37,100,62,10,9,62,10,0,0,0,102,105,103,0,0,0,0,0,9,35,10,9,35,32,71,114,111,117,112,32,116,104,101,32,116,104,101,32,111,98,106,101,99,116,115,32,105,110,32,103,114,111,117,112,115,32,116,111,32,109,97,107,101,32,116,104,101,32,99,104,97,114,116,32,101,97,115,105,101,114,32,116,111,32,109,97,110,105,112,117,108,97,116,101,10,9,35,32,97,102,116,101,114,32,105,116,39,115,32,105,109,112,111,114,116,101,100,32,105,110,116,111,32,70,114,97,109,101,77,97,107,101,114,46,10,0,0,0,110,111,120,116,105,36,99,115,0,0,0,0,0,0,0,0,35,10,35,32,70,114,97,109,101,32,110,117,109,98,101,114,32,37,100,32,119,105,116,104,32,112,108,111,116,32,111,102,32,103,114,97,112,104,105,99,115,10,60,70,114,97,109,101,10,9,60,80,101,110,32,49,53,62,10,9,60,70,105,108,108,32,49,53,62,10,9,60,80,101,110,87,105,100,116,104,32,32,48,46,53,32,112,116,62,10,9,60,83,101,112,97,114,97,116,105,111,110,32,48,62,10,9,60,66,82,101,99,116,32,50,46,48,48,48,32,37,46,51,102,32,37,46,51,102,32,37,46,51,102,62,10,9,60,78,83,79,102,102,115,101,116,32,32,48,46,48,48,48,62,10,9,60,66,76,79,102,102,115,101,116,32,32,48,46,48,48,48,62,10,0,0,9,115,105,122,101,32,105,115,32,115,99,97,108,101,100,32,98,121,32,37,103,44,37,103,10,0,0,0,0,0,0,0,112,111,108,121,103,111,110,32,118,101,114,116,101,120,0,0,77,73,70,32,100,114,105,118,101,114,0,0,0,0,0,0,115,101,116,32,115,105,122,101,32,114,97,116,105,111,32,45,49,0,0,0,0,0,0,0,32,60,80,101,110,32,37,100,62,32,0,0,0,0,0,0,32,60,70,111,110,116,32,60,70,83,101,112,97,114,97,116,105,111,110,32,37,100,62,62,32,0,0,0,0,0,0,0,76,97,115,116,32,112,111,105,110,116,32,105,110,32,116,104,101,32,98,105,110,97,114,121,32,102,105,108,101,32,100,105,100,32,110,111,116,32,109,97,116,99,104,32,116,104,101,32,115,112,101,99,105,102,105,101,100,32,96,117,115,105,110,103,96,32,99,111,108,117,109,110,115,0,0,0,0,0,0,0,32,60,83,101,112,97,114,97,116,105,111,110,32,37,100,62,32,0,0,0,0,0,0,0,32,60,80,101,110,87,105,100,116,104,32,48,46,49,32,112,116,62,32,0,0,0,0,0,32,60,70,111,110,116,32,60,70,83,101,112,97,114,97,116,105,111,110,32,48,62,62,32,0,0,0,0,0,0,0,0,32,60,80,101,110,87,105,100,116,104,32,49,46,48,32,112,116,62,32,0,0,0,0,0,71,80,86,65,76,95,68,65,84,65,0,0,0,0,0,0,120,94,52,0,0,0,0,0,32,60,83,101,112,97,114,97,116,105,111,110,32,48,62,32,0,0,0,0,0,0,0,0,69,110,104,97,110,99,101,100,32,77,101,116,97,102,105,108,101,32,102,111,114,109,97,116,0,0,0,0,0,0,0,0,9,9,60,84,76,79,114,105,103,105,110,32,32,37,46,51,102,32,37,46,51,102,62,32,37,115,32,60,65,110,103,108,101,32,37,100,62,32,60,83,116,114,105,110,103,32,96,37,115,39,62,10,9,62,10,0,120,116,105,36,99,115,0,0,9,60,84,101,120,116,76,105,110,101,32,60,71,114,111,117,112,73,68,32,37,100,62,32,37,115,32,37,115,32,37,115,32,37,115,10,0,0,0,0,9,111,114,105,103,105,110,32,105,115,32,115,101,116,32,116,111,32,37,103,44,37,103,10,0,0,0,0,0,0,0,0,69,120,112,101,99,116,105,110,103,32,97,114,99,32,91,60,98,101,103,105,110,62,58,60,101,110,100,62,93,0,0,0,97,116,32,0,0,0,0,0,32,60,84,76,65,108,105,103,110,109,101,110,116,32,82,105,103,104,116,62,32,0,0,0,96,98,117,105,108,116,105,110,45,116,111,103,103,108,101,45,114,97,116,105,111,96,0,0,32,60,84,76,65,108,105,103,110,109,101,110,116,32,67,101,110,116,101,114,62,32,0,0,45,86,0,0,0,0,0,0,32,60,84,76,65,108,105,103,110,109,101,110,116,32,76,101,102,116,62,32,0,0,0,0,110,111,116,32,101,110,111,117,103,104,32,109,101,109,111,114,121,32,116,111,32,99,114,101,97,116,101,32,118,101,99,116,111,114,0,0,0,0,0,0,9,60,80,111,108,121,76,105,110,101,32,60,71,114,111,117,112,73,68,32,37,100,62,32,37,115,32,37,115,32,37,115,32,60,70,105,108,108,32,49,53,62,10,0,0,0,0,0,9,9,60,70,111,110,116,10,9,9,9,60,70,84,97,103,32,96,37,115,39,62,10,9,9,62,10,0,0,0,0,0,9,62,10,0,0,0,0,0,9,9,60,84,76,79,114,105,103,105,110,32,32,37,46,51,102,32,37,46,51,102,62,32,37,115,32,60,83,116,114,105,110,103,32,96,37,99,39,62,10,0,0,0,0,0,0,0,76,79,71,0,0,0,0,0,9,60,84,101,120,116,76,105,110,101,32,60,71,114,111,117,112,73,68,32,37,100,62,32,37,115,10,0,0,0,0,0,101,109,102,0,0,0,0,0,9,9,60,83,104,97,112,101,82,101,99,116,32,37,46,51,102,32,37,46,51,102,32,37,46,51,102,32,37,46,51,102,62,10,0,0,0,0,0,0,99,98,108,36,97,98,101,108,0,0,0,0,0,0,0,0,9,60,82,101,99,116,97,110,103,108,101,32,60,71,114,111,117,112,73,68,32,37,100,62,32,37,115,10,0,0,0,0,9,116,101,114,109,105,110,97,108,32,116,121,112,101,32,105,115,32,117,110,107,110,111,119,110,10,0,0,0,0,0,0,58,0,0,0,0,0,0,0,114,109,97,114,103,105,110,0,10,9,62,10,0,0,0,0,110,101,120,116,32,122,111,111,109,46,10,0,0,0,0,0,60,80,111,105,110,116,32,32,37,46,51,102,32,37,46,51,102,62,32,0,0,0,0,0,9,9,60,78,117,109,80,111,105,110,116,115,32,37,100,62,32,0,0,0,0,0,0,0,103,112,98,105,110,97,114,121,32,109,97,116,114,105,120,32,114,111,119,0,0,0,0,0,9,9,60,70,105,108,108,32,37,100,62,10,0,0,0,0,9,60,80,111,108,121,103,111,110,32,60,71,114,111,117,112,73,68,32,37,100,62,10,0,110,111,98,97,99,107,103,36,114,111,117,110,100,0,0,0,110,111,97,100,111,98,101,36,103,108,121,112,104,110,97,109,101,115,0,0,0,0,0,0,77,65,88,0,0,0,0,0,97,100,111,98,101,36,103,108,121,112,104,110,97,109,101,115,0,0,0,0,0,0,0,0,100,120,102,45,102,105,108,101,32,102,111,114,32,65,117,116,111,67,97,100,32,40,100,101,102,97,117,108,116,32,115,105,122,101,32,49,50,48,120,56,48,41,0,0,0,0,0,0,110,101,119,36,115,116,121,108,101,0,0,0,0,0,0,0,122,108,36,97,98,101,108,0,111,108,100,36,115,116,121,108,101,0,0,0,0,0,0,0,32,32,32,116,101,114,109,105,110,97,108,32,116,121,112,101,32,105,115,32,37,115,32,37,115,10,0,0,0,0,0,0,65,110,103,108,101,32,111,117,116,32,111,102,32,114,97,110,103,101,0,0,0,0,0,0,108,109,97,114,103,105,110,0,110,111,97,36,117,120,102,105,108,101,0,0,0,0,0,0,96,98,117,105,108,116,105,110,45,122,111,111,109,45,110,101,120,116,96,32,103,111,32,116,111,32,110,101,120,116,32,122,111,111,109,32,105,110,32,116,104,101,32,122,111,111,109,32,115,116,97,99,107,0,0,0,97,36,117,120,102,105,108,101,0,0,0,0,0,0,0,0,110,36,111,114,111,116,97,116,101,0,0,0,0,0,0,0,66,105,110,97,114,121,32,100,97,116,97,32,116,121,112,101,32,117,110,107,110,111,119,110,0,0,0,0,0,0,0,0,112,97,108,102,36,117,110,99,112,97,114,97,109,0,0,0,110,111,102,111,110,116,102,36,105,108,101,115,0,0,0,0,9,102,111,110,116,112,97,116,104,32,105,115,32,0,0,0,102,111,110,116,102,36,105,108,101,0,0,0,0,0,0,0,32,107,77,71,84,80,69,90,89,0,0,0,0,0,0,0,114,111,117,36,110,100,101,100,0,0,0,0,0,0,0,0,10,9,100,117,109,109,121,32,118,97,114,105,97,98,108,101,32,105,115,32,120,32,102,111,114,32,99,117,114,118,101,115,44,32,120,47,121,32,102,111,114,32,115,117,114,102,97,99,101,115,10,0,0,0,0,0,46,37,48,42,100,0,0,0,77,73,78,0,0,0,0,0,100,101,102,97,117,108,116,112,36,108,101,120,0,0,0,0,100,120,102,0,0,0,0,0,100,117,36,112,108,101,120,0,121,50,108,36,97,98,101,108,0,0,0,0,0,0,0,0,115,105,36,109,112,108,101,120,0,0,0,0,0,0,0,0])
.concat([97,114,99,0,0,0,0,0,98,109,97,114,103,105,110,0,99,111,108,111,117,114,116,36,101,120,116,0,0,0,0,0,112,114,101,118,105,111,117,115,32,122,111,111,109,46,10,0,99,111,108,111,114,116,36,101,120,116,0,0,0,0,0,0,98,36,108,97,99,107,116,101,120,116,0,0,0,0,0,0,67,111,117,108,100,110,39,116,32,115,108,117,114,112,32,37,108,100,32,98,121,116,101,115,32,40,114,101,116,117,114,110,32,119,97,115,32,37,122,100,41,10,0,0,0,0,0,0,100,101,102,36,97,117,108,116,0,0,0,0,0,0,0,0,109,36,111,110,111,99,104,114,111,109,101,0,0,0,0,0,116,104,105,115,0,0,0,0,120,111,114,0,0,0,0,0,101,112,36,115,102,0,0,0,32,102,111,110,116,115,99,97,108,101,32,37,51,46,49,102,32,0,0,0,0,0,0,0,37,103,32,0,0,0,0,0,71,80,86,65,76,0,0,0,34,37,115,34,32,37,103,32,0,0,0,0,0,0,0,0,97,115,99,105,105,32,97,114,116,32,102,111,114,32,97,110,121,116,104,105,110,103,32,116,104,97,116,32,112,114,105,110,116,115,32,116,101,120,116,0,34,37,115,34,32,37,103,37,115,32,0,0,0,0,0,0,121,108,36,97,98,101,108,0,100,102,95,114,101,97,100,98,105,110,97,114,121,32,115,108,117,114,112,101,114,0,0,0,112,97,36,117,115,101,0,0,32,37,115,97,100,111,98,101,103,108,121,112,104,110,97,109,101,115,32,92,10,32,32,32,0,0,0,0,0,0,0,0,114,97,100,105,117,115,0,0,111,117,116,36,112,117,116,0,116,109,97,114,103,105,110,0,110,111,104,101,97,100,101,114,32,0,0,0,0,0,0,0,96,98,117,105,108,116,105,110,45,122,111,111,109,45,112,114,101,118,105,111,117,115,96,32,103,111,32,116,111,32,112,114,101,118,105,111,117,115,32,122,111,111,109,32,105,110,32,116,104,101,32,122,111,111,109,32,115,116,97,99,107,0,0,0,104,101,97,100,101,114,32,34,37,115,34,32,0,0,0,0,110,111,97,117,120,102,105,108,101,0,0,0,0,0,0,0,97,117,120,102,105,108,101,0,37,115,32,37,115,32,0,0,32,32,32,112,97,108,102,117,110,99,112,97,114,97,109,32,37,100,44,37,103,32,92,10,32,32,32,0,0,0,0,0,45,66,65,67,75,87,65,82,68,83,95,67,79,77,80,65,84,73,66,73,76,73,84,89,32,32,0,0,0,0,0,0,32,32,32,110,111,98,97,99,107,103,114,111,117,110,100,32,92,10,0,0,0,0,0,0,71,80,86,65,76,95,84,69,82,77,95,89,83,73,90,69,0,0,0,0,0,0,0,0,32,32,32,98,97,99,107,103,114,111,117,110,100,32,34,35,37,48,50,120,37,48,50,120,37,48,50,120,34,32,92,10,0,0,0,0,0,0,0,0,100,117,109,98,0,0,0,0,110,111,99,108,105,112,0,0,120,50,108,36,97,98,101,108,0,0,0,0,0,0,0,0,99,108,105,112,0,0,0,0,116,105,99,115,32,97,114,101,32,105,110,32,37,115,32,111,102,32,112,108,111,116,10,0,99,101,110,36,116,101,114,0,111,117,116,115,105,100,101,0,99,111,108,111,114,116,101,120,116,0,0,0,0,0,0,0,98,108,97,99,107,116,101,120,116,0,0,0,0,0,0,0,108,101,118,101,108,100,101,102,97,117,108,116,0,0,0,0,83,99,97,110,32,115,105,122,101,32,111,102,32,109,97,116,114,105,120,32,105,115,32,122,101,114,111,0,0,0,0,0,115,101,116,32,97,117,116,111,115,99,97,108,101,32,37,115,102,105,120,109,105,110,10,0,108,101,118,101,108,49,0,0,84,104,105,115,32,112,108,111,116,32,115,116,121,108,101,32,105,115,32,111,110,108,121,32,102,111,114,32,100,97,116,97,102,105,108,101,115,32,44,32,114,101,118,101,114,116,105,110,103,32,116,111,32,34,112,111,105,110,116,115,34,0,0,0,32,32,32,37,115,32,37,115,32,37,115,32,92,10,32,32,32,37,115,32,100,97,115,104,108,101,110,103,116,104,32,37,46,49,102,32,108,105,110,101,119,105,100,116,104,32,37,46,49,102,32,37,115,32,37,115,32,92,10,0,0,0,0,0,32,97,117,120,102,105,108,101,0,0,0,0,0,0,0,0,115,121,110,116,97,120,58,32,32,103,110,117,112,108,111,116,32,45,101,32,34,99,111,109,109,97,110,100,115,34,10,0,110,111,114,111,116,97,116,101,0,0,0,0,0,0,0,0,71,80,86,65,76,95,84,69,82,77,95,88,83,73,90,69,0,0,0,0,0,0,0,0,114,111,116,97,116,101,0,0,114,101,102,114,101,115,104,32,110,111,116,32,112,111,115,115,105,98,108,101,32,97,110,100,32,114,101,112,108,111,116,32,105,115,32,100,105,115,97,98,108,101,100,0,0,0,0,0,69,80,83,32,102,111,114,109,97,116,32,102,111,114,32,67,111,114,101,108,68,82,65,87,0,0,0,0,0,0,0,0,100,101,102,97,117,108,116,112,108,101,120,0,0,0,0,0,120,108,36,97,98,101,108,0,67,108,101,97,114,0,0,0,115,105,109,112,108,101,120,0,9,120,121,112,108,97,110,101,32,116,105,99,115,108,101,118,101,108,32,105,115,32,37,103,10,0,0,0,0,0,0,0,69,120,112,101,99,116,105,110,103,32,116,111,32,111,114,32,114,116,111,0,0,0,0,0,105,110,115,105,100,101,0,0,100,117,112,108,101,120,0,0,108,111,97,100,47,101,118,97,108,32,110,101,115,116,101,100,32,116,111,111,32,100,101,101,112,108,121,0,0,0,0,0,59,32,115,101,116,32,120,50,114,91,37,32,35,103,58,37,32,35,103,93,59,32,115,101,116,32,121,50,114,91,37,32,35,103,58,37,32,35,103,93,0,0,0,0,0,0,0,0,110,111,101,110,104,97,110,99,101,100,0,0,0,0,0,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,32,58,32,110,111,110,45,83,84,82,73,78,71,32,97,114,103,117,109,101,110,116,32,116,111,32,115,116,114,115,116,114,116,0,37,115,32,37,115,32,37,115,32,92,10,0,0,0,0,0,100,102,95,110,111,95,98,105,110,95,99,111,108,115,0,0,32,102,111,110,116,102,105,108,101,32,34,37,115,34,0,0,112,115,95,102,111,110,116,102,105,108,101,95,99,104,97,114,0,0,0,0,0,0,0,0,37,115,44,37,103,0,0,0,111,102,32,102,111,110,116,32,110,97,109,101,0,0,0,0,71,80,86,65,76,95,84,69,82,77,95,89,77,65,88,0,116,101,114,109,105,110,97,108,32,37,115,32,100,111,101,115,32,110,111,116,32,97,108,108,111,119,32,115,112,101,99,105,102,105,99,97,116,105,111,110,32,37,115,0,0,0,0,0,99,111,114,101,108,0,0,0,73,32,119,105,108,108,32,116,114,121,32,116,111,32,102,105,120,32,105,116,32,98,117,116,32,116,104,105,115,32,109,97,121,32,110,111,116,32,119,111,114,107,46,0,0,0,0,0,99,98,100,97,36,116,97,0,73,108,108,101,103,97,108,32,99,104,97,114,97,99,116,101,114,115,32,105,110,32,80,111,115,116,83,99,114,105,112,116,32,102,111,110,116,32,110,97,109,101,46,0,0,0,0,0,9,120,121,112,108,97,110,101,32,105,110,116,101,114,99,101,112,116,115,32,122,32,97,120,105,115,32,97,116,32,37,103,10,0,0,0,0,0,0,0,114,101,108,97,116,105,118,101,32,99,111,111,114,100,105,110,97,116,101,115,32,109,117,115,116,32,109,97,116,99,104,32,105,110,32,116,121,112,101,0,115,101,116,32,107,101,121,32,0,0,0,0,0,0,0,0,40,41,91,93,123,125,124,32,0,0,0,0,0,0,0,0,115,101,116,32,120,114,91,37,46,49,50,103,58,37,46,49,50,103,93,59,32,115,101,116,32,121,114,91,37,46,49,50,103,58,37,46,49,50,103,93,0,0,0,0,0,0,0,0,97,108,108,111,119,101,100,32,100,101,118,105,97,116,105,111,110,32,109,117,115,116,32,98,101,32,60,32,49,0,0,0,67,97,110,39,116,32,100,101,108,101,116,101,32,70,111,110,116,32,102,105,108,101,110,97,109,101,32,39,37,115,39,0,100,102,95,109,97,120,95,98,105,110,105,110,102,111,95,99,111,108,115,32,62,32,100,102,95,110,111,95,98,105,110,95,99,111,108,115,0,0,0,0,37,32,103,0,0,0,0,0,110,101,119,95,112,115,95,102,111,110,116,102,105,108,101,45,62,102,111,110,116,102,105,108,101,95,110,97,109,101,0,0,110,101,119,95,112,115,95,102,111,110,116,102,105,108,101,0,115,101,116,32,104,105,100,100,101,110,51,100,32,37,115,32,111,102,102,115,101,116,32,37,100,32,116,114,105,97,110,103,108,101,112,97,116,116,101,114,110,32,37,108,100,32,117,110,100,101,102,105,110,101,100,32,37,100,32,37,115,97,108,116,100,105,97,103,111,110,97,108,32,37,115,98,101,110,116,111,118,101,114,10,0,0,0,0,100,101,108,36,101,116,101,0,97,100,100,0,0,0,0,0,71,80,86,65,76,95,84,69,82,77,95,89,77,73,78,0,67,97,110,110,111,116,32,117,115,101,32,97,117,120,32,102,105,108,101,32,111,110,32,115,116,100,111,117,116,46,32,83,119,105,116,99,104,105,110,103,32,111,102,102,32,97,117,120,102,105,108,101,32,111,112,116,105,111,110,46,10,0,0,0,67,111,109,112,117,116,101,114,32,71,114,97,112,104,105,99,115,32,77,101,116,97,102,105,108,101,0,0,0,0,0,0,84,117,114,110,105,110,103,32,111,102,102,32,97,117,120,102,105,108,101,32,111,112,116,105,111,110,10,0,0,0,0,0,122,100,97,36,116,97,0,0,67,97,110,110,111,116,32,109,97,107,101,32,80,111,115,116,83,99,114,105,112,116,32,102,105,108,101,32,110,97,109,101,32,102,114,111,109,32,37,115,10,0,0,0,0,0,0,0,85,110,107,110,111,119,110,32,109,105,110,105,116,105,99,32,116,121,112,101,32,105,110,32,115,104,111,119,95,109,116,105,99,115,40,41,0,0,0,0,114,116,111,0,0,0,0,0,67,97,110,110,111,116,32,111,112,101,110,32,97,117,120,32,102,105,108,101,32,37,115,32,102,111,114,32,111,117,116,112,117,116,46,32,83,119,105,116,99,104,105,110,103,32,111,102,102,32,97,117,120,102,105,108,101,32,111,112,116,105,111,110,46,10,0,0,0,0,0,0,117,110,122,111,111,109,46,10,0,0,0,0,0,0,0,0,112,115,108,97,116,101,120,32,97,117,120,32,102,105,108,101,110,97,109,101,0,0,0,0,109,97,120,32,60,61,32,77,65,88,68,65,84,65,67,79,76,83,0,0,0,0,0,0,73,109,97,103,101,32,103,114,105,100,32,109,117,115,116,32,98,101,32,97,116,32,108,101,97,115,116,32,50,32,120,32,50,46,10,10,0,0,0,0,101,112,115,108,97,116,101,120,32,84,101,88,32,102,105,108,101,110,97,109,101,0,0,0,111,112,101,110,32,111,102,32,112,111,115,116,115,99,105,112,116,32,111,117,116,112,117,116,32,102,105,108,101,32,37,115,32,102,97,105,108,101,100,0,67,101,110,116,101,114,95,49,0,0,0,0,0,0,0,0,46,37,115,0,0,0,0,0,45,105,110,99,46,37,115,0,71,80,86,65,76,95,84,69,82,77,95,88,77,65,88,0,45,45,45,32,114,101,111,112,101,110,32,102,97,105,108,101,100,0,0,0,0,0,0,0,99,103,109,0,0,0,0,0,82,101,115,101,116,116,105,110,103,32,112,114,105,109,97,114,121,32,111,117,116,112,117,116,32,102,105,108,101,32,116,111,32,37,115,44,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,80,111,115,116,83,99,114,105,112,116,32,111,117,116,112,117,116,32,116,111,32,37,115,0,0,121,50,100,97,36,116,97,0,9,109,105,110,111,114,32,37,115,116,105,99,115,32,97,114,101,32,100,114,97,119,110,32,119,105,116,104,32,37,100,32,115,117,98,105,110,116,101,114,118,97,108,115,32,98,101,116,119,101,101,110,32,109,97,106,111,114,32,120,116,105,99,32,109,97,114,107,115,10,0,0,116,111,0,0,0,0,0,0,115,101,116,32,107,101,121,32,116,105,116,108,101,32,34,37,115,34,0,0,0,0,0,0,103,105,118,101,32,116,104,101,32,116,101,120,32,102,105,108,101,110,97,109,101,32,97,115,32,111,117,116,112,117,116,0,96,98,117,105,108,116,105,110,45,117,110,122,111,111,109,96,0,0,0,0,0,0,0,0,70,111,114,32,101,112,115,108,97,116,101,120,32,115,116,97,110,100,97,108,111,110,101,32,109,111,100,101,44,32,121,111,117,32,104,97,118,101,32,116,111,32,37,115,0,0,0,0,46,69,80,83,0,0,0,0,100,97,116,97,95,102,112,32,33,61,32,78,85,76,76,0,46,101,112,115,0,0,0,0,101,112,115,108,97,116,101,120,32,101,112,115,32,102,105,108,101,110,97,109,101,0,0,0,101,112,115,108,97,116,101,120,32,111,117,116,112,117,116,32,102,105,108,101,32,110,97,109,101,32,109,117,115,116,32,98,101,32,111,102,32,116,104,101,32,102,111,114,109,32,102,105,108,101,110,97,109,101,46,120,120,120,0,0,0,0,0,0,92,112,117,116,40,48,44,48,41,123,92,99,111,108,111,114,98,111,120,123,103,112,66,97,99,107,103,114,111,117,110,100,125,123,92,109,97,107,101,98,111,120,40,37,46,50,102,44,37,46,50,102,41,91,93,123,125,125,125,37,37,10,0,0,71,80,86,65,76,95,84,69,82,77,95,88,77,73,78,0,100,117,112,32,109,117,108,32,100,117,112,32,109,117,108,0,92,100,101,102,105,110,101,99,111,108,111,114,123,103,112,66,97,99,107,103,114,111,117,110,100,125,123,114,103,98,125,123,37,46,51,102,44,32,37,46,51,102,44,32,37,46,51,102,125,37,37,10,0,0,0,0,72,84,77,76,32,67,97,110,118,97,115,32,111,98,106,101,99,116,0,0,0,0,0,0,32,32,92,115,101,116,108,101,110,103,116,104,123,92,117,110,105,116,108,101,110,103,116,104,125,123,37,46,52,102,98,112,125,37,37,10,32,32,92,98,101,103,105,110,123,112,105,99,116,117,114,101,125,40,37,46,50,102,44,37,46,50,102,41,37,37,10,0,0,0,0,0,121,100,97,36,116,97,0,0,32,32,32,32,92,101,108,115,101,10,32,32,32,32,32,32,37,32,103,114,97,121,10,32,32,32,32,32,32,92,100,101,102,92,99,111,108,111,114,114,103,98,35,49,123,92,99,111,108,111,114,123,98,108,97,99,107,125,125,37,10,32,32,32,32,32,32,92,100,101,102,92,99,111,108,111,114,103,114,97,121,35,49,123,92,99,111,108,111,114,91,103,114,97,121,93,123,35,49,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,119,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,123,119,104,105,116,101,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,98,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,123,98,108,97,99,107,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,97,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,123,98,108,97,99,107,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,48,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,123,98,108,97,99,107,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,49,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,123,98,108,97,99,107,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,50,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,123,98,108,97,99,107,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,51,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,123,98,108,97,99,107,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,52,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,123,98,108,97,99,107,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,53,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,123,98,108,97,99,107,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,54,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,123,98,108,97,99,107,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,55,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,123,98,108,97,99,107,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,56,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,123,98,108,97,99,107,125,125,37,10,32,32,32,32,92,102,105,10,32,32,92,102,105,10,0,0,0,9,109,105,110,111,114,32,37,115,116,105,99,115,32,97,114,101,32,99,111,109,112,117,116,101,100,32,97,117,116,111,109,97,116,105,99,97,108,108,121,10,0,0,0,0,0,0,0,102,114,111,109,0,0,0,0,37,115,115,101,116,32,114,97,120,105,115,10,0,0,0,0,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,48,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,91,114,103,98,93,123,49,44,48,44,48,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,49,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,91,114,103,98,93,123,48,44,49,44,48,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,50,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,91,114,103,98,93,123,48,44,48,44,49,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,51,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,91,114,103,98,93,123,49,44,48,44,49,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,52,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,91,114,103,98,93,123,48,44,49,44,49,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,53,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,91,114,103,98,93,123,49,44,49,44,48,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,54,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,91,114,103,98,93,123,48,44,48,44,48,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,55,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,91,114,103,98,93,123,49,44,48,46,51,44,48,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,56,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,91,114,103,98,93,123,48,46,53,44,48,46,53,44,48,46,53,125,125,37,10,0,0,0,0,0,0,0,96,98,117,105,108,116,105,110,45,114,111,116,97,116,101,45,114,105,103,104,116,96,32,111,110,108,121,32,102,111,114,32,115,112,108,111,116,115,59,32,60,115,104,105,102,116,62,32,105,110,99,114,101,97,115,101,115,32,97,109,111,117,110,116,0,0,0,0,0,0,0,0,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,48,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,91,114,103,98,93,123,49,44,48,44,48,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,49,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,91,114,103,98,93,123,48,44,48,44,49,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,50,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,91,114,103,98,93,123,48,44,49,44,49,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,51,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,91,114,103,98,93,123,49,44,48,44,49,125,125,37,10,0,0,0,0,32,32,92,105,102,71,80,98,108,97,99,107,116,101,120,116,10,32,32,32,32,37,32,110,111,32,116,101,120,116,99,111,108,111,114,32,97,116,32,97,108,108,10,32,32,32,32,92,100,101,102,92,99,111,108,111,114,114,103,98,35,49,123,125,37,10,32,32,32,32,92,100,101,102,92,99,111,108,111,114,103,114,97,121,35,49,123,125,37,10,32,32,92,101,108,115,101,10,32,32,32,32,37,32,103,114,97,121,32,111,114,32,99,111,108,111,114,63,10,32,32,32,32,92,105,102,71,80,99,111,108,111,114,10,32,32,32,32,32,32,92,100,101,102,92,99,111,108,111,114,114,103,98,35,49,123,92,99,111,108,111,114,91,114,103,98,93,123,35,49,125,125,37,10,32,32,32,32,32,32,92,100,101,102,92,99,111,108,111,114,103,114,97,121,35,49,123,92,99,111,108,111,114,91,103,114,97,121,93,123,35,49,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,119,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,123,119,104,105,116,101,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,98,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,123,98,108,97,99,107,125,125,37,10,32,32,32,32,32,32,92,101,120,112,97,110,100,97,102,116,101,114,92,100,101,102,92,99,115,110,97,109,101,32,76,84,97,92,101,110,100,99,115,110,97,109,101,123,92,99,111,108,111,114,123,98,108,97,99,107,125,125,37,10,0,0,0,0,9,32,32,37,115,0,0,0,32,32,92,109,97,107,101,97,116,108,101,116,116,101,114,10,32,32,92,112,114,111,118,105,100,101,99,111,109,109,97,110,100,92,99,111,108,111,114,91,50,93,91,93,123,37,37,10,32,32,32,32,92,71,101,110,101,114,105,99,69,114,114,111,114,123,40,103,110,117,112,108,111,116,41,32,92,115,112,97,99,101,92,115,112,97,99,101,92,115,112,97,99,101,92,64,115,112,97,99,101,115,125,123,37,37,10,32,32,32,32,32,32,80,97,99,107,97,103,101,32,99,111,108,111,114,32,110,111,116,32,108,111,97,100,101,100,32,105,110,32,99,111,110,106,117,110,99,116,105,111,110,32,119,105,116,104,10,32,32,32,32,32,32,116,101,114,109,105,110,97,108,32,111,112,116,105,111,110,32,96,99,111,108,111,117,114,116,101,120,116,39,37,37,10,32,32,32,32,125,123,83,101,101,32,116,104,101,32,103,110,117,112,108,111,116,32,100,111,99,117,109,101,110,116,97,116,105,111,110,32,102,111,114,32,101,120,112,108,97,110,97,116,105,111,110,46,37,37,10,32,32,32,32,125,123,69,105,116,104,101,114,32,117,115,101,32,39,98,108,97,99,107,116,101,120,116,39,32,105,110,32,103,110,117,112,108,111,116,32,111,114,32,108,111,97,100,32,116,104,101,32,112,97,99,107,97,103,101,10,32,32,32,32,32,32,99,111,108,111,114,46,115,116,121,32,105,110,32,76,97,84,101,88,46,125,37,37,10,32,32,32,32,92,114,101,110,101,119,99,111,109,109,97,110,100,92,99,111,108,111,114,91,50,93,91,93,123,125,37,37,10,32,32,125,37,37,10,32,32,92,112,114,111,118,105,100,101,99,111,109,109,97,110,100,92,105,110,99,108,117,100,101,103,114,97,112,104,105,99,115,91,50,93,91,93,123,37,37,10,32,32,32,32,92,71,101,110,101,114,105,99,69,114,114,111,114,123,40,103,110,117,112,108,111,116,41,32,92,115,112,97,99,101,92,115,112,97,99,101,92,115,112,97,99,101,92,64,115,112,97,99,101,115,125,123,37,37,10,32,32,32,32,32,32,80,97,99,107,97,103,101,32,103,114,97,112,104,105,99,120,32,111,114,32,103,114,97,112,104,105,99,115,32,110,111,116,32,108,111,97,100,101,100,37,37,10,32,32,32,32,125,123,83,101,101,32,116,104,101,32,103,110,117,112,108,111,116,32,100,111,99,117,109,101,110,116,97,116,105,111,110,32,102,111,114,32,101,120,112,108,97,110,97,116,105,111,110,46,37,37,10,32,32,32,32,125,123,84,104,101,32,103,110,117,112,108,111,116,32,101,112,115,108,97,116,101,120,32,116,101,114,109,105,110,97,108,32,110,101,101,100,115,32,103,114,97,112,104,105,99,120,46,115,116,121,32,111,114,32,103,114,97,112,104,105,99,115,46,115,116,121,46,125,37,37,10,32,32,32,32,92,114,101,110,101,119,99,111,109,109,97,110,100,92,105,110,99,108,117,100,101,103,114,97,112,104,105,99,115,91,50,93,91,93,123,125,37,37,10,32,32,125,37,37,10,32,32,92,112,114,111,118,105,100,101,99,111,109,109,97,110,100,92,114,111,116,97,116,101,98,111,120,91,50,93,123,35,50,125,37,37,10,32,32,92,64,105,102,117,110,100,101,102,105,110,101,100,123,105,102,71,80,99,111,108,111,114,125,123,37,37,10,32,32,32,32,92,110,101,119,105,102,92,105,102,71,80,99,111,108,111,114,10,32,32,32,32,92,71,80,99,111,108,111,114,37,115,10,32,32,125,123,125,37,37,10,32,32,92,64,105,102,117,110,100,101,102,105,110,101,100,123,105,102,71,80,98,108,97,99,107,116,101,120,116,125,123,37,37,10,32,32,32,32,92,110,101,119,105,102,92,105,102,71,80,98,108,97,99,107,116,101,120,116,10,32,32,32,32,92,71,80,98,108,97,99,107,116,101,120,116,37,115,10,32,32,125,123,125,37,37,10,32,32,37,37,32,100,101,102,105,110,101,32,97,32,92,103,64,97,100,100,116,111,64,109,97,99,114,111,32,119,105,116,104,111,117,116,32,64,32,105,110,32,116,104,101,32,110,97,109,101,58,10,32,32,92,108,101,116,92,103,112,108,103,97,100,100,116,111,109,97,99,114,111,92,103,64,97,100,100,116,111,64,109,97,99,114,111,10,32,32,37,37,32,100,101,102,105,110,101,32,101,109,112,116,121,32,116,101,109,112,108,97,116,101,115,32,102,111,114,32,97,108,108,32,99,111,109,109,97,110,100,115,32,116,97,107,105,110,103,32,116,101,120,116,58,10,32,32,92,103,100,101,102,92,103,112,108,98,97,99,107,116,101,120,116,123,125,37,37,10,32,32,92,103,100,101,102,92,103,112,108,102,114,111,110,116,116,101,120,116,123,125,37,37,10,32,32,92,109,97,107,101,97,116,111,116,104,101,114,10,0,0,0,0,0,0,0,32,32,92,115,101,108,101,99,116,102,111,110,116,10,0,0,32,32,92,102,111,110,116,115,104,97,112,101,123,37,115,125,37,37,10,0,0,0,0,0,32,32,92,102,111,110,116,115,101,114,105,101,115,123,37,115,125,37,37,10,0,0,0,0,71,80,86,65,76,95,84,69,82,77,95,87,73,78,68,79,87,73,68,0,0,0,0,0,32,32,92,102,111,110,116,102,97,109,105,108,121,123,37,115,125,37,37,10,0,0,0,0,99,97,110,118,97,115,0,0,32,32,37,37,32,69,110,99,111,100,105,110,103,32,105,110,115,105,100,101,32,116,104,101,32,112,108,111,116,46,32,32,73,110,32,116,104,101,32,104,101,97,100,101,114,32,111,102,32,121,111,117,114,32,100,111,99,117,109,101,110,116,44,32,116,104,105,115,32,101,110,99,111,100,105,110,103,10,32,32,37,37,32,115,104,111,117,108,100,32,116,111,32,100,101,102,105,110,101,100,44,32,101,46,103,46,44,32,98,121,32,117,115,105,110,103,10,32,32,37,37,32,92,117,115,101,112,97,99,107,97,103,101,91,37,115,44,60,111,116,104,101,114,32,101,110,99,111,100,105,110,103,115,62,93,123,105,110,112,117,116,101,110,99,125,10,32,32,92,105,110,112,117,116,101,110,99,111,100,105,110,103,123,37,115,125,37,37,10,0,0,0,120,50,100,97,36,116,97,0,92,98,101,103,105,110,103,114,111,117,112,10,0,0,0,0,9,109,105,110,111,114,32,37,115,116,105,99,115,32,97,114,101,32,111,102,102,32,102,111,114,32,108,105,110,101,97,114,32,115,99,97,108,101,115,10,9,109,105,110,111,114,32,37,115,116,105,99,115,32,97,114,101,32,99,111,109,112,117,116,101,100,32,97,117,116,111,109,97,116,105,99,97,108,108,121,32,102,111,114,32,108,111,103,32,115,99,97,108,101,115,10,0,0,0,0,0,0,0,0,85,110,107,110,111,119,110,32,111,98,106,101,99,116,32,116,121,112,101,0,0,0,0,0,37,0,0,0,0,0,0,0,96,98,117,105,108,116,105,110,45,114,111,116,97,116,101,45,117,112,96,32,111,110,108,121,32,102,111,114,32,115,112,108,111,116,115,59,32,60,115,104,105,102,116,62,32,105,110,99,114,101,97,115,101,115,32,97,109,111,117,110,116,0,0,0,92,109,97,107,101,97,116,108,101,116,116,101,114,10,37,37,32,83,101,108,101,99,116,32,97,110,32,97,112,112,114,111,112,114,105,97,116,101,32,100,101,102,97,117,108,116,32,100,114,105,118,101,114,32,40,102,114,111,109,32,84,101,88,76,105,118,101,32,103,114,97,112,104,105,99,115,46,99,102,103,41,10,92,98,101,103,105,110,103,114,111,117,112,10,32,32,92,99,104,97,114,100,101,102,92,120,61,48,32,37,37,10,32,32,37,37,32,99,104,101,99,107,32,112,100,102,84,101,88,10,32,32,92,64,105,102,117,110,100,101,102,105,110,101,100,123,112,100,102,111,117,116,112,117,116,125,123,125,123,37,37,10,32,32,32,32,92,105,102,99,97,115,101,92,112,100,102,111,117,116,112,117,116,10,32,32,32,32,92,101,108,115,101,10,32,32,32,32,32,32,92,99,104,97,114,100,101,102,92,120,61,49,32,37,37,10,32,32,32,32,92,102,105,10,32,32,125,37,37,10,32,32,37,37,32,99,104,101,99,107,32,86,84,101,88,10,32,32,92,64,105,102,117,110,100,101,102,105,110,101,100,123,79,112,77,111,100,101,125,123,125,123,37,37,10,32,32,32,32,92,99,104,97,114,100,101,102,92,120,61,50,32,37,37,10,32,32,125,37,37,10,92,101,120,112,97,110,100,97,102,116,101,114,92,101,110,100,103,114,111,117,112,10,92,105,102,99,97,115,101,92,120,10,32,32,37,37,32,100,101,102,97,117,108,116,32,99,97,115,101,10,32,32,92,80,97,115,115,79,112,116,105,111,110,115,84,111,80,97,99,107,97,103,101,123,100,118,105,112,115,125,123,103,101,111,109,101,116,114,121,125,10,92,111,114,10,32,32,37,37,32,112,100,102,84,101,88,32,105,115,32,114,117,110,110,105,110,103,32,105,110,32,112,100,102,32,109,111,100,101,10,32,32,92,80,97,115,115,79,112,116,105,111,110,115,84,111,80,97,99,107,97,103,101,123,112,100,102,116,101,120,125,123,103,101,111,109,101,116,114,121,125,10,92,101,108,115,101,10,32,32,37,37,32,86,84,101,88,32,105,115,32,114,117,110,110,105,110,103,10,32,32,92,80,97,115,115,79,112,116,105,111,110,115,84,111,80,97,99,107,97,103,101,123,118,116,101,120,125,123,103,101,111,109,101,116,114,121,125,10,92,102,105,10,92,109,97,107,101,97,116,111,116,104,101,114,10,37,37,32,83,101,116,32,112,97,112,101,114,115,105,122,101,10,92,117,115,101,112,97,99,107,97,103,101,91,112,97,112,101,114,115,105,122,101,61,123,37,46,50,102,98,112,44,37,46,50,102,98,112,125,44,116,101,120,116,61,123,37,46,50,102,98,112,44,37,46,50,102,98,112,125,93,123,103,101,111,109,101,116,114,121,125,10,37,37,32,78,111,32,112,97,103,101,32,110,117,109,98,101,114,115,32,97,110,100,32,110,111,32,112,97,114,97,103,114,97,112,104,32,105,110,100,101,110,116,97,116,105,111,110,10,92,112,97,103,101,115,116,121,108,101,123,101,109,112,116,121,125,10,92,115,101,116,108,101,110,103,116,104,123,92,112,97,114,105,110,100,101,110,116,125,123,48,98,112,125,37,37,10,37,37,32,76,111,97,100,32,99,111,110,102,105,103,117,114,97,116,105,111,110,32,102,105,108,101,10,92,73,110,112,117,116,73,102,70,105,108,101,69,120,105,115,116,115,123,103,110,117,112,108,111,116,46,99,102,103,125,123,37,37,10,32,32,92,116,121,112,101,111,117,116,123,85,115,105,110,103,32,99,111,110,102,105,103,117,114,97,116,105,111,110,32,102,105,108,101,32,103,110,117,112,108,111,116,46,99,102,103,125,37,37,10,125,123,37,37,10,32,92,116,121,112,101,111,117,116,123,78,111,32,99,111,110,102,105,103,117,114,97,116,105,111,110,32,102,105,108,101,32,103,110,117,112,108,111,116,46,99,102,103,32,102,111,117,110,100,46,125,37,37,10,125,37,37,10,37,115,10,92,98,101,103,105,110,123,100,111,99,117,109,101,110,116,125,10,0,0,0,0,0,0,0,0,92,117,115,101,112,97,99,107,97,103,101,91,37,115,93,123,105,110,112,117,116,101,110,99,125,10,0,0,0,0,0,0,9,84,104,105,115,32,118,101,114,115,105,111,110,32,111,102,32,103,110,117,112,108,111,116,32,117,110,100,101,114,115,116,97,110,100,115,32,116,104,101,32,102,111,108,108,111,119,105,110,103,32,98,105,110,97,114,121,32,102,105,108,101,32,116,121,112,101,115,58,10,0,0,37,32,76,111,97,100,32,112,97,99,107,97,103,101,115,10,92,117,115,101,112,97,99,107,97,103,101,123,103,114,97,112,104,105,99,120,125,10,92,117,115,101,112,97,99,107,97,103,101,123,99,111,108,111,114,125,10,0,0,0,0,0,0,0,111,110,108,121,32,54,32,114,97,110,103,101,32,115,112,101,99,115,32,97,114,101,32,112,101,114,109,105,116,116,101,100,0,0,0,0,0,0,0,0,92,114,101,110,101,119,99,111,109,109,97,110,100,42,92,117,112,100,101,102,97,117,108,116,123,37,115,125,37,37,10,0,92,114,101,110,101,119,99,111,109,109,97,110,100,42,92,109,100,100,101,102,97,117,108,116,123,37,115,125,37,37,10,0,92,114,101,110,101,119,99,111,109,109,97,110,100,42,92,114,109,100,101,102,97,117,108,116,123,37,115,125,37,37,10,0,71,80,86,65,76,95,80,87,68,0,0,0,0,0,0,0,92,100,111,99,117,109,101,110,116,99,108,97,115,115,123,109,105,110,105,109,97,108,125,10,37,37,32,83,101,116,32,102,111,110,116,32,115,105,122,101,10,92,109,97,107,101,97,116,108,101,116,116,101,114,10,92,100,101,102,92,64,112,116,115,105,122,101,123,37,100,125,10,92,73,110,112,117,116,73,102,70,105,108,101,69,120,105,115,116,115,123,115,105,122,101,37,100,46,99,108,111,125,123,125,123,37,37,10,32,32,32,92,71,101,110,101,114,105,99,69,114,114,111,114,123,40,103,110,117,112,108,111,116,41,32,92,115,112,97,99,101,92,115,112,97,99,101,92,115,112,97,99,101,92,64,115,112,97,99,101,115,125,123,37,37,10,32,32,32,32,32,32,71,110,117,112,108,111,116,32,69,114,114,111,114,58,32,70,105,108,101,32,96,115,105,122,101,37,100,46,99,108,111,39,32,110,111,116,32,102,111,117,110,100,33,32,67,111,117,108,100,32,110,111,116,32,115,101,116,32,102,111,110,116,32,115,105,122,101,37,37,10,32,32,32,125,123,83,101,101,32,116,104,101,32,103,110,117,112,108,111,116,32,100,111,99,117,109,101,110,116,97,116,105,111,110,32,102,111,114,32,101,120,112,108,97,110,97,116,105,111,110,46,37,37,10,32,32,32,125,123,70,111,114,32,117,115,105,110,103,32,97,32,102,111,110,116,32,115,105,122,101,32,97,32,102,105,108,101,32,96,115,105,122,101,60,102,111,110,116,115,105,122,101,62,46,99,108,111,39,32,104,97,115,32,116,111,32,101,120,105,115,116,46,10,32,32,32,32,32,32,32,32,70,97,108,108,105,110,103,32,98,97,99,107,32,94,94,74,116,111,32,100,101,102,97,117,108,116,32,102,111,110,116,115,105,122,101,32,49,48,112,116,46,125,37,37,10,32,32,92,100,101,102,92,64,112,116,115,105,122,101,123,48,125,10,32,32,92,105,110,112,117,116,123,115,105,122,101,49,48,46,99,108,111,125,37,37,10,125,37,37,10,92,109,97,107,101,97,116,111,116,104,101,114,10,0,0,0,0,88,116,101,114,109,32,84,101,107,116,114,111,110,105,120,32,52,48,49,52,32,77,111,100,101,0,0,0,0,0,0,0,69,80,83,76,65,84,69,88,95,99,111,109,109,111,110,95,105,110,105,116,0,0,0,0,120,100,97,36,116,97,0,0,105,110,118,97,108,105,100,32,105,110,112,117,116,32,101,110,99,111,100,105,110,103,32,117,115,101,100,0,0,0,0,0,9,109,105,110,111,114,32,37,115,116,105,99,115,32,97,114,101,32,111,102,102,10,0,0,108,97,121,101,114,100,101,102,97,117,108,116,0,0,0,0,107,111,105,56,45,117,0,0,96,98,117,105,108,116,105,110,45,114,111,116,97,116,101,45,108,101,102,116,96,32,111,110,108,121,32,102,111,114,32,115,112,108,111,116,115,59,32,60,115,104,105,102,116,62,32,105,110,99,114,101,97,115,101,115,32,97,109,111,117,110,116,0,107,111,105,56,45,114,0,0,99,112,52,51,55,100,101,0,32,45,45,32,112,114,111,99,101,115,115,111,114,32,100,111,101,115,32,110,111,116,32,115,117,112,112,111,114,116,32,116,104,105,115,32,115,105,122,101,0,0,0,0,0,0,0,0,108,97,116,105,110,57,0,0,108,97,116,105,110,53,0,0,114,0,0,0,0,0,0,0,108,97,116,105,110,50,0,0,70,111,114,109,97,116,32,99,104,97,114,97,99,116,101,114,32,109,105,115,109,97,116,99,104,58,32,37,37,66,32,105,115,32,111,110,108,121,32,118,97,108,105,100,32,119,105,116,104,32,37,37,98,0,0,0,108,97,116,105,110,49,0,0,121,111,117,32,99,97,110,39,116,32,117,110,115,101,116,32,116,104,101,32,112,97,108,101,116,116,101,46,10,0,0,0,102,105,108,108,105,110,103,32,71,80,86,65,76,95,80,87,68,0,0,0,0,0,0,0,37,37,32,71,78,85,80,76,79,84,58,32,76,97,84,101,88,32,112,105,99,116,117,114,101,32,119,105,116,104,32,80,111,115,116,115,99,114,105,112,116,10,0,0,0,0,0,0,120,116,101,114,109,0,0,0,101,112,115,108,97,116,101,120,32,116,101,114,109,105,110,97,108,32,99,97,110,110,111,116,32,119,114,105,116,101,32,116,111,32,115,116,97,110,100,97,114,100,32,111,117,116,112,117,116,0,0,0,0,0,0,0,120,121,112,36,108,97,110,101,0,0,0,0,0,0,0,0,9,110,111,116,32,114,111,116,97,116,101,100,10,9,0,0,101,120,112,101,99,116,101,100,32,103,97,112,32,118,97,108,117,101,0,0,0,0,0,0,115,101,116,32,103,114,105,100,32,37,115,32,32,0,0,0,32,32,123,92,71,78,85,80,76,79,84,115,112,101,99,105,97,108,123,34,10,0,0,0,99,104,97,110,103,105,110,103,32,118,105,101,119,32,116,111,32,37,102,44,32,37,102,46,10,0,0,0,0,0,0,0,32,32,92,115,112,101,99,105,97,108,123,112,115,102,105,108,101,61,37,115,32,108,108,120,61,48,32,108,108,121,61,48,32,117,114,120,61,37,100,32,117,114,121,61,37,100,32,114,119,105,61,37,100,125,10,0,92,71,78,85,80,76,79,84,112,105,99,116,117,114,101,40,37,100,44,37,100,41,10,0,40,37,100,41,0,0,0,0,117,116,102,56,0,0,0,0,37,37,32,71,78,85,80,76,79,84,58,32,112,108,97,105,110,32,84,101,88,32,119,105,116,104,32,80,111,115,116,115,99,114,105,112,116,10,92,98,101,103,105,110,103,114,111,117,112,10,92,99,97,116,99,111,100,101,96,92,64,61,49,49,92,114,101,108,97,120,10,92,100,101,102,92,71,78,85,80,76,79,84,115,112,101,99,105,97,108,123,37,37,10,32,32,92,100,101,102,92,100,111,35,35,49,123,92,99,97,116,99,111,100,101,96,35,35,49,61,49,50,92,114,101,108,97,120,125,92,100,111,115,112,101,99,105,97,108,115,10,32,32,92,99,97,116,99,111,100,101,96,92,123,61,49,92,99,97,116,99,111,100,101,96,92,125,61,50,92,99,97,116,99,111,100,101,92,37,37,61,49,52,92,114,101,108,97,120,92,115,112,101,99,105,97,108,125,37,37,10,37,37,10,92,101,120,112,97,110,100,97,102,116,101,114,92,105,102,120,92,99,115,110,97,109,101,32,71,78,85,80,76,79,84,112,105,99,116,117,114,101,92,101,110,100,99,115,110,97,109,101,92,114,101,108,97,120,10,32,32,92,99,115,110,97,109,101,32,110,101,119,100,105,109,101,110,92,101,110,100,99,115,110,97,109,101,92,71,78,85,80,76,79,84,117,110,105,116,10,32,32,92,103,100,101,102,92,71,78,85,80,76,79,84,112,105,99,116,117,114,101,40,35,49,44,35,50,41,123,92,118,98,111,120,32,116,111,35,50,92,71,78,85,80,76,79,84,117,110,105,116,92,98,103,114,111,117,112,10,32,32,32,32,92,100,101,102,92,112,117,116,40,35,35,49,44,35,35,50,41,35,35,51,123,92,117,110,115,107,105,112,92,114,97,105,115,101,35,35,50,92,71,78,85,80,76,79,84,117,110,105,116,10,32,32,32,32,32,32,92,104,98,111,120,32,116,111,48,112,116,123,92,107,101,114,110,35,35,49,92,71,78,85,80,76,79,84,117,110,105,116,32,35,35,51,92,104,115,115,125,92,105,103])
.concat([110,111,114,101,115,112,97,99,101,115,125,37,37,10,32,32,32,32,92,100,101,102,92,108,106,117,115,116,35,35,49,123,92,118,98,111,120,32,116,111,48,112,116,123,92,118,115,115,92,104,98,111,120,32,116,111,48,112,116,123,35,35,49,92,104,115,115,125,92,118,115,115,125,125,37,37,10,32,32,32,32,92,100,101,102,92,99,106,117,115,116,35,35,49,123,92,118,98,111,120,32,116,111,48,112,116,123,92,118,115,115,92,104,98,111,120,32,116,111,48,112,116,123,92,104,115,115,32,35,35,49,92,104,115,115,125,92,118,115,115,125,125,37,37,10,32,32,32,32,92,100,101,102,92,114,106,117,115,116,35,35,49,123,92,118,98,111,120,32,116,111,48,112,116,123,92,118,115,115,92,104,98,111,120,32,116,111,48,112,116,123,92,104,115,115,32,35,35,49,125,92,118,115,115,125,125,37,37,10,32,32,32,32,92,100,101,102,92,115,116,97,99,107,35,35,49,123,92,108,101,116,92,92,61,92,99,114,92,116,97,98,115,107,105,112,61,48,112,116,92,104,97,108,105,103,110,123,92,104,102,105,108,32,35,35,35,35,92,104,102,105,108,92,99,114,32,35,35,49,92,99,114,99,114,125,125,37,37,10,32,32,32,32,92,100,101,102,92,108,115,116,97,99,107,35,35,49,123,92,104,98,111,120,32,116,111,48,112,116,123,92,118,98,111,120,32,116,111,48,112,116,123,92,118,115,115,92,115,116,97,99,107,123,35,35,49,125,125,92,104,115,115,125,125,37,37,10,32,32,32,32,92,100,101,102,92,99,115,116,97,99,107,35,35,49,123,92,104,98,111,120,32,116,111,48,112,116,123,92,104,115,115,92,118,98,111,120,32,116,111,48,112,116,123,92,118,115,115,92,115,116,97,99,107,123,35,35,49,125,125,92,104,115,115,125,125,37,37,10,32,32,32,32,92,100,101,102,92,114,115,116,97,99,107,35,35,49,123,92,104,98,111,120,32,116,111,48,112,116,123,92,118,98,111,120,32,116,111,48,112,116,123,92,115,116,97,99,107,123,35,35,49,125,92,118,115,115,125,92,104,115,115,125,125,37,37,10,32,32,32,32,92,118,115,115,92,104,98,111,120,32,116,111,35,49,92,71,78,85,80,76,79,84,117,110,105,116,92,98,103,114,111,117,112,92,105,103,110,111,114,101,115,112,97,99,101,115,125,37,37,10,32,32,92,103,100,101,102,92,101,110,100,71,78,85,80,76,79,84,112,105,99,116,117,114,101,123,92,104,115,115,92,101,103,114,111,117,112,92,101,103,114,111,117,112,125,37,37,10,92,102,105,10,92,71,78,85,80,76,79,84,117,110,105,116,61,37,46,52,102,98,112,10,0,104,105,115,116,111,103,114,97,109,115,0,0,0,0,0,0,98,111,114,0,0,0,0,0,92,98,101,103,105,110,123,112,105,99,116,117,114,101,125,40,37,100,44,37,100,41,40,48,44,48,41,37,37,10,0,0,37,37,32,71,78,85,80,76,79,84,58,32,76,97,84,101,88,32,112,105,99,116,117,114,101,32,119,105,116,104,32,80,111,115,116,115,99,114,105,112,116,10,92,98,101,103,105,110,103,114,111,117,112,37,37,10,92,109,97,107,101,97,116,108,101,116,116,101,114,37,37,10,92,110,101,119,99,111,109,109,97,110,100,123,92,71,78,85,80,76,79,84,115,112,101,99,105,97,108,125,123,37,37,10,32,32,92,64,115,97,110,105,116,105,122,101,92,99,97,116,99,111,100,101,96,92,37,37,61,49,52,92,114,101,108,97,120,92,115,112,101,99,105,97,108,125,37,37,10,92,115,101,116,108,101,110,103,116,104,123,92,117,110,105,116,108,101,110,103,116,104,125,123,37,46,52,102,98,112,125,37,37,10,0,80,108,111,116,32,102,97,105,108,101,100,33,0,0,0,0,111,114,32,115,101,116,32,116,104,101,32,108,111,97,100,112,97,116,104,32,97,112,112,114,111,112,114,105,97,116,101,108,121,10,0,0,0,0,0,0,86,84,45,108,105,107,101,32,116,101,107,52,48,120,120,32,116,101,114,109,105,110,97,108,32,101,109,117,108,97,116,111,114,0,0,0,0,0,0,0,111,114,32,115,101,116,32,116,104,101,32,101,110,118,105,114,111,110,109,101,110,116,97,108,32,118,97,114,105,97,98,108,101,32,71,78,85,80,76,79,84,95,80,83,95,68,73,82,10,0,0,0,0,0,0,0,118,105,36,101,119,0,0,0,108,36,111,97,100,0,0,0,80,108,101,97,115,101,32,99,111,112,121,32,37,115,32,116,111,32,111,110,101,32,111,102,32,116,104,101,32,97,98,111,118,101,32,100,105,114,101,99,116,111,114,105,101,115,10,0,9,114,111,116,97,116,101,100,32,105,102,32,116,104,101,32,116,101,114,109,105,110,97,108,32,97,108,108,111,119,115,32,105,116,10,9,0,0,0,0,103,97,112,0,0,0,0,0,32,92,10,0,0,0,0,0,67,97,110,39,116,32,102,105,110,100,32,80,111,115,116,83,99,114,105,112,116,32,112,114,111,108,111,103,117,101,32,102,105,108,101,32,37,115,10,0,71,80,86,65,76,95,86,73,69,87,95,82,79,84,95,90,0,0,0,0,0,0,0,0,71,78,85,80,76,79,84,95,80,83,95,68,73,82,0,0,80,114,111,108,111,103,32,110,97,109,101,0,0,0,0,0,10,9,84,104,101,32,102,111,108,108,111,119,105,110,103,32,98,105,110,97,114,121,32,100,97,116,97,32,115,105,122,101,115,32,97,116,116,101,109,112,116,32,116,111,32,98,101,32,109,97,99,104,105,110,101,32,105,110,100,101,112,101,110,100,101,110,116,58,10,10,9,32,32,110,97,109,101,32,40,115,105,122,101,32,105,110,32,98,121,116,101,115,41,10,10,0,47,117,115,114,47,108,111,99,97,108,47,115,104,97,114,101,47,103,110,117,112,108,111,116,47,52,46,54,47,80,111,115,116,83,99,114,105,112,116,0,97,103,108,105,115,116,0,0,97,103,108,102,110,46,116,120,116,0,0,0,0,0,0,0,47,76,84,51,32,123,32,80,76,32,91,56,32,100,108,49,32,53,32,100,108,49,32,48,46,53,32,100,108,49,32,53,32,100,108,49,93,32,49,32,48,32,49,32,68,76,32,125,32,100,101,102,10,0,0,0,71,80,86,65,76,95,78,97,78,0,0,0,0,0,0,0,47,76,84,50,32,123,32,80,76,32,91,52,32,100,108,49,32,52,32,100,108,49,93,32,48,32,49,32,49,32,68,76,32,125,32,100,101,102,10,0,118,116,116,101,107,0,0,0,47,76,84,49,32,123,32,80,76,32,91,56,32,100,108,49,32,53,32,100,108,49,93,32,48,32,48,32,49,32,68,76,32,125,32,100,101,102,10,0,118,101,36,114,115,105,111,110,0,0,0,0,0,0,0,0,47,76,84,48,32,123,32,80,76,32,91,93,32,49,32,48,32,48,32,68,76,32,125,32,100,101,102,10,0,0,0,0,116,111,112,0,0,0,0,0,99,111,108,117,109,110,115,36,116,97,99,107,101,100,0,0,32,37,115,37,115,116,105,99,115,32,37,115,109,37,115,116,105,99,115,0,0,0,0,0,47,76,84,97,32,123,32,65,76,32,91,49,32,117,100,108,32,109,117,108,32,50,32,117,100,108,32,109,117,108,93,32,48,32,115,101,116,100,97,115,104,32,48,32,48,32,48,32,115,101,116,114,103,98,99,111,108,111,114,32,125,32,100,101,102,10,0,0,0,0,0,0,71,80,86,65,76,95,86,73,69,87,95,82,79,84,95,88,0,0,0,0,0,0,0,0,47,76,84,98,32,123,32,66,76,32,91,93,32,48,32,48,32,48,32,68,76,32,125,32,100,101,102,10,0,0,0,0,47,76,84,119,32,123,32,80,76,32,91,93,32,49,32,115,101,116,103,114,97,121,32,125,32,100,101,102,10,0,0,0,40,37,100,41,10,0,0,0,93,32,41,10,0,0,0,0,37,32,82,101,100,101,102,105,110,101,32,108,105,110,101,32,116,121,112,101,115,32,116,111,32,109,97,116,99,104,32,111,108,100,32,101,112,115,108,97,116,101,120,32,100,114,105,118,101,114,10,0,0,0,0,0,119,36,105,116,104,0,0,0,99,117,114,114,101,110,116,100,105,99,116,32,101,110,100,32,100,101,102,105,110,101,102,111,110,116,32,112,111,112,10,0,100,117,112,32,108,101,110,103,116,104,32,100,105,99,116,32,98,101,103,105,110,32,123,49,32,105,110,100,101,120,32,47,70,73,68,32,101,113,32,123,112,111,112,32,112,111,112,125,32,123,100,101,102,125,32,105,102,101,108,115,101,125,32,102,111,114,97,108,108,10,0,0,45,101,0,0,0,0,0,0,47,67,77,69,88,49,48,45,66,97,115,101,108,105,110,101,32,47,67,77,69,88,49,48,32,102,105,110,100,102,111,110,116,32,91,49,32,48,32,48,32,49,32,48,32,49,93,32,109,97,107,101,102,111,110,116,10,0,0,0,0,0,0,0,71,80,86,65,76,95,112,105,0,0,0,0,0,0,0,0,37,37,66,101,103,105,110,80,114,111,99,83,101,116,58,32,67,77,69,88,49,48,45,66,97,115,101,108,105,110,101,10,0,0,0,0,0,0,0,0,114,101,102,114,101,115,104,10,0,0,0,0,0,0,0,0,84,101,107,116,114,111,110,105,120,32,52,48,49,48,32,97,110,100,32,111,116,104,101,114,115,59,32,109,111,115,116,32,84,69,75,32,101,109,117,108,97,116,111,114,115,0,0,0,67,77,69,88,49,48,0,0,116,105,116,36,108,101,0,0,76,105,110,101,102,101,101,100,0,0,0,0,0,0,0,0,37,37,69,110,100,80,114,111,99,83,101,116,10,0,0,0,98,111,116,116,111,109,0,0,114,111,119,115,36,116,97,99,107,101,100,0,0,0,0,0,115,101,116,32,103,114,105,100,0,0,0,0,0,0,0,0,67,111,109,109,97,110,100,32,39,37,115,39,32,103,101,110,101,114,97,116,101,100,32,101,114,114,111,114,44,32,101,120,105,116,99,111,100,101,32,105,115,32,37,100,0,0,0,0,110,111,116,32,101,110,111,117,103,104,32,109,101,109,111,114,121,32,116,111,32,108,111,97,100,32,102,105,108,101,0,0,67,97,110,39,116,32,99,97,108,99,117,108,97,116,101,32,99,117,98,105,99,32,115,112,108,105,110,101,115,0,0,0,96,98,117,105,108,116,105,110,45,114,111,116,97,116,101,45,100,111,119,110,96,32,111,110,108,121,32,102,111,114,32,115,112,108,111,116,115,59,32,60,115,104,105,102,116,62,32,105,110,99,114,101,97,115,101,115,32,97,109,111,117,110,116,0,80,105,112,101,32,39,37,115,39,32,99,111,110,116,97,105,110,115,32,116,104,101,32,102,111,110,116,32,39,37,115,39,46,10,0,0,0,0,0,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,32,58,32,115,116,114,108,101,110,32,111,102,32,110,111,110,45,83,84,82,73,78,71,32,97,114,103,117,109,101,110,116,0,0,70,111,110,116,32,102,105,108,101,32,39,37,115,39,32,99,111,110,116,97,105,110,115,32,116,104,101,32,102,111,110,116,32,39,37,115,39,46,32,76,111,99,97,116,105,111,110,58,10,32,32,32,37,115,10,0,108,111,97,100,95,102,111,110,116,102,105,108,101,115,0,0,47,70,111,110,116,78,97,109,101,0,0,0,0,0,0,0,70,111,110,116,32,102,105,108,101,32,39,37,115,39,32,115,101,101,109,115,32,110,111,116,32,116,111,32,98,101,32,97,32,80,70,65,32,102,105,108,101,0,0,0,0,0,0,0,67,111,109,109,97,110,100,32,39,37,115,39,32,115,101,101,109,115,32,110,111,116,32,116,111,32,103,101,110,101,114,97,116,101,32,80,70,65,32,100,97,116,97,0,0,0,0,0,71,80,86,65,76,95,84,69,82,77,73,78,65,76,83,0,37,33,70,111,110,116,84,121,112,101,49,0,0,0,0,0,116,101,107,52,48,120,120,0,37,33,80,83,45,65,100,111,98,101,70,111,110,116,0,0,116,105,109,36,101,115,116,97,109,112,0,0,0,0,0,0,70,111,110,116,32,102,105,108,101,32,39,37,115,39,32,104,97,115,32,117,110,107,110,111,119,110,32,101,120,116,101,110,115,105,111,110,46,32,65,115,115,117,109,101,32,105,116,32,105,115,32,97,32,112,102,97,32,102,105,108,101,0,0,0,9,119,114,105,116,116,101,110,32,105,110,32,37,115,32,99,111,114,110,101,114,10,0,0,101,114,114,111,114,36,98,97,114,115,0,0,0,0,0,0,115,101,116,32,103,114,105,100,32,110,111,112,111,108,97,114,10,0,0,0,0,0,0,0,112,102,97,0,0,0,0,0,78,111,32,99,111,109,109,97,110,100,32,102,111,114,32,97,117,116,111,109,97,116,105,99,32,102,111,110,116,32,99,111,110,118,101,114,115,105,111,110,32,112,102,98,45,62,112,102,97,32,100,101,102,105,110,101,100,0,0,0,0,0,0,0,112,102,98,116,111,112,115,32,37,115,0,0,0,0,0,0,9,32,32,0,0,0,0,0,67,97,110,39,116,32,112,108,111,116,32,119,105,116,104,32,97,110,32,101,109,112,116,121,32,37,115,32,114,97,110,103,101,33,0,0,0,0,0,0,71,78,85,80,76,79,84,95,80,70,66,84,79,80,70,65,0,0,0,0,0,0,0,0,112,102,98,0,0,0,0,0,117,110,115,101,116,32,104,105,100,100,101,110,51,100,10,0,67,111,117,108,100,32,110,111,116,32,101,120,101,99,117,116,101,32,99,111,109,109,97,110,100,32,39,37,115,39,0,0,78,111,32,99,111,109,109,97,110,100,32,102,111,114,32,97,117,116,111,109,97,116,105,99,32,102,111,110,116,32,99,111,110,118,101,114,115,105,111,110,32,116,116,102,45,62,112,102,97,32,100,101,102,105,110,101,100,0,0,0,0,0,0,0,110,101,119,32,107,101,121,32,108,105,115,116,0,0,0,0,116,116,102,50,112,116,49,32,45,97,32,45,101,32,45,87,32,48,32,37,115,32,45,0,84,101,107,116,114,111,110,105,120,32,52,49,48,54,44,32,52,49,48,55,44,32,52,49,48,57,32,97,110,100,32,52,50,48,88,32,116,101,114,109,105,110,97,108,115,0,0,0,71,78,85,80,76,79,84,95,84,84,70,84,79,80,70,65,0,0,0,0,0,0,0,0,116,105,109,101,102,36,109,116,0,0,0,0,0,0,0,0,111,116,102,0,0,0,0,0,99,108,117,115,116,36,101,114,101,100,0,0,0,0,0,0,115,101,116,32,103,114,105,100,32,112,111,108,97,114,32,37,102,10,0,0,0,0,0,0,116,116,102,0,0,0,0,0,112,0,0,0,0,0,0,0,37,37,37,37,66,101,103,105,110,80,114,111,99,83,101,116,58,32,37,115,10,0,0,0,80,83,95,101,115,99,97,112,101,95,115,116,114,105,110,103,0,0,0,0,0,0,0,0,9,84,104,101,32,102,111,108,108,111,119,105,110,103,32,98,105,110,97,114,121,32,100,97,116,97,32,115,105,122,101,115,32,97,114,101,32,109,97,99,104,105,110,101,32,100,101,112,101,110,100,101,110,116,58,10,10,9,32,32,110,97,109,101,32,40,115,105,122,101,32,105,110,32,98,121,116,101,115,41,10,10,0,0,0,0,0,0,76,111,103,32,115,99,97,108,105,110,103,32,111,102,32,51,68,32,105,109,97,103,101,32,112,108,111,116,115,32,105,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,0,101,110,100,10,37,37,69,110,100,80,114,111,108,111,103,10,0,0,0,0,0,0,0,0,40,41,92,0,0,0,0,0,115,116,97,116,117,115,100,105,99,116,32,98,101,103,105,110,32,37,115,32,115,101,116,100,117,112,108,101,120,109,111,100,101,32,101,110,100,10,0,0,79,114,105,103,105,110,95,50,0,0,0,0,0,0,0,0,117,116,102,45,56,46,112,115,0,0,0,0,0,0,0,0,71,80,86,65,76,95,67,79,77,80,73,76,69,95,79,80,84,73,79,78,83,0,0,0,107,111,105,56,117,46,112,115,0,0,0,0,0,0,0,0,116,101,107,52,49,48,120,0,107,111,105,56,114,46,112,115,0,0,0,0,0,0,0,0,116,105,99,115,108,36,101,118,101,108,0,0,0,0,0,0,99,112,49,50,53,49,46,112,115,0,0,0,0,0,0,0,9,115,101,116,32,37,115,100,97,116,97,32,116,105,109,101,10,0,0,0,0,0,0,0,117,110,115,101,116,32,103,114,105,100,10,0,0,0,0,0,99,112,49,50,53,48,46,112,115,0,0,0,0,0,0,0,110,0,0,0,0,0,0,0,99,112,56,53,50,46,112,115,0,0,0,0,0,0,0,0,99,112,56,53,48,46,112,115,0,0,0,0,0,0,0,0,99,112,52,51,55,46,112,115,0,0,0,0,0,0,0,0,56,56,53,57,45,49,53,46,112,115,0,0,0,0,0,0,56,56,53,57,45,57,46,112,115,0,0,0,0,0,0,0,56,56,53,57,45,50,46,112,115,0,0,0,0,0,0,0,108,111,97,100,112,97,116,104,32,61,61,32,78,85,76,76,0,0,0,0,0,0,0,0,71,80,86,65,76,95,80,65,84,67,72,76,69,86,69,76,0,0,0,0,0,0,0,0,56,56,53,57,45,49,46,112,115,0,0,0,0,0,0,0,120,94,51,0,0,0,0,0,82,69,71,73,83,32,103,114,97,112,104,105,99,115,32,108,97,110,103,117,97,103,101,0,112,114,111,108,111,103,117,101,46,112,115,0,0,0,0,0,116,105,99,115,99,36,97,108,101,0,0,0,0,0,0,0,47,100,111,99,108,105,112,32,123,10,32,32,67,108,105,112,84,111,66,111,117,110,100,105,110,103,66,111,120,32,123,10,32,32,32,32,110,101,119,112,97,116,104,32,37,100,32,37,100,32,109,111,118,101,116,111,32,37,100,32,37,100,32,108,105,110,101,116,111,32,37,100,32,37,100,32,108,105,110,101,116,111,32,37,100,32,37,100,32,108,105,110,101,116,111,32,99,108,111,115,101,112,97,116,104,10,32,32,32,32,99,108,105,112,10,32,32,125,32,105,102,10,125,32,100,101,102,10,0,0,0,0,0,0,0,0,104,115,0,0,0,0,0,0,115,101,116,32,116,105,99,115,32,37,115,10,0,0,0,0,37,37,80,97,103,101,115,58,32,40,97,116,101,110,100,41,10,0,0,0,0,0,0,0,80,111,114,116,114,97,105,116,0,0,0,0,0,0,0,0,76,97,110,100,115,99,97,112,101,0,0,0,0,0,0,0,44,32,37,100,32,98,101,102,111,114,101,32,112,108,97,110,101,0,0,0,0,0,0,0,37,37,37,37,79,114,105,101,110,116,97,116,105,111,110,58,32,37,115,10,0,0,0,0,37,37,37,37,66,111,117,110,100,105,110,103,66,111,120,58,32,37,100,32,37,100,32,37,100,32,37,100,10,0,0,0,40,97,116,101,110,100,41,0,37,37,37,37,84,105,116,108,101,58,32,37,115,10,0,0,71,80,86,65,76,95,86,69,82,83,73,79,78,0,0,0,37,33,80,83,45,65,100,111,98,101,45,50,46,48,10,0,114,101,103,105,115,0,0,0,37,33,80,83,45,65,100,111,98,101,45,50,46,48,32,69,80,83,70,45,50,46,48,10,0,0,0,0,0,0,0,0,116,105,36,99,115,0,0,0,101,112,115,0,0,0,0,0,40,0,0,0,0,0,0,0,32,110,111,101,110,104,97,110,99,101,100,0,0,0,0,0,117,110,36,115,111,114,116,101,100,0,0,0,0,0,0,0,105,110,118,97,108,105,100,32,112,111,115,116,115,99,114,105,112,116,32,102,111,114,109,97,116,32,117,115,101,100,0,0,37,37,37,37,80,97,103,101,115,58,32,37,100,10,0,0,37,115,37,115,0,0,0,0,44,32,37,100,32,98,101,102,111,114,101,32,108,105,110,101,0,0,0,0,0,0,0,0,37,37,68,111,99,117,109,101,110,116,70,111,110,116,115,58,32,0,0,0,0,0,0,0,35,0,0,0,0,0,0,0,37,37,84,114,97,105,108,101,114,10,0,0,0,0,0,0,115,116,114,111,107,101,10,103,114,101,115,116,111,114,101,10,101,110,100,10,115,104,111,119,112,97,103,101,10,0,0,0,77,82,115,104,111,119,10,0,66,97,100,32,102,117,108,108,32,109,111,110,116,104,32,110,97,109,101,0,0,0,0,0,71,80,86,65,76,95,69,82,82,78,79,0,0,0,0,0,77,67,115,104,111,119,10,0,71,80,73,67,32,45,45,32,80,114,111,100,117,99,101,32,103,114,97,112,104,115,32,105,110,32,103,114,111,102,102,32,117,115,105,110,103,32,116,104,101,32,103,112,105,99,32,112,114,101,112,114,111,99,101,115,115,111,114,0,0,0,0,0,77,76,115,104,111,119,10,0,116,101,114,109,111,36,112,116,105,111,110,115,0,0,0,0,93,32,37,46,49,102,32,0,44,32,114,111,116,97,116,101,100,32,98,121,32,37,100,32,100,101,103,114,101,101,115,32,105,110,32,50,68,32,112,108,111,116,115,0,0,0,0,0,115,111,36,114,116,101,100,0,92,37,111,0,0,0,0,0,91,32,0,0,0,0,0,0,99,117,114,114,101,110,116,112,111,105,110,116,32,103,115,97,118,101,32,116,114,97,110,115,108,97,116,101,32,37,100,32,114,111,116,97,116,101,32,48,32,48,32,109,111,118,101,116,111,10,0,0,0,0,0,0,10,9,32,32,32,32,83,107,105,112,32,98,121,116,101,115,58,32,37,100,32,98,101,102,111,114,101,32,114,101,99,111,114,100,0,0,0,0,0,0,47,88,89,114,101,115,116,111,114,101,32,123,32,91,40,32,41,32,49,32,50,32,116,114,117,101,32,102,97,108,115,101,32,52,32,40,41,93,32,125,32,98,105,110,100,32,100,101,102,10,0,0,0,0,0,0,47,88,89,115,97,118,101,32,32,32,32,123,32,91,40,32,41,32,49,32,50,32,116,114,117,101,32,102,97,108,115,101,32,51,32,40,41,93,32,125,32,98,105,110,100,32,100,101,102,10,0,0,0,0,0,0,101,120,112,97,110,100,32,102,111,110,116,112,97,116,104,0,32,32,101,120,99,104,32,100,117,112,32,77,70,119,105,100,116,104,32,45,50,32,100,105,118,32,51,32,45,49,32,114,111,108,108,32,82,10,32,32,66,108,97,99,107,116,101,120,116,32,123,103,115,97,118,101,32,48,32,115,101,116,103,114,97,121,32,77,70,115,104,111,119,32,103,114,101,115,116,111,114,101,125,32,123,77,70,115,104,111,119,125,32,105,102,101,108,115,101,32,125,32,98,105,110,100,32,100,101,102,10,0,101,37,43,48,50,100,0,0,47,77,67,115,104,111,119,32,123,32,99,117,114,114,101,110,116,112,111,105,110,116,32,115,116,114,111,107,101,32,77,10,0,0,0,0,0,0,0,0,10,9,100,117,109,109,121,32,118,97,114,105,97,98,108,101,32,105,115,32,120,32,102,111,114,32,99,117,114,118,101,115,10,0,0,0,0,0,0,0,37,72,58,37,77,0,0,0,71,80,86,65,76,95,69,78,67,79,68,73,78,71,0,0,32,32,101,120,99,104,32,100,117,112,32,77,70,119,105,100,116,104,32,110,101,103,32,51,32,45,49,32,114,111,108,108,32,82,10,32,32,66,108,97,99,107,116,101,120,116,32,123,103,115,97,118,101,32,48,32,115,101,116,103,114,97,121,32,77,70,115,104,111,119,32,103,114,101,115,116,111,114,101,125,32,123,77,70,115,104,111,119,125,32,105,102,101,108,115,101,32,125,32,98,105,110,100,32,100,101,102,10,0,0,0,0,103,112,105,99,0,0,0,0,47,77,82,115,104,111,119,32,123,32,99,117,114,114,101,110,116,112,111,105,110,116,32,115,116,114,111,107,101,32,77,10,0,0,0,0,0,0,0,0,116,97,98,108,101,0,0,0,32,32,48,32,101,120,99,104,32,82,10,32,32,66,108,97,99,107,116,101,120,116,32,123,103,115,97,118,101,32,48,32,115,101,116,103,114,97,121,32,77,70,115,104,111,119,32,103,114,101,115,116,111,114,101,125,32,123,77,70,115,104,111,119,125,32,105,102,101,108,115,101,32,125,32,98,105,110,100,32,100,101,102,10,0,0,0,0,44,32,112,97,114,97,108,108,101,108,32,116,111,32,97,120,105,115,32,105,110,32,51,68,32,112,108,111,116,115,0,0,101,120,112,101,99,116,105,110,103,32,39,120,39,44,32,39,120,50,39,44,32,39,97,117,116,111,39,32,111,114,32,39,111,102,102,39,0,0,0,0,115,101,116,32,97,110,103,108,101,115,32,37,115,10,0,0,47,77,76,115,104,111,119,32,123,32,99,117,114,114,101,110,116,112,111,105,110,116,32,115,116,114,111,107,101,32,77,10,0,0,0,0,0,0,0,0,32,32,32,32,32,54,32,103,101,116,32,71,115,119,105,100,116,104,32,112,111,112,32,97,100,100,125,32,123,112,111,112,125,32,105,102,101,108,115,101,125,32,105,102,101,108,115,101,125,32,102,111,114,97,108,108,125,32,100,101,102,10,0,0,32,123,100,117,112,32,51,32,103,101,116,123,100,117,112,32,100,117,112,32,48,32,103,101,116,32,102,105,110,100,102,111,110,116,32,101,120,99,104,32,49,32,103,101,116,32,115,99,97,108,101,102,111,110,116,32,115,101,116,102,111,110,116,10,0,0,0,0,0,0,0,0,37,50,46,50,115,0,0,0,115,106,105,115,0,0,0,0,47,77,70,119,105,100,116,104,32,123,48,32,101,120,99,104,32,123,32,100,117,112,32,53,32,103,101,116,32,51,32,103,101,32,123,32,53,32,103,101,116,32,51,32,101,113,32,123,32,48,32,125,32,123,32,112,111,112,32,125,32,105,102,101,108,115,101,32,125,10,0,0,84,97,98,117,108,97,114,32,111,117,116,112,117,116,32,111,102,32,37,115,32,112,108,111,116,32,115,116,121,108,101,32,110,111,116,32,102,117,108,108,121,32,105,109,112,108,101,109,101,110,116,101,100,10,0,0,108,97,110,100,0,0,0,0,47,71,115,119,105,100,116,104,32,123,100,117,112,32,116,121,112,101,32,47,115,116,114,105,110,103,116,121,112,101,32,101,113,32,123,115,116,114,105,110,103,119,105,100,116,104,125,32,123,112,111,112,32,40,110,41,32,115,116,114,105,110,103,119,105,100,116,104,125,32,105,102,101,108,115,101,125,32,100,101,102,10,0,0,0,0,0,0,32,32,32,102,111,114,97,108,108,125,32,100,101,102,10,0,32,32,32,32,32,105,102,101,108,115,101,32,125,10,0,0,71,80,86,65,76,95,79,85,84,80,85,84,0,0,0,0,32,32,32,32,32,112,111,112,32,97,108,111,97,100,32,112,111,112,32,77,125,32,105,102,101,108,115,101,32,125,105,102,101,108,115,101,32,125,105,102,101,108,115,101,32,125,10,0,85,110,107,110,111,119,110,32,116,101,114,109,105,110,97,108,32,116,121,112,101,32,45,32,110,111,116,32,97,32,112,108,111,116,116,105,110,103,32,100,101,118,105,99,101,0,0,0,32,32,32,32,32,115,104,111,119,32,50,32,105,110,100,101,120,32,123,97,108,111,97,100,32,112,111,112,32,77,32,110,101,103,32,51,32,45,49,32,114,111,108,108,32,110,101,103,32,82,32,112,111,112,32,112,111,112,125,32,123,112,111,112,32,112,111,112,32,112,111,112,10,0,0,0,0,0,0,0,115,117,36,114,102,97,99,101,0,0,0,0,0,0,0,0,101,108,115,101,0,0,0,0,32,32,32,32,32,100,117,112,32,48,32,82,125,32,123,100,117,112,32,54,32,103,101,116,32,115,116,114,105,110,103,119,105,100,116,104,32,112,111,112,32,45,50,32,100,105,118,32,48,32,82,32,54,32,103,101,116,10,0,0,0,0,0,0,44,32,117,115,105,110,103,32,102,111,110,116,32,34,37,115,34,0,0,0,0,0,0,0,97,117,116,111,0,0,0,0,78,111,32,118,97,108,105,100,32,100,97,116,97,32,112,111,105,110,116,115,32,102,111,117,110,100,32,105,110,32,102,105,108,101,0,0,0,0,0,0,115,101,116,32,102,111,114,109,97,116,32,37,115,32,34,37,115,34,10,0,0,0,0,0,32,32,32,32,32,103,101,116,32,49,32,101,113,32,123,100,117,112,32,50,32,103,101,116,32,101,120,99,104,32,100,117,112,32,51,32,103,101,116,32,101,120,99,104,32,54,32,103,101,116,32,115,116,114,105,110,103,119,105,100,116,104,32,112,111,112,32,45,50,32,100,105,118,10,0,0,0,0,0,0,32,32,32,32,32,123,100,117,112,32,51,32,103,101,116,32,123,50,32,103,101,116,32,110,101,103,32,48,32,101,120,99,104,32,82,32,112,111,112,125,32,123,112,111,112,32,97,108,111,97,100,32,112,111,112,32,77,125,32,105,102,101,108,115,101,125,32,123,100,117,112,32,53,10,0,0,0,0,0,0,32,32,32,32,32,103,101,116,32,101,120,99,104,32,52,32,103,101,116,32,123,71,115,104,111,119,125,32,123,115,116,114,105,110,103,119,105,100,116,104,32,112,111,112,32,48,32,82,125,32,105,102,101,108,115,101,32,125,105,102,32,100,117,112,32,53,32,103,101,116,32,48,32,101,113,10,0,0,0,0,10,9,32,32,32,32,83,99,97,110,58,32,0,0,0,0,32,32,32,32,32,91,32,99,117,114,114,101,110,116,112,111,105,110,116,32,93,32,101,120,99,104,32,100,117,112,32,50,32,103,101,116,32,48,32,101,120,99,104,32,82,32,100,117,112,32,53,32,103,101,116,32,50,32,110,101,32,123,100,117,112,32,100,117,112,32,54,10,0,0,0,0,0,0,0,0,32,32,32,32,32,123,100,117,112,32,100,117,112,32,48,32,103,101,116,32,102,105,110,100,102,111,110,116,32,101,120,99,104,32,49,32,103,101,116,32,115,99,97,108,101,102,111,110,116,32,115,101,116,102,111,110,116,10,0,0,0,0,0,0,32,32,32,32,32,123,32,53,32,103,101,116,32,51,32,101,113,32,123,103,115,97,118,101,125,32,123,103,114,101,115,116,111,114,101,125,32,105,102,101,108,115,101,32,125,10,0,0,45,76,73,66,71,68,32,32,0,0,0,0,0,0,0,0,32,32,32,123,32,100,117,112,32,53,32,103,101,116,32,51,32,103,101,10,0,0,0,0,71,80,86,65,76,95,84,69,82,77,79,80,84,73,79,78,83,0,0,0,0,0,0,0,47,77,70,115,104,111,119,32,123,10,0,0,0,0,0,0,123,125,94,95,64,38,126,10,0,0,0,0,0,0,0,0,125,32,105,102,10,0,0,0,115,116,36,121,108,101,0,0,103,115,97,118,101,32,66,97,99,107,103,114,111,117,110,100,67,111,108,111,114,32,67,32,99,108,105,112,112,97,116,104,32,102,105,108,108,32,103,114,101,115,116,111,114,101,0,0,9,37,115,37,115,32,105,115,32,34,37,115,34,44,32,111,102,102,115,101,116,32,97,116,32,0,0,0,0,0,0,0,116,101,120,116,95,108,97,98,101,108,0,0,0,0,0,0,115,101,116,32,100,117,109,109,121,32,37,115,44,37,115,10,0,0,0,0,0,0,0,0,66,97,99,107,103,114,111,117,110,100,67,111,108,111,114,32,67,32,49,46,48,48,48,32,48,32,48,32,37,46,50,102,32,37,46,50,102,32,66,111,120,67,111,108,70,105,108,108,0,0,0,0,0,0,0,0,66,97,99,107,103,114,111,117,110,100,67,111,108,111,114,32,48,32,108,116,32,51,32,49,32,114,111,108,108,32,48,32,108,116,32,101,120,99,104,32,48,32,108,116,32,111,114,32,111,114,32,110,111,116,32,123,0,0,0,0,0,0,0,0,40,37,115,41,32,102,105,110,100,102,111,110,116,32,37,100,32,115,99,97,108,101,102,111,110,116,32,115,101,116,102,111,110,116,10,0,0,0,0,0,10,9,32,32,32,32,51,68,32,110,111,114,109,97,108,32,118,101,99,116,111,114,58,32,40,37,102,44,32,37,102,44,32,37,102,41,0,0,0,0,32,32,35,32,40,99,117,114,114,101,110,116,108,121,32,91,0,0,0,0,0,0,0,0,48,32,115,101,116,103,114,97,121,10,110,101,119,112,97,116,104,10,0,0,0,0,0,0,110,111,116,36,105,116,108,101,0,0,0,0,0,0,0,0,57,48,32,114,111,116,97,116,101,10,48,32,37,100,32,116,114,97,110,115,108,97,116,101,10,0,0,0,0,0,0,0,103,110,117,100,105,99,116,32,98,101,103,105,110,10,103,115,97,118,101,10,100,111,99,108,105,112,10,37,100,32,37,100,32,116,114,97,110,115,108,97,116,101,10,37,46,51,102,32,37,46,51,102,32,115,99,97,108,101,10,0,0,0,0,0,45,0,0,0,0,0,0,0,87,114,105,116,105,110,103,32,111,117,116,32,80,111,115,116,83,99,114,105,112,116,32,109,97,99,114,111,115,32,102,111,114,32,101,110,104,97,110,99,101,100,32,116,101,120,116,32,109,111,100,101,10,0,0,0,37,37,37,37,80,97,103,101,58,32,37,100,32,37,100,10,0,0,0,0,0,0,0,0,46,0,0,0,0,0,0,0,37,100,32,37,100,32,78,10,0,0,0,0,0,0,0,0,71,80,95,70,73,82,83,84,95,75,69,89,0,0,0,0,37,100,32,37,100,32,82,10,0,0,0,0,0,0,0,0,108,97,98,101,108,0,0,0,47,121,48,32,121,48,32,121,115,116,101,112,32,97,100,100,32,100,101,102,32,47,105,105,32,105,105,32,49,32,97,100,100,32,100,101,102,10,105,105,32,105,109,97,120,32,103,101,32,123,101,120,105,116,125,32,105,102,32,125,32,108,111,111,112,10,103,114,101,115,116,111,114,101,32,48,32,115,101,116,103,114,97,121,10,0,0,0,120,0,0,0,0,0,0,0,32,107,100,101,110,115,105,116,121,50,100,0,0,0,0,0,37,100,32,37,100,32,77,10,0,0,0,0,0,0,0,0,116,111,107,101,110,95,116,97,98,108,101,95,115,105,122,101,32,62,61,32,108,102,45,62,110,117,109,95,116,111,107,101,110,115,43,49,0,0,0,0,67,97,110,39,116,32,99,97,108,99,117,108,97,116,101,32,115,112,108,105,110,101,115,44,32,110,101,101,100,32,97,116,32,108,101,97,115,116,32,51,32,112,111,105,110,116,115,0,115,116,114,111,107,101,32,37,100,32,37,100,32,77,10,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,32,58,32,83,84,82,73,78,71,32,111,112,101,114,97,116,111,114,32,97,112,112,108,105,101,100,32,116,111,32,110,111,110,45,83,84,82,73,78,71,32,116,121,112,101,0,0,0,0,0,37,100,32,37,100,32,86,10,0,0,0,0,0,0,0,0,10,9,32,32,32,32,50,68,32,114,111,116,97,116,105,111,110,32,97,110,103,108,101,58,32,37,102,0,0,0,0,0,37,100,32,37,100,32,76,10,0,0,0,0,0,0,0,0,76,84,37,99,10,0,0,0,41,32,82,115,104,111,119,10,0,0,0,0,0,0,0,0,41,32,67,115,104,111,119,10,0,0,0,0,0,0,0,0,71,80,86,65,76,95,84,69,82,77,0,0,0,0,0,0,41,32,76,115,104,111,119,10,0,0,0,0,0,0,0,0,101,115,116,105,109,97,116,101,32,119,105,100,116,104,32,111,102,32,101,110,104,97,110,99,101,100,32,116,101,120,116,32,115,116,114,105,110,103,0,0,93,32,71,82,115,104,111,119,10,0,0,0,0,0,0,0,115,97,36,109,112,108,101,115,0,0,0,0,0,0,0,0,93,32,71,67,115,104,111,119,10,0,0,0,0,0,0,0,110,117,109,101,114,105,99,97,108,0,0,0,0,0,0,0,115,101,116,32,100,103,114,105,100,51,100,32,37,100,44,37,100,32,37,115,37,115,32,37,102,44,37,102,10,0,0,0,93,32,71,76,115,104,111,119,10,0,0,0,0,0,0,0,99,117,114,114,101,110,116,112,111,105,110,116,32,103,115,97,118,101,32,116,114,97,110,115,108,97,116,101,32,37,100,32,114,111,116,97,116,101,32,48,32,48,32,77,10,0,0,0,37,100,32,37,100,32,37,115,10,0,0,0,0,0,0,0,32,40,37,102,44,32,37,102,44,32,37,102,41,0,0,0,97,100,106,117,115,116,105,110,103,32,116,111,32,91,37,103,58,37,103,93,10,0,0,0,80,101,110,116,87,0,0,0,68,105,97,87,0,0,0,0,84,114,105,68,87,0,0,0,84,114,105,85,87,0,0,0,110,101,119,32,108,105,110,101,32,98,117,102,102,101,114,0,67,105,114,99,87,0,0,0,101,115,116,105,109,97,116,101,0,0,0,0,0,0,0,0,66,111,120,87,0,0,0,0,111,98,106,36,101,99,116,0,80,101,110,116,69,0,0,0,108,97,98,36,101,108,115,0,115,101,116,32,100,103,114,105,100,51,100,32,37,100,44,37,100,32,115,112,108,105,110,101,115,10,0,0,0,0,0,0,68,105,97,69,0,0,0,0,84,114,105,68,69,0,0,0,105,115,111,95,56,56,53,57,95,49,0,0,0,0,0,0,84,114,105,85,69,0,0,0,10,9,32,32,32,32,67,101,110,116,101,114,58,0,0,0,67,105,114,99,69,0,0,0,73,109,97,103,101,32,103,114,105,100,32,109,117,115,116,32,98,101,32,97,116,32,108,101,97,115,116,32,52,32,112,111,105,110,116,115,32,40,50,32,120,32,50,41,46,10,10,0,66,111,120,69,0,0,0,0,68,49,53,0,0,0,0,0,68,49,52,0,0,0,0,0,85,110,107,110,111,119,110,32,112,111,105,110,116,32,116,121,112,101,32,105,110,32,112,108,111,116,51,100,95,108,105,110,101,115,0,0,0,0,0,0,79,114,105,103,105,110,95,49,0,0,0,0,0,0,0,0,10,35,32,67,117,114,118,101,32,37,100,32,111,102,32,37,100,44,32,37,100,32,112,111,105,110,116,115,0,0,0,0,68,49,51,0,0,0,0,0,123,125,36,91,93,92,0,0,68,49,50,0,0,0,0,0,112,115,100,105,114,0,0,0,68,49,49,0,0,0,0,0,9,37,115,32,105,115,32,115,101,116,32,116,111,32,37,115,10,0,0,0,0,0,0,0,115,101,112,97,114,97,116,105,111,110,32,109,117,115,116,32,98,101,32,62,32,48,0,0,115,101,116,32,100,103,114,105,100,51,100,32,37,100,44,37,100,44,32,37,100,10,0,0,68,49,48,0,0,0,0,0,76,0,0,0,0,0,0,0,68,57,0,0,0,0,0,0,68,56,0,0,0,0,0,0,10,9,32,32,32,32,79,114,105,103,105,110,58,0,0,0,68,55,0,0,0,0,0,0,68,54,0,0,0,0,0,0,68,53,0,0,0,0,0,0,68,52,0,0,0,0,0,0,68,51,0,0,0,0,0,0,100,117,112,32,100,117,112,32,109,117,108,32,109,117,108,0,101,110,104,97,110,99,101,100,32,116,101,120,116,32,109,111,100,101,32,112,97,114,115,105,110,103,32,101,114,114,111,114,0,0,0,0,0,0,0,0,68,50,0,0,0,0,0,0,112,111,108,36,97,114,0,0,68,49,0,0,0,0,0,0,9,114,101,97,100,32,102,111,114,109,97,116,32,102,111,114,32,116,105,109,101,32,111,110,32,37,115,32,97,120,105,115,32,105,115,32,34,37,115,34,10,0,0,0,0,0,0,0,115,101,112,36,97,114,97,116,105,111,110,0,0,0,0,0,121,121,10,0,0,0,0,0,68,48,0,0,0,0,0,0,108,0,0,0,0,0,0,0,83,49,53,0,0,0,0,0,83,49,52,0,0,0,0,0,44,32,100,122,61,37,102,0,83,49,51,0,0,0,0,0,83,49,50,0,0,0,0,0,83,49,49,0,0,0,0,0,83,49,48,0,0,0,0,0,83,57,0,0,0,0,0,0,101,110,104,97,110,99,101,100,32,116,101,120,116,32,109,111,100,101,32,112,97,114,115,101,114,32,45,32,105,103,110,111,114,105,110,103,32,115,112,117,114,105,111,117,115,32,125,0,83,56,0,0,0,0,0,0,112,111,105,36,110,116,115,105,122,101,0,0,0,0,0,0,83,55,0,0,0,0,0,0,9,122,101,114,111,32,105,115,32,37,103,10,0,0,0,0,83,54,0,0,0,0,0,0,102,105,110,97,110,99,101,36,98,97,114,115,0,0,0,0,120,120,10,0,0,0,0,0,114,101,115,105,122,101,95,100,121,110,97,114,114,97,121,58,32,100,121,110,97,114,114,97,121,32,119,97,115,110,39,116,32,105,110,105,116,105,97,108,105,122,101,100,33,0,0,0,104,0,0,0,0,0,0,0,83,53,0,0,0,0,0,0,83,52,0,0,0,0,0,0,44,32,100,121,61,37,102,0,83,51,0,0,0,0,0,0,83,50,0,0,0,0,0,0,73,47,79,32,101,114,114,111,114,32,100,117,114,105,110,103,32,117,112,100,97,116,101,0,83,49,0,0,0,0,0,0,83,48,0,0,0,0,0,0,71,80,86,65,76,95,86,73,69,87,95,77,65,80,0,0,67,49,53,0,0,0,0,0,115,118,103,0,0,0,0,0,67,49,52,0,0,0,0,0,112,111,105,110,116,105,110,116,36,101,114,118,97,108,98,111,120,0,0,0,0,0,0,0,67,49,51,0,0,0,0,0,102,105,108,101,116,36,121,112,101,115,0,0,0,0,0,0,99,97,110,100,108,101,36,115,116,105,99,107,115,0,0,0,120,121,10,0,0,0,0,0,67,49,50,0,0,0,0,0,103,0,0,0,0,0,0,0,67,49,49,0,0,0,0,0,67,49,48,0,0,0,0,0,10,9,32,32,32,32,83,97,109,112,108,101,32,112,101,114,105,111,100,115,58,32,100,120,61,37,102,0,0,0,0,0,67,57,0,0,0,0,0,0,67,56,0,0,0,0,0,0,36,96,0,0,0,0,0,0,67,55,0,0,0,0,0,0,121,122,97,102,112,110,117,109,32,107,77,71,84,80,69,90,89,0,0,0,0,0,0,0,67,54,0,0,0,0,0,0,37,73,58,37,77,58,37,83,32,37,112,0,0,0,0,0,71,80,86,65,76,95,83,80,76,79,84,0,0,0,0,0,67,53,0,0,0,0,0,0,101,110,104,97,110,99,101,100,32,116,101,120,116,32,112,97,114,115,101,114,32,45,45,32,115,112,117,114,105,111,117,115,32,98,97,99,107,115,108,97,115,104,0,0,0,0,0,0,67,52,0,0,0,0,0,0,99,111,108,111,114,115,0,0,67,51,0,0,0,0,0,0,100,97,116,97,115,36,105,122,101,115,0,0,0,0,0,0,102,114,97,99,116,105,111,110,32,109,117,115,116,32,98,101,32,108,101,115,115,32,116,104,97,110,32,49,0,0,0,0,117,110,105,116,115,32,0,0,67,50,0,0,0,0,0,0,101,0,0,0,0,0,0,0,67,49,0,0,0,0,0,0,67,48,0,0,0,0,0,0,97,108,108,32,102,111,114,119,97,114,100,0,0,0,0,0,107,111,105,56,117,0,0,0,80,101,110,116,70,0,0,0,32,32,114,101,100,32,103,114,101,101,110,32,98,108,117,101,32,97,108,112,104,97,0,0,80,101,110,116,0,0,0,0,108,111,114,0,0,0,0,0,68,105,97,70,0,0,0,0,68,105,97,0,0,0,0,0,71,80,86,65,76,95,80,76,79,84,0,0,0,0,0,0,84,114,105,68,70,0,0,0,94,95,64,38,126,123,125,0,84,114,105,68,0,0,0,0,99,111,108,111,114,110,36,97,109,101,115,0,0,0,0,0,105,102,0,0,0,0,0,0,84,114,105,85,70,0,0,0,98,105,110,36,97,114,121,0,102,114,97,99,36,116,105,111,110,0,0,0,0,0,0,0,65,108,108,32,112,111,105,110,116,115,32,111,117,116,32,111,102,32,114,97,110,103,101,0,32,97,110,103,108,101,32,37,103,32,0,0,0,0,0,0,84,114,105,85,0,0,0,0,98,0,0,0,0,0,0,0,67,105,114,99,108,101,70,0,108,111,119,36,101,114,0,0,67,105,114,99,108,101,0,0,37,115,102,108,105,112,32,122,0,0,0,0,0,0,0,0,66,111,120,70,0,0,0,0,66,111,120,0,0,0,0,0,83,116,97,114,0,0,0,0,45,76,73,66,82,69,65,68,76,73,78,69,32,32,45,72,73,83,84,79,82,89,32,32,0,0,0,0,0,0,0,0,67,114,115,0,0,0,0,0,71,80,86,65,76,95,82,95,76,79,71,0,0,0,0,0])
.concat([80,108,115,0,0,0,0,0,98,97,100,32,115,121,110,116,97,120,32,105,110,32,101,110,104,97,110,99,101,100,32,116,101,120,116,32,115,116,114,105,110,103,0,0,0,0,0,0,80,110,116,0,0,0,0,0,99,111,108,111,114,98,36,111,120,0,0,0,0,0,0,0,103,115,97,118,101,32,91,93,32,48,32,115,101,116,100,97,115,104,10,0,0,0,0,0,9,78,111,32,102,108,111,97,116,105,110,103,32,112,111,105,110,116,32,101,120,99,101,112,116,105,111,110,32,104,97,110,100,108,101,114,32,100,117,114,105,110,103,32,100,97,116,97,32,105,110,112,117,116,10,0,114,97,119,0,0,0,0,0,85,110,114,101,99,111,103,110,105,122,101,100,32,111,112,116,105,111,110,46,32,32,83,101,101,32,39,104,101,108,112,32,115,101,116,39,46,0,0,0,114,97,110,103,101,0,0,0,115,101,116,32,115,116,121,108,101,32,101,108,108,105,112,115,101,32,115,105,122,101,32,0,47,118,115,104,105,102,116,32,37,100,32,100,101,102,10,0,97,0,0,0,0,0,0,0,47,37,115,32,102,105,110,100,102,111,110,116,32,37,103,32,115,99,97,108,101,102,111,110,116,32,115,101,116,102,111,110,116,10,0,0,0,0,0,0,37,102,0,0,0,0,0,0,109,105,115,115,105,110,103,32,102,105,108,101,110,97,109,101,0,0,0,0,0,0,0,0,37,46,51,102,32,85,80,10,0,0,0,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,34,116,105,116,108,101,34,32,102,111,114,32,112,108,111,116,0,0,0,0,0,0,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,48,32,80,97,116,116,101,114,110,70,105,108,108,10,0,0,0,0,0,0,0,0,110,101,119,104,105,115,116,36,111,103,114,97,109,0,0,0,49,32,37,100,32,37,100,32,37,100,32,37,100,32,66,111,120,67,111,108,70,105,108,108,10,0,0,0,0,0,0,0,87,65,82,78,73,78,71,58,32,69,114,114,111,114,32,100,117,114,105,110,103,32,105,110,105,116,105,97,108,105,122,97,116,105,111,110,10,10,0,0,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,50,32,80,97,116,116,101,114,110,70,105,108,108,10,0,0,0,0,0,0,0,0,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,49,32,80,97,116,116,101,114,110,70,105,108,108,10,0,0,0,0,0,0,0,0,71,80,86,65,76,95,82,95,77,73,78,0,0,0,0,0,39,59,39,32,101,120,112,101,99,116,101,100,0,0,0,0,101,110,104,97,110,99,101,100,32,116,101,120,116,32,112,97,114,115,101,114,32,45,32,115,112,117,114,105,111,117,115,32,125,0,0,0,0,0,0,0,37,100,32,37,100,32,37,100,32,37,100,32,66,111,120,70,105,108,108,10,0,0,0,0,112,97,108,36,101,116,116,101,0,0,0,0,0,0,0,0,98,105,110,100,58,32,99,97,110,110,111,116,32,112,97,114,115,101,32,37,115,10,0,0,10,32,47,84,114,97,110,115,112,97,114,101,110,116,80,97,116,116,101,114,110,115,32,116,114,117,101,32,100,101,102,10,0,0,0,0,0,0,0,0,9,68,97,116,97,102,105,108,101,32,112,97,114,115,105,110,103,32,119,105,108,108,32,97,99,99,101,112,116,32,70,111,114,116,114,97,110,32,68,32,111,114,32,81,32,99,111,110,115,116,97,110,116,115,10,0,112,116,0,0,0,0,0,0,121,48,32,48,32,78,32,48,32,49,32,86,32,121,115,116,101,112,32,48,32,86,32,48,32,45,49,32,102,10,0,0,32,10,0,0,0,0,0,0,37,46,51,102,32,37,100,32,37,100,32,37,100,32,37,100,32,66,111,120,67,111,108,70,105,108,108,10,0,0,0,0,67,97,110,110,111,116,32,115,109,111,111,116,104,58,32,110,111,32,100,97,116,97,32,119,105,116,104,105,110,32,102,105,120,101,100,32,120,114,97,110,103,101,33,0,0,0,0,0,37,115,65,108,116,45,0,0,105,110,116,101,114,110,97,108,32,101,114,114,111,114,32,58,32,97,114,103,117,109,101,110,116,32,110,101,105,116,104,101,114,32,73,78,84,32,111,114,32,67,77,80,76,88,0,0,37,100,32,37,100,32,37,100,32,37,100,32,82,101,99,32,102,105,108,108,10,0,0,0,37,46,51,102,32,85,76,10,0,0,0,0,0,0,0,0,37,115,102,108,105,112,32,121,0,0,0,0,0,0,0,0,32,32,105,102,125,32,105,102,101,108,115,101,125,32,105,102,101,108,115,101,125,32,105,102,101,108,115,101,125,32,100,101,102,10,0,0,0,0,0,0,32,32,88,89,90,50,82,71,66,125,123,67,111,108,111,114,83,112,97,99,101,32,40,67,77,89,41,32,101,113,32,123,67,77,89,50,82,71,66,125,123,67,111,108,111,114,83,112,97,99,101,32,40,89,73,81,41,32,101,113,32,123,89,73,81,50,82,71,66,125,10,0,105,110,118,101,114,115,101,95,110,111,114,109,97,108,95,102,117,110,99,0,0,0,0,0,47,83,101,108,101,99,116,83,112,97,99,101,32,123,67,111,108,111,114,83,112,97,99,101,32,40,72,83,86,41,32,101,113,32,123,72,83,86,50,82,71,66,125,123,67,111,108,111,114,83,112,97,99,101,32,40,88,89,90,41,32,101,113,32,123,10,0,0,0,0,0,0,32,32,101,120,99,104,32,49,46,57,49,32,109,117,108,32,101,120,99,104,32,97,100,100,32,67,111,110,115,116,114,97,105,110,32,51,32,49,32,114,111,108,108,125,32,100,101,102,10,0,0,0,0,0,0,0,32,32,45,48,46,57,56,52,52,32,109,117,108,32,97,100,100,32,67,111,110,115,116,114,97,105,110,32,53,32,49,32,114,111,108,108,32,45,48,46,50,56,57,49,32,109,117,108,32,101,120,99,104,32,45,48,46,53,51,51,56,32,109,117,108,32,97,100,100,10,0,0,105,115,95,106,117,109,112,40,111,112,101,114,97,116,111,114,41,32,124,124,32,40,106,117,109,112,95,111,102,102,115,101,116,32,61,61,32,49,41,0,78,111,32,102,105,108,108,101,100,32,112,111,108,121,103,111,110,115,0,0,0,0,0,0,32,32,67,111,110,115,116,114,97,105,110,32,52,32,49,32,114,111,108,108,32,51,32,99,111,112,121,32,45,48,46,48,50,55,57,32,109,117,108,32,101,120,99,104,32,49,46,57,57,57,32,109,117,108,32,97,100,100,32,101,120,99,104,10,0,0,0,0,0,0,0,0,112,109,36,51,100,0,0,0,32,32,51,32,99,111,112,121,32,45,48,46,57,48,49,55,32,109,117,108,32,101,120,99,104,32,45,48,46,49,49,56,55,32,109,117,108,32,97,100,100,32,101,120,99,104,32,48,46,48,53,56,53,32,109,117,108,32,101,120,99,104,32,97,100,100,10,0,0,0,0,0,9,67,111,109,109,101,110,116,115,32,99,104,97,114,115,32,97,114,101,32,34,37,115,34,10,0,0,0,0,0,0,0,112,111,105,110,116,36,116,121,112,101,0,0,0,0,0,0,115,101,116,32,115,116,121,108,101,32,99,105,114,99,108,101,32,114,97,100,105,117,115,32,0,0,0,0,0,0,0,0,47,88,89,90,50,82,71,66,32,123,0,0,0,0,0,0,32,32,49,32,101,120,99,104,32,115,117,98,32,101,120,99,104,32,49,32,101,120,99,104,32,115,117,98,32,51,32,50,32,114,111,108,108,32,49,32,101,120,99,104,32,115,117,98,32,51,32,49,32,114,111,108,108,32,101,120,99,104,32,125,32,100,101,102,10,0,0,0,67,116,114,108,45,0,0,0,47,67,77,89,50,82,71,66,32,123,0,0,0,0,0,0,102,108,105,112,32,120,0,0,87,97,114,110,105,110,103,58,32,101,109,112,116,121,32,37,115,32,114,97,110,103,101,32,91,37,103,58,37,103,93,44,32,0,0,0,0,0,0,0,32,32,48,46,54,50,49,32,109,117,108,32,101,120,99,104,32,45,48,46,57,53,54,32,109,117,108,32,97,100,100,32,97,100,100,32,67,111,110,115,116,114,97,105,110,32,51,32,49,32,114,111,108,108,32,125,32,100,101,102,10,0,0,0,32,32,51,32,99,111,112,121,32,45,48,46,54,52,55,32,109,117,108,32,101,120,99,104,32,45,48,46,50,55,50,32,109,117,108,32,97,100,100,32,97,100,100,32,67,111,110,115,116,114,97,105,110,32,53,32,49,32,114,111,108,108,10,0,32,32,51,32,99,111,112,121,32,45,49,46,55,48,50,32,109,117,108,32,101,120,99,104,32,45,49,46,49,48,53,32,109,117,108,32,97,100,100,32,97,100,100,32,67,111,110,115,116,114,97,105,110,32,52,32,49,32,114,111,108,108,10,0,47,89,73,81,50,82,71,66,32,123,10,0,0,0,0,0,107,101,121,32,97,114,114,97,121,0,0,0,0,0,0,0,32,32,100,117,112,32,48,32,108,116,32,123,48,32,101,120,99,104,32,112,111,112,125,123,100,117,112,32,49,32,103,116,32,123,49,32,101,120,99,104,32,112,111,112,125,32,105,102,125,32,105,102,101,108,115,101,125,32,100,101,102,10,0,0,102,105,108,108,101,100,32,112,111,108,121,103,111,110,115,58,0,0,0,0,0,0,0,0,47,67,111,110,115,116,114,97,105,110,32,123,10,0,0,0,112,97,36,114,97,109,101,116,114,105,99,0,0,0,0,0,32,32,125,32,105,102,101,108,115,101,125,32,100,101,102,10,0,0,0,0,0,0,0,0,99,111,109,36,109,101,110,116,115,0,0,0,0,0,0,0,111,117,116,36,108,105,101,114,115,0,0,0,0,0,0,0,115,101,116,32,115,116,121,108,101,32,114,101,99,116,97,110,103,108,101,32,37,115,32,102,99,32,0,0,0,0,0,0,9,32,123,72,83,86,118,32,72,83,86,112,32,72,83,86,113,125,32,105,102,101,108,115,101,125,32,105,102,101,108,115,101,125,32,105,102,101,108,115,101,125,32,105,102,101,108,115,101,125,32,105,102,101,108,115,101,10,0,0,0,0,0,0,96,37,115,58,37,100,32,111,111,112,115,46,39,10,0,0,9,32,123,51,32,72,83,86,105,32,101,113,32,123,72,83,86,112,32,72,83,86,113,32,72,83,86,118,125,123,52,32,72,83,86,105,32,101,113,32,123,72,83,86,116,32,72,83,86,112,32,72,83,86,118,125,10,0,0,0,0,0,0,0,9,32,123,49,32,72,83,86,105,32,101,113,32,123,72,83,86,113,32,72,83,86,118,32,72,83,86,112,125,123,50,32,72,83,86,105,32,101,113,32,123,72,83,86,112,32,72,83,86,118,32,72,83,86,116,125,10,0,0,0,0,0,0,0,10,9,32,32,32,32,68,105,114,101,99,116,105,111,110,58,32,0,0,0,0,0,0,0,9,32,47,72,83,86,105,32,72,83,86,105,32,54,32,109,111,100,32,100,101,102,32,48,32,72,83,86,105,32,101,113,32,123,72,83,86,118,32,72,83,86,116,32,72,83,86,112,125,10,0,0,0,0,0,0,78,111,32,112,111,105,110,116,115,32,40,118,105,115,105,98,108,101,32,111,114,32,105,110,118,105,115,105,98,108,101,41,32,116,111,32,112,108,111,116,46,10,10,0,0,0,0,0,9,32,47,72,83,86,116,32,72,83,86,118,32,49,46,48,32,72,83,86,115,32,49,46,48,32,72,83,86,102,32,115,117,98,32,109,117,108,32,115,117,98,32,109,117,108,32,100,101,102,10,0,0,0,0,0,9,32,47,72,83,86,113,32,72,83,86,118,32,49,46,48,32,72,83,86,115,32,72,83,86,102,32,109,117,108,32,115,117,98,32,109,117,108,32,100,101,102,32,10,0,0,0,0,32,32,32,32,47,72,83,86,102,32,101,120,99,104,32,100,101,102,32,47,72,83,86,105,32,101,120,99,104,32,99,118,105,32,100,101,102,32,47,72,83,86,112,32,72,83,86,118,32,49,46,48,32,72,83,86,115,32,115,117,98,32,109,117,108,32,100,101,102,10,0,0,103,114,97,112,104,98,111,120,0,0,0,0,0,0,0,0,32,32,123,32,47,72,83,86,115,32,101,120,99,104,32,100,101,102,32,47,72,83,86,118,32,101,120,99,104,32,100,101,102,32,54,46,48,32,109,117,108,32,100,117,112,32,102,108,111,111,114,32,100,117,112,32,51,32,49,32,114,111,108,108,32,115,117,98,10,32,0,0,66,121,116,101,79,114,100,101,114,0,0,0,0,0,0,0,110,111,110,45,105,110,116,101,103,101,114,32,112,97,115,115,101,100,32,116,111,32,98,111,111,108,101,97,110,32,111,112,101,114,97,116,111,114,0,0,37,50,100,0,0,0,0,0,32,32,101,120,99,104,32,100,117,112,32,48,46,48,32,101,113,32,123,112,111,112,32,101,120,99,104,32,112,111,112,32,100,117,112,32,100,117,112,125,32,37,32,97,99,104,114,111,109,97,116,105,99,32,103,114,97,121,10,0,0,0,0,0,111,36,117,116,112,117,116,0,47,72,83,86,50,82,71,66,32,123,0,0,0,0,0,0,9,100,97,116,97,102,105,108,101,32,102,105,101,108,100,115,32,115,101,112,97,114,97,116,101,100,32,98,121,32,119,104,105,116,101,115,112,97,99,101,10,0,0,0,0,0,0,0,110,111,111,117,116,36,108,105,101,114,115,0,0,0,0,0,115,101,116,32,115,116,121,108,101,32,102,105,108,108,32,0,47,99,70,37,105,32,123,37,115,125,32,98,105,110,100,32,100,101,102,9,37,37,32,37,115,10,0,0,0,0,0,0,32,32,32,32,123,47,100,103,100,120,118,97,108,32,100,103,100,120,32,100,101,102,32,114,101,100,118,97,108,117,101,32,103,114,101,101,110,118,97,108,117,101,32,98,108,117,101,118,97,108,117,101,125,32,105,102,101,108,115,101,125,32,100,101,102,10,0,0,0,0,0,0,32,32,32,32,123,82,101,100,65,32,103,105,100,120,32,103,101,116,32,71,114,101,101,110,65,32,103,105,100,120,32,103,101,116,32,66,108,117,101,65,32,103,105,100,120,32,103,101,116,125,10,0,0,0,0,0,32,32,103,114,97,121,105,110,100,101,120,32,103,114,97,121,118,32,71,114,97,121,65,32,103,105,100,120,32,103,101,116,32,115,117,98,32,97,98,115,32,49,101,45,53,32,108,101,10,0,0,0,0,0,0,0,47,105,110,116,101,114,112,111,108,97,116,101,32,123,10,0,32,32,66,108,117,101,65,32,103,105,100,120,32,103,101,116,32,115,117,98,32,100,103,100,120,118,97,108,32,109,117,108,32,97,100,100,125,32,100,101,102,10,0,0,0,0,0,0,47,98,108,117,101,118,97,108,117,101,32,123,66,108,117,101,65,32,103,105,100,120,32,103,101,116,32,66,108,117,101,65,32,103,105,100,120,32,49,32,115,117,98,32,103,101,116,10,0,0,0,0,0,0,0,0,32,32,71,114,101,101,110,65,32,103,105,100,120,32,103,101,116,32,115,117,98,32,100,103,100,120,118,97,108,32,109,117,108,32,97,100,100,125,32,100,101,102,10,0,0,0,0,0,115,116,97,99,107,32,111,118,101,114,102,108,111,119,0,0,120,94,50,0,0,0,0,0,112,97,116,116,101,114,110,32,102,105,108,108,0,0,0,0,47,103,114,101,101,110,118,97,108,117,101,32,123,71,114,101,101,110,65,32,103,105,100,120,32,103,101,116,32,71,114,101,101,110,65,32,103,105,100,120,32,49,32,115,117,98,32,103,101,116,10,0,0,0,0,0,111,114,36,105,103,105,110,0,32,32,82,101,100,65,32,103,105,100,120,32,103,101,116,32,115,117,98,32,100,103,100,120,118,97,108,32,109,117,108,32,97,100,100,125,32,100,101,102,10,0,0,0,0,0,0,0,9,100,97,116,97,102,105,108,101,32,102,105,101,108,100,115,32,115,101,112,97,114,97,116,101,100,32,98,121,32,34,37,99,34,10,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,39,100,97,116,97,39,44,32,39,102,117,110,99,116,105,111,110,39,44,32,39,108,105,110,101,39,44,32,39,102,105,108,108,39,44,32,39,114,101,99,116,97,110,103,108,101,39,44,32,39,99,105,114,99,108,101,39,44,32,39,101,108,108,105,112,115,101,39,32,111,114,32,39,97,114,114,111,119,39,0,0,0,0,0,0,0,47,114,101,100,118,97,108,117,101,32,123,82,101,100,65,32,103,105,100,120,32,103,101,116,32,82,101,100,65,32,103,105,100,120,32,49,32,115,117,98,32,103,101,116,10,0,0,0,96,37,115,39,10,0,0,0,32,32,71,114,97,121,65,32,103,105,100,120,32,103,101,116,32,115,117,98,32,100,105,118,125,32,100,101,102,32,10,0,47,100,103,100,120,32,123,103,114,97,121,118,32,71,114,97,121,65,32,103,105,100,120,32,103,101,116,32,115,117,98,32,71,114,97,121,65,32,103,105,100,120,32,49,32,115,117,98,32,103,101,116,10,0,0,0,32,32,123,71,114,97,121,65,32,103,105,100,120,32,103,101,116,32,103,114,97,121,118,32,103,101,32,123,101,120,105,116,125,32,105,102,32,47,103,105,100,120,32,103,105,100,120,32,49,32,97,100,100,32,100,101,102,125,32,108,111,111,112,125,32,100,101,102,10,0,0,0,47,103,114,97,121,105,110,100,101,120,32,123,47,103,105,100,120,32,48,32,100,101,102,10,0,0,0,0,0,0,0,0,93,32,100,101,102,10,0,0,47,37,115,32,91,0,0,0,66,108,117,101,65,0,0,0,78,111,110,45,110,117,109,101,114,105,99,32,115,116,114,105,110,103,32,102,111,117,110,100,32,119,104,101,114,101,32,97,32,110,117,109,101,114,105,99,32,101,120,112,114,101,115,115,105,111,110,32,119,97,115,32,101,120,112,101,99,116,101,100,0,0,0,0,0,0,0,0,116,97,103,32,109,117,115,116,32,98,101,32,62,32,122,101,114,111,0,0,0,0,0,0,108,105,110,101,119,105,100,116,104,0,0,0,0,0,0,0,71,114,101,101,110,65,0,0,111,102,36,102,115,101,116,115,0,0,0,0,0,0,0,0,82,101,100,65,0,0,0,0,115,101,112,36,97,114,97,116,111,114,0,0,0,0,0,0,117,36,115,101,114,115,116,121,108,101,115,0,0,0,0,0,71,114,97,121,65,0,0,0,37,99,32,0,0,0,0,0,32,100,101,102,10,0,0,0,37,115,58,37,100,32,111,111,111,112,115,58,32,85,110,107,110,111,119,110,32,99,111,108,111,114,32,109,111,100,101,108,32,39,37,99,39,46,32,87,105,108,108,32,98,101,32,82,71,66,10,0,0,0,0,0,10,9,32,32,32,32,71,101,110,101,114,97,116,101,32,99,111,111,114,100,105,110,97,116,101,115,58,32,37,115,0,0,40,88,89,90,41,0,0,0,40,89,73,81,41,0,0,0,37,45,49,53,46,49,53,115,32,61,32,37,45,49,53,46,49,53,115,32,32,32,37,115,0,0,0,0,0,0,0,0,40,67,77,89,41,0,0,0,40,72,83,86,41,0,0,0,40,82,71,66,41,0,0,0,115,116,97,99,107,32,117,110,100,101,114,102,108,111,119,32,40,102,117,110,99,116,105,111,110,32,99,97,108,108,32,119,105,116,104,32,109,105,115,115,105,110,103,32,112,97,114,97,109,101,116,101,114,115,63,41,0,0,0,0,0,0,0,0,32,32,108,119,32,37,49,100,37,99,0,0,0,0,0,0,47,67,111,108,111,114,83,112,97,99,101,32,0,0,0,0,120,37,100,0,0,0,0,0,110,111,109,99,98,116,36,105,99,115,0,0,0,0,0,0,32,32,47,103,32,123,115,116,114,111,107,101,32,112,109,51,100,114,111,117,110,100,32,112,109,51,100,71,97,109,109,97,32,101,120,112,32,115,101,116,103,114,97,121,125,32,98,105,110,100,32,100,101,102,10,0,9,34,37,115,34,32,105,110,32,100,97,116,97,102,105,108,101,32,105,115,32,105,110,116,101,114,112,114,101,116,101,100,32,97,115,32,109,105,115,115,105,110,103,32,118,97,108,117,101,10,0,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,39,117,110,105,116,115,32,123,120,121,124,120,120,124,121,121,125,39,44,32,39,97,110,103,108,101,32,60,110,117,109,98,101,114,62,39,32,111,114,32,39,115,105,122,101,32,60,112,111,115,105,116,105,111,110,62,39,0,0,0,0,0,115,101,116,32,98,111,120,119,105,100,116,104,32,37,103,32,37,115,10,0,0,0,0,0,125,123,10,0,0,0,0,0,32,37,45,49,50,115,32,0,32,32,125,32,105,102,101,108,115,101,10,0,0,0,0,0,10,32,32,32,32,32,32,32,83,101,108,101,99,116,83,112,97,99,101,32,115,101,116,114,103,98,99,111,108,111,114,125,32,98,105,110,100,32,100,101,102,10,0,0,0,0,0,0,103,112,95,105,110,112,117,116,95,108,105,110,101,0,0,0,99,70,37,105,32,67,111,110,115,116,114,97,105,110,32,0,99,70,37,105,32,67,111,110,115,116,114,97,105,110,32,101,120,99,104,32,0,0,0,0,36,40,0,0,0,0,0,0,99,70,37,105,32,67,111,110,115,116,114,97,105,110,32,101,120,99,104,32,100,117,112,32,0,0,0,0,0,0,0,0,70,111,114,109,97,116,32,99,104,97,114,97,99,116,101,114,32,109,105,115,109,97,116,99,104,58,32,37,37,99,32,105,115,32,111,110,108,121,32,118,97,108,105,100,32,119,105,116,104,32,37,37,115,0,0,0,49,32,101,120,99,104,32,115,117,98,32,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,39,100,97,116,97,39,44,32,39,102,117,110,99,116,105,111,110,39,44,32,39,108,105,110,101,39,44,32,39,102,105,108,108,39,32,111,114,32,39,97,114,114,111,119,39,0,112,109,0,0,0,0,0,0,32,32,47,103,32,123,115,116,114,111,107,101,32,112,109,51,100,114,111,117,110,100,32,100,117,112,32,0,0,0,0,0,10,119,97,114,110,105,110,103,58,32,32,105,110,116,101,114,110,97,108,32,101,114,114,111,114,45,45,115,116,97,99,107,32,110,111,116,32,101,109,112,116,121,33,10,32,32,32,32,32,32,32,32,32,32,40,102,117,110,99,116,105,111,110,32,99,97,108,108,101,100,32,119,105,116,104,32,116,111,111,32,109,97,110,121,32,112,97,114,97,109,101,116,101,114,115,63,41,10,0,0,0,0,0,0,37,100,0,0,0,0,0,0,32,32,125,123,10,0,0,0,73,110,102,0,0,0,0,0,109,99,98,116,36,105,99,115,0,0,0,0,0,0,0,0,32,32,32,32,32,32,32,32,83,101,108,101,99,116,83,112,97,99,101,32,115,101,116,114,103,98,99,111,108,111,114,125,32,98,105,110,100,32,100,101,102,10,0,0,0,0,0,0,9,78,111,32,109,105,115,115,105,110,103,32,100,97,116,97,32,115,116,114,105,110,103,32,115,101,116,32,102,111,114,32,100,97,116,97,102,105,108,101,10,0,0,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,39,120,121,39,44,32,39,120,120,39,32,111,114,32,39,121,121,39,0,0,0,0,115,101,116,32,98,111,120,119,105,100,116,104,10,0,0,0,32,32,32,32,47,103,32,123,115,116,114,111,107,101,32,112,109,51,100,114,111,117,110,100,32,47,103,114,97,121,118,32,101,120,99,104,32,100,101,102,32,105,110,116,101,114,112,111,108,97,116,101,10,0,0,0,32,32,32,32,32,32,32,32,32,32,32,32,32,32,42,32,105,110,100,105,99,97,116,101,115,32,116,104,105,115,32,107,101,121,32,105,115,32,97,99,116,105,118,101,32,102,114,111,109,32,97,108,108,32,112,108,111,116,32,119,105,110,100,111,119,115,10,0,0,0,0,0,32,32,73,110,116,101,114,112,111,108,97,116,101,100,67,111,108,111,114,32,123,32,37,37,32,73,110,116,101,114,112,111,108,97,116,105,111,110,32,118,115,46,32,82,71,66,45,70,111,114,109,117,108,97,10,0,67,111,108,111,114,32,73,110,116,101,114,112,111,108,97,116,101,100,67,111,108,111,114,32,111,114,32,123,32,37,32,67,79,76,79,85,82,32,118,115,46,32,71,82,65,89,32,109,97,112,10,0,0,0,0,0,101,10,0,0,0,0,0,0,107,111,105,56,114,0,0,0,102,97,108,115,101,32,123,32,37,32,67,79,76,79,85,82,32,118,115,46,32,71,82,65,89,32,109,97,112,10,0,0,32,32,112,105,120,101,108,0,47,112,109,51,100,71,97,109,109,97,32,49,46,48,32,37,103,32,71,97,109,109,97,32,109,117,108,32,100,105,118,32,100,101,102,10,0,0,0,0,117,109,105,110,117,115,0,0,9,123,112,111,112,32,49,125,32,123,109,97,120,99,111,108,111,114,115,32,109,117,108,32,102,108,111,111,114,32,109,97,120,99,111,108,111,114,115,32,49,32,115,117,98,32,100,105,118,125,32,105,102,101,108,115,101,125,32,105,102,125,32,100,101,102,10,0,0,0,0,0,47,112,109,51,100,114,111,117,110,100,32,123,109,97,120,99,111,108,111,114,115,32,48,32,103,116,32,123,100,117,112,32,49,32,103,101,10,0,0,0,46,46,47,116,101,114,109,47,112,111,115,116,46,116,114,109,0,0,0,0,0,0,0,0,117,110,107,110,111,119,110,32,116,121,112,101,32,105,110,32,97,110,103,108,101,40,41,0,115,104,111,119,32,116,105,99,115,99,97,108,101,0,0,0,37,115,58,37,100,32,111,111,111,112,115,58,32,85,110,107,110,111,119,110,32,99,111,108,111,114,32,109,111,100,101,32,39,37,99,39,10,0,0,0,110,111,109,122,116,36,105,99,115,0,0,0,0,0,0,0,9,32,32,32,32,68,105,109,101,110,115,105,111,110,58,32,0,0,0,0,0,0,0,0,104,105,36,115,116,111,114,121,0,0,0,0,0,0,0,0,47,73,110,116,101,114,112,111,108,97,116,101,100,67,111,108,111,114,32,116,114,117,101,32,100,101,102,10,0,0,0,0,109,105,115,115,36,105,110,103,0,0,0,0,0,0,0,0,121,121,0,0,0,0,0,0,47,73,110,116,101,114,112,111,108,97,116,101,100,67,111,108,111,114,32,102,97,108,115,101,32,100,101,102,10,0,0,0,37,48,46,52,102,9,37,48,46,52,102,10,0,0,0,0,99,108,111,115,101,32,116,104,105,115,32,112,108,111,116,32,119,105,110,100,111,119,0,0,47,109,97,120,99,111,108,111,114,115,32,37,105,32,100,101,102,10,0,0,0,0,0,0,103,115,97,118,101,32,37,32,99,111,108,111,117,114,32,112,97,108,101,116,116,101,32,98,101,103,105,110,10,0,0,0,37,115,32,104,97,115,32,37,115,32,99,111,111,114,100,32,111,102,32,37,103,59,32,109,117,115,116,32,98,101,32,97,98,111,118,101,32,48,32,102,111,114,32,108,111,103,32,115,99,97,108,101,33,0,0,0,103,114,101,115,116,111,114,101,32,37,32,99,111,108,111,117,114,32,112,97,108,101,116,116,101,32,101,110,100,10,0,0,37,115,32,103,32,0,0,0,49,32,103,32,0,0,0,0,45,82,69,65,68,76,73,78,69,32,32,0,0,0,0,0,48,32,103,32,0,0,0,0,37,51,46,50,102,32,37,51,46,50,102,32,37,51,46,50,102,32,67,32,0,0,0,0,117,110,107,110,111,119,110,32,116,121,112,101,32,105,110,32,109,97,103,110,105,116,117,100,101,40,41,0,0,0,0,0,99,97,110,39,116,32,114,111,116,97,116,101,32,116,101,120,116,0,0,0,0,0,0,0,76,67,37,49,99,32,115,101,116,114,103,98,99,111,108,111,114,10,0,0,0,0,0,0,105,110,118,97,108,105,100,32,99,111,109,112,108,101,120,32,99,111,110,115,116,97,110,116,0,0,0,0,0,0,0,0,109,122,116,36,105,99,115,0,10,9,32,32,82,101,99,111,114,100,32,37,100,58,10,0,80,76,32,0,0,0,0,0,9,109,111,117,115,101,32,105,115,32,111,102,102,10,0,0,101,120,112,101,99,116,105,110,103,32,100,97,116,97,102,105,108,101,32,109,111,100,105,102,105,101,114,0,0,0,0,0,112,110,103,0,0,0,0,0,120,120,0,0,0,0,0,0,115,101,116,32,37,115,100,97,116,97,32,37,115,10,0,0,32,80,97,116,116,101,114,110,37,100,32,102,105,108,108,32,103,114,101,115,116,111,114,101,10,0,0,0,0,0,0,0,113,0,0,0,0,0,0,0,32,37,46,49,102,32,80,111,108,121,70,105,108,108,10,0,32,47,84,114,97,110,115,112,97,114,101,110,116,80,97,116,116,101,114,110,115,32,116,114,117,101,32,100,101,102,10,0,32,37,46,50,102,32,80,111,108,121,70,105,108,108,10,0,32,49,32,80,111,108,121,70,105,108,108,10,0,0,0,0,32,37,105,32,37,105,32,76,0,0,0,0,0,0,0,0,10,84,101,114,109,105,110,97,108,32,116,121,112,101,32,115,101,116,32,116,111,32,39,37,115,39,10,0,0,0,0,0,32,37,105,32,37,105,32,86,0,0,0,0,0,0,0,0,103,115,97,118,101,32,0,0,117,110,107,110,111,119,110,32,116,121,112,101,32,105,110,32,105,109,97,103,40,41,0,0,32,114,111,116,97,116,101,100,32,98,121,32,45,52,53,32,100,101,103,0,0,0,0,0,32,37,105,32,37,105,32,37,105,32,37,105,32,37,105,32,37,105,32,104,10,0,0,0,110,111,109,121,50,116,36,105,99,115,0,0,0,0,0,0,10,9,32,32,68,101,102,97,117,108,116,32,98,105,110,97,114,121,32,102,111,114,109,97,116,58,32,37,115,0,0,0,99,116,114,108,45,0,0,0,37,105,32,37,105,32,78,0,110,111,116,32,0,0,0,0,42,114,101,116,117,114,110,95,110,117,109,95,98,121,116,101,115,32,60,61,32,109,97,120,95,101,110,99,111,100,101,100,95,98,121,116,101,115,0,0,117,110,105,116,36,115,0,0,48,32,121,48,32,78,32,49,32,48,32,86,32,48,32,121,115,116,101,112,32,86,32,45,49,32,48,32,102,10,0,0,115,101,116,32,116,105,109,101,102,109,116,32,37,115,32,34,37,115,34,10,0,0,0,0,112,100,112,32,40,109,105,100,100,108,101,41,0,0,0,0,85,110,101,120,112,101,99,116,101,100,32,125,0,0,0,0,102,105,118,101,95,100,105,97,103,32,104,101,108,112,32,118,97,114,115,0,0,0,0,0,32,37,45,49,50,115,32,42,32,37,115,10,0,0,0,0,126,62,0,0,0,0,0,0,115,116,114,95,99,111,110,115,116,0,0,0,0,0,0,0,37,49,120,0,0,0,0,0,44,32,39,45,39,32,119,32,108,32,116,105,116,108,101,32,39,78,84,83,67,39,32,108,116,32,45,49,0,0,0,0,101,110,99,111,100,101,100,32,105,109,97,103,101,0,0,0,37,115,105,109,97,103,101,10,0,0,0,0,0,0,0,0,37,115,102,97,108,115,101,32,51,10,37,115,99,111,108,111,114,105,109,97,103,101,10,0,32,32,99,117,114,114,101,110,116,102,105,108,101,32,47,65,83,67,73,73,56,53,68,101,99,111,100,101,32,102,105,108,116,101,114,10,0,0,0,0,68,105,100,32,121,111,117,32,116,114,121,32,116,111,32,103,101,110,101,114,97,116,101,32,97,32,102,105,108,101,32,110,97,109,101,32,117,115,105,110,103,32,100,117,109,109,121,32,118,97,114,105,97,98,108,101,32,120,32,111,114,32,121,63,0,0,0,0,0,0,0,0,32,114,111,116,97,116,101,100,32,98,121,32,43,52,53,32,100,101,103,0,0,0,0,0,123,99,117,114,114,101,110,116,102,105,108,101,32,105,109,97,103,101,98,117,102,32,114,101,97,100,104,101,120,115,116,114,105,110,103,32,112,111,112,125,10,0,0,0,0,0,0,0,109,121,50,116,36,105,99,115,0,0,0,0,0,0,0,0,10,9,32,32,70,105,108,101,32,69,110,100,105,97,110,110,101,115,115,58,32,37,115,0,47,105,109,97,103,101,98,117,102,32,37,100,32,115,116,114,105,110,103,32,100,101,102,10,0,0,0,0,0,0,0,0,9,99,111,109,109,117,110,105,99,97,116,105,111,110,32,99,111,109,109,97,110,100,115,32,119,105,108,108,32,37,115,98,101,32,115,104,111,119,110,10,0,0,0,0,0,0,0,0,97,110,103,36,108,101,0,0,58,32,0,0,0,0,0,0,117,110,115,101,116,32,98,111,114,100,101,114,10,0,0,0,37,115,91,32,37,100,32,48,32,48,32,37,100,32,48,32,48,32,93,10,0,0,0,0,114,97,105,115,101,32,103,110,117,112,108,111,116,32,99,111,110,115,111,108,101,32,119,105,110,100,111,119,0,0,0,0,37,115,37,100,32,37,100,32,37,100,10,0,0,0,0,0,37,115,37,100,32,37,100,32,115,99,97,108,101,10,0,0,98,108,117,101,39,119,32,108,32,108,116,32,51,32,108,99,32,114,103,98,32,39,98,108,117,101,39,0,0,0,0,0,121,0,0,0,0,0,0,0,37,115,37,100,32,37,100,32,116,114,97,110,115,108,97,116,101,10,0,0,0,0,0,0,37,115,123,112,109,51,100,71,97,109,109,97,32,101,120,112,125,32,115,101,116,116,114,97,110,115,102,101,114,10,0,0,9,32,32,87,105,108,108,32,37,115,117,115,101,32,111,116,104,101,114,32,100,105,97,103,111,110,97,108,32,105,102,32,105,116,32,103,105,118,101,115,32,97,32,108,101,115,115,32,106,97,103,103,121,32,111,117,116,108,105,110,101,10,9,32,32,87,105,108,108,32,37,115,100,114,97,119,32,100,105,97,103,111,110,97,108,32,118,105,115,105,98,108,121,32,105,102,32,113,117,97,100,114,97,110,103,108,101,32,105,115,32,39,98,101,110,116,32,111,118,101,114,39,10,0,0,0,0,0,37,115,103,115,97,118,101,10,0,0,0,0,0,0,0,0,37,37,37,37,69,110,100,73,109,97,103,101,10,0,0,0,99,111,110,116,111,117,114,32,101,100,103,101,0,0,0,0,103,114,101,115,116,111,114,101,10,0,0,0,0,0,0,0,101,110,99,111,117,110,116,101,114,101,100,32,97,32,115,116,114,105,110,103,32,119,104,101,110,32,101,120,112,101,99,116,105,110,103,32,97,32,110,117,109,98,101,114,0,0,0,0,114,111,116,97,116,101,100,32,99,101,43,110,116,114,101,100,32,116,101,120,116,0,0,0,10,73,110,116,101,114,112,114,101,116,76,101,118,101,108,49,32,110,111,116,32,123,10,32,32,103,114,101,115,116,111,114,101,10,125,32,105,102,10,0,110,111,109,121,116,36,105,99,115,0,0,0,0,0,0,0,10,103,114,101,115,116,111,114,101,10,0,0,0,0,0,0,9,122,111,111,109,106,117,109,112,32,105,115,32,37,115,10,0,0,0,0,0,0,0,0,115,101,116,32,98,111,114,100,101,114,32,37,100,32,37,115,0,0,0,0,0,0,0,0,32,32,47,73,110,116,101,114,112,111,108,97,116,101,32,102,97,108,115,101,10,62,62,10,105,109,97,103,101,10,0,0,83,112,97,99,101,0,0,0,32,32,47,77,117,108,116,105,112,108,101,68,97,116,97,83,111,117,114,99,101,115,32,102,97,108,115,101,10,0,0,0,32,32,47,68,97,116,97,83,111,117,114,99,101,32,99,117,114,114,101,110,116,102,105,108,101,32,47,65,83,67,73,73,56,53,68,101,99,111,100,101,32,102,105,108,116,101,114,10,0,0,0,0,0,0,0,0,103,114,101,101,110,39,119,32,108,32,108,116,32,50,32,108,99,32,114,103,98,32,39,103,114,101,101,110,39,0,0,0,32,32,47,68,97,116,97,83,111,117,114,99,101,32,123,99,117,114,114,101,110,116,102,105,108,101,32,105,109,97,103,101,98,117,102,32,114,101,97,100,104,101,120,115,116,114,105,110,103,32,112,111,112,125,10,0,112,118,101,114,116,0,0,0,32,32,47,68,101,99,111,100,101,32,91,32,48,32,37,100,32,93,10,0,0,0,0,0,32,32,47,66,105,116,115,80,101,114,67,111,109,112,111,110,101,110,116,32,37,100,10,32,32,47,73,109,97,103,101,77,97,116,114,105,120,32,91,32,37,100,32,48,32,48,32,37,100,32,48,32,48,32,93,10,0,0,0,0,0,0,0,0,32,61,9,10,0,0,0,0,60,60,10,32,32,47,73,109,97,103,101,84,121,112,101,32,49,10,32,32,47,87,105,100,116,104,32,37,100,10,32,32,47,72,101,105,103,104,116,32,37,100,10,0,0,0,0,0,115,116,0,0,0,0,0,0,37,37,37,37,69,110,100,80,97,108,101,116,116,101,10,0,117,110,107,110,111,119,110,32,116,121,112,101,32,105,110,32,114,101,97,108,40,41,0,0,10,32,32,62,10,93,32,115,101,116,99,111,108,111,114,115,112,97,99,101,10,0,0,0,114,105,103,104,116,32,106,117,115,116,105,102,105,101,100,0,68,97,116,97,84,121,112,101,0,0,0,0,0,0,0,0,109,121,116,36,105,99,115,0,32,37,50,46,50,120,37,50,46,50,120,37,50,46,50,120,0,0,0,0,0,0,0,0,9,66,117,116,116,111,110,32,50,32,100,114,97,119,115,32,116,101,109,112,111,114,97,114,121,32,108,97,98,101,108,115,10,0,0,0,0,0,0,0,114,36,97,100,105,117,115,0,117,110,0,0,0,0,0,0,91,32,47,73,110,100,101,120,101,100,10,32,32,47,68,101,118,105,99,101,82,71,66,32,37,100,10,32,32,60,0,0,32,37,45,49,50,115,32,32,32,37,115,10,0,0,0,0,37,37,37,37,66,101,103,105,110,80,97,108,101,116,116,101,10,0,0,0,0,0,0,0,37,100,32,37,100,32,115,99,97,108,101,10,0,0,0,0,114,101,100,39,119,32,108,32,108,116,32,49,32,108,99,32,114,103,98,32,39,114,101,100,39,0,0,0,0,0,0,0,37,100,32,37,100,32,116,114,97,110,115,108,97,116,101,10,0,0,0,0,0,0,0,0,103,115,97,118,101,10,0,0,125,32,123,10,0,0,0,0,67,111,117,108,100,32,110,111,116,32,114,101,110,97,109,101,32,102,105,108,101,32,37,115,32,116,111,32,37,115,0,0,32,32,52,48,32,45,49,49,48,32,82,10,32,32,40,80,83,32,108,101,118,101,108,32,50,32,105,109,97,103,101,41,32,76,115,104,111,119,10,32,32,37,37,32,82,101,97,100,32,100,97,116,97,32,98,117,116,32,105,103,110,111,114,101,32,105,116,10,32,32,47,105,109,97,103,101,98,117,102,32,37,100,32,115,116,114,105,110,103,32,100,101,102,10,32,32,99,117,114,114,101,110,116,102,105,108,101,32,105,109,97,103,101,98,117,102,32,114,101,97,100,115,116,114,105,110,103,10,0,0,0,0,0,0,0,0,125,32,105,102,101,108,115,101,10,0,0,0,0,0,0,0,105,115,111,32,99,117,114,118,101,0,0,0,0,0,0,0,118,97,108,117,101,0,0,0,100,117,112,32,109,117,108,0,99,101,110,116,114,101,43,100,32,116,101,120,116,0,0,0,32,32,99,117,114,114,101,110,116,102,105,108,101,32,105,109,97,103,101,98,117,102,32,114,101,97,100,115,116,114,105,110,103,10,125,32,123,10,0,0,110,111,109,120,50,116,36,105,99,115,0,0,0,0,0,0,10,9,32,32,70,105,108,101,32,84,121,112,101,58,32,0,32,32,47,105,109,97,103,101,98,117,102,32,37,100,32,115,116,114,105,110,103,32,100,101,102,10,0,0,0,0,0,0,9,66,117,116,116,111,110,32,50,32,100,114,97,119,115,32,112,101,114,115,105,115,116,101,110,116,32,108,97,98,101,108,115,32,119,105,116,104,32,111,112,116,105,111,110,115,32,34,37,115,34,10,0,0,0,0,115,116,121,108,101,32,110,111,116,32,117,115,97,98,108,101,32,102,111,114,32,102,117,110,99,116,105,111,110,32,112,108,111,116,115,44,32,108,101,102,116,32,117,110,99,104,97,110,103,101,100,0,0,0,0,0,37,115,115,101,116,32,99,108,105,112,32,112,111,105,110,116,115,10,37,115,115,101,116,32,99,108,105,112,32,111,110,101,10,37,115,115,101,116,32,99,108,105,112,32,116,119,111,10,115,101,116,32,98,97,114,32,37,102,32,37,115,10,0,0,32,32,52,48,32,45,49,49,48,32,82,10,32,32,40,80,83,32,108,101,118,101,108,32,50,32,105,109,97,103,101,41,32,76,115,104,111,119,10,32,32,37,32,82,101,97,100,32,100,97,116,97,32,98,117,116,32,105,103,110,111,114,101,32,105,116,10,0,0,0,0,0,101,120,112,97,110,100,105,110,103,32,99,117,114,118,101,32,112,111,105,110,116,115,0,0,122,111,111,109,32,111,117,116,32,111,110,108,121,32,116,104,101,32,88,32,97,120,105,115,46,0,0,0,0,0,0,0,32,32,37,100,32,37,100,32,76,10,0,0,0,0,0,0,32,32,48,32,37,100,32,86,10,0,0,0,0,0,0,0,39,45,39,116,105,116,39,0,32,32,37,100,32,48,32,86,10,0,0,0,0,0,0,0,32,32,37,100,32,37,100,32,77,10,0,0,0,0,0,0,45,45,118,101,114,115,105,111,110,0,0,0,0,0,0,0,73,110,116,101,114,112,114,101,116,76,101,118,101,108,49,32,123,10,32,32,37,37,32,67,111,110,115,116,114,117,99,116,32,97,32,98,111,120,32,105,110,115,116,101,97,100,32,111,102,32,105,109,97,103,101,10,32,32,76,84,98,10,0,0,46,111,108,100,0,0,0,0,103,115,97,118,101,32,37,100,32,37,100,32,78,32,37,100,32,37,100,32,76,32,37,100,32,37,100,32,76,32,37,100,32,37,100,32,76,32,90,32,99,108,105,112,10,0,0,0,37,37,37,37,66,101,103,105,110,73,109,97,103,101,10,0,101,120,105,115,116,115,0,0,108,101,102,116,32,106,117,115,116,105,102,105,101,100,0,0,71,78,85,80,76,79,84,32,40,112,111,115,116,46,116,114,109,41,58,32,32,67,111,109,112,111,110,101,110,116,32,98,105,116,115,32,40,37,100,41,32,111,117,116,32,111,102,32,114,97,110,103,101,46,10,0,109,120,50,116,36,105,99,115,0,0,0,0,0,0,0,0,9,68,101,102,97,117,108,116,32,98,105,110,97,114,121,32,100,97,116,97,32,102,105,108,101,32,115,101,116,116,105,110,103,115,32,40,105,110,45,102,105,108,101,32,115,101,116,116,105,110,103,115,32,109,97,121,32,111,118,101,114,114,105,100,101,41,58,10,0,0,0,0,47,37,115,32,37,115,0,0,9,97,108,116,101,114,110,97,116,105,118,101,32,102,111,114,109,97,116,32,102,111,114,32,66,117,116,116,111,110,32,50,32,105,115,32,39,37,115,39,10,0,0,0,0,0,0,0,99,97,110,110,111,116,32,111,112,101,110,32,116,97,98,108,101,32,111,117,116,112,117,116,32,102,105,108,101,0,0,0,35,32,115,101,116,32,116,101,114,109,105,110,97,108,32,117,110,107,110,111,119,110,10,0,114,101,101,110,99,111,100,101,75,79,73,56,85,32,100,101,102,10,0,0,0,0,0,0,60,115,104,105,102,116,45,99,111,110,116,114,111,108,45,119,104,101,101,108,45,100,111,119,110,62,0,0,0,0,0,0,114,101,101,110,99,111,100,101,67,80,49,50,53,49,32,100,101,102,10,0,0,0,0,0,114,101,101,110,99,111,100,101,67,80,49,50,53,48,32,100,101,102,10,0,0,0,0,0,114,101,101,110,99,111,100,101,75,79,73,56,82,32,100,101,102,10,0,0,0,0,0,0,99,111,110,115,116,97,110,116,32,101,120,112,114,101,115,115,105,111,110,32,114,101,113,117,105,114,101,100,0,0,0,0,114,101,101,110,99,111,100,101,67,80,56,53,50,32,100,101,102,10,0,0,0,0,0,0,114,101,101,110,99,111,100,101,67,80,56,53,48,32,100,101,102,10,0,0,0,0,0,0,70,73,84,95,76,73,77,73,84,0,0,0,0,0,0,0,114,101,101,110,99,111,100,101,67,80,52,51,55,32,100,101,102,10,0,0,0,0,0,0,118,101,99,0,0,0,0,0,114,101,101,110,99,111,100,101,73,83,79,49,53,32,100,101,102,10,0,0,0,0,0,0,101,120,105,115,116,0,0,0])
.concat([115,101,116,32,116,101,114,109,111,112,116,32,110,111,101,110,104,0,0,0,0,0,0,0,114,101,101,110,99,111,100,101,73,83,79,57,32,100,101,102,10,0,0,0,0,0,0,0,110,111,109,120,116,36,105,99,115,0,0,0,0,0,0,0,100,97,116,97,102,105,108,101,32,99,111,108,117,109,110,115,32,98,105,110,97,114,121,32,105,110,102,111,114,109,97,116,105,111,110,0,0,0,0,0,114,101,101,110,99,111,100,101,73,83,79,50,32,100,101,102,10,0,0,0,0,0,0,0,9,102,111,114,109,97,116,32,102,111,114,32,66,117,116,116,111,110,32,50,32,105,115,32,37,100,10,0,0,0,0,0,35,32,115,101,116,32,116,101,114,109,105,110,97,108,32,37,115,32,37,115,10,0,0,0,114,101,101,110,99,111,100,101,73,83,79,32,100,101,102,10,0,0,0,0,0,0,0,0,122,111,111,109,32,105,110,32,111,110,108,121,32,116,104,101,32,88,32,97,120,105,115,46,0,0,0,0,0,0,0,0,80,111,115,116,83,99,114,105,112,116,32,70,111,110,116,32,114,101,99,111,114,100,0,0,123,125,91,93,40,41,32,0,99,97,110,110,111,116,32,119,114,105,116,101,32,116,101,109,112,111,114,97,114,121,32,102,105,108,101,0,0,0,0,0,83,121,109,98,111,108,45,79,98,108,105,113,117,101,0,0,37,115,40,0,0,0,0,0,71,78,85,80,76,79,84,95,70,79,78,84,80,65,84,72,0,0,0,0,0,0,0,0,91,40,37,115,41,32,37,46,49,102,32,37,46,49,102,32,37,115,32,37,115,32,37,100,32,0,0,0,0,0,0,0,70,73,84,95,77,65,88,73,84,69,82,0,0,0,0,0,70,111,114,109,97,116,32,99,104,97,114,97,99,116,101,114,32,109,105,115,109,97,116,99,104,58,32,37,37,83,32,105,115,32,111,110,108,121,32,118,97,108,105,100,32,119,105,116,104,32,37,37,115,0,0,0,69,78,72,80,83,95,111,112,101,110,115,101,113,117,101,110,99,101,0,0,0,0,0,0,71,78,85,84,69,82,77,0,97,109,0,0,0,0,0,0,88,89,114,101,115,116,111,114,101,10,0,0,0,0,0,0,115,121,115,116,101,109,0,0,69,110,104,97,110,99,101,100,32,116,101,120,116,58,32,32,32,123,120,64,95,123,48,125,94,123,110,43,49,125,125,0,88,89,115,97,118,101,10,0,109,120,116,36,105,99,115,0,99,111,108,32,62,32,48,0,41,93,10,0,0,0,0,0,9,97,108,116,101,114,110,97,116,105,118,101,32,102,111,114,109,97,116,32,102,111,114,32,66,117,116,116,111,110,32,49,32,105,115,32,39,37,115,39,10,0,0,0,0,0,0,0,79,112,116,105,111,110,115,32,97,114,101,32,39,37,115,39,10,0,0,0,0,0,0,0,37,115,37,103,44,32,37,115,37,103,44,32,37,115,37,103,0,0,0,0,0,0,0,0,117,110,105,37,48,52,108,88,0,0,0,0,0,0,0,0,60,115,104,105,102,116,45,99,111,110,116,114,111,108,45,119,104,101,101,108,45,117,112,62,0,0,0,0,0,0,0,0,117,37,108,88,0,0,0,0,37,115,47,0,0,0,0,0,99,111,109,98,105,110,97,116,105,111,110,32,114,103,98,32,111,114,32,103,98,114,32,111,114,32,98,114,103,32,101,116,99,46,32,101,120,112,101,99,116,101,100,0,0,0,0,0,37,37,32,69,110,100,32,112,108,111,116,32,35,37,100,10,0,0,0,0,0,0,0,0,99,112,49,50,53,52,0,0,105,110,116,101,114,112,111,108,97,116,105,111,110,32,116,97,98,108,101,0,0,0,0,0,32,100,101,108,116,97,95,120,32,100,101,108,116,97,95,121,0,0,0,0,0,0,0,0,37,37,32,66,101,103,105,110,32,112,108,111,116,32,35,37,100,10,0,0,0,0,0,0,98,110,111,116,0,0,0,0,115,116,114,111,107,101,10,0,70,73,84,95,83,84,65,82,84,95,76,65,77,66,68,65,0,0,0,0,0,0,0,0,94,80,89,94,45,10,94,73,79,76,10,94,73,83,89,78,84,65,88,48,48,48,48,48,94,70,94,73,66,49,49,48,48,48,94,73,74,48,48,48,48,48,94,73,84,48,48,48,48,48,10,0,0,0,0,0,94,80,78,94,45,10,0,0,116,101,115,116,32,111,102,32,99,104,97,114,97,99,116,101,114,32,119,105,100,116,104,58,0,0,0,0,0,0,0,0,94,73,71,69,10,94,45,94,44,0,0,0,0,0,0,0,109,117,108,116,105,36,112,108,111,116,0,0,0,0,0,0,69,114,114,111,114,32,97,115,115,105,103,110,105,110,103,32,109,101,109,111,114,121,32,102,111,114,32,98,105,110,97,114,121,32,102,105,108,101,32,100,97,116,97,32,114,101,99,111,114,100,115,0,0,0,0,0,63,0,0,0,0,0,0,0,94,73,71,86,10,0,0,0,9,102,111,114,109,97,116,32,102,111,114,32,66,117,116,116,111,110,32,49,32,105,115,32,37,100,10,0,0,0,0,0,112,111,112,0,0,0,0,0,98,97,100,32,100,97,116,97,32,111,110,32,108,105,110,101,32,37,100,32,111,102,32,102,105,108,101,32,37,115,0,0,32,111,102,102,115,101,116,32,0,0,0,0,0,0,0,0,94,85,37,48,53,100,58,37,48,53,100,10,0,0,0,0,32,122,111,111,109,32,111,117,116,46,0,0,0,0,0,0,94,68,37,48,53,100,58,37,48,53,100,10,0,0,0,0,73,108,108,101,103,97,108,32,115,101,101,100,32,118,97,108,117,101,0,0,0,0,0,0,94,86,48,10,0,0,0,0,94,80,86,51,48,50,49,48,48,94,71,10,94,86,51,10,0,0,0,0,0,0,0,0,94,80,86,50,48,50,48,53,48,94,71,10,94,86,50,10,0,0,0,0,0,0,0,0,94,80,86,49,48,50,48,50,53,94,71,10,94,86,49,10,0,0,0,0,0,0,0,0,70,73,84,95,76,65,77,66,68,65,95,70,65,67,84,79,82,0,0,0,0,0,0,0,99,111,109,112,105,108,101,95,111,112,116,105,111,110,115,0,94,80,87,37,48,50,100,10,0,0,0,0,0,0,0,0,101,120,116,101,110,100,32,105,110,112,117,116,32,108,105,110,101,0,0,0,0,0,0,0,10,94,73,71,86,10,0,0,115,116,114,112,116,105,109,101,0,0,0,0,0,0,0,0,49,50,51,52,53,54,55,56,57,48,49,50,51,52,53,54,55,56,57,48,0,0,0,0,94,73,71,69,10,0,0,0,109,111,36,117,115,101,0,0,98,105,110,97,114,121,32,102,105,108,101,32,100,97,116,97,32,114,101,99,111,114,100,115,0,0,0,0,0,0,0,0,65,114,105,97,108,0,0,0,9,102,111,114,109,97,116,116,105,110,103,32,110,117,109,98,101,114,115,32,119,105,116,104,32,34,37,115,34,10,0,0,110,111,102,112,101,95,116,114,97,112,0,0,0,0,0,0,106,112,103,0,0,0,0,0,112,117,115,104,0,0,0,0,99,104,97,114,97,99,116,101,114,32,0,0,0,0,0,0,60,116,115,112,97,110,32,102,111,110,116,45,115,105,122,101,61,34,37,46,49,102,112,116,34,32,100,121,61,34,37,46,50,102,112,116,34,62,60,47,116,115,112,97,110,62,0,0,60,99,111,110,116,114,111,108,45,119,104,101,101,108,45,100,111,119,110,62,0,0,0,0,37,99,0,0,0,0,0,0,99,111,110,116,111,117,114,32,99,110,116,114,95,115,116,114,117,99,116,0,0,0,0,0,98,97,99,107,103,114,111,117,110,100,32,34,35,37,48,54,120,34,32,0,0,0,0,0,99,111,110,118,101,114,116,32,98,97,99,107,32,34,37,115,34,32,45,32,37,100,47,37,100,47,37,100,58,58,37,100,58,37,100,58,37,100,32,44,32,119,100,97,121,61,37,100,44,32,121,100,97,121,61,37,100,10,0,0,0,0,0,0,32,93,32,37,115,114,101,118,101,114,115,101,32,37,115,119,114,105,116,101,98,97,99,107,0,0,0,0,0,0,0,0,108,105,110,101,119,105,100,116,104,32,37,51,46,49,102,32,0,0,0,0,0,0,0,0,34,116,105,116,108,101,34,32,97,108,108,111,119,101,100,32,111,110,108,121,32,97,102,116,101,114,32,112,97,114,97,109,101,116,114,105,99,32,102,117,110,99,116,105,111,110,32,102,117,108,108,121,32,115,112,101,99,105,102,105,101,100,0,0,115,111,108,105,100,32,0,0,105,115,111,32,99,117,114,118,101,32,112,111,105,110,116,115,0,0,0,0,0,0,0,0,100,97,115,104,101,100,32,0,70,73,84,95,83,67,82,73,80,84,0,0,0,0,0,0,98,117,116,116,32,0,0,0,102,111,114,0,0,0,0,0,109,97,116,114,105,120,32,114,111,119,32,112,111,105,110,116,101,114,115,0,0,0,0,0,102,111,110,116,102,105,108,101,32,34,37,115,34,32,0,0,115,116,114,102,116,105,109,101,0,0,0,0,0,0,0,0,98,101,122,105,101,114,32,99,111,101,102,102,105,99,105,101,110,116,115,0,0,0,0,0,77,111,117,115,101,32,97,110,100,32,104,111,116,107,101,121,115,32,97,114,101,32,115,117,112,112,111,114,116,101,100,44,32,104,105,116,58,32,104,32,114,32,109,32,54,0,0,0,110,97,109,101,32,34,37,115,34,32,0,0,0,0,0,0,98,109,97,114,36,103,105,110,0,0,0,0,0,0,0,0,69,113,117,97,108,32,40,39,61,39,41,32,115,121,109,98,111,108,32,114,101,113,117,105,114,101,100,0,0,0,0,0,97,108,116,45,0,0,0,0,115,116,97,110,100,97,108,111,110,101,32,0,0,0,0,0,9,100,111,117,98,108,101,32,99,108,105,99,107,32,114,101,115,111,108,117,116,105,111,110,32,105,115,32,111,102,102,10,0,0,0,0,0,0,0,0,89,111,117,32,99,97,110,39,116,32,99,104,97,110,103,101,32,116,104,101,32,116,101,114,109,105,110,97,108,32,105,110,32,109,117,108,116,105,112,108,111,116,32,109,111,100,101,0,123,32,121,48,32,103,32,0,115,99,114,101,101,110,32,0,109,111,117,115,105,110,103,32,0,0,0,0,0,0,0,0,108,111,97,100,0,0,0,0,67,97,110,39,116,32,99,97,108,99,117,108,97,116,101,32,97,112,112,114,111,120,105,109,97,116,105,111,110,32,115,112,108,105,110,101,115,0,0,0,101,110,104,97,110,99,101,100,0,0,0,0,0,0,0,0,122,111,111,109,32,105,110,32,116,111,119,97,114,100,32,116,104,101,32,99,101,110,116,101,114,32,111,102,32,116,104,101,32,112,108,111,116,46,0,0,112,109,51,100,32,112,97,108,101,116,116,101,32,99,111,108,111,114,0,0,0,0,0,0,102,97,99,116,111,114,105,97,108,32,40,33,41,32,97,114,103,117,109,101,110,116,32,109,117,115,116,32,98,101,32,97,110,32,105,110,116,101,103,101,114,0,0,0,0,0,0,0,32,100,121,110,97,109,105,99,0,0,0,0,0,0,0,0,105,110,116,101,114,110,97,108,32,61,32,37,102,32,45,32,37,100,47,37,100,47,37,100,58,58,37,100,58,37,100,58,37,100,32,44,32,119,100,97,121,61,37,100,44,32,121,100,97,121,61,37,100,10,0,0,32,102,105,120,101,100,0,0,115,105,122,101,32,37,100,44,37,100,37,115,32,37,115,32,102,110,97,109,101,32,39,37,115,39,32,32,102,115,105,122,101,32,37,103,32,0,0,0,117,110,114,101,99,111,103,110,105,122,101,100,32,116,101,114,109,105,110,97,108,32,111,112,116,105,111,110,0,0,0,0,98,97,99,107,103,36,114,111,117,110,100,0,0,0,0,0,100,97,115,104,36,101,100,0,32,32,116,101,114,109,105,110,97,108,32,116,101,115,116,0,114,111,117,110,100,36,101,100,0,0,0,0,0,0,0,0,116,109,97,114,36,103,105,110,0,0,0,0,0,0,0,0,111,112,116,105,111,110,32,101,120,112,101,99,116,101,100,0,70,111,110,116,32,102,105,108,101,110,97,109,101,32,101,120,112,101,99,116,101,100,0,0,9,100,111,117,98,108,101,32,99,108,105,99,107,32,114,101,115,111,108,117,116,105,111,110,32,105,115,32,37,100,32,109,115,10,0,0,0,0,0,0,84,104,105,115,32,111,112,116,105,111,110,32,99,97,110,110,111,116,32,98,101,32,99,104,97,110,103,101,100,32,117,115,105,110,103,32,39,115,101,116,32,116,101,114,109,111,112,116,105,111,110,39,0,0,0,0,115,101,99,111,110,100,32,0,102,111,110,116,102,105,108,101,0,0,0,0,0,0,0,0,60,99,111,110,116,114,111,108,45,119,104,101,101,108,45,117,112,62,0,0,0,0,0,0,102,115,105,122,101,58,32,101,120,112,101,99,116,105,110,103,32,102,111,110,116,32,115,105,122,101,0,0,0,0,0,0,102,115,36,105,122,101,0,0,115,109,111,111,116,104,32,112,97,108,101,116,116,101,32,105,110,32,37,115,58,32,117,115,105,110,103,32,37,105,32,111,102,32,37,105,32,97,118,97,105,108,97,98,108,101,32,99,111,108,111,114,32,112,111,115,105,116,105,111,110,115,10,0,37,115,32,114,97,110,103,101,32,109,117,115,116,32,98,101,32,103,114,101,97,116,101,114,32,116,104,97,110,32,48,32,102,111,114,32,108,111,103,32,115,99,97,108,101,0,0,0,102,110,36,97,109,101,0,0,102,105,36,120,101,100,0,0,86,97,108,117,101,32,115,116,111,114,101,100,32,102,111,114,32,117,110,100,101,102,105,110,101,100,32,100,97,116,97,112,111,105,110,116,32,104,97,110,100,108,105,110,103,32,105,115,32,105,108,108,101,103,97,108,33,33,33,10,0,0,0,0,100,36,121,110,97,109,105,99,0,0,0,0,0,0,0,0,110,97,109,101,32,109,117,115,116,32,99,111,110,116,97,105,110,32,111,110,108,121,32,97,108,112,104,97,110,117,109,101,114,105,99,115,32,111,114,32,95,0,0,0,0,0,0,0,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,95,49,50,51,52,53,54,55,56,57,48,0,119,111,114,100,0,0,0,0,116,101,114,109,105,110,97,108,32,116,121,112,101,32,105,115,32,117,110,107,110,111,119,110,0,0,0,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,97,32,112,108,111,116,32,110,97,109,101,0,0,0,114,109,97,114,36,103,105,110,0,0,0,0,0,0,0,0,110,97,109,101,0,0,0,0,9,110,111,32,112,111,108,97,114,32,100,105,115,116,97,110,99,101,32,116,111,32,114,117,108,101,114,32,119,105,108,108,32,98,101,32,115,104,111,119,110,10,0,0,0,0,0,0,100,101,108,97,121,0,0,0,102,105,114,115,116,32,0,0,109,111,117,115,36,105,110,103,0,0,0,0,0,0,0,0,115,99,114,111,108,108,32,114,105,103,104,116,46,0,0,0,109,111,117,115,101,0,0,0,121,32,115,105,122,101,32,111,117,116,32,111,102,32,114,97,110,103,101,0,0,0,0,0,101,120,116,101,110,100,32,105,110,32,100,111,95,115,121,115,116,101,109,95,102,117,110,99,0,0,0,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,121,32,115,105,122,101,0,0,0,0,0,0,0,0,112,111,108,121,103,111,110,0,120,32,115,105,122,101,32,111,117,116,32,111,102,32,114,97,110,103,101,0,0,0,0,0,101,120,112,101,99,116,105,110,103,32,120,32,115,105,122,101,0,0,0,0,0,0,0,0,115,36,105,122,101,0,0,0,67,97,110,110,111,116,32,109,105,120,32,115,99,114,101,101,110,32,111,114,32,99,104,97,114,97,99,116,101,114,32,99,111,111,114,100,115,32,119,105,116,104,32,112,108,111,116,32,99,111,111,114,100,115,0,0,70,111,110,116,32,102,105,108,101,32,39,37,115,39,32,105,115,32,101,109,112,116,121,0,115,117,98,115,116,114,0,0,115,101,116,32,116,101,114,109,111,112,116,32,101,110,104,0,67,111,109,109,97,110,100,32,39,37,115,39,32,103,101,110,101,114,97,116,101,115,32,101,109,112,116,121,32,111,117,116,112,117,116,0,0,0,0,0,67,111,109,109,97,110,100,32,39,37,115,39,32,103,101,110,101,114,97,116,101,100,32,101,114,114,111,114,32,101,120,105,116,99,111,100,101,32,37,100,0,0,0,0,0,0,0,0,108,109,97,114,36,103,105,110,0,0,0,0,0,0,0,0,68,105,109,95,50,0,0,0,9,100,105,115,116,97,110,99,101,32,116,111,32,114,117,108,101,114,32,119,105,108,108,32,98,101,32,115,104,111,119,32,105,110,32,112,111,108,97,114,32,99,111,111,114,100,105,110,97,116,101,115,10,0,0,0,103,105,102,0,0,0,0,0,111,98,106,101,99,116,32,110,111,116,32,102,111,117,110,100,0,0,0,0,0,0,0,0,70,111,110,116,32,102,105,108,101,32,39,37,115,39,32,99,111,110,116,97,105,110,115,32,116,104,101,32,102,111,110,116,32,39,37,115,39,10,0,0,60,115,104,105,102,116,45,119,104,101,101,108,45,100,111,119,110,62,0,0,0,0,0,0,102,111,110,116,45,102,97,109,105,108,121,0,0,0,0,0,70,111,110,116,32,102,105,108,101,32,39,37,115,39,32,110,111,116,32,102,111,117,110,100,0,0,0,0,0,0,0,0,42,118,101,114,121,42,32,108,111,110,103,32,115,121,115,116,101,109,32,99,97,108,108,32,111,117,116,112,117,116,32,104,97,115,32,98,101,101,110,32,116,114,117,110,99,97,116,101,100,0,0,0,0,0,0,0,67,111,117,108,100,32,110,111,116,32,101,120,101,99,117,116,101,32,112,105,112,101,32,39,37,115,39,0,0,0,0,0,10,9,60,99,105,114,99,108,101,32,105,100,61,39,103,112,68,111,116,39,32,114,61,39,48,46,53,39,32,115,116,114,111,107,101,45,119,105,100,116,104,61,39,48,46,53,39,47,62,10,9,60,112,97,116,104,32,105,100,61,39,103,112,80,116,48,39,32,115,116,114,111,107,101,45,119,105,100,116,104,61,39,37,46,51,102,39,32,115,116,114,111,107,101,61,39,99,117,114,114,101,110,116,67,111,108,111,114,39,32,100,61,39,77,45,49,44,48,32,104,50,32,77,48,44,45,49,32,118,50,39,47,62,10,9,60,112,97,116,104,32,105,100,61,39,103,112,80,116,49,39,32,115,116,114,111,107,101,45,119,105,100,116,104,61,39,37,46,51,102,39,32,115,116,114,111,107,101,61,39,99,117,114,114,101,110,116,67,111,108,111,114,39,32,100,61,39,77,45,49,44,45,49,32,76,49,44,49,32,77,49,44,45,49,32,76,45,49,44,49,39,47,62,10,9,60,112,97,116,104,32,105,100,61,39,103,112,80,116,50,39,32,115,116,114,111,107,101,45,119,105,100,116,104,61,39,37,46,51,102,39,32,115,116,114,111,107,101,61,39,99,117,114,114,101,110,116,67,111,108,111,114,39,32,100,61,39,77,45,49,44,48,32,76,49,44,48,32,77,48,44,45,49,32,76,48,44,49,32,77,45,49,44,45,49,32,76,49,44,49,32,77,45,49,44,49,32,76,49,44,45,49,39,47,62,10,9,60,114,101,99,116,32,105,100,61,39,103,112,80,116,51,39,32,115,116,114,111,107,101,45,119,105,100,116,104,61,39,37,46,51,102,39,32,115,116,114,111,107,101,61,39,99,117,114,114,101,110,116,67,111,108,111,114,39,32,120,61,39,45,49,39,32,121,61,39,45,49,39,32,119,105,100,116,104,61,39,50,39,32,104,101,105,103,104,116,61,39,50,39,47,62,10,9,60,114,101,99,116,32,105,100,61,39,103,112,80,116,52,39,32,115,116,114,111,107,101,45,119,105,100,116,104,61,39,37,46,51,102,39,32,115,116,114,111,107,101,61,39,99,117,114,114,101,110,116,67,111,108,111,114,39,32,102,105,108,108,61,39,99,117,114,114,101,110,116,67,111,108,111,114,39,32,120,61,39,45,49,39,32,121,61,39,45,49,39,32,119,105,100,116,104,61,39,50,39,32,104,101,105,103,104,116,61,39,50,39,47,62,10,9,60,99,105,114,99,108,101,32,105,100,61,39,103,112,80,116,53,39,32,115,116,114,111,107,101,45,119,105,100,116,104,61,39,37,46,51,102,39,32,115,116,114,111,107,101,61,39,99,117,114,114,101,110,116,67,111,108,111,114,39,32,99,120,61,39,48,39,32,99,121,61,39,48,39,32,114,61,39,49,39,47,62,10,9,60,117,115,101,32,120,108,105,110,107,58,104,114,101,102,61,39,35,103,112,80,116,53,39,32,105,100,61,39,103,112,80,116,54,39,32,102,105,108,108,61,39,99,117,114,114,101,110,116,67,111,108,111,114,39,32,115,116,114,111,107,101,61,39,110,111,110,101,39,47,62,10,9,60,112,97,116,104,32,105,100,61,39,103,112,80,116,55,39,32,115,116,114,111,107,101,45,119,105,100,116,104,61,39,37,46,51,102,39,32,115,116,114,111,107,101,61,39,99,117,114,114,101,110,116,67,111,108,111,114,39,32,100,61,39,77,48,44,45,49,46,51,51,32,76,45,49,46,51,51,44,48,46,54,55,32,76,49,46,51,51,44,48,46,54,55,32,122,39,47,62,10,9,60,117,115,101,32,120,108,105,110,107,58,104,114,101,102,61,39,35,103,112,80,116,55,39,32,105,100,61,39,103,112,80,116,56,39,32,102,105,108,108,61,39,99,117,114,114,101,110,116,67,111,108,111,114,39,32,115,116,114,111,107,101,61,39,110,111,110,101,39,47,62,10,9,60,117,115,101,32,120,108,105,110,107,58,104,114,101,102,61,39,35,103,112,80,116,55,39,32,105,100,61,39,103,112,80,116,57,39,32,115,116,114,111,107,101,61,39,99,117,114,114,101,110,116,67,111,108,111,114,39,32,116,114,97,110,115,102,111,114,109,61,39,114,111,116,97,116,101,40,49,56,48,41,39,47,62,10,9,60,117,115,101,32,120,108,105,110,107,58,104,114,101,102,61,39,35,103,112,80,116,57,39,32,105,100,61,39,103,112,80,116,49,48,39,32,102,105,108,108,61,39,99,117,114,114,101,110,116,67,111,108,111,114,39,32,115,116,114,111,107,101,61,39,110,111,110,101,39,47,62,10,9,60,117,115,101,32,120,108,105,110,107,58,104,114,101,102,61,39,35,103,112,80,116,51,39,32,105,100,61,39,103,112,80,116,49,49,39,32,115,116,114,111,107,101,61,39,99,117,114,114,101,110,116,67,111,108,111,114,39,32,116,114,97,110,115,102,111,114,109,61,39,114,111,116,97,116,101,40,52,53,41,39,47,62,10,9,60,117,115,101,32,120,108,105,110,107,58,104,114,101,102,61,39,35,103,112,80,116,49,49,39,32,105,100,61,39,103,112,80,116,49,50,39,32,102,105,108,108,61,39,99,117,114,114,101,110,116,67,111,108,111,114,39,32,115,116,114,111,107,101,61,39,110,111,110,101,39,47,62,10,60,47,100,101,102,115,62,10,0,60,100,101,102,115,62,10,0,9,37,115,32,114,97,110,103,101,32,114,101,115,116,114,105,99,116,101,100,32,116,111,32,91,0,0,0,0,0,0,0,47,62,10,0,0,0,0,0,32,102,105,108,108,61,34,35,37,48,54,120,34,0,0,0,115,116,114,115,116,114,116,0,85,110,107,110,111,119,110,32,111,114,32,97,109,98,105,103,117,111,117,115,32,116,101,114,109,105,110,97,108,32,110,97,109,101,32,39,37,115,39,10,0,0,0,0,0,0,0,0,60,103,32,105,100,61,34,103,110,117,112,108,111,116,95,99,97,110,118,97,115,34,62,10,10,0,0,0,0,0,0,0,109,97,114,36,103,105,110,0,60,103,32,105,100,61,34,103,110,117,112,108,111,116,95,99,97,110,118,97,115,34,32,111,110,99,108,105,99,107,61,34,103,110,117,112,108,111,116,95,115,118,103,46,116,111,103,103,108,101,67,111,111,114,100,66,111,120,40,101,118,116,41,34,32,111,110,109,111,117,115,101,109,111,118,101,61,34,103,110,117,112,108,111,116,95,115,118,103,46,109,111,118,101,67,111,111,114,100,66,111,120,40,101,118,116,41,34,62,10,10,0,9,110,111,32,122,111,111,109,32,99,111,111,114,100,105,110,97,116,101,115,32,119,105,108,108,32,98,101,32,100,114,97,119,110,10,0,0,0,0,0,10,60,33,45,45,32,65,108,115,111,32,116,114,97,99,107,32,109,111,117,115,101,32,119,104,101,110,32,105,116,32,105,115,32,111,110,32,97,32,112,108,111,116,32,101,108,101,109,101,110,116,32,45,45,62,10,0,0,0,0,0,0,0,0,32,102,105,108,108,115,116,121,108,101,32,0,0,0,0,0,115,99,114,111,108,108,32,108,101,102,116,32,40,105,110,32,45,88,32,100,105,114,101,99,116,105,111,110,41,46,0,0,111,110,99,108,105,99,107,61,34,103,110,117,112,108,111,116,95,115,118,103,46,116,111,103,103,108,101,67,111,111,114,100,66,111,120,40,101,118,116,41,34,32,32,111,110,109,111,117,115,101,109,111,118,101,61,34,103,110,117,112,108,111,116,95,115,118,103,46,109,111,118,101,67,111,111,114,100,66,111,120,40,101,118,116,41,34,47,62,10,0,0,0,0,0,0,0,32,102,105,108,108,61,34,35,37,48,54,120,34,32,115,116,114,111,107,101,61,34,98,108,97,99,107,34,32,115,116,114,111,107,101,45,119,105,100,116,104,61,34,49,34,10,0,0,100,111,95,115,121,115,116,101,109,95,102,117,110,99,0,0,60,114,101,99,116,32,120,61,34,37,100,34,32,121,61,34,37,100,34,32,119,105,100,116,104,61,34,37,100,34,32,104,101,105,103,104,116,61,34,37,100,34,0,0,0,0,0,0,10,60,33,45,45,32,84,105,101,32,109,111,117,115,105,110,103,32,116,111,32,101,110,116,105,114,101,32,98,111,117,110,100,105,110,103,32,98,111,120,32,111,102,32,116,104,101,32,112,108,111,116,32,45,45,62,10,0,0,0,0,0,0,0,60,115,99,114,105,112,116,32,108,97,110,103,117,97,103,101,61,34,106,97,118,97,83,99,114,105,112,116,34,32,84,89,80,69,61,34,116,101,120,116,47,106,97,118,97,115,99,114,105,112,116,34,32,62,32,60,33,91,67,68,65,84,65,91,10,0,0,0,0,0,0,0,35,32,70,73,88,69,68,0,70,97,105,108,101,100,32,116,111,32,105,110,115,101,114,116,32,106,97,118,97,115,99,114,105,112,116,32,102,105,108,101,32,37,115,10,0,0,0,0,115,116,114,108,101,110,0,0,106,97,118,97,115,99,114,105,112,116,32,110,97,109,101,0,109,97,112,36,112,105,110,103,51,100,0,0,0,0,0,0,103,110,117,112,108,111,116,95,115,118,103,46,106,115,0,0,9,122,111,111,109,32,99,111,111,114,100,105,110,97,116,101,115,32,119,105,108,108,32,98,101,32,100,114,97,119,110,10,0,0,0,0,0,0,0,0,60,115,99,114,105,112,116,32,116,121,112,101,61,34,116,101,120,116,47,106,97,118,97,115,99,114,105,112,116,34,32,120,108,105,110,107,58,104,114,101,102,61,34,37,115,103,110,117,112,108,111,116,95,115,118,103,46,106,115,34,47,62,10,0,60,115,104,105,102,116,45,119,104,101,101,108,45,117,112,62,0,0,0,0,0,0,0,0,116,111,111,32,109,97,110,121,32,97,114,103,117,109,101,110,116,115,32,102,111,114,32,39,99,97,108,108,32,60,102,105,108,101,62,39,0,0,0,0,106,115,100,105,114,0,0,0,112,111,112,101,110,32,102,97,105,108,101,100,0,0,0,0,47,117,115,114,47,108,111,99,97,108,47,115,104,97,114,101,47,103,110,117,112,108,111,116,47,52,46,54,47,106,115,0,60,100,101,115,99,62,80,114,111,100,117,99,101,100,32,98,121,32,71,78,85,80,76,79,84,32,37,115,32,112,97,116,99,104,108,101,118,101,108,32,37,115,32,60,47,100,101,115,99,62,10,10,0,0,0,0,71,110,117,112,108,111,116,0,85,110,100,101,102,105,110,101,100,32,118,97,108,117,101,32,100,117,114,105,110,103,32,102,117,110,99,116,105,111,110,32,101,118,97,108,117,97,116,105,111,110,0,0,0,0,0,0,60,116,105,116,108,101,62,37,115,60,47,116,105,116,108,101,62,10,0,0,0,0,0,0,62,10,10,0,0,0,0,0,103,112,114,105,110,116,102,0,84,101,114,109,105,110,97,108,32,116,121,112,101,32,115,101,116,32,116,111,32,39,37,115,39,10,0,0,0,0,0,0,32,120,109,108,110,115,58,120,108,105,110,107,61,34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,49,57,57,57,47,120,108,105,110,107,34,10,0,0,0,0,109,97,112,36,112,105,110,103,0,0,0,0,0,0,0,0,112,108,111,116,32,116,105,116,108,101,0,0,0,0,0,0,32,120,109,108,110,115,61,34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,50,48,48,48,47,115,118,103,34,10,0,0,0,0,9,109,111,117,115,101,32,105,115,32,111,110,10,0,0,0,10,32,118,105,101,119,66,111,120,61,34,48,32,48,32,37,117,32,37,117,34,10,0,0,115,99,114,111,108,108,32,100,111,119,110,46,0,0,0,0,46,46,0,0,0,0,0,0,10,32,119,105,100,116,104,61,34,37,117,34,32,104,101,105,103,104,116,61,34,37,117,34,32,0,0,0,0,0,0,0,111,110,108,111,97,100,61,34,105,102,32,40,116,121,112,101,111,102,40,103,110,117,112,108,111,116,95,115,118,103,41,33,61,39,117,110,100,101,102,105,110,101,100,39,41,32,103,110,117,112,108,111,116,95,115,118,103,46,73,110,105,116,40,101,118,116,41,34,32,0,0,0,37,115,32,105,115,32,110,111,116,32,97,32,115,116,114,105,110,103,32,118,97,114,105,97,98,108,101,0,0,0,0,0,60,63,120,109,108,32,118,101,114,115,105,111,110,61,34,49,46,48,34,32,37,115,32,115,116,97,110,100,97,108,111,110,101,61,34,110,111,34,63,62,10,60,33,68,79,67,84,89,80,69,32,115,118,103,32,80,85,66,76,73,67,32,34,45,47,47,87,51,67,47,47,68,84,68,32,83,86,71,32,49,46,49,47,47,69,78,34,32,10,32,34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,71,114,97,112,104,105,99,115,47,83,86,71,47,49,46,49,47,68,84,68,47,115,118,103,49,49,46,100,116,100,34,62,10,60,115,118,103,32,0,0,0,0,0,101,110,99,111,100,105,110,103,61,34,117,116,102,45,56,34,32,0,0,0,0,0,0,0,102,111,110,116,112,97,116,104,32,61,61,32,78,85,76,76,0,0,0,0,0,0,0,0,101,110,99,111,100,105,110,103,61,34,83,104,105,102,116,95,74,73,83,34,32,0,0,0,37,45,49,53,46,49,53,115,32,61,32,37,103,10,0,0,70,111,114,109,97,116,32,99,104,97,114,97,99,116,101,114,32,109,105,115,109,97,116,99,104,58,32,37,37,84,32,105,115,32,111,110,108,121,32,118,97,108,105,100,32,119,105,116,104,32,37,37,116,0,0,0,101,110,99,111,100,105,110,103,61,34,107,111,105,56,45,117,34,32,0,0,0,0,0,0,68,101,112,114,101,99,97,116,101,100,32,115,121,110,116,97,120,32,45,32,112,108,101,97,115,101,32,117,115,101,32,39,115,101,116,32,116,105,99,115,32,115,99,97,108,101,32,100,101,102,97,117,108,116,39,0,37,89,45,37,109,45,37,100,0,0,0,0,0,0,0,0,101,110,99,111,100,105,110,103,61,34,107,111,105,56,45,114,34,32,0,0,0,0,0,0,87,97,114,110,105,110,103,58,32,115,99,97,108,101,32,105,110,116,101,114,102,97,99,101,32,105,115,32,110,111,116,32,110,117,108,108,95,115,99,97,108,101,32,45,32,109,97,121,32,110,111,116,32,119,111,114,107,32,119,105,116,104,32,109,117,108,116,105,112,108,111,116,10,0,0,0,0,0,0,0,101,110,99,111,100,105,110,103,61,34,119,105,110,100,111,119,115,45,49,50,53,49,34,32,0,0,0,0,0,0,0,0,109,97,99,36,114,111,115,0,116,105,109,101,99,111,108,117,109,110,40,41,32,99,97,108,108,101,100,32,102,114,111,109,32,105,110,118,97,108,105,100,32,99,111,110,116,101,120,116,0,0,0,0,0,0,0,0,101,110,99,111,100,105,110,103,61,34,119,105,110,100,111,119,115,45,49,50,53,48,34,32,0,0,0,0,0,0,0,0,9,108,97,115,116,32,112,108,111,116,32,99,111,109,109,97,110,100,32,119,97,115,58,32,37,115,10,0,0,0,0,0,102,99,32,0,0,0,0,0,101,110,99,111,100,105,110,103,61,34,99,112,57,53,48,34,32,0,0,0,0,0,0,0,60,119,104,101,101,108,45,100,111,119,110,62,0,0,0,0,101,110,99,111,100,105,110,103,61,34,105,98,109,45,56,53,50,34,32,0,0,0,0,0,101,110,99,111,100,105,110,103,61,34,105,98,109,45,56,53,48,34,32,0,0,0,0,0,115,116,114,105,110,103,32,118,97,114,105,97,98,108,101,0,99,112,49,50,53,49,0,0,101,110,99,111,100,105,110,103,61,34,105,115,111,45,56,56,53,57,45,49,53,34,32,0,32,108,97,98,101,108,0,0,101,110,99,111,100,105,110,103,61,34,105,115,111,45,56,56,53,57,45,57,34,32,0,0,108,110,111,116,0,0,0,0,101,110,99,111,100,105,110,103,61,34,105,115,111,45,56,56,53,57,45,50,34,32,0,0,105,110,105,116,105,97,108,32,115,101,116,32,111,102,32,102,114,101,101,0,0,0,0,0,101,110,99,111,100,105,110,103,61,34,105,115,111,45,56,56,53,57,45,49,34,32,0,0,35,37,50,46,50,88,37,50,46,50,88,37,50,46,50,88,0,0,0,0,0,0,0,0,116,109,95,121,100,97,121,0,120,49,49,0,0,0,0,0,60,47,115,118,103,62,10,10,0,0,0,0,0,0,0,0,108,111,103,36,115,99,97,108,101,0,0,0,0,0,0,0,64,67,79,76,85,77,78,72,69,65,68,64,0,0,0,0,32,32,32,32,111,110,99,108,105,99,107,61,39,103,110,117,112,108,111,116,95,115,118,103,46,116,111,103,103,108,101,71,114,105,100,40,41,59,39,47,62,10,0,0,0,0,0,0,61,32,0,0,0,0,0,0,83,116,97,116,115,32,99,111,109,109,97,110,100,32,110,111,116,32,97,118,97,105,108,97,98,108,101,32,105,110,32,112,97,114,97,109,101,116,114,105,99,32,109,111,100,101,0,0,108,119,32,37,46,49,102,32,0,0,0,0,0,0,0,0,10,32,32,60,105,109,97,103,101,32,120,61,39,49,48,39,32,121,61,39,37,100,39,32,119,105,100,116,104,61,39,49,54,39,32,104,101,105,103,104,116,61,39,49,54,39,32,120,108,105,110,107,58,104,114,101,102,61,39,103,114,105,100,46,112,110,103,39,10,0,0,0,115,99,114,111,108,108,32,117,112,32,40,105,110,32,43,89,32,100,105,114,101,99,116,105,111,110,41,46,0,0,0,0,102,111,110,116,112,97,116,104,95,102,117,108,108,110,97,109,101,0,0,0,0,0,0,0,32,32,118,105,115,105,98,105,108,105,116,121,61,34,104,105,100,100,101,110,34,62,32,60,47,116,101,120,116,62,10,0,37,115,32,101,114,114,111,114,10,0,0,0,0,0,0,0,32,32,102,111,110,116,45,115,105,122,101,61,34,49,50,34,32,102,111,110,116,45,102,97,109,105,108,121,61,34,65,114,105,97,108,34,10,0,0,0,115,121,115,116,101,109,40,41,32,102,97,105,108,101,100,0,10,32,32,60,116,101,120,116,32,105,100,61,34,99,111,111,114,100,95,116,101,120,116,34,32,116,101,120,116,45,97,110,99,104,111,114,61,34,115,116,97,114,116,34,32,112,111,105,110,116,101,114,45,101,118,101,110,116,115,61,34,110,111,110,101,34,10,0,0,0,0,0,93,93,62,10,60,47,115,99,114,105,112,116,62,10,0,0,103,110,117,112,108,111,116,95,115,118,103,46,112,108,111,116,95,116,105,109,101,97,120,105,115,95,120,32,61,32,34,34,59,10,0,0,0,0,0,0,114,101,115,117,108,116,97,110,116,0,0,0,0,0,0,0,105,110,118,97,108,105,100,32,111,114,32,100,101,112,114,101,99,97,116,101,100,32,115,121,110,116,97,120,0,0,0,0,68,97,116,101,84,105,109,101,0,0,0,0,0,0,0,0,84,105,109,101,0,0,0,0,116,109,95,119,100,97,121,0,88,49,49,0,0,0,0,0,68,97,116,101,0,0,0,0,108,111,99,36,97,108,101,0,97,110,97,108,121,122,101,95,115,103,108,95,99,111,108,117,109,110,0,0,0,0,0,0,99,111,108,117,109,110,104,101,97,100,40,41,32,99,97,108,108,101,100,32,102,114,111,109,32,105,110,118,97,108,105,100,32,99,111,110,116,101,120,116,0,0,0,0,0,0,0,0,103,110,117,112,108,111,116,95,115,118,103,46,112,108,111,116,95,116,105,109,101,97,120,105,115,95,120,32,61,32,34,37,115,34,59,10,0,0,0,0,9,37,45,42,115,32,0,0,102,112,101,95,116,114,97,112,0,0,0,0,0,0,0,0,102,110,97,109,101,0,0,0,106,112,101,103,0,0,0,0,103,110,117,112,108,111,116,95,115,118,103,46,112,108,111,116,95,97,120,105,115,95,120,109,97,120,32,61,32,37,46,51,102,59,10,0,0,0,0,0,60,119,104,101,101,108,45,117,112,62,0,0,0,0,0,0,114,101,99,117,114,115,105,118,101,102,117,108,108,110,97,109,101,0,0,0,0,0,0,0,103,110,117,112,108,111,116,95,115,118,103,46,112,108,111,116,95,97,120,105,115,95,120,109,105,110,32,61,32,37,46,51,102,59,10,0,0,0,0,0,116,114,97,99,101,95,99,111,110,116,111,117,114,58,32,117,110,101,120,112,101,99,116,101,100,32,101,110,100,32,111,102,32,99,111,110,116,111,117,114,10,0,0,0,0,0,0,0,103,110,117,112,108,111,116,95,115,118,103,46,112,108,111,116,95,108,111,103,97,120,105,115,95,114,32,61,32,37,100,59,10,0,0,0,0,0,0,0,73,109,112,111,115,115,105,98,108,101,32,99,97,115,101,32,105,110,32,115,119,105,116,99,104,0,0,0,0,0,0,0,32,58,32,0,0,0,0,0,103,110,117,112,108,111,116,95,115,118,103,46,112,108,111,116,95,108,111,103,97,120,105,115,95,121,32,61,32,37,100,59,10,0,0,0,0,0,0,0,112,109,51,100,32,115,99,97,110,32,97,114,114,97,121,0,116,36,105,116,108,101,0,0,103,110,117,112,108,111,116,95,115,118,103,46,112,108,111,116,95,108,111,103,97,120,105,115,95,120,32,61,32,37,100,59,10,0,0,0,0,0,0,0,108,97,98,101,108,112,111,105,110,116,32,116,101,120,116,0,103,110,117,112,108,111,116,95,115,118,103,46,112,108,111,116,95,97,120,105,115,95,121,50,109,105,110,32,61,32,34,110,111,110,101,34,10,0,0,0,67,111,117,108,100,32,110,111,116,32,108,105,110,101,98,117,102,102,101,114,32,115,116,100,111,117,116,10,0,0,0,0,10,10,32,73,116,101,114,97,116,105,111,110,32,37,100,10,32,87,83,83,82,32,32,32,32,32,32,32,32,58,32,37,45,49,53,103,32,32,32,100,101,108,116,97,40,87,83,83,82,41,47,87,83,83,82,32,32,32,58,32,37,103,10,32,100,101,108,116,97,40,87,83,83,82,41,32,58,32,37,45,49,53,103,32,32,32,108,105,109,105,116,32,102,111,114,32,115,116,111,112,112,105,110,103,32,58,32,37,103,10,32,108,97,109,98,100,97,9,32,32,58,32,37,103,10,10,37,115,32,112,97,114,97,109,101,116,101,114,32,118,97,108,117,101,115,10,10,0,0,0,0,0,112,108,111,116,95,97,120,105,115,95,121,50,109,97,120,0,69,120,112,101,99,116,105,110,103,32,105,116,101,114,97,116,111,114,32,9,102,111,114,32,91,60,118,97,114,62,32,61,32,60,115,116,97,114,116,62,32,58,32,60,101,110,100,62,93,10,9,9,9,111,114,9,102,111,114,32,91,60,118,97,114,62,32,105,110,32,34,115,116,114,105,110,103,32,111,102,32,119,111,114,100,115,34,93,0,0,0,0,0,0,0,0,71,80,86,65,76,95,89,50,95,77,65,88,0,0,0,0,116,109,95,121,101,97,114,0,117,110,107,110,111,119,110,32,111,114,32,97,109,98,105,103,117,111,117,115,32,116,101,114,109,105,110,97,108,32,116,121,112,101,59,32,116,121,112,101,32,106,117,115,116,32,39,115,101,116,32,116,101,114,109,105,110,97,108,39,32,102,111,114,32,97,32,108,105,115,116,0,112,108,111,116,95,97,120,105,115,95,121,50,109,105,110,0,83,121,110,116,97,120,32,101,114,114,111,114,58,32,109,105,115,115,105,110,103,32,98,108,111,99,107,32,116,101,114,109,105,110,97,116,111,114,32,125,0,0,0,0,0,0,0,0,108,111,97,36,100,112,97,116,104,0,0,0,0,0,0,0,98,108,97,110,107,0,0,0,116,117,114,110,105,110,103,32,114,117,108,101,114,32,111,110,46,10,0,0,0,0,0,0,71,80,86,65,76,95,89,50,95,77,73,78,0,0,0,0,101,120,116,114,97,110,101,111,117,115,32,97,114,103,117,109,101,110,116,115,32,105,110,32,115,101,116,32,116,105,99,115,0,0,0,0,0,0,0,0,123,32,48,46,57,57,57,57,57,32,121,48,32,115,117,98,32,103,32,0,0,0,0,0,103,110,117,112,108,111,116,95,115,118,103,46,112,108,111,116,95,97,120,105,115,95,120,50,109,105,110,32,61,32,34,110,111,110,101,34,10,0,0,0,99,97,108,108,0,0,0,0,121,32,112,111,115,0,0,0,118,101,114,116,105,99,97,108,32,109,111,116,105,111,110,32,45,45,32,99,104,97,110,103,101,32,120,121,112,108,97,110,101,0,0,0,0,0,0,0,102,97,105,108,115,97,102,101,0,0,0,0,0,0,0,0,112,108,111,116,95,97,120,105,115,95,120,50,109,97,120,0,99,97,110,32,111,110,108,121,32,109,111,100,32,105,110,116,115,0,0,0,0,0,0,0,71,80,86,65,76,95,88,50,95,77,65,88,0,0,0,0,83,111,114,114,121,44,32,110,111,32,104,101,108,112,32,102,111,114,32,39,37,115,39,10,0,0,0,0,0,0,0,0,112,108,111,116,95,97,120,105,115,95,120,50,109,105,110,0,71,80,86,65,76,95,88,50,95,77,73,78,0,0,0,0,103,110,117,112,108,111,116,95,115,118,103,46,112,108,111,116,95,97,120,105,115,95,114,109,105,110,32,61,32,37,103,59,10,0,0,0,0,0,0,0,102,97,108,115,101,0,0,0,116,114,117,101,0,0,0,0,116,109,95,109,111,110,0,0,117,110,107,110,111,119,110,0,103,110,117,112,108,111,116,95,115,118,103,46,112,111,108,97,114,95,109,111,100,101,32,61,32,37,115,59,10,0,0,0,108,116,0,0,0,0,0,0,105,110,100,101,120,95,109,97,120,0,0,0,0,0,0,0,112,97,114,116,105,97,108,32,109,97,116,99,104,32,97,103,97,105,110,115,116,32,99,111,108,117,109,110,32,37,100,32,104,101,97,100,101,114,32,37,115,0,0,0,0,0,0,0,112,108,111,116,95,97,120,105,115,95,121,109,97,120,0,0,68,101,112,114,101,99,97,116,101,100,32,115,121,110,116,97,120,32,45,32,112,108,101,97,115,101,32,117,115,101,32,39,115,101,116,32,116,105,99,115,32,115,99,97,108,101,39,32,107,101,121,119,111,114,100,0,71,80,86,65,76,95,89,95,77,65,88,0,0,0,0,0,60,83,104,105,102,116,45,66,50,45,77,111,116,105,111,110,62,0,0,0,0,0,0,0,112,108,111,116,95,97,120,105,115,95,121,109,105,110,0,0,71,80,86,65,76,95,89,95,77,73,78,0,0,0,0,0,72,101,108,112,32,116,111,112,105,99,58,32,0,0,0,0])
.concat([118,0,0,0,0,0,0,0,111,117,116,32,111,102,32,109,101,109,111,114,121,32,102,111,114,32,37,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,37,32,71,78,85,80,76,79,84,58,32,76,97,84,101,88,32,112,105,99,116,117,114,101,32,117,115,105,110,103,32,116,112,105,99,32,92,115,112,101,99,105,97,108,115,10,37,37,32,32,32,32,32,32,32,32,32,32,119,105,116,104,32,37,100,32,112,111,105,110,116,32,116,121,112,101,115,32,97,110,100,32,37,100,32,108,105,110,101,32,116,121,112,101,115,10,37,37,32,79,112,116,105,111,110,115,58,32,112,111,105,110,116,115,105,122,101,32,61,32,37,100,44,32,108,105,110,101,119,105,100,116,104,32,61,32,37,100,44,32,105,110,116,101,114,118,97,108,32,61,32,37,102,10,37,37,32,84,111,32,99,104,97,110,103,101,32,97,98,111,118,101,32,111,112,116,105,111,110,115,44,32,115,97,121,58,10,37,37,32,115,101,116,32,116,101,114,109,105,110,97,108,32,116,112,105,99,32,112,111,105,110,116,115,105,122,101,95,118,97,108,117,101,32,108,105,110,101,119,105,100,116,104,95,118,97,108,117,101,32,105,110,116,101,114,118,97,108,95,118,97,108,117,101,10,37,37,32,40,112,111,105,110,116,115,105,122,101,32,97,110,100,32,108,105,110,101,119,105,100,116,104,32,45,32,105,110,116,101,103,101,114,115,32,105,110,32,109,105,108,108,105,45,105,110,99,104,101,115,46,10,37,37,32,32,105,110,116,101,114,118,97,108,32,45,32,97,32,102,108,111,97,116,32,105,110,32,105,110,99,104,101,115,46,32,32,73,102,32,122,101,114,111,32,105,115,32,115,112,101,99,105,102,105,101,100,44,32,10,37,37,32,32,116,104,101,32,100,101,102,97,117,108,116,32,118,97,108,117,101,32,105,115,32,99,104,111,115,101,110,46,41,10,92,115,101,116,108,101,110,103,116,104,123,92,117,110,105,116,108,101,110,103,116,104,125,123,37,102,105,110,125,37,37,10,0,0,0,0,37,115,92,98,101,103,105,110,123,112,105,99,116,117,114,101,125,40,37,100,44,37,100,41,40,37,100,44,37,100,41,37,37,32,37,115,10,0,0,0,64,74,1,0,0,0,0,0,184,73,1,0,1,0,0,0,0,0,0,0,2,0,0,0,232,195,1,0,0,0,0,0,144,195,1,0,1,0,0,0,80,195,1,0,1,0,0,0,144,245,1,0,2,0,0,0,40,245,1,0,2,0,0,0,32,50,1,0,3,0,0,0,232,49,1,0,4,0,0,0,200,49,1,0,5,0,0,0,40,195,1,0,6,0,0,0,192,49,1,0,7,0,0,0,192,229,1,0,8,0,0,0,72,236,1,0,10,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,166,1,0,200,165,1,0,248,164,1,0,184,164,1,0,88,164,1,0,8,164,1,0,176,163,1,0,120,163,1,0,64,163,1,0,232,162,1,0,152,162,1,0,248,161,1,0,4,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,98,101,103,105,110,123,116,101,120,100,114,97,119,125,10,92,110,111,114,109,97,108,115,105,122,101,10,92,105,102,120,92,112,97,116,104,68,69,70,73,78,69,68,92,114,101,108,97,120,92,101,108,115,101,92,108,101,116,92,112,97,116,104,68,69,70,73,78,69,68,92,114,101,108,97,120,10,32,92,100,101,102,92,81,116,71,102,114,123,92,105,102,120,32,40,92,84,71,114,101,32,92,108,101,116,92,89,104,101,116,84,92,99,112,97,116,104,92,101,108,115,101,92,108,101,116,92,89,104,101,116,84,92,114,101,108,97,120,92,102,105,92,89,104,101,116,84,125,10,32,92,100,101,102,92,112,97,116,104,32,40,35,49,32,35,50,41,123,92,109,111,118,101,32,40,35,49,32,35,50,41,92,102,117,116,117,114,101,108,101,116,92,84,71,114,101,92,81,116,71,102,114,125,10,32,92,100,101,102,92,99,112,97,116,104,32,40,35,49,32,35,50,41,123,92,108,118,101,99,32,40,35,49,32,35,50,41,92,102,117,116,117,114,101,108,101,116,92,84,71,114,101,92,81,116,71,102,114,125,10,92,102,105,10,92,100,114,97,119,100,105,109,32,112,116,10,92,115,101,116,117,110,105,116,115,99,97,108,101,32,37,50,46,50,102,10,92,108,105,110,101,119,100,32,37,100,10,92,116,101,120,116,114,101,102,32,104,58,76,32,118,58,67,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,18,0,0,0,0,0,0,255,255,255,255,0,0,0,0,112,23,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,64,0,0,0,0,0,0,40,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,152,190,2,0,192,31,1,0,184,31,1,0,72,31,1,0,24,31,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,253,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,7,0,0,0,7,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,5,0,0,0,5,0,0,0,5,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,2,0,0,0,3,0,0,0,0,0,0,0,2,0,0,0,3,0,0,0,0,0,0,0,2,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,32,3,0,240,30,3,0,160,31,3,0,8,32,3,0,240,31,3,0,192,31,3,0,232,30,3,0,144,31,3,0,184,31,3,0,0,0,0,0,56,32,3,0,8,32,3,0,240,31,3,0,200,31,3,0,192,31,3,0,184,31,3,0,160,31,3,0,144,31,3,0,128,31,3,0,56,31,3,0,24,31,3,0,8,31,3,0,240,30,3,0,232,30,3,0,216,30,3,0,184,30,3,0,152,30,3,0,144,30,3,0,128,30,3,0,64,30,3,0,48,30,3,0,248,29,3,0,208,29,3,0,176,29,3,0,160,29,3,0,152,29,3,0,112,29,3,0,104,29,3,0,88,29,3,0,40,29,3,0,8,29,3,0,248,28,3,0,224,28,3,0,216,28,3,0,184,28,3,0,176,28,3,0,160,28,3,0,152,28,3,0,64,28,3,0,40,28,3,0,16,28,3,0,216,27,3,0,208,27,3,0,200,27,3,0,192,27,3,0,184,27,3,0,168,27,3,0,160,27,3,0,144,27,3,0,64,27,3,0,48,27,3,0,240,26,3,0,232,26,3,0,224,26,3,0,216,26,3,0,208,26,3,0,184,26,3,0,176,26,3,0,160,26,3,0,80,26,3,0,64,26,3,0,48,26,3,0,208,25,3,0,200,25,3,0,192,25,3,0,136,25,3,0,112,25,3,0,88,25,3,0,80,25,3,0,32,25,3,0,16,25,3,0,248,24,3,0,224,24,3,0,216,24,3,0,208,24,3,0,200,24,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,254,1,0,3,0,0,0,32,50,1,0,0,0,0,0,232,49,1,0,1,0,0,0,184,208,2,0,2,0,0,0,0,224,1,0,4,0,0,0,192,218,1,0,5,0,0,0,152,208,2,0,9,0,0,0,144,195,1,0,10,0,0,0,80,195,1,0,10,0,0,0,72,208,2,0,11,0,0,0,56,208,2,0,12,0,0,0,24,208,2,0,12,0,0,0,232,247,1,0,13,0,0,0,80,248,1,0,14,0,0,0,48,246,1,0,15,0,0,0,224,245,1,0,15,0,0,0,144,245,1,0,16,0,0,0,40,245,1,0,16,0,0,0,192,253,1,0,39,0,0,0,248,207,2,0,17,0,0,0,224,207,2,0,18,0,0,0,200,207,2,0,19,0,0,0,16,24,2,0,21,0,0,0,112,207,2,0,20,0,0,0,200,210,2,0,22,0,0,0,176,210,2,0,23,0,0,0,80,207,2,0,24,0,0,0,96,244,1,0,30,0,0,0,48,207,2,0,25,0,0,0,32,207,2,0,26,0,0,0,96,211,2,0,27,0,0,0,24,211,2,0,28,0,0,0,192,229,1,0,29,0,0,0,224,252,1,0,7,0,0,0,24,253,1,0,8,0,0,0,200,251,1,0,37,0,0,0,72,251,1,0,38,0,0,0,56,117,1,0,31,0,0,0,240,206,2,0,32,0,0,0,224,206,2,0,33,0,0,0,152,206,2,0,34,0,0,0,72,206,2,0,35,0,0,0,48,206,2,0,36,0,0,0,232,205,2,0,40,0,0,0,200,205,2,0,41,0,0,0,136,82,3,0,42,0,0,0,184,205,2,0,43,0,0,0,0,0,0,0,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,101,108,118,101,116,105,99,97,44,49,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,101,118,101,108,49,32,83,117,112,112,114,101,115,115,80,68,70,77,97,114,107,32,111,114,32,10,123,125,32,123,10,47,83,68,105,99,116,32,49,48,32,100,105,99,116,32,100,101,102,10,115,121,115,116,101,109,100,105,99,116,32,47,112,100,102,109,97,114,107,32,107,110,111,119,110,32,110,111,116,32,123,10,32,32,117,115,101,114,100,105,99,116,32,47,112,100,102,109,97,114,107,32,115,121,115,116,101,109,100,105,99,116,32,47,99,108,101,97,114,116,111,109,97,114,107,32,103,101,116,32,112,117,116,10,125,32,105,102,10,83,68,105,99,116,32,98,101,103,105,110,32,91,10,32,32,47,84,105,116,108,101,32,40,37,115,41,10,32,32,47,83,117,98,106,101,99,116,32,40,103,110,117,112,108,111,116,32,112,108,111,116,41,10,32,32,47,67,114,101,97,116,111,114,32,40,103,110,117,112,108,111,116,32,37,115,32,112,97,116,99,104,108,101,118,101,108,32,37,115,41,10,32,32,47,65,117,116,104,111,114,32,40,37,115,41,10,37,37,32,32,47,80,114,111,100,117,99,101,114,32,40,103,110,117,112,108,111,116,41,10,37,37,32,32,47,75,101,121,119,111,114,100,115,32,40,41,10,32,32,47,67,114,101,97,116,105,111,110,68,97,116,101,32,40,37,115,41,10,32,32,47,68,79,67,73,78,70,79,32,112,100,102,109,97,114,107,10,101,110,100,10,125,32,105,102,101,108,115,101,10,0,0,0,37,37,37,37,69,110,100,67,111,109,109,101,110,116,115,10,37,37,37,37,66,101,103,105,110,80,114,111,108,111,103,10,47,103,110,117,100,105,99,116,32,50,53,54,32,100,105,99,116,32,100,101,102,10,103,110,117,100,105,99,116,32,98,101,103,105,110,10,37,37,10,37,37,32,84,104,101,32,102,111,108,108,111,119,105,110,103,32,116,114,117,101,47,102,97,108,115,101,32,102,108,97,103,115,32,109,97,121,32,98,101,32,101,100,105,116,101,100,32,98,121,32,104,97,110,100,32,105,102,32,100,101,115,105,114,101,100,46,10,37,37,32,84,104,101,32,117,110,105,116,32,108,105,110,101,32,119,105,100,116,104,32,97,110,100,32,103,114,97,121,115,99,97,108,101,32,105,109,97,103,101,32,103,97,109,109,97,32,99,111,114,114,101,99,116,105,111,110,32,109,97,121,32,97,108,115,111,32,98,101,32,99,104,97,110,103,101,100,46,10,37,37,10,47,67,111,108,111,114,32,37,115,32,100,101,102,10,47,66,108,97,99,107,116,101,120,116,32,37,115,32,100,101,102,10,47,83,111,108,105,100,32,37,115,32,100,101,102,10,47,68,97,115,104,108,101,110,103,116,104,32,37,103,32,100,101,102,10,47,76,97,110,100,115,99,97,112,101,32,37,115,32,100,101,102,10,47,76,101,118,101,108,49,32,37,115,32,100,101,102,10,47,82,111,117,110,100,101,100,32,37,115,32,100,101,102,10,47,67,108,105,112,84,111,66,111,117,110,100,105,110,103,66,111,120,32,37,115,32,100,101,102,10,47,83,117,112,112,114,101,115,115,80,68,70,77,97,114,107,32,102,97,108,115,101,32,100,101,102,10,47,84,114,97,110,115,112,97,114,101,110,116,80,97,116,116,101,114,110,115,32,102,97,108,115,101,32,100,101,102,10,47,103,110,117,108,105,110,101,119,105,100,116,104,32,37,46,51,102,32,100,101,102,10,47,117,115,101,114,108,105,110,101,119,105,100,116,104,32,103,110,117,108,105,110,101,119,105,100,116,104,32,100,101,102,10,47,71,97,109,109,97,32,49,46,48,32,100,101,102,10,47,66,97,99,107,103,114,111,117,110,100,67,111,108,111,114,32,123,37,46,51,102,32,37,46,51,102,32,37,46,51,102,125,32,100,101,102,10,37,37,10,47,118,115,104,105,102,116,32,37,100,32,100,101,102,10,47,100,108,49,32,123,10,32,32,37,46,49,102,32,68,97,115,104,108,101,110,103,116,104,32,109,117,108,32,109,117,108,10,32,32,82,111,117,110,100,101,100,32,123,32,99,117,114,114,101,110,116,108,105,110,101,119,105,100,116,104,32,48,46,55,53,32,109,117,108,32,115,117,98,32,100,117,112,32,48,32,108,101,32,123,32,112,111,112,32,48,46,48,49,32,125,32,105,102,32,125,32,105,102,10,125,32,100,101,102,10,47,100,108,50,32,123,10,32,32,37,46,49,102,32,68,97,115,104,108,101,110,103,116,104,32,109,117,108,32,109,117,108,10,32,32,82,111,117,110,100,101,100,32,123,32,99,117,114,114,101,110,116,108,105,110,101,119,105,100,116,104,32,48,46,55,53,32,109,117,108,32,97,100,100,32,125,32,105,102,10,125,32,100,101,102,10,47,104,112,116,95,32,37,46,49,102,32,100,101,102,10,47,118,112,116,95,32,37,46,49,102,32,100,101,102,10,47,104,112,116,32,104,112,116,95,32,100,101,102,10,47,118,112,116,32,118,112,116,95,32,100,101,102,10,0,0,0,0,0,0,37,37,37,37,67,114,101,97,116,111,114,58,32,103,110,117,112,108,111,116,32,37,115,32,112,97,116,99,104,108,101,118,101,108,32,37,115,10,37,37,37,37,67,114,101,97,116,105,111,110,68,97,116,101,58,32,37,115,10,37,37,37,37,68,111,99,117,109,101,110,116,70,111,110,116,115,58,32,37,115,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,153,1,0,40,153,1,0,224,152,1,0,200,152,1,0,184,152,1,0,112,152,1,0,88,152,1,0,64,152,1,0,48,152,1,0,24,152,1,0,112,151,1,0,232,150,1,0,0,0,0,0,0,0,0,0,224,148,1,0,192,148,1,0,176,148,1,0,160,148,1,0,144,148,1,0,40,148,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,49,1,0,112,51,1,0,64,179,2,0,21,177,0,0,148,132,0,0,32,50,1,0,128,51,1,0,56,179,2,0,148,132,0,0,21,177,0,0,40,139,3,0,0,0,0,0,64,178,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,195,1,0,0,0,0,0,144,195,1,0,1,0,0,0,80,195,1,0,1,0,0,0,40,195,1,0,2,0,0,0,80,248,1,0,3,0,0,0,232,194,1,0,4,0,0,0,184,194,1,0,5,0,0,0,96,194,1,0,6,0,0,0,24,194,1,0,7,0,0,0,80,193,1,0,11,0,0,0,232,192,1,0,8,0,0,0,144,192,1,0,9,0,0,0,88,192,1,0,10,0,0,0,0,192,1,0,14,0,0,0,208,191,1,0,15,0,0,0,152,191,1,0,16,0,0,0,104,191,1,0,12,0,0,0,0,0,0,0,17,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,254,255,255,255,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,208,2,0,0,0,0,0,144,195,1,0,1,0,0,0,80,195,1,0,1,0,0,0,48,195,2,0,2,0,0,0,24,195,2,0,3,0,0,0,224,194,2,0,4,0,0,0,216,194,2,0,4,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,192,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,5,0,0,0,6,0,0,0,5,0,0,0,6,0,0,0,1,0,0,0,0,0,192,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,63,15,0,0,0,10,0,0,0,15,0,0,0,10,0,0,0,0,0,0,0,0,0,192,63,10,0,0,0,15,0,0,0,10,0,0,0,15,0,0,0,0,0,0,0,0,0,192,63,20,0,0,0,10,0,0,0,5,0,0,0,10,0,0,0,0,0,0,0,0,0,192,63,10,0,0,0,6,0,0,0,10,0,0,0,6,0,0,0,0,0,0,0,0,0,192,63,15,0,0,0,6,0,0,0,5,0,0,0,10,0,0,0,0,0,0,0,0,0,192,63,10,0,0,0,6,0,0,0,10,0,0,0,10,0,0,0,0,0,0,0,0,0,192,63,5,0,0,0,6,0,0,0,5,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,4,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,1,0,0,0,4,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,150,1,0,152,190,2,0,152,150,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,130,1,0,208,129,1,0,184,105,1,0,80,105,1,0,240,104,1,0,176,104,1,0,56,104,1,0,0,129,1,0,8,104,1,0,216,103,1,0,88,103,1,0,208,102,1,0,144,102,1,0,104,102,1,0,0,102,1,0,0,0,0,0,176,97,1,0,0,0,0,0,160,97,1,0,1,0,0,0,48,254,1,0,2,0,0,0,120,97,1,0,3,0,0,0,88,97,1,0,4,0,0,0,56,97,1,0,5,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,205,204,204,62,0,0,0,0,205,204,204,62,0,0,160,64,205,204,76,63,0,0,0,0,0,0,128,63,0,0,160,64,154,153,153,63,0,0,0,0,0,0,128,63,0,0,32,65,10,0,0,0,0,0,0,0,100,111,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,4,0,0,0,0,0,0,0,0,3,8,0,0,0,0,0,0,0,0,8,8,0,0,0,0,0,0,0,0,16,6,3,6,0,0,0,0,0,0,16,6,8,6,0,0,0,0,0,0,16,4,1,4,8,4,1,4,0,0,16,4,1,8,1,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,9,0,0,0,0,0,0,228,12,0,0,0,0,0,0,36,9,0,0,0,0,0,0,228,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,50,1,0,0,0,0,0,232,49,1,0,1,0,0,0,0,0,0,0,2,0,0,0,246,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,246,255,255,255,0,0,0,0,246,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,246,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,181,2,0,88,181,2,0,72,181,2,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,64,246,255,255,255,0,0,0,0,112,249,1,0,0,0,0,0,208,250,1,0,1,0,0,0,40,250,1,0,1,0,0,0,144,175,2,0,2,0,0,0,136,175,2,0,3,0,0,0,112,175,2,0,4,0,0,0,56,86,3,0,5,0,0,0,80,175,2,0,6,0,0,0,216,174,2,0,7,0,0,0,0,0,0,0,8,0,0,0,6,0,0,0,0,0,0,0,152,190,2,0,200,181,2,0,200,181,2,0,200,181,2,0,200,181,2,0,200,181,2,0,200,181,2,0,200,181,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
.concat([136,193,2,0,128,193,2,0,21,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,64,0,0,0,0,0,0,0,0,52,16,0,0,0,0,0,0,120,193,2,0,40,193,2,0,21,1,0,0,0,0,0,0,0,0,0,0,0,0,34,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,0,0,0,0,0,0,0,208,192,2,0,144,192,2,0,21,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,64,0,0,0,0,0,0,0,0,5,16,0,0,0,0,0,0,40,192,2,0,8,192,2,0,108,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,64,0,0,0,0,0,0,0,0,45,16,0,0,0,0,0,0,216,191,2,0,200,191,2,0,21,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,64,0,0,0,0,0,0,0,0,72,16,0,0,0,0,0,0,128,191,2,0,120,191,2,0,21,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,64,0,0,0,0,0,0,0,0,218,64,0,0,0,0,0,0,104,191,2,0,176,98,1,0,21,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,64,0,0,0,0,0,0,0,0,3,16,0,0,0,0,0,0,40,191,2,0,16,191,2,0,21,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,64,0,0,0,0,0,0,0,0,101,16,0,0,0,0,0,0,200,190,2,0,136,190,2,0,21,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,64,0,0,0,0,0,0,0,0,6,16,0,0,0,0,0,0,104,190,2,0,80,190,2,0,21,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,64,0,0,0,0,0,0,0,0,17,16,0,0,0,0,0,0,64,190,2,0,32,190,2,0,21,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,64,0,0,0,0,1,0,0,0,10,17,0,0,0,0,0,0,8,190,2,0,248,189,2,0,21,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,64,0,0,0,0,0,0,0,0,5,66,0,0,0,0,0,0,216,189,2,0,200,189,2,0,21,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,64,4,0,0,0,3,0,0,0,44,16,0,0,0,0,0,0,144,189,2,0,24,189,2,0,21,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,64,1,0,0,0,0,0,0,0,20,16,0,0,0,0,0,0,248,188,2,0,208,188,2,0,21,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,64,0,0,0,0,0,0,0,0,201,16,0,0,0,0,0,0,168,188,2,0,144,188,2,0,109,2,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,64,0,0,0,0,0,0,0,0,46,65,0,0,0,0,0,0,128,188,2,0,96,188,2,0,108,72,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,64,1,0,0,0,0,0,0,0,170,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,152,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,1,0,0,0,7,0,0,0,1,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,7,0,0,0,2,0,0,0,0,0,0,0,32,32,114,117,108,101,114,58,32,91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,84,2,0,152,190,2,0,152,190,2,0,24,84,2,0,8,84,2,0,248,83,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,73,84,95,76,79,71,0,176,4,0,0,0,0,0,0,176,4,0,0,0,0,0,0,51,46,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,231,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,160,2,0,3,0,0,0,144,195,1,0,1,0,0,0,80,195,1,0,1,0,0,0,80,248,1,0,15,0,0,0,24,160,2,0,12,0,0,0,192,229,1,0,9,0,0,0,240,159,2,0,10,0,0,0,96,255,1,0,4,0,0,0,232,49,1,0,7,0,0,0,200,159,2,0,5,0,0,0,232,195,1,0,0,0,0,0,184,159,2,0,13,0,0,0,152,159,2,0,6,0,0,0,120,97,1,0,8,0,0,0,144,159,2,0,2,0,0,0,232,247,1,0,14,0,0,0,144,245,1,0,11,0,0,0,112,159,2,0,11,0,0,0,24,159,2,0,18,0,0,0,240,158,2,0,16,0,0,0,192,158,2,0,19,0,0,0,176,158,2,0,17,0,0,0,144,158,2,0,20,0,0,0,0,0,0,0,21,0,0,0,4,0,0,0,2,0,0,0,1,0,0,0,5,0,0,0,3,0,0,0,6,0,0,0,0,0,0,0,26,0,0,0,11,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,134,1,0,0,0,0,0,176,132,1,0,1,0,0,0,8,131,1,0,2,0,0,0,88,128,1,0,3,0,0,0,0,126,1,0,4,0,0,0,152,123,1,0,5,0,0,0,112,121,1,0,6,0,0,0,208,119,1,0,7,0,0,0,0,118,1,0,8,0,0,0,24,116,1,0,9,0,0,0,80,114,1,0,10,0,0,0,152,111,1,0,11,0,0,0,48,109,1,0,12,0,0,0,232,105,1,0,13,0,0,0,176,102,1,0,14,0,0,0,16,100,1,0,15,0,0,0,216,97,1,0,16,0,0,0,224,95,1,0,17,0,0,0,16,93,1,0,18,0,0,0,32,91,1,0,19,0,0,0,232,88,1,0,20,0,0,0,224,83,1,0,21,0,0,0,200,79,1,0,22,0,0,0,240,74,1,0,23,0,0,0,200,72,1,0,24,0,0,0,128,69,1,0,25,0,0,0,240,65,1,0,26,0,0,0,192,59,1,0,27,0,0,0,216,54,1,0,28,0,0,0,0,52,1,0,29,0,0,0,216,49,1,0,30,0,0,0,8,48,1,0,31,0,0,0,224,45,1,0,32,0,0,0,128,43,1,0,33,0,0,0,56,41,1,0,34,0,0,0,0,0,0,0,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,3,0,200,23,3,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,78,1,0,0,138,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,19,3,0,64,19,3,0,0,19,3,0,192,18,3,0,112,18,3,0,16,18,3,0,192,17,3,0,112,17,3,0,208,16,3,0,104,16,3,0,8,16,3,0,232,15,3,0,216,15,3,0,128,15,3,0,248,14,3,0,160,14,3,0,96,14,3,0,56,14,3,0,136,13,3,0,88,13,3,0,224,12,3,0,120,12,3,0,0,12,3,0,184,11,3,0,128,11,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,255,0,255,0,0,0,128,0,128,0,0,0,0,128,128,0,0,0,0,0,128,128,128,0,0,128,64,0,128,128,0,0,128,0,128,0,192,192,192,0,0,255,255,0,255,255,0,0,0,0,0,0,5,0,0,0,8,0,0,0,5,0,0,0,8,0,0,0,5,0,0,0,8,0,0,0,5,0,0,0,8,0,0,0,4,0,0,0,2,0,0,0,4,0,0,0,2,0,0,0,4,0,0,0,2,0,0,0,4,0,0,0,2,0,0,0,4,0,0,0,8,0,0,0,4,0,0,0,2,0,0,0,4,0,0,0,8,0,0,0,4,0,0,0,2,0,0,0,4,0,0,0,9,0,0,0,4,0,0,0,2,0,0,0,4,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,130,1,0,112,130,1,0,48,130,1,0,208,129,1,0,0,129,1,0,200,128,1,0,72,128,1,0,48,128,1,0,32,128,1,0,200,127,1,0,160,127,1,0,120,127,1,0,64,127,1,0,16,127,1,0,176,126,1,0,40,126,1,0,216,125,1,0,168,125,1,0,72,128,1,0,48,128,1,0,200,127,1,0,160,127,1,0,0,0,0,0,0,0,0,0,120,125,1,0,48,125,1,0,248,124,1,0,200,124,1,0,152,124,1,0,104,124,1,0,72,128,1,0,200,127,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,119,1,0,128,119,1,0,88,119,1,0,160,119,1,0,64,119,1,0,0,0,0,0,0,0,0,0,0,0,0,0,160,119,1,0,128,119,1,0,88,119,1,0,16,119,1,0,240,118,1,0,208,118,1,0,120,118,1,0,0,0,0,0,160,119,1,0,128,119,1,0,88,119,1,0,88,119,1,0,88,119,1,0,88,119,1,0,88,119,1,0,88,119,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,10,84,65,66,76,69,10,32,32,50,10,76,84,89,80,69,10,32,55,48,10,32,32,32,32,37,100,10,48,10,76,84,89,80,69,10,32,32,50,10,67,79,78,84,73,78,85,79,85,83,10,32,55,48,10,32,32,32,32,54,52,10,32,32,51,10,83,111,108,105,100,32,108,105,110,101,10,32,55,50,10,32,32,32,32,54,53,10,32,55,51,10,32,32,32,32,32,32,48,10,32,52,48,10,48,46,48,10,32,32,48,10,76,84,89,80,69,10,32,32,50,10,68,65,83,72,69,68,10,32,55,48,10,32,32,32,32,54,52,10,32,32,51,10,95,95,32,95,95,32,95,95,32,95,95,32,95,95,32,95,95,32,95,95,32,95,95,32,95,95,32,95,95,32,95,95,32,95,95,32,95,95,32,95,95,32,95,95,10,32,55,50,10,32,32,32,32,54,53,10,32,55,51,10,32,32,32,32,32,50,10,32,52,48,10,48,46,55,53,10,32,52,57,10,48,46,53,10,32,52,57,10,45,48,46,50,53,10,32,32,48,10,76,84,89,80,69,10,32,32,50,10,72,73,68,68,69,78,10,32,55,48,10,32,32,32,32,54,52,10,32,32,51,10,95,32,95,32,95,32,95,32,95,32,95,32,95,32,95,32,95,32,95,32,95,32,95,32,95,32,95,32,95,32,95,32,95,32,95,32,95,32,95,32,95,32,95,32,95,10,32,55,50,10,32,32,32,32,54,53,10,32,55,51,10,32,32,32,32,32,50,10,32,52,48,10,48,46,51,55,53,10,32,52,57,10,48,46,50,53,10,32,52,57,10,45,48,46,49,50,53,10,32,32,48,10,76,84,89,80,69,10,32,32,50,10,67,69,78,84,69,82,10,32,55,48,10,32,32,32,32,54,52,10,32,32,51,10,95,95,95,95,32,95,32,95,95,95,95,32,95,32,95,95,95,95,32,95,32,95,95,95,95,32,95,32,95,95,95,95,32,95,32,95,95,95,95,32,95,32,95,95,95,95,10,32,55,50,10,32,32,32,32,54,53,10,32,55,51,10,32,32,32,32,32,52,10,32,52,48,10,50,46,48,10,32,52,57,10,49,46,50,53,10,32,52,57,10,45,48,46,50,53,10,32,52,57,10,48,46,50,53,10,32,52,57,10,45,48,46,50,53,10,32,32,48,10,76,84,89,80,69,10,32,32,50,10,80,72,65,78,84,79,77,10,32,55,48,10,32,32,32,32,54,52,10,32,32,51,10,95,95,95,95,95,32,95,32,95,32,95,95,95,95,95,32,95,32,95,32,95,95,95,95,95,32,95,32,95,32,95,95,95,95,95,32,95,32,95,32,95,95,95,95,10,32,55,50,10,32,32,32,32,54,53,10,32,55,51,10,32,32,32,32,32,54,10,32,52,48,10,50,46,53,10,32,52,57,10,49,46,50,53,10,32,52,57,10,45,48,46,50,53,10,32,52,57,10,48,46,50,53,10,32,52,57,10,45,48,46,50,53,10,32,52,57,10,48,46,50,53,10,32,52,57,10,45,48,46,50,53,10,32,32,48,10,76,84,89,80,69,10,32,32,50,10,68,79,84,10,32,55,48,10,32,32,32,32,54,52,10,32,32,51,10,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,10,32,55,50,10,32,32,32,32,54,53,10,32,55,51,10,32,32,32,32,32,50,10,32,52,48,10,48,46,50,53,10,32,52,57,10,48,46,48,10,32,52,57,10,45,48,46,50,53,10,32,32,48,10,76,84,89,80,69,10,32,32,50,10,68,65,83,72,68,79,84,10,32,55,48,10,32,32,32,32,54,52,10,32,32,51,10,95,95,32,46,32,95,95,32,46,32,95,95,32,46,32,95,95,32,46,32,95,95,32,46,32,95,95,32,46,32,95,95,32,46,32,95,95,32,46,32,95,95,32,46,32,95,95,10,32,55,50,10,32,32,32,32,54,53,10,32,55,51,10,32,32,32,32,32,52,10,32,52,48,10,49,46,48,10,32,52,57,10,48,46,53,10,32,52,57,10,45,48,46,50,53,10,32,52,57,10,48,46,48,10,32,52,57,10,45,48,46,50,53,10,32,32,48,10,69,78,68,84,65,66,10,0,0,0,0,0,0,0,57,57,57,10,37,37,32,71,78,85,80,76,79,84,58,32,100,120,102,32,102,105,108,101,32,102,111,114,32,65,117,116,111,67,97,100,10,32,32,48,10,83,69,67,84,73,79,78,10,32,32,50,10,72,69,65,68,69,82,10,32,32,57,10,36,69,88,84,77,73,78,10,32,49,48,10,48,46,48,48,48,10,32,50,48,10,48,46,48,48,48,10,32,32,57,10,36,69,88,84,77,65,88,10,32,49,48,10,37,45,54,46,51,102,10,32,50,48,10,37,45,54,46,51,102,10,32,32,57,10,36,76,73,77,77,73,78,10,32,49,48,10,48,46,48,48,48,10,32,50,48,10,48,46,48,48,48,10,32,32,57,10,36,76,73,77,77,65,88,10,32,49,48,10,37,45,54,46,51,102,10,32,50,48,10,37,45,54,46,51,102,10,32,32,57,10,36,84,69,88,84,83,84,89,76,69,10,32,32,55,10,37,115,10,32,32,57,10,36,84,69,88,84,83,73,90,69,10,32,52,48,10,37,45,54,46,51,102,10,32,32,57,10,36,80,76,73,78,69,87,73,68,10,32,52,48,10,37,45,54,46,52,102,10,32,32,57,10,36,76,84,83,67,65,76,69,10,32,32,52,48,10,37,45,54,46,51,102,10,32,32,57,10,36,67,79,79,82,68,83,10,32,55,48,10,32,32,49,10,32,32,57,10,36,67,69,76,84,89,80,69,10,32,54,10,66,89,76,65,89,69,82,10,32,32,57,10,36,67,76,65,89,69,82,10,32,32,56,10,48,10,32,32,57,10,36,67,69,67,79,76,79,82,10,32,54,50,10,32,32,32,37,115,10,32,32,57,10,36,77,69,78,85,10,32,32,49,10,97,99,97,100,10,32,32,48,10,69,78,68,83,69,67,10,32,32,48,10,83,69,67,84,73,79,78,10,32,32,50,10,84,65,66,76,69,83,10,0,0,0,0,0,208,149,2,0,0,0,0,0,200,149,2,0,1,0,0,0,0,224,1,0,2,0,0,0,184,149,2,0,3,0,0,0,192,253,1,0,4,0,0,0,0,0,0,0,5,0,0,0,42,35,36,37,64,38,61,0,0,0,0,0,0,0,0,0,200,172,3,0,0,0,0,0,255,255,255,255,255,255,15,0,255,0,255,0,255,15,240,0,255,127,240,0,7,7,7,7,255,7,255,7,255,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,208,2,0,0,0,0,0,112,249,1,0,1,0,0,0,248,142,2,0,2,0,0,0,224,142,2,0,2,0,0,0,0,0,0,0,3,0,0,0,49,46,48,0,0,0,0,0,50,48,49,49,45,49,49,45,48,53,0,0,0,0,0,0,99,101,110,116,101,114,0,0,0,0,108,101,102,116,0,0,0,0,0,0,114,105,103,104,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,64,0,0,0,0,0,0,8,64,1,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,64,0,0,0,0,0,0,20,64,0,0,0,0,0,0,8,64,1,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,64,48,254,1,0,0,0,0,0,192,253,1,0,1,0,0,0,88,253,1,0,2,0,0,0,24,253,1,0,3,0,0,0,224,252,1,0,4,0,0,0,144,252,1,0,5,0,0,0,0,252,1,0,6,0,0,0,200,251,1,0,7,0,0,0,72,251,1,0,8,0,0,0,208,250,1,0,9,0,0,0,40,250,1,0,9,0,0,0,112,249,1,0,10,0,0,0,80,248,1,0,11,0,0,0,232,247,1,0,12,0,0,0,128,247,1,0,13,0,0,0,48,26,2,0,14,0,0,0,8,247,1,0,15,0,0,0,16,24,2,0,16,0,0,0,96,3,2,0,17,0,0,0,152,246,1,0,18,0,0,0,48,246,1,0,19,0,0,0,224,245,1,0,19,0,0,0,144,245,1,0,20,0,0,0,40,245,1,0,20,0,0,0,96,244,1,0,21,0,0,0,216,243,1,0,21,0,0,0,128,243,1,0,22,0,0,0,248,242,1,0,23,0,0,0,104,242,1,0,22,0,0,0,8,242,1,0,22,0,0,0,184,241,1,0,23,0,0,0,240,240,1,0,24,0,0,0,120,240,1,0,25,0,0,0,192,229,1,0,27,0,0,0,232,239,1,0,26,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,253,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,50,1,0,0,0,0,0,24,135,2,0,1,0,0,0,224,155,2,0,2,0,0,0,0,135,2,0,11,0,0,0,232,134,2,0,11,0,0,0,152,208,2,0,3,0,0,0,144,195,1,0,4,0,0,0,80,195,1,0,4,0,0,0,56,117,1,0,5,0,0,0,200,134,2,0,6,0,0,0,80,248,1,0,7,0,0,0,40,195,1,0,8,0,0,0,184,134,2,0,9,0,0,0,40,245,1,0,9,0,0,0,176,134,2,0,10,0,0,0,136,82,3,0,12,0,0,0,0,0,0,0,13,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,16,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,5,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,5,0,0,0,1,0,0,0,6,0,0,0,1,0,0,0,7,0,0,0,1,0,0,0,8,0,0,0,1,0,0,0,9,0,0,0,1,0,0,0,10,0,0,0,1,0,0,0,13,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,4,0,0,0,2,0,0,0,5,0,0,0,2,0,0,0,6,0,0,0,4,0,0,0,1,0,0,0,4,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,7,0,0,0,4,0,0,0,11,0,0,0,4,0,0,0,12,0,0,0,4,0,0,0,15,0,0,0,4,0,0,0,16,0,0,0,4,0,0,0,17,0,0,0,4,0,0,0,18,0,0,0,4,0,0,0,19,0,0,0,5,0,0,0,2,0,0,0,5,0,0,0,3,0,0,0,5,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,5,0,0,0,7,0,0,0,5,0,0,0,8,0,0,0,5,0,0,0,10,0,0,0,5,0,0,0,14,0,0,0,5,0,0,0,15,0,0,0,5,0,0,0,16,0,0,0,5,0,0,0,18,0,0,0,5,0,0,0,22,0,0,0,5,0,0,0,23,0,0,0,5,0,0,0,24,0,0,0,5,0,0,0,27,0,0,0,5,0,0,0,28,0,0,0,5,0,0,0,29,0,0,0,5,0,0,0,30,0,0,0,5,0,0,0,34,0,0,0,6,0,0,0,1,0,0,0,7,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,5,0,0,0,0,0,0,0,4,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,8,0,0,0,5,0,0,0,8,0,0,0,5,0,0,0,8,0,0,0,5,0,0,0,8,0,0,0,5,0,0,0,3,0,0,0,5,0,0,0,3,0,0,0,5,0,0,0,3,0,0,0,5,0,0,0,3,0,0,0,4,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,4,0,0,0,8,0,0,0,4,0,0,0,1,0,0,0,4,0,0,0,8,0,0,0,4,0,0,0,1,0,0,0,4,0,0,0,9,0,0,0,4,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,10,0,0,0,4,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,4,0,0,0,10,0,0,0,4,0,0,0,10,0,0,0,4,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,10,0,0,0,4,0,0,0,10,0,0,0,4,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,192,229,1,0,1,0,0,0,128,91,2,0,2,0,0,0,64,85,3,0,3,0,0,0,192,253,1,0,0,0,0,0,152,10,2,0,4,0,0,0,136,85,3,0,7,0,0,0,168,85,3,0,7,0,0,0,120,91,2,0,8,0,0,0,0,224,1,0,9,0,0,0,192,218,1,0,10,0,0,0,40,245,1,0,6,0,0,0,144,245,1,0,6,0,0,0,72,91,2,0,5,0,0,0,96,244,1,0,11,0,0,0,176,1,2,0,12,0,0,0,152,82,3,0,13,0,0,0,48,246,1,0,14,0,0,0,224,245,1,0,14,0,0,0,176,82,3,0,15,0,0,0,16,24,2,0,16,0,0,0,136,82,3,0,17,0,0,0,0,0,0,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,128,2,0,8,128,2,0,224,127,2,0,184,127,2,0,40,127,2,0,216,126,2,0,144,126,2,0,120,126,2,0,80,126,2,0,208,125,2,0,168,125,2,0,112,125,2,0,88,125,2,0,16,125,2,0,248,124,2,0,224,124,2,0,192,124,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
, "i8", ALLOC_NONE, Runtime.GLOBAL_BASE)
function runPostSets() {
}
if (!awaitingMemoryInitializer) runPostSets();
var tempDoublePtr = Runtime.alignMemory(allocate(12, "i8", ALLOC_STATIC), 8);
assert(tempDoublePtr % 8 == 0);
function copyTempFloat(ptr) { // functions, because inlining this code increases code size too much
  HEAP8[tempDoublePtr] = HEAP8[ptr];
  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];
  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];
  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];
}
function copyTempDouble(ptr) {
  HEAP8[tempDoublePtr] = HEAP8[ptr];
  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];
  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];
  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];
  HEAP8[tempDoublePtr+4] = HEAP8[ptr+4];
  HEAP8[tempDoublePtr+5] = HEAP8[ptr+5];
  HEAP8[tempDoublePtr+6] = HEAP8[ptr+6];
  HEAP8[tempDoublePtr+7] = HEAP8[ptr+7];
}
  var _log=Math.log;
  var _fabs=Math.abs;
  var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:35,EIDRM:36,ECHRNG:37,EL2NSYNC:38,EL3HLT:39,EL3RST:40,ELNRNG:41,EUNATCH:42,ENOCSI:43,EL2HLT:44,EDEADLK:45,ENOLCK:46,EBADE:50,EBADR:51,EXFULL:52,ENOANO:53,EBADRQC:54,EBADSLT:55,EDEADLOCK:56,EBFONT:57,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:74,ELBIN:75,EDOTDOT:76,EBADMSG:77,EFTYPE:79,ENOTUNIQ:80,EBADFD:81,EREMCHG:82,ELIBACC:83,ELIBBAD:84,ELIBSCN:85,ELIBMAX:86,ELIBEXEC:87,ENOSYS:88,ENMFILE:89,ENOTEMPTY:90,ENAMETOOLONG:91,ELOOP:92,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:106,EPROTOTYPE:107,ENOTSOCK:108,ENOPROTOOPT:109,ESHUTDOWN:110,ECONNREFUSED:111,EADDRINUSE:112,ECONNABORTED:113,ENETUNREACH:114,ENETDOWN:115,ETIMEDOUT:116,EHOSTDOWN:117,EHOSTUNREACH:118,EINPROGRESS:119,EALREADY:120,EDESTADDRREQ:121,EMSGSIZE:122,EPROTONOSUPPORT:123,ESOCKTNOSUPPORT:124,EADDRNOTAVAIL:125,ENETRESET:126,EISCONN:127,ENOTCONN:128,ETOOMANYREFS:129,EPROCLIM:130,EUSERS:131,EDQUOT:132,ESTALE:133,ENOTSUP:134,ENOMEDIUM:135,ENOSHARE:136,ECASECLASH:137,EILSEQ:138,EOVERFLOW:139,ECANCELED:140,ENOTRECOVERABLE:141,EOWNERDEAD:142,ESTRPIPE:143};
  var ___errno_state=0;function ___setErrNo(value) {
      // For convenient setting and returning of errno.
      HEAP32[((___errno_state)>>2)]=value
      return value;
    }
  var _stdin=allocate(1, "i32*", ALLOC_STATIC);
  var _stdout=allocate(1, "i32*", ALLOC_STATIC);
  var _stderr=allocate(1, "i32*", ALLOC_STATIC);
  var __impure_ptr=allocate(1, "i32*", ALLOC_STATIC);var FS={currentPath:"/",nextInode:2,streams:[null],ignorePermissions:true,createFileHandle:function (stream, fd) {
        if (typeof stream === 'undefined') {
          stream = null;
        }
        if (!fd) {
          if (stream && stream.socket) {
            for (var i = 1; i < 64; i++) {
              if (!FS.streams[i]) {
                fd = i;
                break;
              }
            }
            assert(fd, 'ran out of low fds for sockets');
          } else {
            fd = Math.max(FS.streams.length, 64);
            for (var i = FS.streams.length; i < fd; i++) {
              FS.streams[i] = null; // Keep dense
            }
          }
        }
        // Close WebSocket first if we are about to replace the fd (i.e. dup2)
        if (FS.streams[fd] && FS.streams[fd].socket && FS.streams[fd].socket.close) {
          FS.streams[fd].socket.close();
        }
        FS.streams[fd] = stream;
        return fd;
      },removeFileHandle:function (fd) {
        FS.streams[fd] = null;
      },joinPath:function (parts, forceRelative) {
        var ret = parts[0];
        for (var i = 1; i < parts.length; i++) {
          if (ret[ret.length-1] != '/') ret += '/';
          ret += parts[i];
        }
        if (forceRelative && ret[0] == '/') ret = ret.substr(1);
        return ret;
      },absolutePath:function (relative, base) {
        if (typeof relative !== 'string') return null;
        if (base === undefined) base = FS.currentPath;
        if (relative && relative[0] == '/') base = '';
        var full = base + '/' + relative;
        var parts = full.split('/').reverse();
        var absolute = [''];
        while (parts.length) {
          var part = parts.pop();
          if (part == '' || part == '.') {
            // Nothing.
          } else if (part == '..') {
            if (absolute.length > 1) absolute.pop();
          } else {
            absolute.push(part);
          }
        }
        return absolute.length == 1 ? '/' : absolute.join('/');
      },analyzePath:function (path, dontResolveLastLink, linksVisited) {
        var ret = {
          isRoot: false,
          exists: false,
          error: 0,
          name: null,
          path: null,
          object: null,
          parentExists: false,
          parentPath: null,
          parentObject: null
        };
        path = FS.absolutePath(path);
        if (path == '/') {
          ret.isRoot = true;
          ret.exists = ret.parentExists = true;
          ret.name = '/';
          ret.path = ret.parentPath = '/';
          ret.object = ret.parentObject = FS.root;
        } else if (path !== null) {
          linksVisited = linksVisited || 0;
          path = path.slice(1).split('/');
          var current = FS.root;
          var traversed = [''];
          while (path.length) {
            if (path.length == 1 && current.isFolder) {
              ret.parentExists = true;
              ret.parentPath = traversed.length == 1 ? '/' : traversed.join('/');
              ret.parentObject = current;
              ret.name = path[0];
            }
            var target = path.shift();
            if (!current.isFolder) {
              ret.error = ERRNO_CODES.ENOTDIR;
              break;
            } else if (!current.read) {
              ret.error = ERRNO_CODES.EACCES;
              break;
            } else if (!current.contents.hasOwnProperty(target)) {
              ret.error = ERRNO_CODES.ENOENT;
              break;
            }
            current = current.contents[target];
            if (current.link && !(dontResolveLastLink && path.length == 0)) {
              if (linksVisited > 40) { // Usual Linux SYMLOOP_MAX.
                ret.error = ERRNO_CODES.ELOOP;
                break;
              }
              var link = FS.absolutePath(current.link, traversed.join('/'));
              ret = FS.analyzePath([link].concat(path).join('/'),
                                   dontResolveLastLink, linksVisited + 1);
              return ret;
            }
            traversed.push(target);
            if (path.length == 0) {
              ret.exists = true;
              ret.path = traversed.join('/');
              ret.object = current;
            }
          }
        }
        return ret;
      },findObject:function (path, dontResolveLastLink) {
        FS.ensureRoot();
        var ret = FS.analyzePath(path, dontResolveLastLink);
        if (ret.exists) {
          return ret.object;
        } else {
          ___setErrNo(ret.error);
          return null;
        }
      },createObject:function (parent, name, properties, canRead, canWrite) {
        if (!parent) parent = '/';
        if (typeof parent === 'string') parent = FS.findObject(parent);
        if (!parent) {
          ___setErrNo(ERRNO_CODES.EACCES);
          throw new Error('Parent path must exist.');
        }
        if (!parent.isFolder) {
          ___setErrNo(ERRNO_CODES.ENOTDIR);
          throw new Error('Parent must be a folder.');
        }
        if (!parent.write && !FS.ignorePermissions) {
          ___setErrNo(ERRNO_CODES.EACCES);
          throw new Error('Parent folder must be writeable.');
        }
        if (!name || name == '.' || name == '..') {
          ___setErrNo(ERRNO_CODES.ENOENT);
          throw new Error('Name must not be empty.');
        }
        if (parent.contents.hasOwnProperty(name)) {
          ___setErrNo(ERRNO_CODES.EEXIST);
          throw new Error("Can't overwrite object.");
        }
        parent.contents[name] = {
          read: canRead === undefined ? true : canRead,
          write: canWrite === undefined ? false : canWrite,
          timestamp: Date.now(),
          inodeNumber: FS.nextInode++
        };
        for (var key in properties) {
          if (properties.hasOwnProperty(key)) {
            parent.contents[name][key] = properties[key];
          }
        }
        return parent.contents[name];
      },createFolder:function (parent, name, canRead, canWrite) {
        var properties = {isFolder: true, isDevice: false, contents: {}};
        return FS.createObject(parent, name, properties, canRead, canWrite);
      },createPath:function (parent, path, canRead, canWrite) {
        var current = FS.findObject(parent);
        if (current === null) throw new Error('Invalid parent.');
        path = path.split('/').reverse();
        while (path.length) {
          var part = path.pop();
          if (!part) continue;
          if (!current.contents.hasOwnProperty(part)) {
            FS.createFolder(current, part, canRead, canWrite);
          }
          current = current.contents[part];
        }
        return current;
      },createFile:function (parent, name, properties, canRead, canWrite) {
        properties.isFolder = false;
        return FS.createObject(parent, name, properties, canRead, canWrite);
      },createDataFile:function (parent, name, data, canRead, canWrite) {
        if (typeof data === 'string') {
          var dataArray = new Array(data.length);
          for (var i = 0, len = data.length; i < len; ++i) dataArray[i] = data.charCodeAt(i);
          data = dataArray;
        }
        var properties = {
          isDevice: false,
          contents: data.subarray ? data.subarray(0) : data // as an optimization, create a new array wrapper (not buffer) here, to help JS engines understand this object
        };
        return FS.createFile(parent, name, properties, canRead, canWrite);
      },createLazyFile:function (parent, name, url, canRead, canWrite) {
        if (typeof XMLHttpRequest !== 'undefined') {
          if (!ENVIRONMENT_IS_WORKER) throw 'Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc';
          // Lazy chunked Uint8Array (implements get and length from Uint8Array). Actual getting is abstracted away for eventual reuse.
          var LazyUint8Array = function() {
            this.lengthKnown = false;
            this.chunks = []; // Loaded chunks. Index is the chunk number
          }
          LazyUint8Array.prototype.get = function(idx) {
            if (idx > this.length-1 || idx < 0) {
              return undefined;
            }
            var chunkOffset = idx % this.chunkSize;
            var chunkNum = Math.floor(idx / this.chunkSize);
            return this.getter(chunkNum)[chunkOffset];
          }
          LazyUint8Array.prototype.setDataGetter = function(getter) {
            this.getter = getter;
          }
          LazyUint8Array.prototype.cacheLength = function() {
              // Find length
              var xhr = new XMLHttpRequest();
              xhr.open('HEAD', url, false);
              xhr.send(null);
              if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
              var datalength = Number(xhr.getResponseHeader("Content-length"));
              var header;
              var hasByteServing = (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes";
              var chunkSize = 1024*1024; // Chunk size in bytes
              if (!hasByteServing) chunkSize = datalength;
              // Function to get a range from the remote URL.
              var doXHR = (function(from, to) {
                if (from > to) throw new Error("invalid range (" + from + ", " + to + ") or no bytes requested!");
                if (to > datalength-1) throw new Error("only " + datalength + " bytes available! programmer error!");
                // TODO: Use mozResponseArrayBuffer, responseStream, etc. if available.
                var xhr = new XMLHttpRequest();
                xhr.open('GET', url, false);
                if (datalength !== chunkSize) xhr.setRequestHeader("Range", "bytes=" + from + "-" + to);
                // Some hints to the browser that we want binary data.
                if (typeof Uint8Array != 'undefined') xhr.responseType = 'arraybuffer';
                if (xhr.overrideMimeType) {
                  xhr.overrideMimeType('text/plain; charset=x-user-defined');
                }
                xhr.send(null);
                if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
                if (xhr.response !== undefined) {
                  return new Uint8Array(xhr.response || []);
                } else {
                  return intArrayFromString(xhr.responseText || '', true);
                }
              });
              var lazyArray = this;
              lazyArray.setDataGetter(function(chunkNum) {
                var start = chunkNum * chunkSize;
                var end = (chunkNum+1) * chunkSize - 1; // including this byte
                end = Math.min(end, datalength-1); // if datalength-1 is selected, this is the last block
                if (typeof(lazyArray.chunks[chunkNum]) === "undefined") {
                  lazyArray.chunks[chunkNum] = doXHR(start, end);
                }
                if (typeof(lazyArray.chunks[chunkNum]) === "undefined") throw new Error("doXHR failed!");
                return lazyArray.chunks[chunkNum];
              });
              this._length = datalength;
              this._chunkSize = chunkSize;
              this.lengthKnown = true;
          }
          var lazyArray = new LazyUint8Array();
          Object.defineProperty(lazyArray, "length", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._length;
              }
          });
          Object.defineProperty(lazyArray, "chunkSize", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._chunkSize;
              }
          });
          var properties = { isDevice: false, contents: lazyArray };
        } else {
          var properties = { isDevice: false, url: url };
        }
        return FS.createFile(parent, name, properties, canRead, canWrite);
      },createPreloadedFile:function (parent, name, url, canRead, canWrite, onload, onerror, dontCreateFile) {
        Browser.init();
        var fullname = FS.joinPath([parent, name], true);
        function processData(byteArray) {
          function finish(byteArray) {
            if (!dontCreateFile) {
              FS.createDataFile(parent, name, byteArray, canRead, canWrite);
            }
            if (onload) onload();
            removeRunDependency('cp ' + fullname);
          }
          var handled = false;
          Module['preloadPlugins'].forEach(function(plugin) {
            if (handled) return;
            if (plugin['canHandle'](fullname)) {
              plugin['handle'](byteArray, fullname, finish, function() {
                if (onerror) onerror();
                removeRunDependency('cp ' + fullname);
              });
              handled = true;
            }
          });
          if (!handled) finish(byteArray);
        }
        addRunDependency('cp ' + fullname);
        if (typeof url == 'string') {
          Browser.asyncLoad(url, function(byteArray) {
            processData(byteArray);
          }, onerror);
        } else {
          processData(url);
        }
      },createLink:function (parent, name, target, canRead, canWrite) {
        var properties = {isDevice: false, link: target};
        return FS.createFile(parent, name, properties, canRead, canWrite);
      },createDevice:function (parent, name, input, output) {
        if (!(input || output)) {
          throw new Error('A device must have at least one callback defined.');
        }
        var ops = {isDevice: true, input: input, output: output};
        return FS.createFile(parent, name, ops, Boolean(input), Boolean(output));
      },forceLoadFile:function (obj) {
        if (obj.isDevice || obj.isFolder || obj.link || obj.contents) return true;
        var success = true;
        if (typeof XMLHttpRequest !== 'undefined') {
          throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");
        } else if (Module['read']) {
          // Command-line.
          try {
            // WARNING: Can't read binary files in V8's d8 or tracemonkey's js, as
            //          read() will try to parse UTF8.
            obj.contents = intArrayFromString(Module['read'](obj.url), true);
          } catch (e) {
            success = false;
          }
        } else {
          throw new Error('Cannot load without read() or XMLHttpRequest.');
        }
        if (!success) ___setErrNo(ERRNO_CODES.EIO);
        return success;
      },ensureRoot:function () {
        if (FS.root) return;
        // The main file system tree. All the contents are inside this.
        FS.root = {
          read: true,
          write: true,
          isFolder: true,
          isDevice: false,
          timestamp: Date.now(),
          inodeNumber: 1,
          contents: {}
        };
      },init:function (input, output, error) {
        // Make sure we initialize only once.
        assert(!FS.init.initialized, 'FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)');
        FS.init.initialized = true;
        FS.ensureRoot();
        // Allow Module.stdin etc. to provide defaults, if none explicitly passed to us here
        input = input || Module['stdin'];
        output = output || Module['stdout'];
        error = error || Module['stderr'];
        // Default handlers.
        var stdinOverridden = true, stdoutOverridden = true, stderrOverridden = true;
        if (!input) {
          stdinOverridden = false;
          input = function() {
            if (!input.cache || !input.cache.length) {
              var result;
              if (typeof window != 'undefined' &&
                  typeof window.prompt == 'function') {
                // Browser.
                result = window.prompt('Input: ');
                if (result === null) result = String.fromCharCode(0); // cancel ==> EOF
              } else if (typeof readline == 'function') {
                // Command line.
                result = readline();
              }
              if (!result) result = '';
              input.cache = intArrayFromString(result + '\n', true);
            }
            return input.cache.shift();
          };
        }
        var utf8 = new Runtime.UTF8Processor();
        function simpleOutput(val) {
          if (val === null || val === 10) {
            output.printer(output.buffer.join(''));
            output.buffer = [];
          } else {
            output.buffer.push(utf8.processCChar(val));
          }
        }
        if (!output) {
          stdoutOverridden = false;
          output = simpleOutput;
        }
        if (!output.printer) output.printer = Module['print'];
        if (!output.buffer) output.buffer = [];
        if (!error) {
          stderrOverridden = false;
          error = simpleOutput;
        }
        if (!error.printer) error.printer = Module['print'];
        if (!error.buffer) error.buffer = [];
        // Create the temporary folder, if not already created
        try {
          FS.createFolder('/', 'tmp', true, true);
        } catch(e) {}
        // Create the I/O devices.
        var devFolder = FS.createFolder('/', 'dev', true, true);
        var stdin = FS.createDevice(devFolder, 'stdin', input);
        var stdout = FS.createDevice(devFolder, 'stdout', null, output);
        var stderr = FS.createDevice(devFolder, 'stderr', null, error);
        FS.createDevice(devFolder, 'tty', input, output);
        FS.createDevice(devFolder, 'null', function(){}, function(){});
        // Create default streams.
        FS.streams[1] = {
          path: '/dev/stdin',
          object: stdin,
          position: 0,
          isRead: true,
          isWrite: false,
          isAppend: false,
          isTerminal: !stdinOverridden,
          error: false,
          eof: false,
          ungotten: []
        };
        FS.streams[2] = {
          path: '/dev/stdout',
          object: stdout,
          position: 0,
          isRead: false,
          isWrite: true,
          isAppend: false,
          isTerminal: !stdoutOverridden,
          error: false,
          eof: false,
          ungotten: []
        };
        FS.streams[3] = {
          path: '/dev/stderr',
          object: stderr,
          position: 0,
          isRead: false,
          isWrite: true,
          isAppend: false,
          isTerminal: !stderrOverridden,
          error: false,
          eof: false,
          ungotten: []
        };
        // TODO: put these low in memory like we used to assert on: assert(Math.max(_stdin, _stdout, _stderr) < 15000); // make sure these are low, we flatten arrays with these
        HEAP32[((_stdin)>>2)]=1;
        HEAP32[((_stdout)>>2)]=2;
        HEAP32[((_stderr)>>2)]=3;
        // Other system paths
        FS.createPath('/', 'dev/shm/tmp', true, true); // temp files
        // Newlib initialization
        for (var i = FS.streams.length; i < Math.max(_stdin, _stdout, _stderr) + 4; i++) {
          FS.streams[i] = null; // Make sure to keep FS.streams dense
        }
        FS.streams[_stdin] = FS.streams[1];
        FS.streams[_stdout] = FS.streams[2];
        FS.streams[_stderr] = FS.streams[3];
        allocate([ allocate(
          [0, 0, 0, 0, _stdin, 0, 0, 0, _stdout, 0, 0, 0, _stderr, 0, 0, 0],
          'void*', ALLOC_NORMAL) ], 'void*', ALLOC_NONE, __impure_ptr);
      },quit:function () {
        if (!FS.init.initialized) return;
        // Flush any partially-printed lines in stdout and stderr. Careful, they may have been closed
        if (FS.streams[2] && FS.streams[2].object.output.buffer.length > 0) FS.streams[2].object.output(10);
        if (FS.streams[3] && FS.streams[3].object.output.buffer.length > 0) FS.streams[3].object.output(10);
      },standardizePath:function (path) {
        if (path.substr(0, 2) == './') path = path.substr(2);
        return path;
      },deleteFile:function (path) {
        path = FS.analyzePath(path);
        if (!path.parentExists || !path.exists) {
          throw 'Invalid path ' + path;
        }
        delete path.parentObject.contents[path.name];
      }};
  function _send(fd, buf, len, flags) {
      var info = FS.streams[fd];
      if (!info) return -1;
      info.sender(HEAPU8.subarray(buf, buf+len));
      return len;
    }
  function _pwrite(fildes, buf, nbyte, offset) {
      // ssize_t pwrite(int fildes, const void *buf, size_t nbyte, off_t offset);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
      var stream = FS.streams[fildes];
      if (!stream || stream.object.isDevice) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      } else if (!stream.isWrite) {
        ___setErrNo(ERRNO_CODES.EACCES);
        return -1;
      } else if (stream.object.isFolder) {
        ___setErrNo(ERRNO_CODES.EISDIR);
        return -1;
      } else if (nbyte < 0 || offset < 0) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return -1;
      } else {
        var contents = stream.object.contents;
        while (contents.length < offset) contents.push(0);
        for (var i = 0; i < nbyte; i++) {
          contents[offset + i] = HEAPU8[(((buf)+(i))|0)];
        }
        stream.object.timestamp = Date.now();
        return i;
      }
    }function _write(fildes, buf, nbyte) {
      // ssize_t write(int fildes, const void *buf, size_t nbyte);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
      var stream = FS.streams[fildes];
      if (stream && ('socket' in stream)) {
          return _send(fildes, buf, nbyte, 0);
      } else if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      } else if (!stream.isWrite) {
        ___setErrNo(ERRNO_CODES.EACCES);
        return -1;
      } else if (nbyte < 0) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return -1;
      } else {
        if (stream.object.isDevice) {
          if (stream.object.output) {
            for (var i = 0; i < nbyte; i++) {
              try {
                stream.object.output(HEAP8[(((buf)+(i))|0)]);
              } catch (e) {
                ___setErrNo(ERRNO_CODES.EIO);
                return -1;
              }
            }
            stream.object.timestamp = Date.now();
            return i;
          } else {
            ___setErrNo(ERRNO_CODES.ENXIO);
            return -1;
          }
        } else {
          var bytesWritten = _pwrite(fildes, buf, nbyte, stream.position);
          if (bytesWritten != -1) stream.position += bytesWritten;
          return bytesWritten;
        }
      }
    }function _fwrite(ptr, size, nitems, stream) {
      // size_t fwrite(const void *restrict ptr, size_t size, size_t nitems, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fwrite.html
      var bytesToWrite = nitems * size;
      if (bytesToWrite == 0) return 0;
      var bytesWritten = _write(stream, ptr, bytesToWrite);
      if (bytesWritten == -1) {
        if (FS.streams[stream]) FS.streams[stream].error = true;
        return 0;
      } else {
        return Math.floor(bytesWritten / size);
      }
    }
  Module["_strlen"] = _strlen;
  function __reallyNegative(x) {
      return x < 0 || (x === 0 && (1/x) === -Infinity);
    }function __formatString(format, varargs) {
      var textIndex = format;
      var argIndex = 0;
      function getNextArg(type) {
        // NOTE: Explicitly ignoring type safety. Otherwise this fails:
        //       int x = 4; printf("%c\n", (char)x);
        var ret;
        if (type === 'double') {
          ret = HEAPF64[(((varargs)+(argIndex))>>3)];
        } else if (type == 'i64') {
          ret = [HEAP32[(((varargs)+(argIndex))>>2)],
                 HEAP32[(((varargs)+(argIndex+8))>>2)]];
          argIndex += 8; // each 32-bit chunk is in a 64-bit block
        } else {
          type = 'i32'; // varargs are always i32, i64, or double
          ret = HEAP32[(((varargs)+(argIndex))>>2)];
        }
        argIndex += Math.max(Runtime.getNativeFieldSize(type), Runtime.getAlignSize(type, null, true));
        return ret;
      }
      var ret = [];
      var curr, next, currArg;
      while(1) {
        var startTextIndex = textIndex;
        curr = HEAP8[(textIndex)];
        if (curr === 0) break;
        next = HEAP8[((textIndex+1)|0)];
        if (curr == 37) {
          // Handle flags.
          var flagAlwaysSigned = false;
          var flagLeftAlign = false;
          var flagAlternative = false;
          var flagZeroPad = false;
          flagsLoop: while (1) {
            switch (next) {
              case 43:
                flagAlwaysSigned = true;
                break;
              case 45:
                flagLeftAlign = true;
                break;
              case 35:
                flagAlternative = true;
                break;
              case 48:
                if (flagZeroPad) {
                  break flagsLoop;
                } else {
                  flagZeroPad = true;
                  break;
                }
              default:
                break flagsLoop;
            }
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
          }
          // Handle width.
          var width = 0;
          if (next == 42) {
            width = getNextArg('i32');
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
          } else {
            while (next >= 48 && next <= 57) {
              width = width * 10 + (next - 48);
              textIndex++;
              next = HEAP8[((textIndex+1)|0)];
            }
          }
          // Handle precision.
          var precisionSet = false;
          if (next == 46) {
            var precision = 0;
            precisionSet = true;
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
            if (next == 42) {
              precision = getNextArg('i32');
              textIndex++;
            } else {
              while(1) {
                var precisionChr = HEAP8[((textIndex+1)|0)];
                if (precisionChr < 48 ||
                    precisionChr > 57) break;
                precision = precision * 10 + (precisionChr - 48);
                textIndex++;
              }
            }
            next = HEAP8[((textIndex+1)|0)];
          } else {
            var precision = 6; // Standard default.
          }
          // Handle integer sizes. WARNING: These assume a 32-bit architecture!
          var argSize;
          switch (String.fromCharCode(next)) {
            case 'h':
              var nextNext = HEAP8[((textIndex+2)|0)];
              if (nextNext == 104) {
                textIndex++;
                argSize = 1; // char (actually i32 in varargs)
              } else {
                argSize = 2; // short (actually i32 in varargs)
              }
              break;
            case 'l':
              var nextNext = HEAP8[((textIndex+2)|0)];
              if (nextNext == 108) {
                textIndex++;
                argSize = 8; // long long
              } else {
                argSize = 4; // long
              }
              break;
            case 'L': // long long
            case 'q': // int64_t
            case 'j': // intmax_t
              argSize = 8;
              break;
            case 'z': // size_t
            case 't': // ptrdiff_t
            case 'I': // signed ptrdiff_t or unsigned size_t
              argSize = 4;
              break;
            default:
              argSize = null;
          }
          if (argSize) textIndex++;
          next = HEAP8[((textIndex+1)|0)];
          // Handle type specifier.
          switch (String.fromCharCode(next)) {
            case 'd': case 'i': case 'u': case 'o': case 'x': case 'X': case 'p': {
              // Integer.
              var signed = next == 100 || next == 105;
              argSize = argSize || 4;
              var currArg = getNextArg('i' + (argSize * 8));
              var origArg = currArg;
              var argText;
              // Flatten i64-1 [low, high] into a (slightly rounded) double
              if (argSize == 8) {
                currArg = Runtime.makeBigInt(currArg[0], currArg[1], next == 117);
              }
              // Truncate to requested size.
              if (argSize <= 4) {
                var limit = Math.pow(256, argSize) - 1;
                currArg = (signed ? reSign : unSign)(currArg & limit, argSize * 8);
              }
              // Format the number.
              var currAbsArg = Math.abs(currArg);
              var prefix = '';
              if (next == 100 || next == 105) {
                if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], null); else
                argText = reSign(currArg, 8 * argSize, 1).toString(10);
              } else if (next == 117) {
                if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], true); else
                argText = unSign(currArg, 8 * argSize, 1).toString(10);
                currArg = Math.abs(currArg);
              } else if (next == 111) {
                argText = (flagAlternative ? '0' : '') + currAbsArg.toString(8);
              } else if (next == 120 || next == 88) {
                prefix = (flagAlternative && currArg != 0) ? '0x' : '';
                if (argSize == 8 && i64Math) {
                  if (origArg[1]) {
                    argText = (origArg[1]>>>0).toString(16);
                    var lower = (origArg[0]>>>0).toString(16);
                    while (lower.length < 8) lower = '0' + lower;
                    argText += lower;
                  } else {
                    argText = (origArg[0]>>>0).toString(16);
                  }
                } else
                if (currArg < 0) {
                  // Represent negative numbers in hex as 2's complement.
                  currArg = -currArg;
                  argText = (currAbsArg - 1).toString(16);
                  var buffer = [];
                  for (var i = 0; i < argText.length; i++) {
                    buffer.push((0xF - parseInt(argText[i], 16)).toString(16));
                  }
                  argText = buffer.join('');
                  while (argText.length < argSize * 2) argText = 'f' + argText;
                } else {
                  argText = currAbsArg.toString(16);
                }
                if (next == 88) {
                  prefix = prefix.toUpperCase();
                  argText = argText.toUpperCase();
                }
              } else if (next == 112) {
                if (currAbsArg === 0) {
                  argText = '(nil)';
                } else {
                  prefix = '0x';
                  argText = currAbsArg.toString(16);
                }
              }
              if (precisionSet) {
                while (argText.length < precision) {
                  argText = '0' + argText;
                }
              }
              // Add sign if needed
              if (flagAlwaysSigned) {
                if (currArg < 0) {
                  prefix = '-' + prefix;
                } else {
                  prefix = '+' + prefix;
                }
              }
              // Add padding.
              while (prefix.length + argText.length < width) {
                if (flagLeftAlign) {
                  argText += ' ';
                } else {
                  if (flagZeroPad) {
                    argText = '0' + argText;
                  } else {
                    prefix = ' ' + prefix;
                  }
                }
              }
              // Insert the result into the buffer.
              argText = prefix + argText;
              argText.split('').forEach(function(chr) {
                ret.push(chr.charCodeAt(0));
              });
              break;
            }
            case 'f': case 'F': case 'e': case 'E': case 'g': case 'G': {
              // Float.
              var currArg = getNextArg('double');
              var argText;
              if (isNaN(currArg)) {
                argText = 'nan';
                flagZeroPad = false;
              } else if (!isFinite(currArg)) {
                argText = (currArg < 0 ? '-' : '') + 'inf';
                flagZeroPad = false;
              } else {
                var isGeneral = false;
                var effectivePrecision = Math.min(precision, 20);
                // Convert g/G to f/F or e/E, as per:
                // http://pubs.opengroup.org/onlinepubs/9699919799/functions/printf.html
                if (next == 103 || next == 71) {
                  isGeneral = true;
                  precision = precision || 1;
                  var exponent = parseInt(currArg.toExponential(effectivePrecision).split('e')[1], 10);
                  if (precision > exponent && exponent >= -4) {
                    next = ((next == 103) ? 'f' : 'F').charCodeAt(0);
                    precision -= exponent + 1;
                  } else {
                    next = ((next == 103) ? 'e' : 'E').charCodeAt(0);
                    precision--;
                  }
                  effectivePrecision = Math.min(precision, 20);
                }
                if (next == 101 || next == 69) {
                  argText = currArg.toExponential(effectivePrecision);
                  // Make sure the exponent has at least 2 digits.
                  if (/[eE][-+]\d$/.test(argText)) {
                    argText = argText.slice(0, -1) + '0' + argText.slice(-1);
                  }
                } else if (next == 102 || next == 70) {
                  argText = currArg.toFixed(effectivePrecision);
                  if (currArg === 0 && __reallyNegative(currArg)) {
                    argText = '-' + argText;
                  }
                }
                var parts = argText.split('e');
                if (isGeneral && !flagAlternative) {
                  // Discard trailing zeros and periods.
                  while (parts[0].length > 1 && parts[0].indexOf('.') != -1 &&
                         (parts[0].slice(-1) == '0' || parts[0].slice(-1) == '.')) {
                    parts[0] = parts[0].slice(0, -1);
                  }
                } else {
                  // Make sure we have a period in alternative mode.
                  if (flagAlternative && argText.indexOf('.') == -1) parts[0] += '.';
                  // Zero pad until required precision.
                  while (precision > effectivePrecision++) parts[0] += '0';
                }
                argText = parts[0] + (parts.length > 1 ? 'e' + parts[1] : '');
                // Capitalize 'E' if needed.
                if (next == 69) argText = argText.toUpperCase();
                // Add sign.
                if (flagAlwaysSigned && currArg >= 0) {
                  argText = '+' + argText;
                }
              }
              // Add padding.
              while (argText.length < width) {
                if (flagLeftAlign) {
                  argText += ' ';
                } else {
                  if (flagZeroPad && (argText[0] == '-' || argText[0] == '+')) {
                    argText = argText[0] + '0' + argText.slice(1);
                  } else {
                    argText = (flagZeroPad ? '0' : ' ') + argText;
                  }
                }
              }
              // Adjust case.
              if (next < 97) argText = argText.toUpperCase();
              // Insert the result into the buffer.
              argText.split('').forEach(function(chr) {
                ret.push(chr.charCodeAt(0));
              });
              break;
            }
            case 's': {
              // String.
              var arg = getNextArg('i8*');
              var argLength = arg ? _strlen(arg) : '(null)'.length;
              if (precisionSet) argLength = Math.min(argLength, precision);
              if (!flagLeftAlign) {
                while (argLength < width--) {
                  ret.push(32);
                }
              }
              if (arg) {
                for (var i = 0; i < argLength; i++) {
                  ret.push(HEAPU8[((arg++)|0)]);
                }
              } else {
                ret = ret.concat(intArrayFromString('(null)'.substr(0, argLength), true));
              }
              if (flagLeftAlign) {
                while (argLength < width--) {
                  ret.push(32);
                }
              }
              break;
            }
            case 'c': {
              // Character.
              if (flagLeftAlign) ret.push(getNextArg('i8'));
              while (--width > 0) {
                ret.push(32);
              }
              if (!flagLeftAlign) ret.push(getNextArg('i8'));
              break;
            }
            case 'n': {
              // Write the length written so far to the next parameter.
              var ptr = getNextArg('i32*');
              HEAP32[((ptr)>>2)]=ret.length
              break;
            }
            case '%': {
              // Literal percent sign.
              ret.push(curr);
              break;
            }
            default: {
              // Unknown specifiers remain untouched.
              for (var i = startTextIndex; i < textIndex + 2; i++) {
                ret.push(HEAP8[(i)]);
              }
            }
          }
          textIndex += 2;
          // TODO: Support a/A (hex float) and m (last error) specifiers.
          // TODO: Support %1${specifier} for arg selection.
        } else {
          ret.push(curr);
          textIndex += 1;
        }
      }
      return ret;
    }function _fprintf(stream, format, varargs) {
      // int fprintf(FILE *restrict stream, const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      var result = __formatString(format, varargs);
      var stack = Runtime.stackSave();
      var ret = _fwrite(allocate(result, 'i8', ALLOC_STACK), 1, result.length, stream);
      Runtime.stackRestore(stack);
      return ret;
    }
  Module["_strcpy"] = _strcpy;
  function _strncmp(px, py, n) {
      var i = 0;
      while (i < n) {
        var x = HEAPU8[(((px)+(i))|0)];
        var y = HEAPU8[(((py)+(i))|0)];
        if (x == y && x == 0) return 0;
        if (x == 0) return -1;
        if (y == 0) return 1;
        if (x == y) {
          i ++;
          continue;
        } else {
          return x > y ? 1 : -1;
        }
      }
      return 0;
    }function _strcmp(px, py) {
      return _strncmp(px, py, TOTAL_MEMORY);
    }
  var _exp=Math.exp;
  var _ceil=Math.ceil;
  function _log10(x) {
      return Math.log(x) / Math.LN10;
    }
  function _snprintf(s, n, format, varargs) {
      // int snprintf(char *restrict s, size_t n, const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      var result = __formatString(format, varargs);
      var limit = (n === undefined) ? result.length
                                    : Math.min(result.length, Math.max(n - 1, 0));
      if (s < 0) {
        s = -s;
        var buf = _malloc(limit+1);
        HEAP32[((s)>>2)]=buf;
        s = buf;
      }
      for (var i = 0; i < limit; i++) {
        HEAP8[(((s)+(i))|0)]=result[i];
      }
      if (limit < n || (n === undefined)) HEAP8[(((s)+(i))|0)]=0;
      return result.length;
    }function _sprintf(s, format, varargs) {
      // int sprintf(char *restrict s, const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      return _snprintf(s, undefined, format, varargs);
    }
  Module["_strcat"] = _strcat;
  function _strchr(ptr, chr) {
      ptr--;
      do {
        ptr++;
        var val = HEAP8[(ptr)];
        if (val == chr) return ptr;
      } while (val);
      return 0;
    }
  var _floor=Math.floor;
  var _llvm_pow_f64=Math.pow;
  Module["_memcpy"] = _memcpy;var _llvm_memcpy_p0i8_p0i8_i32=_memcpy;
  Module["_memset"] = _memset;var _llvm_memset_p0i8_i32=_memset;
  function _ftell(stream) {
      // long ftell(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/ftell.html
      if (FS.streams[stream]) {
        stream = FS.streams[stream];
        if (stream.object.isDevice) {
          ___setErrNo(ERRNO_CODES.ESPIPE);
          return -1;
        } else {
          return stream.position;
        }
      } else {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
    }
  function _lseek(fildes, offset, whence) {
      // off_t lseek(int fildes, off_t offset, int whence);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/lseek.html
      if (FS.streams[fildes] && !FS.streams[fildes].object.isDevice) {
        var stream = FS.streams[fildes];
        var position = offset;
        if (whence === 1) {  // SEEK_CUR.
          position += stream.position;
        } else if (whence === 2) {  // SEEK_END.
          position += stream.object.contents.length;
        }
        if (position < 0) {
          ___setErrNo(ERRNO_CODES.EINVAL);
          return -1;
        } else {
          stream.ungotten = [];
          stream.position = position;
          return position;
        }
      } else {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
    }function _fseek(stream, offset, whence) {
      // int fseek(FILE *stream, long offset, int whence);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fseek.html
      var ret = _lseek(stream, offset, whence);
      if (ret == -1) {
        return -1;
      } else {
        FS.streams[stream].eof = false;
        return 0;
      }
    }function _rewind(stream) {
      // void rewind(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/rewind.html
      _fseek(stream, 0, 0);  // SEEK_SET.
      if (FS.streams[stream]) FS.streams[stream].error = false;
    }
  function _recv(fd, buf, len, flags) {
      var info = FS.streams[fd];
      if (!info) return -1;
      if (!info.hasData()) {
        ___setErrNo(ERRNO_CODES.EAGAIN); // no data, and all sockets are nonblocking, so this is the right behavior
        return -1;
      }
      var buffer = info.inQueue.shift();
      if (len < buffer.length) {
        if (info.stream) {
          // This is tcp (reliable), so if not all was read, keep it
          info.inQueue.unshift(buffer.subarray(len));
        }
        buffer = buffer.subarray(0, len);
      }
      HEAPU8.set(buffer, buf);
      return buffer.length;
    }
  function _pread(fildes, buf, nbyte, offset) {
      // ssize_t pread(int fildes, void *buf, size_t nbyte, off_t offset);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/read.html
      var stream = FS.streams[fildes];
      if (!stream || stream.object.isDevice) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      } else if (!stream.isRead) {
        ___setErrNo(ERRNO_CODES.EACCES);
        return -1;
      } else if (stream.object.isFolder) {
        ___setErrNo(ERRNO_CODES.EISDIR);
        return -1;
      } else if (nbyte < 0 || offset < 0) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return -1;
      } else {
        var bytesRead = 0;
        while (stream.ungotten.length && nbyte > 0) {
          HEAP8[((buf++)|0)]=stream.ungotten.pop()
          nbyte--;
          bytesRead++;
        }
        var contents = stream.object.contents;
        var size = Math.min(contents.length - offset, nbyte);
        if (contents.subarray) { // typed array
          HEAPU8.set(contents.subarray(offset, offset+size), buf);
        } else
        if (contents.slice) { // normal array
          for (var i = 0; i < size; i++) {
            HEAP8[(((buf)+(i))|0)]=contents[offset + i]
          }
        } else {
          for (var i = 0; i < size; i++) { // LazyUint8Array from sync binary XHR
            HEAP8[(((buf)+(i))|0)]=contents.get(offset + i)
          }
        }
        bytesRead += size;
        return bytesRead;
      }
    }function _read(fildes, buf, nbyte) {
      // ssize_t read(int fildes, void *buf, size_t nbyte);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/read.html
      var stream = FS.streams[fildes];
      if (stream && ('socket' in stream)) {
        return _recv(fildes, buf, nbyte, 0);
      } else if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      } else if (!stream.isRead) {
        ___setErrNo(ERRNO_CODES.EACCES);
        return -1;
      } else if (nbyte < 0) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return -1;
      } else {
        var bytesRead;
        if (stream.object.isDevice) {
          if (stream.object.input) {
            bytesRead = 0;
            while (stream.ungotten.length && nbyte > 0) {
              HEAP8[((buf++)|0)]=stream.ungotten.pop()
              nbyte--;
              bytesRead++;
            }
            for (var i = 0; i < nbyte; i++) {
              try {
                var result = stream.object.input();
              } catch (e) {
                ___setErrNo(ERRNO_CODES.EIO);
                return -1;
              }
              if (result === undefined && bytesRead === 0) {
                ___setErrNo(ERRNO_CODES.EAGAIN);
                return -1;
              }
              if (result === null || result === undefined) break;
              bytesRead++;
              HEAP8[(((buf)+(i))|0)]=result
            }
            return bytesRead;
          } else {
            ___setErrNo(ERRNO_CODES.ENXIO);
            return -1;
          }
        } else {
          var ungotSize = stream.ungotten.length;
          bytesRead = _pread(fildes, buf, nbyte, stream.position);
          if (bytesRead != -1) {
            stream.position += (stream.ungotten.length - ungotSize) + bytesRead;
          }
          return bytesRead;
        }
      }
    }function _fread(ptr, size, nitems, stream) {
      // size_t fread(void *restrict ptr, size_t size, size_t nitems, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fread.html
      var bytesToRead = nitems * size;
      if (bytesToRead == 0) return 0;
      var bytesRead = _read(stream, ptr, bytesToRead);
      var streamObj = FS.streams[stream];
      if (bytesRead == -1) {
        if (streamObj) streamObj.error = true;
        return 0;
      } else {
        if (bytesRead < bytesToRead) streamObj.eof = true;
        return Math.floor(bytesRead / size);
      }
    }
  function _close(fildes) {
      // int close(int fildes);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/close.html
      if (FS.streams[fildes]) {
        if (FS.streams[fildes].currentEntry) {
          _free(FS.streams[fildes].currentEntry);
        }
        FS.streams[fildes] = null;
        return 0;
      } else {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
    }
  function _fsync(fildes) {
      // int fsync(int fildes);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fsync.html
      if (FS.streams[fildes]) {
        // We write directly to the file system, so there's nothing to do here.
        return 0;
      } else {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
    }function _fclose(stream) {
      // int fclose(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fclose.html
      _fsync(stream);
      return _close(stream);
    }
  function _strcspn(pstr, pset) {
      var str = pstr, set, strcurr, setcurr;
      while (1) {
        strcurr = HEAP8[(str)];
        if (!strcurr) return str - pstr;
        set = pset;
        while (1) {
          setcurr = HEAP8[(set)];
          if (!setcurr || setcurr == strcurr) break;
          set++;
        }
        if (setcurr) return str - pstr;
        str++;
      }
    }
  Module["_strncpy"] = _strncpy;
  function _isspace(chr) {
      return chr in { 32: 0, 9: 0, 10: 0, 11: 0, 12: 0, 13: 0 };
    }function __parseInt(str, endptr, base, min, max, bits, unsign) {
      // Skip space.
      while (_isspace(HEAP8[(str)])) str++;
      // Check for a plus/minus sign.
      var multiplier = 1;
      if (HEAP8[(str)] == 45) {
        multiplier = -1;
        str++;
      } else if (HEAP8[(str)] == 43) {
        str++;
      }
      // Find base.
      var finalBase = base;
      if (!finalBase) {
        if (HEAP8[(str)] == 48) {
          if (HEAP8[((str+1)|0)] == 120 ||
              HEAP8[((str+1)|0)] == 88) {
            finalBase = 16;
            str += 2;
          } else {
            finalBase = 8;
            str++;
          }
        }
      } else if (finalBase==16) {
        if (HEAP8[(str)] == 48) {
          if (HEAP8[((str+1)|0)] == 120 ||
              HEAP8[((str+1)|0)] == 88) {
            str += 2;
          }
        }
      }
      if (!finalBase) finalBase = 10;
      // Get digits.
      var chr;
      var ret = 0;
      while ((chr = HEAP8[(str)]) != 0) {
        var digit = parseInt(String.fromCharCode(chr), finalBase);
        if (isNaN(digit)) {
          break;
        } else {
          ret = ret * finalBase + digit;
          str++;
        }
      }
      // Apply sign.
      ret *= multiplier;
      // Set end pointer.
      if (endptr) {
        HEAP32[((endptr)>>2)]=str
      }
      // Unsign if needed.
      if (unsign) {
        if (Math.abs(ret) > max) {
          ret = max;
          ___setErrNo(ERRNO_CODES.ERANGE);
        } else {
          ret = unSign(ret, bits);
        }
      }
      // Validate range.
      if (ret > max || ret < min) {
        ret = ret > max ? max : min;
        ___setErrNo(ERRNO_CODES.ERANGE);
      }
      if (bits == 64) {
        return ((asm["setTempRet0"](Math.min(Math.floor((ret)/(+(4294967296))), (+(4294967295)))>>>0),ret>>>0)|0);
      }
      return ret;
    }function _strtol(str, endptr, base) {
      return __parseInt(str, endptr, base, -2147483648, 2147483647, 32);  // LONG_MIN, LONG_MAX.
    }function _atoi(ptr) {
      return _strtol(ptr, null, 10);
    }
  function _strstr(ptr1, ptr2) {
      var check = 0, start;
      do {
        if (!check) {
          start = ptr1;
          check = ptr2;
        }
        var curr1 = HEAP8[((ptr1++)|0)];
        var curr2 = HEAP8[((check++)|0)];
        if (curr2 == 0) return start;
        if (curr2 != curr1) {
          // rewind to one character after start, to find ez in eeez
          ptr1 = start + 1;
          check = 0;
        }
      } while (curr1);
      return 0;
    }
  Module["_memcmp"] = _memcmp;
  function _fputs(s, stream) {
      // int fputs(const char *restrict s, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fputs.html
      return _write(stream, s, _strlen(s));
    }
  Module["_memmove"] = _memmove;var _llvm_memmove_p0i8_p0i8_i32=_memmove;
  function _fflush(stream) {
      // int fflush(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fflush.html
      var flush = function(filedes) {
        // Right now we write all data directly, except for output devices.
        if (FS.streams[filedes] && FS.streams[filedes].object.output) {
          if (!FS.streams[filedes].isTerminal) { // don't flush terminals, it would cause a \n to also appear
            FS.streams[filedes].object.output(null);
          }
        }
      };
      try {
        if (stream === 0) {
          for (var i = 0; i < FS.streams.length; i++) if (FS.streams[i]) flush(i);
        } else {
          flush(stream);
        }
        return 0;
      } catch (e) {
        ___setErrNo(ERRNO_CODES.EIO);
        return -1;
      }
    }
  function __exit(status) {
      // void _exit(int status);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/exit.html
      function ExitStatus() {
        this.name = "ExitStatus";
        this.message = "Program terminated with exit(" + status + ")";
        this.status = status;
        Module.print('Exit Status: ' + status);
      };
      ExitStatus.prototype = new Error();
      ExitStatus.prototype.constructor = ExitStatus;
      exitRuntime();
      ABORT = true;
      throw new ExitStatus();
    }function _exit(status) {
      __exit(status);
    }
  function _fgetc(stream) {
      // int fgetc(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fgetc.html
      if (!FS.streams[stream]) return -1;
      var streamObj = FS.streams[stream];
      if (streamObj.eof || streamObj.error) return -1;
      var ret = _read(stream, _fgetc.ret, 1);
      if (ret == 0) {
        streamObj.eof = true;
        return -1;
      } else if (ret == -1) {
        streamObj.error = true;
        return -1;
      } else {
        return HEAPU8[((_fgetc.ret)|0)];
      }
    }function _fgets(s, n, stream) {
      // char *fgets(char *restrict s, int n, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fgets.html
      if (!FS.streams[stream]) return 0;
      var streamObj = FS.streams[stream];
      if (streamObj.error || streamObj.eof) return 0;
      var byte_;
      for (var i = 0; i < n - 1 && byte_ != 10; i++) {
        byte_ = _fgetc(stream);
        if (byte_ == -1) {
          if (streamObj.error || (streamObj.eof && i == 0)) return 0;
          else if (streamObj.eof) break;
        }
        HEAP8[(((s)+(i))|0)]=byte_
      }
      HEAP8[(((s)+(i))|0)]=0
      return s;
    }
  function _usleep(useconds) {
      // int usleep(useconds_t useconds);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/usleep.html
      // We're single-threaded, so use a busy loop. Super-ugly.
      var msec = useconds / 1000;
      var start = Date.now();
      while (Date.now() - start < msec) {
        // Do nothing.
      }
      return 0;
    }
  function _fputc(c, stream) {
      // int fputc(int c, FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fputc.html
      var chr = unSign(c & 0xFF);
      HEAP8[((_fputc.ret)|0)]=chr
      var ret = _write(stream, _fputc.ret, 1);
      if (ret == -1) {
        if (FS.streams[stream]) FS.streams[stream].error = true;
        return -1;
      } else {
        return chr;
      }
    }
  function _pclose(stream) {
      // int pclose(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/pclose.html
      // We allow only one process, so no pipes.
      ___setErrNo(ERRNO_CODES.ECHILD);
      return -1;
    }
  function _puts(s) {
      // int puts(const char *s);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/puts.html
      // NOTE: puts() always writes an extra newline.
      var stdout = HEAP32[((_stdout)>>2)];
      var ret = _fputs(s, stdout);
      if (ret < 0) {
        return ret;
      } else {
        var newlineRet = _fputc(10, stdout);
        return (newlineRet < 0) ? -1 : ret + 1;
      }
    }
  var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"No message of desired type",36:"Identifier removed",37:"Channel number out of range",38:"Level 2 not synchronized",39:"Level 3 halted",40:"Level 3 reset",41:"Link number out of range",42:"Protocol driver not attached",43:"No CSI structure available",44:"Level 2 halted",45:"Deadlock condition",46:"No record locks available",50:"Invalid exchange",51:"Invalid request descriptor",52:"Exchange full",53:"No anode",54:"Invalid request code",55:"Invalid slot",56:"File locking deadlock error",57:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",74:"Multihop attempted",75:"Inode is remote (not really error)",76:"Cross mount point (not really error)",77:"Trying to read unreadable message",79:"Inappropriate file type or format",80:"Given log. name not unique",81:"f.d. invalid for this operation",82:"Remote address changed",83:"Can\t access a needed shared lib",84:"Accessing a corrupted shared lib",85:".lib section in a.out corrupted",86:"Attempting to link in too many libs",87:"Attempting to exec a shared library",88:"Function not implemented",89:"No more files",90:"Directory not empty",91:"File or path name too long",92:"Too many symbolic links",95:"Operation not supported on transport endpoint",96:"Protocol family not supported",104:"Connection reset by peer",105:"No buffer space available",106:"Address family not supported by protocol family",107:"Protocol wrong type for socket",108:"Socket operation on non-socket",109:"Protocol not available",110:"Can't send after socket shutdown",111:"Connection refused",112:"Address already in use",113:"Connection aborted",114:"Network is unreachable",115:"Network interface is not configured",116:"Connection timed out",117:"Host is down",118:"Host is unreachable",119:"Connection already in progress",120:"Socket already connected",121:"Destination address required",122:"Message too long",123:"Unknown protocol",124:"Socket type not supported",125:"Address not available",126:"ENETRESET",127:"Socket is already connected",128:"Socket is not connected",129:"TOOMANYREFS",130:"EPROCLIM",131:"EUSERS",132:"EDQUOT",133:"ESTALE",134:"Not supported",135:"No medium (in tape drive)",136:"No such host or network path",137:"Filename exists with different case",138:"EILSEQ",139:"Value too large for defined data type",140:"Operation canceled",141:"State not recoverable",142:"Previous owner died",143:"Streams pipe error"};function _strerror_r(errnum, strerrbuf, buflen) {
      if (errnum in ERRNO_MESSAGES) {
        if (ERRNO_MESSAGES[errnum].length > buflen - 1) {
          return ___setErrNo(ERRNO_CODES.ERANGE);
        } else {
          var msg = ERRNO_MESSAGES[errnum];
          for (var i = 0; i < msg.length; i++) {
            HEAP8[(((strerrbuf)+(i))|0)]=msg.charCodeAt(i)
          }
          HEAP8[(((strerrbuf)+(i))|0)]=0
          return 0;
        }
      } else {
        return ___setErrNo(ERRNO_CODES.EINVAL);
      }
    }function _strerror(errnum) {
      if (!_strerror.buffer) _strerror.buffer = _malloc(256);
      _strerror_r(errnum, _strerror.buffer, 256);
      return _strerror.buffer;
    }
  function ___errno_location() {
      return ___errno_state;
    }function _perror(s) {
      // void perror(const char *s);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/perror.html
      var stdout = HEAP32[((_stdout)>>2)];
      if (s) {
        _fputs(s, stdout);
        _fputc(58, stdout);
        _fputc(32, stdout);
      }
      var errnum = HEAP32[((___errno_location())>>2)];
      _puts(_strerror(errnum));
    }
  function _popen(command, mode) {
      // FILE *popen(const char *command, const char *mode);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/popen.html
      // We allow only one process, so no pipes.
      ___setErrNo(ERRNO_CODES.EMFILE);
      return 0;
    }
  var ___dirent_struct_layout={__size__:1040,d_ino:0,d_name:4,d_off:1028,d_reclen:1032,d_type:1036};function _open(path, oflag, varargs) {
      // int open(const char *path, int oflag, ...);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/open.html
      // NOTE: This implementation tries to mimic glibc rather than strictly
      // following the POSIX standard.
      var mode = HEAP32[((varargs)>>2)];
      // Simplify flags.
      var accessMode = oflag & 3;
      var isWrite = accessMode != 0;
      var isRead = accessMode != 1;
      var isCreate = Boolean(oflag & 512);
      var isExistCheck = Boolean(oflag & 2048);
      var isTruncate = Boolean(oflag & 1024);
      var isAppend = Boolean(oflag & 8);
      // Verify path.
      var origPath = path;
      path = FS.analyzePath(Pointer_stringify(path));
      if (!path.parentExists) {
        ___setErrNo(path.error);
        return -1;
      }
      var target = path.object || null;
      var finalPath;
      // Verify the file exists, create if needed and allowed.
      if (target) {
        if (isCreate && isExistCheck) {
          ___setErrNo(ERRNO_CODES.EEXIST);
          return -1;
        }
        if ((isWrite || isCreate || isTruncate) && target.isFolder) {
          ___setErrNo(ERRNO_CODES.EISDIR);
          return -1;
        }
        if (isRead && !target.read || isWrite && !target.write) {
          ___setErrNo(ERRNO_CODES.EACCES);
          return -1;
        }
        if (isTruncate && !target.isDevice) {
          target.contents = [];
        } else {
          if (!FS.forceLoadFile(target)) {
            ___setErrNo(ERRNO_CODES.EIO);
            return -1;
          }
        }
        finalPath = path.path;
      } else {
        if (!isCreate) {
          ___setErrNo(ERRNO_CODES.ENOENT);
          return -1;
        }
        if (!path.parentObject.write) {
          ___setErrNo(ERRNO_CODES.EACCES);
          return -1;
        }
        target = FS.createDataFile(path.parentObject, path.name, [],
                                   mode & 0x100, mode & 0x80);  // S_IRUSR, S_IWUSR.
        finalPath = path.parentPath + '/' + path.name;
      }
      // Actually create an open stream.
      var id;
      if (target.isFolder) {
        var entryBuffer = 0;
        if (___dirent_struct_layout) {
          entryBuffer = _malloc(___dirent_struct_layout.__size__);
        }
        var contents = [];
        for (var key in target.contents) contents.push(key);
        id = FS.createFileHandle({
          path: finalPath,
          object: target,
          // An index into contents. Special values: -2 is ".", -1 is "..".
          position: -2,
          isRead: true,
          isWrite: false,
          isAppend: false,
          error: false,
          eof: false,
          ungotten: [],
          // Folder-specific properties:
          // Remember the contents at the time of opening in an array, so we can
          // seek between them relying on a single order.
          contents: contents,
          // Each stream has its own area for readdir() returns.
          currentEntry: entryBuffer
        });
      } else {
        id = FS.createFileHandle({
          path: finalPath,
          object: target,
          position: 0,
          isRead: isRead,
          isWrite: isWrite,
          isAppend: isAppend,
          error: false,
          eof: false,
          ungotten: []
        });
      }
      return id;
    }function _fopen(filename, mode) {
      // FILE *fopen(const char *restrict filename, const char *restrict mode);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fopen.html
      var flags;
      mode = Pointer_stringify(mode);
      if (mode[0] == 'r') {
        if (mode.indexOf('+') != -1) {
          flags = 2;
        } else {
          flags = 0;
        }
      } else if (mode[0] == 'w') {
        if (mode.indexOf('+') != -1) {
          flags = 2;
        } else {
          flags = 1;
        }
        flags |= 512;
        flags |= 1024;
      } else if (mode[0] == 'a') {
        if (mode.indexOf('+') != -1) {
          flags = 2;
        } else {
          flags = 1;
        }
        flags |= 512;
        flags |= 8;
      } else {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return 0;
      }
      var ret = _open(filename, flags, allocate([0x1FF, 0, 0, 0], 'i32', ALLOC_STACK));  // All creation permissions.
      return (ret == -1) ? 0 : ret;
    }
  var _putc=_fputc;
  function _getcwd(buf, size) {
      // char *getcwd(char *buf, size_t size);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/getcwd.html
      if (size == 0) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return 0;
      } else if (size < FS.currentPath.length + 1) {
        ___setErrNo(ERRNO_CODES.ERANGE);
        return 0;
      } else {
        for (var i = 0; i < FS.currentPath.length; i++) {
          HEAP8[(((buf)+(i))|0)]=FS.currentPath.charCodeAt(i)
        }
        HEAP8[(((buf)+(i))|0)]=0
        return buf;
      }
    }
  var _environ=allocate(1, "i32*", ALLOC_STATIC);var ___environ=_environ;function ___buildEnvironment(env) {
      // WARNING: Arbitrary limit!
      var MAX_ENV_VALUES = 64;
      var TOTAL_ENV_SIZE = 1024;
      // Statically allocate memory for the environment.
      var poolPtr;
      var envPtr;
      if (!___buildEnvironment.called) {
        ___buildEnvironment.called = true;
        // Set default values. Use string keys for Closure Compiler compatibility.
        ENV['USER'] = 'root';
        ENV['PATH'] = '/';
        ENV['PWD'] = '/';
        ENV['HOME'] = '/home/emscripten';
        ENV['LANG'] = 'en_US.UTF-8';
        ENV['_'] = './this.program';
        // Allocate memory.
        poolPtr = allocate(TOTAL_ENV_SIZE, 'i8', ALLOC_STATIC);
        envPtr = allocate(MAX_ENV_VALUES * 4,
                          'i8*', ALLOC_STATIC);
        HEAP32[((envPtr)>>2)]=poolPtr
        HEAP32[((_environ)>>2)]=envPtr;
      } else {
        envPtr = HEAP32[((_environ)>>2)];
        poolPtr = HEAP32[((envPtr)>>2)];
      }
      // Collect key=value lines.
      var strings = [];
      var totalSize = 0;
      for (var key in env) {
        if (typeof env[key] === 'string') {
          var line = key + '=' + env[key];
          strings.push(line);
          totalSize += line.length;
        }
      }
      if (totalSize > TOTAL_ENV_SIZE) {
        throw new Error('Environment size exceeded TOTAL_ENV_SIZE!');
      }
      // Make new.
      var ptrSize = 4;
      for (var i = 0; i < strings.length; i++) {
        var line = strings[i];
        for (var j = 0; j < line.length; j++) {
          HEAP8[(((poolPtr)+(j))|0)]=line.charCodeAt(j);
        }
        HEAP8[(((poolPtr)+(j))|0)]=0;
        HEAP32[(((envPtr)+(i * ptrSize))>>2)]=poolPtr;
        poolPtr += line.length + 1;
      }
      HEAP32[(((envPtr)+(strings.length * ptrSize))>>2)]=0;
    }var ENV={};function _getenv(name) {
      // char *getenv(const char *name);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/getenv.html
      if (name === 0) return 0;
      name = Pointer_stringify(name);
      if (!ENV.hasOwnProperty(name)) return 0;
      if (_getenv.ret) _free(_getenv.ret);
      _getenv.ret = allocate(intArrayFromString(ENV[name]), 'i8', ALLOC_NORMAL);
      return _getenv.ret;
    }
  function _strncat(pdest, psrc, num) {
      var len = _strlen(pdest);
      var i = 0;
      while(1) {
        HEAP8[((pdest+len+i)|0)]=HEAP8[((psrc+i)|0)];
        if (HEAP8[(((pdest)+(len+i))|0)] == 0) break;
        i ++;
        if (i == num) {
          HEAP8[(((pdest)+(len+i))|0)]=0
          break;
        }
      }
      return pdest;
    }
  function _printf(format, varargs) {
      // int printf(const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      var stdout = HEAP32[((_stdout)>>2)];
      return _fprintf(stdout, format, varargs);
    }
  function _system(command) {
      // int system(const char *command);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/system.html
      // Can't call external programs.
      ___setErrNo(ERRNO_CODES.EAGAIN);
      return -1;
    }
  function _isalpha(chr) {
      return (chr >= 97 && chr <= 122) ||
             (chr >= 65 && chr <= 90);
    }
  function _isalnum(chr) {
      return (chr >= 48 && chr <= 57) ||
             (chr >= 97 && chr <= 122) ||
             (chr >= 65 && chr <= 90);
    }
  var _getc=_fgetc;
  function _chdir(path) {
      // int chdir(const char *path);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/chdir.html
      // NOTE: The path argument may be a string, to simplify fchdir().
      if (typeof path !== 'string') path = Pointer_stringify(path);
      path = FS.analyzePath(path);
      if (!path.exists) {
        ___setErrNo(path.error);
        return -1;
      } else if (!path.object.isFolder) {
        ___setErrNo(ERRNO_CODES.ENOTDIR);
        return -1;
      } else {
        FS.currentPath = path.path;
        return 0;
      }
    }
  function _tmpnam(s, dir, prefix) {
      // char *tmpnam(char *s);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/tmpnam.html
      // NOTE: The dir and prefix arguments are for internal use only.
      var folder = FS.findObject(dir || '/tmp');
      if (!folder || !folder.isFolder) {
        dir = '/tmp';
        folder = FS.findObject(dir);
        if (!folder || !folder.isFolder) return 0;
      }
      var name = prefix || 'file';
      do {
        name += String.fromCharCode(65 + Math.floor(Math.random() * 25));
      } while (name in folder.contents);
      var result = dir + '/' + name;
      if (!_tmpnam.buffer) _tmpnam.buffer = _malloc(256);
      if (!s) s = _tmpnam.buffer;
      for (var i = 0; i < result.length; i++) {
        HEAP8[(((s)+(i))|0)]=result.charCodeAt(i);
      }
      HEAP8[(((s)+(i))|0)]=0;
      return s;
    }function _tmpfile() {
      // FILE *tmpfile(void);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/tmpfile.html
      // TODO: Delete the created file on closing.
      if (_tmpfile.mode) {
        _tmpfile.mode = allocate(intArrayFromString('w+'), 'i8', ALLOC_NORMAL);
      }
      return _fopen(_tmpnam(0), _tmpfile.mode);
    }
  function _memchr(ptr, chr, num) {
      chr = unSign(chr);
      for (var i = 0; i < num; i++) {
        if (HEAP8[(ptr)] == chr) return ptr;
        ptr++;
      }
      return 0;
    }
  var _sqrt=Math.sqrt;
  function _fileno(stream) {
      // int fileno(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fileno.html
      // We use file descriptor numbers and FILE* streams interchangeably.
      return stream;
    }
  function _fdopen(fildes, mode) {
      // FILE *fdopen(int fildes, const char *mode);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fdopen.html
      if (FS.streams[fildes]) {
        var stream = FS.streams[fildes];
        mode = Pointer_stringify(mode);
        if ((mode.indexOf('w') != -1 && !stream.isWrite) ||
            (mode.indexOf('r') != -1 && !stream.isRead) ||
            (mode.indexOf('a') != -1 && !stream.isAppend) ||
            (mode.indexOf('+') != -1 && (!stream.isRead || !stream.isWrite))) {
          ___setErrNo(ERRNO_CODES.EINVAL);
          return 0;
        } else {
          stream.error = false;
          stream.eof = false;
          return fildes;
        }
      } else {
        ___setErrNo(ERRNO_CODES.EBADF);
        return 0;
      }
    }
  var ___stat_struct_layout={__size__:68,st_dev:0,st_ino:4,st_mode:8,st_nlink:12,st_uid:16,st_gid:20,st_rdev:24,st_size:28,st_atime:32,st_spare1:36,st_mtime:40,st_spare2:44,st_ctime:48,st_spare3:52,st_blksize:56,st_blocks:60,st_spare4:64};function _stat(path, buf, dontResolveLastLink) {
      // http://pubs.opengroup.org/onlinepubs/7908799/xsh/stat.html
      // int stat(const char *path, struct stat *buf);
      // NOTE: dontResolveLastLink is a shortcut for lstat(). It should never be
      //       used in client code.
      var obj = FS.findObject(Pointer_stringify(path), dontResolveLastLink);
      if (obj === null || !FS.forceLoadFile(obj)) return -1;
      var offsets = ___stat_struct_layout;
      // Constants.
      HEAP32[(((buf)+(offsets.st_nlink))>>2)]=1
      HEAP32[(((buf)+(offsets.st_uid))>>2)]=0
      HEAP32[(((buf)+(offsets.st_gid))>>2)]=0
      HEAP32[(((buf)+(offsets.st_blksize))>>2)]=4096
      // Variables.
      HEAP32[(((buf)+(offsets.st_ino))>>2)]=obj.inodeNumber
      var time = Math.floor(obj.timestamp / 1000);
      if (offsets.st_atime === undefined) {
        offsets.st_atime = offsets.st_atim.tv_sec;
        offsets.st_mtime = offsets.st_mtim.tv_sec;
        offsets.st_ctime = offsets.st_ctim.tv_sec;
        var nanosec = (obj.timestamp % 1000) * 1000;
        HEAP32[(((buf)+(offsets.st_atim.tv_nsec))>>2)]=nanosec
        HEAP32[(((buf)+(offsets.st_mtim.tv_nsec))>>2)]=nanosec
        HEAP32[(((buf)+(offsets.st_ctim.tv_nsec))>>2)]=nanosec
      }
      HEAP32[(((buf)+(offsets.st_atime))>>2)]=time
      HEAP32[(((buf)+(offsets.st_mtime))>>2)]=time
      HEAP32[(((buf)+(offsets.st_ctime))>>2)]=time
      var mode = 0;
      var size = 0;
      var blocks = 0;
      var dev = 0;
      var rdev = 0;
      if (obj.isDevice) {
        //  Device numbers reuse inode numbers.
        dev = rdev = obj.inodeNumber;
        size = blocks = 0;
        mode = 0x2000;  // S_IFCHR.
      } else {
        dev = 1;
        rdev = 0;
        // NOTE: In our implementation, st_blocks = Math.ceil(st_size/st_blksize),
        //       but this is not required by the standard.
        if (obj.isFolder) {
          size = 4096;
          blocks = 1;
          mode = 0x4000;  // S_IFDIR.
        } else {
          var data = obj.contents || obj.link;
          size = data.length;
          blocks = Math.ceil(data.length / 4096);
          mode = obj.link === undefined ? 0x8000 : 0xA000;  // S_IFREG, S_IFLNK.
        }
      }
      HEAP32[(((buf)+(offsets.st_dev))>>2)]=dev;
      HEAP32[(((buf)+(offsets.st_rdev))>>2)]=rdev;
      HEAP32[(((buf)+(offsets.st_size))>>2)]=size
      HEAP32[(((buf)+(offsets.st_blocks))>>2)]=blocks
      if (obj.read) mode |= 0x16D;  // S_IRUSR | S_IXUSR | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH.
      if (obj.write) mode |= 0x92;  // S_IWUSR | S_IWGRP | S_IWOTH.
      HEAP32[(((buf)+(offsets.st_mode))>>2)]=mode
      return 0;
    }
  function _feof(stream) {
      // int feof(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/feof.html
      return Number(FS.streams[stream] && FS.streams[stream].eof);
    }
  function _setlocale(category, locale) {
      if (!_setlocale.ret) _setlocale.ret = allocate([0], 'i8', ALLOC_NORMAL);
      return _setlocale.ret;
    }
  function ___fpclassifyf(x) {
      if (isNaN(x)) return 0;
      if (!isFinite(x)) return 1;
      if (x == 0) return 2;
      // FP_SUBNORMAL..?
      return 4;
    }var ___fpclassifyd=___fpclassifyf;
  var _cos=Math.cos;
  var _sin=Math.sin;
  Module["_tolower"] = _tolower;
  Module["_strncasecmp"] = _strncasecmp;
  Module["_strcasecmp"] = _strcasecmp;
  function _strrchr(ptr, chr) {
      var ptr2 = ptr + _strlen(ptr);
      do {
        if (HEAP8[(ptr2)] == chr) return ptr2;
        ptr2--;
      } while (ptr2 >= ptr);
      return 0;
    }
  function _strspn(pstr, pset) {
      var str = pstr, set, strcurr, setcurr;
      while (1) {
        strcurr = HEAP8[(str)];
        if (!strcurr) return str - pstr;
        set = pset;
        while (1) {
          setcurr = HEAP8[(set)];
          if (!setcurr || setcurr == strcurr) break;
          set++;
        }
        if (!setcurr) return str - pstr;
        str++;
      }
    }
  function _strpbrk(ptr1, ptr2) {
      var curr;
      var searchSet = {};
      while (1) {
        var curr = HEAP8[((ptr2++)|0)];
        if (!curr) break;
        searchSet[curr] = 1;
      }
      while (1) {
        curr = HEAP8[(ptr1)];
        if (!curr) break;
        if (curr in searchSet) return ptr1;
        ptr1++;
      }
      return 0;
    }
  function __isFloat(text) {
      return !!(/^[+-]?[0-9]*\.?[0-9]+([eE][+-]?[0-9]+)?$/.exec(text));
    }function __scanString(format, get, unget, varargs) {
      if (!__scanString.whiteSpace) {
        __scanString.whiteSpace = {};
        __scanString.whiteSpace[32] = 1;
        __scanString.whiteSpace[9] = 1;
        __scanString.whiteSpace[10] = 1;
        __scanString.whiteSpace[11] = 1;
        __scanString.whiteSpace[12] = 1;
        __scanString.whiteSpace[13] = 1;
        __scanString.whiteSpace[' '] = 1;
        __scanString.whiteSpace['\t'] = 1;
        __scanString.whiteSpace['\n'] = 1;
        __scanString.whiteSpace['\v'] = 1;
        __scanString.whiteSpace['\f'] = 1;
        __scanString.whiteSpace['\r'] = 1;
      }
      // Supports %x, %4x, %d.%d, %lld, %s, %f, %lf.
      // TODO: Support all format specifiers.
      format = Pointer_stringify(format);
      var soFar = 0;
      if (format.indexOf('%n') >= 0) {
        // need to track soFar
        var _get = get;
        get = function() {
          soFar++;
          return _get();
        }
        var _unget = unget;
        unget = function() {
          soFar--;
          return _unget();
        }
      }
      var formatIndex = 0;
      var argsi = 0;
      var fields = 0;
      var argIndex = 0;
      var next;
      mainLoop:
      for (var formatIndex = 0; formatIndex < format.length;) {
        if (format[formatIndex] === '%' && format[formatIndex+1] == 'n') {
          var argPtr = HEAP32[(((varargs)+(argIndex))>>2)];
          argIndex += Runtime.getAlignSize('void*', null, true);
          HEAP32[((argPtr)>>2)]=soFar;
          formatIndex += 2;
          continue;
        }
        // TODO: Support strings like "%5c" etc.
        if (format[formatIndex] === '%' && format[formatIndex+1] == 'c') {
          var argPtr = HEAP32[(((varargs)+(argIndex))>>2)];
          argIndex += Runtime.getAlignSize('void*', null, true);
          fields++;
          next = get();
          HEAP8[(argPtr)]=next
          formatIndex += 2;
          continue;
        }
        // remove whitespace
        while (1) {
          next = get();
          if (next == 0) return fields;
          if (!(next in __scanString.whiteSpace)) break;
        }
        unget();
        if (format[formatIndex] === '%') {
          formatIndex++;
          var suppressAssignment = false;
          if (format[formatIndex] == '*') {
            suppressAssignment = true;
            formatIndex++;
          }
          var maxSpecifierStart = formatIndex;
          while (format[formatIndex].charCodeAt(0) >= 48 &&
                 format[formatIndex].charCodeAt(0) <= 57) {
            formatIndex++;
          }
          var max_;
          if (formatIndex != maxSpecifierStart) {
            max_ = parseInt(format.slice(maxSpecifierStart, formatIndex), 10);
          }
          var long_ = false;
          var half = false;
          var longLong = false;
          if (format[formatIndex] == 'l') {
            long_ = true;
            formatIndex++;
            if (format[formatIndex] == 'l') {
              longLong = true;
              formatIndex++;
            }
          } else if (format[formatIndex] == 'h') {
            half = true;
            formatIndex++;
          }
          var type = format[formatIndex];
          formatIndex++;
          var curr = 0;
          var buffer = [];
          // Read characters according to the format. floats are trickier, they may be in an unfloat state in the middle, then be a valid float later
          if (type == 'f' || type == 'e' || type == 'g' ||
              type == 'F' || type == 'E' || type == 'G') {
            var last = 0;
            next = get();
            while (next > 0) {
              buffer.push(String.fromCharCode(next));
              if (__isFloat(buffer.join(''))) {
                last = buffer.length;
              }
              next = get();
            }
            for (var i = 0; i < buffer.length - last + 1; i++) {
              unget();
            }
            buffer.length = last;
          } else {
            next = get();
            var first = true;
            while ((curr < max_ || isNaN(max_)) && next > 0) {
              if (!(next in __scanString.whiteSpace) && // stop on whitespace
                  (type == 's' ||
                   ((type === 'd' || type == 'u' || type == 'i') && ((next >= 48 && next <= 57) ||
                                                                     (first && next == 45))) ||
                   ((type === 'x' || type === 'X') && (next >= 48 && next <= 57 ||
                                     next >= 97 && next <= 102 ||
                                     next >= 65 && next <= 70))) &&
                  (formatIndex >= format.length || next !== format[formatIndex].charCodeAt(0))) { // Stop when we read something that is coming up
                buffer.push(String.fromCharCode(next));
                next = get();
                curr++;
                first = false;
              } else {
                break;
              }
            }
            unget();
          }
          if (buffer.length === 0) return 0;  // Failure.
          if (suppressAssignment) continue;
          var text = buffer.join('');
          var argPtr = HEAP32[(((varargs)+(argIndex))>>2)];
          argIndex += Runtime.getAlignSize('void*', null, true);
          switch (type) {
            case 'd': case 'u': case 'i':
              if (half) {
                HEAP16[((argPtr)>>1)]=parseInt(text, 10);
              } else if (longLong) {
                (tempI64 = [parseInt(text, 10)>>>0,Math.min(Math.floor((parseInt(text, 10))/(+(4294967296))), (+(4294967295)))>>>0],HEAP32[((argPtr)>>2)]=tempI64[0],HEAP32[(((argPtr)+(4))>>2)]=tempI64[1]);
              } else {
                HEAP32[((argPtr)>>2)]=parseInt(text, 10);
              }
              break;
            case 'X':
            case 'x':
              HEAP32[((argPtr)>>2)]=parseInt(text, 16)
              break;
            case 'F':
            case 'f':
            case 'E':
            case 'e':
            case 'G':
            case 'g':
            case 'E':
              // fallthrough intended
              if (long_) {
                HEAPF64[((argPtr)>>3)]=parseFloat(text)
              } else {
                HEAPF32[((argPtr)>>2)]=parseFloat(text)
              }
              break;
            case 's':
              var array = intArrayFromString(text);
              for (var j = 0; j < array.length; j++) {
                HEAP8[(((argPtr)+(j))|0)]=array[j]
              }
              break;
          }
          fields++;
        } else if (format[formatIndex] in __scanString.whiteSpace) {
          next = get();
          while (next in __scanString.whiteSpace) {
            if (next <= 0) break mainLoop;  // End of input.
            next = get();
          }
          unget(next);
          formatIndex++;
        } else {
          // Not a specifier.
          next = get();
          if (format[formatIndex].charCodeAt(0) !== next) {
            unget(next);
            break mainLoop;
          }
          formatIndex++;
        }
      }
      return fields;
    }function _sscanf(s, format, varargs) {
      // int sscanf(const char *restrict s, const char *restrict format, ... );
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/scanf.html
      var index = 0;
      var get = function() { return HEAP8[(((s)+(index++))|0)]; };
      var unget = function() { index--; };
      return __scanString(format, get, unget, varargs);
    }
  var _atan2=Math.atan2;
  var ___errno=___errno_location;
  function _putchar(c) {
      // int putchar(int c);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/putchar.html
      return _fputc(c, HEAP32[((_stdout)>>2)]);
    }
  Module["_saveSetjmp"] = _saveSetjmp;
  Module["_testSetjmp"] = _testSetjmp;var _setjmp=undefined;
  function _signal(sig, func) {
      // TODO
      return 0;
    }
  function _toupper(chr) {
      if (chr >= 97 && chr <= 122) {
        return chr - 97 + 65;
      } else {
        return chr;
      }
    }
  function _longjmp(env, value) {
      asm['setThrew'](env, value || 1);
      throw 'longjmp';
    }
  function _time(ptr) {
      var ret = Math.floor(Date.now()/1000);
      if (ptr) {
        HEAP32[((ptr)>>2)]=ret
      }
      return ret;
    }
  var ___tm_struct_layout={__size__:44,tm_sec:0,tm_min:4,tm_hour:8,tm_mday:12,tm_mon:16,tm_year:20,tm_wday:24,tm_yday:28,tm_isdst:32,tm_gmtoff:36,tm_zone:40};
  var ___tm_current=allocate(4*26, "i8", ALLOC_STATIC);
  var ___tm_timezones={};
  var __tzname=allocate(8, "i32*", ALLOC_STATIC);
  var __daylight=allocate(1, "i32*", ALLOC_STATIC);
  var __timezone=allocate(1, "i32*", ALLOC_STATIC);function _tzset() {
      // TODO: Use (malleable) environment variables instead of system settings.
      if (_tzset.called) return;
      _tzset.called = true;
      HEAP32[((__timezone)>>2)]=-(new Date()).getTimezoneOffset() * 60
      var winter = new Date(2000, 0, 1);
      var summer = new Date(2000, 6, 1);
      HEAP32[((__daylight)>>2)]=Number(winter.getTimezoneOffset() != summer.getTimezoneOffset())
      var winterName = 'GMT'; // XXX do not rely on browser timezone info, it is very unpredictable | winter.toString().match(/\(([A-Z]+)\)/)[1];
      var summerName = 'GMT'; // XXX do not rely on browser timezone info, it is very unpredictable | summer.toString().match(/\(([A-Z]+)\)/)[1];
      var winterNamePtr = allocate(intArrayFromString(winterName), 'i8', ALLOC_NORMAL);
      var summerNamePtr = allocate(intArrayFromString(summerName), 'i8', ALLOC_NORMAL);
      HEAP32[((__tzname)>>2)]=winterNamePtr
      HEAP32[(((__tzname)+(4))>>2)]=summerNamePtr
    }function _localtime_r(time, tmPtr) {
      _tzset();
      var offsets = ___tm_struct_layout;
      var date = new Date(HEAP32[((time)>>2)]*1000);
      HEAP32[(((tmPtr)+(offsets.tm_sec))>>2)]=date.getSeconds()
      HEAP32[(((tmPtr)+(offsets.tm_min))>>2)]=date.getMinutes()
      HEAP32[(((tmPtr)+(offsets.tm_hour))>>2)]=date.getHours()
      HEAP32[(((tmPtr)+(offsets.tm_mday))>>2)]=date.getDate()
      HEAP32[(((tmPtr)+(offsets.tm_mon))>>2)]=date.getMonth()
      HEAP32[(((tmPtr)+(offsets.tm_year))>>2)]=date.getFullYear()-1900
      HEAP32[(((tmPtr)+(offsets.tm_wday))>>2)]=date.getDay()
      var start = new Date(date.getFullYear(), 0, 1);
      var yday = Math.floor((date.getTime() - start.getTime()) / (1000 * 60 * 60 * 24));
      HEAP32[(((tmPtr)+(offsets.tm_yday))>>2)]=yday
      HEAP32[(((tmPtr)+(offsets.tm_gmtoff))>>2)]=start.getTimezoneOffset() * 60
      var dst = Number(start.getTimezoneOffset() != date.getTimezoneOffset());
      HEAP32[(((tmPtr)+(offsets.tm_isdst))>>2)]=dst
      var timezone = 'GMT'; // XXX do not rely on browser timezone info, it is very unpredictable | date.toString().match(/\(([A-Z]+)\)/)[1];
      if (!(timezone in ___tm_timezones)) {
        ___tm_timezones[timezone] = allocate(intArrayFromString(timezone), 'i8', ALLOC_NORMAL);
      }
      HEAP32[(((tmPtr)+(offsets.tm_zone))>>2)]=___tm_timezones[timezone]
      return tmPtr;
    }function _localtime(time) {
      return _localtime_r(time, ___tm_current);
    }
  var ___tm_formatted=allocate(4*26, "i8", ALLOC_STATIC);
  function _mktime(tmPtr) {
      _tzset();
      var offsets = ___tm_struct_layout;
      var year = HEAP32[(((tmPtr)+(offsets.tm_year))>>2)];
      var timestamp = new Date(year >= 1900 ? year : year + 1900,
                               HEAP32[(((tmPtr)+(offsets.tm_mon))>>2)],
                               HEAP32[(((tmPtr)+(offsets.tm_mday))>>2)],
                               HEAP32[(((tmPtr)+(offsets.tm_hour))>>2)],
                               HEAP32[(((tmPtr)+(offsets.tm_min))>>2)],
                               HEAP32[(((tmPtr)+(offsets.tm_sec))>>2)],
                               0).getTime() / 1000;
      HEAP32[(((tmPtr)+(offsets.tm_wday))>>2)]=new Date(timestamp).getDay()
      var yday = Math.round((timestamp - (new Date(year, 0, 1)).getTime()) / (1000 * 60 * 60 * 24));
      HEAP32[(((tmPtr)+(offsets.tm_yday))>>2)]=yday
      return timestamp;
    }function _asctime_r(tmPtr, buf) {
      var date = new Date(_mktime(tmPtr)*1000);
      var formatted = date.toString();
      var datePart = formatted.replace(/\d{4}.*/, '').replace(/ 0/, '  ');
      var timePart = formatted.match(/\d{2}:\d{2}:\d{2}/)[0];
      formatted = datePart + timePart + ' ' + date.getFullYear() + '\n';
      formatted.split('').forEach(function(chr, index) {
        HEAP8[(((buf)+(index))|0)]=chr.charCodeAt(0)
      });
      HEAP8[(((buf)+(25))|0)]=0
      return buf;
    }function _asctime(tmPtr) {
      return _asctime_r(tmPtr, ___tm_formatted);
    }function _ctime(timer) {
      return _asctime(_localtime(timer));
    }
  var _llvm_va_start=undefined;
  function _vfprintf(s, f, va_arg) {
      return _fprintf(s, f, HEAP32[((va_arg)>>2)]);
    }
  function _llvm_va_end() {}
  function _rename(old, new_) {
      // int rename(const char *old, const char *new);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/rename.html
      var oldObj = FS.analyzePath(Pointer_stringify(old));
      var newObj = FS.analyzePath(Pointer_stringify(new_));
      if (newObj.path == oldObj.path) {
        return 0;
      } else if (!oldObj.exists) {
        ___setErrNo(oldObj.error);
        return -1;
      } else if (oldObj.isRoot || oldObj.path == FS.currentPath) {
        ___setErrNo(ERRNO_CODES.EBUSY);
        return -1;
      } else if (newObj.parentPath &&
                 newObj.parentPath.indexOf(oldObj.path) == 0) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return -1;
      } else if (newObj.exists && newObj.object.isFolder) {
        ___setErrNo(ERRNO_CODES.EISDIR);
        return -1;
      } else {
        delete oldObj.parentObject.contents[oldObj.name];
        newObj.parentObject.contents[newObj.name] = oldObj.object;
        return 0;
      }
    }
  function _strftime(s, maxsize, format, timeptr) {
      // size_t strftime(char *restrict s, size_t maxsize, const char *restrict format, const struct tm *restrict timeptr);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/strftime.html
      // TODO: Implement.
      return 0;
    }
  function _qsort(base, num, size, cmp) {
      if (num == 0 || size == 0) return;
      // forward calls to the JavaScript sort method
      // first, sort the items logically
      var comparator = function(x, y) {
        return Runtime.dynCall('iii', cmp, [x, y]);
      }
      var keys = [];
      for (var i = 0; i < num; i++) keys.push(i);
      keys.sort(function(a, b) {
        return comparator(base+a*size, base+b*size);
      });
      // apply the sort
      var temp = _malloc(num*size);
      _memcpy(temp, base, num*size);
      for (var i = 0; i < num; i++) {
        if (keys[i] == i) continue; // already in place
        _memcpy(base+i*size, temp+keys[i]*size, size);
      }
      _free(temp);
    }
  function _gettimeofday(ptr) {
      // %struct.timeval = type { i32, i32 }
      var now = Date.now();
      HEAP32[((ptr)>>2)]=Math.floor(now/1000); // seconds
      HEAP32[(((ptr)+(4))>>2)]=Math.floor((now-1000*Math.floor(now/1000))*1000); // microseconds
      return 0;
    }
  function _opendir(dirname) {
      // DIR *opendir(const char *dirname);
      // http://pubs.opengroup.org/onlinepubs/007908799/xsh/opendir.html
      // NOTE: Calculating absolute path redundantly since we need to associate it
      //       with the opened stream.
      var path = FS.absolutePath(Pointer_stringify(dirname));
      if (path === null) {
        ___setErrNo(ERRNO_CODES.ENOENT);
        return 0;
      }
      var target = FS.findObject(path);
      if (target === null) return 0;
      if (!target.isFolder) {
        ___setErrNo(ERRNO_CODES.ENOTDIR);
        return 0;
      } else if (!target.read) {
        ___setErrNo(ERRNO_CODES.EACCES);
        return 0;
      }
      var contents = [];
      for (var key in target.contents) contents.push(key);
      var id = FS.createFileHandle({
        path: path,
        object: target,
        // An index into contents. Special values: -2 is ".", -1 is "..".
        position: -2,
        isRead: true,
        isWrite: false,
        isAppend: false,
        error: false,
        eof: false,
        ungotten: [],
        // Folder-specific properties:
        // Remember the contents at the time of opening in an array, so we can
        // seek between them relying on a single order.
        contents: contents,
        // Each stream has its own area for readdir() returns.
        currentEntry: _malloc(___dirent_struct_layout.__size__)
      });
      return id;
    }
  function _readdir_r(dirp, entry, result) {
      // int readdir_r(DIR *dirp, struct dirent *entry, struct dirent **result);
      // http://pubs.opengroup.org/onlinepubs/007908799/xsh/readdir_r.html
      if (!FS.streams[dirp] || !FS.streams[dirp].object.isFolder) {
        return ___setErrNo(ERRNO_CODES.EBADF);
      }
      var stream = FS.streams[dirp];
      var loc = stream.position;
      var entries = 0;
      for (var key in stream.contents) entries++;
      if (loc < -2 || loc >= entries) {
        HEAP32[((result)>>2)]=0
      } else {
        var name, inode, type;
        if (loc === -2) {
          name = '.';
          inode = 1;  // Really undefined.
          type = 4; //DT_DIR
        } else if (loc === -1) {
          name = '..';
          inode = 1;  // Really undefined.
          type = 4; //DT_DIR
        } else {
          var object;
          name = stream.contents[loc];
          object = stream.object.contents[name];
          inode = object.inodeNumber;
          type = object.isDevice ? 2 // DT_CHR, character device.
                : object.isFolder ? 4 // DT_DIR, directory.
                : object.link !== undefined ? 10 // DT_LNK, symbolic link.
                : 8; // DT_REG, regular file.
        }
        stream.position++;
        var offsets = ___dirent_struct_layout;
        HEAP32[(((entry)+(offsets.d_ino))>>2)]=inode
        HEAP32[(((entry)+(offsets.d_off))>>2)]=stream.position
        HEAP32[(((entry)+(offsets.d_reclen))>>2)]=name.length + 1
        for (var i = 0; i < name.length; i++) {
          HEAP8[(((entry + offsets.d_name)+(i))|0)]=name.charCodeAt(i)
        }
        HEAP8[(((entry + offsets.d_name)+(i))|0)]=0
        HEAP8[(((entry)+(offsets.d_type))|0)]=type
        HEAP32[((result)>>2)]=entry
      }
      return 0;
    }function _readdir(dirp) {
      // struct dirent *readdir(DIR *dirp);
      // http://pubs.opengroup.org/onlinepubs/007908799/xsh/readdir_r.html
      if (!FS.streams[dirp] || !FS.streams[dirp].object.isFolder) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return 0;
      } else {
        if (!_readdir.result) _readdir.result = _malloc(4);
        _readdir_r(dirp, FS.streams[dirp].currentEntry, _readdir.result);
        if (HEAP32[((_readdir.result)>>2)] === 0) {
          return 0;
        } else {
          return FS.streams[dirp].currentEntry;
        }
      }
    }
  function _closedir(dirp) {
      // int closedir(DIR *dirp);
      // http://pubs.opengroup.org/onlinepubs/007908799/xsh/closedir.html
      if (!FS.streams[dirp] || !FS.streams[dirp].object.isFolder) {
        return ___setErrNo(ERRNO_CODES.EBADF);
      } else {
        _free(FS.streams[dirp].currentEntry);
        FS.streams[dirp] = null;
        return 0;
      }
    }
  function _ungetc(c, stream) {
      // int ungetc(int c, FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/ungetc.html
      if (FS.streams[stream]) {
        c = unSign(c & 0xFF);
        FS.streams[stream].ungotten.push(c);
        return c;
      } else {
        return -1;
      }
    }
  function _fmod(x, y) {
      return x % y;
    }
  function _gmtime_r(time, tmPtr) {
      var date = new Date(HEAP32[((time)>>2)]*1000);
      var offsets = ___tm_struct_layout;
      HEAP32[(((tmPtr)+(offsets.tm_sec))>>2)]=date.getUTCSeconds()
      HEAP32[(((tmPtr)+(offsets.tm_min))>>2)]=date.getUTCMinutes()
      HEAP32[(((tmPtr)+(offsets.tm_hour))>>2)]=date.getUTCHours()
      HEAP32[(((tmPtr)+(offsets.tm_mday))>>2)]=date.getUTCDate()
      HEAP32[(((tmPtr)+(offsets.tm_mon))>>2)]=date.getUTCMonth()
      HEAP32[(((tmPtr)+(offsets.tm_year))>>2)]=date.getUTCFullYear()-1900
      HEAP32[(((tmPtr)+(offsets.tm_wday))>>2)]=date.getUTCDay()
      HEAP32[(((tmPtr)+(offsets.tm_gmtoff))>>2)]=0
      HEAP32[(((tmPtr)+(offsets.tm_isdst))>>2)]=0
      var start = new Date(date.getFullYear(), 0, 1);
      var yday = Math.round((date.getTime() - start.getTime()) / (1000 * 60 * 60 * 24));
      HEAP32[(((tmPtr)+(offsets.tm_yday))>>2)]=yday
      var timezone = "GMT";
      if (!(timezone in ___tm_timezones)) {
        ___tm_timezones[timezone] = allocate(intArrayFromString(timezone), 'i8', ALLOC_NORMAL);
      }
      HEAP32[(((tmPtr)+(offsets.tm_zone))>>2)]=___tm_timezones[timezone]
      return tmPtr;
    }function _gmtime(time) {
      return _gmtime_r(time, ___tm_current);
    }
  function _setvbuf(stream, buf, type, size) {
      // int setvbuf(FILE *restrict stream, char *restrict buf, int type, size_t size);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/setvbuf.html
      // TODO: Implement custom buffering.
      return 0;
    }function _setbuf(stream, buf) {
      // void setbuf(FILE *restrict stream, char *restrict buf);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/setbuf.html
      if (buf) _setvbuf(stream, buf, 0, 8192);  // _IOFBF, BUFSIZ.
      else _setvbuf(stream, buf, 2, 8192);  // _IONBF, BUFSIZ.
    }
  function _atexit(func, arg) {
      __ATEXIT__.unshift({ func: func, arg: arg });
    }
  function _isatty(fildes) {
      // int isatty(int fildes);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/isatty.html
      if (!FS.streams[fildes]) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return 0;
      }
      if (FS.streams[fildes].isTerminal) return 1;
      ___setErrNo(ERRNO_CODES.ENOTTY);
      return 0;
    }
  var ___utsname_struct_layout={__size__:160,sysname:0,nodename:32,release:64,version:96,machine:128};function _uname(name) {
      // int uname(struct utsname *name);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/uname.html
      function copyString(element, value) {
        var offset = ___utsname_struct_layout[element];
        for (var i = 0; i < value.length; i++) {
          HEAP8[(((name)+(offset + i))|0)]=value.charCodeAt(i)
        }
        HEAP8[(((name)+(offset + i))|0)]=0
      }
      if (name === 0) {
        return -1;
      } else {
        copyString('sysname', 'Emscripten');
        copyString('nodename', 'emscripten');
        copyString('release', '1.0');
        copyString('version', '#1');
        copyString('machine', 'x86-JS');
        return 0;
      }
    }
  function _nl_langinfo(item) {
      // char *nl_langinfo(nl_item item);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/nl_langinfo.html
      var result;
      switch (item) {
        case 0:
          result = 'ANSI_X3.4-1968';
          break;
        case 1:
          result = '%a %b %e %H:%M:%S %Y';
          break;
        case 2:
          result = '%m/%d/%y';
          break;
        case 3:
          result = '%H:%M:%S';
          break;
        case 4:
          result = '%I:%M:%S %p';
          break;
        case 5:
          result = 'AM';
          break;
        case 6:
          result = 'PM';
          break;
        case 7:
          result = 'Sunday';
          break;
        case 8:
          result = 'Monday';
          break;
        case 9:
          result = 'Tuesday';
          break;
        case 10:
          result = 'Wednesday';
          break;
        case 11:
          result = 'Thursday';
          break;
        case 12:
          result = 'Friday';
          break;
        case 13:
          result = 'Saturday';
          break;
        case 14:
          result = 'Sun';
          break;
        case 15:
          result = 'Mon';
          break;
        case 16:
          result = 'Tue';
          break;
        case 17:
          result = 'Wed';
          break;
        case 18:
          result = 'Thu';
          break;
        case 19:
          result = 'Fri';
          break;
        case 20:
          result = 'Sat';
          break;
        case 21:
          result = 'January';
          break;
        case 22:
          result = 'February';
          break;
        case 23:
          result = 'March';
          break;
        case 24:
          result = 'April';
          break;
        case 25:
          result = 'May';
          break;
        case 26:
          result = 'June';
          break;
        case 27:
          result = 'July';
          break;
        case 28:
          result = 'August';
          break;
        case 29:
          result = 'September';
          break;
        case 30:
          result = 'October';
          break;
        case 31:
          result = 'November';
          break;
        case 32:
          result = 'December';
          break;
        case 33:
          result = 'Jan';
          break;
        case 34:
          result = 'Feb';
          break;
        case 35:
          result = 'Mar';
          break;
        case 36:
          result = 'Apr';
          break;
        case 37:
          result = 'May';
          break;
        case 38:
          result = 'Jun';
          break;
        case 39:
          result = 'Jul';
          break;
        case 40:
          result = 'Aug';
          break;
        case 41:
          result = 'Sep';
          break;
        case 42:
          result = 'Oct';
          break;
        case 43:
          result = 'Nov';
          break;
        case 44:
          result = 'Dec';
          break;
        case 49:
          result = '';
          break;
        case 50:
          result = '.';
          break;
        case 51:
          result = '';
          break;
        case 52:
          result = '^[yY]';
          break;
        case 53:
          result = '^[nN]';
          break;
        case 56:
          result = '-';
          break;
        case 45:
        case 46:
        case 47:
        case 48:
        default:
          result = '';
          break;
      }
      var me = _nl_langinfo;
      if (!me.ret) me.ret = _malloc(32);
      for (var i = 0; i < result.length; i++) {
        HEAP8[(((me.ret)+(i))|0)]=result.charCodeAt(i)
      }
      HEAP8[(((me.ret)+(i))|0)]=0
      return me.ret;
    }
  function _iconv_open() {
  Module['printErr']('missing function: iconv_open'); abort(-1);
  }
  function _iconv() {
  Module['printErr']('missing function: iconv'); abort(-1);
  }
  function _iconv_close() {
  Module['printErr']('missing function: iconv_close'); abort(-1);
  }
  function _localeconv() {
      // %struct.timeval = type { char* decimal point, other stuff... }
      // var indexes = Runtime.calculateStructAlignment({ fields: ['i32', 'i32'] });
      var me = _localeconv;
      if (!me.ret) {
        me.ret = allocate([allocate(intArrayFromString('.'), 'i8', ALLOC_NORMAL)], 'i8*', ALLOC_NORMAL); // just decimal point, for now
      }
      return me.ret;
    }
  function _isprint(chr) {
      return 0x1F < chr && chr < 0x7F;
    }
  function _erfc(x) {
      var MATH_TOLERANCE = 1E-12;
      var ONE_SQRTPI = 0.564189583547756287;
      var a = 1;
      var b = x;
      var c = x;
      var d = x * x + 0.5;
      var n = 1.0;
      var q2 = b / d;
      var q1, t;
      if (Math.abs(x) < 2.2) {
        return 1.0 - _erf(x);
      }
      if (x < 0) {
        return 2.0 - _erfc(-x);
      }
      do {
        t = a * n + b * x;
        a = b;
        b = t;
        t = c * n + d * x;
        c = d;
        d = t;
        n += 0.5;
        q1 = q2;
        q2 = b / d;
      } while (Math.abs(q1 - q2) / q2 > MATH_TOLERANCE);
      return (ONE_SQRTPI * Math.exp(- x * x) * q2);
    }function _erf(x) {
      var MATH_TOLERANCE = 1E-12;
      var TWO_SQRTPI = 1.128379167095512574;
      var sum = x;
      var term = x;
      var xsqr = x*x;
      var j = 1;
      if (Math.abs(x) > 2.2) {
        return 1.0 - _erfc(x);
      }
      do {
        term *= xsqr / j;
        sum -= term / (2 * j + 1);
        ++j;
        term *= xsqr / j;
        sum += term / (2 * j + 1);
        ++j;
      } while (Math.abs(term / sum) > MATH_TOLERANCE);
      return (TWO_SQRTPI * sum);
    }
  function _lgamma() {
  Module['printErr']('missing function: lgamma'); abort(-1);
  }
  function ___signgam() {
  Module['printErr']('missing function: __signgam'); abort(-1);
  }
  function _modf(x, intpart) {
      HEAPF64[((intpart)>>3)]=Math.floor(x)
      return x - HEAPF64[((intpart)>>3)];
    }
  function _cosh(x) {
      var p = Math.pow(Math.E, x);
      return (p + (1 / p)) / 2;
    }
  function _sinh(x) {
      var p = Math.pow(Math.E, x);
      return (p - (1 / p)) / 2;
    }
  var _tan=Math.tan;
  var _asin=Math.asin;
  var _acos=Math.acos;
  var _atan=Math.atan;
  function _sleep(seconds) {
      // unsigned sleep(unsigned seconds);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/sleep.html
      return _usleep(seconds * 1e6);
    }
  function _strdup(ptr) {
      var len = _strlen(ptr);
      var newStr = _malloc(len + 1);
      _memcpy(newStr, ptr, len);
      HEAP8[(((newStr)+(len))|0)]=0;
      return newStr;
    }
  function _vsnprintf(s, n, format, va_arg) {
      return _snprintf(s, n, format, HEAP32[((va_arg)>>2)]);
    }
  function _abort() {
      ABORT = true;
      throw 'abort() at ' + (new Error().stack);
    }
  function _sysconf(name) {
      // long sysconf(int name);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/sysconf.html
      switch(name) {
        case 8: return PAGE_SIZE;
        case 54:
        case 56:
        case 21:
        case 61:
        case 63:
        case 22:
        case 67:
        case 23:
        case 24:
        case 25:
        case 26:
        case 27:
        case 69:
        case 28:
        case 101:
        case 70:
        case 71:
        case 29:
        case 30:
        case 199:
        case 75:
        case 76:
        case 32:
        case 43:
        case 44:
        case 80:
        case 46:
        case 47:
        case 45:
        case 48:
        case 49:
        case 42:
        case 82:
        case 33:
        case 7:
        case 108:
        case 109:
        case 107:
        case 112:
        case 119:
        case 121:
          return 200809;
        case 13:
        case 104:
        case 94:
        case 95:
        case 34:
        case 35:
        case 77:
        case 81:
        case 83:
        case 84:
        case 85:
        case 86:
        case 87:
        case 88:
        case 89:
        case 90:
        case 91:
        case 94:
        case 95:
        case 110:
        case 111:
        case 113:
        case 114:
        case 115:
        case 116:
        case 117:
        case 118:
        case 120:
        case 40:
        case 16:
        case 79:
        case 19:
          return -1;
        case 92:
        case 93:
        case 5:
        case 72:
        case 6:
        case 74:
        case 92:
        case 93:
        case 96:
        case 97:
        case 98:
        case 99:
        case 102:
        case 103:
        case 105:
          return 1;
        case 38:
        case 66:
        case 50:
        case 51:
        case 4:
          return 1024;
        case 15:
        case 64:
        case 41:
          return 32;
        case 55:
        case 37:
        case 17:
          return 2147483647;
        case 18:
        case 1:
          return 47839;
        case 59:
        case 57:
          return 99;
        case 68:
        case 58:
          return 2048;
        case 0: return 2097152;
        case 3: return 65536;
        case 14: return 32768;
        case 73: return 32767;
        case 39: return 16384;
        case 60: return 1000;
        case 106: return 700;
        case 52: return 256;
        case 62: return 255;
        case 2: return 100;
        case 65: return 64;
        case 36: return 20;
        case 100: return 16;
        case 20: return 6;
        case 53: return 4;
        case 10: return 1;
      }
      ___setErrNo(ERRNO_CODES.EINVAL);
      return -1;
    }
  function _sbrk(bytes) {
      // Implement a Linux-like 'memory area' for our 'process'.
      // Changes the size of the memory area by |bytes|; returns the
      // address of the previous top ('break') of the memory area
      // We control the "dynamic" memory - DYNAMIC_BASE to DYNAMICTOP
      var self = _sbrk;
      if (!self.called) {
        DYNAMICTOP = alignMemoryPage(DYNAMICTOP); // make sure we start out aligned
        self.called = true;
        assert(Runtime.dynamicAlloc);
        self.alloc = Runtime.dynamicAlloc;
        Runtime.dynamicAlloc = function() { abort('cannot dynamically allocate, sbrk now has control') };
      }
      var ret = DYNAMICTOP;
      if (bytes != 0) self.alloc(bytes);
      return ret;  // Previous break location.
    }
  function _llvm_lifetime_start() {}
  function _llvm_lifetime_end() {}
  var _llvm_memset_p0i8_i64=_memset;
  var _llvm_memcpy_p0i8_p0i8_i64=_memcpy;
  function _llvm_trap() {
      throw 'trap! ' + new Error().stack;
    }
  var Browser={mainLoop:{scheduler:null,shouldPause:false,paused:false,queue:[],pause:function () {
          Browser.mainLoop.shouldPause = true;
        },resume:function () {
          if (Browser.mainLoop.paused) {
            Browser.mainLoop.paused = false;
            Browser.mainLoop.scheduler();
          }
          Browser.mainLoop.shouldPause = false;
        },updateStatus:function () {
          if (Module['setStatus']) {
            var message = Module['statusMessage'] || 'Please wait...';
            var remaining = Browser.mainLoop.remainingBlockers;
            var expected = Browser.mainLoop.expectedBlockers;
            if (remaining) {
              if (remaining < expected) {
                Module['setStatus'](message + ' (' + (expected - remaining) + '/' + expected + ')');
              } else {
                Module['setStatus'](message);
              }
            } else {
              Module['setStatus']('');
            }
          }
        }},isFullScreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],init:function () {
        if (Browser.initted) return;
        Browser.initted = true;
        try {
          new Blob();
          Browser.hasBlobConstructor = true;
        } catch(e) {
          Browser.hasBlobConstructor = false;
          console.log("warning: no blob constructor, cannot create blobs with mimetypes");
        }
        Browser.BlobBuilder = typeof MozBlobBuilder != "undefined" ? MozBlobBuilder : (typeof WebKitBlobBuilder != "undefined" ? WebKitBlobBuilder : (!Browser.hasBlobConstructor ? console.log("warning: no BlobBuilder") : null));
        Browser.URLObject = typeof window != "undefined" ? (window.URL ? window.URL : window.webkitURL) : console.log("warning: cannot create object URLs");
        // Support for plugins that can process preloaded files. You can add more of these to
        // your app by creating and appending to Module.preloadPlugins.
        //
        // Each plugin is asked if it can handle a file based on the file's name. If it can,
        // it is given the file's raw data. When it is done, it calls a callback with the file's
        // (possibly modified) data. For example, a plugin might decompress a file, or it
        // might create some side data structure for use later (like an Image element, etc.).
        function getMimetype(name) {
          return {
            'jpg': 'image/jpeg',
            'jpeg': 'image/jpeg',
            'png': 'image/png',
            'bmp': 'image/bmp',
            'ogg': 'audio/ogg',
            'wav': 'audio/wav',
            'mp3': 'audio/mpeg'
          }[name.substr(name.lastIndexOf('.')+1)];
        }
        if (!Module["preloadPlugins"]) Module["preloadPlugins"] = [];
        var imagePlugin = {};
        imagePlugin['canHandle'] = function(name) {
          return !Module.noImageDecoding && /\.(jpg|jpeg|png|bmp)$/.exec(name);
        };
        imagePlugin['handle'] = function(byteArray, name, onload, onerror) {
          var b = null;
          if (Browser.hasBlobConstructor) {
            try {
              b = new Blob([byteArray], { type: getMimetype(name) });
            } catch(e) {
              Runtime.warnOnce('Blob constructor present but fails: ' + e + '; falling back to blob builder');
            }
          }
          if (!b) {
            var bb = new Browser.BlobBuilder();
            bb.append((new Uint8Array(byteArray)).buffer); // we need to pass a buffer, and must copy the array to get the right data range
            b = bb.getBlob();
          }
          var url = Browser.URLObject.createObjectURL(b);
          var img = new Image();
          img.onload = function() {
            assert(img.complete, 'Image ' + name + ' could not be decoded');
            var canvas = document.createElement('canvas');
            canvas.width = img.width;
            canvas.height = img.height;
            var ctx = canvas.getContext('2d');
            ctx.drawImage(img, 0, 0);
            Module["preloadedImages"][name] = canvas;
            Browser.URLObject.revokeObjectURL(url);
            if (onload) onload(byteArray);
          };
          img.onerror = function(event) {
            console.log('Image ' + url + ' could not be decoded');
            if (onerror) onerror();
          };
          img.src = url;
        };
        Module['preloadPlugins'].push(imagePlugin);
        var audioPlugin = {};
        audioPlugin['canHandle'] = function(name) {
          return !Module.noAudioDecoding && name.substr(-4) in { '.ogg': 1, '.wav': 1, '.mp3': 1 };
        };
        audioPlugin['handle'] = function(byteArray, name, onload, onerror) {
          var done = false;
          function finish(audio) {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = audio;
            if (onload) onload(byteArray);
          }
          function fail() {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = new Audio(); // empty shim
            if (onerror) onerror();
          }
          if (Browser.hasBlobConstructor) {
            try {
              var b = new Blob([byteArray], { type: getMimetype(name) });
            } catch(e) {
              return fail();
            }
            var url = Browser.URLObject.createObjectURL(b); // XXX we never revoke this!
            var audio = new Audio();
            audio.addEventListener('canplaythrough', function() { finish(audio) }, false); // use addEventListener due to chromium bug 124926
            audio.onerror = function(event) {
              if (done) return;
              console.log('warning: browser could not fully decode audio ' + name + ', trying slower base64 approach');
              function encode64(data) {
                var BASE = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
                var PAD = '=';
                var ret = '';
                var leftchar = 0;
                var leftbits = 0;
                for (var i = 0; i < data.length; i++) {
                  leftchar = (leftchar << 8) | data[i];
                  leftbits += 8;
                  while (leftbits >= 6) {
                    var curr = (leftchar >> (leftbits-6)) & 0x3f;
                    leftbits -= 6;
                    ret += BASE[curr];
                  }
                }
                if (leftbits == 2) {
                  ret += BASE[(leftchar&3) << 4];
                  ret += PAD + PAD;
                } else if (leftbits == 4) {
                  ret += BASE[(leftchar&0xf) << 2];
                  ret += PAD;
                }
                return ret;
              }
              audio.src = 'data:audio/x-' + name.substr(-3) + ';base64,' + encode64(byteArray);
              finish(audio); // we don't wait for confirmation this worked - but it's worth trying
            };
            audio.src = url;
            // workaround for chrome bug 124926 - we do not always get oncanplaythrough or onerror
            Browser.safeSetTimeout(function() {
              finish(audio); // try to use it even though it is not necessarily ready to play
            }, 10000);
          } else {
            return fail();
          }
        };
        Module['preloadPlugins'].push(audioPlugin);
        // Canvas event setup
        var canvas = Module['canvas'];
        canvas.requestPointerLock = canvas['requestPointerLock'] ||
                                    canvas['mozRequestPointerLock'] ||
                                    canvas['webkitRequestPointerLock'];
        canvas.exitPointerLock = document['exitPointerLock'] ||
                                 document['mozExitPointerLock'] ||
                                 document['webkitExitPointerLock'] ||
                                 function(){}; // no-op if function does not exist
        canvas.exitPointerLock = canvas.exitPointerLock.bind(document);
        function pointerLockChange() {
          Browser.pointerLock = document['pointerLockElement'] === canvas ||
                                document['mozPointerLockElement'] === canvas ||
                                document['webkitPointerLockElement'] === canvas;
        }
        document.addEventListener('pointerlockchange', pointerLockChange, false);
        document.addEventListener('mozpointerlockchange', pointerLockChange, false);
        document.addEventListener('webkitpointerlockchange', pointerLockChange, false);
        if (Module['elementPointerLock']) {
          canvas.addEventListener("click", function(ev) {
            if (!Browser.pointerLock && canvas.requestPointerLock) {
              canvas.requestPointerLock();
              ev.preventDefault();
            }
          }, false);
        }
      },createContext:function (canvas, useWebGL, setInModule) {
        var ctx;
        try {
          if (useWebGL) {
            ctx = canvas.getContext('experimental-webgl', {
              alpha: false
            });
          } else {
            ctx = canvas.getContext('2d');
          }
          if (!ctx) throw ':(';
        } catch (e) {
          Module.print('Could not create canvas - ' + e);
          return null;
        }
        if (useWebGL) {
          // Set the background of the WebGL canvas to black
          canvas.style.backgroundColor = "black";
          // Warn on context loss
          canvas.addEventListener('webglcontextlost', function(event) {
            alert('WebGL context lost. You will need to reload the page.');
          }, false);
        }
        if (setInModule) {
          Module.ctx = ctx;
          Module.useWebGL = useWebGL;
          Browser.moduleContextCreatedCallbacks.forEach(function(callback) { callback() });
          Browser.init();
        }
        return ctx;
      },destroyContext:function (canvas, useWebGL, setInModule) {},fullScreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullScreen:function (lockPointer, resizeCanvas) {
        Browser.lockPointer = lockPointer;
        Browser.resizeCanvas = resizeCanvas;
        if (typeof Browser.lockPointer === 'undefined') Browser.lockPointer = true;
        if (typeof Browser.resizeCanvas === 'undefined') Browser.resizeCanvas = false;
        var canvas = Module['canvas'];
        function fullScreenChange() {
          Browser.isFullScreen = false;
          if ((document['webkitFullScreenElement'] || document['webkitFullscreenElement'] ||
               document['mozFullScreenElement'] || document['mozFullscreenElement'] ||
               document['fullScreenElement'] || document['fullscreenElement']) === canvas) {
            canvas.cancelFullScreen = document['cancelFullScreen'] ||
                                      document['mozCancelFullScreen'] ||
                                      document['webkitCancelFullScreen'];
            canvas.cancelFullScreen = canvas.cancelFullScreen.bind(document);
            if (Browser.lockPointer) canvas.requestPointerLock();
            Browser.isFullScreen = true;
            if (Browser.resizeCanvas) Browser.setFullScreenCanvasSize();
          } else if (Browser.resizeCanvas){
            Browser.setWindowedCanvasSize();
          }
          if (Module['onFullScreen']) Module['onFullScreen'](Browser.isFullScreen);
        }
        if (!Browser.fullScreenHandlersInstalled) {
          Browser.fullScreenHandlersInstalled = true;
          document.addEventListener('fullscreenchange', fullScreenChange, false);
          document.addEventListener('mozfullscreenchange', fullScreenChange, false);
          document.addEventListener('webkitfullscreenchange', fullScreenChange, false);
        }
        canvas.requestFullScreen = canvas['requestFullScreen'] ||
                                   canvas['mozRequestFullScreen'] ||
                                   (canvas['webkitRequestFullScreen'] ? function() { canvas['webkitRequestFullScreen'](Element['ALLOW_KEYBOARD_INPUT']) } : null);
        canvas.requestFullScreen();
      },requestAnimationFrame:function (func) {
        if (!window.requestAnimationFrame) {
          window.requestAnimationFrame = window['requestAnimationFrame'] ||
                                         window['mozRequestAnimationFrame'] ||
                                         window['webkitRequestAnimationFrame'] ||
                                         window['msRequestAnimationFrame'] ||
                                         window['oRequestAnimationFrame'] ||
                                         window['setTimeout'];
        }
        window.requestAnimationFrame(func);
      },safeCallback:function (func) {
        return function() {
          if (!ABORT) return func.apply(null, arguments);
        };
      },safeRequestAnimationFrame:function (func) {
        return Browser.requestAnimationFrame(function() {
          if (!ABORT) func();
        });
      },safeSetTimeout:function (func, timeout) {
        return setTimeout(function() {
          if (!ABORT) func();
        }, timeout);
      },safeSetInterval:function (func, timeout) {
        return setInterval(function() {
          if (!ABORT) func();
        }, timeout);
      },getUserMedia:function (func) {
        if(!window.getUserMedia) {
          window.getUserMedia = navigator['getUserMedia'] ||
                                navigator['mozGetUserMedia'];
        }
        window.getUserMedia(func);
      },getMovementX:function (event) {
        return event['movementX'] ||
               event['mozMovementX'] ||
               event['webkitMovementX'] ||
               0;
      },getMovementY:function (event) {
        return event['movementY'] ||
               event['mozMovementY'] ||
               event['webkitMovementY'] ||
               0;
      },mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,calculateMouseEvent:function (event) { // event should be mousemove, mousedown or mouseup
        if (Browser.pointerLock) {
          // When the pointer is locked, calculate the coordinates
          // based on the movement of the mouse.
          // Workaround for Firefox bug 764498
          if (event.type != 'mousemove' &&
              ('mozMovementX' in event)) {
            Browser.mouseMovementX = Browser.mouseMovementY = 0;
          } else {
            Browser.mouseMovementX = Browser.getMovementX(event);
            Browser.mouseMovementY = Browser.getMovementY(event);
          }
          Browser.mouseX = SDL.mouseX + Browser.mouseMovementX;
          Browser.mouseY = SDL.mouseY + Browser.mouseMovementY;
        } else {
          // Otherwise, calculate the movement based on the changes
          // in the coordinates.
          var rect = Module["canvas"].getBoundingClientRect();
          var x = event.pageX - (window.scrollX + rect.left);
          var y = event.pageY - (window.scrollY + rect.top);
          // the canvas might be CSS-scaled compared to its backbuffer;
          // SDL-using content will want mouse coordinates in terms
          // of backbuffer units.
          var cw = Module["canvas"].width;
          var ch = Module["canvas"].height;
          x = x * (cw / rect.width);
          y = y * (ch / rect.height);
          Browser.mouseMovementX = x - Browser.mouseX;
          Browser.mouseMovementY = y - Browser.mouseY;
          Browser.mouseX = x;
          Browser.mouseY = y;
        }
      },xhrLoad:function (url, onload, onerror) {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', url, true);
        xhr.responseType = 'arraybuffer';
        xhr.onload = function() {
          if (xhr.status == 200 || (xhr.status == 0 && xhr.response)) { // file URLs can return 0
            onload(xhr.response);
          } else {
            onerror();
          }
        };
        xhr.onerror = onerror;
        xhr.send(null);
      },asyncLoad:function (url, onload, onerror, noRunDep) {
        Browser.xhrLoad(url, function(arrayBuffer) {
          assert(arrayBuffer, 'Loading data file "' + url + '" failed (no arrayBuffer).');
          onload(new Uint8Array(arrayBuffer));
          if (!noRunDep) removeRunDependency('al ' + url);
        }, function(event) {
          if (onerror) {
            onerror();
          } else {
            throw 'Loading data file "' + url + '" failed.';
          }
        });
        if (!noRunDep) addRunDependency('al ' + url);
      },resizeListeners:[],updateResizeListeners:function () {
        var canvas = Module['canvas'];
        Browser.resizeListeners.forEach(function(listener) {
          listener(canvas.width, canvas.height);
        });
      },setCanvasSize:function (width, height, noUpdates) {
        var canvas = Module['canvas'];
        canvas.width = width;
        canvas.height = height;
        if (!noUpdates) Browser.updateResizeListeners();
      },windowedWidth:0,windowedHeight:0,setFullScreenCanvasSize:function () {
        var canvas = Module['canvas'];
        this.windowedWidth = canvas.width;
        this.windowedHeight = canvas.height;
        canvas.width = screen.width;
        canvas.height = screen.height;
        var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
        flags = flags | 0x00800000; // set SDL_FULLSCREEN flag
        HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        Browser.updateResizeListeners();
      },setWindowedCanvasSize:function () {
        var canvas = Module['canvas'];
        canvas.width = this.windowedWidth;
        canvas.height = this.windowedHeight;
        var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
        flags = flags & ~0x00800000; // clear SDL_FULLSCREEN flag
        HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        Browser.updateResizeListeners();
      }};
__ATINIT__.unshift({ func: function() { if (!Module["noFSInit"] && !FS.init.initialized) FS.init() } });__ATMAIN__.push({ func: function() { FS.ignorePermissions = false } });__ATEXIT__.push({ func: function() { FS.quit() } });Module["FS_createFolder"] = FS.createFolder;Module["FS_createPath"] = FS.createPath;Module["FS_createDataFile"] = FS.createDataFile;Module["FS_createPreloadedFile"] = FS.createPreloadedFile;Module["FS_createLazyFile"] = FS.createLazyFile;Module["FS_createLink"] = FS.createLink;Module["FS_createDevice"] = FS.createDevice;
___errno_state = Runtime.staticAlloc(4); HEAP32[((___errno_state)>>2)]=0;
_fgetc.ret = allocate([0], "i8", ALLOC_STATIC);
_fputc.ret = allocate([0], "i8", ALLOC_STATIC);
___buildEnvironment(ENV);
Module["requestFullScreen"] = function(lockPointer, resizeCanvas) { Browser.requestFullScreen(lockPointer, resizeCanvas) };
  Module["requestAnimationFrame"] = function(func) { Browser.requestAnimationFrame(func) };
  Module["pauseMainLoop"] = function() { Browser.mainLoop.pause() };
  Module["resumeMainLoop"] = function() { Browser.mainLoop.resume() };
  Module["getUserMedia"] = function() { Browser.getUserMedia() }
STACK_BASE = STACKTOP = Runtime.alignMemory(STATICTOP);
staticSealed = true; // seal the static portion of memory
STACK_MAX = STACK_BASE + 5242880;
DYNAMIC_BASE = DYNAMICTOP = Runtime.alignMemory(STACK_MAX);
assert(DYNAMIC_BASE < TOTAL_MEMORY); // Stack must fit in TOTAL_MEMORY; allocations from here on may enlarge TOTAL_MEMORY
var Math_min = Math.min;
function invoke_viiiii(index,a1,a2,a3,a4,a5) {
  try {
    Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viffiii(index,a1,a2,a3,a4,a5,a6) {
  try {
    Module["dynCall_viffiii"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vf(index,a1) {
  try {
    Module["dynCall_vf"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_i(index) {
  try {
    return Module["dynCall_i"](index);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vi(index,a1) {
  try {
    Module["dynCall_vi"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vii(index,a1,a2) {
  try {
    Module["dynCall_vii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_ii(index,a1) {
  try {
    return Module["dynCall_ii"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iff(index,a1,a2) {
  try {
    return Module["dynCall_iff"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiii(index,a1,a2,a3) {
  try {
    return Module["dynCall_iiii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viii(index,a1,a2,a3) {
  try {
    Module["dynCall_viii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_v(index) {
  try {
    Module["dynCall_v"](index);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vifiii(index,a1,a2,a3,a4,a5) {
  try {
    Module["dynCall_vifiii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiii(index,a1,a2,a3,a4) {
  try {
    return Module["dynCall_iiiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fii(index,a1,a2) {
  try {
    return Module["dynCall_fii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iii(index,a1,a2) {
  try {
    return Module["dynCall_iii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function asmPrintInt(x, y) {
  Module.print('int ' + x + ',' + y);// + ' ' + new Error().stack);
}
function asmPrintFloat(x, y) {
  Module.print('float ' + x + ',' + y);// + ' ' + new Error().stack);
}
// EMSCRIPTEN_START_ASM
var asm=(function(global,env,buffer){"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.STACKTOP|0;var j=env.STACK_MAX|0;var k=env.tempDoublePtr|0;var l=env.ABORT|0;var m=env._stderr|0;var n=env._stdout|0;var o=env._stdin|0;var p=+env.NaN;var q=+env.Infinity;var r=0;var s=0;var t=0;var u=0;var v=0,w=0,x=0,y=0,z=0.0,A=0,B=0,C=0,D=0.0;var E=0;var F=0;var G=0;var H=0;var I=0;var J=0;var K=0;var L=0;var M=0;var N=0;var O=global.Math.floor;var P=global.Math.abs;var Q=global.Math.sqrt;var R=global.Math.pow;var S=global.Math.cos;var T=global.Math.sin;var U=global.Math.tan;var V=global.Math.acos;var W=global.Math.asin;var X=global.Math.atan;var Y=global.Math.atan2;var Z=global.Math.exp;var _=global.Math.log;var $=global.Math.ceil;var aa=global.Math.imul;var ab=env.abort;var ac=env.assert;var ad=env.asmPrintInt;var ae=env.asmPrintFloat;var af=env.copyTempDouble;var ag=env.copyTempFloat;var ah=env.min;var ai=env.invoke_viiiii;var aj=env.invoke_viffiii;var ak=env.invoke_vf;var al=env.invoke_i;var am=env.invoke_vi;var an=env.invoke_vii;var ao=env.invoke_ii;var ap=env.invoke_iff;var aq=env.invoke_iiii;var ar=env.invoke_viii;var as=env.invoke_v;var at=env.invoke_vifiii;var au=env.invoke_iiiii;var av=env.invoke_fii;var aw=env.invoke_iii;var ax=env._lseek;var ay=env.__scanString;var az=env._fclose;var aA=env._uname;var aB=env._sleep;var aC=env.__isFloat;var aD=env._fflush;var aE=env._strtol;var aF=env._fputc;var aG=env._iconv;var aH=env.___signgam;var aI=env._fwrite;var aJ=env._send;var aK=env._fputs;var aL=env._tmpnam;var aM=env._isspace;var aN=env._localtime;var aO=env._read;var aP=env._ceil;var aQ=env._strstr;var aR=env._fileno;var aS=env._perror;var aT=env._ctime;var aU=env._fsync;var aV=env._signal;var aW=env._opendir;var aX=env._fmod;var aY=env._strcmp;var aZ=env._memchr;var a_=env._strncmp;var a$=env._tmpfile;var a0=env._snprintf;var a1=env._fgetc;var a2=env._pclose;var a3=env._readdir;var a4=env._cosh;var a5=env._atexit;var a6=env._fgets;var a7=env._close;var a8=env._strchr;var a9=env._asin;var ba=env._llvm_lifetime_start;var bb=env.___setErrNo;var bc=env._ftell;var bd=env._exit;var be=env._sprintf;var bf=env._llvm_lifetime_end;var bg=env._asctime;var bh=env._strrchr;var bi=env._iconv_open;var bj=env._modf;var bk=env._strcspn;var bl=env._getcwd;var bm=env._gmtime;var bn=env._localtime_r;var bo=env._asctime_r;var bp=env._recv;var bq=env._cos;var br=env._putchar;var bs=env._isalnum;var bt=env._popen;var bu=env._erfc;var bv=env.__exit;var bw=env._strftime;var bx=env._llvm_va_end;var by=env._tzset;var bz=env._sinh;var bA=env._setlocale;var bB=env._isprint;var bC=env._toupper;var bD=env._printf;var bE=env._pread;var bF=env._fopen;var bG=env._open;var bH=env._usleep;var bI=env._log;var bJ=env._puts;var bK=env._mktime;var bL=env._fdopen;var bM=env._qsort;var bN=env._system;var bO=env._isalpha;var bP=env._strdup;var bQ=env._log10;var bR=env._closedir;var bS=env._isatty;var bT=env.__formatString;var bU=env._getenv;var bV=env._gettimeofday;var bW=env._atoi;var bX=env._vfprintf;var bY=env._chdir;var bZ=env._llvm_pow_f64;var b_=env._sbrk;var b$=env._localeconv;var b0=env.___errno_location;var b1=env._strerror;var b2=env._lgamma;var b3=env._erf;var b4=env._strspn;var b5=env.__parseInt;var b6=env._ungetc;var b7=env._llvm_trap;var b8=env._rename;var b9=env._vsnprintf;var ca=env._sscanf;var cb=env._sysconf;var cc=env._acos;var cd=env._fread;var ce=env._abort;var cf=env._fprintf;var cg=env.___fpclassifyf;var ch=env._tan;var ci=env.___buildEnvironment;var cj=env._feof;var ck=env._strncat;var cl=env._gmtime_r;var cm=env._fabs;var cn=env._floor;var co=env.__reallyNegative;var cp=env._fseek;var cq=env._sqrt;var cr=env._write;var cs=env._rewind;var ct=env._sin;var cu=env._stat;var cv=env._longjmp;var cw=env._atan;var cx=env._readdir_r;var cy=env._strpbrk;var cz=env._iconv_close;var cA=env._setbuf;var cB=env._nl_langinfo;var cC=env._pwrite;var cD=env._strerror_r;var cE=env._atan2;var cF=env._exp;var cG=env._time;var cH=env._setvbuf;
// EMSCRIPTEN_START_FUNCS
function cX(a){a=a|0;var b=0;b=i;i=i+a|0;i=i+7>>3<<3;return b|0}function cY(){return i|0}function cZ(a){a=a|0;i=a}function c_(a,b){a=a|0;b=b|0;if((r|0)==0){r=a;s=b}}function c$(a){a=a|0;E=a}function c0(a){a=a|0;F=a}function c1(a){a=a|0;G=a}function c2(a){a=a|0;H=a}function c3(a){a=a|0;I=a}function c4(a){a=a|0;J=a}function c5(a){a=a|0;K=a}function c6(a){a=a|0;L=a}function c7(a){a=a|0;M=a}function c8(a){a=a|0;N=a}function c9(b){b=b|0;var d=0,e=0,f=0,g=0,j=0,k=0.0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,x=0.0;d=i;i=i+96|0;e=d|0;f=d+48|0;do{if((c[64808+(b*688&-1)>>2]|0)==1){if((a[64812+(b*688&-1)|0]&1)==0){break}g=4968+(b*51&-1)|0;a[g]=0;j=4608+(b<<2)|0;k=+da(c[j>>2]|0,+h[64664+(b*688&-1)>>3]);t3(e,k);k=+da(c[j>>2]|0,+h[64672+(b*688&-1)>>3]);t3(f,k);l=c[f+20>>2]|0;m=c[e+20>>2]|0;n=(l|0)==(m|0);do{if(n){if((c[f+28>>2]|0)!=(c[e+28>>2]|0)){break}if((c[f+8>>2]|0)!=(c[e+8>>2]|0)){a[g]=a[172544]|0;a[g+1|0]=a[172545|0]|0;a[g+2|0]=a[172546|0]|0}o=c[j>>2]|0;if(o>>>0>=4){p=g;i=d;return p|0}if((a[g]|0)!=0){q=(uA(g|0)|0)+(4968+(b*51&-1))|0;w=58;a[q]=w&255;w=w>>8;a[q+1|0]=w&255}q=(uA(g|0)|0)+(4968+(b*51&-1))|0;a[q]=a[164672]|0;a[q+1|0]=a[164673|0]|0;a[q+2|0]=a[164674|0]|0;if(o>>>0>=3){p=g;i=d;return p|0}o=(uA(g|0)|0)+(4968+(b*51&-1))|0;w=5449018;a[o]=w&255;w=w>>8;a[o+1|0]=w&255;w=w>>8;a[o+2|0]=w&255;w=w>>8;a[o+3|0]=w&255;p=g;i=d;return p|0}}while(0);o=64813+(b*688&-1)|0;q=a8(o|0,109)|0;r=q>>>0<(a8(o|0,100)|0)>>>0;do{if(n){if(r){a[g]=a[145768]|0;a[g+1|0]=a[145769|0]|0;a[g+2|0]=a[145770|0]|0;a[g+3|0]=a[145771|0]|0;a[g+4|0]=a[145772|0]|0;a[g+5|0]=a[145773|0]|0;break}else{a[g]=a[143792]|0;a[g+1|0]=a[143793|0]|0;a[g+2|0]=a[143794|0]|0;a[g+3|0]=a[143795|0]|0;a[g+4|0]=a[143796|0]|0;a[g+5|0]=a[143797|0]|0;break}}else{o=g;q=o|0;w=r?623865125:623862821;a[q]=w&255;w=w>>8;a[q+1|0]=w&255;w=w>>8;a[q+2|0]=w&255;w=w>>8;a[q+3|0]=w&255;q=o+4|0;w=r?2436964:2436973;a[q]=w&255;w=w>>8;a[q+1|0]=w&255;w=w>>8;a[q+2|0]=w&255;w=w>>8;a[q+3|0]=w&255;q=(uA(g|0)|0)+(4968+(b*51&-1))|0;if(((l|0)/100&-1|0)==((m|0)/100&-1|0)){w=121;a[q]=w&255;w=w>>8;a[q+1|0]=w&255;break}else{w=89;a[q]=w&255;w=w>>8;a[q+1|0]=w&255;break}}}while(0);if((c[j>>2]|0)>>>0>=5){p=g;i=d;return p|0}m=(uA(g|0)|0)+(4968+(b*51&-1))|0;a[m]=a[142240]|0;a[m+1|0]=a[142241|0]|0;a[m+2|0]=a[142242|0]|0;a[m+3|0]=a[142243|0]|0;a[m+4|0]=a[142244|0]|0;a[m+5|0]=a[142245|0]|0;a[m+6|0]=a[142246|0]|0;p=g;i=d;return p|0}}while(0);e=4968+(b*51&-1)|0;uB(e|0,64864+(b*688&-1)|0);if((aY(e|0,186288)|0)!=0){p=e;i=d;return p|0}k=+h[64664+(b*688&-1)>>3];if((a[64788+(b*688&-1)|0]&1)==0){s=+h[64672+(b*688&-1)>>3];t=k}else{u=+h[64800+(b*688&-1)>>3];x=+Z(+(k*u));s=+Z(+(+h[64672+(b*688&-1)>>3]*u));t=x}b=~~+$(+(-0.0- +bQ(+(+P(+(s-t))))));if(t*s>0.0&(b|0)>4){f=(b|0)>14?14:b;be(e|0,180872,(v=i,i=i+8|0,c[v>>2]=f,v)|0);p=e;i=d;return p|0}else{a[e]=a[170912]|0;a[e+1|0]=a[170913|0]|0;a[e+2|0]=a[170914|0]|0;p=e;i=d;return p|0}return 0}function da(a,b){a=a|0;b=+b;var d=0,e=0,f=0.0,g=0,h=0,j=0;d=i;i=i+48|0;e=d|0;if(a>>>0<2){f=b;i=d;return+f}t3(e,b);g=e|0;if((c[g>>2]|0)>55){h=e+4|0;c[h>>2]=(c[h>>2]|0)+1}c[g>>2]=0;do{if(a>>>0>2){g=e+4|0;if((c[g>>2]|0)>55){h=e+8|0;c[h>>2]=(c[h>>2]|0)+1}c[g>>2]=0;if(a>>>0<=3){break}g=e+8|0;if((c[g>>2]|0)>22){c[g>>2]=0;c[e+12>>2]=0;g=e+28|0;c[g>>2]=(c[g>>2]|0)+1;b=+t2(e);t3(e,b)}if(a>>>0<=5){break}g=e+12|0;do{if((c[g>>2]|0)>25){h=e+16|0;j=(c[h>>2]|0)+1|0;c[h>>2]=j;if((j|0)<=11){break}j=e+20|0;c[j>>2]=(c[j>>2]|0)+1;c[h>>2]=0}}while(0);c[g>>2]=1}}while(0);f=+t2(e);i=d;return+f}function db(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;do{if((a|0)==0){f=ut(b)|0;if((f|0)!=0){g=f;break}gk();f=ut(b)|0;if((f|0)!=0|(d|0)==0){g=f;break}uf(-1,225296,(v=i,i=i+8|0,c[v>>2]=d,v)|0);return 0}else{f=uv(a,b)|0;if((f|0)!=0){g=f;break}gk();f=uv(a,b)|0;if((f|0)!=0|(d|0)==0){g=f;break}uf(-1,225296,(v=i,i=i+8|0,c[v>>2]=d,v)|0);return 0}}while(0);i=e;return g|0}function dc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0.0,g=0,j=0.0,k=0,l=0,n=0.0,o=0,p=0,q=0;d=i;e=64664+(a*688&-1)|0;f=+h[e>>3];g=64672+(a*688&-1)|0;j=+h[g>>3];k=(b|0)!=0;do{if(k){if(!(f==8.988465674311579e+307|j==-8.988465674311579e+307)){break}uf(c[13898]|0,b,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}}while(0);if(j-f!=0.0){i=d;return}b=64648+(a*688&-1)|0;l=c[b>>2]|0;if((l|0)==0){uf(-1,197584,(v=i,i=i+8|0,c[v>>2]=56832+(a*24&-1),v)|0)}if(j==0.0){n=1.0}else{n=+P(+j)*.01}o=(a|0)!=0|k;if(o){k=c[m>>2]|0;p=56832+(a*24&-1)|0;cf(k|0,206616,(v=i,i=i+24|0,c[v>>2]=p,h[v+8>>3]=f,h[v+16>>3]=j,v)|0);q=c[b>>2]|0}else{q=l}if((q&1|0)!=0){h[e>>3]=+h[e>>3]-n}if((q&2|0)!=0){h[g>>3]=n+ +h[g>>3]}if(!o){i=d;return}n=+h[g>>3];cf(c[m>>2]|0,202928,(v=i,i=i+16|0,h[v>>3]=+h[e>>3],h[v+8>>3]=n,v)|0);i=d;return}function dd(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,j=0,k=0,l=0,m=0.0,n=0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,w=0.0,x=0.0,y=0.0,z=0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,Q=0.0,S=0,T=0.0,U=0.0;e=i;f=c[64648+(b*688&-1)>>2]|0;g=(f&1|0)==0;if(g){j=0}else{j=(f&4|0)==0}k=(f&2|0)==0;if(k){l=0}else{l=(f&8|0)==0}do{if(!g){if((c[64728+(b*688&-1)>>2]&2|0)==0){break}f=64664+(b*688&-1)|0;m=+h[64744+(b*688&-1)>>3];if(+h[f>>3]<=m){break}h[f>>3]=m}}while(0);do{if(!k){if((c[64732+(b*688&-1)>>2]&1|0)==0){break}g=64672+(b*688&-1)|0;m=+h[64752+(b*688&-1)>>3];if(+h[g>>3]>=m){break}h[g>>3]=m}}while(0);if((c[64916+(b*688&-1)>>2]|0)==0){i=e;return}k=64920+(b*688&-1)|0;g=c[k>>2]|0;do{if((g|0)==2){m=+h[64960+(b*688&-1)>>3];h[4880+(b<<3)>>3]=m;if(j){n=+h[64952+(b*688&-1)>>3]==-8.988465674311579e+307}else{n=0}if(!l){o=0;p=n;q=m;break}o=+h[64968+(b*688&-1)>>3]==8.988465674311579e+307;p=n;q=m}else if((g|0)==1){m=+h[64664+(b*688&-1)>>3]- +h[64672+(b*688&-1)>>3];r=+P(+m);do{if(m==0.0){s=1.0}else{if(r>=8.988465674311579e+307){uf(-1,98888,(v=i,i=i+8|0,c[v>>2]=56832+(b*24&-1),v)|0)}t=+R(10.0,+(+O(+(+bQ(+r)))));u=r/t;w=+(d|0);x=w/u;do{if(x>40.0){y=.05}else{if(x>20.0){y=.1;break}if(x>10.0){y=.2;break}if(x>4.0){y=.5;break}if(x>2.0){y=1.0;break}if(x>.5){y=2.0;break}y=+$(+u)}}while(0);u=t*y;x=(a[64788+(b*688&-1)|0]&1)!=0&u<1.0?1.0:u;if((c[64808+(b*688&-1)>>2]|0)!=1){s=x;break}f=(d*3&-1|0)/5&-1;z=4608+(b<<2)|0;c[z>>2]=1;do{if(x>5.0){u=r/60.0;A=+R(12.0,+(+O(+(+_(+u)/2.4849066497880004))));B=u/A;u=+(f|0)/B;do{if(u>24.0){C=A/24.0}else{if(u>12.0){C=A/12.0;break}if(u>6.0){C=A/6.0;break}if(u>4.0){C=A*.25;break}if(u>2.0){C=A*.5;break}if(u>1.0){C=A;break}if(u>.5){C=A*2.0;break}if(u>.3333333333333333){C=A*3.0;break}else{C=A*+$(+B);break}}}while(0);B=C*60.0;if(B<60.0){D=B;break}c[z>>2]=2;D=B}else{D=x}}while(0);do{if(D>300.0){x=r/3600.0;t=+R(12.0,+(+O(+(+_(+x)/2.4849066497880004))));B=x/t;x=+(f|0)/B;do{if(x>24.0){E=t/24.0}else{if(x>12.0){E=t/12.0;break}if(x>6.0){E=t/6.0;break}if(x>4.0){E=t*.25;break}if(x>2.0){E=t*.5;break}if(x>1.0){E=t;break}if(x>.5){E=t*2.0;break}if(x>.3333333333333333){E=t*3.0;break}else{E=t*+$(+B);break}}}while(0);B=E*3600.0;if(B<3600.0){F=B;break}c[z>>2]=3;F=B}else{F=D}}while(0);do{if(F>3600.0){B=r/86400.0;t=+R(12.0,+(+O(+(+_(+B)/2.4849066497880004))));x=B/t;B=+(f|0)/x;do{if(B>24.0){G=t/24.0}else{if(B>12.0){G=t/12.0;break}if(B>6.0){G=t/6.0;break}if(B>4.0){G=t*.25;break}if(B>2.0){G=t*.5;break}if(B>1.0){G=t;break}if(B>.5){G=t*2.0;break}if(B>.3333333333333333){G=t*3.0;break}else{G=t*+$(+x);break}}}while(0);x=G*86400.0;if(x<86400.0){H=x;break}c[z>>2]=4;H=x}else{H=F}}while(0);do{if(H>172800.0){x=r/604800.0;t=+R(10.0,+(+O(+(+bQ(+x)))));B=x/t;x=w/B;do{if(x>40.0){I=.05}else{if(x>20.0){I=.1;break}if(x>10.0){I=.2;break}if(x>4.0){I=.5;break}if(x>2.0){I=1.0;break}if(x>.5){I=2.0;break}I=+$(+B)}}while(0);B=t*I*604800.0;x=B<604800.0?604800.0:B;if(x<604800.0){J=x;break}c[z>>2]=5;J=x}else{J=H}}while(0);do{if(J>1814400.0){x=r/2629800.0;B=+R(10.0,+(+O(+(+bQ(+x)))));A=x/B;x=w/A;do{if(x>40.0){K=.05}else{if(x>20.0){K=.1;break}if(x>10.0){K=.2;break}if(x>4.0){K=.5;break}if(x>2.0){K=1.0;break}if(x>.5){K=2.0;break}K=+$(+A)}}while(0);A=B*K*2629800.0;x=A<2629800.0?2629800.0:A;if(x<2629800.0){L=x;break}c[z>>2]=6;L=x}else{L=J}}while(0);if(L<=2629800.0){s=L;break}w=r/31557600.0;x=+R(12.0,+(+O(+(+_(+w)/2.4849066497880004))));A=w/x;w=+(f|0)/A;do{if(w>24.0){M=x/24.0}else{if(w>12.0){M=x/12.0;break}if(w>6.0){M=x/6.0;break}if(w>4.0){M=x*.25;break}if(w>2.0){M=x*.5;break}if(w>1.0){M=x;break}if(w>.5){M=x*2.0;break}if(w>.3333333333333333){M=x*3.0;break}else{M=x*+$(+A);break}}}while(0);A=M*31557600.0;if(A<31557600.0){s=A;break}c[z>>2]=7;s=A}}while(0);h[4880+(b<<3)>>3]=s;o=l;p=j;q=s}else{o=0;p=0;q=0.0}}while(0);j=(c[64808+(b*688&-1)>>2]|0)==1;do{if(j){if((c[k>>2]|0)!=2){break}if(q>=31536.0e3){c[4608+(b<<2)>>2]=7;break}if(q>=2419200.0){c[4608+(b<<2)>>2]=6;break}if(q>=604800.0){c[4608+(b<<2)>>2]=5;break}if(q>=86400.0){c[4608+(b<<2)>>2]=4;break}if(q>=3600.0){c[4608+(b<<2)>>2]=3;break}l=4608+(b<<2)|0;if(q<60.0){c[l>>2]=1;break}else{c[l>>2]=2;break}}}while(0);do{if(p){k=64664+(b*688&-1)|0;q=+h[k>>3];l=q>=+h[64672+(b*688&-1)>>3];s=+h[4880+(b<<3)>>3];M=q/s;if(l){N=+$(+M)}else{N=+O(+M)}M=s*N;do{if(j){s=+da(c[4608+(b<<2)>>2]|0,M);if(s>M&l){Q=s;break}if(s<M&(l^1)){Q=s}else{S=231}}else{S=231}}while(0);if((S|0)==231){Q=M}h[k>>3]=Q;if((c[64728+(b*688&-1)>>2]&1|0)==0){break}s=+h[64736+(b*688&-1)>>3];if(Q>=s){break}h[k>>3]=s}}while(0);do{if(o){j=64672+(b*688&-1)|0;Q=+h[j>>3];p=+h[64664+(b*688&-1)>>3]<Q;N=+h[4880+(b<<3)>>3];s=Q/N;if(p){T=+$(+s)}else{T=+O(+s)}s=N*T;do{if((c[64808+(b*688&-1)>>2]|0)==1){N=+da(c[4608+(b<<2)>>2]|0,s);if(N>s&p){U=N;break}if(N<s&(p^1)){U=N}else{S=242}}else{S=242}}while(0);if((S|0)==242){U=s}h[j>>3]=U;if((c[64732+(b*688&-1)>>2]&2|0)==0){break}M=+h[64760+(b*688&-1)>>3];if(U<=M){break}h[j>>3]=M}}while(0);c9(b);i=e;return}function de(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0.0,s=0,t=0,u=0,w=0,x=0,y=0,z=0,A=0.0,B=0,C=0.0,D=0.0,E=0,F=0.0,G=0.0,H=0.0,I=0.0,J=0,K=0,L=0,M=0,N=0,Q=0,S=0,T=0,U=0,V=0,W=0,X=0.0,Y=0.0,aa=0.0,ab=0.0,ac=0.0,ad=0.0,ae=0.0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0.0,ap=0.0,aq=0.0,ar=0.0,as=0.0,at=0.0,au=0,av=0.0,aw=0.0,ax=0.0,ay=0,az=0.0,aA=0.0,aB=0.0,aC=0.0,aD=0.0,aE=0.0,aF=0.0,aG=0.0,aH=0.0,aI=0.0,aJ=0.0,aK=0.0,aL=0.0,aM=0.0,aN=0.0,aO=0.0,aP=0.0,aQ=0.0,aR=0.0,aS=0.0,aT=0.0;e=i;i=i+432|0;f=e|0;g=e+48|0;j=e+96|0;k=e+152|0;l=e+208|0;m=e+264|0;n=e+320|0;o=e+376|0;p=64920+(b*688&-1)|0;q=c[65040+(b*688&-1)>>2]|0;r=+h[65048+(b*688&-1)>>3];s=j;c[s>>2]=c[10012];c[s+4>>2]=c[10013];c[s+8>>2]=c[10014];c[s+12>>2]=c[10015];c[s+16>>2]=c[10016];c[s+20>>2]=c[10017];c[s+24>>2]=c[10018];c[s+28>>2]=c[10019];c[s+32>>2]=c[10020];c[s+36>>2]=c[10021];c[s+40>>2]=c[10022];c[s+44>>2]=c[10023];c[s+48>>2]=c[10024];c[s+52>>2]=c[10025];t=k;c[t>>2]=c[8694];c[t+4>>2]=c[8695];c[t+8>>2]=c[8696];c[t+12>>2]=c[8697];c[t+16>>2]=c[8698];c[t+20>>2]=c[8699];c[t+24>>2]=c[8700];c[t+28>>2]=c[8701];c[t+32>>2]=c[8702];c[t+36>>2]=c[8703];c[t+40>>2]=c[8704];c[t+44>>2]=c[8705];c[t+48>>2]=c[8706];c[t+52>>2]=c[8707];if((a[65036+(b*688&-1)|0]&1)==0){c[j+4>>2]=-3}if((a[65037+(b*688&-1)|0]&1)==0){c[k+4>>2]=-3}u=64944+(b*688&-1)|0;do{if((c[u>>2]|0)==0){w=64664+(b*688&-1)|0;x=64672+(b*688&-1)|0;y=64788+(b*688&-1)|0}else{z=64672+(b*688&-1)|0;A=+h[z>>3];B=64664+(b*688&-1)|0;C=+h[B>>3];D=(A-C)/10.0*.01;E=64788+(b*688&-1)|0;if((a[E]&1)==0){F=1.0}else{F=+bQ(+(+h[64792+(b*688&-1)>>3]))}if((a[30528]&1)==0){G=C;H=A;I=0.0}else{J=c[200]|0;G=+h[64664+(J*688&-1)>>3];H=+h[64672+(J*688&-1)>>3];I=(c[17366]&1|0)==0?+h[8685]:0.0}A=G-D;C=D+H;J=c[u>>2]|0;if((J|0)!=0){K=(b|0)==7;L=A<C;M=m;N=j+4|0;Q=n;S=64808+(b*688&-1)|0;T=l|0;U=4968+(b*51&-1)|0;V=64800+(b*688&-1)|0;W=J;do{if(K){D=+h[W>>3];if((a[69604]&1)==0){X=I;Y=D}else{aa=+_(+D);ab=+h[8702];X=+_(+I)/ab;Y=aa/ab}ac=Y-X;ad=D}else{D=+h[W>>3];if((a[E]&1)==0){ae=D}else{ab=+_(+D);ae=ab/+h[V>>3]}ac=ae-I;ad=D}if(L){if(!(ac<A|ac>C)){af=272}}else{if(!(ac<C|ac>A)){af=272}}do{if((af|0)==272){af=0;J=W+12|0;ag=c[W+8>>2]|0;do{if((c[J>>2]|0)<0){ah=ag;ai=ag;af=280}else{if((ag|0)==0){af=275}else{if((a8(ag|0,37)|0)==0){aj=ag}else{af=275}}do{if((af|0)==275){af=0;ak=(ag|0)!=0?ag:U;if((c[S>>2]|0)==1){t3(g,ad);D=ad- +O(+ad);t4(T,49,ak,g,D);aj=T;break}else{ud(T,50,ak,F,ad);aj=T;break}}}while(0);ak=(c[J>>2]|0)>0;al=ak?0:aj;if(!ak){ah=aj;ai=al;af=280;break}c[M>>2]=c[t>>2];c[M+4>>2]=c[t+4>>2];c[M+8>>2]=c[t+8>>2];c[M+12>>2]=c[t+12>>2];c[M+16>>2]=c[t+16>>2];c[M+20>>2]=c[t+20>>2];c[M+24>>2]=c[t+24>>2];c[M+28>>2]=c[t+28>>2];c[M+32>>2]=c[t+32>>2];c[M+36>>2]=c[t+36>>2];c[M+40>>2]=c[t+40>>2];c[M+44>>2]=c[t+44>>2];c[M+48>>2]=c[t+48>>2];c[M+52>>2]=c[t+52>>2];am=aj;an=al}}while(0);if((af|0)==280){af=0;c[M>>2]=c[s>>2];c[M+4>>2]=c[s+4>>2];c[M+8>>2]=c[s+8>>2];c[M+12>>2]=c[s+12>>2];c[M+16>>2]=c[s+16>>2];c[M+20>>2]=c[s+20>>2];c[M+24>>2]=c[s+24>>2];c[M+28>>2]=c[s+28>>2];c[M+32>>2]=c[s+32>>2];c[M+36>>2]=c[s+36>>2];c[M+40>>2]=c[s+40>>2];c[M+44>>2]=c[s+44>>2];c[M+48>>2]=c[s+48>>2];c[M+52>>2]=c[s+52>>2];am=ah;an=ai}cT[d&15](b,ac,an,m,0);if(!K){break}if((c[17433]&4|0)==0){break}ag=c[N>>2]|0;c[N>>2]=-3;al=(c[J>>2]|0)>0;if(al){c[Q>>2]=c[t>>2];c[Q+4>>2]=c[t+4>>2];c[Q+8>>2]=c[t+8>>2];c[Q+12>>2]=c[t+12>>2];c[Q+16>>2]=c[t+16>>2];c[Q+20>>2]=c[t+20>>2];c[Q+24>>2]=c[t+24>>2];c[Q+28>>2]=c[t+28>>2];c[Q+32>>2]=c[t+32>>2];c[Q+36>>2]=c[t+36>>2];c[Q+40>>2]=c[t+40>>2];c[Q+44>>2]=c[t+44>>2];c[Q+48>>2]=c[t+48>>2];c[Q+52>>2]=c[t+52>>2]}else{c[Q>>2]=c[s>>2];c[Q+4>>2]=c[s+4>>2];c[Q+8>>2]=c[s+8>>2];c[Q+12>>2]=c[s+12>>2];c[Q+16>>2]=c[s+16>>2];c[Q+20>>2]=c[s+20>>2];c[Q+24>>2]=c[s+24>>2];c[Q+28>>2]=c[s+28>>2];c[Q+32>>2]=c[s+32>>2];c[Q+36>>2]=c[s+36>>2];c[Q+40>>2]=c[s+40>>2];c[Q+44>>2]=c[s+44>>2];c[Q+48>>2]=c[s+48>>2];c[Q+52>>2]=c[s+52>>2]}cT[d&15](7,-0.0-ac,al?0:am,n,0);c[N>>2]=ag}}while(0);W=c[W+16>>2]|0;}while((W|0)!=0)}if((c[p>>2]|0)!=3){w=B;x=z;y=E;break}i=e;return}}while(0);ac=+h[w>>3];ad=+h[x>>3];if((a[y]&1)==0){ao=1.0}else{ao=+bQ(+(+h[64792+(b*688&-1)>>3]))}x=ad<ac;F=x?ad:ac;I=x?ac:ad;x=p|0;p=c[x>>2]|0;do{if((p|0)==2){if((a[y]&1)==0|(b|0)==7){ad=+h[64952+(b*688&-1)>>3];ac=+h[64960+(b*688&-1)>>3];ae=+h[64968+(b*688&-1)>>3];if(ad==-8.988465674311579e+307){ap=ac*+O(+(F/ac))}else{ap=ad}if(ae!=8.988465674311579e+307){aq=ae;ar=ac;as=ap;break}aq=ac*+$(+(I/ac));ar=ac;as=ap;break}ac=+h[64968+(b*688&-1)>>3];if(ac<=0.0){i=e;return}ae=+h[64960+(b*688&-1)>>3];if(ae<=0.0){i=e;return}ad=+_(+ae);ae=+h[64800+(b*688&-1)>>3];X=ad/ae;ad=+h[64952+(b*688&-1)>>3];if(ad>0.0){at=+_(+ad)/ae}else{at=X*+O(+(F/X))}if(ac==8.988465674311579e+307){aq=X*+$(+(I/X));ar=X;as=at;break}else{aq=+_(+ac)/ae;ar=X;as=at;break}}else if((p|0)==1){X=+h[4880+(b<<3)>>3];ae=X*+O(+(F/X));aq=X*+$(+(I/X));ar=X;as=ae}else if((p|0)==4){ae=+O(+F);X=+$(+I);ac=+O(+((X-ae)/12.0));if(ac>=1.0){aq=X;ar=ac;as=ae;break}aq=X;ar=1.0;as=ae}else if((p|0)==5){ae=+O(+F);X=+$(+I);ac=+O(+((X-ae)/14.0));if(ac>=1.0){aq=X;ar=ac;as=ae;break}aq=X;ar=1.0;as=ae}else{uk(140640,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}}while(0);p=aq<as;at=p?aq:as;ap=p?as:aq;aq=+P(+ar);L424:do{if((q|0)==0){au=0;av=1.0;aw=1.0;ax=0.0}else{if(+h[65064+(b*688&-1)>>3]==0.0){au=q;av=1.0;aw=1.0;ax=0.0;break}do{if((q|0)==2){if(r<=0.0){au=0;av=1.0;aw=1.0;ax=0.0;break L424}as=aq/r;if((a[y]&1)==0){ay=2;az=aq;aA=as;break}ae=+h[64792+(b*688&-1)>>3];ay=2;az=aq*ae;aA=as*ae}else{if((a[y]&1)!=0){if(aq<=1.5){ae=+h[64792+(b*688&-1)>>3];as=ap-at;if(as>=10.0){au=0;av=ae;aw=1.0;ax=0.0;break L424}au=q;av=ae;aw=as<5.0?1.0:3.0;ax=2.0;break L424}as=aq*.2;if(aq<65535.0){aB=+(~~as|0)}else{aB=as}ay=q;az=aq;aA=aB<1.0?1.0:aB;break}if((c[64808+(b*688&-1)>>2]|0)!=1){if((q|0)!=3){au=0;av=1.0;aw=1.0;ax=0.0;break L424}as=+P(+aq);ay=3;az=aq;aA=aq*((~~(as/+R(10.0,+(+O(+(+bQ(+as))))))|0)==2?.5:.2);break}p=c[4608+(b<<2)>>2]|0;w=(p|0)<1?1:p;do{if((w|0)==1|(w|0)==2){if(aq<1440.0){aC=aq<720.0?aq<360.0?aq<120.0?aq<60.0?aq<20.0?aq<10.0?aq<5.0?0.0:1.0:5.0:10.0:20.0:60.0:120.0:180.0;break}aC=360.0}else if((w|0)==3){if(aq<86400.0){aC=aq<43200.0?aq<21600.0?aq<7200.0?aq<3600.0?aq<1200.0?0.0:600.0:1800.0:3600.0:7200.0:10800.0;break}aC=21600.0}else if((w|0)==4){if(aq<=172800.0){aC=aq>86400.0?43200.0:aq>46800.0?21600.0:aq>25200.0?10800.0:aq>14400.0?7200.0:aq>7200.0?3600.0:0.0;break}aC=86400.0}else if((w|0)==5){if(aq<=604800.0){aC=aq>172800.0?86400.0:0.0;break}aC=604800.0}else if((w|0)==6){if(aq<=63115200.0){aC=aq>15778800.0?7889400.0:aq>5259600.0?2629800.0:aq>1296.0e3?864.0e3:aq>172800.0?86400.0:0.0;break}aC=31557600.0}else if((w|0)==7){if(aq<=946728.0e4){aC=aq>631152.0e4?157788.0e4:aq>315576.0e4?631152.0e3:aq>157788.0e4?315576.0e3:aq>315576.0e3?157788.0e3:aq>63115200.0?31557600.0:aq>15778800.0?7889400.0:aq>5259600.0?2629800.0:0.0;break}aC=315576.0e4}else{aC=0.0}}while(0);ay=q;az=aq*.9;aA=aC}}while(0);if(aA>0.0){au=ay;av=az;aw=aA;ax=aA;break}au=0;av=az;aw=aA;ax=aA}}while(0);aA=aq*.01;az=ap+aA;ap=+P(+I);if(aq<ap+ +P(+F)){aD=I+aA;aE=F-aA}else{aD=I;aE=F}if(ar==0.0){i=e;return}ar=(aD-aE)/aq;if(ar>+((c[(c[3524]|0)+8>>2]|0)>>>0>>>0)){uh(-1,138720,(v=i,i=i+8|0,h[v>>3]=ar,v)|0);i=e;return}h[111]=at-aq;h[110]=at;L473:do{if(+h[110]>az){aF=aq}else{ar=aq*.25;while(1){if(+P(+(+h[110]- +h[111]))<ar){break}h[111]=+h[110];h[110]=aq+ +h[110];if(+h[110]>az){aF=aq;break L473}}uh(-1,137120,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);aF=az-at}}while(0);if(at>az){i=e;return}ay=(b|0)==7;q=(au|0)==0;au=65064+(b*688&-1)|0;E=64808+(b*688&-1)|0;z=4608+(b<<2)|0;B=aE<aD;aq=aF*.01;ar=at-aq;F=az+aq;w=ar<F;p=aF>1.5;n=64800+(b*688&-1)|0;am=o|0;o=4968+(b*51&-1)|0;s=65024+(b*688&-1)|0;t=j+4|0;m=64712+(b*688&-1)|0;an=64720+(b*688&-1)|0;I=at;at=0.0;while(1){do{if(ay){aG=at;aH=I}else{if((a[y]&1)!=0){aG=+Z(+(I*+h[n>>3]));aH=I;break}if((c[E>>2]|0)==1){aI=+da(c[z>>2]|0,I)}else{aI=I}aG=+P(+aI)<aq?0.0:aI;aH=aI}}while(0);if(aH>aD){af=427;break}L495:do{if(aH<aE){aJ=aH;af=382}else{ai=c[x>>2]|0;if((ai|0)==5){ah=(~~+O(+(aG+.5))|0)%7&-1;cT[d&15](b,aH,72464+(((ah|0)<0?ah+7|0:ah)<<3)|0,j,c[u>>2]|0);aJ=aH;af=382;break}else if((ai|0)==4){ai=(~~+O(+(aG+-1.0))|0)%12&-1;cT[d&15](b,aH,72368+(((ai|0)<0?ai+12|0:ai)<<3)|0,j,c[u>>2]|0);aJ=aH;af=382;break}else{do{if((c[E>>2]|0)==1){t3(f,aG);aA=aG- +O(+aG);t4(am,49,o,f,aA);aK=aH}else{if((a[30528]&1)==0){ud(am,50,o,ao,aG);aK=aH;break}aA=+h[8685];ap=(c[17366]&1|0)==0?aA:0.0;aC=+P(+aG)+ap;if(ay){if((a[y]&1)==0){aL=aA;aM=I}else{ap=+_(+I);aB=+h[n>>3];aL=+_(+aA)/aB;aM=ap/aB}aN=I;aO=aM-aL}else{aN=aC;aO=aH}ud(am,50,o,ao,aN);aK=aO}}while(0);do{if((a[s]&1)!=0){aC=+h[m>>3];aB=+h[an>>3];if(aC<aB){if(aK<aC|aK>aB){break L495}else{break}}else{if(aK<aB|aK>aC){break L495}else{break}}}}while(0);cT[d&15](b,aK,am,j,c[u>>2]|0);if(!ay){aJ=aK;af=382;break}if((c[17433]&4|0)==0){aJ=aK;af=382;break}ai=c[t>>2]|0;c[t>>2]=-3;cT[d&15](7,-0.0-aK,am,j,c[u>>2]|0);c[t>>2]=ai;aJ=aK;af=382;break}}}while(0);L522:do{if((af|0)==382){af=0;if(q){break}if(+h[au>>3]==0.0|ax>=av){break}if(p){aC=ax;while(1){if((c[E>>2]|0)==1){aP=+da((c[z>>2]|0)-1|0,aJ+aC)}else{aP=aJ+aC}if(B){if(!(aP<aE|aP>aD)){af=392}}else{if(!(aP<aD|aP>aE)){af=392}}do{if((af|0)==392){af=0;if(w){if(aP<ar|aP>F){break}}else{if(aP<F|aP>ar){break}}cT[d&15](b,aP,0,k,0)}}while(0);aC=aw+aC;if(aC>=av){break L522}}}if(B){aC=ax;do{if((c[E>>2]|0)==1){aQ=+da((c[z>>2]|0)-1|0,aJ+aC)}else{if((a[y]&1)==0){aR=aC}else{aB=+_(+aC);aR=aB/+h[n>>3]}aQ=aJ+aR}do{if(!(aQ<aE|aQ>aD)){if(w){if(aQ<ar|aQ>F){break}}else{if(aQ<F|aQ>ar){break}}cT[d&15](b,aQ,0,k,0)}}while(0);aC=aw+aC;}while(aC<av)}else{aC=ax;do{if((c[E>>2]|0)==1){aS=+da((c[z>>2]|0)-1|0,aJ+aC)}else{if((a[y]&1)==0){aT=aC}else{aB=+_(+aC);aT=aB/+h[n>>3]}aS=aJ+aT}do{if(!(aS<aD|aS>aE)){if(w){if(aS<ar|aS>F){break}}else{if(aS<F|aS>ar){break}}cT[d&15](b,aS,0,k,0)}}while(0);aC=aw+aC;}while(aC<av)}}}while(0);aC=aF+I;if(aC>az){af=428;break}else{I=aC;at=aG}}if((af|0)==427){i=e;return}else if((af|0)==428){i=e;return}}function df(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0.0,u=0.0,v=0,w=0.0,x=0.0,y=0.0,z=0,A=0;g=c[3524]|0;i=(b&3|0)==1;j=(b&-4|0)==4;if(e>>>0>3){k=64768+(e*688&-1)|0;l=64772+(e*688&-1)|0}else{k=64772+(e*688&-1)|0;l=64768+(e*688&-1)|0}m=c[k>>2]|0;k=c[l>>2]|0;l=64916+(b*688&-1)|0;if((c[l>>2]|0)==0){return}n=65032+(b*688&-1)|0;o=c[n>>2]|0;do{if((o|0)==-270){if((cO[c[g+72>>2]&255](-270)|0)==0){p=c[n>>2]|0;q=441;break}if(i){c[1398]=1;r=j?0:2}else{c[1398]=j?0:2;r=1}c[1384]=r;c[6586]=-270;if((b|0)!=1){break}c[d>>2]=(c[d>>2]|0)+((c[g+16>>2]|0)>>>1)}else{p=o;q=441}}while(0);L599:do{if((q|0)==441){do{if((p|0)!=0){if((cO[c[g+72>>2]&255](p)|0)==0){break}if((b|0)==5){c[1398]=0}else if((b|0)==2){c[1398]=0}else if((b|0)==6){c[1398]=0}else if((b|0)==1){c[d>>2]=~~(+(c[d>>2]|0)+ +((c[g+20>>2]|0)>>>0>>>0)*2.5);c[1398]=2}else{c[1398]=0}c[1384]=1;c[6586]=c[n>>2];break L599}}while(0);if(i){c[1398]=j?0:2;s=1}else{c[1398]=1;s=j?2:0}c[1384]=s;c[6586]=0}}while(0);if((a[65272+(b*688&-1)|0]&1)==0){c[65128+(b*688&-1)>>2]=c[1398]}else{c[1398]=c[65128+(b*688&-1)>>2]}s=c[l>>2]|0;l=(s&4|0)==0;c[1396]=l?-1:m;do{if((s&2|0)==0){q=481}else{if((a[64788+(e*688&-1)|0]&1)!=0){q=481;break}t=+h[64664+(e*688&-1)>>3];u=+h[64672+(e*688&-1)>>3];if(t<u){if(t>0.0|u<0.0){q=481;break}}else{if(u>0.0|t<0.0){q=481;break}}m=~~(+(c[64768+(e*688&-1)>>2]|0)+(0.0-t)*+h[64776+(e*688&-1)>>3]+.5);c[1394]=m;n=j?1:-1;c[1400]=n;if(!l){c[1396]=m}p=aa(m-k|0,j?-1:1);if(i){o=g+20|0;do{if(p>>>0>((c[o>>2]|0)*3&-1)>>>0){q=469}else{r=c[11692]|0;if(j){if((r&8|0)==0){q=469;break}else{v=k;break}}else{if((r&2|0)==0){q=469;break}else{v=k;break}}}}while(0);if((q|0)==469){v=m}c[1392]=v;c[1392]=aa(c[o>>2]|0,n)+v;break}r=g+16|0;do{if(p>>>0>c[r>>2]<<1>>>0){t=+(m|0);if(j){w=0.0;x=t;q=479}else{y=t;q=478}}else{z=c[11692]|0;if(j){if((z&4|0)!=0){A=k;break}w=0.0;x=+(m|0);q=479;break}else{if((z&1|0)!=0){A=k;break}y=+(m|0);q=478;break}}}while(0);if((q|0)==478){w=+((c[g+24>>2]|0)>>>0>>>0)*(-0.0- +h[65056+(b*688&-1)>>3]);x=y;q=479}if((q|0)==479){A=~~(x+w)}c[1392]=A;c[1392]=A-(c[r>>2]|0)}}while(0);if((q|0)==481){c[1394]=k;c[1400]=aa((a[65072+(b*688&-1)|0]&1)!=0?1:-1,j?-1:1);c[1392]=c[d>>2]}de(b,f);cO[c[g+72>>2]&255](0);return}function dg(b,d){b=b|0;d=d|0;var e=0,f=0,g=0.0,j=0.0,k=0.0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;e=i;i=i+16|0;f=e|0;g=+h[64664+(d*688&-1)>>3];if(g>0.0){j=+h[64672+(d*688&-1)>>3];if(j>0.0){k=j}else{l=488}}else{l=488}do{if((l|0)==488){if((a[64788+(d*688&-1)|0]&1)!=0){k=+h[64672+(d*688&-1)>>3];break}do{if(g<0.0){j=+h[64672+(d*688&-1)>>3];if(j>=0.0){break}if(j<g){m=64768+(d*688&-1)|0}else{m=64772+(d*688&-1)|0}c[64784+(d*688&-1)>>2]=c[m>>2];i=e;return}}while(0);c[64784+(d*688&-1)>>2]=~~(+(c[64768+(d*688&-1)>>2]|0)+(0.0-g)*+h[64776+(d*688&-1)>>3]+.5);n=c[65284+(b*688&-1)>>2]|0;if((n|0)<=-3){i=e;return}o=f;p=65320+(b*688&-1)|0;c[o>>2]=c[p>>2];c[o+4>>2]=c[p+4>>2];c[o+8>>2]=c[p+8>>2];c[o+12>>2]=c[p+12>>2];do{if((c[65280+(b*688&-1)>>2]|0)!=0){j=+h[65304+(b*688&-1)>>3];p=c[(c[3524]|0)+92>>2]|0;if(j<0.0){cK[p&63](+h[3817]);break}else{cK[p&63](j);break}}}while(0);cK[c[(c[3524]|0)+112>>2]&63](+h[65296+(b*688&-1)>>3]);p=c[(c[3524]|0)+64>>2]|0;if((n|0)<-5){cM[p&511](-2)}else{cM[p&511](n)}p=c[3524]|0;do{if((a[65312+(b*688&-1)|0]&1)==0){if((c[p+96>>2]&1024|0)!=0){q=p;break}c[f>>2]=1;c[f+4>>2]=n;l=511}else{l=511}}while(0);if((l|0)==511){fn(f,p);q=c[3524]|0}n=c[q+56>>2]|0;if((b&3|0)==2){o=64784+(d*688&-1)|0;cN[n&255](c[64768+(b*688&-1)>>2]|0,c[o>>2]|0);cN[c[(c[3524]|0)+60>>2]&255](c[64772+(b*688&-1)>>2]|0,c[o>>2]|0);i=e;return}else{o=64784+(d*688&-1)|0;cN[n&255](c[o>>2]|0,c[64768+(b*688&-1)>>2]|0);cN[c[(c[3524]|0)+60>>2]&255](c[o>>2]|0,c[64772+(b*688&-1)>>2]|0);i=e;return}}}while(0);if(k<g){r=64772+(d*688&-1)|0}else{r=64768+(d*688&-1)|0}c[64784+(d*688&-1)>>2]=c[r>>2];i=e;return}function dh(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0.0,L=0.0,M=0.0,N=0.0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0.0,V=0.0,W=0.0;g=i;i=i+208|0;j=g|0;k=g+24|0;l=g+48|0;m=g+72|0;n=g+96|0;o=g+144|0;p=g+152|0;q=g+200|0;r=(f|0)==1;s=(f|0)==2;if((f-1|0)>>>0>=2){uf(-1,113648,(v=i,i=i+8|0,c[v>>2]=133592,v)|0)}t=c[13898]|0;u=(c[8272]|0)>(t|0);L710:do{if(u){w=c[1054]|0;if((a[w+(t*40&-1)|0]&1)==0){x=533;break}y=c[w+(t*40&-1)+36>>2]|0;z=w+(t*40&-1)+32|0;w=c[10036]|0;A=0;while(1){if((A|0)>=(y|0)){break}if((a[w+((c[z>>2]|0)+A|0)|0]|0)==(a[A+134808|0]|0)){A=A+1|0}else{x=533;break L710}}if((A|0)!=1){x=533;break}c[e>>2]=c[e>>2]|f;if(r){z=64728+(b*688&-1)|0;c[z>>2]=c[z>>2]&-2;h[64736+(b*688&-1)>>3]=0.0}else{z=64732+(b*688&-1)|0;c[z>>2]=c[z>>2]&-2;h[64752+(b*688&-1)>>3]=0.0}z=(c[13898]|0)+1|0;c[13898]=z;B=z}else{x=533}}while(0);L722:do{if((x|0)==533){a[25288]=1;L724:do{if((c[64808+(b*688&-1)>>2]|0)==1){z=c[1054]|0;w=(a[z+(t*40&-1)|0]&1)==0;if(w){x=536}else{y=c[10036]|0;C=a[y+(c[z+(t*40&-1)+32>>2]|0)|0]|0;if((C<<24>>24|0)==39|(C<<24>>24|0)==34){D=y}else{x=536}}if((x|0)==536){y=c[10810]|0;if((y|0)==0){x=558;break}C=z+(t*40&-1)+36|0;E=z+(t*40&-1)+32|0;F=c[10036]|0;G=y;L731:while(1){y=c[G+4>>2]|0;L733:do{if(!(w|u^1)){H=c[C>>2]|0;I=0;while(1){if((I|0)>=(H|0)){break}if((a[F+((c[E>>2]|0)+I|0)|0]|0)==(a[y+I|0]|0)){I=I+1|0}else{break L733}}if((a[y+I|0]|0)==0){break L731}}}while(0);y=c[G>>2]|0;if((y|0)==0){x=558;break L724}else{G=y}}if((a[G+8|0]&1)!=0){x=558;break}if((c[G+16>>2]|0)==3){D=F}else{x=558;break}}L743:do{if(u){L745:do{if(!w){E=c[z+(t*40&-1)+36>>2]|0;C=z+(t*40&-1)+32|0;y=0;while(1){if((y|0)>=(E|0)){break}if((a[D+((c[C>>2]|0)+y|0)|0]|0)==(a[y+103664|0]|0)){y=y+1|0}else{break L745}}if((y|0)==1){J=0;break L743}}}while(0);a[14176]=1;is(m);a[14176]=0;if((c[m>>2]|0)==3){J=c[m+8>>2]|0;break}else{c[13898]=t;J=0;break}}else{J=0}}while(0);if((t1(J,64813+(b*688&-1)|0,n,o)|0)==0){K=0.0}else{L=+t2(n);K=L+ +h[o>>3]}uu(J);M=K}else{x=558}}while(0);do{if((x|0)==558){A=is(l)|0;z=c[A>>2]|0;if((z|0)==1){N=+(c[A+8>>2]|0)}else if((z|0)==2){N=+h[A+8>>3]}else if((z|0)==3){N=+uz(c[A+8>>2]|0,0)}else{uf(-1,213288,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}A=l|0;if((c[A>>2]|0)!=3){M=N;break}uu(c[l+8>>2]|0);c[A>>2]=1;M=N}}while(0);a[25288]=0;A=c[13898]|0;z=c[8272]|0;if((A|0)>=(z|0)){uf(A,129840,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}w=c[1054]|0;F=(a[w+(A*40&-1)|0]&1)==0;L772:do{if(!F){G=c[w+(A*40&-1)+36>>2]|0;C=w+(A*40&-1)+32|0;E=c[10036]|0;I=0;while(1){if((I|0)>=(G|0)){x=570;break}if((a[E+((c[C>>2]|0)+I|0)|0]|0)==(a[I+103664|0]|0)){I=I+1|0}else{break}}do{if((x|0)==570){if((I|0)!=1){break}uf(A,129840,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}}while(0);if(F){break}I=c[w+(A*40&-1)+36>>2]|0;C=w+(A*40&-1)+32|0;E=c[10036]|0;G=0;while(1){if((G|0)>=(I|0)){x=576;break}if((a[E+((c[C>>2]|0)+G|0)|0]|0)==(a[G+136608|0]|0)){G=G+1|0}else{break}}do{if((x|0)==576){if((G|0)!=1){break}C=A+1|0;c[13898]=C;if((C|0)>=(z|0)){uf(C,127176,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}I=(a[w+(C*40&-1)|0]&1)==0;if(I){uf(C,126040,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}H=c[w+(C*40&-1)+36>>2]|0;O=w+(C*40&-1)+32|0;P=0;while(1){if((P|0)>=(H|0)){x=582;break}if((a[E+((c[O>>2]|0)+P|0)|0]|0)==(a[P+103664|0]|0)){P=P+1|0}else{break}}do{if((x|0)==582){if((P|0)!=1){break}uf(C,127176,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}}while(0);if(I){uf(C,126040,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}P=c[w+(C*40&-1)+36>>2]|0;O=w+(C*40&-1)+32|0;H=0;while(1){if((H|0)>=(P|0)){break}if((a[E+((c[O>>2]|0)+H|0)|0]|0)==(a[H+134808|0]|0)){H=H+1|0}else{x=695;break}}if((x|0)==695){uf(C,126040,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}if((H|0)!=1){uf(C,126040,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}c[e>>2]=c[e>>2]|f;if(r){O=64728+(b*688&-1)|0;c[O>>2]=c[O>>2]|1;h[64736+(b*688&-1)>>3]=M}else{O=64732+(b*688&-1)|0;c[O>>2]=c[O>>2]|1;h[64752+(b*688&-1)>>3]=M}O=(c[13898]|0)+1|0;c[13898]=O;B=O;break L722}}while(0);if(F){break}E=c[w+(A*40&-1)+36>>2]|0;G=w+(A*40&-1)+32|0;O=c[10036]|0;P=0;while(1){if((P|0)>=(E|0)){break}if((a[O+((c[G>>2]|0)+P|0)|0]|0)==(a[P+138304|0]|0)){P=P+1|0}else{break L772}}if((P|0)!=1){break}uf(A,123680,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}}while(0);c[e>>2]=c[e>>2]&(f^-1);if(r){c[64728+(b*688&-1)>>2]=0;h[64744+(b*688&-1)>>3]=0.0}else{c[64732+(b*688&-1)>>2]=0;h[64760+(b*688&-1)>>3]=0.0}h[d>>3]=M;B=c[13898]|0}}while(0);d=c[8272]|0;l=(B|0)>=(d|0);L830:do{if((c[e>>2]&f|0)==0){if(l){break}J=c[1054]|0;L923:do{if((a[J+(B*40&-1)|0]&1)!=0){o=c[J+(B*40&-1)+36>>2]|0;n=J+(B*40&-1)+32|0;t=c[10036]|0;m=0;while(1){if((m|0)>=(o|0)){break}if((a[t+((c[n>>2]|0)+m|0)|0]|0)==(a[m+103664|0]|0)){m=m+1|0}else{break L923}}if((m|0)==1){break L830}}}while(0);J=c[1054]|0;L930:do{if((a[J+(B*40&-1)|0]&1)!=0){n=c[J+(B*40&-1)+36>>2]|0;t=J+(B*40&-1)+32|0;o=c[10036]|0;P=0;while(1){if((P|0)>=(n|0)){break}if((a[o+((c[t>>2]|0)+P|0)|0]|0)==(a[P+136608|0]|0)){P=P+1|0}else{break L930}}if((P|0)!=1){break}uf(B,122232,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}}while(0);J=c[1054]|0;if((a[J+(B*40&-1)|0]&1)==0){break}t=c[J+(B*40&-1)+36>>2]|0;o=J+(B*40&-1)+32|0;J=c[10036]|0;n=0;while(1){if((n|0)>=(t|0)){break}if((a[J+((c[o>>2]|0)+n|0)|0]|0)==(a[n+138304|0]|0)){n=n+1|0}else{break L830}}if((n|0)!=1){break}uf(B,122232,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}else{if(l){uf(B,129840,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}o=c[1054]|0;L835:do{if((a[o+(B*40&-1)|0]&1)!=0){J=c[o+(B*40&-1)+36>>2]|0;t=o+(B*40&-1)+32|0;m=c[10036]|0;D=0;while(1){if((D|0)>=(J|0)){break}if((a[m+((c[t>>2]|0)+D|0)|0]|0)==(a[D+103664|0]|0)){D=D+1|0}else{break L835}}if((D|0)!=1){break}uf(B,129840,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}}while(0);o=c[1054]|0;L843:do{if((a[o+(B*40&-1)|0]&1)!=0){n=c[o+(B*40&-1)+36>>2]|0;t=o+(B*40&-1)+32|0;m=c[10036]|0;J=0;while(1){if((J|0)>=(n|0)){break}if((a[m+((c[t>>2]|0)+J|0)|0]|0)==(a[J+136608|0]|0)){J=J+1|0}else{break L843}}if((J|0)!=1){break}t=B+1|0;c[13898]=t;if((t|0)>=(d|0)){uf(t,127176,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}n=(a[o+(t*40&-1)|0]&1)==0;L853:do{if(!n){D=c[o+(t*40&-1)+36>>2]|0;P=o+(t*40&-1)+32|0;u=0;while(1){if((u|0)>=(D|0)){break}if((a[m+((c[P>>2]|0)+u|0)|0]|0)==(a[u+103664|0]|0)){u=u+1|0}else{break L853}}if((u|0)!=1){break}uf(t,127176,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}}while(0);L861:do{if((c[64808+(b*688&-1)>>2]|0)==1){do{if(n){x=627}else{J=a[m+(c[o+(t*40&-1)+32>>2]|0)|0]|0;if(!((J<<24>>24|0)==39|(J<<24>>24|0)==34)){x=627;break}Q=j;x=639}}while(0);if((x|0)==627){u=c[10810]|0;if((u|0)==0){x=649;break}J=o+(t*40&-1)+36|0;P=o+(t*40&-1)+32|0;D=u;L869:while(1){u=c[D+4>>2]|0;L871:do{if(!n){C=c[J>>2]|0;H=0;while(1){if((H|0)>=(C|0)){break}if((a[m+((c[P>>2]|0)+H|0)|0]|0)==(a[u+H|0]|0)){H=H+1|0}else{break L871}}if((a[u+H|0]|0)==0){break L869}}}while(0);u=c[D>>2]|0;if((u|0)==0){x=649;break L861}else{D=u}}if((a[D+8|0]&1)!=0){x=649;break}if((c[D+16>>2]|0)!=3){x=649;break}P=j;if(n){R=P;x=643}else{Q=P;x=639}}L881:do{if((x|0)==639){P=c[o+(t*40&-1)+36>>2]|0;J=o+(t*40&-1)+32|0;u=0;while(1){if((u|0)>=(P|0)){break}if((a[m+((c[J>>2]|0)+u|0)|0]|0)==(a[u+103664|0]|0)){u=u+1|0}else{R=Q;x=643;break L881}}if((u|0)==1){S=0;T=Q}else{R=Q;x=643}}}while(0);do{if((x|0)==643){a[14176]=1;is(j);a[14176]=0;if((c[j>>2]|0)==3){S=c[j+8>>2]|0;T=R;break}else{c[13898]=t;S=0;T=R;break}}}while(0);if((t1(S,64813+(b*688&-1)|0,p,q)|0)==0){U=0.0}else{M=+t2(p);U=M+ +h[q>>3]}uu(S);V=U}else{x=649}}while(0);do{if((x|0)==649){t=is(k)|0;m=c[t>>2]|0;if((m|0)==1){W=+(c[t+8>>2]|0)}else if((m|0)==2){W=+h[t+8>>3]}else if((m|0)==3){W=+uz(c[t+8>>2]|0,0)}else{uf(-1,213288,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}t=k|0;if((c[t>>2]|0)!=3){V=W;break}uu(c[k+8>>2]|0);c[t>>2]=1;V=W}}while(0);if(r){t=64728+(b*688&-1)|0;c[t>>2]=c[t>>2]|2;h[64744+(b*688&-1)>>3]=V;break L830}else{t=64732+(b*688&-1)|0;c[t>>2]=c[t>>2]|2;h[64760+(b*688&-1)>>3]=V;break L830}}}while(0);o=c[1054]|0;L910:do{if((a[o+(B*40&-1)|0]&1)!=0){t=c[o+(B*40&-1)+36>>2]|0;m=o+(B*40&-1)+32|0;n=c[10036]|0;D=0;while(1){if((D|0)>=(t|0)){break}if((a[n+((c[m>>2]|0)+D|0)|0]|0)==(a[D+138304|0]|0)){D=D+1|0}else{break L910}}if((D|0)!=1){break}uf(B,123680,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}}while(0);if(r){o=64728+(b*688&-1)|0;c[o>>2]=c[o>>2]&-3;h[64744+(b*688&-1)>>3]=0.0;break}else{o=64732+(b*688&-1)|0;c[o>>2]=c[o>>2]&-3;h[64760+(b*688&-1)>>3]=0.0;break}}}while(0);if((c[e>>2]&f|0)==0){i=g;return}do{if(r){f=64728+(b*688&-1)|0;if((c[f>>2]|0)!=3){break}if(+h[64744+(b*688&-1)>>3]>=+h[64736+(b*688&-1)>>3]){break}uh(c[13898]|0,120752,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);c[f>>2]=0}}while(0);if(!s){i=g;return}s=64732+(b*688&-1)|0;if((c[s>>2]|0)!=3){i=g;return}if(+h[64760+(b*688&-1)>>3]>=+h[64752+(b*688&-1)>>3]){i=g;return}uh(c[13898]|0,120752,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);c[s>>2]=0;i=g;return}function di(a,b,d,e,f){a=a|0;b=+b;d=d|0;e=e|0;f=f|0;f=i;a=e;e=i;i=i+56|0;uD(e,a,56);do{if((d|0)!=0){a=ga(d,0)|0;if((a|0)<=(c[216]|0)){break}c[216]=a}}while(0);i=f;return}function dj(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,w=0,x=0,y=0,z=0.0,A=0.0;g=i;i=i+8|0;j=g|0;c[j>>2]=f;k=c[13898]|0;l=c[8272]|0;m=(l|0)>(k|0);if(!m){uf(k,116248,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}n=c[1054]|0;do{if((a[n+(k*40&-1)|0]&1)!=0){o=c[n+(k*40&-1)+36>>2]|0;p=n+(k*40&-1)+32|0;q=c[10036]|0;r=0;while(1){if((r|0)>=(o|0)){s=723;break}if((a[q+((c[p>>2]|0)+r|0)|0]|0)==(a[r+78864|0]|0)){r=r+1|0}else{break}}do{if((s|0)==723){if((r|0)!=1){break}c[64728+(b*688&-1)>>2]=0;c[64732+(b*688&-1)>>2]=0;t=f;i=g;return t|0}}while(0);if(m){break}uf(k,116248,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}}while(0);m=c[1054]|0;f=(a[m+(k*40&-1)|0]&1)==0;L984:do{if(f){s=742}else{n=c[m+(k*40&-1)+36>>2]|0;r=m+(k*40&-1)+32|0;p=c[10036]|0;q=0;while(1){if((q|0)>=(n|0)){s=730;break}if((a[p+((c[r>>2]|0)+q|0)|0]|0)==(a[q+103664|0]|0)){q=q+1|0}else{break}}do{if((s|0)==730){if((q|0)!=1){break}uf(k,116248,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}}while(0);if(f){s=742;break}q=c[m+(k*40&-1)+36>>2]|0;r=m+(k*40&-1)+32|0;p=c[10036]|0;n=0;while(1){if((n|0)>=(q|0)){s=736;break}if((a[p+((c[r>>2]|0)+n|0)|0]|0)==(a[n+187176|0]|0)){n=n+1|0}else{break}}if((s|0)==736){if((n|0)==2){u=k;w=l;break}}if(f){s=742;break}r=c[m+(k*40&-1)+36>>2]|0;p=m+(k*40&-1)+32|0;q=c[10036]|0;o=0;while(1){if((o|0)>=(r|0)){break}if((a[q+((c[p>>2]|0)+o|0)|0]|0)==(a[o+183584|0]|0)){o=o+1|0}else{s=742;break L984}}if((o|0)==1){u=k;w=l}else{s=742}}}while(0);if((s|0)==742){dh(b,d,j,1);u=c[13898]|0;w=c[8272]|0}l=(w|0)>(u|0);if(!l){uf(u,114504,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}k=c[1054]|0;do{if((a[k+(u*40&-1)|0]&1)==0){s=750}else{m=c[k+(u*40&-1)+36>>2]|0;f=k+(u*40&-1)+32|0;p=c[10036]|0;q=0;while(1){if((q|0)>=(m|0)){s=748;break}if((a[p+((c[f>>2]|0)+q|0)|0]|0)==(a[q+187176|0]|0)){q=q+1|0}else{break}}if((s|0)==748){if((q|0)==2){x=k;y=p;break}}if(l){s=750;break}uf(u,114504,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}}while(0);do{if((s|0)==750){l=c[1054]|0;if((a[l+(u*40&-1)|0]&1)==0){uf(u,114504,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}k=c[l+(u*40&-1)+36>>2]|0;f=l+(u*40&-1)+32|0;m=c[10036]|0;o=0;while(1){if((o|0)>=(k|0)){break}if((a[m+((c[f>>2]|0)+o|0)|0]|0)==(a[o+183584|0]|0)){o=o+1|0}else{s=774;break}}if((s|0)==774){uf(u,114504,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}if((o|0)==1){x=l;y=m;break}uf(u,114504,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}}while(0);f=u+1|0;c[13898]=f;L1033:do{if((w|0)>(f|0)){if((a[x+(f*40&-1)|0]&1)==0){s=762;break}u=c[x+(f*40&-1)+36>>2]|0;k=x+(f*40&-1)+32|0;p=0;while(1){if((p|0)>=(u|0)){break}if((a[y+((c[k>>2]|0)+p|0)|0]|0)==(a[p+78864|0]|0)){p=p+1|0}else{s=762;break L1033}}if((p|0)!=1){s=762}}else{s=762}}while(0);if((s|0)==762){dh(b,e,j,2)}s=c[j>>2]|0;if((s&3|0)!=0){t=s;i=g;return t|0}z=+h[e>>3];A=+h[d>>3];if(z>=A){t=s;i=g;return t|0}h[d>>3]=z;h[e>>3]=A;e=64656+(b*688&-1)|0;c[e>>2]=c[e>>2]|2;t=s;i=g;return t|0}function dk(){var b=0,d=0,e=0.0,f=0.0,g=0.0,j=0,k=0.0,l=0.0,m=0.0,n=0.0;b=i;d=c[16679]|0;e=+h[8341];if((d&1|0)==0|e<8.988465674311579e+307){f=e}else{e=+h[64664+((c[34]|0)*688&-1)>>3];if((a[64788]&1)==0){g=e}else{g=+Z(+(e*+h[8100]))}h[8341]=g;f=g}j=(a[66852]&1)==0;do{if(j){k=f}else{if(f>0.0){g=+_(+f);k=g/+h[8358];break}else{uk(210984,(v=i,i=i+24|0,c[v>>2]=112752,c[v+8>>2]=56904,h[v+16>>3]=f,v)|0);return 0}}}while(0);h[8341]=k;f=+h[8342];if((d&2|0)==0|f>-8.988465674311579e+307){l=f}else{f=+h[64672+((c[34]|0)*688&-1)>>3];if((a[64788]&1)==0){m=f}else{m=+Z(+(f*+h[8100]))}h[8342]=m;l=m}do{if(j){n=l}else{if(l>0.0){m=+_(+l);n=m/+h[8358];break}else{uk(210984,(v=i,i=i+24|0,c[v>>2]=112752,c[v+8>>2]=56904,h[v+16>>3]=l,v)|0);return 0}}}while(0);h[8342]=n;if(k<=n){i=b;return 1}h[8342]=k;h[8341]=n;i=b;return 1}function dl(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0.0,M=0.0,N=0,O=0,P=0,Q=0.0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0.0;e=i;i=i+328|0;f=e|0;g=e+24|0;j=e+48|0;k=e+72|0;l=e+96|0;m=e+120|0;n=e+144|0;o=e+152|0;p=e+160|0;q=e+208|0;r=e+216|0;s=e+264|0;t=e+272|0;u=e+320|0;c[o>>2]=d;uE(b|0,0,40);dm(o,n);d=c[o>>2]|0;c[b>>2]=d;w=c[n>>2]|0;L1080:do{if((w|0)>-1){if((c[64808+((w+2|0)*688&-1)>>2]|0)!=1){x=826;break}y=c[13898]|0;z=c[1054]|0;A=(a[z+(y*40&-1)|0]&1)==0;if(A){x=804}else{B=c[10036]|0;C=a[B+(c[z+(y*40&-1)+32>>2]|0)|0]|0;if((C<<24>>24|0)==39|(C<<24>>24|0)==34){D=B}else{x=804}}if((x|0)==804){B=c[10810]|0;if((B|0)==0){x=826;break}C=c[8272]|0;E=z+(y*40&-1)+36|0;F=z+(y*40&-1)+32|0;G=c[10036]|0;H=B;L1088:while(1){B=c[H+4>>2]|0;L1090:do{if(!((C|0)<=(y|0)|A)){I=c[E>>2]|0;J=0;while(1){if((J|0)>=(I|0)){break}if((a[G+((c[F>>2]|0)+J|0)|0]|0)==(a[B+J|0]|0)){J=J+1|0}else{break L1090}}if((a[B+J|0]|0)==0){break L1088}}}while(0);B=c[H>>2]|0;if((B|0)==0){x=826;break L1080}else{H=B}}if((a[H+8|0]&1)!=0){x=826;break}if((c[H+16>>2]|0)==3){D=G}else{x=826;break}}L1100:do{if((y|0)<(c[8272]|0)){L1102:do{if(!A){F=c[z+(y*40&-1)+36>>2]|0;E=z+(y*40&-1)+32|0;C=0;while(1){if((C|0)>=(F|0)){break}if((a[D+((c[E>>2]|0)+C|0)|0]|0)==(a[C+103664|0]|0)){C=C+1|0}else{break L1102}}if((C|0)==1){K=0;break L1100}}}while(0);a[14176]=1;is(l);a[14176]=0;if((c[l>>2]|0)==3){K=c[l+8>>2]|0;break}else{c[13898]=y;K=0;break}}else{K=0}}while(0);if((t1(K,66189,p,q)|0)!=0){L=+t2(p);h[b+16>>3]=L+ +h[q>>3]}uu(K)}else{x=826}}while(0);if((x|0)==826){K=is(k)|0;q=c[K>>2]|0;if((q|0)==1){M=+(c[K+8>>2]|0)}else if((q|0)==2){M=+h[K+8>>3]}else if((q|0)==3){M=+uz(c[K+8>>2]|0,0)}else{uf(-1,213288,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}K=k|0;if((c[K>>2]|0)==3){uu(c[k+8>>2]|0);c[K>>2]=1}h[b+16>>3]=M}K=c[13898]|0;L1128:do{if((c[8272]|0)>(K|0)){k=c[1054]|0;if((a[k+(K*40&-1)|0]&1)==0){x=874;break}q=c[k+(K*40&-1)+36>>2]|0;p=k+(K*40&-1)+32|0;k=c[10036]|0;l=0;while(1){if((l|0)>=(q|0)){break}if((a[k+((c[p>>2]|0)+l|0)|0]|0)==(a[l+148464|0]|0)){l=l+1|0}else{x=874;break L1128}}if((l|0)!=1){x=874;break}c[13898]=K+1;dm(o,n);p=c[o>>2]|0;c[b+4>>2]=p;k=c[n>>2]|0;L1136:do{if((k|0)>-1){if((c[64808+((k+1|0)*688&-1)>>2]|0)!=1){break}q=c[13898]|0;D=c[1054]|0;w=(a[D+(q*40&-1)|0]&1)==0;if(w){x=844}else{y=c[10036]|0;z=a[y+(c[D+(q*40&-1)+32>>2]|0)|0]|0;if((z<<24>>24|0)==39|(z<<24>>24|0)==34){N=y}else{x=844}}if((x|0)==844){y=c[10810]|0;if((y|0)==0){break}z=c[8272]|0;A=D+(q*40&-1)+36|0;G=D+(q*40&-1)+32|0;H=c[10036]|0;E=y;L1144:while(1){y=c[E+4>>2]|0;L1146:do{if(!((z|0)<=(q|0)|w)){F=c[A>>2]|0;J=0;while(1){if((J|0)>=(F|0)){break}if((a[H+((c[G>>2]|0)+J|0)|0]|0)==(a[y+J|0]|0)){J=J+1|0}else{break L1146}}if((a[y+J|0]|0)==0){break L1144}}}while(0);y=c[E>>2]|0;if((y|0)==0){break L1136}else{E=y}}if((a[E+8|0]&1)!=0){break}if((c[E+16>>2]|0)==3){N=H}else{break}}L1156:do{if((q|0)<(c[8272]|0)){L1158:do{if(!w){G=c[D+(q*40&-1)+36>>2]|0;A=D+(q*40&-1)+32|0;z=0;while(1){if((z|0)>=(G|0)){break}if((a[N+((c[A>>2]|0)+z|0)|0]|0)==(a[z+103664|0]|0)){z=z+1|0}else{break L1158}}if((z|0)==1){O=0;break L1156}}}while(0);a[14176]=1;is(j);a[14176]=0;if((c[j>>2]|0)==3){O=c[j+8>>2]|0;break}else{c[13898]=q;O=0;break}}else{O=0}}while(0);if((t1(O,65501,r,s)|0)!=0){M=+t2(r);h[b+24>>3]=M+ +h[s>>3]}uu(O);P=p;break L1128}}while(0);k=is(g)|0;l=c[k>>2]|0;if((l|0)==1){Q=+(c[k+8>>2]|0)}else if((l|0)==2){Q=+h[k+8>>3]}else if((l|0)==3){Q=+uz(c[k+8>>2]|0,0)}else{uf(-1,213288,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}k=g|0;if((c[k>>2]|0)==3){uu(c[g+8>>2]|0);c[k>>2]=1}h[b+24>>3]=Q;P=p}else{x=874}}while(0);if((x|0)==874){h[b+24>>3]=0.0;c[b+4>>2]=d;P=d}d=c[13898]|0;g=c[8272]|0;L1185:do{if((g|0)>(d|0)){O=c[1054]|0;if((a[O+(d*40&-1)|0]&1)==0){break}s=c[O+(d*40&-1)+36>>2]|0;r=O+(d*40&-1)+32|0;j=c[10036]|0;N=0;while(1){if((N|0)>=(s|0)){break}if((a[j+((c[r>>2]|0)+N|0)|0]|0)==(a[N+148464|0]|0)){N=N+1|0}else{break L1185}}if((N|0)!=1){break}r=d+1|0;s=(a[O+(r*40&-1)|0]&1)==0;if(!s){p=a[j+(c[O+(r*40&-1)+32>>2]|0)|0]|0;if((p<<24>>24|0)==39|(p<<24>>24|0)==34){break}}p=c[10810]|0;L1196:do{if((p|0)==0){R=O+(r*40&-1)+36|0;S=O+(r*40&-1)+32|0}else{K=O+(r*40&-1)+36|0;k=O+(r*40&-1)+32|0;l=p;L1199:while(1){q=c[l+4>>2]|0;L1201:do{if(!((g|0)<=(r|0)|s)){D=c[K>>2]|0;w=0;while(1){if((w|0)>=(D|0)){break}if((a[j+((c[k>>2]|0)+w|0)|0]|0)==(a[q+w|0]|0)){w=w+1|0}else{break L1201}}if((a[q+w|0]|0)==0){break L1199}}}while(0);q=c[l>>2]|0;if((q|0)==0){R=K;S=k;break L1196}else{l=q}}if((a[l+8|0]&1)!=0){R=K;S=k;break}if((c[l+16>>2]|0)==3){break L1185}else{R=K;S=k}}}while(0);p=c[R>>2]|0;O=c[S>>2]|0;L1211:do{if((p|0)>0&(s^1)){N=0;q=0;D=O;while(1){if((a[N+205224|0]|0)==(a[j+(N+D|0)|0]|0)){T=D;U=q}else{if((N|0)!=7){break}T=D-1|0;U=1}z=N+1|0;if((z|0)<(U+p|0)){N=z;q=U;D=T}else{x=899;break}}if((x|0)==899){if((U|0)!=0){break L1185}if((N|0)==6|(N|0)==12){break L1185}}if((p|0)>0&(s^1)){V=0}else{break}do{if((a[V+217064|0]|0)!=(a[j+(V+O|0)|0]|0)){break L1211}V=V+1|0;}while((V|0)<(p|0));if((V|0)==3){break L1185}}}while(0);c[13898]=r;dm(o,n);c[b+8>>2]=c[o>>2];p=c[n>>2]|0;L1227:do{if((p|0)>-1){if((c[64808+(p*688&-1)>>2]|0)!=1){break}O=c[13898]|0;j=c[1054]|0;s=(a[j+(O*40&-1)|0]&1)==0;if(s){x=909}else{N=c[10036]|0;D=a[N+(c[j+(O*40&-1)+32>>2]|0)|0]|0;if((D<<24>>24|0)==39|(D<<24>>24|0)==34){W=N}else{x=909}}if((x|0)==909){N=c[10810]|0;if((N|0)==0){break}D=c[8272]|0;q=j+(O*40&-1)+36|0;k=j+(O*40&-1)+32|0;K=c[10036]|0;l=N;L1235:while(1){N=c[l+4>>2]|0;L1237:do{if(!((D|0)<=(O|0)|s)){z=c[q>>2]|0;H=0;while(1){if((H|0)>=(z|0)){break}if((a[K+((c[k>>2]|0)+H|0)|0]|0)==(a[N+H|0]|0)){H=H+1|0}else{break L1237}}if((a[N+H|0]|0)==0){break L1235}}}while(0);N=c[l>>2]|0;if((N|0)==0){break L1227}else{l=N}}if((a[l+8|0]&1)!=0){break}if((c[l+16>>2]|0)==3){W=K}else{break}}L1247:do{if((O|0)<(c[8272]|0)){L1249:do{if(!s){k=c[j+(O*40&-1)+36>>2]|0;q=j+(O*40&-1)+32|0;D=0;while(1){if((D|0)>=(k|0)){break}if((a[W+((c[q>>2]|0)+D|0)|0]|0)==(a[D+103664|0]|0)){D=D+1|0}else{break L1249}}if((D|0)==1){X=0;break L1247}}}while(0);a[14176]=1;is(f);a[14176]=0;if((c[f>>2]|0)==3){X=c[f+8>>2]|0;break}else{c[13898]=O;X=0;break}}else{X=0}}while(0);if((t1(X,64813,t,u)|0)!=0){Q=+t2(t);h[b+32>>3]=Q+ +h[u>>3]}uu(X);i=e;return}}while(0);p=is(m)|0;r=c[p>>2]|0;if((r|0)==1){Y=+(c[p+8>>2]|0)}else if((r|0)==2){Y=+h[p+8>>3]}else if((r|0)==3){Y=+uz(c[p+8>>2]|0,0)}else{uf(-1,213288,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}p=m|0;if((c[p>>2]|0)==3){uu(c[m+8>>2]|0);c[p>>2]=1}h[b+32>>3]=Y;i=e;return}}while(0);h[b+32>>3]=0.0;c[b+8>>2]=P;i=e;return}function dm(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;e=c[13898]|0;f=c[1054]|0;g=c[f+(e*40&-1)+36>>2]|0;h=c[f+(e*40&-1)+32>>2]|0;i=(a[f+(e*40&-1)|0]&1)==0;L1278:do{if((g|0)>0&(i^1)){f=c[10036]|0;j=0;k=0;l=h;while(1){if((a[j+101440|0]|0)==(a[f+(j+l|0)|0]|0)){m=l;n=k}else{if((j|0)!=3){break}m=l-1|0;n=1}o=j+1|0;if((o|0)<(n+g|0)){j=o;k=n;l=m}else{p=950;break}}do{if((p|0)==950){if((n|0)==0){if(!((j|0)==5|(j|0)==2)){break}}c[13898]=e+1;c[b>>2]=0;p=990;break L1278}}while(0);if(!((g|0)>0&(i^1))){p=989;break}j=c[10036]|0;l=0;k=0;f=h;while(1){if((a[l+100944|0]|0)==(a[j+(l+f|0)|0]|0)){q=f;r=k}else{if((l|0)!=3){break}q=f-1|0;r=1}o=l+1|0;if((o|0)<(r+g|0)){l=o;k=r;f=q}else{p=959;break}}do{if((p|0)==959){if((r|0)==0){if(!((l|0)==6|(l|0)==2)){break}}c[13898]=e+1;c[b>>2]=1;p=991;break L1278}}while(0);if(!((g|0)>0&(i^1))){p=989;break}l=c[10036]|0;f=0;k=0;j=h;while(1){if((a[f+148408|0]|0)==(a[l+(f+j|0)|0]|0)){s=j;t=k}else{if((f|0)!=2){break}s=j-1|0;t=1}o=f+1|0;if((o|0)<(t+g|0)){f=o;k=t;j=s}else{p=968;break}}do{if((p|0)==968){if((t|0)==0){if(!((f|0)==5|(f|0)==1)){break}}c[13898]=e+1;c[b>>2]=2;p=992;break L1278}}while(0);if(!((g|0)>0&(i^1))){p=989;break}f=c[10036]|0;j=0;k=0;l=h;while(1){if((a[j+142056|0]|0)==(a[f+(j+l|0)|0]|0)){u=l;v=k}else{if((j|0)!=2){break}u=l-1|0;v=1}o=j+1|0;if((o|0)<(v+g|0)){j=o;k=v;l=u}else{p=977;break}}do{if((p|0)==977){if((v|0)==0){if(!((j|0)==6|(j|0)==1)){break}}c[13898]=e+1;c[b>>2]=3;p=992;break L1278}}while(0);if(!((g|0)>0&(i^1))){p=989;break}j=c[10036]|0;l=0;k=0;f=h;while(1){if((a[l+99320|0]|0)==(a[j+(l+f|0)|0]|0)){w=f;x=k}else{if((l|0)!=4){p=989;break L1278}w=f-1|0;x=1}o=l+1|0;if((o|0)<(x+g|0)){l=o;k=x;f=w}else{break}}if((x|0)==0){if(!((l|0)==3|(l|0)==9)){p=989;break}}c[13898]=e+1;c[b>>2]=4;p=992}else{p=989}}while(0);if((p|0)==989){e=c[b>>2]|0;if((e|0)==0){p=990}else if((e|0)==1){p=991}else{p=992}}if((p|0)==992){c[d>>2]=-1;return}else if((p|0)==990){c[d>>2]=0;return}else if((p|0)==991){c[d>>2]=4;return}}function dn(){var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;b=c[8272]|0;d=c[13898]|0;L1352:while(1){e=d+1|0;c[13898]=e;L1354:do{if((b|0)>(d|0)){f=c[1054]|0;if((a[f+(d*40&-1)|0]&1)==0){g=1004;break}h=c[f+(d*40&-1)+36>>2]|0;i=f+(d*40&-1)+32|0;f=c[10036]|0;j=0;while(1){if((j|0)>=(h|0)){break}if((a[f+((c[i>>2]|0)+j|0)|0]|0)==(a[j+78864|0]|0)){j=j+1|0}else{g=1004;break L1354}}if(!((j|0)!=1&(e|0)<(b|0))){g=1011;break L1352}}else{g=1004}}while(0);if((g|0)==1004){g=0;if((e|0)>=(b|0)){g=1012;break}}i=c[1054]|0;if((a[i+(e*40&-1)|0]&1)==0){d=e;continue}f=c[i+(e*40&-1)+36>>2]|0;h=i+(e*40&-1)+32|0;i=c[10036]|0;k=0;while(1){if((k|0)>=(f|0)){break}if((a[i+((c[h>>2]|0)+k|0)|0]|0)==(a[k+103664|0]|0)){k=k+1|0}else{d=e;continue L1352}}if((k|0)==1){g=1013;break}else{d=e}}if((g|0)==1013){return}else if((g|0)==1011){return}else if((g|0)==1012){return}}function dp(b,d,e,f){b=b|0;d=d|0;e=+e;f=f|0;var g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0.0,r=0,s=0,t=0;g=i;i=i+24|0;j=g|0;k=(d|0)!=0;if((f|0)<0&(k^1)){i=g;return}if((a[64976+(b*688&-1)|0]&1)==0){c[64920+(b*688&-1)>>2]=3}l=64944+(b*688&-1)|0;b=c[l>>2]|0;m=j+16|0;c[m>>2]=b;h[j>>3]=-1.7976931348623157e+308;n=j;j=b;while(1){o=n+16|0;if((j|0)==0){p=1022;break}q=+h[j>>3];if(q>=e){p=1021;break}n=j;j=c[j+16>>2]|0}do{if((p|0)==1021){if(q>e){p=1022;break}if(q!=e){uh(-1,105096,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);r=c[o>>2]|0}else{r=j}if((c[r+12>>2]|0)<(f|0)){i=g;return}n=r+8|0;b=c[n>>2]|0;if((b|0)==0){s=r;break}uu(b);c[n>>2]=0;s=r}}while(0);if((p|0)==1022){p=ut(24)|0;if((p|0)==0){gk();t=ut(24)|0}else{t=p}p=t;h[t>>3]=e;c[t+12>>2]=f;c[t+16>>2]=c[o>>2];c[o>>2]=p;s=p}if(k){c[s+8>>2]=bP(d|0)|0}else{c[s+8>>2]=0}c[l>>2]=c[m>>2];i=g;return}function dq(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;e=c[13898]|0;if((c[8272]|0)<=(e|0)){i=d;return}f=c[1054]|0;if((a[f+(e*40&-1)|0]&1)==0){i=d;return}g=c[f+(e*40&-1)+36>>2]|0;h=f+(e*40&-1)+32|0;f=c[10036]|0;j=0;while(1){if((j|0)>=(g|0)){break}if((a[f+((c[h>>2]|0)+j|0)|0]|0)==(a[j+78280|0]|0)){j=j+1|0}else{k=1056;break}}if((k|0)==1056){i=d;return}if((j|0)!=1){i=d;return}c[13898]=e+1;e=64648+(b*688&-1)|0;c[e>>2]=dj(b,64664+(b*688&-1)|0,64672+(b*688&-1)|0,c[e>>2]|0)|0;e=c[13898]|0;L1421:do{if((c[8272]|0)>(e|0)){b=c[1054]|0;if((a[b+(e*40&-1)|0]&1)==0){break}j=c[b+(e*40&-1)+36>>2]|0;k=b+(e*40&-1)+32|0;b=c[10036]|0;h=0;while(1){if((h|0)>=(j|0)){break}if((a[b+((c[k>>2]|0)+h|0)|0]|0)==(a[h+78864|0]|0)){h=h+1|0}else{break L1421}}if((h|0)!=1){break}c[13898]=e+1;i=d;return}}while(0);uf(e,101328,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}function dr(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;f=i;g=c[13898]|0;if((c[8272]|0)<=(g|0)){h=e;i=f;return h|0}j=c[1054]|0;if((a[j+(g*40&-1)|0]&1)==0){h=e;i=f;return h|0}k=c[j+(g*40&-1)+36>>2]|0;l=j+(g*40&-1)+32|0;m=c[10036]|0;n=0;while(1){if((n|0)>=(k|0)){break}if((a[m+((c[l>>2]|0)+n|0)|0]|0)==(a[n+78280|0]|0)){n=n+1|0}else{h=e;o=1085;break}}if((o|0)==1085){i=f;return h|0}if((n|0)!=1){h=e;i=f;return h|0}n=g+1|0;c[13898]=n;L1447:do{if((a[j+(n*40&-1)|0]&1)==0){p=e}else{if((bO(d[m+(c[j+(n*40&-1)+32>>2]|0)|0]|0|0)|0)==0){if((a[(c[10036]|0)+(c[(c[1054]|0)+(n*40&-1)+32>>2]|0)|0]|0)!=95){p=e;break}}g=c[13898]|0;l=g+1|0;if((c[8272]|0)<=(l|0)){p=e;break}k=c[1054]|0;if((a[k+(l*40&-1)|0]&1)==0){p=e;break}q=c[k+(l*40&-1)+36>>2]|0;r=k+(l*40&-1)+32|0;l=c[10036]|0;k=0;while(1){if((k|0)>=(q|0)){break}if((a[l+((c[r>>2]|0)+k|0)|0]|0)==(a[k+115e3|0]|0)){k=k+1|0}else{p=e;break L1447}}if((k|0)!=1){p=e;break}c[13898]=g+2;p=g}}while(0);e=64648+(b*688&-1)|0;c[e>>2]=dj(b,64664+(b*688&-1)|0,64672+(b*688&-1)|0,c[e>>2]|0)|0;e=c[13898]|0;if((c[8272]|0)<=(e|0)){uf(e,101328,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}b=c[1054]|0;if((a[b+(e*40&-1)|0]&1)==0){uf(e,101328,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}n=c[b+(e*40&-1)+36>>2]|0;j=b+(e*40&-1)+32|0;b=c[10036]|0;m=0;while(1){if((m|0)>=(n|0)){break}if((a[b+((c[j>>2]|0)+m|0)|0]|0)==(a[m+78864|0]|0)){m=m+1|0}else{o=1089;break}}if((o|0)==1089){uf(e,101328,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}if((m|0)!=1){uf(e,101328,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}c[13898]=e+1;h=p;i=f;return h|0}function ds(){var d=0,e=0,f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,w=0,x=0,y=0,z=0,A=0.0,B=0,C=0;d=i;e=hA(c[11932]|0,78360)|0;if((e|0)==0){uj(-1,146640,(v=i,i=i+8|0,c[v>>2]=c[11932],v)|0)}else{f=0;g=0}L1479:while(1){if((g|0)!=0){if((a_(f+(g-2|0)|0,86144,2)|0)==0){j=1104;break}}k=g+512|0;l=g+513|0;do{if((f|0)==0){m=ut(l)|0;if((m|0)!=0){n=m;break}gk();m=ut(l)|0;if((m|0)==0){j=1099;break L1479}else{n=m}}else{n=db(f,l,127720)|0}}while(0);l=n+g|0;a[l]=0;if((cd(l|0,512,1,e|0)|0)==0){j=1102;break}a[n+k|0]=0;f=n;g=k}if((j|0)==1099){uf(-1,225296,(v=i,i=i+8|0,c[v>>2]=127720,v)|0)}else if((j|0)==1102){uu(n);uj(-1,113448,(v=i,i=i+8|0,c[v>>2]=c[11932],v)|0)}else if((j|0)==1104){az(e|0);e=c[11864]|0;do{if((e|0)<1){n=1-e|0;do{if((c[11880]|0)<1){l=db(c[12172]|0,232,216568)|0;c[12172]=l;if((l|0)==0){c[11880]=0;uf(c[13898]|0,216112,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}else{c[11880]=1;break}}}while(0);if((n|0)<=0){break}k=c[12172]|0;l=0;m=c[11864]|0;do{uD(k+(m*232&-1)|0,48440,232);m=(c[11864]|0)+1|0;c[11864]=m;l=l+1|0;}while((l|0)<(n|0))}}while(0);e=aQ(f|0,100248)|0;L1506:do{if((e|0)==0){j=1122}else{n=a8(e+18|0,61)|0;do{n=n+1|0;}while((aM(a[n]|0|0)|0)!=0);if((n|0)==0){j=1122;break}l=bk(n|0,95048)|0;m=db(c[11932]|0,l+1|0,88488)|0;c[11932]=m;uF(m|0,n|0,l|0);a[(c[11932]|0)+l|0]=0;l=aQ(f|0,78632)|0;do{if((l|0)!=0){m=a8(l+22|0,61)|0;do{m=m+1|0;}while((aM(a[m]|0|0)|0)!=0);if((m|0)==0){break}k=bW(m|0)|0;c[(c[12172]|0)+128>>2]=k;break L1506}}while(0);c[(c[12172]|0)+128>>2]=0}}while(0);if((j|0)==1122){c[(c[12172]|0)+128>>2]=g}c[(c[12172]|0)+152>>2]=1;c[(c[12172]|0)+156>>2]=-1;a[(c[12172]|0)+124|0]=1;c[(c[12172]|0)+112>>2]=-3;c[(c[12172]|0)+116>>2]=-4;eQ(1);g=c[11950]|0;if((c[11884]|0)<1){j=db(g,12,215112)|0;c[11950]=j;c[11884]=1;o=j}else{o=g}c[o>>2]=0;o=c[11950]|0;if((c[11884]|0)<2){g=db(o,24,215112)|0;c[11950]=g;c[11884]=2;p=g}else{p=o}c[p+12>>2]=0;c[11870]=1;c[262]=1;p=aQ(f|0,73608)|0;do{if((p|0)!=0){o=a8(p+5|0,61)|0;do{o=o+1|0;}while((aM(a[o]|0|0)|0)!=0);if((o|0)==0){break}g=bW(o|0)|0;c[(c[12172]|0)+140>>2]=g}}while(0);p=aQ(f|0,218896)|0;do{if((p|0)!=0){g=a8(p+5|0,61)|0;do{g=g+1|0;}while((aM(a[g]|0|0)|0)!=0);if((g|0)==0){break}o=bW(g|0)|0;c[(c[12172]|0)+144>>2]=o}}while(0);p=aQ(f|0,213352)|0;L1542:do{if((p|0)!=0){o=a8(p+8|0,61)|0;do{o=o+1|0;}while((aM(a[o]|0|0)|0)!=0);if((o|0)==0){break}else{q=-1}while(1){r=q+1|0;g=c[46440+(r*12&-1)>>2]|0;if((r|0)==12){break L1542}if((a_(o|0,g|0,uA(g|0)|0)|0)==0){break}else{q=r}}if((r|0)<=-1){break}o=b[46448+(r*12&-1)>>1]|0;if((o|0)==1){g=1328>>>(r>>>0);do{if((g&1|0)==0){j=2752>>>(r>>>0);if(((j|g)&1|0)!=0){s=(j&1|0)!=0?11:5;break}if((q-1|0)>>>0<2){s=3;break}s=r>>>0<2?1:12}else{s=7}}while(0);g=c[11950]|0;if((c[11884]|0)<1){j=db(g,12,215112)|0;c[11950]=j;c[11884]=1;t=j}else{t=g}c[t+4>>2]=s;b[(c[11950]|0)+8>>1]=b[48036+(s<<4)>>1]|0;break}else if((o|0)==2){if((1328>>>(r>>>0)&1|0)==0){u=(2752>>>(r>>>0)&1|0)!=0?9:12}else{u=8}g=c[11950]|0;if((c[11884]|0)<1){j=db(g,12,215112)|0;c[11950]=j;c[11884]=1;w=j}else{w=g}c[w+4>>2]=u;b[(c[11950]|0)+8>>1]=b[48036+(u<<4)>>1]|0;break}else if((o|0)==0){g=1328>>>(r>>>0);do{if((g&1|0)==0){j=2752>>>(r>>>0);if(((j|g)&1|0)!=0){x=(j&1|0)!=0?10:4;break}if((q-1|0)>>>0<2){x=2;break}x=r>>>0<2?0:12}else{x=6}}while(0);g=c[11950]|0;if((c[11884]|0)<1){o=db(g,12,215112)|0;c[11950]=o;c[11884]=1;y=o}else{y=g}c[y+4>>2]=x;b[(c[11950]|0)+8>>1]=b[48036+(x<<4)>>1]|0;break}else{break}}}while(0);x=aQ(f|0,207688)|0;L1579:do{if((x|0)!=0){y=a8(x+9|0,61)|0;do{y=y+1|0;}while((aM(a[y]|0|0)|0)!=0);if((y|0)==0){break}do{if((aY(y|0,149792)|0)==0){z=0}else{r=(a_(y|0,149792,12)|0)!=0;if((aY(y|0,147968)|0)==0){z=1;break}q=(a_(y|0,147968,13)|0)==0&r?1:r<<31>>31;if((q|0)>-1){z=q}else{break L1579}}}while(0);c[12208]=c[46604+(z<<3)>>2]}}while(0);z=aQ(f|0,203264)|0;do{if((z|0)!=0){x=a8(z+8|0,61)|0;do{x=x+1|0;}while((aM(a[x]|0|0)|0)!=0);if((x|0)==0){break}A=+uz(x,0);y=c[12172]|0;h[y+200>>3]=A;c[y+192>>2]=1}}while(0);z=aQ(f|0,198216)|0;do{if((z|0)!=0){y=a8(z+8|0,61)|0;do{y=y+1|0;}while((aM(a[y]|0|0)|0)!=0);if((y|0)==0){break}A=+uz(y,0);x=c[12172]|0;h[x+208>>3]=A;c[x+192>>2]=1}}while(0);z=aQ(f|0,186936)|0;do{if((z|0)!=0){x=a8(z+8|0,61)|0;do{x=x+1|0;}while((aM(a[x]|0|0)|0)!=0);if((x|0)==0){break}A=+uz(x,0);y=c[12172]|0;h[y+200>>3]=A;c[y+192>>2]=2}}while(0);z=aQ(f|0,181632)|0;do{if((z|0)!=0){y=a8(z+8|0,61)|0;do{y=y+1|0;}while((aM(a[y]|0|0)|0)!=0);if((y|0)==0){break}A=+uz(y,0);x=c[12172]|0;h[x+208>>3]=A;c[x+192>>2]=2}}while(0);z=aQ(f|0,177440)|0;do{if((z|0)!=0){x=a8(z+7|0,61)|0;do{x=x+1|0;}while((aM(a[x]|0|0)|0)!=0);if((x|0)==0){break}A=+uz(x,0);h[(c[12172]|0)+168>>3]=A}}while(0);z=aQ(f|0,172936)|0;do{if((z|0)!=0){y=a8(z+7|0,61)|0;do{y=y+1|0;}while((aM(a[y]|0|0)|0)!=0);if((y|0)==0){break}A=+uz(y,0);h[(c[12172]|0)+176>>3]=A}}while(0);z=aQ(f|0,169160)|0;if((z|0)==0){uu(f);i=d;return}x=a8(z+10|0,61)|0;do{x=x+1|0;}while((aM(a[x]|0|0)|0)!=0);if((x|0)==0){uu(f);i=d;return}do{if((aY(x|0,155800)|0)==0){c[(c[12172]|0)+152>>2]=1;B=(c[12172]|0)+156|0}else{if((aY(x|0,151720)|0)==0){c[(c[12172]|0)+152>>2]=1;C=(c[12172]|0)+156|0}else{z=(a_(x|0,155800,11)|0)!=0;q=(a_(x|0,151720,9)|0)==0&z;c[(c[12172]|0)+152>>2]=1;z=(c[12172]|0)+156|0;if(q){C=z}else{B=z;break}}c[C>>2]=1;c[(c[12172]|0)+112>>2]=-3;c[(c[12172]|0)+116>>2]=-4;uu(f);i=d;return}}while(0);c[B>>2]=-1;c[(c[12172]|0)+112>>2]=-3;c[(c[12172]|0)+116>>2]=-4;uu(f);i=d;return}}function dt(){du(0)}function du(a){a=a|0;uf(-1,164848,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}function dv(){du(0)}function dw(){du(0)}function dx(b){b=b|0;var d=0,e=0,f=0,g=0,j=0,k=0.0,l=0;d=i;i=i+16|0;e=d|0;f=c[12372]|0;if((f|0)==2|(f|0)==5){g=(c[12374]<<4&65520)+f|0;j=1226}else if((f|0)==1|(f|0)==4){g=(c[12373]<<4&65520)+f|0;j=1226}else if((f|0)==0){c[b+8>>2]=1601}else{g=0;j=1226}if((j|0)==1226){c[b+8>>2]=g}cN[c[(c[3524]|0)+148>>2]&255](4,b);if((c[7661]|0)==0){i=d;return}g=e;c[g>>2]=c[7654];c[g+4>>2]=c[30620>>2];c[g+8>>2]=c[30624>>2];c[g+12>>2]=c[30628>>2];g=c[7645]|0;do{if((c[7644]|0)!=0){k=+h[3825];f=c[(c[3524]|0)+92>>2]|0;if(k<0.0){cK[f&63](+h[3817]);break}else{cK[f&63](k);break}}}while(0);cK[c[(c[3524]|0)+112>>2]&63](+h[3824]);f=c[(c[3524]|0)+64>>2]|0;if((g|0)<-5){cM[f&511](-2)}else{cM[f&511](g)}f=c[3524]|0;do{if((a[30608]&1)==0){if((c[f+96>>2]&1024|0)!=0){l=f;break}c[e>>2]=1;c[e+4>>2]=g;j=1238}else{j=1238}}while(0);if((j|0)==1238){fn(e,f);l=c[3524]|0}f=b|0;e=b+4|0;cN[c[l+56>>2]&255](c[f>>2]|0,c[e>>2]|0);cN[c[(c[3524]|0)+60>>2]&255](c[b+36>>2]|0,c[b+40>>2]|0);cN[c[(c[3524]|0)+60>>2]&255](c[b+24>>2]|0,c[b+28>>2]|0);cN[c[(c[3524]|0)+60>>2]&255](c[b+12>>2]|0,c[b+16>>2]|0);cN[c[(c[3524]|0)+60>>2]&255](c[f>>2]|0,c[e>>2]|0);i=d;return}function dy(a){a=a|0;var b=0,d=0,e=0.0,f=0.0,g=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0.0,E=0,F=0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0;b=i;i=i+48|0;d=b|0;e=+h[64664+((c[200]|0)*688&-1)>>3];f=+h[91];g=+h[96];j=+h[64664+((c[144]|0)*688&-1)>>3];k=+h[21];l=+h[68];m=+h[5279];n=+h[2];o=+h[12];p=+h[403];q=+h[391];r=+h[395];s=+h[399];t=+h[404];u=+h[392];v=+h[396];w=+h[400];x=+h[406];y=+h[394];z=+h[398];A=+h[402];B=+(c[180]|0);C=c[186]|0;D=+(c[40]|0);E=c[46]|0;F=0;do{G=(+h[a+(F<<5)>>3]-e)*f+g+-1.0;H=(+h[a+(F<<5)+8>>3]-j)*k+l+-1.0;I=(+h[a+(F<<5)+16>>3]-m)*n+o+-1.0;J=x+G*y+H*z+I*A;K=J==0.0?1.0e-5:J;c[d+(F*12&-1)>>2]=~~((p+G*q+H*r+I*s)/K*B)+C;c[d+(F*12&-1)+4>>2]=~~((t+G*u+H*v+I*w)/K*D)+E;F=F+1|0;}while((F|0)<4);dx(d|0);i=b;return}function dz(){var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;b=i;d=c[(c[3524]|0)+136>>2]|0;if((d|0)==0){e=1;i=b;return e|0}f=cO[d&255](0)|0;c[5169]=f;if((f|0)==0){if((uG(29056,20648,1024)|0)==0){e=0;i=b;return e|0}d=c[(c[3524]|0)+136>>2]|0;cO[d&255](20648);uD(29056,20648,1024);e=0;i=b;return e|0}d=c[5168]|0;do{if((d|0)>0){if((c[5163]|0)==100){c[5169]=f;g=f;break}if((f|0)<=(d|0)){g=f;break}c[5169]=d;g=d}else{g=f}}while(0);d=c[7264]|0;do{if((d|0)>-1&(c[5162]|0)==(d|0)){if((c[5163]|0)!=(c[7265]|0)){h=1261;break}if((c[5164]|0)!=(c[7266]|0)){h=1261;break}if((c[5165]|0)!=(c[7267]|0)){h=1261;break}if((c[5166]|0)!=(c[7268]|0)){h=1261;break}if(!((a[20668]|0)==(a[29076]|0)&(g|0)==(c[7271]|0))){h=1261}}else{h=1261}}while(0);do{if((h|0)==1261){if((a[37400]&1)==0){break}d=c[m>>2]|0;j=c[c[3524]>>2]|0;cf(d|0,218032,(v=i,i=i+24|0,c[v>>2]=j,c[v+8>>2]=g,c[v+16>>2]=f,v)|0)}}while(0);uD(29056,20648,1024);f=c[5170]|0;if((f|0)!=0){uu(f);c[5170]=0}f=(c[5169]|0)*24&-1;g=ut(f)|0;do{if((g|0)==0){gk();h=ut(f)|0;if((h|0)!=0){k=h;break}uf(-1,225296,(v=i,i=i+8|0,c[v>>2]=217512,v)|0);return 0}else{k=g}}while(0);g=k;c[5170]=g;k=c[5169]|0;L1722:do{if((k|0)>0){f=0;h=k;j=g;while(1){fq(+(f|0)/+(h-1|0),j+(f*24&-1)|0);d=f+1|0;l=c[5169]|0;if((d|0)>=(l|0)){break L1722}f=d;h=l;j=c[5170]|0}}}while(0);cO[c[(c[3524]|0)+136>>2]&255](20648);e=0;i=b;return e|0}function dA(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0,s=0;d=i;e=a*12&-1;f=ut(e)|0;do{if((f|0)==0){gk();g=ut(e)|0;if((g|0)!=0){j=g;break}uf(-1,225296,(v=i,i=i+8|0,c[v>>2]=164072,v)|0)}else{j=f}}while(0);f=j;if((a|0)>0){e=0;do{k=(+h[b+(e<<6)+8>>3]- +h[64664+((c[200]|0)*688&-1)>>3])*+h[91]+ +h[96]+-1.0;l=(+h[b+(e<<6)+16>>3]- +h[64664+((c[144]|0)*688&-1)>>3])*+h[21]+ +h[68]+-1.0;m=(+h[b+(e<<6)+24>>3]- +h[5279])*+h[2]+ +h[12]+-1.0;n=+h[406]+k*+h[394]+l*+h[398]+m*+h[402];o=n==0.0?1.0e-5:n;g=~~((+h[404]+k*+h[392]+l*+h[396]+m*+h[400])/o*+(c[40]|0))+(c[46]|0)|0;c[f+(e*12&-1)>>2]=~~((+h[403]+k*+h[391]+l*+h[395]+m*+h[399])/o*+(c[180]|0))+(c[186]|0);c[f+(e*12&-1)+4>>2]=g;e=e+1|0;}while((e|0)<(a|0))}e=c[12372]|0;if((e|0)==1|(e|0)==4){p=(c[12373]<<4&65520)+e|0}else if((e|0)==2|(e|0)==5){p=(c[12374]<<4&65520)+e|0}else if((e|0)==0){c[j+8>>2]=1601;q=c[3524]|0;r=q+148|0;s=c[r>>2]|0;cN[s&255](a,f);uu(j);i=d;return}else{p=0}c[j+8>>2]=p;q=c[3524]|0;r=q+148|0;s=c[r>>2]|0;cN[s&255](a,f);uu(j);i=d;return}function dB(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0,g=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0,t=0;e=i;f=a*12&-1;g=ut(f)|0;do{if((g|0)==0){gk();j=ut(f)|0;if((j|0)!=0){k=j;break}uf(-1,225296,(v=i,i=i+8|0,c[v>>2]=136792,v)|0)}else{k=g}}while(0);g=k;if((a|0)>0){f=0;do{l=(+h[b+(f<<6)+8>>3]- +h[64664+((c[200]|0)*688&-1)>>3])*+h[91]+ +h[96]+-1.0;m=(+h[b+(f<<6)+16>>3]- +h[64664+((c[144]|0)*688&-1)>>3])*+h[21]+ +h[68]+-1.0;n=(d- +h[5279])*+h[2]+ +h[12]+-1.0;o=+h[406]+l*+h[394]+m*+h[398]+n*+h[402];p=o==0.0?1.0e-5:o;j=~~((+h[404]+l*+h[392]+m*+h[396]+n*+h[400])/p*+(c[40]|0))+(c[46]|0)|0;c[g+(f*12&-1)>>2]=~~((+h[403]+l*+h[391]+m*+h[395]+n*+h[399])/p*+(c[180]|0))+(c[186]|0);c[g+(f*12&-1)+4>>2]=j;f=f+1|0;}while((f|0)<(a|0))}f=c[12372]|0;if((f|0)==0){c[k+8>>2]=1601;q=c[3524]|0;r=q+148|0;s=c[r>>2]|0;cN[s&255](a,g);uu(k);i=e;return}else if((f|0)==1|(f|0)==4){t=(c[12373]<<4&65520)+f|0}else if((f|0)==2|(f|0)==5){t=(c[12374]<<4&65520)+f|0}else{t=0}c[k+8>>2]=t;q=c[3524]|0;r=q+148|0;s=c[r>>2]|0;cN[s&255](a,g);uu(k);i=e;return}function dC(b,d,e,f,g){b=b|0;d=+d;e=e|0;f=f|0;g=g|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0;j=i;i=i+64|0;k=f;f=i;i=i+56|0;uD(f,k,56);k=j|0;l=j+16|0;m=j+32|0;n=j+48|0;o=j+56|0;p=(e|0)!=0;q=c[3524]|0;r=~~(+((c[q+28>>2]|0)>>>0>>>0)*(p?+h[8390]:+h[8391])*((a[67136]&1)!=0?-1.0:1.0));s=+h[8341];t=(d-s)/(+h[8342]-s);if((a[54017]|0)==104){u=c[13528]|0;v=~~(+(u|0)+t*+((c[13529]|0)-u|0));u=c[13530]|0;w=u-r|0;x=v;y=u;z=v}else{v=c[13529]|0;u=c[13530]|0;A=~~(+(u|0)+t*+((c[13531]|0)-u|0));w=A;x=v+r|0;y=A;z=v}v=c[f+4>>2]|0;do{if((v|0)>-3){A=m;u=f+40|0;c[A>>2]=c[u>>2];c[A+4>>2]=c[u+4>>2];c[A+8>>2]=c[u+8>>2];c[A+12>>2]=c[u+12>>2];do{if((c[f>>2]|0)!=0){t=+h[f+24>>3];u=c[q+92>>2]|0;if(t<0.0){cK[u&63](+h[3817]);break}else{cK[u&63](t);break}}}while(0);cK[c[(c[3524]|0)+112>>2]&63](+h[f+16>>3]);u=c[(c[3524]|0)+64>>2]|0;if((v|0)<-5){cM[u&511](-2)}else{cM[u&511](v)}u=c[3524]|0;do{if((a[f+32|0]&1)==0){if((c[u+96>>2]&1024|0)!=0){B=u;break}c[m>>2]=1;c[m+4>>2]=v;C=1317}else{C=1317}}while(0);if((C|0)==1317){fn(m,u);B=c[3524]|0}A=c[B+56>>2]|0;if((a[54017]|0)==104){cN[A&255](z,c[13530]|0);cN[c[(c[3524]|0)+60>>2]&255](z,c[13531]|0)}else{cN[A&255](c[13528]|0,y);cN[c[(c[3524]|0)+60>>2]&255](c[13529]|0,y)}A=l;c[A>>2]=c[14084];c[A+4>>2]=c[56340>>2];c[A+8>>2]=c[56344>>2];c[A+12>>2]=c[56348>>2];A=c[14075]|0;do{if((c[14074]|0)!=0){t=+h[7040];D=c[(c[3524]|0)+92>>2]|0;if(t<0.0){cK[D&63](+h[3817]);break}else{cK[D&63](t);break}}}while(0);cK[c[(c[3524]|0)+112>>2]&63](+h[7039]);u=c[(c[3524]|0)+64>>2]|0;if((A|0)<-5){cM[u&511](-2)}else{cM[u&511](A)}u=c[3524]|0;if((a[56328]&1)==0){if((c[u+96>>2]&1024|0)!=0){E=u;break}c[l>>2]=1;c[l+4>>2]=A}fn(l,u);E=c[3524]|0}else{E=q}}while(0);cN[c[E+56>>2]&255](z,y);cN[c[(c[3524]|0)+60>>2]&255](x,w);do{if(p){L1804:do{if((g|0)==0){F=e}else{t=+h[8342]- +h[8341];E=g;while(1){if(+P(+((d- +h[E>>3])/t))<=.001){F=0;break L1804}q=c[E+16>>2]|0;if((q|0)==0){F=e;break}else{E=q}}}}while(0);fx(64984+(b*688&-1)|0,n,o,123416);A=64928+(b*688&-1)|0;if((c[A>>2]|0)!=0){fn(A,c[3524]|0)}do{if((a[54017]|0)==104){A=c[3524]|0;E=(c[13530]|0)-(c[A+16>>2]|0)|0;q=65032+(b*688&-1)|0;l=c[q>>2]|0;do{if((l|0)==0){G=0}else{if((cO[c[A+72>>2]&255](l)|0)==0){G=0;break}G=c[q>>2]|0}}while(0);q=E+((r|0)>0?-r|0:0)|0;l=(G|0)!=0;if((a[65272+(b*688&-1)|0]&1)==0){H=l&1^1}else{H=c[65128+(b*688&-1)>>2]|0}ln((c[n>>2]|0)+x|0,(c[o>>2]|0)+((q|0)<0?0:q)|0,F,H,1,G,c[64924+(b*688&-1)>>2]|0);if(!l){break}l=c[(c[3524]|0)+72>>2]|0;cO[l&255](0)}else{if((a[65272+(b*688&-1)|0]&1)==0){I=0}else{I=c[65128+(b*688&-1)>>2]|0}ln((((c[13529]|0)+((r|0)>0?r:0)|0)+(c[(c[3524]|0)+20>>2]|0)|0)+(c[n>>2]|0)|0,(c[o>>2]|0)+w|0,F,I,1,0,c[64924+(b*688&-1)>>2]|0)}}while(0);l=k;c[l>>2]=c[14084];c[l+4>>2]=c[56340>>2];c[l+8>>2]=c[56344>>2];c[l+12>>2]=c[56348>>2];l=c[14075]|0;do{if((c[14074]|0)!=0){t=+h[7040];q=c[(c[3524]|0)+92>>2]|0;if(t<0.0){cK[q&63](+h[3817]);break}else{cK[q&63](t);break}}}while(0);cK[c[(c[3524]|0)+112>>2]&63](+h[7039]);q=c[(c[3524]|0)+64>>2]|0;if((l|0)<-5){cM[q&511](-2)}else{cM[q&511](l)}q=c[3524]|0;if((a[56328]&1)==0){if((c[q+96>>2]&1024|0)!=0){break}c[k>>2]=1;c[k+4>>2]=l}fn(k,q)}}while(0);if((c[16745]&4|0)==0){i=j;return}if((a[54017]|0)==104){k=c[13531]|0;J=k+r|0;K=x;L=k;M=z}else{z=c[13528]|0;J=w;K=z-r|0;L=y;M=z}cN[c[(c[3524]|0)+56>>2]&255](M,L);cN[c[(c[3524]|0)+60>>2]&255](K,J);i=j;return}function dD(b){b=b|0;var d=0,e=0,f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ab=0.0,ac=0.0,ad=0.0,ae=0.0,af=0.0,ag=0.0,ah=0.0,ai=0.0,aj=0.0,ak=0.0,al=0.0,am=0.0,an=0.0,ao=0.0,ap=0.0,aq=0.0,ar=0.0,as=0.0,at=0,au=0,av=0,aw=0,ax=0,ay=0,az=0,aA=0,aB=0,aC=0,aD=0,aE=0,aF=0,aG=0,aH=0,aJ=0,aK=0.0,aL=0,aM=0,aN=0,aO=0,aP=0,aQ=0,aR=0,aS=0,aT=0,aU=0,aV=0.0,aW=0.0,aX=0,aY=0,aZ=0,a_=0.0,a$=0,a0=0,a1=0,a2=0,a3=0,a4=0;d=i;i=i+304|0;e=d|0;f=d+16|0;g=d+32|0;j=d+48|0;k=d+64|0;l=d+80|0;m=d+128|0;n=d+136|0;o=d+144|0;p=d+152|0;q=d+160|0;r=d+168|0;s=d+176|0;t=d+184|0;u=d+192|0;w=d+232|0;x=d+272|0;y=d+280|0;z=d+288|0;A=d+296|0;B=c[10028]|0;C=a[54016]|0;if(C<<24>>24==110){i=d;return}D=c[3524]|0;if((c[D+148>>2]|0)==0){i=d;return}do{if(C<<24>>24==117){do{if((a[37384]&1)==0){fR(54032,o,p,106096);c[13528]=~~+h[o>>3];c[13530]=~~+h[p>>3];fN(54072,q,r,106096);E=~~+h[q>>3];c[13529]=E;F=~~+h[r>>3];c[13531]=F;G=E;H=F}else{if((c[5094]|0)==0){F=D+8|0;c[13528]=~~(+h[6756]*+((c[F>>2]|0)>>>0>>>0)+.5);E=D+12|0;c[13530]=~~(+h[6757]*+((c[E>>2]|0)>>>0>>>0)+.5);I=~~(+h[6761]*+(((c[F>>2]|0)-1|0)>>>0>>>0)+.5);c[13529]=I;F=~~(+h[6762]*+(((c[E>>2]|0)-1|0)>>>0>>>0)+.5);c[13531]=F;G=I;H=F;break}else{fK(54032,s,t,106096);c[13528]=~~+h[s>>3];c[13530]=~~+h[t>>3];fx(54072,54116,54124,106096);G=c[13529]|0;H=c[13531]|0;break}}}while(0);F=c[13528]|0;I=G+F|0;c[13529]=I;E=c[13530]|0;J=H+E|0;c[13531]=J;K=E;L=J;M=F;N=I}else{do{if((b|0)!=2|(c[5094]|0)!=0){if((a[37384]&1)==0){uE(u|0,0,40);c[u>>2]=2;c[u+4>>2]=2;c[u+8>>2]=2;h[u+16>>3]=1.025;uE(w|0,0,40);c[w>>2]=2;c[w+4>>2]=2;c[w+8>>2]=2;h[w+16>>3]=.05;h[w+24>>3]=1.0;fR(u,m,n,106096);I=~~+h[m>>3];c[13530]=~~+h[n>>3];c[13528]=I+(c[13507]|0);fN(w,x,y,106096);I=c[13528]|0;F=~~(+h[x>>3]+ +(I|0));c[13529]=F;J=c[13530]|0;E=~~(+h[y>>3]+ +(J|0));c[13531]=E;O=J;P=E;Q=I;R=F;break}else{F=c[200]|0;S=+h[64672+(F*688&-1)>>3];T=+h[64664+(F*688&-1)>>3];U=S-T;F=c[144]|0;V=+h[64664+(F*688&-1)>>3];W=+h[91];X=+h[96];Y=(S+U*.025-T)*W+X+-1.0;Z=+h[21];_=+h[68];$=(V-V)*Z+_+-1.0;aa=+h[5279];ab=+h[2];ac=+h[12];ad=(+h[7076]-aa)*ab+ac+-1.0;ae=+h[403];af=+h[391];ag=+h[395];ah=+h[399];ai=+h[404];aj=+h[392];ak=+h[396];al=+h[400];am=+h[406];an=+h[394];ao=+h[398];ap=+h[402];aq=am+Y*an+$*ao+ad*ap;ar=aq==0.0?1.0e-5:aq;aq=+(c[180]|0);I=c[186]|0;E=~~((ae+Y*af+$*ag+ad*ah)/ar*aq)+I|0;as=+(c[40]|0);J=c[46]|0;at=~~((ai+Y*aj+$*ak+ad*al)/ar*as)+J|0;c[13528]=E;c[13530]=at;ar=(U*.075+S-T)*W+X+-1.0;X=(+h[64672+(F*688&-1)>>3]-V)*Z+_+-1.0;_=(+h[6915]-aa)*ab+ac+-1.0;ac=am+ar*an+X*ao+_*ap;ap=ac==0.0?1.0e-5:ac;F=~~((ae+ar*af+X*ag+_*ah)/ap*aq)+I|0;I=~~((ai+ar*aj+X*ak+_*al)/ap*as)+J|0;c[13529]=F;c[13531]=I;O=at;P=I;Q=E;R=F;break}}else{as=+(c[186]|0);ap=+(c[180]|0);F=~~(as+ap*.709);c[13528]=F;E=~~(as+ap*.778);c[13529]=E;ap=+(c[46]|0);as=+(c[40]|0);I=~~(ap-as*.147);c[13530]=I;at=~~(ap+as*.497);c[13531]=at;O=I;P=at;Q=F;R=E}}while(0);if((a[54017]|0)!=118){K=O;L=P;M=Q;N=R;break}as=+((c[(c[3524]|0)+28>>2]|0)>>>0>>>0);E=~~(+h[8390]*((a[67136]&1)!=0?-1.0:1.0)*as);F=c[144]|0;at=~~(as*+h[65056+(F*688&-1)>>3]*((a[65072+(F*688&-1)|0]&1)!=0?-1.0:1.0));do{if((E|0)>0){if((c[16745]&4|0)==0){au=Q;av=R;break}F=Q+E|0;c[13528]=F;I=R+E|0;c[13529]=I;au=F;av=I}else{au=Q;av=R}}while(0);if((at|0)<=0){K=O;L=P;M=au;N=av;break}if((c[16401]&4|0)==0){K=O;L=P;M=au;N=av;break}E=au+at|0;c[13528]=E;I=av+at|0;c[13529]=I;K=O;L=P;M=E;N=I}}while(0);if((K|0)>(L|0)){c[13531]=K;c[13530]=L;aw=L;ax=K}else{aw=K;ax=L}if((c[(c[3524]|0)+96>>2]&16|0)==0){if((a[54017]|0)==118){L=l+36|0;c[L>>2]=M;K=l|0;c[K>>2]=M;P=l+24|0;c[P>>2]=N;O=l+12|0;c[O>>2]=N;ay=ax-aw|0;az=ax;aA=aw;aB=l+16|0;aC=l+4|0;aD=l+40|0;aE=l+28|0;aF=L;aG=K;aH=P;aJ=O}else{O=l+16|0;c[O>>2]=aw;P=l+4|0;c[P>>2]=aw;K=l+40|0;c[K>>2]=ax;L=l+28|0;c[L>>2]=ax;ay=N-M|0;az=N;aA=M;aB=O;aC=P;aD=K;aE=L;aF=l+36|0;aG=l|0;aH=l+24|0;aJ=l+12|0}as=+(ay|0)*.0078125;ap=+(az-aA|0);ay=1-aA|0;L=l+8|0;K=l|0;l=k|0;P=k+8|0;O=k+4|0;av=aA;au=0;R=0;while(1){Q=~~(as*+(R+1|0))+aA|0;al=+(ay+av|0)/ap;if((a[20668]|0)==110){aK=1.0-al}else{aK=al}y=(c[3524]|0)+144|0;if((c[y>>2]|0)!=0){c[l>>2]=5;h[P>>3]=aK;c[O>>2]=0;cM[c[y>>2]&511](k)}L1909:do{if((c[5163]|0)==100){y=c[5172]|0;x=c[5173]|0;w=au;n=au;while(1){if((w|0)>=(y|0)){aL=R;aM=n;aN=Q;break L1909}aO=~~(ap*+h[x+(w<<5)>>3])+aA|0;if((av|0)<(aO|0)){if((Q|0)>(aO|0)){break}else{aP=n}}else{aP=w}if((Q|0)<(aO|0)){aL=R;aM=aP;aN=Q;break L1909}else{w=w+1|0;n=aP}}aL=R-1|0;aM=n;aN=aO}else{aL=R;aM=au;aN=Q}}while(0);if((a[54017]|0)==118){c[aB>>2]=av;c[aC>>2]=av;Q=aN+1|0;at=(az|0)<(Q|0)?az:Q;c[aD>>2]=at;c[aE>>2]=at}else{c[aF>>2]=av;c[aG>>2]=av;at=aN+1|0;Q=(az|0)<(at|0)?az:at;c[aH>>2]=Q;c[aJ>>2]=Q}Q=c[12372]|0;if((Q|0)==0){aQ=1601}else if((Q|0)==1|(Q|0)==4){aR=(c[12373]<<4&65520)+Q|0;aS=1421}else if((Q|0)==2|(Q|0)==5){aR=(c[12374]<<4&65520)+Q|0;aS=1421}else{aR=0;aS=1421}if((aS|0)==1421){aS=0;aQ=aR}c[L>>2]=aQ;cN[c[(c[3524]|0)+148>>2]&255](4,K);Q=aL+1|0;if((Q|0)<128){av=aN;au=aM;R=Q}else{break}}}else{aI(92952,104,1,B|0);R=c[13530]|0;cf(B|0,85112,(v=i,i=i+32|0,c[v>>2]=c[13528],c[v+8>>2]=R,c[v+16>>2]=N-M,c[v+24>>2]=ax-aw,v)|0);aI(76928,42,1,B|0);if((a[20668]|0)==110){aI(224696,19,1,B|0)}else{aI(217376,7,1,B|0)}if((a[54017]|0)==118){aI(211744,30,1,B|0)}else{aI(205632,30,1,B|0)}aI(202264,85,1,B|0)}do{if((a[54018]|0)!=0){B=c[13505]|0;do{if((B|0)>-1){aw=c[14074]|0;ap=+h[7039];aK=+h[7040];ax=a[56328]|0;as=+h[7043];M=43280;while(1){aT=c[M>>2]|0;if((aT|0)==0){aS=1429;break}if((c[aT+4>>2]|0)==(B|0)){aS=1428;break}else{M=aT|0}}L1952:do{if((aS|0)==1428){M=c[aT+12>>2]|0;n=a[aT+40|0]|0;N=(n&1)==0;aU=M;aV=+h[aT+24>>3];aW=+h[aT+32>>3];aX=n;aY=N?1:c[aT+48>>2]|0;aZ=N?M:c[aT+52>>2]|0;a_=+h[aT+56>>3]}else if((aS|0)==1429){M=c[8798]|0;N=(M|0)>0;n=B;L1955:while(1){R=43264;while(1){a$=c[R>>2]|0;if((a$|0)==0){break}if((c[a$+4>>2]|0)==(n|0)){break L1955}else{R=a$|0}}R=n-1|0;if(!((n|0)>(M|0)&N)){aU=R;aV=ap;aW=aK;aX=ax;aY=1;aZ=R;a_=as;break L1952}n=((R|0)%(M|0)&-1)+1|0}M=c[a$+12>>2]|0;al=+h[a$+24>>3];_=+h[a$+32>>3];N=a[a$+40|0]|0;R=c[a$+48>>2]|0;aM=c[a$+52>>2]|0;ak=+h[a$+56>>3];if((c[(c[3524]|0)+96>>2]&1024|0)!=0){aU=n;aV=al;aW=_;aX=0;aY=R;aZ=aM;a_=ak;break}au=(N&1)==0;aU=M;aV=al;aW=_;aX=N;aY=au?1:R;aZ=au?M:aM;a_=ak}}while(0);ax=j|0;c[ax>>2]=aY;aM=j+4|0;c[aM>>2]=aZ;h[j+8>>3]=a_;do{if((aw|0)!=0){M=c[(c[3524]|0)+92>>2]|0;if(aW<0.0){cK[M&63](+h[3817]);break}else{cK[M&63](aW);break}}}while(0);cK[c[(c[3524]|0)+112>>2]&63](aV);aw=c[(c[3524]|0)+64>>2]|0;if((aU|0)<-5){cM[aw&511](-2)}else{cM[aw&511](aU)}aw=c[3524]|0;if((aX&1)==0){if((c[aw+96>>2]&1024|0)!=0){break}c[ax>>2]=1;c[aM>>2]=aU}fn(j,aw)}else{aw=g;c[aw>>2]=c[14084];c[aw+4>>2]=c[56340>>2];c[aw+8>>2]=c[56344>>2];c[aw+12>>2]=c[56348>>2];aw=c[14075]|0;do{if((c[14074]|0)!=0){as=+h[7040];M=c[(c[3524]|0)+92>>2]|0;if(as<0.0){cK[M&63](+h[3817]);break}else{cK[M&63](as);break}}}while(0);cK[c[(c[3524]|0)+112>>2]&63](+h[7039]);aM=c[(c[3524]|0)+64>>2]|0;if((aw|0)<-5){cM[aM&511](-2)}else{cM[aM&511](aw)}aM=c[3524]|0;if((a[56328]&1)==0){if((c[aM+96>>2]&1024|0)!=0){break}c[g>>2]=1;c[g+4>>2]=aw}fn(g,aM)}}while(0);B=c[3524]|0;aM=c[B+172>>2]|0;if((aM|0)==0){a0=B}else{cM[aM&511](0);a0=c[3524]|0}cN[c[a0+56>>2]&255](c[13528]|0,c[13530]|0);cN[c[(c[3524]|0)+60>>2]&255](c[13529]|0,c[13530]|0);cN[c[(c[3524]|0)+60>>2]&255](c[13529]|0,c[13531]|0);cN[c[(c[3524]|0)+60>>2]&255](c[13528]|0,c[13531]|0);cN[c[(c[3524]|0)+60>>2]&255](c[13528]|0,c[13530]|0);aM=c[(c[3524]|0)+172>>2]|0;if((aM|0)!=0){cM[aM&511](1)}aM=f;c[aM>>2]=c[14084];c[aM+4>>2]=c[56340>>2];c[aM+8>>2]=c[56344>>2];c[aM+12>>2]=c[56348>>2];aM=c[14075]|0;do{if((c[14074]|0)!=0){as=+h[7040];B=c[(c[3524]|0)+92>>2]|0;if(as<0.0){cK[B&63](+h[3817]);break}else{cK[B&63](as);break}}}while(0);cK[c[(c[3524]|0)+112>>2]&63](+h[7039]);B=c[(c[3524]|0)+64>>2]|0;if((aM|0)<-5){cM[B&511](-2)}else{cM[B&511](aM)}B=c[3524]|0;if((a[56328]&1)==0){if((c[B+96>>2]&1024|0)!=0){break}c[f>>2]=1;c[f+4>>2]=aM}fn(f,B)}}while(0);if((c[16745]|0)!=0){f=e;c[f>>2]=c[14084];c[f+4>>2]=c[56340>>2];c[f+8>>2]=c[56344>>2];c[f+12>>2]=c[56348>>2];f=c[14075]|0;do{if((c[14074]|0)!=0){aV=+h[7040];a0=c[(c[3524]|0)+92>>2]|0;if(aV<0.0){cK[a0&63](+h[3817]);break}else{cK[a0&63](aV);break}}}while(0);cK[c[(c[3524]|0)+112>>2]&63](+h[7039]);a0=c[(c[3524]|0)+64>>2]|0;if((f|0)<-5){cM[a0&511](-2)}else{cM[a0&511](f)}a0=c[3524]|0;do{if((a[56328]&1)==0){if((c[a0+96>>2]&1024|0)!=0){break}c[e>>2]=1;c[e+4>>2]=f;aS=1485}else{aS=1485}}while(0);if((aS|0)==1485){fn(e,a0)}de(3,8)}if((c[16801]|0)==0){i=d;return}fn(67216,c[3524]|0);aV=+h[8390];a0=(a[67136]&1)!=0;do{if((a[54017]|0)==104){e=~~(aV*(a0?1.0:-1.0)*+((c[(c[3524]|0)+24>>2]|0)>>>0>>>0));fx(67288,z,A,98672);aS=(c[z>>2]|0)+(((c[13529]|0)+(c[13528]|0)|0)/2&-1)|0;c[z>>2]=aS;f=~~(+(c[A>>2]|0)+(+(c[13530]|0)+ +((c[(c[3524]|0)+16>>2]|0)>>>0>>>0)*-2.7))+((e|0)<0?e:0)|0;c[A>>2]=f;if((aS|0)<0){c[z>>2]=0;a1=0}else{a1=aS}if((f|0)<0){c[A>>2]=0;a2=0}else{a2=f}ln(a1,a2,c[16801]|0,1,1,0,c[16802]|0)}else{f=~~(aV*(a0?-1.0:1.0)*+((c[(c[3524]|0)+28>>2]|0)>>>0>>>0));c[216]=0;if((c[16745]&1|0)!=0){c[216]=0;de(3,14)}fx(67288,z,A,98672);aS=c[3524]|0;e=~~(+(c[z>>2]|0)+(+(c[13529]|0)+(+(c[216]|0)+1.5)*+((c[aS+20>>2]|0)>>>0>>>0)))+((f|0)>0?f:0)|0;c[z>>2]=e;f=(c[A>>2]|0)+(((c[13531]|0)+(c[13530]|0)|0)/2&-1)|0;c[A>>2]=f;if((e|0)<0){c[z>>2]=0;a3=0}else{a3=e}if((f|0)<0){c[A>>2]=0;a4=0}else{a4=f}f=(cO[c[aS+72>>2]&255](c[16799]|0)|0)==0;aS=c[16801]|0;if(f){ln(a3,a4,aS,0,0,0,c[16802]|0);break}else{ln(a3,a4,aS,1,0,c[16799]|0,c[16802]|0);aS=c[(c[3524]|0)+72>>2]|0;cO[aS&255](0);break}}}while(0);if((c[16804]|0)==0){i=d;return}cM[c[(c[3524]|0)+64>>2]&511](-2);i=d;return}function dE(){c[13544]=(c[13544]|0)+1;c[13898]=(c[13898]|0)+1;return}function dF(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,n=0,p=0,q=0;c[12906]=b;do{if((d|0)==0){if((a[37400]&1)!=0){e=b;f=0;break}c[8272]=0;c[13898]=0;a[c[10036]|0]=0;e=b;f=0}else{e=b;f=d}}while(0);L2054:while(1){d=(c[10036]|0)+f|0;b=(c[10034]|0)-f|0;if((a[37400]&1)!=0){g=c[m>>2]|0;aK(e|0,g|0)}if((a6(d|0,b|0,c[o>>2]|0)|0)==0){h=1518;break}b=c[10036]|0;d=uA(b|0)|0;g=d-1|0;if((g|0)<=-1){break}i=b+g|0;b=a[i]|0;do{if(b<<24>>24==10){a[i]=0;do{if((g|0)>0){j=d-2|0;k=(c[10036]|0)+j|0;if((a[k]|0)!=13){l=g;break}a[k]=0;l=j}else{l=g}}while(0);j=(((l|0)>0)<<31>>31)+l|0;n=j;p=a[(c[10036]|0)+j|0]|0}else{if((d+1|0)>>>0<(c[10034]|0)>>>0){n=g;p=b;break}dG();e=138304;f=d;continue L2054}}while(0);d=p<<24>>24==92;if(d){e=138304;f=d?n:f}else{q=0;h=1533;break}}if((h|0)==1533){return q|0}do{if((h|0)==1518){if((a[37400]&1)!=0){n=c[m>>2]|0;aF(10,n|0)}a[(c[10036]|0)+f|0]=0;c[9354]=(c[9354]|0)+1;if((f|0)>0&(c[12918]|0)==0){break}else{q=1}return q|0}}while(0);q=0;return q|0}function dG(){var b=0,d=0,e=0,f=0;b=i;d=c[10034]|0;if((d|0)!=0){c[10036]=db(c[10036]|0,d+1024|0,216480)|0;c[10034]=(c[10034]|0)+1024;i=b;return}d=ut(1024)|0;do{if((d|0)==0){gk();e=ut(1024)|0;if((e|0)!=0){f=e;break}uf(-1,225296,(v=i,i=i+8|0,c[v>>2]=209632,v)|0)}else{f=d}}while(0);c[10036]=f;c[10034]=1024;a[f]=0;i=b;return}function dH(){var a=0,b=0,d=0,e=0;a=i;b=c[1052]|0;if((b|0)!=0){d=db(c[1054]|0,(b*40&-1)+16e3|0,136360)|0;c[1054]=d;uE(d+((c[1052]|0)*40&-1)|0,0,16e3);c[1052]=(c[1052]|0)+400;i=a;return}d=ut(16e3)|0;do{if((d|0)==0){gk();b=ut(16e3)|0;if((b|0)!=0){e=b;break}uf(-1,225296,(v=i,i=i+8|0,c[v>>2]=163112,v)|0)}else{e=d}}while(0);c[1054]=e;c[1052]=400;uE(e|0,0,16e3);i=a;return}function dI(){var b=0,d=0,e=0;b=i;do{if((a[33512]&1)==0){if((dF(105808,0)|0)==0){break}else{d=1}i=b;return d|0}else{do{if((a[14080]&1)!=0){do{if((a[37400]&1)!=0){e=c[(c[3524]|0)+96>>2]|0;if((e&1|0)!=0){break}if((c[10030]|0)!=(c[n>>2]|0)){if((e&2|0)==0){break}}lm();if((c[(c[3524]|0)+96>>2]&2|0)==0){uf(-1,100528,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}else{uf(-1,101160,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}}}while(0);if(a[13032]|0){break}e=c[(c[3524]|0)+100>>2]|0;if((e|0)==0){break}cS[e&511]();a[13032]=1}}while(0);if((dF(123048,0)|0)==0){break}else{d=1}i=b;return d|0}}while(0);a[25280]=a[37400]&1;d=(dJ()|0)!=0&1;i=b;return d|0}function dJ(){var b=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,x=0,y=0,z=0,A=0,B=0;b=i;do{if((a[43472]&1)!=0){if((dK()|0)==0){break}if((dK()|0)==0){break}if((dK()|0)==0){break}if((dK()|0)==0){break}uf(-1,98448,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}}while(0);e=c[10036]|0;while(1){if((aM(d[e]|0|0)|0)==0){break}else{e=e+1|0}}do{if((a8(e|0,35)|0)!=0){f=jl(40144,40136)|0;c[8272]=f;g=(c[10036]|0)+(c[(c[1054]|0)+(f*40&-1)+32>>2]|0)|0;if((a[g]|0)!=35){break}a[g]=0}}while(0);g=c[10036]|0;if((e|0)==(g|0)){h=e}else{uH(g|0,e|0,uA(e|0)|0);g=uA(e|0)|0;a[(c[10036]|0)+g|0]=0;h=c[10036]|0}if((a[h]|0)==33){g=h+1|0;if((g|0)==0){j=0;i=b;return j|0}if(!(a[14168]|0)){uf(-1,145320,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}bN(g|0);j=0;i=b;return j|0}c[9368]=0;g=jl(40144,40136)|0;c[8272]=g;h=c[12918]|0;if((h|0)<0){uf(-1,211816,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}do{if((h|0)>0){while(1){if((a[37400]&1)==0){if((a[33232]&1)==0){k=1600;break}}e=c[10036]|0;f=e+(uA(e|0)|0)|0;w=59;a[f]=w&255;w=w>>8;a[f+1|0]=w&255;if((dF(76720,uA(c[10036]|0)|0)|0)!=0){k=1597;break}f=jl(40144,40136)|0;c[8272]=f;e=(c[10036]|0)+(c[(c[1054]|0)+(f*40&-1)+32>>2]|0)|0;if((a[e]|0)==35){a[e]=0}if((c[12918]|0)<=0){k=1601;break}}if((k|0)==1597){uf(-1,224544,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}else if((k|0)==1600){uf(-1,224544,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}else if((k|0)==1601){l=c[8272]|0;break}}else{l=g}}while(0);c[13898]=0;if((l|0)>0){m=0}else{j=0;i=b;return j|0}L2171:while(1){a[55600]=0;a[55651]=0;a[55702]=0;a[55753]=0;a[55804]=0;a[55855]=0;a[55906]=0;a[55957]=0;a[56008]=0;a[56059]=0;a[56110]=0;a[56161]=0;if((t9(m)|0)==0){l=c[13898]|0;g=c[1054]|0;h=c[g+(l*40&-1)+36>>2]|0;e=c[g+(l*40&-1)+32>>2]|0;f=(a[g+(l*40&-1)|0]&1)==0;l=(h|0)>0;g=c[10036]|0;n=53600;o=133488;L2176:while(1){L2178:do{if(!f){if(l){p=0;q=0;r=e;while(1){s=a[o+p|0]|0;if(s<<24>>24==(a[g+(p+r|0)|0]|0)){t=r;u=q}else{if(s<<24>>24!=36){break L2178}t=r-1|0;u=1}x=p+1|0;if((x|0)<(u+h|0)){p=x;q=u;r=t}else{break}}if((u|0)==0){y=x}else{z=n;break L2176}}else{y=0}r=a[o+y|0]|0;if((r<<24>>24|0)==36|(r<<24>>24|0)==0){z=n;break L2176}}}while(0);r=n+8|0;q=c[r>>2]|0;if((q|0)==0){z=r;break}else{n=r;o=q}}cS[c[z+4>>2]&511]()}else{dT()}if((c[13484]|0)!=0){k=1617;break}A=c[13898]|0;o=c[8272]|0;L2193:do{if((A|0)<(o|0)){n=c[1054]|0;h=(a[n+(A*40&-1)|0]&1)==0;if(h){k=1649;break L2171}g=c[n+(A*40&-1)+36>>2]|0;e=n+(A*40&-1)+32|0;l=c[10036]|0;f=0;while(1){if((f|0)>=(g|0)){k=1623;break}if((a[l+((c[e>>2]|0)+f|0)|0]|0)==(a[f+103664|0]|0)){f=f+1|0}else{break}}do{if((k|0)==1623){k=0;if((f|0)!=1){break}e=A+1|0;c[13898]=e;B=e;break L2193}}while(0);if(h){k=1651;break L2171}f=c[n+(A*40&-1)+36>>2]|0;e=n+(A*40&-1)+32|0;l=c[10036]|0;g=0;while(1){if((g|0)>=(f|0)){k=1630;break}if((a[l+((c[e>>2]|0)+g|0)|0]|0)==(a[g+126728|0]|0)){g=g+1|0}else{break}}do{if((k|0)==1630){k=0;if((g|0)!=1){break}c[13544]=(c[13544]|0)+1;e=A+1|0;c[13898]=e;B=e;break L2193}}while(0);if(h){k=1647;break L2171}g=c[n+(A*40&-1)+36>>2]|0;e=n+(A*40&-1)+32|0;l=c[10036]|0;f=0;while(1){if((f|0)>=(g|0)){break}if((a[l+((c[e>>2]|0)+f|0)|0]|0)==(a[f+125616|0]|0)){f=f+1|0}else{k=1650;break L2171}}if((f|0)!=1){k=1648;break L2171}e=c[13544]|0;if((e|0)==0){k=1638;break L2171}c[13544]=e-1;e=A+1|0;c[13898]=e;B=e}else{B=A}}while(0);if((B|0)<(o|0)){m=B}else{j=0;k=1646;break}}if((k|0)==1646){i=b;return j|0}else if((k|0)==1647){uf(A,205408,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}else if((k|0)==1648){uf(A,205408,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}else if((k|0)==1649){uf(A,205408,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}else if((k|0)==1638){uf(A,103896,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}else if((k|0)==1617){c[13484]=0;j=1;i=b;return j|0}else if((k|0)==1650){uf(A,205408,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}else if((k|0)==1651){uf(A,205408,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);return 0}return 0}function dK(){var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0;b=i;if((a8(c[10036]|0,64)|0)==0){d=0;i=b;return d|0}e=c[10034]|0;f=ut(e)|0;do{if((f|0)==0){gk();g=ut(e)|0;if((g|0)!=0){h=g;break}uf(-1,225296,(v=i,i=i+8|0,c[v>>2]=222744,v)|0);return 0}else{h=f}}while(0);f=c[10036]|0;e=uA(f|0)|0;g=c[10034]|0;j=e>>>0<g>>>0?e:g-1|0;uF(h|0,f|0,j|0);a[h+j|0]=0;L2237:do{if((j|0)==0|(h|0)==0){k=0;l=0}else{f=0;g=0;e=j;m=0;n=0;o=h;p=0;q=0;while(1){r=a[o]|0;if(r<<24>>24==0){k=m;l=n;break L2237}s=r<<24>>24;L2241:do{if((s|0)==64){do{if(q|p|g){t=r}else{u=o+1|0;if((bO(a[u]|0|0)|0)==0){t=a[o]|0;break}else{w=u}while(1){if((bs(a[w]|0|0)|0)==0){x=a[w]|0;if(x<<24>>24!=95){break}}w=w+1|0}a[w]=0;y=e6(u)|0;do{if((y|0)==0){z=1671}else{if((c[y+16>>2]|0)!=3){z=1671;break}A=n+1|0;B=c[y+24>>2]|0;C=m+e|0;D=C+(uA(B|0)|0)|0;if(D>>>0>(c[10034]|0)>>>0){do{dG();D=C+(uA(B|0)|0)|0;}while(D>>>0>(c[10034]|0)>>>0)}C=a[B]|0;if(C<<24>>24==0){E=A;F=m;break}else{G=m;H=B;I=C}while(1){C=H+1|0;D=G+1|0;a[(c[10036]|0)+G|0]=I;J=a[C]|0;if(J<<24>>24==0){E=A;F=D;break}else{G=D;H=C;I=J}}}}while(0);if((z|0)==1671){z=0;uh(-1,221968,(v=i,i=i+8|0,c[v>>2]=u,v)|0);E=n;F=m}a[w]=x;K=0;L=0;M=w-1|0;N=E;O=F;P=0;Q=0;break L2241}}while(0);a[(c[10036]|0)+m|0]=t;K=q;L=p;M=o;N=n;O=m+1|0;P=g;Q=0}else if((s|0)==34){a[(c[10036]|0)+m|0]=r;K=q;L=p^(f^1);M=o;N=n;O=m+1|0;P=g;Q=0}else if((s|0)==39){a[(c[10036]|0)+m|0]=r;K=q^1;L=p;M=o;N=n;O=m+1|0;P=g;Q=0}else if((s|0)==92){a[(c[10036]|0)+m|0]=r;K=q;L=p;M=o;N=n;O=m+1|0;P=g;Q=f^p}else if((s|0)==35){if(q){R=g;z=1679;break}R=g|p^1;z=1679}else{R=g;z=1679}}while(0);if((z|0)==1679){z=0;a[(c[10036]|0)+m|0]=r;K=q;L=p;M=o;N=n;O=m+1|0;P=R;Q=0}s=M+1|0;y=e-1|0;if((y|0)==0|(s|0)==0){k=O;l=N;break}else{f=Q;g=P;e=y;m=O;n=N;o=s;p=L;q=K}}}}while(0);a[(c[10036]|0)+k|0]=0;uu(h);d=l;i=b;return d|0}function dL(b){b=b|0;var d=0,e=0;d=i;if((c[8501]|0)!=0){e=c[m>>2]|0;cf(e|0,154696,(v=i,i=i+8|0,c[v>>2]=b,v)|0)}hx(0,0,b);e=c[10034]|0;if(e>>>0<((uA(b|0)|0)+1|0)>>>0){do{dG();e=c[10034]|0;}while(e>>>0<((uA(b|0)|0)+1|0)>>>0)}uB(c[10036]|0,b|0);a[25280]=0;c[13484]=dJ()|0;hy();i=d;return}function dM(b){b=b|0;var d=0,e=0;d=i;if((b|0)==0){e=0}else{e=bP(b|0)|0}dL(e);if((a[872]&1)!=0&(c[6928]|0)!=0){if((c[8501]|0)!=0){e=c[m>>2]|0;aI(196688,8,1,e|0)}dO();i=d;return}if((a[27704]&1)==0){dP();i=d;return}else{uh(-1,185416,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);i=d;return}}function dN(){var a=0,b=0;a=i;b=c[13544]|0;if((b|0)==0){uf(c[13898]|0,103896,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}else{c[13544]=b-1;c[13898]=(c[13898]|0)+1;i=a;return}}function dO(){var b=0,d=0,e=0,f=0,g=0,j=0.0,k=0.0,l=0.0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0;b=i;d=c[10814]|0;e=c[6928]|0;if((d|0)==0&(e|0)==2){uf(-1,87408,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}f=c[10828]|0;if((f|0)==0&(e|0)==3){uf(-1,87408,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}if((e|0)==0){uh(-1,86328,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);dP();i=b;return}g=c[16507]|0;c[16506]=g;do{if((g&1|0)==0){j=+h[8257];if((a[66164]&1)==0){k=j;break}l=+_(+j);k=l/+h[8272]}else{k=8.988465674311578e+304}}while(0);h[8255]=k;m=a[66164]|0;do{if((g&2|0)==0){k=+h[8258];if((m&1)==0){n=k;break}l=+_(+k);n=l/+h[8272]}else{n=-8.988465674311578e+304}}while(0);h[8256]=n;if((m&1)==0){o=0.0}else{o=+_(+(+h[8271]))}h[8272]=o;m=c[16335]|0;c[16334]=m;do{if((m&1|0)==0){o=+h[8171];if((a[65476]&1)==0){p=o;break}n=+_(+o);p=n/+h[8186]}else{p=8.988465674311578e+304}}while(0);h[8169]=p;g=a[65476]|0;do{if((m&2|0)==0){p=+h[8172];if((g&1)==0){q=p;break}n=+_(+p);q=n/+h[8186]}else{q=-8.988465674311578e+304}}while(0);h[8170]=q;if((g&1)==0){r=0.0}else{r=+_(+(+h[8185]))}h[8186]=r;g=c[17195]|0;c[17194]=g;do{if((g&1|0)==0){r=+h[8601];if((a[68916]&1)==0){s=r;break}q=+_(+r);s=q/+h[8616]}else{s=8.988465674311578e+304}}while(0);h[8599]=s;m=a[68916]|0;do{if((g&2|0)==0){s=+h[8602];if((m&1)==0){t=s;break}q=+_(+s);t=q/+h[8616]}else{t=-8.988465674311578e+304}}while(0);h[8600]=t;if((m&1)==0){u=0.0}else{u=+_(+(+h[8615]))}h[8616]=u;m=c[17023]|0;c[17022]=m;do{if((m&1|0)==0){u=+h[8515];if((a[68228]&1)==0){w=u;break}t=+_(+u);w=t/+h[8530]}else{w=8.988465674311578e+304}}while(0);h[8513]=w;g=a[68228]|0;do{if((m&2|0)==0){w=+h[8516];if((g&1)==0){x=w;break}t=+_(+w);x=t/+h[8530]}else{x=-8.988465674311578e+304}}while(0);h[8514]=x;if((g&1)==0){y=0.0}else{y=+_(+(+h[8529]))}h[8530]=y;g=c[17539]|0;if((g&1|0)==0){y=+h[8773];if((a[70292]&1)==0){z=y}else{x=+_(+y);z=x/+h[8788]}h[8771]=z}if((g&2|0)==0){z=+h[8774];if((a[70292]&1)==0){A=z}else{x=+_(+z);A=x/+h[8788]}h[8772]=A}g=c[17367]|0;if((g&1|0)==0){A=+h[8687];if((a[69604]&1)==0){B=A}else{x=+_(+A);B=x/+h[8702]}h[8685]=B}if((g&2|0)==0){B=+h[8688];if((a[69604]&1)==0){C=B}else{x=+_(+B);C=x/+h[8702]}h[8686]=C}g=c[16163]|0;if((g&1|0)==0){C=+h[8085];if((a[64788]&1)==0){D=C}else{x=+_(+C);D=x/+h[8100]}h[8083]=D}if((g&2|0)==0){D=+h[8086];if((a[64788]&1)==0){E=D}else{x=+_(+D);E=x/+h[8100]}h[8084]=E}g=c[16679]|0;if((g&1|0)==0){E=+h[8343];if((a[66852]&1)==0){F=E}else{x=+_(+E);F=x/+h[8358]}h[8341]=F}if((g&2|0)==0){F=+h[8344];if((a[66852]&1)==0){G=F}else{x=+_(+F);G=x/+h[8358]}h[8342]=G}if((e|0)==2){iU(d,c[6930]|0)}else if((e|0)==3){i$(f,c[6930]|0)}if((c[16508]&2|0)!=0){G=+h[8256];h[8256]=+h[8255];h[8255]=G}if((c[16336]&2|0)!=0){G=+h[8170];h[8170]=+h[8169];h[8169]=G}if((c[17196]&2|0)!=0){G=+h[8600];h[8600]=+h[8599];h[8599]=G}if((c[17024]&2|0)!=0){G=+h[8514];h[8514]=+h[8513];h[8513]=G}f=c[6928]|0;if((f|0)==2){fS(c[10814]|0,c[6930]|0);i=b;return}else if((f|0)==3){fv(c[10828]|0,c[6930]|0,0);i=b;return}else{uf(-1,85504,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}}function dP(){var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,w=0,x=0,y=0;b=i;d=c[13898]|0;e=c[8272]|0;f=(e|0)>(d|0);L2430:do{if(f){g=c[1054]|0;if((a[g+(d*40&-1)|0]&1)!=0){h=c[g+(d*40&-1)+36>>2]|0;j=g+(d*40&-1)+32|0;g=c[10036]|0;k=0;while(1){if((k|0)>=(h|0)){l=1801;break}if((a[g+((c[j>>2]|0)+k|0)|0]|0)==(a[k+78280|0]|0)){k=k+1|0}else{break}}do{if((l|0)==1801){if((k|0)!=1){break}uf(d,77152,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}}while(0);if(!f){l=1804;break}}k=c[1054]|0;L2442:do{if((a[k+(d*40&-1)|0]&1)==0){m=k+(d*40&-1)+32|0}else{j=c[k+(d*40&-1)+36>>2]|0;g=k+(d*40&-1)+32|0;h=c[10036]|0;n=0;while(1){if((n|0)>=(j|0)){break}if((a[h+((c[g>>2]|0)+n|0)|0]|0)==(a[n+103664|0]|0)){n=n+1|0}else{m=g;break L2442}}if((n|0)==1){o=k;p=h;l=1811;break L2430}else{m=g}}}while(0);j=e-1|0;q=uA(c[6924]|0)|0;r=c[k+(j*40&-1)+32>>2]|0;s=c[k+(j*40&-1)+36>>2]|0;j=c[m>>2]|0;t=(((q+3|0)+r|0)+s|0)-j|0;q=s+r|0;r=db(0,(q+1|0)-j|0,116456)|0;j=c[(c[1054]|0)+(d*40&-1)+32>>2]|0;L2450:do{if((j|0)<(q|0)){s=j;u=r;while(1){w=a[(c[10036]|0)+s|0]|0;if(w<<24>>24==0){x=u;break L2450}y=u+1|0;a[u]=w;w=s+1|0;if((w|0)<(q|0)){s=w;u=y}else{x=y;break}}}else{x=r}}while(0);a[x]=0;if((c[10034]|0)>>>0<t>>>0){do{dG();}while((c[10034]|0)>>>0<t>>>0)}t=c[10036]|0;q=c[6924]|0;uB(t|0,q|0);q=c[10036]|0;t=q+(uA(q|0)|0)|0;a[t]=a[86120]|0;a[t+1|0]=a[86121|0]|0;a[t+2|0]=a[86122|0]|0;t=c[10036]|0;uC(t|0,r|0);uu(r)}else{l=1804}}while(0);if((l|0)==1804){o=c[1054]|0;p=c[10036]|0;l=1811}if((l|0)==1811){l=p+(c[o+(d*40&-1)+32>>2]|0)|0;d=uA(c[6924]|0)|0;o=uA(l|0)|0;x=o+1|0;uH(p|0,l|0,x|0);l=(d+1|0)+o|0;if((c[10034]|0)>>>0<l>>>0){do{dG();}while((c[10034]|0)>>>0<l>>>0)}l=c[10036]|0;uH(l+d|0,l|0,x|0);uD(c[10036]|0,c[6924]|0,d)}c[7738]=0;c[6928]=0;a[25280]=0;c[8272]=jl(40144,40136)|0;c[13898]=1;if((a[37384]&1)==0){iS();i=b;return}else{iZ();i=b;return}}function dQ(){var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;b=i;i=i+56|0;d=b|0;e=d|0;f=(c[13898]|0)+1|0;c[13898]=f;g=c[8272]|0;if((f|0)>=(g|0)){i=b;return}h=d|0;j=f;f=g;L2477:while(1){g=c[1054]|0;k=c[g+(j*40&-1)+36>>2]|0;L2479:do{if((a[g+(j*40&-1)|0]&1)==0){l=c[10036]|0;m=g+(j*40&-1)+32|0}else{n=g+(j*40&-1)+32|0;o=c[10036]|0;p=0;while(1){if((p|0)>=(k|0)){break}if((a[o+((c[n>>2]|0)+p|0)|0]|0)==(a[p+103664|0]|0)){p=p+1|0}else{l=o;m=n;break L2479}}if((p|0)==1){q=1848;break L2477}else{l=o;m=n}}}while(0);uD(e|0,l+(c[m>>2]|0)|0,(k|0)<49?k:49);a[d+((k|0)>49?49:k)|0]=0;r=j+1|0;L2487:do{if((f|0)>(r|0)){if((a[g+(r*40&-1)|0]&1)==0){s=0;t=j;break}u=c[g+(r*40&-1)+36>>2]|0;v=g+(r*40&-1)+32|0;w=0;while(1){if((w|0)>=(u|0)){break}if((a[l+((c[v>>2]|0)+w|0)|0]|0)==(a[w+134808|0]|0)){w=w+1|0}else{s=0;t=j;break L2487}}if((w|0)!=1){s=0;t=j;break}c[13898]=r;s=1;t=r}else{s=0;t=j}}while(0);do{if((a_(h|0,167320,6)|0)==0){x=t;y=f}else{if((a_(h|0,126208,6)|0)==0){x=t;y=f;break}e2(h,s);x=c[13898]|0;y=c[8272]|0}}while(0);r=x+1|0;c[13898]=r;if((r|0)<(y|0)){j=r;f=y}else{q=1847;break}}if((q|0)==1847){i=b;return}else if((q|0)==1848){i=b;return}}function dR(){dU(0);return}function dS(){dU(1);return}function dT(){var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;b=i;i=i+696|0;d=b|0;e=b+56|0;f=b+80|0;g=c[13898]|0;h=g+1|0;j=c[8272]|0;k=c[1054]|0;L2506:do{if((j|0)>(h|0)){if((a[k+(h*40&-1)|0]&1)==0){break}l=c[k+(h*40&-1)+36>>2]|0;m=k+(h*40&-1)+32|0;n=c[10036]|0;o=0;while(1){if((o|0)>=(l|0)){break}if((a[n+((c[m>>2]|0)+o|0)|0]|0)==(a[o+199040|0]|0)){o=o+1|0}else{break L2506}}if((o|0)!=1){break}uD(f|0,55600,612);m=0;l=g;L2514:while(1){p=l+2|0;c[13898]=p;q=c[k+(p*40&-1)+36>>2]|0;r=(q|0)>49?49:q;q=c[k+(p*40&-1)+32>>2]|0;s=0;while(1){t=s+1|0;a[55600+(m*51&-1)+s|0]=a[n+q|0]|0;if((t|0)==(r|0)){break}else{q=q+1|0;s=t}}u=m+1|0;a[55600+(m*51&-1)+r|0]=0;w=l+3|0;x=(j|0)>(w|0);if(!x){break}if((a[k+(w*40&-1)|0]&1)==0){y=1867;break}s=c[k+(w*40&-1)+36>>2]|0;q=k+(w*40&-1)+32|0;t=0;while(1){if((t|0)>=(s|0)){break}if((a[n+((c[q>>2]|0)+t|0)|0]|0)==(a[t+148464|0]|0)){t=t+1|0}else{y=1866;break L2514}}if((t|0)==1&(u|0)<12){m=u;l=p}else{y=1866;break}}if((y|0)==1866){if(x){y=1867}}L2527:do{if((y|0)==1867){if((a[k+(w*40&-1)|0]&1)==0){break}m=c[k+(w*40&-1)+36>>2]|0;o=k+(w*40&-1)+32|0;q=0;while(1){if((q|0)>=(m|0)){break}if((a[n+((c[o>>2]|0)+q|0)|0]|0)==(a[q+148464|0]|0)){q=q+1|0}else{break L2527}}if((q|0)!=1){break}uf(l+4|0,172072,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}}while(0);o=l+5|0;c[13898]=o;if((o|0)>=(j|0)){uf(o,168144,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}L2539:do{if((a[k+(o*40&-1)|0]&1)!=0){m=c[k+(o*40&-1)+36>>2]|0;p=k+(o*40&-1)+32|0;t=0;while(1){if((t|0)>=(m|0)){break}if((a[n+((c[p>>2]|0)+t|0)|0]|0)==(a[t+103664|0]|0)){t=t+1|0}else{break L2539}}if((t|0)!=1){break}uf(o,168144,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}}while(0);o=iv(g)|0;c[11670]=o;c[o+16>>2]=u;it();n=c[18070]|0;l=db(n,c[n>>2]<<5|8,105624)|0;c[18070]=0;if((l|0)==0){uf(g,152776,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}n=o+8|0;p=c[n>>2]|0;if((p|0)!=0){e1(p)}c[n>>2]=l;uD(55600,f|0,612);l=o+12|0;n=(c[13898]|0)-1|0;p=c[1054]|0;m=(c[p+(n*40&-1)+36>>2]|0)+(c[p+(n*40&-1)+32>>2]|0)|0;n=db(c[l>>2]|0,(m+1|0)-(c[p+(g*40&-1)+32>>2]|0)|0,116456)|0;c[l>>2]=n;p=c[(c[1054]|0)+(g*40&-1)+32>>2]|0;L2553:do{if((p|0)<(m|0)){q=p;s=n;while(1){r=a[(c[10036]|0)+q|0]|0;if(r<<24>>24==0){z=s;break L2553}A=s+1|0;a[s]=r;r=q+1|0;if((r|0)<(m|0)){q=r;s=A}else{z=A;break}}}else{z=n}}while(0);a[z]=0;c[11670]=0;n=o+4|0;m=(uA(c[n>>2]|0)|0)+8|0;p=ut(m)|0;do{if((p|0)==0){gk();s=ut(m)|0;if((s|0)!=0){B=s;break}uf(-1,225296,(v=i,i=i+8|0,c[v>>2]=154560,v)|0)}else{B=p}}while(0);a[B]=a[151320]|0;a[B+1|0]=a[151321|0]|0;a[B+2|0]=a[151322|0]|0;a[B+3|0]=a[151323|0]|0;a[B+4|0]=a[151324|0]|0;a[B+5|0]=a[151325|0]|0;a[B+6|0]=a[151326|0]|0;uC(B|0,c[n>>2]|0);p=c[l>>2]|0;m=e6(B)|0;L2562:do{if((m|0)!=0){o=m+8|0;do{if((a[o]&1)==0){s=c[m+24>>2]|0;if((aY(s|0,p|0)|0)==0){break L2562}q=m+16|0;if((c[q>>2]|0)!=3){break}uu(s);c[q>>2]=1}else{a[o]=0}}while(0);if((p|0)==0){C=0}else{C=bP(p|0)|0}c[m+16>>2]=3;c[m+24>>2]=C}}while(0);uu(B);i=b;return}}while(0);B=c[10036]|0;C=k+(g*40&-1)+32|0;z=B+(c[C>>2]|0)|0;if((a_(z|0,167320,6)|0)==0){uf(g,145392,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}if((a_(z|0,126208,6)|0)==0){uf(g,145392,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}c[13898]=g+2;z=d|0;f=c[k+(g*40&-1)+36>>2]|0;g=(f|0)>49?49:f;f=c[C>>2]|0;C=0;while(1){k=C+1|0;a[d+C|0]=a[B+f|0]|0;if((k|0)==(g|0)){break}else{f=f+1|0;C=k}}a[d+g|0]=0;g=e6(z)|0;is(e);z=g+8|0;do{if((a[z]&1)==0){d=g+16|0;if((c[d>>2]|0)!=3){break}uu(c[g+24>>2]|0);c[d>>2]=1}}while(0);d=g+16|0;g=e;c[d>>2]=c[g>>2];c[d+4>>2]=c[g+4>>2];c[d+8>>2]=c[g+8>>2];c[d+12>>2]=c[g+12>>2];c[d+16>>2]=c[g+16>>2];c[d+20>>2]=c[g+20>>2];a[z]=0;i=b;return}function dU(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;d=i;i=i+24|0;e=d|0;f=c[13898]|0;g=f+1|0;c[13898]=g;h=c[8272]|0;if((g|0)>=(h|0)){i=d;return}j=c[1054]|0;k=(a[j+(g*40&-1)|0]&1)==0;L2594:do{if(k){l=g}else{m=c[j+(g*40&-1)+36>>2]|0;n=j+(g*40&-1)+32|0;o=c[10036]|0;p=0;while(1){if((p|0)>=(m|0)){q=1921;break}if((a[o+((c[n>>2]|0)+p|0)|0]|0)==(a[p+103664|0]|0)){p=p+1|0}else{break}}do{if((q|0)==1921){if((p|0)!=1){break}i=d;return}}while(0);if(k){l=g;break}p=c[j+(g*40&-1)+36>>2]|0;n=j+(g*40&-1)+32|0;o=c[10036]|0;m=0;while(1){if((m|0)>=(p|0)){q=1926;break}if((a[o+((c[n>>2]|0)+m|0)|0]|0)==(a[m+202112|0]|0)){m=m+1|0}else{q=1927;break}}if((q|0)==1926){if((m|0)!=1){q=1927}}if((q|0)==1927){if(k){l=g;break}n=c[j+(g*40&-1)+36>>2]|0;o=j+(g*40&-1)+32|0;p=c[10036]|0;r=0;while(1){if((r|0)>=(n|0)){break}if((a[p+((c[o>>2]|0)+r|0)|0]|0)==(a[r+129568|0]|0)){r=r+1|0}else{l=g;break L2594}}if((r|0)!=1){l=g;break}}o=f+2|0;c[13898]=o;l=o}}while(0);L2618:do{if((l|0)<(h|0)){f=(a[j+(l*40&-1)|0]&1)==0;do{if(!f){g=c[j+(l*40&-1)+36>>2]|0;k=j+(l*40&-1)+32|0;o=c[10036]|0;p=0;while(1){if((p|0)>=(g|0)){q=1938;break}if((a[o+((c[k>>2]|0)+p|0)|0]|0)==(a[p+103664|0]|0)){p=p+1|0}else{q=1939;break}}if((q|0)==1938){if((p|0)==1|f^1){break L2618}else{break}}else if((q|0)==1939){if(f){break}else{break L2618}}}}while(0);f=is(e)|0;r=c[f>>2]|0;if((r|0)==3){k=c[f+8>>2]|0;uz(k,0)}else if(!((r|0)==1|(r|0)==2)){uf(-1,213288,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}r=e|0;if((c[r>>2]|0)==3){uu(c[e+8>>2]|0);c[r>>2]=1}c[13898]=(c[13898]|0)+1;i=d;return}}while(0);if((b|0)==0){uf(l,136616,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}else{uf(l,138312,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}}function dV(){var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0;b=i;d=c[13898]|0;e=d+1|0;c[13898]=e;f=c[8272]|0;g=(e|0)<(f|0);L2642:do{if(g){h=c[1054]|0;j=(a[h+(e*40&-1)|0]&1)==0;if(!j){k=c[h+(e*40&-1)+36>>2]|0;l=h+(e*40&-1)+32|0;n=c[10036]|0;o=0;while(1){if((o|0)>=(k|0)){p=1958;break}if((a[n+((c[l>>2]|0)+o|0)|0]|0)==(a[o+103664|0]|0)){o=o+1|0}else{p=1959;break}}if((p|0)==1959){if(!j){p=1960}}else if((p|0)==1958){if(!((o|0)==1|j)){p=1960}}L2652:do{if((p|0)==1960){l=c[h+(e*40&-1)+36>>2]|0;n=h+(e*40&-1)+32|0;k=c[10036]|0;q=0;while(1){if((q|0)>=(l|0)){break}if((a[k+((c[n>>2]|0)+q|0)|0]|0)==(a[q+124624|0]|0)){q=q+1|0}else{break L2652}}if((q|0)!=1){break}n=c[14128]|0;if((n|0)==0){r=e}else{k=n;while(1){n=k+12|0;l=c[n>>2]|0;if((l|0)!=0){uu(l);c[n>>2]=0}n=c[k+24>>2]|0;uu(k);if((n|0)==0){break}else{k=n}}r=c[13898]|0}c[14128]=0;c[13898]=r+1;i=b;return}}while(0);if(!g){s=0;t=e;break}}h=c[1054]|0;j=(a[h+(e*40&-1)|0]&1)==0;if(j){s=0;t=e;break}o=c[h+(e*40&-1)+36>>2]|0;k=h+(e*40&-1)+32|0;h=c[10036]|0;q=0;while(1){if((q|0)>=(o|0)){p=1975;break}if((a[h+((c[k>>2]|0)+q|0)|0]|0)==(a[q+103664|0]|0)){q=q+1|0}else{break}}if((p|0)==1975){if((q|0)==1){s=0;t=e;break}}if(!((o|0)>0&(j^1))){s=0;t=e;break}h=c[10036]|0;n=0;l=0;u=c[k>>2]|0;while(1){if((a[n+133296|0]|0)==(a[h+(n+u|0)|0]|0)){w=u;x=l}else{if((n|0)!=3){s=0;t=e;break L2642}w=u-1|0;x=1}y=n+1|0;if((y|0)<(x+o|0)){n=y;l=x;u=w}else{break}}if((x|0)==0){if(!((n|0)==2|(n|0)==10)){s=0;t=e;break}}u=d+2|0;c[13898]=u;s=1;t=u}else{s=0;t=e}}while(0);L2689:do{if((t|0)<(f|0)){e=c[1054]|0;L2691:do{if((a[e+(t*40&-1)|0]&1)==0){z=c[10036]|0;A=e+(t*40&-1)+32|0}else{d=c[e+(t*40&-1)+36>>2]|0;x=e+(t*40&-1)+32|0;w=c[10036]|0;g=0;while(1){if((g|0)>=(d|0)){break}if((a[w+((c[x>>2]|0)+g|0)|0]|0)==(a[g+103664|0]|0)){g=g+1|0}else{z=w;A=x;break L2691}}if((g|0)==1){B=0;C=t;D=f;break L2689}else{z=w;A=x}}}while(0);e=z+(c[A>>2]|0)|0;n=e;d=(a8(e|0,32)|0)-n|0;do{if((d|0)<0){r=(a8(e|0,0)|0)-n|0;if((r|0)>=0){E=r;break}r=c[m>>2]|0;cf(r|0,131904,(v=i,i=i+16|0,c[v>>2]=130592,c[v+8>>2]=754,v)|0);i=b;return}else{E=d}}while(0);d=E+1|0;n=ut(d)|0;do{if((n|0)==0){gk();e=ut(d)|0;if((e|0)!=0){F=e;break}uf(-1,225296,(v=i,i=i+8|0,c[v>>2]=129544,v)|0)}else{F=n}}while(0);n=c[13898]|0;d=c[1054]|0;e=a[d+(n*40&-1)|0]|0;do{if((e&1)==0){p=2e3}else{r=c[d+(n*40&-1)+32>>2]|0;u=c[10036]|0;l=a[u+r|0]|0;if(!((l<<24>>24|0)==39|(l<<24>>24|0)==34)){p=2e3;break}l=(c[d+(n*40&-1)+36>>2]|0)-2|0;L2711:do{if((l|0)>0){o=r;h=0;k=u;while(1){j=o+1|0;q=h+1|0;a[F+h|0]=a[k+j|0]|0;if((q|0)==(l|0)){G=l;break L2711}o=j;h=q;k=c[10036]|0}}else{G=0}}while(0);a[F+G|0]=0;if((a[(c[10036]|0)+(c[(c[1054]|0)+(n*40&-1)+32>>2]|0)|0]|0)==34){ua(F);break}else{H=F;I=F}while(1){l=a[I]|0;if((l<<24>>24|0)==0){break}else if((l<<24>>24|0)==39){u=I+1|0;r=(a[u]|0)==39?u:I;J=r;K=a[r]|0}else{J=I;K=l}a[H]=K;H=H+1|0;I=J+1|0}a[H]=0}}while(0);L2724:do{if((p|0)==2e3){if((n|0)<(c[8272]|0)){L=F;M=n;N=d;O=e}else{break}while(1){l=c[N+(M*40&-1)+36>>2]|0;r=N+(M*40&-1)+32|0;L2728:do{if((O&1)!=0){u=c[10036]|0;x=0;while(1){if((x|0)>=(l|0)){break}if((a[u+((c[r>>2]|0)+x|0)|0]|0)==(a[x+103664|0]|0)){x=x+1|0}else{break L2728}}if((x|0)==1){break L2724}}}while(0);u=c[r>>2]|0;w=0;while(1){g=w+1|0;a[L+w|0]=a[(c[10036]|0)+u|0]|0;if((g|0)==(l|0)){break}u=u+1|0;w=g}a[L+l|0]=0;w=c[13898]|0;u=c[1054]|0;r=c[u+(w*40&-1)+36>>2]|0;g=a[(c[10036]|0)+((c[u+(w*40&-1)+32>>2]|0)+r|0)|0]|0;if((g<<24>>24|0)==32|(g<<24>>24|0)==9|(g<<24>>24|0)==0){break L2724}g=w+1|0;c[13898]=g;if((g|0)>=(c[8272]|0)){break L2724}L=L+r|0;M=g;N=u;O=a[u+(g*40&-1)|0]|0}}}while(0);e=(c[13898]|0)+1|0;c[13898]=e;B=F;C=e;D=c[8272]|0}else{B=0;C=t;D=f}}while(0);L2743:do{if((C|0)<(D|0)){f=c[1054]|0;L2745:do{if((a[f+(C*40&-1)|0]&1)==0){P=c[10036]|0}else{t=c[f+(C*40&-1)+36>>2]|0;F=f+(C*40&-1)+32|0;O=c[10036]|0;N=0;while(1){if((N|0)>=(t|0)){break}if((a[O+((c[F>>2]|0)+N|0)|0]|0)==(a[N+103664|0]|0)){N=N+1|0}else{P=O;break L2745}}if((N|0)==1){Q=0;break L2743}else{P=O}}}while(0);f=(uA(P|0)|0)+1|0;F=ut(f)|0;do{if((F|0)==0){gk();t=ut(f)|0;if((t|0)!=0){R=t;break}uf(-1,225296,(v=i,i=i+8|0,c[v>>2]=128272,v)|0)}else{R=F}}while(0);F=c[13898]|0;f=c[1054]|0;t=a[f+(F*40&-1)|0]|0;do{if((t&1)!=0){M=c[f+(F*40&-1)+32>>2]|0;L=c[10036]|0;p=a[L+M|0]|0;if(!((p<<24>>24|0)==39|(p<<24>>24|0)==34)){break}p=(c[f+(F*40&-1)+36>>2]|0)-2|0;L2760:do{if((p|0)>0){H=M;J=0;I=L;while(1){K=H+1|0;G=J+1|0;a[R+J|0]=a[I+K|0]|0;if((G|0)==(p|0)){S=p;break L2760}H=K;J=G;I=c[10036]|0}}else{S=0}}while(0);a[R+S|0]=0;if((a[(c[10036]|0)+(c[(c[1054]|0)+(F*40&-1)+32>>2]|0)|0]|0)==34){ua(R)}else{p=R;L=R;while(1){M=a[L]|0;if((M<<24>>24|0)==39){O=L+1|0;N=(a[O]|0)==39?O:L;T=N;U=a[N]|0}else if((M<<24>>24|0)==0){break}else{T=L;U=M}a[p]=U;p=p+1|0;L=T+1|0}a[p]=0}c[13898]=(c[13898]|0)+1;Q=R;break L2743}}while(0);if((F|0)<(c[8272]|0)){V=R;W=F;X=f;Y=t}else{Q=R;break}while(1){L=c[X+(W*40&-1)+36>>2]|0;M=X+(W*40&-1)+32|0;L2777:do{if((Y&1)!=0){N=c[10036]|0;O=0;while(1){if((O|0)>=(L|0)){break}if((a[N+((c[M>>2]|0)+O|0)|0]|0)==(a[O+103664|0]|0)){O=O+1|0}else{break L2777}}if((O|0)==1){Q=R;break L2743}}}while(0);p=c[M>>2]|0;N=0;while(1){I=N+1|0;a[V+N|0]=a[(c[10036]|0)+p|0]|0;if((I|0)==(L|0)){break}p=p+1|0;N=I}a[V+L|0]=0;N=c[13898]|0;p=c[1054]|0;M=c[p+(N*40&-1)+36>>2]|0;I=V+M|0;J=a[(c[10036]|0)+((c[p+(N*40&-1)+32>>2]|0)+M|0)|0]|0;if((J<<24>>24|0)==32|(J<<24>>24|0)==9|(J<<24>>24|0)==0){J=V+(M+1|0)|0;a[I]=32;a[J]=0;Z=J;_=c[13898]|0}else{Z=I;_=N}N=_+1|0;c[13898]=N;if((N|0)>=(c[8272]|0)){Q=R;break L2743}I=c[1054]|0;V=Z;W=N;X=I;Y=a[I+(N*40&-1)|0]|0}}else{Q=0}}while(0);hR(B,Q,s);i=b;return}function dW(){var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;b=i;i=i+32|0;d=b|0;e=b+24|0;c[e>>2]=0;f=(c[13898]|0)+1|0;c[13898]=f;L2795:do{if((f|0)<(c[8272]|0)){g=c[1054]|0;L2797:do{if((a[g+(f*40&-1)|0]&1)!=0){h=c[g+(f*40&-1)+36>>2]|0;j=g+(f*40&-1)+32|0;k=c[10036]|0;l=0;while(1){if((l|0)>=(h|0)){break}if((a[k+((c[j>>2]|0)+l|0)|0]|0)==(a[l+103664|0]|0)){l=l+1|0}else{break L2797}}if((l|0)==1){break L2795}}}while(0);a[14176]=1;is(d);a[14176]=0;if((c[d>>2]|0)!=3){c[13898]=f;break}g=c[d+8>>2]|0;c[e>>2]=g;if((g|0)!=0){iQ(e);g=c[e>>2]|0;hw(hA(g,193632)|0,g,1);i=b;return}m=c[13898]|0;uf(m,149040,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}}while(0);c[e>>2]=0;m=f;uf(m,149040,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}function dX(){var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;b=i;i=i+32|0;d=b|0;e=b+24|0;c[e>>2]=0;f=(c[13898]|0)+1|0;c[13898]=f;L2814:do{if((f|0)<(c[8272]|0)){g=c[1054]|0;L2816:do{if((a[g+(f*40&-1)|0]&1)!=0){h=c[g+(f*40&-1)+36>>2]|0;j=g+(f*40&-1)+32|0;k=c[10036]|0;l=0;while(1){if((l|0)>=(h|0)){break}if((a[k+((c[j>>2]|0)+l|0)|0]|0)==(a[l+103664|0]|0)){l=l+1|0}else{break L2816}}if((l|0)==1){break L2814}}}while(0);a[14176]=1;is(d);a[14176]=0;if((c[d>>2]|0)!=3){c[13898]=f;break}g=c[d+8>>2]|0;c[e>>2]=g;if((g|0)==0){m=c[13898]|0;uf(m,124592,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}iQ(e);g=c[e>>2]|0;if((bY(g|0)|0)==0){e7(5);uu(g);i=b;return}else{uf(c[13898]|0,123232,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}}}while(0);c[e>>2]=0;m=f;uf(m,124592,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}function dY(){var b=0,d=0,e=0,f=0,h=0,i=0,j=0.0,k=0.0;if((a[14080]&1)==0){lk()}do{if(a[14088]|0){if((a[33512]&1)==0){break}if(!(a[13032]|0)){break}b=c[(c[3524]|0)+104>>2]|0;if((b|0)!=0){cS[b&511]()}a[13032]=0}else{cS[c[(c[3524]|0)+52>>2]&511]();a[14088]=1}}while(0);cM[c[(c[3524]|0)+168>>2]&511](0);b=c[3524]|0;if((c[b+96>>2]&16|0)!=0){c[7271]=-1}c[13880]=0;d=b+8|0;c[13881]=(c[d>>2]|0)-1;c[13882]=0;e=b+12|0;c[13883]=(c[e>>2]|0)-1;if((a[33512]&1)==0){lh();a[25280]=0;f=c[13898]|0;h=f+1|0;c[13898]=h;return}i=c[b+108>>2]|0;if((i|0)==0){lh();a[25280]=0;f=c[13898]|0;h=f+1|0;c[13898]=h;return}j=+((c[d>>2]|0)>>>0>>>0);k=+((c[e>>2]|0)>>>0>>>0);cI[i&63](0,~~(+g[184]*j),~~(+g[44]*k),~~(j*+g[178]),~~(k*+g[38]));lh();a[25280]=0;f=c[13898]|0;h=f+1|0;c[13898]=h;return}function dZ(){var a=0;a=i;c[13898]=(c[13898]|0)+1;uh(-1,116984,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);i=a;return}function d_(){var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;b=i;i=i+24|0;d=b|0;e=(c[13898]|0)+1|0;c[13898]=e;L2860:do{if((e|0)<(c[8272]|0)){f=c[1054]|0;L2862:do{if((a[f+(e*40&-1)|0]&1)!=0){g=c[f+(e*40&-1)+36>>2]|0;h=f+(e*40&-1)+32|0;j=c[10036]|0;k=0;while(1){if((k|0)>=(g|0)){break}if((a[j+((c[h>>2]|0)+k|0)|0]|0)==(a[k+103664|0]|0)){k=k+1|0}else{break L2862}}if((k|0)==1){l=e;break L2860}}}while(0);a[14176]=1;is(d);a[14176]=0;if((c[d>>2]|0)!=3){c[13898]=e;l=e;break}f=c[d+8>>2]|0;if((f|0)==0){l=c[13898]|0;break}else{dL(f);i=b;return}}else{l=e}}while(0);uf(l,122e3,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}function d$(){var b=0,d=0,e=0,f=0,g=0;b=(c[13898]|0)+1|0;if((c[8272]|0)<=(b|0)){c[13484]=1;return}d=c[1054]|0;if((a[d+(b*40&-1)|0]&1)==0){c[13484]=1;return}e=c[d+(b*40&-1)+36>>2]|0;f=d+(b*40&-1)+32|0;b=c[10036]|0;d=0;while(1){if((d|0)>=(e|0)){break}if((a[b+((c[f>>2]|0)+d|0)|0]|0)==(a[d+78208|0]|0)){d=d+1|0}else{g=2133;break}}if((g|0)==2133){c[13484]=1;return}if((d|0)==7){bd(0)}else{c[13484]=1;return}}function d0(){var b=0,d=0,e=0,f=0,g=0,j=0,k=0,l=0,m=0.0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0;b=i;i=i+24|0;d=b|0;e=(c[13898]|0)+1|0;c[13898]=e;if((c[8272]|0)<=(e|0)){uf(e,116032,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}f=c[1054]|0;if((a[f+(e*40&-1)|0]&1)==0){uf(e,116032,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}g=c[f+(e*40&-1)+36>>2]|0;j=f+(e*40&-1)+32|0;f=c[10036]|0;k=0;while(1){if((k|0)>=(g|0)){break}if((a[f+((c[j>>2]|0)+k|0)|0]|0)==(a[k+199040|0]|0)){k=k+1|0}else{l=2234;break}}if((l|0)==2234){uf(e,116032,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}if((k|0)!=1){uf(e,116032,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}e=is(d)|0;k=c[e>>2]|0;if((k|0)==1){m=+(c[e+8>>2]|0)}else if((k|0)==3){m=+uz(c[e+8>>2]|0,0)}else if((k|0)==2){m=+h[e+8>>3]}else{uf(-1,213288,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}e=d|0;if((c[e>>2]|0)==3){uu(c[d+8>>2]|0);c[e>>2]=1}e=c[13898]|0;d=c[8272]|0;k=(d|0)>(e|0);L2917:do{if(k){j=c[1054]|0;if((a[j+(e*40&-1)|0]&1)==0){break}f=c[j+(e*40&-1)+36>>2]|0;g=j+(e*40&-1)+32|0;n=c[10036]|0;o=0;while(1){if((o|0)>=(f|0)){break}if((a[n+((c[g>>2]|0)+o|0)|0]|0)==(a[o+126728|0]|0)){o=o+1|0}else{break L2917}}if((o|0)!=1){break}f=c[g>>2]|0;p=e+1|0;c[13898]=p;q=1;r=p;while(1){if((r|0)>=(d|0)){l=2159;break}L2928:do{if((a[j+(r*40&-1)|0]&1)==0){l=2166}else{p=c[j+(r*40&-1)+36>>2]|0;s=j+(r*40&-1)+32|0;t=0;while(1){if((t|0)>=(p|0)){break}if((a[n+((c[s>>2]|0)+t|0)|0]|0)==(a[t+126728|0]|0)){t=t+1|0}else{l=2166;break L2928}}if((t|0)!=1){l=2166;break}u=q+1|0}}while(0);if((l|0)==2166){l=0;L2937:do{if((a[j+(r*40&-1)|0]&1)==0){w=0}else{s=c[j+(r*40&-1)+36>>2]|0;p=j+(r*40&-1)+32|0;x=0;while(1){if((x|0)>=(s|0)){break}if((a[n+((c[p>>2]|0)+x|0)|0]|0)==(a[x+125616|0]|0)){x=x+1|0}else{w=0;break L2937}}w=((x|0)==1)<<31>>31}}while(0);u=w+q|0}p=r+1|0;if((u|0)==0){y=p;break}else{q=u;r=p}}if((l|0)==2159){y=r+1|0}q=c[j+(r*40&-1)+32>>2]|0;c[13898]=y;L2948:do{if((d|0)>(y|0)){if((a[j+(y*40&-1)|0]&1)==0){z=0;A=0;B=y;break}g=c[j+(y*40&-1)+36>>2]|0;o=j+(y*40&-1)+32|0;p=0;while(1){if((p|0)>=(g|0)){break}if((a[n+((c[o>>2]|0)+p|0)|0]|0)==(a[p+200904|0]|0)){p=p+1|0}else{z=0;A=0;B=y;break L2948}}if((p|0)!=4){z=0;A=0;B=y;break}o=y+1|0;c[13898]=o;if((d|0)<=(o|0)){uf(o,114208,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}if((a[j+(o*40&-1)|0]&1)==0){uf(o,114208,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}g=c[j+(o*40&-1)+36>>2]|0;s=j+(o*40&-1)+32|0;t=0;while(1){if((t|0)>=(g|0)){break}if((a[n+((c[s>>2]|0)+t|0)|0]|0)==(a[t+126728|0]|0)){t=t+1|0}else{l=2242;break}}if((l|0)==2242){uf(o,114208,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}if((t|0)!=1){uf(o,114208,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}g=c[s>>2]|0;p=y+2|0;c[13898]=p;C=1;D=p;while(1){if((D|0)>=(d|0)){l=2188;break}L2974:do{if((a[j+(D*40&-1)|0]&1)==0){l=2195}else{p=c[j+(D*40&-1)+36>>2]|0;E=j+(D*40&-1)+32|0;F=0;while(1){if((F|0)>=(p|0)){break}if((a[n+((c[E>>2]|0)+F|0)|0]|0)==(a[F+126728|0]|0)){F=F+1|0}else{l=2195;break L2974}}if((F|0)!=1){l=2195;break}G=C+1|0}}while(0);if((l|0)==2195){l=0;L2983:do{if((a[j+(D*40&-1)|0]&1)==0){H=0}else{x=c[j+(D*40&-1)+36>>2]|0;E=j+(D*40&-1)+32|0;p=0;while(1){if((p|0)>=(x|0)){break}if((a[n+((c[E>>2]|0)+p|0)|0]|0)==(a[p+125616|0]|0)){p=p+1|0}else{H=0;break L2983}}H=((p|0)==1)<<31>>31}}while(0);G=H+C|0}E=D+1|0;if((G|0)==0){I=E;break}else{C=G;D=E}}if((l|0)==2188){I=D+1|0}C=c[j+(D*40&-1)+32>>2]|0;c[13898]=I;z=C;A=g;B=I}else{z=0;A=0;B=y}}while(0);j=m!=0.0;n=j?f:A;a[37480]=j&1;r=(A|0)==0;a[37464]=r&1;c[13544]=(c[13544]|0)+1;if(j|r^1){r=(j?q:z)-n|0;j=ut(r)|0;do{if((j|0)==0){gk();C=ut(r)|0;if((C|0)!=0){J=C;break}uf(-1,225296,(v=i,i=i+8|0,c[v>>2]=110688,v)|0)}else{J=j}}while(0);uD(J|0,(c[10036]|0)+(n+1|0)|0,r);a[J+(r-1|0)|0]=0;dL(J);K=c[13898]|0}else{K=B}c[13898]=K-1;i=b;return}}while(0);if((c[13544]|0)>0){uf(e,107896,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}c[9368]=(c[9368]|0)+1;if(m!=0.0){K=d-1|0;B=c[1054]|0;J=(c[B+(K*40&-1)+36>>2]|0)+(c[B+(K*40&-1)+32>>2]|0)|0;K=e-1|0;c[13898]=K;c[B+(K*40&-1)+36>>2]=1;K=J+2|0;c[(c[1054]|0)+((c[13898]|0)*40&-1)+32>>2]=K;a[(c[10036]|0)+K|0]=59;a[(c[10036]|0)+(J+3|0)|0]=0;a[37480]=1;i=b;return}L3011:do{if(k){J=e;L3012:while(1){L3014:do{if((J|0)<(d|0)){K=c[1054]|0;B=J;while(1){L3018:do{if((a[K+(B*40&-1)|0]&1)==0){l=2221}else{z=c[K+(B*40&-1)+36>>2]|0;A=K+(B*40&-1)+32|0;y=c[10036]|0;I=0;while(1){if((I|0)>=(z|0)){break}if((a[y+((c[A>>2]|0)+I|0)|0]|0)==(a[I+103664|0]|0)){I=I+1|0}else{l=2221;break L3018}}A=B+1|0;c[13898]=A;if((I|0)==1){L=A;break L3014}else{M=A}}}while(0);if((l|0)==2221){l=0;p=B+1|0;c[13898]=p;M=p}if((M|0)<(d|0)){B=M}else{N=M;l=2216;break}}}else{N=J;l=2216}}while(0);if((l|0)==2216){l=0;g=N+1|0;c[13898]=g;L=g}L3030:do{if((d|0)>(L|0)){g=c[1054]|0;if((a[g+(L*40&-1)|0]&1)==0){break}D=c[g+(L*40&-1)+36>>2]|0;B=g+(L*40&-1)+32|0;g=c[10036]|0;K=0;while(1){if((K|0)>=(D|0)){break}if((a[g+((c[B>>2]|0)+K|0)|0]|0)==(a[K+200904|0]|0)){K=K+1|0}else{break L3030}}if((K|0)==4){break L3012}}}while(0);if((L|0)<(d|0)){J=L}else{break L3011}}a[37480]=0;c[13898]=L-1;i=b;return}}while(0);c[8272]=0;c[13898]=0;i=b;return}function d1(){return}function d2(){var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,w=0,x=0;b=i;d=c[13898]|0;e=d+1|0;f=c[8272]|0;L3044:do{if((f|0)>(e|0)){g=c[1054]|0;if((a[g+(e*40&-1)|0]&1)==0){break}h=c[g+(e*40&-1)+36>>2]|0;j=g+(e*40&-1)+32|0;k=c[10036]|0;l=0;while(1){if((l|0)>=(h|0)){break}if((a[k+((c[j>>2]|0)+l|0)|0]|0)==(a[l+126728|0]|0)){l=l+1|0}else{break L3044}}if((l|0)!=1){break}if((a[37464]&1)==0){uf(d,106968,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}a[37464]=0;c[13898]=e;h=c[j>>2]|0;m=d+2|0;c[13898]=m;n=1;o=m;while(1){if((o|0)>=(f|0)){p=2256;break}L3058:do{if((a[g+(o*40&-1)|0]&1)==0){p=2263}else{m=c[g+(o*40&-1)+36>>2]|0;q=g+(o*40&-1)+32|0;r=0;while(1){if((r|0)>=(m|0)){break}if((a[k+((c[q>>2]|0)+r|0)|0]|0)==(a[r+126728|0]|0)){r=r+1|0}else{p=2263;break L3058}}if((r|0)!=1){p=2263;break}s=n+1|0}}while(0);if((p|0)==2263){p=0;L3067:do{if((a[g+(o*40&-1)|0]&1)==0){t=0}else{q=c[g+(o*40&-1)+36>>2]|0;m=g+(o*40&-1)+32|0;u=0;while(1){if((u|0)>=(q|0)){break}if((a[k+((c[m>>2]|0)+u|0)|0]|0)==(a[u+125616|0]|0)){u=u+1|0}else{t=0;break L3067}}t=((u|0)==1)<<31>>31}}while(0);s=t+n|0}m=o+1|0;if((s|0)==0){w=m;break}else{n=s;o=m}}if((p|0)==2256){w=o+1|0}n=c[g+(o*40&-1)+32>>2]|0;c[13898]=w-1;c[13544]=(c[13544]|0)+1;if((a[37480]&1)!=0){i=b;return}k=n-h|0;n=ut(k)|0;do{if((n|0)==0){gk();j=ut(k)|0;if((j|0)!=0){x=j;break}uf(-1,225296,(v=i,i=i+8|0,c[v>>2]=110688,v)|0)}else{x=n}}while(0);uD(x|0,(c[10036]|0)+(h+1|0)|0,k);a[x+(k-1|0)|0]=0;dL(x);i=b;return}}while(0);x=c[9368]|0;if((x|0)<1){uf(d,106008,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}c[9368]=x-1;if((a[37480]&1)==0){x=c[1054]|0;w=c[x+(d*40&-1)+32>>2]|0;c[x+(d*40&-1)+36>>2]=1;a[(c[10036]|0)+w|0]=59;a[(c[10036]|0)+(w+1|0)|0]=32;a[(c[10036]|0)+(w+2|0)|0]=32;a[(c[10036]|0)+(w+3|0)|0]=32;a[37480]=1;i=b;return}else{c[8272]=0;c[13898]=0;i=b;return}}function d3(){var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,x=0;b=i;c[13898]=(c[13898]|0)+1;d=iw()|0;e=c[13898]|0;f=c[8272]|0;if((f|0)<=(e|0)){uf(e,104920,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}g=c[1054]|0;if((a[g+(e*40&-1)|0]&1)==0){uf(e,104920,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}h=c[g+(e*40&-1)+36>>2]|0;j=g+(e*40&-1)+32|0;k=c[10036]|0;l=0;while(1){if((l|0)>=(h|0)){break}if((a[k+((c[j>>2]|0)+l|0)|0]|0)==(a[l+126728|0]|0)){l=l+1|0}else{m=2323;break}}if((m|0)==2323){uf(e,104920,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}if((l|0)!=1){uf(e,104920,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}l=c[j>>2]|0;j=e+1|0;c[13898]=j;e=1;h=j;while(1){if((h|0)>=(f|0)){m=2295;break}L3114:do{if((a[g+(h*40&-1)|0]&1)==0){m=2302}else{j=c[g+(h*40&-1)+36>>2]|0;n=g+(h*40&-1)+32|0;o=0;while(1){if((o|0)>=(j|0)){break}if((a[k+((c[n>>2]|0)+o|0)|0]|0)==(a[o+126728|0]|0)){o=o+1|0}else{m=2302;break L3114}}if((o|0)!=1){m=2302;break}p=e+1|0}}while(0);if((m|0)==2302){m=0;L3123:do{if((a[g+(h*40&-1)|0]&1)==0){q=0}else{n=c[g+(h*40&-1)+36>>2]|0;j=g+(h*40&-1)+32|0;r=0;while(1){if((r|0)>=(n|0)){break}if((a[k+((c[j>>2]|0)+r|0)|0]|0)==(a[r+125616|0]|0)){r=r+1|0}else{q=0;break L3123}}q=((r|0)==1)<<31>>31}}while(0);p=q+e|0}j=h+1|0;if((p|0)==0){s=j;break}else{e=p;h=j}}if((m|0)==2295){s=h+1|0}m=c[g+(h*40&-1)+32>>2]|0;c[13544]=(c[13544]|0)+1;c[13898]=s-1;s=m-l|0;m=s+2|0;h=ut(m)|0;do{if((h|0)==0){gk();g=ut(m)|0;if((g|0)!=0){t=g;break}uf(-1,225296,(v=i,i=i+8|0,c[v>>2]=110688,v)|0)}else{t=h}}while(0);uD(t|0,(c[10036]|0)+(l+1|0)|0,s);a[t+(s-1|0)|0]=0;s=(d|0)==0;do{if(!s){if((a[d+38|0]&1)==0){break}l=t;w=59;a[l]=w&255;w=w>>8;a[l+1|0]=w&255}}while(0);l=(t|0)==0;do{if(l){u=0}else{u=bP(t|0)|0}dL(u);}while(ix(d)|0);uu(t);if(s){i=b;return}else{x=d}while(1){d=c[x>>2]|0;uu(c[x+12>>2]|0);uu(x);if((d|0)==0){break}else{x=d}}i=b;return}function d4(){var b=0,d=0,e=0,f=0,g=0,j=0,k=0.0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,w=0,x=0,y=0.0;b=i;i=i+48|0;d=b|0;e=b+24|0;f=(c[13898]|0)+1|0;c[13898]=f;g=is(e)|0;j=c[g>>2]|0;if((j|0)==1){k=+(c[g+8>>2]|0)}else if((j|0)==2){k=+h[g+8>>3]}else if((j|0)==3){k=+uz(c[g+8>>2]|0,0)}else{uf(-1,213288,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}g=e|0;if((c[g>>2]|0)==3){uu(c[e+8>>2]|0);c[g>>2]=1}g=c[13898]|0;e=c[8272]|0;if((e|0)<=(g|0)){uf(g,104360,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}j=c[1054]|0;if((a[j+(g*40&-1)|0]&1)==0){uf(g,104360,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}l=c[j+(g*40&-1)+36>>2]|0;m=j+(g*40&-1)+32|0;n=c[10036]|0;o=0;while(1){if((o|0)>=(l|0)){break}if((a[n+((c[m>>2]|0)+o|0)|0]|0)==(a[o+126728|0]|0)){o=o+1|0}else{p=2374;break}}if((p|0)==2374){uf(g,104360,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}if((o|0)!=1){uf(g,104360,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}o=c[m>>2]|0;m=g+1|0;c[13898]=m;g=1;l=m;while(1){if((l|0)>=(e|0)){p=2344;break}L3181:do{if((a[j+(l*40&-1)|0]&1)==0){p=2351}else{m=c[j+(l*40&-1)+36>>2]|0;q=j+(l*40&-1)+32|0;r=0;while(1){if((r|0)>=(m|0)){break}if((a[n+((c[q>>2]|0)+r|0)|0]|0)==(a[r+126728|0]|0)){r=r+1|0}else{p=2351;break L3181}}if((r|0)!=1){p=2351;break}s=g+1|0}}while(0);if((p|0)==2351){p=0;L3190:do{if((a[j+(l*40&-1)|0]&1)==0){t=0}else{q=c[j+(l*40&-1)+36>>2]|0;m=j+(l*40&-1)+32|0;u=0;while(1){if((u|0)>=(q|0)){break}if((a[n+((c[m>>2]|0)+u|0)|0]|0)==(a[u+125616|0]|0)){u=u+1|0}else{t=0;break L3190}}t=((u|0)==1)<<31>>31}}while(0);s=t+g|0}m=l+1|0;if((s|0)==0){w=m;break}else{g=s;l=m}}if((p|0)==2344){w=l+1|0}s=(c[j+(l*40&-1)+32>>2]|0)-o|0;l=ut(s)|0;do{if((l|0)==0){gk();j=ut(s)|0;if((j|0)!=0){x=j;break}uf(-1,225296,(v=i,i=i+8|0,c[v>>2]=110688,v)|0)}else{x=l}}while(0);uD(x|0,(c[10036]|0)+(o+1|0)|0,s);a[x+(s-1|0)|0]=0;c[13544]=(c[13544]|0)+1;if(k==0.0){uu(x);c[13898]=w;i=b;return}s=d|0;o=d+8|0;while(1){dL(bP(x|0)|0);c[13898]=f;l=is(d)|0;j=c[l>>2]|0;if((j|0)==1){y=+(c[l+8>>2]|0)}else if((j|0)==3){y=+uz(c[l+8>>2]|0,0)}else if((j|0)==2){y=+h[l+8>>3]}else{p=2367;break}if((c[s>>2]|0)==3){uu(c[o>>2]|0);c[s>>2]=1}if(y==0.0){p=2377;break}}if((p|0)==2377){uu(x);c[13898]=w;i=b;return}else if((p|0)==2367){uf(-1,213288,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}}function d5(){var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,o=0;b=i;i=i+32|0;d=b|0;e=b+24|0;f=(c[13898]|0)+1|0;c[13898]=f;L3222:do{if((f|0)<(c[8272]|0)){g=c[1054]|0;L3224:do{if((a[g+(f*40&-1)|0]&1)!=0){h=c[g+(f*40&-1)+36>>2]|0;j=g+(f*40&-1)+32|0;k=c[10036]|0;l=0;while(1){if((l|0)>=(h|0)){break}if((a[k+((c[j>>2]|0)+l|0)|0]|0)==(a[l+103664|0]|0)){l=l+1|0}else{break L3224}}if((l|0)==1){break L3222}}}while(0);a[14176]=1;is(d);a[14176]=0;if((c[d>>2]|0)!=3){c[13898]=f;break}g=c[d+8>>2]|0;c[e>>2]=g;if((g|0)==0){m=c[13898]|0;uf(m,149040,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}iQ(e);g=c[e>>2]|0;if((aY(g|0,202112)|0)==0){o=c[n>>2]|0;hw(o,g,0);i=b;return}else{o=hA(g,193632)|0;hw(o,g,0);i=b;return}}}while(0);c[e>>2]=0;m=f;uf(m,149040,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0)}function d6(){var b=0;b=c[13898]|0;c[13898]=b+1;c[7738]=b;a[30664]=0;hY(1);a[(e6(159824)|0)+8|0]=1;a[(e6(159208)|0)+8|0]=1;a[(e6(158720)|0)+8|0]=1;a[(e6(158096)|0)+8|0]=1;a[(e6(164136)|0)+8|0]=1;a[(e6(156232)|0)+8|0]=1;a[(e6(155120)|0)+8|0]=1;a[(e6(154768)|0)+8|0]=1;iS();return}function d7(){var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;b=i;i=i+24|0;d=b|0;if((c[7262]|0)==0){c[7262]=c[m>>2]}a[25280]=0;e=d|0;f=d+8|0;g=0;h=c[13898]|0;L3250:while(1){c[13898]=h+1;is(d);do{if((c[e>>2]|0)==3){j=c[f>>2]|0;k=c[7262]|0;aK(j|0,k|0);if((c[e>>2]|0)!=3){l=0;break}uu(c[f>>2]|0);c[e>>2]=1;l=0}else{if((g|0)!=0){k=c[7262]|0;aF(32,k|0)}j5(c[7262]|0,d,0);l=1}}while(0);k=c[13898]|0;if((k|0)>=(c[8272]|0)){break}j=c[1054]|0;n=(a[j+(k*40&-1)|0]&1)==0;if(n){break}o=c[j+(k*40&-1)+36>>2]|0;p=j+(k*40&-1)+32|0;q=c[10036]|0;r=0;while(1){if((r|0)>=(o|0)){s=2413;break}if((a[q+((c[p>>2]|0)+r|0)|0]|0)==(a[r+103664|0]|0)){r=r+1|0}else{s=2414;break}}if((s|0)==2413){s=0;if((r|0)==1|n){break}}else if((s|0)==2414){s=0;if(n){break}}p=c[j+(k*40&-1)+36>>2]|0;q=j+(k*40&-1)+32|0;o=c[10036]|0;t=0;while(1){if((t|0)>=(p|0)){break}if((a[o+((c[q>>2]|0)+t|0)|0]|0)==(a[t+148464|0]|0)){t=t+1|0}else{break L3250}}if((t|0)==1){g=l;h=k}else{break}}aF(10,c[7262]|0);aD(c[7262]|0);i=b;return}function d8(){c[13898]=(c[13898]|0)+1;dO();return}function d9(){var b=0,d=0,e=0,f=0,g=0,j=0,k=0,l=0,n=0,p=0,q=0,r=0,s=0.0,t=0,u=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0.0,O=0,P=0;b=i;i=i+48|0;d=b|0;e=b+24|0;f=c[13898]|0;g=f+1|0;c[13898]=g;c[8026]=0;j=c[8272]|0;L3276:do{if((j|0)>(g|0)){k=c[1054]|0;if((a[k+(g*40&-1)|0]&1)==0){l=2487;break}n=c[k+(g*40&-1)+36>>2]|0;p=k+(g*40&-1)+32|0;q=c[10036]|0;r=0;while(1){if((r|0)>=(n|0)){break}if((a[q+((c[p>>2]|0)+r|0)|0]|0)==(a[r+218536|0]|0)){r=r+1|0}else{l=2487;break L3276}}if((r|0)!=5){l=2487;break}p=f+2|0;c[13898]=p;if(!((c[8496]|0)!=0&(c[3524]|0)!=0)){uh(-1,96888,(v=i,i=i+1|0,i=i+7>>3<<3,c[v>>2]=0,v)|0);s=-1.0;break}L3287:do{if((p|0)<(j|0)){n=0;t=p;while(1){u=t;L3290:while(1){w=(a[k+(u*40&-1)|0]&1)==0;x=c[k+(u*40&-1)+36>>2]|0;y=k+(u*40&-1)+32|0;L3292:do{if(w){z=c[y>>2]|0}else{A=0;while(1){if((A|0)>=(x|0)){l=2434;break}if((a[q+((c[y>>2]|0)+A|0)|0]|0)==(a[A+103664|0]|0)){A=A+1|0}else{break}}if((l|0)==2434){l=0;if((A|0)==1){B=n;break L3287}}C=c[y>>2]|0;if((x|0)>0&(w^1)){D=0;E=0;F=C}else{z=C;break}while(1){if((a[D+101312|0]|0)==(a[q+(D+F|0)|0]|0)){G=F;H=E}else{if((D|0)!=3){z=C;break L3292}G=F-1|0;H=1}I=D+1|0;if((I|0)<(H+x|0)){D=I;E=H;F=G}else{break}}if((H|0)!=0){l=2442;break L3290}if((D|0)==2|(D|0)==8){l=2442;break L3290}else{z=C}}}while(0);J=(j|0)>(u|0);if(!J){B=n;break L3287}if(w){l=2451;break}else{K=0}while(1){if((K|0)>=(x|0)){break}if((a[q+(z+K|0)|0]|0)==(a[K+148464|0]|0)){K=K+1|0}else{l=2450;break L3290}}if((K|0)!=1){l=2450;break}x=u+1|0;c[13898]=x;if((x|0)<(j|0)){u=x}else{B=n;break L3287}}if((l|0)==2450){l=0;if(J){l=2451}else{B=n;break L3287}}else if((l|0)==2442){l=0;x=u+1|0;c[13898]=x;L=n|8;M=x}L3318:do{if((l|0)==2451){l=0;L3320:do{if((a[k+(u*40&-1)|0]&1)!=0){x=c[k+(u*40&-1)+36>>2]|0;w=k+(u*40&-1)+32|0;y=0;while(1){if((y|0)>=(x|0)){break}if((a[q+((c[w>>2]|0)+y|0)|0]|0)==(a[y+100784|0]|0)){y=y+1|0}else{break L3320}}if((y|0)!=3){break}w=u+1|0;c[13898]=w;L=n|63;M=w;break L3318}}while(0)