// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package rds provides a client for Amazon Relational Database Service.
package rds

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opAddSourceIdentifierToSubscription = "AddSourceIdentifierToSubscription"

// AddSourceIdentifierToSubscriptionRequest generates a request for the AddSourceIdentifierToSubscription operation.
func (c *RDS) AddSourceIdentifierToSubscriptionRequest(input *AddSourceIdentifierToSubscriptionInput) (req *request.Request, output *AddSourceIdentifierToSubscriptionOutput) {
	op := &request.Operation{
		Name:       opAddSourceIdentifierToSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddSourceIdentifierToSubscriptionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddSourceIdentifierToSubscriptionOutput{}
	req.Data = output
	return
}

// Adds a source identifier to an existing RDS event notification subscription.
func (c *RDS) AddSourceIdentifierToSubscription(input *AddSourceIdentifierToSubscriptionInput) (*AddSourceIdentifierToSubscriptionOutput, error) {
	req, out := c.AddSourceIdentifierToSubscriptionRequest(input)
	err := req.Send()
	return out, err
}

const opAddTagsToResource = "AddTagsToResource"

// AddTagsToResourceRequest generates a request for the AddTagsToResource operation.
func (c *RDS) AddTagsToResourceRequest(input *AddTagsToResourceInput) (req *request.Request, output *AddTagsToResourceOutput) {
	op := &request.Operation{
		Name:       opAddTagsToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToResourceInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &AddTagsToResourceOutput{}
	req.Data = output
	return
}

// Adds metadata tags to an Amazon RDS resource. These tags can also be used
// with cost allocation reporting to track cost associated with Amazon RDS resources,
// or used in a Condition statement in an IAM policy for Amazon RDS.
//
// For an overview on tagging Amazon RDS resources, see Tagging Amazon RDS
// Resources (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html).
func (c *RDS) AddTagsToResource(input *AddTagsToResourceInput) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	err := req.Send()
	return out, err
}

const opApplyPendingMaintenanceAction = "ApplyPendingMaintenanceAction"

// ApplyPendingMaintenanceActionRequest generates a request for the ApplyPendingMaintenanceAction operation.
func (c *RDS) ApplyPendingMaintenanceActionRequest(input *ApplyPendingMaintenanceActionInput) (req *request.Request, output *ApplyPendingMaintenanceActionOutput) {
	op := &request.Operation{
		Name:       opApplyPendingMaintenanceAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ApplyPendingMaintenanceActionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ApplyPendingMaintenanceActionOutput{}
	req.Data = output
	return
}

// Applies a pending maintenance action to a resource (for example, to a DB
// instance).
func (c *RDS) ApplyPendingMaintenanceAction(input *ApplyPendingMaintenanceActionInput) (*ApplyPendingMaintenanceActionOutput, error) {
	req, out := c.ApplyPendingMaintenanceActionRequest(input)
	err := req.Send()
	return out, err
}

const opAuthorizeDBSecurityGroupIngress = "AuthorizeDBSecurityGroupIngress"

// AuthorizeDBSecurityGroupIngressRequest generates a request for the AuthorizeDBSecurityGroupIngress operation.
func (c *RDS) AuthorizeDBSecurityGroupIngressRequest(input *AuthorizeDBSecurityGroupIngressInput) (req *request.Request, output *AuthorizeDBSecurityGroupIngressOutput) {
	op := &request.Operation{
		Name:       opAuthorizeDBSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeDBSecurityGroupIngressInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AuthorizeDBSecurityGroupIngressOutput{}
	req.Data = output
	return
}

// Enables ingress to a DBSecurityGroup using one of two forms of authorization.
// First, EC2 or VPC security groups can be added to the DBSecurityGroup if
// the application using the database is running on EC2 or VPC instances. Second,
// IP ranges are available if the application accessing your database is running
// on the Internet. Required parameters for this API are one of CIDR range,
// EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either EC2SecurityGroupName
// or EC2SecurityGroupId for non-VPC).
//
//  You cannot authorize ingress from an EC2 security group in one region to
// an Amazon RDS DB instance in another. You cannot authorize ingress from a
// VPC security group in one VPC to an Amazon RDS DB instance in another.  For
// an overview of CIDR ranges, go to the Wikipedia Tutorial (http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
func (c *RDS) AuthorizeDBSecurityGroupIngress(input *AuthorizeDBSecurityGroupIngressInput) (*AuthorizeDBSecurityGroupIngressOutput, error) {
	req, out := c.AuthorizeDBSecurityGroupIngressRequest(input)
	err := req.Send()
	return out, err
}

const opCopyDBClusterSnapshot = "CopyDBClusterSnapshot"

// CopyDBClusterSnapshotRequest generates a request for the CopyDBClusterSnapshot operation.
func (c *RDS) CopyDBClusterSnapshotRequest(input *CopyDBClusterSnapshotInput) (req *request.Request, output *CopyDBClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opCopyDBClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyDBClusterSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CopyDBClusterSnapshotOutput{}
	req.Data = output
	return
}

// Creates a snapshot of a DB cluster. For more information on Amazon Aurora,
// see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
func (c *RDS) CopyDBClusterSnapshot(input *CopyDBClusterSnapshotInput) (*CopyDBClusterSnapshotOutput, error) {
	req, out := c.CopyDBClusterSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opCopyDBParameterGroup = "CopyDBParameterGroup"

// CopyDBParameterGroupRequest generates a request for the CopyDBParameterGroup operation.
func (c *RDS) CopyDBParameterGroupRequest(input *CopyDBParameterGroupInput) (req *request.Request, output *CopyDBParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCopyDBParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyDBParameterGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CopyDBParameterGroupOutput{}
	req.Data = output
	return
}

// Copies the specified DB parameter group.
func (c *RDS) CopyDBParameterGroup(input *CopyDBParameterGroupInput) (*CopyDBParameterGroupOutput, error) {
	req, out := c.CopyDBParameterGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCopyDBSnapshot = "CopyDBSnapshot"

// CopyDBSnapshotRequest generates a request for the CopyDBSnapshot operation.
func (c *RDS) CopyDBSnapshotRequest(input *CopyDBSnapshotInput) (req *request.Request, output *CopyDBSnapshotOutput) {
	op := &request.Operation{
		Name:       opCopyDBSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyDBSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CopyDBSnapshotOutput{}
	req.Data = output
	return
}

// Copies the specified DBSnapshot. The source DB snapshot must be in the "available"
// state.
//
// If you are copying from a shared manual DB snapshot, the SourceDBSnapshotIdentifier
// must be the ARN of the shared DB snapshot.
func (c *RDS) CopyDBSnapshot(input *CopyDBSnapshotInput) (*CopyDBSnapshotOutput, error) {
	req, out := c.CopyDBSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opCopyOptionGroup = "CopyOptionGroup"

// CopyOptionGroupRequest generates a request for the CopyOptionGroup operation.
func (c *RDS) CopyOptionGroupRequest(input *CopyOptionGroupInput) (req *request.Request, output *CopyOptionGroupOutput) {
	op := &request.Operation{
		Name:       opCopyOptionGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyOptionGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CopyOptionGroupOutput{}
	req.Data = output
	return
}

// Copies the specified option group.
func (c *RDS) CopyOptionGroup(input *CopyOptionGroupInput) (*CopyOptionGroupOutput, error) {
	req, out := c.CopyOptionGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDBCluster = "CreateDBCluster"

// CreateDBClusterRequest generates a request for the CreateDBCluster operation.
func (c *RDS) CreateDBClusterRequest(input *CreateDBClusterInput) (req *request.Request, output *CreateDBClusterOutput) {
	op := &request.Operation{
		Name:       opCreateDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBClusterInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDBClusterOutput{}
	req.Data = output
	return
}

// Creates a new Amazon Aurora DB cluster. For more information on Amazon Aurora,
// see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
func (c *RDS) CreateDBCluster(input *CreateDBClusterInput) (*CreateDBClusterOutput, error) {
	req, out := c.CreateDBClusterRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDBClusterParameterGroup = "CreateDBClusterParameterGroup"

// CreateDBClusterParameterGroupRequest generates a request for the CreateDBClusterParameterGroup operation.
func (c *RDS) CreateDBClusterParameterGroupRequest(input *CreateDBClusterParameterGroupInput) (req *request.Request, output *CreateDBClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBClusterParameterGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDBClusterParameterGroupOutput{}
	req.Data = output
	return
}

// Creates a new DB cluster parameter group.
//
//  Parameters in a DB cluster parameter group apply to all of the instances
// in a DB cluster.
//
//  A DB cluster parameter group is initially created with the default parameters
// for the database engine used by instances in the DB cluster. To provide custom
// values for any of the parameters, you must modify the group after creating
// it using ModifyDBClusterParameterGroup. Once you've created a DB cluster
// parameter group, you need to associate it with your DB cluster using ModifyDBCluster.
// When you associate a new DB cluster parameter group with a running DB cluster,
// you need to reboot the DB instances in the DB cluster without failover for
// the new DB cluster parameter group and associated settings to take effect.
//
//  After you create a DB cluster parameter group, you should wait at least
// 5 minutes before creating your first DB cluster that uses that DB cluster
// parameter group as the default parameter group. This allows Amazon RDS to
// fully complete the create action before the DB cluster parameter group is
// used as the default for a new DB cluster. This is especially important for
// parameters that are critical when creating the default database for a DB
// cluster, such as the character set for the default database defined by the
// character_set_database parameter. You can use the Parameter Groups option
// of the Amazon RDS console (https://console.aws.amazon.com/rds/) or the DescribeDBClusterParameters
// command to verify that your DB cluster parameter group has been created or
// modified.
//
//  For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
func (c *RDS) CreateDBClusterParameterGroup(input *CreateDBClusterParameterGroupInput) (*CreateDBClusterParameterGroupOutput, error) {
	req, out := c.CreateDBClusterParameterGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDBClusterSnapshot = "CreateDBClusterSnapshot"

// CreateDBClusterSnapshotRequest generates a request for the CreateDBClusterSnapshot operation.
func (c *RDS) CreateDBClusterSnapshotRequest(input *CreateDBClusterSnapshotInput) (req *request.Request, output *CreateDBClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateDBClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBClusterSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDBClusterSnapshotOutput{}
	req.Data = output
	return
}

// Creates a snapshot of a DB cluster. For more information on Amazon Aurora,
// see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
func (c *RDS) CreateDBClusterSnapshot(input *CreateDBClusterSnapshotInput) (*CreateDBClusterSnapshotOutput, error) {
	req, out := c.CreateDBClusterSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDBInstance = "CreateDBInstance"

// CreateDBInstanceRequest generates a request for the CreateDBInstance operation.
func (c *RDS) CreateDBInstanceRequest(input *CreateDBInstanceInput) (req *request.Request, output *CreateDBInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDBInstanceOutput{}
	req.Data = output
	return
}

// Creates a new DB instance.
func (c *RDS) CreateDBInstance(input *CreateDBInstanceInput) (*CreateDBInstanceOutput, error) {
	req, out := c.CreateDBInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDBInstanceReadReplica = "CreateDBInstanceReadReplica"

// CreateDBInstanceReadReplicaRequest generates a request for the CreateDBInstanceReadReplica operation.
func (c *RDS) CreateDBInstanceReadReplicaRequest(input *CreateDBInstanceReadReplicaInput) (req *request.Request, output *CreateDBInstanceReadReplicaOutput) {
	op := &request.Operation{
		Name:       opCreateDBInstanceReadReplica,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBInstanceReadReplicaInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDBInstanceReadReplicaOutput{}
	req.Data = output
	return
}

// Creates a DB instance for a DB instance running MySQL, MariaDB, or PostgreSQL
// that acts as a Read Replica of a source DB instance.
//
//  All Read Replica DB instances are created as Single-AZ deployments with
// backups disabled. All other DB instance attributes (including DB security
// groups and DB parameter groups) are inherited from the source DB instance,
// except as specified below.
//
//   The source DB instance must have backup retention enabled.
func (c *RDS) CreateDBInstanceReadReplica(input *CreateDBInstanceReadReplicaInput) (*CreateDBInstanceReadReplicaOutput, error) {
	req, out := c.CreateDBInstanceReadReplicaRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDBParameterGroup = "CreateDBParameterGroup"

// CreateDBParameterGroupRequest generates a request for the CreateDBParameterGroup operation.
func (c *RDS) CreateDBParameterGroupRequest(input *CreateDBParameterGroupInput) (req *request.Request, output *CreateDBParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDBParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBParameterGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDBParameterGroupOutput{}
	req.Data = output
	return
}

// Creates a new DB parameter group.
//
//  A DB parameter group is initially created with the default parameters for
// the database engine used by the DB instance. To provide custom values for
// any of the parameters, you must modify the group after creating it using
// ModifyDBParameterGroup. Once you've created a DB parameter group, you need
// to associate it with your DB instance using ModifyDBInstance. When you associate
// a new DB parameter group with a running DB instance, you need to reboot the
// DB instance without failover for the new DB parameter group and associated
// settings to take effect.
//
//  After you create a DB parameter group, you should wait at least 5 minutes
// before creating your first DB instance that uses that DB parameter group
// as the default parameter group. This allows Amazon RDS to fully complete
// the create action before the parameter group is used as the default for a
// new DB instance. This is especially important for parameters that are critical
// when creating the default database for a DB instance, such as the character
// set for the default database defined by the character_set_database parameter.
// You can use the Parameter Groups option of the Amazon RDS console (https://console.aws.amazon.com/rds/)
// or the DescribeDBParameters command to verify that your DB parameter group
// has been created or modified.
func (c *RDS) CreateDBParameterGroup(input *CreateDBParameterGroupInput) (*CreateDBParameterGroupOutput, error) {
	req, out := c.CreateDBParameterGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDBSecurityGroup = "CreateDBSecurityGroup"

// CreateDBSecurityGroupRequest generates a request for the CreateDBSecurityGroup operation.
func (c *RDS) CreateDBSecurityGroupRequest(input *CreateDBSecurityGroupInput) (req *request.Request, output *CreateDBSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDBSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBSecurityGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDBSecurityGroupOutput{}
	req.Data = output
	return
}

// Creates a new DB security group. DB security groups control access to a DB
// instance.
func (c *RDS) CreateDBSecurityGroup(input *CreateDBSecurityGroupInput) (*CreateDBSecurityGroupOutput, error) {
	req, out := c.CreateDBSecurityGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDBSnapshot = "CreateDBSnapshot"

// CreateDBSnapshotRequest generates a request for the CreateDBSnapshot operation.
func (c *RDS) CreateDBSnapshotRequest(input *CreateDBSnapshotInput) (req *request.Request, output *CreateDBSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateDBSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDBSnapshotOutput{}
	req.Data = output
	return
}

// Creates a DBSnapshot. The source DBInstance must be in "available" state.
func (c *RDS) CreateDBSnapshot(input *CreateDBSnapshotInput) (*CreateDBSnapshotOutput, error) {
	req, out := c.CreateDBSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDBSubnetGroup = "CreateDBSubnetGroup"

// CreateDBSubnetGroupRequest generates a request for the CreateDBSubnetGroup operation.
func (c *RDS) CreateDBSubnetGroupRequest(input *CreateDBSubnetGroupInput) (req *request.Request, output *CreateDBSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDBSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBSubnetGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDBSubnetGroupOutput{}
	req.Data = output
	return
}

// Creates a new DB subnet group. DB subnet groups must contain at least one
// subnet in at least two AZs in the region.
func (c *RDS) CreateDBSubnetGroup(input *CreateDBSubnetGroupInput) (*CreateDBSubnetGroupOutput, error) {
	req, out := c.CreateDBSubnetGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateEventSubscription = "CreateEventSubscription"

// CreateEventSubscriptionRequest generates a request for the CreateEventSubscription operation.
func (c *RDS) CreateEventSubscriptionRequest(input *CreateEventSubscriptionInput) (req *request.Request, output *CreateEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEventSubscriptionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateEventSubscriptionOutput{}
	req.Data = output
	return
}

// Creates an RDS event notification subscription. This action requires a topic
// ARN (Amazon Resource Name) created by either the RDS console, the SNS console,
// or the SNS API. To obtain an ARN with SNS, you must create a topic in Amazon
// SNS and subscribe to the topic. The ARN is displayed in the SNS console.
//
// You can specify the type of source (SourceType) you want to be notified
// of, provide a list of RDS sources (SourceIds) that triggers the events, and
// provide a list of event categories (EventCategories) for events you want
// to be notified of. For example, you can specify SourceType = db-instance,
// SourceIds = mydbinstance1, mydbinstance2 and EventCategories = Availability,
// Backup.
//
// If you specify both the SourceType and SourceIds, such as SourceType = db-instance
// and SourceIdentifier = myDBInstance1, you will be notified of all the db-instance
// events for the specified source. If you specify a SourceType but do not specify
// a SourceIdentifier, you will receive notice of the events for that source
// type for all your RDS sources. If you do not specify either the SourceType
// nor the SourceIdentifier, you will be notified of events generated from all
// RDS sources belonging to your customer account.
func (c *RDS) CreateEventSubscription(input *CreateEventSubscriptionInput) (*CreateEventSubscriptionOutput, error) {
	req, out := c.CreateEventSubscriptionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateOptionGroup = "CreateOptionGroup"

// CreateOptionGroupRequest generates a request for the CreateOptionGroup operation.
func (c *RDS) CreateOptionGroupRequest(input *CreateOptionGroupInput) (req *request.Request, output *CreateOptionGroupOutput) {
	op := &request.Operation{
		Name:       opCreateOptionGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateOptionGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateOptionGroupOutput{}
	req.Data = output
	return
}

// Creates a new option group. You can create up to 20 option groups.
func (c *RDS) CreateOptionGroup(input *CreateOptionGroupInput) (*CreateOptionGroupOutput, error) {
	req, out := c.CreateOptionGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDBCluster = "DeleteDBCluster"

// DeleteDBClusterRequest generates a request for the DeleteDBCluster operation.
func (c *RDS) DeleteDBClusterRequest(input *DeleteDBClusterInput) (req *request.Request, output *DeleteDBClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBClusterInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteDBClusterOutput{}
	req.Data = output
	return
}

// The DeleteDBCluster action deletes a previously provisioned DB cluster. A
// successful response from the web service indicates the request was received
// correctly. When you delete a DB cluster, all automated backups for that DB
// cluster are deleted and cannot be recovered. Manual DB cluster snapshots
// of the DB cluster to be deleted are not deleted.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
func (c *RDS) DeleteDBCluster(input *DeleteDBClusterInput) (*DeleteDBClusterOutput, error) {
	req, out := c.DeleteDBClusterRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDBClusterParameterGroup = "DeleteDBClusterParameterGroup"

// DeleteDBClusterParameterGroupRequest generates a request for the DeleteDBClusterParameterGroup operation.
func (c *RDS) DeleteDBClusterParameterGroupRequest(input *DeleteDBClusterParameterGroupInput) (req *request.Request, output *DeleteDBClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBClusterParameterGroupInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteDBClusterParameterGroupOutput{}
	req.Data = output
	return
}

// Deletes a specified DB cluster parameter group. The DB cluster parameter
// group to be deleted cannot be associated with any DB clusters.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
func (c *RDS) DeleteDBClusterParameterGroup(input *DeleteDBClusterParameterGroupInput) (*DeleteDBClusterParameterGroupOutput, error) {
	req, out := c.DeleteDBClusterParameterGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDBClusterSnapshot = "DeleteDBClusterSnapshot"

// DeleteDBClusterSnapshotRequest generates a request for the DeleteDBClusterSnapshot operation.
func (c *RDS) DeleteDBClusterSnapshotRequest(input *DeleteDBClusterSnapshotInput) (req *request.Request, output *DeleteDBClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteDBClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBClusterSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteDBClusterSnapshotOutput{}
	req.Data = output
	return
}

// Deletes a DB cluster snapshot. If the snapshot is being copied, the copy
// operation is terminated.
//
// The DB cluster snapshot must be in the available state to be deleted. For
// more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
func (c *RDS) DeleteDBClusterSnapshot(input *DeleteDBClusterSnapshotInput) (*DeleteDBClusterSnapshotOutput, error) {
	req, out := c.DeleteDBClusterSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDBInstance = "DeleteDBInstance"

// DeleteDBInstanceRequest generates a request for the DeleteDBInstance operation.
func (c *RDS) DeleteDBInstanceRequest(input *DeleteDBInstanceInput) (req *request.Request, output *DeleteDBInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteDBInstanceOutput{}
	req.Data = output
	return
}

// The DeleteDBInstance action deletes a previously provisioned DB instance.
// A successful response from the web service indicates the request was received
// correctly. When you delete a DB instance, all automated backups for that
// instance are deleted and cannot be recovered. Manual DB snapshots of the
// DB instance to be deleted are not deleted.
//
//  If a final DB snapshot is requested the status of the RDS instance will
// be "deleting" until the DB snapshot is created. The API action DescribeDBInstance
// is used to monitor the status of this operation. The action cannot be canceled
// or reverted once submitted.
//
// Note that when a DB instance is in a failure state and has a status of 'failed',
// 'incompatible-restore', or 'incompatible-network', it can only be deleted
// when the SkipFinalSnapshot parameter is set to "true".
func (c *RDS) DeleteDBInstance(input *DeleteDBInstanceInput) (*DeleteDBInstanceOutput, error) {
	req, out := c.DeleteDBInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDBParameterGroup = "DeleteDBParameterGroup"

// DeleteDBParameterGroupRequest generates a request for the DeleteDBParameterGroup operation.
func (c *RDS) DeleteDBParameterGroupRequest(input *DeleteDBParameterGroupInput) (req *request.Request, output *DeleteDBParameterGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDBParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBParameterGroupInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteDBParameterGroupOutput{}
	req.Data = output
	return
}

// Deletes a specified DBParameterGroup. The DBParameterGroup to be deleted
// cannot be associated with any DB instances.
func (c *RDS) DeleteDBParameterGroup(input *DeleteDBParameterGroupInput) (*DeleteDBParameterGroupOutput, error) {
	req, out := c.DeleteDBParameterGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDBSecurityGroup = "DeleteDBSecurityGroup"

// DeleteDBSecurityGroupRequest generates a request for the DeleteDBSecurityGroup operation.
func (c *RDS) DeleteDBSecurityGroupRequest(input *DeleteDBSecurityGroupInput) (req *request.Request, output *DeleteDBSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDBSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBSecurityGroupInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteDBSecurityGroupOutput{}
	req.Data = output
	return
}

// Deletes a DB security group.
//
// The specified DB security group must not be associated with any DB instances.
func (c *RDS) DeleteDBSecurityGroup(input *DeleteDBSecurityGroupInput) (*DeleteDBSecurityGroupOutput, error) {
	req, out := c.DeleteDBSecurityGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDBSnapshot = "DeleteDBSnapshot"

// DeleteDBSnapshotRequest generates a request for the DeleteDBSnapshot operation.
func (c *RDS) DeleteDBSnapshotRequest(input *DeleteDBSnapshotInput) (req *request.Request, output *DeleteDBSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteDBSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteDBSnapshotOutput{}
	req.Data = output
	return
}

// Deletes a DBSnapshot. If the snapshot is being copied, the copy operation
// is terminated.
//
// The DBSnapshot must be in the available state to be deleted.
func (c *RDS) DeleteDBSnapshot(input *DeleteDBSnapshotInput) (*DeleteDBSnapshotOutput, error) {
	req, out := c.DeleteDBSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDBSubnetGroup = "DeleteDBSubnetGroup"

// DeleteDBSubnetGroupRequest generates a request for the DeleteDBSubnetGroup operation.
func (c *RDS) DeleteDBSubnetGroupRequest(input *DeleteDBSubnetGroupInput) (req *request.Request, output *DeleteDBSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDBSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBSubnetGroupInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteDBSubnetGroupOutput{}
	req.Data = output
	return
}

// Deletes a DB subnet group.
//
// The specified database subnet group must not be associated with any DB instances.
func (c *RDS) DeleteDBSubnetGroup(input *DeleteDBSubnetGroupInput) (*DeleteDBSubnetGroupOutput, error) {
	req, out := c.DeleteDBSubnetGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteEventSubscription = "DeleteEventSubscription"

// DeleteEventSubscriptionRequest generates a request for the DeleteEventSubscription operation.
func (c *RDS) DeleteEventSubscriptionRequest(input *DeleteEventSubscriptionInput) (req *request.Request, output *DeleteEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEventSubscriptionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteEventSubscriptionOutput{}
	req.Data = output
	return
}

// Deletes an RDS event notification subscription.
func (c *RDS) DeleteEventSubscription(input *DeleteEventSubscriptionInput) (*DeleteEventSubscriptionOutput, error) {
	req, out := c.DeleteEventSubscriptionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteOptionGroup = "DeleteOptionGroup"

// DeleteOptionGroupRequest generates a request for the DeleteOptionGroup operation.
func (c *RDS) DeleteOptionGroupRequest(input *DeleteOptionGroupInput) (req *request.Request, output *DeleteOptionGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteOptionGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteOptionGroupInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteOptionGroupOutput{}
	req.Data = output
	return
}

// Deletes an existing option group.
func (c *RDS) DeleteOptionGroup(input *DeleteOptionGroupInput) (*DeleteOptionGroupOutput, error) {
	req, out := c.DeleteOptionGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAccountAttributes = "DescribeAccountAttributes"

// DescribeAccountAttributesRequest generates a request for the DescribeAccountAttributes operation.
func (c *RDS) DescribeAccountAttributesRequest(input *DescribeAccountAttributesInput) (req *request.Request, output *DescribeAccountAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAccountAttributesOutput{}
	req.Data = output
	return
}

// Lists all of the attributes for a customer account. The attributes include
// Amazon RDS quotas for the account, such as the number of DB instances allowed.
// The description for a quota includes the quota name, current usage toward
// that quota, and the quota's maximum value.
//
// This command does not take any parameters.
func (c *RDS) DescribeAccountAttributes(input *DescribeAccountAttributesInput) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeCertificates = "DescribeCertificates"

// DescribeCertificatesRequest generates a request for the DescribeCertificates operation.
func (c *RDS) DescribeCertificatesRequest(input *DescribeCertificatesInput) (req *request.Request, output *DescribeCertificatesOutput) {
	op := &request.Operation{
		Name:       opDescribeCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCertificatesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeCertificatesOutput{}
	req.Data = output
	return
}

// Lists the set of CA certificates provided by Amazon RDS for this AWS account.
func (c *RDS) DescribeCertificates(input *DescribeCertificatesInput) (*DescribeCertificatesOutput, error) {
	req, out := c.DescribeCertificatesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeDBClusterParameterGroups = "DescribeDBClusterParameterGroups"

// DescribeDBClusterParameterGroupsRequest generates a request for the DescribeDBClusterParameterGroups operation.
func (c *RDS) DescribeDBClusterParameterGroupsRequest(input *DescribeDBClusterParameterGroupsInput) (req *request.Request, output *DescribeDBClusterParameterGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusterParameterGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBClusterParameterGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDBClusterParameterGroupsOutput{}
	req.Data = output
	return
}

// Returns a list of DBClusterParameterGroup descriptions. If a DBClusterParameterGroupName
// parameter is specified, the list will contain only the description of the
// specified DB cluster parameter group.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
func (c *RDS) DescribeDBClusterParameterGroups(input *DescribeDBClusterParameterGroupsInput) (*DescribeDBClusterParameterGroupsOutput, error) {
	req, out := c.DescribeDBClusterParameterGroupsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeDBClusterParameters = "DescribeDBClusterParameters"

// DescribeDBClusterParametersRequest generates a request for the DescribeDBClusterParameters operation.
func (c *RDS) DescribeDBClusterParametersRequest(input *DescribeDBClusterParametersInput) (req *request.Request, output *DescribeDBClusterParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusterParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBClusterParametersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDBClusterParametersOutput{}
	req.Data = output
	return
}

// Returns the detailed parameter list for a particular DB cluster parameter
// group.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
func (c *RDS) DescribeDBClusterParameters(input *DescribeDBClusterParametersInput) (*DescribeDBClusterParametersOutput, error) {
	req, out := c.DescribeDBClusterParametersRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeDBClusterSnapshots = "DescribeDBClusterSnapshots"

// DescribeDBClusterSnapshotsRequest generates a request for the DescribeDBClusterSnapshots operation.
func (c *RDS) DescribeDBClusterSnapshotsRequest(input *DescribeDBClusterSnapshotsInput) (req *request.Request, output *DescribeDBClusterSnapshotsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusterSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBClusterSnapshotsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDBClusterSnapshotsOutput{}
	req.Data = output
	return
}

// Returns information about DB cluster snapshots. This API supports pagination.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
func (c *RDS) DescribeDBClusterSnapshots(input *DescribeDBClusterSnapshotsInput) (*DescribeDBClusterSnapshotsOutput, error) {
	req, out := c.DescribeDBClusterSnapshotsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeDBClusters = "DescribeDBClusters"

// DescribeDBClustersRequest generates a request for the DescribeDBClusters operation.
func (c *RDS) DescribeDBClustersRequest(input *DescribeDBClustersInput) (req *request.Request, output *DescribeDBClustersOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBClustersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDBClustersOutput{}
	req.Data = output
	return
}

// Returns information about provisioned Aurora DB clusters. This API supports
// pagination.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
func (c *RDS) DescribeDBClusters(input *DescribeDBClustersInput) (*DescribeDBClustersOutput, error) {
	req, out := c.DescribeDBClustersRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeDBEngineVersions = "DescribeDBEngineVersions"

// DescribeDBEngineVersionsRequest generates a request for the DescribeDBEngineVersions operation.
func (c *RDS) DescribeDBEngineVersionsRequest(input *DescribeDBEngineVersionsInput) (req *request.Request, output *DescribeDBEngineVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBEngineVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBEngineVersionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDBEngineVersionsOutput{}
	req.Data = output
	return
}

// Returns a list of the available DB engines.
func (c *RDS) DescribeDBEngineVersions(input *DescribeDBEngineVersionsInput) (*DescribeDBEngineVersionsOutput, error) {
	req, out := c.DescribeDBEngineVersionsRequest(input)
	err := req.Send()
	return out, err
}

func (c *RDS) DescribeDBEngineVersionsPages(input *DescribeDBEngineVersionsInput, fn func(p *DescribeDBEngineVersionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeDBEngineVersionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeDBEngineVersionsOutput), lastPage)
	})
}

const opDescribeDBInstances = "DescribeDBInstances"

// DescribeDBInstancesRequest generates a request for the DescribeDBInstances operation.
func (c *RDS) DescribeDBInstancesRequest(input *DescribeDBInstancesInput) (req *request.Request, output *DescribeDBInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeDBInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDBInstancesOutput{}
	req.Data = output
	return
}

// Returns information about provisioned RDS instances. This API supports pagination.
func (c *RDS) DescribeDBInstances(input *DescribeDBInstancesInput) (*DescribeDBInstancesOutput, error) {
	req, out := c.DescribeDBInstancesRequest(input)
	err := req.Send()
	return out, err
}

func (c *RDS) DescribeDBInstancesPages(input *DescribeDBInstancesInput, fn func(p *DescribeDBInstancesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeDBInstancesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeDBInstancesOutput), lastPage)
	})
}

const opDescribeDBLogFiles = "DescribeDBLogFiles"

// DescribeDBLogFilesRequest generates a request for the DescribeDBLogFiles operation.
func (c *RDS) DescribeDBLogFilesRequest(input *DescribeDBLogFilesInput) (req *request.Request, output *DescribeDBLogFilesOutput) {
	op := &request.Operation{
		Name:       opDescribeDBLogFiles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBLogFilesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDBLogFilesOutput{}
	req.Data = output
	return
}

// Returns a list of DB log files for the DB instance.
func (c *RDS) DescribeDBLogFiles(input *DescribeDBLogFilesInput) (*DescribeDBLogFilesOutput, error) {
	req, out := c.DescribeDBLogFilesRequest(input)
	err := req.Send()
	return out, err
}

func (c *RDS) DescribeDBLogFilesPages(input *DescribeDBLogFilesInput, fn func(p *DescribeDBLogFilesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeDBLogFilesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeDBLogFilesOutput), lastPage)
	})
}

const opDescribeDBParameterGroups = "DescribeDBParameterGroups"

// DescribeDBParameterGroupsRequest generates a request for the DescribeDBParameterGroups operation.
func (c *RDS) DescribeDBParameterGroupsRequest(input *DescribeDBParameterGroupsInput) (req *request.Request, output *DescribeDBParameterGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBParameterGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBParameterGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDBParameterGroupsOutput{}
	req.Data = output
	return
}

// Returns a list of DBParameterGroup descriptions. If a DBParameterGroupName
// is specified, the list will contain only the description of the specified
// DB parameter group.
func (c *RDS) DescribeDBParameterGroups(input *DescribeDBParameterGroupsInput) (*DescribeDBParameterGroupsOutput, error) {
	req, out := c.DescribeDBParameterGroupsRequest(input)
	err := req.Send()
	return out, err
}

func (c *RDS) DescribeDBParameterGroupsPages(input *DescribeDBParameterGroupsInput, fn func(p *DescribeDBParameterGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeDBParameterGroupsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeDBParameterGroupsOutput), lastPage)
	})
}

const opDescribeDBParameters = "DescribeDBParameters"

// DescribeDBParametersRequest generates a request for the DescribeDBParameters operation.
func (c *RDS) DescribeDBParametersRequest(input *DescribeDBParametersInput) (req *request.Request, output *DescribeDBParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeDBParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBParametersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDBParametersOutput{}
	req.Data = output
	return
}

// Returns the detailed parameter list for a particular DB parameter group.
func (c *RDS) DescribeDBParameters(input *DescribeDBParametersInput) (*DescribeDBParametersOutput, error) {
	req, out := c.DescribeDBParametersRequest(input)
	err := req.Send()
	return out, err
}

func (c *RDS) DescribeDBParametersPages(input *DescribeDBParametersInput, fn func(p *DescribeDBParametersOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeDBParametersRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeDBParametersOutput), lastPage)
	})
}

const opDescribeDBSecurityGroups = "DescribeDBSecurityGroups"

// DescribeDBSecurityGroupsRequest generates a request for the DescribeDBSecurityGroups operation.
func (c *RDS) DescribeDBSecurityGroupsRequest(input *DescribeDBSecurityGroupsInput) (req *request.Request, output *DescribeDBSecurityGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBSecurityGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBSecurityGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDBSecurityGroupsOutput{}
	req.Data = output
	return
}

// Returns a list of DBSecurityGroup descriptions. If a DBSecurityGroupName
// is specified, the list will contain only the descriptions of the specified
// DB security group.
func (c *RDS) DescribeDBSecurityGroups(input *DescribeDBSecurityGroupsInput) (*DescribeDBSecurityGroupsOutput, error) {
	req, out := c.DescribeDBSecurityGroupsRequest(input)
	err := req.Send()
	return out, err
}

func (c *RDS) DescribeDBSecurityGroupsPages(input *DescribeDBSecurityGroupsInput, fn func(p *DescribeDBSecurityGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeDBSecurityGroupsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeDBSecurityGroupsOutput), lastPage)
	})
}

const opDescribeDBSnapshotAttributes = "DescribeDBSnapshotAttributes"

// DescribeDBSnapshotAttributesRequest generates a request for the DescribeDBSnapshotAttributes operation.
func (c *RDS) DescribeDBSnapshotAttributesRequest(input *DescribeDBSnapshotAttributesInput) (req *request.Request, output *DescribeDBSnapshotAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeDBSnapshotAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBSnapshotAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDBSnapshotAttributesOutput{}
	req.Data = output
	return
}

// Returns a list of DB snapshot attribute names and values for a manual DB
// snapshot.
//
// When sharing snapshots with other AWS accounts, DescribeDBSnapshotAttributes
// returns the restore attribute and a list of the AWS account ids that are
// authorized to copy or restore the manual DB snapshot. If all is included
// in the list of values for the restore attribute, then the manual DB snapshot
// is public and can be copied or restored by all AWS accounts.
//
// To add or remove access for an AWS account to copy or restore a manual DB
// snapshot, or to make the manual DB snapshot public or private, use the ModifyDBSnapshotAttribute
// API.
func (c *RDS) DescribeDBSnapshotAttributes(input *DescribeDBSnapshotAttributesInput) (*DescribeDBSnapshotAttributesOutput, error) {
	req, out := c.DescribeDBSnapshotAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeDBSnapshots = "DescribeDBSnapshots"

// DescribeDBSnapshotsRequest generates a request for the DescribeDBSnapshots operation.
func (c *RDS) DescribeDBSnapshotsRequest(input *DescribeDBSnapshotsInput) (req *request.Request, output *DescribeDBSnapshotsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBSnapshotsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDBSnapshotsOutput{}
	req.Data = output
	return
}

// Returns information about DB snapshots. This API supports pagination.
func (c *RDS) DescribeDBSnapshots(input *DescribeDBSnapshotsInput) (*DescribeDBSnapshotsOutput, error) {
	req, out := c.DescribeDBSnapshotsRequest(input)
	err := req.Send()
	return out, err
}

func (c *RDS) DescribeDBSnapshotsPages(input *DescribeDBSnapshotsInput, fn func(p *DescribeDBSnapshotsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeDBSnapshotsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeDBSnapshotsOutput), lastPage)
	})
}

const opDescribeDBSubnetGroups = "DescribeDBSubnetGroups"

// DescribeDBSubnetGroupsRequest generates a request for the DescribeDBSubnetGroups operation.
func (c *RDS) DescribeDBSubnetGroupsRequest(input *DescribeDBSubnetGroupsInput) (req *request.Request, output *DescribeDBSubnetGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBSubnetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBSubnetGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDBSubnetGroupsOutput{}
	req.Data = output
	return
}

// Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified,
// the list will contain only the descriptions of the specified DBSubnetGroup.
//
// For an overview of CIDR ranges, go to the Wikipedia Tutorial (http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
func (c *RDS) DescribeDBSubnetGroups(input *DescribeDBSubnetGroupsInput) (*DescribeDBSubnetGroupsOutput, error) {
	req, out := c.DescribeDBSubnetGroupsRequest(input)
	err := req.Send()
	return out, err
}

func (c *RDS) DescribeDBSubnetGroupsPages(input *DescribeDBSubnetGroupsInput, fn func(p *DescribeDBSubnetGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeDBSubnetGroupsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeDBSubnetGroupsOutput), lastPage)
	})
}

const opDescribeEngineDefaultClusterParameters = "DescribeEngineDefaultClusterParameters"

// DescribeEngineDefaultClusterParametersRequest generates a request for the DescribeEngineDefaultClusterParameters operation.
func (c *RDS) DescribeEngineDefaultClusterParametersRequest(input *DescribeEngineDefaultClusterParametersInput) (req *request.Request, output *DescribeEngineDefaultClusterParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeEngineDefaultClusterParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEngineDefaultClusterParametersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeEngineDefaultClusterParametersOutput{}
	req.Data = output
	return
}

// Returns the default engine and system parameter information for the cluster
// database engine.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
func (c *RDS) DescribeEngineDefaultClusterParameters(input *DescribeEngineDefaultClusterParametersInput) (*DescribeEngineDefaultClusterParametersOutput, error) {
	req, out := c.DescribeEngineDefaultClusterParametersRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeEngineDefaultParameters = "DescribeEngineDefaultParameters"

// DescribeEngineDefaultParametersRequest generates a request for the DescribeEngineDefaultParameters operation.
func (c *RDS) DescribeEngineDefaultParametersRequest(input *DescribeEngineDefaultParametersInput) (req *request.Request, output *DescribeEngineDefaultParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeEngineDefaultParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"EngineDefaults.Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEngineDefaultParametersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeEngineDefaultParametersOutput{}
	req.Data = output
	return
}

// Returns the default engine and system parameter information for the specified
// database engine.
func (c *RDS) DescribeEngineDefaultParameters(input *DescribeEngineDefaultParametersInput) (*DescribeEngineDefaultParametersOutput, error) {
	req, out := c.DescribeEngineDefaultParametersRequest(input)
	err := req.Send()
	return out, err
}

func (c *RDS) DescribeEngineDefaultParametersPages(input *DescribeEngineDefaultParametersInput, fn func(p *DescribeEngineDefaultParametersOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeEngineDefaultParametersRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeEngineDefaultParametersOutput), lastPage)
	})
}

const opDescribeEventCategories = "DescribeEventCategories"

// DescribeEventCategoriesRequest generates a request for the DescribeEventCategories operation.
func (c *RDS) DescribeEventCategoriesRequest(input *DescribeEventCategoriesInput) (req *request.Request, output *DescribeEventCategoriesOutput) {
	op := &request.Operation{
		Name:       opDescribeEventCategories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventCategoriesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeEventCategoriesOutput{}
	req.Data = output
	return
}

// Displays a list of categories for all event source types, or, if specified,
// for a specified source type. You can see a list of the event categories and
// source types in the  Events (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html)
// topic in the Amazon RDS User Guide.
func (c *RDS) DescribeEventCategories(input *DescribeEventCategoriesInput) (*DescribeEventCategoriesOutput, error) {
	req, out := c.DescribeEventCategoriesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeEventSubscriptions = "DescribeEventSubscriptions"

// DescribeEventSubscriptionsRequest generates a request for the DescribeEventSubscriptions operation.
func (c *RDS) DescribeEventSubscriptionsRequest(input *DescribeEventSubscriptionsInput) (req *request.Request, output *DescribeEventSubscriptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeEventSubscriptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventSubscriptionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeEventSubscriptionsOutput{}
	req.Data = output
	return
}

// Lists all the subscription descriptions for a customer account. The description
// for a subscription includes SubscriptionName, SNSTopicARN, CustomerID, SourceType,
// SourceID, CreationTime, and Status.
//
// If you specify a SubscriptionName, lists the description for that subscription.
func (c *RDS) DescribeEventSubscriptions(input *DescribeEventSubscriptionsInput) (*DescribeEventSubscriptionsOutput, error) {
	req, out := c.DescribeEventSubscriptionsRequest(input)
	err := req.Send()
	return out, err
}

func (c *RDS) DescribeEventSubscriptionsPages(input *DescribeEventSubscriptionsInput, fn func(p *DescribeEventSubscriptionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeEventSubscriptionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeEventSubscriptionsOutput), lastPage)
	})
}

const opDescribeEvents = "DescribeEvents"

// DescribeEventsRequest generates a request for the DescribeEvents operation.
func (c *RDS) DescribeEventsRequest(input *DescribeEventsInput) (req *request.Request, output *DescribeEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeEventsOutput{}
	req.Data = output
	return
}

// Returns events related to DB instances, DB security groups, DB snapshots,
// and DB parameter groups for the past 14 days. Events specific to a particular
// DB instance, DB security group, database snapshot, or DB parameter group
// can be obtained by providing the name as a parameter. By default, the past
// hour of events are returned.
func (c *RDS) DescribeEvents(input *DescribeEventsInput) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	err := req.Send()
	return out, err
}

func (c *RDS) DescribeEventsPages(input *DescribeEventsInput, fn func(p *DescribeEventsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeEventsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeEventsOutput), lastPage)
	})
}

const opDescribeOptionGroupOptions = "DescribeOptionGroupOptions"

// DescribeOptionGroupOptionsRequest generates a request for the DescribeOptionGroupOptions operation.
func (c *RDS) DescribeOptionGroupOptionsRequest(input *DescribeOptionGroupOptionsInput) (req *request.Request, output *DescribeOptionGroupOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeOptionGroupOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOptionGroupOptionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeOptionGroupOptionsOutput{}
	req.Data = output
	return
}

// Describes all available options.
func (c *RDS) DescribeOptionGroupOptions(input *DescribeOptionGroupOptionsInput) (*DescribeOptionGroupOptionsOutput, error) {
	req, out := c.DescribeOptionGroupOptionsRequest(input)
	err := req.Send()
	return out, err
}

func (c *RDS) DescribeOptionGroupOptionsPages(input *DescribeOptionGroupOptionsInput, fn func(p *DescribeOptionGroupOptionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeOptionGroupOptionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeOptionGroupOptionsOutput), lastPage)
	})
}

const opDescribeOptionGroups = "DescribeOptionGroups"

// DescribeOptionGroupsRequest generates a request for the DescribeOptionGroups operation.
func (c *RDS) DescribeOptionGroupsRequest(input *DescribeOptionGroupsInput) (req *request.Request, output *DescribeOptionGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeOptionGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOptionGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeOptionGroupsOutput{}
	req.Data = output
	return
}

// Describes the available option groups.
func (c *RDS) DescribeOptionGroups(input *DescribeOptionGroupsInput) (*DescribeOptionGroupsOutput, error) {
	req, out := c.DescribeOptionGroupsRequest(input)
	err := req.Send()
	return out, err
}

func (c *RDS) DescribeOptionGroupsPages(input *DescribeOptionGroupsInput, fn func(p *DescribeOptionGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeOptionGroupsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeOptionGroupsOutput), lastPage)
	})
}

const opDescribeOrderableDBInstanceOptions = "DescribeOrderableDBInstanceOptions"

// DescribeOrderableDBInstanceOptionsRequest generates a request for the DescribeOrderableDBInstanceOptions operation.
func (c *RDS) DescribeOrderableDBInstanceOptionsRequest(input *DescribeOrderableDBInstanceOptionsInput) (req *request.Request, output *DescribeOrderableDBInstanceOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeOrderableDBInstanceOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOrderableDBInstanceOptionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeOrderableDBInstanceOptionsOutput{}
	req.Data = output
	return
}

// Returns a list of orderable DB instance options for the specified engine.
func (c *RDS) DescribeOrderableDBInstanceOptions(input *DescribeOrderableDBInstanceOptionsInput) (*DescribeOrderableDBInstanceOptionsOutput, error) {
	req, out := c.DescribeOrderableDBInstanceOptionsRequest(input)
	err := req.Send()
	return out, err
}

func (c *RDS) DescribeOrderableDBInstanceOptionsPages(input *DescribeOrderableDBInstanceOptionsInput, fn func(p *DescribeOrderableDBInstanceOptionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeOrderableDBInstanceOptionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeOrderableDBInstanceOptionsOutput), lastPage)
	})
}

const opDescribePendingMaintenanceActions = "DescribePendingMaintenanceActions"

// DescribePendingMaintenanceActionsRequest generates a request for the DescribePendingMaintenanceActions operation.
func (c *RDS) DescribePendingMaintenanceActionsRequest(input *DescribePendingMaintenanceActionsInput) (req *request.Request, output *DescribePendingMaintenanceActionsOutput) {
	op := &request.Operation{
		Name:       opDescribePendingMaintenanceActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePendingMaintenanceActionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribePendingMaintenanceActionsOutput{}
	req.Data = output
	return
}

// Returns a list of resources (for example, DB instances) that have at least
// one pending maintenance action.
func (c *RDS) DescribePendingMaintenanceActions(input *DescribePendingMaintenanceActionsInput) (*DescribePendingMaintenanceActionsOutput, error) {
	req, out := c.DescribePendingMaintenanceActionsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeReservedDBInstances = "DescribeReservedDBInstances"

// DescribeReservedDBInstancesRequest generates a request for the DescribeReservedDBInstances operation.
func (c *RDS) DescribeReservedDBInstancesRequest(input *DescribeReservedDBInstancesInput) (req *request.Request, output *DescribeReservedDBInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedDBInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedDBInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeReservedDBInstancesOutput{}
	req.Data = output
	return
}

// Returns information about reserved DB instances for this account, or about
// a specified reserved DB instance.
func (c *RDS) DescribeReservedDBInstances(input *DescribeReservedDBInstancesInput) (*DescribeReservedDBInstancesOutput, error) {
	req, out := c.DescribeReservedDBInstancesRequest(input)
	err := req.Send()
	return out, err
}

func (c *RDS) DescribeReservedDBInstancesPages(input *DescribeReservedDBInstancesInput, fn func(p *DescribeReservedDBInstancesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeReservedDBInstancesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeReservedDBInstancesOutput), lastPage)
	})
}

const opDescribeReservedDBInstancesOfferings = "DescribeReservedDBInstancesOfferings"

// DescribeReservedDBInstancesOfferingsRequest generates a request for the DescribeReservedDBInstancesOfferings operation.
func (c *RDS) DescribeReservedDBInstancesOfferingsRequest(input *DescribeReservedDBInstancesOfferingsInput) (req *request.Request, output *DescribeReservedDBInstancesOfferingsOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedDBInstancesOfferings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedDBInstancesOfferingsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeReservedDBInstancesOfferingsOutput{}
	req.Data = output
	return
}

// Lists available reserved DB instance offerings.
func (c *RDS) DescribeReservedDBInstancesOfferings(input *DescribeReservedDBInstancesOfferingsInput) (*DescribeReservedDBInstancesOfferingsOutput, error) {
	req, out := c.DescribeReservedDBInstancesOfferingsRequest(input)
	err := req.Send()
	return out, err
}

func (c *RDS) DescribeReservedDBInstancesOfferingsPages(input *DescribeReservedDBInstancesOfferingsInput, fn func(p *DescribeReservedDBInstancesOfferingsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeReservedDBInstancesOfferingsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeReservedDBInstancesOfferingsOutput), lastPage)
	})
}

const opDownloadDBLogFilePortion = "DownloadDBLogFilePortion"

// DownloadDBLogFilePortionRequest generates a request for the DownloadDBLogFilePortion operation.
func (c *RDS) DownloadDBLogFilePortionRequest(input *DownloadDBLogFilePortionInput) (req *request.Request, output *DownloadDBLogFilePortionOutput) {
	op := &request.Operation{
		Name:       opDownloadDBLogFilePortion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "NumberOfLines",
			TruncationToken: "AdditionalDataPending",
		},
	}

	if input == nil {
		input = &DownloadDBLogFilePortionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DownloadDBLogFilePortionOutput{}
	req.Data = output
	return
}

// Downloads all or a portion of the specified log file, up to 1 MB in size.
func (c *RDS) DownloadDBLogFilePortion(input *DownloadDBLogFilePortionInput) (*DownloadDBLogFilePortionOutput, error) {
	req, out := c.DownloadDBLogFilePortionRequest(input)
	err := req.Send()
	return out, err
}

func (c *RDS) DownloadDBLogFilePortionPages(input *DownloadDBLogFilePortionInput, fn func(p *DownloadDBLogFilePortionOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DownloadDBLogFilePortionRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DownloadDBLogFilePortionOutput), lastPage)
	})
}

const opFailoverDBCluster = "FailoverDBCluster"

// FailoverDBClusterRequest generates a request for the FailoverDBCluster operation.
func (c *RDS) FailoverDBClusterRequest(input *FailoverDBClusterInput) (req *request.Request, output *FailoverDBClusterOutput) {
	op := &request.Operation{
		Name:       opFailoverDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &FailoverDBClusterInput{}
	}

	req = c.newRequest(op, input, output)
	output = &FailoverDBClusterOutput{}
	req.Data = output
	return
}

// Forces a failover for a DB cluster.
//
// A failover for a DB cluster promotes one of the read-only instances in the
// DB cluster to the master DB instance (the cluster writer) and deletes the
// current primary instance.
//
// Amazon Aurora will automatically fail over to a read-only instance, if one
// exists, when the primary instance fails. You can force a failover when you
// want to simulate a failure of a DB instance for testing. Because each instance
// in a DB cluster has its own endpoint address, you will need to clean up and
// re-establish any existing connections that use those endpoint addresses when
// the failover is complete.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
func (c *RDS) FailoverDBCluster(input *FailoverDBClusterInput) (*FailoverDBClusterOutput, error) {
	req, out := c.FailoverDBClusterRequest(input)
	err := req.Send()
	return out, err
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a request for the ListTagsForResource operation.
func (c *RDS) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTagsForResourceOutput{}
	req.Data = output
	return
}

// Lists all tags on an Amazon RDS resource.
//
// For an overview on tagging an Amazon RDS resource, see Tagging Amazon RDS
// Resources (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html).
func (c *RDS) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	err := req.Send()
	return out, err
}

const opModifyDBCluster = "ModifyDBCluster"

// ModifyDBClusterRequest generates a request for the ModifyDBCluster operation.
func (c *RDS) ModifyDBClusterRequest(input *ModifyDBClusterInput) (req *request.Request, output *ModifyDBClusterOutput) {
	op := &request.Operation{
		Name:       opModifyDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBClusterInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyDBClusterOutput{}
	req.Data = output
	return
}

// Modify a setting for an Amazon Aurora DB cluster. You can change one or more
// database configuration parameters by specifying these parameters and the
// new values in the request. For more information on Amazon Aurora, see Aurora
// on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
func (c *RDS) ModifyDBCluster(input *ModifyDBClusterInput) (*ModifyDBClusterOutput, error) {
	req, out := c.ModifyDBClusterRequest(input)
	err := req.Send()
	return out, err
}

const opModifyDBClusterParameterGroup = "ModifyDBClusterParameterGroup"

// ModifyDBClusterParameterGroupRequest generates a request for the ModifyDBClusterParameterGroup operation.
func (c *RDS) ModifyDBClusterParameterGroupRequest(input *ModifyDBClusterParameterGroupInput) (req *request.Request, output *DBClusterParameterGroupNameMessage) {
	op := &request.Operation{
		Name:       opModifyDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBClusterParameterGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DBClusterParameterGroupNameMessage{}
	req.Data = output
	return
}

// Modifies the parameters of a DB cluster parameter group. To modify more than
// one parameter, submit a list of the following: ParameterName, ParameterValue,
// and ApplyMethod. A maximum of 20 parameters can be modified in a single request.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
//
//   Changes to dynamic parameters are applied immediately. Changes to static
// parameters require a reboot without failover to the DB cluster associated
// with the parameter group before the change can take effect.
//
//   After you create a DB cluster parameter group, you should wait at least
// 5 minutes before creating your first DB cluster that uses that DB cluster
// parameter group as the default parameter group. This allows Amazon RDS to
// fully complete the create action before the parameter group is used as the
// default for a new DB cluster. This is especially important for parameters
// that are critical when creating the default database for a DB cluster, such
// as the character set for the default database defined by the character_set_database
// parameter. You can use the Parameter Groups option of the Amazon RDS console
// (https://console.aws.amazon.com/rds/) or the DescribeDBClusterParameters
// command to verify that your DB cluster parameter group has been created or
// modified.
func (c *RDS) ModifyDBClusterParameterGroup(input *ModifyDBClusterParameterGroupInput) (*DBClusterParameterGroupNameMessage, error) {
	req, out := c.ModifyDBClusterParameterGroupRequest(input)
	err := req.Send()
	return out, err
}

const opModifyDBInstance = "ModifyDBInstance"

// ModifyDBInstanceRequest generates a request for the ModifyDBInstance operation.
func (c *RDS) ModifyDBInstanceRequest(input *ModifyDBInstanceInput) (req *request.Request, output *ModifyDBInstanceOutput) {
	op := &request.Operation{
		Name:       opModifyDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyDBInstanceOutput{}
	req.Data = output
	return
}

// Modify settings for a DB instance. You can change one or more database configuration
// parameters by specifying these parameters and the new values in the request.
func (c *RDS) ModifyDBInstance(input *ModifyDBInstanceInput) (*ModifyDBInstanceOutput, error) {
	req, out := c.ModifyDBInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opModifyDBParameterGroup = "ModifyDBParameterGroup"

// ModifyDBParameterGroupRequest generates a request for the ModifyDBParameterGroup operation.
func (c *RDS) ModifyDBParameterGroupRequest(input *ModifyDBParameterGroupInput) (req *request.Request, output *DBParameterGroupNameMessage) {
	op := &request.Operation{
		Name:       opModifyDBParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBParameterGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DBParameterGroupNameMessage{}
	req.Data = output
	return
}

// Modifies the parameters of a DB parameter group. To modify more than one
// parameter, submit a list of the following: ParameterName, ParameterValue,
// and ApplyMethod. A maximum of 20 parameters can be modified in a single request.
//
//   Changes to dynamic parameters are applied immediately. Changes to static
// parameters require a reboot without failover to the DB instance associated
// with the parameter group before the change can take effect.
//
//   After you modify a DB parameter group, you should wait at least 5 minutes
// before creating your first DB instance that uses that DB parameter group
// as the default parameter group. This allows Amazon RDS to fully complete
// the modify action before the parameter group is used as the default for a
// new DB instance. This is especially important for parameters that are critical
// when creating the default database for a DB instance, such as the character
// set for the default database defined by the character_set_database parameter.
// You can use the Parameter Groups option of the Amazon RDS console (https://console.aws.amazon.com/rds/)
// or the DescribeDBParameters command to verify that your DB parameter group
// has been created or modified.
func (c *RDS) ModifyDBParameterGroup(input *ModifyDBParameterGroupInput) (*DBParameterGroupNameMessage, error) {
	req, out := c.ModifyDBParameterGroupRequest(input)
	err := req.Send()
	return out, err
}

const opModifyDBSnapshotAttribute = "ModifyDBSnapshotAttribute"

// ModifyDBSnapshotAttributeRequest generates a request for the ModifyDBSnapshotAttribute operation.
func (c *RDS) ModifyDBSnapshotAttributeRequest(input *ModifyDBSnapshotAttributeInput) (req *request.Request, output *ModifyDBSnapshotAttributeOutput) {
	op := &request.Operation{
		Name:       opModifyDBSnapshotAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBSnapshotAttributeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyDBSnapshotAttributeOutput{}
	req.Data = output
	return
}

// Adds an attribute and values to, or removes an attribute and values from
// a manual DB snapshot.
//
// To share a manual DB snapshot with other AWS accounts, specify restore as
// the AttributeName and use the ValuesToAdd parameter to add a list of the
// AWS account ids that are authorized to retore the manual DB snapshot. Uses
// the value all to make the manual DB snapshot public and can by copied or
// restored by all AWS accounts. Do not add the all value for any manual DB
// snapshots that contain private information that you do not want to be available
// to all AWS accounts.
//
// To view which AWS accounts have access to copy or restore a manual DB snapshot,
// or whether a manual DB snapshot public or private, use the DescribeDBSnapshotAttributes
// API.
//
// If the manual DB snapshot is encrypted, it cannot be shared.
func (c *RDS) ModifyDBSnapshotAttribute(input *ModifyDBSnapshotAttributeInput) (*ModifyDBSnapshotAttributeOutput, error) {
	req, out := c.ModifyDBSnapshotAttributeRequest(input)
	err := req.Send()
	return out, err
}

const opModifyDBSubnetGroup = "ModifyDBSubnetGroup"

// ModifyDBSubnetGroupRequest generates a request for the ModifyDBSubnetGroup operation.
func (c *RDS) ModifyDBSubnetGroupRequest(input *ModifyDBSubnetGroupInput) (req *request.Request, output *ModifyDBSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opModifyDBSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBSubnetGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyDBSubnetGroupOutput{}
	req.Data = output
	return
}

// Modifies an existing DB subnet group. DB subnet groups must contain at least
// one subnet in at least two AZs in the region.
func (c *RDS) ModifyDBSubnetGroup(input *ModifyDBSubnetGroupInput) (*ModifyDBSubnetGroupOutput, error) {
	req, out := c.ModifyDBSubnetGroupRequest(input)
	err := req.Send()
	return out, err
}

const opModifyEventSubscription = "ModifyEventSubscription"

// ModifyEventSubscriptionRequest generates a request for the ModifyEventSubscription operation.
func (c *RDS) ModifyEventSubscriptionRequest(input *ModifyEventSubscriptionInput) (req *request.Request, output *ModifyEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opModifyEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyEventSubscriptionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyEventSubscriptionOutput{}
	req.Data = output
	return
}

// Modifies an existing RDS event notification subscription. Note that you cannot
// modify the source identifiers using this call; to change source identifiers
// for a subscription, use the AddSourceIdentifierToSubscription and RemoveSourceIdentifierFromSubscription
// calls.
//
// You can see a list of the event categories for a given SourceType in the
// Events (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html)
// topic in the Amazon RDS User Guide or by using the DescribeEventCategories
// action.
func (c *RDS) ModifyEventSubscription(input *ModifyEventSubscriptionInput) (*ModifyEventSubscriptionOutput, error) {
	req, out := c.ModifyEventSubscriptionRequest(input)
	err := req.Send()
	return out, err
}

const opModifyOptionGroup = "ModifyOptionGroup"

// ModifyOptionGroupRequest generates a request for the ModifyOptionGroup operation.
func (c *RDS) ModifyOptionGroupRequest(input *ModifyOptionGroupInput) (req *request.Request, output *ModifyOptionGroupOutput) {
	op := &request.Operation{
		Name:       opModifyOptionGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyOptionGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyOptionGroupOutput{}
	req.Data = output
	return
}

// Modifies an existing option group.
func (c *RDS) ModifyOptionGroup(input *ModifyOptionGroupInput) (*ModifyOptionGroupOutput, error) {
	req, out := c.ModifyOptionGroupRequest(input)
	err := req.Send()
	return out, err
}

const opPromoteReadReplica = "PromoteReadReplica"

// PromoteReadReplicaRequest generates a request for the PromoteReadReplica operation.
func (c *RDS) PromoteReadReplicaRequest(input *PromoteReadReplicaInput) (req *request.Request, output *PromoteReadReplicaOutput) {
	op := &request.Operation{
		Name:       opPromoteReadReplica,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PromoteReadReplicaInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PromoteReadReplicaOutput{}
	req.Data = output
	return
}

// Promotes a Read Replica DB instance to a standalone DB instance.
//
//  We recommend that you enable automated backups on your Read Replica before
// promoting the Read Replica. This ensures that no backup is taken during the
// promotion process. Once the instance is promoted to a primary instance, backups
// are taken based on your backup settings.
func (c *RDS) PromoteReadReplica(input *PromoteReadReplicaInput) (*PromoteReadReplicaOutput, error) {
	req, out := c.PromoteReadReplicaRequest(input)
	err := req.Send()
	return out, err
}

const opPurchaseReservedDBInstancesOffering = "PurchaseReservedDBInstancesOffering"

// PurchaseReservedDBInstancesOfferingRequest generates a request for the PurchaseReservedDBInstancesOffering operation.
func (c *RDS) PurchaseReservedDBInstancesOfferingRequest(input *PurchaseReservedDBInstancesOfferingInput) (req *request.Request, output *PurchaseReservedDBInstancesOfferingOutput) {
	op := &request.Operation{
		Name:       opPurchaseReservedDBInstancesOffering,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PurchaseReservedDBInstancesOfferingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PurchaseReservedDBInstancesOfferingOutput{}
	req.Data = output
	return
}

// Purchases a reserved DB instance offering.
func (c *RDS) PurchaseReservedDBInstancesOffering(input *PurchaseReservedDBInstancesOfferingInput) (*PurchaseReservedDBInstancesOfferingOutput, error) {
	req, out := c.PurchaseReservedDBInstancesOfferingRequest(input)
	err := req.Send()
	return out, err
}

const opRebootDBInstance = "RebootDBInstance"

// RebootDBInstanceRequest generates a request for the RebootDBInstance operation.
func (c *RDS) RebootDBInstanceRequest(input *RebootDBInstanceInput) (req *request.Request, output *RebootDBInstanceOutput) {
	op := &request.Operation{
		Name:       opRebootDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootDBInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RebootDBInstanceOutput{}
	req.Data = output
	return
}

// Rebooting a DB instance restarts the database engine service. A reboot also
// applies to the DB instance any modifications to the associated DB parameter
// group that were pending. Rebooting a DB instance results in a momentary outage
// of the instance, during which the DB instance status is set to rebooting.
// If the RDS instance is configured for MultiAZ, it is possible that the reboot
// will be conducted through a failover. An Amazon RDS event is created when
// the reboot is completed.
//
//  If your DB instance is deployed in multiple Availability Zones, you can
// force a failover from one AZ to the other during the reboot. You might force
// a failover to test the availability of your DB instance deployment or to
// restore operations to the original AZ after a failover occurs.
//
//  The time required to reboot is a function of the specific database engine's
// crash recovery process. To improve the reboot time, we recommend that you
// reduce database activities as much as possible during the reboot process
// to reduce rollback activity for in-transit transactions.
func (c *RDS) RebootDBInstance(input *RebootDBInstanceInput) (*RebootDBInstanceOutput, error) {
	req, out := c.RebootDBInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveSourceIdentifierFromSubscription = "RemoveSourceIdentifierFromSubscription"

// RemoveSourceIdentifierFromSubscriptionRequest generates a request for the RemoveSourceIdentifierFromSubscription operation.
func (c *RDS) RemoveSourceIdentifierFromSubscriptionRequest(input *RemoveSourceIdentifierFromSubscriptionInput) (req *request.Request, output *RemoveSourceIdentifierFromSubscriptionOutput) {
	op := &request.Operation{
		Name:       opRemoveSourceIdentifierFromSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveSourceIdentifierFromSubscriptionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RemoveSourceIdentifierFromSubscriptionOutput{}
	req.Data = output
	return
}

// Removes a source identifier from an existing RDS event notification subscription.
func (c *RDS) RemoveSourceIdentifierFromSubscription(input *RemoveSourceIdentifierFromSubscriptionInput) (*RemoveSourceIdentifierFromSubscriptionOutput, error) {
	req, out := c.RemoveSourceIdentifierFromSubscriptionRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveTagsFromResource = "RemoveTagsFromResource"

// RemoveTagsFromResourceRequest generates a request for the RemoveTagsFromResource operation.
func (c *RDS) RemoveTagsFromResourceRequest(input *RemoveTagsFromResourceInput) (req *request.Request, output *RemoveTagsFromResourceOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromResourceInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &RemoveTagsFromResourceOutput{}
	req.Data = output
	return
}

// Removes metadata tags from an Amazon RDS resource.
//
// For an overview on tagging an Amazon RDS resource, see Tagging Amazon RDS
// Resources (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html).
func (c *RDS) RemoveTagsFromResource(input *RemoveTagsFromResourceInput) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	err := req.Send()
	return out, err
}

const opResetDBClusterParameterGroup = "ResetDBClusterParameterGroup"

// ResetDBClusterParameterGroupRequest generates a request for the ResetDBClusterParameterGroup operation.
func (c *RDS) ResetDBClusterParameterGroupRequest(input *ResetDBClusterParameterGroupInput) (req *request.Request, output *DBClusterParameterGroupNameMessage) {
	op := &request.Operation{
		Name:       opResetDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetDBClusterParameterGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DBClusterParameterGroupNameMessage{}
	req.Data = output
	return
}

// Modifies the parameters of a DB cluster parameter group to the default value.
// To reset specific parameters submit a list of the following: ParameterName
// and ApplyMethod. To reset the entire DB cluster parameter group, specify
// the DBClusterParameterGroupName and ResetAllParameters parameters.
//
//  When resetting the entire group, dynamic parameters are updated immediately
// and static parameters are set to pending-reboot to take effect on the next
// DB instance restart or RebootDBInstance request. You must call RebootDBInstance
// for every DB instance in your DB cluster that you want the updated static
// parameter to apply to.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
func (c *RDS) ResetDBClusterParameterGroup(input *ResetDBClusterParameterGroupInput) (*DBClusterParameterGroupNameMessage, error) {
	req, out := c.ResetDBClusterParameterGroupRequest(input)
	err := req.Send()
	return out, err
}

const opResetDBParameterGroup = "ResetDBParameterGroup"

// ResetDBParameterGroupRequest generates a request for the ResetDBParameterGroup operation.
func (c *RDS) ResetDBParameterGroupRequest(input *ResetDBParameterGroupInput) (req *request.Request, output *DBParameterGroupNameMessage) {
	op := &request.Operation{
		Name:       opResetDBParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetDBParameterGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DBParameterGroupNameMessage{}
	req.Data = output
	return
}

// Modifies the parameters of a DB parameter group to the engine/system default
// value. To reset specific parameters submit a list of the following: ParameterName
// and ApplyMethod. To reset the entire DB parameter group, specify the DBParameterGroup
// name and ResetAllParameters parameters. When resetting the entire group,
// dynamic parameters are updated immediately and static parameters are set
// to pending-reboot to take effect on the next DB instance restart or RebootDBInstance
// request.
func (c *RDS) ResetDBParameterGroup(input *ResetDBParameterGroupInput) (*DBParameterGroupNameMessage, error) {
	req, out := c.ResetDBParameterGroupRequest(input)
	err := req.Send()
	return out, err
}

const opRestoreDBClusterFromSnapshot = "RestoreDBClusterFromSnapshot"

// RestoreDBClusterFromSnapshotRequest generates a request for the RestoreDBClusterFromSnapshot operation.
func (c *RDS) RestoreDBClusterFromSnapshotRequest(input *RestoreDBClusterFromSnapshotInput) (req *request.Request, output *RestoreDBClusterFromSnapshotOutput) {
	op := &request.Operation{
		Name:       opRestoreDBClusterFromSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreDBClusterFromSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RestoreDBClusterFromSnapshotOutput{}
	req.Data = output
	return
}

// Creates a new DB cluster from a DB cluster snapshot. The target DB cluster
// is created from the source DB cluster restore point with the same configuration
// as the original source DB cluster, except that the new DB cluster is created
// with the default security group.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
func (c *RDS) RestoreDBClusterFromSnapshot(input *RestoreDBClusterFromSnapshotInput) (*RestoreDBClusterFromSnapshotOutput, error) {
	req, out := c.RestoreDBClusterFromSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opRestoreDBClusterToPointInTime = "RestoreDBClusterToPointInTime"

// RestoreDBClusterToPointInTimeRequest generates a request for the RestoreDBClusterToPointInTime operation.
func (c *RDS) RestoreDBClusterToPointInTimeRequest(input *RestoreDBClusterToPointInTimeInput) (req *request.Request, output *RestoreDBClusterToPointInTimeOutput) {
	op := &request.Operation{
		Name:       opRestoreDBClusterToPointInTime,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreDBClusterToPointInTimeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RestoreDBClusterToPointInTimeOutput{}
	req.Data = output
	return
}

// Restores a DB cluster to an arbitrary point in time. Users can restore to
// any point in time before LatestRestorableTime for up to BackupRetentionPeriod
// days. The target DB cluster is created from the source DB cluster with the
// same configuration as the original DB cluster, except that the new DB cluster
// is created with the default DB security group.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
func (c *RDS) RestoreDBClusterToPointInTime(input *RestoreDBClusterToPointInTimeInput) (*RestoreDBClusterToPointInTimeOutput, error) {
	req, out := c.RestoreDBClusterToPointInTimeRequest(input)
	err := req.Send()
	return out, err
}

const opRestoreDBInstanceFromDBSnapshot = "RestoreDBInstanceFromDBSnapshot"

// RestoreDBInstanceFromDBSnapshotRequest generates a request for the RestoreDBInstanceFromDBSnapshot operation.
func (c *RDS) RestoreDBInstanceFromDBSnapshotRequest(input *RestoreDBInstanceFromDBSnapshotInput) (req *request.Request, output *RestoreDBInstanceFromDBSnapshotOutput) {
	op := &request.Operation{
		Name:       opRestoreDBInstanceFromDBSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreDBInstanceFromDBSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RestoreDBInstanceFromDBSnapshotOutput{}
	req.Data = output
	return
}

// Creates a new DB instance from a DB snapshot. The target database is created
// from the source database restore point with the most of original configuration,
// but in a system chosen availability zone with the default security group,
// the default subnet group, and the default DB parameter group. By default,
// the new DB instance is created as a single-AZ deployment except when the
// instance is a SQL Server instance that has an option group that is associated
// with mirroring; in this case, the instance becomes a mirrored AZ deployment
// and not a single-AZ deployment.
//
// If your intent is to replace your original DB instance with the new, restored
// DB instance, then rename your original DB instance before you call the RestoreDBInstanceFromDBSnapshot
// action. RDS does not allow two DB instances with the same name. Once you
// have renamed your original DB instance with a different identifier, then
// you can pass the original name of the DB instance as the DBInstanceIdentifier
// in the call to the RestoreDBInstanceFromDBSnapshot action. The result is
// that you will replace the original DB instance with the DB instance created
// from the snapshot.
//
// If you are restoring from a shared manual DB snapshot, the DBSnapshotIdentifier
// must be the ARN of the shared DB snapshot.
func (c *RDS) RestoreDBInstanceFromDBSnapshot(input *RestoreDBInstanceFromDBSnapshotInput) (*RestoreDBInstanceFromDBSnapshotOutput, error) {
	req, out := c.RestoreDBInstanceFromDBSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opRestoreDBInstanceToPointInTime = "RestoreDBInstanceToPointInTime"

// RestoreDBInstanceToPointInTimeRequest generates a request for the RestoreDBInstanceToPointInTime operation.
func (c *RDS) RestoreDBInstanceToPointInTimeRequest(input *RestoreDBInstanceToPointInTimeInput) (req *request.Request, output *RestoreDBInstanceToPointInTimeOutput) {
	op := &request.Operation{
		Name:       opRestoreDBInstanceToPointInTime,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreDBInstanceToPointInTimeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RestoreDBInstanceToPointInTimeOutput{}
	req.Data = output
	return
}

// Restores a DB instance to an arbitrary point-in-time. Users can restore to
// any point in time before the LatestRestorableTime for up to BackupRetentionPeriod
// days. The target database is created with the most of original configuration,
// but in a system chosen availability zone with the default security group,
// the default subnet group, and the default DB parameter group. By default,
// the new DB instance is created as a single-AZ deployment except when the
// instance is a SQL Server instance that has an option group that is associated
// with mirroring; in this case, the instance becomes a mirrored deployment
// and not a single-AZ deployment.
func (c *RDS) RestoreDBInstanceToPointInTime(input *RestoreDBInstanceToPointInTimeInput) (*RestoreDBInstanceToPointInTimeOutput, error) {
	req, out := c.RestoreDBInstanceToPointInTimeRequest(input)
	err := req.Send()
	return out, err
}

const opRevokeDBSecurityGroupIngress = "RevokeDBSecurityGroupIngress"

// RevokeDBSecurityGroupIngressRequest generates a request for the RevokeDBSecurityGroupIngress operation.
func (c *RDS) RevokeDBSecurityGroupIngressRequest(input *RevokeDBSecurityGroupIngressInput) (req *request.Request, output *RevokeDBSecurityGroupIngressOutput) {
	op := &request.Operation{
		Name:       opRevokeDBSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeDBSecurityGroupIngressInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RevokeDBSecurityGroupIngressOutput{}
	req.Data = output
	return
}

// Revokes ingress from a DBSecurityGroup for previously authorized IP ranges
// or EC2 or VPC Security Groups. Required parameters for this API are one of
// CIDRIP, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either
// EC2SecurityGroupName or EC2SecurityGroupId).
func (c *RDS) RevokeDBSecurityGroupIngress(input *RevokeDBSecurityGroupIngressInput) (*RevokeDBSecurityGroupIngressOutput, error) {
	req, out := c.RevokeDBSecurityGroupIngressRequest(input)
	err := req.Send()
	return out, err
}

// Describes a quota for an AWS account, for example, the number of DB instances
// allowed.
type AccountQuota struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon RDS quota for this AWS account.
	AccountQuotaName *string `type:"string"`

	// The maximum allowed value for the quota.
	Max *int64 `type:"long"`

	// The amount currently used toward the quota maximum.
	Used *int64 `type:"long"`
}

// String returns the string representation
func (s AccountQuota) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountQuota) GoString() string {
	return s.String()
}

type AddSourceIdentifierToSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the event source to be added. An identifier must begin
	// with a letter and must contain only ASCII letters, digits, and hyphens; it
	// cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Constraints:
	//
	//  If the source type is a DB instance, then a DBInstanceIdentifier must be
	// supplied. If the source type is a DB security group, a DBSecurityGroupName
	// must be supplied. If the source type is a DB parameter group, a DBParameterGroupName
	// must be supplied. If the source type is a DB snapshot, a DBSnapshotIdentifier
	// must be supplied.
	SourceIdentifier *string `type:"string" required:"true"`

	// The name of the RDS event notification subscription you want to add a source
	// identifier to.
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AddSourceIdentifierToSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddSourceIdentifierToSubscriptionInput) GoString() string {
	return s.String()
}

type AddSourceIdentifierToSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful invocation of the DescribeEventSubscriptions
	// action.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s AddSourceIdentifierToSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddSourceIdentifierToSubscriptionOutput) GoString() string {
	return s.String()
}

type AddTagsToResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon RDS resource the tags will be added to. This value is an Amazon
	// Resource Name (ARN). For information about creating an ARN, see  Constructing
	// an RDS Amazon Resource Name (ARN) (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN).
	ResourceName *string `type:"string" required:"true"`

	// The tags to be assigned to the Amazon RDS resource.
	Tags []*Tag `locationNameList:"Tag" type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceInput) GoString() string {
	return s.String()
}

type AddTagsToResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsToResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceOutput) GoString() string {
	return s.String()
}

type ApplyPendingMaintenanceActionInput struct {
	_ struct{} `type:"structure"`

	// The pending maintenance action to apply to this resource.
	ApplyAction *string `type:"string" required:"true"`

	// A value that specifies the type of opt-in request, or undoes an opt-in request.
	// An opt-in request of type immediate cannot be undone.
	//
	// Valid values:
	//
	//   immediate - Apply the maintenance action immediately.  next-maintenance
	// - Apply the maintenance action during the next maintenance window for the
	// resource.  undo-opt-in - Cancel any existing next-maintenance opt-in requests.
	OptInType *string `type:"string" required:"true"`

	// The RDS Amazon Resource Name (ARN) of the resource that the pending maintenance
	// action applies to. For information about creating an ARN, see  Constructing
	// an RDS Amazon Resource Name (ARN) (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN).
	ResourceIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ApplyPendingMaintenanceActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplyPendingMaintenanceActionInput) GoString() string {
	return s.String()
}

type ApplyPendingMaintenanceActionOutput struct {
	_ struct{} `type:"structure"`

	// Describes the pending maintenance actions for a resource.
	ResourcePendingMaintenanceActions *ResourcePendingMaintenanceActions `type:"structure"`
}

// String returns the string representation
func (s ApplyPendingMaintenanceActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplyPendingMaintenanceActionOutput) GoString() string {
	return s.String()
}

type AuthorizeDBSecurityGroupIngressInput struct {
	_ struct{} `type:"structure"`

	// The IP range to authorize.
	CIDRIP *string `type:"string"`

	// The name of the DB security group to add authorization to.
	DBSecurityGroupName *string `type:"string" required:"true"`

	// Id of the EC2 security group to authorize. For VPC DB security groups, EC2SecurityGroupId
	// must be provided. Otherwise, EC2SecurityGroupOwnerId and either EC2SecurityGroupName
	// or EC2SecurityGroupId must be provided.
	EC2SecurityGroupId *string `type:"string"`

	// Name of the EC2 security group to authorize. For VPC DB security groups,
	// EC2SecurityGroupId must be provided. Otherwise, EC2SecurityGroupOwnerId and
	// either EC2SecurityGroupName or EC2SecurityGroupId must be provided.
	EC2SecurityGroupName *string `type:"string"`

	// AWS account number of the owner of the EC2 security group specified in the
	// EC2SecurityGroupName parameter. The AWS Access Key ID is not an acceptable
	// value. For VPC DB security groups, EC2SecurityGroupId must be provided. Otherwise,
	// EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId
	// must be provided.
	EC2SecurityGroupOwnerId *string `type:"string"`
}

// String returns the string representation
func (s AuthorizeDBSecurityGroupIngressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeDBSecurityGroupIngressInput) GoString() string {
	return s.String()
}

type AuthorizeDBSecurityGroupIngressOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   DescribeDBSecurityGroups   AuthorizeDBSecurityGroupIngress   CreateDBSecurityGroup
	//   RevokeDBSecurityGroupIngress   This data type is used as a response element
	// in the DescribeDBSecurityGroups action.
	DBSecurityGroup *DBSecurityGroup `type:"structure"`
}

// String returns the string representation
func (s AuthorizeDBSecurityGroupIngressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeDBSecurityGroupIngressOutput) GoString() string {
	return s.String()
}

// Contains Availability Zone information.
//
//  This data type is used as an element in the following data type: OrderableDBInstanceOption
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The name of the availability zone.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// A CA certificate for an AWS account.
type Certificate struct {
	_ struct{} `type:"structure"`

	// The unique key that identifies a certificate.
	CertificateIdentifier *string `type:"string"`

	// The type of the certificate.
	CertificateType *string `type:"string"`

	// The thumbprint of the certificate.
	Thumbprint *string `type:"string"`

	// The starting date from which the certificate is valid.
	ValidFrom *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The final date that the certificate continues to be valid.
	ValidTill *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Certificate) GoString() string {
	return s.String()
}

// This data type is used as a response element in the action DescribeDBEngineVersions.
type CharacterSet struct {
	_ struct{} `type:"structure"`

	// The description of the character set.
	CharacterSetDescription *string `type:"string"`

	// The name of the character set.
	CharacterSetName *string `type:"string"`
}

// String returns the string representation
func (s CharacterSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CharacterSet) GoString() string {
	return s.String()
}

type CopyDBClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the DB cluster snapshot to copy. This parameter is not
	// case-sensitive.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens. First character
	// must be a letter. Cannot end with a hyphen or contain two consecutive hyphens.
	//  Example: my-cluster-snapshot1
	SourceDBClusterSnapshotIdentifier *string `type:"string" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The identifier of the new DB cluster snapshot to create from the source DB
	// cluster snapshot. This parameter is not case-sensitive.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens. First character
	// must be a letter. Cannot end with a hyphen or contain two consecutive hyphens.
	//  Example: my-cluster-snapshot2
	TargetDBClusterSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyDBClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBClusterSnapshotInput) GoString() string {
	return s.String()
}

type CopyDBClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   CreateDBClusterSnapshot   DeleteDBClusterSnapshot   This data type is
	// used as a response element in the DescribeDBClusterSnapshots action.
	DBClusterSnapshot *DBClusterSnapshot `type:"structure"`
}

// String returns the string representation
func (s CopyDBClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBClusterSnapshotOutput) GoString() string {
	return s.String()
}

type CopyDBParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier or ARN for the source DB parameter group. For information
	// about creating an ARN, see  Constructing an RDS Amazon Resource Name (ARN)
	// (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN).
	//
	// Constraints:
	//
	//  Must specify a valid DB parameter group. If the source DB parameter group
	// is in the same region as the copy, specify a valid DB parameter group identifier,
	// for example my-db-param-group, or a valid ARN. If the source DB parameter
	// group is in a different region than the copy, specify a valid DB parameter
	// group ARN, for example arn:aws:rds:us-west-2:123456789012:pg:special-parameters.
	SourceDBParameterGroupIdentifier *string `type:"string" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A description for the copied DB parameter group.
	TargetDBParameterGroupDescription *string `type:"string" required:"true"`

	// The identifier for the copied DB parameter group.
	//
	// Constraints:
	//
	//  Cannot be null, empty, or blank Must contain from 1 to 255 alphanumeric
	// characters or hyphens First character must be a letter Cannot end with a
	// hyphen or contain two consecutive hyphens  Example: my-db-parameter-group
	TargetDBParameterGroupIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyDBParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBParameterGroupInput) GoString() string {
	return s.String()
}

type CopyDBParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the CreateDBParameterGroup
	// action.
	//
	// This data type is used as a request parameter in the DeleteDBParameterGroup
	// action, and as a response element in the DescribeDBParameterGroups action.
	DBParameterGroup *DBParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CopyDBParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBParameterGroupOutput) GoString() string {
	return s.String()
}

type CopyDBSnapshotInput struct {
	_ struct{} `type:"structure"`

	// True to copy all tags from the source DB snapshot to the target DB snapshot;
	// otherwise false. The default is false.
	CopyTags *bool `type:"boolean"`

	// The identifier for the source DB snapshot.
	//
	// If you are copying from a shared manual DB snapshot, this must be the ARN
	// of the shared DB snapshot.
	//
	// Constraints:
	//
	//  Must specify a valid system snapshot in the "available" state. If the source
	// snapshot is in the same region as the copy, specify a valid DB snapshot identifier.
	// If the source snapshot is in a different region than the copy, specify a
	// valid DB snapshot ARN. For more information, go to  Copying a DB Snapshot
	// (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html).
	//  Example: rds:mydb-2012-04-02-00-01
	//
	// Example: arn:aws:rds:rr-regn-1:123456789012:snapshot:mysql-instance1-snapshot-20130805
	SourceDBSnapshotIdentifier *string `type:"string" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The identifier for the copied snapshot.
	//
	// Constraints:
	//
	//  Cannot be null, empty, or blank Must contain from 1 to 255 alphanumeric
	// characters or hyphens First character must be a letter Cannot end with a
	// hyphen or contain two consecutive hyphens  Example: my-db-snapshot
	TargetDBSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyDBSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBSnapshotInput) GoString() string {
	return s.String()
}

type CopyDBSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   CreateDBSnapshot   DeleteDBSnapshot   This data type is used as a response
	// element in the DescribeDBSnapshots action.
	DBSnapshot *DBSnapshot `type:"structure"`
}

// String returns the string representation
func (s CopyDBSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBSnapshotOutput) GoString() string {
	return s.String()
}

type CopyOptionGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier or ARN for the source option group. For information about
	// creating an ARN, see  Constructing an RDS Amazon Resource Name (ARN) (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN).
	//
	// Constraints:
	//
	//  Must specify a valid option group. If the source option group is in the
	// same region as the copy, specify a valid option group identifier, for example
	// my-option-group, or a valid ARN. If the source option group is in a different
	// region than the copy, specify a valid option group ARN, for example arn:aws:rds:us-west-2:123456789012:og:special-options.
	SourceOptionGroupIdentifier *string `type:"string" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The description for the copied option group.
	TargetOptionGroupDescription *string `type:"string" required:"true"`

	// The identifier for the copied option group.
	//
	// Constraints:
	//
	//  Cannot be null, empty, or blank Must contain from 1 to 255 alphanumeric
	// characters or hyphens First character must be a letter Cannot end with a
	// hyphen or contain two consecutive hyphens  Example: my-option-group
	TargetOptionGroupIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyOptionGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyOptionGroupInput) GoString() string {
	return s.String()
}

type CopyOptionGroupOutput struct {
	_ struct{} `type:"structure"`

	OptionGroup *OptionGroup `type:"structure"`
}

// String returns the string representation
func (s CopyOptionGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyOptionGroupOutput) GoString() string {
	return s.String()
}

type CreateDBClusterInput struct {
	_ struct{} `type:"structure"`

	// A list of EC2 Availability Zones that instances in the DB cluster can be
	// created in. For information on regions and Availability Zones, see Regions
	// and Availability Zones (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
	AvailabilityZones []*string `locationNameList:"AvailabilityZone" type:"list"`

	// The number of days for which automated backups are retained. You must specify
	// a minimum value of 1.
	//
	// Default: 1
	//
	// Constraints:
	//
	//  Must be a value from 1 to 35
	BackupRetentionPeriod *int64 `type:"integer"`

	// A value that indicates that the DB cluster should be associated with the
	// specified CharacterSet.
	CharacterSetName *string `type:"string"`

	// The DB cluster identifier. This parameter is stored as a lowercase string.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens. First character
	// must be a letter. Cannot end with a hyphen or contain two consecutive hyphens.
	//  Example: my-cluster1
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The name of the DB cluster parameter group to associate with this DB cluster.
	// If this argument is omitted, default.aurora5.6 for the specified engine will
	// be used.
	//
	//  Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens
	DBClusterParameterGroupName *string `type:"string"`

	// A DB subnet group to associate with this DB cluster.
	DBSubnetGroupName *string `type:"string"`

	// The name for your database of up to 8 alpha-numeric characters. If you do
	// not provide a name, Amazon RDS will not create a database in the DB cluster
	// you are creating.
	DatabaseName *string `type:"string"`

	// The name of the database engine to be used for this DB cluster.
	//
	// Valid Values: aurora
	Engine *string `type:"string" required:"true"`

	// The version number of the database engine to use.
	//
	//  Aurora
	//
	// Example: 5.6.10a
	EngineVersion *string `type:"string"`

	// The KMS key identifier for an encrypted DB cluster.
	//
	// The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption
	// key. If you are creating a DB cluster with the same AWS account that owns
	// the KMS encryption key used to encrypt the new DB cluster, then you can use
	// the KMS key alias instead of the ARN for the KM encryption key.
	//
	// If the StorageEncrypted parameter is true, and you do not specify a value
	// for the KmsKeyId parameter, then Amazon RDS will use your default encryption
	// key. AWS KMS creates the default encryption key for your AWS account. Your
	// AWS account has a different default encryption key for each AWS region.
	KmsKeyId *string `type:"string"`

	// The password for the master database user. This password can contain any
	// printable ASCII character except "/", """, or "@".
	//
	// Constraints: Must contain from 8 to 41 characters.
	MasterUserPassword *string `type:"string" required:"true"`

	// The name of the master user for the client DB cluster.
	//
	// Constraints:
	//
	//  Must be 1 to 16 alphanumeric characters. First character must be a letter.
	// Cannot be a reserved word for the chosen database engine.
	MasterUsername *string `type:"string" required:"true"`

	// A value that indicates that the DB cluster should be associated with the
	// specified option group.
	//
	// Permanent options cannot be removed from an option group. The option group
	// cannot be removed from a DB cluster once it is associated with a DB cluster.
	OptionGroupName *string `type:"string"`

	// The port number on which the instances in the DB cluster accept connections.
	//
	//  Default: 3306
	Port *int64 `type:"integer"`

	// The daily time range during which automated backups are created if automated
	// backups are enabled using the BackupRetentionPeriod parameter.
	//
	// Default: A 30-minute window selected at random from an 8-hour block of time
	// per region. To see the time blocks available, see  Adjusting the Preferred
	// Maintenance Window (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html)
	// in the Amazon RDS User Guide.
	//
	// Constraints:
	//
	//  Must be in the format hh24:mi-hh24:mi. Times should be in Universal Coordinated
	// Time (UTC). Must not conflict with the preferred maintenance window. Must
	// be at least 30 minutes.
	PreferredBackupWindow *string `type:"string"`

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	//  Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Default: A 30-minute window selected at random from an 8-hour block of time
	// per region, occurring on a random day of the week. To see the time blocks
	// available, see  Adjusting the Preferred Maintenance Window (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html)
	// in the Amazon RDS User Guide.
	//
	// Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// Specifies whether the DB cluster is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A list of EC2 VPC security groups to associate with this DB cluster.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s CreateDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterInput) GoString() string {
	return s.String()
}

type CreateDBClusterOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   CreateDBCluster   DeleteDBCluster   FailoverDBCluster   ModifyDBCluster
	//   RestoreDBClusterFromSnapshot   This data type is used as a response element
	// in the DescribeDBClusters action.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s CreateDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterOutput) GoString() string {
	return s.String()
}

type CreateDBClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster parameter group.
	//
	//  Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens  This value is
	// stored as a lowercase string.
	DBClusterParameterGroupName *string `type:"string" required:"true"`

	// The DB cluster parameter group family name. A DB cluster parameter group
	// can be associated with one and only one DB cluster parameter group family,
	// and can be applied only to a DB cluster running a database engine and engine
	// version compatible with that DB cluster parameter group family.
	DBParameterGroupFamily *string `type:"string" required:"true"`

	// The description for the DB cluster parameter group.
	Description *string `type:"string" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterParameterGroupInput) GoString() string {
	return s.String()
}

type CreateDBClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the CreateDBClusterParameterGroup
	// action.
	//
	// This data type is used as a request parameter in the DeleteDBClusterParameterGroup
	// action, and as a response element in the DescribeDBClusterParameterGroups
	// action.
	DBClusterParameterGroup *DBClusterParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CreateDBClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterParameterGroupOutput) GoString() string {
	return s.String()
}

type CreateDBClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the DB cluster to create a snapshot for. This parameter
	// is not case-sensitive.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens. First character
	// must be a letter. Cannot end with a hyphen or contain two consecutive hyphens.
	//  Example: my-cluster1
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The identifier of the DB cluster snapshot. This parameter is stored as a
	// lowercase string.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens. First character
	// must be a letter. Cannot end with a hyphen or contain two consecutive hyphens.
	//  Example: my-cluster1-snapshot1
	DBClusterSnapshotIdentifier *string `type:"string" required:"true"`

	// The tags to be assigned to the DB cluster snapshot.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterSnapshotInput) GoString() string {
	return s.String()
}

type CreateDBClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   CreateDBClusterSnapshot   DeleteDBClusterSnapshot   This data type is
	// used as a response element in the DescribeDBClusterSnapshots action.
	DBClusterSnapshot *DBClusterSnapshot `type:"structure"`
}

// String returns the string representation
func (s CreateDBClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterSnapshotOutput) GoString() string {
	return s.String()
}

type CreateDBInstanceInput struct {
	_ struct{} `type:"structure"`

	// The amount of storage (in gigabytes) to be initially allocated for the database
	// instance.
	//
	//  Type: Integer
	//
	//  MySQL
	//
	//  Constraints: Must be an integer from 5 to 6144.
	//
	//  MariaDB
	//
	//  Constraints: Must be an integer from 5 to 6144.
	//
	//  PostgreSQL
	//
	//  Constraints: Must be an integer from 5 to 6144.
	//
	//  Oracle
	//
	//  Constraints: Must be an integer from 10 to 6144.
	//
	//  SQL Server
	//
	//  Constraints: Must be an integer from 200 to 4096 (Standard Edition and
	// Enterprise Edition) or from 20 to 4096 (Express Edition and Web Edition)
	AllocatedStorage *int64 `type:"integer"`

	// Indicates that minor engine upgrades will be applied automatically to the
	// DB instance during the maintenance window.
	//
	// Default: true
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The EC2 Availability Zone that the database instance will be created in.
	// For information on regions and Availability Zones, see Regions and Availability
	// Zones (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
	//
	//  Default: A random, system-chosen Availability Zone in the endpoint's region.
	//
	//  Example: us-east-1d
	//
	//  Constraint: The AvailabilityZone parameter cannot be specified if the MultiAZ
	// parameter is set to true. The specified Availability Zone must be in the
	// same region as the current endpoint.
	AvailabilityZone *string `type:"string"`

	// The number of days for which automated backups are retained. Setting this
	// parameter to a positive number enables backups. Setting this parameter to
	// 0 disables automated backups.
	//
	//  Default: 1
	//
	// Constraints:
	//
	//  Must be a value from 0 to 35 Cannot be set to 0 if the DB instance is a
	// source to Read Replicas
	BackupRetentionPeriod *int64 `type:"integer"`

	// For supported engines, indicates that the DB instance should be associated
	// with the specified CharacterSet.
	CharacterSetName *string `type:"string"`

	// True to copy all tags from the DB instance to snapshots of the DB instance;
	// otherwise false. The default is false.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// The identifier of the DB cluster that the instance will belong to.
	//
	// For information on creating a DB cluster, see CreateDBCluster.
	//
	// Type: String
	DBClusterIdentifier *string `type:"string"`

	// The compute and memory capacity of the DB instance.
	//
	//  Valid Values: db.t1.micro | db.m1.small | db.m1.medium | db.m1.large |
	// db.m1.xlarge | db.m2.xlarge |db.m2.2xlarge | db.m2.4xlarge | db.m3.medium
	// | db.m3.large | db.m3.xlarge | db.m3.2xlarge | db.m4.large | db.m4.xlarge
	// | db.m4.2xlarge | db.m4.4xlarge | db.m4.10xlarge | db.r3.large | db.r3.xlarge
	// | db.r3.2xlarge | db.r3.4xlarge | db.r3.8xlarge | db.t2.micro | db.t2.small
	// | db.t2.medium | db.t2.large
	DBInstanceClass *string `type:"string" required:"true"`

	// The DB instance identifier. This parameter is stored as a lowercase string.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens (1 to 15 for
	// SQL Server). First character must be a letter. Cannot end with a hyphen or
	// contain two consecutive hyphens.  Example: mydbinstance
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The meaning of this parameter differs according to the database engine you
	// use.
	//
	// Type: String
	//
	//  MySQL
	//
	// The name of the database to create when the DB instance is created. If this
	// parameter is not specified, no database is created in the DB instance.
	//
	// Constraints:
	//
	//  Must contain 1 to 64 alphanumeric characters Cannot be a word reserved
	// by the specified database engine   MariaDB
	//
	// The name of the database to create when the DB instance is created. If this
	// parameter is not specified, no database is created in the DB instance.
	//
	// Constraints:
	//
	//  Must contain 1 to 64 alphanumeric characters Cannot be a word reserved
	// by the specified database engine   PostgreSQL
	//
	// The name of the database to create when the DB instance is created. If this
	// parameter is not specified, the default "postgres" database is created in
	// the DB instance.
	//
	// Constraints:
	//
	//  Must contain 1 to 63 alphanumeric characters Must begin with a letter or
	// an underscore. Subsequent characters can be letters, underscores, or digits
	// (0-9). Cannot be a word reserved by the specified database engine   Oracle
	//
	//  The Oracle System ID (SID) of the created DB instance.
	//
	// Default: ORCL
	//
	// Constraints:
	//
	//  Cannot be longer than 8 characters   SQL Server
	//
	// Not applicable. Must be null.
	//
	//  Amazon Aurora
	//
	// The name of the database to create when the primary instance of the DB cluster
	// is created. If this parameter is not specified, no database is created in
	// the DB instance.
	//
	// Constraints:
	//
	//  Must contain 1 to 64 alphanumeric characters Cannot be a word reserved
	// by the specified database engine
	DBName *string `type:"string"`

	// The name of the DB parameter group to associate with this DB instance. If
	// this argument is omitted, the default DBParameterGroup for the specified
	// engine will be used.
	//
	//  Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens
	DBParameterGroupName *string `type:"string"`

	// A list of DB security groups to associate with this DB instance.
	//
	//  Default: The default DB security group for the database engine.
	DBSecurityGroups []*string `locationNameList:"DBSecurityGroupName" type:"list"`

	// A DB subnet group to associate with this DB instance.
	//
	//  If there is no DB subnet group, then it is a non-VPC DB instance.
	DBSubnetGroupName *string `type:"string"`

	// The name of the database engine to be used for this instance.
	//
	//  Valid Values: MySQL | mariadb | oracle-se1 | oracle-se | oracle-ee | sqlserver-ee
	// | sqlserver-se | sqlserver-ex | sqlserver-web | postgres | aurora
	//
	//  Not every database engine is available for every AWS region.
	Engine *string `type:"string" required:"true"`

	// The version number of the database engine to use.
	//
	//  The following are the database engines and major and minor versions that
	// are available with Amazon RDS. Not every database engine is available for
	// every AWS region.
	//
	// MySQL
	//
	//  Version 5.1 (Only available in the following regions: ap-northeast-1, ap-southeast-1,
	// ap-southeast-2, eu-west-1, sa-east-1, us-west-1, us-west-2):  5.1.73a | 5.1.73b
	// Version 5.5 (Only available in the following regions: ap-northeast-1, ap-southeast-1,
	// ap-southeast-2, eu-west-1, sa-east-1, us-west-1, us-west-2):  5.5.40 | 5.5.40a
	// Version 5.5 (Available in all regions):  5.5.40b | 5.5.41 | 5.5.42 Version
	// 5.6 (Available in all regions):  5.6.19a | 5.6.19b | 5.6.21 | 5.6.21b | 5.6.22
	// | 5.6.23  MariaDB
	//
	//  Version 10.0 (Available in all regions except AWS GovCloud (US) Region
	// (us-gov-west-1)):  10.0.17   Oracle Database Enterprise Edition (oracle-ee)
	//
	//  Version 11.2 (Only available in the following regions: ap-northeast-1,
	// ap-southeast-1, ap-southeast-2, eu-west-1, sa-east-1, us-west-1, us-west-2):
	//  11.2.0.2.v3 | 11.2.0.2.v4 | 11.2.0.2.v5 | 11.2.0.2.v6 | 11.2.0.2.v7 Version
	// 11.2 (Available in all regions):  11.2.0.3.v1 | 11.2.0.3.v2 | 11.2.0.3.v3
	// | 11.2.0.4.v1 | 11.2.0.4.v3 | 11.2.0.4.v4 Version 12.1 (Available in all
	// regions): 12.1.0.1.v1 | 12.1.0.1.v2 | 12.1.0.2.v1   Oracle Database Standard
	// Edition (oracle-se)
	//
	//  Version 11.2 (Only available in the following regions: us-west-1):  11.2.0.2.v3
	// | 11.2.0.2.v4 | 11.2.0.2.v5 | 11.2.0.2.v6 | 11.2.0.2.v7 Version 11.2 (Only
	// available in the following regions: eu-central-1, us-west-1):  11.2.0.3.v1
	// | 11.2.0.3.v2 | 11.2.0.3.v3 | 11.2.0.4.v1 | 11.2.0.4.v3 | 11.2.0.4.v4 Version
	// 12.1 (Only available in the following regions: eu-central-1, us-west-1):
	// 12.1.0.1.v1 | 12.1.0.1.v2  Oracle Database Standard Edition One (oracle-se1)
	//
	//  Version 11.2 (Only available in the following regions: us-west-1):  11.2.0.2.v3
	// | 11.2.0.2.v4 | 11.2.0.2.v5 | 11.2.0.2.v6 | 11.2.0.2.v7 Version 11.2 (Only
	// available in the following regions: eu-central-1, us-west-1):  11.2.0.3.v1
	// | 11.2.0.3.v2 | 11.2.0.3.v3 | 11.2.0.4.v1 | 11.2.0.4.v3 | 11.2.0.4.v4 Version
	// 12.1 (Only available in the following regions: eu-central-1, us-west-1):
	//  12.1.0.1.v1 | 12.1.0.1.v2  PostgreSQL
	//
	//  Version 9.3 (Only available in the following regions: ap-northeast-1, ap-southeast-1,
	// ap-southeast-2, eu-west-1, sa-east-1, us-west-1, us-west-2):  9.3.1 | 9.3.2
	// Version 9.3 (Available in all regions):  9.3.3 | 9.3.5 | 9.3.6 | 9.3.9 |
	// 9.3.10 Version 9.4 (Available in all regions):  9.4.1 | 9.4.4 | 9.4.5  Microsoft
	// SQL Server Enterprise Edition (sqlserver-ee)
	//
	//  Version 10.50 (Available in all regions):  10.50.2789.0.v1 Version 10.50
	// (Available in all regions):  10.50.6000.34.v1 Version 11.00 (Available in
	// all regions):  11.00.2100.60.v1 Version 11.00 (Available in all regions):
	//  11.00.5058.0.v1  Microsoft SQL Server Express Edition (sqlserver-ex)
	//
	//  Version 10.50 (Available in all regions):  10.50.2789.0.v1 Version 10.50
	// (Available in all regions):  10.50.6000.34.v1 Version 11.00 (Available in
	// all regions):  11.00.2100.60.v1 Version 11.00 (Available in all regions):
	//  11.00.5058.0.v1 Version 12.00 (Available in all regions):  12.00.4422.0.v1
	//  Microsoft SQL Server Standard Edition (sqlserver-se)
	//
	//  Version 10.50 (Available in all regions):  10.50.2789.0.v1 Version 10.50
	// (Available in all regions):  10.50.6000.34.v1 Version 11.00 (Available in
	// all regions):  11.00.2100.60.v1 Version 11.00 (Available in all regions):
	//  11.00.5058.0.v1 Version 12.00 (Available in all regions):  12.00.4422.0.v1
	//  Microsoft SQL Server Web Edition (sqlserver-web)
	//
	//  Version 10.50 (Available in all regions):  10.50.2789.0.v1 Version 10.50
	// (Available in all regions):  10.50.6000.34.v1 Version 11.00 (Available in
	// all regions):  11.00.2100.60.v1 Version 11.00 (Available in all regions):
	//  11.00.5058.0.v1 Version 12.00 (Available in all regions):  12.00.4422.0.v1
	EngineVersion *string `type:"string"`

	// The amount of Provisioned IOPS (input/output operations per second) to be
	// initially allocated for the DB instance.
	//
	//  Constraints: To use PIOPS, this value must be an integer greater than 1000.
	Iops *int64 `type:"integer"`

	// The KMS key identifier for an encrypted DB instance.
	//
	// The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption
	// key. If you are creating a DB instance with the same AWS account that owns
	// the KMS encryption key used to encrypt the new DB instance, then you can
	// use the KMS key alias instead of the ARN for the KM encryption key.
	//
	// If the StorageEncrypted parameter is true, and you do not specify a value
	// for the KmsKeyId parameter, then Amazon RDS will use your default encryption
	// key. AWS KMS creates the default encryption key for your AWS account. Your
	// AWS account has a different default encryption key for each AWS region.
	KmsKeyId *string `type:"string"`

	// License model information for this DB instance.
	//
	//  Valid values: license-included | bring-your-own-license | general-public-license
	LicenseModel *string `type:"string"`

	// The password for the master database user. Can be any printable ASCII character
	// except "/", """, or "@".
	//
	// Type: String
	//
	//  MySQL
	//
	//  Constraints: Must contain from 8 to 41 characters.
	//
	//  MariaDB
	//
	//  Constraints: Must contain from 8 to 41 characters.
	//
	//  Oracle
	//
	//  Constraints: Must contain from 8 to 30 characters.
	//
	//  SQL Server
	//
	//  Constraints: Must contain from 8 to 128 characters.
	//
	//  PostgreSQL
	//
	//  Constraints: Must contain from 8 to 128 characters.
	//
	//  Amazon Aurora
	//
	//  Constraints: Must contain from 8 to 41 characters.
	MasterUserPassword *string `type:"string"`

	// The name of master user for the client DB instance.
	//
	//  MySQL
	//
	// Constraints:
	//
	//  Must be 1 to 16 alphanumeric characters. First character must be a letter.
	// Cannot be a reserved word for the chosen database engine.   MariaDB
	//
	// Constraints:
	//
	//  Must be 1 to 16 alphanumeric characters. Cannot be a reserved word for
	// the chosen database engine.  Type: String
	//
	//  Oracle
	//
	// Constraints:
	//
	//  Must be 1 to 30 alphanumeric characters. First character must be a letter.
	// Cannot be a reserved word for the chosen database engine.   SQL Server
	//
	// Constraints:
	//
	//  Must be 1 to 128 alphanumeric characters. First character must be a letter.
	// Cannot be a reserved word for the chosen database engine.   PostgreSQL
	//
	// Constraints:
	//
	//  Must be 1 to 63 alphanumeric characters. First character must be a letter.
	// Cannot be a reserved word for the chosen database engine.
	MasterUsername *string `type:"string"`

	// The interval, in seconds, between points when Enhanced Monitoring metrics
	// are collected for the DB instance. To disable collecting Enhanced Monitoring
	// metrics, specify 0. The default is 60.
	//
	// If MonitoringRoleArn is specified, then you must also set MonitoringInterval
	// to a value other than 0.
	//
	// Valid Values: 0, 1, 5, 10, 15, 30, 60
	MonitoringInterval *int64 `type:"integer"`

	// The ARN for the IAM role that permits RDS to send enhanced monitoring metrics
	// to CloudWatch Logs. For example, arn:aws:iam:123456789012:role/emaccess.
	// For information on creating a monitoring role, go to To create an IAM role
	// for Amazon RDS Enhanced Monitoring (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole).
	//
	// If MonitoringInterval is set to a value other than 0, then you must supply
	// a MonitoringRoleArn value.
	MonitoringRoleArn *string `type:"string"`

	// Specifies if the DB instance is a Multi-AZ deployment. You cannot set the
	// AvailabilityZone parameter if the MultiAZ parameter is set to true. Do not
	// set this value if you want a Multi-AZ deployment for a SQL Server DB instance.
	// Multi-AZ for SQL Server is set using the Mirroring option in an option group.
	MultiAZ *bool `type:"boolean"`

	// Indicates that the DB instance should be associated with the specified option
	// group.
	//
	//  Permanent options, such as the TDE option for Oracle Advanced Security
	// TDE, cannot be removed from an option group, and that option group cannot
	// be removed from a DB instance once it is associated with a DB instance
	OptionGroupName *string `type:"string"`

	// The port number on which the database accepts connections.
	//
	//  MySQL
	//
	//  Default: 3306
	//
	//  Valid Values: 1150-65535
	//
	// Type: Integer
	//
	//  MariaDB
	//
	//  Default: 3306
	//
	//  Valid Values: 1150-65535
	//
	// Type: Integer
	//
	//  PostgreSQL
	//
	//  Default: 5432
	//
	//  Valid Values: 1150-65535
	//
	// Type: Integer
	//
	//  Oracle
	//
	//  Default: 1521
	//
	//  Valid Values: 1150-65535
	//
	//  SQL Server
	//
	//  Default: 1433
	//
	//  Valid Values: 1150-65535 except for 1434, 3389, 47001, 49152, and 49152
	// through 49156.
	//
	//  Amazon Aurora
	//
	//  Default: 3306
	//
	//  Valid Values: 1150-65535
	//
	// Type: Integer
	Port *int64 `type:"integer"`

	// The daily time range during which automated backups are created if automated
	// backups are enabled, using the BackupRetentionPeriod parameter. For more
	// information, see DB Instance Backups (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.BackingUpAndRestoringAmazonRDSInstances.html).
	//
	//  Default: A 30-minute window selected at random from an 8-hour block of
	// time per region. To see the time blocks available, see  Adjusting the Preferred
	// Maintenance Window (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html)
	// in the Amazon RDS User Guide.
	//
	// Constraints:
	//
	//  Must be in the format hh24:mi-hh24:mi. Times should be in Universal Coordinated
	// Time (UTC). Must not conflict with the preferred maintenance window. Must
	// be at least 30 minutes.
	PreferredBackupWindow *string `type:"string"`

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC). For more information, see DB Instance Maintenance
	// (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBMaintenance.html).
	//
	//  Format: ddd:hh24:mi-ddd:hh24:mi
	//
	//  Default: A 30-minute window selected at random from an 8-hour block of
	// time per region, occurring on a random day of the week. To see the time blocks
	// available, see  Adjusting the Preferred Maintenance Window (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html)
	// in the Amazon RDS User Guide.
	//
	// Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// Specifies the accessibility options for the DB instance. A value of true
	// specifies an Internet-facing instance with a publicly resolvable DNS name,
	// which resolves to a public IP address. A value of false specifies an internal
	// instance with a DNS name that resolves to a private IP address.
	//
	//  Default: The default behavior varies depending on whether a VPC has been
	// requested or not. The following list shows the default behavior in each case.
	//
	//   Default VPC: true  VPC: false   If no DB subnet group has been specified
	// as part of the request and the PubliclyAccessible value has not been set,
	// the DB instance will be publicly accessible. If a specific DB subnet group
	// has been specified as part of the request and the PubliclyAccessible value
	// has not been set, the DB instance will be private.
	PubliclyAccessible *bool `type:"boolean"`

	// Specifies whether the DB instance is encrypted.
	//
	//  Default: false
	StorageEncrypted *bool `type:"boolean"`

	// Specifies the storage type to be associated with the DB instance.
	//
	//  Valid values: standard | gp2 | io1
	//
	//  If you specify io1, you must also include a value for the Iops parameter.
	//
	//  Default: io1 if the Iops parameter is specified; otherwise standard
	StorageType *string `type:"string"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The ARN from the Key Store with which to associate the instance for TDE encryption.
	TdeCredentialArn *string `type:"string"`

	// The password for the given ARN from the Key Store in order to access the
	// device.
	TdeCredentialPassword *string `type:"string"`

	// A list of EC2 VPC security groups to associate with this DB instance.
	//
	//  Default: The default EC2 VPC security group for the DB subnet group's VPC.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s CreateDBInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBInstanceInput) GoString() string {
	return s.String()
}

type CreateDBInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   CreateDBInstance   DeleteDBInstance   ModifyDBInstance   This data type
	// is used as a response element in the DescribeDBInstances action.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s CreateDBInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBInstanceOutput) GoString() string {
	return s.String()
}

type CreateDBInstanceReadReplicaInput struct {
	_ struct{} `type:"structure"`

	// Indicates that minor engine upgrades will be applied automatically to the
	// Read Replica during the maintenance window.
	//
	// Default: Inherits from the source DB instance
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The Amazon EC2 Availability Zone that the Read Replica will be created in.
	//
	//  Default: A random, system-chosen Availability Zone in the endpoint's region.
	//
	//  Example: us-east-1d
	AvailabilityZone *string `type:"string"`

	// True to copy all tags from the Read Replica to snapshots of the Read Replica;
	// otherwise false. The default is false.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// The compute and memory capacity of the Read Replica.
	//
	//  Valid Values: db.m1.small | db.m1.medium | db.m1.large | db.m1.xlarge |
	// db.m2.xlarge |db.m2.2xlarge | db.m2.4xlarge | db.m3.medium | db.m3.large
	// | db.m3.xlarge | db.m3.2xlarge | db.m4.large | db.m4.xlarge | db.m4.2xlarge
	// | db.m4.4xlarge | db.m4.10xlarge | db.r3.large | db.r3.xlarge | db.r3.2xlarge
	// | db.r3.4xlarge | db.r3.8xlarge | db.t2.micro | db.t2.small | db.t2.medium
	// | db.t2.large
	//
	// Default: Inherits from the source DB instance.
	DBInstanceClass *string `type:"string"`

	// The DB instance identifier of the Read Replica. This identifier is the unique
	// key that identifies a DB instance. This parameter is stored as a lowercase
	// string.
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// Specifies a DB subnet group for the DB instance. The new DB instance will
	// be created in the VPC associated with the DB subnet group. If no DB subnet
	// group is specified, then the new DB instance is not created in a VPC.
	//
	// Constraints:
	//
	//  Can only be specified if the source DB instance identifier specifies a
	// DB instance in another region. The specified DB subnet group must be in the
	// same region in which the operation is running.  All Read Replicas in one
	// region that are created from the same source DB instance must either: Specify
	// DB subnet groups from the same VPC. All these Read Replicas will be created
	// in the same VPC.Not specify a DB subnet group. All these Read Replicas will
	// be created outside of any VPC.
	DBSubnetGroupName *string `type:"string"`

	// The amount of Provisioned IOPS (input/output operations per second) to be
	// initially allocated for the DB instance.
	Iops *int64 `type:"integer"`

	// The interval, in seconds, between points when Enhanced Monitoring metrics
	// are collected for the Read Replica. To disable collecting Enhanced Monitoring
	// metrics, specify 0. The default is 60.
	//
	// If MonitoringRoleArn is specified, then you must also set MonitoringInterval
	// to a value other than 0.
	//
	// Valid Values: 0, 1, 5, 10, 15, 30, 60
	MonitoringInterval *int64 `type:"integer"`

	// The ARN for the IAM role that permits RDS to send enhanced monitoring metrics
	// to CloudWatch Logs. For example, arn:aws:iam:123456789012:role/emaccess.
	// For information on creating a monitoring role, go to To create an IAM role
	// for Amazon RDS Enhanced Monitoring (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole).
	//
	// If MonitoringInterval is set to a value other than 0, then you must supply
	// a MonitoringRoleArn value.
	MonitoringRoleArn *string `type:"string"`

	// The option group the DB instance will be associated with. If omitted, the
	// default option group for the engine specified will be used.
	OptionGroupName *string `type:"string"`

	// The port number that the DB instance uses for connections.
	//
	// Default: Inherits from the source DB instance
	//
	// Valid Values: 1150-65535
	Port *int64 `type:"integer"`

	// Specifies the accessibility options for the DB instance. A value of true
	// specifies an Internet-facing instance with a publicly resolvable DNS name,
	// which resolves to a public IP address. A value of false specifies an internal
	// instance with a DNS name that resolves to a private IP address.
	//
	//  Default: The default behavior varies depending on whether a VPC has been
	// requested or not. The following list shows the default behavior in each case.
	//
	//   Default VPC:true  VPC:false   If no DB subnet group has been specified
	// as part of the request and the PubliclyAccessible value has not been set,
	// the DB instance will be publicly accessible. If a specific DB subnet group
	// has been specified as part of the request and the PubliclyAccessible value
	// has not been set, the DB instance will be private.
	PubliclyAccessible *bool `type:"boolean"`

	// The identifier of the DB instance that will act as the source for the Read
	// Replica. Each DB instance can have up to five Read Replicas.
	//
	// Constraints:
	//
	//  Must be the identifier of an existing MySQL, MariaDB, or PostgreSQL DB
	// instance. Can specify a DB instance that is a MySQL Read Replica only if
	// the source is running MySQL 5.6. Can specify a DB instance that is a PostgreSQL
	// Read Replica only if the source is running PostgreSQL 9.3.5. The specified
	// DB instance must have automatic backups enabled, its backup retention period
	// must be greater than 0. If the source DB instance is in the same region as
	// the Read Replica, specify a valid DB instance identifier. If the source DB
	// instance is in a different region than the Read Replica, specify a valid
	// DB instance ARN. For more information, go to  Constructing a Amazon RDS Amazon
	// Resource Name (ARN) (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN).
	SourceDBInstanceIdentifier *string `type:"string" required:"true"`

	// Specifies the storage type to be associated with the Read Replica.
	//
	//  Valid values: standard | gp2 | io1
	//
	//  If you specify io1, you must also include a value for the Iops parameter.
	//
	//  Default: io1 if the Iops parameter is specified; otherwise standard
	StorageType *string `type:"string"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBInstanceReadReplicaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBInstanceReadReplicaInput) GoString() string {
	return s.String()
}

type CreateDBInstanceReadReplicaOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   CreateDBInstance   DeleteDBInstance   ModifyDBInstance   This data type
	// is used as a response element in the DescribeDBInstances action.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s CreateDBInstanceReadReplicaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBInstanceReadReplicaOutput) GoString() string {
	return s.String()
}

type CreateDBParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The DB parameter group family name. A DB parameter group can be associated
	// with one and only one DB parameter group family, and can be applied only
	// to a DB instance running a database engine and engine version compatible
	// with that DB parameter group family.
	DBParameterGroupFamily *string `type:"string" required:"true"`

	// The name of the DB parameter group.
	//
	//  Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens  This value is
	// stored as a lowercase string.
	DBParameterGroupName *string `type:"string" required:"true"`

	// The description for the DB parameter group.
	Description *string `type:"string" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBParameterGroupInput) GoString() string {
	return s.String()
}

type CreateDBParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the CreateDBParameterGroup
	// action.
	//
	// This data type is used as a request parameter in the DeleteDBParameterGroup
	// action, and as a response element in the DescribeDBParameterGroups action.
	DBParameterGroup *DBParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CreateDBParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBParameterGroupOutput) GoString() string {
	return s.String()
}

type CreateDBSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// The description for the DB security group.
	DBSecurityGroupDescription *string `type:"string" required:"true"`

	// The name for the DB security group. This value is stored as a lowercase string.
	//
	// Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens Must not be "Default"
	// Cannot contain spaces  Example: mysecuritygroup
	DBSecurityGroupName *string `type:"string" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBSecurityGroupInput) GoString() string {
	return s.String()
}

type CreateDBSecurityGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   DescribeDBSecurityGroups   AuthorizeDBSecurityGroupIngress   CreateDBSecurityGroup
	//   RevokeDBSecurityGroupIngress   This data type is used as a response element
	// in the DescribeDBSecurityGroups action.
	DBSecurityGroup *DBSecurityGroup `type:"structure"`
}

// String returns the string representation
func (s CreateDBSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBSecurityGroupOutput) GoString() string {
	return s.String()
}

type CreateDBSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The DB instance identifier. This is the unique key that identifies a DB instance.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens First character
	// must be a letter Cannot end with a hyphen or contain two consecutive hyphens
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The identifier for the DB snapshot.
	//
	// Constraints:
	//
	//  Cannot be null, empty, or blank Must contain from 1 to 255 alphanumeric
	// characters or hyphens First character must be a letter Cannot end with a
	// hyphen or contain two consecutive hyphens  Example: my-snapshot-id
	DBSnapshotIdentifier *string `type:"string" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBSnapshotInput) GoString() string {
	return s.String()
}

type CreateDBSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   CreateDBSnapshot   DeleteDBSnapshot   This data type is used as a response
	// element in the DescribeDBSnapshots action.
	DBSnapshot *DBSnapshot `type:"structure"`
}

// String returns the string representation
func (s CreateDBSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBSnapshotOutput) GoString() string {
	return s.String()
}

type CreateDBSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The description for the DB subnet group.
	DBSubnetGroupDescription *string `type:"string" required:"true"`

	// The name for the DB subnet group. This value is stored as a lowercase string.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters, periods,
	// underscores, or hyphens. Must not be default.
	//
	// Example: mySubnetgroup
	DBSubnetGroupName *string `type:"string" required:"true"`

	// The EC2 Subnet IDs for the DB subnet group.
	SubnetIds []*string `locationNameList:"SubnetIdentifier" type:"list" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBSubnetGroupInput) GoString() string {
	return s.String()
}

type CreateDBSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   CreateDBSubnetGroup   ModifyDBSubnetGroup   DescribeDBSubnetGroups   DeleteDBSubnetGroup
	//   This data type is used as a response element in the DescribeDBSubnetGroups
	// action.
	DBSubnetGroup *DBSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s CreateDBSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBSubnetGroupOutput) GoString() string {
	return s.String()
}

type CreateEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value; set to true to activate the subscription, set to false to
	// create the subscription but not active it.
	Enabled *bool `type:"boolean"`

	// A list of event categories for a SourceType that you want to subscribe to.
	// You can see a list of the categories for a given SourceType in the Events
	// (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html)
	// topic in the Amazon RDS User Guide or by using the DescribeEventCategories
	// action.
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// The Amazon Resource Name (ARN) of the SNS topic created for event notification.
	// The ARN is created by Amazon SNS when you create a topic and subscribe to
	// it.
	SnsTopicArn *string `type:"string" required:"true"`

	// The list of identifiers of the event sources for which events will be returned.
	// If not specified, then all sources are included in the response. An identifier
	// must begin with a letter and must contain only ASCII letters, digits, and
	// hyphens; it cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Constraints:
	//
	//  If SourceIds are supplied, SourceType must also be provided. If the source
	// type is a DB instance, then a DBInstanceIdentifier must be supplied. If the
	// source type is a DB security group, a DBSecurityGroupName must be supplied.
	// If the source type is a DB parameter group, a DBParameterGroupName must be
	// supplied. If the source type is a DB snapshot, a DBSnapshotIdentifier must
	// be supplied.
	SourceIds []*string `locationNameList:"SourceId" type:"list"`

	// The type of source that will be generating the events. For example, if you
	// want to be notified of events generated by a DB instance, you would set this
	// parameter to db-instance. if this value is not specified, all events are
	// returned.
	//
	// Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot
	SourceType *string `type:"string"`

	// The name of the subscription.
	//
	// Constraints: The name must be less than 255 characters.
	SubscriptionName *string `type:"string" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSubscriptionInput) GoString() string {
	return s.String()
}

type CreateEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful invocation of the DescribeEventSubscriptions
	// action.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s CreateEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSubscriptionOutput) GoString() string {
	return s.String()
}

type CreateOptionGroupInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the engine that this option group should be associated
	// with.
	EngineName *string `type:"string" required:"true"`

	// Specifies the major version of the engine that this option group should be
	// associated with.
	MajorEngineVersion *string `type:"string" required:"true"`

	// The description of the option group.
	OptionGroupDescription *string `type:"string" required:"true"`

	// Specifies the name of the option group to be created.
	//
	//  Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters or hyphens First character must
	// be a letter Cannot end with a hyphen or contain two consecutive hyphens
	// Example: myoptiongroup
	OptionGroupName *string `type:"string" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateOptionGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOptionGroupInput) GoString() string {
	return s.String()
}

type CreateOptionGroupOutput struct {
	_ struct{} `type:"structure"`

	OptionGroup *OptionGroup `type:"structure"`
}

// String returns the string representation
func (s CreateOptionGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOptionGroupOutput) GoString() string {
	return s.String()
}

// Contains the result of a successful invocation of the following actions:
//
//   CreateDBCluster   DeleteDBCluster   FailoverDBCluster   ModifyDBCluster
//   RestoreDBClusterFromSnapshot   This data type is used as a response element
// in the DescribeDBClusters action.
type DBCluster struct {
	_ struct{} `type:"structure"`

	// Specifies the allocated storage size in gigabytes (GB).
	AllocatedStorage *int64 `type:"integer"`

	// Provides the list of EC2 Availability Zones that instances in the DB cluster
	// can be created in.
	AvailabilityZones []*string `locationNameList:"AvailabilityZone" type:"list"`

	// Specifies the number of days for which automatic DB snapshots are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// If present, specifies the name of the character set that this cluster is
	// associated with.
	CharacterSetName *string `type:"string"`

	// Contains a user-supplied DB cluster identifier. This identifier is the unique
	// key that identifies a DB cluster.
	DBClusterIdentifier *string `type:"string"`

	// Provides the list of instances that make up the DB cluster.
	DBClusterMembers []*DBClusterMember `locationNameList:"DBClusterMember" type:"list"`

	// Provides the list of option group memberships for this DB cluster.
	DBClusterOptionGroupMemberships []*DBClusterOptionGroupStatus `locationNameList:"DBClusterOptionGroup" type:"list"`

	// Specifies the name of the DB cluster parameter group for the DB cluster.
	DBClusterParameterGroup *string `type:"string"`

	// Specifies information on the subnet group associated with the DB cluster,
	// including the name, description, and subnets in the subnet group.
	DBSubnetGroup *string `type:"string"`

	// Contains the name of the initial database of this DB cluster that was provided
	// at create time, if one was specified when the DB cluster was created. This
	// same name is returned for the life of the DB cluster.
	DatabaseName *string `type:"string"`

	// If StorageEncrypted is true, the region-unique, immutable identifier for
	// the encrypted DB cluster. This identifier is found in AWS CloudTrail log
	// entries whenever the KMS key for the DB cluster is accessed.
	DbClusterResourceId *string `type:"string"`

	// Specifies the earliest time to which a database can be restored with point-in-time
	// restore.
	EarliestRestorableTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Specifies the connection endpoint for the primary instance of the DB cluster.
	Endpoint *string `type:"string"`

	// Provides the name of the database engine to be used for this DB cluster.
	Engine *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string `type:"string"`

	// If StorageEncrypted is true, the KMS key identifier for the encrypted DB
	// cluster.
	KmsKeyId *string `type:"string"`

	// Specifies the latest time to which a database can be restored with point-in-time
	// restore.
	LatestRestorableTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Contains the master username for the DB cluster.
	MasterUsername *string `type:"string"`

	// Specifies the progress of the operation as a percentage.
	PercentProgress *string `type:"string"`

	// Specifies the port that the database engine is listening on.
	Port *int64 `type:"integer"`

	// Specifies the daily time range during which automated backups are created
	// if automated backups are enabled, as determined by the BackupRetentionPeriod.
	PreferredBackupWindow *string `type:"string"`

	// Specifies the weekly time range during which system maintenance can occur,
	// in Universal Coordinated Time (UTC).
	PreferredMaintenanceWindow *string `type:"string"`

	// Specifies the current state of this DB cluster.
	Status *string `type:"string"`

	// Specifies whether the DB cluster is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// Provides a list of VPC security groups that the DB cluster belongs to.
	VpcSecurityGroups []*VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroupMembership" type:"list"`
}

// String returns the string representation
func (s DBCluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBCluster) GoString() string {
	return s.String()
}

// Contains information about an instance that is part of a DB cluster.
type DBClusterMember struct {
	_ struct{} `type:"structure"`

	// Specifies the status of the DB cluster parameter group for this member of
	// the DB cluster.
	DBClusterParameterGroupStatus *string `type:"string"`

	// Specifies the instance identifier for this member of the DB cluster.
	DBInstanceIdentifier *string `type:"string"`

	// Value that is true if the cluster member is the primary instance for the
	// DB cluster and false otherwise.
	IsClusterWriter *bool `type:"boolean"`
}

// String returns the string representation
func (s DBClusterMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterMember) GoString() string {
	return s.String()
}

// Contains status information for a DB cluster option group.
type DBClusterOptionGroupStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the DB cluster option group.
	DBClusterOptionGroupName *string `type:"string"`

	// Specifies the status of the DB cluster option group.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBClusterOptionGroupStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterOptionGroupStatus) GoString() string {
	return s.String()
}

// Contains the result of a successful invocation of the CreateDBClusterParameterGroup
// action.
//
// This data type is used as a request parameter in the DeleteDBClusterParameterGroup
// action, and as a response element in the DescribeDBClusterParameterGroups
// action.
type DBClusterParameterGroup struct {
	_ struct{} `type:"structure"`

	// Provides the name of the DB cluster parameter group.
	DBClusterParameterGroupName *string `type:"string"`

	// Provides the name of the DB parameter group family that this DB cluster parameter
	// group is compatible with.
	DBParameterGroupFamily *string `type:"string"`

	// Provides the customer-specified description for this DB cluster parameter
	// group.
	Description *string `type:"string"`
}

// String returns the string representation
func (s DBClusterParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterParameterGroup) GoString() string {
	return s.String()
}

type DBClusterParameterGroupNameMessage struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster parameter group.
	//
	//  Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens  This value is
	// stored as a lowercase string.
	DBClusterParameterGroupName *string `type:"string"`
}

// String returns the string representation
func (s DBClusterParameterGroupNameMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterParameterGroupNameMessage) GoString() string {
	return s.String()
}

// Contains the result of a successful invocation of the following actions:
//
//   CreateDBClusterSnapshot   DeleteDBClusterSnapshot   This data type is
// used as a response element in the DescribeDBClusterSnapshots action.
type DBClusterSnapshot struct {
	_ struct{} `type:"structure"`

	// Specifies the allocated storage size in gigabytes (GB).
	AllocatedStorage *int64 `type:"integer"`

	// Provides the list of EC2 Availability Zones that instances in the DB cluster
	// snapshot can be restored in.
	AvailabilityZones []*string `locationNameList:"AvailabilityZone" type:"list"`

	// Specifies the time when the DB cluster was created, in Universal Coordinated
	// Time (UTC).
	ClusterCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Specifies the DB cluster identifier of the DB cluster that this DB cluster
	// snapshot was created from.
	DBClusterIdentifier *string `type:"string"`

	// Specifies the identifier for the DB cluster snapshot.
	DBClusterSnapshotIdentifier *string `type:"string"`

	// Specifies the name of the database engine.
	Engine *string `type:"string"`

	// Provides the version of the database engine for this DB cluster snapshot.
	EngineVersion *string `type:"string"`

	// If StorageEncrypted is true, the KMS key identifier for the encrypted DB
	// cluster snapshot.
	KmsKeyId *string `type:"string"`

	// Provides the license model information for this DB cluster snapshot.
	LicenseModel *string `type:"string"`

	// Provides the master username for the DB cluster snapshot.
	MasterUsername *string `type:"string"`

	// Specifies the percentage of the estimated data that has been transferred.
	PercentProgress *int64 `type:"integer"`

	// Specifies the port that the DB cluster was listening on at the time of the
	// snapshot.
	Port *int64 `type:"integer"`

	// Provides the time when the snapshot was taken, in Universal Coordinated Time
	// (UTC).
	SnapshotCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Provides the type of the DB cluster snapshot.
	SnapshotType *string `type:"string"`

	// Specifies the status of this DB cluster snapshot.
	Status *string `type:"string"`

	// Specifies whether the DB cluster snapshot is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// Provides the VPC ID associated with the DB cluster snapshot.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBClusterSnapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterSnapshot) GoString() string {
	return s.String()
}

// This data type is used as a response element in the action DescribeDBEngineVersions.
type DBEngineVersion struct {
	_ struct{} `type:"structure"`

	// The description of the database engine.
	DBEngineDescription *string `type:"string"`

	// The description of the database engine version.
	DBEngineVersionDescription *string `type:"string"`

	// The name of the DB parameter group family for the database engine.
	DBParameterGroupFamily *string `type:"string"`

	// The default character set for new instances of this engine version, if the
	// CharacterSetName parameter of the CreateDBInstance API is not specified.
	DefaultCharacterSet *CharacterSet `type:"structure"`

	// The name of the database engine.
	Engine *string `type:"string"`

	// The version number of the database engine.
	EngineVersion *string `type:"string"`

	// A list of the character sets supported by this engine for the CharacterSetName
	// parameter of the CreateDBInstance API.
	SupportedCharacterSets []*CharacterSet `locationNameList:"CharacterSet" type:"list"`

	// A list of engine versions that this database engine version can be upgraded
	// to.
	ValidUpgradeTarget []*UpgradeTarget `locationNameList:"UpgradeTarget" type:"list"`
}

// String returns the string representation
func (s DBEngineVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBEngineVersion) GoString() string {
	return s.String()
}

// Contains the result of a successful invocation of the following actions:
//
//   CreateDBInstance   DeleteDBInstance   ModifyDBInstance   This data type
// is used as a response element in the DescribeDBInstances action.
type DBInstance struct {
	_ struct{} `type:"structure"`

	// Specifies the allocated storage size specified in gigabytes.
	AllocatedStorage *int64 `type:"integer"`

	// Indicates that minor version patches are applied automatically.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// Specifies the name of the Availability Zone the DB instance is located in.
	AvailabilityZone *string `type:"string"`

	// Specifies the number of days for which automatic DB snapshots are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// The identifier of the CA certificate for this DB instance.
	CACertificateIdentifier *string `type:"string"`

	// If present, specifies the name of the character set that this instance is
	// associated with.
	CharacterSetName *string `type:"string"`

	// Specifies whether tags are copied from the DB instance to snapshots of the
	// DB instance.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// If the DB instance is a member of a DB cluster, contains the name of the
	// DB cluster that the DB instance is a member of.
	DBClusterIdentifier *string `type:"string"`

	// Contains the name of the compute and memory capacity class of the DB instance.
	DBInstanceClass *string `type:"string"`

	// Contains a user-supplied database identifier. This identifier is the unique
	// key that identifies a DB instance.
	DBInstanceIdentifier *string `type:"string"`

	// Specifies the current state of this database.
	DBInstanceStatus *string `type:"string"`

	// The meaning of this parameter differs according to the database engine you
	// use. For example, this value returns MySQL, MariaDB, or PostgreSQL information
	// when returning values from CreateDBInstanceReadReplica since Read Replicas
	// are only supported for these engines.
	//
	//  MySQL, MariaDB, SQL Server, PostgreSQL, Amazon Aurora
	//
	//  Contains the name of the initial database of this instance that was provided
	// at create time, if one was specified when the DB instance was created. This
	// same name is returned for the life of the DB instance.
	//
	// Type: String
	//
	//  Oracle
	//
	//  Contains the Oracle System ID (SID) of the created DB instance. Not shown
	// when the returned parameters do not apply to an Oracle DB instance.
	DBName *string `type:"string"`

	// Provides the list of DB parameter groups applied to this DB instance.
	DBParameterGroups []*DBParameterGroupStatus `locationNameList:"DBParameterGroup" type:"list"`

	// Provides List of DB security group elements containing only DBSecurityGroup.Name
	// and DBSecurityGroup.Status subelements.
	DBSecurityGroups []*DBSecurityGroupMembership `locationNameList:"DBSecurityGroup" type:"list"`

	// Specifies information on the subnet group associated with the DB instance,
	// including the name, description, and subnets in the subnet group.
	DBSubnetGroup *DBSubnetGroup `type:"structure"`

	// Specifies the port that the DB instance listens on. If the DB instance is
	// part of a DB cluster, this can be a different port than the DB cluster port.
	DbInstancePort *int64 `type:"integer"`

	// If StorageEncrypted is true, the region-unique, immutable identifier for
	// the encrypted DB instance. This identifier is found in AWS CloudTrail log
	// entries whenever the KMS key for the DB instance is accessed.
	DbiResourceId *string `type:"string"`

	// Specifies the connection endpoint.
	Endpoint *Endpoint `type:"structure"`

	// Provides the name of the database engine to be used for this DB instance.
	Engine *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that
	// receives the Enhanced Monitoring metrics data for the DB instance.
	EnhancedMonitoringResourceArn *string `type:"string"`

	// Provides the date and time the DB instance was created.
	InstanceCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Specifies the Provisioned IOPS (I/O operations per second) value.
	Iops *int64 `type:"integer"`

	// If StorageEncrypted is true, the KMS key identifier for the encrypted DB
	// instance.
	KmsKeyId *string `type:"string"`

	// Specifies the latest time to which a database can be restored with point-in-time
	// restore.
	LatestRestorableTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// License model information for this DB instance.
	LicenseModel *string `type:"string"`

	// Contains the master username for the DB instance.
	MasterUsername *string `type:"string"`

	// The interval, in seconds, between points when Enhanced Monitoring metrics
	// are collected for the DB instance.
	MonitoringInterval *int64 `type:"integer"`

	// The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics
	// to CloudWatch Logs.
	MonitoringRoleArn *string `type:"string"`

	// Specifies if the DB instance is a Multi-AZ deployment.
	MultiAZ *bool `type:"boolean"`

	// Provides the list of option group memberships for this DB instance.
	OptionGroupMemberships []*OptionGroupMembership `locationNameList:"OptionGroupMembership" type:"list"`

	// Specifies that changes to the DB instance are pending. This element is only
	// included when changes are pending. Specific changes are identified by subelements.
	PendingModifiedValues *PendingModifiedValues `type:"structure"`

	// Specifies the daily time range during which automated backups are created
	// if automated backups are enabled, as determined by the BackupRetentionPeriod.
	PreferredBackupWindow *string `type:"string"`

	// Specifies the weekly time range during which system maintenance can occur,
	// in Universal Coordinated Time (UTC).
	PreferredMaintenanceWindow *string `type:"string"`

	// Specifies the accessibility options for the DB instance. A value of true
	// specifies an Internet-facing instance with a publicly resolvable DNS name,
	// which resolves to a public IP address. A value of false specifies an internal
	// instance with a DNS name that resolves to a private IP address.
	//
	//  Default: The default behavior varies depending on whether a VPC has been
	// requested or not. The following list shows the default behavior in each case.
	//
	//   Default VPC:true  VPC:false   If no DB subnet group has been specified
	// as part of the request and the PubliclyAccessible value has not been set,
	// the DB instance will be publicly accessible. If a specific DB subnet group
	// has been specified as part of the request and the PubliclyAccessible value
	// has not been set, the DB instance will be private.
	PubliclyAccessible *bool `type:"boolean"`

	// Contains one or more identifiers of the Read Replicas associated with this
	// DB instance.
	ReadReplicaDBInstanceIdentifiers []*string `locationNameList:"ReadReplicaDBInstanceIdentifier" type:"list"`

	// Contains the identifier of the source DB instance if this DB instance is
	// a Read Replica.
	ReadReplicaSourceDBInstanceIdentifier *string `type:"string"`

	// If present, specifies the name of the secondary Availability Zone for a DB
	// instance with multi-AZ support.
	SecondaryAvailabilityZone *string `type:"string"`

	// The status of a Read Replica. If the instance is not a Read Replica, this
	// will be blank.
	StatusInfos []*DBInstanceStatusInfo `locationNameList:"DBInstanceStatusInfo" type:"list"`

	// Specifies whether the DB instance is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// Specifies the storage type associated with DB instance.
	StorageType *string `type:"string"`

	// The ARN from the Key Store with which the instance is associated for TDE
	// encryption.
	TdeCredentialArn *string `type:"string"`

	// Provides List of VPC security group elements that the DB instance belongs
	// to.
	VpcSecurityGroups []*VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroupMembership" type:"list"`
}

// String returns the string representation
func (s DBInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBInstance) GoString() string {
	return s.String()
}

// Provides a list of status information for a DB instance.
type DBInstanceStatusInfo struct {
	_ struct{} `type:"structure"`

	// Details of the error if there is an error for the instance. If the instance
	// is not in an error state, this value is blank.
	Message *string `type:"string"`

	// Boolean value that is true if the instance is operating normally, or false
	// if the instance is in an error state.
	Normal *bool `type:"boolean"`

	// Status of the DB instance. For a StatusType of read replica, the values can
	// be replicating, error, stopped, or terminated.
	Status *string `type:"string"`

	// This value is currently "read replication."
	StatusType *string `type:"string"`
}

// String returns the string representation
func (s DBInstanceStatusInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBInstanceStatusInfo) GoString() string {
	return s.String()
}

// Contains the result of a successful invocation of the CreateDBParameterGroup
// action.
//
// This data type is used as a request parameter in the DeleteDBParameterGroup
// action, and as a response element in the DescribeDBParameterGroups action.
type DBParameterGroup struct {
	_ struct{} `type:"structure"`

	// Provides the name of the DB parameter group family that this DB parameter
	// group is compatible with.
	DBParameterGroupFamily *string `type:"string"`

	// Provides the name of the DB parameter group.
	DBParameterGroupName *string `type:"string"`

	// Provides the customer-specified description for this DB parameter group.
	Description *string `type:"string"`
}

// String returns the string representation
func (s DBParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBParameterGroup) GoString() string {
	return s.String()
}

// Contains the result of a successful invocation of the ModifyDBParameterGroup
// or ResetDBParameterGroup action.
type DBParameterGroupNameMessage struct {
	_ struct{} `type:"structure"`

	// Provides the name of the DB parameter group.
	DBParameterGroupName *string `type:"string"`
}

// String returns the string representation
func (s DBParameterGroupNameMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBParameterGroupNameMessage) GoString() string {
	return s.String()
}

// The status of the DB parameter group.
//
// This data type is used as a response element in the following actions:
//
//   CreateDBInstance   CreateDBInstanceReadReplica   DeleteDBInstance   ModifyDBInstance
//   RebootDBInstance   RestoreDBInstanceFromDBSnapshot
type DBParameterGroupStatus struct {
	_ struct{} `type:"structure"`

	// The name of the DP parameter group.
	DBParameterGroupName *string `type:"string"`

	// The status of parameter updates.
	ParameterApplyStatus *string `type:"string"`
}

// String returns the string representation
func (s DBParameterGroupStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBParameterGroupStatus) GoString() string {
	return s.String()
}

// Contains the result of a successful invocation of the following actions:
//
//   DescribeDBSecurityGroups   AuthorizeDBSecurityGroupIngress   CreateDBSecurityGroup
//   RevokeDBSecurityGroupIngress   This data type is used as a response element
// in the DescribeDBSecurityGroups action.
type DBSecurityGroup struct {
	_ struct{} `type:"structure"`

	// Provides the description of the DB security group.
	DBSecurityGroupDescription *string `type:"string"`

	// Specifies the name of the DB security group.
	DBSecurityGroupName *string `type:"string"`

	// Contains a list of EC2SecurityGroup elements.
	EC2SecurityGroups []*EC2SecurityGroup `locationNameList:"EC2SecurityGroup" type:"list"`

	// Contains a list of IPRange elements.
	IPRanges []*IPRange `locationNameList:"IPRange" type:"list"`

	// Provides the AWS ID of the owner of a specific DB security group.
	OwnerId *string `type:"string"`

	// Provides the VpcId of the DB security group.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBSecurityGroup) GoString() string {
	return s.String()
}

// This data type is used as a response element in the following actions:
//
//   ModifyDBInstance   RebootDBInstance   RestoreDBInstanceFromDBSnapshot
//   RestoreDBInstanceToPointInTime
type DBSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The name of the DB security group.
	DBSecurityGroupName *string `type:"string"`

	// The status of the DB security group.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBSecurityGroupMembership) GoString() string {
	return s.String()
}

// Contains the result of a successful invocation of the following actions:
//
//   CreateDBSnapshot   DeleteDBSnapshot   This data type is used as a response
// element in the DescribeDBSnapshots action.
type DBSnapshot struct {
	_ struct{} `type:"structure"`

	// Specifies the allocated storage size in gigabytes (GB).
	AllocatedStorage *int64 `type:"integer"`

	// Specifies the name of the Availability Zone the DB instance was located in
	// at the time of the DB snapshot.
	AvailabilityZone *string `type:"string"`

	// Specifies the DB instance identifier of the DB instance this DB snapshot
	// was created from.
	DBInstanceIdentifier *string `type:"string"`

	// Specifies the identifier for the DB snapshot.
	DBSnapshotIdentifier *string `type:"string"`

	// Specifies whether the DB snapshot is encrypted.
	Encrypted *bool `type:"boolean"`

	// Specifies the name of the database engine.
	Engine *string `type:"string"`

	// Specifies the version of the database engine.
	EngineVersion *string `type:"string"`

	// Specifies the time when the snapshot was taken, in Universal Coordinated
	// Time (UTC).
	InstanceCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Specifies the Provisioned IOPS (I/O operations per second) value of the DB
	// instance at the time of the snapshot.
	Iops *int64 `type:"integer"`

	// If Encrypted is true, the KMS key identifier for the encrypted DB snapshot.
	KmsKeyId *string `type:"string"`

	// License model information for the restored DB instance.
	LicenseModel *string `type:"string"`

	// Provides the master username for the DB snapshot.
	MasterUsername *string `type:"string"`

	// Provides the option group name for the DB snapshot.
	OptionGroupName *string `type:"string"`

	// The percentage of the estimated data that has been transferred.
	PercentProgress *int64 `type:"integer"`

	// Specifies the port that the database engine was listening on at the time
	// of the snapshot.
	Port *int64 `type:"integer"`

	// Provides the time when the snapshot was taken, in Universal Coordinated Time
	// (UTC).
	SnapshotCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Provides the type of the DB snapshot.
	SnapshotType *string `type:"string"`

	// The DB snapshot Arn that the DB snapshot was copied from. It only has value
	// in case of cross customer or cross region copy.
	SourceDBSnapshotIdentifier *string `type:"string"`

	// The region that the DB snapshot was created in or copied from.
	SourceRegion *string `type:"string"`

	// Specifies the status of this DB snapshot.
	Status *string `type:"string"`

	// Specifies the storage type associated with DB Snapshot.
	StorageType *string `type:"string"`

	// The ARN from the Key Store with which to associate the instance for TDE encryption.
	TdeCredentialArn *string `type:"string"`

	// Provides the VPC ID associated with the DB snapshot.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBSnapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBSnapshot) GoString() string {
	return s.String()
}

// Contains the name and values of a manual DB snapshot attribute
//
// Manual DB snapshot attributes are used to authorize other AWS accounts to
// restore a manual DB snapshot. For more information, see the ModifyDBSnapshotAttribute
// API.
type DBSnapshotAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the manual DB snapshot attribute.
	//
	// An attribute name of restore applies to the list of AWS accounts that have
	// permission to copy or restore the manual DB snapshot.
	AttributeName *string `type:"string"`

	// The value(s) for the manual DB snapshot attribute.
	//
	// If the AttributeName field is restore, then this field returns a list of
	// AWS account ids that are authorized to copy or restore the manual DB snapshot.
	// If a value of all is in the list, then the manual DB snapshot is public and
	// available for any AWS account to copy or restore.
	AttributeValues []*string `locationNameList:"AttributeValue" type:"list"`
}

// String returns the string representation
func (s DBSnapshotAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBSnapshotAttribute) GoString() string {
	return s.String()
}

// Contains the results of a successful call to the DescribeDBSnapshotAttributes
// API.
//
// Manual DB snapshot attributes are used to authorize other AWS accounts to
// copy or restore a manual DB snapshot. For more information, see the ModifyDBSnapshotAttribute
// API.
type DBSnapshotAttributesResult struct {
	_ struct{} `type:"structure"`

	// The list of attributes and values for the manual DB snapshot.
	DBSnapshotAttributes []*DBSnapshotAttribute `locationNameList:"DBSnapshotAttribute" type:"list"`

	// The identifier of the manual DB snapshot that the attributes apply to.
	DBSnapshotIdentifier *string `type:"string"`
}

// String returns the string representation
func (s DBSnapshotAttributesResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBSnapshotAttributesResult) GoString() string {
	return s.String()
}

// Contains the result of a successful invocation of the following actions:
//
//   CreateDBSubnetGroup   ModifyDBSubnetGroup   DescribeDBSubnetGroups   DeleteDBSubnetGroup
//   This data type is used as a response element in the DescribeDBSubnetGroups
// action.
type DBSubnetGroup struct {
	_ struct{} `type:"structure"`

	// Provides the description of the DB subnet group.
	DBSubnetGroupDescription *string `type:"string"`

	// Specifies the name of the DB subnet group.
	DBSubnetGroupName *string `type:"string"`

	// Provides the status of the DB subnet group.
	SubnetGroupStatus *string `type:"string"`

	// Contains a list of Subnet elements.
	Subnets []*Subnet `locationNameList:"Subnet" type:"list"`

	// Provides the VpcId of the DB subnet group.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBSubnetGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBSubnetGroup) GoString() string {
	return s.String()
}

type DeleteDBClusterInput struct {
	_ struct{} `type:"structure"`

	// The DB cluster identifier for the DB cluster to be deleted. This parameter
	// isn't case-sensitive.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens First character
	// must be a letter Cannot end with a hyphen or contain two consecutive hyphens
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The DB cluster snapshot identifier of the new DB cluster snapshot created
	// when SkipFinalSnapshot is set to false.
	//
	//  Specifying this parameter and also setting the SkipFinalShapshot parameter
	// to true results in an error.  Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens
	FinalDBSnapshotIdentifier *string `type:"string"`

	// Determines whether a final DB cluster snapshot is created before the DB cluster
	// is deleted. If true is specified, no DB cluster snapshot is created. If false
	// is specified, a DB cluster snapshot is created before the DB cluster is deleted.
	//
	// You must specify a FinalDBSnapshotIdentifier parameter if SkipFinalSnapshot
	// is false. Default: false
	SkipFinalSnapshot *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterInput) GoString() string {
	return s.String()
}

type DeleteDBClusterOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   CreateDBCluster   DeleteDBCluster   FailoverDBCluster   ModifyDBCluster
	//   RestoreDBClusterFromSnapshot   This data type is used as a response element
	// in the DescribeDBClusters action.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s DeleteDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterOutput) GoString() string {
	return s.String()
}

type DeleteDBClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster parameter group.
	//
	// Constraints:
	//
	//  Must be the name of an existing DB cluster parameter group. You cannot
	// delete a default DB cluster parameter group. Cannot be associated with any
	// DB clusters.
	DBClusterParameterGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterParameterGroupInput) GoString() string {
	return s.String()
}

type DeleteDBClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDBClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterParameterGroupOutput) GoString() string {
	return s.String()
}

type DeleteDBClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the DB cluster snapshot to delete.
	//
	// Constraints: Must be the name of an existing DB cluster snapshot in the
	// available state.
	DBClusterSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterSnapshotInput) GoString() string {
	return s.String()
}

type DeleteDBClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   CreateDBClusterSnapshot   DeleteDBClusterSnapshot   This data type is
	// used as a response element in the DescribeDBClusterSnapshots action.
	DBClusterSnapshot *DBClusterSnapshot `type:"structure"`
}

// String returns the string representation
func (s DeleteDBClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterSnapshotOutput) GoString() string {
	return s.String()
}

type DeleteDBInstanceInput struct {
	_ struct{} `type:"structure"`

	// The DB instance identifier for the DB instance to be deleted. This parameter
	// isn't case-sensitive.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens First character
	// must be a letter Cannot end with a hyphen or contain two consecutive hyphens
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The DBSnapshotIdentifier of the new DBSnapshot created when SkipFinalSnapshot
	// is set to false.
	//
	//  Specifying this parameter and also setting the SkipFinalShapshot parameter
	// to true results in an error.  Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens Cannot be specified
	// when deleting a Read Replica.
	FinalDBSnapshotIdentifier *string `type:"string"`

	// Determines whether a final DB snapshot is created before the DB instance
	// is deleted. If true is specified, no DBSnapshot is created. If false is specified,
	// a DB snapshot is created before the DB instance is deleted.
	//
	// Note that when a DB instance is in a failure state and has a status of 'failed',
	// 'incompatible-restore', or 'incompatible-network', it can only be deleted
	// when the SkipFinalSnapshot parameter is set to "true".
	//
	// Specify true when deleting a Read Replica.
	//
	// The FinalDBSnapshotIdentifier parameter must be specified if SkipFinalSnapshot
	// is false. Default: false
	SkipFinalSnapshot *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteDBInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBInstanceInput) GoString() string {
	return s.String()
}

type DeleteDBInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   CreateDBInstance   DeleteDBInstance   ModifyDBInstance   This data type
	// is used as a response element in the DescribeDBInstances action.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s DeleteDBInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBInstanceOutput) GoString() string {
	return s.String()
}

type DeleteDBParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB parameter group.
	//
	// Constraints:
	//
	//  Must be the name of an existing DB parameter group You cannot delete a
	// default DB parameter group Cannot be associated with any DB instances
	DBParameterGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBParameterGroupInput) GoString() string {
	return s.String()
}

type DeleteDBParameterGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDBParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBParameterGroupOutput) GoString() string {
	return s.String()
}

type DeleteDBSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB security group to delete.
	//
	// You cannot delete the default DB security group.  Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens Must not be "Default"
	// Cannot contain spaces
	DBSecurityGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBSecurityGroupInput) GoString() string {
	return s.String()
}

type DeleteDBSecurityGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDBSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBSecurityGroupOutput) GoString() string {
	return s.String()
}

type DeleteDBSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The DBSnapshot identifier.
	//
	// Constraints: Must be the name of an existing DB snapshot in the available
	// state.
	DBSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBSnapshotInput) GoString() string {
	return s.String()
}

type DeleteDBSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   CreateDBSnapshot   DeleteDBSnapshot   This data type is used as a response
	// element in the DescribeDBSnapshots action.
	DBSnapshot *DBSnapshot `type:"structure"`
}

// String returns the string representation
func (s DeleteDBSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBSnapshotOutput) GoString() string {
	return s.String()
}

type DeleteDBSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the database subnet group to delete.
	//
	// You cannot delete the default subnet group.  Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens
	DBSubnetGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBSubnetGroupInput) GoString() string {
	return s.String()
}

type DeleteDBSubnetGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDBSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBSubnetGroupOutput) GoString() string {
	return s.String()
}

type DeleteEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The name of the RDS event notification subscription you want to delete.
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSubscriptionInput) GoString() string {
	return s.String()
}

type DeleteEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful invocation of the DescribeEventSubscriptions
	// action.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s DeleteEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSubscriptionOutput) GoString() string {
	return s.String()
}

type DeleteOptionGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the option group to be deleted.
	//
	// You cannot delete default option groups.
	OptionGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteOptionGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOptionGroupInput) GoString() string {
	return s.String()
}

type DeleteOptionGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteOptionGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOptionGroupOutput) GoString() string {
	return s.String()
}

type DescribeAccountAttributesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeAccountAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAttributesInput) GoString() string {
	return s.String()
}

// Data returned by the DescribeAccountAttributes action.
type DescribeAccountAttributesOutput struct {
	_ struct{} `type:"structure"`

	// A list of AccountQuota objects. Within this list, each quota has a name,
	// a count of usage toward the quota maximum, and a maximum value for the quota.
	AccountQuotas []*AccountQuota `locationNameList:"AccountQuota" type:"list"`
}

// String returns the string representation
func (s DescribeAccountAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAttributesOutput) GoString() string {
	return s.String()
}

type DescribeCertificatesInput struct {
	_ struct{} `type:"structure"`

	// The user-supplied certificate identifier. If this parameter is specified,
	// information for only the identified certificate is returned. This parameter
	// isn't case-sensitive.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens First character
	// must be a letter Cannot end with a hyphen or contain two consecutive hyphens
	CertificateIdentifier *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeCertificates
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificatesInput) GoString() string {
	return s.String()
}

// Data returned by the DescribeCertificates action.
type DescribeCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// The list of Certificate objects for the AWS account.
	Certificates []*Certificate `locationNameList:"Certificate" type:"list"`

	// An optional pagination token provided by a previous DescribeCertificates
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords .
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificatesOutput) GoString() string {
	return s.String()
}

type DescribeDBClusterParameterGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific DB cluster parameter group to return details for.
	//
	// Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens
	DBClusterParameterGroupName *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBClusterParameterGroups
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBClusterParameterGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterParameterGroupsInput) GoString() string {
	return s.String()
}

type DescribeDBClusterParameterGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of DB cluster parameter groups.
	DBClusterParameterGroups []*DBClusterParameterGroup `locationNameList:"DBClusterParameterGroup" type:"list"`

	// An optional pagination token provided by a previous DescribeDBClusterParameterGroups
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClusterParameterGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterParameterGroupsOutput) GoString() string {
	return s.String()
}

type DescribeDBClusterParametersInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific DB cluster parameter group to return parameter details
	// for.
	//
	// Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens
	DBClusterParameterGroupName *string `type:"string" required:"true"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBClusterParameters
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// A value that indicates to return only parameters for a specific source. Parameter
	// sources can be engine, service, or customer.
	Source *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClusterParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterParametersInput) GoString() string {
	return s.String()
}

// Provides details about a DB cluster parameter group including the parameters
// in the DB cluster parameter group.
type DescribeDBClusterParametersOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous DescribeDBClusterParameters
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords .
	Marker *string `type:"string"`

	// Provides a list of parameters for the DB cluster parameter group.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s DescribeDBClusterParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterParametersOutput) GoString() string {
	return s.String()
}

type DescribeDBClusterSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// A DB cluster identifier to retrieve the list of DB cluster snapshots for.
	// This parameter cannot be used in conjunction with the DBClusterSnapshotIdentifier
	// parameter. This parameter is not case-sensitive.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens First character
	// must be a letter Cannot end with a hyphen or contain two consecutive hyphens
	DBClusterIdentifier *string `type:"string"`

	// A specific DB cluster snapshot identifier to describe. This parameter cannot
	// be used in conjunction with the DBClusterIdentifier parameter. This value
	// is stored as a lowercase string.
	//
	// Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens If this is the
	// identifier of an automated snapshot, the SnapshotType parameter must also
	// be specified.
	DBClusterSnapshotIdentifier *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBClusterSnapshots
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The type of DB cluster snapshots that will be returned. Values can be automated
	// or manual. If this parameter is not specified, the returned results will
	// include all snapshot types.
	SnapshotType *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClusterSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterSnapshotsInput) GoString() string {
	return s.String()
}

// Provides a list of DB cluster snapshots for the user as the result of a call
// to the DescribeDBClusterSnapshots action.
type DescribeDBClusterSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// Provides a list of DB cluster snapshots for the user.
	DBClusterSnapshots []*DBClusterSnapshot `locationNameList:"DBClusterSnapshot" type:"list"`

	// An optional pagination token provided by a previous DescribeDBClusterSnapshots
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClusterSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterSnapshotsOutput) GoString() string {
	return s.String()
}

type DescribeDBClustersInput struct {
	_ struct{} `type:"structure"`

	// The user-supplied DB cluster identifier. If this parameter is specified,
	// information from only the specific DB cluster is returned. This parameter
	// isn't case-sensitive.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens First character
	// must be a letter Cannot end with a hyphen or contain two consecutive hyphens
	DBClusterIdentifier *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBClusters request.
	// If this parameter is specified, the response includes only records beyond
	// the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClustersInput) GoString() string {
	return s.String()
}

// Contains the result of a successful invocation of the DescribeDBClusters
// action.
type DescribeDBClustersOutput struct {
	_ struct{} `type:"structure"`

	// Contains a list of DB clusters for the user.
	DBClusters []*DBCluster `locationNameList:"DBCluster" type:"list"`

	// A pagination token that can be used in a subsequent DescribeDBClusters request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClustersOutput) GoString() string {
	return s.String()
}

type DescribeDBEngineVersionsInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific DB parameter group family to return details for.
	//
	// Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens
	DBParameterGroupFamily *string `type:"string"`

	// Indicates that only the default version of the specified engine or engine
	// and major version combination is returned.
	DefaultOnly *bool `type:"boolean"`

	// The database engine to return.
	Engine *string `type:"string"`

	// The database engine version to return.
	//
	// Example: 5.1.49
	EngineVersion *string `type:"string"`

	// Not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// If this parameter is specified, and if the requested engine supports the
	// CharacterSetName parameter for CreateDBInstance, the response includes a
	// list of supported character sets for each engine version.
	ListSupportedCharacterSets *bool `type:"boolean"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more than the
	// MaxRecords value is available, a pagination token called a marker is included
	// in the response so that the following results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBEngineVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBEngineVersionsInput) GoString() string {
	return s.String()
}

// Contains the result of a successful invocation of the DescribeDBEngineVersions
// action.
type DescribeDBEngineVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of DBEngineVersion elements.
	DBEngineVersions []*DBEngineVersion `locationNameList:"DBEngineVersion" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBEngineVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBEngineVersionsOutput) GoString() string {
	return s.String()
}

type DescribeDBInstancesInput struct {
	_ struct{} `type:"structure"`

	// The user-supplied instance identifier. If this parameter is specified, information
	// from only the specific DB instance is returned. This parameter isn't case-sensitive.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens First character
	// must be a letter Cannot end with a hyphen or contain two consecutive hyphens
	DBInstanceIdentifier *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBInstances request.
	// If this parameter is specified, the response includes only records beyond
	// the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBInstancesInput) GoString() string {
	return s.String()
}

// Contains the result of a successful invocation of the DescribeDBInstances
// action.
type DescribeDBInstancesOutput struct {
	_ struct{} `type:"structure"`

	// A list of DBInstance instances.
	DBInstances []*DBInstance `locationNameList:"DBInstance" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords .
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBInstancesOutput) GoString() string {
	return s.String()
}

// This data type is used as a response element to DescribeDBLogFiles.
type DescribeDBLogFilesDetails struct {
	_ struct{} `type:"structure"`

	// A POSIX timestamp when the last log entry was written.
	LastWritten *int64 `type:"long"`

	// The name of the log file for the specified DB instance.
	LogFileName *string `type:"string"`

	// The size, in bytes, of the log file for the specified DB instance.
	Size *int64 `type:"long"`
}

// String returns the string representation
func (s DescribeDBLogFilesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBLogFilesDetails) GoString() string {
	return s.String()
}

type DescribeDBLogFilesInput struct {
	_ struct{} `type:"structure"`

	// The customer-assigned name of the DB instance that contains the log files
	// you want to list.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens First character
	// must be a letter Cannot end with a hyphen or contain two consecutive hyphens
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// Filters the available log files for files written since the specified date,
	// in POSIX timestamp format with milliseconds.
	FileLastWritten *int64 `type:"long"`

	// Filters the available log files for files larger than the specified size.
	FileSize *int64 `type:"long"`

	// Filters the available log files for log file names that contain the specified
	// string.
	FilenameContains *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// The pagination token provided in the previous request. If this parameter
	// is specified the response includes only records beyond the marker, up to
	// MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBLogFilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBLogFilesInput) GoString() string {
	return s.String()
}

// The response from a call to DescribeDBLogFiles.
type DescribeDBLogFilesOutput struct {
	_ struct{} `type:"structure"`

	// The DB log files returned.
	DescribeDBLogFiles []*DescribeDBLogFilesDetails `locationNameList:"DescribeDBLogFilesDetails" type:"list"`

	// A pagination token that can be used in a subsequent DescribeDBLogFiles request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBLogFilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBLogFilesOutput) GoString() string {
	return s.String()
}

type DescribeDBParameterGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific DB parameter group to return details for.
	//
	// Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens
	DBParameterGroupName *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBParameterGroups
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBParameterGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBParameterGroupsInput) GoString() string {
	return s.String()
}

// Contains the result of a successful invocation of the DescribeDBParameterGroups
// action.
type DescribeDBParameterGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of DBParameterGroup instances.
	DBParameterGroups []*DBParameterGroup `locationNameList:"DBParameterGroup" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBParameterGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBParameterGroupsOutput) GoString() string {
	return s.String()
}

type DescribeDBParametersInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific DB parameter group to return details for.
	//
	// Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens
	DBParameterGroupName *string `type:"string" required:"true"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBParameters
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The parameter types to return.
	//
	// Default: All parameter types returned
	//
	// Valid Values: user | system | engine-default
	Source *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBParametersInput) GoString() string {
	return s.String()
}

// Contains the result of a successful invocation of the DescribeDBParameters
// action.
type DescribeDBParametersOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// A list of Parameter values.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s DescribeDBParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBParametersOutput) GoString() string {
	return s.String()
}

type DescribeDBSecurityGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB security group to return details for.
	DBSecurityGroupName *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBSecurityGroups
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBSecurityGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBSecurityGroupsInput) GoString() string {
	return s.String()
}

// Contains the result of a successful invocation of the DescribeDBSecurityGroups
// action.
type DescribeDBSecurityGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of DBSecurityGroup instances.
	DBSecurityGroups []*DBSecurityGroup `locationNameList:"DBSecurityGroup" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBSecurityGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBSecurityGroupsOutput) GoString() string {
	return s.String()
}

type DescribeDBSnapshotAttributesInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the DB snapshot to modify the attributes for.
	DBSnapshotIdentifier *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBSnapshotAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBSnapshotAttributesInput) GoString() string {
	return s.String()
}

type DescribeDBSnapshotAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful call to the DescribeDBSnapshotAttributes
	// API.
	//
	// Manual DB snapshot attributes are used to authorize other AWS accounts to
	// copy or restore a manual DB snapshot. For more information, see the ModifyDBSnapshotAttribute
	// API.
	DBSnapshotAttributesResult *DBSnapshotAttributesResult `type:"structure"`
}

// String returns the string representation
func (s DescribeDBSnapshotAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBSnapshotAttributesOutput) GoString() string {
	return s.String()
}

type DescribeDBSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// A DB instance identifier to retrieve the list of DB snapshots for. This parameter
	// cannot be used in conjunction with DBSnapshotIdentifier. This parameter is
	// not case-sensitive.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens First character
	// must be a letter Cannot end with a hyphen or contain two consecutive hyphens
	DBInstanceIdentifier *string `type:"string"`

	// A specific DB snapshot identifier to describe. This parameter cannot be used
	// in conjunction with DBInstanceIdentifier. This value is stored as a lowercase
	// string.
	//
	// Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters. First character must be a letter.
	// Cannot end with a hyphen or contain two consecutive hyphens. If this is the
	// identifier of an automated snapshot, the SnapshotType parameter must also
	// be specified.
	DBSnapshotIdentifier *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// True to include manual DB snapshots that are public and can be copied or
	// restored by any AWS account; otherwise false. The default is false.
	//
	// An manual DB snapshot is shared as public by the ModifyDBSnapshotAttribute
	// API.
	IncludePublic *bool `type:"boolean"`

	// True to include shared manual DB snapshots from other AWS accounts that this
	// AWS account has been given permission to copy or restore; otherwise false.
	// The default is false.
	//
	// An AWS account is given permission to restore a manual DB snapshot from
	// another AWS account by the ModifyDBSnapshotAttribute API.
	IncludeShared *bool `type:"boolean"`

	// An optional pagination token provided by a previous DescribeDBSnapshots request.
	// If this parameter is specified, the response includes only records beyond
	// the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The type of snapshots that will be returned. You can specify one of the following
	// values:
	//
	//  automated - Return all DB snapshots that have been automatically taken
	// by Amazon RDS for my AWS account. manual - Return all DB snapshots that have
	// been taken by my AWS account. shared - Return all manual DB snapshots that
	// have been shared to my AWS account. public - Return all DB snapshots that
	// have been marked as public.  If you do not specify a SnapshotType, then both
	// automated and manual snapshots are returned. You can include shared snapshots
	// with these results by setting the IncludeShared parameter to true. You can
	// include public snapshots with these results by setting the IncludePublic
	// parameter to true.
	//
	// The IncludeShared and IncludePublic parameters do not apply for SnapshotType
	// values of manual or automated. The IncludePublic parameter does not apply
	// when SnapshotType is set to shared. the IncludeShared parameter does not
	// apply when SnapshotType is set to public.
	SnapshotType *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBSnapshotsInput) GoString() string {
	return s.String()
}

// Contains the result of a successful invocation of the DescribeDBSnapshots
// action.
type DescribeDBSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// A list of DBSnapshot instances.
	DBSnapshots []*DBSnapshot `locationNameList:"DBSnapshot" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBSnapshotsOutput) GoString() string {
	return s.String()
}

type DescribeDBSubnetGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB subnet group to return details for.
	DBSubnetGroupName *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBSubnetGroups
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBSubnetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBSubnetGroupsInput) GoString() string {
	return s.String()
}

// Contains the result of a successful invocation of the DescribeDBSubnetGroups
// action.
type DescribeDBSubnetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of DBSubnetGroup instances.
	DBSubnetGroups []*DBSubnetGroup `locationNameList:"DBSubnetGroup" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBSubnetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBSubnetGroupsOutput) GoString() string {
	return s.String()
}

type DescribeEngineDefaultClusterParametersInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster parameter group family to return engine parameter
	// information for.
	DBParameterGroupFamily *string `type:"string" required:"true"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeEngineDefaultClusterParameters
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeEngineDefaultClusterParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEngineDefaultClusterParametersInput) GoString() string {
	return s.String()
}

type DescribeEngineDefaultClusterParametersOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the DescribeEngineDefaultParameters
	// action.
	EngineDefaults *EngineDefaults `type:"structure"`
}

// String returns the string representation
func (s DescribeEngineDefaultClusterParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEngineDefaultClusterParametersOutput) GoString() string {
	return s.String()
}

type DescribeEngineDefaultParametersInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB parameter group family.
	DBParameterGroupFamily *string `type:"string" required:"true"`

	// Not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeEngineDefaultParameters
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeEngineDefaultParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEngineDefaultParametersInput) GoString() string {
	return s.String()
}

type DescribeEngineDefaultParametersOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the DescribeEngineDefaultParameters
	// action.
	EngineDefaults *EngineDefaults `type:"structure"`
}

// String returns the string representation
func (s DescribeEngineDefaultParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEngineDefaultParametersOutput) GoString() string {
	return s.String()
}

type DescribeEventCategoriesInput struct {
	_ struct{} `type:"structure"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// The type of source that will be generating the events.
	//
	// Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventCategoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventCategoriesInput) GoString() string {
	return s.String()
}

// Data returned from the DescribeEventCategories action.
type DescribeEventCategoriesOutput struct {
	_ struct{} `type:"structure"`

	// A list of EventCategoriesMap data types.
	EventCategoriesMapList []*EventCategoriesMap `locationNameList:"EventCategoriesMap" type:"list"`
}

// String returns the string representation
func (s DescribeEventCategoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventCategoriesOutput) GoString() string {
	return s.String()
}

type DescribeEventSubscriptionsInput struct {
	_ struct{} `type:"structure"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords .
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of the RDS event notification subscription you want to describe.
	SubscriptionName *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventSubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventSubscriptionsInput) GoString() string {
	return s.String()
}

// Data returned by the DescribeEventSubscriptions action.
type DescribeEventSubscriptionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of EventSubscriptions data types.
	EventSubscriptionsList []*EventSubscription `locationNameList:"EventSubscription" type:"list"`

	// An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventSubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventSubscriptionsOutput) GoString() string {
	return s.String()
}

type DescribeEventsInput struct {
	_ struct{} `type:"structure"`

	// The number of minutes to retrieve events for.
	//
	// Default: 60
	Duration *int64 `type:"integer"`

	// The end of the time interval for which to retrieve events, specified in ISO
	// 8601 format. For more information about ISO 8601, go to the ISO8601 Wikipedia
	// page. (http://en.wikipedia.org/wiki/ISO_8601)
	//
	// Example: 2009-07-08T18:00Z
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A list of event categories that trigger notifications for a event notification
	// subscription.
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeEvents request.
	// If this parameter is specified, the response includes only records beyond
	// the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The identifier of the event source for which events will be returned. If
	// not specified, then all sources are included in the response.
	//
	// Constraints:
	//
	//  If SourceIdentifier is supplied, SourceType must also be provided. If the
	// source type is DBInstance, then a DBInstanceIdentifier must be supplied.
	// If the source type is DBSecurityGroup, a DBSecurityGroupName must be supplied.
	// If the source type is DBParameterGroup, a DBParameterGroupName must be supplied.
	// If the source type is DBSnapshot, a DBSnapshotIdentifier must be supplied.
	// Cannot end with a hyphen or contain two consecutive hyphens.
	SourceIdentifier *string `type:"string"`

	// The event source to retrieve events for. If no value is specified, all events
	// are returned.
	SourceType *string `type:"string" enum:"SourceType"`

	// The beginning of the time interval to retrieve events for, specified in ISO
	// 8601 format. For more information about ISO 8601, go to the ISO8601 Wikipedia
	// page. (http://en.wikipedia.org/wiki/ISO_8601)
	//
	// Example: 2009-07-08T18:00Z
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s DescribeEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsInput) GoString() string {
	return s.String()
}

// Contains the result of a successful invocation of the DescribeEvents action.
type DescribeEventsOutput struct {
	_ struct{} `type:"structure"`

	// A list of Event instances.
	Events []*Event `locationNameList:"Event" type:"list"`

	// An optional pagination token provided by a previous Events request. If this
	// parameter is specified, the response includes only records beyond the marker,
	// up to the value specified by MaxRecords .
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsOutput) GoString() string {
	return s.String()
}

type DescribeOptionGroupOptionsInput struct {
	_ struct{} `type:"structure"`

	// A required parameter. Options available for the given engine name will be
	// described.
	EngineName *string `type:"string" required:"true"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// If specified, filters the results to include only options for the specified
	// major engine version.
	MajorEngineVersion *string `type:"string"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeOptionGroupOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOptionGroupOptionsInput) GoString() string {
	return s.String()
}

type DescribeOptionGroupOptionsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// List of available option group options.
	OptionGroupOptions []*OptionGroupOption `locationNameList:"OptionGroupOption" type:"list"`
}

// String returns the string representation
func (s DescribeOptionGroupOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOptionGroupOptionsOutput) GoString() string {
	return s.String()
}

type DescribeOptionGroupsInput struct {
	_ struct{} `type:"structure"`

	// Filters the list of option groups to only include groups associated with
	// a specific database engine.
	EngineName *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// Filters the list of option groups to only include groups associated with
	// a specific database engine version. If specified, then EngineName must also
	// be specified.
	MajorEngineVersion *string `type:"string"`

	// An optional pagination token provided by a previous DescribeOptionGroups
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of the option group to describe. Cannot be supplied together with
	// EngineName or MajorEngineVersion.
	OptionGroupName *string `type:"string"`
}

// String returns the string representation
func (s DescribeOptionGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOptionGroupsInput) GoString() string {
	return s.String()
}

// List of option groups.
type DescribeOptionGroupsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// List of option groups.
	OptionGroupsList []*OptionGroup `locationNameList:"OptionGroup" type:"list"`
}

// String returns the string representation
func (s DescribeOptionGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOptionGroupsOutput) GoString() string {
	return s.String()
}

type DescribeOrderableDBInstanceOptionsInput struct {
	_ struct{} `type:"structure"`

	// The DB instance class filter value. Specify this parameter to show only the
	// available offerings matching the specified DB instance class.
	DBInstanceClass *string `type:"string"`

	// The name of the engine to retrieve DB instance options for.
	Engine *string `type:"string" required:"true"`

	// The engine version filter value. Specify this parameter to show only the
	// available offerings matching the specified engine version.
	EngineVersion *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// The license model filter value. Specify this parameter to show only the available
	// offerings matching the specified license model.
	LicenseModel *string `type:"string"`

	// An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords .
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The VPC filter value. Specify this parameter to show only the available VPC
	// or non-VPC offerings.
	Vpc *bool `type:"boolean"`
}

// String returns the string representation
func (s DescribeOrderableDBInstanceOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrderableDBInstanceOptionsInput) GoString() string {
	return s.String()
}

// Contains the result of a successful invocation of the DescribeOrderableDBInstanceOptions
// action.
type DescribeOrderableDBInstanceOptionsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous OrderableDBInstanceOptions
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords .
	Marker *string `type:"string"`

	// An OrderableDBInstanceOption structure containing information about orderable
	// options for the DB instance.
	OrderableDBInstanceOptions []*OrderableDBInstanceOption `locationNameList:"OrderableDBInstanceOption" type:"list"`
}

// String returns the string representation
func (s DescribeOrderableDBInstanceOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrderableDBInstanceOptionsOutput) GoString() string {
	return s.String()
}

type DescribePendingMaintenanceActionsInput struct {
	_ struct{} `type:"structure"`

	// A filter that specifies one or more resources to return pending maintenance
	// actions for.
	//
	// Supported filters:
	//
	//   db-instance-id - Accepts DB instance identifiers and DB instance Amazon
	// Resource Names (ARNs). The results list will only include pending maintenance
	// actions for the DB instances identified by these ARNs.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribePendingMaintenanceActions
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to a number of records specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The ARN of a resource to return pending maintenance actions for.
	ResourceIdentifier *string `type:"string"`
}

// String returns the string representation
func (s DescribePendingMaintenanceActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePendingMaintenanceActionsInput) GoString() string {
	return s.String()
}

// Data returned from the DescribePendingMaintenanceActions action.
type DescribePendingMaintenanceActionsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous DescribePendingMaintenanceActions
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to a number of records specified by MaxRecords.
	Marker *string `type:"string"`

	// A list of the pending maintenance actions for the resource.
	PendingMaintenanceActions []*ResourcePendingMaintenanceActions `locationNameList:"ResourcePendingMaintenanceActions" type:"list"`
}

// String returns the string representation
func (s DescribePendingMaintenanceActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePendingMaintenanceActionsOutput) GoString() string {
	return s.String()
}

type DescribeReservedDBInstancesInput struct {
	_ struct{} `type:"structure"`

	// The DB instance class filter value. Specify this parameter to show only those
	// reservations matching the specified DB instances class.
	DBInstanceClass *string `type:"string"`

	// The duration filter value, specified in years or seconds. Specify this parameter
	// to show only reservations for this duration.
	//
	// Valid Values: 1 | 3 | 31536000 | 94608000
	Duration *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more than the
	// MaxRecords value is available, a pagination token called a marker is included
	// in the response so that the following results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The Multi-AZ filter value. Specify this parameter to show only those reservations
	// matching the specified Multi-AZ parameter.
	MultiAZ *bool `type:"boolean"`

	// The offering type filter value. Specify this parameter to show only the available
	// offerings matching the specified offering type.
	//
	// Valid Values: "Partial Upfront" | "All Upfront" | "No Upfront"
	OfferingType *string `type:"string"`

	// The product description filter value. Specify this parameter to show only
	// those reservations matching the specified product description.
	ProductDescription *string `type:"string"`

	// The reserved DB instance identifier filter value. Specify this parameter
	// to show only the reservation that matches the specified reservation ID.
	ReservedDBInstanceId *string `type:"string"`

	// The offering identifier filter value. Specify this parameter to show only
	// purchased reservations matching the specified offering identifier.
	ReservedDBInstancesOfferingId *string `type:"string"`
}

// String returns the string representation
func (s DescribeReservedDBInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedDBInstancesInput) GoString() string {
	return s.String()
}

type DescribeReservedDBInstancesOfferingsInput struct {
	_ struct{} `type:"structure"`

	// The DB instance class filter value. Specify this parameter to show only the
	// available offerings matching the specified DB instance class.
	DBInstanceClass *string `type:"string"`

	// Duration filter value, specified in years or seconds. Specify this parameter
	// to show only reservations for this duration.
	//
	// Valid Values: 1 | 3 | 31536000 | 94608000
	Duration *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more than the
	// MaxRecords value is available, a pagination token called a marker is included
	// in the response so that the following results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The Multi-AZ filter value. Specify this parameter to show only the available
	// offerings matching the specified Multi-AZ parameter.
	MultiAZ *bool `type:"boolean"`

	// The offering type filter value. Specify this parameter to show only the available
	// offerings matching the specified offering type.
	//
	// Valid Values: "Partial Upfront" | "All Upfront" | "No Upfront"
	OfferingType *string `type:"string"`

	// Product description filter value. Specify this parameter to show only the
	// available offerings matching the specified product description.
	ProductDescription *string `type:"string"`

	// The offering identifier filter value. Specify this parameter to show only
	// the available offering that matches the specified reservation identifier.
	//
	// Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706
	ReservedDBInstancesOfferingId *string `type:"string"`
}

// String returns the string representation
func (s DescribeReservedDBInstancesOfferingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedDBInstancesOfferingsInput) GoString() string {
	return s.String()
}

// Contains the result of a successful invocation of the DescribeReservedDBInstancesOfferings
// action.
type DescribeReservedDBInstancesOfferingsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// A list of reserved DB instance offerings.
	ReservedDBInstancesOfferings []*ReservedDBInstancesOffering `locationNameList:"ReservedDBInstancesOffering" type:"list"`
}

// String returns the string representation
func (s DescribeReservedDBInstancesOfferingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedDBInstancesOfferingsOutput) GoString() string {
	return s.String()
}

// Contains the result of a successful invocation of the DescribeReservedDBInstances
// action.
type DescribeReservedDBInstancesOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// A list of reserved DB instances.
	ReservedDBInstances []*ReservedDBInstance `locationNameList:"ReservedDBInstance" type:"list"`
}

// String returns the string representation
func (s DescribeReservedDBInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedDBInstancesOutput) GoString() string {
	return s.String()
}

type DownloadDBLogFilePortionInput struct {
	_ struct{} `type:"structure"`

	// The customer-assigned name of the DB instance that contains the log files
	// you want to list.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens First character
	// must be a letter Cannot end with a hyphen or contain two consecutive hyphens
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The name of the log file to be downloaded.
	LogFileName *string `type:"string" required:"true"`

	// The pagination token provided in the previous request or "0". If the Marker
	// parameter is specified the response includes only records beyond the marker
	// until the end of the file or up to NumberOfLines.
	Marker *string `type:"string"`

	// The number of lines to download. If the number of lines specified results
	// in a file over 1 MB in size, the file will be truncated at 1 MB in size.
	//
	// If the NumberOfLines parameter is specified, then the block of lines returned
	// can be from the beginning or the end of the log file, depending on the value
	// of the Marker parameter. If neither Marker or NumberOfLines are specified,
	// the entire log file is returned.
	//
	// If NumberOfLines is specified and Marker is not specified, then the most
	// recent lines from the end of the log file are returned.
	//
	// If Marker is specified as "0", then the specified number of lines from the
	// beginning of the log file are returned.
	//
	// You can download the log file in blocks of lines by specifying the size of
	// the block using the NumberOfLines parameter, and by specifying a value of
	// "0" for the Marker parameter in your first request. Include the Marker value
	// returned in the response as the Marker value for the next request, continuing
	// until the AdditionalDataPending response element returns false.
	NumberOfLines *int64 `type:"integer"`
}

// String returns the string representation
func (s DownloadDBLogFilePortionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DownloadDBLogFilePortionInput) GoString() string {
	return s.String()
}

// This data type is used as a response element to DownloadDBLogFilePortion.
type DownloadDBLogFilePortionOutput struct {
	_ struct{} `type:"structure"`

	// Boolean value that if true, indicates there is more data to be downloaded.
	AdditionalDataPending *bool `type:"boolean"`

	// Entries from the specified log file.
	LogFileData *string `type:"string"`

	// A pagination token that can be used in a subsequent DownloadDBLogFilePortion
	// request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DownloadDBLogFilePortionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DownloadDBLogFilePortionOutput) GoString() string {
	return s.String()
}

// This data type is used as a response element in the following actions:
//
//   AuthorizeDBSecurityGroupIngress   DescribeDBSecurityGroups   RevokeDBSecurityGroupIngress
type EC2SecurityGroup struct {
	_ struct{} `type:"structure"`

	// Specifies the id of the EC2 security group.
	EC2SecurityGroupId *string `type:"string"`

	// Specifies the name of the EC2 security group.
	EC2SecurityGroupName *string `type:"string"`

	// Specifies the AWS ID of the owner of the EC2 security group specified in
	// the EC2SecurityGroupName field.
	EC2SecurityGroupOwnerId *string `type:"string"`

	// Provides the status of the EC2 security group. Status can be "authorizing",
	// "authorized", "revoking", and "revoked".
	Status *string `type:"string"`
}

// String returns the string representation
func (s EC2SecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2SecurityGroup) GoString() string {
	return s.String()
}

// This data type is used as a response element in the following actions:
//
//   CreateDBInstance   DescribeDBInstances   DeleteDBInstance
type Endpoint struct {
	_ struct{} `type:"structure"`

	// Specifies the DNS address of the DB instance.
	Address *string `type:"string"`

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string `type:"string"`

	// Specifies the port that the database engine is listening on.
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Endpoint) GoString() string {
	return s.String()
}

// Contains the result of a successful invocation of the DescribeEngineDefaultParameters
// action.
type EngineDefaults struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the DB parameter group family that the engine default
	// parameters apply to.
	DBParameterGroupFamily *string `type:"string"`

	// An optional pagination token provided by a previous EngineDefaults request.
	// If this parameter is specified, the response includes only records beyond
	// the marker, up to the value specified by MaxRecords .
	Marker *string `type:"string"`

	// Contains a list of engine default parameters.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s EngineDefaults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EngineDefaults) GoString() string {
	return s.String()
}

// This data type is used as a response element in the DescribeEvents action.
type Event struct {
	_ struct{} `type:"structure"`

	// Specifies the date and time of the event.
	Date *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Specifies the category for the event.
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// Provides the text of this event.
	Message *string `type:"string"`

	// Provides the identifier for the source of the event.
	SourceIdentifier *string `type:"string"`

	// Specifies the source type for this event.
	SourceType *string `type:"string" enum:"SourceType"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Event) GoString() string {
	return s.String()
}

// Contains the results of a successful invocation of the DescribeEventCategories
// action.
type EventCategoriesMap struct {
	_ struct{} `type:"structure"`

	// The event categories for the specified source type
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// The source type that the returned categories belong to
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s EventCategoriesMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventCategoriesMap) GoString() string {
	return s.String()
}

// Contains the results of a successful invocation of the DescribeEventSubscriptions
// action.
type EventSubscription struct {
	_ struct{} `type:"structure"`

	// The RDS event notification subscription Id.
	CustSubscriptionId *string `type:"string"`

	// The AWS customer account associated with the RDS event notification subscription.
	CustomerAwsId *string `type:"string"`

	// A Boolean value indicating if the subscription is enabled. True indicates
	// the subscription is enabled.
	Enabled *bool `type:"boolean"`

	// A list of event categories for the RDS event notification subscription.
	EventCategoriesList []*string `locationNameList:"EventCategory" type:"list"`

	// The topic ARN of the RDS event notification subscription.
	SnsTopicArn *string `type:"string"`

	// A list of source IDs for the RDS event notification subscription.
	SourceIdsList []*string `locationNameList:"SourceId" type:"list"`

	// The source type for the RDS event notification subscription.
	SourceType *string `type:"string"`

	// The status of the RDS event notification subscription.
	//
	// Constraints:
	//
	// Can be one of the following: creating | modifying | deleting | active |
	// no-permission | topic-not-exist
	//
	// The status "no-permission" indicates that RDS no longer has permission to
	// post to the SNS topic. The status "topic-not-exist" indicates that the topic
	// was deleted after the subscription was created.
	Status *string `type:"string"`

	// The time the RDS event notification subscription was created.
	SubscriptionCreationTime *string `type:"string"`
}

// String returns the string representation
func (s EventSubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventSubscription) GoString() string {
	return s.String()
}

type FailoverDBClusterInput struct {
	_ struct{} `type:"structure"`

	// A DB cluster identifier to force a failover for. This parameter is not case-sensitive.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens First character
	// must be a letter Cannot end with a hyphen or contain two consecutive hyphens
	DBClusterIdentifier *string `type:"string"`
}

// String returns the string representation
func (s FailoverDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailoverDBClusterInput) GoString() string {
	return s.String()
}

type FailoverDBClusterOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   CreateDBCluster   DeleteDBCluster   FailoverDBCluster   ModifyDBCluster
	//   RestoreDBClusterFromSnapshot   This data type is used as a response element
	// in the DescribeDBClusters action.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s FailoverDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailoverDBClusterOutput) GoString() string {
	return s.String()
}

type Filter struct {
	_ struct{} `type:"structure"`

	// This parameter is not currently supported.
	Name *string `type:"string" required:"true"`

	// This parameter is not currently supported.
	Values []*string `locationNameList:"Value" type:"list" required:"true"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// This data type is used as a response element in the DescribeDBSecurityGroups
// action.
type IPRange struct {
	_ struct{} `type:"structure"`

	// Specifies the IP range.
	CIDRIP *string `type:"string"`

	// Specifies the status of the IP range. Status can be "authorizing", "authorized",
	// "revoking", and "revoked".
	Status *string `type:"string"`
}

// String returns the string representation
func (s IPRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IPRange) GoString() string {
	return s.String()
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// The Amazon RDS resource with tags to be listed. This value is an Amazon Resource
	// Name (ARN). For information about creating an ARN, see  Constructing an RDS
	// Amazon Resource Name (ARN) (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN).
	ResourceName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// List of tags returned by the ListTagsForResource operation.
	TagList []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

type ModifyDBClusterInput struct {
	_ struct{} `type:"structure"`

	// A value that specifies whether the modifications in this request and any
	// pending modifications are asynchronously applied as soon as possible, regardless
	// of the PreferredMaintenanceWindow setting for the DB cluster.
	//
	// If this parameter is set to false, changes to the DB cluster are applied
	// during the next maintenance window.
	//
	// Default: false
	ApplyImmediately *bool `type:"boolean"`

	// The number of days for which automated backups are retained. You must specify
	// a minimum value of 1.
	//
	// Default: 1
	//
	// Constraints:
	//
	//  Must be a value from 1 to 35
	BackupRetentionPeriod *int64 `type:"integer"`

	// The DB cluster identifier for the cluster being modified. This parameter
	// is not case-sensitive.
	//
	// Constraints:
	//
	//  Must be the identifier for an existing DB cluster. Must contain from 1
	// to 63 alphanumeric characters or hyphens. First character must be a letter.
	// Cannot end with a hyphen or contain two consecutive hyphens.
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The name of the DB cluster parameter group to use for the DB cluster.
	DBClusterParameterGroupName *string `type:"string"`

	// The new password for the master database user. This password can contain
	// any printable ASCII character except "/", """, or "@".
	//
	// Constraints: Must contain from 8 to 41 characters.
	MasterUserPassword *string `type:"string"`

	// The new DB cluster identifier for the DB cluster when renaming a DB cluster.
	// This value is stored as a lowercase string.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens First character
	// must be a letter Cannot end with a hyphen or contain two consecutive hyphens
	//  Example: my-cluster2
	NewDBClusterIdentifier *string `type:"string"`

	// A value that indicates that the DB cluster should be associated with the
	// specified option group. Changing this parameter does not result in an outage
	// except in the following case, and the change is applied during the next maintenance
	// window unless the ApplyImmediately parameter is set to true for this request.
	// If the parameter change results in an option group that enables OEM, this
	// change can cause a brief (sub-second) period during which new connections
	// are rejected but existing connections are not interrupted.
	//
	// Permanent options cannot be removed from an option group. The option group
	// cannot be removed from a DB cluster once it is associated with a DB cluster.
	OptionGroupName *string `type:"string"`

	// The port number on which the DB cluster accepts connections.
	//
	// Constraints: Value must be 1150-65535
	//
	// Default: The same port as the original DB cluster.
	Port *int64 `type:"integer"`

	// The daily time range during which automated backups are created if automated
	// backups are enabled, using the BackupRetentionPeriod parameter.
	//
	// Default: A 30-minute window selected at random from an 8-hour block of time
	// per region. To see the time blocks available, see  Adjusting the Preferred
	// Maintenance Window (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html)
	// in the Amazon RDS User Guide.
	//
	// Constraints:
	//
	//  Must be in the format hh24:mi-hh24:mi. Times should be in Universal Coordinated
	// Time (UTC). Must not conflict with the preferred maintenance window. Must
	// be at least 30 minutes.
	PreferredBackupWindow *string `type:"string"`

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	//  Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Default: A 30-minute window selected at random from an 8-hour block of time
	// per region, occurring on a random day of the week. To see the time blocks
	// available, see  Adjusting the Preferred Maintenance Window (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html)
	// in the Amazon RDS User Guide.
	//
	// Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// A lst of VPC security groups that the DB cluster will belong to.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s ModifyDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBClusterInput) GoString() string {
	return s.String()
}

type ModifyDBClusterOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   CreateDBCluster   DeleteDBCluster   FailoverDBCluster   ModifyDBCluster
	//   RestoreDBClusterFromSnapshot   This data type is used as a response element
	// in the DescribeDBClusters action.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s ModifyDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBClusterOutput) GoString() string {
	return s.String()
}

type ModifyDBClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster parameter group to modify.
	DBClusterParameterGroupName *string `type:"string" required:"true"`

	// A list of parameters in the DB cluster parameter group to modify.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyDBClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBClusterParameterGroupInput) GoString() string {
	return s.String()
}

type ModifyDBInstanceInput struct {
	_ struct{} `type:"structure"`

	// The new storage capacity of the RDS instance. Changing this setting does
	// not result in an outage and the change is applied during the next maintenance
	// window unless ApplyImmediately is set to true for this request.
	//
	//  MySQL
	//
	// Default: Uses existing setting
	//
	// Valid Values: 5-6144
	//
	// Constraints: Value supplied must be at least 10% greater than the current
	// value. Values that are not at least 10% greater than the existing value are
	// rounded up so that they are 10% greater than the current value.
	//
	// Type: Integer
	//
	//  MariaDB
	//
	// Default: Uses existing setting
	//
	// Valid Values: 5-6144
	//
	// Constraints: Value supplied must be at least 10% greater than the current
	// value. Values that are not at least 10% greater than the existing value are
	// rounded up so that they are 10% greater than the current value.
	//
	// Type: Integer
	//
	//  PostgreSQL
	//
	// Default: Uses existing setting
	//
	// Valid Values: 5-6144
	//
	// Constraints: Value supplied must be at least 10% greater than the current
	// value. Values that are not at least 10% greater than the existing value are
	// rounded up so that they are 10% greater than the current value.
	//
	// Type: Integer
	//
	//  Oracle
	//
	// Default: Uses existing setting
	//
	// Valid Values: 10-6144
	//
	// Constraints: Value supplied must be at least 10% greater than the current
	// value. Values that are not at least 10% greater than the existing value are
	// rounded up so that they are 10% greater than the current value.
	//
	//  SQL Server
	//
	// Cannot be modified.
	//
	//  If you choose to migrate your DB instance from using standard storage to
	// using Provisioned IOPS, or from using Provisioned IOPS to using standard
	// storage, the process can take time. The duration of the migration depends
	// on several factors such as database load, storage size, storage type (standard
	// or Provisioned IOPS), amount of IOPS provisioned (if any), and the number
	// of prior scale storage operations. Typical migration times are under 24 hours,
	// but the process can take up to several days in some cases. During the migration,
	// the DB instance will be available for use, but might experience performance
	// degradation. While the migration takes place, nightly backups for the instance
	// will be suspended. No other Amazon RDS operations can take place for the
	// instance, including modifying the instance, rebooting the instance, deleting
	// the instance, creating a Read Replica for the instance, and creating a DB
	// snapshot of the instance.
	AllocatedStorage *int64 `type:"integer"`

	// Indicates that major version upgrades are allowed. Changing this parameter
	// does not result in an outage and the change is asynchronously applied as
	// soon as possible.
	//
	// Constraints: This parameter must be set to true when specifying a value
	// for the EngineVersion parameter that is a different major version than the
	// DB instance's current version.
	AllowMajorVersionUpgrade *bool `type:"boolean"`

	// Specifies whether the modifications in this request and any pending modifications
	// are asynchronously applied as soon as possible, regardless of the PreferredMaintenanceWindow
	// setting for the DB instance.
	//
	//  If this parameter is set to false, changes to the DB instance are applied
	// during the next maintenance window. Some parameter changes can cause an outage
	// and will be applied on the next call to RebootDBInstance, or the next failure
	// reboot. Review the table of parameters in Modifying a DB Instance and Using
	// the Apply Immediately Parameter (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html)
	// to see the impact that setting ApplyImmediately to true or false has for
	// each modified parameter and to determine when the changes will be applied.
	//
	// Default: false
	ApplyImmediately *bool `type:"boolean"`

	// Indicates that minor version upgrades will be applied automatically to the
	// DB instance during the maintenance window. Changing this parameter does not
	// result in an outage except in the following case and the change is asynchronously
	// applied as soon as possible. An outage will result if this parameter is set
	// to true during the maintenance window, and a newer minor version is available,
	// and RDS has enabled auto patching for that engine version.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The number of days to retain automated backups. Setting this parameter to
	// a positive number enables backups. Setting this parameter to 0 disables automated
	// backups.
	//
	// Changing this parameter can result in an outage if you change from 0 to
	// a non-zero value or from a non-zero value to 0. These changes are applied
	// during the next maintenance window unless the ApplyImmediately parameter
	// is set to true for this request. If you change the parameter from one non-zero
	// value to another non-zero value, the change is asynchronously applied as
	// soon as possible.
	//
	// Default: Uses existing setting
	//
	// Constraints:
	//
	//  Must be a value from 0 to 35 Can be specified for a MySQL Read Replica
	// only if the source is running MySQL 5.6 Can be specified for a PostgreSQL
	// Read Replica only if the source is running PostgreSQL 9.3.5 Cannot be set
	// to 0 if the DB instance is a source to Read Replicas
	BackupRetentionPeriod *int64 `type:"integer"`

	// Indicates the certificate that needs to be associated with the instance.
	CACertificateIdentifier *string `type:"string"`

	// True to copy all tags from the DB instance to snapshots of the DB instance;
	// otherwise false. The default is false.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// The new compute and memory capacity of the DB instance. To determine the
	// instance classes that are available for a particular DB engine, use the DescribeOrderableDBInstanceOptions
	// action.
	//
	//  Passing a value for this setting causes an outage during the change and
	// is applied during the next maintenance window, unless ApplyImmediately is
	// specified as true for this request.
	//
	// Default: Uses existing setting
	//
	// Valid Values: db.t1.micro | db.m1.small | db.m1.medium | db.m1.large | db.m1.xlarge
	// | db.m2.xlarge | db.m2.2xlarge | db.m2.4xlarge | db.m3.medium | db.m3.large
	// | db.m3.xlarge | db.m3.2xlarge | db.m4.large | db.m4.xlarge | db.m4.2xlarge
	// | db.m4.4xlarge | db.m4.10xlarge | db.r3.large | db.r3.xlarge | db.r3.2xlarge
	// | db.r3.4xlarge | db.r3.8xlarge | db.t2.micro | db.t2.small | db.t2.medium
	// | db.t2.large
	DBInstanceClass *string `type:"string"`

	// The DB instance identifier. This value is stored as a lowercase string.
	//
	// Constraints:
	//
	//  Must be the identifier for an existing DB instance Must contain from 1
	// to 63 alphanumeric characters or hyphens First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The name of the DB parameter group to apply to the DB instance. Changing
	// this setting does not result in an outage. The parameter group name itself
	// is changed immediately, but the actual parameter changes are not applied
	// until you reboot the instance without failover. The db instance will NOT
	// be rebooted automatically and the parameter changes will NOT be applied during
	// the next maintenance window.
	//
	// Default: Uses existing setting
	//
	// Constraints: The DB parameter group must be in the same DB parameter group
	// family as this DB instance.
	DBParameterGroupName *string `type:"string"`

	// The port number on which the database accepts connections.
	//
	// The value of the DBPortNumber parameter must not match any of the port values
	// specified for options in the option group for the DB instance.
	//
	// Your database will restart when you change the DBPortNumber value regardless
	// of the value of the ApplyImmediately parameter.
	//
	//  MySQL
	//
	//  Default: 3306
	//
	//  Valid Values: 1150-65535
	//
	//  MariaDB
	//
	//  Default: 3306
	//
	//  Valid Values: 1150-65535
	//
	//  PostgreSQL
	//
	//  Default: 5432
	//
	//  Valid Values: 1150-65535
	//
	//  Oracle
	//
	//  Default: 1521
	//
	//  Valid Values: 1150-65535
	//
	//  SQL Server
	//
	//  Default: 1433
	//
	//  Valid Values: 1150-65535 except for 1434, 3389, 47001, 49152, and 49152
	// through 49156.
	//
	//  Amazon Aurora
	//
	//  Default: 3306
	//
	//  Valid Values: 1150-65535
	DBPortNumber *int64 `type:"integer"`

	// A list of DB security groups to authorize on this DB instance. Changing this
	// setting does not result in an outage and the change is asynchronously applied
	// as soon as possible.
	//
	// Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens
	DBSecurityGroups []*string `locationNameList:"DBSecurityGroupName" type:"list"`

	// The version number of the database engine to upgrade to. Changing this parameter
	// results in an outage and the change is applied during the next maintenance
	// window unless the ApplyImmediately parameter is set to true for this request.
	//
	//  For major version upgrades, if a non-default DB parameter group is currently
	// in use, a new DB parameter group in the DB parameter group family for the
	// new engine version must be specified. The new DB parameter group can be the
	// default for that DB parameter group family.
	//
	// For a list of valid engine versions, see CreateDBInstance.
	EngineVersion *string `type:"string"`

	// The new Provisioned IOPS (I/O operations per second) value for the RDS instance.
	// Changing this setting does not result in an outage and the change is applied
	// during the next maintenance window unless the ApplyImmediately parameter
	// is set to true for this request.
	//
	// Default: Uses existing setting
	//
	// Constraints: Value supplied must be at least 10% greater than the current
	// value. Values that are not at least 10% greater than the existing value are
	// rounded up so that they are 10% greater than the current value. If you are
	// migrating from Provisioned IOPS to standard storage, set this value to 0.
	// The DB instance will require a reboot for the change in storage type to take
	// effect.
	//
	//  SQL Server
	//
	// Setting the IOPS value for the SQL Server database engine is not supported.
	//
	// Type: Integer
	//
	//  If you choose to migrate your DB instance from using standard storage to
	// using Provisioned IOPS, or from using Provisioned IOPS to using standard
	// storage, the process can take time. The duration of the migration depends
	// on several factors such as database load, storage size, storage type (standard
	// or Provisioned IOPS), amount of IOPS provisioned (if any), and the number
	// of prior scale storage operations. Typical migration times are under 24 hours,
	// but the process can take up to several days in some cases. During the migration,
	// the DB instance will be available for use, but might experience performance
	// degradation. While the migration takes place, nightly backups for the instance
	// will be suspended. No other Amazon RDS operations can take place for the
	// instance, including modifying the instance, rebooting the instance, deleting
	// the instance, creating a Read Replica for the instance, and creating a DB
	// snapshot of the instance.
	Iops *int64 `type:"integer"`

	// The new password for the DB instance master user. Can be any printable ASCII
	// character except "/", """, or "@".
	//
	//  Changing this parameter does not result in an outage and the change is
	// asynchronously applied as soon as possible. Between the time of the request
	// and the completion of the request, the MasterUserPassword element exists
	// in the PendingModifiedValues element of the operation response.
	//
	// Default: Uses existing setting
	//
	// Constraints: Must be 8 to 41 alphanumeric characters (MySQL, MariaDB, and
	// Amazon Aurora), 8 to 30 alphanumeric characters (Oracle), or 8 to 128 alphanumeric
	// characters (SQL Server).
	//
	//  Amazon RDS API actions never return the password, so this action provides
	// a way to regain access to a primary instance user if the password is lost.
	// This includes restoring privileges that might have been accidentally revoked.
	MasterUserPassword *string `type:"string"`

	// The interval, in seconds, between points when Enhanced Monitoring metrics
	// are collected for the DB instance. To disable collecting Enhanced Monitoring
	// metrics, specify 0. The default is 60.
	//
	// If MonitoringRoleArn is specified, then you must also set MonitoringInterval
	// to a value other than 0.
	//
	// Valid Values: 0, 1, 5, 10, 15, 30, 60
	MonitoringInterval *int64 `type:"integer"`

	// The ARN for the IAM role that permits RDS to send enhanced monitoring metrics
	// to CloudWatch Logs. For example, arn:aws:iam:123456789012:role/emaccess.
	// For information on creating a monitoring role, go to To create an IAM role
	// for Amazon RDS Enhanced Monitoring (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole).
	//
	// If MonitoringInterval is set to a value other than 0, then you must supply
	// a MonitoringRoleArn value.
	MonitoringRoleArn *string `type:"string"`

	// Specifies if the DB instance is a Multi-AZ deployment. Changing this parameter
	// does not result in an outage and the change is applied during the next maintenance
	// window unless the ApplyImmediately parameter is set to true for this request.
	//
	// Constraints: Cannot be specified if the DB instance is a Read Replica. This
	// parameter cannot be used with SQL Server DB instances. Multi-AZ for SQL Server
	// DB instances is set using the Mirroring option in an option group associated
	// with the DB instance.
	MultiAZ *bool `type:"boolean"`

	// The new DB instance identifier for the DB instance when renaming a DB instance.
	// When you change the DB instance identifier, an instance reboot will occur
	// immediately if you set Apply Immediately to true, or will occur during the
	// next maintenance window if Apply Immediately to false. This value is stored
	// as a lowercase string.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens First character
	// must be a letter Cannot end with a hyphen or contain two consecutive hyphens
	NewDBInstanceIdentifier *string `type:"string"`

	// Indicates that the DB instance should be associated with the specified option
	// group. Changing this parameter does not result in an outage except in the
	// following case and the change is applied during the next maintenance window
	// unless the ApplyImmediately parameter is set to true for this request. If
	// the parameter change results in an option group that enables OEM, this change
	// can cause a brief (sub-second) period during which new connections are rejected
	// but existing connections are not interrupted.
	//
	//  Permanent options, such as the TDE option for Oracle Advanced Security
	// TDE, cannot be removed from an option group, and that option group cannot
	// be removed from a DB instance once it is associated with a DB instance
	OptionGroupName *string `type:"string"`

	// The daily time range during which automated backups are created if automated
	// backups are enabled, as determined by the BackupRetentionPeriod parameter.
	// Changing this parameter does not result in an outage and the change is asynchronously
	// applied as soon as possible.
	//
	// Constraints:
	//
	//  Must be in the format hh24:mi-hh24:mi Times should be in Universal Time
	// Coordinated (UTC) Must not conflict with the preferred maintenance window
	// Must be at least 30 minutes
	PreferredBackupWindow *string `type:"string"`

	// The weekly time range (in UTC) during which system maintenance can occur,
	// which might result in an outage. Changing this parameter does not result
	// in an outage, except in the following situation, and the change is asynchronously
	// applied as soon as possible. If there are pending actions that cause a reboot,
	// and the maintenance window is changed to include the current time, then changing
	// this parameter will cause a reboot of the DB instance. If moving this window
	// to the current time, there must be at least 30 minutes between the current
	// time and end of the window to ensure pending changes are applied.
	//
	// Default: Uses existing setting
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
	//
	// Constraints: Must be at least 30 minutes
	PreferredMaintenanceWindow *string `type:"string"`

	// True to make the DB instance Internet-facing with a publicly resolvable DNS
	// name, which resolves to a public IP address. False to make the DB instance
	// internal with a DNS name that resolves to a private IP address.
	//
	// PubliclyAccessible only applies to DB instances in a VPC. The DB instance
	// must be part of a public subnet and PubliclyAccessible must be true in order
	// for it to be publicly accessible.
	//
	// Changes to the PubliclyAccessible parameter are applied immediately regardless
	// of the value of the ApplyImmediately parameter.
	//
	//  Default: false
	PubliclyAccessible *bool `type:"boolean"`

	// Specifies the storage type to be associated with the DB instance.
	//
	//  Valid values: standard | gp2 | io1
	//
	//  If you specify io1, you must also include a value for the Iops parameter.
	//
	//  Default: io1 if the Iops parameter is specified; otherwise standard
	StorageType *string `type:"string"`

	// The ARN from the Key Store with which to associate the instance for TDE encryption.
	TdeCredentialArn *string `type:"string"`

	// The password for the given ARN from the Key Store in order to access the
	// device.
	TdeCredentialPassword *string `type:"string"`

	// A list of EC2 VPC security groups to authorize on this DB instance. This
	// change is asynchronously applied as soon as possible.
	//
	// Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s ModifyDBInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBInstanceInput) GoString() string {
	return s.String()
}

type ModifyDBInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   CreateDBInstance   DeleteDBInstance   ModifyDBInstance   This data type
	// is used as a response element in the DescribeDBInstances action.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s ModifyDBInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBInstanceOutput) GoString() string {
	return s.String()
}

type ModifyDBParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB parameter group.
	//
	// Constraints:
	//
	//  Must be the name of an existing DB parameter group Must be 1 to 255 alphanumeric
	// characters First character must be a letter Cannot end with a hyphen or contain
	// two consecutive hyphens
	DBParameterGroupName *string `type:"string" required:"true"`

	// An array of parameter names, values, and the apply method for the parameter
	// update. At least one parameter name, value, and apply method must be supplied;
	// subsequent arguments are optional. A maximum of 20 parameters can be modified
	// in a single request.
	//
	// Valid Values (for the application method): immediate | pending-reboot
	//
	// You can use the immediate value with dynamic parameters only. You can use
	// the pending-reboot value for both dynamic and static parameters, and changes
	// are applied when you reboot the DB instance without failover.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyDBParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBParameterGroupInput) GoString() string {
	return s.String()
}

type ModifyDBSnapshotAttributeInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB snapshot attribute to modify.
	//
	// To manage authorization for other AWS accounts to copy or restore a manual
	// DB snapshot, this value is restore.
	AttributeName *string `type:"string"`

	// The identifier for the DB snapshot to modify the attributes for.
	DBSnapshotIdentifier *string `type:"string" required:"true"`

	// A list of DB snapshot attributes to add to the attribute specified by AttributeName.
	//
	// To authorize other AWS Accounts to copy or restore a manual snapshot, this
	// is one or more AWS account identifiers, or all to make the manual DB snapshot
	// restorable by any AWS account. Do not add the all value for any manual DB
	// snapshots that contain private information that you do not want to be available
	// to all AWS accounts.
	ValuesToAdd []*string `locationNameList:"AttributeValue" type:"list"`

	// A list of DB snapshot attributes to remove from the attribute specified by
	// AttributeName.
	//
	// To remove authorization for other AWS Accounts to copy or restore a manual
	// snapshot, this is one or more AWS account identifiers, or all to remove authorization
	// for any AWS account to copy or restore the DB snapshot. If you specify all,
	// AWS accounts that have their account identifier explicitly added to the restore
	// attribute can still copy or restore the manual DB snapshot.
	ValuesToRemove []*string `locationNameList:"AttributeValue" type:"list"`
}

// String returns the string representation
func (s ModifyDBSnapshotAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBSnapshotAttributeInput) GoString() string {
	return s.String()
}

type ModifyDBSnapshotAttributeOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful call to the DescribeDBSnapshotAttributes
	// API.
	//
	// Manual DB snapshot attributes are used to authorize other AWS accounts to
	// copy or restore a manual DB snapshot. For more information, see the ModifyDBSnapshotAttribute
	// API.
	DBSnapshotAttributesResult *DBSnapshotAttributesResult `type:"structure"`
}

// String returns the string representation
func (s ModifyDBSnapshotAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBSnapshotAttributeOutput) GoString() string {
	return s.String()
}

type ModifyDBSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The description for the DB subnet group.
	DBSubnetGroupDescription *string `type:"string"`

	// The name for the DB subnet group. This value is stored as a lowercase string.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters or hyphens.
	// Must not be "Default".
	//
	// Example: mySubnetgroup
	DBSubnetGroupName *string `type:"string" required:"true"`

	// The EC2 subnet IDs for the DB subnet group.
	SubnetIds []*string `locationNameList:"SubnetIdentifier" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyDBSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBSubnetGroupInput) GoString() string {
	return s.String()
}

type ModifyDBSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   CreateDBSubnetGroup   ModifyDBSubnetGroup   DescribeDBSubnetGroups   DeleteDBSubnetGroup
	//   This data type is used as a response element in the DescribeDBSubnetGroups
	// action.
	DBSubnetGroup *DBSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s ModifyDBSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBSubnetGroupOutput) GoString() string {
	return s.String()
}

type ModifyEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value; set to true to activate the subscription.
	Enabled *bool `type:"boolean"`

	// A list of event categories for a SourceType that you want to subscribe to.
	// You can see a list of the categories for a given SourceType in the Events
	// (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html)
	// topic in the Amazon RDS User Guide or by using the DescribeEventCategories
	// action.
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// The Amazon Resource Name (ARN) of the SNS topic created for event notification.
	// The ARN is created by Amazon SNS when you create a topic and subscribe to
	// it.
	SnsTopicArn *string `type:"string"`

	// The type of source that will be generating the events. For example, if you
	// want to be notified of events generated by a DB instance, you would set this
	// parameter to db-instance. if this value is not specified, all events are
	// returned.
	//
	// Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot
	SourceType *string `type:"string"`

	// The name of the RDS event notification subscription.
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyEventSubscriptionInput) GoString() string {
	return s.String()
}

type ModifyEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful invocation of the DescribeEventSubscriptions
	// action.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s ModifyEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyEventSubscriptionOutput) GoString() string {
	return s.String()
}

type ModifyOptionGroupInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the changes should be applied immediately, or during the
	// next maintenance window for each instance associated with the option group.
	ApplyImmediately *bool `type:"boolean"`

	// The name of the option group to be modified.
	//
	//  Permanent options, such as the TDE option for Oracle Advanced Security
	// TDE, cannot be removed from an option group, and that option group cannot
	// be removed from a DB instance once it is associated with a DB instance
	OptionGroupName *string `type:"string" required:"true"`

	// Options in this list are added to the option group or, if already present,
	// the specified configuration is used to update the existing configuration.
	OptionsToInclude []*OptionConfiguration `locationNameList:"OptionConfiguration" type:"list"`

	// Options in this list are removed from the option group.
	OptionsToRemove []*string `type:"list"`
}

// String returns the string representation
func (s ModifyOptionGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyOptionGroupInput) GoString() string {
	return s.String()
}

type ModifyOptionGroupOutput struct {
	_ struct{} `type:"structure"`

	OptionGroup *OptionGroup `type:"structure"`
}

// String returns the string representation
func (s ModifyOptionGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyOptionGroupOutput) GoString() string {
	return s.String()
}

// Option details.
type Option struct {
	_ struct{} `type:"structure"`

	// If the option requires access to a port, then this DB security group allows
	// access to the port.
	DBSecurityGroupMemberships []*DBSecurityGroupMembership `locationNameList:"DBSecurityGroup" type:"list"`

	// The description of the option.
	OptionDescription *string `type:"string"`

	// The name of the option.
	OptionName *string `type:"string"`

	// The option settings for this option.
	OptionSettings []*OptionSetting `locationNameList:"OptionSetting" type:"list"`

	// Indicate if this option is permanent.
	Permanent *bool `type:"boolean"`

	// Indicate if this option is persistent.
	Persistent *bool `type:"boolean"`

	// If required, the port configured for this option to use.
	Port *int64 `type:"integer"`

	// If the option requires access to a port, then this VPC security group allows
	// access to the port.
	VpcSecurityGroupMemberships []*VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroupMembership" type:"list"`
}

// String returns the string representation
func (s Option) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Option) GoString() string {
	return s.String()
}

// A list of all available options
type OptionConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of DBSecurityGroupMemebrship name strings used for this option.
	DBSecurityGroupMemberships []*string `locationNameList:"DBSecurityGroupName" type:"list"`

	// The configuration of options to include in a group.
	OptionName *string `type:"string" required:"true"`

	// The option settings to include in an option group.
	OptionSettings []*OptionSetting `locationNameList:"OptionSetting" type:"list"`

	// The optional port for the option.
	Port *int64 `type:"integer"`

	// A list of VpcSecurityGroupMemebrship name strings used for this option.
	VpcSecurityGroupMemberships []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s OptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionConfiguration) GoString() string {
	return s.String()
}

type OptionGroup struct {
	_ struct{} `type:"structure"`

	// Indicates whether this option group can be applied to both VPC and non-VPC
	// instances. The value true indicates the option group can be applied to both
	// VPC and non-VPC instances.
	AllowsVpcAndNonVpcInstanceMemberships *bool `type:"boolean"`

	// Indicates the name of the engine that this option group can be applied to.
	EngineName *string `type:"string"`

	// Indicates the major engine version associated with this option group.
	MajorEngineVersion *string `type:"string"`

	// Provides a description of the option group.
	OptionGroupDescription *string `type:"string"`

	// Specifies the name of the option group.
	OptionGroupName *string `type:"string"`

	// Indicates what options are available in the option group.
	Options []*Option `locationNameList:"Option" type:"list"`

	// If AllowsVpcAndNonVpcInstanceMemberships is false, this field is blank. If
	// AllowsVpcAndNonVpcInstanceMemberships is true and this field is blank, then
	// this option group can be applied to both VPC and non-VPC instances. If this
	// field contains a value, then this option group can only be applied to instances
	// that are in the VPC indicated by this field.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s OptionGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionGroup) GoString() string {
	return s.String()
}

// Provides information on the option groups the DB instance is a member of.
type OptionGroupMembership struct {
	_ struct{} `type:"structure"`

	// The name of the option group that the instance belongs to.
	OptionGroupName *string `type:"string"`

	// The status of the DB instance's option group membership (e.g. in-sync, pending,
	// pending-maintenance, applying).
	Status *string `type:"string"`
}

// String returns the string representation
func (s OptionGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionGroupMembership) GoString() string {
	return s.String()
}

// Available option.
type OptionGroupOption struct {
	_ struct{} `type:"structure"`

	// If the option requires a port, specifies the default port for the option.
	DefaultPort *int64 `type:"integer"`

	// The description of the option.
	Description *string `type:"string"`

	// The name of the engine that this option can be applied to.
	EngineName *string `type:"string"`

	// Indicates the major engine version that the option is available for.
	MajorEngineVersion *string `type:"string"`

	// The minimum required engine version for the option to be applied.
	MinimumRequiredMinorEngineVersion *string `type:"string"`

	// The name of the option.
	Name *string `type:"string"`

	// Specifies the option settings that are available (and the default value)
	// for each option in an option group.
	OptionGroupOptionSettings []*OptionGroupOptionSetting `locationNameList:"OptionGroupOptionSetting" type:"list"`

	// List of all options that are prerequisites for this option.
	OptionsDependedOn []*string `locationNameList:"OptionName" type:"list"`

	// A permanent option cannot be removed from the option group once the option
	// group is used, and it cannot be removed from the db instance after assigning
	// an option group with this permanent option.
	Permanent *bool `type:"boolean"`

	// A persistent option cannot be removed from the option group once the option
	// group is used, but this option can be removed from the db instance while
	// modifying the related data and assigning another option group without this
	// option.
	Persistent *bool `type:"boolean"`

	// Specifies whether the option requires a port.
	PortRequired *bool `type:"boolean"`
}

// String returns the string representation
func (s OptionGroupOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionGroupOption) GoString() string {
	return s.String()
}

// Option group option settings are used to display settings available for each
// option with their default values and other information. These values are
// used with the DescribeOptionGroupOptions action.
type OptionGroupOptionSetting struct {
	_ struct{} `type:"structure"`

	// Indicates the acceptable values for the option group option.
	AllowedValues *string `type:"string"`

	// The DB engine specific parameter type for the option group option.
	ApplyType *string `type:"string"`

	// The default value for the option group option.
	DefaultValue *string `type:"string"`

	// Boolean value where true indicates that this option group option can be changed
	// from the default value.
	IsModifiable *bool `type:"boolean"`

	// The description of the option group option.
	SettingDescription *string `type:"string"`

	// The name of the option group option.
	SettingName *string `type:"string"`
}

// String returns the string representation
func (s OptionGroupOptionSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionGroupOptionSetting) GoString() string {
	return s.String()
}

// Option settings are the actual settings being applied or configured for that
// option. It is used when you modify an option group or describe option groups.
// For example, the NATIVE_NETWORK_ENCRYPTION option has a setting called SQLNET.ENCRYPTION_SERVER
// that can have several different values.
type OptionSetting struct {
	_ struct{} `type:"structure"`

	// The allowed values of the option setting.
	AllowedValues *string `type:"string"`

	// The DB engine specific parameter type.
	ApplyType *string `type:"string"`

	// The data type of the option setting.
	DataType *string `type:"string"`

	// The default value of the option setting.
	DefaultValue *string `type:"string"`

	// The description of the option setting.
	Description *string `type:"string"`

	// Indicates if the option setting is part of a collection.
	IsCollection *bool `type:"boolean"`

	// A Boolean value that, when true, indicates the option setting can be modified
	// from the default.
	IsModifiable *bool `type:"boolean"`

	// The name of the option that has settings that you can set.
	Name *string `type:"string"`

	// The current value of the option setting.
	Value *string `type:"string"`
}

// String returns the string representation
func (s OptionSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionSetting) GoString() string {
	return s.String()
}

// Contains a list of available options for a DB instance
//
//  This data type is used as a response element in the DescribeOrderableDBInstanceOptions
// action.
type OrderableDBInstanceOption struct {
	_ struct{} `type:"structure"`

	// A list of Availability Zones for the orderable DB instance.
	AvailabilityZones []*AvailabilityZone `locationNameList:"AvailabilityZone" type:"list"`

	// The DB instance class for the orderable DB instance.
	DBInstanceClass *string `type:"string"`

	// The engine type of the orderable DB instance.
	Engine *string `type:"string"`

	// The engine version of the orderable DB instance.
	EngineVersion *string `type:"string"`

	// The license model for the orderable DB instance.
	LicenseModel *string `type:"string"`

	// Indicates whether this orderable DB instance is multi-AZ capable.
	MultiAZCapable *bool `type:"boolean"`

	// Indicates whether this orderable DB instance can have a Read Replica.
	ReadReplicaCapable *bool `type:"boolean"`

	// Indicates the storage type for this orderable DB instance.
	StorageType *string `type:"string"`

	// Indicates whether the DB instance supports enhanced monitoring at intervals
	// from 1 to 60 seconds.
	SupportsEnhancedMonitoring *bool `type:"boolean"`

	// Indicates whether this orderable DB instance supports provisioned IOPS.
	SupportsIops *bool `type:"boolean"`

	// Indicates whether this orderable DB instance supports encrypted storage.
	SupportsStorageEncryption *bool `type:"boolean"`

	// Indicates whether this is a VPC orderable DB instance.
	Vpc *bool `type:"boolean"`
}

// String returns the string representation
func (s OrderableDBInstanceOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrderableDBInstanceOption) GoString() string {
	return s.String()
}

// This data type is used as a request parameter in the ModifyDBParameterGroup
// and ResetDBParameterGroup actions.
//
// This data type is used as a response element in the DescribeEngineDefaultParameters
// and DescribeDBParameters actions.
type Parameter struct {
	_ struct{} `type:"structure"`

	// Specifies the valid range of values for the parameter.
	AllowedValues *string `type:"string"`

	// Indicates when to apply parameter updates.
	ApplyMethod *string `type:"string" enum:"ApplyMethod"`

	// Specifies the engine specific parameters type.
	ApplyType *string `type:"string"`

	// Specifies the valid data type for the parameter.
	DataType *string `type:"string"`

	// Provides a description of the parameter.
	Description *string `type:"string"`

	// Indicates whether (true) or not (false) the parameter can be modified. Some
	// parameters have security or operational implications that prevent them from
	// being changed.
	IsModifiable *bool `type:"boolean"`

	// The earliest engine version to which the parameter can apply.
	MinimumEngineVersion *string `type:"string"`

	// Specifies the name of the parameter.
	ParameterName *string `type:"string"`

	// Specifies the value of the parameter.
	ParameterValue *string `type:"string"`

	// Indicates the source of the parameter value.
	Source *string `type:"string"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Parameter) GoString() string {
	return s.String()
}

// Provides information about a pending maintenance action for a resource.
type PendingMaintenanceAction struct {
	_ struct{} `type:"structure"`

	// The type of pending maintenance action that is available for the resource.
	Action *string `type:"string"`

	// The date of the maintenance window when the action will be applied. The maintenance
	// action will be applied to the resource during its first maintenance window
	// after this date. If this date is specified, any next-maintenance opt-in requests
	// are ignored.
	AutoAppliedAfterDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The effective date when the pending maintenance action will be applied to
	// the resource. This date takes into account opt-in requests received from
	// the ApplyPendingMaintenanceAction API, the AutoAppliedAfterDate, and the
	// ForcedApplyDate. This value is blank if an opt-in request has not been received
	// and nothing has been specified as AutoAppliedAfterDate or ForcedApplyDate.
	CurrentApplyDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A description providing more detail about the maintenance action.
	Description *string `type:"string"`

	// The date when the maintenance action will be automatically applied. The maintenance
	// action will be applied to the resource on this date regardless of the maintenance
	// window for the resource. If this date is specified, any immediate opt-in
	// requests are ignored.
	ForcedApplyDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Indicates the type of opt-in request that has been received for the resource.
	OptInStatus *string `type:"string"`
}

// String returns the string representation
func (s PendingMaintenanceAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingMaintenanceAction) GoString() string {
	return s.String()
}

// This data type is used as a response element in the ModifyDBInstance action.
type PendingModifiedValues struct {
	_ struct{} `type:"structure"`

	// Contains the new AllocatedStorage size for the DB instance that will be applied
	// or is in progress.
	AllocatedStorage *int64 `type:"integer"`

	// Specifies the pending number of days for which automated backups are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// Specifies the identifier of the CA certificate for the DB instance.
	CACertificateIdentifier *string `type:"string"`

	// Contains the new DBInstanceClass for the DB instance that will be applied
	// or is in progress.
	DBInstanceClass *string `type:"string"`

	// Contains the new DBInstanceIdentifier for the DB instance that will be applied
	// or is in progress.
	DBInstanceIdentifier *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// Specifies the new Provisioned IOPS value for the DB instance that will be
	// applied or is being applied.
	Iops *int64 `type:"integer"`

	// Contains the pending or in-progress change of the master credentials for
	// the DB instance.
	MasterUserPassword *string `type:"string"`

	// Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.
	MultiAZ *bool `type:"boolean"`

	// Specifies the pending port for the DB instance.
	Port *int64 `type:"integer"`

	// Specifies the storage type to be associated with the DB instance.
	StorageType *string `type:"string"`
}

// String returns the string representation
func (s PendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingModifiedValues) GoString() string {
	return s.String()
}

type PromoteReadReplicaInput struct {
	_ struct{} `type:"structure"`

	// The number of days to retain automated backups. Setting this parameter to
	// a positive number enables backups. Setting this parameter to 0 disables automated
	// backups.
	//
	//  Default: 1
	//
	// Constraints:
	//
	//  Must be a value from 0 to 8
	BackupRetentionPeriod *int64 `type:"integer"`

	// The DB instance identifier. This value is stored as a lowercase string.
	//
	// Constraints:
	//
	//  Must be the identifier for an existing Read Replica DB instance Must contain
	// from 1 to 63 alphanumeric characters or hyphens First character must be a
	// letter Cannot end with a hyphen or contain two consecutive hyphens  Example:
	// mydbinstance
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The daily time range during which automated backups are created if automated
	// backups are enabled, using the BackupRetentionPeriod parameter.
	//
	//  Default: A 30-minute window selected at random from an 8-hour block of
	// time per region. To see the time blocks available, see  Adjusting the Preferred
	// Maintenance Window (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html)
	// in the Amazon RDS User Guide.
	//
	// Constraints:
	//
	//  Must be in the format hh24:mi-hh24:mi. Times should be in Universal Coordinated
	// Time (UTC). Must not conflict with the preferred maintenance window. Must
	// be at least 30 minutes.
	PreferredBackupWindow *string `type:"string"`
}

// String returns the string representation
func (s PromoteReadReplicaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PromoteReadReplicaInput) GoString() string {
	return s.String()
}

type PromoteReadReplicaOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   CreateDBInstance   DeleteDBInstance   ModifyDBInstance   This data type
	// is used as a response element in the DescribeDBInstances action.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s PromoteReadReplicaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PromoteReadReplicaOutput) GoString() string {
	return s.String()
}

type PurchaseReservedDBInstancesOfferingInput struct {
	_ struct{} `type:"structure"`

	// The number of instances to reserve.
	//
	// Default: 1
	DBInstanceCount *int64 `type:"integer"`

	// Customer-specified identifier to track this reservation.
	//
	// Example: myreservationID
	ReservedDBInstanceId *string `type:"string"`

	// The ID of the Reserved DB instance offering to purchase.
	//
	// Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706
	ReservedDBInstancesOfferingId *string `type:"string" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s PurchaseReservedDBInstancesOfferingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseReservedDBInstancesOfferingInput) GoString() string {
	return s.String()
}

type PurchaseReservedDBInstancesOfferingOutput struct {
	_ struct{} `type:"structure"`

	// This data type is used as a response element in the DescribeReservedDBInstances
	// and PurchaseReservedDBInstancesOffering actions.
	ReservedDBInstance *ReservedDBInstance `type:"structure"`
}

// String returns the string representation
func (s PurchaseReservedDBInstancesOfferingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseReservedDBInstancesOfferingOutput) GoString() string {
	return s.String()
}

type RebootDBInstanceInput struct {
	_ struct{} `type:"structure"`

	// The DB instance identifier. This parameter is stored as a lowercase string.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens First character
	// must be a letter Cannot end with a hyphen or contain two consecutive hyphens
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// When true, the reboot will be conducted through a MultiAZ failover.
	//
	// Constraint: You cannot specify true if the instance is not configured for
	// MultiAZ.
	ForceFailover *bool `type:"boolean"`
}

// String returns the string representation
func (s RebootDBInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootDBInstanceInput) GoString() string {
	return s.String()
}

type RebootDBInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   CreateDBInstance   DeleteDBInstance   ModifyDBInstance   This data type
	// is used as a response element in the DescribeDBInstances action.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s RebootDBInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootDBInstanceOutput) GoString() string {
	return s.String()
}

// This data type is used as a response element in the DescribeReservedDBInstances
// and DescribeReservedDBInstancesOfferings actions.
type RecurringCharge struct {
	_ struct{} `type:"structure"`

	// The amount of the recurring charge.
	RecurringChargeAmount *float64 `type:"double"`

	// The frequency of the recurring charge.
	RecurringChargeFrequency *string `type:"string"`
}

// String returns the string representation
func (s RecurringCharge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecurringCharge) GoString() string {
	return s.String()
}

type RemoveSourceIdentifierFromSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The source identifier to be removed from the subscription, such as the DB
	// instance identifier for a DB instance or the name of a security group.
	SourceIdentifier *string `type:"string" required:"true"`

	// The name of the RDS event notification subscription you want to remove a
	// source identifier from.
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveSourceIdentifierFromSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveSourceIdentifierFromSubscriptionInput) GoString() string {
	return s.String()
}

type RemoveSourceIdentifierFromSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful invocation of the DescribeEventSubscriptions
	// action.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s RemoveSourceIdentifierFromSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveSourceIdentifierFromSubscriptionOutput) GoString() string {
	return s.String()
}

type RemoveTagsFromResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon RDS resource the tags will be removed from. This value is an Amazon
	// Resource Name (ARN). For information about creating an ARN, see  Constructing
	// an RDS Amazon Resource Name (ARN) (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN).
	ResourceName *string `type:"string" required:"true"`

	// The tag key (name) of the tag to be removed.
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceInput) GoString() string {
	return s.String()
}

type RemoveTagsFromResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsFromResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceOutput) GoString() string {
	return s.String()
}

// This data type is used as a response element in the DescribeReservedDBInstances
// and PurchaseReservedDBInstancesOffering actions.
type ReservedDBInstance struct {
	_ struct{} `type:"structure"`

	// The currency code for the reserved DB instance.
	CurrencyCode *string `type:"string"`

	// The DB instance class for the reserved DB instance.
	DBInstanceClass *string `type:"string"`

	// The number of reserved DB instances.
	DBInstanceCount *int64 `type:"integer"`

	// The duration of the reservation in seconds.
	Duration *int64 `type:"integer"`

	// The fixed price charged for this reserved DB instance.
	FixedPrice *float64 `type:"double"`

	// Indicates if the reservation applies to Multi-AZ deployments.
	MultiAZ *bool `type:"boolean"`

	// The offering type of this reserved DB instance.
	OfferingType *string `type:"string"`

	// The description of the reserved DB instance.
	ProductDescription *string `type:"string"`

	// The recurring price charged to run this reserved DB instance.
	RecurringCharges []*RecurringCharge `locationNameList:"RecurringCharge" type:"list"`

	// The unique identifier for the reservation.
	ReservedDBInstanceId *string `type:"string"`

	// The offering identifier.
	ReservedDBInstancesOfferingId *string `type:"string"`

	// The time the reservation started.
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The state of the reserved DB instance.
	State *string `type:"string"`

	// The hourly price charged for this reserved DB instance.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation
func (s ReservedDBInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedDBInstance) GoString() string {
	return s.String()
}

// This data type is used as a response element in the DescribeReservedDBInstancesOfferings
// action.
type ReservedDBInstancesOffering struct {
	_ struct{} `type:"structure"`

	// The currency code for the reserved DB instance offering.
	CurrencyCode *string `type:"string"`

	// The DB instance class for the reserved DB instance.
	DBInstanceClass *string `type:"string"`

	// The duration of the offering in seconds.
	Duration *int64 `type:"integer"`

	// The fixed price charged for this offering.
	FixedPrice *float64 `type:"double"`

	// Indicates if the offering applies to Multi-AZ deployments.
	MultiAZ *bool `type:"boolean"`

	// The offering type.
	OfferingType *string `type:"string"`

	// The database engine used by the offering.
	ProductDescription *string `type:"string"`

	// The recurring price charged to run this reserved DB instance.
	RecurringCharges []*RecurringCharge `locationNameList:"RecurringCharge" type:"list"`

	// The offering identifier.
	ReservedDBInstancesOfferingId *string `type:"string"`

	// The hourly price charged for this offering.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation
func (s ReservedDBInstancesOffering) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedDBInstancesOffering) GoString() string {
	return s.String()
}

type ResetDBClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster parameter group to reset.
	DBClusterParameterGroupName *string `type:"string" required:"true"`

	// A list of parameter names in the DB cluster parameter group to reset to the
	// default values. You cannot use this parameter if the ResetAllParameters parameter
	// is set to true.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`

	// A value that is set to true to reset all parameters in the DB cluster parameter
	// group to their default values, and false otherwise. You cannot use this parameter
	// if there is a list of parameter names specified for the Parameters parameter.
	ResetAllParameters *bool `type:"boolean"`
}

// String returns the string representation
func (s ResetDBClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetDBClusterParameterGroupInput) GoString() string {
	return s.String()
}

type ResetDBParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB parameter group.
	//
	// Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens
	DBParameterGroupName *string `type:"string" required:"true"`

	// An array of parameter names, values, and the apply method for the parameter
	// update. At least one parameter name, value, and apply method must be supplied;
	// subsequent arguments are optional. A maximum of 20 parameters can be modified
	// in a single request.
	//
	//  MySQL
	//
	// Valid Values (for Apply method): immediate | pending-reboot
	//
	// You can use the immediate value with dynamic parameters only. You can use
	// the pending-reboot value for both dynamic and static parameters, and changes
	// are applied when DB instance reboots.
	//
	//  MariaDB
	//
	// Valid Values (for Apply method): immediate | pending-reboot
	//
	// You can use the immediate value with dynamic parameters only. You can use
	// the pending-reboot value for both dynamic and static parameters, and changes
	// are applied when DB instance reboots.
	//
	//  Oracle
	//
	// Valid Values (for Apply method): pending-reboot
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`

	// Specifies whether (true) or not (false) to reset all parameters in the DB
	// parameter group to default values.
	//
	// Default: true
	ResetAllParameters *bool `type:"boolean"`
}

// String returns the string representation
func (s ResetDBParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetDBParameterGroupInput) GoString() string {
	return s.String()
}

// Describes the pending maintenance actions for a resource.
type ResourcePendingMaintenanceActions struct {
	_ struct{} `type:"structure"`

	// A list that provides details about the pending maintenance actions for the
	// resource.
	PendingMaintenanceActionDetails []*PendingMaintenanceAction `locationNameList:"PendingMaintenanceAction" type:"list"`

	// The ARN of the resource that has pending maintenance actions.
	ResourceIdentifier *string `type:"string"`
}

// String returns the string representation
func (s ResourcePendingMaintenanceActions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourcePendingMaintenanceActions) GoString() string {
	return s.String()
}

type RestoreDBClusterFromSnapshotInput struct {
	_ struct{} `type:"structure"`

	// Provides the list of EC2 Availability Zones that instances in the restored
	// DB cluster can be created in.
	AvailabilityZones []*string `locationNameList:"AvailabilityZone" type:"list"`

	// The name of the DB cluster to create from the DB cluster snapshot. This parameter
	// isn't case-sensitive.
	//
	// Constraints:
	//
	//  Must contain from 1 to 255 alphanumeric characters or hyphens First character
	// must be a letter Cannot end with a hyphen or contain two consecutive hyphens
	//  Example: my-snapshot-id
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The name of the DB subnet group to use for the new DB cluster.
	DBSubnetGroupName *string `type:"string"`

	// The database name for the restored DB cluster.
	DatabaseName *string `type:"string"`

	// The database engine to use for the new DB cluster.
	//
	// Default: The same as source
	//
	// Constraint: Must be compatible with the engine of the source
	Engine *string `type:"string" required:"true"`

	// The version of the database engine to use for the new DB cluster.
	EngineVersion *string `type:"string"`

	// The KMS key identifier to use when restoring an encrypted DB cluster from
	// an encrypted DB cluster snapshot.
	//
	// The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption
	// key. If you are restoring a DB cluster with the same AWS account that owns
	// the KMS encryption key used to encrypt the new DB cluster, then you can use
	// the KMS key alias instead of the ARN for the KMS encryption key.
	//
	// If you do not specify a value for the KmsKeyId parameter, then the following
	// will occur:
	//
	//  If the DB cluster snapshot is encrypted, then the restored DB cluster is
	// encrypted using the KMS key that was used to encrypt the DB cluster snapshot.
	// If the DB cluster snapshot is not encrypted, then the restored DB cluster
	// is not encrypted.  If SnapshotIdentifier refers to a DB cluster snapshot
	// that is not encrypted, and you specify a value for the KmsKeyId parameter,
	// then the restore request is rejected.
	KmsKeyId *string `type:"string"`

	// The name of the option group to use for the restored DB cluster.
	OptionGroupName *string `type:"string"`

	// The port number on which the new DB cluster accepts connections.
	//
	// Constraints: Value must be 1150-65535
	//
	// Default: The same port as the original DB cluster.
	Port *int64 `type:"integer"`

	// The identifier for the DB cluster snapshot to restore from.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens First character
	// must be a letter Cannot end with a hyphen or contain two consecutive hyphens
	SnapshotIdentifier *string `type:"string" required:"true"`

	// The tags to be assigned to the restored DB cluster.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A list of VPC security groups that the new DB cluster will belong to.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s RestoreDBClusterFromSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBClusterFromSnapshotInput) GoString() string {
	return s.String()
}

type RestoreDBClusterFromSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   CreateDBCluster   DeleteDBCluster   FailoverDBCluster   ModifyDBCluster
	//   RestoreDBClusterFromSnapshot   This data type is used as a response element
	// in the DescribeDBClusters action.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s RestoreDBClusterFromSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBClusterFromSnapshotOutput) GoString() string {
	return s.String()
}

type RestoreDBClusterToPointInTimeInput struct {
	_ struct{} `type:"structure"`

	// The name of the new DB cluster to be created.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens First character
	// must be a letter Cannot end with a hyphen or contain two consecutive hyphens
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The DB subnet group name to use for the new DB cluster.
	DBSubnetGroupName *string `type:"string"`

	// The KMS key identifier to use when restoring an encrypted DB cluster from
	// an encrypted DB cluster.
	//
	// The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption
	// key. If you are restoring a DB cluster with the same AWS account that owns
	// the KMS encryption key used to encrypt the new DB cluster, then you can use
	// the KMS key alias instead of the ARN for the KMS encryption key.
	//
	// You can restore to a new DB cluster and encrypt the new DB cluster with
	// a KMS key that is different than the KMS key used to encrypt the source DB
	// cluster. The new DB cluster will be encrypted with the KMS key identified
	// by the KmsKeyId parameter.
	//
	// If you do not specify a value for the KmsKeyId parameter, then the following
	// will occur:
	//
	//  If the DB cluster is encrypted, then the restored DB cluster is encrypted
	// using the KMS key that was used to encrypt the source DB cluster.  If the
	// DB cluster is not encrypted, then the restored DB cluster is not encrypted.
	// If DBClusterIdentifier refers to a DB cluster that is note encrypted, then
	// the restore request is rejected.
	KmsKeyId *string `type:"string"`

	// The name of the option group for the new DB cluster.
	OptionGroupName *string `type:"string"`

	// The port number on which the new DB cluster accepts connections.
	//
	// Constraints: Value must be 1150-65535
	//
	// Default: The same port as the original DB cluster.
	Port *int64 `type:"integer"`

	// The date and time to restore the DB cluster to.
	//
	// Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
	//
	// Constraints:
	//
	//  Must be before the latest restorable time for the DB instance Cannot be
	// specified if UseLatestRestorableTime parameter is true  Example: 2015-03-07T23:45:00Z
	RestoreToTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The identifier of the source DB cluster from which to restore.
	//
	// Constraints:
	//
	//  Must be the identifier of an existing database instance Must contain from
	// 1 to 63 alphanumeric characters or hyphens First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens
	SourceDBClusterIdentifier *string `type:"string" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A value that is set to true to restore the DB cluster to the latest restorable
	// backup time, and false otherwise.
	//
	// Default: false
	//
	// Constraints: Cannot be specified if RestoreToTime parameter is provided.
	UseLatestRestorableTime *bool `type:"boolean"`

	// A lst of VPC security groups that the new DB cluster belongs to.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s RestoreDBClusterToPointInTimeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBClusterToPointInTimeInput) GoString() string {
	return s.String()
}

type RestoreDBClusterToPointInTimeOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   CreateDBCluster   DeleteDBCluster   FailoverDBCluster   ModifyDBCluster
	//   RestoreDBClusterFromSnapshot   This data type is used as a response element
	// in the DescribeDBClusters action.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s RestoreDBClusterToPointInTimeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBClusterToPointInTimeOutput) GoString() string {
	return s.String()
}

type RestoreDBInstanceFromDBSnapshotInput struct {
	_ struct{} `type:"structure"`

	// Indicates that minor version upgrades will be applied automatically to the
	// DB instance during the maintenance window.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The EC2 Availability Zone that the database instance will be created in.
	//
	// Default: A random, system-chosen Availability Zone.
	//
	// Constraint: You cannot specify the AvailabilityZone parameter if the MultiAZ
	// parameter is set to true.
	//
	// Example: us-east-1a
	AvailabilityZone *string `type:"string"`

	// True to copy all tags from the restored DB instance to snapshots of the DB
	// instance; otherwise false. The default is false.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// The compute and memory capacity of the Amazon RDS DB instance.
	//
	// Valid Values: db.t1.micro | db.m1.small | db.m1.medium | db.m1.large | db.m1.xlarge
	// | db.m2.2xlarge | db.m2.4xlarge | db.m3.medium | db.m3.large | db.m3.xlarge
	// | db.m3.2xlarge | db.m4.large | db.m4.xlarge | db.m4.2xlarge | db.m4.4xlarge
	// | db.m4.10xlarge | db.r3.large | db.r3.xlarge | db.r3.2xlarge | db.r3.4xlarge
	// | db.r3.8xlarge | db.t2.micro | db.t2.small | db.t2.medium | db.t2.large
	DBInstanceClass *string `type:"string"`

	// Name of the DB instance to create from the DB snapshot. This parameter isn't
	// case-sensitive.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens (1 to 15 for
	// SQL Server) First character must be a letter Cannot end with a hyphen or
	// contain two consecutive hyphens  Example: my-snapshot-id
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The database name for the restored DB instance.
	//
	//  This parameter doesn't apply to the MySQL or MariaDB engines.
	DBName *string `type:"string"`

	// The identifier for the DB snapshot to restore from.
	//
	// Constraints:
	//
	//  Must contain from 1 to 255 alphanumeric characters or hyphens First character
	// must be a letter Cannot end with a hyphen or contain two consecutive hyphens
	//  If you are restoring from a shared manual DB snapshot, the DBSnapshotIdentifier
	// must be the ARN of the shared DB snapshot.
	DBSnapshotIdentifier *string `type:"string" required:"true"`

	// The DB subnet group name to use for the new instance.
	DBSubnetGroupName *string `type:"string"`

	// The database engine to use for the new instance.
	//
	// Default: The same as source
	//
	// Constraint: Must be compatible with the engine of the source
	//
	//  Valid Values: MySQL | mariadb | oracle-se1 | oracle-se | oracle-ee | sqlserver-ee
	// | sqlserver-se | sqlserver-ex | sqlserver-web | postgres | aurora
	Engine *string `type:"string"`

	// Specifies the amount of provisioned IOPS for the DB instance, expressed in
	// I/O operations per second. If this parameter is not specified, the IOPS value
	// will be taken from the backup. If this parameter is set to 0, the new instance
	// will be converted to a non-PIOPS instance, which will take additional time,
	// though your DB instance will be available for connections before the conversion
	// starts.
	//
	//  Constraints: Must be an integer greater than 1000.
	//
	//  SQL Server
	//
	// Setting the IOPS value for the SQL Server database engine is not supported.
	Iops *int64 `type:"integer"`

	// License model information for the restored DB instance.
	//
	//  Default: Same as source.
	//
	//  Valid values: license-included | bring-your-own-license | general-public-license
	LicenseModel *string `type:"string"`

	// Specifies if the DB instance is a Multi-AZ deployment.
	//
	// Constraint: You cannot specify the AvailabilityZone parameter if the MultiAZ
	// parameter is set to true.
	MultiAZ *bool `type:"boolean"`

	// The name of the option group to be used for the restored DB instance.
	//
	// Permanent options, such as the TDE option for Oracle Advanced Security TDE,
	// cannot be removed from an option group, and that option group cannot be removed
	// from a DB instance once it is associated with a DB instance
	OptionGroupName *string `type:"string"`

	// The port number on which the database accepts connections.
	//
	// Default: The same port as the original DB instance
	//
	// Constraints: Value must be 1150-65535
	Port *int64 `type:"integer"`

	// Specifies the accessibility options for the DB instance. A value of true
	// specifies an Internet-facing instance with a publicly resolvable DNS name,
	// which resolves to a public IP address. A value of false specifies an internal
	// instance with a DNS name that resolves to a private IP address.
	//
	//  Default: The default behavior varies depending on whether a VPC has been
	// requested or not. The following list shows the default behavior in each case.
	//
	//   Default VPC: true  VPC: false   If no DB subnet group has been specified
	// as part of the request and the PubliclyAccessible value has not been set,
	// the DB instance will be publicly accessible. If a specific DB subnet group
	// has been specified as part of the request and the PubliclyAccessible value
	// has not been set, the DB instance will be private.
	PubliclyAccessible *bool `type:"boolean"`

	// Specifies the storage type to be associated with the DB instance.
	//
	//  Valid values: standard | gp2 | io1
	//
	//  If you specify io1, you must also include a value for the Iops parameter.
	//
	//  Default: io1 if the Iops parameter is specified; otherwise standard
	StorageType *string `type:"string"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The ARN from the Key Store with which to associate the instance for TDE encryption.
	TdeCredentialArn *string `type:"string"`

	// The password for the given ARN from the Key Store in order to access the
	// device.
	TdeCredentialPassword *string `type:"string"`
}

// String returns the string representation
func (s RestoreDBInstanceFromDBSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBInstanceFromDBSnapshotInput) GoString() string {
	return s.String()
}

type RestoreDBInstanceFromDBSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   CreateDBInstance   DeleteDBInstance   ModifyDBInstance   This data type
	// is used as a response element in the DescribeDBInstances action.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s RestoreDBInstanceFromDBSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBInstanceFromDBSnapshotOutput) GoString() string {
	return s.String()
}

type RestoreDBInstanceToPointInTimeInput struct {
	_ struct{} `type:"structure"`

	// Indicates that minor version upgrades will be applied automatically to the
	// DB instance during the maintenance window.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The EC2 Availability Zone that the database instance will be created in.
	//
	// Default: A random, system-chosen Availability Zone.
	//
	// Constraint: You cannot specify the AvailabilityZone parameter if the MultiAZ
	// parameter is set to true.
	//
	// Example: us-east-1a
	AvailabilityZone *string `type:"string"`

	// True to copy all tags from the restored DB instance to snapshots of the DB
	// instance; otherwise false. The default is false.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// The compute and memory capacity of the Amazon RDS DB instance.
	//
	// Valid Values: db.t1.micro | db.m1.small | db.m1.medium | db.m1.large | db.m1.xlarge
	// | db.m2.2xlarge | db.m2.4xlarge | db.m3.medium | db.m3.large | db.m3.xlarge
	// | db.m3.2xlarge | db.m4.large | db.m4.xlarge | db.m4.2xlarge | db.m4.4xlarge
	// | db.m4.10xlarge | db.r3.large | db.r3.xlarge | db.r3.2xlarge | db.r3.4xlarge
	// | db.r3.8xlarge | db.t2.micro | db.t2.small | db.t2.medium | db.t2.large
	//
	// Default: The same DBInstanceClass as the original DB instance.
	DBInstanceClass *string `type:"string"`

	// The database name for the restored DB instance.
	//
	//  This parameter is not used for the MySQL or MariaDB engines.
	DBName *string `type:"string"`

	// The DB subnet group name to use for the new instance.
	DBSubnetGroupName *string `type:"string"`

	// The database engine to use for the new instance.
	//
	// Default: The same as source
	//
	// Constraint: Must be compatible with the engine of the source
	//
	//  Valid Values: MySQL | mariadb | oracle-se1 | oracle-se | oracle-ee | sqlserver-ee
	// | sqlserver-se | sqlserver-ex | sqlserver-web | postgres| aurora
	Engine *string `type:"string"`

	// The amount of Provisioned IOPS (input/output operations per second) to be
	// initially allocated for the DB instance.
	//
	//  Constraints: Must be an integer greater than 1000.
	//
	//  SQL Server
	//
	// Setting the IOPS value for the SQL Server database engine is not supported.
	Iops *int64 `type:"integer"`

	// License model information for the restored DB instance.
	//
	//  Default: Same as source.
	//
	//  Valid values: license-included | bring-your-own-license | general-public-license
	LicenseModel *string `type:"string"`

	// Specifies if the DB instance is a Multi-AZ deployment.
	//
	// Constraint: You cannot specify the AvailabilityZone parameter if the MultiAZ
	// parameter is set to true.
	MultiAZ *bool `type:"boolean"`

	// The name of the option group to be used for the restored DB instance.
	//
	// Permanent options, such as the TDE option for Oracle Advanced Security TDE,
	// cannot be removed from an option group, and that option group cannot be removed
	// from a DB instance once it is associated with a DB instance
	OptionGroupName *string `type:"string"`

	// The port number on which the database accepts connections.
	//
	// Constraints: Value must be 1150-65535
	//
	// Default: The same port as the original DB instance.
	Port *int64 `type:"integer"`

	// Specifies the accessibility options for the DB instance. A value of true
	// specifies an Internet-facing instance with a publicly resolvable DNS name,
	// which resolves to a public IP address. A value of false specifies an internal
	// instance with a DNS name that resolves to a private IP address.
	//
	//  Default: The default behavior varies depending on whether a VPC has been
	// requested or not. The following list shows the default behavior in each case.
	//
	//   Default VPC:true  VPC:false   If no DB subnet group has been specified
	// as part of the request and the PubliclyAccessible value has not been set,
	// the DB instance will be publicly accessible. If a specific DB subnet group
	// has been specified as part of the request and the PubliclyAccessible value
	// has not been set, the DB instance will be private.
	PubliclyAccessible *bool `type:"boolean"`

	// The date and time to restore from.
	//
	// Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
	//
	// Constraints:
	//
	//  Must be before the latest restorable time for the DB instance Cannot be
	// specified if UseLatestRestorableTime parameter is true  Example: 2009-09-07T23:45:00Z
	RestoreTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The identifier of the source DB instance from which to restore.
	//
	// Constraints:
	//
	//  Must be the identifier of an existing database instance Must contain from
	// 1 to 63 alphanumeric characters or hyphens First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens
	SourceDBInstanceIdentifier *string `type:"string" required:"true"`

	// Specifies the storage type to be associated with the DB instance.
	//
	//  Valid values: standard | gp2 | io1
	//
	//  If you specify io1, you must also include a value for the Iops parameter.
	//
	//  Default: io1 if the Iops parameter is specified; otherwise standard
	StorageType *string `type:"string"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The name of the new database instance to be created.
	//
	// Constraints:
	//
	//  Must contain from 1 to 63 alphanumeric characters or hyphens First character
	// must be a letter Cannot end with a hyphen or contain two consecutive hyphens
	TargetDBInstanceIdentifier *string `type:"string" required:"true"`

	// The ARN from the Key Store with which to associate the instance for TDE encryption.
	TdeCredentialArn *string `type:"string"`

	// The password for the given ARN from the Key Store in order to access the
	// device.
	TdeCredentialPassword *string `type:"string"`

	// Specifies whether (true) or not (false) the DB instance is restored from
	// the latest backup time.
	//
	// Default: false
	//
	// Constraints: Cannot be specified if RestoreTime parameter is provided.
	UseLatestRestorableTime *bool `type:"boolean"`
}

// String returns the string representation
func (s RestoreDBInstanceToPointInTimeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBInstanceToPointInTimeInput) GoString() string {
	return s.String()
}

type RestoreDBInstanceToPointInTimeOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   CreateDBInstance   DeleteDBInstance   ModifyDBInstance   This data type
	// is used as a response element in the DescribeDBInstances action.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s RestoreDBInstanceToPointInTimeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBInstanceToPointInTimeOutput) GoString() string {
	return s.String()
}

type RevokeDBSecurityGroupIngressInput struct {
	_ struct{} `type:"structure"`

	// The IP range to revoke access from. Must be a valid CIDR range. If CIDRIP
	// is specified, EC2SecurityGroupName, EC2SecurityGroupId and EC2SecurityGroupOwnerId
	// cannot be provided.
	CIDRIP *string `type:"string"`

	// The name of the DB security group to revoke ingress from.
	DBSecurityGroupName *string `type:"string" required:"true"`

	// The id of the EC2 security group to revoke access from. For VPC DB security
	// groups, EC2SecurityGroupId must be provided. Otherwise, EC2SecurityGroupOwnerId
	// and either EC2SecurityGroupName or EC2SecurityGroupId must be provided.
	EC2SecurityGroupId *string `type:"string"`

	// The name of the EC2 security group to revoke access from. For VPC DB security
	// groups, EC2SecurityGroupId must be provided. Otherwise, EC2SecurityGroupOwnerId
	// and either EC2SecurityGroupName or EC2SecurityGroupId must be provided.
	EC2SecurityGroupName *string `type:"string"`

	// The AWS Account Number of the owner of the EC2 security group specified in
	// the EC2SecurityGroupName parameter. The AWS Access Key ID is not an acceptable
	// value. For VPC DB security groups, EC2SecurityGroupId must be provided. Otherwise,
	// EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId
	// must be provided.
	EC2SecurityGroupOwnerId *string `type:"string"`
}

// String returns the string representation
func (s RevokeDBSecurityGroupIngressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeDBSecurityGroupIngressInput) GoString() string {
	return s.String()
}

type RevokeDBSecurityGroupIngressOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//   DescribeDBSecurityGroups   AuthorizeDBSecurityGroupIngress   CreateDBSecurityGroup
	//   RevokeDBSecurityGroupIngress   This data type is used as a response element
	// in the DescribeDBSecurityGroups action.
	DBSecurityGroup *DBSecurityGroup `type:"structure"`
}

// String returns the string representation
func (s RevokeDBSecurityGroupIngressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeDBSecurityGroupIngressOutput) GoString() string {
	return s.String()
}

// This data type is used as a response element in the DescribeDBSubnetGroups
// action.
type Subnet struct {
	_ struct{} `type:"structure"`

	// Contains Availability Zone information.
	//
	//  This data type is used as an element in the following data type: OrderableDBInstanceOption
	SubnetAvailabilityZone *AvailabilityZone `type:"structure"`

	// Specifies the identifier of the subnet.
	SubnetIdentifier *string `type:"string"`

	// Specifies the status of the subnet.
	SubnetStatus *string `type:"string"`
}

// String returns the string representation
func (s Subnet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Subnet) GoString() string {
	return s.String()
}

// Metadata assigned to an Amazon RDS resource consisting of a key-value pair.
type Tag struct {
	_ struct{} `type:"structure"`

	// A key is the required name of the tag. The string value can be from 1 to
	// 128 Unicode characters in length and cannot be prefixed with "aws:" or "rds:".
	// The string can only contain only the set of Unicode letters, digits, white-space,
	// '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	Key *string `type:"string"`

	// A value is the optional value of the tag. The string value can be from 1
	// to 256 Unicode characters in length and cannot be prefixed with "aws:" or
	// "rds:". The string can only contain only the set of Unicode letters, digits,
	// white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// The version of the database engine that a DB instance can be upgraded to.
type UpgradeTarget struct {
	_ struct{} `type:"structure"`

	// A value that indicates whether the target version will be applied to any
	// source DB instances that have AutoMinorVersionUpgrade set to true.
	AutoUpgrade *bool `type:"boolean"`

	// The version of the database engine that a DB instance can be upgraded to.
	Description *string `type:"string"`

	// The name of the upgrade target database engine.
	Engine *string `type:"string"`

	// The version number of the upgrade target database engine.
	EngineVersion *string `type:"string"`

	// A value that indicates whether a database engine will be upgraded to a major
	// version.
	IsMajorVersionUpgrade *bool `type:"boolean"`
}

// String returns the string representation
func (s UpgradeTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpgradeTarget) GoString() string {
	return s.String()
}

// This data type is used as a response element for queries on VPC security
// group membership.
type VpcSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The status of the VPC security group.
	Status *string `type:"string"`

	// The name of the VPC security group.
	VpcSecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s VpcSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcSecurityGroupMembership) GoString() string {
	return s.String()
}

const (
	// @enum ApplyMethod
	ApplyMethodImmediate = "immediate"
	// @enum ApplyMethod
	ApplyMethodPendingReboot = "pending-reboot"
)

const (
	// @enum SourceType
	SourceTypeDbInstance = "db-instance"
	// @enum SourceType
	SourceTypeDbParameterGroup = "db-parameter-group"
	// @enum SourceType
	SourceTypeDbSecurityGroup = "db-security-group"
	// @enum SourceType
	SourceTypeDbSnapshot = "db-snapshot"
	// @enum SourceType
	SourceTypeDbCluster = "db-cluster"
	// @enum SourceType
	SourceTypeDbClusterSnapshot = "db-cluster-snapshot"
)
