/*
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *                                                            1998, 2010
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * Support:
 *     http://sourceforge.net/projects/sarg/forums/forum/363374
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

int totalger(const char *dirname, int debug, const char *outdir)
{
   FILE *fp_in, *fp_ou;
   long long int tnacc=0;
   long long int tnbytes=0;
   long long int telap=0;
   long long int tincache=0, toucache=0;
   long long int nacc, nbytes;
   long long int elap;
   long long int incac, oucac;
   char wger[MAXLEN], user[MAXLEN], url[MAXLEN];
   char ip[MAXLEN], hora[9], data[15];
   char warea[MAXLEN];
   struct getwordstruct gwarea;

   strcpy(wger,dirname);
   strcat(wger,"/sarg-general");

   if((fp_in=fopen(wger,"r"))==NULL) {
      fprintf(stderr, "SARG: (totger) %s: %s\n",text[45],wger);
      exit(1);
   }

   while(fgets(warea,sizeof(warea),fp_in))
   {
      //printf("%s\n",warea);
      getword_start(&gwarea,warea);
      if (getword(user,sizeof(user),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken user in your %s file.\n",wger);
         exit(1);
      }
      if (getword_atoll(&nacc,&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken number of access in your %s file.\n",wger);
         exit(1);
      }
      if (getword_atoll(&nbytes,&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken number of bytes in your %s file.\n",wger);
         exit(1);
      }
      if (getword(url,sizeof(url),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken url in your %s file.\n",wger);
         exit(1);
      }
      if (getword(ip,sizeof(ip),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken source IP address in your %s file.\n",wger);
         exit(1);
      }
      if (getword(hora,sizeof(hora),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken time in your %s file.\n",wger);
         exit(1);
      }
      if (getword(data,sizeof(data),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken date in your %s file.\n",wger);
         exit(1);
      }
      if (getword_atoll(&elap,&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken elapsed time in your %s file.\n",wger);
         exit(1);
      }
      if (getword_atoll(&incac,&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken in cache column in your %s file.\n",wger);
         exit(1);
      }
      if (getword_atoll(&oucac,&gwarea,'\n')<0) {
         printf("SARG: Maybe you have a broken not in cache column in your %s file.\n",wger);
         exit(1);
      }
      tnacc+=nacc;
      tnbytes+=nbytes;
      telap+=elap;
      tincache+=incac;
      toucache+=oucac;
   }

   fclose(fp_in);

   strcpy(wger,dirname);
   strcat(wger,"/sarg-general");

   if((fp_ou=fopen(wger,"a"))==NULL) {
    fprintf(stderr, "SARG: (totger) %s: %s\n",text[45],wger);
    exit(1);
   }

   url[0]='\0';

   my_lltoa(tnacc,val1,15);
   my_lltoa(tnbytes,val2,15);
   my_lltoa(telap,val3,15);
   my_lltoa(tincache,val4,15);
   my_lltoa(toucache,val5,15);
   fprintf(fp_ou,"TOTAL\t%s\t%s\t%s\t%s\t%s\n",val1,val2,val3,val4,val5);
   fclose(fp_ou);

   return (0);
}
