/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: od.sl.xsl,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hbrinkm $ $Date: 2006/11/01 09:14:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:office="urn:oasis:names:tc:opendocument:xmlns:office:1.0" xmlns:style="urn:oasis:names:tc:opendocument:xmlns:style:1.0" xmlns:text="urn:oasis:names:tc:opendocument:xmlns:text:1.0" xmlns:table="urn:oasis:names:tc:opendocument:xmlns:table:1.0" xmlns:draw="urn:oasis:names:tc:opendocument:xmlns:drawing:1.0" xmlns:fo="urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:meta="urn:oasis:names:tc:opendocument:xmlns:meta:1.0" xmlns:number="urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0" xmlns:svg="urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0" xmlns:chart="urn:oasis:names:tc:opendocument:xmlns:chart:1.0" xmlns:dr3d="urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0" xmlns:math="http://www.w3.org/1998/Math/MathML" xmlns:form="urn:oasis:names:tc:opendocument:xmlns:form:1.0" xmlns:script="urn:oasis:names:tc:opendocument:xmlns:script:1.0" xmlns:config="urn:oasis:names:tc:opendocument:xmlns:config:1.0" xmlns:ooo="http://openoffice.org/2004/office" xmlns:ooow="http://openoffice.org/2004/writer" xmlns:oooc="http://openoffice.org/2004/calc" xmlns:dom="http://www.w3.org/2001/xml-events" xmlns:xforms="http://www.w3.org/2002/xforms" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"  
  xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#" xmlns:UML = 'org.omg.xmi.namespace.UML' xml:space="default">
<xsl:output method="text" />

<xsl:template match="/">
<out xml:space="preserve">
#include &lt;odiapi/sl/od_sl.hxx&gt;
#include &lt;stack&gt;
#include &lt;hash_map&gt;

#include &lt;stdio.h&gt;

using namespace writerfilter;
using namespace odiapi;

class StyleReferenceValue : public xxml::Value
{
	odiapi::props::PropertyPoolHandle_Pointer_t ph;
public:
	void setStyleReference(odiapi::props::PropertyPoolHandle_Pointer_t &amp;ph)
	{
		this->ph=ph;
	}


	int getStyleName(char *buf) const
	{
		return sprintf(buf, "S%p", ph.get());
	}
	virtual rtl::OUString getOUString() const
	{
		char buf[50];
		int len=getStyleName(buf);
		return rtl::OUString((const sal_Char *)buf, len, RTL_TEXTENCODING_UTF8);
	}
	virtual rtl::OString getOString() const
	{
		char buf[50];
		int len=getStyleName(buf);
		return rtl::OString((const sal_Char *)buf, len);
	}
	virtual std::string getString() const
	{
		char buf[50];
		int len=getStyleName(buf);
		return std::string(buf, len);
	}
	virtual QName_t getQName() const
	{
		return NULL;
	}
};


class ODSLHandlerImpl : public ODSLHandler
{
private:
	std::stack&lt;props::PropertyBag_Pointer_t&gt; stack;
	props::PropertyPool::Pointer_t pool;
	typedef std::hash_map&lt;QName_t, odiapi::props::PropertyPoolHandle_Pointer_t&gt; styles_map;
    styles_map styles;
	int ignoreLevel;
	int automatic_style_level;
	props::Property::Pointer_t style_name;
	std::string style_name_id;	
	writerfilter::xxml::ContentHandler &amp;bridgeHandler;
	typedef std::hash_multimap&lt;QName_t, odiapi::props::Property::Pointer_t&gt; unresolved_map;
	unresolved_map unresolved;
public:
	ODSLHandlerImpl(odiapi::props::PropertyPool::Pointer_t propertyPool, writerfilter::xxml::ContentHandler &amp;bridgeHandler)
		: pool(propertyPool), bridgeHandler(bridgeHandler)
	{
	}
	virtual void startDocument()
	{
	ignoreLevel=0;
	automatic_style_level=0;
	bridgeHandler.startDocument();
	}
	void resolveReferences()
	{
		for(unresolved_map::iterator i=unresolved.begin();i!=unresolved.end();
			i++)
		{
			printf("%s:%s\n", QName::serializer().getNamespaceUri(i->first), QName::serializer().getLocalName(i->first));
			styles_map::iterator j=styles.find(i->first);
			if (j!=styles.end())
			{
				odiapi::props::PropertyPoolHandle_Pointer_t _resolve=j->second;
				odiapi::props::Property::Pointer_t _ref=i->second;
				_ref->resolve(_resolve);
			}
			else
			{
				printf("not found: %s:%s\n", QName::serializer().getNamespaceUri(i->first), QName::serializer().getLocalName(i->first));
			}
		}

	}

	void resolveReferences(QName_t proxy, odiapi::props::PropertyPoolHandle_Pointer_t solution)
	{
		std::pair&lt;unresolved_map::iterator, unresolved_map::iterator&gt; range=unresolved.equal_range(proxy);
		for(unresolved_map::iterator i=range.first;i!=range.second;i++)
		{
			odiapi::props::Property::Pointer_t _ref=i->second;
			_ref->resolve(solution);
		}
		unresolved.erase(range.first, range.second);
		/*
		for(unresolved_map::iterator i=unresolved.begin();i!=unresolved.end();
			i++)
		{
			printf("%s:%s\n", QName::serializer().getNamespaceUri(i->first), QName::serializer().getLocalName(i->first));
			styles_map::iterator j=styles.find(i->first);
			if (j!=styles.end())
			{
				odiapi::props::PropertyPoolHandle_Pointer_t _resolve=j->second;
				odiapi::props::Property::Pointer_t _ref=i->second;
				_ref->resolve(_resolve);
			}
			else
			{
				printf("not found: %s:%s\n", QName::serializer().getNamespaceUri(i->first), QName::serializer().getLocalName(i->first));
			}
		}
		*/
	}
	virtual void endDocument()
	{
	bridgeHandler.endDocument();
	}
	virtual void startElement(QName_t name, QName_t attrName[], const xxml::Value *attrValue[], int attrs)
	{
		if (ignoreLevel>0)
		{
			if (name==NS_text::LN_p)
			{
				StyleReferenceValue styleRefValue;
				for(int i=0;i&lt;attrs;i++)
				{
					if (attrName[i]==NS_text::LN_style_name)
					{
						QName_t id=writerfilter::QName::tokenizer().insert("paragraph", attrValue[i]->getString().c_str());
						odiapi::props::PropertyPoolHandle_Pointer_t &style=styles[id];
						styleRefValue.setStyleReference(style);
						attrValue[i]=&styleRefValue;
						/*
						if (style.get()!=NULL)
						{
							printf("style=%i\n", style->getId());
						}
						*/
					}
				}
			}
			bridgeHandler.startElement(name, attrName, attrValue, attrs);
			ignoreLevel++;
			return;
		}
		switch(name)
		{
<xsl:apply-templates mode="startElement"/>

			case NS_office::LN_document:
			case NS_office::LN_document_styles:
			case NS_office::LN_document_content:
				bridgeHandler.startElement(name, attrName, attrValue, attrs);
				break;
			case NS_office::LN_styles:
				break;
			case NS_office::LN_automatic_styles:
				automatic_style_level++;
				break;
			default:
				bridgeHandler.startElement(name, attrName, attrValue, attrs);
				ignoreLevel++;
				break;
		};
	}

<xsl:for-each select="//UML:Class[@name]">
	void attribute_<xsl:value-of select="translate(@name, ':-', '__')"/>(QName_t name, const xxml::Value *value)
	{
		switch(name)
		{
<xsl:if test="@name='style:style'">
		case NS_style::LN_name: 
			style_name_id=value->getString();
			style_name=props::createStringProperty(NS_style::LN_display_name, value->getString());
 
		break;
</xsl:if>
<xsl:apply-templates mode="attribute"/>
default: break;
		};
	}
</xsl:for-each>

	virtual void endElement(QName_t name)
	{
		if (ignoreLevel > 0)
		{
		bridgeHandler.endElement(name);
		ignoreLevel--;
		return;	
		}
		switch(name)
		{
<xsl:apply-templates mode="endElement"/>
case NS_style::LN_style:
			{
//		printf("&lt;/{%s}:%s [%i]&gt;\n", QName::serializer().getNamespaceUri(name), QName::serializer().getLocalName(name), stack.size());
		props::PropertyBag_Pointer_t bag=stack.top();
		stack.pop();			
		if (automatic_style_level==0 &amp;&amp; bag->find(NS_style::LN_display_name)==NULL)
		{
			bag->insert(style_name);
			style_name.reset();
		}
			
		QName_t id=writerfilter::QName::tokenizer().insert(bag->find(NS_style::LN_family)->getStringValue().c_str(), style_name_id.c_str());
			
			styles[id]=props::createCompositeProperty(name, pool->insert(bag));
			}
break;
			case NS_office::LN_automatic_styles:
				automatic_style_level--;
				break;

			case NS_text::LN_p:
			case NS_office::LN_document:
			case NS_office::LN_document_styles:
			case NS_office::LN_document_content:
		bridgeHandler.endElement(name);
				break;

default: break;
		};
	}
	virtual void characters(const xxml::Value &amp;value)
	{
		if (ignoreLevel==0)
		{
//		printf("\"%s\"\n", value.getOString().getStr());
		}				
		else
		{
		bridgeHandler.characters(value);
		}
	}

	virtual void startStream(QName_t stream)
	{
	}
	virtual void endStream(QName_t stream)
	{
	}

	virtual void startReading(size_t totalBytes)
	{
	}
	virtual void continueReading(size_t bytes)
	{
	}
	virtual void endReading()
	{
	}

	virtual const std::hash_map<QName_t, odiapi::props::PropertyPoolHandle_Pointer_t>&amp; getStyles(void)
	{
		return styles;
	}
};

std::auto_ptr&lt;ODSLHandler&gt; ODSLHandler::createODSLHandler(odiapi::props::PropertyPool::Pointer_t propertyPool, writerfilter::xxml::ContentHandler &amp;bridgeHandler)
{
	return std::auto_ptr&lt;ODSLHandler&gt;(new ODSLHandlerImpl(propertyPool, bridgeHandler));
}
<!--
<xsl:apply-templates mode="startElement"/>
push(pool.createPropertyBag()); break;
<xsl:apply-templates mode="attribute"/>
<xsl:apply-templates mode="endElement"/>
-->
</out>
</xsl:template>

<xsl:template match="UML:Class[@name]" mode="startElement">
			case <xsl:value-of select="concat('NS_', translate(substring-before(@name, ':'), '-', '_'), '::LN_', translate(substring-after(@name, ':'), '-', '_'))"/>: 
//		printf("&lt;{%s}:%s [%i]&gt;\n", QName::serializer().getNamespaceUri(name), QName::serializer().getLocalName(name), stack.size());
			stack.push(props::createPropertyBag());
			for(int i=0;i&lt;attrs;i++)
			{
				attribute_<xsl:value-of select="translate(@name, ':-', '__')"/>(attrName[i], attrValue[i]);
			}			
			break;			
</xsl:template>
<!--
<xsl:template match="UML:Attribute[@name]" mode="attribute">
	case <xsl:value-of select="concat('NS_', translate(substring-before(@name, ':'), '-', '_'), '::LN_', translate(substring-after(@name, ':'), '-', '_'))"/>: <xsl:apply-templates mode="attribute"/> break;
</xsl:template>
-->
<xsl:template match="UML:Attribute[@name]" mode="attribute">
<xsl:if test=".//UML:Stereotype[@xmi.idref='property']">
		case <xsl:value-of select="concat('NS_', translate(substring-before(@name, ':'), '-', '_'), '::LN_', translate(substring-after(@name, ':'), '-', '_'))"/>: 
		<xsl:apply-templates mode="attribute"/> 
		break;
</xsl:if>		
</xsl:template>


<xsl:template match="UML:DataType[@xmi.idref='String']" mode="attribute">
			stack.top()->insert(props::createStringProperty(name, value->getString()));
</xsl:template>

<xsl:template match="UML:DataType[@xmi.idref='Twips']" mode="attribute">
			stack.top()->insert(props::createTwipsProperty(name, value->getString()));
</xsl:template>


<!--
<xsl:template match="UML:Stereotype[@xmi.idref='propertyArray']" mode="element">
push(pool.createPropertyBag());
</xsl:template>
<xsl:template match="UML:Stereotype[@xmi.idref='propertySet']" mode="element">
push(pool.createPropertyBag());
</xsl:template>
-->

<xsl:template match="UML:Dependency[@name]" mode="endElement">
<end>
case <xsl:value-of select="concat('NS_', translate(substring-before(@name, ':'), '-', '_'), '::LN_', translate(substring-after(@name, ':'), '-', '_'))"/>:
			{
//		printf("&lt;/{%s}:%s [%i]&gt;\n", QName::serializer().getNamespaceUri(name), QName::serializer().getLocalName(name), stack.size());
		props::PropertyBag_Pointer_t bag=stack.top();
		stack.pop();			

<xsl:variable name="client"><xsl:value-of select="UML:Dependency.client/UML:Class/@xmi.idref"/></xsl:variable>
<xsl:variable name="supplier"><xsl:value-of select="UML:Dependency.supplier/UML:Class/@xmi.idref"/></xsl:variable>
<xsl:choose>
<xsl:when test="//UML:Class[@xmi.id=$client and .//UML:Stereotype/@xmi.idref='propertySet']">
			stack.top()->insert(props::createCompositeProperty(name, pool->insert(bag)));
</xsl:when>
<xsl:when test="//UML:Class[@xmi.id=$client and .//UML:Stereotype/@xmi.idref='propertyArray']">
<xsl:variable name="pos"><xsl:value-of select="normalize-space(//UML:Class[@xmi.id=$supplier])"/></xsl:variable>	
				int p=bag->get(<xsl:value-of select="concat('NS_', translate(substring-before($pos, ':'), '-', '_'), '::LN_', translate(substring-after($pos, ':'), '-', '_'))"/>)->getIntValue();
				stack.top()->insert(p, props::createCompositeProperty(name, pool->insert(bag)));
</xsl:when>
<xsl:otherwise><xsl:message>PROBLEM: <xsl:value-of select="$client"/></xsl:message></xsl:otherwise>
</xsl:choose>
			}
break;
</end>
</xsl:template>

<xsl:template match="text()"/>
<xsl:template match="text()" mode="startElement"/>
<xsl:template match="text()" mode="endElement"/>
<xsl:template match="text()" mode="attribute"/>

</xsl:stylesheet>