/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: overlaysdrobject.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2007/07/06 13:19:40 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"

#ifndef _SDR_OVERLAY_OVERLAYSDROBJECT_HXX
#include <svx/sdr/overlay/overlaysdrobject.hxx>
#endif

#ifndef _XOUTX_HXX //autogen
#include <svx/xoutx.hxx>
#endif

#ifndef _SVDOBJ_HXX //autogen
#include <svx/svdobj.hxx>
#endif

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace overlay
	{
		void OverlaySdrObject::drawGeometry(OutputDevice& rOutputDevice)
		{
			XOutputDevice aExtOut(&rOutputDevice);
			SdrPaintInfoRec aInfoRec;
			mrSdrObject.SingleObjectPainter(aExtOut, aInfoRec);
		}

		void OverlaySdrObject::createBaseRange(OutputDevice& /*rOutputDevice*/)
		{
			// reset range and expand it
			maBaseRange.reset();
			
			// get BoundRect
			Rectangle aBoundRect(mrSdrObject.GetCurrentBoundRect());
			const basegfx::B2DPoint aTopLeft(aBoundRect.Left(), aBoundRect.Top());
			const basegfx::B2DPoint aBottomRight(aBoundRect.Right(), aBoundRect.Bottom());

			maBaseRange.expand(aTopLeft);
			maBaseRange.expand(aBottomRight);
		}

		OverlaySdrObject::OverlaySdrObject(
			const basegfx::B2DPoint& rBasePos,
			const SdrObject& rObject)
		:	OverlayObjectWithBasePosition(rBasePos, Color(COL_BLACK)),
			mrSdrObject(rObject)
		{
		}
		
		OverlaySdrObject::~OverlaySdrObject()
		{
		}

		sal_Bool OverlaySdrObject::isHit(const basegfx::B2DPoint& rPos, double fTol) const
		{
			if(isHittable())
			{
				Point aPnt( (long)rPos.getX(), (long)rPos.getY() );
				return mrSdrObject.CheckHit(aPnt, (USHORT)fTol, 0) != 0 ? sal_True : sal_False;
			}

			return sal_False;
		}
	} // end of namespace overlay
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// eof
