/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: FactoryContainer.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2007/04/03 15:59:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "precompiled_sd.hxx"

#include "framework/FactoryContainer.hxx"

#ifndef _COM_SUN_STAR_DRAWING_FRAMEWORK_XCONTROLLERMANAGER_HPP_
#include <com/sun/star/drawing/framework/XControllerManager.hpp>
#endif

using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::drawing::framework;
using ::rtl::OUString;

namespace sd { namespace framework {

FactoryContainer::FactoryContainer ()
    : maMutex(),
      maFactoryMap(),
      mxModuleController()
{
}




void FactoryContainer::SetModuleController (const Reference<XModuleController>& xModuleController)
{
    mxModuleController = xModuleController;
}




FactoryContainer::~FactoryContainer (void)
{
}




void FactoryContainer::AddFactory (
    const OUString& rsURL,
    const Reference<XInterface>& rxFactory)
        throw (RuntimeException)
{
    if ( ! rxFactory.is())
        throw lang::IllegalArgumentException();
    if (rsURL.getLength() == 0)
        throw lang::IllegalArgumentException();

    ::osl::MutexGuard aGuard (maMutex);

    maFactoryMap[rsURL] = rxFactory;
}




void FactoryContainer::RemoveFactoryForURL (
    const OUString& rsURL)
    throw (RuntimeException)
{
    if (rsURL.getLength() == 0)
        throw lang::IllegalArgumentException();

    ::osl::MutexGuard aGuard (maMutex);

    FactoryMap::iterator iFactory (maFactoryMap.find(rsURL));
    if (iFactory != maFactoryMap.end())
    {
        maFactoryMap.erase(iFactory);
    }
}





void FactoryContainer::RemoveFactoryForReference(
    const Reference<XInterface>& rxFactory)
    throw (RuntimeException)
{
    ::osl::MutexGuard aGuard (maMutex);

    // Collect a list with all keys that map to the given factory.
    ::std::vector<OUString> aKeys;
    FactoryMap::const_iterator iFactory;
    for (iFactory=maFactoryMap.begin(); iFactory!=maFactoryMap.end(); ++iFactory)
        if (iFactory->second == rxFactory)
            aKeys.push_back(iFactory->first);

    // Remove the entries whose keys we just have collected.
    ::std::vector<OUString>::const_iterator iKey;
    for (iKey=aKeys.begin(); iKey!=aKeys.end();  ++iKey)
        maFactoryMap.erase(maFactoryMap.find(*iKey));
}




Reference<XInterface> FactoryContainer::GetFactory (const OUString& rsURL)
    throw (RuntimeException)
{
    Reference<XInterface> xFactory;
    
    FactoryMap::const_iterator iFactory;
    {
        ::osl::MutexGuard aGuard (maMutex);
        iFactory = maFactoryMap.find(rsURL);
        if (iFactory != maFactoryMap.end())
            xFactory = iFactory->second;
    }
    
    if ( ! xFactory.is()
        && mxModuleController.is())
    {
        // Ask the module controller to provide a factory of the requested
        // view type.
        mxModuleController->requestResource(rsURL);
        
        {
            // Search again for the factory.
            ::osl::MutexGuard aGuard (maMutex);
            iFactory = maFactoryMap.find(rsURL);
            if (iFactory != maFactoryMap.end())
                xFactory = iFactory->second;
        }
    }

    return xFactory;
}

} } // end of namespace sd::framework
