/* 
# fifo_write.c
# Copyright (C) 2005, NETWAYS GmbH, Gerd Mueller
#  $Id: fifo_write.c 1067 2005-12-29 15:20:59Z gmueller $
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# Build it with: 
gcc -o fifo_write fifo_write.c

*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <fcntl.h>
#include <unistd.h>

#include <sys/stat.h>

int main(int argc, char **argv)
{
    int hfpath;
    int rw = 0;
    char *output = NULL;
    char *fpath = NULL;

    // right amount of parameters?
    if (argc == 3 || argc == 4) {
        struct stat st;
        int timeout = 3;

        fpath = argv[1];
        output = argv[2];

        // got timeout-parameter?
        if (argc == 4)
            timeout = atoi(argv[3]);

        // file should be a pipe
        stat(fpath, &st);
        if (S_ISFIFO(st.st_mode)) {

            // open file
            hfpath = open(fpath, O_WRONLY | O_NONBLOCK);
            if (hfpath) {

                //allocate memory for the output
                char *formated_output = (char *) malloc(strlen(output));

                //allocation worked?
                if (formated_output) {
                    int i, j = 0;
                    int tab = 0;

                    //replace \t with tabs
                    for (i = 0; output[i]; i++) {
                        if (output[i] != '\\') {
                            if (output[i] != 't') {
                                formated_output[j++] = output[i];
                            } else {
                                if (tab) {
                                    formated_output[j++] = 9;
                                } else {
                                    formated_output[j++] = output[i];
                                }
                            }
                            tab = 0;
                        } else {
                            tab = 1;
                        }
                    }
                    formated_output[j] = 0;

                    // write to pipe
                    alarm(timeout);
                    write(hfpath, formated_output,
                          strlen(formated_output));
                    alarm(0);

                    //free memory
                    free(formated_output);

                    /* Errorhandling below */


                } else {
                    printf("I was not able to allocate enough memory.\n");
                    rw = 1;
                }
                close(hfpath);
            } else {
                printf("Could not open %s for writing!\n", fpath);
                rw = 1;
            }
        } else {
            printf("%s is not a pipe or does not exist!\n", fpath);
            rw = 1;
        }
    } else {
        printf
            ("Usage: write_fifo <path of the pipe> <output> [timeout]\n");
        rw = 1;
    }
    return rw;
}
