#!/bin/sh

# simple bash script to fetch all servicegraphs from a specific host for the last week


#######################################
# Please configure following variables:
#######################################

# directory to export into
EXPORTDIR=/var/tmp/ng_export

#webserver
WEBSERVER=https://monitor.netways.de

# nagios status file
STATUSFILE=/usr/local/nagios/var/status.dat

#htaccess User for the webinterface
USER=
PASSWORD=

#default pattern
PATERN=

#default period
PERIOD=week

################################################
# Please do not change anything beyond this line
#################################################


usage() {
	echo ""
	echo "Usage: ng_export.sh -H hostname -t timeperiod [-p patern] [-D]"
	echo " -H hostname    which graphs should be exported"
	echo " -t timeperiod  hour|day|week|month|year"
	echo " -p pattern     grep after this services"
	echo ""
	echo " -D             Debug"
	echo " -h             this message"
	echo ""
	exit 0
}

DEBUG=-q

while getopts "hH:t:p:d:" flag; do
	case "$flag" in
		h)
			usage
			;;
		H)
			HOST=$OPTARG
			;;
		t)
			PERIOD=$OPTARG
			;;
		p)
			PATERN=$OPTARG
			;;
		d)
			EXPORTDIR=$OPTARG
			;;
		D)
			DEBUG=
			;;
	esac
done


if [ "$PERIOD" != "hour" -a "$PERIOD" != "day" -a "$PERIOD" != "week" -a "$PERIOD" != "month" -a "$PERIOD" != "year" ]; then
	usage
fi

#export last week (monday to sunday)
START=`date --utc --date=-1$PERIOD +%s`
END=`date --utc +%s`
YEAR=`date --utc +%Y`
WEEK=`date --utc +%V`

#url to nagiosgrapher
URL=`echo "$WEBSERVER/nagios/cgi-bin/rrd2-system.cgi?start=$START&end=$END&host=$HOST&service="`

if [ "$HOST" == "" -o "$PERIOD" == "" ]; then
	usage
fi

if [ ! -d $EXPORTDIR ]; then
  mkdir $EXPORTDIR
fi

if [ ! -d $EXPORTDIR/$HOST ]; then
  mkdir $EXPORTDIR/$HOST
fi

cd $EXPORTDIR

if [ "$USER" != "" ]; then
  USER=`echo "--user=$USER"`
fi

if [ "$PASSWORD" != "" ]; then
  PASSWORD=`echo "--password=$PASSWORD"`
fi

if [ ! -e $STATUSFILE ]; then
	echo "$STATUSFILE is missing. Please configure STATUSFILE inside this script."
	exit 0
fi

grep $HOST -A 1 $STATUSFILE  | grep service_desc | awk -F= '{print "\""$2"\""}' | grep -E "^\"$PATERN"  | xargs -n 1 echo "$URL" | sed "s/= /=/" | sed "s/ /%20/g"| sed "s/ /%20/" | xargs -n 1 wget $DEBUG --no-check-certificate $USER $PASSWORD

for FILE in rrd2-system.cgi*; do
  NEWNAME=`echo "$FILE" | sed "s/^.*service=//"`
  mv "$FILE" "$EXPORTDIR/$HOST/$NEWNAME-$PERIOD.png"
done


