/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util;

import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.Traceable;
import com.sap.dbtech.util.UnicodeUtil;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class StructuredBytes
implements StructuredMem,
Traceable {
    public static final String sapdbEncodingC = "ISO8859_1";
    protected byte[] data;
    protected int ptrOffs;
    protected int byteSize;
    protected static final byte blank_C = 32;
    public static final char[] hexDigits_C = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int fillBufSizeC = 1024;
    private static final int unicodeWidthC = 2;
    static byte[] zeroBytes = new byte[1024];
    static byte[] blankBytes = new byte[1024];
    static byte[] blankUnicodeBytes = new byte[2048];

    public StructuredBytes(byte[] byArray) {
        this.data = byArray;
        this.ptrOffs = 0;
        this.byteSize = byArray.length;
    }

    public StructuredBytes(byte[] byArray, int n) {
        this.data = byArray;
        this.ptrOffs = n;
        this.byteSize = byArray.length - this.ptrOffs;
    }

    public StructuredBytes(int n) {
        this.data = new byte[n];
        this.byteSize = n;
    }

    public byte[] bytes() {
        return this.data;
    }

    public byte[] getBytes(int n, int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.data, n + this.ptrOffs, byArray, 0, n2);
        return byArray;
    }

    public int[] getIntArray(int n, int n2) {
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.getUInt1(n + i);
        }
        return nArray;
    }

    public byte getInt1(int n) {
        return this.data[n + this.ptrOffs];
    }

    public int getUInt1(int n) {
        int n2 = this.data[n + this.ptrOffs];
        if (n2 < 0) {
            n2 += 256;
        }
        return n2;
    }

    public int getInt2(int n) {
        int n2 = n + this.ptrOffs;
        int n3 = this.data[n2 + 1];
        if (n3 < 0) {
            n3 += 256;
        }
        return this.data[n2] * 256 + n3;
    }

    public int getInt4(int n) {
        byte[] byArray = this.data;
        int n2 = n + this.ptrOffs;
        int n3 = 0;
        for (int i = 0; i < 4; ++i) {
            int n4 = byArray[n2 + i];
            if (n4 < 0) {
                n4 += 256;
            }
            n3 = n3 * 256 + n4;
        }
        return n3;
    }

    public StructuredMem getPointer(int n) {
        return new StructuredBytes(this.data, this.ptrOffs + n);
    }

    public String getString(int n, int n2) {
        try {
            return new String(this.data, n + this.ptrOffs, n2, sapdbEncodingC);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(this.data, n + this.ptrOffs, n2);
        }
    }

    public byte[] getStrippedBytes(int n, int n2) {
        while (n2 > 0 && this.data[n + this.ptrOffs + n2 - 1] == 0) {
            --n2;
        }
        return this.getBytes(n, n2);
    }

    public String getStrippedString(int n, int n2) {
        String string = StringUtil.trimLeft(this.getString(n, n2));
        return string;
    }

    public char getBigUnicodeChar(int n) {
        int n2;
        int n3 = this.ptrOffs + n;
        int n4 = this.data[n3];
        if (n4 < 0) {
            n4 += 256;
        }
        if ((n2 = this.data[n3 + 1]) < 0) {
            n2 += 256;
        }
        int n5 = (n4 << 8) + n2;
        return (char)n5;
    }

    public char[] getBigUnicode(int n, int n2) {
        int n3 = this.ptrOffs + n;
        return UnicodeUtil.bigUnicode2Chars(this.data, n3, n2);
    }

    public void moveBase(int n) {
        this.ptrOffs += n;
        if (this.size() < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.byteSize -= n;
    }

    public void putBytes(byte[] byArray, int n) {
        System.arraycopy(byArray, 0, this.data, n + this.ptrOffs, byArray.length);
    }

    private void putBytes(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = byArray.length;
        int n4 = 0;
        if (n3 > n2) {
            n3 = n2;
        } else if (n3 < n2) {
            n4 = n2 - n3;
        }
        System.arraycopy(byArray, 0, this.data, n + this.ptrOffs, n3);
        if (n4 > 0) {
            this.fill(n + n3, n4, byArray2);
        }
    }

    public void putBytes(byte[] byArray, int n, int n2) {
        this.putBytes(byArray, n, n2, zeroBytes);
    }

    public void putStringBytes(byte[] byArray, int n, int n2) {
        this.putBytes(byArray, n, n2, blankBytes);
    }

    public void putUnicodeBytes(byte[] byArray, int n, int n2) {
        this.putBytes(byArray, n, n2, blankUnicodeBytes);
    }

    public void putBigUnicode(char[] cArray, int n, int n2) {
        int n3 = cArray.length;
        int n4 = n2 / 2;
        int n5 = 0;
        if (n3 > n4) {
            n3 = n4;
        } else if (n3 < n2) {
            n5 = n2 - n3 * 2;
        }
        int n6 = this.ptrOffs + n;
        for (int i = 0; i < n3; ++i) {
            char c = cArray[i];
            this.data[i * 2 + n6] = (byte)(c / 256);
            this.data[i * 2 + n6 + 1] = (byte)(c % 256);
        }
        if (n5 > 0) {
            this.fill(n + n3 * 2, n5, blankUnicodeBytes);
        }
    }

    public void putInt1(int n, int n2) {
        this.data[n2 + this.ptrOffs] = (byte)n;
    }

    public void putInt2(int n, int n2) {
        int n3 = n2 + this.ptrOffs;
        byte[] byArray = this.data;
        if (n == 0) {
            byArray[n3 + 1] = 0;
            byArray[n3] = 0;
            return;
        }
        byArray[n3] = (byte)(n >> 8 & 0xFF);
        byArray[n3 + 1] = (byte)(n & 0xFF);
    }

    public void putInt4(int n, int n2) {
        int n3 = n2 + this.ptrOffs;
        byte[] byArray = this.data;
        if (n == 0) {
            byArray[n3 + 3] = 0;
            byArray[n3 + 2] = 0;
            byArray[n3 + 1] = 0;
            byArray[n3] = 0;
            return;
        }
        for (int i = 3; i >= 0; --i) {
            byArray[n3 + i] = (byte)(n & 0xFF);
            n >>= 8;
        }
    }

    public void putInt8(long l, int n) {
        int n2 = n + this.ptrOffs;
        byte[] byArray = this.data;
        if (l == 0L) {
            byArray[n2 + 7] = 0;
            byArray[n2 + 6] = 0;
            byArray[n2 + 5] = 0;
            byArray[n2 + 4] = 0;
            byArray[n2 + 3] = 0;
            byArray[n2 + 2] = 0;
            byArray[n2 + 1] = 0;
            byArray[n2] = 0;
            return;
        }
        for (int i = 7; i >= 0; --i) {
            byArray[n2 + i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
    }

    public int putString(String string, int n) {
        int n2 = n + this.ptrOffs;
        char[] cArray = string.toCharArray();
        int n3 = cArray.length;
        for (int i = 0; i < n3; ++i) {
            char c = cArray[i];
            this.data[n2++] = c <= '\u00ff' ? (int)c : 63;
        }
        return n3;
    }

    public int putString(String string, int n, int n2) {
        char[] cArray = string.toCharArray();
        int n3 = cArray.length;
        if (n3 >= n2) {
            int n4 = n + this.ptrOffs;
            for (int i = 0; i < n2; ++i) {
                char c = cArray[i];
                this.data[n4 + i] = c <= '\u00ff' ? (int)c : 63;
            }
        } else {
            int n5 = n + this.ptrOffs;
            for (int i = 0; i < n3; ++i) {
                char c = cArray[i];
                this.data[n5 + i] = c <= '\u00ff' ? (int)c : 63;
            }
            this.fill(n + n3, n2 - n3, blankBytes);
        }
        return n2;
    }

    public int size() {
        return this.data.length - this.ptrOffs;
    }

    private void fill(int n, int n2, byte[] byArray) {
        while (n2 > 0) {
            int n3 = Math.min(n2, 1024);
            System.arraycopy(byArray, 0, this.data, n + this.ptrOffs, n3);
            n2 -= n3;
            n += n3;
        }
    }

    public void traceOn(PrintStream printStream) {
        this.traceOn(printStream, 0, this.byteSize);
    }

    public void traceOn(PrintStream printStream, int n) {
        this.traceOn(printStream, 0, n);
    }

    public void traceOn(PrintStream printStream, int n, int n2) {
        printStream.print(StringUtil.hexDump(this.data, n + this.ptrOffs, n2 + this.ptrOffs));
    }

    public static byte[] getInt4Const(int n) {
        byte[] byArray = new byte[4];
        for (int i = 3; i >= 0; --i) {
            byte by;
            byArray[i] = by = (byte)(n & 0xFF);
            n >>= 8;
        }
        return byArray;
    }

    public long getInt8(int n) {
        byte[] byArray = this.data;
        int n2 = n + this.ptrOffs;
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            int n3 = byArray[n2 + i];
            if (n3 < 0) {
                n3 += 256;
            }
            l = l * 256L + (long)n3;
        }
        return l;
    }

    static {
        for (int i = 0; i < 1024; i += 2) {
            StructuredBytes.zeroBytes[i + 1] = 0;
            StructuredBytes.zeroBytes[i] = 0;
            StructuredBytes.blankBytes[i + 1] = 32;
            StructuredBytes.blankBytes[i] = 32;
            StructuredBytes.blankUnicodeBytes[i] = 0;
            StructuredBytes.blankUnicodeBytes[i + 1] = 32;
        }
    }
}

