#ifndef __KADU_FIREWALL_H
#define __KADU_FIREWALL_H

#include <qobject.h>
#include <qdatetime.h>
#include <qregexp.h>

#include "gadu.h"

class Firewall : public QObject
{
	Q_OBJECT

	public:
		Firewall();
		~Firewall();
		
	private:
		QStringList secured, secured_temp_allowed;
		QString last_uin;	//TODO: pozby si tego
		UserListElements passed;
		unsigned int flood_messages;
		QTime lastMsg;
		QTime lastNotify;
		bool right_after_connection;
		QRegExp pattern;
		
		void loadSecuredList(void);
		void saveSecuredList(void);
		bool isSecured(QString id);
		
		bool checkChat(QString message, UserListElements senders, QString user, bool& stop);
		bool checkConference(QString message, UserListElements senders, QString user);
		bool checkEmoticons(QString& message);
		bool checkFlood();
		
		void showHint(QString, QString);
		void writeLog(QString, QString);
		
		void createGUI(void);
		void destroyGUI(void);
		
	private slots:
		void messageFiltering(Protocol *protocol, UserListElements senders, QCString& msg, QByteArray& formats, bool& stop);
		void chatCreated(const UserGroup *);
		void chatDestroyed(const UserGroup *);
		void sendMessageFilter(const UserGroup *users, QCString &msg, bool &stop);

		void userDataChanged(UserListElement, QString, QVariant, QVariant, bool, bool);
		void userAdded(UserListElement, bool, bool);
		void userRemoved(UserListElement, bool, bool);
		
		void connected();
		void connecting();
		void changeRight_after_connection();

		void onCreateTabFirewall(void);
		void onApplyTabFirewall(void);
		void toggled_chats(bool);
		void toggled_confirmation(bool);
		void toggled_show_hint(bool);
		void toggled_log(bool);
		void toggled_emoticons_DoS(bool);
		void toggled_flooding_DoS(bool);
		void toggled_safe_sending(bool);
		
		void _Left();
		void _Right();
};

#endif
