package GCPlugins::GCFilmAffinityEN;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;
use utf8;

use GCPlugins::GCPluginsBase;

{
    package GCPlugins::GCPluginFilmAffinityEN;

    use base qw(GCPluginParser);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;
		
        if ($self->{parsingList})
        {
            if ($self->{parsingEnded})
            {
                if (($tagname eq 'img') && 
                   ($attr->{src} =~ m{images\.filmaffinity\.com/movies/full/[0-9]+/([0-9]*)}))
                {
                    $self->{hasUrl} = 'film'.$1.'.html';
                }
            }
            elsif (!$self->{isMovie} &&
                ($tagname eq 'a') && 
                ($attr->{href} =~ /^\/en\/(film.*)$/))
			{
                my $url = $1;
                $self->{isMovie} = 1;
                $self->{movieIdx}++;
                $self->{movieList}[$self->{movieIdx}]->{url} = $url;
            }
            elsif (($tagname eq 'span') && 
                   ($attr->{style} eq 'font-size: 10px; color:#666666'))
            {
                $self->{isDirector} = 1;
            }
            elsif (($tagname eq 'div') && 
                   ($attr->{style} eq 'font-size: 10px'))
            {
                $self->{isActors} = 1;
            }
        }
        else
        {
            if (($tagname eq 'span') && 
                ($attr->{style} eq 'color:#990000; font-size:16; font-weight: bold;'))
            {
                $self->{isTitle} = 1;
            }
            elsif ($tagname eq 'img')
            {
                if ($attr->{src} =~ /^\/imgs\/countries/)
                {
                    $self->{curInfo}->{nat} = $attr->{alt};
                }
                elsif ($attr->{src} =~ /images\.filmaffinity\.com\/movies\/full/)
                {
                    $self->{curInfo}->{image} = $attr->{src};
                }
            }
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;
		
        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        if ($self->{parsingList})
        {
            if ($self->{parsingEnded})
            {
                if ($self->{hasUrl})
                {
                    $self->{movieList}[0]->{url} = $self->{hasUrl};
                    $self->{hasUrl} = 0;
                }
                return;
            }
            if ($self->{inside}->{title} && ($origtext !~ /^Search\s+for /))
            {
                $self->{parsingEnded} = 1;
                $self->{hasUrl} = 0;
                $self->{movieIdx} = 0;
            }
            elsif ($self->{isMovie})
            {
                return if $origtext !~ /\w/;
                $self->{movieList}[$self->{movieIdx}]->{title} = $origtext;
                $self->{isMovie} = 0;
                $self->{isTitle} = 1;
            }
            elsif ($self->{isTitle})
            {
                (my $year = $origtext) =~ s/\s*\(([0-9]{4})\)\s*/$1/;
                $self->{movieList}[$self->{movieIdx}]->{year} = $year;
                $self->{isTitle} = 0;
            }
            elsif ($self->{isDirector})
            {
                $self->{movieList}[$self->{movieIdx}]->{director} = $origtext;
                $self->{isDirector} = 0;
            }
            elsif ($self->{isActors})
            {
                $self->{movieList}[$self->{movieIdx}]->{actors} = $origtext;
                $self->{isActors} = 0;
            }
        }
        else
        {
            $origtext =~ s/^\s*//;
                 
            return if !$origtext;       
            if ($self->{isTitle})
            {
                $self->{curInfo}->{title} = $origtext;
                $self->{isTitle} = 0;
            }
            elsif ($self->{isOrig})
            {
                $self->{curInfo}->{orig} = $origtext;
                $self->{isOrig} = 0;   
            }
            elsif ($self->{isDate})
            {
                $self->{curInfo}->{date} = $origtext;
                $self->{isDate} = 0;   
            }
            elsif ($self->{isTime})
            {
                $self->{curInfo}->{time} = $origtext;
                $self->{isTime} = 0;   
            }
            elsif ($self->{isDirector})
            {
                $self->{curInfo}->{director} = $origtext;
                $self->{isDirector} = 0;   
            }
            elsif ($self->{isActors})
            {
                if ($self->{inside}->{a})
                {
                    $self->{curInfo}->{actors} .= $origtext.', ';
                }
            }
            elsif ($self->{isGenre})
            {
                $self->{curInfo}->{type} = $origtext;
                $self->{curInfo}->{type} =~ s/\s*\/\s*/,/g;
                $self->{isGenre} = 0;
            }
            elsif ($self->{isSynopsis})
            {
                $self->{curInfo}->{synopsis} = $origtext;
                $self->{isSynopsis} = 0;
            }
            
            if ($self->{inside}->{b})
            {
                if ($origtext eq 'Original Title:')
                {
                    $self->{isOrig} = 1;
                }
                elsif ($origtext eq 'Year:')
                {
                    $self->{isDate} = 1;
                }
                elsif ($origtext eq 'Running Time:')
                {
                    $self->{isTime} = 1;
                }
                elsif ($origtext eq 'Director:')
                {
                    $self->{isDirector} = 1;
                }
                elsif ($origtext eq 'Cast:')
                {
                    $self->{isActors} = 1;
                }
                elsif ($origtext eq 'Studio / Producer:')
                {
                    $self->{curInfo}->{actors} =~ s/, $//;
                    $self->{isActors} = 0;
                }
                elsif ($origtext eq 'Genre:')
                {
                    $self->{isGenre} = 1;
                }
                elsif ($origtext eq 'Synopsis:')
                {
                    $self->{isSynopsis} = 1;
                }                
            }
            
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{isInfo} = 0;
        $self->{isMovie} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        $self->{parsingEnded} = 0;

        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        return "http://www.filmaffinity.com/en/search.php?stext=$word&stype=title";
    }
    
    sub getMovieUrl
    {
		my ($self, $url) = @_;
		
        return 'http://www.filmaffinity.com/en/'.$url;
    }

    sub changeUrl
    {
        my ($self, $url) = @_;
        
        return $url;
    }

    sub getName
    {
        return "Film affinity (EN)";
    }
    
    sub getImageFile
    {
        return "filmaffinity.png";
    }

    sub getCharset
    {
        my $self = shift;
    
        return "ISO-8859-1";
    }

    sub getAuthor
    {
        return 'Tian';
    }
    
    sub getLang
    {
        return 'EN';
    }
}

1;
