{
    package GCLang::EN;

    use utf8;
###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################
    
    use strict;
    use base 'Exporter';

    our @EXPORT = qw(%lang);

    our %lang = (

        'LangName' => 'English',
        
        'Separator' => ': ',
        
        'Warning' => '<b>Warning</b>:
        
Information downloaded from web sites (through the 
search plugins) is for <b>personal use only</b>.

Any redistribution is forbidden without the site\'s
<b>explicit authorization</b>.

To determine which site owns the information, you
may use the <b>button below movie details</b>.',
        
        'AllMoviesFiltered' => 'No movie matches your filtering criteria',
        
	'InstallDirInfo' => 'Installing in ',
	'InstallMandatory' => 'Mandatory components',
	'InstallOptional' => 'Optional Components',
	'InstallErrorMissing' => 'Error : Following Perl components have to be installed: ',
	'InstallPrompt' => 'Base directory for installation [/usr/local]: ',
	'InstallEnd' => 'End of the installation',
	'InstallNoError' => 'No error',
	'InstallLaunch' => 'To use this application, one can launch ',
	'InstallDirectory' => 'Base directory',
	'InstallTitle' => 'GCfilms installation',
	'InstallDependencies' => 'Dependencies',
    'InstallPath' => 'Path',
    'InstallOptions' => 'Options',
	'InstallSelectDirectory' => 'Select base directory for the installation',
	'InstallWithClean' => 'Remove files found in installation directory',
	'InstallWithMenu' => 'Add GCfilms to Applications menu',
	'InstallNoPermission' => 'Error: You don\'t have permission to write in the selected directory',
	'InstallMissingMandatory' => 'Mandatory dependencies are missing. You won\'t be able to install GCfilms until they have been added to your system.',
	'InstallMissingOptional' => 'Some optional dependencies are missing. There are listed under. GCfilms may be installed but some features won\'t be available.',
	'InstallMissingNone' => 'There are no missing dependency. You may continue and install GCfilms.',
	'InstallOK' => 'OK',
	'InstallMissing' => 'Missing',
	'InstallMissingFor' => 'Missing for',

#Splash
	'SplashInit' => 'Initialization',
	'SplashLoad' => 'Loading Collection',
	'SplashDone' => 'Ready',

#Menus
	'MenuMovies' => '_File',
		'MenuNewList' => '_New Collection',
		'MenuHistory' => '_Recent Collections',
		'MenuLend' => 'Display _Borrowed Movies',
		'MenuImport' => '_Import',	
		'MenuExport' => '_Export',

	'MenuEdit'  => '_Edit',
   	    'MenuDuplicate' => '_Duplicate movie',
		'MenuEditDeleteCurrent' => '_Remove Movie',
		'MenuEditLockMovies' => '_Lock Collection',

	'MenuDisplay' => 'F_ilter',
		'MenuViewAllMovies' => 'Show _All Movies',
		'MenuSearchMovies' => '_Search',
			'MenuSearchAllMovies' => 'Search _All Movies',
			'MenuSearchSelectedMovies' => 'Search _Displayed Movies',
		'MenuSeenOrNot' => '_Viewed',
			'MenuAllMovies' => '_Any',
			'MenuNotSeen' => '_Not Yet Viewed',
		'MenuBorrowing' => '_Lending',
			'MenuBorrowed' => '_Borrowed',
			'MenuNotBorrowed' => 'A_vailable',
        'MenuAge' => 'A_udience',
        'MenuAgeNone' => '_All Ages',
        'MenuAgeParent' => '_Parental Guidance',
        'MenuAgeLess' => '_Specify Age...',
		'MenuCategories' => '_Genre',
			'MenuAllCategories' => '_Any',
		'MenuRating' => '_Rating',
			'MenuAllRating' => '_Any',
			'MenuChooseRating' => 'Rating At _Least...',

	'MenuConfiguration' => '_Settings',
		'MenuDisplayOptions' => '_Displayed Information',
		'MenuBorrowers' => '_Borrowers',
        'MenuGenresConversion' => 'Genre _Conversion',
		'MenuRename' => 'Edit _Genres',

	'MenuHelp' => '_Help',
		'MenuAbout' => '_About GCfilms',

	'MenuNewWindow' => 'Show Movie in _New Window',

        'RemoveConfirm' => 'Do you really want to remove this movie?',
        'NewMovie' => 'New movie',
        'NewMovieTooltip' => 'Add a new movie',
        'NoMovieFound' => 'No movie was found. Would you like to search another site?',
        'OpenList' => 'Please select collection',
        'SaveList' => 'Please choose where to save the collection',
        'SaveListTooltip' => 'Save current collection',
        'SaveCurrentList' => 'First specify where to save the current collection',
        'Movies' => 'Movies',
        'PreferencesTooltip' => 'Set your preferences',
        'ViewTooltip' => 'Change collection display',
        'PlayTooltip' => 'Play video associated to the movie',

        'StatusSearch' => 'Search in progress...',
        'StatusGetInfo' => 'Getting information...',
        'StatusGetImage' => 'Getting picture...',
                
        'SaveError' => 'Cannot save movies list. Please check access rights and disk free space.',
        'OpenError' => 'Cannot open movies list. Please check access rights.',
        'ImageError' => 'Selected directory to save images is not correct. Please select another one.',
        'OptionsCreationError'=> 'Cannot create options file: ',
        'OptionsOpenError'=> 'Cannot open options file: ',
        'OptionsSaveError'=> 'Cannot save options file: ',
        
        'RandomTooltip' => 'What to see this evening ?',
        'RandomError'=> 'You have no unseen movies',
        'RandomEnd'=> 'There are no more movies',
        'RandomNextTip'=> 'Next suggestion',
        'RandomOkTip'=> 'Accept this movie',
        
        'AboutTitle' => 'About GCfilms',
        'AboutDesc' => 'Gtk2 Movie Catalog',
        'AboutVersion' => 'Version',
        'AboutTeam' => 'Team',
        'AboutWho' => 'Tian: Project manager, Programmer
MeV: Programmer
Christophe Z: Programmer
Adolfo González : Programmer

Jason Day : Contributer
Gabriel Meier : Contributer

Dab : Contributer
rootII : Contributer
VFRMania : Contributer',
        'AboutLicense' => 'Distributed under the terms of the GNU GPL
Logos Copyright le Spektre
http://le-spektre.org',
        'AboutTranslation' => 'English translation by Tian and Jason Day',
        'AboutDesign' => 'Logo and webdesign by le Spektre',

        'ToolbarRandom' => 'Tonight',
        
        'ResultsTitle' => 'Select a movie',
        'ResultsMovieTitle' => 'Title',
        'ResultsMovieYear' => 'Year',
        'ResultsMovieDirector' => 'Director',
        'ResultsMovieActors' => 'Actors',
        'ResultsNextTip' => 'Search in next site',
        
        'OptionsTitle' => 'Preferences',
        'OptionsBrowser' => 'Web browser',
        'OptionsPlayer' => 'Video player',
        'OptionsImages' => 'Images directory',
        'OptionsUseRelativePaths' => 'Use relative paths for images',
        'OptionsOrder' => 'Layout',
        'OptionsStatus' => 'Display status bar',
        'OptionsUrlPicture' => 'Display site logo on button used to display movie\'s webpage',
        'OptionsWarning' => 'Warning: Changes in this tab won\'t take effect until the application is restarted.',
        'OptionsTabs' => 'Tabs',
        'OptionsAllInOne' => 'All In One',
        'OptionsCompact' => 'Compact',
        'OptionsReadOnly' => 'Read Only',
        'OptionsWebSite' => 'GCfilms Website',
        'OptionsRemoveConfirm' => 'Ask confirmation before movie deletion',
        'OptionsAutoSave' => 'Automatically save collection',
        'OptionsSplash' => 'Show splash screen',
        'OptionsImagesTitle' => 'Select a Directory',
        'OptionsBrowserTitle' => 'Select the Program to be Used',
		'OptionsPlugins' => 'Site to retrieve data from',
		'OptionsAskPlugins' => 'Ask (All sites)',
		'OptionsPluginsMulti' => 'Many sites',
		'OptionsPluginsMultiAsk' => 'Ask (Many sites)',
		'OptionsPluginsList' => 'Set list',
        'OptionsAskImport' => 'Select fields to be imported',
		'OptionsProxy' => 'Use a proxy',
        'OptionsLang' => 'Language',
        'OptionsMain' => 'Main',
        'OptionsPaths' => 'Paths',
        'OptionsInternet' => 'Internet',
        'OptionsConveniences' => 'Features',
        'OptionsDisplay' => 'Display',
        'OptionsToolbar' => 'Toolbar',
        'OptionsToolbars' => {0 => 'None', 1 => 'Small', 2 => 'Large'},
        'OptionsToolbarPosition' => 'Position',
        'OptionsToolbarPositions' => {0 => 'Top', 1 => 'Bottom', 2 => 'Left', 3 => 'Right'},
        'OptionsView' => 'Display',
        'OptionsViews' => {0 => 'Text', 1 => 'Image', 2 => 'Detailed'},
        'OptionsColumns' => 'Columns',
        'OptionsMailer' => 'E-mailer',
        'OptionsSMTP' => 'Server',
        'OptionsFrom' => 'Your e-mail',
        'OptionsTransform' => 'Place articles at the end of titles',
        'OptionsArticles' => 'Articles (Comma separated)',
        'OptionsFormats' => 'Media types (Comma separated)',
        'OptionsSearchStop' => 'Allow search to be aborted',
        'OptionsAlwaysOriginal' => 'Use main title as the original title if none present',
        'OptionsHistory' => 'Size of history',
        'OptionsClearHistory' => 'Clear history',
		'OptionsStyle' => 'Skin',
        'OptionsDontAsk' => 'Don\'t ask anymore',

        'ImagesOptionsButton' => 'Settings',
        'ImagesOptionsTitle' => 'Settings for images list',
        'ImagesOptionsSelectColor' => 'Select a color',
        'ImagesOptionsBg' => 'Background',
        'ImagesOptionsBgPicture' => 'Use a background picture',
        'ImagesOptionsFg'=> 'Selection',
        'ImagesOptionsBgTooltip' => 'Change background color',
        'ImagesOptionsFgTooltip'=> 'Change selection color',
        'ImagesOptionsSizeLabel' => 'Size',
        'ImagesOptionsSizeList' => {0 => 'Very Small', 1 => 'Small', 2 => 'Medium', 3 => 'Large', 4 => 'Extra Large'},
        'ImagesOptionsSizeTooltip' => 'Select image size',
		        
        'DetailedOptionsTitle' => 'Settings for detailed list',
        'DetailedOptionsImageSize' => 'Images size',
        'DetailedOptionsGroupMovies' => 'Group movies by collection',
		'DetailedOptionsFields' => 'Select fields to display',

        'ExtractButton' => 'Information',
        'ExtractTitle' => 'Video file information',
        'ExtractSize' => 'Size',
        'ExtractLength' => 'Runtime (minutes)',
        'ExtractType' => 'Video format',
        'ExtractAudioEncoding' => 'Audio format',
        'ExtractImport' => 'Use values',

        'ExportTitle' => 'Export movie list',
        'ExportFilter' => 'Export only displayed movies',
        'ImportListTitle' => 'Import another movies list',
        'ImportExportFile' => 'File',
        'ImportExportSave' => 'Please select file to use',
        'ImportExportFieldsUnused' => 'Unused fields',
        'ImportExportFieldsUsed' => 'Used fields',
        'ImportExportFieldsFill' => 'Add All',
        'ImportExportFieldsClear' => 'Remove All',
        'ImportExportFieldsEmpty' => 'You must choose at least one field',
        'ImportExportFileEmpty' => 'You have to specify a file name',
        'ExportFieldsTitle' => 'Fields to be exported',
        'ExportFieldsTip' => 'Select fields you want to export',
        'ImportFieldsTitle' => 'Fields to be imported',
        'ImportFieldsTip' => 'Select fields you want to import',
        'ImportNewList' => 'Create a new collection',
        'ImportCurrentList' => 'Add to current collection',
        'ImportDropError' => 'There was an error opening at least one file. Previous list will be reloaded.',

        'FileOverwrite' => 'This file already exists. Do you want to overwrite it?',

        'PanelSearchButton' => 'Fetch Information',
        'PanelSearchTip' => 'Search web for information on this title',
        'PanelSeenYes' => 'Viewed',
        'PanelSeenNo' => 'Not viewed',
        'PanelLanguages' => 'Languages',
        'PanelEncoding' => 'Encoding',
        'PanelImageTip' => 'Click on the picture to select different one. Right click for more options.',
        'PanelImageTitle' => 'Select a picture',
        'PanelTrailerTitle' => 'Select a file',
        'PanelInfoFrame' => 'Information',
        'PanelAgeUnknown' => 'Unrated',
        'PanelAgeNone' => 'All Ages',
        'PanelAgeParent' => 'Parental Guidance',
        'PanelNobody' => 'Nobody',
        'PanelUnknown' => 'Unknown',
        'PanelLendedYes' => 'Lended',
        'PanelLendedNo' => 'Available',
        'PanelLendDateSelect' => 'Select a Date',
        'PanelReturned' => 'Movie Returned',
        'PanelRemove' =>'Remove',
        'PanelClear' =>'Clear',
        'PanelReturnDate' => 'Return date',
        'PanelWeb' => 'View Information',
        'PanelWebTip' => 'View information on the web about this movie',
        'PanelRemoveTip' => 'Remove current movie',
        'PanelMovieInfo' => 'General',
        'PanelPrivateInfo' => 'Details',
        'PanelLendInfo' => 'Lending',

        'ToolbarAll' => 'View All',
        'ToolbarAllTooltip' => 'View all movies',
        
        'RatingTitle' => 'Minimum rating',
        'RatingLabel' => 'The following value is the minimum rating a movie should have to be displayed',

        'AgeTitle' => 'Audience age:',
        'AgeLabel' => 'Only movies suitable for people with this age will be shown',

        'StatusMovies' => 'Movies',
        
        'PluginsTitle' => 'Search a movie',
        'PluginsFrame' => 'Search site',
        'PluginsLogo' => 'Logo',
        'PluginsName' => 'Name',
        'PluginsAuthor' => 'Author',
        'PluginsLang' => 'Language',
        'PluginsUseSite' => 'Use selected site for future searches',

        'BorrowersTitle' => 'Borrower Configuration',
        'BorrowersName' => 'Name',
        'BorrowersEmail' => 'E-mail',
        'BorrowersAdd' => 'Add',
        'BorrowersRemove' => 'Remove',
        'BorrowersEdit' => 'Edit',
        'BorrowersTemplate' => 'Mail template',
        'BorrowersSubject' => 'Mail subject',
        'BorrowersNotice1' => '%1 will be replaced with the borrower\'s name',
        'BorrowersNotice2' => '%2 will be replaced with the movie title',
        'BorrowersNotice3' => '%3 will be replaced with the borrow date',

        'BorrowedTitle' => 'Borrowed movies',
        'BorrowedMovie' => 'Movie',
        'BorrowedName' => 'Borrower',
        'BorrowedDate' => 'Since',

        'MailTitle' => 'Send an e-mail',
        'MailFrom' => 'From: ',
        'MailTo' => 'To: ',
        'MailSubject' => 'Subject: ',
        'MailSmtpError' => 'Problem when connecting to SMTP server',
        'MailSendmailError' => 'Problem when launching sendmail',

        'SearchTooltip' => 'Search all movies',
        'SearchTitle' => 'Movie Search',
        'SearchMovieTitle' => 'Title contains:',
        'SearchRating' => 'Rating of at least:',
        'SearchDirector' => 'Director:',
        'SearchActors' => 'Cast (comma separated):',
        'SearchType' => 'Genre:',
        'SearchSeen' => 'Viewed:',
        'SearchUndef' => 'Either',
        'SearchSeenYes' => 'Yes',
        'SearchSeenNo' => 'No',
        'SearchAge' => 'Audience age:',
        'SearchYear' => 'Year betweeen',
        'SearchYearBetween' => 'and',

        'RenameTitle' => 'Edit Genres',
        'RenameOld' => 'Current name',
        'RenameNew' => 'New name',
        
        'ImportWindowTitle' => 'Select Fields to be Imported',
        'ImportViewPicture' => 'View picture',
        'ImportSelectAll' => 'Select all',
        'ImportSelectNone' => 'Select none',

        'ExportTarGzInfo' => 'Archive is in file: ',

        'ExportHTMLWithJS' => 'Use Javascript',
       	'ExportHTMLFileTemplate' => 'Template :',
        'ExportHTMLPreview' => 'Preview',
        'ExportHTMLNoPreview' => 'No preview available',
        'ExportHTMLTitle' => 'Page title',
        'ExportHTMLInfoFile' => 'Movies list is in file: ',
        'ExportHTMLInfoDir' => 'Images are in: ',
        'ExportHTMLHeightimg' => 'Height (in pixels) of the image to be exported: ',
        'ExportHTMLOpenFileInBrowser' => 'Open generated file in web browser',
        'ExportHTMLNote' => 'List generated by <a href="http://home.gna.org/gcfilms/">GCfilms</a>',
        'ExportHTMLInputTitle' => 'Enter search text',
        'ExportHTMLSearchType1' => 'Title only',
        'ExportHTMLSearchType2' => 'Full information',
        'ExportHTMLSearchButton' => 'Search',    
        'ExportHTMLSearchTitle' => 'Display only movies matching previous criteria',
        'ExportHTMLAllButton' => 'All',
        'ExportHTMLAllTitle' => 'Display all movies',
        'ExportHTMLExpand' => 'Expand all',
        'ExportHTMLExpandTitle' => 'Display all movies information',
        'ExportHTMLCollapse' => 'Collapse all',
        'ExportHTMLCollapseTitle' => 'Collapse all movies information',
        'ExportHTMLBorrowed' => 'Borrowed by: ',
        'ExportHTMLNotBorrowed' => 'Available',
        'ExportHTMLTop' => 'Top',
        
        'ExportSQLWithPictures' => 'Copy pictures in a sub-directory',
        'ExportSQLWithDrop' => 'Include DROP instruction',
        'ExportSQLWithCreate' => 'Include CREATE instruction',
        'ExportSQLTableName' => 'Table Name',
        'ExportSQLInfoFile' => 'SQL file: ',
        
        'ExportXMLModelFile' => 'Template file',
        'ExportXMLModelText' => 'Template text',
        'ExportXMLModels' => 'Template to use',
        'ExportXMLUseFile' => 'Use file',
        'ExportXMLUseModel' => 'Use text area',

        'ExportCSVHeader' => 'Include fields names on the top',
        'ExportCSVSeparator' => 'Separator',
        'ExportCSVReplacement' => 'Replace the separator with',

        'ImportCSVHeader' => 'Ignore first line',

        'ImportListName' => 'Titles list',
        'ImportListPlugin' => 'Site to be used',
        'ImportListUseFirst' => 'Select first one if many results',
        'ImportListCommentAuto' => 'Movie automatically imported.',
        'ImportListCommentSite' => 'Website: ',
        'ImportListCommentTitle' => 'Title: ',

        'ImportTellicoNotVideo' => 'File is not a Tellico video collection',

        'MultiSiteTitle' => 'Sites to use for searches',
        'MultiSiteUnused' => 'Unused plugins',
        'MultiSiteUsed' => 'Plugins to be used',
        'MultiSiteLang' => 'Fill list with English plugins',
        'MultiSiteEmptyError' => 'You have an empty site list',
        'MultiSiteClear' => 'Clear list',

        'FieldsList' => {
            id => 'General: Id',
            title => 'General: Title',
            date => 'General: Date',
            time => 'General: Length',
            director => 'General: Director',
            nat => 'General: Country',
            age => 'General: Minimum age',
            type => 'General: Genre',
            image => 'General: Picture',
            orig => 'General: Original title',
            actors => 'General: Cast',
            comment => 'Details: Comments',
            synopsis => 'General: Synopsis',
            seen => 'Details: Viewed',
            number => 'Details: # of Media',
            rating => 'Details: Rating',
            format => 'Details: Media',
            url => 'Details: Web',
            place => 'Details: Location',
            audio => 'Details: Audio',
            video => 'Details: Video format',
            trailer => 'Details : Video file',
            collection => 'Details: Collection',
            rank => 'Details: Rank',
            subt => 'Details: Subtitles',
            borrower => 'Lending: Borrower',
            lendDate => 'Lending: Out Since',
            history => 'Lending: Lending History',
        },
        
        'DisplayOptionsTitle' => 'Items to display',
        'DisplayOptionsAll' => 'Select all',
        'DisplayOptionsMain' => 'Main items',
        'DisplayOptionsActions' => 'Action buttons',
        'DisplayOptionsSearch' => 'Search button',

        'GenresTitle' => 'Genre Conversion',
        'GenresCategoryName' => 'Genre to use',
        'GenresCategoryMembers' => 'Genre to replace',
        'GenresLoad' => 'Load a list',
        'GenresExport' => 'Save list to a file',
        'GenresModify' => 'Edit conversion',
    );
}
1;
