/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: iconcdlg.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 13:39:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _ICCDLG_HXX
#define _ICCDLG_HXX

// auto strip #ifndef _SV_TABPAGE_HXX
// auto strip #include <vcl/tabpage.hxx>
// auto strip #endif

// auto strip #ifndef _SV_MSGBOX_HXX
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SV_DIALOG_HXX
// auto strip #include <vcl/dialog.hxx>
// auto strip #endif
// auto strip #ifndef _SV_BUTTON_HXX
// auto strip #include <vcl/button.hxx>
// auto strip #endif
// auto strip #ifndef _SV_IMAGE_HXX
// auto strip #include <vcl/image.hxx>
// auto strip #endif
// auto strip #ifndef _ICNVW_HXX
// auto strip #include <svtools/ivctrl.hxx>
// auto strip #endif

// auto strip #ifndef _SFXITEMPOOL_HXX
// auto strip #include <svtools/itempool.hxx>
// auto strip #endif
// auto strip #ifndef _SFXITEMSET_HXX
// auto strip #include <svtools/itemset.hxx>
// auto strip #endif

// auto strip #ifndef _LIST_HXX
// auto strip #include <tools/list.hxx>
// auto strip #endif
// auto strip #ifndef _STRING_HXX
// auto strip #include <tools/string.hxx>
// auto strip #endif
namespace binfilter {

//STRIP001 #define CTRLS_OFFSET		3
//STRIP001 #define BUTTON_DISTANCE		8
//STRIP001 #define RET_USER 		100
//STRIP001 #define RET_USER_CANCEL	101

// forward-declarations
//STRIP001 struct IconChoicePageData;
//STRIP001 class IconChoiceDialog;
//STRIP001 class IconChoicePage;

// Create-Function
//STRIP001 typedef IconChoicePage* (*CreatePage)(Window *pParent, const SfxItemSet &rAttrSet);
//STRIP001 typedef USHORT*		    (*GetPageRanges)(); // liefert internationale Which-Wert

// page-list
//STRIP001 DECLARE_LIST( IconChoicePageList, IconChoicePageData * )

// position of iconchoicectrl
//STRIP001 enum EIconChoicePos { PosLeft, PosRight, PosTop, PosBottom };

/**********************************************************************
|
| Data-structure for pages in dialog
|
\**********************************************************************/

//STRIP001 struct IconChoicePageData
//STRIP001 {
//STRIP001 	USHORT nId;					 // Die ID
//STRIP001 	CreatePage fnCreatePage;	 // Pointer auf die Factory
//STRIP001 	GetPageRanges fnGetRanges;// Pointer auf die Ranges-Funktion
//STRIP001 	IconChoicePage* pPage;		 // die TabPage selber
//STRIP001 	BOOL bOnDemand;				 // Flag: ItemSet onDemand
//STRIP001 	BOOL bRefresh; 				 // Flag: Seite mu\s neu initialisiert werden
//STRIP001 
//STRIP001 	// Konstruktor
//STRIP001 	IconChoicePageData( USHORT Id, CreatePage fnPage, GetPageRanges fnRanges, BOOL bDemand )
//STRIP001 		: nId			( Id ),
//STRIP001 		  fnCreatePage	( fnPage ),
//STRIP001 		  fnGetRanges	( fnRanges ),
//STRIP001 		  pPage			( NULL ),
//STRIP001 		  bOnDemand		( bDemand ),
//STRIP001 		  bRefresh		( FALSE )
//STRIP001 	{}
//STRIP001 };

/**********************************************************************
|
| IconChoicePage
|
\**********************************************************************/

//STRIP001 class IconChoicePage : public TabPage
//STRIP001 {
//STRIP001 private :
//STRIP001 	const SfxItemSet*	pSet;
//STRIP001 	String				aUserString;
//STRIP001 	BOOL				bHasExchangeSupport;
//STRIP001 	IconChoiceDialog*	pDialog;
//STRIP001 	BOOL				bStandard;
//STRIP001 
//STRIP001 	void				SetDialog( IconChoiceDialog* pNew ) { pDialog = pNew; }
//STRIP001 	IconChoiceDialog*	GetDialog() const { return pDialog; }
//STRIP001 
//STRIP001 	void				SetInputSet( const SfxItemSet* pNew ) { pSet = pNew; }
//STRIP001 
//STRIP001 	void				ImplInitSettings();
//STRIP001 
//STRIP001 protected :
//STRIP001 	IconChoicePage( Window *pParent, const ResId &, const SfxItemSet &rAttrSet );
//STRIP001 
//STRIP001 	USHORT				GetSlot( USHORT nWhich ) const	{ return pSet->GetPool()->GetSlotId( nWhich ); }
//STRIP001 	USHORT				GetWhich( USHORT nSlot ) const	{ return pSet->GetPool()->GetWhich( nSlot ); }
//STRIP001 	const SfxPoolItem* 	GetOldItem( const SfxItemSet& rSet, USHORT nSlot );
//STRIP001 	const SfxPoolItem* 	GetExchangeItem( const SfxItemSet& rSet, USHORT nSlot );
//STRIP001 
//STRIP001 public :
//STRIP001 	virtual             ~IconChoicePage();
//STRIP001 
//STRIP001 	const SfxItemSet&	GetItemSet() const { return *pSet; }
//STRIP001 
//STRIP001 	virtual BOOL		FillItemSet( SfxItemSet& ) = 0;
//STRIP001 	virtual void		Reset( const SfxItemSet& ) = 0;
//STRIP001 
//STRIP001 	BOOL				HasExchangeSupport() const				{ return bHasExchangeSupport; }
//STRIP001 	void				SetExchangeSupport( BOOL bNew = TRUE )	{ bHasExchangeSupport = bNew; }
//STRIP001 
//STRIP001 	enum {
//STRIP001 		KEEP_PAGE = 0x0000,		// Fehlerbehandlung; Seite nicht wechseln
//STRIP001 			// 2. F"ullen eines ItemSets f"ur die Aktualilsierung
//STRIP001 			// "ubergeordneter Beispiele; dieser Pointer kann immer
//STRIP001 			// NULL sein!!
//STRIP001 		LEAVE_PAGE = 0x0001,
//STRIP001 			// Set aktualisieren und andere Page aktualisieren
//STRIP001 		REFRESH_SET = 0x0002
//STRIP001 	};
//STRIP001 
//STRIP001 	virtual void		ActivatePage( const SfxItemSet& );
//STRIP001 	virtual int			DeactivatePage( SfxItemSet* pSet = 0 );
//STRIP001 	void				SetUserData(const String& rString)	{ aUserString = rString; }
//STRIP001 	String				GetUserData() { return aUserString; }
//STRIP001 	virtual void		FillUserData();
//STRIP001 	virtual BOOL		IsReadOnly() const;
//STRIP001 
//STRIP001 	static const SfxPoolItem* GetItem( const SfxItemSet& rSet, USHORT nSlot );
//STRIP001 
//STRIP001 	void				StateChanged( StateChangedType nType );
//STRIP001 	void				DataChanged( const DataChangedEvent& rDCEvt );
//STRIP001 };

/**********************************************************************
|
| IconChoiceDialog
|
\**********************************************************************/

//STRIP001 class IconChoiceDialog : public ModalDialog
//STRIP001 {
//STRIP001 private :
//STRIP001 	friend class IconChoicePage;
//STRIP001 
//STRIP001 	EIconChoicePos			meChoicePos;    // Position des IconChoiceCtrl's
//STRIP001 	IconChoicePageList		maPageList;		// Liste von PageData-Pointer
//STRIP001 
//STRIP001 	SvtIconChoiceCtrl		maIconCtrl;		// DAS IconChoice-Control
//STRIP001 
//STRIP001 	USHORT					mnCurrentPageId;	// Id der aktuell sichtbaren Page
//STRIP001 
//STRIP001 	// Buttons
//STRIP001 	OKButton				aOKBtn;
//STRIP001 	CancelButton			aCancelBtn;
//STRIP001 	HelpButton				aHelpBtn;
//STRIP001 	PushButton				aResetBtn;
//STRIP001 
//STRIP001 	const SfxItemSet*		pSet;
//STRIP001 	SfxItemSet*				pOutSet;
//STRIP001 	SfxItemSet*				pExampleSet;
//STRIP001 	USHORT*					pRanges;
//STRIP001 
//STRIP001 	USHORT					nResId;
//STRIP001 
//STRIP001 	BOOL					bHideResetBtn;
//STRIP001 	BOOL					bModal;
//STRIP001 	BOOL					bInOK;
//STRIP001 	BOOL					bModified;
//STRIP001 	BOOL					bItemsReset;
//STRIP001 
//STRIP001 	DECL_LINK ( ChosePageHdl_Impl, void * );
//STRIP001 	DECL_LINK ( OkHdl,			   Button * );
//STRIP001 	DECL_LINK ( ResetHdl,          Button * );
//STRIP001 	DECL_LINK ( CancelHdl,		   Button * );
//STRIP001 
//STRIP001 	IconChoicePageData*		GetPageData ( USHORT nId );
//STRIP001 	void					Start_Impl();
//STRIP001 	BOOL					OK_Impl();
//STRIP001 
//STRIP001 	void					SetPosSizeCtrls ( BOOL bInit = FALSE );
//STRIP001 	void					SetPosSizePages ( USHORT nId );
//STRIP001 
//STRIP001 	void					FocusOnIcon ( USHORT nId );
//STRIP001 
//STRIP001 protected :
//STRIP001 	void					ShowPageImpl ( IconChoicePageData* pData );
//STRIP001 	void					HidePageImpl ( IconChoicePageData* pData );
//STRIP001 
//STRIP001 	virtual void			PageCreated( USHORT nId, IconChoicePage &rPage );
//STRIP001 	virtual SfxItemSet*		CreateInputItemSet( USHORT nId );
//STRIP001 	inline SfxItemSet*		GetInputSetImpl() { return (SfxItemSet*)pSet; }
//STRIP001 	inline IconChoicePage*	GetTabPage( USHORT nPageId )
//STRIP001 								{ return ( GetPageData (nPageId)->pPage?GetPageData (nPageId)->pPage:NULL); }
//STRIP001 	const SfxItemSet*		GetRefreshedSet();
//STRIP001 
//STRIP001 	void					ActivatePageImpl ();
//STRIP001 	BOOL					DeActivatePageImpl ();
//STRIP001 	void					ResetPageImpl ();
//STRIP001 
//STRIP001 	short					Ok();
//STRIP001 	BOOL					IsInOK() const;
//STRIP001 
//STRIP001 public :
//STRIP001 
//STRIP001 	// im Ctor knnte auch die Position des IconChoiceCtrl's gesetzt werden.
//STRIP001 
//STRIP001 	IconChoiceDialog ( Window* pParent, const ResId &rResId,
//STRIP001 					   const EIconChoicePos ePos = PosLeft, const SfxItemSet * pItemSet = 0 );
//STRIP001 	~IconChoiceDialog ();
//STRIP001 
//STRIP001 	///////////////////////////////////////////////////////////////////////////////////
//STRIP001 	// virtuelle Methoden
//STRIP001 	//
//STRIP001 	virtual void		Paint( const Rectangle& rRect );
//STRIP001 	virtual void		Resize();
//STRIP001 
//STRIP001 	///////////////////////////////////////////////////////////////////////////////////
//STRIP001 	// Schnittstelle
//STRIP001 	//
//STRIP001 
//STRIP001 	SvxIconChoiceCtrlEntry*	AddTabPage(
//STRIP001 		USHORT nId, const String& rIconText, const Image& rChoiceIcon,
//STRIP001 		CreatePage pCreateFunc /* != NULL */, GetPageRanges pRangesFunc = NULL /* NULL allowed*/,
//STRIP001 		BOOL bItemsOnDemand = FALSE, ULONG nPos = LIST_APPEND );
//STRIP001 
//STRIP001 	SvxIconChoiceCtrlEntry*	AddTabPage(
//STRIP001 		USHORT nId, const String& rIconText, const Image& rChoiceIcon, const Image& rChoiceIconHC,
//STRIP001 		CreatePage pCreateFunc /* != NULL */, GetPageRanges pRangesFunc = NULL /* NULL allowed*/,
//STRIP001 		BOOL bItemsOnDemand = FALSE, ULONG nPos = LIST_APPEND );
//STRIP001 
//STRIP001 	void				RemoveTabPage( USHORT nId );
//STRIP001 
//STRIP001 	void				SetCurPageId( USHORT nId ) { mnCurrentPageId = nId; FocusOnIcon( nId ); }
//STRIP001 	USHORT				GetCurPageId() const       { return mnCurrentPageId; }
//STRIP001 	void				ShowPage( USHORT nId );
//STRIP001 
//STRIP001 						// liefert ggf. per Map konvertierte lokale Slots
//STRIP001 	const USHORT*		GetInputRanges( const SfxItemPool& );
//STRIP001 	void				SetInputSet( const SfxItemSet* pInSet );
//STRIP001 	const SfxItemSet*	GetOutputItemSet() const { return pOutSet; }
//STRIP001 	const SfxItemSet*	GetOutputItemSet( USHORT nId );
//STRIP001 	int					FillOutputItemSet();
//STRIP001 
//STRIP001 	const OKButton& 	GetOKButton() const { return aOKBtn; }
//STRIP001 	OKButton&			GetOKButton() { return aOKBtn; }
//STRIP001 	const CancelButton& GetCancelButton() const { return aCancelBtn; }
//STRIP001 	CancelButton&		GetCancelButton() { return aCancelBtn; }
//STRIP001 	const HelpButton&	GetHelpButton() const { return aHelpBtn; }
//STRIP001 	HelpButton&			GetHelpButton() { return aHelpBtn; }
//STRIP001 
//STRIP001 	void				RemoveResetButton();
//STRIP001 
//STRIP001 	short				Execute();
//STRIP001 	void				Start( BOOL bShow = TRUE );
//STRIP001 
//STRIP001 	const SfxItemSet*	GetExampleSet() const { return pExampleSet; }
//STRIP001 
//STRIP001 	void				SetCtrlColor ( const Color& rColor );
//STRIP001 	EIconChoicePos		SetCtrlPos   ( const EIconChoicePos& rPos );
//STRIP001 
//STRIP001 	void				CreateIconTextAutoMnemonics( void );
//STRIP001 };

}//end of namespace binfilter
#endif //_ICCDLG_HXX

